/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import io.flutter.embedding.android.FlutterFragment;
import io.flutter.embedding.android.FlutterView;
import io.flutter.embedding.engine.FlutterEngine;
import io.flutter.embedding.engine.FlutterShellArgs;
import io.flutter.embedding.engine.renderer.OnFirstFrameRenderedListener;
import io.flutter.view.FlutterMain;

public class FlutterActivity
extends FragmentActivity
implements OnFirstFrameRenderedListener {
    private static final String TAG = "FlutterActivity";
    protected static final String DART_ENTRYPOINT_META_DATA_KEY = "io.flutter.Entrypoint";
    protected static final String INITIAL_ROUTE_META_DATA_KEY = "io.flutter.InitialRoute";
    protected static final String EXTRA_DART_ENTRYPOINT = "dart_entrypoint";
    protected static final String EXTRA_INITIAL_ROUTE = "initial_route";
    protected static final String DEFAULT_DART_ENTRYPOINT = "main";
    protected static final String DEFAULT_INITIAL_ROUTE = "/";
    private static final String TAG_FLUTTER_FRAGMENT = "flutter_fragment";
    private static final int FRAGMENT_CONTAINER_ID = 609893468;
    private FlutterFragment flutterFragment;
    private View coverView;

    public static Intent createDefaultIntent(@NonNull Context launchContext) {
        return FlutterActivity.createBuilder().build(launchContext);
    }

    public static IntentBuilder createBuilder() {
        return new IntentBuilder(FlutterActivity.class);
    }

    public void onCreate(Bundle savedInstanceState) {
        Log.d((String)TAG, (String)"onCreate()");
        super.onCreate(savedInstanceState);
        this.setContentView(this.createFragmentContainer());
        this.showCoverView();
        this.configureStatusBarForFullscreenFlutterExperience();
        this.ensureFlutterFragmentCreated();
    }

    private void showCoverView() {
        Drawable background;
        if (this.coverView == null) {
            this.coverView = new View((Context)this);
            this.addContentView(this.coverView, new ViewGroup.LayoutParams(-1, -1));
        }
        if ((background = this.createCoverViewBackground()) != null) {
            this.coverView.setBackground(background);
        }
    }

    @Nullable
    private Drawable createCoverViewBackground() {
        TypedValue typedValue = new TypedValue();
        boolean hasBackgroundColor = this.getTheme().resolveAttribute(16842836, typedValue, true);
        if (hasBackgroundColor && typedValue.resourceId != 0) {
            return this.getResources().getDrawable(typedValue.resourceId, this.getTheme());
        }
        return null;
    }

    private void hideCoverView() {
        this.coverView.setVisibility(8);
    }

    private void configureStatusBarForFullscreenFlutterExperience() {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = this.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(0x40000000);
            window.getDecorView().setSystemUiVisibility(1280);
        }
    }

    @NonNull
    private View createFragmentContainer() {
        FrameLayout container = new FrameLayout((Context)this);
        container.setId(609893468);
        container.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        return container;
    }

    private void ensureFlutterFragmentCreated() {
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        this.flutterFragment = (FlutterFragment)fragmentManager.findFragmentByTag(TAG_FLUTTER_FRAGMENT);
        if (this.flutterFragment == null) {
            this.flutterFragment = this.createFlutterFragment();
            fragmentManager.beginTransaction().add(609893468, (Fragment)this.flutterFragment, TAG_FLUTTER_FRAGMENT).commit();
        }
    }

    @NonNull
    protected FlutterFragment createFlutterFragment() {
        return new FlutterFragment.Builder().dartEntrypoint(this.getDartEntrypoint()).initialRoute(this.getInitialRoute()).appBundlePath(this.getAppBundlePath()).flutterShellArgs(FlutterShellArgs.fromIntent(this.getIntent())).renderMode(FlutterView.RenderMode.surface).transparencyMode(FlutterView.TransparencyMode.opaque).build();
    }

    public void onPostResume() {
        super.onPostResume();
        this.flutterFragment.onPostResume();
    }

    protected void onNewIntent(Intent intent) {
        this.flutterFragment.onNewIntent(intent);
    }

    public void onBackPressed() {
        this.flutterFragment.onBackPressed();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        this.flutterFragment.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    public void onUserLeaveHint() {
        this.flutterFragment.onUserLeaveHint();
    }

    public void onTrimMemory(int level) {
        super.onTrimMemory(level);
        this.flutterFragment.onTrimMemory(level);
    }

    @Nullable
    protected FlutterEngine getFlutterEngine() {
        return this.flutterFragment.getFlutterEngine();
    }

    @NonNull
    protected String getAppBundlePath() {
        String appBundlePath;
        if (this.isDebuggable() && "android.intent.action.RUN".equals(this.getIntent().getAction()) && (appBundlePath = this.getIntent().getDataString()) != null) {
            return appBundlePath;
        }
        return FlutterMain.findAppBundlePath(this.getApplicationContext());
    }

    @NonNull
    protected String getDartEntrypoint() {
        if (this.getIntent().hasExtra(EXTRA_DART_ENTRYPOINT)) {
            return this.getIntent().getStringExtra(EXTRA_DART_ENTRYPOINT);
        }
        try {
            ActivityInfo activityInfo = this.getPackageManager().getActivityInfo(this.getComponentName(), 129);
            Bundle metadata = activityInfo.metaData;
            String desiredDartEntrypoint = metadata != null ? metadata.getString(DART_ENTRYPOINT_META_DATA_KEY) : null;
            return desiredDartEntrypoint != null ? desiredDartEntrypoint : DEFAULT_DART_ENTRYPOINT;
        }
        catch (PackageManager.NameNotFoundException e) {
            return DEFAULT_DART_ENTRYPOINT;
        }
    }

    @NonNull
    protected String getInitialRoute() {
        if (this.getIntent().hasExtra(EXTRA_INITIAL_ROUTE)) {
            return this.getIntent().getStringExtra(EXTRA_INITIAL_ROUTE);
        }
        try {
            ActivityInfo activityInfo = this.getPackageManager().getActivityInfo(this.getComponentName(), 129);
            Bundle metadata = activityInfo.metaData;
            String desiredInitialRoute = metadata != null ? metadata.getString(INITIAL_ROUTE_META_DATA_KEY) : null;
            return desiredInitialRoute != null ? desiredInitialRoute : DEFAULT_INITIAL_ROUTE;
        }
        catch (PackageManager.NameNotFoundException e) {
            return DEFAULT_INITIAL_ROUTE;
        }
    }

    private boolean isDebuggable() {
        return (this.getApplicationInfo().flags & 2) != 0;
    }

    @Override
    public void onFirstFrameRendered() {
        this.hideCoverView();
    }

    public static class IntentBuilder {
        private final Class<? extends FlutterActivity> activityClass;
        private String dartEntrypoint = "main";
        private String initialRoute = "/";

        protected IntentBuilder(@NonNull Class<? extends FlutterActivity> activityClass) {
            this.activityClass = activityClass;
        }

        @NonNull
        public IntentBuilder dartEntrypoint(@NonNull String dartEntrypoint) {
            this.dartEntrypoint = dartEntrypoint;
            return this;
        }

        @NonNull
        public IntentBuilder initialRoute(@NonNull String initialRoute) {
            this.initialRoute = initialRoute;
            return this;
        }

        @NonNull
        public Intent build(@NonNull Context context) {
            return new Intent(context, this.activityClass).putExtra(FlutterActivity.EXTRA_DART_ENTRYPOINT, this.dartEntrypoint).putExtra(FlutterActivity.EXTRA_INITIAL_ROUTE, this.initialRoute);
        }
    }
}

