/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.Build;
import android.os.LocaleList;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowInsets;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeProvider;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.widget.FrameLayout;
import io.flutter.embedding.android.AndroidKeyProcessor;
import io.flutter.embedding.android.AndroidTouchProcessor;
import io.flutter.embedding.android.FlutterSurfaceView;
import io.flutter.embedding.android.FlutterTextureView;
import io.flutter.embedding.engine.FlutterEngine;
import io.flutter.embedding.engine.renderer.FlutterRenderer;
import io.flutter.embedding.engine.renderer.OnFirstFrameRenderedListener;
import io.flutter.plugin.editing.TextInputPlugin;
import io.flutter.view.AccessibilityBridge;
import java.util.ArrayList;
import java.util.Locale;

public class FlutterView
extends FrameLayout {
    private static final String TAG = "FlutterView";
    @NonNull
    private RenderMode renderMode;
    @Nullable
    private TransparencyMode transparencyMode;
    @Nullable
    private FlutterRenderer.RenderSurface renderSurface;
    @Nullable
    private FlutterEngine flutterEngine;
    @Nullable
    private TextInputPlugin textInputPlugin;
    @Nullable
    private AndroidKeyProcessor androidKeyProcessor;
    @Nullable
    private AndroidTouchProcessor androidTouchProcessor;
    @Nullable
    private AccessibilityBridge accessibilityBridge;
    private final FlutterRenderer.ViewportMetrics viewportMetrics = new FlutterRenderer.ViewportMetrics();
    private final AccessibilityBridge.OnAccessibilityChangeListener onAccessibilityChangeListener = new AccessibilityBridge.OnAccessibilityChangeListener(){

        @Override
        public void onAccessibilityChanged(boolean isAccessibilityEnabled, boolean isTouchExplorationEnabled) {
            FlutterView.this.resetWillNotDraw(isAccessibilityEnabled, isTouchExplorationEnabled);
        }
    };

    public FlutterView(@NonNull Context context) {
        this(context, null, null, null);
    }

    public FlutterView(@NonNull Context context, @NonNull RenderMode renderMode) {
        this(context, null, renderMode, null);
    }

    public FlutterView(@NonNull Context context, @NonNull TransparencyMode transparencyMode) {
        this(context, null, RenderMode.surface, transparencyMode);
    }

    public FlutterView(@NonNull Context context, @NonNull RenderMode renderMode, @NonNull TransparencyMode transparencyMode) {
        this(context, null, renderMode, transparencyMode);
    }

    public FlutterView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, null, null);
    }

    private FlutterView(@NonNull Context context, @Nullable AttributeSet attrs, @Nullable RenderMode renderMode, @Nullable TransparencyMode transparencyMode) {
        super(context, attrs);
        this.renderMode = renderMode == null ? RenderMode.surface : renderMode;
        this.transparencyMode = transparencyMode != null ? transparencyMode : TransparencyMode.opaque;
        this.init();
    }

    private void init() {
        Log.d((String)TAG, (String)"Initializing FlutterView");
        switch (this.renderMode) {
            case surface: {
                Log.d((String)TAG, (String)"Internally creating a FlutterSurfaceView.");
                FlutterSurfaceView flutterSurfaceView = new FlutterSurfaceView(this.getContext(), this.transparencyMode == TransparencyMode.transparent);
                this.renderSurface = flutterSurfaceView;
                this.addView((View)flutterSurfaceView);
                break;
            }
            case texture: {
                Log.d((String)TAG, (String)"Internally creating a FlutterTextureView.");
                FlutterTextureView flutterTextureView = new FlutterTextureView(this.getContext());
                this.renderSurface = flutterTextureView;
                this.addView((View)flutterTextureView);
            }
        }
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
    }

    public void addOnFirstFrameRenderedListener(@NonNull OnFirstFrameRenderedListener listener) {
        this.renderSurface.addOnFirstFrameRenderedListener(listener);
    }

    public void removeOnFirstFrameRenderedListener(@NonNull OnFirstFrameRenderedListener listener) {
        this.renderSurface.removeOnFirstFrameRenderedListener(listener);
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.sendLocalesToFlutter(newConfig);
        this.sendUserSettingsToFlutter();
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        super.onSizeChanged(width, height, oldWidth, oldHeight);
        this.viewportMetrics.width = width;
        this.viewportMetrics.height = height;
        this.sendViewportMetricsToFlutter();
    }

    @TargetApi(value=20)
    @RequiresApi(value=20)
    public final WindowInsets onApplyWindowInsets(WindowInsets insets) {
        WindowInsets newInsets = super.onApplyWindowInsets(insets);
        this.viewportMetrics.paddingTop = insets.getSystemWindowInsetTop();
        this.viewportMetrics.paddingRight = insets.getSystemWindowInsetRight();
        this.viewportMetrics.paddingBottom = 0;
        this.viewportMetrics.paddingLeft = insets.getSystemWindowInsetLeft();
        this.viewportMetrics.viewInsetTop = 0;
        this.viewportMetrics.viewInsetRight = 0;
        this.viewportMetrics.viewInsetBottom = insets.getSystemWindowInsetBottom();
        this.viewportMetrics.viewInsetLeft = 0;
        this.sendViewportMetricsToFlutter();
        return newInsets;
    }

    protected boolean fitSystemWindows(Rect insets) {
        if (Build.VERSION.SDK_INT <= 19) {
            this.viewportMetrics.paddingTop = insets.top;
            this.viewportMetrics.paddingRight = insets.right;
            this.viewportMetrics.paddingBottom = 0;
            this.viewportMetrics.paddingLeft = insets.left;
            this.viewportMetrics.viewInsetTop = 0;
            this.viewportMetrics.viewInsetRight = 0;
            this.viewportMetrics.viewInsetBottom = insets.bottom;
            this.viewportMetrics.viewInsetLeft = 0;
            this.sendViewportMetricsToFlutter();
            return true;
        }
        return super.fitSystemWindows(insets);
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        if (!this.isAttachedToFlutterEngine()) {
            return super.onCreateInputConnection(outAttrs);
        }
        return this.textInputPlugin.createInputConnection((View)this, outAttrs);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (!this.isAttachedToFlutterEngine()) {
            return super.onKeyUp(keyCode, event);
        }
        this.androidKeyProcessor.onKeyUp(event);
        return super.onKeyUp(keyCode, event);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (!this.isAttachedToFlutterEngine()) {
            return super.onKeyDown(keyCode, event);
        }
        this.androidKeyProcessor.onKeyDown(event);
        return super.onKeyDown(keyCode, event);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isAttachedToFlutterEngine()) {
            return super.onTouchEvent(event);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.requestUnbufferedDispatch(event);
        }
        return this.androidTouchProcessor.onTouchEvent(event);
    }

    public boolean onGenericMotionEvent(MotionEvent event) {
        boolean handled = this.isAttachedToFlutterEngine() && this.androidTouchProcessor.onGenericMotionEvent(event);
        return handled ? true : super.onGenericMotionEvent(event);
    }

    public boolean onHoverEvent(MotionEvent event) {
        if (!this.isAttachedToFlutterEngine()) {
            return super.onHoverEvent(event);
        }
        boolean handled = this.accessibilityBridge.onAccessibilityHoverEvent(event);
        if (!handled) {
            // empty if block
        }
        return handled;
    }

    public AccessibilityNodeProvider getAccessibilityNodeProvider() {
        if (this.accessibilityBridge != null && this.accessibilityBridge.isAccessibilityEnabled()) {
            return this.accessibilityBridge;
        }
        return null;
    }

    private void resetWillNotDraw(boolean isAccessibilityEnabled, boolean isTouchExplorationEnabled) {
        if (!this.flutterEngine.getRenderer().isSoftwareRenderingEnabled()) {
            this.setWillNotDraw(!isAccessibilityEnabled && !isTouchExplorationEnabled);
        } else {
            this.setWillNotDraw(false);
        }
    }

    public void attachToFlutterEngine(@NonNull FlutterEngine flutterEngine) {
        Log.d((String)TAG, (String)"attachToFlutterEngine()");
        if (this.isAttachedToFlutterEngine()) {
            if (flutterEngine == this.flutterEngine) {
                Log.d((String)TAG, (String)"Already attached to this engine. Doing nothing.");
                return;
            }
            Log.d((String)TAG, (String)"Currently attached to a different engine. Detaching.");
            this.detachFromFlutterEngine();
        }
        this.flutterEngine = flutterEngine;
        this.flutterEngine.getRenderer().attachToRenderSurface(this.renderSurface);
        this.textInputPlugin = new TextInputPlugin((View)this, this.flutterEngine.getDartExecutor());
        this.androidKeyProcessor = new AndroidKeyProcessor(this.flutterEngine.getKeyEventChannel(), this.textInputPlugin);
        this.androidTouchProcessor = new AndroidTouchProcessor(this.flutterEngine.getRenderer());
        this.accessibilityBridge = new AccessibilityBridge((View)this, flutterEngine.getAccessibilityChannel(), (AccessibilityManager)this.getContext().getSystemService("accessibility"), this.getContext().getContentResolver(), null);
        this.accessibilityBridge.setOnAccessibilityChangeListener(this.onAccessibilityChangeListener);
        this.resetWillNotDraw(this.accessibilityBridge.isAccessibilityEnabled(), this.accessibilityBridge.isTouchExplorationEnabled());
        this.textInputPlugin.getInputMethodManager().restartInput((View)this);
        this.sendUserSettingsToFlutter();
        this.sendLocalesToFlutter(this.getResources().getConfiguration());
        this.sendViewportMetricsToFlutter();
    }

    public void detachFromFlutterEngine() {
        Log.d((String)TAG, (String)"detachFromFlutterEngine()");
        if (!this.isAttachedToFlutterEngine()) {
            Log.d((String)TAG, (String)"Not attached to an engine. Doing nothing.");
            return;
        }
        Log.d((String)TAG, (String)"Detaching from Flutter Engine");
        this.textInputPlugin.getInputMethodManager().restartInput((View)this);
        this.flutterEngine.getRenderer().detachFromRenderSurface();
        this.flutterEngine = null;
    }

    private boolean isAttachedToFlutterEngine() {
        return this.flutterEngine != null;
    }

    private void sendLocalesToFlutter(Configuration config) {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        if (Build.VERSION.SDK_INT >= 24) {
            LocaleList localeList = config.getLocales();
            int localeCount = localeList.size();
            for (int index = 0; index < localeCount; ++index) {
                Locale locale = localeList.get(index);
                locales.add(locale);
            }
        } else {
            locales.add(config.locale);
        }
        this.flutterEngine.getLocalizationChannel().sendLocales(locales);
    }

    private void sendUserSettingsToFlutter() {
        this.flutterEngine.getSettingsChannel().startMessage().setTextScaleFactor(this.getResources().getConfiguration().fontScale).setUse24HourFormat(DateFormat.is24HourFormat((Context)this.getContext())).send();
    }

    private void sendViewportMetricsToFlutter() {
        Log.d((String)TAG, (String)"sendViewportMetricsToFlutter()");
        if (!this.isAttachedToFlutterEngine()) {
            Log.w((String)TAG, (String)"Tried to send viewport metrics from Android to Flutter but this FlutterView was not attached to a FlutterEngine.");
            return;
        }
        this.viewportMetrics.devicePixelRatio = this.getResources().getDisplayMetrics().density;
        this.flutterEngine.getRenderer().setViewportMetrics(this.viewportMetrics);
    }

    public static enum TransparencyMode {
        opaque,
        transparent;

    }

    public static enum RenderMode {
        surface,
        texture;

    }
}

