/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.platform;

import android.annotation.TargetApi;
import android.app.Presentation;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Rect;
import android.os.Bundle;
import android.util.Log;
import android.view.Display;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import android.widget.FrameLayout;
import io.flutter.plugin.platform.AccessibilityEventsDelegate;
import io.flutter.plugin.platform.PlatformView;
import io.flutter.plugin.platform.PlatformViewFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

@TargetApi(value=17)
class SingleViewPresentation
extends Presentation {
    private final PlatformViewFactory mViewFactory;
    private final AccessibilityEventsDelegate mAccessibilityEventsDelegate;
    private int mViewId;
    private Object mCreateParams;
    private AccessibilityDelegatingFrameLayout mRootView;
    private FrameLayout mContainer;
    private PresentationState mState;

    public SingleViewPresentation(Context outerContext, Display display, PlatformViewFactory viewFactory, AccessibilityEventsDelegate accessibilityEventsDelegate, int viewId, Object createParams) {
        super(outerContext, display);
        this.mViewFactory = viewFactory;
        this.mAccessibilityEventsDelegate = accessibilityEventsDelegate;
        this.mViewId = viewId;
        this.mCreateParams = createParams;
        this.mState = new PresentationState();
        this.getWindow().setFlags(8, 8);
    }

    public SingleViewPresentation(Context outerContext, Display display, AccessibilityEventsDelegate accessibilityEventsDelegate, PresentationState state) {
        super(outerContext, display);
        this.mAccessibilityEventsDelegate = accessibilityEventsDelegate;
        this.mViewFactory = null;
        this.mState = state;
        this.getWindow().setFlags(8, 8);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.mState.mFakeWindowRootView == null) {
            this.mState.mFakeWindowRootView = new FakeWindowViewGroup(this.getContext());
        }
        if (this.mState.mWindowManagerHandler == null) {
            WindowManager windowManagerDelegate = (WindowManager)this.getContext().getSystemService("window");
            this.mState.mWindowManagerHandler = new WindowManagerHandler(windowManagerDelegate, this.mState.mFakeWindowRootView);
        }
        this.mContainer = new FrameLayout(this.getContext());
        PresentationContext context = new PresentationContext(this.getContext(), this.mState.mWindowManagerHandler);
        if (this.mState.mView == null) {
            this.mState.mView = this.mViewFactory.create((Context)context, this.mViewId, this.mCreateParams);
        }
        View embeddedView = this.mState.mView.getView();
        this.mContainer.addView(embeddedView);
        this.mRootView = new AccessibilityDelegatingFrameLayout(this.getContext(), this.mAccessibilityEventsDelegate, embeddedView);
        this.mRootView.addView((View)this.mContainer);
        this.mRootView.addView((View)this.mState.mFakeWindowRootView);
        this.setContentView((View)this.mRootView);
    }

    public PresentationState detachState() {
        this.mContainer.removeAllViews();
        this.mRootView.removeAllViews();
        return this.mState;
    }

    public PlatformView getView() {
        if (this.mState.mView == null) {
            return null;
        }
        return this.mState.mView;
    }

    private static class AccessibilityDelegatingFrameLayout
    extends FrameLayout {
        private final AccessibilityEventsDelegate mAccessibilityEventsDelegate;
        private final View mEmbeddedView;

        public AccessibilityDelegatingFrameLayout(Context context, AccessibilityEventsDelegate accessibilityEventsDelegate, View ebeddedView) {
            super(context);
            this.mAccessibilityEventsDelegate = accessibilityEventsDelegate;
            this.mEmbeddedView = ebeddedView;
        }

        public boolean requestSendAccessibilityEvent(View child, AccessibilityEvent event) {
            return this.mAccessibilityEventsDelegate.requestSendAccessibilityEvent(this.mEmbeddedView, child, event);
        }
    }

    static class WindowManagerHandler
    implements InvocationHandler {
        private static final String TAG = "PlatformViewsController";
        private final WindowManager mDelegate;
        FakeWindowViewGroup mFakeWindowRootView;

        WindowManagerHandler(WindowManager delegate, FakeWindowViewGroup fakeWindowViewGroup) {
            this.mDelegate = delegate;
            this.mFakeWindowRootView = fakeWindowViewGroup;
        }

        public WindowManager getWindowManager() {
            return (WindowManager)Proxy.newProxyInstance(WindowManager.class.getClassLoader(), new Class[]{WindowManager.class}, (InvocationHandler)this);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "addView": {
                    this.addView(args);
                    return null;
                }
                case "removeView": {
                    this.removeView(args);
                    return null;
                }
                case "removeViewImmediate": {
                    this.removeViewImmediate(args);
                    return null;
                }
                case "updateViewLayout": {
                    this.updateViewLayout(args);
                    return null;
                }
            }
            try {
                return method.invoke((Object)this.mDelegate, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        private void addView(Object[] args) {
            if (this.mFakeWindowRootView == null) {
                Log.w((String)TAG, (String)"Embedded view called addView while detached from presentation");
                return;
            }
            View view = (View)args[0];
            WindowManager.LayoutParams layoutParams = (WindowManager.LayoutParams)args[1];
            this.mFakeWindowRootView.addView(view, (ViewGroup.LayoutParams)layoutParams);
        }

        private void removeView(Object[] args) {
            if (this.mFakeWindowRootView == null) {
                Log.w((String)TAG, (String)"Embedded view called removeView while detached from presentation");
                return;
            }
            View view = (View)args[0];
            this.mFakeWindowRootView.removeView(view);
        }

        private void removeViewImmediate(Object[] args) {
            if (this.mFakeWindowRootView == null) {
                Log.w((String)TAG, (String)"Embedded view called removeViewImmediate while detached from presentation");
                return;
            }
            View view = (View)args[0];
            view.clearAnimation();
            this.mFakeWindowRootView.removeView(view);
        }

        private void updateViewLayout(Object[] args) {
            if (this.mFakeWindowRootView == null) {
                Log.w((String)TAG, (String)"Embedded view called updateViewLayout while detached from presentation");
                return;
            }
            View view = (View)args[0];
            WindowManager.LayoutParams layoutParams = (WindowManager.LayoutParams)args[1];
            this.mFakeWindowRootView.updateViewLayout(view, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    static class PresentationContext
    extends ContextWrapper {
        private WindowManager mWindowManager;
        private final WindowManagerHandler mWindowManagerHandler;

        PresentationContext(Context base, WindowManagerHandler windowManagerHandler) {
            super(base);
            this.mWindowManagerHandler = windowManagerHandler;
        }

        public Object getSystemService(String name) {
            if ("window".equals(name)) {
                return this.getWindowManager();
            }
            return super.getSystemService(name);
        }

        private WindowManager getWindowManager() {
            if (this.mWindowManager == null) {
                this.mWindowManager = this.mWindowManagerHandler.getWindowManager();
            }
            return this.mWindowManager;
        }
    }

    static class FakeWindowViewGroup
    extends ViewGroup {
        private final Rect mViewBounds = new Rect();
        private final Rect mChildRect = new Rect();

        public FakeWindowViewGroup(Context context) {
            super(context);
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                WindowManager.LayoutParams params = (WindowManager.LayoutParams)child.getLayoutParams();
                this.mViewBounds.set(l, t, r, b);
                Gravity.apply((int)params.gravity, (int)child.getMeasuredWidth(), (int)child.getMeasuredHeight(), (Rect)this.mViewBounds, (int)params.x, (int)params.y, (Rect)this.mChildRect);
                child.layout(this.mChildRect.left, this.mChildRect.top, this.mChildRect.right, this.mChildRect.bottom);
            }
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                child.measure(FakeWindowViewGroup.atMost(widthMeasureSpec), FakeWindowViewGroup.atMost(heightMeasureSpec));
            }
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }

        private static int atMost(int measureSpec) {
            return View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)measureSpec), (int)Integer.MIN_VALUE);
        }
    }

    static class PresentationState {
        private PlatformView mView;
        private WindowManagerHandler mWindowManagerHandler;
        private FakeWindowViewGroup mFakeWindowRootView;

        PresentationState() {
        }
    }
}

