// Copyright 2013 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

library quiver.collection.collection_test;

import 'package:quiver/collection.dart';
import 'package:test/test.dart';

main() {
  group('listsEqual', () {
    test('return true for equal lists', () {
      expect(listsEqual(null, null), isTrue);
      expect(listsEqual([], []), isTrue);
      expect(listsEqual([1], [1]), isTrue);
      expect(listsEqual(['a', 'b'], ['a', 'b']), isTrue);
    });

    test('return false for non-equal lists', () {
      expect(listsEqual(null, []), isFalse);
      expect(listsEqual([], null), isFalse);
      expect(listsEqual([1], [2]), isFalse);
      expect(listsEqual([1], []), isFalse);
      expect(listsEqual([], [1]), isFalse);
    });
  });

  group('listMap', () {
    test('return true for equal maps', () {
      expect(mapsEqual(null, null), isTrue);
      expect(mapsEqual({}, {}), isTrue);
      expect(mapsEqual({'a': 1}, {'a': 1}), isTrue);
    });

    test('return false for non-equal maps', () {
      expect(mapsEqual(null, {}), isFalse);
      expect(mapsEqual({}, null), isFalse);
      expect(mapsEqual({'a': 1}, {'a': 2}), isFalse);
      expect(mapsEqual({'a': 1}, {'b': 1}), isFalse);
      expect(mapsEqual({'a': 1}, {'a': 1, 'b': 2}), isFalse);
      expect(mapsEqual({'a': 1, 'b': 2}, {'a': 1}), isFalse);
    });
  });

  group('setsEqual', () {
    test('return true for equal sets', () {
      expect(setsEqual(null, null), isTrue);
      expect(setsEqual(new Set(), new Set()), isTrue);
      expect(setsEqual(new Set.from([1]), new Set.from([1])), isTrue);
      expect(setsEqual(new Set.from(['a', 'b']), new Set.from(['a', 'b'])),
          isTrue);
    });

    test('return false for non-equal sets', () {
      expect(setsEqual(null, new Set()), isFalse);
      expect(setsEqual(new Set(), null), isFalse);
      expect(setsEqual(new Set.from([1]), new Set.from([2])), isFalse);
      expect(setsEqual(new Set.from([1]), new Set()), isFalse);
      expect(setsEqual(new Set(), new Set.from([1])), isFalse);
    });
  });

  group('indexOf', () {
    test('returns the first matching index', () {
      expect(indexOf<int>([1, 12, 19, 20, 24], (n) => n % 2 == 0), 1);
      expect(indexOf<String>(['a', 'b', 'a'], (s) => s == 'a'), 0);
    });

    test('returns -1 when there is no match', () {
      expect(indexOf<int>([1, 3, 7], (n) => n % 2 == 0), -1);
      expect(indexOf<String>(['a', 'b'], (s) => s == 'e'), -1);
      expect(indexOf<bool>([], (_) => true), -1);
    });
  });
}
