/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.WindowManager;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.util.PathUtils;
import io.flutter.view.ResourceCleaner;
import io.flutter.view.ResourceExtractor;
import io.flutter.view.VsyncWaiter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;

public class FlutterMain {
    private static final String TAG = "FlutterMain";
    private static final String AOT_SHARED_LIBRARY_NAME = "aot-shared-library-name";
    private static final String SNAPSHOT_ASSET_PATH_KEY = "snapshot-asset-path";
    private static final String VM_SNAPSHOT_DATA_KEY = "vm-snapshot-data";
    private static final String ISOLATE_SNAPSHOT_DATA_KEY = "isolate-snapshot-data";
    private static final String FLUTTER_ASSETS_DIR_KEY = "flutter-assets-dir";
    public static final String PUBLIC_AOT_SHARED_LIBRARY_NAME = FlutterMain.class.getName() + '.' + "aot-shared-library-name";
    public static final String PUBLIC_VM_SNAPSHOT_DATA_KEY = FlutterMain.class.getName() + '.' + "vm-snapshot-data";
    public static final String PUBLIC_ISOLATE_SNAPSHOT_DATA_KEY = FlutterMain.class.getName() + '.' + "isolate-snapshot-data";
    public static final String PUBLIC_FLUTTER_ASSETS_DIR_KEY = FlutterMain.class.getName() + '.' + "flutter-assets-dir";
    private static final String DEFAULT_AOT_SHARED_LIBRARY_NAME = "libapp.so";
    private static final String DEFAULT_VM_SNAPSHOT_DATA = "vm_snapshot_data";
    private static final String DEFAULT_ISOLATE_SNAPSHOT_DATA = "isolate_snapshot_data";
    private static final String DEFAULT_LIBRARY = "libflutter.so";
    private static final String DEFAULT_KERNEL_BLOB = "kernel_blob.bin";
    private static final String DEFAULT_FLUTTER_ASSETS_DIR = "flutter_assets";
    private static String sAotSharedLibraryName = "libapp.so";
    private static String sVmSnapshotData = "vm_snapshot_data";
    private static String sIsolateSnapshotData = "isolate_snapshot_data";
    private static String sFlutterAssetsDir = "flutter_assets";
    private static boolean sInitialized = false;
    @Nullable
    private static ResourceExtractor sResourceExtractor;
    @Nullable
    private static Settings sSettings;

    @NonNull
    private static String fromFlutterAssets(@NonNull String filePath) {
        return sFlutterAssetsDir + File.separator + filePath;
    }

    public static void startInitialization(@NonNull Context applicationContext) {
        FlutterMain.startInitialization(applicationContext, new Settings());
    }

    public static void startInitialization(@NonNull Context applicationContext, @NonNull Settings settings) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("startInitialization must be called on the main thread");
        }
        if (sSettings != null) {
            return;
        }
        sSettings = settings;
        long initStartTimestampMillis = SystemClock.uptimeMillis();
        FlutterMain.initConfig(applicationContext);
        FlutterMain.initResources(applicationContext);
        System.loadLibrary("flutter");
        VsyncWaiter.getInstance((WindowManager)applicationContext.getSystemService("window")).init();
        long initTimeMillis = SystemClock.uptimeMillis() - initStartTimestampMillis;
        FlutterJNI.nativeRecordStartTimestamp(initTimeMillis);
    }

    public static void ensureInitializationComplete(@NonNull Context applicationContext, @Nullable String[] args) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("ensureInitializationComplete must be called on the main thread");
        }
        if (sSettings == null) {
            throw new IllegalStateException("ensureInitializationComplete must be called after startInitialization");
        }
        if (sInitialized) {
            return;
        }
        try {
            if (sResourceExtractor != null) {
                sResourceExtractor.waitForCompletion();
            }
            ArrayList<String> shellArgs = new ArrayList<String>();
            shellArgs.add("--icu-symbol-prefix=_binary_icudtl_dat");
            ApplicationInfo applicationInfo = FlutterMain.getApplicationInfo(applicationContext);
            shellArgs.add("--icu-native-lib-path=" + applicationInfo.nativeLibraryDir + File.separator + DEFAULT_LIBRARY);
            if (args != null) {
                Collections.addAll(shellArgs, args);
            }
            shellArgs.add("--aot-shared-library-name=" + sAotSharedLibraryName);
            shellArgs.add("--cache-dir-path=" + PathUtils.getCacheDirectory(applicationContext));
            if (sSettings.getLogTag() != null) {
                shellArgs.add("--log-tag=" + sSettings.getLogTag());
            }
            String appBundlePath = FlutterMain.findAppBundlePath(applicationContext);
            String appStoragePath = PathUtils.getFilesDir(applicationContext);
            String engineCachesPath = PathUtils.getCacheDirectory(applicationContext);
            FlutterJNI.nativeInit(applicationContext, shellArgs.toArray(new String[0]), appBundlePath, appStoragePath, engineCachesPath);
            sInitialized = true;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Flutter initialization failed.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void ensureInitializationCompleteAsync(final @NonNull Context applicationContext, final @Nullable String[] args, final @NonNull Handler callbackHandler, final @NonNull Runnable callback) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("ensureInitializationComplete must be called on the main thread");
        }
        if (sSettings == null) {
            throw new IllegalStateException("ensureInitializationComplete must be called after startInitialization");
        }
        if (sInitialized) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (sResourceExtractor != null) {
                    sResourceExtractor.waitForCompletion();
                }
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        FlutterMain.ensureInitializationComplete(applicationContext.getApplicationContext(), args);
                        callbackHandler.post(callback);
                    }
                });
            }
        }).start();
    }

    @NonNull
    private static ApplicationInfo getApplicationInfo(@NonNull Context applicationContext) {
        try {
            return applicationContext.getPackageManager().getApplicationInfo(applicationContext.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static void initConfig(@NonNull Context applicationContext) {
        Bundle metadata = FlutterMain.getApplicationInfo((Context)applicationContext).metaData;
        if (metadata == null) {
            return;
        }
        sAotSharedLibraryName = metadata.getString(PUBLIC_AOT_SHARED_LIBRARY_NAME, DEFAULT_AOT_SHARED_LIBRARY_NAME);
        sFlutterAssetsDir = metadata.getString(PUBLIC_FLUTTER_ASSETS_DIR_KEY, DEFAULT_FLUTTER_ASSETS_DIR);
        sVmSnapshotData = metadata.getString(PUBLIC_VM_SNAPSHOT_DATA_KEY, DEFAULT_VM_SNAPSHOT_DATA);
        sIsolateSnapshotData = metadata.getString(PUBLIC_ISOLATE_SNAPSHOT_DATA_KEY, DEFAULT_ISOLATE_SNAPSHOT_DATA);
    }

    private static void initResources(@NonNull Context applicationContext) {
        new ResourceCleaner(applicationContext).start();
        String dataDirPath = PathUtils.getDataDirectory(applicationContext);
        new File(dataDirPath, sFlutterAssetsDir).mkdirs();
    }

    @Nullable
    public static String findAppBundlePath(@NonNull Context applicationContext) {
        String dataDirectory = PathUtils.getDataDirectory(applicationContext);
        File appBundle = new File(dataDirectory, sFlutterAssetsDir);
        return appBundle.exists() ? appBundle.getPath() : null;
    }

    @NonNull
    public static String getLookupKeyForAsset(@NonNull String asset) {
        return FlutterMain.fromFlutterAssets(asset);
    }

    @NonNull
    public static String getLookupKeyForAsset(@NonNull String asset, @NonNull String packageName) {
        return FlutterMain.getLookupKeyForAsset("packages" + File.separator + packageName + File.separator + asset);
    }

    public static class Settings {
        private String logTag;

        @Nullable
        public String getLogTag() {
            return this.logTag;
        }

        public void setLogTag(String tag) {
            this.logTag = tag;
        }
    }
}

