/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import io.flutter.Log;
import io.flutter.embedding.android.DrawableSplashScreen;
import io.flutter.embedding.android.FlutterFragment;
import io.flutter.embedding.android.FlutterView;
import io.flutter.embedding.android.SplashScreen;
import io.flutter.embedding.engine.FlutterEngine;
import io.flutter.embedding.engine.FlutterShellArgs;
import io.flutter.view.FlutterMain;

public class FlutterActivity
extends FragmentActivity
implements FlutterFragment.FlutterEngineProvider,
FlutterFragment.FlutterEngineConfigurator,
FlutterFragment.SplashScreenProvider {
    private static final String TAG = "FlutterActivity";
    protected static final String DART_ENTRYPOINT_META_DATA_KEY = "io.flutter.Entrypoint";
    protected static final String INITIAL_ROUTE_META_DATA_KEY = "io.flutter.InitialRoute";
    protected static final String SPLASH_SCREEN_META_DATA_KEY = "io.flutter.embedding.android.SplashScreenDrawable";
    protected static final String NORMAL_THEME_META_DATA_KEY = "io.flutter.embedding.android.NormalTheme";
    protected static final String EXTRA_DART_ENTRYPOINT = "dart_entrypoint";
    protected static final String EXTRA_INITIAL_ROUTE = "initial_route";
    protected static final String EXTRA_BACKGROUND_MODE = "background_mode";
    protected static final String DEFAULT_DART_ENTRYPOINT = "main";
    protected static final String DEFAULT_INITIAL_ROUTE = "/";
    protected static final String DEFAULT_BACKGROUND_MODE = BackgroundMode.opaque.name();
    private static final String TAG_FLUTTER_FRAGMENT = "flutter_fragment";
    private static final int FRAGMENT_CONTAINER_ID = 609893468;
    @Nullable
    private FlutterFragment flutterFragment;

    @NonNull
    public static Intent createDefaultIntent(@NonNull Context launchContext) {
        return FlutterActivity.createBuilder().build(launchContext);
    }

    @NonNull
    public static IntentBuilder createBuilder() {
        return new IntentBuilder(FlutterActivity.class);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        this.switchLaunchThemeForNormalTheme();
        super.onCreate(savedInstanceState);
        this.configureWindowForTransparency();
        this.setContentView(this.createFragmentContainer());
        this.configureStatusBarForFullscreenFlutterExperience();
        this.ensureFlutterFragmentCreated();
    }

    private void switchLaunchThemeForNormalTheme() {
        try {
            ActivityInfo activityInfo = this.getPackageManager().getActivityInfo(this.getComponentName(), 128);
            if (activityInfo.metaData != null) {
                int normalThemeRID = activityInfo.metaData.getInt(NORMAL_THEME_META_DATA_KEY, -1);
                if (normalThemeRID != -1) {
                    this.setTheme(normalThemeRID);
                }
            } else {
                Log.d(TAG, "Using the launch theme as normal theme.");
            }
        }
        catch (PackageManager.NameNotFoundException exception) {
            Log.e(TAG, "Could not read meta-data for FlutterActivity. Using the launch theme as normal theme.");
        }
    }

    private Drawable getLaunchScreenDrawableFromActivityTheme() {
        TypedValue typedValue = new TypedValue();
        if (!this.getTheme().resolveAttribute(16842836, typedValue, true)) {
            return null;
        }
        if (typedValue.resourceId == 0) {
            return null;
        }
        try {
            return this.getResources().getDrawable(typedValue.resourceId, this.getTheme());
        }
        catch (Resources.NotFoundException e) {
            Log.e(TAG, "Splash screen requested in AndroidManifest.xml, but no windowBackground is available in the theme.");
            return null;
        }
    }

    @Override
    @Nullable
    public SplashScreen provideSplashScreen() {
        Drawable manifestSplashDrawable = this.getSplashScreenFromManifest();
        if (manifestSplashDrawable != null) {
            return new DrawableSplashScreen(manifestSplashDrawable);
        }
        return null;
    }

    @Nullable
    private Drawable getSplashScreenFromManifest() {
        try {
            ActivityInfo activityInfo = this.getPackageManager().getActivityInfo(this.getComponentName(), 129);
            Bundle metadata = activityInfo.metaData;
            Integer splashScreenId = metadata != null ? Integer.valueOf(metadata.getInt(SPLASH_SCREEN_META_DATA_KEY)) : null;
            return splashScreenId != null ? this.getResources().getDrawable(splashScreenId.intValue(), this.getTheme()) : null;
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    private void configureWindowForTransparency() {
        BackgroundMode backgroundMode = this.getBackgroundMode();
        if (backgroundMode == BackgroundMode.transparent) {
            this.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.getWindow().setFlags(512, 512);
        }
    }

    private void configureStatusBarForFullscreenFlutterExperience() {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = this.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(0x40000000);
            window.getDecorView().setSystemUiVisibility(1280);
        }
    }

    @NonNull
    private View createFragmentContainer() {
        FrameLayout container = new FrameLayout((Context)this);
        container.setId(609893468);
        container.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        return container;
    }

    private void ensureFlutterFragmentCreated() {
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        this.flutterFragment = (FlutterFragment)fragmentManager.findFragmentByTag(TAG_FLUTTER_FRAGMENT);
        if (this.flutterFragment == null) {
            this.flutterFragment = this.createFlutterFragment();
            fragmentManager.beginTransaction().add(609893468, (Fragment)this.flutterFragment, TAG_FLUTTER_FRAGMENT).commit();
        }
    }

    @NonNull
    protected FlutterFragment createFlutterFragment() {
        BackgroundMode backgroundMode = this.getBackgroundMode();
        Log.d(TAG, "Creating FlutterFragment:\nBackground transparency mode: " + (Object)((Object)backgroundMode) + "\nDart entrypoint: " + this.getDartEntrypoint() + "\nInitial route: " + this.getInitialRoute() + "\nApp bundle path: " + this.getAppBundlePath() + "\nWill attach FlutterEngine to Activity: " + this.shouldAttachEngineToActivity());
        return new FlutterFragment.Builder().dartEntrypoint(this.getDartEntrypoint()).initialRoute(this.getInitialRoute()).appBundlePath(this.getAppBundlePath()).flutterShellArgs(FlutterShellArgs.fromIntent(this.getIntent())).renderMode(backgroundMode == BackgroundMode.opaque ? FlutterView.RenderMode.surface : FlutterView.RenderMode.texture).transparencyMode(backgroundMode == BackgroundMode.opaque ? FlutterView.TransparencyMode.opaque : FlutterView.TransparencyMode.transparent).shouldAttachEngineToActivity(this.shouldAttachEngineToActivity()).build();
    }

    protected boolean shouldAttachEngineToActivity() {
        return true;
    }

    @Override
    @Nullable
    public FlutterEngine provideFlutterEngine(@NonNull Context context) {
        return null;
    }

    @Override
    public void configureFlutterEngine(@NonNull FlutterEngine flutterEngine) {
    }

    public void onPostResume() {
        super.onPostResume();
        this.flutterFragment.onPostResume();
    }

    protected void onNewIntent(@NonNull Intent intent) {
        this.flutterFragment.onNewIntent(intent);
        super.onNewIntent(intent);
    }

    public void onBackPressed() {
        this.flutterFragment.onBackPressed();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        this.flutterFragment.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    public void onUserLeaveHint() {
        this.flutterFragment.onUserLeaveHint();
    }

    public void onTrimMemory(int level) {
        super.onTrimMemory(level);
        this.flutterFragment.onTrimMemory(level);
    }

    @Nullable
    protected FlutterEngine getFlutterEngine() {
        return this.flutterFragment.getFlutterEngine();
    }

    @NonNull
    protected String getAppBundlePath() {
        String appBundlePath;
        if (this.isDebuggable() && "android.intent.action.RUN".equals(this.getIntent().getAction()) && (appBundlePath = this.getIntent().getDataString()) != null) {
            return appBundlePath;
        }
        return FlutterMain.findAppBundlePath(this.getApplicationContext());
    }

    @NonNull
    protected String getDartEntrypoint() {
        if (this.getIntent().hasExtra(EXTRA_DART_ENTRYPOINT)) {
            return this.getIntent().getStringExtra(EXTRA_DART_ENTRYPOINT);
        }
        try {
            ActivityInfo activityInfo = this.getPackageManager().getActivityInfo(this.getComponentName(), 129);
            Bundle metadata = activityInfo.metaData;
            String desiredDartEntrypoint = metadata != null ? metadata.getString(DART_ENTRYPOINT_META_DATA_KEY) : null;
            return desiredDartEntrypoint != null ? desiredDartEntrypoint : DEFAULT_DART_ENTRYPOINT;
        }
        catch (PackageManager.NameNotFoundException e) {
            return DEFAULT_DART_ENTRYPOINT;
        }
    }

    @NonNull
    protected String getInitialRoute() {
        if (this.getIntent().hasExtra(EXTRA_INITIAL_ROUTE)) {
            return this.getIntent().getStringExtra(EXTRA_INITIAL_ROUTE);
        }
        try {
            ActivityInfo activityInfo = this.getPackageManager().getActivityInfo(this.getComponentName(), 129);
            Bundle metadata = activityInfo.metaData;
            String desiredInitialRoute = metadata != null ? metadata.getString(INITIAL_ROUTE_META_DATA_KEY) : null;
            return desiredInitialRoute != null ? desiredInitialRoute : DEFAULT_INITIAL_ROUTE;
        }
        catch (PackageManager.NameNotFoundException e) {
            return DEFAULT_INITIAL_ROUTE;
        }
    }

    @NonNull
    protected BackgroundMode getBackgroundMode() {
        if (this.getIntent().hasExtra(EXTRA_BACKGROUND_MODE)) {
            return BackgroundMode.valueOf(this.getIntent().getStringExtra(EXTRA_BACKGROUND_MODE));
        }
        return BackgroundMode.opaque;
    }

    private boolean isDebuggable() {
        return (this.getApplicationInfo().flags & 2) != 0;
    }

    public static enum BackgroundMode {
        opaque,
        transparent;

    }

    public static class IntentBuilder {
        private final Class<? extends FlutterActivity> activityClass;
        private String dartEntrypoint = "main";
        private String initialRoute = "/";
        private String backgroundMode = DEFAULT_BACKGROUND_MODE;

        protected IntentBuilder(@NonNull Class<? extends FlutterActivity> activityClass) {
            this.activityClass = activityClass;
        }

        @NonNull
        public IntentBuilder dartEntrypoint(@NonNull String dartEntrypoint) {
            this.dartEntrypoint = dartEntrypoint;
            return this;
        }

        @NonNull
        public IntentBuilder initialRoute(@NonNull String initialRoute) {
            this.initialRoute = initialRoute;
            return this;
        }

        @NonNull
        public IntentBuilder backgroundMode(@NonNull BackgroundMode backgroundMode) {
            this.backgroundMode = backgroundMode.name();
            return this;
        }

        @NonNull
        public Intent build(@NonNull Context context) {
            return new Intent(context, this.activityClass).putExtra(FlutterActivity.EXTRA_DART_ENTRYPOINT, this.dartEntrypoint).putExtra(FlutterActivity.EXTRA_INITIAL_ROUTE, this.initialRoute).putExtra(FlutterActivity.EXTRA_BACKGROUND_MODE, this.backgroundMode);
        }
    }
}

