/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.os.Build;
import android.os.Handler;
import android.os.LocaleList;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.annotation.UiThread;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.WindowInsets;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeProvider;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import io.flutter.app.FlutterPluginRegistry;
import io.flutter.embedding.android.AndroidKeyProcessor;
import io.flutter.embedding.android.AndroidTouchProcessor;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.embedding.engine.renderer.FlutterRenderer;
import io.flutter.embedding.engine.systemchannels.AccessibilityChannel;
import io.flutter.embedding.engine.systemchannels.KeyEventChannel;
import io.flutter.embedding.engine.systemchannels.LifecycleChannel;
import io.flutter.embedding.engine.systemchannels.LocalizationChannel;
import io.flutter.embedding.engine.systemchannels.NavigationChannel;
import io.flutter.embedding.engine.systemchannels.PlatformChannel;
import io.flutter.embedding.engine.systemchannels.SettingsChannel;
import io.flutter.embedding.engine.systemchannels.SystemChannel;
import io.flutter.plugin.common.ActivityLifecycleListener;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.editing.TextInputPlugin;
import io.flutter.plugin.platform.PlatformPlugin;
import io.flutter.plugin.platform.PlatformViewsController;
import io.flutter.view.AccessibilityBridge;
import io.flutter.view.FlutterMain;
import io.flutter.view.FlutterNativeView;
import io.flutter.view.FlutterRunArguments;
import io.flutter.view.TextureRegistry;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;

public class FlutterView
extends SurfaceView
implements BinaryMessenger,
TextureRegistry {
    private static final String TAG = "FlutterView";
    private final DartExecutor dartExecutor;
    private final FlutterRenderer flutterRenderer;
    private final NavigationChannel navigationChannel;
    private final KeyEventChannel keyEventChannel;
    private final LifecycleChannel lifecycleChannel;
    private final LocalizationChannel localizationChannel;
    private final PlatformChannel platformChannel;
    private final SettingsChannel settingsChannel;
    private final SystemChannel systemChannel;
    private final InputMethodManager mImm;
    private final TextInputPlugin mTextInputPlugin;
    private final AndroidKeyProcessor androidKeyProcessor;
    private final AndroidTouchProcessor androidTouchProcessor;
    private AccessibilityBridge mAccessibilityNodeProvider;
    private final SurfaceHolder.Callback mSurfaceCallback;
    private final ViewportMetrics mMetrics;
    private final List<ActivityLifecycleListener> mActivityLifecycleListeners;
    private final List<FirstFrameListener> mFirstFrameListeners;
    private final AtomicLong nextTextureId = new AtomicLong(0L);
    private FlutterNativeView mNativeView;
    private boolean mIsSoftwareRenderingEnabled = false;
    private boolean didRenderFirstFrame = false;
    private final AccessibilityBridge.OnAccessibilityChangeListener onAccessibilityChangeListener = new AccessibilityBridge.OnAccessibilityChangeListener(){

        @Override
        public void onAccessibilityChanged(boolean isAccessibilityEnabled, boolean isTouchExplorationEnabled) {
            FlutterView.this.resetWillNotDraw(isAccessibilityEnabled, isTouchExplorationEnabled);
        }
    };

    public FlutterView(Context context) {
        this(context, null);
    }

    public FlutterView(Context context, AttributeSet attrs) {
        this(context, attrs, null);
    }

    public FlutterView(Context context, AttributeSet attrs, FlutterNativeView nativeView) {
        super(context, attrs);
        Activity activity = FlutterView.getActivity(this.getContext());
        if (activity == null) {
            throw new IllegalArgumentException("Bad context");
        }
        this.mNativeView = nativeView == null ? new FlutterNativeView(activity.getApplicationContext()) : nativeView;
        this.dartExecutor = this.mNativeView.getDartExecutor();
        this.flutterRenderer = new FlutterRenderer(this.mNativeView.getFlutterJNI());
        this.mIsSoftwareRenderingEnabled = FlutterJNI.nativeGetIsSoftwareRenderingEnabled();
        this.mMetrics = new ViewportMetrics();
        this.mMetrics.devicePixelRatio = context.getResources().getDisplayMetrics().density;
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.mNativeView.attachViewAndActivity(this, activity);
        this.mSurfaceCallback = new SurfaceHolder.Callback(){

            public void surfaceCreated(SurfaceHolder holder) {
                FlutterView.this.assertAttached();
                FlutterView.this.mNativeView.getFlutterJNI().onSurfaceCreated(holder.getSurface());
            }

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                FlutterView.this.assertAttached();
                FlutterView.this.mNativeView.getFlutterJNI().onSurfaceChanged(width, height);
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
                FlutterView.this.assertAttached();
                FlutterView.this.mNativeView.getFlutterJNI().onSurfaceDestroyed();
            }
        };
        this.getHolder().addCallback(this.mSurfaceCallback);
        this.mActivityLifecycleListeners = new ArrayList<ActivityLifecycleListener>();
        this.mFirstFrameListeners = new ArrayList<FirstFrameListener>();
        this.navigationChannel = new NavigationChannel(this.dartExecutor);
        this.keyEventChannel = new KeyEventChannel(this.dartExecutor);
        this.lifecycleChannel = new LifecycleChannel(this.dartExecutor);
        this.localizationChannel = new LocalizationChannel(this.dartExecutor);
        this.platformChannel = new PlatformChannel(this.dartExecutor);
        this.systemChannel = new SystemChannel(this.dartExecutor);
        this.settingsChannel = new SettingsChannel(this.dartExecutor);
        PlatformPlugin platformPlugin = new PlatformPlugin(activity, this.platformChannel);
        this.addActivityLifecycleListener(platformPlugin);
        this.mImm = (InputMethodManager)this.getContext().getSystemService("input_method");
        PlatformViewsController platformViewsController = this.mNativeView.getPluginRegistry().getPlatformViewsController();
        this.mTextInputPlugin = new TextInputPlugin((View)this, this.dartExecutor, platformViewsController);
        this.androidKeyProcessor = new AndroidKeyProcessor(this.keyEventChannel, this.mTextInputPlugin);
        this.androidTouchProcessor = new AndroidTouchProcessor(this.flutterRenderer);
        this.mNativeView.getPluginRegistry().getPlatformViewsController().attachTextInputPlugin(this.mTextInputPlugin);
        this.sendLocalesToDart(this.getResources().getConfiguration());
        this.sendUserPlatformSettingsToDart();
    }

    private static Activity getActivity(Context context) {
        if (context == null) {
            return null;
        }
        if (context instanceof Activity) {
            return (Activity)context;
        }
        if (context instanceof ContextWrapper) {
            return FlutterView.getActivity(((ContextWrapper)context).getBaseContext());
        }
        return null;
    }

    @NonNull
    public DartExecutor getDartExecutor() {
        return this.dartExecutor;
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (!this.isAttached()) {
            return super.onKeyUp(keyCode, event);
        }
        this.androidKeyProcessor.onKeyUp(event);
        return super.onKeyUp(keyCode, event);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (!this.isAttached()) {
            return super.onKeyDown(keyCode, event);
        }
        this.androidKeyProcessor.onKeyDown(event);
        return super.onKeyDown(keyCode, event);
    }

    public FlutterNativeView getFlutterNativeView() {
        return this.mNativeView;
    }

    public FlutterPluginRegistry getPluginRegistry() {
        return this.mNativeView.getPluginRegistry();
    }

    public String getLookupKeyForAsset(String asset) {
        return FlutterMain.getLookupKeyForAsset(asset);
    }

    public String getLookupKeyForAsset(String asset, String packageName) {
        return FlutterMain.getLookupKeyForAsset(asset, packageName);
    }

    public void addActivityLifecycleListener(ActivityLifecycleListener listener) {
        this.mActivityLifecycleListeners.add(listener);
    }

    public void onStart() {
        this.lifecycleChannel.appIsInactive();
    }

    public void onPause() {
        this.lifecycleChannel.appIsInactive();
    }

    public void onPostResume() {
        for (ActivityLifecycleListener listener : this.mActivityLifecycleListeners) {
            listener.onPostResume();
        }
        this.lifecycleChannel.appIsResumed();
    }

    public void onStop() {
        this.lifecycleChannel.appIsPaused();
    }

    public void onMemoryPressure() {
        this.systemChannel.sendMemoryPressureWarning();
    }

    public boolean hasRenderedFirstFrame() {
        return this.didRenderFirstFrame;
    }

    public void addFirstFrameListener(FirstFrameListener listener) {
        this.mFirstFrameListeners.add(listener);
    }

    public void removeFirstFrameListener(FirstFrameListener listener) {
        this.mFirstFrameListeners.remove(listener);
    }

    public void enableTransparentBackground() {
        this.setZOrderOnTop(true);
        this.getHolder().setFormat(-2);
    }

    public void disableTransparentBackground() {
        this.setZOrderOnTop(false);
        this.getHolder().setFormat(-1);
    }

    public void setInitialRoute(String route) {
        this.navigationChannel.setInitialRoute(route);
    }

    public void pushRoute(String route) {
        this.navigationChannel.pushRoute(route);
    }

    public void popRoute() {
        this.navigationChannel.popRoute();
    }

    private void sendUserPlatformSettingsToDart() {
        boolean isNightModeOn = (this.getResources().getConfiguration().uiMode & 0x30) == 32;
        SettingsChannel.PlatformBrightness brightness = isNightModeOn ? SettingsChannel.PlatformBrightness.dark : SettingsChannel.PlatformBrightness.light;
        this.settingsChannel.startMessage().setTextScaleFactor(this.getResources().getConfiguration().fontScale).setUse24HourFormat(DateFormat.is24HourFormat((Context)this.getContext())).setPlatformBrightness(brightness).send();
    }

    private void sendLocalesToDart(Configuration config) {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        if (Build.VERSION.SDK_INT >= 24) {
            LocaleList localeList = config.getLocales();
            int localeCount = localeList.size();
            for (int index = 0; index < localeCount; ++index) {
                Locale locale = localeList.get(index);
                locales.add(locale);
            }
        } else {
            locales.add(config.locale);
        }
        this.localizationChannel.sendLocales(locales);
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.sendLocalesToDart(newConfig);
        this.sendUserPlatformSettingsToDart();
    }

    float getDevicePixelRatio() {
        return this.mMetrics.devicePixelRatio;
    }

    public FlutterNativeView detach() {
        if (!this.isAttached()) {
            return null;
        }
        this.getHolder().removeCallback(this.mSurfaceCallback);
        this.mNativeView.detachFromFlutterView();
        FlutterNativeView view = this.mNativeView;
        this.mNativeView = null;
        return view;
    }

    public void destroy() {
        if (!this.isAttached()) {
            return;
        }
        this.getHolder().removeCallback(this.mSurfaceCallback);
        this.mNativeView.destroy();
        this.mNativeView = null;
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        return this.mTextInputPlugin.createInputConnection((View)this, outAttrs);
    }

    public boolean checkInputConnectionProxy(View view) {
        return this.mNativeView.getPluginRegistry().getPlatformViewsController().checkInputConnectionProxy(view);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isAttached()) {
            return super.onTouchEvent(event);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.requestUnbufferedDispatch(event);
        }
        return this.androidTouchProcessor.onTouchEvent(event);
    }

    public boolean onHoverEvent(MotionEvent event) {
        if (!this.isAttached()) {
            return super.onHoverEvent(event);
        }
        boolean handled = this.mAccessibilityNodeProvider.onAccessibilityHoverEvent(event);
        if (!handled) {
            // empty if block
        }
        return handled;
    }

    public boolean onGenericMotionEvent(MotionEvent event) {
        boolean handled = this.isAttached() && this.androidTouchProcessor.onGenericMotionEvent(event);
        return handled ? true : super.onGenericMotionEvent(event);
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        this.mMetrics.physicalWidth = width;
        this.mMetrics.physicalHeight = height;
        this.updateViewportMetrics();
        super.onSizeChanged(width, height, oldWidth, oldHeight);
    }

    ZeroSides calculateShouldZeroSides() {
        Activity activity = (Activity)this.getContext();
        int orientation = activity.getResources().getConfiguration().orientation;
        int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
        if (orientation == 2) {
            if (rotation == 1) {
                return ZeroSides.RIGHT;
            }
            if (rotation == 3) {
                return Build.VERSION.SDK_INT >= 23 ? ZeroSides.LEFT : ZeroSides.RIGHT;
            }
            if (rotation == 0 || rotation == 2) {
                return ZeroSides.BOTH;
            }
        }
        return ZeroSides.NONE;
    }

    @TargetApi(value=20)
    @RequiresApi(value=20)
    int calculateBottomKeyboardInset(WindowInsets insets) {
        int screenHeight = this.getRootView().getHeight();
        double keyboardHeightRatioHeuristic = 0.18;
        if ((double)insets.getSystemWindowInsetBottom() < (double)screenHeight * 0.18) {
            return 0;
        }
        return insets.getSystemWindowInsetBottom();
    }

    @TargetApi(value=20)
    @RequiresApi(value=20)
    public final WindowInsets onApplyWindowInsets(WindowInsets insets) {
        boolean statusBarHidden = (4 & this.getWindowSystemUiVisibility()) != 0;
        boolean navigationBarHidden = (2 & this.getWindowSystemUiVisibility()) != 0;
        ZeroSides zeroSides = ZeroSides.NONE;
        if (navigationBarHidden) {
            zeroSides = this.calculateShouldZeroSides();
        }
        this.mMetrics.physicalPaddingTop = statusBarHidden ? 0 : insets.getSystemWindowInsetTop();
        this.mMetrics.physicalPaddingRight = zeroSides == ZeroSides.RIGHT || zeroSides == ZeroSides.BOTH ? 0 : insets.getSystemWindowInsetRight();
        this.mMetrics.physicalPaddingBottom = 0;
        this.mMetrics.physicalPaddingLeft = zeroSides == ZeroSides.LEFT || zeroSides == ZeroSides.BOTH ? 0 : insets.getSystemWindowInsetLeft();
        this.mMetrics.physicalViewInsetTop = 0;
        this.mMetrics.physicalViewInsetRight = 0;
        this.mMetrics.physicalViewInsetBottom = navigationBarHidden ? this.calculateBottomKeyboardInset(insets) : insets.getSystemWindowInsetBottom();
        this.mMetrics.physicalViewInsetLeft = 0;
        this.updateViewportMetrics();
        return super.onApplyWindowInsets(insets);
    }

    protected boolean fitSystemWindows(Rect insets) {
        if (Build.VERSION.SDK_INT <= 19) {
            this.mMetrics.physicalPaddingTop = insets.top;
            this.mMetrics.physicalPaddingRight = insets.right;
            this.mMetrics.physicalPaddingBottom = 0;
            this.mMetrics.physicalPaddingLeft = insets.left;
            this.mMetrics.physicalViewInsetTop = 0;
            this.mMetrics.physicalViewInsetRight = 0;
            this.mMetrics.physicalViewInsetBottom = insets.bottom;
            this.mMetrics.physicalViewInsetLeft = 0;
            this.updateViewportMetrics();
            return true;
        }
        return super.fitSystemWindows(insets);
    }

    private boolean isAttached() {
        return this.mNativeView != null && this.mNativeView.isAttached();
    }

    void assertAttached() {
        if (!this.isAttached()) {
            throw new AssertionError((Object)"Platform view is not attached");
        }
    }

    private void preRun() {
        this.resetAccessibilityTree();
    }

    void resetAccessibilityTree() {
        if (this.mAccessibilityNodeProvider != null) {
            this.mAccessibilityNodeProvider.reset();
        }
    }

    private void postRun() {
    }

    public void runFromBundle(FlutterRunArguments args) {
        this.assertAttached();
        this.preRun();
        this.mNativeView.runFromBundle(args);
        this.postRun();
    }

    public Bitmap getBitmap() {
        this.assertAttached();
        return this.mNativeView.getFlutterJNI().getBitmap();
    }

    private void updateViewportMetrics() {
        if (!this.isAttached()) {
            return;
        }
        this.mNativeView.getFlutterJNI().setViewportMetrics(this.mMetrics.devicePixelRatio, this.mMetrics.physicalWidth, this.mMetrics.physicalHeight, this.mMetrics.physicalPaddingTop, this.mMetrics.physicalPaddingRight, this.mMetrics.physicalPaddingBottom, this.mMetrics.physicalPaddingLeft, this.mMetrics.physicalViewInsetTop, this.mMetrics.physicalViewInsetRight, this.mMetrics.physicalViewInsetBottom, this.mMetrics.physicalViewInsetLeft);
    }

    public void updateSemantics(ByteBuffer buffer, String[] strings) {
        try {
            if (this.mAccessibilityNodeProvider != null) {
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                this.mAccessibilityNodeProvider.updateSemantics(buffer, strings);
            }
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"Uncaught exception while updating semantics", (Throwable)ex);
        }
    }

    public void updateCustomAccessibilityActions(ByteBuffer buffer, String[] strings) {
        try {
            if (this.mAccessibilityNodeProvider != null) {
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                this.mAccessibilityNodeProvider.updateCustomAccessibilityActions(buffer, strings);
            }
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"Uncaught exception while updating local context actions", (Throwable)ex);
        }
    }

    public void onFirstFrame() {
        this.didRenderFirstFrame = true;
        ArrayList<FirstFrameListener> listeners = new ArrayList<FirstFrameListener>(this.mFirstFrameListeners);
        for (FirstFrameListener listener : listeners) {
            listener.onFirstFrame();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        PlatformViewsController platformViewsController = this.getPluginRegistry().getPlatformViewsController();
        this.mAccessibilityNodeProvider = new AccessibilityBridge((View)this, new AccessibilityChannel(this.dartExecutor, this.getFlutterNativeView().getFlutterJNI()), (AccessibilityManager)this.getContext().getSystemService("accessibility"), this.getContext().getContentResolver(), platformViewsController);
        this.mAccessibilityNodeProvider.setOnAccessibilityChangeListener(this.onAccessibilityChangeListener);
        this.resetWillNotDraw(this.mAccessibilityNodeProvider.isAccessibilityEnabled(), this.mAccessibilityNodeProvider.isTouchExplorationEnabled());
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mAccessibilityNodeProvider.release();
        this.mAccessibilityNodeProvider = null;
    }

    private void resetWillNotDraw(boolean isAccessibilityEnabled, boolean isTouchExplorationEnabled) {
        if (!this.mIsSoftwareRenderingEnabled) {
            this.setWillNotDraw(!isAccessibilityEnabled && !isTouchExplorationEnabled);
        } else {
            this.setWillNotDraw(false);
        }
    }

    public AccessibilityNodeProvider getAccessibilityNodeProvider() {
        if (this.mAccessibilityNodeProvider != null && this.mAccessibilityNodeProvider.isAccessibilityEnabled()) {
            return this.mAccessibilityNodeProvider;
        }
        return null;
    }

    @Override
    @UiThread
    public void send(String channel, ByteBuffer message) {
        this.send(channel, message, null);
    }

    @Override
    @UiThread
    public void send(String channel, ByteBuffer message, BinaryMessenger.BinaryReply callback) {
        if (!this.isAttached()) {
            Log.d((String)TAG, (String)("FlutterView.send called on a detached view, channel=" + channel));
            return;
        }
        this.mNativeView.send(channel, message, callback);
    }

    @Override
    @UiThread
    public void setMessageHandler(String channel, BinaryMessenger.BinaryMessageHandler handler) {
        this.mNativeView.setMessageHandler(channel, handler);
    }

    @Override
    public TextureRegistry.SurfaceTextureEntry createSurfaceTexture() {
        SurfaceTexture surfaceTexture = new SurfaceTexture(0);
        surfaceTexture.detachFromGLContext();
        SurfaceTextureRegistryEntry entry = new SurfaceTextureRegistryEntry(this.nextTextureId.getAndIncrement(), surfaceTexture);
        this.mNativeView.getFlutterJNI().registerTexture(entry.id(), surfaceTexture);
        return entry;
    }

    final class SurfaceTextureRegistryEntry
    implements TextureRegistry.SurfaceTextureEntry {
        private final long id;
        private final SurfaceTexture surfaceTexture;
        private boolean released;
        private SurfaceTexture.OnFrameAvailableListener onFrameListener = new SurfaceTexture.OnFrameAvailableListener(){

            public void onFrameAvailable(SurfaceTexture texture) {
                if (SurfaceTextureRegistryEntry.this.released || FlutterView.this.mNativeView == null) {
                    return;
                }
                FlutterView.this.mNativeView.getFlutterJNI().markTextureFrameAvailable(SurfaceTextureRegistryEntry.this.id);
            }
        };

        SurfaceTextureRegistryEntry(long id, SurfaceTexture surfaceTexture) {
            this.id = id;
            this.surfaceTexture = surfaceTexture;
            if (Build.VERSION.SDK_INT >= 21) {
                this.surfaceTexture.setOnFrameAvailableListener(this.onFrameListener, new Handler());
            } else {
                this.surfaceTexture.setOnFrameAvailableListener(this.onFrameListener);
            }
        }

        @Override
        public SurfaceTexture surfaceTexture() {
            return this.surfaceTexture;
        }

        @Override
        public long id() {
            return this.id;
        }

        @Override
        public void release() {
            if (this.released) {
                return;
            }
            this.released = true;
            this.surfaceTexture.setOnFrameAvailableListener(null);
            this.surfaceTexture.release();
            FlutterView.this.mNativeView.getFlutterJNI().unregisterTexture(this.id);
        }
    }

    public static interface FirstFrameListener {
        public void onFirstFrame();
    }

    static enum ZeroSides {
        NONE,
        LEFT,
        RIGHT,
        BOTH;

    }

    static final class ViewportMetrics {
        float devicePixelRatio = 1.0f;
        int physicalWidth = 0;
        int physicalHeight = 0;
        int physicalPaddingTop = 0;
        int physicalPaddingRight = 0;
        int physicalPaddingBottom = 0;
        int physicalPaddingLeft = 0;
        int physicalViewInsetTop = 0;
        int physicalViewInsetRight = 0;
        int physicalViewInsetBottom = 0;
        int physicalViewInsetLeft = 0;

        ViewportMetrics() {
        }
    }

    public static interface Provider {
        public FlutterView getFlutterView();
    }
}

