/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.dart;

import android.content.res.AssetManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import io.flutter.Log;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.embedding.engine.dart.DartMessenger;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.StringCodec;
import io.flutter.view.FlutterCallbackInformation;
import java.nio.ByteBuffer;

public class DartExecutor
implements BinaryMessenger {
    private static final String TAG = "DartExecutor";
    @NonNull
    private final FlutterJNI flutterJNI;
    @NonNull
    private final DartMessenger messenger;
    private boolean isApplicationRunning = false;
    @Nullable
    private String isolateServiceId;
    @Nullable
    private IsolateServiceIdListener isolateServiceIdListener;
    private final BinaryMessenger.BinaryMessageHandler isolateChannelMessageHandler = new BinaryMessenger.BinaryMessageHandler(){

        @Override
        public void onMessage(ByteBuffer message, BinaryMessenger.BinaryReply callback) {
            DartExecutor.this.isolateServiceId = StringCodec.INSTANCE.decodeMessage(message);
            if (DartExecutor.this.isolateServiceIdListener != null) {
                DartExecutor.this.isolateServiceIdListener.onIsolateServiceIdAvailable(DartExecutor.this.isolateServiceId);
            }
        }
    };

    public DartExecutor(@NonNull FlutterJNI flutterJNI) {
        this.flutterJNI = flutterJNI;
        this.messenger = new DartMessenger(flutterJNI);
        this.messenger.setMessageHandler("flutter/isolate", this.isolateChannelMessageHandler);
    }

    public void onAttachedToJNI() {
        Log.v(TAG, "Attached to JNI. Registering the platform message handler for this Dart execution context.");
        this.flutterJNI.setPlatformMessageHandler(this.messenger);
    }

    public void onDetachedFromJNI() {
        Log.v(TAG, "Detached from JNI. De-registering the platform message handler for this Dart execution context.");
        this.flutterJNI.setPlatformMessageHandler(null);
    }

    public boolean isExecutingDart() {
        return this.isApplicationRunning;
    }

    public void executeDartEntrypoint(@NonNull DartEntrypoint dartEntrypoint) {
        if (this.isApplicationRunning) {
            Log.w(TAG, "Attempted to run a DartExecutor that is already running.");
            return;
        }
        Log.v(TAG, "Executing Dart entrypoint: " + dartEntrypoint);
        this.flutterJNI.runBundleAndSnapshotFromLibrary(dartEntrypoint.pathToBundle, dartEntrypoint.dartEntrypointFunctionName, null, dartEntrypoint.androidAssetManager);
        this.isApplicationRunning = true;
    }

    public void executeDartCallback(@NonNull DartCallback dartCallback) {
        if (this.isApplicationRunning) {
            Log.w(TAG, "Attempted to run a DartExecutor that is already running.");
            return;
        }
        Log.v(TAG, "Executing Dart callback: " + dartCallback);
        this.flutterJNI.runBundleAndSnapshotFromLibrary(dartCallback.pathToBundle, dartCallback.callbackHandle.callbackName, dartCallback.callbackHandle.callbackLibraryPath, dartCallback.androidAssetManager);
        this.isApplicationRunning = true;
    }

    @Override
    @UiThread
    public void send(@NonNull String channel, @Nullable ByteBuffer message) {
        this.messenger.send(channel, message, null);
    }

    @Override
    @UiThread
    public void send(@NonNull String channel, @Nullable ByteBuffer message, @Nullable BinaryMessenger.BinaryReply callback) {
        this.messenger.send(channel, message, callback);
    }

    @Override
    @UiThread
    public void setMessageHandler(@NonNull String channel, @Nullable BinaryMessenger.BinaryMessageHandler handler) {
        this.messenger.setMessageHandler(channel, handler);
    }

    @UiThread
    public int getPendingChannelResponseCount() {
        return this.messenger.getPendingChannelResponseCount();
    }

    @Nullable
    public String getIsolateServiceId() {
        return this.isolateServiceId;
    }

    public void setIsolateServiceIdListener(@Nullable IsolateServiceIdListener listener) {
        this.isolateServiceIdListener = listener;
        if (this.isolateServiceIdListener != null && this.isolateServiceId != null) {
            this.isolateServiceIdListener.onIsolateServiceIdAvailable(this.isolateServiceId);
        }
    }

    public static class DartCallback {
        public final AssetManager androidAssetManager;
        public final String pathToBundle;
        public final FlutterCallbackInformation callbackHandle;

        public DartCallback(@NonNull AssetManager androidAssetManager, @NonNull String pathToBundle, @NonNull FlutterCallbackInformation callbackHandle) {
            this.androidAssetManager = androidAssetManager;
            this.pathToBundle = pathToBundle;
            this.callbackHandle = callbackHandle;
        }

        @NonNull
        public String toString() {
            return "DartCallback( bundle path: " + this.pathToBundle + ", library path: " + this.callbackHandle.callbackLibraryPath + ", function: " + this.callbackHandle.callbackName + " )";
        }
    }

    public static class DartEntrypoint {
        @NonNull
        public final AssetManager androidAssetManager;
        @NonNull
        public final String pathToBundle;
        @NonNull
        public final String dartEntrypointFunctionName;

        public DartEntrypoint(@NonNull AssetManager androidAssetManager, @NonNull String pathToBundle, @NonNull String dartEntrypointFunctionName) {
            this.androidAssetManager = androidAssetManager;
            this.pathToBundle = pathToBundle;
            this.dartEntrypointFunctionName = dartEntrypointFunctionName;
        }

        @NonNull
        public String toString() {
            return "DartEntrypoint( bundle path: " + this.pathToBundle + ", function: " + this.dartEntrypointFunctionName + " )";
        }
    }

    static interface IsolateServiceIdListener {
        public void onIsolateServiceIdAvailable(@NonNull String var1);
    }
}

