/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine;

import android.app.Activity;
import android.app.Service;
import android.arch.lifecycle.Lifecycle;
import android.content.BroadcastReceiver;
import android.content.ContentProvider;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.flutter.Log;
import io.flutter.embedding.engine.FlutterEngine;
import io.flutter.embedding.engine.FlutterEngineAndroidLifecycle;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.embedding.engine.plugins.PluginRegistry;
import io.flutter.embedding.engine.plugins.activity.ActivityAware;
import io.flutter.embedding.engine.plugins.activity.ActivityControlSurface;
import io.flutter.embedding.engine.plugins.activity.ActivityPluginBinding;
import io.flutter.embedding.engine.plugins.broadcastreceiver.BroadcastReceiverAware;
import io.flutter.embedding.engine.plugins.broadcastreceiver.BroadcastReceiverControlSurface;
import io.flutter.embedding.engine.plugins.broadcastreceiver.BroadcastReceiverPluginBinding;
import io.flutter.embedding.engine.plugins.contentprovider.ContentProviderAware;
import io.flutter.embedding.engine.plugins.contentprovider.ContentProviderControlSurface;
import io.flutter.embedding.engine.plugins.contentprovider.ContentProviderPluginBinding;
import io.flutter.embedding.engine.plugins.service.ServiceAware;
import io.flutter.embedding.engine.plugins.service.ServiceControlSurface;
import io.flutter.embedding.engine.plugins.service.ServicePluginBinding;
import io.flutter.plugin.common.PluginRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class FlutterEnginePluginRegistry
implements PluginRegistry,
ActivityControlSurface,
ServiceControlSurface,
BroadcastReceiverControlSurface,
ContentProviderControlSurface {
    private static final String TAG = "FlutterEnginePluginRegistry";
    @NonNull
    private final Map<Class<? extends FlutterPlugin>, FlutterPlugin> plugins = new HashMap<Class<? extends FlutterPlugin>, FlutterPlugin>();
    @NonNull
    private final FlutterPlugin.FlutterPluginBinding pluginBinding;
    @NonNull
    private final FlutterEngineAndroidLifecycle flutterEngineAndroidLifecycle;
    @NonNull
    private final Map<Class<? extends FlutterPlugin>, ActivityAware> activityAwarePlugins = new HashMap<Class<? extends FlutterPlugin>, ActivityAware>();
    @Nullable
    private Activity activity;
    @Nullable
    private FlutterEngineActivityPluginBinding activityPluginBinding;
    private boolean isWaitingForActivityReattachment = false;
    @NonNull
    private final Map<Class<? extends FlutterPlugin>, ServiceAware> serviceAwarePlugins = new HashMap<Class<? extends FlutterPlugin>, ServiceAware>();
    @Nullable
    private Service service;
    @Nullable
    private FlutterEngineServicePluginBinding servicePluginBinding;
    @NonNull
    private final Map<Class<? extends FlutterPlugin>, BroadcastReceiverAware> broadcastReceiverAwarePlugins = new HashMap<Class<? extends FlutterPlugin>, BroadcastReceiverAware>();
    @Nullable
    private BroadcastReceiver broadcastReceiver;
    @Nullable
    private FlutterEngineBroadcastReceiverPluginBinding broadcastReceiverPluginBinding;
    @NonNull
    private final Map<Class<? extends FlutterPlugin>, ContentProviderAware> contentProviderAwarePlugins = new HashMap<Class<? extends FlutterPlugin>, ContentProviderAware>();
    @Nullable
    private ContentProvider contentProvider;
    @Nullable
    private FlutterEngineContentProviderPluginBinding contentProviderPluginBinding;

    FlutterEnginePluginRegistry(@NonNull Context appContext, @NonNull FlutterEngine flutterEngine, @NonNull FlutterEngineAndroidLifecycle lifecycle) {
        this.flutterEngineAndroidLifecycle = lifecycle;
        this.pluginBinding = new FlutterPlugin.FlutterPluginBinding(appContext, flutterEngine, (Lifecycle)lifecycle);
    }

    public void destroy() {
        Log.d(TAG, "Destroying.");
        this.detachFromAndroidComponent();
        this.flutterEngineAndroidLifecycle.destroy();
        this.removeAll();
    }

    @Override
    public void add(@NonNull FlutterPlugin plugin) {
        Log.v(TAG, "Adding plugin: " + plugin);
        this.plugins.put(plugin.getClass(), plugin);
        plugin.onAttachedToEngine(this.pluginBinding);
        if (plugin instanceof ActivityAware) {
            ActivityAware activityAware = (ActivityAware)((Object)plugin);
            this.activityAwarePlugins.put(plugin.getClass(), activityAware);
            if (this.isAttachedToActivity()) {
                activityAware.onAttachedToActivity(this.activityPluginBinding);
            }
        }
        if (plugin instanceof ServiceAware) {
            ServiceAware serviceAware = (ServiceAware)((Object)plugin);
            this.serviceAwarePlugins.put(plugin.getClass(), serviceAware);
            if (this.isAttachedToService()) {
                serviceAware.onAttachedToService(this.servicePluginBinding);
            }
        }
        if (plugin instanceof BroadcastReceiverAware) {
            BroadcastReceiverAware broadcastReceiverAware = (BroadcastReceiverAware)((Object)plugin);
            this.broadcastReceiverAwarePlugins.put(plugin.getClass(), broadcastReceiverAware);
            if (this.isAttachedToBroadcastReceiver()) {
                broadcastReceiverAware.onAttachedToBroadcastReceiver(this.broadcastReceiverPluginBinding);
            }
        }
        if (plugin instanceof ContentProviderAware) {
            ContentProviderAware contentProviderAware = (ContentProviderAware)((Object)plugin);
            this.contentProviderAwarePlugins.put(plugin.getClass(), contentProviderAware);
            if (this.isAttachedToContentProvider()) {
                contentProviderAware.onAttachedToContentProvider(this.contentProviderPluginBinding);
            }
        }
    }

    @Override
    public void add(@NonNull Set<FlutterPlugin> plugins) {
        for (FlutterPlugin plugin : plugins) {
            this.add(plugin);
        }
    }

    @Override
    public boolean has(@NonNull Class<? extends FlutterPlugin> pluginClass) {
        return this.plugins.containsKey(pluginClass);
    }

    @Override
    public FlutterPlugin get(@NonNull Class<? extends FlutterPlugin> pluginClass) {
        return this.plugins.get(pluginClass);
    }

    @Override
    public void remove(@NonNull Class<? extends FlutterPlugin> pluginClass) {
        FlutterPlugin plugin = this.plugins.get(pluginClass);
        if (plugin != null) {
            Log.v(TAG, "Removing plugin: " + plugin);
            if (plugin instanceof ActivityAware) {
                if (this.isAttachedToActivity()) {
                    ActivityAware activityAware = (ActivityAware)((Object)plugin);
                    activityAware.onDetachedFromActivity();
                }
                this.activityAwarePlugins.remove(pluginClass);
            }
            if (plugin instanceof ServiceAware) {
                if (this.isAttachedToService()) {
                    ServiceAware serviceAware = (ServiceAware)((Object)plugin);
                    serviceAware.onDetachedFromService();
                }
                this.serviceAwarePlugins.remove(pluginClass);
            }
            if (plugin instanceof BroadcastReceiverAware) {
                if (this.isAttachedToBroadcastReceiver()) {
                    BroadcastReceiverAware broadcastReceiverAware = (BroadcastReceiverAware)((Object)plugin);
                    broadcastReceiverAware.onDetachedFromBroadcastReceiver();
                }
                this.broadcastReceiverAwarePlugins.remove(pluginClass);
            }
            if (plugin instanceof ContentProviderAware) {
                if (this.isAttachedToContentProvider()) {
                    ContentProviderAware contentProviderAware = (ContentProviderAware)((Object)plugin);
                    contentProviderAware.onDetachedFromContentProvider();
                }
                this.contentProviderAwarePlugins.remove(pluginClass);
            }
            plugin.onDetachedFromEngine(this.pluginBinding);
            this.plugins.remove(pluginClass);
        }
    }

    @Override
    public void remove(@NonNull Set<Class<? extends FlutterPlugin>> pluginClasses) {
        for (Class<? extends FlutterPlugin> pluginClass : pluginClasses) {
            this.remove(pluginClass);
        }
    }

    @Override
    public void removeAll() {
        this.remove(new HashSet<Class<? extends FlutterPlugin>>(this.plugins.keySet()));
        this.plugins.clear();
    }

    private void detachFromAndroidComponent() {
        if (this.isAttachedToActivity()) {
            this.detachFromActivity();
        } else if (this.isAttachedToService()) {
            this.detachFromService();
        } else if (this.isAttachedToBroadcastReceiver()) {
            this.detachFromBroadcastReceiver();
        } else if (this.isAttachedToContentProvider()) {
            this.detachFromContentProvider();
        }
    }

    private boolean isAttachedToActivity() {
        return this.activity != null;
    }

    @Override
    public void attachToActivity(@NonNull Activity activity, @NonNull Lifecycle lifecycle) {
        Log.v(TAG, "Attaching to an Activity: " + activity + "." + (this.isWaitingForActivityReattachment ? " This is after a config change." : ""));
        this.detachFromAndroidComponent();
        this.activity = activity;
        this.activityPluginBinding = new FlutterEngineActivityPluginBinding(activity);
        this.flutterEngineAndroidLifecycle.setBackingLifecycle(lifecycle);
        this.pluginBinding.getFlutterEngine().getPlatformViewsController().attach((Context)activity, this.pluginBinding.getFlutterEngine().getRenderer(), this.pluginBinding.getFlutterEngine().getDartExecutor());
        for (ActivityAware activityAware : this.activityAwarePlugins.values()) {
            if (this.isWaitingForActivityReattachment) {
                activityAware.onReattachedToActivityForConfigChanges(this.activityPluginBinding);
                continue;
            }
            activityAware.onAttachedToActivity(this.activityPluginBinding);
        }
        this.isWaitingForActivityReattachment = false;
    }

    @Override
    public void detachFromActivityForConfigChanges() {
        if (this.isAttachedToActivity()) {
            Log.v(TAG, "Detaching from an Activity for config changes: " + this.activity);
            this.isWaitingForActivityReattachment = true;
            for (ActivityAware activityAware : this.activityAwarePlugins.values()) {
                activityAware.onDetachedFromActivityForConfigChanges();
            }
            this.pluginBinding.getFlutterEngine().getPlatformViewsController().detach();
            this.flutterEngineAndroidLifecycle.setBackingLifecycle(null);
            this.activity = null;
            this.activityPluginBinding = null;
        } else {
            Log.e(TAG, "Attempted to detach plugins from an Activity when no Activity was attached.");
        }
    }

    @Override
    public void detachFromActivity() {
        if (this.isAttachedToActivity()) {
            Log.v(TAG, "Detaching from an Activity: " + this.activity);
            for (ActivityAware activityAware : this.activityAwarePlugins.values()) {
                activityAware.onDetachedFromActivity();
            }
            this.pluginBinding.getFlutterEngine().getPlatformViewsController().detach();
            this.flutterEngineAndroidLifecycle.setBackingLifecycle(null);
            this.activity = null;
            this.activityPluginBinding = null;
        } else {
            Log.e(TAG, "Attempted to detach plugins from an Activity when no Activity was attached.");
        }
    }

    @Override
    public boolean onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResult) {
        Log.v(TAG, "Forwarding onRequestPermissionsResult() to plugins.");
        if (this.isAttachedToActivity()) {
            return this.activityPluginBinding.onRequestPermissionsResult(requestCode, permissions, grantResult);
        }
        Log.e(TAG, "Attempted to notify ActivityAware plugins of onRequestPermissionsResult, but no Activity was attached.");
        return false;
    }

    @Override
    public boolean onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        Log.v(TAG, "Forwarding onActivityResult() to plugins.");
        if (this.isAttachedToActivity()) {
            return this.activityPluginBinding.onActivityResult(requestCode, resultCode, data);
        }
        Log.e(TAG, "Attempted to notify ActivityAware plugins of onActivityResult, but no Activity was attached.");
        return false;
    }

    @Override
    public void onNewIntent(@NonNull Intent intent) {
        Log.v(TAG, "Forwarding onNewIntent() to plugins.");
        if (this.isAttachedToActivity()) {
            this.activityPluginBinding.onNewIntent(intent);
        } else {
            Log.e(TAG, "Attempted to notify ActivityAware plugins of onNewIntent, but no Activity was attached.");
        }
    }

    @Override
    public void onUserLeaveHint() {
        Log.v(TAG, "Forwarding onUserLeaveHint() to plugins.");
        if (this.isAttachedToActivity()) {
            this.activityPluginBinding.onUserLeaveHint();
        } else {
            Log.e(TAG, "Attempted to notify ActivityAware plugins of onUserLeaveHint, but no Activity was attached.");
        }
    }

    private boolean isAttachedToService() {
        return this.service != null;
    }

    @Override
    public void attachToService(@NonNull Service service, @NonNull Lifecycle lifecycle, boolean isForeground) {
        Log.v(TAG, "Attaching to a Service: " + service);
        this.detachFromAndroidComponent();
        this.service = service;
        this.servicePluginBinding = new FlutterEngineServicePluginBinding(service);
        this.flutterEngineAndroidLifecycle.setBackingLifecycle(lifecycle);
        for (ServiceAware serviceAware : this.serviceAwarePlugins.values()) {
            serviceAware.onAttachedToService(this.servicePluginBinding);
        }
    }

    @Override
    public void detachFromService() {
        if (this.isAttachedToService()) {
            Log.v(TAG, "Detaching from a Service: " + this.service);
            for (ServiceAware serviceAware : this.serviceAwarePlugins.values()) {
                serviceAware.onDetachedFromService();
            }
            this.flutterEngineAndroidLifecycle.setBackingLifecycle(null);
            this.service = null;
            this.servicePluginBinding = null;
        } else {
            Log.e(TAG, "Attempted to detach plugins from a Service when no Service was attached.");
        }
    }

    @Override
    public void onMoveToForeground() {
        if (this.isAttachedToService()) {
            Log.v(TAG, "Attached Service moved to foreground.");
            this.servicePluginBinding.onMoveToForeground();
        }
    }

    @Override
    public void onMoveToBackground() {
        if (this.isAttachedToService()) {
            Log.v(TAG, "Attached Service moved to background.");
            this.servicePluginBinding.onMoveToBackground();
        }
    }

    private boolean isAttachedToBroadcastReceiver() {
        return this.broadcastReceiver != null;
    }

    @Override
    public void attachToBroadcastReceiver(@NonNull BroadcastReceiver broadcastReceiver, @NonNull Lifecycle lifecycle) {
        Log.v(TAG, "Attaching to BroadcastReceiver: " + broadcastReceiver);
        this.detachFromAndroidComponent();
        this.broadcastReceiver = broadcastReceiver;
        this.broadcastReceiverPluginBinding = new FlutterEngineBroadcastReceiverPluginBinding(broadcastReceiver);
        for (BroadcastReceiverAware broadcastReceiverAware : this.broadcastReceiverAwarePlugins.values()) {
            broadcastReceiverAware.onAttachedToBroadcastReceiver(this.broadcastReceiverPluginBinding);
        }
    }

    @Override
    public void detachFromBroadcastReceiver() {
        if (this.isAttachedToBroadcastReceiver()) {
            Log.v(TAG, "Detaching from BroadcastReceiver: " + this.broadcastReceiver);
            for (BroadcastReceiverAware broadcastReceiverAware : this.broadcastReceiverAwarePlugins.values()) {
                broadcastReceiverAware.onDetachedFromBroadcastReceiver();
            }
        } else {
            Log.e(TAG, "Attempted to detach plugins from a BroadcastReceiver when no BroadcastReceiver was attached.");
        }
    }

    private boolean isAttachedToContentProvider() {
        return this.contentProvider != null;
    }

    @Override
    public void attachToContentProvider(@NonNull ContentProvider contentProvider, @NonNull Lifecycle lifecycle) {
        Log.v(TAG, "Attaching to ContentProvider: " + contentProvider);
        this.detachFromAndroidComponent();
        this.contentProvider = contentProvider;
        this.contentProviderPluginBinding = new FlutterEngineContentProviderPluginBinding(contentProvider);
        for (ContentProviderAware contentProviderAware : this.contentProviderAwarePlugins.values()) {
            contentProviderAware.onAttachedToContentProvider(this.contentProviderPluginBinding);
        }
    }

    @Override
    public void detachFromContentProvider() {
        if (this.isAttachedToContentProvider()) {
            Log.v(TAG, "Detaching from ContentProvider: " + this.contentProvider);
            for (ContentProviderAware contentProviderAware : this.contentProviderAwarePlugins.values()) {
                contentProviderAware.onDetachedFromContentProvider();
            }
        } else {
            Log.e(TAG, "Attempted to detach plugins from a ContentProvider when no ContentProvider was attached.");
        }
    }

    private static class FlutterEngineContentProviderPluginBinding
    implements ContentProviderPluginBinding {
        @NonNull
        private final ContentProvider contentProvider;

        FlutterEngineContentProviderPluginBinding(@NonNull ContentProvider contentProvider) {
            this.contentProvider = contentProvider;
        }

        @Override
        @NonNull
        public ContentProvider getContentProvider() {
            return this.contentProvider;
        }
    }

    private static class FlutterEngineBroadcastReceiverPluginBinding
    implements BroadcastReceiverPluginBinding {
        @NonNull
        private final BroadcastReceiver broadcastReceiver;

        FlutterEngineBroadcastReceiverPluginBinding(@NonNull BroadcastReceiver broadcastReceiver) {
            this.broadcastReceiver = broadcastReceiver;
        }

        @Override
        @NonNull
        public BroadcastReceiver getBroadcastReceiver() {
            return this.broadcastReceiver;
        }
    }

    private static class FlutterEngineServicePluginBinding
    implements ServicePluginBinding {
        @NonNull
        private final Service service;
        @NonNull
        private final Set<ServiceAware.OnModeChangeListener> onModeChangeListeners = new HashSet<ServiceAware.OnModeChangeListener>();

        FlutterEngineServicePluginBinding(@NonNull Service service) {
            this.service = service;
        }

        @Override
        @NonNull
        public Service getService() {
            return this.service;
        }

        @Override
        public void addOnModeChangeListener(@NonNull ServiceAware.OnModeChangeListener listener) {
            this.onModeChangeListeners.add(listener);
        }

        @Override
        public void removeOnModeChangeListener(@NonNull ServiceAware.OnModeChangeListener listener) {
            this.onModeChangeListeners.remove(listener);
        }

        void onMoveToForeground() {
            for (ServiceAware.OnModeChangeListener listener : this.onModeChangeListeners) {
                listener.onMoveToForeground();
            }
        }

        void onMoveToBackground() {
            for (ServiceAware.OnModeChangeListener listener : this.onModeChangeListeners) {
                listener.onMoveToBackground();
            }
        }
    }

    private static class FlutterEngineActivityPluginBinding
    implements ActivityPluginBinding {
        @NonNull
        private final Activity activity;
        @NonNull
        private final Set<PluginRegistry.RequestPermissionsResultListener> onRequestPermissionsResultListeners = new HashSet<PluginRegistry.RequestPermissionsResultListener>();
        @NonNull
        private final Set<PluginRegistry.ActivityResultListener> onActivityResultListeners = new HashSet<PluginRegistry.ActivityResultListener>();
        @NonNull
        private final Set<PluginRegistry.NewIntentListener> onNewIntentListeners = new HashSet<PluginRegistry.NewIntentListener>();
        @NonNull
        private final Set<PluginRegistry.UserLeaveHintListener> onUserLeaveHintListeners = new HashSet<PluginRegistry.UserLeaveHintListener>();

        public FlutterEngineActivityPluginBinding(@NonNull Activity activity) {
            this.activity = activity;
        }

        @Override
        @NonNull
        public Activity getActivity() {
            return this.activity;
        }

        @Override
        public void addRequestPermissionsResultListener(@NonNull PluginRegistry.RequestPermissionsResultListener listener) {
            this.onRequestPermissionsResultListeners.add(listener);
        }

        @Override
        public void removeRequestPermissionsResultListener(@NonNull PluginRegistry.RequestPermissionsResultListener listener) {
            this.onRequestPermissionsResultListeners.remove(listener);
        }

        boolean onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResult) {
            boolean didConsumeResult = false;
            for (PluginRegistry.RequestPermissionsResultListener listener : this.onRequestPermissionsResultListeners) {
                didConsumeResult = listener.onRequestPermissionsResult(requestCode, permissions, grantResult) || didConsumeResult;
            }
            return didConsumeResult;
        }

        @Override
        public void addActivityResultListener(@NonNull PluginRegistry.ActivityResultListener listener) {
            this.onActivityResultListeners.add(listener);
        }

        @Override
        public void removeActivityResultListener(@NonNull PluginRegistry.ActivityResultListener listener) {
            this.onActivityResultListeners.remove(listener);
        }

        boolean onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
            boolean didConsumeResult = false;
            for (PluginRegistry.ActivityResultListener listener : this.onActivityResultListeners) {
                didConsumeResult = listener.onActivityResult(requestCode, resultCode, data) || didConsumeResult;
            }
            return didConsumeResult;
        }

        @Override
        public void addOnNewIntentListener(@NonNull PluginRegistry.NewIntentListener listener) {
            this.onNewIntentListeners.add(listener);
        }

        @Override
        public void removeOnNewIntentListener(@NonNull PluginRegistry.NewIntentListener listener) {
            this.onNewIntentListeners.remove(listener);
        }

        void onNewIntent(@Nullable Intent intent) {
            for (PluginRegistry.NewIntentListener listener : this.onNewIntentListeners) {
                listener.onNewIntent(intent);
            }
        }

        @Override
        public void addOnUserLeaveHintListener(@NonNull PluginRegistry.UserLeaveHintListener listener) {
            this.onUserLeaveHintListeners.add(listener);
        }

        @Override
        public void removeOnUserLeaveHintListener(@NonNull PluginRegistry.UserLeaveHintListener listener) {
            this.onUserLeaveHintListeners.remove(listener);
        }

        void onUserLeaveHint() {
            for (PluginRegistry.UserLeaveHintListener listener : this.onUserLeaveHintListeners) {
                listener.onUserLeaveHint();
            }
        }
    }
}

