library googleapis.compute.v1.test;

import "dart:core" as core;
import "dart:async" as async;
import "dart:convert" as convert;

import 'package:http/http.dart' as http;
import 'package:test/test.dart' as unittest;

import 'package:googleapis/compute/v1.dart' as api;

class HttpServerMock extends http.BaseClient {
  core.Function _callback;
  core.bool _expectJson;

  void register(core.Function callback, core.bool expectJson) {
    _callback = callback;
    _expectJson = expectJson;
  }

  async.Future<http.StreamedResponse> send(http.BaseRequest request) {
    if (_expectJson) {
      return request
          .finalize()
          .transform(convert.utf8.decoder)
          .join('')
          .then((core.String jsonString) {
        if (jsonString.isEmpty) {
          return _callback(request, null);
        } else {
          return _callback(request, convert.json.decode(jsonString));
        }
      });
    } else {
      var stream = request.finalize();
      if (stream == null) {
        return _callback(request, []);
      } else {
        return stream.toBytes().then((data) {
          return _callback(request, data);
        });
      }
    }
  }
}

http.StreamedResponse stringResponse(core.int status,
    core.Map<core.String, core.String> headers, core.String body) {
  var stream = new async.Stream.fromIterable([convert.utf8.encode(body)]);
  return new http.StreamedResponse(stream, status, headers: headers);
}

core.int buildCounterAcceleratorConfig = 0;
buildAcceleratorConfig() {
  var o = new api.AcceleratorConfig();
  buildCounterAcceleratorConfig++;
  if (buildCounterAcceleratorConfig < 3) {
    o.acceleratorCount = 42;
    o.acceleratorType = "foo";
  }
  buildCounterAcceleratorConfig--;
  return o;
}

checkAcceleratorConfig(api.AcceleratorConfig o) {
  buildCounterAcceleratorConfig++;
  if (buildCounterAcceleratorConfig < 3) {
    unittest.expect(o.acceleratorCount, unittest.equals(42));
    unittest.expect(o.acceleratorType, unittest.equals('foo'));
  }
  buildCounterAcceleratorConfig--;
}

core.int buildCounterAcceleratorType = 0;
buildAcceleratorType() {
  var o = new api.AcceleratorType();
  buildCounterAcceleratorType++;
  if (buildCounterAcceleratorType < 3) {
    o.creationTimestamp = "foo";
    o.deprecated = buildDeprecationStatus();
    o.description = "foo";
    o.id = "foo";
    o.kind = "foo";
    o.maximumCardsPerInstance = 42;
    o.name = "foo";
    o.selfLink = "foo";
    o.zone = "foo";
  }
  buildCounterAcceleratorType--;
  return o;
}

checkAcceleratorType(api.AcceleratorType o) {
  buildCounterAcceleratorType++;
  if (buildCounterAcceleratorType < 3) {
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    checkDeprecationStatus(o.deprecated);
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.maximumCardsPerInstance, unittest.equals(42));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.zone, unittest.equals('foo'));
  }
  buildCounterAcceleratorType--;
}

buildUnnamed1632() {
  var o = new core.Map<core.String, api.AcceleratorTypesScopedList>();
  o["x"] = buildAcceleratorTypesScopedList();
  o["y"] = buildAcceleratorTypesScopedList();
  return o;
}

checkUnnamed1632(core.Map<core.String, api.AcceleratorTypesScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAcceleratorTypesScopedList(o["x"]);
  checkAcceleratorTypesScopedList(o["y"]);
}

core.int buildCounterAcceleratorTypeAggregatedListWarningData = 0;
buildAcceleratorTypeAggregatedListWarningData() {
  var o = new api.AcceleratorTypeAggregatedListWarningData();
  buildCounterAcceleratorTypeAggregatedListWarningData++;
  if (buildCounterAcceleratorTypeAggregatedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterAcceleratorTypeAggregatedListWarningData--;
  return o;
}

checkAcceleratorTypeAggregatedListWarningData(
    api.AcceleratorTypeAggregatedListWarningData o) {
  buildCounterAcceleratorTypeAggregatedListWarningData++;
  if (buildCounterAcceleratorTypeAggregatedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterAcceleratorTypeAggregatedListWarningData--;
}

buildUnnamed1633() {
  var o = new core.List<api.AcceleratorTypeAggregatedListWarningData>();
  o.add(buildAcceleratorTypeAggregatedListWarningData());
  o.add(buildAcceleratorTypeAggregatedListWarningData());
  return o;
}

checkUnnamed1633(core.List<api.AcceleratorTypeAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAcceleratorTypeAggregatedListWarningData(o[0]);
  checkAcceleratorTypeAggregatedListWarningData(o[1]);
}

core.int buildCounterAcceleratorTypeAggregatedListWarning = 0;
buildAcceleratorTypeAggregatedListWarning() {
  var o = new api.AcceleratorTypeAggregatedListWarning();
  buildCounterAcceleratorTypeAggregatedListWarning++;
  if (buildCounterAcceleratorTypeAggregatedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1633();
    o.message = "foo";
  }
  buildCounterAcceleratorTypeAggregatedListWarning--;
  return o;
}

checkAcceleratorTypeAggregatedListWarning(
    api.AcceleratorTypeAggregatedListWarning o) {
  buildCounterAcceleratorTypeAggregatedListWarning++;
  if (buildCounterAcceleratorTypeAggregatedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1633(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterAcceleratorTypeAggregatedListWarning--;
}

core.int buildCounterAcceleratorTypeAggregatedList = 0;
buildAcceleratorTypeAggregatedList() {
  var o = new api.AcceleratorTypeAggregatedList();
  buildCounterAcceleratorTypeAggregatedList++;
  if (buildCounterAcceleratorTypeAggregatedList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1632();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildAcceleratorTypeAggregatedListWarning();
  }
  buildCounterAcceleratorTypeAggregatedList--;
  return o;
}

checkAcceleratorTypeAggregatedList(api.AcceleratorTypeAggregatedList o) {
  buildCounterAcceleratorTypeAggregatedList++;
  if (buildCounterAcceleratorTypeAggregatedList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1632(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkAcceleratorTypeAggregatedListWarning(o.warning);
  }
  buildCounterAcceleratorTypeAggregatedList--;
}

buildUnnamed1634() {
  var o = new core.List<api.AcceleratorType>();
  o.add(buildAcceleratorType());
  o.add(buildAcceleratorType());
  return o;
}

checkUnnamed1634(core.List<api.AcceleratorType> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAcceleratorType(o[0]);
  checkAcceleratorType(o[1]);
}

core.int buildCounterAcceleratorTypeListWarningData = 0;
buildAcceleratorTypeListWarningData() {
  var o = new api.AcceleratorTypeListWarningData();
  buildCounterAcceleratorTypeListWarningData++;
  if (buildCounterAcceleratorTypeListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterAcceleratorTypeListWarningData--;
  return o;
}

checkAcceleratorTypeListWarningData(api.AcceleratorTypeListWarningData o) {
  buildCounterAcceleratorTypeListWarningData++;
  if (buildCounterAcceleratorTypeListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterAcceleratorTypeListWarningData--;
}

buildUnnamed1635() {
  var o = new core.List<api.AcceleratorTypeListWarningData>();
  o.add(buildAcceleratorTypeListWarningData());
  o.add(buildAcceleratorTypeListWarningData());
  return o;
}

checkUnnamed1635(core.List<api.AcceleratorTypeListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAcceleratorTypeListWarningData(o[0]);
  checkAcceleratorTypeListWarningData(o[1]);
}

core.int buildCounterAcceleratorTypeListWarning = 0;
buildAcceleratorTypeListWarning() {
  var o = new api.AcceleratorTypeListWarning();
  buildCounterAcceleratorTypeListWarning++;
  if (buildCounterAcceleratorTypeListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1635();
    o.message = "foo";
  }
  buildCounterAcceleratorTypeListWarning--;
  return o;
}

checkAcceleratorTypeListWarning(api.AcceleratorTypeListWarning o) {
  buildCounterAcceleratorTypeListWarning++;
  if (buildCounterAcceleratorTypeListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1635(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterAcceleratorTypeListWarning--;
}

core.int buildCounterAcceleratorTypeList = 0;
buildAcceleratorTypeList() {
  var o = new api.AcceleratorTypeList();
  buildCounterAcceleratorTypeList++;
  if (buildCounterAcceleratorTypeList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1634();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildAcceleratorTypeListWarning();
  }
  buildCounterAcceleratorTypeList--;
  return o;
}

checkAcceleratorTypeList(api.AcceleratorTypeList o) {
  buildCounterAcceleratorTypeList++;
  if (buildCounterAcceleratorTypeList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1634(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkAcceleratorTypeListWarning(o.warning);
  }
  buildCounterAcceleratorTypeList--;
}

buildUnnamed1636() {
  var o = new core.List<api.AcceleratorType>();
  o.add(buildAcceleratorType());
  o.add(buildAcceleratorType());
  return o;
}

checkUnnamed1636(core.List<api.AcceleratorType> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAcceleratorType(o[0]);
  checkAcceleratorType(o[1]);
}

core.int buildCounterAcceleratorTypesScopedListWarningData = 0;
buildAcceleratorTypesScopedListWarningData() {
  var o = new api.AcceleratorTypesScopedListWarningData();
  buildCounterAcceleratorTypesScopedListWarningData++;
  if (buildCounterAcceleratorTypesScopedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterAcceleratorTypesScopedListWarningData--;
  return o;
}

checkAcceleratorTypesScopedListWarningData(
    api.AcceleratorTypesScopedListWarningData o) {
  buildCounterAcceleratorTypesScopedListWarningData++;
  if (buildCounterAcceleratorTypesScopedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterAcceleratorTypesScopedListWarningData--;
}

buildUnnamed1637() {
  var o = new core.List<api.AcceleratorTypesScopedListWarningData>();
  o.add(buildAcceleratorTypesScopedListWarningData());
  o.add(buildAcceleratorTypesScopedListWarningData());
  return o;
}

checkUnnamed1637(core.List<api.AcceleratorTypesScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAcceleratorTypesScopedListWarningData(o[0]);
  checkAcceleratorTypesScopedListWarningData(o[1]);
}

core.int buildCounterAcceleratorTypesScopedListWarning = 0;
buildAcceleratorTypesScopedListWarning() {
  var o = new api.AcceleratorTypesScopedListWarning();
  buildCounterAcceleratorTypesScopedListWarning++;
  if (buildCounterAcceleratorTypesScopedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1637();
    o.message = "foo";
  }
  buildCounterAcceleratorTypesScopedListWarning--;
  return o;
}

checkAcceleratorTypesScopedListWarning(
    api.AcceleratorTypesScopedListWarning o) {
  buildCounterAcceleratorTypesScopedListWarning++;
  if (buildCounterAcceleratorTypesScopedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1637(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterAcceleratorTypesScopedListWarning--;
}

core.int buildCounterAcceleratorTypesScopedList = 0;
buildAcceleratorTypesScopedList() {
  var o = new api.AcceleratorTypesScopedList();
  buildCounterAcceleratorTypesScopedList++;
  if (buildCounterAcceleratorTypesScopedList < 3) {
    o.acceleratorTypes = buildUnnamed1636();
    o.warning = buildAcceleratorTypesScopedListWarning();
  }
  buildCounterAcceleratorTypesScopedList--;
  return o;
}

checkAcceleratorTypesScopedList(api.AcceleratorTypesScopedList o) {
  buildCounterAcceleratorTypesScopedList++;
  if (buildCounterAcceleratorTypesScopedList < 3) {
    checkUnnamed1636(o.acceleratorTypes);
    checkAcceleratorTypesScopedListWarning(o.warning);
  }
  buildCounterAcceleratorTypesScopedList--;
}

core.int buildCounterAccessConfig = 0;
buildAccessConfig() {
  var o = new api.AccessConfig();
  buildCounterAccessConfig++;
  if (buildCounterAccessConfig < 3) {
    o.kind = "foo";
    o.name = "foo";
    o.natIP = "foo";
    o.networkTier = "foo";
    o.publicPtrDomainName = "foo";
    o.setPublicPtr = true;
    o.type = "foo";
  }
  buildCounterAccessConfig--;
  return o;
}

checkAccessConfig(api.AccessConfig o) {
  buildCounterAccessConfig++;
  if (buildCounterAccessConfig < 3) {
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.natIP, unittest.equals('foo'));
    unittest.expect(o.networkTier, unittest.equals('foo'));
    unittest.expect(o.publicPtrDomainName, unittest.equals('foo'));
    unittest.expect(o.setPublicPtr, unittest.isTrue);
    unittest.expect(o.type, unittest.equals('foo'));
  }
  buildCounterAccessConfig--;
}

buildUnnamed1638() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1638(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterAddress = 0;
buildAddress() {
  var o = new api.Address();
  buildCounterAddress++;
  if (buildCounterAddress < 3) {
    o.address = "foo";
    o.addressType = "foo";
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.id = "foo";
    o.ipVersion = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.network = "foo";
    o.networkTier = "foo";
    o.prefixLength = 42;
    o.purpose = "foo";
    o.region = "foo";
    o.selfLink = "foo";
    o.status = "foo";
    o.subnetwork = "foo";
    o.users = buildUnnamed1638();
  }
  buildCounterAddress--;
  return o;
}

checkAddress(api.Address o) {
  buildCounterAddress++;
  if (buildCounterAddress < 3) {
    unittest.expect(o.address, unittest.equals('foo'));
    unittest.expect(o.addressType, unittest.equals('foo'));
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.ipVersion, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.network, unittest.equals('foo'));
    unittest.expect(o.networkTier, unittest.equals('foo'));
    unittest.expect(o.prefixLength, unittest.equals(42));
    unittest.expect(o.purpose, unittest.equals('foo'));
    unittest.expect(o.region, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.status, unittest.equals('foo'));
    unittest.expect(o.subnetwork, unittest.equals('foo'));
    checkUnnamed1638(o.users);
  }
  buildCounterAddress--;
}

buildUnnamed1639() {
  var o = new core.Map<core.String, api.AddressesScopedList>();
  o["x"] = buildAddressesScopedList();
  o["y"] = buildAddressesScopedList();
  return o;
}

checkUnnamed1639(core.Map<core.String, api.AddressesScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAddressesScopedList(o["x"]);
  checkAddressesScopedList(o["y"]);
}

core.int buildCounterAddressAggregatedListWarningData = 0;
buildAddressAggregatedListWarningData() {
  var o = new api.AddressAggregatedListWarningData();
  buildCounterAddressAggregatedListWarningData++;
  if (buildCounterAddressAggregatedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterAddressAggregatedListWarningData--;
  return o;
}

checkAddressAggregatedListWarningData(api.AddressAggregatedListWarningData o) {
  buildCounterAddressAggregatedListWarningData++;
  if (buildCounterAddressAggregatedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterAddressAggregatedListWarningData--;
}

buildUnnamed1640() {
  var o = new core.List<api.AddressAggregatedListWarningData>();
  o.add(buildAddressAggregatedListWarningData());
  o.add(buildAddressAggregatedListWarningData());
  return o;
}

checkUnnamed1640(core.List<api.AddressAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAddressAggregatedListWarningData(o[0]);
  checkAddressAggregatedListWarningData(o[1]);
}

core.int buildCounterAddressAggregatedListWarning = 0;
buildAddressAggregatedListWarning() {
  var o = new api.AddressAggregatedListWarning();
  buildCounterAddressAggregatedListWarning++;
  if (buildCounterAddressAggregatedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1640();
    o.message = "foo";
  }
  buildCounterAddressAggregatedListWarning--;
  return o;
}

checkAddressAggregatedListWarning(api.AddressAggregatedListWarning o) {
  buildCounterAddressAggregatedListWarning++;
  if (buildCounterAddressAggregatedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1640(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterAddressAggregatedListWarning--;
}

core.int buildCounterAddressAggregatedList = 0;
buildAddressAggregatedList() {
  var o = new api.AddressAggregatedList();
  buildCounterAddressAggregatedList++;
  if (buildCounterAddressAggregatedList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1639();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildAddressAggregatedListWarning();
  }
  buildCounterAddressAggregatedList--;
  return o;
}

checkAddressAggregatedList(api.AddressAggregatedList o) {
  buildCounterAddressAggregatedList++;
  if (buildCounterAddressAggregatedList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1639(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkAddressAggregatedListWarning(o.warning);
  }
  buildCounterAddressAggregatedList--;
}

buildUnnamed1641() {
  var o = new core.List<api.Address>();
  o.add(buildAddress());
  o.add(buildAddress());
  return o;
}

checkUnnamed1641(core.List<api.Address> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAddress(o[0]);
  checkAddress(o[1]);
}

core.int buildCounterAddressListWarningData = 0;
buildAddressListWarningData() {
  var o = new api.AddressListWarningData();
  buildCounterAddressListWarningData++;
  if (buildCounterAddressListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterAddressListWarningData--;
  return o;
}

checkAddressListWarningData(api.AddressListWarningData o) {
  buildCounterAddressListWarningData++;
  if (buildCounterAddressListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterAddressListWarningData--;
}

buildUnnamed1642() {
  var o = new core.List<api.AddressListWarningData>();
  o.add(buildAddressListWarningData());
  o.add(buildAddressListWarningData());
  return o;
}

checkUnnamed1642(core.List<api.AddressListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAddressListWarningData(o[0]);
  checkAddressListWarningData(o[1]);
}

core.int buildCounterAddressListWarning = 0;
buildAddressListWarning() {
  var o = new api.AddressListWarning();
  buildCounterAddressListWarning++;
  if (buildCounterAddressListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1642();
    o.message = "foo";
  }
  buildCounterAddressListWarning--;
  return o;
}

checkAddressListWarning(api.AddressListWarning o) {
  buildCounterAddressListWarning++;
  if (buildCounterAddressListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1642(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterAddressListWarning--;
}

core.int buildCounterAddressList = 0;
buildAddressList() {
  var o = new api.AddressList();
  buildCounterAddressList++;
  if (buildCounterAddressList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1641();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildAddressListWarning();
  }
  buildCounterAddressList--;
  return o;
}

checkAddressList(api.AddressList o) {
  buildCounterAddressList++;
  if (buildCounterAddressList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1641(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkAddressListWarning(o.warning);
  }
  buildCounterAddressList--;
}

buildUnnamed1643() {
  var o = new core.List<api.Address>();
  o.add(buildAddress());
  o.add(buildAddress());
  return o;
}

checkUnnamed1643(core.List<api.Address> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAddress(o[0]);
  checkAddress(o[1]);
}

core.int buildCounterAddressesScopedListWarningData = 0;
buildAddressesScopedListWarningData() {
  var o = new api.AddressesScopedListWarningData();
  buildCounterAddressesScopedListWarningData++;
  if (buildCounterAddressesScopedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterAddressesScopedListWarningData--;
  return o;
}

checkAddressesScopedListWarningData(api.AddressesScopedListWarningData o) {
  buildCounterAddressesScopedListWarningData++;
  if (buildCounterAddressesScopedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterAddressesScopedListWarningData--;
}

buildUnnamed1644() {
  var o = new core.List<api.AddressesScopedListWarningData>();
  o.add(buildAddressesScopedListWarningData());
  o.add(buildAddressesScopedListWarningData());
  return o;
}

checkUnnamed1644(core.List<api.AddressesScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAddressesScopedListWarningData(o[0]);
  checkAddressesScopedListWarningData(o[1]);
}

core.int buildCounterAddressesScopedListWarning = 0;
buildAddressesScopedListWarning() {
  var o = new api.AddressesScopedListWarning();
  buildCounterAddressesScopedListWarning++;
  if (buildCounterAddressesScopedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1644();
    o.message = "foo";
  }
  buildCounterAddressesScopedListWarning--;
  return o;
}

checkAddressesScopedListWarning(api.AddressesScopedListWarning o) {
  buildCounterAddressesScopedListWarning++;
  if (buildCounterAddressesScopedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1644(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterAddressesScopedListWarning--;
}

core.int buildCounterAddressesScopedList = 0;
buildAddressesScopedList() {
  var o = new api.AddressesScopedList();
  buildCounterAddressesScopedList++;
  if (buildCounterAddressesScopedList < 3) {
    o.addresses = buildUnnamed1643();
    o.warning = buildAddressesScopedListWarning();
  }
  buildCounterAddressesScopedList--;
  return o;
}

checkAddressesScopedList(api.AddressesScopedList o) {
  buildCounterAddressesScopedList++;
  if (buildCounterAddressesScopedList < 3) {
    checkUnnamed1643(o.addresses);
    checkAddressesScopedListWarning(o.warning);
  }
  buildCounterAddressesScopedList--;
}

core.int buildCounterAliasIpRange = 0;
buildAliasIpRange() {
  var o = new api.AliasIpRange();
  buildCounterAliasIpRange++;
  if (buildCounterAliasIpRange < 3) {
    o.ipCidrRange = "foo";
    o.subnetworkRangeName = "foo";
  }
  buildCounterAliasIpRange--;
  return o;
}

checkAliasIpRange(api.AliasIpRange o) {
  buildCounterAliasIpRange++;
  if (buildCounterAliasIpRange < 3) {
    unittest.expect(o.ipCidrRange, unittest.equals('foo'));
    unittest.expect(o.subnetworkRangeName, unittest.equals('foo'));
  }
  buildCounterAliasIpRange--;
}

core.int
    buildCounterAllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk =
    0;
buildAllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk() {
  var o = new api
      .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk();
  buildCounterAllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk++;
  if (buildCounterAllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk <
      3) {
    o.diskSizeGb = "foo";
    o.interface = "foo";
  }
  buildCounterAllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk--;
  return o;
}

checkAllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk(
    api.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk
        o) {
  buildCounterAllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk++;
  if (buildCounterAllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk <
      3) {
    unittest.expect(o.diskSizeGb, unittest.equals('foo'));
    unittest.expect(o.interface, unittest.equals('foo'));
  }
  buildCounterAllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk--;
}

buildUnnamed1645() {
  var o = new core.List<api.AcceleratorConfig>();
  o.add(buildAcceleratorConfig());
  o.add(buildAcceleratorConfig());
  return o;
}

checkUnnamed1645(core.List<api.AcceleratorConfig> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAcceleratorConfig(o[0]);
  checkAcceleratorConfig(o[1]);
}

buildUnnamed1646() {
  var o = new core.List<
      api.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk>();
  o.add(
      buildAllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk());
  o.add(
      buildAllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk());
  return o;
}

checkUnnamed1646(
    core.List<
            api.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk>
        o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk(
      o[0]);
  checkAllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk(
      o[1]);
}

core.int buildCounterAllocationSpecificSKUAllocationReservedInstanceProperties =
    0;
buildAllocationSpecificSKUAllocationReservedInstanceProperties() {
  var o = new api.AllocationSpecificSKUAllocationReservedInstanceProperties();
  buildCounterAllocationSpecificSKUAllocationReservedInstanceProperties++;
  if (buildCounterAllocationSpecificSKUAllocationReservedInstanceProperties <
      3) {
    o.guestAccelerators = buildUnnamed1645();
    o.localSsds = buildUnnamed1646();
    o.machineType = "foo";
    o.minCpuPlatform = "foo";
  }
  buildCounterAllocationSpecificSKUAllocationReservedInstanceProperties--;
  return o;
}

checkAllocationSpecificSKUAllocationReservedInstanceProperties(
    api.AllocationSpecificSKUAllocationReservedInstanceProperties o) {
  buildCounterAllocationSpecificSKUAllocationReservedInstanceProperties++;
  if (buildCounterAllocationSpecificSKUAllocationReservedInstanceProperties <
      3) {
    checkUnnamed1645(o.guestAccelerators);
    checkUnnamed1646(o.localSsds);
    unittest.expect(o.machineType, unittest.equals('foo'));
    unittest.expect(o.minCpuPlatform, unittest.equals('foo'));
  }
  buildCounterAllocationSpecificSKUAllocationReservedInstanceProperties--;
}

core.int buildCounterAllocationSpecificSKUReservation = 0;
buildAllocationSpecificSKUReservation() {
  var o = new api.AllocationSpecificSKUReservation();
  buildCounterAllocationSpecificSKUReservation++;
  if (buildCounterAllocationSpecificSKUReservation < 3) {
    o.count = "foo";
    o.inUseCount = "foo";
    o.instanceProperties =
        buildAllocationSpecificSKUAllocationReservedInstanceProperties();
  }
  buildCounterAllocationSpecificSKUReservation--;
  return o;
}

checkAllocationSpecificSKUReservation(api.AllocationSpecificSKUReservation o) {
  buildCounterAllocationSpecificSKUReservation++;
  if (buildCounterAllocationSpecificSKUReservation < 3) {
    unittest.expect(o.count, unittest.equals('foo'));
    unittest.expect(o.inUseCount, unittest.equals('foo'));
    checkAllocationSpecificSKUAllocationReservedInstanceProperties(
        o.instanceProperties);
  }
  buildCounterAllocationSpecificSKUReservation--;
}

buildUnnamed1647() {
  var o = new core.List<api.GuestOsFeature>();
  o.add(buildGuestOsFeature());
  o.add(buildGuestOsFeature());
  return o;
}

checkUnnamed1647(core.List<api.GuestOsFeature> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkGuestOsFeature(o[0]);
  checkGuestOsFeature(o[1]);
}

buildUnnamed1648() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1648(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterAttachedDisk = 0;
buildAttachedDisk() {
  var o = new api.AttachedDisk();
  buildCounterAttachedDisk++;
  if (buildCounterAttachedDisk < 3) {
    o.autoDelete = true;
    o.boot = true;
    o.deviceName = "foo";
    o.diskEncryptionKey = buildCustomerEncryptionKey();
    o.guestOsFeatures = buildUnnamed1647();
    o.index = 42;
    o.initializeParams = buildAttachedDiskInitializeParams();
    o.interface = "foo";
    o.kind = "foo";
    o.licenses = buildUnnamed1648();
    o.mode = "foo";
    o.source = "foo";
    o.type = "foo";
  }
  buildCounterAttachedDisk--;
  return o;
}

checkAttachedDisk(api.AttachedDisk o) {
  buildCounterAttachedDisk++;
  if (buildCounterAttachedDisk < 3) {
    unittest.expect(o.autoDelete, unittest.isTrue);
    unittest.expect(o.boot, unittest.isTrue);
    unittest.expect(o.deviceName, unittest.equals('foo'));
    checkCustomerEncryptionKey(o.diskEncryptionKey);
    checkUnnamed1647(o.guestOsFeatures);
    unittest.expect(o.index, unittest.equals(42));
    checkAttachedDiskInitializeParams(o.initializeParams);
    unittest.expect(o.interface, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    checkUnnamed1648(o.licenses);
    unittest.expect(o.mode, unittest.equals('foo'));
    unittest.expect(o.source, unittest.equals('foo'));
    unittest.expect(o.type, unittest.equals('foo'));
  }
  buildCounterAttachedDisk--;
}

buildUnnamed1649() {
  var o = new core.Map<core.String, core.String>();
  o["x"] = "foo";
  o["y"] = "foo";
  return o;
}

checkUnnamed1649(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o["x"], unittest.equals('foo'));
  unittest.expect(o["y"], unittest.equals('foo'));
}

buildUnnamed1650() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1650(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterAttachedDiskInitializeParams = 0;
buildAttachedDiskInitializeParams() {
  var o = new api.AttachedDiskInitializeParams();
  buildCounterAttachedDiskInitializeParams++;
  if (buildCounterAttachedDiskInitializeParams < 3) {
    o.description = "foo";
    o.diskName = "foo";
    o.diskSizeGb = "foo";
    o.diskType = "foo";
    o.labels = buildUnnamed1649();
    o.resourcePolicies = buildUnnamed1650();
    o.sourceImage = "foo";
    o.sourceImageEncryptionKey = buildCustomerEncryptionKey();
    o.sourceSnapshot = "foo";
    o.sourceSnapshotEncryptionKey = buildCustomerEncryptionKey();
  }
  buildCounterAttachedDiskInitializeParams--;
  return o;
}

checkAttachedDiskInitializeParams(api.AttachedDiskInitializeParams o) {
  buildCounterAttachedDiskInitializeParams++;
  if (buildCounterAttachedDiskInitializeParams < 3) {
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.diskName, unittest.equals('foo'));
    unittest.expect(o.diskSizeGb, unittest.equals('foo'));
    unittest.expect(o.diskType, unittest.equals('foo'));
    checkUnnamed1649(o.labels);
    checkUnnamed1650(o.resourcePolicies);
    unittest.expect(o.sourceImage, unittest.equals('foo'));
    checkCustomerEncryptionKey(o.sourceImageEncryptionKey);
    unittest.expect(o.sourceSnapshot, unittest.equals('foo'));
    checkCustomerEncryptionKey(o.sourceSnapshotEncryptionKey);
  }
  buildCounterAttachedDiskInitializeParams--;
}

buildUnnamed1651() {
  var o = new core.List<api.AuditLogConfig>();
  o.add(buildAuditLogConfig());
  o.add(buildAuditLogConfig());
  return o;
}

checkUnnamed1651(core.List<api.AuditLogConfig> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAuditLogConfig(o[0]);
  checkAuditLogConfig(o[1]);
}

buildUnnamed1652() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1652(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterAuditConfig = 0;
buildAuditConfig() {
  var o = new api.AuditConfig();
  buildCounterAuditConfig++;
  if (buildCounterAuditConfig < 3) {
    o.auditLogConfigs = buildUnnamed1651();
    o.exemptedMembers = buildUnnamed1652();
    o.service = "foo";
  }
  buildCounterAuditConfig--;
  return o;
}

checkAuditConfig(api.AuditConfig o) {
  buildCounterAuditConfig++;
  if (buildCounterAuditConfig < 3) {
    checkUnnamed1651(o.auditLogConfigs);
    checkUnnamed1652(o.exemptedMembers);
    unittest.expect(o.service, unittest.equals('foo'));
  }
  buildCounterAuditConfig--;
}

buildUnnamed1653() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1653(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterAuditLogConfig = 0;
buildAuditLogConfig() {
  var o = new api.AuditLogConfig();
  buildCounterAuditLogConfig++;
  if (buildCounterAuditLogConfig < 3) {
    o.exemptedMembers = buildUnnamed1653();
    o.logType = "foo";
  }
  buildCounterAuditLogConfig--;
  return o;
}

checkAuditLogConfig(api.AuditLogConfig o) {
  buildCounterAuditLogConfig++;
  if (buildCounterAuditLogConfig < 3) {
    checkUnnamed1653(o.exemptedMembers);
    unittest.expect(o.logType, unittest.equals('foo'));
  }
  buildCounterAuditLogConfig--;
}

core.int buildCounterAuthorizationLoggingOptions = 0;
buildAuthorizationLoggingOptions() {
  var o = new api.AuthorizationLoggingOptions();
  buildCounterAuthorizationLoggingOptions++;
  if (buildCounterAuthorizationLoggingOptions < 3) {
    o.permissionType = "foo";
  }
  buildCounterAuthorizationLoggingOptions--;
  return o;
}

checkAuthorizationLoggingOptions(api.AuthorizationLoggingOptions o) {
  buildCounterAuthorizationLoggingOptions++;
  if (buildCounterAuthorizationLoggingOptions < 3) {
    unittest.expect(o.permissionType, unittest.equals('foo'));
  }
  buildCounterAuthorizationLoggingOptions--;
}

buildUnnamed1654() {
  var o = new core.List<api.AutoscalerStatusDetails>();
  o.add(buildAutoscalerStatusDetails());
  o.add(buildAutoscalerStatusDetails());
  return o;
}

checkUnnamed1654(core.List<api.AutoscalerStatusDetails> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAutoscalerStatusDetails(o[0]);
  checkAutoscalerStatusDetails(o[1]);
}

core.int buildCounterAutoscaler = 0;
buildAutoscaler() {
  var o = new api.Autoscaler();
  buildCounterAutoscaler++;
  if (buildCounterAutoscaler < 3) {
    o.autoscalingPolicy = buildAutoscalingPolicy();
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.id = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.region = "foo";
    o.selfLink = "foo";
    o.status = "foo";
    o.statusDetails = buildUnnamed1654();
    o.target = "foo";
    o.zone = "foo";
  }
  buildCounterAutoscaler--;
  return o;
}

checkAutoscaler(api.Autoscaler o) {
  buildCounterAutoscaler++;
  if (buildCounterAutoscaler < 3) {
    checkAutoscalingPolicy(o.autoscalingPolicy);
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.region, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.status, unittest.equals('foo'));
    checkUnnamed1654(o.statusDetails);
    unittest.expect(o.target, unittest.equals('foo'));
    unittest.expect(o.zone, unittest.equals('foo'));
  }
  buildCounterAutoscaler--;
}

buildUnnamed1655() {
  var o = new core.Map<core.String, api.AutoscalersScopedList>();
  o["x"] = buildAutoscalersScopedList();
  o["y"] = buildAutoscalersScopedList();
  return o;
}

checkUnnamed1655(core.Map<core.String, api.AutoscalersScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAutoscalersScopedList(o["x"]);
  checkAutoscalersScopedList(o["y"]);
}

core.int buildCounterAutoscalerAggregatedListWarningData = 0;
buildAutoscalerAggregatedListWarningData() {
  var o = new api.AutoscalerAggregatedListWarningData();
  buildCounterAutoscalerAggregatedListWarningData++;
  if (buildCounterAutoscalerAggregatedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterAutoscalerAggregatedListWarningData--;
  return o;
}

checkAutoscalerAggregatedListWarningData(
    api.AutoscalerAggregatedListWarningData o) {
  buildCounterAutoscalerAggregatedListWarningData++;
  if (buildCounterAutoscalerAggregatedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterAutoscalerAggregatedListWarningData--;
}

buildUnnamed1656() {
  var o = new core.List<api.AutoscalerAggregatedListWarningData>();
  o.add(buildAutoscalerAggregatedListWarningData());
  o.add(buildAutoscalerAggregatedListWarningData());
  return o;
}

checkUnnamed1656(core.List<api.AutoscalerAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAutoscalerAggregatedListWarningData(o[0]);
  checkAutoscalerAggregatedListWarningData(o[1]);
}

core.int buildCounterAutoscalerAggregatedListWarning = 0;
buildAutoscalerAggregatedListWarning() {
  var o = new api.AutoscalerAggregatedListWarning();
  buildCounterAutoscalerAggregatedListWarning++;
  if (buildCounterAutoscalerAggregatedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1656();
    o.message = "foo";
  }
  buildCounterAutoscalerAggregatedListWarning--;
  return o;
}

checkAutoscalerAggregatedListWarning(api.AutoscalerAggregatedListWarning o) {
  buildCounterAutoscalerAggregatedListWarning++;
  if (buildCounterAutoscalerAggregatedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1656(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterAutoscalerAggregatedListWarning--;
}

core.int buildCounterAutoscalerAggregatedList = 0;
buildAutoscalerAggregatedList() {
  var o = new api.AutoscalerAggregatedList();
  buildCounterAutoscalerAggregatedList++;
  if (buildCounterAutoscalerAggregatedList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1655();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildAutoscalerAggregatedListWarning();
  }
  buildCounterAutoscalerAggregatedList--;
  return o;
}

checkAutoscalerAggregatedList(api.AutoscalerAggregatedList o) {
  buildCounterAutoscalerAggregatedList++;
  if (buildCounterAutoscalerAggregatedList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1655(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkAutoscalerAggregatedListWarning(o.warning);
  }
  buildCounterAutoscalerAggregatedList--;
}

buildUnnamed1657() {
  var o = new core.List<api.Autoscaler>();
  o.add(buildAutoscaler());
  o.add(buildAutoscaler());
  return o;
}

checkUnnamed1657(core.List<api.Autoscaler> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAutoscaler(o[0]);
  checkAutoscaler(o[1]);
}

core.int buildCounterAutoscalerListWarningData = 0;
buildAutoscalerListWarningData() {
  var o = new api.AutoscalerListWarningData();
  buildCounterAutoscalerListWarningData++;
  if (buildCounterAutoscalerListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterAutoscalerListWarningData--;
  return o;
}

checkAutoscalerListWarningData(api.AutoscalerListWarningData o) {
  buildCounterAutoscalerListWarningData++;
  if (buildCounterAutoscalerListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterAutoscalerListWarningData--;
}

buildUnnamed1658() {
  var o = new core.List<api.AutoscalerListWarningData>();
  o.add(buildAutoscalerListWarningData());
  o.add(buildAutoscalerListWarningData());
  return o;
}

checkUnnamed1658(core.List<api.AutoscalerListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAutoscalerListWarningData(o[0]);
  checkAutoscalerListWarningData(o[1]);
}

core.int buildCounterAutoscalerListWarning = 0;
buildAutoscalerListWarning() {
  var o = new api.AutoscalerListWarning();
  buildCounterAutoscalerListWarning++;
  if (buildCounterAutoscalerListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1658();
    o.message = "foo";
  }
  buildCounterAutoscalerListWarning--;
  return o;
}

checkAutoscalerListWarning(api.AutoscalerListWarning o) {
  buildCounterAutoscalerListWarning++;
  if (buildCounterAutoscalerListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1658(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterAutoscalerListWarning--;
}

core.int buildCounterAutoscalerList = 0;
buildAutoscalerList() {
  var o = new api.AutoscalerList();
  buildCounterAutoscalerList++;
  if (buildCounterAutoscalerList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1657();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildAutoscalerListWarning();
  }
  buildCounterAutoscalerList--;
  return o;
}

checkAutoscalerList(api.AutoscalerList o) {
  buildCounterAutoscalerList++;
  if (buildCounterAutoscalerList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1657(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkAutoscalerListWarning(o.warning);
  }
  buildCounterAutoscalerList--;
}

core.int buildCounterAutoscalerStatusDetails = 0;
buildAutoscalerStatusDetails() {
  var o = new api.AutoscalerStatusDetails();
  buildCounterAutoscalerStatusDetails++;
  if (buildCounterAutoscalerStatusDetails < 3) {
    o.message = "foo";
    o.type = "foo";
  }
  buildCounterAutoscalerStatusDetails--;
  return o;
}

checkAutoscalerStatusDetails(api.AutoscalerStatusDetails o) {
  buildCounterAutoscalerStatusDetails++;
  if (buildCounterAutoscalerStatusDetails < 3) {
    unittest.expect(o.message, unittest.equals('foo'));
    unittest.expect(o.type, unittest.equals('foo'));
  }
  buildCounterAutoscalerStatusDetails--;
}

buildUnnamed1659() {
  var o = new core.List<api.Autoscaler>();
  o.add(buildAutoscaler());
  o.add(buildAutoscaler());
  return o;
}

checkUnnamed1659(core.List<api.Autoscaler> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAutoscaler(o[0]);
  checkAutoscaler(o[1]);
}

core.int buildCounterAutoscalersScopedListWarningData = 0;
buildAutoscalersScopedListWarningData() {
  var o = new api.AutoscalersScopedListWarningData();
  buildCounterAutoscalersScopedListWarningData++;
  if (buildCounterAutoscalersScopedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterAutoscalersScopedListWarningData--;
  return o;
}

checkAutoscalersScopedListWarningData(api.AutoscalersScopedListWarningData o) {
  buildCounterAutoscalersScopedListWarningData++;
  if (buildCounterAutoscalersScopedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterAutoscalersScopedListWarningData--;
}

buildUnnamed1660() {
  var o = new core.List<api.AutoscalersScopedListWarningData>();
  o.add(buildAutoscalersScopedListWarningData());
  o.add(buildAutoscalersScopedListWarningData());
  return o;
}

checkUnnamed1660(core.List<api.AutoscalersScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAutoscalersScopedListWarningData(o[0]);
  checkAutoscalersScopedListWarningData(o[1]);
}

core.int buildCounterAutoscalersScopedListWarning = 0;
buildAutoscalersScopedListWarning() {
  var o = new api.AutoscalersScopedListWarning();
  buildCounterAutoscalersScopedListWarning++;
  if (buildCounterAutoscalersScopedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1660();
    o.message = "foo";
  }
  buildCounterAutoscalersScopedListWarning--;
  return o;
}

checkAutoscalersScopedListWarning(api.AutoscalersScopedListWarning o) {
  buildCounterAutoscalersScopedListWarning++;
  if (buildCounterAutoscalersScopedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1660(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterAutoscalersScopedListWarning--;
}

core.int buildCounterAutoscalersScopedList = 0;
buildAutoscalersScopedList() {
  var o = new api.AutoscalersScopedList();
  buildCounterAutoscalersScopedList++;
  if (buildCounterAutoscalersScopedList < 3) {
    o.autoscalers = buildUnnamed1659();
    o.warning = buildAutoscalersScopedListWarning();
  }
  buildCounterAutoscalersScopedList--;
  return o;
}

checkAutoscalersScopedList(api.AutoscalersScopedList o) {
  buildCounterAutoscalersScopedList++;
  if (buildCounterAutoscalersScopedList < 3) {
    checkUnnamed1659(o.autoscalers);
    checkAutoscalersScopedListWarning(o.warning);
  }
  buildCounterAutoscalersScopedList--;
}

buildUnnamed1661() {
  var o = new core.List<api.AutoscalingPolicyCustomMetricUtilization>();
  o.add(buildAutoscalingPolicyCustomMetricUtilization());
  o.add(buildAutoscalingPolicyCustomMetricUtilization());
  return o;
}

checkUnnamed1661(core.List<api.AutoscalingPolicyCustomMetricUtilization> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAutoscalingPolicyCustomMetricUtilization(o[0]);
  checkAutoscalingPolicyCustomMetricUtilization(o[1]);
}

core.int buildCounterAutoscalingPolicy = 0;
buildAutoscalingPolicy() {
  var o = new api.AutoscalingPolicy();
  buildCounterAutoscalingPolicy++;
  if (buildCounterAutoscalingPolicy < 3) {
    o.coolDownPeriodSec = 42;
    o.cpuUtilization = buildAutoscalingPolicyCpuUtilization();
    o.customMetricUtilizations = buildUnnamed1661();
    o.loadBalancingUtilization =
        buildAutoscalingPolicyLoadBalancingUtilization();
    o.maxNumReplicas = 42;
    o.minNumReplicas = 42;
  }
  buildCounterAutoscalingPolicy--;
  return o;
}

checkAutoscalingPolicy(api.AutoscalingPolicy o) {
  buildCounterAutoscalingPolicy++;
  if (buildCounterAutoscalingPolicy < 3) {
    unittest.expect(o.coolDownPeriodSec, unittest.equals(42));
    checkAutoscalingPolicyCpuUtilization(o.cpuUtilization);
    checkUnnamed1661(o.customMetricUtilizations);
    checkAutoscalingPolicyLoadBalancingUtilization(o.loadBalancingUtilization);
    unittest.expect(o.maxNumReplicas, unittest.equals(42));
    unittest.expect(o.minNumReplicas, unittest.equals(42));
  }
  buildCounterAutoscalingPolicy--;
}

core.int buildCounterAutoscalingPolicyCpuUtilization = 0;
buildAutoscalingPolicyCpuUtilization() {
  var o = new api.AutoscalingPolicyCpuUtilization();
  buildCounterAutoscalingPolicyCpuUtilization++;
  if (buildCounterAutoscalingPolicyCpuUtilization < 3) {
    o.utilizationTarget = 42.0;
  }
  buildCounterAutoscalingPolicyCpuUtilization--;
  return o;
}

checkAutoscalingPolicyCpuUtilization(api.AutoscalingPolicyCpuUtilization o) {
  buildCounterAutoscalingPolicyCpuUtilization++;
  if (buildCounterAutoscalingPolicyCpuUtilization < 3) {
    unittest.expect(o.utilizationTarget, unittest.equals(42.0));
  }
  buildCounterAutoscalingPolicyCpuUtilization--;
}

core.int buildCounterAutoscalingPolicyCustomMetricUtilization = 0;
buildAutoscalingPolicyCustomMetricUtilization() {
  var o = new api.AutoscalingPolicyCustomMetricUtilization();
  buildCounterAutoscalingPolicyCustomMetricUtilization++;
  if (buildCounterAutoscalingPolicyCustomMetricUtilization < 3) {
    o.metric = "foo";
    o.utilizationTarget = 42.0;
    o.utilizationTargetType = "foo";
  }
  buildCounterAutoscalingPolicyCustomMetricUtilization--;
  return o;
}

checkAutoscalingPolicyCustomMetricUtilization(
    api.AutoscalingPolicyCustomMetricUtilization o) {
  buildCounterAutoscalingPolicyCustomMetricUtilization++;
  if (buildCounterAutoscalingPolicyCustomMetricUtilization < 3) {
    unittest.expect(o.metric, unittest.equals('foo'));
    unittest.expect(o.utilizationTarget, unittest.equals(42.0));
    unittest.expect(o.utilizationTargetType, unittest.equals('foo'));
  }
  buildCounterAutoscalingPolicyCustomMetricUtilization--;
}

core.int buildCounterAutoscalingPolicyLoadBalancingUtilization = 0;
buildAutoscalingPolicyLoadBalancingUtilization() {
  var o = new api.AutoscalingPolicyLoadBalancingUtilization();
  buildCounterAutoscalingPolicyLoadBalancingUtilization++;
  if (buildCounterAutoscalingPolicyLoadBalancingUtilization < 3) {
    o.utilizationTarget = 42.0;
  }
  buildCounterAutoscalingPolicyLoadBalancingUtilization--;
  return o;
}

checkAutoscalingPolicyLoadBalancingUtilization(
    api.AutoscalingPolicyLoadBalancingUtilization o) {
  buildCounterAutoscalingPolicyLoadBalancingUtilization++;
  if (buildCounterAutoscalingPolicyLoadBalancingUtilization < 3) {
    unittest.expect(o.utilizationTarget, unittest.equals(42.0));
  }
  buildCounterAutoscalingPolicyLoadBalancingUtilization--;
}

core.int buildCounterBackend = 0;
buildBackend() {
  var o = new api.Backend();
  buildCounterBackend++;
  if (buildCounterBackend < 3) {
    o.balancingMode = "foo";
    o.capacityScaler = 42.0;
    o.description = "foo";
    o.group = "foo";
    o.maxConnections = 42;
    o.maxConnectionsPerEndpoint = 42;
    o.maxConnectionsPerInstance = 42;
    o.maxRate = 42;
    o.maxRatePerEndpoint = 42.0;
    o.maxRatePerInstance = 42.0;
    o.maxUtilization = 42.0;
  }
  buildCounterBackend--;
  return o;
}

checkBackend(api.Backend o) {
  buildCounterBackend++;
  if (buildCounterBackend < 3) {
    unittest.expect(o.balancingMode, unittest.equals('foo'));
    unittest.expect(o.capacityScaler, unittest.equals(42.0));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.group, unittest.equals('foo'));
    unittest.expect(o.maxConnections, unittest.equals(42));
    unittest.expect(o.maxConnectionsPerEndpoint, unittest.equals(42));
    unittest.expect(o.maxConnectionsPerInstance, unittest.equals(42));
    unittest.expect(o.maxRate, unittest.equals(42));
    unittest.expect(o.maxRatePerEndpoint, unittest.equals(42.0));
    unittest.expect(o.maxRatePerInstance, unittest.equals(42.0));
    unittest.expect(o.maxUtilization, unittest.equals(42.0));
  }
  buildCounterBackend--;
}

core.int buildCounterBackendBucket = 0;
buildBackendBucket() {
  var o = new api.BackendBucket();
  buildCounterBackendBucket++;
  if (buildCounterBackendBucket < 3) {
    o.bucketName = "foo";
    o.cdnPolicy = buildBackendBucketCdnPolicy();
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.enableCdn = true;
    o.id = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.selfLink = "foo";
  }
  buildCounterBackendBucket--;
  return o;
}

checkBackendBucket(api.BackendBucket o) {
  buildCounterBackendBucket++;
  if (buildCounterBackendBucket < 3) {
    unittest.expect(o.bucketName, unittest.equals('foo'));
    checkBackendBucketCdnPolicy(o.cdnPolicy);
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.enableCdn, unittest.isTrue);
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
  }
  buildCounterBackendBucket--;
}

buildUnnamed1662() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1662(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterBackendBucketCdnPolicy = 0;
buildBackendBucketCdnPolicy() {
  var o = new api.BackendBucketCdnPolicy();
  buildCounterBackendBucketCdnPolicy++;
  if (buildCounterBackendBucketCdnPolicy < 3) {
    o.signedUrlCacheMaxAgeSec = "foo";
    o.signedUrlKeyNames = buildUnnamed1662();
  }
  buildCounterBackendBucketCdnPolicy--;
  return o;
}

checkBackendBucketCdnPolicy(api.BackendBucketCdnPolicy o) {
  buildCounterBackendBucketCdnPolicy++;
  if (buildCounterBackendBucketCdnPolicy < 3) {
    unittest.expect(o.signedUrlCacheMaxAgeSec, unittest.equals('foo'));
    checkUnnamed1662(o.signedUrlKeyNames);
  }
  buildCounterBackendBucketCdnPolicy--;
}

buildUnnamed1663() {
  var o = new core.List<api.BackendBucket>();
  o.add(buildBackendBucket());
  o.add(buildBackendBucket());
  return o;
}

checkUnnamed1663(core.List<api.BackendBucket> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBackendBucket(o[0]);
  checkBackendBucket(o[1]);
}

core.int buildCounterBackendBucketListWarningData = 0;
buildBackendBucketListWarningData() {
  var o = new api.BackendBucketListWarningData();
  buildCounterBackendBucketListWarningData++;
  if (buildCounterBackendBucketListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterBackendBucketListWarningData--;
  return o;
}

checkBackendBucketListWarningData(api.BackendBucketListWarningData o) {
  buildCounterBackendBucketListWarningData++;
  if (buildCounterBackendBucketListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterBackendBucketListWarningData--;
}

buildUnnamed1664() {
  var o = new core.List<api.BackendBucketListWarningData>();
  o.add(buildBackendBucketListWarningData());
  o.add(buildBackendBucketListWarningData());
  return o;
}

checkUnnamed1664(core.List<api.BackendBucketListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBackendBucketListWarningData(o[0]);
  checkBackendBucketListWarningData(o[1]);
}

core.int buildCounterBackendBucketListWarning = 0;
buildBackendBucketListWarning() {
  var o = new api.BackendBucketListWarning();
  buildCounterBackendBucketListWarning++;
  if (buildCounterBackendBucketListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1664();
    o.message = "foo";
  }
  buildCounterBackendBucketListWarning--;
  return o;
}

checkBackendBucketListWarning(api.BackendBucketListWarning o) {
  buildCounterBackendBucketListWarning++;
  if (buildCounterBackendBucketListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1664(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterBackendBucketListWarning--;
}

core.int buildCounterBackendBucketList = 0;
buildBackendBucketList() {
  var o = new api.BackendBucketList();
  buildCounterBackendBucketList++;
  if (buildCounterBackendBucketList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1663();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildBackendBucketListWarning();
  }
  buildCounterBackendBucketList--;
  return o;
}

checkBackendBucketList(api.BackendBucketList o) {
  buildCounterBackendBucketList++;
  if (buildCounterBackendBucketList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1663(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkBackendBucketListWarning(o.warning);
  }
  buildCounterBackendBucketList--;
}

buildUnnamed1665() {
  var o = new core.List<api.Backend>();
  o.add(buildBackend());
  o.add(buildBackend());
  return o;
}

checkUnnamed1665(core.List<api.Backend> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBackend(o[0]);
  checkBackend(o[1]);
}

buildUnnamed1666() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1666(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

buildUnnamed1667() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1667(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterBackendService = 0;
buildBackendService() {
  var o = new api.BackendService();
  buildCounterBackendService++;
  if (buildCounterBackendService < 3) {
    o.affinityCookieTtlSec = 42;
    o.backends = buildUnnamed1665();
    o.cdnPolicy = buildBackendServiceCdnPolicy();
    o.connectionDraining = buildConnectionDraining();
    o.creationTimestamp = "foo";
    o.customRequestHeaders = buildUnnamed1666();
    o.description = "foo";
    o.enableCDN = true;
    o.fingerprint = "foo";
    o.healthChecks = buildUnnamed1667();
    o.iap = buildBackendServiceIAP();
    o.id = "foo";
    o.kind = "foo";
    o.loadBalancingScheme = "foo";
    o.name = "foo";
    o.port = 42;
    o.portName = "foo";
    o.protocol = "foo";
    o.region = "foo";
    o.securityPolicy = "foo";
    o.selfLink = "foo";
    o.sessionAffinity = "foo";
    o.timeoutSec = 42;
  }
  buildCounterBackendService--;
  return o;
}

checkBackendService(api.BackendService o) {
  buildCounterBackendService++;
  if (buildCounterBackendService < 3) {
    unittest.expect(o.affinityCookieTtlSec, unittest.equals(42));
    checkUnnamed1665(o.backends);
    checkBackendServiceCdnPolicy(o.cdnPolicy);
    checkConnectionDraining(o.connectionDraining);
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    checkUnnamed1666(o.customRequestHeaders);
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.enableCDN, unittest.isTrue);
    unittest.expect(o.fingerprint, unittest.equals('foo'));
    checkUnnamed1667(o.healthChecks);
    checkBackendServiceIAP(o.iap);
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.loadBalancingScheme, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.port, unittest.equals(42));
    unittest.expect(o.portName, unittest.equals('foo'));
    unittest.expect(o.protocol, unittest.equals('foo'));
    unittest.expect(o.region, unittest.equals('foo'));
    unittest.expect(o.securityPolicy, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.sessionAffinity, unittest.equals('foo'));
    unittest.expect(o.timeoutSec, unittest.equals(42));
  }
  buildCounterBackendService--;
}

buildUnnamed1668() {
  var o = new core.Map<core.String, api.BackendServicesScopedList>();
  o["x"] = buildBackendServicesScopedList();
  o["y"] = buildBackendServicesScopedList();
  return o;
}

checkUnnamed1668(core.Map<core.String, api.BackendServicesScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBackendServicesScopedList(o["x"]);
  checkBackendServicesScopedList(o["y"]);
}

core.int buildCounterBackendServiceAggregatedListWarningData = 0;
buildBackendServiceAggregatedListWarningData() {
  var o = new api.BackendServiceAggregatedListWarningData();
  buildCounterBackendServiceAggregatedListWarningData++;
  if (buildCounterBackendServiceAggregatedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterBackendServiceAggregatedListWarningData--;
  return o;
}

checkBackendServiceAggregatedListWarningData(
    api.BackendServiceAggregatedListWarningData o) {
  buildCounterBackendServiceAggregatedListWarningData++;
  if (buildCounterBackendServiceAggregatedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterBackendServiceAggregatedListWarningData--;
}

buildUnnamed1669() {
  var o = new core.List<api.BackendServiceAggregatedListWarningData>();
  o.add(buildBackendServiceAggregatedListWarningData());
  o.add(buildBackendServiceAggregatedListWarningData());
  return o;
}

checkUnnamed1669(core.List<api.BackendServiceAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBackendServiceAggregatedListWarningData(o[0]);
  checkBackendServiceAggregatedListWarningData(o[1]);
}

core.int buildCounterBackendServiceAggregatedListWarning = 0;
buildBackendServiceAggregatedListWarning() {
  var o = new api.BackendServiceAggregatedListWarning();
  buildCounterBackendServiceAggregatedListWarning++;
  if (buildCounterBackendServiceAggregatedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1669();
    o.message = "foo";
  }
  buildCounterBackendServiceAggregatedListWarning--;
  return o;
}

checkBackendServiceAggregatedListWarning(
    api.BackendServiceAggregatedListWarning o) {
  buildCounterBackendServiceAggregatedListWarning++;
  if (buildCounterBackendServiceAggregatedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1669(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterBackendServiceAggregatedListWarning--;
}

core.int buildCounterBackendServiceAggregatedList = 0;
buildBackendServiceAggregatedList() {
  var o = new api.BackendServiceAggregatedList();
  buildCounterBackendServiceAggregatedList++;
  if (buildCounterBackendServiceAggregatedList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1668();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildBackendServiceAggregatedListWarning();
  }
  buildCounterBackendServiceAggregatedList--;
  return o;
}

checkBackendServiceAggregatedList(api.BackendServiceAggregatedList o) {
  buildCounterBackendServiceAggregatedList++;
  if (buildCounterBackendServiceAggregatedList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1668(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkBackendServiceAggregatedListWarning(o.warning);
  }
  buildCounterBackendServiceAggregatedList--;
}

buildUnnamed1670() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1670(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterBackendServiceCdnPolicy = 0;
buildBackendServiceCdnPolicy() {
  var o = new api.BackendServiceCdnPolicy();
  buildCounterBackendServiceCdnPolicy++;
  if (buildCounterBackendServiceCdnPolicy < 3) {
    o.cacheKeyPolicy = buildCacheKeyPolicy();
    o.signedUrlCacheMaxAgeSec = "foo";
    o.signedUrlKeyNames = buildUnnamed1670();
  }
  buildCounterBackendServiceCdnPolicy--;
  return o;
}

checkBackendServiceCdnPolicy(api.BackendServiceCdnPolicy o) {
  buildCounterBackendServiceCdnPolicy++;
  if (buildCounterBackendServiceCdnPolicy < 3) {
    checkCacheKeyPolicy(o.cacheKeyPolicy);
    unittest.expect(o.signedUrlCacheMaxAgeSec, unittest.equals('foo'));
    checkUnnamed1670(o.signedUrlKeyNames);
  }
  buildCounterBackendServiceCdnPolicy--;
}

buildUnnamed1671() {
  var o = new core.List<api.HealthStatus>();
  o.add(buildHealthStatus());
  o.add(buildHealthStatus());
  return o;
}

checkUnnamed1671(core.List<api.HealthStatus> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkHealthStatus(o[0]);
  checkHealthStatus(o[1]);
}

core.int buildCounterBackendServiceGroupHealth = 0;
buildBackendServiceGroupHealth() {
  var o = new api.BackendServiceGroupHealth();
  buildCounterBackendServiceGroupHealth++;
  if (buildCounterBackendServiceGroupHealth < 3) {
    o.healthStatus = buildUnnamed1671();
    o.kind = "foo";
  }
  buildCounterBackendServiceGroupHealth--;
  return o;
}

checkBackendServiceGroupHealth(api.BackendServiceGroupHealth o) {
  buildCounterBackendServiceGroupHealth++;
  if (buildCounterBackendServiceGroupHealth < 3) {
    checkUnnamed1671(o.healthStatus);
    unittest.expect(o.kind, unittest.equals('foo'));
  }
  buildCounterBackendServiceGroupHealth--;
}

core.int buildCounterBackendServiceIAP = 0;
buildBackendServiceIAP() {
  var o = new api.BackendServiceIAP();
  buildCounterBackendServiceIAP++;
  if (buildCounterBackendServiceIAP < 3) {
    o.enabled = true;
    o.oauth2ClientId = "foo";
    o.oauth2ClientSecret = "foo";
    o.oauth2ClientSecretSha256 = "foo";
  }
  buildCounterBackendServiceIAP--;
  return o;
}

checkBackendServiceIAP(api.BackendServiceIAP o) {
  buildCounterBackendServiceIAP++;
  if (buildCounterBackendServiceIAP < 3) {
    unittest.expect(o.enabled, unittest.isTrue);
    unittest.expect(o.oauth2ClientId, unittest.equals('foo'));
    unittest.expect(o.oauth2ClientSecret, unittest.equals('foo'));
    unittest.expect(o.oauth2ClientSecretSha256, unittest.equals('foo'));
  }
  buildCounterBackendServiceIAP--;
}

buildUnnamed1672() {
  var o = new core.List<api.BackendService>();
  o.add(buildBackendService());
  o.add(buildBackendService());
  return o;
}

checkUnnamed1672(core.List<api.BackendService> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBackendService(o[0]);
  checkBackendService(o[1]);
}

core.int buildCounterBackendServiceListWarningData = 0;
buildBackendServiceListWarningData() {
  var o = new api.BackendServiceListWarningData();
  buildCounterBackendServiceListWarningData++;
  if (buildCounterBackendServiceListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterBackendServiceListWarningData--;
  return o;
}

checkBackendServiceListWarningData(api.BackendServiceListWarningData o) {
  buildCounterBackendServiceListWarningData++;
  if (buildCounterBackendServiceListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterBackendServiceListWarningData--;
}

buildUnnamed1673() {
  var o = new core.List<api.BackendServiceListWarningData>();
  o.add(buildBackendServiceListWarningData());
  o.add(buildBackendServiceListWarningData());
  return o;
}

checkUnnamed1673(core.List<api.BackendServiceListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBackendServiceListWarningData(o[0]);
  checkBackendServiceListWarningData(o[1]);
}

core.int buildCounterBackendServiceListWarning = 0;
buildBackendServiceListWarning() {
  var o = new api.BackendServiceListWarning();
  buildCounterBackendServiceListWarning++;
  if (buildCounterBackendServiceListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1673();
    o.message = "foo";
  }
  buildCounterBackendServiceListWarning--;
  return o;
}

checkBackendServiceListWarning(api.BackendServiceListWarning o) {
  buildCounterBackendServiceListWarning++;
  if (buildCounterBackendServiceListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1673(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterBackendServiceListWarning--;
}

core.int buildCounterBackendServiceList = 0;
buildBackendServiceList() {
  var o = new api.BackendServiceList();
  buildCounterBackendServiceList++;
  if (buildCounterBackendServiceList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1672();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildBackendServiceListWarning();
  }
  buildCounterBackendServiceList--;
  return o;
}

checkBackendServiceList(api.BackendServiceList o) {
  buildCounterBackendServiceList++;
  if (buildCounterBackendServiceList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1672(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkBackendServiceListWarning(o.warning);
  }
  buildCounterBackendServiceList--;
}

core.int buildCounterBackendServiceReference = 0;
buildBackendServiceReference() {
  var o = new api.BackendServiceReference();
  buildCounterBackendServiceReference++;
  if (buildCounterBackendServiceReference < 3) {
    o.backendService = "foo";
  }
  buildCounterBackendServiceReference--;
  return o;
}

checkBackendServiceReference(api.BackendServiceReference o) {
  buildCounterBackendServiceReference++;
  if (buildCounterBackendServiceReference < 3) {
    unittest.expect(o.backendService, unittest.equals('foo'));
  }
  buildCounterBackendServiceReference--;
}

buildUnnamed1674() {
  var o = new core.List<api.BackendService>();
  o.add(buildBackendService());
  o.add(buildBackendService());
  return o;
}

checkUnnamed1674(core.List<api.BackendService> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBackendService(o[0]);
  checkBackendService(o[1]);
}

core.int buildCounterBackendServicesScopedListWarningData = 0;
buildBackendServicesScopedListWarningData() {
  var o = new api.BackendServicesScopedListWarningData();
  buildCounterBackendServicesScopedListWarningData++;
  if (buildCounterBackendServicesScopedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterBackendServicesScopedListWarningData--;
  return o;
}

checkBackendServicesScopedListWarningData(
    api.BackendServicesScopedListWarningData o) {
  buildCounterBackendServicesScopedListWarningData++;
  if (buildCounterBackendServicesScopedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterBackendServicesScopedListWarningData--;
}

buildUnnamed1675() {
  var o = new core.List<api.BackendServicesScopedListWarningData>();
  o.add(buildBackendServicesScopedListWarningData());
  o.add(buildBackendServicesScopedListWarningData());
  return o;
}

checkUnnamed1675(core.List<api.BackendServicesScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBackendServicesScopedListWarningData(o[0]);
  checkBackendServicesScopedListWarningData(o[1]);
}

core.int buildCounterBackendServicesScopedListWarning = 0;
buildBackendServicesScopedListWarning() {
  var o = new api.BackendServicesScopedListWarning();
  buildCounterBackendServicesScopedListWarning++;
  if (buildCounterBackendServicesScopedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1675();
    o.message = "foo";
  }
  buildCounterBackendServicesScopedListWarning--;
  return o;
}

checkBackendServicesScopedListWarning(api.BackendServicesScopedListWarning o) {
  buildCounterBackendServicesScopedListWarning++;
  if (buildCounterBackendServicesScopedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1675(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterBackendServicesScopedListWarning--;
}

core.int buildCounterBackendServicesScopedList = 0;
buildBackendServicesScopedList() {
  var o = new api.BackendServicesScopedList();
  buildCounterBackendServicesScopedList++;
  if (buildCounterBackendServicesScopedList < 3) {
    o.backendServices = buildUnnamed1674();
    o.warning = buildBackendServicesScopedListWarning();
  }
  buildCounterBackendServicesScopedList--;
  return o;
}

checkBackendServicesScopedList(api.BackendServicesScopedList o) {
  buildCounterBackendServicesScopedList++;
  if (buildCounterBackendServicesScopedList < 3) {
    checkUnnamed1674(o.backendServices);
    checkBackendServicesScopedListWarning(o.warning);
  }
  buildCounterBackendServicesScopedList--;
}

buildUnnamed1676() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1676(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterBinding = 0;
buildBinding() {
  var o = new api.Binding();
  buildCounterBinding++;
  if (buildCounterBinding < 3) {
    o.condition = buildExpr();
    o.members = buildUnnamed1676();
    o.role = "foo";
  }
  buildCounterBinding--;
  return o;
}

checkBinding(api.Binding o) {
  buildCounterBinding++;
  if (buildCounterBinding < 3) {
    checkExpr(o.condition);
    checkUnnamed1676(o.members);
    unittest.expect(o.role, unittest.equals('foo'));
  }
  buildCounterBinding--;
}

core.int buildCounterCacheInvalidationRule = 0;
buildCacheInvalidationRule() {
  var o = new api.CacheInvalidationRule();
  buildCounterCacheInvalidationRule++;
  if (buildCounterCacheInvalidationRule < 3) {
    o.host = "foo";
    o.path = "foo";
  }
  buildCounterCacheInvalidationRule--;
  return o;
}

checkCacheInvalidationRule(api.CacheInvalidationRule o) {
  buildCounterCacheInvalidationRule++;
  if (buildCounterCacheInvalidationRule < 3) {
    unittest.expect(o.host, unittest.equals('foo'));
    unittest.expect(o.path, unittest.equals('foo'));
  }
  buildCounterCacheInvalidationRule--;
}

buildUnnamed1677() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1677(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

buildUnnamed1678() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1678(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterCacheKeyPolicy = 0;
buildCacheKeyPolicy() {
  var o = new api.CacheKeyPolicy();
  buildCounterCacheKeyPolicy++;
  if (buildCounterCacheKeyPolicy < 3) {
    o.includeHost = true;
    o.includeProtocol = true;
    o.includeQueryString = true;
    o.queryStringBlacklist = buildUnnamed1677();
    o.queryStringWhitelist = buildUnnamed1678();
  }
  buildCounterCacheKeyPolicy--;
  return o;
}

checkCacheKeyPolicy(api.CacheKeyPolicy o) {
  buildCounterCacheKeyPolicy++;
  if (buildCounterCacheKeyPolicy < 3) {
    unittest.expect(o.includeHost, unittest.isTrue);
    unittest.expect(o.includeProtocol, unittest.isTrue);
    unittest.expect(o.includeQueryString, unittest.isTrue);
    checkUnnamed1677(o.queryStringBlacklist);
    checkUnnamed1678(o.queryStringWhitelist);
  }
  buildCounterCacheKeyPolicy--;
}

buildUnnamed1679() {
  var o = new core.List<api.Reservation>();
  o.add(buildReservation());
  o.add(buildReservation());
  return o;
}

checkUnnamed1679(core.List<api.Reservation> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkReservation(o[0]);
  checkReservation(o[1]);
}

buildUnnamed1680() {
  var o = new core.List<api.ResourceCommitment>();
  o.add(buildResourceCommitment());
  o.add(buildResourceCommitment());
  return o;
}

checkUnnamed1680(core.List<api.ResourceCommitment> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkResourceCommitment(o[0]);
  checkResourceCommitment(o[1]);
}

core.int buildCounterCommitment = 0;
buildCommitment() {
  var o = new api.Commitment();
  buildCounterCommitment++;
  if (buildCounterCommitment < 3) {
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.endTimestamp = "foo";
    o.id = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.plan = "foo";
    o.region = "foo";
    o.reservations = buildUnnamed1679();
    o.resources = buildUnnamed1680();
    o.selfLink = "foo";
    o.startTimestamp = "foo";
    o.status = "foo";
    o.statusMessage = "foo";
  }
  buildCounterCommitment--;
  return o;
}

checkCommitment(api.Commitment o) {
  buildCounterCommitment++;
  if (buildCounterCommitment < 3) {
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.endTimestamp, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.plan, unittest.equals('foo'));
    unittest.expect(o.region, unittest.equals('foo'));
    checkUnnamed1679(o.reservations);
    checkUnnamed1680(o.resources);
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.startTimestamp, unittest.equals('foo'));
    unittest.expect(o.status, unittest.equals('foo'));
    unittest.expect(o.statusMessage, unittest.equals('foo'));
  }
  buildCounterCommitment--;
}

buildUnnamed1681() {
  var o = new core.Map<core.String, api.CommitmentsScopedList>();
  o["x"] = buildCommitmentsScopedList();
  o["y"] = buildCommitmentsScopedList();
  return o;
}

checkUnnamed1681(core.Map<core.String, api.CommitmentsScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkCommitmentsScopedList(o["x"]);
  checkCommitmentsScopedList(o["y"]);
}

core.int buildCounterCommitmentAggregatedListWarningData = 0;
buildCommitmentAggregatedListWarningData() {
  var o = new api.CommitmentAggregatedListWarningData();
  buildCounterCommitmentAggregatedListWarningData++;
  if (buildCounterCommitmentAggregatedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterCommitmentAggregatedListWarningData--;
  return o;
}

checkCommitmentAggregatedListWarningData(
    api.CommitmentAggregatedListWarningData o) {
  buildCounterCommitmentAggregatedListWarningData++;
  if (buildCounterCommitmentAggregatedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterCommitmentAggregatedListWarningData--;
}

buildUnnamed1682() {
  var o = new core.List<api.CommitmentAggregatedListWarningData>();
  o.add(buildCommitmentAggregatedListWarningData());
  o.add(buildCommitmentAggregatedListWarningData());
  return o;
}

checkUnnamed1682(core.List<api.CommitmentAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkCommitmentAggregatedListWarningData(o[0]);
  checkCommitmentAggregatedListWarningData(o[1]);
}

core.int buildCounterCommitmentAggregatedListWarning = 0;
buildCommitmentAggregatedListWarning() {
  var o = new api.CommitmentAggregatedListWarning();
  buildCounterCommitmentAggregatedListWarning++;
  if (buildCounterCommitmentAggregatedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1682();
    o.message = "foo";
  }
  buildCounterCommitmentAggregatedListWarning--;
  return o;
}

checkCommitmentAggregatedListWarning(api.CommitmentAggregatedListWarning o) {
  buildCounterCommitmentAggregatedListWarning++;
  if (buildCounterCommitmentAggregatedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1682(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterCommitmentAggregatedListWarning--;
}

core.int buildCounterCommitmentAggregatedList = 0;
buildCommitmentAggregatedList() {
  var o = new api.CommitmentAggregatedList();
  buildCounterCommitmentAggregatedList++;
  if (buildCounterCommitmentAggregatedList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1681();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildCommitmentAggregatedListWarning();
  }
  buildCounterCommitmentAggregatedList--;
  return o;
}

checkCommitmentAggregatedList(api.CommitmentAggregatedList o) {
  buildCounterCommitmentAggregatedList++;
  if (buildCounterCommitmentAggregatedList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1681(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkCommitmentAggregatedListWarning(o.warning);
  }
  buildCounterCommitmentAggregatedList--;
}

buildUnnamed1683() {
  var o = new core.List<api.Commitment>();
  o.add(buildCommitment());
  o.add(buildCommitment());
  return o;
}

checkUnnamed1683(core.List<api.Commitment> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkCommitment(o[0]);
  checkCommitment(o[1]);
}

core.int buildCounterCommitmentListWarningData = 0;
buildCommitmentListWarningData() {
  var o = new api.CommitmentListWarningData();
  buildCounterCommitmentListWarningData++;
  if (buildCounterCommitmentListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterCommitmentListWarningData--;
  return o;
}

checkCommitmentListWarningData(api.CommitmentListWarningData o) {
  buildCounterCommitmentListWarningData++;
  if (buildCounterCommitmentListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterCommitmentListWarningData--;
}

buildUnnamed1684() {
  var o = new core.List<api.CommitmentListWarningData>();
  o.add(buildCommitmentListWarningData());
  o.add(buildCommitmentListWarningData());
  return o;
}

checkUnnamed1684(core.List<api.CommitmentListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkCommitmentListWarningData(o[0]);
  checkCommitmentListWarningData(o[1]);
}

core.int buildCounterCommitmentListWarning = 0;
buildCommitmentListWarning() {
  var o = new api.CommitmentListWarning();
  buildCounterCommitmentListWarning++;
  if (buildCounterCommitmentListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1684();
    o.message = "foo";
  }
  buildCounterCommitmentListWarning--;
  return o;
}

checkCommitmentListWarning(api.CommitmentListWarning o) {
  buildCounterCommitmentListWarning++;
  if (buildCounterCommitmentListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1684(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterCommitmentListWarning--;
}

core.int buildCounterCommitmentList = 0;
buildCommitmentList() {
  var o = new api.CommitmentList();
  buildCounterCommitmentList++;
  if (buildCounterCommitmentList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1683();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildCommitmentListWarning();
  }
  buildCounterCommitmentList--;
  return o;
}

checkCommitmentList(api.CommitmentList o) {
  buildCounterCommitmentList++;
  if (buildCounterCommitmentList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1683(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkCommitmentListWarning(o.warning);
  }
  buildCounterCommitmentList--;
}

buildUnnamed1685() {
  var o = new core.List<api.Commitment>();
  o.add(buildCommitment());
  o.add(buildCommitment());
  return o;
}

checkUnnamed1685(core.List<api.Commitment> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkCommitment(o[0]);
  checkCommitment(o[1]);
}

core.int buildCounterCommitmentsScopedListWarningData = 0;
buildCommitmentsScopedListWarningData() {
  var o = new api.CommitmentsScopedListWarningData();
  buildCounterCommitmentsScopedListWarningData++;
  if (buildCounterCommitmentsScopedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterCommitmentsScopedListWarningData--;
  return o;
}

checkCommitmentsScopedListWarningData(api.CommitmentsScopedListWarningData o) {
  buildCounterCommitmentsScopedListWarningData++;
  if (buildCounterCommitmentsScopedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterCommitmentsScopedListWarningData--;
}

buildUnnamed1686() {
  var o = new core.List<api.CommitmentsScopedListWarningData>();
  o.add(buildCommitmentsScopedListWarningData());
  o.add(buildCommitmentsScopedListWarningData());
  return o;
}

checkUnnamed1686(core.List<api.CommitmentsScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkCommitmentsScopedListWarningData(o[0]);
  checkCommitmentsScopedListWarningData(o[1]);
}

core.int buildCounterCommitmentsScopedListWarning = 0;
buildCommitmentsScopedListWarning() {
  var o = new api.CommitmentsScopedListWarning();
  buildCounterCommitmentsScopedListWarning++;
  if (buildCounterCommitmentsScopedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1686();
    o.message = "foo";
  }
  buildCounterCommitmentsScopedListWarning--;
  return o;
}

checkCommitmentsScopedListWarning(api.CommitmentsScopedListWarning o) {
  buildCounterCommitmentsScopedListWarning++;
  if (buildCounterCommitmentsScopedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1686(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterCommitmentsScopedListWarning--;
}

core.int buildCounterCommitmentsScopedList = 0;
buildCommitmentsScopedList() {
  var o = new api.CommitmentsScopedList();
  buildCounterCommitmentsScopedList++;
  if (buildCounterCommitmentsScopedList < 3) {
    o.commitments = buildUnnamed1685();
    o.warning = buildCommitmentsScopedListWarning();
  }
  buildCounterCommitmentsScopedList--;
  return o;
}

checkCommitmentsScopedList(api.CommitmentsScopedList o) {
  buildCounterCommitmentsScopedList++;
  if (buildCounterCommitmentsScopedList < 3) {
    checkUnnamed1685(o.commitments);
    checkCommitmentsScopedListWarning(o.warning);
  }
  buildCounterCommitmentsScopedList--;
}

buildUnnamed1687() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1687(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterCondition = 0;
buildCondition() {
  var o = new api.Condition();
  buildCounterCondition++;
  if (buildCounterCondition < 3) {
    o.iam = "foo";
    o.op = "foo";
    o.svc = "foo";
    o.sys = "foo";
    o.values = buildUnnamed1687();
  }
  buildCounterCondition--;
  return o;
}

checkCondition(api.Condition o) {
  buildCounterCondition++;
  if (buildCounterCondition < 3) {
    unittest.expect(o.iam, unittest.equals('foo'));
    unittest.expect(o.op, unittest.equals('foo'));
    unittest.expect(o.svc, unittest.equals('foo'));
    unittest.expect(o.sys, unittest.equals('foo'));
    checkUnnamed1687(o.values);
  }
  buildCounterCondition--;
}

core.int buildCounterConnectionDraining = 0;
buildConnectionDraining() {
  var o = new api.ConnectionDraining();
  buildCounterConnectionDraining++;
  if (buildCounterConnectionDraining < 3) {
    o.drainingTimeoutSec = 42;
  }
  buildCounterConnectionDraining--;
  return o;
}

checkConnectionDraining(api.ConnectionDraining o) {
  buildCounterConnectionDraining++;
  if (buildCounterConnectionDraining < 3) {
    unittest.expect(o.drainingTimeoutSec, unittest.equals(42));
  }
  buildCounterConnectionDraining--;
}

core.int buildCounterCustomerEncryptionKey = 0;
buildCustomerEncryptionKey() {
  var o = new api.CustomerEncryptionKey();
  buildCounterCustomerEncryptionKey++;
  if (buildCounterCustomerEncryptionKey < 3) {
    o.kmsKeyName = "foo";
    o.rawKey = "foo";
    o.sha256 = "foo";
  }
  buildCounterCustomerEncryptionKey--;
  return o;
}

checkCustomerEncryptionKey(api.CustomerEncryptionKey o) {
  buildCounterCustomerEncryptionKey++;
  if (buildCounterCustomerEncryptionKey < 3) {
    unittest.expect(o.kmsKeyName, unittest.equals('foo'));
    unittest.expect(o.rawKey, unittest.equals('foo'));
    unittest.expect(o.sha256, unittest.equals('foo'));
  }
  buildCounterCustomerEncryptionKey--;
}

core.int buildCounterCustomerEncryptionKeyProtectedDisk = 0;
buildCustomerEncryptionKeyProtectedDisk() {
  var o = new api.CustomerEncryptionKeyProtectedDisk();
  buildCounterCustomerEncryptionKeyProtectedDisk++;
  if (buildCounterCustomerEncryptionKeyProtectedDisk < 3) {
    o.diskEncryptionKey = buildCustomerEncryptionKey();
    o.source = "foo";
  }
  buildCounterCustomerEncryptionKeyProtectedDisk--;
  return o;
}

checkCustomerEncryptionKeyProtectedDisk(
    api.CustomerEncryptionKeyProtectedDisk o) {
  buildCounterCustomerEncryptionKeyProtectedDisk++;
  if (buildCounterCustomerEncryptionKeyProtectedDisk < 3) {
    checkCustomerEncryptionKey(o.diskEncryptionKey);
    unittest.expect(o.source, unittest.equals('foo'));
  }
  buildCounterCustomerEncryptionKeyProtectedDisk--;
}

core.int buildCounterDeprecationStatus = 0;
buildDeprecationStatus() {
  var o = new api.DeprecationStatus();
  buildCounterDeprecationStatus++;
  if (buildCounterDeprecationStatus < 3) {
    o.deleted = "foo";
    o.deprecated = "foo";
    o.obsolete = "foo";
    o.replacement = "foo";
    o.state = "foo";
  }
  buildCounterDeprecationStatus--;
  return o;
}

checkDeprecationStatus(api.DeprecationStatus o) {
  buildCounterDeprecationStatus++;
  if (buildCounterDeprecationStatus < 3) {
    unittest.expect(o.deleted, unittest.equals('foo'));
    unittest.expect(o.deprecated, unittest.equals('foo'));
    unittest.expect(o.obsolete, unittest.equals('foo'));
    unittest.expect(o.replacement, unittest.equals('foo'));
    unittest.expect(o.state, unittest.equals('foo'));
  }
  buildCounterDeprecationStatus--;
}

buildUnnamed1688() {
  var o = new core.List<api.GuestOsFeature>();
  o.add(buildGuestOsFeature());
  o.add(buildGuestOsFeature());
  return o;
}

checkUnnamed1688(core.List<api.GuestOsFeature> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkGuestOsFeature(o[0]);
  checkGuestOsFeature(o[1]);
}

buildUnnamed1689() {
  var o = new core.Map<core.String, core.String>();
  o["x"] = "foo";
  o["y"] = "foo";
  return o;
}

checkUnnamed1689(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o["x"], unittest.equals('foo'));
  unittest.expect(o["y"], unittest.equals('foo'));
}

buildUnnamed1690() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1690(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

buildUnnamed1691() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1691(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

buildUnnamed1692() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1692(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

buildUnnamed1693() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1693(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

buildUnnamed1694() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1694(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterDisk = 0;
buildDisk() {
  var o = new api.Disk();
  buildCounterDisk++;
  if (buildCounterDisk < 3) {
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.diskEncryptionKey = buildCustomerEncryptionKey();
    o.guestOsFeatures = buildUnnamed1688();
    o.id = "foo";
    o.kind = "foo";
    o.labelFingerprint = "foo";
    o.labels = buildUnnamed1689();
    o.lastAttachTimestamp = "foo";
    o.lastDetachTimestamp = "foo";
    o.licenseCodes = buildUnnamed1690();
    o.licenses = buildUnnamed1691();
    o.name = "foo";
    o.options = "foo";
    o.physicalBlockSizeBytes = "foo";
    o.region = "foo";
    o.replicaZones = buildUnnamed1692();
    o.resourcePolicies = buildUnnamed1693();
    o.selfLink = "foo";
    o.sizeGb = "foo";
    o.sourceImage = "foo";
    o.sourceImageEncryptionKey = buildCustomerEncryptionKey();
    o.sourceImageId = "foo";
    o.sourceSnapshot = "foo";
    o.sourceSnapshotEncryptionKey = buildCustomerEncryptionKey();
    o.sourceSnapshotId = "foo";
    o.status = "foo";
    o.type = "foo";
    o.users = buildUnnamed1694();
    o.zone = "foo";
  }
  buildCounterDisk--;
  return o;
}

checkDisk(api.Disk o) {
  buildCounterDisk++;
  if (buildCounterDisk < 3) {
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    checkCustomerEncryptionKey(o.diskEncryptionKey);
    checkUnnamed1688(o.guestOsFeatures);
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.labelFingerprint, unittest.equals('foo'));
    checkUnnamed1689(o.labels);
    unittest.expect(o.lastAttachTimestamp, unittest.equals('foo'));
    unittest.expect(o.lastDetachTimestamp, unittest.equals('foo'));
    checkUnnamed1690(o.licenseCodes);
    checkUnnamed1691(o.licenses);
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.options, unittest.equals('foo'));
    unittest.expect(o.physicalBlockSizeBytes, unittest.equals('foo'));
    unittest.expect(o.region, unittest.equals('foo'));
    checkUnnamed1692(o.replicaZones);
    checkUnnamed1693(o.resourcePolicies);
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.sizeGb, unittest.equals('foo'));
    unittest.expect(o.sourceImage, unittest.equals('foo'));
    checkCustomerEncryptionKey(o.sourceImageEncryptionKey);
    unittest.expect(o.sourceImageId, unittest.equals('foo'));
    unittest.expect(o.sourceSnapshot, unittest.equals('foo'));
    checkCustomerEncryptionKey(o.sourceSnapshotEncryptionKey);
    unittest.expect(o.sourceSnapshotId, unittest.equals('foo'));
    unittest.expect(o.status, unittest.equals('foo'));
    unittest.expect(o.type, unittest.equals('foo'));
    checkUnnamed1694(o.users);
    unittest.expect(o.zone, unittest.equals('foo'));
  }
  buildCounterDisk--;
}

buildUnnamed1695() {
  var o = new core.Map<core.String, api.DisksScopedList>();
  o["x"] = buildDisksScopedList();
  o["y"] = buildDisksScopedList();
  return o;
}

checkUnnamed1695(core.Map<core.String, api.DisksScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkDisksScopedList(o["x"]);
  checkDisksScopedList(o["y"]);
}

core.int buildCounterDiskAggregatedListWarningData = 0;
buildDiskAggregatedListWarningData() {
  var o = new api.DiskAggregatedListWarningData();
  buildCounterDiskAggregatedListWarningData++;
  if (buildCounterDiskAggregatedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterDiskAggregatedListWarningData--;
  return o;
}

checkDiskAggregatedListWarningData(api.DiskAggregatedListWarningData o) {
  buildCounterDiskAggregatedListWarningData++;
  if (buildCounterDiskAggregatedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterDiskAggregatedListWarningData--;
}

buildUnnamed1696() {
  var o = new core.List<api.DiskAggregatedListWarningData>();
  o.add(buildDiskAggregatedListWarningData());
  o.add(buildDiskAggregatedListWarningData());
  return o;
}

checkUnnamed1696(core.List<api.DiskAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkDiskAggregatedListWarningData(o[0]);
  checkDiskAggregatedListWarningData(o[1]);
}

core.int buildCounterDiskAggregatedListWarning = 0;
buildDiskAggregatedListWarning() {
  var o = new api.DiskAggregatedListWarning();
  buildCounterDiskAggregatedListWarning++;
  if (buildCounterDiskAggregatedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1696();
    o.message = "foo";
  }
  buildCounterDiskAggregatedListWarning--;
  return o;
}

checkDiskAggregatedListWarning(api.DiskAggregatedListWarning o) {
  buildCounterDiskAggregatedListWarning++;
  if (buildCounterDiskAggregatedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1696(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterDiskAggregatedListWarning--;
}

core.int buildCounterDiskAggregatedList = 0;
buildDiskAggregatedList() {
  var o = new api.DiskAggregatedList();
  buildCounterDiskAggregatedList++;
  if (buildCounterDiskAggregatedList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1695();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildDiskAggregatedListWarning();
  }
  buildCounterDiskAggregatedList--;
  return o;
}

checkDiskAggregatedList(api.DiskAggregatedList o) {
  buildCounterDiskAggregatedList++;
  if (buildCounterDiskAggregatedList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1695(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkDiskAggregatedListWarning(o.warning);
  }
  buildCounterDiskAggregatedList--;
}

core.int buildCounterDiskInstantiationConfig = 0;
buildDiskInstantiationConfig() {
  var o = new api.DiskInstantiationConfig();
  buildCounterDiskInstantiationConfig++;
  if (buildCounterDiskInstantiationConfig < 3) {
    o.autoDelete = true;
    o.customImage = "foo";
    o.deviceName = "foo";
    o.instantiateFrom = "foo";
  }
  buildCounterDiskInstantiationConfig--;
  return o;
}

checkDiskInstantiationConfig(api.DiskInstantiationConfig o) {
  buildCounterDiskInstantiationConfig++;
  if (buildCounterDiskInstantiationConfig < 3) {
    unittest.expect(o.autoDelete, unittest.isTrue);
    unittest.expect(o.customImage, unittest.equals('foo'));
    unittest.expect(o.deviceName, unittest.equals('foo'));
    unittest.expect(o.instantiateFrom, unittest.equals('foo'));
  }
  buildCounterDiskInstantiationConfig--;
}

buildUnnamed1697() {
  var o = new core.List<api.Disk>();
  o.add(buildDisk());
  o.add(buildDisk());
  return o;
}

checkUnnamed1697(core.List<api.Disk> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkDisk(o[0]);
  checkDisk(o[1]);
}

core.int buildCounterDiskListWarningData = 0;
buildDiskListWarningData() {
  var o = new api.DiskListWarningData();
  buildCounterDiskListWarningData++;
  if (buildCounterDiskListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterDiskListWarningData--;
  return o;
}

checkDiskListWarningData(api.DiskListWarningData o) {
  buildCounterDiskListWarningData++;
  if (buildCounterDiskListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterDiskListWarningData--;
}

buildUnnamed1698() {
  var o = new core.List<api.DiskListWarningData>();
  o.add(buildDiskListWarningData());
  o.add(buildDiskListWarningData());
  return o;
}

checkUnnamed1698(core.List<api.DiskListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkDiskListWarningData(o[0]);
  checkDiskListWarningData(o[1]);
}

core.int buildCounterDiskListWarning = 0;
buildDiskListWarning() {
  var o = new api.DiskListWarning();
  buildCounterDiskListWarning++;
  if (buildCounterDiskListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1698();
    o.message = "foo";
  }
  buildCounterDiskListWarning--;
  return o;
}

checkDiskListWarning(api.DiskListWarning o) {
  buildCounterDiskListWarning++;
  if (buildCounterDiskListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1698(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterDiskListWarning--;
}

core.int buildCounterDiskList = 0;
buildDiskList() {
  var o = new api.DiskList();
  buildCounterDiskList++;
  if (buildCounterDiskList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1697();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildDiskListWarning();
  }
  buildCounterDiskList--;
  return o;
}

checkDiskList(api.DiskList o) {
  buildCounterDiskList++;
  if (buildCounterDiskList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1697(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkDiskListWarning(o.warning);
  }
  buildCounterDiskList--;
}

core.int buildCounterDiskMoveRequest = 0;
buildDiskMoveRequest() {
  var o = new api.DiskMoveRequest();
  buildCounterDiskMoveRequest++;
  if (buildCounterDiskMoveRequest < 3) {
    o.destinationZone = "foo";
    o.targetDisk = "foo";
  }
  buildCounterDiskMoveRequest--;
  return o;
}

checkDiskMoveRequest(api.DiskMoveRequest o) {
  buildCounterDiskMoveRequest++;
  if (buildCounterDiskMoveRequest < 3) {
    unittest.expect(o.destinationZone, unittest.equals('foo'));
    unittest.expect(o.targetDisk, unittest.equals('foo'));
  }
  buildCounterDiskMoveRequest--;
}

core.int buildCounterDiskType = 0;
buildDiskType() {
  var o = new api.DiskType();
  buildCounterDiskType++;
  if (buildCounterDiskType < 3) {
    o.creationTimestamp = "foo";
    o.defaultDiskSizeGb = "foo";
    o.deprecated = buildDeprecationStatus();
    o.description = "foo";
    o.id = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.region = "foo";
    o.selfLink = "foo";
    o.validDiskSize = "foo";
    o.zone = "foo";
  }
  buildCounterDiskType--;
  return o;
}

checkDiskType(api.DiskType o) {
  buildCounterDiskType++;
  if (buildCounterDiskType < 3) {
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.defaultDiskSizeGb, unittest.equals('foo'));
    checkDeprecationStatus(o.deprecated);
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.region, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.validDiskSize, unittest.equals('foo'));
    unittest.expect(o.zone, unittest.equals('foo'));
  }
  buildCounterDiskType--;
}

buildUnnamed1699() {
  var o = new core.Map<core.String, api.DiskTypesScopedList>();
  o["x"] = buildDiskTypesScopedList();
  o["y"] = buildDiskTypesScopedList();
  return o;
}

checkUnnamed1699(core.Map<core.String, api.DiskTypesScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkDiskTypesScopedList(o["x"]);
  checkDiskTypesScopedList(o["y"]);
}

core.int buildCounterDiskTypeAggregatedListWarningData = 0;
buildDiskTypeAggregatedListWarningData() {
  var o = new api.DiskTypeAggregatedListWarningData();
  buildCounterDiskTypeAggregatedListWarningData++;
  if (buildCounterDiskTypeAggregatedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterDiskTypeAggregatedListWarningData--;
  return o;
}

checkDiskTypeAggregatedListWarningData(
    api.DiskTypeAggregatedListWarningData o) {
  buildCounterDiskTypeAggregatedListWarningData++;
  if (buildCounterDiskTypeAggregatedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterDiskTypeAggregatedListWarningData--;
}

buildUnnamed1700() {
  var o = new core.List<api.DiskTypeAggregatedListWarningData>();
  o.add(buildDiskTypeAggregatedListWarningData());
  o.add(buildDiskTypeAggregatedListWarningData());
  return o;
}

checkUnnamed1700(core.List<api.DiskTypeAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkDiskTypeAggregatedListWarningData(o[0]);
  checkDiskTypeAggregatedListWarningData(o[1]);
}

core.int buildCounterDiskTypeAggregatedListWarning = 0;
buildDiskTypeAggregatedListWarning() {
  var o = new api.DiskTypeAggregatedListWarning();
  buildCounterDiskTypeAggregatedListWarning++;
  if (buildCounterDiskTypeAggregatedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1700();
    o.message = "foo";
  }
  buildCounterDiskTypeAggregatedListWarning--;
  return o;
}

checkDiskTypeAggregatedListWarning(api.DiskTypeAggregatedListWarning o) {
  buildCounterDiskTypeAggregatedListWarning++;
  if (buildCounterDiskTypeAggregatedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1700(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterDiskTypeAggregatedListWarning--;
}

core.int buildCounterDiskTypeAggregatedList = 0;
buildDiskTypeAggregatedList() {
  var o = new api.DiskTypeAggregatedList();
  buildCounterDiskTypeAggregatedList++;
  if (buildCounterDiskTypeAggregatedList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1699();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildDiskTypeAggregatedListWarning();
  }
  buildCounterDiskTypeAggregatedList--;
  return o;
}

checkDiskTypeAggregatedList(api.DiskTypeAggregatedList o) {
  buildCounterDiskTypeAggregatedList++;
  if (buildCounterDiskTypeAggregatedList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1699(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkDiskTypeAggregatedListWarning(o.warning);
  }
  buildCounterDiskTypeAggregatedList--;
}

buildUnnamed1701() {
  var o = new core.List<api.DiskType>();
  o.add(buildDiskType());
  o.add(buildDiskType());
  return o;
}

checkUnnamed1701(core.List<api.DiskType> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkDiskType(o[0]);
  checkDiskType(o[1]);
}

core.int buildCounterDiskTypeListWarningData = 0;
buildDiskTypeListWarningData() {
  var o = new api.DiskTypeListWarningData();
  buildCounterDiskTypeListWarningData++;
  if (buildCounterDiskTypeListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterDiskTypeListWarningData--;
  return o;
}

checkDiskTypeListWarningData(api.DiskTypeListWarningData o) {
  buildCounterDiskTypeListWarningData++;
  if (buildCounterDiskTypeListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterDiskTypeListWarningData--;
}

buildUnnamed1702() {
  var o = new core.List<api.DiskTypeListWarningData>();
  o.add(buildDiskTypeListWarningData());
  o.add(buildDiskTypeListWarningData());
  return o;
}

checkUnnamed1702(core.List<api.DiskTypeListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkDiskTypeListWarningData(o[0]);
  checkDiskTypeListWarningData(o[1]);
}

core.int buildCounterDiskTypeListWarning = 0;
buildDiskTypeListWarning() {
  var o = new api.DiskTypeListWarning();
  buildCounterDiskTypeListWarning++;
  if (buildCounterDiskTypeListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1702();
    o.message = "foo";
  }
  buildCounterDiskTypeListWarning--;
  return o;
}

checkDiskTypeListWarning(api.DiskTypeListWarning o) {
  buildCounterDiskTypeListWarning++;
  if (buildCounterDiskTypeListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1702(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterDiskTypeListWarning--;
}

core.int buildCounterDiskTypeList = 0;
buildDiskTypeList() {
  var o = new api.DiskTypeList();
  buildCounterDiskTypeList++;
  if (buildCounterDiskTypeList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1701();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildDiskTypeListWarning();
  }
  buildCounterDiskTypeList--;
  return o;
}

checkDiskTypeList(api.DiskTypeList o) {
  buildCounterDiskTypeList++;
  if (buildCounterDiskTypeList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1701(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkDiskTypeListWarning(o.warning);
  }
  buildCounterDiskTypeList--;
}

buildUnnamed1703() {
  var o = new core.List<api.DiskType>();
  o.add(buildDiskType());
  o.add(buildDiskType());
  return o;
}

checkUnnamed1703(core.List<api.DiskType> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkDiskType(o[0]);
  checkDiskType(o[1]);
}

core.int buildCounterDiskTypesScopedListWarningData = 0;
buildDiskTypesScopedListWarningData() {
  var o = new api.DiskTypesScopedListWarningData();
  buildCounterDiskTypesScopedListWarningData++;
  if (buildCounterDiskTypesScopedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterDiskTypesScopedListWarningData--;
  return o;
}

checkDiskTypesScopedListWarningData(api.DiskTypesScopedListWarningData o) {
  buildCounterDiskTypesScopedListWarningData++;
  if (buildCounterDiskTypesScopedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterDiskTypesScopedListWarningData--;
}

buildUnnamed1704() {
  var o = new core.List<api.DiskTypesScopedListWarningData>();
  o.add(buildDiskTypesScopedListWarningData());
  o.add(buildDiskTypesScopedListWarningData());
  return o;
}

checkUnnamed1704(core.List<api.DiskTypesScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkDiskTypesScopedListWarningData(o[0]);
  checkDiskTypesScopedListWarningData(o[1]);
}

core.int buildCounterDiskTypesScopedListWarning = 0;
buildDiskTypesScopedListWarning() {
  var o = new api.DiskTypesScopedListWarning();
  buildCounterDiskTypesScopedListWarning++;
  if (buildCounterDiskTypesScopedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1704();
    o.message = "foo";
  }
  buildCounterDiskTypesScopedListWarning--;
  return o;
}

checkDiskTypesScopedListWarning(api.DiskTypesScopedListWarning o) {
  buildCounterDiskTypesScopedListWarning++;
  if (buildCounterDiskTypesScopedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1704(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterDiskTypesScopedListWarning--;
}

core.int buildCounterDiskTypesScopedList = 0;
buildDiskTypesScopedList() {
  var o = new api.DiskTypesScopedList();
  buildCounterDiskTypesScopedList++;
  if (buildCounterDiskTypesScopedList < 3) {
    o.diskTypes = buildUnnamed1703();
    o.warning = buildDiskTypesScopedListWarning();
  }
  buildCounterDiskTypesScopedList--;
  return o;
}

checkDiskTypesScopedList(api.DiskTypesScopedList o) {
  buildCounterDiskTypesScopedList++;
  if (buildCounterDiskTypesScopedList < 3) {
    checkUnnamed1703(o.diskTypes);
    checkDiskTypesScopedListWarning(o.warning);
  }
  buildCounterDiskTypesScopedList--;
}

buildUnnamed1705() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1705(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterDisksAddResourcePoliciesRequest = 0;
buildDisksAddResourcePoliciesRequest() {
  var o = new api.DisksAddResourcePoliciesRequest();
  buildCounterDisksAddResourcePoliciesRequest++;
  if (buildCounterDisksAddResourcePoliciesRequest < 3) {
    o.resourcePolicies = buildUnnamed1705();
  }
  buildCounterDisksAddResourcePoliciesRequest--;
  return o;
}

checkDisksAddResourcePoliciesRequest(api.DisksAddResourcePoliciesRequest o) {
  buildCounterDisksAddResourcePoliciesRequest++;
  if (buildCounterDisksAddResourcePoliciesRequest < 3) {
    checkUnnamed1705(o.resourcePolicies);
  }
  buildCounterDisksAddResourcePoliciesRequest--;
}

buildUnnamed1706() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1706(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterDisksRemoveResourcePoliciesRequest = 0;
buildDisksRemoveResourcePoliciesRequest() {
  var o = new api.DisksRemoveResourcePoliciesRequest();
  buildCounterDisksRemoveResourcePoliciesRequest++;
  if (buildCounterDisksRemoveResourcePoliciesRequest < 3) {
    o.resourcePolicies = buildUnnamed1706();
  }
  buildCounterDisksRemoveResourcePoliciesRequest--;
  return o;
}

checkDisksRemoveResourcePoliciesRequest(
    api.DisksRemoveResourcePoliciesRequest o) {
  buildCounterDisksRemoveResourcePoliciesRequest++;
  if (buildCounterDisksRemoveResourcePoliciesRequest < 3) {
    checkUnnamed1706(o.resourcePolicies);
  }
  buildCounterDisksRemoveResourcePoliciesRequest--;
}

core.int buildCounterDisksResizeRequest = 0;
buildDisksResizeRequest() {
  var o = new api.DisksResizeRequest();
  buildCounterDisksResizeRequest++;
  if (buildCounterDisksResizeRequest < 3) {
    o.sizeGb = "foo";
  }
  buildCounterDisksResizeRequest--;
  return o;
}

checkDisksResizeRequest(api.DisksResizeRequest o) {
  buildCounterDisksResizeRequest++;
  if (buildCounterDisksResizeRequest < 3) {
    unittest.expect(o.sizeGb, unittest.equals('foo'));
  }
  buildCounterDisksResizeRequest--;
}

buildUnnamed1707() {
  var o = new core.List<api.Disk>();
  o.add(buildDisk());
  o.add(buildDisk());
  return o;
}

checkUnnamed1707(core.List<api.Disk> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkDisk(o[0]);
  checkDisk(o[1]);
}

core.int buildCounterDisksScopedListWarningData = 0;
buildDisksScopedListWarningData() {
  var o = new api.DisksScopedListWarningData();
  buildCounterDisksScopedListWarningData++;
  if (buildCounterDisksScopedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterDisksScopedListWarningData--;
  return o;
}

checkDisksScopedListWarningData(api.DisksScopedListWarningData o) {
  buildCounterDisksScopedListWarningData++;
  if (buildCounterDisksScopedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterDisksScopedListWarningData--;
}

buildUnnamed1708() {
  var o = new core.List<api.DisksScopedListWarningData>();
  o.add(buildDisksScopedListWarningData());
  o.add(buildDisksScopedListWarningData());
  return o;
}

checkUnnamed1708(core.List<api.DisksScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkDisksScopedListWarningData(o[0]);
  checkDisksScopedListWarningData(o[1]);
}

core.int buildCounterDisksScopedListWarning = 0;
buildDisksScopedListWarning() {
  var o = new api.DisksScopedListWarning();
  buildCounterDisksScopedListWarning++;
  if (buildCounterDisksScopedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1708();
    o.message = "foo";
  }
  buildCounterDisksScopedListWarning--;
  return o;
}

checkDisksScopedListWarning(api.DisksScopedListWarning o) {
  buildCounterDisksScopedListWarning++;
  if (buildCounterDisksScopedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1708(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterDisksScopedListWarning--;
}

core.int buildCounterDisksScopedList = 0;
buildDisksScopedList() {
  var o = new api.DisksScopedList();
  buildCounterDisksScopedList++;
  if (buildCounterDisksScopedList < 3) {
    o.disks = buildUnnamed1707();
    o.warning = buildDisksScopedListWarning();
  }
  buildCounterDisksScopedList--;
  return o;
}

checkDisksScopedList(api.DisksScopedList o) {
  buildCounterDisksScopedList++;
  if (buildCounterDisksScopedList < 3) {
    checkUnnamed1707(o.disks);
    checkDisksScopedListWarning(o.warning);
  }
  buildCounterDisksScopedList--;
}

buildUnnamed1709() {
  var o = new core.List<api.DistributionPolicyZoneConfiguration>();
  o.add(buildDistributionPolicyZoneConfiguration());
  o.add(buildDistributionPolicyZoneConfiguration());
  return o;
}

checkUnnamed1709(core.List<api.DistributionPolicyZoneConfiguration> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkDistributionPolicyZoneConfiguration(o[0]);
  checkDistributionPolicyZoneConfiguration(o[1]);
}

core.int buildCounterDistributionPolicy = 0;
buildDistributionPolicy() {
  var o = new api.DistributionPolicy();
  buildCounterDistributionPolicy++;
  if (buildCounterDistributionPolicy < 3) {
    o.zones = buildUnnamed1709();
  }
  buildCounterDistributionPolicy--;
  return o;
}

checkDistributionPolicy(api.DistributionPolicy o) {
  buildCounterDistributionPolicy++;
  if (buildCounterDistributionPolicy < 3) {
    checkUnnamed1709(o.zones);
  }
  buildCounterDistributionPolicy--;
}

core.int buildCounterDistributionPolicyZoneConfiguration = 0;
buildDistributionPolicyZoneConfiguration() {
  var o = new api.DistributionPolicyZoneConfiguration();
  buildCounterDistributionPolicyZoneConfiguration++;
  if (buildCounterDistributionPolicyZoneConfiguration < 3) {
    o.zone = "foo";
  }
  buildCounterDistributionPolicyZoneConfiguration--;
  return o;
}

checkDistributionPolicyZoneConfiguration(
    api.DistributionPolicyZoneConfiguration o) {
  buildCounterDistributionPolicyZoneConfiguration++;
  if (buildCounterDistributionPolicyZoneConfiguration < 3) {
    unittest.expect(o.zone, unittest.equals('foo'));
  }
  buildCounterDistributionPolicyZoneConfiguration--;
}

core.int buildCounterExpr = 0;
buildExpr() {
  var o = new api.Expr();
  buildCounterExpr++;
  if (buildCounterExpr < 3) {
    o.description = "foo";
    o.expression = "foo";
    o.location = "foo";
    o.title = "foo";
  }
  buildCounterExpr--;
  return o;
}

checkExpr(api.Expr o) {
  buildCounterExpr++;
  if (buildCounterExpr < 3) {
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.expression, unittest.equals('foo'));
    unittest.expect(o.location, unittest.equals('foo'));
    unittest.expect(o.title, unittest.equals('foo'));
  }
  buildCounterExpr--;
}

buildUnnamed1710() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1710(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterFirewallAllowed = 0;
buildFirewallAllowed() {
  var o = new api.FirewallAllowed();
  buildCounterFirewallAllowed++;
  if (buildCounterFirewallAllowed < 3) {
    o.IPProtocol = "foo";
    o.ports = buildUnnamed1710();
  }
  buildCounterFirewallAllowed--;
  return o;
}

checkFirewallAllowed(api.FirewallAllowed o) {
  buildCounterFirewallAllowed++;
  if (buildCounterFirewallAllowed < 3) {
    unittest.expect(o.IPProtocol, unittest.equals('foo'));
    checkUnnamed1710(o.ports);
  }
  buildCounterFirewallAllowed--;
}

buildUnnamed1711() {
  var o = new core.List<api.FirewallAllowed>();
  o.add(buildFirewallAllowed());
  o.add(buildFirewallAllowed());
  return o;
}

checkUnnamed1711(core.List<api.FirewallAllowed> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkFirewallAllowed(o[0]);
  checkFirewallAllowed(o[1]);
}

buildUnnamed1712() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1712(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterFirewallDenied = 0;
buildFirewallDenied() {
  var o = new api.FirewallDenied();
  buildCounterFirewallDenied++;
  if (buildCounterFirewallDenied < 3) {
    o.IPProtocol = "foo";
    o.ports = buildUnnamed1712();
  }
  buildCounterFirewallDenied--;
  return o;
}

checkFirewallDenied(api.FirewallDenied o) {
  buildCounterFirewallDenied++;
  if (buildCounterFirewallDenied < 3) {
    unittest.expect(o.IPProtocol, unittest.equals('foo'));
    checkUnnamed1712(o.ports);
  }
  buildCounterFirewallDenied--;
}

buildUnnamed1713() {
  var o = new core.List<api.FirewallDenied>();
  o.add(buildFirewallDenied());
  o.add(buildFirewallDenied());
  return o;
}

checkUnnamed1713(core.List<api.FirewallDenied> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkFirewallDenied(o[0]);
  checkFirewallDenied(o[1]);
}

buildUnnamed1714() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1714(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

buildUnnamed1715() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1715(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

buildUnnamed1716() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1716(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

buildUnnamed1717() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1717(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

buildUnnamed1718() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1718(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

buildUnnamed1719() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1719(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterFirewall = 0;
buildFirewall() {
  var o = new api.Firewall();
  buildCounterFirewall++;
  if (buildCounterFirewall < 3) {
    o.allowed = buildUnnamed1711();
    o.creationTimestamp = "foo";
    o.denied = buildUnnamed1713();
    o.description = "foo";
    o.destinationRanges = buildUnnamed1714();
    o.direction = "foo";
    o.disabled = true;
    o.id = "foo";
    o.kind = "foo";
    o.logConfig = buildFirewallLogConfig();
    o.name = "foo";
    o.network = "foo";
    o.priority = 42;
    o.selfLink = "foo";
    o.sourceRanges = buildUnnamed1715();
    o.sourceServiceAccounts = buildUnnamed1716();
    o.sourceTags = buildUnnamed1717();
    o.targetServiceAccounts = buildUnnamed1718();
    o.targetTags = buildUnnamed1719();
  }
  buildCounterFirewall--;
  return o;
}

checkFirewall(api.Firewall o) {
  buildCounterFirewall++;
  if (buildCounterFirewall < 3) {
    checkUnnamed1711(o.allowed);
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    checkUnnamed1713(o.denied);
    unittest.expect(o.description, unittest.equals('foo'));
    checkUnnamed1714(o.destinationRanges);
    unittest.expect(o.direction, unittest.equals('foo'));
    unittest.expect(o.disabled, unittest.isTrue);
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    checkFirewallLogConfig(o.logConfig);
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.network, unittest.equals('foo'));
    unittest.expect(o.priority, unittest.equals(42));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkUnnamed1715(o.sourceRanges);
    checkUnnamed1716(o.sourceServiceAccounts);
    checkUnnamed1717(o.sourceTags);
    checkUnnamed1718(o.targetServiceAccounts);
    checkUnnamed1719(o.targetTags);
  }
  buildCounterFirewall--;
}

buildUnnamed1720() {
  var o = new core.List<api.Firewall>();
  o.add(buildFirewall());
  o.add(buildFirewall());
  return o;
}

checkUnnamed1720(core.List<api.Firewall> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkFirewall(o[0]);
  checkFirewall(o[1]);
}

core.int buildCounterFirewallListWarningData = 0;
buildFirewallListWarningData() {
  var o = new api.FirewallListWarningData();
  buildCounterFirewallListWarningData++;
  if (buildCounterFirewallListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterFirewallListWarningData--;
  return o;
}

checkFirewallListWarningData(api.FirewallListWarningData o) {
  buildCounterFirewallListWarningData++;
  if (buildCounterFirewallListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterFirewallListWarningData--;
}

buildUnnamed1721() {
  var o = new core.List<api.FirewallListWarningData>();
  o.add(buildFirewallListWarningData());
  o.add(buildFirewallListWarningData());
  return o;
}

checkUnnamed1721(core.List<api.FirewallListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkFirewallListWarningData(o[0]);
  checkFirewallListWarningData(o[1]);
}

core.int buildCounterFirewallListWarning = 0;
buildFirewallListWarning() {
  var o = new api.FirewallListWarning();
  buildCounterFirewallListWarning++;
  if (buildCounterFirewallListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1721();
    o.message = "foo";
  }
  buildCounterFirewallListWarning--;
  return o;
}

checkFirewallListWarning(api.FirewallListWarning o) {
  buildCounterFirewallListWarning++;
  if (buildCounterFirewallListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1721(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterFirewallListWarning--;
}

core.int buildCounterFirewallList = 0;
buildFirewallList() {
  var o = new api.FirewallList();
  buildCounterFirewallList++;
  if (buildCounterFirewallList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1720();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildFirewallListWarning();
  }
  buildCounterFirewallList--;
  return o;
}

checkFirewallList(api.FirewallList o) {
  buildCounterFirewallList++;
  if (buildCounterFirewallList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1720(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkFirewallListWarning(o.warning);
  }
  buildCounterFirewallList--;
}

core.int buildCounterFirewallLogConfig = 0;
buildFirewallLogConfig() {
  var o = new api.FirewallLogConfig();
  buildCounterFirewallLogConfig++;
  if (buildCounterFirewallLogConfig < 3) {
    o.enable = true;
  }
  buildCounterFirewallLogConfig--;
  return o;
}

checkFirewallLogConfig(api.FirewallLogConfig o) {
  buildCounterFirewallLogConfig++;
  if (buildCounterFirewallLogConfig < 3) {
    unittest.expect(o.enable, unittest.isTrue);
  }
  buildCounterFirewallLogConfig--;
}

core.int buildCounterFixedOrPercent = 0;
buildFixedOrPercent() {
  var o = new api.FixedOrPercent();
  buildCounterFixedOrPercent++;
  if (buildCounterFixedOrPercent < 3) {
    o.calculated = 42;
    o.fixed = 42;
    o.percent = 42;
  }
  buildCounterFixedOrPercent--;
  return o;
}

checkFixedOrPercent(api.FixedOrPercent o) {
  buildCounterFixedOrPercent++;
  if (buildCounterFixedOrPercent < 3) {
    unittest.expect(o.calculated, unittest.equals(42));
    unittest.expect(o.fixed, unittest.equals(42));
    unittest.expect(o.percent, unittest.equals(42));
  }
  buildCounterFixedOrPercent--;
}

buildUnnamed1722() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1722(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterForwardingRule = 0;
buildForwardingRule() {
  var o = new api.ForwardingRule();
  buildCounterForwardingRule++;
  if (buildCounterForwardingRule < 3) {
    o.IPAddress = "foo";
    o.IPProtocol = "foo";
    o.allPorts = true;
    o.backendService = "foo";
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.id = "foo";
    o.ipVersion = "foo";
    o.kind = "foo";
    o.loadBalancingScheme = "foo";
    o.name = "foo";
    o.network = "foo";
    o.networkTier = "foo";
    o.portRange = "foo";
    o.ports = buildUnnamed1722();
    o.region = "foo";
    o.selfLink = "foo";
    o.serviceLabel = "foo";
    o.serviceName = "foo";
    o.subnetwork = "foo";
    o.target = "foo";
  }
  buildCounterForwardingRule--;
  return o;
}

checkForwardingRule(api.ForwardingRule o) {
  buildCounterForwardingRule++;
  if (buildCounterForwardingRule < 3) {
    unittest.expect(o.IPAddress, unittest.equals('foo'));
    unittest.expect(o.IPProtocol, unittest.equals('foo'));
    unittest.expect(o.allPorts, unittest.isTrue);
    unittest.expect(o.backendService, unittest.equals('foo'));
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.ipVersion, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.loadBalancingScheme, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.network, unittest.equals('foo'));
    unittest.expect(o.networkTier, unittest.equals('foo'));
    unittest.expect(o.portRange, unittest.equals('foo'));
    checkUnnamed1722(o.ports);
    unittest.expect(o.region, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.serviceLabel, unittest.equals('foo'));
    unittest.expect(o.serviceName, unittest.equals('foo'));
    unittest.expect(o.subnetwork, unittest.equals('foo'));
    unittest.expect(o.target, unittest.equals('foo'));
  }
  buildCounterForwardingRule--;
}

buildUnnamed1723() {
  var o = new core.Map<core.String, api.ForwardingRulesScopedList>();
  o["x"] = buildForwardingRulesScopedList();
  o["y"] = buildForwardingRulesScopedList();
  return o;
}

checkUnnamed1723(core.Map<core.String, api.ForwardingRulesScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkForwardingRulesScopedList(o["x"]);
  checkForwardingRulesScopedList(o["y"]);
}

core.int buildCounterForwardingRuleAggregatedListWarningData = 0;
buildForwardingRuleAggregatedListWarningData() {
  var o = new api.ForwardingRuleAggregatedListWarningData();
  buildCounterForwardingRuleAggregatedListWarningData++;
  if (buildCounterForwardingRuleAggregatedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterForwardingRuleAggregatedListWarningData--;
  return o;
}

checkForwardingRuleAggregatedListWarningData(
    api.ForwardingRuleAggregatedListWarningData o) {
  buildCounterForwardingRuleAggregatedListWarningData++;
  if (buildCounterForwardingRuleAggregatedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterForwardingRuleAggregatedListWarningData--;
}

buildUnnamed1724() {
  var o = new core.List<api.ForwardingRuleAggregatedListWarningData>();
  o.add(buildForwardingRuleAggregatedListWarningData());
  o.add(buildForwardingRuleAggregatedListWarningData());
  return o;
}

checkUnnamed1724(core.List<api.ForwardingRuleAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkForwardingRuleAggregatedListWarningData(o[0]);
  checkForwardingRuleAggregatedListWarningData(o[1]);
}

core.int buildCounterForwardingRuleAggregatedListWarning = 0;
buildForwardingRuleAggregatedListWarning() {
  var o = new api.ForwardingRuleAggregatedListWarning();
  buildCounterForwardingRuleAggregatedListWarning++;
  if (buildCounterForwardingRuleAggregatedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1724();
    o.message = "foo";
  }
  buildCounterForwardingRuleAggregatedListWarning--;
  return o;
}

checkForwardingRuleAggregatedListWarning(
    api.ForwardingRuleAggregatedListWarning o) {
  buildCounterForwardingRuleAggregatedListWarning++;
  if (buildCounterForwardingRuleAggregatedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1724(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterForwardingRuleAggregatedListWarning--;
}

core.int buildCounterForwardingRuleAggregatedList = 0;
buildForwardingRuleAggregatedList() {
  var o = new api.ForwardingRuleAggregatedList();
  buildCounterForwardingRuleAggregatedList++;
  if (buildCounterForwardingRuleAggregatedList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1723();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildForwardingRuleAggregatedListWarning();
  }
  buildCounterForwardingRuleAggregatedList--;
  return o;
}

checkForwardingRuleAggregatedList(api.ForwardingRuleAggregatedList o) {
  buildCounterForwardingRuleAggregatedList++;
  if (buildCounterForwardingRuleAggregatedList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1723(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkForwardingRuleAggregatedListWarning(o.warning);
  }
  buildCounterForwardingRuleAggregatedList--;
}

buildUnnamed1725() {
  var o = new core.List<api.ForwardingRule>();
  o.add(buildForwardingRule());
  o.add(buildForwardingRule());
  return o;
}

checkUnnamed1725(core.List<api.ForwardingRule> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkForwardingRule(o[0]);
  checkForwardingRule(o[1]);
}

core.int buildCounterForwardingRuleListWarningData = 0;
buildForwardingRuleListWarningData() {
  var o = new api.ForwardingRuleListWarningData();
  buildCounterForwardingRuleListWarningData++;
  if (buildCounterForwardingRuleListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterForwardingRuleListWarningData--;
  return o;
}

checkForwardingRuleListWarningData(api.ForwardingRuleListWarningData o) {
  buildCounterForwardingRuleListWarningData++;
  if (buildCounterForwardingRuleListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterForwardingRuleListWarningData--;
}

buildUnnamed1726() {
  var o = new core.List<api.ForwardingRuleListWarningData>();
  o.add(buildForwardingRuleListWarningData());
  o.add(buildForwardingRuleListWarningData());
  return o;
}

checkUnnamed1726(core.List<api.ForwardingRuleListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkForwardingRuleListWarningData(o[0]);
  checkForwardingRuleListWarningData(o[1]);
}

core.int buildCounterForwardingRuleListWarning = 0;
buildForwardingRuleListWarning() {
  var o = new api.ForwardingRuleListWarning();
  buildCounterForwardingRuleListWarning++;
  if (buildCounterForwardingRuleListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1726();
    o.message = "foo";
  }
  buildCounterForwardingRuleListWarning--;
  return o;
}

checkForwardingRuleListWarning(api.ForwardingRuleListWarning o) {
  buildCounterForwardingRuleListWarning++;
  if (buildCounterForwardingRuleListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1726(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterForwardingRuleListWarning--;
}

core.int buildCounterForwardingRuleList = 0;
buildForwardingRuleList() {
  var o = new api.ForwardingRuleList();
  buildCounterForwardingRuleList++;
  if (buildCounterForwardingRuleList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1725();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildForwardingRuleListWarning();
  }
  buildCounterForwardingRuleList--;
  return o;
}

checkForwardingRuleList(api.ForwardingRuleList o) {
  buildCounterForwardingRuleList++;
  if (buildCounterForwardingRuleList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1725(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkForwardingRuleListWarning(o.warning);
  }
  buildCounterForwardingRuleList--;
}

core.int buildCounterForwardingRuleReference = 0;
buildForwardingRuleReference() {
  var o = new api.ForwardingRuleReference();
  buildCounterForwardingRuleReference++;
  if (buildCounterForwardingRuleReference < 3) {
    o.forwardingRule = "foo";
  }
  buildCounterForwardingRuleReference--;
  return o;
}

checkForwardingRuleReference(api.ForwardingRuleReference o) {
  buildCounterForwardingRuleReference++;
  if (buildCounterForwardingRuleReference < 3) {
    unittest.expect(o.forwardingRule, unittest.equals('foo'));
  }
  buildCounterForwardingRuleReference--;
}

buildUnnamed1727() {
  var o = new core.List<api.ForwardingRule>();
  o.add(buildForwardingRule());
  o.add(buildForwardingRule());
  return o;
}

checkUnnamed1727(core.List<api.ForwardingRule> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkForwardingRule(o[0]);
  checkForwardingRule(o[1]);
}

core.int buildCounterForwardingRulesScopedListWarningData = 0;
buildForwardingRulesScopedListWarningData() {
  var o = new api.ForwardingRulesScopedListWarningData();
  buildCounterForwardingRulesScopedListWarningData++;
  if (buildCounterForwardingRulesScopedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterForwardingRulesScopedListWarningData--;
  return o;
}

checkForwardingRulesScopedListWarningData(
    api.ForwardingRulesScopedListWarningData o) {
  buildCounterForwardingRulesScopedListWarningData++;
  if (buildCounterForwardingRulesScopedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterForwardingRulesScopedListWarningData--;
}

buildUnnamed1728() {
  var o = new core.List<api.ForwardingRulesScopedListWarningData>();
  o.add(buildForwardingRulesScopedListWarningData());
  o.add(buildForwardingRulesScopedListWarningData());
  return o;
}

checkUnnamed1728(core.List<api.ForwardingRulesScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkForwardingRulesScopedListWarningData(o[0]);
  checkForwardingRulesScopedListWarningData(o[1]);
}

core.int buildCounterForwardingRulesScopedListWarning = 0;
buildForwardingRulesScopedListWarning() {
  var o = new api.ForwardingRulesScopedListWarning();
  buildCounterForwardingRulesScopedListWarning++;
  if (buildCounterForwardingRulesScopedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1728();
    o.message = "foo";
  }
  buildCounterForwardingRulesScopedListWarning--;
  return o;
}

checkForwardingRulesScopedListWarning(api.ForwardingRulesScopedListWarning o) {
  buildCounterForwardingRulesScopedListWarning++;
  if (buildCounterForwardingRulesScopedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1728(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterForwardingRulesScopedListWarning--;
}

core.int buildCounterForwardingRulesScopedList = 0;
buildForwardingRulesScopedList() {
  var o = new api.ForwardingRulesScopedList();
  buildCounterForwardingRulesScopedList++;
  if (buildCounterForwardingRulesScopedList < 3) {
    o.forwardingRules = buildUnnamed1727();
    o.warning = buildForwardingRulesScopedListWarning();
  }
  buildCounterForwardingRulesScopedList--;
  return o;
}

checkForwardingRulesScopedList(api.ForwardingRulesScopedList o) {
  buildCounterForwardingRulesScopedList++;
  if (buildCounterForwardingRulesScopedList < 3) {
    checkUnnamed1727(o.forwardingRules);
    checkForwardingRulesScopedListWarning(o.warning);
  }
  buildCounterForwardingRulesScopedList--;
}

buildUnnamed1729() {
  var o = new core.Map<core.String, core.String>();
  o["x"] = "foo";
  o["y"] = "foo";
  return o;
}

checkUnnamed1729(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o["x"], unittest.equals('foo'));
  unittest.expect(o["y"], unittest.equals('foo'));
}

core.int buildCounterGlobalSetLabelsRequest = 0;
buildGlobalSetLabelsRequest() {
  var o = new api.GlobalSetLabelsRequest();
  buildCounterGlobalSetLabelsRequest++;
  if (buildCounterGlobalSetLabelsRequest < 3) {
    o.labelFingerprint = "foo";
    o.labels = buildUnnamed1729();
  }
  buildCounterGlobalSetLabelsRequest--;
  return o;
}

checkGlobalSetLabelsRequest(api.GlobalSetLabelsRequest o) {
  buildCounterGlobalSetLabelsRequest++;
  if (buildCounterGlobalSetLabelsRequest < 3) {
    unittest.expect(o.labelFingerprint, unittest.equals('foo'));
    checkUnnamed1729(o.labels);
  }
  buildCounterGlobalSetLabelsRequest--;
}

buildUnnamed1730() {
  var o = new core.List<api.Binding>();
  o.add(buildBinding());
  o.add(buildBinding());
  return o;
}

checkUnnamed1730(core.List<api.Binding> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBinding(o[0]);
  checkBinding(o[1]);
}

core.int buildCounterGlobalSetPolicyRequest = 0;
buildGlobalSetPolicyRequest() {
  var o = new api.GlobalSetPolicyRequest();
  buildCounterGlobalSetPolicyRequest++;
  if (buildCounterGlobalSetPolicyRequest < 3) {
    o.bindings = buildUnnamed1730();
    o.etag = "foo";
    o.policy = buildPolicy();
  }
  buildCounterGlobalSetPolicyRequest--;
  return o;
}

checkGlobalSetPolicyRequest(api.GlobalSetPolicyRequest o) {
  buildCounterGlobalSetPolicyRequest++;
  if (buildCounterGlobalSetPolicyRequest < 3) {
    checkUnnamed1730(o.bindings);
    unittest.expect(o.etag, unittest.equals('foo'));
    checkPolicy(o.policy);
  }
  buildCounterGlobalSetPolicyRequest--;
}

core.int buildCounterGuestAttributes = 0;
buildGuestAttributes() {
  var o = new api.GuestAttributes();
  buildCounterGuestAttributes++;
  if (buildCounterGuestAttributes < 3) {
    o.kind = "foo";
    o.queryPath = "foo";
    o.queryValue = buildGuestAttributesValue();
    o.selfLink = "foo";
    o.variableKey = "foo";
    o.variableValue = "foo";
  }
  buildCounterGuestAttributes--;
  return o;
}

checkGuestAttributes(api.GuestAttributes o) {
  buildCounterGuestAttributes++;
  if (buildCounterGuestAttributes < 3) {
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.queryPath, unittest.equals('foo'));
    checkGuestAttributesValue(o.queryValue);
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.variableKey, unittest.equals('foo'));
    unittest.expect(o.variableValue, unittest.equals('foo'));
  }
  buildCounterGuestAttributes--;
}

core.int buildCounterGuestAttributesEntry = 0;
buildGuestAttributesEntry() {
  var o = new api.GuestAttributesEntry();
  buildCounterGuestAttributesEntry++;
  if (buildCounterGuestAttributesEntry < 3) {
    o.key = "foo";
    o.namespace = "foo";
    o.value = "foo";
  }
  buildCounterGuestAttributesEntry--;
  return o;
}

checkGuestAttributesEntry(api.GuestAttributesEntry o) {
  buildCounterGuestAttributesEntry++;
  if (buildCounterGuestAttributesEntry < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.namespace, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterGuestAttributesEntry--;
}

buildUnnamed1731() {
  var o = new core.List<api.GuestAttributesEntry>();
  o.add(buildGuestAttributesEntry());
  o.add(buildGuestAttributesEntry());
  return o;
}

checkUnnamed1731(core.List<api.GuestAttributesEntry> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkGuestAttributesEntry(o[0]);
  checkGuestAttributesEntry(o[1]);
}

core.int buildCounterGuestAttributesValue = 0;
buildGuestAttributesValue() {
  var o = new api.GuestAttributesValue();
  buildCounterGuestAttributesValue++;
  if (buildCounterGuestAttributesValue < 3) {
    o.items = buildUnnamed1731();
  }
  buildCounterGuestAttributesValue--;
  return o;
}

checkGuestAttributesValue(api.GuestAttributesValue o) {
  buildCounterGuestAttributesValue++;
  if (buildCounterGuestAttributesValue < 3) {
    checkUnnamed1731(o.items);
  }
  buildCounterGuestAttributesValue--;
}

core.int buildCounterGuestOsFeature = 0;
buildGuestOsFeature() {
  var o = new api.GuestOsFeature();
  buildCounterGuestOsFeature++;
  if (buildCounterGuestOsFeature < 3) {
    o.type = "foo";
  }
  buildCounterGuestOsFeature--;
  return o;
}

checkGuestOsFeature(api.GuestOsFeature o) {
  buildCounterGuestOsFeature++;
  if (buildCounterGuestOsFeature < 3) {
    unittest.expect(o.type, unittest.equals('foo'));
  }
  buildCounterGuestOsFeature--;
}

core.int buildCounterHTTP2HealthCheck = 0;
buildHTTP2HealthCheck() {
  var o = new api.HTTP2HealthCheck();
  buildCounterHTTP2HealthCheck++;
  if (buildCounterHTTP2HealthCheck < 3) {
    o.host = "foo";
    o.port = 42;
    o.portName = "foo";
    o.portSpecification = "foo";
    o.proxyHeader = "foo";
    o.requestPath = "foo";
    o.response = "foo";
  }
  buildCounterHTTP2HealthCheck--;
  return o;
}

checkHTTP2HealthCheck(api.HTTP2HealthCheck o) {
  buildCounterHTTP2HealthCheck++;
  if (buildCounterHTTP2HealthCheck < 3) {
    unittest.expect(o.host, unittest.equals('foo'));
    unittest.expect(o.port, unittest.equals(42));
    unittest.expect(o.portName, unittest.equals('foo'));
    unittest.expect(o.portSpecification, unittest.equals('foo'));
    unittest.expect(o.proxyHeader, unittest.equals('foo'));
    unittest.expect(o.requestPath, unittest.equals('foo'));
    unittest.expect(o.response, unittest.equals('foo'));
  }
  buildCounterHTTP2HealthCheck--;
}

core.int buildCounterHTTPHealthCheck = 0;
buildHTTPHealthCheck() {
  var o = new api.HTTPHealthCheck();
  buildCounterHTTPHealthCheck++;
  if (buildCounterHTTPHealthCheck < 3) {
    o.host = "foo";
    o.port = 42;
    o.portName = "foo";
    o.portSpecification = "foo";
    o.proxyHeader = "foo";
    o.requestPath = "foo";
    o.response = "foo";
  }
  buildCounterHTTPHealthCheck--;
  return o;
}

checkHTTPHealthCheck(api.HTTPHealthCheck o) {
  buildCounterHTTPHealthCheck++;
  if (buildCounterHTTPHealthCheck < 3) {
    unittest.expect(o.host, unittest.equals('foo'));
    unittest.expect(o.port, unittest.equals(42));
    unittest.expect(o.portName, unittest.equals('foo'));
    unittest.expect(o.portSpecification, unittest.equals('foo'));
    unittest.expect(o.proxyHeader, unittest.equals('foo'));
    unittest.expect(o.requestPath, unittest.equals('foo'));
    unittest.expect(o.response, unittest.equals('foo'));
  }
  buildCounterHTTPHealthCheck--;
}

core.int buildCounterHTTPSHealthCheck = 0;
buildHTTPSHealthCheck() {
  var o = new api.HTTPSHealthCheck();
  buildCounterHTTPSHealthCheck++;
  if (buildCounterHTTPSHealthCheck < 3) {
    o.host = "foo";
    o.port = 42;
    o.portName = "foo";
    o.portSpecification = "foo";
    o.proxyHeader = "foo";
    o.requestPath = "foo";
    o.response = "foo";
  }
  buildCounterHTTPSHealthCheck--;
  return o;
}

checkHTTPSHealthCheck(api.HTTPSHealthCheck o) {
  buildCounterHTTPSHealthCheck++;
  if (buildCounterHTTPSHealthCheck < 3) {
    unittest.expect(o.host, unittest.equals('foo'));
    unittest.expect(o.port, unittest.equals(42));
    unittest.expect(o.portName, unittest.equals('foo'));
    unittest.expect(o.portSpecification, unittest.equals('foo'));
    unittest.expect(o.proxyHeader, unittest.equals('foo'));
    unittest.expect(o.requestPath, unittest.equals('foo'));
    unittest.expect(o.response, unittest.equals('foo'));
  }
  buildCounterHTTPSHealthCheck--;
}

core.int buildCounterHealthCheck = 0;
buildHealthCheck() {
  var o = new api.HealthCheck();
  buildCounterHealthCheck++;
  if (buildCounterHealthCheck < 3) {
    o.checkIntervalSec = 42;
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.healthyThreshold = 42;
    o.http2HealthCheck = buildHTTP2HealthCheck();
    o.httpHealthCheck = buildHTTPHealthCheck();
    o.httpsHealthCheck = buildHTTPSHealthCheck();
    o.id = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.selfLink = "foo";
    o.sslHealthCheck = buildSSLHealthCheck();
    o.tcpHealthCheck = buildTCPHealthCheck();
    o.timeoutSec = 42;
    o.type = "foo";
    o.unhealthyThreshold = 42;
  }
  buildCounterHealthCheck--;
  return o;
}

checkHealthCheck(api.HealthCheck o) {
  buildCounterHealthCheck++;
  if (buildCounterHealthCheck < 3) {
    unittest.expect(o.checkIntervalSec, unittest.equals(42));
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.healthyThreshold, unittest.equals(42));
    checkHTTP2HealthCheck(o.http2HealthCheck);
    checkHTTPHealthCheck(o.httpHealthCheck);
    checkHTTPSHealthCheck(o.httpsHealthCheck);
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkSSLHealthCheck(o.sslHealthCheck);
    checkTCPHealthCheck(o.tcpHealthCheck);
    unittest.expect(o.timeoutSec, unittest.equals(42));
    unittest.expect(o.type, unittest.equals('foo'));
    unittest.expect(o.unhealthyThreshold, unittest.equals(42));
  }
  buildCounterHealthCheck--;
}

buildUnnamed1732() {
  var o = new core.List<api.HealthCheck>();
  o.add(buildHealthCheck());
  o.add(buildHealthCheck());
  return o;
}

checkUnnamed1732(core.List<api.HealthCheck> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkHealthCheck(o[0]);
  checkHealthCheck(o[1]);
}

core.int buildCounterHealthCheckListWarningData = 0;
buildHealthCheckListWarningData() {
  var o = new api.HealthCheckListWarningData();
  buildCounterHealthCheckListWarningData++;
  if (buildCounterHealthCheckListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterHealthCheckListWarningData--;
  return o;
}

checkHealthCheckListWarningData(api.HealthCheckListWarningData o) {
  buildCounterHealthCheckListWarningData++;
  if (buildCounterHealthCheckListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterHealthCheckListWarningData--;
}

buildUnnamed1733() {
  var o = new core.List<api.HealthCheckListWarningData>();
  o.add(buildHealthCheckListWarningData());
  o.add(buildHealthCheckListWarningData());
  return o;
}

checkUnnamed1733(core.List<api.HealthCheckListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkHealthCheckListWarningData(o[0]);
  checkHealthCheckListWarningData(o[1]);
}

core.int buildCounterHealthCheckListWarning = 0;
buildHealthCheckListWarning() {
  var o = new api.HealthCheckListWarning();
  buildCounterHealthCheckListWarning++;
  if (buildCounterHealthCheckListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1733();
    o.message = "foo";
  }
  buildCounterHealthCheckListWarning--;
  return o;
}

checkHealthCheckListWarning(api.HealthCheckListWarning o) {
  buildCounterHealthCheckListWarning++;
  if (buildCounterHealthCheckListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1733(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterHealthCheckListWarning--;
}

core.int buildCounterHealthCheckList = 0;
buildHealthCheckList() {
  var o = new api.HealthCheckList();
  buildCounterHealthCheckList++;
  if (buildCounterHealthCheckList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1732();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildHealthCheckListWarning();
  }
  buildCounterHealthCheckList--;
  return o;
}

checkHealthCheckList(api.HealthCheckList o) {
  buildCounterHealthCheckList++;
  if (buildCounterHealthCheckList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1732(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkHealthCheckListWarning(o.warning);
  }
  buildCounterHealthCheckList--;
}

core.int buildCounterHealthCheckReference = 0;
buildHealthCheckReference() {
  var o = new api.HealthCheckReference();
  buildCounterHealthCheckReference++;
  if (buildCounterHealthCheckReference < 3) {
    o.healthCheck = "foo";
  }
  buildCounterHealthCheckReference--;
  return o;
}

checkHealthCheckReference(api.HealthCheckReference o) {
  buildCounterHealthCheckReference++;
  if (buildCounterHealthCheckReference < 3) {
    unittest.expect(o.healthCheck, unittest.equals('foo'));
  }
  buildCounterHealthCheckReference--;
}

core.int buildCounterHealthStatus = 0;
buildHealthStatus() {
  var o = new api.HealthStatus();
  buildCounterHealthStatus++;
  if (buildCounterHealthStatus < 3) {
    o.healthState = "foo";
    o.instance = "foo";
    o.ipAddress = "foo";
    o.port = 42;
  }
  buildCounterHealthStatus--;
  return o;
}

checkHealthStatus(api.HealthStatus o) {
  buildCounterHealthStatus++;
  if (buildCounterHealthStatus < 3) {
    unittest.expect(o.healthState, unittest.equals('foo'));
    unittest.expect(o.instance, unittest.equals('foo'));
    unittest.expect(o.ipAddress, unittest.equals('foo'));
    unittest.expect(o.port, unittest.equals(42));
  }
  buildCounterHealthStatus--;
}

core.int buildCounterHealthStatusForNetworkEndpoint = 0;
buildHealthStatusForNetworkEndpoint() {
  var o = new api.HealthStatusForNetworkEndpoint();
  buildCounterHealthStatusForNetworkEndpoint++;
  if (buildCounterHealthStatusForNetworkEndpoint < 3) {
    o.backendService = buildBackendServiceReference();
    o.forwardingRule = buildForwardingRuleReference();
    o.healthCheck = buildHealthCheckReference();
    o.healthState = "foo";
  }
  buildCounterHealthStatusForNetworkEndpoint--;
  return o;
}

checkHealthStatusForNetworkEndpoint(api.HealthStatusForNetworkEndpoint o) {
  buildCounterHealthStatusForNetworkEndpoint++;
  if (buildCounterHealthStatusForNetworkEndpoint < 3) {
    checkBackendServiceReference(o.backendService);
    checkForwardingRuleReference(o.forwardingRule);
    checkHealthCheckReference(o.healthCheck);
    unittest.expect(o.healthState, unittest.equals('foo'));
  }
  buildCounterHealthStatusForNetworkEndpoint--;
}

buildUnnamed1734() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1734(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterHostRule = 0;
buildHostRule() {
  var o = new api.HostRule();
  buildCounterHostRule++;
  if (buildCounterHostRule < 3) {
    o.description = "foo";
    o.hosts = buildUnnamed1734();
    o.pathMatcher = "foo";
  }
  buildCounterHostRule--;
  return o;
}

checkHostRule(api.HostRule o) {
  buildCounterHostRule++;
  if (buildCounterHostRule < 3) {
    unittest.expect(o.description, unittest.equals('foo'));
    checkUnnamed1734(o.hosts);
    unittest.expect(o.pathMatcher, unittest.equals('foo'));
  }
  buildCounterHostRule--;
}

core.int buildCounterHttpHealthCheck = 0;
buildHttpHealthCheck() {
  var o = new api.HttpHealthCheck();
  buildCounterHttpHealthCheck++;
  if (buildCounterHttpHealthCheck < 3) {
    o.checkIntervalSec = 42;
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.healthyThreshold = 42;
    o.host = "foo";
    o.id = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.port = 42;
    o.requestPath = "foo";
    o.selfLink = "foo";
    o.timeoutSec = 42;
    o.unhealthyThreshold = 42;
  }
  buildCounterHttpHealthCheck--;
  return o;
}

checkHttpHealthCheck(api.HttpHealthCheck o) {
  buildCounterHttpHealthCheck++;
  if (buildCounterHttpHealthCheck < 3) {
    unittest.expect(o.checkIntervalSec, unittest.equals(42));
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.healthyThreshold, unittest.equals(42));
    unittest.expect(o.host, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.port, unittest.equals(42));
    unittest.expect(o.requestPath, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.timeoutSec, unittest.equals(42));
    unittest.expect(o.unhealthyThreshold, unittest.equals(42));
  }
  buildCounterHttpHealthCheck--;
}

buildUnnamed1735() {
  var o = new core.List<api.HttpHealthCheck>();
  o.add(buildHttpHealthCheck());
  o.add(buildHttpHealthCheck());
  return o;
}

checkUnnamed1735(core.List<api.HttpHealthCheck> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkHttpHealthCheck(o[0]);
  checkHttpHealthCheck(o[1]);
}

core.int buildCounterHttpHealthCheckListWarningData = 0;
buildHttpHealthCheckListWarningData() {
  var o = new api.HttpHealthCheckListWarningData();
  buildCounterHttpHealthCheckListWarningData++;
  if (buildCounterHttpHealthCheckListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterHttpHealthCheckListWarningData--;
  return o;
}

checkHttpHealthCheckListWarningData(api.HttpHealthCheckListWarningData o) {
  buildCounterHttpHealthCheckListWarningData++;
  if (buildCounterHttpHealthCheckListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterHttpHealthCheckListWarningData--;
}

buildUnnamed1736() {
  var o = new core.List<api.HttpHealthCheckListWarningData>();
  o.add(buildHttpHealthCheckListWarningData());
  o.add(buildHttpHealthCheckListWarningData());
  return o;
}

checkUnnamed1736(core.List<api.HttpHealthCheckListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkHttpHealthCheckListWarningData(o[0]);
  checkHttpHealthCheckListWarningData(o[1]);
}

core.int buildCounterHttpHealthCheckListWarning = 0;
buildHttpHealthCheckListWarning() {
  var o = new api.HttpHealthCheckListWarning();
  buildCounterHttpHealthCheckListWarning++;
  if (buildCounterHttpHealthCheckListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1736();
    o.message = "foo";
  }
  buildCounterHttpHealthCheckListWarning--;
  return o;
}

checkHttpHealthCheckListWarning(api.HttpHealthCheckListWarning o) {
  buildCounterHttpHealthCheckListWarning++;
  if (buildCounterHttpHealthCheckListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1736(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterHttpHealthCheckListWarning--;
}

core.int buildCounterHttpHealthCheckList = 0;
buildHttpHealthCheckList() {
  var o = new api.HttpHealthCheckList();
  buildCounterHttpHealthCheckList++;
  if (buildCounterHttpHealthCheckList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1735();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildHttpHealthCheckListWarning();
  }
  buildCounterHttpHealthCheckList--;
  return o;
}

checkHttpHealthCheckList(api.HttpHealthCheckList o) {
  buildCounterHttpHealthCheckList++;
  if (buildCounterHttpHealthCheckList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1735(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkHttpHealthCheckListWarning(o.warning);
  }
  buildCounterHttpHealthCheckList--;
}

core.int buildCounterHttpsHealthCheck = 0;
buildHttpsHealthCheck() {
  var o = new api.HttpsHealthCheck();
  buildCounterHttpsHealthCheck++;
  if (buildCounterHttpsHealthCheck < 3) {
    o.checkIntervalSec = 42;
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.healthyThreshold = 42;
    o.host = "foo";
    o.id = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.port = 42;
    o.requestPath = "foo";
    o.selfLink = "foo";
    o.timeoutSec = 42;
    o.unhealthyThreshold = 42;
  }
  buildCounterHttpsHealthCheck--;
  return o;
}

checkHttpsHealthCheck(api.HttpsHealthCheck o) {
  buildCounterHttpsHealthCheck++;
  if (buildCounterHttpsHealthCheck < 3) {
    unittest.expect(o.checkIntervalSec, unittest.equals(42));
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.healthyThreshold, unittest.equals(42));
    unittest.expect(o.host, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.port, unittest.equals(42));
    unittest.expect(o.requestPath, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.timeoutSec, unittest.equals(42));
    unittest.expect(o.unhealthyThreshold, unittest.equals(42));
  }
  buildCounterHttpsHealthCheck--;
}

buildUnnamed1737() {
  var o = new core.List<api.HttpsHealthCheck>();
  o.add(buildHttpsHealthCheck());
  o.add(buildHttpsHealthCheck());
  return o;
}

checkUnnamed1737(core.List<api.HttpsHealthCheck> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkHttpsHealthCheck(o[0]);
  checkHttpsHealthCheck(o[1]);
}

core.int buildCounterHttpsHealthCheckListWarningData = 0;
buildHttpsHealthCheckListWarningData() {
  var o = new api.HttpsHealthCheckListWarningData();
  buildCounterHttpsHealthCheckListWarningData++;
  if (buildCounterHttpsHealthCheckListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterHttpsHealthCheckListWarningData--;
  return o;
}

checkHttpsHealthCheckListWarningData(api.HttpsHealthCheckListWarningData o) {
  buildCounterHttpsHealthCheckListWarningData++;
  if (buildCounterHttpsHealthCheckListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterHttpsHealthCheckListWarningData--;
}

buildUnnamed1738() {
  var o = new core.List<api.HttpsHealthCheckListWarningData>();
  o.add(buildHttpsHealthCheckListWarningData());
  o.add(buildHttpsHealthCheckListWarningData());
  return o;
}

checkUnnamed1738(core.List<api.HttpsHealthCheckListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkHttpsHealthCheckListWarningData(o[0]);
  checkHttpsHealthCheckListWarningData(o[1]);
}

core.int buildCounterHttpsHealthCheckListWarning = 0;
buildHttpsHealthCheckListWarning() {
  var o = new api.HttpsHealthCheckListWarning();
  buildCounterHttpsHealthCheckListWarning++;
  if (buildCounterHttpsHealthCheckListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1738();
    o.message = "foo";
  }
  buildCounterHttpsHealthCheckListWarning--;
  return o;
}

checkHttpsHealthCheckListWarning(api.HttpsHealthCheckListWarning o) {
  buildCounterHttpsHealthCheckListWarning++;
  if (buildCounterHttpsHealthCheckListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1738(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterHttpsHealthCheckListWarning--;
}

core.int buildCounterHttpsHealthCheckList = 0;
buildHttpsHealthCheckList() {
  var o = new api.HttpsHealthCheckList();
  buildCounterHttpsHealthCheckList++;
  if (buildCounterHttpsHealthCheckList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1737();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildHttpsHealthCheckListWarning();
  }
  buildCounterHttpsHealthCheckList--;
  return o;
}

checkHttpsHealthCheckList(api.HttpsHealthCheckList o) {
  buildCounterHttpsHealthCheckList++;
  if (buildCounterHttpsHealthCheckList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1737(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkHttpsHealthCheckListWarning(o.warning);
  }
  buildCounterHttpsHealthCheckList--;
}

buildUnnamed1739() {
  var o = new core.List<api.GuestOsFeature>();
  o.add(buildGuestOsFeature());
  o.add(buildGuestOsFeature());
  return o;
}

checkUnnamed1739(core.List<api.GuestOsFeature> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkGuestOsFeature(o[0]);
  checkGuestOsFeature(o[1]);
}

buildUnnamed1740() {
  var o = new core.Map<core.String, core.String>();
  o["x"] = "foo";
  o["y"] = "foo";
  return o;
}

checkUnnamed1740(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o["x"], unittest.equals('foo'));
  unittest.expect(o["y"], unittest.equals('foo'));
}

buildUnnamed1741() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1741(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

buildUnnamed1742() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1742(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterImageRawDisk = 0;
buildImageRawDisk() {
  var o = new api.ImageRawDisk();
  buildCounterImageRawDisk++;
  if (buildCounterImageRawDisk < 3) {
    o.containerType = "foo";
    o.sha1Checksum = "foo";
    o.source = "foo";
  }
  buildCounterImageRawDisk--;
  return o;
}

checkImageRawDisk(api.ImageRawDisk o) {
  buildCounterImageRawDisk++;
  if (buildCounterImageRawDisk < 3) {
    unittest.expect(o.containerType, unittest.equals('foo'));
    unittest.expect(o.sha1Checksum, unittest.equals('foo'));
    unittest.expect(o.source, unittest.equals('foo'));
  }
  buildCounterImageRawDisk--;
}

core.int buildCounterImage = 0;
buildImage() {
  var o = new api.Image();
  buildCounterImage++;
  if (buildCounterImage < 3) {
    o.archiveSizeBytes = "foo";
    o.creationTimestamp = "foo";
    o.deprecated = buildDeprecationStatus();
    o.description = "foo";
    o.diskSizeGb = "foo";
    o.family = "foo";
    o.guestOsFeatures = buildUnnamed1739();
    o.id = "foo";
    o.imageEncryptionKey = buildCustomerEncryptionKey();
    o.kind = "foo";
    o.labelFingerprint = "foo";
    o.labels = buildUnnamed1740();
    o.licenseCodes = buildUnnamed1741();
    o.licenses = buildUnnamed1742();
    o.name = "foo";
    o.rawDisk = buildImageRawDisk();
    o.selfLink = "foo";
    o.sourceDisk = "foo";
    o.sourceDiskEncryptionKey = buildCustomerEncryptionKey();
    o.sourceDiskId = "foo";
    o.sourceImage = "foo";
    o.sourceImageEncryptionKey = buildCustomerEncryptionKey();
    o.sourceImageId = "foo";
    o.sourceSnapshot = "foo";
    o.sourceSnapshotEncryptionKey = buildCustomerEncryptionKey();
    o.sourceSnapshotId = "foo";
    o.sourceType = "foo";
    o.status = "foo";
  }
  buildCounterImage--;
  return o;
}

checkImage(api.Image o) {
  buildCounterImage++;
  if (buildCounterImage < 3) {
    unittest.expect(o.archiveSizeBytes, unittest.equals('foo'));
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    checkDeprecationStatus(o.deprecated);
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.diskSizeGb, unittest.equals('foo'));
    unittest.expect(o.family, unittest.equals('foo'));
    checkUnnamed1739(o.guestOsFeatures);
    unittest.expect(o.id, unittest.equals('foo'));
    checkCustomerEncryptionKey(o.imageEncryptionKey);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.labelFingerprint, unittest.equals('foo'));
    checkUnnamed1740(o.labels);
    checkUnnamed1741(o.licenseCodes);
    checkUnnamed1742(o.licenses);
    unittest.expect(o.name, unittest.equals('foo'));
    checkImageRawDisk(o.rawDisk);
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.sourceDisk, unittest.equals('foo'));
    checkCustomerEncryptionKey(o.sourceDiskEncryptionKey);
    unittest.expect(o.sourceDiskId, unittest.equals('foo'));
    unittest.expect(o.sourceImage, unittest.equals('foo'));
    checkCustomerEncryptionKey(o.sourceImageEncryptionKey);
    unittest.expect(o.sourceImageId, unittest.equals('foo'));
    unittest.expect(o.sourceSnapshot, unittest.equals('foo'));
    checkCustomerEncryptionKey(o.sourceSnapshotEncryptionKey);
    unittest.expect(o.sourceSnapshotId, unittest.equals('foo'));
    unittest.expect(o.sourceType, unittest.equals('foo'));
    unittest.expect(o.status, unittest.equals('foo'));
  }
  buildCounterImage--;
}

buildUnnamed1743() {
  var o = new core.List<api.Image>();
  o.add(buildImage());
  o.add(buildImage());
  return o;
}

checkUnnamed1743(core.List<api.Image> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkImage(o[0]);
  checkImage(o[1]);
}

core.int buildCounterImageListWarningData = 0;
buildImageListWarningData() {
  var o = new api.ImageListWarningData();
  buildCounterImageListWarningData++;
  if (buildCounterImageListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterImageListWarningData--;
  return o;
}

checkImageListWarningData(api.ImageListWarningData o) {
  buildCounterImageListWarningData++;
  if (buildCounterImageListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterImageListWarningData--;
}

buildUnnamed1744() {
  var o = new core.List<api.ImageListWarningData>();
  o.add(buildImageListWarningData());
  o.add(buildImageListWarningData());
  return o;
}

checkUnnamed1744(core.List<api.ImageListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkImageListWarningData(o[0]);
  checkImageListWarningData(o[1]);
}

core.int buildCounterImageListWarning = 0;
buildImageListWarning() {
  var o = new api.ImageListWarning();
  buildCounterImageListWarning++;
  if (buildCounterImageListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1744();
    o.message = "foo";
  }
  buildCounterImageListWarning--;
  return o;
}

checkImageListWarning(api.ImageListWarning o) {
  buildCounterImageListWarning++;
  if (buildCounterImageListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1744(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterImageListWarning--;
}

core.int buildCounterImageList = 0;
buildImageList() {
  var o = new api.ImageList();
  buildCounterImageList++;
  if (buildCounterImageList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1743();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildImageListWarning();
  }
  buildCounterImageList--;
  return o;
}

checkImageList(api.ImageList o) {
  buildCounterImageList++;
  if (buildCounterImageList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1743(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkImageListWarning(o.warning);
  }
  buildCounterImageList--;
}

buildUnnamed1745() {
  var o = new core.List<api.AttachedDisk>();
  o.add(buildAttachedDisk());
  o.add(buildAttachedDisk());
  return o;
}

checkUnnamed1745(core.List<api.AttachedDisk> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAttachedDisk(o[0]);
  checkAttachedDisk(o[1]);
}

buildUnnamed1746() {
  var o = new core.List<api.AcceleratorConfig>();
  o.add(buildAcceleratorConfig());
  o.add(buildAcceleratorConfig());
  return o;
}

checkUnnamed1746(core.List<api.AcceleratorConfig> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAcceleratorConfig(o[0]);
  checkAcceleratorConfig(o[1]);
}

buildUnnamed1747() {
  var o = new core.Map<core.String, core.String>();
  o["x"] = "foo";
  o["y"] = "foo";
  return o;
}

checkUnnamed1747(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o["x"], unittest.equals('foo'));
  unittest.expect(o["y"], unittest.equals('foo'));
}

buildUnnamed1748() {
  var o = new core.List<api.NetworkInterface>();
  o.add(buildNetworkInterface());
  o.add(buildNetworkInterface());
  return o;
}

checkUnnamed1748(core.List<api.NetworkInterface> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkInterface(o[0]);
  checkNetworkInterface(o[1]);
}

buildUnnamed1749() {
  var o = new core.List<api.ServiceAccount>();
  o.add(buildServiceAccount());
  o.add(buildServiceAccount());
  return o;
}

checkUnnamed1749(core.List<api.ServiceAccount> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkServiceAccount(o[0]);
  checkServiceAccount(o[1]);
}

core.int buildCounterInstance = 0;
buildInstance() {
  var o = new api.Instance();
  buildCounterInstance++;
  if (buildCounterInstance < 3) {
    o.canIpForward = true;
    o.cpuPlatform = "foo";
    o.creationTimestamp = "foo";
    o.deletionProtection = true;
    o.description = "foo";
    o.disks = buildUnnamed1745();
    o.guestAccelerators = buildUnnamed1746();
    o.hostname = "foo";
    o.id = "foo";
    o.kind = "foo";
    o.labelFingerprint = "foo";
    o.labels = buildUnnamed1747();
    o.machineType = "foo";
    o.metadata = buildMetadata();
    o.minCpuPlatform = "foo";
    o.name = "foo";
    o.networkInterfaces = buildUnnamed1748();
    o.reservationAffinity = buildReservationAffinity();
    o.scheduling = buildScheduling();
    o.selfLink = "foo";
    o.serviceAccounts = buildUnnamed1749();
    o.shieldedInstanceConfig = buildShieldedInstanceConfig();
    o.shieldedInstanceIntegrityPolicy = buildShieldedInstanceIntegrityPolicy();
    o.startRestricted = true;
    o.status = "foo";
    o.statusMessage = "foo";
    o.tags = buildTags();
    o.zone = "foo";
  }
  buildCounterInstance--;
  return o;
}

checkInstance(api.Instance o) {
  buildCounterInstance++;
  if (buildCounterInstance < 3) {
    unittest.expect(o.canIpForward, unittest.isTrue);
    unittest.expect(o.cpuPlatform, unittest.equals('foo'));
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.deletionProtection, unittest.isTrue);
    unittest.expect(o.description, unittest.equals('foo'));
    checkUnnamed1745(o.disks);
    checkUnnamed1746(o.guestAccelerators);
    unittest.expect(o.hostname, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.labelFingerprint, unittest.equals('foo'));
    checkUnnamed1747(o.labels);
    unittest.expect(o.machineType, unittest.equals('foo'));
    checkMetadata(o.metadata);
    unittest.expect(o.minCpuPlatform, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    checkUnnamed1748(o.networkInterfaces);
    checkReservationAffinity(o.reservationAffinity);
    checkScheduling(o.scheduling);
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkUnnamed1749(o.serviceAccounts);
    checkShieldedInstanceConfig(o.shieldedInstanceConfig);
    checkShieldedInstanceIntegrityPolicy(o.shieldedInstanceIntegrityPolicy);
    unittest.expect(o.startRestricted, unittest.isTrue);
    unittest.expect(o.status, unittest.equals('foo'));
    unittest.expect(o.statusMessage, unittest.equals('foo'));
    checkTags(o.tags);
    unittest.expect(o.zone, unittest.equals('foo'));
  }
  buildCounterInstance--;
}

buildUnnamed1750() {
  var o = new core.Map<core.String, api.InstancesScopedList>();
  o["x"] = buildInstancesScopedList();
  o["y"] = buildInstancesScopedList();
  return o;
}

checkUnnamed1750(core.Map<core.String, api.InstancesScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstancesScopedList(o["x"]);
  checkInstancesScopedList(o["y"]);
}

core.int buildCounterInstanceAggregatedListWarningData = 0;
buildInstanceAggregatedListWarningData() {
  var o = new api.InstanceAggregatedListWarningData();
  buildCounterInstanceAggregatedListWarningData++;
  if (buildCounterInstanceAggregatedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterInstanceAggregatedListWarningData--;
  return o;
}

checkInstanceAggregatedListWarningData(
    api.InstanceAggregatedListWarningData o) {
  buildCounterInstanceAggregatedListWarningData++;
  if (buildCounterInstanceAggregatedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterInstanceAggregatedListWarningData--;
}

buildUnnamed1751() {
  var o = new core.List<api.InstanceAggregatedListWarningData>();
  o.add(buildInstanceAggregatedListWarningData());
  o.add(buildInstanceAggregatedListWarningData());
  return o;
}

checkUnnamed1751(core.List<api.InstanceAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceAggregatedListWarningData(o[0]);
  checkInstanceAggregatedListWarningData(o[1]);
}

core.int buildCounterInstanceAggregatedListWarning = 0;
buildInstanceAggregatedListWarning() {
  var o = new api.InstanceAggregatedListWarning();
  buildCounterInstanceAggregatedListWarning++;
  if (buildCounterInstanceAggregatedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1751();
    o.message = "foo";
  }
  buildCounterInstanceAggregatedListWarning--;
  return o;
}

checkInstanceAggregatedListWarning(api.InstanceAggregatedListWarning o) {
  buildCounterInstanceAggregatedListWarning++;
  if (buildCounterInstanceAggregatedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1751(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterInstanceAggregatedListWarning--;
}

core.int buildCounterInstanceAggregatedList = 0;
buildInstanceAggregatedList() {
  var o = new api.InstanceAggregatedList();
  buildCounterInstanceAggregatedList++;
  if (buildCounterInstanceAggregatedList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1750();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildInstanceAggregatedListWarning();
  }
  buildCounterInstanceAggregatedList--;
  return o;
}

checkInstanceAggregatedList(api.InstanceAggregatedList o) {
  buildCounterInstanceAggregatedList++;
  if (buildCounterInstanceAggregatedList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1750(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkInstanceAggregatedListWarning(o.warning);
  }
  buildCounterInstanceAggregatedList--;
}

buildUnnamed1752() {
  var o = new core.List<api.NamedPort>();
  o.add(buildNamedPort());
  o.add(buildNamedPort());
  return o;
}

checkUnnamed1752(core.List<api.NamedPort> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNamedPort(o[0]);
  checkNamedPort(o[1]);
}

core.int buildCounterInstanceGroup = 0;
buildInstanceGroup() {
  var o = new api.InstanceGroup();
  buildCounterInstanceGroup++;
  if (buildCounterInstanceGroup < 3) {
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.fingerprint = "foo";
    o.id = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.namedPorts = buildUnnamed1752();
    o.network = "foo";
    o.region = "foo";
    o.selfLink = "foo";
    o.size = 42;
    o.subnetwork = "foo";
    o.zone = "foo";
  }
  buildCounterInstanceGroup--;
  return o;
}

checkInstanceGroup(api.InstanceGroup o) {
  buildCounterInstanceGroup++;
  if (buildCounterInstanceGroup < 3) {
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.fingerprint, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    checkUnnamed1752(o.namedPorts);
    unittest.expect(o.network, unittest.equals('foo'));
    unittest.expect(o.region, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.size, unittest.equals(42));
    unittest.expect(o.subnetwork, unittest.equals('foo'));
    unittest.expect(o.zone, unittest.equals('foo'));
  }
  buildCounterInstanceGroup--;
}

buildUnnamed1753() {
  var o = new core.Map<core.String, api.InstanceGroupsScopedList>();
  o["x"] = buildInstanceGroupsScopedList();
  o["y"] = buildInstanceGroupsScopedList();
  return o;
}

checkUnnamed1753(core.Map<core.String, api.InstanceGroupsScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroupsScopedList(o["x"]);
  checkInstanceGroupsScopedList(o["y"]);
}

core.int buildCounterInstanceGroupAggregatedListWarningData = 0;
buildInstanceGroupAggregatedListWarningData() {
  var o = new api.InstanceGroupAggregatedListWarningData();
  buildCounterInstanceGroupAggregatedListWarningData++;
  if (buildCounterInstanceGroupAggregatedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterInstanceGroupAggregatedListWarningData--;
  return o;
}

checkInstanceGroupAggregatedListWarningData(
    api.InstanceGroupAggregatedListWarningData o) {
  buildCounterInstanceGroupAggregatedListWarningData++;
  if (buildCounterInstanceGroupAggregatedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterInstanceGroupAggregatedListWarningData--;
}

buildUnnamed1754() {
  var o = new core.List<api.InstanceGroupAggregatedListWarningData>();
  o.add(buildInstanceGroupAggregatedListWarningData());
  o.add(buildInstanceGroupAggregatedListWarningData());
  return o;
}

checkUnnamed1754(core.List<api.InstanceGroupAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroupAggregatedListWarningData(o[0]);
  checkInstanceGroupAggregatedListWarningData(o[1]);
}

core.int buildCounterInstanceGroupAggregatedListWarning = 0;
buildInstanceGroupAggregatedListWarning() {
  var o = new api.InstanceGroupAggregatedListWarning();
  buildCounterInstanceGroupAggregatedListWarning++;
  if (buildCounterInstanceGroupAggregatedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1754();
    o.message = "foo";
  }
  buildCounterInstanceGroupAggregatedListWarning--;
  return o;
}

checkInstanceGroupAggregatedListWarning(
    api.InstanceGroupAggregatedListWarning o) {
  buildCounterInstanceGroupAggregatedListWarning++;
  if (buildCounterInstanceGroupAggregatedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1754(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterInstanceGroupAggregatedListWarning--;
}

core.int buildCounterInstanceGroupAggregatedList = 0;
buildInstanceGroupAggregatedList() {
  var o = new api.InstanceGroupAggregatedList();
  buildCounterInstanceGroupAggregatedList++;
  if (buildCounterInstanceGroupAggregatedList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1753();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildInstanceGroupAggregatedListWarning();
  }
  buildCounterInstanceGroupAggregatedList--;
  return o;
}

checkInstanceGroupAggregatedList(api.InstanceGroupAggregatedList o) {
  buildCounterInstanceGroupAggregatedList++;
  if (buildCounterInstanceGroupAggregatedList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1753(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkInstanceGroupAggregatedListWarning(o.warning);
  }
  buildCounterInstanceGroupAggregatedList--;
}

buildUnnamed1755() {
  var o = new core.List<api.InstanceGroup>();
  o.add(buildInstanceGroup());
  o.add(buildInstanceGroup());
  return o;
}

checkUnnamed1755(core.List<api.InstanceGroup> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroup(o[0]);
  checkInstanceGroup(o[1]);
}

core.int buildCounterInstanceGroupListWarningData = 0;
buildInstanceGroupListWarningData() {
  var o = new api.InstanceGroupListWarningData();
  buildCounterInstanceGroupListWarningData++;
  if (buildCounterInstanceGroupListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterInstanceGroupListWarningData--;
  return o;
}

checkInstanceGroupListWarningData(api.InstanceGroupListWarningData o) {
  buildCounterInstanceGroupListWarningData++;
  if (buildCounterInstanceGroupListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterInstanceGroupListWarningData--;
}

buildUnnamed1756() {
  var o = new core.List<api.InstanceGroupListWarningData>();
  o.add(buildInstanceGroupListWarningData());
  o.add(buildInstanceGroupListWarningData());
  return o;
}

checkUnnamed1756(core.List<api.InstanceGroupListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroupListWarningData(o[0]);
  checkInstanceGroupListWarningData(o[1]);
}

core.int buildCounterInstanceGroupListWarning = 0;
buildInstanceGroupListWarning() {
  var o = new api.InstanceGroupListWarning();
  buildCounterInstanceGroupListWarning++;
  if (buildCounterInstanceGroupListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1756();
    o.message = "foo";
  }
  buildCounterInstanceGroupListWarning--;
  return o;
}

checkInstanceGroupListWarning(api.InstanceGroupListWarning o) {
  buildCounterInstanceGroupListWarning++;
  if (buildCounterInstanceGroupListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1756(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterInstanceGroupListWarning--;
}

core.int buildCounterInstanceGroupList = 0;
buildInstanceGroupList() {
  var o = new api.InstanceGroupList();
  buildCounterInstanceGroupList++;
  if (buildCounterInstanceGroupList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1755();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildInstanceGroupListWarning();
  }
  buildCounterInstanceGroupList--;
  return o;
}

checkInstanceGroupList(api.InstanceGroupList o) {
  buildCounterInstanceGroupList++;
  if (buildCounterInstanceGroupList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1755(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkInstanceGroupListWarning(o.warning);
  }
  buildCounterInstanceGroupList--;
}

buildUnnamed1757() {
  var o = new core.List<api.InstanceGroupManagerAutoHealingPolicy>();
  o.add(buildInstanceGroupManagerAutoHealingPolicy());
  o.add(buildInstanceGroupManagerAutoHealingPolicy());
  return o;
}

checkUnnamed1757(core.List<api.InstanceGroupManagerAutoHealingPolicy> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroupManagerAutoHealingPolicy(o[0]);
  checkInstanceGroupManagerAutoHealingPolicy(o[1]);
}

buildUnnamed1758() {
  var o = new core.List<api.NamedPort>();
  o.add(buildNamedPort());
  o.add(buildNamedPort());
  return o;
}

checkUnnamed1758(core.List<api.NamedPort> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNamedPort(o[0]);
  checkNamedPort(o[1]);
}

buildUnnamed1759() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1759(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

buildUnnamed1760() {
  var o = new core.List<api.InstanceGroupManagerVersion>();
  o.add(buildInstanceGroupManagerVersion());
  o.add(buildInstanceGroupManagerVersion());
  return o;
}

checkUnnamed1760(core.List<api.InstanceGroupManagerVersion> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroupManagerVersion(o[0]);
  checkInstanceGroupManagerVersion(o[1]);
}

core.int buildCounterInstanceGroupManager = 0;
buildInstanceGroupManager() {
  var o = new api.InstanceGroupManager();
  buildCounterInstanceGroupManager++;
  if (buildCounterInstanceGroupManager < 3) {
    o.autoHealingPolicies = buildUnnamed1757();
    o.baseInstanceName = "foo";
    o.creationTimestamp = "foo";
    o.currentActions = buildInstanceGroupManagerActionsSummary();
    o.description = "foo";
    o.distributionPolicy = buildDistributionPolicy();
    o.fingerprint = "foo";
    o.id = "foo";
    o.instanceGroup = "foo";
    o.instanceTemplate = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.namedPorts = buildUnnamed1758();
    o.region = "foo";
    o.selfLink = "foo";
    o.status = buildInstanceGroupManagerStatus();
    o.targetPools = buildUnnamed1759();
    o.targetSize = 42;
    o.updatePolicy = buildInstanceGroupManagerUpdatePolicy();
    o.versions = buildUnnamed1760();
    o.zone = "foo";
  }
  buildCounterInstanceGroupManager--;
  return o;
}

checkInstanceGroupManager(api.InstanceGroupManager o) {
  buildCounterInstanceGroupManager++;
  if (buildCounterInstanceGroupManager < 3) {
    checkUnnamed1757(o.autoHealingPolicies);
    unittest.expect(o.baseInstanceName, unittest.equals('foo'));
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    checkInstanceGroupManagerActionsSummary(o.currentActions);
    unittest.expect(o.description, unittest.equals('foo'));
    checkDistributionPolicy(o.distributionPolicy);
    unittest.expect(o.fingerprint, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.instanceGroup, unittest.equals('foo'));
    unittest.expect(o.instanceTemplate, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    checkUnnamed1758(o.namedPorts);
    unittest.expect(o.region, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkInstanceGroupManagerStatus(o.status);
    checkUnnamed1759(o.targetPools);
    unittest.expect(o.targetSize, unittest.equals(42));
    checkInstanceGroupManagerUpdatePolicy(o.updatePolicy);
    checkUnnamed1760(o.versions);
    unittest.expect(o.zone, unittest.equals('foo'));
  }
  buildCounterInstanceGroupManager--;
}

core.int buildCounterInstanceGroupManagerActionsSummary = 0;
buildInstanceGroupManagerActionsSummary() {
  var o = new api.InstanceGroupManagerActionsSummary();
  buildCounterInstanceGroupManagerActionsSummary++;
  if (buildCounterInstanceGroupManagerActionsSummary < 3) {
    o.abandoning = 42;
    o.creating = 42;
    o.creatingWithoutRetries = 42;
    o.deleting = 42;
    o.none = 42;
    o.recreating = 42;
    o.refreshing = 42;
    o.restarting = 42;
    o.verifying = 42;
  }
  buildCounterInstanceGroupManagerActionsSummary--;
  return o;
}

checkInstanceGroupManagerActionsSummary(
    api.InstanceGroupManagerActionsSummary o) {
  buildCounterInstanceGroupManagerActionsSummary++;
  if (buildCounterInstanceGroupManagerActionsSummary < 3) {
    unittest.expect(o.abandoning, unittest.equals(42));
    unittest.expect(o.creating, unittest.equals(42));
    unittest.expect(o.creatingWithoutRetries, unittest.equals(42));
    unittest.expect(o.deleting, unittest.equals(42));
    unittest.expect(o.none, unittest.equals(42));
    unittest.expect(o.recreating, unittest.equals(42));
    unittest.expect(o.refreshing, unittest.equals(42));
    unittest.expect(o.restarting, unittest.equals(42));
    unittest.expect(o.verifying, unittest.equals(42));
  }
  buildCounterInstanceGroupManagerActionsSummary--;
}

buildUnnamed1761() {
  var o = new core.Map<core.String, api.InstanceGroupManagersScopedList>();
  o["x"] = buildInstanceGroupManagersScopedList();
  o["y"] = buildInstanceGroupManagersScopedList();
  return o;
}

checkUnnamed1761(core.Map<core.String, api.InstanceGroupManagersScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroupManagersScopedList(o["x"]);
  checkInstanceGroupManagersScopedList(o["y"]);
}

core.int buildCounterInstanceGroupManagerAggregatedListWarningData = 0;
buildInstanceGroupManagerAggregatedListWarningData() {
  var o = new api.InstanceGroupManagerAggregatedListWarningData();
  buildCounterInstanceGroupManagerAggregatedListWarningData++;
  if (buildCounterInstanceGroupManagerAggregatedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterInstanceGroupManagerAggregatedListWarningData--;
  return o;
}

checkInstanceGroupManagerAggregatedListWarningData(
    api.InstanceGroupManagerAggregatedListWarningData o) {
  buildCounterInstanceGroupManagerAggregatedListWarningData++;
  if (buildCounterInstanceGroupManagerAggregatedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterInstanceGroupManagerAggregatedListWarningData--;
}

buildUnnamed1762() {
  var o = new core.List<api.InstanceGroupManagerAggregatedListWarningData>();
  o.add(buildInstanceGroupManagerAggregatedListWarningData());
  o.add(buildInstanceGroupManagerAggregatedListWarningData());
  return o;
}

checkUnnamed1762(
    core.List<api.InstanceGroupManagerAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroupManagerAggregatedListWarningData(o[0]);
  checkInstanceGroupManagerAggregatedListWarningData(o[1]);
}

core.int buildCounterInstanceGroupManagerAggregatedListWarning = 0;
buildInstanceGroupManagerAggregatedListWarning() {
  var o = new api.InstanceGroupManagerAggregatedListWarning();
  buildCounterInstanceGroupManagerAggregatedListWarning++;
  if (buildCounterInstanceGroupManagerAggregatedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1762();
    o.message = "foo";
  }
  buildCounterInstanceGroupManagerAggregatedListWarning--;
  return o;
}

checkInstanceGroupManagerAggregatedListWarning(
    api.InstanceGroupManagerAggregatedListWarning o) {
  buildCounterInstanceGroupManagerAggregatedListWarning++;
  if (buildCounterInstanceGroupManagerAggregatedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1762(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterInstanceGroupManagerAggregatedListWarning--;
}

core.int buildCounterInstanceGroupManagerAggregatedList = 0;
buildInstanceGroupManagerAggregatedList() {
  var o = new api.InstanceGroupManagerAggregatedList();
  buildCounterInstanceGroupManagerAggregatedList++;
  if (buildCounterInstanceGroupManagerAggregatedList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1761();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildInstanceGroupManagerAggregatedListWarning();
  }
  buildCounterInstanceGroupManagerAggregatedList--;
  return o;
}

checkInstanceGroupManagerAggregatedList(
    api.InstanceGroupManagerAggregatedList o) {
  buildCounterInstanceGroupManagerAggregatedList++;
  if (buildCounterInstanceGroupManagerAggregatedList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1761(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkInstanceGroupManagerAggregatedListWarning(o.warning);
  }
  buildCounterInstanceGroupManagerAggregatedList--;
}

core.int buildCounterInstanceGroupManagerAutoHealingPolicy = 0;
buildInstanceGroupManagerAutoHealingPolicy() {
  var o = new api.InstanceGroupManagerAutoHealingPolicy();
  buildCounterInstanceGroupManagerAutoHealingPolicy++;
  if (buildCounterInstanceGroupManagerAutoHealingPolicy < 3) {
    o.healthCheck = "foo";
    o.initialDelaySec = 42;
  }
  buildCounterInstanceGroupManagerAutoHealingPolicy--;
  return o;
}

checkInstanceGroupManagerAutoHealingPolicy(
    api.InstanceGroupManagerAutoHealingPolicy o) {
  buildCounterInstanceGroupManagerAutoHealingPolicy++;
  if (buildCounterInstanceGroupManagerAutoHealingPolicy < 3) {
    unittest.expect(o.healthCheck, unittest.equals('foo'));
    unittest.expect(o.initialDelaySec, unittest.equals(42));
  }
  buildCounterInstanceGroupManagerAutoHealingPolicy--;
}

buildUnnamed1763() {
  var o = new core.List<api.InstanceGroupManager>();
  o.add(buildInstanceGroupManager());
  o.add(buildInstanceGroupManager());
  return o;
}

checkUnnamed1763(core.List<api.InstanceGroupManager> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroupManager(o[0]);
  checkInstanceGroupManager(o[1]);
}

core.int buildCounterInstanceGroupManagerListWarningData = 0;
buildInstanceGroupManagerListWarningData() {
  var o = new api.InstanceGroupManagerListWarningData();
  buildCounterInstanceGroupManagerListWarningData++;
  if (buildCounterInstanceGroupManagerListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterInstanceGroupManagerListWarningData--;
  return o;
}

checkInstanceGroupManagerListWarningData(
    api.InstanceGroupManagerListWarningData o) {
  buildCounterInstanceGroupManagerListWarningData++;
  if (buildCounterInstanceGroupManagerListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterInstanceGroupManagerListWarningData--;
}

buildUnnamed1764() {
  var o = new core.List<api.InstanceGroupManagerListWarningData>();
  o.add(buildInstanceGroupManagerListWarningData());
  o.add(buildInstanceGroupManagerListWarningData());
  return o;
}

checkUnnamed1764(core.List<api.InstanceGroupManagerListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroupManagerListWarningData(o[0]);
  checkInstanceGroupManagerListWarningData(o[1]);
}

core.int buildCounterInstanceGroupManagerListWarning = 0;
buildInstanceGroupManagerListWarning() {
  var o = new api.InstanceGroupManagerListWarning();
  buildCounterInstanceGroupManagerListWarning++;
  if (buildCounterInstanceGroupManagerListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1764();
    o.message = "foo";
  }
  buildCounterInstanceGroupManagerListWarning--;
  return o;
}

checkInstanceGroupManagerListWarning(api.InstanceGroupManagerListWarning o) {
  buildCounterInstanceGroupManagerListWarning++;
  if (buildCounterInstanceGroupManagerListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1764(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterInstanceGroupManagerListWarning--;
}

core.int buildCounterInstanceGroupManagerList = 0;
buildInstanceGroupManagerList() {
  var o = new api.InstanceGroupManagerList();
  buildCounterInstanceGroupManagerList++;
  if (buildCounterInstanceGroupManagerList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1763();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildInstanceGroupManagerListWarning();
  }
  buildCounterInstanceGroupManagerList--;
  return o;
}

checkInstanceGroupManagerList(api.InstanceGroupManagerList o) {
  buildCounterInstanceGroupManagerList++;
  if (buildCounterInstanceGroupManagerList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1763(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkInstanceGroupManagerListWarning(o.warning);
  }
  buildCounterInstanceGroupManagerList--;
}

core.int buildCounterInstanceGroupManagerStatus = 0;
buildInstanceGroupManagerStatus() {
  var o = new api.InstanceGroupManagerStatus();
  buildCounterInstanceGroupManagerStatus++;
  if (buildCounterInstanceGroupManagerStatus < 3) {
    o.isStable = true;
  }
  buildCounterInstanceGroupManagerStatus--;
  return o;
}

checkInstanceGroupManagerStatus(api.InstanceGroupManagerStatus o) {
  buildCounterInstanceGroupManagerStatus++;
  if (buildCounterInstanceGroupManagerStatus < 3) {
    unittest.expect(o.isStable, unittest.isTrue);
  }
  buildCounterInstanceGroupManagerStatus--;
}

core.int buildCounterInstanceGroupManagerUpdatePolicy = 0;
buildInstanceGroupManagerUpdatePolicy() {
  var o = new api.InstanceGroupManagerUpdatePolicy();
  buildCounterInstanceGroupManagerUpdatePolicy++;
  if (buildCounterInstanceGroupManagerUpdatePolicy < 3) {
    o.maxSurge = buildFixedOrPercent();
    o.maxUnavailable = buildFixedOrPercent();
    o.minimalAction = "foo";
    o.type = "foo";
  }
  buildCounterInstanceGroupManagerUpdatePolicy--;
  return o;
}

checkInstanceGroupManagerUpdatePolicy(api.InstanceGroupManagerUpdatePolicy o) {
  buildCounterInstanceGroupManagerUpdatePolicy++;
  if (buildCounterInstanceGroupManagerUpdatePolicy < 3) {
    checkFixedOrPercent(o.maxSurge);
    checkFixedOrPercent(o.maxUnavailable);
    unittest.expect(o.minimalAction, unittest.equals('foo'));
    unittest.expect(o.type, unittest.equals('foo'));
  }
  buildCounterInstanceGroupManagerUpdatePolicy--;
}

core.int buildCounterInstanceGroupManagerVersion = 0;
buildInstanceGroupManagerVersion() {
  var o = new api.InstanceGroupManagerVersion();
  buildCounterInstanceGroupManagerVersion++;
  if (buildCounterInstanceGroupManagerVersion < 3) {
    o.instanceTemplate = "foo";
    o.name = "foo";
    o.targetSize = buildFixedOrPercent();
  }
  buildCounterInstanceGroupManagerVersion--;
  return o;
}

checkInstanceGroupManagerVersion(api.InstanceGroupManagerVersion o) {
  buildCounterInstanceGroupManagerVersion++;
  if (buildCounterInstanceGroupManagerVersion < 3) {
    unittest.expect(o.instanceTemplate, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    checkFixedOrPercent(o.targetSize);
  }
  buildCounterInstanceGroupManagerVersion--;
}

buildUnnamed1765() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1765(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterInstanceGroupManagersAbandonInstancesRequest = 0;
buildInstanceGroupManagersAbandonInstancesRequest() {
  var o = new api.InstanceGroupManagersAbandonInstancesRequest();
  buildCounterInstanceGroupManagersAbandonInstancesRequest++;
  if (buildCounterInstanceGroupManagersAbandonInstancesRequest < 3) {
    o.instances = buildUnnamed1765();
  }
  buildCounterInstanceGroupManagersAbandonInstancesRequest--;
  return o;
}

checkInstanceGroupManagersAbandonInstancesRequest(
    api.InstanceGroupManagersAbandonInstancesRequest o) {
  buildCounterInstanceGroupManagersAbandonInstancesRequest++;
  if (buildCounterInstanceGroupManagersAbandonInstancesRequest < 3) {
    checkUnnamed1765(o.instances);
  }
  buildCounterInstanceGroupManagersAbandonInstancesRequest--;
}

buildUnnamed1766() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1766(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterInstanceGroupManagersDeleteInstancesRequest = 0;
buildInstanceGroupManagersDeleteInstancesRequest() {
  var o = new api.InstanceGroupManagersDeleteInstancesRequest();
  buildCounterInstanceGroupManagersDeleteInstancesRequest++;
  if (buildCounterInstanceGroupManagersDeleteInstancesRequest < 3) {
    o.instances = buildUnnamed1766();
  }
  buildCounterInstanceGroupManagersDeleteInstancesRequest--;
  return o;
}

checkInstanceGroupManagersDeleteInstancesRequest(
    api.InstanceGroupManagersDeleteInstancesRequest o) {
  buildCounterInstanceGroupManagersDeleteInstancesRequest++;
  if (buildCounterInstanceGroupManagersDeleteInstancesRequest < 3) {
    checkUnnamed1766(o.instances);
  }
  buildCounterInstanceGroupManagersDeleteInstancesRequest--;
}

buildUnnamed1767() {
  var o = new core.List<api.ManagedInstance>();
  o.add(buildManagedInstance());
  o.add(buildManagedInstance());
  return o;
}

checkUnnamed1767(core.List<api.ManagedInstance> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkManagedInstance(o[0]);
  checkManagedInstance(o[1]);
}

core.int buildCounterInstanceGroupManagersListManagedInstancesResponse = 0;
buildInstanceGroupManagersListManagedInstancesResponse() {
  var o = new api.InstanceGroupManagersListManagedInstancesResponse();
  buildCounterInstanceGroupManagersListManagedInstancesResponse++;
  if (buildCounterInstanceGroupManagersListManagedInstancesResponse < 3) {
    o.managedInstances = buildUnnamed1767();
  }
  buildCounterInstanceGroupManagersListManagedInstancesResponse--;
  return o;
}

checkInstanceGroupManagersListManagedInstancesResponse(
    api.InstanceGroupManagersListManagedInstancesResponse o) {
  buildCounterInstanceGroupManagersListManagedInstancesResponse++;
  if (buildCounterInstanceGroupManagersListManagedInstancesResponse < 3) {
    checkUnnamed1767(o.managedInstances);
  }
  buildCounterInstanceGroupManagersListManagedInstancesResponse--;
}

buildUnnamed1768() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1768(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterInstanceGroupManagersRecreateInstancesRequest = 0;
buildInstanceGroupManagersRecreateInstancesRequest() {
  var o = new api.InstanceGroupManagersRecreateInstancesRequest();
  buildCounterInstanceGroupManagersRecreateInstancesRequest++;
  if (buildCounterInstanceGroupManagersRecreateInstancesRequest < 3) {
    o.instances = buildUnnamed1768();
  }
  buildCounterInstanceGroupManagersRecreateInstancesRequest--;
  return o;
}

checkInstanceGroupManagersRecreateInstancesRequest(
    api.InstanceGroupManagersRecreateInstancesRequest o) {
  buildCounterInstanceGroupManagersRecreateInstancesRequest++;
  if (buildCounterInstanceGroupManagersRecreateInstancesRequest < 3) {
    checkUnnamed1768(o.instances);
  }
  buildCounterInstanceGroupManagersRecreateInstancesRequest--;
}

buildUnnamed1769() {
  var o = new core.List<api.InstanceGroupManager>();
  o.add(buildInstanceGroupManager());
  o.add(buildInstanceGroupManager());
  return o;
}

checkUnnamed1769(core.List<api.InstanceGroupManager> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroupManager(o[0]);
  checkInstanceGroupManager(o[1]);
}

core.int buildCounterInstanceGroupManagersScopedListWarningData = 0;
buildInstanceGroupManagersScopedListWarningData() {
  var o = new api.InstanceGroupManagersScopedListWarningData();
  buildCounterInstanceGroupManagersScopedListWarningData++;
  if (buildCounterInstanceGroupManagersScopedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterInstanceGroupManagersScopedListWarningData--;
  return o;
}

checkInstanceGroupManagersScopedListWarningData(
    api.InstanceGroupManagersScopedListWarningData o) {
  buildCounterInstanceGroupManagersScopedListWarningData++;
  if (buildCounterInstanceGroupManagersScopedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterInstanceGroupManagersScopedListWarningData--;
}

buildUnnamed1770() {
  var o = new core.List<api.InstanceGroupManagersScopedListWarningData>();
  o.add(buildInstanceGroupManagersScopedListWarningData());
  o.add(buildInstanceGroupManagersScopedListWarningData());
  return o;
}

checkUnnamed1770(core.List<api.InstanceGroupManagersScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroupManagersScopedListWarningData(o[0]);
  checkInstanceGroupManagersScopedListWarningData(o[1]);
}

core.int buildCounterInstanceGroupManagersScopedListWarning = 0;
buildInstanceGroupManagersScopedListWarning() {
  var o = new api.InstanceGroupManagersScopedListWarning();
  buildCounterInstanceGroupManagersScopedListWarning++;
  if (buildCounterInstanceGroupManagersScopedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1770();
    o.message = "foo";
  }
  buildCounterInstanceGroupManagersScopedListWarning--;
  return o;
}

checkInstanceGroupManagersScopedListWarning(
    api.InstanceGroupManagersScopedListWarning o) {
  buildCounterInstanceGroupManagersScopedListWarning++;
  if (buildCounterInstanceGroupManagersScopedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1770(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterInstanceGroupManagersScopedListWarning--;
}

core.int buildCounterInstanceGroupManagersScopedList = 0;
buildInstanceGroupManagersScopedList() {
  var o = new api.InstanceGroupManagersScopedList();
  buildCounterInstanceGroupManagersScopedList++;
  if (buildCounterInstanceGroupManagersScopedList < 3) {
    o.instanceGroupManagers = buildUnnamed1769();
    o.warning = buildInstanceGroupManagersScopedListWarning();
  }
  buildCounterInstanceGroupManagersScopedList--;
  return o;
}

checkInstanceGroupManagersScopedList(api.InstanceGroupManagersScopedList o) {
  buildCounterInstanceGroupManagersScopedList++;
  if (buildCounterInstanceGroupManagersScopedList < 3) {
    checkUnnamed1769(o.instanceGroupManagers);
    checkInstanceGroupManagersScopedListWarning(o.warning);
  }
  buildCounterInstanceGroupManagersScopedList--;
}

core.int buildCounterInstanceGroupManagersSetInstanceTemplateRequest = 0;
buildInstanceGroupManagersSetInstanceTemplateRequest() {
  var o = new api.InstanceGroupManagersSetInstanceTemplateRequest();
  buildCounterInstanceGroupManagersSetInstanceTemplateRequest++;
  if (buildCounterInstanceGroupManagersSetInstanceTemplateRequest < 3) {
    o.instanceTemplate = "foo";
  }
  buildCounterInstanceGroupManagersSetInstanceTemplateRequest--;
  return o;
}

checkInstanceGroupManagersSetInstanceTemplateRequest(
    api.InstanceGroupManagersSetInstanceTemplateRequest o) {
  buildCounterInstanceGroupManagersSetInstanceTemplateRequest++;
  if (buildCounterInstanceGroupManagersSetInstanceTemplateRequest < 3) {
    unittest.expect(o.instanceTemplate, unittest.equals('foo'));
  }
  buildCounterInstanceGroupManagersSetInstanceTemplateRequest--;
}

buildUnnamed1771() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1771(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterInstanceGroupManagersSetTargetPoolsRequest = 0;
buildInstanceGroupManagersSetTargetPoolsRequest() {
  var o = new api.InstanceGroupManagersSetTargetPoolsRequest();
  buildCounterInstanceGroupManagersSetTargetPoolsRequest++;
  if (buildCounterInstanceGroupManagersSetTargetPoolsRequest < 3) {
    o.fingerprint = "foo";
    o.targetPools = buildUnnamed1771();
  }
  buildCounterInstanceGroupManagersSetTargetPoolsRequest--;
  return o;
}

checkInstanceGroupManagersSetTargetPoolsRequest(
    api.InstanceGroupManagersSetTargetPoolsRequest o) {
  buildCounterInstanceGroupManagersSetTargetPoolsRequest++;
  if (buildCounterInstanceGroupManagersSetTargetPoolsRequest < 3) {
    unittest.expect(o.fingerprint, unittest.equals('foo'));
    checkUnnamed1771(o.targetPools);
  }
  buildCounterInstanceGroupManagersSetTargetPoolsRequest--;
}

buildUnnamed1772() {
  var o = new core.List<api.InstanceReference>();
  o.add(buildInstanceReference());
  o.add(buildInstanceReference());
  return o;
}

checkUnnamed1772(core.List<api.InstanceReference> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceReference(o[0]);
  checkInstanceReference(o[1]);
}

core.int buildCounterInstanceGroupsAddInstancesRequest = 0;
buildInstanceGroupsAddInstancesRequest() {
  var o = new api.InstanceGroupsAddInstancesRequest();
  buildCounterInstanceGroupsAddInstancesRequest++;
  if (buildCounterInstanceGroupsAddInstancesRequest < 3) {
    o.instances = buildUnnamed1772();
  }
  buildCounterInstanceGroupsAddInstancesRequest--;
  return o;
}

checkInstanceGroupsAddInstancesRequest(
    api.InstanceGroupsAddInstancesRequest o) {
  buildCounterInstanceGroupsAddInstancesRequest++;
  if (buildCounterInstanceGroupsAddInstancesRequest < 3) {
    checkUnnamed1772(o.instances);
  }
  buildCounterInstanceGroupsAddInstancesRequest--;
}

buildUnnamed1773() {
  var o = new core.List<api.InstanceWithNamedPorts>();
  o.add(buildInstanceWithNamedPorts());
  o.add(buildInstanceWithNamedPorts());
  return o;
}

checkUnnamed1773(core.List<api.InstanceWithNamedPorts> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceWithNamedPorts(o[0]);
  checkInstanceWithNamedPorts(o[1]);
}

core.int buildCounterInstanceGroupsListInstancesWarningData = 0;
buildInstanceGroupsListInstancesWarningData() {
  var o = new api.InstanceGroupsListInstancesWarningData();
  buildCounterInstanceGroupsListInstancesWarningData++;
  if (buildCounterInstanceGroupsListInstancesWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterInstanceGroupsListInstancesWarningData--;
  return o;
}

checkInstanceGroupsListInstancesWarningData(
    api.InstanceGroupsListInstancesWarningData o) {
  buildCounterInstanceGroupsListInstancesWarningData++;
  if (buildCounterInstanceGroupsListInstancesWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterInstanceGroupsListInstancesWarningData--;
}

buildUnnamed1774() {
  var o = new core.List<api.InstanceGroupsListInstancesWarningData>();
  o.add(buildInstanceGroupsListInstancesWarningData());
  o.add(buildInstanceGroupsListInstancesWarningData());
  return o;
}

checkUnnamed1774(core.List<api.InstanceGroupsListInstancesWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroupsListInstancesWarningData(o[0]);
  checkInstanceGroupsListInstancesWarningData(o[1]);
}

core.int buildCounterInstanceGroupsListInstancesWarning = 0;
buildInstanceGroupsListInstancesWarning() {
  var o = new api.InstanceGroupsListInstancesWarning();
  buildCounterInstanceGroupsListInstancesWarning++;
  if (buildCounterInstanceGroupsListInstancesWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1774();
    o.message = "foo";
  }
  buildCounterInstanceGroupsListInstancesWarning--;
  return o;
}

checkInstanceGroupsListInstancesWarning(
    api.InstanceGroupsListInstancesWarning o) {
  buildCounterInstanceGroupsListInstancesWarning++;
  if (buildCounterInstanceGroupsListInstancesWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1774(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterInstanceGroupsListInstancesWarning--;
}

core.int buildCounterInstanceGroupsListInstances = 0;
buildInstanceGroupsListInstances() {
  var o = new api.InstanceGroupsListInstances();
  buildCounterInstanceGroupsListInstances++;
  if (buildCounterInstanceGroupsListInstances < 3) {
    o.id = "foo";
    o.items = buildUnnamed1773();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildInstanceGroupsListInstancesWarning();
  }
  buildCounterInstanceGroupsListInstances--;
  return o;
}

checkInstanceGroupsListInstances(api.InstanceGroupsListInstances o) {
  buildCounterInstanceGroupsListInstances++;
  if (buildCounterInstanceGroupsListInstances < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1773(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkInstanceGroupsListInstancesWarning(o.warning);
  }
  buildCounterInstanceGroupsListInstances--;
}

core.int buildCounterInstanceGroupsListInstancesRequest = 0;
buildInstanceGroupsListInstancesRequest() {
  var o = new api.InstanceGroupsListInstancesRequest();
  buildCounterInstanceGroupsListInstancesRequest++;
  if (buildCounterInstanceGroupsListInstancesRequest < 3) {
    o.instanceState = "foo";
  }
  buildCounterInstanceGroupsListInstancesRequest--;
  return o;
}

checkInstanceGroupsListInstancesRequest(
    api.InstanceGroupsListInstancesRequest o) {
  buildCounterInstanceGroupsListInstancesRequest++;
  if (buildCounterInstanceGroupsListInstancesRequest < 3) {
    unittest.expect(o.instanceState, unittest.equals('foo'));
  }
  buildCounterInstanceGroupsListInstancesRequest--;
}

buildUnnamed1775() {
  var o = new core.List<api.InstanceReference>();
  o.add(buildInstanceReference());
  o.add(buildInstanceReference());
  return o;
}

checkUnnamed1775(core.List<api.InstanceReference> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceReference(o[0]);
  checkInstanceReference(o[1]);
}

core.int buildCounterInstanceGroupsRemoveInstancesRequest = 0;
buildInstanceGroupsRemoveInstancesRequest() {
  var o = new api.InstanceGroupsRemoveInstancesRequest();
  buildCounterInstanceGroupsRemoveInstancesRequest++;
  if (buildCounterInstanceGroupsRemoveInstancesRequest < 3) {
    o.instances = buildUnnamed1775();
  }
  buildCounterInstanceGroupsRemoveInstancesRequest--;
  return o;
}

checkInstanceGroupsRemoveInstancesRequest(
    api.InstanceGroupsRemoveInstancesRequest o) {
  buildCounterInstanceGroupsRemoveInstancesRequest++;
  if (buildCounterInstanceGroupsRemoveInstancesRequest < 3) {
    checkUnnamed1775(o.instances);
  }
  buildCounterInstanceGroupsRemoveInstancesRequest--;
}

buildUnnamed1776() {
  var o = new core.List<api.InstanceGroup>();
  o.add(buildInstanceGroup());
  o.add(buildInstanceGroup());
  return o;
}

checkUnnamed1776(core.List<api.InstanceGroup> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroup(o[0]);
  checkInstanceGroup(o[1]);
}

core.int buildCounterInstanceGroupsScopedListWarningData = 0;
buildInstanceGroupsScopedListWarningData() {
  var o = new api.InstanceGroupsScopedListWarningData();
  buildCounterInstanceGroupsScopedListWarningData++;
  if (buildCounterInstanceGroupsScopedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterInstanceGroupsScopedListWarningData--;
  return o;
}

checkInstanceGroupsScopedListWarningData(
    api.InstanceGroupsScopedListWarningData o) {
  buildCounterInstanceGroupsScopedListWarningData++;
  if (buildCounterInstanceGroupsScopedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterInstanceGroupsScopedListWarningData--;
}

buildUnnamed1777() {
  var o = new core.List<api.InstanceGroupsScopedListWarningData>();
  o.add(buildInstanceGroupsScopedListWarningData());
  o.add(buildInstanceGroupsScopedListWarningData());
  return o;
}

checkUnnamed1777(core.List<api.InstanceGroupsScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroupsScopedListWarningData(o[0]);
  checkInstanceGroupsScopedListWarningData(o[1]);
}

core.int buildCounterInstanceGroupsScopedListWarning = 0;
buildInstanceGroupsScopedListWarning() {
  var o = new api.InstanceGroupsScopedListWarning();
  buildCounterInstanceGroupsScopedListWarning++;
  if (buildCounterInstanceGroupsScopedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1777();
    o.message = "foo";
  }
  buildCounterInstanceGroupsScopedListWarning--;
  return o;
}

checkInstanceGroupsScopedListWarning(api.InstanceGroupsScopedListWarning o) {
  buildCounterInstanceGroupsScopedListWarning++;
  if (buildCounterInstanceGroupsScopedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1777(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterInstanceGroupsScopedListWarning--;
}

core.int buildCounterInstanceGroupsScopedList = 0;
buildInstanceGroupsScopedList() {
  var o = new api.InstanceGroupsScopedList();
  buildCounterInstanceGroupsScopedList++;
  if (buildCounterInstanceGroupsScopedList < 3) {
    o.instanceGroups = buildUnnamed1776();
    o.warning = buildInstanceGroupsScopedListWarning();
  }
  buildCounterInstanceGroupsScopedList--;
  return o;
}

checkInstanceGroupsScopedList(api.InstanceGroupsScopedList o) {
  buildCounterInstanceGroupsScopedList++;
  if (buildCounterInstanceGroupsScopedList < 3) {
    checkUnnamed1776(o.instanceGroups);
    checkInstanceGroupsScopedListWarning(o.warning);
  }
  buildCounterInstanceGroupsScopedList--;
}

buildUnnamed1778() {
  var o = new core.List<api.NamedPort>();
  o.add(buildNamedPort());
  o.add(buildNamedPort());
  return o;
}

checkUnnamed1778(core.List<api.NamedPort> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNamedPort(o[0]);
  checkNamedPort(o[1]);
}

core.int buildCounterInstanceGroupsSetNamedPortsRequest = 0;
buildInstanceGroupsSetNamedPortsRequest() {
  var o = new api.InstanceGroupsSetNamedPortsRequest();
  buildCounterInstanceGroupsSetNamedPortsRequest++;
  if (buildCounterInstanceGroupsSetNamedPortsRequest < 3) {
    o.fingerprint = "foo";
    o.namedPorts = buildUnnamed1778();
  }
  buildCounterInstanceGroupsSetNamedPortsRequest--;
  return o;
}

checkInstanceGroupsSetNamedPortsRequest(
    api.InstanceGroupsSetNamedPortsRequest o) {
  buildCounterInstanceGroupsSetNamedPortsRequest++;
  if (buildCounterInstanceGroupsSetNamedPortsRequest < 3) {
    unittest.expect(o.fingerprint, unittest.equals('foo'));
    checkUnnamed1778(o.namedPorts);
  }
  buildCounterInstanceGroupsSetNamedPortsRequest--;
}

buildUnnamed1779() {
  var o = new core.List<api.Instance>();
  o.add(buildInstance());
  o.add(buildInstance());
  return o;
}

checkUnnamed1779(core.List<api.Instance> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstance(o[0]);
  checkInstance(o[1]);
}

core.int buildCounterInstanceListWarningData = 0;
buildInstanceListWarningData() {
  var o = new api.InstanceListWarningData();
  buildCounterInstanceListWarningData++;
  if (buildCounterInstanceListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterInstanceListWarningData--;
  return o;
}

checkInstanceListWarningData(api.InstanceListWarningData o) {
  buildCounterInstanceListWarningData++;
  if (buildCounterInstanceListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterInstanceListWarningData--;
}

buildUnnamed1780() {
  var o = new core.List<api.InstanceListWarningData>();
  o.add(buildInstanceListWarningData());
  o.add(buildInstanceListWarningData());
  return o;
}

checkUnnamed1780(core.List<api.InstanceListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceListWarningData(o[0]);
  checkInstanceListWarningData(o[1]);
}

core.int buildCounterInstanceListWarning = 0;
buildInstanceListWarning() {
  var o = new api.InstanceListWarning();
  buildCounterInstanceListWarning++;
  if (buildCounterInstanceListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1780();
    o.message = "foo";
  }
  buildCounterInstanceListWarning--;
  return o;
}

checkInstanceListWarning(api.InstanceListWarning o) {
  buildCounterInstanceListWarning++;
  if (buildCounterInstanceListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1780(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterInstanceListWarning--;
}

core.int buildCounterInstanceList = 0;
buildInstanceList() {
  var o = new api.InstanceList();
  buildCounterInstanceList++;
  if (buildCounterInstanceList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1779();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildInstanceListWarning();
  }
  buildCounterInstanceList--;
  return o;
}

checkInstanceList(api.InstanceList o) {
  buildCounterInstanceList++;
  if (buildCounterInstanceList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1779(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkInstanceListWarning(o.warning);
  }
  buildCounterInstanceList--;
}

buildUnnamed1781() {
  var o = new core.List<api.Reference>();
  o.add(buildReference());
  o.add(buildReference());
  return o;
}

checkUnnamed1781(core.List<api.Reference> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkReference(o[0]);
  checkReference(o[1]);
}

core.int buildCounterInstanceListReferrersWarningData = 0;
buildInstanceListReferrersWarningData() {
  var o = new api.InstanceListReferrersWarningData();
  buildCounterInstanceListReferrersWarningData++;
  if (buildCounterInstanceListReferrersWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterInstanceListReferrersWarningData--;
  return o;
}

checkInstanceListReferrersWarningData(api.InstanceListReferrersWarningData o) {
  buildCounterInstanceListReferrersWarningData++;
  if (buildCounterInstanceListReferrersWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterInstanceListReferrersWarningData--;
}

buildUnnamed1782() {
  var o = new core.List<api.InstanceListReferrersWarningData>();
  o.add(buildInstanceListReferrersWarningData());
  o.add(buildInstanceListReferrersWarningData());
  return o;
}

checkUnnamed1782(core.List<api.InstanceListReferrersWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceListReferrersWarningData(o[0]);
  checkInstanceListReferrersWarningData(o[1]);
}

core.int buildCounterInstanceListReferrersWarning = 0;
buildInstanceListReferrersWarning() {
  var o = new api.InstanceListReferrersWarning();
  buildCounterInstanceListReferrersWarning++;
  if (buildCounterInstanceListReferrersWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1782();
    o.message = "foo";
  }
  buildCounterInstanceListReferrersWarning--;
  return o;
}

checkInstanceListReferrersWarning(api.InstanceListReferrersWarning o) {
  buildCounterInstanceListReferrersWarning++;
  if (buildCounterInstanceListReferrersWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1782(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterInstanceListReferrersWarning--;
}

core.int buildCounterInstanceListReferrers = 0;
buildInstanceListReferrers() {
  var o = new api.InstanceListReferrers();
  buildCounterInstanceListReferrers++;
  if (buildCounterInstanceListReferrers < 3) {
    o.id = "foo";
    o.items = buildUnnamed1781();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildInstanceListReferrersWarning();
  }
  buildCounterInstanceListReferrers--;
  return o;
}

checkInstanceListReferrers(api.InstanceListReferrers o) {
  buildCounterInstanceListReferrers++;
  if (buildCounterInstanceListReferrers < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1781(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkInstanceListReferrersWarning(o.warning);
  }
  buildCounterInstanceListReferrers--;
}

core.int buildCounterInstanceMoveRequest = 0;
buildInstanceMoveRequest() {
  var o = new api.InstanceMoveRequest();
  buildCounterInstanceMoveRequest++;
  if (buildCounterInstanceMoveRequest < 3) {
    o.destinationZone = "foo";
    o.targetInstance = "foo";
  }
  buildCounterInstanceMoveRequest--;
  return o;
}

checkInstanceMoveRequest(api.InstanceMoveRequest o) {
  buildCounterInstanceMoveRequest++;
  if (buildCounterInstanceMoveRequest < 3) {
    unittest.expect(o.destinationZone, unittest.equals('foo'));
    unittest.expect(o.targetInstance, unittest.equals('foo'));
  }
  buildCounterInstanceMoveRequest--;
}

buildUnnamed1783() {
  var o = new core.List<api.AttachedDisk>();
  o.add(buildAttachedDisk());
  o.add(buildAttachedDisk());
  return o;
}

checkUnnamed1783(core.List<api.AttachedDisk> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAttachedDisk(o[0]);
  checkAttachedDisk(o[1]);
}

buildUnnamed1784() {
  var o = new core.List<api.AcceleratorConfig>();
  o.add(buildAcceleratorConfig());
  o.add(buildAcceleratorConfig());
  return o;
}

checkUnnamed1784(core.List<api.AcceleratorConfig> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAcceleratorConfig(o[0]);
  checkAcceleratorConfig(o[1]);
}

buildUnnamed1785() {
  var o = new core.Map<core.String, core.String>();
  o["x"] = "foo";
  o["y"] = "foo";
  return o;
}

checkUnnamed1785(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o["x"], unittest.equals('foo'));
  unittest.expect(o["y"], unittest.equals('foo'));
}

buildUnnamed1786() {
  var o = new core.List<api.NetworkInterface>();
  o.add(buildNetworkInterface());
  o.add(buildNetworkInterface());
  return o;
}

checkUnnamed1786(core.List<api.NetworkInterface> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkInterface(o[0]);
  checkNetworkInterface(o[1]);
}

buildUnnamed1787() {
  var o = new core.List<api.ServiceAccount>();
  o.add(buildServiceAccount());
  o.add(buildServiceAccount());
  return o;
}

checkUnnamed1787(core.List<api.ServiceAccount> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkServiceAccount(o[0]);
  checkServiceAccount(o[1]);
}

core.int buildCounterInstanceProperties = 0;
buildInstanceProperties() {
  var o = new api.InstanceProperties();
  buildCounterInstanceProperties++;
  if (buildCounterInstanceProperties < 3) {
    o.canIpForward = true;
    o.description = "foo";
    o.disks = buildUnnamed1783();
    o.guestAccelerators = buildUnnamed1784();
    o.labels = buildUnnamed1785();
    o.machineType = "foo";
    o.metadata = buildMetadata();
    o.minCpuPlatform = "foo";
    o.networkInterfaces = buildUnnamed1786();
    o.reservationAffinity = buildReservationAffinity();
    o.scheduling = buildScheduling();
    o.serviceAccounts = buildUnnamed1787();
    o.shieldedInstanceConfig = buildShieldedInstanceConfig();
    o.tags = buildTags();
  }
  buildCounterInstanceProperties--;
  return o;
}

checkInstanceProperties(api.InstanceProperties o) {
  buildCounterInstanceProperties++;
  if (buildCounterInstanceProperties < 3) {
    unittest.expect(o.canIpForward, unittest.isTrue);
    unittest.expect(o.description, unittest.equals('foo'));
    checkUnnamed1783(o.disks);
    checkUnnamed1784(o.guestAccelerators);
    checkUnnamed1785(o.labels);
    unittest.expect(o.machineType, unittest.equals('foo'));
    checkMetadata(o.metadata);
    unittest.expect(o.minCpuPlatform, unittest.equals('foo'));
    checkUnnamed1786(o.networkInterfaces);
    checkReservationAffinity(o.reservationAffinity);
    checkScheduling(o.scheduling);
    checkUnnamed1787(o.serviceAccounts);
    checkShieldedInstanceConfig(o.shieldedInstanceConfig);
    checkTags(o.tags);
  }
  buildCounterInstanceProperties--;
}

core.int buildCounterInstanceReference = 0;
buildInstanceReference() {
  var o = new api.InstanceReference();
  buildCounterInstanceReference++;
  if (buildCounterInstanceReference < 3) {
    o.instance = "foo";
  }
  buildCounterInstanceReference--;
  return o;
}

checkInstanceReference(api.InstanceReference o) {
  buildCounterInstanceReference++;
  if (buildCounterInstanceReference < 3) {
    unittest.expect(o.instance, unittest.equals('foo'));
  }
  buildCounterInstanceReference--;
}

core.int buildCounterInstanceTemplate = 0;
buildInstanceTemplate() {
  var o = new api.InstanceTemplate();
  buildCounterInstanceTemplate++;
  if (buildCounterInstanceTemplate < 3) {
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.id = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.properties = buildInstanceProperties();
    o.selfLink = "foo";
    o.sourceInstance = "foo";
    o.sourceInstanceParams = buildSourceInstanceParams();
  }
  buildCounterInstanceTemplate--;
  return o;
}

checkInstanceTemplate(api.InstanceTemplate o) {
  buildCounterInstanceTemplate++;
  if (buildCounterInstanceTemplate < 3) {
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    checkInstanceProperties(o.properties);
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.sourceInstance, unittest.equals('foo'));
    checkSourceInstanceParams(o.sourceInstanceParams);
  }
  buildCounterInstanceTemplate--;
}

buildUnnamed1788() {
  var o = new core.List<api.InstanceTemplate>();
  o.add(buildInstanceTemplate());
  o.add(buildInstanceTemplate());
  return o;
}

checkUnnamed1788(core.List<api.InstanceTemplate> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceTemplate(o[0]);
  checkInstanceTemplate(o[1]);
}

core.int buildCounterInstanceTemplateListWarningData = 0;
buildInstanceTemplateListWarningData() {
  var o = new api.InstanceTemplateListWarningData();
  buildCounterInstanceTemplateListWarningData++;
  if (buildCounterInstanceTemplateListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterInstanceTemplateListWarningData--;
  return o;
}

checkInstanceTemplateListWarningData(api.InstanceTemplateListWarningData o) {
  buildCounterInstanceTemplateListWarningData++;
  if (buildCounterInstanceTemplateListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterInstanceTemplateListWarningData--;
}

buildUnnamed1789() {
  var o = new core.List<api.InstanceTemplateListWarningData>();
  o.add(buildInstanceTemplateListWarningData());
  o.add(buildInstanceTemplateListWarningData());
  return o;
}

checkUnnamed1789(core.List<api.InstanceTemplateListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceTemplateListWarningData(o[0]);
  checkInstanceTemplateListWarningData(o[1]);
}

core.int buildCounterInstanceTemplateListWarning = 0;
buildInstanceTemplateListWarning() {
  var o = new api.InstanceTemplateListWarning();
  buildCounterInstanceTemplateListWarning++;
  if (buildCounterInstanceTemplateListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1789();
    o.message = "foo";
  }
  buildCounterInstanceTemplateListWarning--;
  return o;
}

checkInstanceTemplateListWarning(api.InstanceTemplateListWarning o) {
  buildCounterInstanceTemplateListWarning++;
  if (buildCounterInstanceTemplateListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1789(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterInstanceTemplateListWarning--;
}

core.int buildCounterInstanceTemplateList = 0;
buildInstanceTemplateList() {
  var o = new api.InstanceTemplateList();
  buildCounterInstanceTemplateList++;
  if (buildCounterInstanceTemplateList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1788();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildInstanceTemplateListWarning();
  }
  buildCounterInstanceTemplateList--;
  return o;
}

checkInstanceTemplateList(api.InstanceTemplateList o) {
  buildCounterInstanceTemplateList++;
  if (buildCounterInstanceTemplateList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1788(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkInstanceTemplateListWarning(o.warning);
  }
  buildCounterInstanceTemplateList--;
}

buildUnnamed1790() {
  var o = new core.List<api.NamedPort>();
  o.add(buildNamedPort());
  o.add(buildNamedPort());
  return o;
}

checkUnnamed1790(core.List<api.NamedPort> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNamedPort(o[0]);
  checkNamedPort(o[1]);
}

core.int buildCounterInstanceWithNamedPorts = 0;
buildInstanceWithNamedPorts() {
  var o = new api.InstanceWithNamedPorts();
  buildCounterInstanceWithNamedPorts++;
  if (buildCounterInstanceWithNamedPorts < 3) {
    o.instance = "foo";
    o.namedPorts = buildUnnamed1790();
    o.status = "foo";
  }
  buildCounterInstanceWithNamedPorts--;
  return o;
}

checkInstanceWithNamedPorts(api.InstanceWithNamedPorts o) {
  buildCounterInstanceWithNamedPorts++;
  if (buildCounterInstanceWithNamedPorts < 3) {
    unittest.expect(o.instance, unittest.equals('foo'));
    checkUnnamed1790(o.namedPorts);
    unittest.expect(o.status, unittest.equals('foo'));
  }
  buildCounterInstanceWithNamedPorts--;
}

buildUnnamed1791() {
  var o = new core.List<api.Instance>();
  o.add(buildInstance());
  o.add(buildInstance());
  return o;
}

checkUnnamed1791(core.List<api.Instance> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstance(o[0]);
  checkInstance(o[1]);
}

core.int buildCounterInstancesScopedListWarningData = 0;
buildInstancesScopedListWarningData() {
  var o = new api.InstancesScopedListWarningData();
  buildCounterInstancesScopedListWarningData++;
  if (buildCounterInstancesScopedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterInstancesScopedListWarningData--;
  return o;
}

checkInstancesScopedListWarningData(api.InstancesScopedListWarningData o) {
  buildCounterInstancesScopedListWarningData++;
  if (buildCounterInstancesScopedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterInstancesScopedListWarningData--;
}

buildUnnamed1792() {
  var o = new core.List<api.InstancesScopedListWarningData>();
  o.add(buildInstancesScopedListWarningData());
  o.add(buildInstancesScopedListWarningData());
  return o;
}

checkUnnamed1792(core.List<api.InstancesScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstancesScopedListWarningData(o[0]);
  checkInstancesScopedListWarningData(o[1]);
}

core.int buildCounterInstancesScopedListWarning = 0;
buildInstancesScopedListWarning() {
  var o = new api.InstancesScopedListWarning();
  buildCounterInstancesScopedListWarning++;
  if (buildCounterInstancesScopedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1792();
    o.message = "foo";
  }
  buildCounterInstancesScopedListWarning--;
  return o;
}

checkInstancesScopedListWarning(api.InstancesScopedListWarning o) {
  buildCounterInstancesScopedListWarning++;
  if (buildCounterInstancesScopedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1792(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterInstancesScopedListWarning--;
}

core.int buildCounterInstancesScopedList = 0;
buildInstancesScopedList() {
  var o = new api.InstancesScopedList();
  buildCounterInstancesScopedList++;
  if (buildCounterInstancesScopedList < 3) {
    o.instances = buildUnnamed1791();
    o.warning = buildInstancesScopedListWarning();
  }
  buildCounterInstancesScopedList--;
  return o;
}

checkInstancesScopedList(api.InstancesScopedList o) {
  buildCounterInstancesScopedList++;
  if (buildCounterInstancesScopedList < 3) {
    checkUnnamed1791(o.instances);
    checkInstancesScopedListWarning(o.warning);
  }
  buildCounterInstancesScopedList--;
}

buildUnnamed1793() {
  var o = new core.Map<core.String, core.String>();
  o["x"] = "foo";
  o["y"] = "foo";
  return o;
}

checkUnnamed1793(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o["x"], unittest.equals('foo'));
  unittest.expect(o["y"], unittest.equals('foo'));
}

core.int buildCounterInstancesSetLabelsRequest = 0;
buildInstancesSetLabelsRequest() {
  var o = new api.InstancesSetLabelsRequest();
  buildCounterInstancesSetLabelsRequest++;
  if (buildCounterInstancesSetLabelsRequest < 3) {
    o.labelFingerprint = "foo";
    o.labels = buildUnnamed1793();
  }
  buildCounterInstancesSetLabelsRequest--;
  return o;
}

checkInstancesSetLabelsRequest(api.InstancesSetLabelsRequest o) {
  buildCounterInstancesSetLabelsRequest++;
  if (buildCounterInstancesSetLabelsRequest < 3) {
    unittest.expect(o.labelFingerprint, unittest.equals('foo'));
    checkUnnamed1793(o.labels);
  }
  buildCounterInstancesSetLabelsRequest--;
}

buildUnnamed1794() {
  var o = new core.List<api.AcceleratorConfig>();
  o.add(buildAcceleratorConfig());
  o.add(buildAcceleratorConfig());
  return o;
}

checkUnnamed1794(core.List<api.AcceleratorConfig> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAcceleratorConfig(o[0]);
  checkAcceleratorConfig(o[1]);
}

core.int buildCounterInstancesSetMachineResourcesRequest = 0;
buildInstancesSetMachineResourcesRequest() {
  var o = new api.InstancesSetMachineResourcesRequest();
  buildCounterInstancesSetMachineResourcesRequest++;
  if (buildCounterInstancesSetMachineResourcesRequest < 3) {
    o.guestAccelerators = buildUnnamed1794();
  }
  buildCounterInstancesSetMachineResourcesRequest--;
  return o;
}

checkInstancesSetMachineResourcesRequest(
    api.InstancesSetMachineResourcesRequest o) {
  buildCounterInstancesSetMachineResourcesRequest++;
  if (buildCounterInstancesSetMachineResourcesRequest < 3) {
    checkUnnamed1794(o.guestAccelerators);
  }
  buildCounterInstancesSetMachineResourcesRequest--;
}

core.int buildCounterInstancesSetMachineTypeRequest = 0;
buildInstancesSetMachineTypeRequest() {
  var o = new api.InstancesSetMachineTypeRequest();
  buildCounterInstancesSetMachineTypeRequest++;
  if (buildCounterInstancesSetMachineTypeRequest < 3) {
    o.machineType = "foo";
  }
  buildCounterInstancesSetMachineTypeRequest--;
  return o;
}

checkInstancesSetMachineTypeRequest(api.InstancesSetMachineTypeRequest o) {
  buildCounterInstancesSetMachineTypeRequest++;
  if (buildCounterInstancesSetMachineTypeRequest < 3) {
    unittest.expect(o.machineType, unittest.equals('foo'));
  }
  buildCounterInstancesSetMachineTypeRequest--;
}

core.int buildCounterInstancesSetMinCpuPlatformRequest = 0;
buildInstancesSetMinCpuPlatformRequest() {
  var o = new api.InstancesSetMinCpuPlatformRequest();
  buildCounterInstancesSetMinCpuPlatformRequest++;
  if (buildCounterInstancesSetMinCpuPlatformRequest < 3) {
    o.minCpuPlatform = "foo";
  }
  buildCounterInstancesSetMinCpuPlatformRequest--;
  return o;
}

checkInstancesSetMinCpuPlatformRequest(
    api.InstancesSetMinCpuPlatformRequest o) {
  buildCounterInstancesSetMinCpuPlatformRequest++;
  if (buildCounterInstancesSetMinCpuPlatformRequest < 3) {
    unittest.expect(o.minCpuPlatform, unittest.equals('foo'));
  }
  buildCounterInstancesSetMinCpuPlatformRequest--;
}

buildUnnamed1795() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1795(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterInstancesSetServiceAccountRequest = 0;
buildInstancesSetServiceAccountRequest() {
  var o = new api.InstancesSetServiceAccountRequest();
  buildCounterInstancesSetServiceAccountRequest++;
  if (buildCounterInstancesSetServiceAccountRequest < 3) {
    o.email = "foo";
    o.scopes = buildUnnamed1795();
  }
  buildCounterInstancesSetServiceAccountRequest--;
  return o;
}

checkInstancesSetServiceAccountRequest(
    api.InstancesSetServiceAccountRequest o) {
  buildCounterInstancesSetServiceAccountRequest++;
  if (buildCounterInstancesSetServiceAccountRequest < 3) {
    unittest.expect(o.email, unittest.equals('foo'));
    checkUnnamed1795(o.scopes);
  }
  buildCounterInstancesSetServiceAccountRequest--;
}

buildUnnamed1796() {
  var o = new core.List<api.CustomerEncryptionKeyProtectedDisk>();
  o.add(buildCustomerEncryptionKeyProtectedDisk());
  o.add(buildCustomerEncryptionKeyProtectedDisk());
  return o;
}

checkUnnamed1796(core.List<api.CustomerEncryptionKeyProtectedDisk> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkCustomerEncryptionKeyProtectedDisk(o[0]);
  checkCustomerEncryptionKeyProtectedDisk(o[1]);
}

core.int buildCounterInstancesStartWithEncryptionKeyRequest = 0;
buildInstancesStartWithEncryptionKeyRequest() {
  var o = new api.InstancesStartWithEncryptionKeyRequest();
  buildCounterInstancesStartWithEncryptionKeyRequest++;
  if (buildCounterInstancesStartWithEncryptionKeyRequest < 3) {
    o.disks = buildUnnamed1796();
  }
  buildCounterInstancesStartWithEncryptionKeyRequest--;
  return o;
}

checkInstancesStartWithEncryptionKeyRequest(
    api.InstancesStartWithEncryptionKeyRequest o) {
  buildCounterInstancesStartWithEncryptionKeyRequest++;
  if (buildCounterInstancesStartWithEncryptionKeyRequest < 3) {
    checkUnnamed1796(o.disks);
  }
  buildCounterInstancesStartWithEncryptionKeyRequest--;
}

buildUnnamed1797() {
  var o = new core.List<api.InterconnectCircuitInfo>();
  o.add(buildInterconnectCircuitInfo());
  o.add(buildInterconnectCircuitInfo());
  return o;
}

checkUnnamed1797(core.List<api.InterconnectCircuitInfo> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectCircuitInfo(o[0]);
  checkInterconnectCircuitInfo(o[1]);
}

buildUnnamed1798() {
  var o = new core.List<api.InterconnectOutageNotification>();
  o.add(buildInterconnectOutageNotification());
  o.add(buildInterconnectOutageNotification());
  return o;
}

checkUnnamed1798(core.List<api.InterconnectOutageNotification> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectOutageNotification(o[0]);
  checkInterconnectOutageNotification(o[1]);
}

buildUnnamed1799() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1799(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterInterconnect = 0;
buildInterconnect() {
  var o = new api.Interconnect();
  buildCounterInterconnect++;
  if (buildCounterInterconnect < 3) {
    o.adminEnabled = true;
    o.circuitInfos = buildUnnamed1797();
    o.creationTimestamp = "foo";
    o.customerName = "foo";
    o.description = "foo";
    o.expectedOutages = buildUnnamed1798();
    o.googleIpAddress = "foo";
    o.googleReferenceId = "foo";
    o.id = "foo";
    o.interconnectAttachments = buildUnnamed1799();
    o.interconnectType = "foo";
    o.kind = "foo";
    o.linkType = "foo";
    o.location = "foo";
    o.name = "foo";
    o.nocContactEmail = "foo";
    o.operationalStatus = "foo";
    o.peerIpAddress = "foo";
    o.provisionedLinkCount = 42;
    o.requestedLinkCount = 42;
    o.selfLink = "foo";
    o.state = "foo";
  }
  buildCounterInterconnect--;
  return o;
}

checkInterconnect(api.Interconnect o) {
  buildCounterInterconnect++;
  if (buildCounterInterconnect < 3) {
    unittest.expect(o.adminEnabled, unittest.isTrue);
    checkUnnamed1797(o.circuitInfos);
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.customerName, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    checkUnnamed1798(o.expectedOutages);
    unittest.expect(o.googleIpAddress, unittest.equals('foo'));
    unittest.expect(o.googleReferenceId, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1799(o.interconnectAttachments);
    unittest.expect(o.interconnectType, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.linkType, unittest.equals('foo'));
    unittest.expect(o.location, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.nocContactEmail, unittest.equals('foo'));
    unittest.expect(o.operationalStatus, unittest.equals('foo'));
    unittest.expect(o.peerIpAddress, unittest.equals('foo'));
    unittest.expect(o.provisionedLinkCount, unittest.equals(42));
    unittest.expect(o.requestedLinkCount, unittest.equals(42));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.state, unittest.equals('foo'));
  }
  buildCounterInterconnect--;
}

buildUnnamed1800() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1800(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterInterconnectAttachment = 0;
buildInterconnectAttachment() {
  var o = new api.InterconnectAttachment();
  buildCounterInterconnectAttachment++;
  if (buildCounterInterconnectAttachment < 3) {
    o.adminEnabled = true;
    o.bandwidth = "foo";
    o.candidateSubnets = buildUnnamed1800();
    o.cloudRouterIpAddress = "foo";
    o.creationTimestamp = "foo";
    o.customerRouterIpAddress = "foo";
    o.description = "foo";
    o.edgeAvailabilityDomain = "foo";
    o.googleReferenceId = "foo";
    o.id = "foo";
    o.interconnect = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.operationalStatus = "foo";
    o.pairingKey = "foo";
    o.partnerAsn = "foo";
    o.partnerMetadata = buildInterconnectAttachmentPartnerMetadata();
    o.privateInterconnectInfo = buildInterconnectAttachmentPrivateInfo();
    o.region = "foo";
    o.router = "foo";
    o.selfLink = "foo";
    o.state = "foo";
    o.type = "foo";
    o.vlanTag8021q = 42;
  }
  buildCounterInterconnectAttachment--;
  return o;
}

checkInterconnectAttachment(api.InterconnectAttachment o) {
  buildCounterInterconnectAttachment++;
  if (buildCounterInterconnectAttachment < 3) {
    unittest.expect(o.adminEnabled, unittest.isTrue);
    unittest.expect(o.bandwidth, unittest.equals('foo'));
    checkUnnamed1800(o.candidateSubnets);
    unittest.expect(o.cloudRouterIpAddress, unittest.equals('foo'));
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.customerRouterIpAddress, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.edgeAvailabilityDomain, unittest.equals('foo'));
    unittest.expect(o.googleReferenceId, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.interconnect, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.operationalStatus, unittest.equals('foo'));
    unittest.expect(o.pairingKey, unittest.equals('foo'));
    unittest.expect(o.partnerAsn, unittest.equals('foo'));
    checkInterconnectAttachmentPartnerMetadata(o.partnerMetadata);
    checkInterconnectAttachmentPrivateInfo(o.privateInterconnectInfo);
    unittest.expect(o.region, unittest.equals('foo'));
    unittest.expect(o.router, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.state, unittest.equals('foo'));
    unittest.expect(o.type, unittest.equals('foo'));
    unittest.expect(o.vlanTag8021q, unittest.equals(42));
  }
  buildCounterInterconnectAttachment--;
}

buildUnnamed1801() {
  var o = new core.Map<core.String, api.InterconnectAttachmentsScopedList>();
  o["x"] = buildInterconnectAttachmentsScopedList();
  o["y"] = buildInterconnectAttachmentsScopedList();
  return o;
}

checkUnnamed1801(
    core.Map<core.String, api.InterconnectAttachmentsScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectAttachmentsScopedList(o["x"]);
  checkInterconnectAttachmentsScopedList(o["y"]);
}

core.int buildCounterInterconnectAttachmentAggregatedListWarningData = 0;
buildInterconnectAttachmentAggregatedListWarningData() {
  var o = new api.InterconnectAttachmentAggregatedListWarningData();
  buildCounterInterconnectAttachmentAggregatedListWarningData++;
  if (buildCounterInterconnectAttachmentAggregatedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterInterconnectAttachmentAggregatedListWarningData--;
  return o;
}

checkInterconnectAttachmentAggregatedListWarningData(
    api.InterconnectAttachmentAggregatedListWarningData o) {
  buildCounterInterconnectAttachmentAggregatedListWarningData++;
  if (buildCounterInterconnectAttachmentAggregatedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterInterconnectAttachmentAggregatedListWarningData--;
}

buildUnnamed1802() {
  var o = new core.List<api.InterconnectAttachmentAggregatedListWarningData>();
  o.add(buildInterconnectAttachmentAggregatedListWarningData());
  o.add(buildInterconnectAttachmentAggregatedListWarningData());
  return o;
}

checkUnnamed1802(
    core.List<api.InterconnectAttachmentAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectAttachmentAggregatedListWarningData(o[0]);
  checkInterconnectAttachmentAggregatedListWarningData(o[1]);
}

core.int buildCounterInterconnectAttachmentAggregatedListWarning = 0;
buildInterconnectAttachmentAggregatedListWarning() {
  var o = new api.InterconnectAttachmentAggregatedListWarning();
  buildCounterInterconnectAttachmentAggregatedListWarning++;
  if (buildCounterInterconnectAttachmentAggregatedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1802();
    o.message = "foo";
  }
  buildCounterInterconnectAttachmentAggregatedListWarning--;
  return o;
}

checkInterconnectAttachmentAggregatedListWarning(
    api.InterconnectAttachmentAggregatedListWarning o) {
  buildCounterInterconnectAttachmentAggregatedListWarning++;
  if (buildCounterInterconnectAttachmentAggregatedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1802(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterInterconnectAttachmentAggregatedListWarning--;
}

core.int buildCounterInterconnectAttachmentAggregatedList = 0;
buildInterconnectAttachmentAggregatedList() {
  var o = new api.InterconnectAttachmentAggregatedList();
  buildCounterInterconnectAttachmentAggregatedList++;
  if (buildCounterInterconnectAttachmentAggregatedList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1801();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildInterconnectAttachmentAggregatedListWarning();
  }
  buildCounterInterconnectAttachmentAggregatedList--;
  return o;
}

checkInterconnectAttachmentAggregatedList(
    api.InterconnectAttachmentAggregatedList o) {
  buildCounterInterconnectAttachmentAggregatedList++;
  if (buildCounterInterconnectAttachmentAggregatedList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1801(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkInterconnectAttachmentAggregatedListWarning(o.warning);
  }
  buildCounterInterconnectAttachmentAggregatedList--;
}

buildUnnamed1803() {
  var o = new core.List<api.InterconnectAttachment>();
  o.add(buildInterconnectAttachment());
  o.add(buildInterconnectAttachment());
  return o;
}

checkUnnamed1803(core.List<api.InterconnectAttachment> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectAttachment(o[0]);
  checkInterconnectAttachment(o[1]);
}

core.int buildCounterInterconnectAttachmentListWarningData = 0;
buildInterconnectAttachmentListWarningData() {
  var o = new api.InterconnectAttachmentListWarningData();
  buildCounterInterconnectAttachmentListWarningData++;
  if (buildCounterInterconnectAttachmentListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterInterconnectAttachmentListWarningData--;
  return o;
}

checkInterconnectAttachmentListWarningData(
    api.InterconnectAttachmentListWarningData o) {
  buildCounterInterconnectAttachmentListWarningData++;
  if (buildCounterInterconnectAttachmentListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterInterconnectAttachmentListWarningData--;
}

buildUnnamed1804() {
  var o = new core.List<api.InterconnectAttachmentListWarningData>();
  o.add(buildInterconnectAttachmentListWarningData());
  o.add(buildInterconnectAttachmentListWarningData());
  return o;
}

checkUnnamed1804(core.List<api.InterconnectAttachmentListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectAttachmentListWarningData(o[0]);
  checkInterconnectAttachmentListWarningData(o[1]);
}

core.int buildCounterInterconnectAttachmentListWarning = 0;
buildInterconnectAttachmentListWarning() {
  var o = new api.InterconnectAttachmentListWarning();
  buildCounterInterconnectAttachmentListWarning++;
  if (buildCounterInterconnectAttachmentListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1804();
    o.message = "foo";
  }
  buildCounterInterconnectAttachmentListWarning--;
  return o;
}

checkInterconnectAttachmentListWarning(
    api.InterconnectAttachmentListWarning o) {
  buildCounterInterconnectAttachmentListWarning++;
  if (buildCounterInterconnectAttachmentListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1804(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterInterconnectAttachmentListWarning--;
}

core.int buildCounterInterconnectAttachmentList = 0;
buildInterconnectAttachmentList() {
  var o = new api.InterconnectAttachmentList();
  buildCounterInterconnectAttachmentList++;
  if (buildCounterInterconnectAttachmentList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1803();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildInterconnectAttachmentListWarning();
  }
  buildCounterInterconnectAttachmentList--;
  return o;
}

checkInterconnectAttachmentList(api.InterconnectAttachmentList o) {
  buildCounterInterconnectAttachmentList++;
  if (buildCounterInterconnectAttachmentList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1803(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkInterconnectAttachmentListWarning(o.warning);
  }
  buildCounterInterconnectAttachmentList--;
}

core.int buildCounterInterconnectAttachmentPartnerMetadata = 0;
buildInterconnectAttachmentPartnerMetadata() {
  var o = new api.InterconnectAttachmentPartnerMetadata();
  buildCounterInterconnectAttachmentPartnerMetadata++;
  if (buildCounterInterconnectAttachmentPartnerMetadata < 3) {
    o.interconnectName = "foo";
    o.partnerName = "foo";
    o.portalUrl = "foo";
  }
  buildCounterInterconnectAttachmentPartnerMetadata--;
  return o;
}

checkInterconnectAttachmentPartnerMetadata(
    api.InterconnectAttachmentPartnerMetadata o) {
  buildCounterInterconnectAttachmentPartnerMetadata++;
  if (buildCounterInterconnectAttachmentPartnerMetadata < 3) {
    unittest.expect(o.interconnectName, unittest.equals('foo'));
    unittest.expect(o.partnerName, unittest.equals('foo'));
    unittest.expect(o.portalUrl, unittest.equals('foo'));
  }
  buildCounterInterconnectAttachmentPartnerMetadata--;
}

core.int buildCounterInterconnectAttachmentPrivateInfo = 0;
buildInterconnectAttachmentPrivateInfo() {
  var o = new api.InterconnectAttachmentPrivateInfo();
  buildCounterInterconnectAttachmentPrivateInfo++;
  if (buildCounterInterconnectAttachmentPrivateInfo < 3) {
    o.tag8021q = 42;
  }
  buildCounterInterconnectAttachmentPrivateInfo--;
  return o;
}

checkInterconnectAttachmentPrivateInfo(
    api.InterconnectAttachmentPrivateInfo o) {
  buildCounterInterconnectAttachmentPrivateInfo++;
  if (buildCounterInterconnectAttachmentPrivateInfo < 3) {
    unittest.expect(o.tag8021q, unittest.equals(42));
  }
  buildCounterInterconnectAttachmentPrivateInfo--;
}

buildUnnamed1805() {
  var o = new core.List<api.InterconnectAttachment>();
  o.add(buildInterconnectAttachment());
  o.add(buildInterconnectAttachment());
  return o;
}

checkUnnamed1805(core.List<api.InterconnectAttachment> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectAttachment(o[0]);
  checkInterconnectAttachment(o[1]);
}

core.int buildCounterInterconnectAttachmentsScopedListWarningData = 0;
buildInterconnectAttachmentsScopedListWarningData() {
  var o = new api.InterconnectAttachmentsScopedListWarningData();
  buildCounterInterconnectAttachmentsScopedListWarningData++;
  if (buildCounterInterconnectAttachmentsScopedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterInterconnectAttachmentsScopedListWarningData--;
  return o;
}

checkInterconnectAttachmentsScopedListWarningData(
    api.InterconnectAttachmentsScopedListWarningData o) {
  buildCounterInterconnectAttachmentsScopedListWarningData++;
  if (buildCounterInterconnectAttachmentsScopedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterInterconnectAttachmentsScopedListWarningData--;
}

buildUnnamed1806() {
  var o = new core.List<api.InterconnectAttachmentsScopedListWarningData>();
  o.add(buildInterconnectAttachmentsScopedListWarningData());
  o.add(buildInterconnectAttachmentsScopedListWarningData());
  return o;
}

checkUnnamed1806(
    core.List<api.InterconnectAttachmentsScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectAttachmentsScopedListWarningData(o[0]);
  checkInterconnectAttachmentsScopedListWarningData(o[1]);
}

core.int buildCounterInterconnectAttachmentsScopedListWarning = 0;
buildInterconnectAttachmentsScopedListWarning() {
  var o = new api.InterconnectAttachmentsScopedListWarning();
  buildCounterInterconnectAttachmentsScopedListWarning++;
  if (buildCounterInterconnectAttachmentsScopedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1806();
    o.message = "foo";
  }
  buildCounterInterconnectAttachmentsScopedListWarning--;
  return o;
}

checkInterconnectAttachmentsScopedListWarning(
    api.InterconnectAttachmentsScopedListWarning o) {
  buildCounterInterconnectAttachmentsScopedListWarning++;
  if (buildCounterInterconnectAttachmentsScopedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1806(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterInterconnectAttachmentsScopedListWarning--;
}

core.int buildCounterInterconnectAttachmentsScopedList = 0;
buildInterconnectAttachmentsScopedList() {
  var o = new api.InterconnectAttachmentsScopedList();
  buildCounterInterconnectAttachmentsScopedList++;
  if (buildCounterInterconnectAttachmentsScopedList < 3) {
    o.interconnectAttachments = buildUnnamed1805();
    o.warning = buildInterconnectAttachmentsScopedListWarning();
  }
  buildCounterInterconnectAttachmentsScopedList--;
  return o;
}

checkInterconnectAttachmentsScopedList(
    api.InterconnectAttachmentsScopedList o) {
  buildCounterInterconnectAttachmentsScopedList++;
  if (buildCounterInterconnectAttachmentsScopedList < 3) {
    checkUnnamed1805(o.interconnectAttachments);
    checkInterconnectAttachmentsScopedListWarning(o.warning);
  }
  buildCounterInterconnectAttachmentsScopedList--;
}

core.int buildCounterInterconnectCircuitInfo = 0;
buildInterconnectCircuitInfo() {
  var o = new api.InterconnectCircuitInfo();
  buildCounterInterconnectCircuitInfo++;
  if (buildCounterInterconnectCircuitInfo < 3) {
    o.customerDemarcId = "foo";
    o.googleCircuitId = "foo";
    o.googleDemarcId = "foo";
  }
  buildCounterInterconnectCircuitInfo--;
  return o;
}

checkInterconnectCircuitInfo(api.InterconnectCircuitInfo o) {
  buildCounterInterconnectCircuitInfo++;
  if (buildCounterInterconnectCircuitInfo < 3) {
    unittest.expect(o.customerDemarcId, unittest.equals('foo'));
    unittest.expect(o.googleCircuitId, unittest.equals('foo'));
    unittest.expect(o.googleDemarcId, unittest.equals('foo'));
  }
  buildCounterInterconnectCircuitInfo--;
}

buildUnnamed1807() {
  var o = new core.List<api.InterconnectDiagnosticsARPEntry>();
  o.add(buildInterconnectDiagnosticsARPEntry());
  o.add(buildInterconnectDiagnosticsARPEntry());
  return o;
}

checkUnnamed1807(core.List<api.InterconnectDiagnosticsARPEntry> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectDiagnosticsARPEntry(o[0]);
  checkInterconnectDiagnosticsARPEntry(o[1]);
}

buildUnnamed1808() {
  var o = new core.List<api.InterconnectDiagnosticsLinkStatus>();
  o.add(buildInterconnectDiagnosticsLinkStatus());
  o.add(buildInterconnectDiagnosticsLinkStatus());
  return o;
}

checkUnnamed1808(core.List<api.InterconnectDiagnosticsLinkStatus> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectDiagnosticsLinkStatus(o[0]);
  checkInterconnectDiagnosticsLinkStatus(o[1]);
}

core.int buildCounterInterconnectDiagnostics = 0;
buildInterconnectDiagnostics() {
  var o = new api.InterconnectDiagnostics();
  buildCounterInterconnectDiagnostics++;
  if (buildCounterInterconnectDiagnostics < 3) {
    o.arpCaches = buildUnnamed1807();
    o.links = buildUnnamed1808();
    o.macAddress = "foo";
  }
  buildCounterInterconnectDiagnostics--;
  return o;
}

checkInterconnectDiagnostics(api.InterconnectDiagnostics o) {
  buildCounterInterconnectDiagnostics++;
  if (buildCounterInterconnectDiagnostics < 3) {
    checkUnnamed1807(o.arpCaches);
    checkUnnamed1808(o.links);
    unittest.expect(o.macAddress, unittest.equals('foo'));
  }
  buildCounterInterconnectDiagnostics--;
}

core.int buildCounterInterconnectDiagnosticsARPEntry = 0;
buildInterconnectDiagnosticsARPEntry() {
  var o = new api.InterconnectDiagnosticsARPEntry();
  buildCounterInterconnectDiagnosticsARPEntry++;
  if (buildCounterInterconnectDiagnosticsARPEntry < 3) {
    o.ipAddress = "foo";
    o.macAddress = "foo";
  }
  buildCounterInterconnectDiagnosticsARPEntry--;
  return o;
}

checkInterconnectDiagnosticsARPEntry(api.InterconnectDiagnosticsARPEntry o) {
  buildCounterInterconnectDiagnosticsARPEntry++;
  if (buildCounterInterconnectDiagnosticsARPEntry < 3) {
    unittest.expect(o.ipAddress, unittest.equals('foo'));
    unittest.expect(o.macAddress, unittest.equals('foo'));
  }
  buildCounterInterconnectDiagnosticsARPEntry--;
}

core.int buildCounterInterconnectDiagnosticsLinkLACPStatus = 0;
buildInterconnectDiagnosticsLinkLACPStatus() {
  var o = new api.InterconnectDiagnosticsLinkLACPStatus();
  buildCounterInterconnectDiagnosticsLinkLACPStatus++;
  if (buildCounterInterconnectDiagnosticsLinkLACPStatus < 3) {
    o.googleSystemId = "foo";
    o.neighborSystemId = "foo";
    o.state = "foo";
  }
  buildCounterInterconnectDiagnosticsLinkLACPStatus--;
  return o;
}

checkInterconnectDiagnosticsLinkLACPStatus(
    api.InterconnectDiagnosticsLinkLACPStatus o) {
  buildCounterInterconnectDiagnosticsLinkLACPStatus++;
  if (buildCounterInterconnectDiagnosticsLinkLACPStatus < 3) {
    unittest.expect(o.googleSystemId, unittest.equals('foo'));
    unittest.expect(o.neighborSystemId, unittest.equals('foo'));
    unittest.expect(o.state, unittest.equals('foo'));
  }
  buildCounterInterconnectDiagnosticsLinkLACPStatus--;
}

core.int buildCounterInterconnectDiagnosticsLinkOpticalPower = 0;
buildInterconnectDiagnosticsLinkOpticalPower() {
  var o = new api.InterconnectDiagnosticsLinkOpticalPower();
  buildCounterInterconnectDiagnosticsLinkOpticalPower++;
  if (buildCounterInterconnectDiagnosticsLinkOpticalPower < 3) {
    o.state = "foo";
    o.value = 42.0;
  }
  buildCounterInterconnectDiagnosticsLinkOpticalPower--;
  return o;
}

checkInterconnectDiagnosticsLinkOpticalPower(
    api.InterconnectDiagnosticsLinkOpticalPower o) {
  buildCounterInterconnectDiagnosticsLinkOpticalPower++;
  if (buildCounterInterconnectDiagnosticsLinkOpticalPower < 3) {
    unittest.expect(o.state, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals(42.0));
  }
  buildCounterInterconnectDiagnosticsLinkOpticalPower--;
}

buildUnnamed1809() {
  var o = new core.List<api.InterconnectDiagnosticsARPEntry>();
  o.add(buildInterconnectDiagnosticsARPEntry());
  o.add(buildInterconnectDiagnosticsARPEntry());
  return o;
}

checkUnnamed1809(core.List<api.InterconnectDiagnosticsARPEntry> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectDiagnosticsARPEntry(o[0]);
  checkInterconnectDiagnosticsARPEntry(o[1]);
}

core.int buildCounterInterconnectDiagnosticsLinkStatus = 0;
buildInterconnectDiagnosticsLinkStatus() {
  var o = new api.InterconnectDiagnosticsLinkStatus();
  buildCounterInterconnectDiagnosticsLinkStatus++;
  if (buildCounterInterconnectDiagnosticsLinkStatus < 3) {
    o.arpCaches = buildUnnamed1809();
    o.circuitId = "foo";
    o.googleDemarc = "foo";
    o.lacpStatus = buildInterconnectDiagnosticsLinkLACPStatus();
    o.receivingOpticalPower = buildInterconnectDiagnosticsLinkOpticalPower();
    o.transmittingOpticalPower = buildInterconnectDiagnosticsLinkOpticalPower();
  }
  buildCounterInterconnectDiagnosticsLinkStatus--;
  return o;
}

checkInterconnectDiagnosticsLinkStatus(
    api.InterconnectDiagnosticsLinkStatus o) {
  buildCounterInterconnectDiagnosticsLinkStatus++;
  if (buildCounterInterconnectDiagnosticsLinkStatus < 3) {
    checkUnnamed1809(o.arpCaches);
    unittest.expect(o.circuitId, unittest.equals('foo'));
    unittest.expect(o.googleDemarc, unittest.equals('foo'));
    checkInterconnectDiagnosticsLinkLACPStatus(o.lacpStatus);
    checkInterconnectDiagnosticsLinkOpticalPower(o.receivingOpticalPower);
    checkInterconnectDiagnosticsLinkOpticalPower(o.transmittingOpticalPower);
  }
  buildCounterInterconnectDiagnosticsLinkStatus--;
}

buildUnnamed1810() {
  var o = new core.List<api.Interconnect>();
  o.add(buildInterconnect());
  o.add(buildInterconnect());
  return o;
}

checkUnnamed1810(core.List<api.Interconnect> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnect(o[0]);
  checkInterconnect(o[1]);
}

core.int buildCounterInterconnectListWarningData = 0;
buildInterconnectListWarningData() {
  var o = new api.InterconnectListWarningData();
  buildCounterInterconnectListWarningData++;
  if (buildCounterInterconnectListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterInterconnectListWarningData--;
  return o;
}

checkInterconnectListWarningData(api.InterconnectListWarningData o) {
  buildCounterInterconnectListWarningData++;
  if (buildCounterInterconnectListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterInterconnectListWarningData--;
}

buildUnnamed1811() {
  var o = new core.List<api.InterconnectListWarningData>();
  o.add(buildInterconnectListWarningData());
  o.add(buildInterconnectListWarningData());
  return o;
}

checkUnnamed1811(core.List<api.InterconnectListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectListWarningData(o[0]);
  checkInterconnectListWarningData(o[1]);
}

core.int buildCounterInterconnectListWarning = 0;
buildInterconnectListWarning() {
  var o = new api.InterconnectListWarning();
  buildCounterInterconnectListWarning++;
  if (buildCounterInterconnectListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1811();
    o.message = "foo";
  }
  buildCounterInterconnectListWarning--;
  return o;
}

checkInterconnectListWarning(api.InterconnectListWarning o) {
  buildCounterInterconnectListWarning++;
  if (buildCounterInterconnectListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1811(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterInterconnectListWarning--;
}

core.int buildCounterInterconnectList = 0;
buildInterconnectList() {
  var o = new api.InterconnectList();
  buildCounterInterconnectList++;
  if (buildCounterInterconnectList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1810();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildInterconnectListWarning();
  }
  buildCounterInterconnectList--;
  return o;
}

checkInterconnectList(api.InterconnectList o) {
  buildCounterInterconnectList++;
  if (buildCounterInterconnectList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1810(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkInterconnectListWarning(o.warning);
  }
  buildCounterInterconnectList--;
}

buildUnnamed1812() {
  var o = new core.List<api.InterconnectLocationRegionInfo>();
  o.add(buildInterconnectLocationRegionInfo());
  o.add(buildInterconnectLocationRegionInfo());
  return o;
}

checkUnnamed1812(core.List<api.InterconnectLocationRegionInfo> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectLocationRegionInfo(o[0]);
  checkInterconnectLocationRegionInfo(o[1]);
}

core.int buildCounterInterconnectLocation = 0;
buildInterconnectLocation() {
  var o = new api.InterconnectLocation();
  buildCounterInterconnectLocation++;
  if (buildCounterInterconnectLocation < 3) {
    o.address = "foo";
    o.availabilityZone = "foo";
    o.city = "foo";
    o.continent = "foo";
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.facilityProvider = "foo";
    o.facilityProviderFacilityId = "foo";
    o.id = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.peeringdbFacilityId = "foo";
    o.regionInfos = buildUnnamed1812();
    o.selfLink = "foo";
    o.status = "foo";
  }
  buildCounterInterconnectLocation--;
  return o;
}

checkInterconnectLocation(api.InterconnectLocation o) {
  buildCounterInterconnectLocation++;
  if (buildCounterInterconnectLocation < 3) {
    unittest.expect(o.address, unittest.equals('foo'));
    unittest.expect(o.availabilityZone, unittest.equals('foo'));
    unittest.expect(o.city, unittest.equals('foo'));
    unittest.expect(o.continent, unittest.equals('foo'));
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.facilityProvider, unittest.equals('foo'));
    unittest.expect(o.facilityProviderFacilityId, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.peeringdbFacilityId, unittest.equals('foo'));
    checkUnnamed1812(o.regionInfos);
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.status, unittest.equals('foo'));
  }
  buildCounterInterconnectLocation--;
}

buildUnnamed1813() {
  var o = new core.List<api.InterconnectLocation>();
  o.add(buildInterconnectLocation());
  o.add(buildInterconnectLocation());
  return o;
}

checkUnnamed1813(core.List<api.InterconnectLocation> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectLocation(o[0]);
  checkInterconnectLocation(o[1]);
}

core.int buildCounterInterconnectLocationListWarningData = 0;
buildInterconnectLocationListWarningData() {
  var o = new api.InterconnectLocationListWarningData();
  buildCounterInterconnectLocationListWarningData++;
  if (buildCounterInterconnectLocationListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterInterconnectLocationListWarningData--;
  return o;
}

checkInterconnectLocationListWarningData(
    api.InterconnectLocationListWarningData o) {
  buildCounterInterconnectLocationListWarningData++;
  if (buildCounterInterconnectLocationListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterInterconnectLocationListWarningData--;
}

buildUnnamed1814() {
  var o = new core.List<api.InterconnectLocationListWarningData>();
  o.add(buildInterconnectLocationListWarningData());
  o.add(buildInterconnectLocationListWarningData());
  return o;
}

checkUnnamed1814(core.List<api.InterconnectLocationListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectLocationListWarningData(o[0]);
  checkInterconnectLocationListWarningData(o[1]);
}

core.int buildCounterInterconnectLocationListWarning = 0;
buildInterconnectLocationListWarning() {
  var o = new api.InterconnectLocationListWarning();
  buildCounterInterconnectLocationListWarning++;
  if (buildCounterInterconnectLocationListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1814();
    o.message = "foo";
  }
  buildCounterInterconnectLocationListWarning--;
  return o;
}

checkInterconnectLocationListWarning(api.InterconnectLocationListWarning o) {
  buildCounterInterconnectLocationListWarning++;
  if (buildCounterInterconnectLocationListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1814(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterInterconnectLocationListWarning--;
}

core.int buildCounterInterconnectLocationList = 0;
buildInterconnectLocationList() {
  var o = new api.InterconnectLocationList();
  buildCounterInterconnectLocationList++;
  if (buildCounterInterconnectLocationList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1813();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildInterconnectLocationListWarning();
  }
  buildCounterInterconnectLocationList--;
  return o;
}

checkInterconnectLocationList(api.InterconnectLocationList o) {
  buildCounterInterconnectLocationList++;
  if (buildCounterInterconnectLocationList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1813(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkInterconnectLocationListWarning(o.warning);
  }
  buildCounterInterconnectLocationList--;
}

core.int buildCounterInterconnectLocationRegionInfo = 0;
buildInterconnectLocationRegionInfo() {
  var o = new api.InterconnectLocationRegionInfo();
  buildCounterInterconnectLocationRegionInfo++;
  if (buildCounterInterconnectLocationRegionInfo < 3) {
    o.expectedRttMs = "foo";
    o.locationPresence = "foo";
    o.region = "foo";
  }
  buildCounterInterconnectLocationRegionInfo--;
  return o;
}

checkInterconnectLocationRegionInfo(api.InterconnectLocationRegionInfo o) {
  buildCounterInterconnectLocationRegionInfo++;
  if (buildCounterInterconnectLocationRegionInfo < 3) {
    unittest.expect(o.expectedRttMs, unittest.equals('foo'));
    unittest.expect(o.locationPresence, unittest.equals('foo'));
    unittest.expect(o.region, unittest.equals('foo'));
  }
  buildCounterInterconnectLocationRegionInfo--;
}

buildUnnamed1815() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1815(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterInterconnectOutageNotification = 0;
buildInterconnectOutageNotification() {
  var o = new api.InterconnectOutageNotification();
  buildCounterInterconnectOutageNotification++;
  if (buildCounterInterconnectOutageNotification < 3) {
    o.affectedCircuits = buildUnnamed1815();
    o.description = "foo";
    o.endTime = "foo";
    o.issueType = "foo";
    o.name = "foo";
    o.source = "foo";
    o.startTime = "foo";
    o.state = "foo";
  }
  buildCounterInterconnectOutageNotification--;
  return o;
}

checkInterconnectOutageNotification(api.InterconnectOutageNotification o) {
  buildCounterInterconnectOutageNotification++;
  if (buildCounterInterconnectOutageNotification < 3) {
    checkUnnamed1815(o.affectedCircuits);
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.endTime, unittest.equals('foo'));
    unittest.expect(o.issueType, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.source, unittest.equals('foo'));
    unittest.expect(o.startTime, unittest.equals('foo'));
    unittest.expect(o.state, unittest.equals('foo'));
  }
  buildCounterInterconnectOutageNotification--;
}

core.int buildCounterInterconnectsGetDiagnosticsResponse = 0;
buildInterconnectsGetDiagnosticsResponse() {
  var o = new api.InterconnectsGetDiagnosticsResponse();
  buildCounterInterconnectsGetDiagnosticsResponse++;
  if (buildCounterInterconnectsGetDiagnosticsResponse < 3) {
    o.result = buildInterconnectDiagnostics();
  }
  buildCounterInterconnectsGetDiagnosticsResponse--;
  return o;
}

checkInterconnectsGetDiagnosticsResponse(
    api.InterconnectsGetDiagnosticsResponse o) {
  buildCounterInterconnectsGetDiagnosticsResponse++;
  if (buildCounterInterconnectsGetDiagnosticsResponse < 3) {
    checkInterconnectDiagnostics(o.result);
  }
  buildCounterInterconnectsGetDiagnosticsResponse--;
}

core.int buildCounterLicense = 0;
buildLicense() {
  var o = new api.License();
  buildCounterLicense++;
  if (buildCounterLicense < 3) {
    o.chargesUseFee = true;
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.id = "foo";
    o.kind = "foo";
    o.licenseCode = "foo";
    o.name = "foo";
    o.resourceRequirements = buildLicenseResourceRequirements();
    o.selfLink = "foo";
    o.transferable = true;
  }
  buildCounterLicense--;
  return o;
}

checkLicense(api.License o) {
  buildCounterLicense++;
  if (buildCounterLicense < 3) {
    unittest.expect(o.chargesUseFee, unittest.isTrue);
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.licenseCode, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    checkLicenseResourceRequirements(o.resourceRequirements);
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.transferable, unittest.isTrue);
  }
  buildCounterLicense--;
}

buildUnnamed1816() {
  var o = new core.List<api.LicenseCodeLicenseAlias>();
  o.add(buildLicenseCodeLicenseAlias());
  o.add(buildLicenseCodeLicenseAlias());
  return o;
}

checkUnnamed1816(core.List<api.LicenseCodeLicenseAlias> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkLicenseCodeLicenseAlias(o[0]);
  checkLicenseCodeLicenseAlias(o[1]);
}

core.int buildCounterLicenseCode = 0;
buildLicenseCode() {
  var o = new api.LicenseCode();
  buildCounterLicenseCode++;
  if (buildCounterLicenseCode < 3) {
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.id = "foo";
    o.kind = "foo";
    o.licenseAlias = buildUnnamed1816();
    o.name = "foo";
    o.selfLink = "foo";
    o.state = "foo";
    o.transferable = true;
  }
  buildCounterLicenseCode--;
  return o;
}

checkLicenseCode(api.LicenseCode o) {
  buildCounterLicenseCode++;
  if (buildCounterLicenseCode < 3) {
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    checkUnnamed1816(o.licenseAlias);
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.state, unittest.equals('foo'));
    unittest.expect(o.transferable, unittest.isTrue);
  }
  buildCounterLicenseCode--;
}

core.int buildCounterLicenseCodeLicenseAlias = 0;
buildLicenseCodeLicenseAlias() {
  var o = new api.LicenseCodeLicenseAlias();
  buildCounterLicenseCodeLicenseAlias++;
  if (buildCounterLicenseCodeLicenseAlias < 3) {
    o.description = "foo";
    o.selfLink = "foo";
  }
  buildCounterLicenseCodeLicenseAlias--;
  return o;
}

checkLicenseCodeLicenseAlias(api.LicenseCodeLicenseAlias o) {
  buildCounterLicenseCodeLicenseAlias++;
  if (buildCounterLicenseCodeLicenseAlias < 3) {
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
  }
  buildCounterLicenseCodeLicenseAlias--;
}

core.int buildCounterLicenseResourceRequirements = 0;
buildLicenseResourceRequirements() {
  var o = new api.LicenseResourceRequirements();
  buildCounterLicenseResourceRequirements++;
  if (buildCounterLicenseResourceRequirements < 3) {
    o.minGuestCpuCount = 42;
    o.minMemoryMb = 42;
  }
  buildCounterLicenseResourceRequirements--;
  return o;
}

checkLicenseResourceRequirements(api.LicenseResourceRequirements o) {
  buildCounterLicenseResourceRequirements++;
  if (buildCounterLicenseResourceRequirements < 3) {
    unittest.expect(o.minGuestCpuCount, unittest.equals(42));
    unittest.expect(o.minMemoryMb, unittest.equals(42));
  }
  buildCounterLicenseResourceRequirements--;
}

buildUnnamed1817() {
  var o = new core.List<api.License>();
  o.add(buildLicense());
  o.add(buildLicense());
  return o;
}

checkUnnamed1817(core.List<api.License> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkLicense(o[0]);
  checkLicense(o[1]);
}

core.int buildCounterLicensesListResponseWarningData = 0;
buildLicensesListResponseWarningData() {
  var o = new api.LicensesListResponseWarningData();
  buildCounterLicensesListResponseWarningData++;
  if (buildCounterLicensesListResponseWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterLicensesListResponseWarningData--;
  return o;
}

checkLicensesListResponseWarningData(api.LicensesListResponseWarningData o) {
  buildCounterLicensesListResponseWarningData++;
  if (buildCounterLicensesListResponseWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterLicensesListResponseWarningData--;
}

buildUnnamed1818() {
  var o = new core.List<api.LicensesListResponseWarningData>();
  o.add(buildLicensesListResponseWarningData());
  o.add(buildLicensesListResponseWarningData());
  return o;
}

checkUnnamed1818(core.List<api.LicensesListResponseWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkLicensesListResponseWarningData(o[0]);
  checkLicensesListResponseWarningData(o[1]);
}

core.int buildCounterLicensesListResponseWarning = 0;
buildLicensesListResponseWarning() {
  var o = new api.LicensesListResponseWarning();
  buildCounterLicensesListResponseWarning++;
  if (buildCounterLicensesListResponseWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1818();
    o.message = "foo";
  }
  buildCounterLicensesListResponseWarning--;
  return o;
}

checkLicensesListResponseWarning(api.LicensesListResponseWarning o) {
  buildCounterLicensesListResponseWarning++;
  if (buildCounterLicensesListResponseWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1818(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterLicensesListResponseWarning--;
}

core.int buildCounterLicensesListResponse = 0;
buildLicensesListResponse() {
  var o = new api.LicensesListResponse();
  buildCounterLicensesListResponse++;
  if (buildCounterLicensesListResponse < 3) {
    o.id = "foo";
    o.items = buildUnnamed1817();
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildLicensesListResponseWarning();
  }
  buildCounterLicensesListResponse--;
  return o;
}

checkLicensesListResponse(api.LicensesListResponse o) {
  buildCounterLicensesListResponse++;
  if (buildCounterLicensesListResponse < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1817(o.items);
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkLicensesListResponseWarning(o.warning);
  }
  buildCounterLicensesListResponse--;
}

core.int buildCounterLogConfig = 0;
buildLogConfig() {
  var o = new api.LogConfig();
  buildCounterLogConfig++;
  if (buildCounterLogConfig < 3) {
    o.cloudAudit = buildLogConfigCloudAuditOptions();
    o.counter = buildLogConfigCounterOptions();
    o.dataAccess = buildLogConfigDataAccessOptions();
  }
  buildCounterLogConfig--;
  return o;
}

checkLogConfig(api.LogConfig o) {
  buildCounterLogConfig++;
  if (buildCounterLogConfig < 3) {
    checkLogConfigCloudAuditOptions(o.cloudAudit);
    checkLogConfigCounterOptions(o.counter);
    checkLogConfigDataAccessOptions(o.dataAccess);
  }
  buildCounterLogConfig--;
}

core.int buildCounterLogConfigCloudAuditOptions = 0;
buildLogConfigCloudAuditOptions() {
  var o = new api.LogConfigCloudAuditOptions();
  buildCounterLogConfigCloudAuditOptions++;
  if (buildCounterLogConfigCloudAuditOptions < 3) {
    o.authorizationLoggingOptions = buildAuthorizationLoggingOptions();
    o.logName = "foo";
  }
  buildCounterLogConfigCloudAuditOptions--;
  return o;
}

checkLogConfigCloudAuditOptions(api.LogConfigCloudAuditOptions o) {
  buildCounterLogConfigCloudAuditOptions++;
  if (buildCounterLogConfigCloudAuditOptions < 3) {
    checkAuthorizationLoggingOptions(o.authorizationLoggingOptions);
    unittest.expect(o.logName, unittest.equals('foo'));
  }
  buildCounterLogConfigCloudAuditOptions--;
}

core.int buildCounterLogConfigCounterOptions = 0;
buildLogConfigCounterOptions() {
  var o = new api.LogConfigCounterOptions();
  buildCounterLogConfigCounterOptions++;
  if (buildCounterLogConfigCounterOptions < 3) {
    o.field = "foo";
    o.metric = "foo";
  }
  buildCounterLogConfigCounterOptions--;
  return o;
}

checkLogConfigCounterOptions(api.LogConfigCounterOptions o) {
  buildCounterLogConfigCounterOptions++;
  if (buildCounterLogConfigCounterOptions < 3) {
    unittest.expect(o.field, unittest.equals('foo'));
    unittest.expect(o.metric, unittest.equals('foo'));
  }
  buildCounterLogConfigCounterOptions--;
}

core.int buildCounterLogConfigDataAccessOptions = 0;
buildLogConfigDataAccessOptions() {
  var o = new api.LogConfigDataAccessOptions();
  buildCounterLogConfigDataAccessOptions++;
  if (buildCounterLogConfigDataAccessOptions < 3) {
    o.logMode = "foo";
  }
  buildCounterLogConfigDataAccessOptions--;
  return o;
}

checkLogConfigDataAccessOptions(api.LogConfigDataAccessOptions o) {
  buildCounterLogConfigDataAccessOptions++;
  if (buildCounterLogConfigDataAccessOptions < 3) {
    unittest.expect(o.logMode, unittest.equals('foo'));
  }
  buildCounterLogConfigDataAccessOptions--;
}

core.int buildCounterMachineTypeScratchDisks = 0;
buildMachineTypeScratchDisks() {
  var o = new api.MachineTypeScratchDisks();
  buildCounterMachineTypeScratchDisks++;
  if (buildCounterMachineTypeScratchDisks < 3) {
    o.diskGb = 42;
  }
  buildCounterMachineTypeScratchDisks--;
  return o;
}

checkMachineTypeScratchDisks(api.MachineTypeScratchDisks o) {
  buildCounterMachineTypeScratchDisks++;
  if (buildCounterMachineTypeScratchDisks < 3) {
    unittest.expect(o.diskGb, unittest.equals(42));
  }
  buildCounterMachineTypeScratchDisks--;
}

buildUnnamed1819() {
  var o = new core.List<api.MachineTypeScratchDisks>();
  o.add(buildMachineTypeScratchDisks());
  o.add(buildMachineTypeScratchDisks());
  return o;
}

checkUnnamed1819(core.List<api.MachineTypeScratchDisks> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkMachineTypeScratchDisks(o[0]);
  checkMachineTypeScratchDisks(o[1]);
}

core.int buildCounterMachineType = 0;
buildMachineType() {
  var o = new api.MachineType();
  buildCounterMachineType++;
  if (buildCounterMachineType < 3) {
    o.creationTimestamp = "foo";
    o.deprecated = buildDeprecationStatus();
    o.description = "foo";
    o.guestCpus = 42;
    o.id = "foo";
    o.imageSpaceGb = 42;
    o.isSharedCpu = true;
    o.kind = "foo";
    o.maximumPersistentDisks = 42;
    o.maximumPersistentDisksSizeGb = "foo";
    o.memoryMb = 42;
    o.name = "foo";
    o.scratchDisks = buildUnnamed1819();
    o.selfLink = "foo";
    o.zone = "foo";
  }
  buildCounterMachineType--;
  return o;
}

checkMachineType(api.MachineType o) {
  buildCounterMachineType++;
  if (buildCounterMachineType < 3) {
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    checkDeprecationStatus(o.deprecated);
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.guestCpus, unittest.equals(42));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.imageSpaceGb, unittest.equals(42));
    unittest.expect(o.isSharedCpu, unittest.isTrue);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.maximumPersistentDisks, unittest.equals(42));
    unittest.expect(o.maximumPersistentDisksSizeGb, unittest.equals('foo'));
    unittest.expect(o.memoryMb, unittest.equals(42));
    unittest.expect(o.name, unittest.equals('foo'));
    checkUnnamed1819(o.scratchDisks);
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.zone, unittest.equals('foo'));
  }
  buildCounterMachineType--;
}

buildUnnamed1820() {
  var o = new core.Map<core.String, api.MachineTypesScopedList>();
  o["x"] = buildMachineTypesScopedList();
  o["y"] = buildMachineTypesScopedList();
  return o;
}

checkUnnamed1820(core.Map<core.String, api.MachineTypesScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkMachineTypesScopedList(o["x"]);
  checkMachineTypesScopedList(o["y"]);
}

core.int buildCounterMachineTypeAggregatedListWarningData = 0;
buildMachineTypeAggregatedListWarningData() {
  var o = new api.MachineTypeAggregatedListWarningData();
  buildCounterMachineTypeAggregatedListWarningData++;
  if (buildCounterMachineTypeAggregatedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterMachineTypeAggregatedListWarningData--;
  return o;
}

checkMachineTypeAggregatedListWarningData(
    api.MachineTypeAggregatedListWarningData o) {
  buildCounterMachineTypeAggregatedListWarningData++;
  if (buildCounterMachineTypeAggregatedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterMachineTypeAggregatedListWarningData--;
}

buildUnnamed1821() {
  var o = new core.List<api.MachineTypeAggregatedListWarningData>();
  o.add(buildMachineTypeAggregatedListWarningData());
  o.add(buildMachineTypeAggregatedListWarningData());
  return o;
}

checkUnnamed1821(core.List<api.MachineTypeAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkMachineTypeAggregatedListWarningData(o[0]);
  checkMachineTypeAggregatedListWarningData(o[1]);
}

core.int buildCounterMachineTypeAggregatedListWarning = 0;
buildMachineTypeAggregatedListWarning() {
  var o = new api.MachineTypeAggregatedListWarning();
  buildCounterMachineTypeAggregatedListWarning++;
  if (buildCounterMachineTypeAggregatedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1821();
    o.message = "foo";
  }
  buildCounterMachineTypeAggregatedListWarning--;
  return o;
}

checkMachineTypeAggregatedListWarning(api.MachineTypeAggregatedListWarning o) {
  buildCounterMachineTypeAggregatedListWarning++;
  if (buildCounterMachineTypeAggregatedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1821(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterMachineTypeAggregatedListWarning--;
}

core.int buildCounterMachineTypeAggregatedList = 0;
buildMachineTypeAggregatedList() {
  var o = new api.MachineTypeAggregatedList();
  buildCounterMachineTypeAggregatedList++;
  if (buildCounterMachineTypeAggregatedList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1820();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildMachineTypeAggregatedListWarning();
  }
  buildCounterMachineTypeAggregatedList--;
  return o;
}

checkMachineTypeAggregatedList(api.MachineTypeAggregatedList o) {
  buildCounterMachineTypeAggregatedList++;
  if (buildCounterMachineTypeAggregatedList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1820(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkMachineTypeAggregatedListWarning(o.warning);
  }
  buildCounterMachineTypeAggregatedList--;
}

buildUnnamed1822() {
  var o = new core.List<api.MachineType>();
  o.add(buildMachineType());
  o.add(buildMachineType());
  return o;
}

checkUnnamed1822(core.List<api.MachineType> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkMachineType(o[0]);
  checkMachineType(o[1]);
}

core.int buildCounterMachineTypeListWarningData = 0;
buildMachineTypeListWarningData() {
  var o = new api.MachineTypeListWarningData();
  buildCounterMachineTypeListWarningData++;
  if (buildCounterMachineTypeListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterMachineTypeListWarningData--;
  return o;
}

checkMachineTypeListWarningData(api.MachineTypeListWarningData o) {
  buildCounterMachineTypeListWarningData++;
  if (buildCounterMachineTypeListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterMachineTypeListWarningData--;
}

buildUnnamed1823() {
  var o = new core.List<api.MachineTypeListWarningData>();
  o.add(buildMachineTypeListWarningData());
  o.add(buildMachineTypeListWarningData());
  return o;
}

checkUnnamed1823(core.List<api.MachineTypeListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkMachineTypeListWarningData(o[0]);
  checkMachineTypeListWarningData(o[1]);
}

core.int buildCounterMachineTypeListWarning = 0;
buildMachineTypeListWarning() {
  var o = new api.MachineTypeListWarning();
  buildCounterMachineTypeListWarning++;
  if (buildCounterMachineTypeListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1823();
    o.message = "foo";
  }
  buildCounterMachineTypeListWarning--;
  return o;
}

checkMachineTypeListWarning(api.MachineTypeListWarning o) {
  buildCounterMachineTypeListWarning++;
  if (buildCounterMachineTypeListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1823(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterMachineTypeListWarning--;
}

core.int buildCounterMachineTypeList = 0;
buildMachineTypeList() {
  var o = new api.MachineTypeList();
  buildCounterMachineTypeList++;
  if (buildCounterMachineTypeList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1822();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildMachineTypeListWarning();
  }
  buildCounterMachineTypeList--;
  return o;
}

checkMachineTypeList(api.MachineTypeList o) {
  buildCounterMachineTypeList++;
  if (buildCounterMachineTypeList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1822(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkMachineTypeListWarning(o.warning);
  }
  buildCounterMachineTypeList--;
}

buildUnnamed1824() {
  var o = new core.List<api.MachineType>();
  o.add(buildMachineType());
  o.add(buildMachineType());
  return o;
}

checkUnnamed1824(core.List<api.MachineType> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkMachineType(o[0]);
  checkMachineType(o[1]);
}

core.int buildCounterMachineTypesScopedListWarningData = 0;
buildMachineTypesScopedListWarningData() {
  var o = new api.MachineTypesScopedListWarningData();
  buildCounterMachineTypesScopedListWarningData++;
  if (buildCounterMachineTypesScopedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterMachineTypesScopedListWarningData--;
  return o;
}

checkMachineTypesScopedListWarningData(
    api.MachineTypesScopedListWarningData o) {
  buildCounterMachineTypesScopedListWarningData++;
  if (buildCounterMachineTypesScopedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterMachineTypesScopedListWarningData--;
}

buildUnnamed1825() {
  var o = new core.List<api.MachineTypesScopedListWarningData>();
  o.add(buildMachineTypesScopedListWarningData());
  o.add(buildMachineTypesScopedListWarningData());
  return o;
}

checkUnnamed1825(core.List<api.MachineTypesScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkMachineTypesScopedListWarningData(o[0]);
  checkMachineTypesScopedListWarningData(o[1]);
}

core.int buildCounterMachineTypesScopedListWarning = 0;
buildMachineTypesScopedListWarning() {
  var o = new api.MachineTypesScopedListWarning();
  buildCounterMachineTypesScopedListWarning++;
  if (buildCounterMachineTypesScopedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1825();
    o.message = "foo";
  }
  buildCounterMachineTypesScopedListWarning--;
  return o;
}

checkMachineTypesScopedListWarning(api.MachineTypesScopedListWarning o) {
  buildCounterMachineTypesScopedListWarning++;
  if (buildCounterMachineTypesScopedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1825(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterMachineTypesScopedListWarning--;
}

core.int buildCounterMachineTypesScopedList = 0;
buildMachineTypesScopedList() {
  var o = new api.MachineTypesScopedList();
  buildCounterMachineTypesScopedList++;
  if (buildCounterMachineTypesScopedList < 3) {
    o.machineTypes = buildUnnamed1824();
    o.warning = buildMachineTypesScopedListWarning();
  }
  buildCounterMachineTypesScopedList--;
  return o;
}

checkMachineTypesScopedList(api.MachineTypesScopedList o) {
  buildCounterMachineTypesScopedList++;
  if (buildCounterMachineTypesScopedList < 3) {
    checkUnnamed1824(o.machineTypes);
    checkMachineTypesScopedListWarning(o.warning);
  }
  buildCounterMachineTypesScopedList--;
}

core.int buildCounterManagedInstance = 0;
buildManagedInstance() {
  var o = new api.ManagedInstance();
  buildCounterManagedInstance++;
  if (buildCounterManagedInstance < 3) {
    o.currentAction = "foo";
    o.id = "foo";
    o.instance = "foo";
    o.instanceStatus = "foo";
    o.lastAttempt = buildManagedInstanceLastAttempt();
    o.version = buildManagedInstanceVersion();
  }
  buildCounterManagedInstance--;
  return o;
}

checkManagedInstance(api.ManagedInstance o) {
  buildCounterManagedInstance++;
  if (buildCounterManagedInstance < 3) {
    unittest.expect(o.currentAction, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.instance, unittest.equals('foo'));
    unittest.expect(o.instanceStatus, unittest.equals('foo'));
    checkManagedInstanceLastAttempt(o.lastAttempt);
    checkManagedInstanceVersion(o.version);
  }
  buildCounterManagedInstance--;
}

core.int buildCounterManagedInstanceLastAttemptErrorsErrors = 0;
buildManagedInstanceLastAttemptErrorsErrors() {
  var o = new api.ManagedInstanceLastAttemptErrorsErrors();
  buildCounterManagedInstanceLastAttemptErrorsErrors++;
  if (buildCounterManagedInstanceLastAttemptErrorsErrors < 3) {
    o.code = "foo";
    o.location = "foo";
    o.message = "foo";
  }
  buildCounterManagedInstanceLastAttemptErrorsErrors--;
  return o;
}

checkManagedInstanceLastAttemptErrorsErrors(
    api.ManagedInstanceLastAttemptErrorsErrors o) {
  buildCounterManagedInstanceLastAttemptErrorsErrors++;
  if (buildCounterManagedInstanceLastAttemptErrorsErrors < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    unittest.expect(o.location, unittest.equals('foo'));
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterManagedInstanceLastAttemptErrorsErrors--;
}

buildUnnamed1826() {
  var o = new core.List<api.ManagedInstanceLastAttemptErrorsErrors>();
  o.add(buildManagedInstanceLastAttemptErrorsErrors());
  o.add(buildManagedInstanceLastAttemptErrorsErrors());
  return o;
}

checkUnnamed1826(core.List<api.ManagedInstanceLastAttemptErrorsErrors> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkManagedInstanceLastAttemptErrorsErrors(o[0]);
  checkManagedInstanceLastAttemptErrorsErrors(o[1]);
}

core.int buildCounterManagedInstanceLastAttemptErrors = 0;
buildManagedInstanceLastAttemptErrors() {
  var o = new api.ManagedInstanceLastAttemptErrors();
  buildCounterManagedInstanceLastAttemptErrors++;
  if (buildCounterManagedInstanceLastAttemptErrors < 3) {
    o.errors = buildUnnamed1826();
  }
  buildCounterManagedInstanceLastAttemptErrors--;
  return o;
}

checkManagedInstanceLastAttemptErrors(api.ManagedInstanceLastAttemptErrors o) {
  buildCounterManagedInstanceLastAttemptErrors++;
  if (buildCounterManagedInstanceLastAttemptErrors < 3) {
    checkUnnamed1826(o.errors);
  }
  buildCounterManagedInstanceLastAttemptErrors--;
}

core.int buildCounterManagedInstanceLastAttempt = 0;
buildManagedInstanceLastAttempt() {
  var o = new api.ManagedInstanceLastAttempt();
  buildCounterManagedInstanceLastAttempt++;
  if (buildCounterManagedInstanceLastAttempt < 3) {
    o.errors = buildManagedInstanceLastAttemptErrors();
  }
  buildCounterManagedInstanceLastAttempt--;
  return o;
}

checkManagedInstanceLastAttempt(api.ManagedInstanceLastAttempt o) {
  buildCounterManagedInstanceLastAttempt++;
  if (buildCounterManagedInstanceLastAttempt < 3) {
    checkManagedInstanceLastAttemptErrors(o.errors);
  }
  buildCounterManagedInstanceLastAttempt--;
}

core.int buildCounterManagedInstanceVersion = 0;
buildManagedInstanceVersion() {
  var o = new api.ManagedInstanceVersion();
  buildCounterManagedInstanceVersion++;
  if (buildCounterManagedInstanceVersion < 3) {
    o.instanceTemplate = "foo";
    o.name = "foo";
  }
  buildCounterManagedInstanceVersion--;
  return o;
}

checkManagedInstanceVersion(api.ManagedInstanceVersion o) {
  buildCounterManagedInstanceVersion++;
  if (buildCounterManagedInstanceVersion < 3) {
    unittest.expect(o.instanceTemplate, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
  }
  buildCounterManagedInstanceVersion--;
}

core.int buildCounterMetadataItems = 0;
buildMetadataItems() {
  var o = new api.MetadataItems();
  buildCounterMetadataItems++;
  if (buildCounterMetadataItems < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterMetadataItems--;
  return o;
}

checkMetadataItems(api.MetadataItems o) {
  buildCounterMetadataItems++;
  if (buildCounterMetadataItems < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterMetadataItems--;
}

buildUnnamed1827() {
  var o = new core.List<api.MetadataItems>();
  o.add(buildMetadataItems());
  o.add(buildMetadataItems());
  return o;
}

checkUnnamed1827(core.List<api.MetadataItems> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkMetadataItems(o[0]);
  checkMetadataItems(o[1]);
}

core.int buildCounterMetadata = 0;
buildMetadata() {
  var o = new api.Metadata();
  buildCounterMetadata++;
  if (buildCounterMetadata < 3) {
    o.fingerprint = "foo";
    o.items = buildUnnamed1827();
    o.kind = "foo";
  }
  buildCounterMetadata--;
  return o;
}

checkMetadata(api.Metadata o) {
  buildCounterMetadata++;
  if (buildCounterMetadata < 3) {
    unittest.expect(o.fingerprint, unittest.equals('foo'));
    checkUnnamed1827(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
  }
  buildCounterMetadata--;
}

core.int buildCounterNamedPort = 0;
buildNamedPort() {
  var o = new api.NamedPort();
  buildCounterNamedPort++;
  if (buildCounterNamedPort < 3) {
    o.name = "foo";
    o.port = 42;
  }
  buildCounterNamedPort--;
  return o;
}

checkNamedPort(api.NamedPort o) {
  buildCounterNamedPort++;
  if (buildCounterNamedPort < 3) {
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.port, unittest.equals(42));
  }
  buildCounterNamedPort--;
}

buildUnnamed1828() {
  var o = new core.List<api.NetworkPeering>();
  o.add(buildNetworkPeering());
  o.add(buildNetworkPeering());
  return o;
}

checkUnnamed1828(core.List<api.NetworkPeering> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkPeering(o[0]);
  checkNetworkPeering(o[1]);
}

buildUnnamed1829() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1829(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterNetwork = 0;
buildNetwork() {
  var o = new api.Network();
  buildCounterNetwork++;
  if (buildCounterNetwork < 3) {
    o.IPv4Range = "foo";
    o.autoCreateSubnetworks = true;
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.gatewayIPv4 = "foo";
    o.id = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.peerings = buildUnnamed1828();
    o.routingConfig = buildNetworkRoutingConfig();
    o.selfLink = "foo";
    o.subnetworks = buildUnnamed1829();
  }
  buildCounterNetwork--;
  return o;
}

checkNetwork(api.Network o) {
  buildCounterNetwork++;
  if (buildCounterNetwork < 3) {
    unittest.expect(o.IPv4Range, unittest.equals('foo'));
    unittest.expect(o.autoCreateSubnetworks, unittest.isTrue);
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.gatewayIPv4, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    checkUnnamed1828(o.peerings);
    checkNetworkRoutingConfig(o.routingConfig);
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkUnnamed1829(o.subnetworks);
  }
  buildCounterNetwork--;
}

core.int buildCounterNetworkEndpoint = 0;
buildNetworkEndpoint() {
  var o = new api.NetworkEndpoint();
  buildCounterNetworkEndpoint++;
  if (buildCounterNetworkEndpoint < 3) {
    o.instance = "foo";
    o.ipAddress = "foo";
    o.port = 42;
  }
  buildCounterNetworkEndpoint--;
  return o;
}

checkNetworkEndpoint(api.NetworkEndpoint o) {
  buildCounterNetworkEndpoint++;
  if (buildCounterNetworkEndpoint < 3) {
    unittest.expect(o.instance, unittest.equals('foo'));
    unittest.expect(o.ipAddress, unittest.equals('foo'));
    unittest.expect(o.port, unittest.equals(42));
  }
  buildCounterNetworkEndpoint--;
}

core.int buildCounterNetworkEndpointGroup = 0;
buildNetworkEndpointGroup() {
  var o = new api.NetworkEndpointGroup();
  buildCounterNetworkEndpointGroup++;
  if (buildCounterNetworkEndpointGroup < 3) {
    o.creationTimestamp = "foo";
    o.defaultPort = 42;
    o.description = "foo";
    o.id = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.network = "foo";
    o.networkEndpointType = "foo";
    o.selfLink = "foo";
    o.size = 42;
    o.subnetwork = "foo";
    o.zone = "foo";
  }
  buildCounterNetworkEndpointGroup--;
  return o;
}

checkNetworkEndpointGroup(api.NetworkEndpointGroup o) {
  buildCounterNetworkEndpointGroup++;
  if (buildCounterNetworkEndpointGroup < 3) {
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.defaultPort, unittest.equals(42));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.network, unittest.equals('foo'));
    unittest.expect(o.networkEndpointType, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.size, unittest.equals(42));
    unittest.expect(o.subnetwork, unittest.equals('foo'));
    unittest.expect(o.zone, unittest.equals('foo'));
  }
  buildCounterNetworkEndpointGroup--;
}

buildUnnamed1830() {
  var o = new core.Map<core.String, api.NetworkEndpointGroupsScopedList>();
  o["x"] = buildNetworkEndpointGroupsScopedList();
  o["y"] = buildNetworkEndpointGroupsScopedList();
  return o;
}

checkUnnamed1830(core.Map<core.String, api.NetworkEndpointGroupsScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkEndpointGroupsScopedList(o["x"]);
  checkNetworkEndpointGroupsScopedList(o["y"]);
}

core.int buildCounterNetworkEndpointGroupAggregatedListWarningData = 0;
buildNetworkEndpointGroupAggregatedListWarningData() {
  var o = new api.NetworkEndpointGroupAggregatedListWarningData();
  buildCounterNetworkEndpointGroupAggregatedListWarningData++;
  if (buildCounterNetworkEndpointGroupAggregatedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterNetworkEndpointGroupAggregatedListWarningData--;
  return o;
}

checkNetworkEndpointGroupAggregatedListWarningData(
    api.NetworkEndpointGroupAggregatedListWarningData o) {
  buildCounterNetworkEndpointGroupAggregatedListWarningData++;
  if (buildCounterNetworkEndpointGroupAggregatedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterNetworkEndpointGroupAggregatedListWarningData--;
}

buildUnnamed1831() {
  var o = new core.List<api.NetworkEndpointGroupAggregatedListWarningData>();
  o.add(buildNetworkEndpointGroupAggregatedListWarningData());
  o.add(buildNetworkEndpointGroupAggregatedListWarningData());
  return o;
}

checkUnnamed1831(
    core.List<api.NetworkEndpointGroupAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkEndpointGroupAggregatedListWarningData(o[0]);
  checkNetworkEndpointGroupAggregatedListWarningData(o[1]);
}

core.int buildCounterNetworkEndpointGroupAggregatedListWarning = 0;
buildNetworkEndpointGroupAggregatedListWarning() {
  var o = new api.NetworkEndpointGroupAggregatedListWarning();
  buildCounterNetworkEndpointGroupAggregatedListWarning++;
  if (buildCounterNetworkEndpointGroupAggregatedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1831();
    o.message = "foo";
  }
  buildCounterNetworkEndpointGroupAggregatedListWarning--;
  return o;
}

checkNetworkEndpointGroupAggregatedListWarning(
    api.NetworkEndpointGroupAggregatedListWarning o) {
  buildCounterNetworkEndpointGroupAggregatedListWarning++;
  if (buildCounterNetworkEndpointGroupAggregatedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1831(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterNetworkEndpointGroupAggregatedListWarning--;
}

core.int buildCounterNetworkEndpointGroupAggregatedList = 0;
buildNetworkEndpointGroupAggregatedList() {
  var o = new api.NetworkEndpointGroupAggregatedList();
  buildCounterNetworkEndpointGroupAggregatedList++;
  if (buildCounterNetworkEndpointGroupAggregatedList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1830();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildNetworkEndpointGroupAggregatedListWarning();
  }
  buildCounterNetworkEndpointGroupAggregatedList--;
  return o;
}

checkNetworkEndpointGroupAggregatedList(
    api.NetworkEndpointGroupAggregatedList o) {
  buildCounterNetworkEndpointGroupAggregatedList++;
  if (buildCounterNetworkEndpointGroupAggregatedList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1830(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkNetworkEndpointGroupAggregatedListWarning(o.warning);
  }
  buildCounterNetworkEndpointGroupAggregatedList--;
}

buildUnnamed1832() {
  var o = new core.List<api.NetworkEndpointGroup>();
  o.add(buildNetworkEndpointGroup());
  o.add(buildNetworkEndpointGroup());
  return o;
}

checkUnnamed1832(core.List<api.NetworkEndpointGroup> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkEndpointGroup(o[0]);
  checkNetworkEndpointGroup(o[1]);
}

core.int buildCounterNetworkEndpointGroupListWarningData = 0;
buildNetworkEndpointGroupListWarningData() {
  var o = new api.NetworkEndpointGroupListWarningData();
  buildCounterNetworkEndpointGroupListWarningData++;
  if (buildCounterNetworkEndpointGroupListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterNetworkEndpointGroupListWarningData--;
  return o;
}

checkNetworkEndpointGroupListWarningData(
    api.NetworkEndpointGroupListWarningData o) {
  buildCounterNetworkEndpointGroupListWarningData++;
  if (buildCounterNetworkEndpointGroupListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterNetworkEndpointGroupListWarningData--;
}

buildUnnamed1833() {
  var o = new core.List<api.NetworkEndpointGroupListWarningData>();
  o.add(buildNetworkEndpointGroupListWarningData());
  o.add(buildNetworkEndpointGroupListWarningData());
  return o;
}

checkUnnamed1833(core.List<api.NetworkEndpointGroupListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkEndpointGroupListWarningData(o[0]);
  checkNetworkEndpointGroupListWarningData(o[1]);
}

core.int buildCounterNetworkEndpointGroupListWarning = 0;
buildNetworkEndpointGroupListWarning() {
  var o = new api.NetworkEndpointGroupListWarning();
  buildCounterNetworkEndpointGroupListWarning++;
  if (buildCounterNetworkEndpointGroupListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1833();
    o.message = "foo";
  }
  buildCounterNetworkEndpointGroupListWarning--;
  return o;
}

checkNetworkEndpointGroupListWarning(api.NetworkEndpointGroupListWarning o) {
  buildCounterNetworkEndpointGroupListWarning++;
  if (buildCounterNetworkEndpointGroupListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1833(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterNetworkEndpointGroupListWarning--;
}

core.int buildCounterNetworkEndpointGroupList = 0;
buildNetworkEndpointGroupList() {
  var o = new api.NetworkEndpointGroupList();
  buildCounterNetworkEndpointGroupList++;
  if (buildCounterNetworkEndpointGroupList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1832();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildNetworkEndpointGroupListWarning();
  }
  buildCounterNetworkEndpointGroupList--;
  return o;
}

checkNetworkEndpointGroupList(api.NetworkEndpointGroupList o) {
  buildCounterNetworkEndpointGroupList++;
  if (buildCounterNetworkEndpointGroupList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1832(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkNetworkEndpointGroupListWarning(o.warning);
  }
  buildCounterNetworkEndpointGroupList--;
}

buildUnnamed1834() {
  var o = new core.List<api.NetworkEndpoint>();
  o.add(buildNetworkEndpoint());
  o.add(buildNetworkEndpoint());
  return o;
}

checkUnnamed1834(core.List<api.NetworkEndpoint> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkEndpoint(o[0]);
  checkNetworkEndpoint(o[1]);
}

core.int buildCounterNetworkEndpointGroupsAttachEndpointsRequest = 0;
buildNetworkEndpointGroupsAttachEndpointsRequest() {
  var o = new api.NetworkEndpointGroupsAttachEndpointsRequest();
  buildCounterNetworkEndpointGroupsAttachEndpointsRequest++;
  if (buildCounterNetworkEndpointGroupsAttachEndpointsRequest < 3) {
    o.networkEndpoints = buildUnnamed1834();
  }
  buildCounterNetworkEndpointGroupsAttachEndpointsRequest--;
  return o;
}

checkNetworkEndpointGroupsAttachEndpointsRequest(
    api.NetworkEndpointGroupsAttachEndpointsRequest o) {
  buildCounterNetworkEndpointGroupsAttachEndpointsRequest++;
  if (buildCounterNetworkEndpointGroupsAttachEndpointsRequest < 3) {
    checkUnnamed1834(o.networkEndpoints);
  }
  buildCounterNetworkEndpointGroupsAttachEndpointsRequest--;
}

buildUnnamed1835() {
  var o = new core.List<api.NetworkEndpoint>();
  o.add(buildNetworkEndpoint());
  o.add(buildNetworkEndpoint());
  return o;
}

checkUnnamed1835(core.List<api.NetworkEndpoint> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkEndpoint(o[0]);
  checkNetworkEndpoint(o[1]);
}

core.int buildCounterNetworkEndpointGroupsDetachEndpointsRequest = 0;
buildNetworkEndpointGroupsDetachEndpointsRequest() {
  var o = new api.NetworkEndpointGroupsDetachEndpointsRequest();
  buildCounterNetworkEndpointGroupsDetachEndpointsRequest++;
  if (buildCounterNetworkEndpointGroupsDetachEndpointsRequest < 3) {
    o.networkEndpoints = buildUnnamed1835();
  }
  buildCounterNetworkEndpointGroupsDetachEndpointsRequest--;
  return o;
}

checkNetworkEndpointGroupsDetachEndpointsRequest(
    api.NetworkEndpointGroupsDetachEndpointsRequest o) {
  buildCounterNetworkEndpointGroupsDetachEndpointsRequest++;
  if (buildCounterNetworkEndpointGroupsDetachEndpointsRequest < 3) {
    checkUnnamed1835(o.networkEndpoints);
  }
  buildCounterNetworkEndpointGroupsDetachEndpointsRequest--;
}

core.int buildCounterNetworkEndpointGroupsListEndpointsRequest = 0;
buildNetworkEndpointGroupsListEndpointsRequest() {
  var o = new api.NetworkEndpointGroupsListEndpointsRequest();
  buildCounterNetworkEndpointGroupsListEndpointsRequest++;
  if (buildCounterNetworkEndpointGroupsListEndpointsRequest < 3) {
    o.healthStatus = "foo";
  }
  buildCounterNetworkEndpointGroupsListEndpointsRequest--;
  return o;
}

checkNetworkEndpointGroupsListEndpointsRequest(
    api.NetworkEndpointGroupsListEndpointsRequest o) {
  buildCounterNetworkEndpointGroupsListEndpointsRequest++;
  if (buildCounterNetworkEndpointGroupsListEndpointsRequest < 3) {
    unittest.expect(o.healthStatus, unittest.equals('foo'));
  }
  buildCounterNetworkEndpointGroupsListEndpointsRequest--;
}

buildUnnamed1836() {
  var o = new core.List<api.NetworkEndpointWithHealthStatus>();
  o.add(buildNetworkEndpointWithHealthStatus());
  o.add(buildNetworkEndpointWithHealthStatus());
  return o;
}

checkUnnamed1836(core.List<api.NetworkEndpointWithHealthStatus> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkEndpointWithHealthStatus(o[0]);
  checkNetworkEndpointWithHealthStatus(o[1]);
}

core.int buildCounterNetworkEndpointGroupsListNetworkEndpointsWarningData = 0;
buildNetworkEndpointGroupsListNetworkEndpointsWarningData() {
  var o = new api.NetworkEndpointGroupsListNetworkEndpointsWarningData();
  buildCounterNetworkEndpointGroupsListNetworkEndpointsWarningData++;
  if (buildCounterNetworkEndpointGroupsListNetworkEndpointsWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterNetworkEndpointGroupsListNetworkEndpointsWarningData--;
  return o;
}

checkNetworkEndpointGroupsListNetworkEndpointsWarningData(
    api.NetworkEndpointGroupsListNetworkEndpointsWarningData o) {
  buildCounterNetworkEndpointGroupsListNetworkEndpointsWarningData++;
  if (buildCounterNetworkEndpointGroupsListNetworkEndpointsWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterNetworkEndpointGroupsListNetworkEndpointsWarningData--;
}

buildUnnamed1837() {
  var o =
      new core.List<api.NetworkEndpointGroupsListNetworkEndpointsWarningData>();
  o.add(buildNetworkEndpointGroupsListNetworkEndpointsWarningData());
  o.add(buildNetworkEndpointGroupsListNetworkEndpointsWarningData());
  return o;
}

checkUnnamed1837(
    core.List<api.NetworkEndpointGroupsListNetworkEndpointsWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkEndpointGroupsListNetworkEndpointsWarningData(o[0]);
  checkNetworkEndpointGroupsListNetworkEndpointsWarningData(o[1]);
}

core.int buildCounterNetworkEndpointGroupsListNetworkEndpointsWarning = 0;
buildNetworkEndpointGroupsListNetworkEndpointsWarning() {
  var o = new api.NetworkEndpointGroupsListNetworkEndpointsWarning();
  buildCounterNetworkEndpointGroupsListNetworkEndpointsWarning++;
  if (buildCounterNetworkEndpointGroupsListNetworkEndpointsWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1837();
    o.message = "foo";
  }
  buildCounterNetworkEndpointGroupsListNetworkEndpointsWarning--;
  return o;
}

checkNetworkEndpointGroupsListNetworkEndpointsWarning(
    api.NetworkEndpointGroupsListNetworkEndpointsWarning o) {
  buildCounterNetworkEndpointGroupsListNetworkEndpointsWarning++;
  if (buildCounterNetworkEndpointGroupsListNetworkEndpointsWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1837(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterNetworkEndpointGroupsListNetworkEndpointsWarning--;
}

core.int buildCounterNetworkEndpointGroupsListNetworkEndpoints = 0;
buildNetworkEndpointGroupsListNetworkEndpoints() {
  var o = new api.NetworkEndpointGroupsListNetworkEndpoints();
  buildCounterNetworkEndpointGroupsListNetworkEndpoints++;
  if (buildCounterNetworkEndpointGroupsListNetworkEndpoints < 3) {
    o.id = "foo";
    o.items = buildUnnamed1836();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.warning = buildNetworkEndpointGroupsListNetworkEndpointsWarning();
  }
  buildCounterNetworkEndpointGroupsListNetworkEndpoints--;
  return o;
}

checkNetworkEndpointGroupsListNetworkEndpoints(
    api.NetworkEndpointGroupsListNetworkEndpoints o) {
  buildCounterNetworkEndpointGroupsListNetworkEndpoints++;
  if (buildCounterNetworkEndpointGroupsListNetworkEndpoints < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1836(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    checkNetworkEndpointGroupsListNetworkEndpointsWarning(o.warning);
  }
  buildCounterNetworkEndpointGroupsListNetworkEndpoints--;
}

buildUnnamed1838() {
  var o = new core.List<api.NetworkEndpointGroup>();
  o.add(buildNetworkEndpointGroup());
  o.add(buildNetworkEndpointGroup());
  return o;
}

checkUnnamed1838(core.List<api.NetworkEndpointGroup> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkEndpointGroup(o[0]);
  checkNetworkEndpointGroup(o[1]);
}

core.int buildCounterNetworkEndpointGroupsScopedListWarningData = 0;
buildNetworkEndpointGroupsScopedListWarningData() {
  var o = new api.NetworkEndpointGroupsScopedListWarningData();
  buildCounterNetworkEndpointGroupsScopedListWarningData++;
  if (buildCounterNetworkEndpointGroupsScopedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterNetworkEndpointGroupsScopedListWarningData--;
  return o;
}

checkNetworkEndpointGroupsScopedListWarningData(
    api.NetworkEndpointGroupsScopedListWarningData o) {
  buildCounterNetworkEndpointGroupsScopedListWarningData++;
  if (buildCounterNetworkEndpointGroupsScopedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterNetworkEndpointGroupsScopedListWarningData--;
}

buildUnnamed1839() {
  var o = new core.List<api.NetworkEndpointGroupsScopedListWarningData>();
  o.add(buildNetworkEndpointGroupsScopedListWarningData());
  o.add(buildNetworkEndpointGroupsScopedListWarningData());
  return o;
}

checkUnnamed1839(core.List<api.NetworkEndpointGroupsScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkEndpointGroupsScopedListWarningData(o[0]);
  checkNetworkEndpointGroupsScopedListWarningData(o[1]);
}

core.int buildCounterNetworkEndpointGroupsScopedListWarning = 0;
buildNetworkEndpointGroupsScopedListWarning() {
  var o = new api.NetworkEndpointGroupsScopedListWarning();
  buildCounterNetworkEndpointGroupsScopedListWarning++;
  if (buildCounterNetworkEndpointGroupsScopedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1839();
    o.message = "foo";
  }
  buildCounterNetworkEndpointGroupsScopedListWarning--;
  return o;
}

checkNetworkEndpointGroupsScopedListWarning(
    api.NetworkEndpointGroupsScopedListWarning o) {
  buildCounterNetworkEndpointGroupsScopedListWarning++;
  if (buildCounterNetworkEndpointGroupsScopedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1839(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterNetworkEndpointGroupsScopedListWarning--;
}

core.int buildCounterNetworkEndpointGroupsScopedList = 0;
buildNetworkEndpointGroupsScopedList() {
  var o = new api.NetworkEndpointGroupsScopedList();
  buildCounterNetworkEndpointGroupsScopedList++;
  if (buildCounterNetworkEndpointGroupsScopedList < 3) {
    o.networkEndpointGroups = buildUnnamed1838();
    o.warning = buildNetworkEndpointGroupsScopedListWarning();
  }
  buildCounterNetworkEndpointGroupsScopedList--;
  return o;
}

checkNetworkEndpointGroupsScopedList(api.NetworkEndpointGroupsScopedList o) {
  buildCounterNetworkEndpointGroupsScopedList++;
  if (buildCounterNetworkEndpointGroupsScopedList < 3) {
    checkUnnamed1838(o.networkEndpointGroups);
    checkNetworkEndpointGroupsScopedListWarning(o.warning);
  }
  buildCounterNetworkEndpointGroupsScopedList--;
}

buildUnnamed1840() {
  var o = new core.List<api.HealthStatusForNetworkEndpoint>();
  o.add(buildHealthStatusForNetworkEndpoint());
  o.add(buildHealthStatusForNetworkEndpoint());
  return o;
}

checkUnnamed1840(core.List<api.HealthStatusForNetworkEndpoint> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkHealthStatusForNetworkEndpoint(o[0]);
  checkHealthStatusForNetworkEndpoint(o[1]);
}

core.int buildCounterNetworkEndpointWithHealthStatus = 0;
buildNetworkEndpointWithHealthStatus() {
  var o = new api.NetworkEndpointWithHealthStatus();
  buildCounterNetworkEndpointWithHealthStatus++;
  if (buildCounterNetworkEndpointWithHealthStatus < 3) {
    o.healths = buildUnnamed1840();
    o.networkEndpoint = buildNetworkEndpoint();
  }
  buildCounterNetworkEndpointWithHealthStatus--;
  return o;
}

checkNetworkEndpointWithHealthStatus(api.NetworkEndpointWithHealthStatus o) {
  buildCounterNetworkEndpointWithHealthStatus++;
  if (buildCounterNetworkEndpointWithHealthStatus < 3) {
    checkUnnamed1840(o.healths);
    checkNetworkEndpoint(o.networkEndpoint);
  }
  buildCounterNetworkEndpointWithHealthStatus--;
}

buildUnnamed1841() {
  var o = new core.List<api.AccessConfig>();
  o.add(buildAccessConfig());
  o.add(buildAccessConfig());
  return o;
}

checkUnnamed1841(core.List<api.AccessConfig> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAccessConfig(o[0]);
  checkAccessConfig(o[1]);
}

buildUnnamed1842() {
  var o = new core.List<api.AliasIpRange>();
  o.add(buildAliasIpRange());
  o.add(buildAliasIpRange());
  return o;
}

checkUnnamed1842(core.List<api.AliasIpRange> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAliasIpRange(o[0]);
  checkAliasIpRange(o[1]);
}

core.int buildCounterNetworkInterface = 0;
buildNetworkInterface() {
  var o = new api.NetworkInterface();
  buildCounterNetworkInterface++;
  if (buildCounterNetworkInterface < 3) {
    o.accessConfigs = buildUnnamed1841();
    o.aliasIpRanges = buildUnnamed1842();
    o.fingerprint = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.network = "foo";
    o.networkIP = "foo";
    o.subnetwork = "foo";
  }
  buildCounterNetworkInterface--;
  return o;
}

checkNetworkInterface(api.NetworkInterface o) {
  buildCounterNetworkInterface++;
  if (buildCounterNetworkInterface < 3) {
    checkUnnamed1841(o.accessConfigs);
    checkUnnamed1842(o.aliasIpRanges);
    unittest.expect(o.fingerprint, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.network, unittest.equals('foo'));
    unittest.expect(o.networkIP, unittest.equals('foo'));
    unittest.expect(o.subnetwork, unittest.equals('foo'));
  }
  buildCounterNetworkInterface--;
}

buildUnnamed1843() {
  var o = new core.List<api.Network>();
  o.add(buildNetwork());
  o.add(buildNetwork());
  return o;
}

checkUnnamed1843(core.List<api.Network> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetwork(o[0]);
  checkNetwork(o[1]);
}

core.int buildCounterNetworkListWarningData = 0;
buildNetworkListWarningData() {
  var o = new api.NetworkListWarningData();
  buildCounterNetworkListWarningData++;
  if (buildCounterNetworkListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterNetworkListWarningData--;
  return o;
}

checkNetworkListWarningData(api.NetworkListWarningData o) {
  buildCounterNetworkListWarningData++;
  if (buildCounterNetworkListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterNetworkListWarningData--;
}

buildUnnamed1844() {
  var o = new core.List<api.NetworkListWarningData>();
  o.add(buildNetworkListWarningData());
  o.add(buildNetworkListWarningData());
  return o;
}

checkUnnamed1844(core.List<api.NetworkListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkListWarningData(o[0]);
  checkNetworkListWarningData(o[1]);
}

core.int buildCounterNetworkListWarning = 0;
buildNetworkListWarning() {
  var o = new api.NetworkListWarning();
  buildCounterNetworkListWarning++;
  if (buildCounterNetworkListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1844();
    o.message = "foo";
  }
  buildCounterNetworkListWarning--;
  return o;
}

checkNetworkListWarning(api.NetworkListWarning o) {
  buildCounterNetworkListWarning++;
  if (buildCounterNetworkListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1844(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterNetworkListWarning--;
}

core.int buildCounterNetworkList = 0;
buildNetworkList() {
  var o = new api.NetworkList();
  buildCounterNetworkList++;
  if (buildCounterNetworkList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1843();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildNetworkListWarning();
  }
  buildCounterNetworkList--;
  return o;
}

checkNetworkList(api.NetworkList o) {
  buildCounterNetworkList++;
  if (buildCounterNetworkList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1843(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkNetworkListWarning(o.warning);
  }
  buildCounterNetworkList--;
}

core.int buildCounterNetworkPeering = 0;
buildNetworkPeering() {
  var o = new api.NetworkPeering();
  buildCounterNetworkPeering++;
  if (buildCounterNetworkPeering < 3) {
    o.autoCreateRoutes = true;
    o.exchangeSubnetRoutes = true;
    o.name = "foo";
    o.network = "foo";
    o.state = "foo";
    o.stateDetails = "foo";
  }
  buildCounterNetworkPeering--;
  return o;
}

checkNetworkPeering(api.NetworkPeering o) {
  buildCounterNetworkPeering++;
  if (buildCounterNetworkPeering < 3) {
    unittest.expect(o.autoCreateRoutes, unittest.isTrue);
    unittest.expect(o.exchangeSubnetRoutes, unittest.isTrue);
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.network, unittest.equals('foo'));
    unittest.expect(o.state, unittest.equals('foo'));
    unittest.expect(o.stateDetails, unittest.equals('foo'));
  }
  buildCounterNetworkPeering--;
}

core.int buildCounterNetworkRoutingConfig = 0;
buildNetworkRoutingConfig() {
  var o = new api.NetworkRoutingConfig();
  buildCounterNetworkRoutingConfig++;
  if (buildCounterNetworkRoutingConfig < 3) {
    o.routingMode = "foo";
  }
  buildCounterNetworkRoutingConfig--;
  return o;
}

checkNetworkRoutingConfig(api.NetworkRoutingConfig o) {
  buildCounterNetworkRoutingConfig++;
  if (buildCounterNetworkRoutingConfig < 3) {
    unittest.expect(o.routingMode, unittest.equals('foo'));
  }
  buildCounterNetworkRoutingConfig--;
}

core.int buildCounterNetworksAddPeeringRequest = 0;
buildNetworksAddPeeringRequest() {
  var o = new api.NetworksAddPeeringRequest();
  buildCounterNetworksAddPeeringRequest++;
  if (buildCounterNetworksAddPeeringRequest < 3) {
    o.autoCreateRoutes = true;
    o.name = "foo";
    o.networkPeering = buildNetworkPeering();
    o.peerNetwork = "foo";
  }
  buildCounterNetworksAddPeeringRequest--;
  return o;
}

checkNetworksAddPeeringRequest(api.NetworksAddPeeringRequest o) {
  buildCounterNetworksAddPeeringRequest++;
  if (buildCounterNetworksAddPeeringRequest < 3) {
    unittest.expect(o.autoCreateRoutes, unittest.isTrue);
    unittest.expect(o.name, unittest.equals('foo'));
    checkNetworkPeering(o.networkPeering);
    unittest.expect(o.peerNetwork, unittest.equals('foo'));
  }
  buildCounterNetworksAddPeeringRequest--;
}

core.int buildCounterNetworksRemovePeeringRequest = 0;
buildNetworksRemovePeeringRequest() {
  var o = new api.NetworksRemovePeeringRequest();
  buildCounterNetworksRemovePeeringRequest++;
  if (buildCounterNetworksRemovePeeringRequest < 3) {
    o.name = "foo";
  }
  buildCounterNetworksRemovePeeringRequest--;
  return o;
}

checkNetworksRemovePeeringRequest(api.NetworksRemovePeeringRequest o) {
  buildCounterNetworksRemovePeeringRequest++;
  if (buildCounterNetworksRemovePeeringRequest < 3) {
    unittest.expect(o.name, unittest.equals('foo'));
  }
  buildCounterNetworksRemovePeeringRequest--;
}

core.int buildCounterNodeGroup = 0;
buildNodeGroup() {
  var o = new api.NodeGroup();
  buildCounterNodeGroup++;
  if (buildCounterNodeGroup < 3) {
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.id = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.nodeTemplate = "foo";
    o.selfLink = "foo";
    o.size = 42;
    o.status = "foo";
    o.zone = "foo";
  }
  buildCounterNodeGroup--;
  return o;
}

checkNodeGroup(api.NodeGroup o) {
  buildCounterNodeGroup++;
  if (buildCounterNodeGroup < 3) {
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.nodeTemplate, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.size, unittest.equals(42));
    unittest.expect(o.status, unittest.equals('foo'));
    unittest.expect(o.zone, unittest.equals('foo'));
  }
  buildCounterNodeGroup--;
}

buildUnnamed1845() {
  var o = new core.Map<core.String, api.NodeGroupsScopedList>();
  o["x"] = buildNodeGroupsScopedList();
  o["y"] = buildNodeGroupsScopedList();
  return o;
}

checkUnnamed1845(core.Map<core.String, api.NodeGroupsScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeGroupsScopedList(o["x"]);
  checkNodeGroupsScopedList(o["y"]);
}

core.int buildCounterNodeGroupAggregatedListWarningData = 0;
buildNodeGroupAggregatedListWarningData() {
  var o = new api.NodeGroupAggregatedListWarningData();
  buildCounterNodeGroupAggregatedListWarningData++;
  if (buildCounterNodeGroupAggregatedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterNodeGroupAggregatedListWarningData--;
  return o;
}

checkNodeGroupAggregatedListWarningData(
    api.NodeGroupAggregatedListWarningData o) {
  buildCounterNodeGroupAggregatedListWarningData++;
  if (buildCounterNodeGroupAggregatedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterNodeGroupAggregatedListWarningData--;
}

buildUnnamed1846() {
  var o = new core.List<api.NodeGroupAggregatedListWarningData>();
  o.add(buildNodeGroupAggregatedListWarningData());
  o.add(buildNodeGroupAggregatedListWarningData());
  return o;
}

checkUnnamed1846(core.List<api.NodeGroupAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeGroupAggregatedListWarningData(o[0]);
  checkNodeGroupAggregatedListWarningData(o[1]);
}

core.int buildCounterNodeGroupAggregatedListWarning = 0;
buildNodeGroupAggregatedListWarning() {
  var o = new api.NodeGroupAggregatedListWarning();
  buildCounterNodeGroupAggregatedListWarning++;
  if (buildCounterNodeGroupAggregatedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1846();
    o.message = "foo";
  }
  buildCounterNodeGroupAggregatedListWarning--;
  return o;
}

checkNodeGroupAggregatedListWarning(api.NodeGroupAggregatedListWarning o) {
  buildCounterNodeGroupAggregatedListWarning++;
  if (buildCounterNodeGroupAggregatedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1846(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterNodeGroupAggregatedListWarning--;
}

core.int buildCounterNodeGroupAggregatedList = 0;
buildNodeGroupAggregatedList() {
  var o = new api.NodeGroupAggregatedList();
  buildCounterNodeGroupAggregatedList++;
  if (buildCounterNodeGroupAggregatedList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1845();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildNodeGroupAggregatedListWarning();
  }
  buildCounterNodeGroupAggregatedList--;
  return o;
}

checkNodeGroupAggregatedList(api.NodeGroupAggregatedList o) {
  buildCounterNodeGroupAggregatedList++;
  if (buildCounterNodeGroupAggregatedList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1845(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkNodeGroupAggregatedListWarning(o.warning);
  }
  buildCounterNodeGroupAggregatedList--;
}

buildUnnamed1847() {
  var o = new core.List<api.NodeGroup>();
  o.add(buildNodeGroup());
  o.add(buildNodeGroup());
  return o;
}

checkUnnamed1847(core.List<api.NodeGroup> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeGroup(o[0]);
  checkNodeGroup(o[1]);
}

core.int buildCounterNodeGroupListWarningData = 0;
buildNodeGroupListWarningData() {
  var o = new api.NodeGroupListWarningData();
  buildCounterNodeGroupListWarningData++;
  if (buildCounterNodeGroupListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterNodeGroupListWarningData--;
  return o;
}

checkNodeGroupListWarningData(api.NodeGroupListWarningData o) {
  buildCounterNodeGroupListWarningData++;
  if (buildCounterNodeGroupListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterNodeGroupListWarningData--;
}

buildUnnamed1848() {
  var o = new core.List<api.NodeGroupListWarningData>();
  o.add(buildNodeGroupListWarningData());
  o.add(buildNodeGroupListWarningData());
  return o;
}

checkUnnamed1848(core.List<api.NodeGroupListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeGroupListWarningData(o[0]);
  checkNodeGroupListWarningData(o[1]);
}

core.int buildCounterNodeGroupListWarning = 0;
buildNodeGroupListWarning() {
  var o = new api.NodeGroupListWarning();
  buildCounterNodeGroupListWarning++;
  if (buildCounterNodeGroupListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1848();
    o.message = "foo";
  }
  buildCounterNodeGroupListWarning--;
  return o;
}

checkNodeGroupListWarning(api.NodeGroupListWarning o) {
  buildCounterNodeGroupListWarning++;
  if (buildCounterNodeGroupListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1848(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterNodeGroupListWarning--;
}

core.int buildCounterNodeGroupList = 0;
buildNodeGroupList() {
  var o = new api.NodeGroupList();
  buildCounterNodeGroupList++;
  if (buildCounterNodeGroupList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1847();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildNodeGroupListWarning();
  }
  buildCounterNodeGroupList--;
  return o;
}

checkNodeGroupList(api.NodeGroupList o) {
  buildCounterNodeGroupList++;
  if (buildCounterNodeGroupList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1847(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkNodeGroupListWarning(o.warning);
  }
  buildCounterNodeGroupList--;
}

buildUnnamed1849() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1849(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterNodeGroupNode = 0;
buildNodeGroupNode() {
  var o = new api.NodeGroupNode();
  buildCounterNodeGroupNode++;
  if (buildCounterNodeGroupNode < 3) {
    o.instances = buildUnnamed1849();
    o.name = "foo";
    o.nodeType = "foo";
    o.serverBinding = buildServerBinding();
    o.status = "foo";
  }
  buildCounterNodeGroupNode--;
  return o;
}

checkNodeGroupNode(api.NodeGroupNode o) {
  buildCounterNodeGroupNode++;
  if (buildCounterNodeGroupNode < 3) {
    checkUnnamed1849(o.instances);
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.nodeType, unittest.equals('foo'));
    checkServerBinding(o.serverBinding);
    unittest.expect(o.status, unittest.equals('foo'));
  }
  buildCounterNodeGroupNode--;
}

core.int buildCounterNodeGroupsAddNodesRequest = 0;
buildNodeGroupsAddNodesRequest() {
  var o = new api.NodeGroupsAddNodesRequest();
  buildCounterNodeGroupsAddNodesRequest++;
  if (buildCounterNodeGroupsAddNodesRequest < 3) {
    o.additionalNodeCount = 42;
  }
  buildCounterNodeGroupsAddNodesRequest--;
  return o;
}

checkNodeGroupsAddNodesRequest(api.NodeGroupsAddNodesRequest o) {
  buildCounterNodeGroupsAddNodesRequest++;
  if (buildCounterNodeGroupsAddNodesRequest < 3) {
    unittest.expect(o.additionalNodeCount, unittest.equals(42));
  }
  buildCounterNodeGroupsAddNodesRequest--;
}

buildUnnamed1850() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1850(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterNodeGroupsDeleteNodesRequest = 0;
buildNodeGroupsDeleteNodesRequest() {
  var o = new api.NodeGroupsDeleteNodesRequest();
  buildCounterNodeGroupsDeleteNodesRequest++;
  if (buildCounterNodeGroupsDeleteNodesRequest < 3) {
    o.nodes = buildUnnamed1850();
  }
  buildCounterNodeGroupsDeleteNodesRequest--;
  return o;
}

checkNodeGroupsDeleteNodesRequest(api.NodeGroupsDeleteNodesRequest o) {
  buildCounterNodeGroupsDeleteNodesRequest++;
  if (buildCounterNodeGroupsDeleteNodesRequest < 3) {
    checkUnnamed1850(o.nodes);
  }
  buildCounterNodeGroupsDeleteNodesRequest--;
}

buildUnnamed1851() {
  var o = new core.List<api.NodeGroupNode>();
  o.add(buildNodeGroupNode());
  o.add(buildNodeGroupNode());
  return o;
}

checkUnnamed1851(core.List<api.NodeGroupNode> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeGroupNode(o[0]);
  checkNodeGroupNode(o[1]);
}

core.int buildCounterNodeGroupsListNodesWarningData = 0;
buildNodeGroupsListNodesWarningData() {
  var o = new api.NodeGroupsListNodesWarningData();
  buildCounterNodeGroupsListNodesWarningData++;
  if (buildCounterNodeGroupsListNodesWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterNodeGroupsListNodesWarningData--;
  return o;
}

checkNodeGroupsListNodesWarningData(api.NodeGroupsListNodesWarningData o) {
  buildCounterNodeGroupsListNodesWarningData++;
  if (buildCounterNodeGroupsListNodesWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterNodeGroupsListNodesWarningData--;
}

buildUnnamed1852() {
  var o = new core.List<api.NodeGroupsListNodesWarningData>();
  o.add(buildNodeGroupsListNodesWarningData());
  o.add(buildNodeGroupsListNodesWarningData());
  return o;
}

checkUnnamed1852(core.List<api.NodeGroupsListNodesWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeGroupsListNodesWarningData(o[0]);
  checkNodeGroupsListNodesWarningData(o[1]);
}

core.int buildCounterNodeGroupsListNodesWarning = 0;
buildNodeGroupsListNodesWarning() {
  var o = new api.NodeGroupsListNodesWarning();
  buildCounterNodeGroupsListNodesWarning++;
  if (buildCounterNodeGroupsListNodesWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1852();
    o.message = "foo";
  }
  buildCounterNodeGroupsListNodesWarning--;
  return o;
}

checkNodeGroupsListNodesWarning(api.NodeGroupsListNodesWarning o) {
  buildCounterNodeGroupsListNodesWarning++;
  if (buildCounterNodeGroupsListNodesWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1852(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterNodeGroupsListNodesWarning--;
}

core.int buildCounterNodeGroupsListNodes = 0;
buildNodeGroupsListNodes() {
  var o = new api.NodeGroupsListNodes();
  buildCounterNodeGroupsListNodes++;
  if (buildCounterNodeGroupsListNodes < 3) {
    o.id = "foo";
    o.items = buildUnnamed1851();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildNodeGroupsListNodesWarning();
  }
  buildCounterNodeGroupsListNodes--;
  return o;
}

checkNodeGroupsListNodes(api.NodeGroupsListNodes o) {
  buildCounterNodeGroupsListNodes++;
  if (buildCounterNodeGroupsListNodes < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1851(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkNodeGroupsListNodesWarning(o.warning);
  }
  buildCounterNodeGroupsListNodes--;
}

buildUnnamed1853() {
  var o = new core.List<api.NodeGroup>();
  o.add(buildNodeGroup());
  o.add(buildNodeGroup());
  return o;
}

checkUnnamed1853(core.List<api.NodeGroup> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeGroup(o[0]);
  checkNodeGroup(o[1]);
}

core.int buildCounterNodeGroupsScopedListWarningData = 0;
buildNodeGroupsScopedListWarningData() {
  var o = new api.NodeGroupsScopedListWarningData();
  buildCounterNodeGroupsScopedListWarningData++;
  if (buildCounterNodeGroupsScopedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterNodeGroupsScopedListWarningData--;
  return o;
}

checkNodeGroupsScopedListWarningData(api.NodeGroupsScopedListWarningData o) {
  buildCounterNodeGroupsScopedListWarningData++;
  if (buildCounterNodeGroupsScopedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterNodeGroupsScopedListWarningData--;
}

buildUnnamed1854() {
  var o = new core.List<api.NodeGroupsScopedListWarningData>();
  o.add(buildNodeGroupsScopedListWarningData());
  o.add(buildNodeGroupsScopedListWarningData());
  return o;
}

checkUnnamed1854(core.List<api.NodeGroupsScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeGroupsScopedListWarningData(o[0]);
  checkNodeGroupsScopedListWarningData(o[1]);
}

core.int buildCounterNodeGroupsScopedListWarning = 0;
buildNodeGroupsScopedListWarning() {
  var o = new api.NodeGroupsScopedListWarning();
  buildCounterNodeGroupsScopedListWarning++;
  if (buildCounterNodeGroupsScopedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1854();
    o.message = "foo";
  }
  buildCounterNodeGroupsScopedListWarning--;
  return o;
}

checkNodeGroupsScopedListWarning(api.NodeGroupsScopedListWarning o) {
  buildCounterNodeGroupsScopedListWarning++;
  if (buildCounterNodeGroupsScopedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1854(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterNodeGroupsScopedListWarning--;
}

core.int buildCounterNodeGroupsScopedList = 0;
buildNodeGroupsScopedList() {
  var o = new api.NodeGroupsScopedList();
  buildCounterNodeGroupsScopedList++;
  if (buildCounterNodeGroupsScopedList < 3) {
    o.nodeGroups = buildUnnamed1853();
    o.warning = buildNodeGroupsScopedListWarning();
  }
  buildCounterNodeGroupsScopedList--;
  return o;
}

checkNodeGroupsScopedList(api.NodeGroupsScopedList o) {
  buildCounterNodeGroupsScopedList++;
  if (buildCounterNodeGroupsScopedList < 3) {
    checkUnnamed1853(o.nodeGroups);
    checkNodeGroupsScopedListWarning(o.warning);
  }
  buildCounterNodeGroupsScopedList--;
}

core.int buildCounterNodeGroupsSetNodeTemplateRequest = 0;
buildNodeGroupsSetNodeTemplateRequest() {
  var o = new api.NodeGroupsSetNodeTemplateRequest();
  buildCounterNodeGroupsSetNodeTemplateRequest++;
  if (buildCounterNodeGroupsSetNodeTemplateRequest < 3) {
    o.nodeTemplate = "foo";
  }
  buildCounterNodeGroupsSetNodeTemplateRequest--;
  return o;
}

checkNodeGroupsSetNodeTemplateRequest(api.NodeGroupsSetNodeTemplateRequest o) {
  buildCounterNodeGroupsSetNodeTemplateRequest++;
  if (buildCounterNodeGroupsSetNodeTemplateRequest < 3) {
    unittest.expect(o.nodeTemplate, unittest.equals('foo'));
  }
  buildCounterNodeGroupsSetNodeTemplateRequest--;
}

buildUnnamed1855() {
  var o = new core.Map<core.String, core.String>();
  o["x"] = "foo";
  o["y"] = "foo";
  return o;
}

checkUnnamed1855(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o["x"], unittest.equals('foo'));
  unittest.expect(o["y"], unittest.equals('foo'));
}

core.int buildCounterNodeTemplate = 0;
buildNodeTemplate() {
  var o = new api.NodeTemplate();
  buildCounterNodeTemplate++;
  if (buildCounterNodeTemplate < 3) {
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.id = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.nodeAffinityLabels = buildUnnamed1855();
    o.nodeType = "foo";
    o.nodeTypeFlexibility = buildNodeTemplateNodeTypeFlexibility();
    o.region = "foo";
    o.selfLink = "foo";
    o.serverBinding = buildServerBinding();
    o.status = "foo";
    o.statusMessage = "foo";
  }
  buildCounterNodeTemplate--;
  return o;
}

checkNodeTemplate(api.NodeTemplate o) {
  buildCounterNodeTemplate++;
  if (buildCounterNodeTemplate < 3) {
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    checkUnnamed1855(o.nodeAffinityLabels);
    unittest.expect(o.nodeType, unittest.equals('foo'));
    checkNodeTemplateNodeTypeFlexibility(o.nodeTypeFlexibility);
    unittest.expect(o.region, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkServerBinding(o.serverBinding);
    unittest.expect(o.status, unittest.equals('foo'));
    unittest.expect(o.statusMessage, unittest.equals('foo'));
  }
  buildCounterNodeTemplate--;
}

buildUnnamed1856() {
  var o = new core.Map<core.String, api.NodeTemplatesScopedList>();
  o["x"] = buildNodeTemplatesScopedList();
  o["y"] = buildNodeTemplatesScopedList();
  return o;
}

checkUnnamed1856(core.Map<core.String, api.NodeTemplatesScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeTemplatesScopedList(o["x"]);
  checkNodeTemplatesScopedList(o["y"]);
}

core.int buildCounterNodeTemplateAggregatedListWarningData = 0;
buildNodeTemplateAggregatedListWarningData() {
  var o = new api.NodeTemplateAggregatedListWarningData();
  buildCounterNodeTemplateAggregatedListWarningData++;
  if (buildCounterNodeTemplateAggregatedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterNodeTemplateAggregatedListWarningData--;
  return o;
}

checkNodeTemplateAggregatedListWarningData(
    api.NodeTemplateAggregatedListWarningData o) {
  buildCounterNodeTemplateAggregatedListWarningData++;
  if (buildCounterNodeTemplateAggregatedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterNodeTemplateAggregatedListWarningData--;
}

buildUnnamed1857() {
  var o = new core.List<api.NodeTemplateAggregatedListWarningData>();
  o.add(buildNodeTemplateAggregatedListWarningData());
  o.add(buildNodeTemplateAggregatedListWarningData());
  return o;
}

checkUnnamed1857(core.List<api.NodeTemplateAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeTemplateAggregatedListWarningData(o[0]);
  checkNodeTemplateAggregatedListWarningData(o[1]);
}

core.int buildCounterNodeTemplateAggregatedListWarning = 0;
buildNodeTemplateAggregatedListWarning() {
  var o = new api.NodeTemplateAggregatedListWarning();
  buildCounterNodeTemplateAggregatedListWarning++;
  if (buildCounterNodeTemplateAggregatedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1857();
    o.message = "foo";
  }
  buildCounterNodeTemplateAggregatedListWarning--;
  return o;
}

checkNodeTemplateAggregatedListWarning(
    api.NodeTemplateAggregatedListWarning o) {
  buildCounterNodeTemplateAggregatedListWarning++;
  if (buildCounterNodeTemplateAggregatedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1857(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterNodeTemplateAggregatedListWarning--;
}

core.int buildCounterNodeTemplateAggregatedList = 0;
buildNodeTemplateAggregatedList() {
  var o = new api.NodeTemplateAggregatedList();
  buildCounterNodeTemplateAggregatedList++;
  if (buildCounterNodeTemplateAggregatedList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1856();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildNodeTemplateAggregatedListWarning();
  }
  buildCounterNodeTemplateAggregatedList--;
  return o;
}

checkNodeTemplateAggregatedList(api.NodeTemplateAggregatedList o) {
  buildCounterNodeTemplateAggregatedList++;
  if (buildCounterNodeTemplateAggregatedList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1856(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkNodeTemplateAggregatedListWarning(o.warning);
  }
  buildCounterNodeTemplateAggregatedList--;
}

buildUnnamed1858() {
  var o = new core.List<api.NodeTemplate>();
  o.add(buildNodeTemplate());
  o.add(buildNodeTemplate());
  return o;
}

checkUnnamed1858(core.List<api.NodeTemplate> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeTemplate(o[0]);
  checkNodeTemplate(o[1]);
}

core.int buildCounterNodeTemplateListWarningData = 0;
buildNodeTemplateListWarningData() {
  var o = new api.NodeTemplateListWarningData();
  buildCounterNodeTemplateListWarningData++;
  if (buildCounterNodeTemplateListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterNodeTemplateListWarningData--;
  return o;
}

checkNodeTemplateListWarningData(api.NodeTemplateListWarningData o) {
  buildCounterNodeTemplateListWarningData++;
  if (buildCounterNodeTemplateListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterNodeTemplateListWarningData--;
}

buildUnnamed1859() {
  var o = new core.List<api.NodeTemplateListWarningData>();
  o.add(buildNodeTemplateListWarningData());
  o.add(buildNodeTemplateListWarningData());
  return o;
}

checkUnnamed1859(core.List<api.NodeTemplateListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeTemplateListWarningData(o[0]);
  checkNodeTemplateListWarningData(o[1]);
}

core.int buildCounterNodeTemplateListWarning = 0;
buildNodeTemplateListWarning() {
  var o = new api.NodeTemplateListWarning();
  buildCounterNodeTemplateListWarning++;
  if (buildCounterNodeTemplateListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1859();
    o.message = "foo";
  }
  buildCounterNodeTemplateListWarning--;
  return o;
}

checkNodeTemplateListWarning(api.NodeTemplateListWarning o) {
  buildCounterNodeTemplateListWarning++;
  if (buildCounterNodeTemplateListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1859(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterNodeTemplateListWarning--;
}

core.int buildCounterNodeTemplateList = 0;
buildNodeTemplateList() {
  var o = new api.NodeTemplateList();
  buildCounterNodeTemplateList++;
  if (buildCounterNodeTemplateList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1858();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildNodeTemplateListWarning();
  }
  buildCounterNodeTemplateList--;
  return o;
}

checkNodeTemplateList(api.NodeTemplateList o) {
  buildCounterNodeTemplateList++;
  if (buildCounterNodeTemplateList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1858(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkNodeTemplateListWarning(o.warning);
  }
  buildCounterNodeTemplateList--;
}

core.int buildCounterNodeTemplateNodeTypeFlexibility = 0;
buildNodeTemplateNodeTypeFlexibility() {
  var o = new api.NodeTemplateNodeTypeFlexibility();
  buildCounterNodeTemplateNodeTypeFlexibility++;
  if (buildCounterNodeTemplateNodeTypeFlexibility < 3) {
    o.cpus = "foo";
    o.localSsd = "foo";
    o.memory = "foo";
  }
  buildCounterNodeTemplateNodeTypeFlexibility--;
  return o;
}

checkNodeTemplateNodeTypeFlexibility(api.NodeTemplateNodeTypeFlexibility o) {
  buildCounterNodeTemplateNodeTypeFlexibility++;
  if (buildCounterNodeTemplateNodeTypeFlexibility < 3) {
    unittest.expect(o.cpus, unittest.equals('foo'));
    unittest.expect(o.localSsd, unittest.equals('foo'));
    unittest.expect(o.memory, unittest.equals('foo'));
  }
  buildCounterNodeTemplateNodeTypeFlexibility--;
}

buildUnnamed1860() {
  var o = new core.List<api.NodeTemplate>();
  o.add(buildNodeTemplate());
  o.add(buildNodeTemplate());
  return o;
}

checkUnnamed1860(core.List<api.NodeTemplate> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeTemplate(o[0]);
  checkNodeTemplate(o[1]);
}

core.int buildCounterNodeTemplatesScopedListWarningData = 0;
buildNodeTemplatesScopedListWarningData() {
  var o = new api.NodeTemplatesScopedListWarningData();
  buildCounterNodeTemplatesScopedListWarningData++;
  if (buildCounterNodeTemplatesScopedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterNodeTemplatesScopedListWarningData--;
  return o;
}

checkNodeTemplatesScopedListWarningData(
    api.NodeTemplatesScopedListWarningData o) {
  buildCounterNodeTemplatesScopedListWarningData++;
  if (buildCounterNodeTemplatesScopedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterNodeTemplatesScopedListWarningData--;
}

buildUnnamed1861() {
  var o = new core.List<api.NodeTemplatesScopedListWarningData>();
  o.add(buildNodeTemplatesScopedListWarningData());
  o.add(buildNodeTemplatesScopedListWarningData());
  return o;
}

checkUnnamed1861(core.List<api.NodeTemplatesScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeTemplatesScopedListWarningData(o[0]);
  checkNodeTemplatesScopedListWarningData(o[1]);
}

core.int buildCounterNodeTemplatesScopedListWarning = 0;
buildNodeTemplatesScopedListWarning() {
  var o = new api.NodeTemplatesScopedListWarning();
  buildCounterNodeTemplatesScopedListWarning++;
  if (buildCounterNodeTemplatesScopedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1861();
    o.message = "foo";
  }
  buildCounterNodeTemplatesScopedListWarning--;
  return o;
}

checkNodeTemplatesScopedListWarning(api.NodeTemplatesScopedListWarning o) {
  buildCounterNodeTemplatesScopedListWarning++;
  if (buildCounterNodeTemplatesScopedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1861(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterNodeTemplatesScopedListWarning--;
}

core.int buildCounterNodeTemplatesScopedList = 0;
buildNodeTemplatesScopedList() {
  var o = new api.NodeTemplatesScopedList();
  buildCounterNodeTemplatesScopedList++;
  if (buildCounterNodeTemplatesScopedList < 3) {
    o.nodeTemplates = buildUnnamed1860();
    o.warning = buildNodeTemplatesScopedListWarning();
  }
  buildCounterNodeTemplatesScopedList--;
  return o;
}

checkNodeTemplatesScopedList(api.NodeTemplatesScopedList o) {
  buildCounterNodeTemplatesScopedList++;
  if (buildCounterNodeTemplatesScopedList < 3) {
    checkUnnamed1860(o.nodeTemplates);
    checkNodeTemplatesScopedListWarning(o.warning);
  }
  buildCounterNodeTemplatesScopedList--;
}

core.int buildCounterNodeType = 0;
buildNodeType() {
  var o = new api.NodeType();
  buildCounterNodeType++;
  if (buildCounterNodeType < 3) {
    o.cpuPlatform = "foo";
    o.creationTimestamp = "foo";
    o.deprecated = buildDeprecationStatus();
    o.description = "foo";
    o.guestCpus = 42;
    o.id = "foo";
    o.kind = "foo";
    o.localSsdGb = 42;
    o.memoryMb = 42;
    o.name = "foo";
    o.selfLink = "foo";
    o.zone = "foo";
  }
  buildCounterNodeType--;
  return o;
}

checkNodeType(api.NodeType o) {
  buildCounterNodeType++;
  if (buildCounterNodeType < 3) {
    unittest.expect(o.cpuPlatform, unittest.equals('foo'));
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    checkDeprecationStatus(o.deprecated);
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.guestCpus, unittest.equals(42));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.localSsdGb, unittest.equals(42));
    unittest.expect(o.memoryMb, unittest.equals(42));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.zone, unittest.equals('foo'));
  }
  buildCounterNodeType--;
}

buildUnnamed1862() {
  var o = new core.Map<core.String, api.NodeTypesScopedList>();
  o["x"] = buildNodeTypesScopedList();
  o["y"] = buildNodeTypesScopedList();
  return o;
}

checkUnnamed1862(core.Map<core.String, api.NodeTypesScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeTypesScopedList(o["x"]);
  checkNodeTypesScopedList(o["y"]);
}

core.int buildCounterNodeTypeAggregatedListWarningData = 0;
buildNodeTypeAggregatedListWarningData() {
  var o = new api.NodeTypeAggregatedListWarningData();
  buildCounterNodeTypeAggregatedListWarningData++;
  if (buildCounterNodeTypeAggregatedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterNodeTypeAggregatedListWarningData--;
  return o;
}

checkNodeTypeAggregatedListWarningData(
    api.NodeTypeAggregatedListWarningData o) {
  buildCounterNodeTypeAggregatedListWarningData++;
  if (buildCounterNodeTypeAggregatedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterNodeTypeAggregatedListWarningData--;
}

buildUnnamed1863() {
  var o = new core.List<api.NodeTypeAggregatedListWarningData>();
  o.add(buildNodeTypeAggregatedListWarningData());
  o.add(buildNodeTypeAggregatedListWarningData());
  return o;
}

checkUnnamed1863(core.List<api.NodeTypeAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeTypeAggregatedListWarningData(o[0]);
  checkNodeTypeAggregatedListWarningData(o[1]);
}

core.int buildCounterNodeTypeAggregatedListWarning = 0;
buildNodeTypeAggregatedListWarning() {
  var o = new api.NodeTypeAggregatedListWarning();
  buildCounterNodeTypeAggregatedListWarning++;
  if (buildCounterNodeTypeAggregatedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1863();
    o.message = "foo";
  }
  buildCounterNodeTypeAggregatedListWarning--;
  return o;
}

checkNodeTypeAggregatedListWarning(api.NodeTypeAggregatedListWarning o) {
  buildCounterNodeTypeAggregatedListWarning++;
  if (buildCounterNodeTypeAggregatedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1863(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterNodeTypeAggregatedListWarning--;
}

core.int buildCounterNodeTypeAggregatedList = 0;
buildNodeTypeAggregatedList() {
  var o = new api.NodeTypeAggregatedList();
  buildCounterNodeTypeAggregatedList++;
  if (buildCounterNodeTypeAggregatedList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1862();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildNodeTypeAggregatedListWarning();
  }
  buildCounterNodeTypeAggregatedList--;
  return o;
}

checkNodeTypeAggregatedList(api.NodeTypeAggregatedList o) {
  buildCounterNodeTypeAggregatedList++;
  if (buildCounterNodeTypeAggregatedList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1862(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkNodeTypeAggregatedListWarning(o.warning);
  }
  buildCounterNodeTypeAggregatedList--;
}

buildUnnamed1864() {
  var o = new core.List<api.NodeType>();
  o.add(buildNodeType());
  o.add(buildNodeType());
  return o;
}

checkUnnamed1864(core.List<api.NodeType> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeType(o[0]);
  checkNodeType(o[1]);
}

core.int buildCounterNodeTypeListWarningData = 0;
buildNodeTypeListWarningData() {
  var o = new api.NodeTypeListWarningData();
  buildCounterNodeTypeListWarningData++;
  if (buildCounterNodeTypeListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterNodeTypeListWarningData--;
  return o;
}

checkNodeTypeListWarningData(api.NodeTypeListWarningData o) {
  buildCounterNodeTypeListWarningData++;
  if (buildCounterNodeTypeListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterNodeTypeListWarningData--;
}

buildUnnamed1865() {
  var o = new core.List<api.NodeTypeListWarningData>();
  o.add(buildNodeTypeListWarningData());
  o.add(buildNodeTypeListWarningData());
  return o;
}

checkUnnamed1865(core.List<api.NodeTypeListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeTypeListWarningData(o[0]);
  checkNodeTypeListWarningData(o[1]);
}

core.int buildCounterNodeTypeListWarning = 0;
buildNodeTypeListWarning() {
  var o = new api.NodeTypeListWarning();
  buildCounterNodeTypeListWarning++;
  if (buildCounterNodeTypeListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1865();
    o.message = "foo";
  }
  buildCounterNodeTypeListWarning--;
  return o;
}

checkNodeTypeListWarning(api.NodeTypeListWarning o) {
  buildCounterNodeTypeListWarning++;
  if (buildCounterNodeTypeListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1865(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterNodeTypeListWarning--;
}

core.int buildCounterNodeTypeList = 0;
buildNodeTypeList() {
  var o = new api.NodeTypeList();
  buildCounterNodeTypeList++;
  if (buildCounterNodeTypeList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1864();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildNodeTypeListWarning();
  }
  buildCounterNodeTypeList--;
  return o;
}

checkNodeTypeList(api.NodeTypeList o) {
  buildCounterNodeTypeList++;
  if (buildCounterNodeTypeList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1864(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkNodeTypeListWarning(o.warning);
  }
  buildCounterNodeTypeList--;
}

buildUnnamed1866() {
  var o = new core.List<api.NodeType>();
  o.add(buildNodeType());
  o.add(buildNodeType());
  return o;
}

checkUnnamed1866(core.List<api.NodeType> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeType(o[0]);
  checkNodeType(o[1]);
}

core.int buildCounterNodeTypesScopedListWarningData = 0;
buildNodeTypesScopedListWarningData() {
  var o = new api.NodeTypesScopedListWarningData();
  buildCounterNodeTypesScopedListWarningData++;
  if (buildCounterNodeTypesScopedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterNodeTypesScopedListWarningData--;
  return o;
}

checkNodeTypesScopedListWarningData(api.NodeTypesScopedListWarningData o) {
  buildCounterNodeTypesScopedListWarningData++;
  if (buildCounterNodeTypesScopedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterNodeTypesScopedListWarningData--;
}

buildUnnamed1867() {
  var o = new core.List<api.NodeTypesScopedListWarningData>();
  o.add(buildNodeTypesScopedListWarningData());
  o.add(buildNodeTypesScopedListWarningData());
  return o;
}

checkUnnamed1867(core.List<api.NodeTypesScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeTypesScopedListWarningData(o[0]);
  checkNodeTypesScopedListWarningData(o[1]);
}

core.int buildCounterNodeTypesScopedListWarning = 0;
buildNodeTypesScopedListWarning() {
  var o = new api.NodeTypesScopedListWarning();
  buildCounterNodeTypesScopedListWarning++;
  if (buildCounterNodeTypesScopedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1867();
    o.message = "foo";
  }
  buildCounterNodeTypesScopedListWarning--;
  return o;
}

checkNodeTypesScopedListWarning(api.NodeTypesScopedListWarning o) {
  buildCounterNodeTypesScopedListWarning++;
  if (buildCounterNodeTypesScopedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1867(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterNodeTypesScopedListWarning--;
}

core.int buildCounterNodeTypesScopedList = 0;
buildNodeTypesScopedList() {
  var o = new api.NodeTypesScopedList();
  buildCounterNodeTypesScopedList++;
  if (buildCounterNodeTypesScopedList < 3) {
    o.nodeTypes = buildUnnamed1866();
    o.warning = buildNodeTypesScopedListWarning();
  }
  buildCounterNodeTypesScopedList--;
  return o;
}

checkNodeTypesScopedList(api.NodeTypesScopedList o) {
  buildCounterNodeTypesScopedList++;
  if (buildCounterNodeTypesScopedList < 3) {
    checkUnnamed1866(o.nodeTypes);
    checkNodeTypesScopedListWarning(o.warning);
  }
  buildCounterNodeTypesScopedList--;
}

core.int buildCounterOperationErrorErrors = 0;
buildOperationErrorErrors() {
  var o = new api.OperationErrorErrors();
  buildCounterOperationErrorErrors++;
  if (buildCounterOperationErrorErrors < 3) {
    o.code = "foo";
    o.location = "foo";
    o.message = "foo";
  }
  buildCounterOperationErrorErrors--;
  return o;
}

checkOperationErrorErrors(api.OperationErrorErrors o) {
  buildCounterOperationErrorErrors++;
  if (buildCounterOperationErrorErrors < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    unittest.expect(o.location, unittest.equals('foo'));
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterOperationErrorErrors--;
}

buildUnnamed1868() {
  var o = new core.List<api.OperationErrorErrors>();
  o.add(buildOperationErrorErrors());
  o.add(buildOperationErrorErrors());
  return o;
}

checkUnnamed1868(core.List<api.OperationErrorErrors> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkOperationErrorErrors(o[0]);
  checkOperationErrorErrors(o[1]);
}

core.int buildCounterOperationError = 0;
buildOperationError() {
  var o = new api.OperationError();
  buildCounterOperationError++;
  if (buildCounterOperationError < 3) {
    o.errors = buildUnnamed1868();
  }
  buildCounterOperationError--;
  return o;
}

checkOperationError(api.OperationError o) {
  buildCounterOperationError++;
  if (buildCounterOperationError < 3) {
    checkUnnamed1868(o.errors);
  }
  buildCounterOperationError--;
}

core.int buildCounterOperationWarningsData = 0;
buildOperationWarningsData() {
  var o = new api.OperationWarningsData();
  buildCounterOperationWarningsData++;
  if (buildCounterOperationWarningsData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterOperationWarningsData--;
  return o;
}

checkOperationWarningsData(api.OperationWarningsData o) {
  buildCounterOperationWarningsData++;
  if (buildCounterOperationWarningsData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterOperationWarningsData--;
}

buildUnnamed1869() {
  var o = new core.List<api.OperationWarningsData>();
  o.add(buildOperationWarningsData());
  o.add(buildOperationWarningsData());
  return o;
}

checkUnnamed1869(core.List<api.OperationWarningsData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkOperationWarningsData(o[0]);
  checkOperationWarningsData(o[1]);
}

core.int buildCounterOperationWarnings = 0;
buildOperationWarnings() {
  var o = new api.OperationWarnings();
  buildCounterOperationWarnings++;
  if (buildCounterOperationWarnings < 3) {
    o.code = "foo";
    o.data = buildUnnamed1869();
    o.message = "foo";
  }
  buildCounterOperationWarnings--;
  return o;
}

checkOperationWarnings(api.OperationWarnings o) {
  buildCounterOperationWarnings++;
  if (buildCounterOperationWarnings < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1869(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterOperationWarnings--;
}

buildUnnamed1870() {
  var o = new core.List<api.OperationWarnings>();
  o.add(buildOperationWarnings());
  o.add(buildOperationWarnings());
  return o;
}

checkUnnamed1870(core.List<api.OperationWarnings> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkOperationWarnings(o[0]);
  checkOperationWarnings(o[1]);
}

core.int buildCounterOperation = 0;
buildOperation() {
  var o = new api.Operation();
  buildCounterOperation++;
  if (buildCounterOperation < 3) {
    o.clientOperationId = "foo";
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.endTime = "foo";
    o.error = buildOperationError();
    o.httpErrorMessage = "foo";
    o.httpErrorStatusCode = 42;
    o.id = "foo";
    o.insertTime = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.operationType = "foo";
    o.progress = 42;
    o.region = "foo";
    o.selfLink = "foo";
    o.startTime = "foo";
    o.status = "foo";
    o.statusMessage = "foo";
    o.targetId = "foo";
    o.targetLink = "foo";
    o.user = "foo";
    o.warnings = buildUnnamed1870();
    o.zone = "foo";
  }
  buildCounterOperation--;
  return o;
}

checkOperation(api.Operation o) {
  buildCounterOperation++;
  if (buildCounterOperation < 3) {
    unittest.expect(o.clientOperationId, unittest.equals('foo'));
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.endTime, unittest.equals('foo'));
    checkOperationError(o.error);
    unittest.expect(o.httpErrorMessage, unittest.equals('foo'));
    unittest.expect(o.httpErrorStatusCode, unittest.equals(42));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.insertTime, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.operationType, unittest.equals('foo'));
    unittest.expect(o.progress, unittest.equals(42));
    unittest.expect(o.region, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.startTime, unittest.equals('foo'));
    unittest.expect(o.status, unittest.equals('foo'));
    unittest.expect(o.statusMessage, unittest.equals('foo'));
    unittest.expect(o.targetId, unittest.equals('foo'));
    unittest.expect(o.targetLink, unittest.equals('foo'));
    unittest.expect(o.user, unittest.equals('foo'));
    checkUnnamed1870(o.warnings);
    unittest.expect(o.zone, unittest.equals('foo'));
  }
  buildCounterOperation--;
}

buildUnnamed1871() {
  var o = new core.Map<core.String, api.OperationsScopedList>();
  o["x"] = buildOperationsScopedList();
  o["y"] = buildOperationsScopedList();
  return o;
}

checkUnnamed1871(core.Map<core.String, api.OperationsScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkOperationsScopedList(o["x"]);
  checkOperationsScopedList(o["y"]);
}

core.int buildCounterOperationAggregatedListWarningData = 0;
buildOperationAggregatedListWarningData() {
  var o = new api.OperationAggregatedListWarningData();
  buildCounterOperationAggregatedListWarningData++;
  if (buildCounterOperationAggregatedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterOperationAggregatedListWarningData--;
  return o;
}

checkOperationAggregatedListWarningData(
    api.OperationAggregatedListWarningData o) {
  buildCounterOperationAggregatedListWarningData++;
  if (buildCounterOperationAggregatedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterOperationAggregatedListWarningData--;
}

buildUnnamed1872() {
  var o = new core.List<api.OperationAggregatedListWarningData>();
  o.add(buildOperationAggregatedListWarningData());
  o.add(buildOperationAggregatedListWarningData());
  return o;
}

checkUnnamed1872(core.List<api.OperationAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkOperationAggregatedListWarningData(o[0]);
  checkOperationAggregatedListWarningData(o[1]);
}

core.int buildCounterOperationAggregatedListWarning = 0;
buildOperationAggregatedListWarning() {
  var o = new api.OperationAggregatedListWarning();
  buildCounterOperationAggregatedListWarning++;
  if (buildCounterOperationAggregatedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1872();
    o.message = "foo";
  }
  buildCounterOperationAggregatedListWarning--;
  return o;
}

checkOperationAggregatedListWarning(api.OperationAggregatedListWarning o) {
  buildCounterOperationAggregatedListWarning++;
  if (buildCounterOperationAggregatedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1872(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterOperationAggregatedListWarning--;
}

core.int buildCounterOperationAggregatedList = 0;
buildOperationAggregatedList() {
  var o = new api.OperationAggregatedList();
  buildCounterOperationAggregatedList++;
  if (buildCounterOperationAggregatedList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1871();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildOperationAggregatedListWarning();
  }
  buildCounterOperationAggregatedList--;
  return o;
}

checkOperationAggregatedList(api.OperationAggregatedList o) {
  buildCounterOperationAggregatedList++;
  if (buildCounterOperationAggregatedList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1871(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkOperationAggregatedListWarning(o.warning);
  }
  buildCounterOperationAggregatedList--;
}

buildUnnamed1873() {
  var o = new core.List<api.Operation>();
  o.add(buildOperation());
  o.add(buildOperation());
  return o;
}

checkUnnamed1873(core.List<api.Operation> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkOperation(o[0]);
  checkOperation(o[1]);
}

core.int buildCounterOperationListWarningData = 0;
buildOperationListWarningData() {
  var o = new api.OperationListWarningData();
  buildCounterOperationListWarningData++;
  if (buildCounterOperationListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterOperationListWarningData--;
  return o;
}

checkOperationListWarningData(api.OperationListWarningData o) {
  buildCounterOperationListWarningData++;
  if (buildCounterOperationListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterOperationListWarningData--;
}

buildUnnamed1874() {
  var o = new core.List<api.OperationListWarningData>();
  o.add(buildOperationListWarningData());
  o.add(buildOperationListWarningData());
  return o;
}

checkUnnamed1874(core.List<api.OperationListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkOperationListWarningData(o[0]);
  checkOperationListWarningData(o[1]);
}

core.int buildCounterOperationListWarning = 0;
buildOperationListWarning() {
  var o = new api.OperationListWarning();
  buildCounterOperationListWarning++;
  if (buildCounterOperationListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1874();
    o.message = "foo";
  }
  buildCounterOperationListWarning--;
  return o;
}

checkOperationListWarning(api.OperationListWarning o) {
  buildCounterOperationListWarning++;
  if (buildCounterOperationListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1874(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterOperationListWarning--;
}

core.int buildCounterOperationList = 0;
buildOperationList() {
  var o = new api.OperationList();
  buildCounterOperationList++;
  if (buildCounterOperationList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1873();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildOperationListWarning();
  }
  buildCounterOperationList--;
  return o;
}

checkOperationList(api.OperationList o) {
  buildCounterOperationList++;
  if (buildCounterOperationList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1873(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkOperationListWarning(o.warning);
  }
  buildCounterOperationList--;
}

buildUnnamed1875() {
  var o = new core.List<api.Operation>();
  o.add(buildOperation());
  o.add(buildOperation());
  return o;
}

checkUnnamed1875(core.List<api.Operation> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkOperation(o[0]);
  checkOperation(o[1]);
}

core.int buildCounterOperationsScopedListWarningData = 0;
buildOperationsScopedListWarningData() {
  var o = new api.OperationsScopedListWarningData();
  buildCounterOperationsScopedListWarningData++;
  if (buildCounterOperationsScopedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterOperationsScopedListWarningData--;
  return o;
}

checkOperationsScopedListWarningData(api.OperationsScopedListWarningData o) {
  buildCounterOperationsScopedListWarningData++;
  if (buildCounterOperationsScopedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterOperationsScopedListWarningData--;
}

buildUnnamed1876() {
  var o = new core.List<api.OperationsScopedListWarningData>();
  o.add(buildOperationsScopedListWarningData());
  o.add(buildOperationsScopedListWarningData());
  return o;
}

checkUnnamed1876(core.List<api.OperationsScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkOperationsScopedListWarningData(o[0]);
  checkOperationsScopedListWarningData(o[1]);
}

core.int buildCounterOperationsScopedListWarning = 0;
buildOperationsScopedListWarning() {
  var o = new api.OperationsScopedListWarning();
  buildCounterOperationsScopedListWarning++;
  if (buildCounterOperationsScopedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1876();
    o.message = "foo";
  }
  buildCounterOperationsScopedListWarning--;
  return o;
}

checkOperationsScopedListWarning(api.OperationsScopedListWarning o) {
  buildCounterOperationsScopedListWarning++;
  if (buildCounterOperationsScopedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1876(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterOperationsScopedListWarning--;
}

core.int buildCounterOperationsScopedList = 0;
buildOperationsScopedList() {
  var o = new api.OperationsScopedList();
  buildCounterOperationsScopedList++;
  if (buildCounterOperationsScopedList < 3) {
    o.operations = buildUnnamed1875();
    o.warning = buildOperationsScopedListWarning();
  }
  buildCounterOperationsScopedList--;
  return o;
}

checkOperationsScopedList(api.OperationsScopedList o) {
  buildCounterOperationsScopedList++;
  if (buildCounterOperationsScopedList < 3) {
    checkUnnamed1875(o.operations);
    checkOperationsScopedListWarning(o.warning);
  }
  buildCounterOperationsScopedList--;
}

buildUnnamed1877() {
  var o = new core.List<api.PathRule>();
  o.add(buildPathRule());
  o.add(buildPathRule());
  return o;
}

checkUnnamed1877(core.List<api.PathRule> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkPathRule(o[0]);
  checkPathRule(o[1]);
}

core.int buildCounterPathMatcher = 0;
buildPathMatcher() {
  var o = new api.PathMatcher();
  buildCounterPathMatcher++;
  if (buildCounterPathMatcher < 3) {
    o.defaultService = "foo";
    o.description = "foo";
    o.name = "foo";
    o.pathRules = buildUnnamed1877();
  }
  buildCounterPathMatcher--;
  return o;
}

checkPathMatcher(api.PathMatcher o) {
  buildCounterPathMatcher++;
  if (buildCounterPathMatcher < 3) {
    unittest.expect(o.defaultService, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    checkUnnamed1877(o.pathRules);
  }
  buildCounterPathMatcher--;
}

buildUnnamed1878() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1878(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterPathRule = 0;
buildPathRule() {
  var o = new api.PathRule();
  buildCounterPathRule++;
  if (buildCounterPathRule < 3) {
    o.paths = buildUnnamed1878();
    o.service = "foo";
  }
  buildCounterPathRule--;
  return o;
}

checkPathRule(api.PathRule o) {
  buildCounterPathRule++;
  if (buildCounterPathRule < 3) {
    checkUnnamed1878(o.paths);
    unittest.expect(o.service, unittest.equals('foo'));
  }
  buildCounterPathRule--;
}

buildUnnamed1879() {
  var o = new core.List<api.AuditConfig>();
  o.add(buildAuditConfig());
  o.add(buildAuditConfig());
  return o;
}

checkUnnamed1879(core.List<api.AuditConfig> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAuditConfig(o[0]);
  checkAuditConfig(o[1]);
}

buildUnnamed1880() {
  var o = new core.List<api.Binding>();
  o.add(buildBinding());
  o.add(buildBinding());
  return o;
}

checkUnnamed1880(core.List<api.Binding> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBinding(o[0]);
  checkBinding(o[1]);
}

buildUnnamed1881() {
  var o = new core.List<api.Rule>();
  o.add(buildRule());
  o.add(buildRule());
  return o;
}

checkUnnamed1881(core.List<api.Rule> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRule(o[0]);
  checkRule(o[1]);
}

core.int buildCounterPolicy = 0;
buildPolicy() {
  var o = new api.Policy();
  buildCounterPolicy++;
  if (buildCounterPolicy < 3) {
    o.auditConfigs = buildUnnamed1879();
    o.bindings = buildUnnamed1880();
    o.etag = "foo";
    o.iamOwned = true;
    o.rules = buildUnnamed1881();
    o.version = 42;
  }
  buildCounterPolicy--;
  return o;
}

checkPolicy(api.Policy o) {
  buildCounterPolicy++;
  if (buildCounterPolicy < 3) {
    checkUnnamed1879(o.auditConfigs);
    checkUnnamed1880(o.bindings);
    unittest.expect(o.etag, unittest.equals('foo'));
    unittest.expect(o.iamOwned, unittest.isTrue);
    checkUnnamed1881(o.rules);
    unittest.expect(o.version, unittest.equals(42));
  }
  buildCounterPolicy--;
}

buildUnnamed1882() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1882(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

buildUnnamed1883() {
  var o = new core.List<api.Quota>();
  o.add(buildQuota());
  o.add(buildQuota());
  return o;
}

checkUnnamed1883(core.List<api.Quota> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkQuota(o[0]);
  checkQuota(o[1]);
}

core.int buildCounterProject = 0;
buildProject() {
  var o = new api.Project();
  buildCounterProject++;
  if (buildCounterProject < 3) {
    o.commonInstanceMetadata = buildMetadata();
    o.creationTimestamp = "foo";
    o.defaultNetworkTier = "foo";
    o.defaultServiceAccount = "foo";
    o.description = "foo";
    o.enabledFeatures = buildUnnamed1882();
    o.id = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.quotas = buildUnnamed1883();
    o.selfLink = "foo";
    o.usageExportLocation = buildUsageExportLocation();
    o.xpnProjectStatus = "foo";
  }
  buildCounterProject--;
  return o;
}

checkProject(api.Project o) {
  buildCounterProject++;
  if (buildCounterProject < 3) {
    checkMetadata(o.commonInstanceMetadata);
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.defaultNetworkTier, unittest.equals('foo'));
    unittest.expect(o.defaultServiceAccount, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    checkUnnamed1882(o.enabledFeatures);
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    checkUnnamed1883(o.quotas);
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkUsageExportLocation(o.usageExportLocation);
    unittest.expect(o.xpnProjectStatus, unittest.equals('foo'));
  }
  buildCounterProject--;
}

core.int buildCounterProjectsDisableXpnResourceRequest = 0;
buildProjectsDisableXpnResourceRequest() {
  var o = new api.ProjectsDisableXpnResourceRequest();
  buildCounterProjectsDisableXpnResourceRequest++;
  if (buildCounterProjectsDisableXpnResourceRequest < 3) {
    o.xpnResource = buildXpnResourceId();
  }
  buildCounterProjectsDisableXpnResourceRequest--;
  return o;
}

checkProjectsDisableXpnResourceRequest(
    api.ProjectsDisableXpnResourceRequest o) {
  buildCounterProjectsDisableXpnResourceRequest++;
  if (buildCounterProjectsDisableXpnResourceRequest < 3) {
    checkXpnResourceId(o.xpnResource);
  }
  buildCounterProjectsDisableXpnResourceRequest--;
}

core.int buildCounterProjectsEnableXpnResourceRequest = 0;
buildProjectsEnableXpnResourceRequest() {
  var o = new api.ProjectsEnableXpnResourceRequest();
  buildCounterProjectsEnableXpnResourceRequest++;
  if (buildCounterProjectsEnableXpnResourceRequest < 3) {
    o.xpnResource = buildXpnResourceId();
  }
  buildCounterProjectsEnableXpnResourceRequest--;
  return o;
}

checkProjectsEnableXpnResourceRequest(api.ProjectsEnableXpnResourceRequest o) {
  buildCounterProjectsEnableXpnResourceRequest++;
  if (buildCounterProjectsEnableXpnResourceRequest < 3) {
    checkXpnResourceId(o.xpnResource);
  }
  buildCounterProjectsEnableXpnResourceRequest--;
}

buildUnnamed1884() {
  var o = new core.List<api.XpnResourceId>();
  o.add(buildXpnResourceId());
  o.add(buildXpnResourceId());
  return o;
}

checkUnnamed1884(core.List<api.XpnResourceId> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkXpnResourceId(o[0]);
  checkXpnResourceId(o[1]);
}

core.int buildCounterProjectsGetXpnResources = 0;
buildProjectsGetXpnResources() {
  var o = new api.ProjectsGetXpnResources();
  buildCounterProjectsGetXpnResources++;
  if (buildCounterProjectsGetXpnResources < 3) {
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.resources = buildUnnamed1884();
  }
  buildCounterProjectsGetXpnResources--;
  return o;
}

checkProjectsGetXpnResources(api.ProjectsGetXpnResources o) {
  buildCounterProjectsGetXpnResources++;
  if (buildCounterProjectsGetXpnResources < 3) {
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    checkUnnamed1884(o.resources);
  }
  buildCounterProjectsGetXpnResources--;
}

core.int buildCounterProjectsListXpnHostsRequest = 0;
buildProjectsListXpnHostsRequest() {
  var o = new api.ProjectsListXpnHostsRequest();
  buildCounterProjectsListXpnHostsRequest++;
  if (buildCounterProjectsListXpnHostsRequest < 3) {
    o.organization = "foo";
  }
  buildCounterProjectsListXpnHostsRequest--;
  return o;
}

checkProjectsListXpnHostsRequest(api.ProjectsListXpnHostsRequest o) {
  buildCounterProjectsListXpnHostsRequest++;
  if (buildCounterProjectsListXpnHostsRequest < 3) {
    unittest.expect(o.organization, unittest.equals('foo'));
  }
  buildCounterProjectsListXpnHostsRequest--;
}

core.int buildCounterProjectsSetDefaultNetworkTierRequest = 0;
buildProjectsSetDefaultNetworkTierRequest() {
  var o = new api.ProjectsSetDefaultNetworkTierRequest();
  buildCounterProjectsSetDefaultNetworkTierRequest++;
  if (buildCounterProjectsSetDefaultNetworkTierRequest < 3) {
    o.networkTier = "foo";
  }
  buildCounterProjectsSetDefaultNetworkTierRequest--;
  return o;
}

checkProjectsSetDefaultNetworkTierRequest(
    api.ProjectsSetDefaultNetworkTierRequest o) {
  buildCounterProjectsSetDefaultNetworkTierRequest++;
  if (buildCounterProjectsSetDefaultNetworkTierRequest < 3) {
    unittest.expect(o.networkTier, unittest.equals('foo'));
  }
  buildCounterProjectsSetDefaultNetworkTierRequest--;
}

core.int buildCounterQuota = 0;
buildQuota() {
  var o = new api.Quota();
  buildCounterQuota++;
  if (buildCounterQuota < 3) {
    o.limit = 42.0;
    o.metric = "foo";
    o.owner = "foo";
    o.usage = 42.0;
  }
  buildCounterQuota--;
  return o;
}

checkQuota(api.Quota o) {
  buildCounterQuota++;
  if (buildCounterQuota < 3) {
    unittest.expect(o.limit, unittest.equals(42.0));
    unittest.expect(o.metric, unittest.equals('foo'));
    unittest.expect(o.owner, unittest.equals('foo'));
    unittest.expect(o.usage, unittest.equals(42.0));
  }
  buildCounterQuota--;
}

core.int buildCounterReference = 0;
buildReference() {
  var o = new api.Reference();
  buildCounterReference++;
  if (buildCounterReference < 3) {
    o.kind = "foo";
    o.referenceType = "foo";
    o.referrer = "foo";
    o.target = "foo";
  }
  buildCounterReference--;
  return o;
}

checkReference(api.Reference o) {
  buildCounterReference++;
  if (buildCounterReference < 3) {
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.referenceType, unittest.equals('foo'));
    unittest.expect(o.referrer, unittest.equals('foo'));
    unittest.expect(o.target, unittest.equals('foo'));
  }
  buildCounterReference--;
}

buildUnnamed1885() {
  var o = new core.List<api.Quota>();
  o.add(buildQuota());
  o.add(buildQuota());
  return o;
}

checkUnnamed1885(core.List<api.Quota> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkQuota(o[0]);
  checkQuota(o[1]);
}

buildUnnamed1886() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1886(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterRegion = 0;
buildRegion() {
  var o = new api.Region();
  buildCounterRegion++;
  if (buildCounterRegion < 3) {
    o.creationTimestamp = "foo";
    o.deprecated = buildDeprecationStatus();
    o.description = "foo";
    o.id = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.quotas = buildUnnamed1885();
    o.selfLink = "foo";
    o.status = "foo";
    o.zones = buildUnnamed1886();
  }
  buildCounterRegion--;
  return o;
}

checkRegion(api.Region o) {
  buildCounterRegion++;
  if (buildCounterRegion < 3) {
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    checkDeprecationStatus(o.deprecated);
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    checkUnnamed1885(o.quotas);
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.status, unittest.equals('foo'));
    checkUnnamed1886(o.zones);
  }
  buildCounterRegion--;
}

buildUnnamed1887() {
  var o = new core.List<api.Autoscaler>();
  o.add(buildAutoscaler());
  o.add(buildAutoscaler());
  return o;
}

checkUnnamed1887(core.List<api.Autoscaler> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAutoscaler(o[0]);
  checkAutoscaler(o[1]);
}

core.int buildCounterRegionAutoscalerListWarningData = 0;
buildRegionAutoscalerListWarningData() {
  var o = new api.RegionAutoscalerListWarningData();
  buildCounterRegionAutoscalerListWarningData++;
  if (buildCounterRegionAutoscalerListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterRegionAutoscalerListWarningData--;
  return o;
}

checkRegionAutoscalerListWarningData(api.RegionAutoscalerListWarningData o) {
  buildCounterRegionAutoscalerListWarningData++;
  if (buildCounterRegionAutoscalerListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterRegionAutoscalerListWarningData--;
}

buildUnnamed1888() {
  var o = new core.List<api.RegionAutoscalerListWarningData>();
  o.add(buildRegionAutoscalerListWarningData());
  o.add(buildRegionAutoscalerListWarningData());
  return o;
}

checkUnnamed1888(core.List<api.RegionAutoscalerListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRegionAutoscalerListWarningData(o[0]);
  checkRegionAutoscalerListWarningData(o[1]);
}

core.int buildCounterRegionAutoscalerListWarning = 0;
buildRegionAutoscalerListWarning() {
  var o = new api.RegionAutoscalerListWarning();
  buildCounterRegionAutoscalerListWarning++;
  if (buildCounterRegionAutoscalerListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1888();
    o.message = "foo";
  }
  buildCounterRegionAutoscalerListWarning--;
  return o;
}

checkRegionAutoscalerListWarning(api.RegionAutoscalerListWarning o) {
  buildCounterRegionAutoscalerListWarning++;
  if (buildCounterRegionAutoscalerListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1888(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterRegionAutoscalerListWarning--;
}

core.int buildCounterRegionAutoscalerList = 0;
buildRegionAutoscalerList() {
  var o = new api.RegionAutoscalerList();
  buildCounterRegionAutoscalerList++;
  if (buildCounterRegionAutoscalerList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1887();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildRegionAutoscalerListWarning();
  }
  buildCounterRegionAutoscalerList--;
  return o;
}

checkRegionAutoscalerList(api.RegionAutoscalerList o) {
  buildCounterRegionAutoscalerList++;
  if (buildCounterRegionAutoscalerList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1887(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkRegionAutoscalerListWarning(o.warning);
  }
  buildCounterRegionAutoscalerList--;
}

buildUnnamed1889() {
  var o = new core.List<api.DiskType>();
  o.add(buildDiskType());
  o.add(buildDiskType());
  return o;
}

checkUnnamed1889(core.List<api.DiskType> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkDiskType(o[0]);
  checkDiskType(o[1]);
}

core.int buildCounterRegionDiskTypeListWarningData = 0;
buildRegionDiskTypeListWarningData() {
  var o = new api.RegionDiskTypeListWarningData();
  buildCounterRegionDiskTypeListWarningData++;
  if (buildCounterRegionDiskTypeListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterRegionDiskTypeListWarningData--;
  return o;
}

checkRegionDiskTypeListWarningData(api.RegionDiskTypeListWarningData o) {
  buildCounterRegionDiskTypeListWarningData++;
  if (buildCounterRegionDiskTypeListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterRegionDiskTypeListWarningData--;
}

buildUnnamed1890() {
  var o = new core.List<api.RegionDiskTypeListWarningData>();
  o.add(buildRegionDiskTypeListWarningData());
  o.add(buildRegionDiskTypeListWarningData());
  return o;
}

checkUnnamed1890(core.List<api.RegionDiskTypeListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRegionDiskTypeListWarningData(o[0]);
  checkRegionDiskTypeListWarningData(o[1]);
}

core.int buildCounterRegionDiskTypeListWarning = 0;
buildRegionDiskTypeListWarning() {
  var o = new api.RegionDiskTypeListWarning();
  buildCounterRegionDiskTypeListWarning++;
  if (buildCounterRegionDiskTypeListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1890();
    o.message = "foo";
  }
  buildCounterRegionDiskTypeListWarning--;
  return o;
}

checkRegionDiskTypeListWarning(api.RegionDiskTypeListWarning o) {
  buildCounterRegionDiskTypeListWarning++;
  if (buildCounterRegionDiskTypeListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1890(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterRegionDiskTypeListWarning--;
}

core.int buildCounterRegionDiskTypeList = 0;
buildRegionDiskTypeList() {
  var o = new api.RegionDiskTypeList();
  buildCounterRegionDiskTypeList++;
  if (buildCounterRegionDiskTypeList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1889();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildRegionDiskTypeListWarning();
  }
  buildCounterRegionDiskTypeList--;
  return o;
}

checkRegionDiskTypeList(api.RegionDiskTypeList o) {
  buildCounterRegionDiskTypeList++;
  if (buildCounterRegionDiskTypeList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1889(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkRegionDiskTypeListWarning(o.warning);
  }
  buildCounterRegionDiskTypeList--;
}

buildUnnamed1891() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1891(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterRegionDisksAddResourcePoliciesRequest = 0;
buildRegionDisksAddResourcePoliciesRequest() {
  var o = new api.RegionDisksAddResourcePoliciesRequest();
  buildCounterRegionDisksAddResourcePoliciesRequest++;
  if (buildCounterRegionDisksAddResourcePoliciesRequest < 3) {
    o.resourcePolicies = buildUnnamed1891();
  }
  buildCounterRegionDisksAddResourcePoliciesRequest--;
  return o;
}

checkRegionDisksAddResourcePoliciesRequest(
    api.RegionDisksAddResourcePoliciesRequest o) {
  buildCounterRegionDisksAddResourcePoliciesRequest++;
  if (buildCounterRegionDisksAddResourcePoliciesRequest < 3) {
    checkUnnamed1891(o.resourcePolicies);
  }
  buildCounterRegionDisksAddResourcePoliciesRequest--;
}

buildUnnamed1892() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1892(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterRegionDisksRemoveResourcePoliciesRequest = 0;
buildRegionDisksRemoveResourcePoliciesRequest() {
  var o = new api.RegionDisksRemoveResourcePoliciesRequest();
  buildCounterRegionDisksRemoveResourcePoliciesRequest++;
  if (buildCounterRegionDisksRemoveResourcePoliciesRequest < 3) {
    o.resourcePolicies = buildUnnamed1892();
  }
  buildCounterRegionDisksRemoveResourcePoliciesRequest--;
  return o;
}

checkRegionDisksRemoveResourcePoliciesRequest(
    api.RegionDisksRemoveResourcePoliciesRequest o) {
  buildCounterRegionDisksRemoveResourcePoliciesRequest++;
  if (buildCounterRegionDisksRemoveResourcePoliciesRequest < 3) {
    checkUnnamed1892(o.resourcePolicies);
  }
  buildCounterRegionDisksRemoveResourcePoliciesRequest--;
}

core.int buildCounterRegionDisksResizeRequest = 0;
buildRegionDisksResizeRequest() {
  var o = new api.RegionDisksResizeRequest();
  buildCounterRegionDisksResizeRequest++;
  if (buildCounterRegionDisksResizeRequest < 3) {
    o.sizeGb = "foo";
  }
  buildCounterRegionDisksResizeRequest--;
  return o;
}

checkRegionDisksResizeRequest(api.RegionDisksResizeRequest o) {
  buildCounterRegionDisksResizeRequest++;
  if (buildCounterRegionDisksResizeRequest < 3) {
    unittest.expect(o.sizeGb, unittest.equals('foo'));
  }
  buildCounterRegionDisksResizeRequest--;
}

buildUnnamed1893() {
  var o = new core.List<api.InstanceGroup>();
  o.add(buildInstanceGroup());
  o.add(buildInstanceGroup());
  return o;
}

checkUnnamed1893(core.List<api.InstanceGroup> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroup(o[0]);
  checkInstanceGroup(o[1]);
}

core.int buildCounterRegionInstanceGroupListWarningData = 0;
buildRegionInstanceGroupListWarningData() {
  var o = new api.RegionInstanceGroupListWarningData();
  buildCounterRegionInstanceGroupListWarningData++;
  if (buildCounterRegionInstanceGroupListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterRegionInstanceGroupListWarningData--;
  return o;
}

checkRegionInstanceGroupListWarningData(
    api.RegionInstanceGroupListWarningData o) {
  buildCounterRegionInstanceGroupListWarningData++;
  if (buildCounterRegionInstanceGroupListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterRegionInstanceGroupListWarningData--;
}

buildUnnamed1894() {
  var o = new core.List<api.RegionInstanceGroupListWarningData>();
  o.add(buildRegionInstanceGroupListWarningData());
  o.add(buildRegionInstanceGroupListWarningData());
  return o;
}

checkUnnamed1894(core.List<api.RegionInstanceGroupListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRegionInstanceGroupListWarningData(o[0]);
  checkRegionInstanceGroupListWarningData(o[1]);
}

core.int buildCounterRegionInstanceGroupListWarning = 0;
buildRegionInstanceGroupListWarning() {
  var o = new api.RegionInstanceGroupListWarning();
  buildCounterRegionInstanceGroupListWarning++;
  if (buildCounterRegionInstanceGroupListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1894();
    o.message = "foo";
  }
  buildCounterRegionInstanceGroupListWarning--;
  return o;
}

checkRegionInstanceGroupListWarning(api.RegionInstanceGroupListWarning o) {
  buildCounterRegionInstanceGroupListWarning++;
  if (buildCounterRegionInstanceGroupListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1894(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterRegionInstanceGroupListWarning--;
}

core.int buildCounterRegionInstanceGroupList = 0;
buildRegionInstanceGroupList() {
  var o = new api.RegionInstanceGroupList();
  buildCounterRegionInstanceGroupList++;
  if (buildCounterRegionInstanceGroupList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1893();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildRegionInstanceGroupListWarning();
  }
  buildCounterRegionInstanceGroupList--;
  return o;
}

checkRegionInstanceGroupList(api.RegionInstanceGroupList o) {
  buildCounterRegionInstanceGroupList++;
  if (buildCounterRegionInstanceGroupList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1893(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkRegionInstanceGroupListWarning(o.warning);
  }
  buildCounterRegionInstanceGroupList--;
}

buildUnnamed1895() {
  var o = new core.List<api.InstanceGroupManager>();
  o.add(buildInstanceGroupManager());
  o.add(buildInstanceGroupManager());
  return o;
}

checkUnnamed1895(core.List<api.InstanceGroupManager> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroupManager(o[0]);
  checkInstanceGroupManager(o[1]);
}

core.int buildCounterRegionInstanceGroupManagerListWarningData = 0;
buildRegionInstanceGroupManagerListWarningData() {
  var o = new api.RegionInstanceGroupManagerListWarningData();
  buildCounterRegionInstanceGroupManagerListWarningData++;
  if (buildCounterRegionInstanceGroupManagerListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterRegionInstanceGroupManagerListWarningData--;
  return o;
}

checkRegionInstanceGroupManagerListWarningData(
    api.RegionInstanceGroupManagerListWarningData o) {
  buildCounterRegionInstanceGroupManagerListWarningData++;
  if (buildCounterRegionInstanceGroupManagerListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterRegionInstanceGroupManagerListWarningData--;
}

buildUnnamed1896() {
  var o = new core.List<api.RegionInstanceGroupManagerListWarningData>();
  o.add(buildRegionInstanceGroupManagerListWarningData());
  o.add(buildRegionInstanceGroupManagerListWarningData());
  return o;
}

checkUnnamed1896(core.List<api.RegionInstanceGroupManagerListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRegionInstanceGroupManagerListWarningData(o[0]);
  checkRegionInstanceGroupManagerListWarningData(o[1]);
}

core.int buildCounterRegionInstanceGroupManagerListWarning = 0;
buildRegionInstanceGroupManagerListWarning() {
  var o = new api.RegionInstanceGroupManagerListWarning();
  buildCounterRegionInstanceGroupManagerListWarning++;
  if (buildCounterRegionInstanceGroupManagerListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1896();
    o.message = "foo";
  }
  buildCounterRegionInstanceGroupManagerListWarning--;
  return o;
}

checkRegionInstanceGroupManagerListWarning(
    api.RegionInstanceGroupManagerListWarning o) {
  buildCounterRegionInstanceGroupManagerListWarning++;
  if (buildCounterRegionInstanceGroupManagerListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1896(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterRegionInstanceGroupManagerListWarning--;
}

core.int buildCounterRegionInstanceGroupManagerList = 0;
buildRegionInstanceGroupManagerList() {
  var o = new api.RegionInstanceGroupManagerList();
  buildCounterRegionInstanceGroupManagerList++;
  if (buildCounterRegionInstanceGroupManagerList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1895();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildRegionInstanceGroupManagerListWarning();
  }
  buildCounterRegionInstanceGroupManagerList--;
  return o;
}

checkRegionInstanceGroupManagerList(api.RegionInstanceGroupManagerList o) {
  buildCounterRegionInstanceGroupManagerList++;
  if (buildCounterRegionInstanceGroupManagerList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1895(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkRegionInstanceGroupManagerListWarning(o.warning);
  }
  buildCounterRegionInstanceGroupManagerList--;
}

buildUnnamed1897() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1897(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterRegionInstanceGroupManagersAbandonInstancesRequest = 0;
buildRegionInstanceGroupManagersAbandonInstancesRequest() {
  var o = new api.RegionInstanceGroupManagersAbandonInstancesRequest();
  buildCounterRegionInstanceGroupManagersAbandonInstancesRequest++;
  if (buildCounterRegionInstanceGroupManagersAbandonInstancesRequest < 3) {
    o.instances = buildUnnamed1897();
  }
  buildCounterRegionInstanceGroupManagersAbandonInstancesRequest--;
  return o;
}

checkRegionInstanceGroupManagersAbandonInstancesRequest(
    api.RegionInstanceGroupManagersAbandonInstancesRequest o) {
  buildCounterRegionInstanceGroupManagersAbandonInstancesRequest++;
  if (buildCounterRegionInstanceGroupManagersAbandonInstancesRequest < 3) {
    checkUnnamed1897(o.instances);
  }
  buildCounterRegionInstanceGroupManagersAbandonInstancesRequest--;
}

buildUnnamed1898() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1898(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterRegionInstanceGroupManagersDeleteInstancesRequest = 0;
buildRegionInstanceGroupManagersDeleteInstancesRequest() {
  var o = new api.RegionInstanceGroupManagersDeleteInstancesRequest();
  buildCounterRegionInstanceGroupManagersDeleteInstancesRequest++;
  if (buildCounterRegionInstanceGroupManagersDeleteInstancesRequest < 3) {
    o.instances = buildUnnamed1898();
  }
  buildCounterRegionInstanceGroupManagersDeleteInstancesRequest--;
  return o;
}

checkRegionInstanceGroupManagersDeleteInstancesRequest(
    api.RegionInstanceGroupManagersDeleteInstancesRequest o) {
  buildCounterRegionInstanceGroupManagersDeleteInstancesRequest++;
  if (buildCounterRegionInstanceGroupManagersDeleteInstancesRequest < 3) {
    checkUnnamed1898(o.instances);
  }
  buildCounterRegionInstanceGroupManagersDeleteInstancesRequest--;
}

buildUnnamed1899() {
  var o = new core.List<api.ManagedInstance>();
  o.add(buildManagedInstance());
  o.add(buildManagedInstance());
  return o;
}

checkUnnamed1899(core.List<api.ManagedInstance> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkManagedInstance(o[0]);
  checkManagedInstance(o[1]);
}

core.int buildCounterRegionInstanceGroupManagersListInstancesResponse = 0;
buildRegionInstanceGroupManagersListInstancesResponse() {
  var o = new api.RegionInstanceGroupManagersListInstancesResponse();
  buildCounterRegionInstanceGroupManagersListInstancesResponse++;
  if (buildCounterRegionInstanceGroupManagersListInstancesResponse < 3) {
    o.managedInstances = buildUnnamed1899();
  }
  buildCounterRegionInstanceGroupManagersListInstancesResponse--;
  return o;
}

checkRegionInstanceGroupManagersListInstancesResponse(
    api.RegionInstanceGroupManagersListInstancesResponse o) {
  buildCounterRegionInstanceGroupManagersListInstancesResponse++;
  if (buildCounterRegionInstanceGroupManagersListInstancesResponse < 3) {
    checkUnnamed1899(o.managedInstances);
  }
  buildCounterRegionInstanceGroupManagersListInstancesResponse--;
}

buildUnnamed1900() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1900(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterRegionInstanceGroupManagersRecreateRequest = 0;
buildRegionInstanceGroupManagersRecreateRequest() {
  var o = new api.RegionInstanceGroupManagersRecreateRequest();
  buildCounterRegionInstanceGroupManagersRecreateRequest++;
  if (buildCounterRegionInstanceGroupManagersRecreateRequest < 3) {
    o.instances = buildUnnamed1900();
  }
  buildCounterRegionInstanceGroupManagersRecreateRequest--;
  return o;
}

checkRegionInstanceGroupManagersRecreateRequest(
    api.RegionInstanceGroupManagersRecreateRequest o) {
  buildCounterRegionInstanceGroupManagersRecreateRequest++;
  if (buildCounterRegionInstanceGroupManagersRecreateRequest < 3) {
    checkUnnamed1900(o.instances);
  }
  buildCounterRegionInstanceGroupManagersRecreateRequest--;
}

buildUnnamed1901() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1901(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterRegionInstanceGroupManagersSetTargetPoolsRequest = 0;
buildRegionInstanceGroupManagersSetTargetPoolsRequest() {
  var o = new api.RegionInstanceGroupManagersSetTargetPoolsRequest();
  buildCounterRegionInstanceGroupManagersSetTargetPoolsRequest++;
  if (buildCounterRegionInstanceGroupManagersSetTargetPoolsRequest < 3) {
    o.fingerprint = "foo";
    o.targetPools = buildUnnamed1901();
  }
  buildCounterRegionInstanceGroupManagersSetTargetPoolsRequest--;
  return o;
}

checkRegionInstanceGroupManagersSetTargetPoolsRequest(
    api.RegionInstanceGroupManagersSetTargetPoolsRequest o) {
  buildCounterRegionInstanceGroupManagersSetTargetPoolsRequest++;
  if (buildCounterRegionInstanceGroupManagersSetTargetPoolsRequest < 3) {
    unittest.expect(o.fingerprint, unittest.equals('foo'));
    checkUnnamed1901(o.targetPools);
  }
  buildCounterRegionInstanceGroupManagersSetTargetPoolsRequest--;
}

core.int buildCounterRegionInstanceGroupManagersSetTemplateRequest = 0;
buildRegionInstanceGroupManagersSetTemplateRequest() {
  var o = new api.RegionInstanceGroupManagersSetTemplateRequest();
  buildCounterRegionInstanceGroupManagersSetTemplateRequest++;
  if (buildCounterRegionInstanceGroupManagersSetTemplateRequest < 3) {
    o.instanceTemplate = "foo";
  }
  buildCounterRegionInstanceGroupManagersSetTemplateRequest--;
  return o;
}

checkRegionInstanceGroupManagersSetTemplateRequest(
    api.RegionInstanceGroupManagersSetTemplateRequest o) {
  buildCounterRegionInstanceGroupManagersSetTemplateRequest++;
  if (buildCounterRegionInstanceGroupManagersSetTemplateRequest < 3) {
    unittest.expect(o.instanceTemplate, unittest.equals('foo'));
  }
  buildCounterRegionInstanceGroupManagersSetTemplateRequest--;
}

buildUnnamed1902() {
  var o = new core.List<api.InstanceWithNamedPorts>();
  o.add(buildInstanceWithNamedPorts());
  o.add(buildInstanceWithNamedPorts());
  return o;
}

checkUnnamed1902(core.List<api.InstanceWithNamedPorts> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceWithNamedPorts(o[0]);
  checkInstanceWithNamedPorts(o[1]);
}

core.int buildCounterRegionInstanceGroupsListInstancesWarningData = 0;
buildRegionInstanceGroupsListInstancesWarningData() {
  var o = new api.RegionInstanceGroupsListInstancesWarningData();
  buildCounterRegionInstanceGroupsListInstancesWarningData++;
  if (buildCounterRegionInstanceGroupsListInstancesWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterRegionInstanceGroupsListInstancesWarningData--;
  return o;
}

checkRegionInstanceGroupsListInstancesWarningData(
    api.RegionInstanceGroupsListInstancesWarningData o) {
  buildCounterRegionInstanceGroupsListInstancesWarningData++;
  if (buildCounterRegionInstanceGroupsListInstancesWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterRegionInstanceGroupsListInstancesWarningData--;
}

buildUnnamed1903() {
  var o = new core.List<api.RegionInstanceGroupsListInstancesWarningData>();
  o.add(buildRegionInstanceGroupsListInstancesWarningData());
  o.add(buildRegionInstanceGroupsListInstancesWarningData());
  return o;
}

checkUnnamed1903(
    core.List<api.RegionInstanceGroupsListInstancesWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRegionInstanceGroupsListInstancesWarningData(o[0]);
  checkRegionInstanceGroupsListInstancesWarningData(o[1]);
}

core.int buildCounterRegionInstanceGroupsListInstancesWarning = 0;
buildRegionInstanceGroupsListInstancesWarning() {
  var o = new api.RegionInstanceGroupsListInstancesWarning();
  buildCounterRegionInstanceGroupsListInstancesWarning++;
  if (buildCounterRegionInstanceGroupsListInstancesWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1903();
    o.message = "foo";
  }
  buildCounterRegionInstanceGroupsListInstancesWarning--;
  return o;
}

checkRegionInstanceGroupsListInstancesWarning(
    api.RegionInstanceGroupsListInstancesWarning o) {
  buildCounterRegionInstanceGroupsListInstancesWarning++;
  if (buildCounterRegionInstanceGroupsListInstancesWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1903(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterRegionInstanceGroupsListInstancesWarning--;
}

core.int buildCounterRegionInstanceGroupsListInstances = 0;
buildRegionInstanceGroupsListInstances() {
  var o = new api.RegionInstanceGroupsListInstances();
  buildCounterRegionInstanceGroupsListInstances++;
  if (buildCounterRegionInstanceGroupsListInstances < 3) {
    o.id = "foo";
    o.items = buildUnnamed1902();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildRegionInstanceGroupsListInstancesWarning();
  }
  buildCounterRegionInstanceGroupsListInstances--;
  return o;
}

checkRegionInstanceGroupsListInstances(
    api.RegionInstanceGroupsListInstances o) {
  buildCounterRegionInstanceGroupsListInstances++;
  if (buildCounterRegionInstanceGroupsListInstances < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1902(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkRegionInstanceGroupsListInstancesWarning(o.warning);
  }
  buildCounterRegionInstanceGroupsListInstances--;
}

core.int buildCounterRegionInstanceGroupsListInstancesRequest = 0;
buildRegionInstanceGroupsListInstancesRequest() {
  var o = new api.RegionInstanceGroupsListInstancesRequest();
  buildCounterRegionInstanceGroupsListInstancesRequest++;
  if (buildCounterRegionInstanceGroupsListInstancesRequest < 3) {
    o.instanceState = "foo";
    o.portName = "foo";
  }
  buildCounterRegionInstanceGroupsListInstancesRequest--;
  return o;
}

checkRegionInstanceGroupsListInstancesRequest(
    api.RegionInstanceGroupsListInstancesRequest o) {
  buildCounterRegionInstanceGroupsListInstancesRequest++;
  if (buildCounterRegionInstanceGroupsListInstancesRequest < 3) {
    unittest.expect(o.instanceState, unittest.equals('foo'));
    unittest.expect(o.portName, unittest.equals('foo'));
  }
  buildCounterRegionInstanceGroupsListInstancesRequest--;
}

buildUnnamed1904() {
  var o = new core.List<api.NamedPort>();
  o.add(buildNamedPort());
  o.add(buildNamedPort());
  return o;
}

checkUnnamed1904(core.List<api.NamedPort> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNamedPort(o[0]);
  checkNamedPort(o[1]);
}

core.int buildCounterRegionInstanceGroupsSetNamedPortsRequest = 0;
buildRegionInstanceGroupsSetNamedPortsRequest() {
  var o = new api.RegionInstanceGroupsSetNamedPortsRequest();
  buildCounterRegionInstanceGroupsSetNamedPortsRequest++;
  if (buildCounterRegionInstanceGroupsSetNamedPortsRequest < 3) {
    o.fingerprint = "foo";
    o.namedPorts = buildUnnamed1904();
  }
  buildCounterRegionInstanceGroupsSetNamedPortsRequest--;
  return o;
}

checkRegionInstanceGroupsSetNamedPortsRequest(
    api.RegionInstanceGroupsSetNamedPortsRequest o) {
  buildCounterRegionInstanceGroupsSetNamedPortsRequest++;
  if (buildCounterRegionInstanceGroupsSetNamedPortsRequest < 3) {
    unittest.expect(o.fingerprint, unittest.equals('foo'));
    checkUnnamed1904(o.namedPorts);
  }
  buildCounterRegionInstanceGroupsSetNamedPortsRequest--;
}

buildUnnamed1905() {
  var o = new core.List<api.Region>();
  o.add(buildRegion());
  o.add(buildRegion());
  return o;
}

checkUnnamed1905(core.List<api.Region> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRegion(o[0]);
  checkRegion(o[1]);
}

core.int buildCounterRegionListWarningData = 0;
buildRegionListWarningData() {
  var o = new api.RegionListWarningData();
  buildCounterRegionListWarningData++;
  if (buildCounterRegionListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterRegionListWarningData--;
  return o;
}

checkRegionListWarningData(api.RegionListWarningData o) {
  buildCounterRegionListWarningData++;
  if (buildCounterRegionListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterRegionListWarningData--;
}

buildUnnamed1906() {
  var o = new core.List<api.RegionListWarningData>();
  o.add(buildRegionListWarningData());
  o.add(buildRegionListWarningData());
  return o;
}

checkUnnamed1906(core.List<api.RegionListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRegionListWarningData(o[0]);
  checkRegionListWarningData(o[1]);
}

core.int buildCounterRegionListWarning = 0;
buildRegionListWarning() {
  var o = new api.RegionListWarning();
  buildCounterRegionListWarning++;
  if (buildCounterRegionListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1906();
    o.message = "foo";
  }
  buildCounterRegionListWarning--;
  return o;
}

checkRegionListWarning(api.RegionListWarning o) {
  buildCounterRegionListWarning++;
  if (buildCounterRegionListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1906(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterRegionListWarning--;
}

core.int buildCounterRegionList = 0;
buildRegionList() {
  var o = new api.RegionList();
  buildCounterRegionList++;
  if (buildCounterRegionList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1905();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildRegionListWarning();
  }
  buildCounterRegionList--;
  return o;
}

checkRegionList(api.RegionList o) {
  buildCounterRegionList++;
  if (buildCounterRegionList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1905(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkRegionListWarning(o.warning);
  }
  buildCounterRegionList--;
}

buildUnnamed1907() {
  var o = new core.Map<core.String, core.String>();
  o["x"] = "foo";
  o["y"] = "foo";
  return o;
}

checkUnnamed1907(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o["x"], unittest.equals('foo'));
  unittest.expect(o["y"], unittest.equals('foo'));
}

core.int buildCounterRegionSetLabelsRequest = 0;
buildRegionSetLabelsRequest() {
  var o = new api.RegionSetLabelsRequest();
  buildCounterRegionSetLabelsRequest++;
  if (buildCounterRegionSetLabelsRequest < 3) {
    o.labelFingerprint = "foo";
    o.labels = buildUnnamed1907();
  }
  buildCounterRegionSetLabelsRequest--;
  return o;
}

checkRegionSetLabelsRequest(api.RegionSetLabelsRequest o) {
  buildCounterRegionSetLabelsRequest++;
  if (buildCounterRegionSetLabelsRequest < 3) {
    unittest.expect(o.labelFingerprint, unittest.equals('foo'));
    checkUnnamed1907(o.labels);
  }
  buildCounterRegionSetLabelsRequest--;
}

buildUnnamed1908() {
  var o = new core.List<api.Binding>();
  o.add(buildBinding());
  o.add(buildBinding());
  return o;
}

checkUnnamed1908(core.List<api.Binding> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBinding(o[0]);
  checkBinding(o[1]);
}

core.int buildCounterRegionSetPolicyRequest = 0;
buildRegionSetPolicyRequest() {
  var o = new api.RegionSetPolicyRequest();
  buildCounterRegionSetPolicyRequest++;
  if (buildCounterRegionSetPolicyRequest < 3) {
    o.bindings = buildUnnamed1908();
    o.etag = "foo";
    o.policy = buildPolicy();
  }
  buildCounterRegionSetPolicyRequest--;
  return o;
}

checkRegionSetPolicyRequest(api.RegionSetPolicyRequest o) {
  buildCounterRegionSetPolicyRequest++;
  if (buildCounterRegionSetPolicyRequest < 3) {
    checkUnnamed1908(o.bindings);
    unittest.expect(o.etag, unittest.equals('foo'));
    checkPolicy(o.policy);
  }
  buildCounterRegionSetPolicyRequest--;
}

core.int buildCounterReservation = 0;
buildReservation() {
  var o = new api.Reservation();
  buildCounterReservation++;
  if (buildCounterReservation < 3) {
    o.commitment = "foo";
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.id = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.selfLink = "foo";
    o.specificReservation = buildAllocationSpecificSKUReservation();
    o.specificReservationRequired = true;
    o.status = "foo";
    o.zone = "foo";
  }
  buildCounterReservation--;
  return o;
}

checkReservation(api.Reservation o) {
  buildCounterReservation++;
  if (buildCounterReservation < 3) {
    unittest.expect(o.commitment, unittest.equals('foo'));
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkAllocationSpecificSKUReservation(o.specificReservation);
    unittest.expect(o.specificReservationRequired, unittest.isTrue);
    unittest.expect(o.status, unittest.equals('foo'));
    unittest.expect(o.zone, unittest.equals('foo'));
  }
  buildCounterReservation--;
}

buildUnnamed1909() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1909(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterReservationAffinity = 0;
buildReservationAffinity() {
  var o = new api.ReservationAffinity();
  buildCounterReservationAffinity++;
  if (buildCounterReservationAffinity < 3) {
    o.consumeReservationType = "foo";
    o.key = "foo";
    o.values = buildUnnamed1909();
  }
  buildCounterReservationAffinity--;
  return o;
}

checkReservationAffinity(api.ReservationAffinity o) {
  buildCounterReservationAffinity++;
  if (buildCounterReservationAffinity < 3) {
    unittest.expect(o.consumeReservationType, unittest.equals('foo'));
    unittest.expect(o.key, unittest.equals('foo'));
    checkUnnamed1909(o.values);
  }
  buildCounterReservationAffinity--;
}

buildUnnamed1910() {
  var o = new core.Map<core.String, api.ReservationsScopedList>();
  o["x"] = buildReservationsScopedList();
  o["y"] = buildReservationsScopedList();
  return o;
}

checkUnnamed1910(core.Map<core.String, api.ReservationsScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkReservationsScopedList(o["x"]);
  checkReservationsScopedList(o["y"]);
}

core.int buildCounterReservationAggregatedListWarningData = 0;
buildReservationAggregatedListWarningData() {
  var o = new api.ReservationAggregatedListWarningData();
  buildCounterReservationAggregatedListWarningData++;
  if (buildCounterReservationAggregatedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterReservationAggregatedListWarningData--;
  return o;
}

checkReservationAggregatedListWarningData(
    api.ReservationAggregatedListWarningData o) {
  buildCounterReservationAggregatedListWarningData++;
  if (buildCounterReservationAggregatedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterReservationAggregatedListWarningData--;
}

buildUnnamed1911() {
  var o = new core.List<api.ReservationAggregatedListWarningData>();
  o.add(buildReservationAggregatedListWarningData());
  o.add(buildReservationAggregatedListWarningData());
  return o;
}

checkUnnamed1911(core.List<api.ReservationAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkReservationAggregatedListWarningData(o[0]);
  checkReservationAggregatedListWarningData(o[1]);
}

core.int buildCounterReservationAggregatedListWarning = 0;
buildReservationAggregatedListWarning() {
  var o = new api.ReservationAggregatedListWarning();
  buildCounterReservationAggregatedListWarning++;
  if (buildCounterReservationAggregatedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1911();
    o.message = "foo";
  }
  buildCounterReservationAggregatedListWarning--;
  return o;
}

checkReservationAggregatedListWarning(api.ReservationAggregatedListWarning o) {
  buildCounterReservationAggregatedListWarning++;
  if (buildCounterReservationAggregatedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1911(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterReservationAggregatedListWarning--;
}

core.int buildCounterReservationAggregatedList = 0;
buildReservationAggregatedList() {
  var o = new api.ReservationAggregatedList();
  buildCounterReservationAggregatedList++;
  if (buildCounterReservationAggregatedList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1910();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildReservationAggregatedListWarning();
  }
  buildCounterReservationAggregatedList--;
  return o;
}

checkReservationAggregatedList(api.ReservationAggregatedList o) {
  buildCounterReservationAggregatedList++;
  if (buildCounterReservationAggregatedList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1910(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkReservationAggregatedListWarning(o.warning);
  }
  buildCounterReservationAggregatedList--;
}

buildUnnamed1912() {
  var o = new core.List<api.Reservation>();
  o.add(buildReservation());
  o.add(buildReservation());
  return o;
}

checkUnnamed1912(core.List<api.Reservation> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkReservation(o[0]);
  checkReservation(o[1]);
}

core.int buildCounterReservationListWarningData = 0;
buildReservationListWarningData() {
  var o = new api.ReservationListWarningData();
  buildCounterReservationListWarningData++;
  if (buildCounterReservationListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterReservationListWarningData--;
  return o;
}

checkReservationListWarningData(api.ReservationListWarningData o) {
  buildCounterReservationListWarningData++;
  if (buildCounterReservationListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterReservationListWarningData--;
}

buildUnnamed1913() {
  var o = new core.List<api.ReservationListWarningData>();
  o.add(buildReservationListWarningData());
  o.add(buildReservationListWarningData());
  return o;
}

checkUnnamed1913(core.List<api.ReservationListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkReservationListWarningData(o[0]);
  checkReservationListWarningData(o[1]);
}

core.int buildCounterReservationListWarning = 0;
buildReservationListWarning() {
  var o = new api.ReservationListWarning();
  buildCounterReservationListWarning++;
  if (buildCounterReservationListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1913();
    o.message = "foo";
  }
  buildCounterReservationListWarning--;
  return o;
}

checkReservationListWarning(api.ReservationListWarning o) {
  buildCounterReservationListWarning++;
  if (buildCounterReservationListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1913(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterReservationListWarning--;
}

core.int buildCounterReservationList = 0;
buildReservationList() {
  var o = new api.ReservationList();
  buildCounterReservationList++;
  if (buildCounterReservationList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1912();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildReservationListWarning();
  }
  buildCounterReservationList--;
  return o;
}

checkReservationList(api.ReservationList o) {
  buildCounterReservationList++;
  if (buildCounterReservationList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1912(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkReservationListWarning(o.warning);
  }
  buildCounterReservationList--;
}

core.int buildCounterReservationsResizeRequest = 0;
buildReservationsResizeRequest() {
  var o = new api.ReservationsResizeRequest();
  buildCounterReservationsResizeRequest++;
  if (buildCounterReservationsResizeRequest < 3) {
    o.specificSkuCount = "foo";
  }
  buildCounterReservationsResizeRequest--;
  return o;
}

checkReservationsResizeRequest(api.ReservationsResizeRequest o) {
  buildCounterReservationsResizeRequest++;
  if (buildCounterReservationsResizeRequest < 3) {
    unittest.expect(o.specificSkuCount, unittest.equals('foo'));
  }
  buildCounterReservationsResizeRequest--;
}

buildUnnamed1914() {
  var o = new core.List<api.Reservation>();
  o.add(buildReservation());
  o.add(buildReservation());
  return o;
}

checkUnnamed1914(core.List<api.Reservation> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkReservation(o[0]);
  checkReservation(o[1]);
}

core.int buildCounterReservationsScopedListWarningData = 0;
buildReservationsScopedListWarningData() {
  var o = new api.ReservationsScopedListWarningData();
  buildCounterReservationsScopedListWarningData++;
  if (buildCounterReservationsScopedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterReservationsScopedListWarningData--;
  return o;
}

checkReservationsScopedListWarningData(
    api.ReservationsScopedListWarningData o) {
  buildCounterReservationsScopedListWarningData++;
  if (buildCounterReservationsScopedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterReservationsScopedListWarningData--;
}

buildUnnamed1915() {
  var o = new core.List<api.ReservationsScopedListWarningData>();
  o.add(buildReservationsScopedListWarningData());
  o.add(buildReservationsScopedListWarningData());
  return o;
}

checkUnnamed1915(core.List<api.ReservationsScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkReservationsScopedListWarningData(o[0]);
  checkReservationsScopedListWarningData(o[1]);
}

core.int buildCounterReservationsScopedListWarning = 0;
buildReservationsScopedListWarning() {
  var o = new api.ReservationsScopedListWarning();
  buildCounterReservationsScopedListWarning++;
  if (buildCounterReservationsScopedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1915();
    o.message = "foo";
  }
  buildCounterReservationsScopedListWarning--;
  return o;
}

checkReservationsScopedListWarning(api.ReservationsScopedListWarning o) {
  buildCounterReservationsScopedListWarning++;
  if (buildCounterReservationsScopedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1915(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterReservationsScopedListWarning--;
}

core.int buildCounterReservationsScopedList = 0;
buildReservationsScopedList() {
  var o = new api.ReservationsScopedList();
  buildCounterReservationsScopedList++;
  if (buildCounterReservationsScopedList < 3) {
    o.reservations = buildUnnamed1914();
    o.warning = buildReservationsScopedListWarning();
  }
  buildCounterReservationsScopedList--;
  return o;
}

checkReservationsScopedList(api.ReservationsScopedList o) {
  buildCounterReservationsScopedList++;
  if (buildCounterReservationsScopedList < 3) {
    checkUnnamed1914(o.reservations);
    checkReservationsScopedListWarning(o.warning);
  }
  buildCounterReservationsScopedList--;
}

core.int buildCounterResourceCommitment = 0;
buildResourceCommitment() {
  var o = new api.ResourceCommitment();
  buildCounterResourceCommitment++;
  if (buildCounterResourceCommitment < 3) {
    o.acceleratorType = "foo";
    o.amount = "foo";
    o.type = "foo";
  }
  buildCounterResourceCommitment--;
  return o;
}

checkResourceCommitment(api.ResourceCommitment o) {
  buildCounterResourceCommitment++;
  if (buildCounterResourceCommitment < 3) {
    unittest.expect(o.acceleratorType, unittest.equals('foo'));
    unittest.expect(o.amount, unittest.equals('foo'));
    unittest.expect(o.type, unittest.equals('foo'));
  }
  buildCounterResourceCommitment--;
}

core.int buildCounterResourceGroupReference = 0;
buildResourceGroupReference() {
  var o = new api.ResourceGroupReference();
  buildCounterResourceGroupReference++;
  if (buildCounterResourceGroupReference < 3) {
    o.group = "foo";
  }
  buildCounterResourceGroupReference--;
  return o;
}

checkResourceGroupReference(api.ResourceGroupReference o) {
  buildCounterResourceGroupReference++;
  if (buildCounterResourceGroupReference < 3) {
    unittest.expect(o.group, unittest.equals('foo'));
  }
  buildCounterResourceGroupReference--;
}

buildUnnamed1916() {
  var o = new core.List<api.ResourcePolicy>();
  o.add(buildResourcePolicy());
  o.add(buildResourcePolicy());
  return o;
}

checkUnnamed1916(core.List<api.ResourcePolicy> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkResourcePolicy(o[0]);
  checkResourcePolicy(o[1]);
}

core.int buildCounterResourcePoliciesScopedListWarningData = 0;
buildResourcePoliciesScopedListWarningData() {
  var o = new api.ResourcePoliciesScopedListWarningData();
  buildCounterResourcePoliciesScopedListWarningData++;
  if (buildCounterResourcePoliciesScopedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterResourcePoliciesScopedListWarningData--;
  return o;
}

checkResourcePoliciesScopedListWarningData(
    api.ResourcePoliciesScopedListWarningData o) {
  buildCounterResourcePoliciesScopedListWarningData++;
  if (buildCounterResourcePoliciesScopedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterResourcePoliciesScopedListWarningData--;
}

buildUnnamed1917() {
  var o = new core.List<api.ResourcePoliciesScopedListWarningData>();
  o.add(buildResourcePoliciesScopedListWarningData());
  o.add(buildResourcePoliciesScopedListWarningData());
  return o;
}

checkUnnamed1917(core.List<api.ResourcePoliciesScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkResourcePoliciesScopedListWarningData(o[0]);
  checkResourcePoliciesScopedListWarningData(o[1]);
}

core.int buildCounterResourcePoliciesScopedListWarning = 0;
buildResourcePoliciesScopedListWarning() {
  var o = new api.ResourcePoliciesScopedListWarning();
  buildCounterResourcePoliciesScopedListWarning++;
  if (buildCounterResourcePoliciesScopedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1917();
    o.message = "foo";
  }
  buildCounterResourcePoliciesScopedListWarning--;
  return o;
}

checkResourcePoliciesScopedListWarning(
    api.ResourcePoliciesScopedListWarning o) {
  buildCounterResourcePoliciesScopedListWarning++;
  if (buildCounterResourcePoliciesScopedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1917(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterResourcePoliciesScopedListWarning--;
}

core.int buildCounterResourcePoliciesScopedList = 0;
buildResourcePoliciesScopedList() {
  var o = new api.ResourcePoliciesScopedList();
  buildCounterResourcePoliciesScopedList++;
  if (buildCounterResourcePoliciesScopedList < 3) {
    o.resourcePolicies = buildUnnamed1916();
    o.warning = buildResourcePoliciesScopedListWarning();
  }
  buildCounterResourcePoliciesScopedList--;
  return o;
}

checkResourcePoliciesScopedList(api.ResourcePoliciesScopedList o) {
  buildCounterResourcePoliciesScopedList++;
  if (buildCounterResourcePoliciesScopedList < 3) {
    checkUnnamed1916(o.resourcePolicies);
    checkResourcePoliciesScopedListWarning(o.warning);
  }
  buildCounterResourcePoliciesScopedList--;
}

core.int buildCounterResourcePolicy = 0;
buildResourcePolicy() {
  var o = new api.ResourcePolicy();
  buildCounterResourcePolicy++;
  if (buildCounterResourcePolicy < 3) {
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.id = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.region = "foo";
    o.selfLink = "foo";
    o.snapshotSchedulePolicy = buildResourcePolicySnapshotSchedulePolicy();
    o.status = "foo";
  }
  buildCounterResourcePolicy--;
  return o;
}

checkResourcePolicy(api.ResourcePolicy o) {
  buildCounterResourcePolicy++;
  if (buildCounterResourcePolicy < 3) {
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.region, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkResourcePolicySnapshotSchedulePolicy(o.snapshotSchedulePolicy);
    unittest.expect(o.status, unittest.equals('foo'));
  }
  buildCounterResourcePolicy--;
}

buildUnnamed1918() {
  var o = new core.Map<core.String, api.ResourcePoliciesScopedList>();
  o["x"] = buildResourcePoliciesScopedList();
  o["y"] = buildResourcePoliciesScopedList();
  return o;
}

checkUnnamed1918(core.Map<core.String, api.ResourcePoliciesScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkResourcePoliciesScopedList(o["x"]);
  checkResourcePoliciesScopedList(o["y"]);
}

core.int buildCounterResourcePolicyAggregatedListWarningData = 0;
buildResourcePolicyAggregatedListWarningData() {
  var o = new api.ResourcePolicyAggregatedListWarningData();
  buildCounterResourcePolicyAggregatedListWarningData++;
  if (buildCounterResourcePolicyAggregatedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterResourcePolicyAggregatedListWarningData--;
  return o;
}

checkResourcePolicyAggregatedListWarningData(
    api.ResourcePolicyAggregatedListWarningData o) {
  buildCounterResourcePolicyAggregatedListWarningData++;
  if (buildCounterResourcePolicyAggregatedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterResourcePolicyAggregatedListWarningData--;
}

buildUnnamed1919() {
  var o = new core.List<api.ResourcePolicyAggregatedListWarningData>();
  o.add(buildResourcePolicyAggregatedListWarningData());
  o.add(buildResourcePolicyAggregatedListWarningData());
  return o;
}

checkUnnamed1919(core.List<api.ResourcePolicyAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkResourcePolicyAggregatedListWarningData(o[0]);
  checkResourcePolicyAggregatedListWarningData(o[1]);
}

core.int buildCounterResourcePolicyAggregatedListWarning = 0;
buildResourcePolicyAggregatedListWarning() {
  var o = new api.ResourcePolicyAggregatedListWarning();
  buildCounterResourcePolicyAggregatedListWarning++;
  if (buildCounterResourcePolicyAggregatedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1919();
    o.message = "foo";
  }
  buildCounterResourcePolicyAggregatedListWarning--;
  return o;
}

checkResourcePolicyAggregatedListWarning(
    api.ResourcePolicyAggregatedListWarning o) {
  buildCounterResourcePolicyAggregatedListWarning++;
  if (buildCounterResourcePolicyAggregatedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1919(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterResourcePolicyAggregatedListWarning--;
}

core.int buildCounterResourcePolicyAggregatedList = 0;
buildResourcePolicyAggregatedList() {
  var o = new api.ResourcePolicyAggregatedList();
  buildCounterResourcePolicyAggregatedList++;
  if (buildCounterResourcePolicyAggregatedList < 3) {
    o.etag = "foo";
    o.id = "foo";
    o.items = buildUnnamed1918();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildResourcePolicyAggregatedListWarning();
  }
  buildCounterResourcePolicyAggregatedList--;
  return o;
}

checkResourcePolicyAggregatedList(api.ResourcePolicyAggregatedList o) {
  buildCounterResourcePolicyAggregatedList++;
  if (buildCounterResourcePolicyAggregatedList < 3) {
    unittest.expect(o.etag, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1918(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkResourcePolicyAggregatedListWarning(o.warning);
  }
  buildCounterResourcePolicyAggregatedList--;
}

core.int buildCounterResourcePolicyDailyCycle = 0;
buildResourcePolicyDailyCycle() {
  var o = new api.ResourcePolicyDailyCycle();
  buildCounterResourcePolicyDailyCycle++;
  if (buildCounterResourcePolicyDailyCycle < 3) {
    o.daysInCycle = 42;
    o.duration = "foo";
    o.startTime = "foo";
  }
  buildCounterResourcePolicyDailyCycle--;
  return o;
}

checkResourcePolicyDailyCycle(api.ResourcePolicyDailyCycle o) {
  buildCounterResourcePolicyDailyCycle++;
  if (buildCounterResourcePolicyDailyCycle < 3) {
    unittest.expect(o.daysInCycle, unittest.equals(42));
    unittest.expect(o.duration, unittest.equals('foo'));
    unittest.expect(o.startTime, unittest.equals('foo'));
  }
  buildCounterResourcePolicyDailyCycle--;
}

core.int buildCounterResourcePolicyHourlyCycle = 0;
buildResourcePolicyHourlyCycle() {
  var o = new api.ResourcePolicyHourlyCycle();
  buildCounterResourcePolicyHourlyCycle++;
  if (buildCounterResourcePolicyHourlyCycle < 3) {
    o.duration = "foo";
    o.hoursInCycle = 42;
    o.startTime = "foo";
  }
  buildCounterResourcePolicyHourlyCycle--;
  return o;
}

checkResourcePolicyHourlyCycle(api.ResourcePolicyHourlyCycle o) {
  buildCounterResourcePolicyHourlyCycle++;
  if (buildCounterResourcePolicyHourlyCycle < 3) {
    unittest.expect(o.duration, unittest.equals('foo'));
    unittest.expect(o.hoursInCycle, unittest.equals(42));
    unittest.expect(o.startTime, unittest.equals('foo'));
  }
  buildCounterResourcePolicyHourlyCycle--;
}

buildUnnamed1920() {
  var o = new core.List<api.ResourcePolicy>();
  o.add(buildResourcePolicy());
  o.add(buildResourcePolicy());
  return o;
}

checkUnnamed1920(core.List<api.ResourcePolicy> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkResourcePolicy(o[0]);
  checkResourcePolicy(o[1]);
}

core.int buildCounterResourcePolicyListWarningData = 0;
buildResourcePolicyListWarningData() {
  var o = new api.ResourcePolicyListWarningData();
  buildCounterResourcePolicyListWarningData++;
  if (buildCounterResourcePolicyListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterResourcePolicyListWarningData--;
  return o;
}

checkResourcePolicyListWarningData(api.ResourcePolicyListWarningData o) {
  buildCounterResourcePolicyListWarningData++;
  if (buildCounterResourcePolicyListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterResourcePolicyListWarningData--;
}

buildUnnamed1921() {
  var o = new core.List<api.ResourcePolicyListWarningData>();
  o.add(buildResourcePolicyListWarningData());
  o.add(buildResourcePolicyListWarningData());
  return o;
}

checkUnnamed1921(core.List<api.ResourcePolicyListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkResourcePolicyListWarningData(o[0]);
  checkResourcePolicyListWarningData(o[1]);
}

core.int buildCounterResourcePolicyListWarning = 0;
buildResourcePolicyListWarning() {
  var o = new api.ResourcePolicyListWarning();
  buildCounterResourcePolicyListWarning++;
  if (buildCounterResourcePolicyListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1921();
    o.message = "foo";
  }
  buildCounterResourcePolicyListWarning--;
  return o;
}

checkResourcePolicyListWarning(api.ResourcePolicyListWarning o) {
  buildCounterResourcePolicyListWarning++;
  if (buildCounterResourcePolicyListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1921(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterResourcePolicyListWarning--;
}

core.int buildCounterResourcePolicyList = 0;
buildResourcePolicyList() {
  var o = new api.ResourcePolicyList();
  buildCounterResourcePolicyList++;
  if (buildCounterResourcePolicyList < 3) {
    o.etag = "foo";
    o.id = "foo";
    o.items = buildUnnamed1920();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildResourcePolicyListWarning();
  }
  buildCounterResourcePolicyList--;
  return o;
}

checkResourcePolicyList(api.ResourcePolicyList o) {
  buildCounterResourcePolicyList++;
  if (buildCounterResourcePolicyList < 3) {
    unittest.expect(o.etag, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1920(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkResourcePolicyListWarning(o.warning);
  }
  buildCounterResourcePolicyList--;
}

core.int buildCounterResourcePolicySnapshotSchedulePolicy = 0;
buildResourcePolicySnapshotSchedulePolicy() {
  var o = new api.ResourcePolicySnapshotSchedulePolicy();
  buildCounterResourcePolicySnapshotSchedulePolicy++;
  if (buildCounterResourcePolicySnapshotSchedulePolicy < 3) {
    o.retentionPolicy =
        buildResourcePolicySnapshotSchedulePolicyRetentionPolicy();
    o.schedule = buildResourcePolicySnapshotSchedulePolicySchedule();
    o.snapshotProperties =
        buildResourcePolicySnapshotSchedulePolicySnapshotProperties();
  }
  buildCounterResourcePolicySnapshotSchedulePolicy--;
  return o;
}

checkResourcePolicySnapshotSchedulePolicy(
    api.ResourcePolicySnapshotSchedulePolicy o) {
  buildCounterResourcePolicySnapshotSchedulePolicy++;
  if (buildCounterResourcePolicySnapshotSchedulePolicy < 3) {
    checkResourcePolicySnapshotSchedulePolicyRetentionPolicy(o.retentionPolicy);
    checkResourcePolicySnapshotSchedulePolicySchedule(o.schedule);
    checkResourcePolicySnapshotSchedulePolicySnapshotProperties(
        o.snapshotProperties);
  }
  buildCounterResourcePolicySnapshotSchedulePolicy--;
}

core.int buildCounterResourcePolicySnapshotSchedulePolicyRetentionPolicy = 0;
buildResourcePolicySnapshotSchedulePolicyRetentionPolicy() {
  var o = new api.ResourcePolicySnapshotSchedulePolicyRetentionPolicy();
  buildCounterResourcePolicySnapshotSchedulePolicyRetentionPolicy++;
  if (buildCounterResourcePolicySnapshotSchedulePolicyRetentionPolicy < 3) {
    o.maxRetentionDays = 42;
    o.onSourceDiskDelete = "foo";
  }
  buildCounterResourcePolicySnapshotSchedulePolicyRetentionPolicy--;
  return o;
}

checkResourcePolicySnapshotSchedulePolicyRetentionPolicy(
    api.ResourcePolicySnapshotSchedulePolicyRetentionPolicy o) {
  buildCounterResourcePolicySnapshotSchedulePolicyRetentionPolicy++;
  if (buildCounterResourcePolicySnapshotSchedulePolicyRetentionPolicy < 3) {
    unittest.expect(o.maxRetentionDays, unittest.equals(42));
    unittest.expect(o.onSourceDiskDelete, unittest.equals('foo'));
  }
  buildCounterResourcePolicySnapshotSchedulePolicyRetentionPolicy--;
}

core.int buildCounterResourcePolicySnapshotSchedulePolicySchedule = 0;
buildResourcePolicySnapshotSchedulePolicySchedule() {
  var o = new api.ResourcePolicySnapshotSchedulePolicySchedule();
  buildCounterResourcePolicySnapshotSchedulePolicySchedule++;
  if (buildCounterResourcePolicySnapshotSchedulePolicySchedule < 3) {
    o.dailySchedule = buildResourcePolicyDailyCycle();
    o.hourlySchedule = buildResourcePolicyHourlyCycle();
    o.weeklySchedule = buildResourcePolicyWeeklyCycle();
  }
  buildCounterResourcePolicySnapshotSchedulePolicySchedule--;
  return o;
}

checkResourcePolicySnapshotSchedulePolicySchedule(
    api.ResourcePolicySnapshotSchedulePolicySchedule o) {
  buildCounterResourcePolicySnapshotSchedulePolicySchedule++;
  if (buildCounterResourcePolicySnapshotSchedulePolicySchedule < 3) {
    checkResourcePolicyDailyCycle(o.dailySchedule);
    checkResourcePolicyHourlyCycle(o.hourlySchedule);
    checkResourcePolicyWeeklyCycle(o.weeklySchedule);
  }
  buildCounterResourcePolicySnapshotSchedulePolicySchedule--;
}

buildUnnamed1922() {
  var o = new core.Map<core.String, core.String>();
  o["x"] = "foo";
  o["y"] = "foo";
  return o;
}

checkUnnamed1922(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o["x"], unittest.equals('foo'));
  unittest.expect(o["y"], unittest.equals('foo'));
}

buildUnnamed1923() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1923(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterResourcePolicySnapshotSchedulePolicySnapshotProperties = 0;
buildResourcePolicySnapshotSchedulePolicySnapshotProperties() {
  var o = new api.ResourcePolicySnapshotSchedulePolicySnapshotProperties();
  buildCounterResourcePolicySnapshotSchedulePolicySnapshotProperties++;
  if (buildCounterResourcePolicySnapshotSchedulePolicySnapshotProperties < 3) {
    o.guestFlush = true;
    o.labels = buildUnnamed1922();
    o.storageLocations = buildUnnamed1923();
  }
  buildCounterResourcePolicySnapshotSchedulePolicySnapshotProperties--;
  return o;
}

checkResourcePolicySnapshotSchedulePolicySnapshotProperties(
    api.ResourcePolicySnapshotSchedulePolicySnapshotProperties o) {
  buildCounterResourcePolicySnapshotSchedulePolicySnapshotProperties++;
  if (buildCounterResourcePolicySnapshotSchedulePolicySnapshotProperties < 3) {
    unittest.expect(o.guestFlush, unittest.isTrue);
    checkUnnamed1922(o.labels);
    checkUnnamed1923(o.storageLocations);
  }
  buildCounterResourcePolicySnapshotSchedulePolicySnapshotProperties--;
}

buildUnnamed1924() {
  var o = new core.List<api.ResourcePolicyWeeklyCycleDayOfWeek>();
  o.add(buildResourcePolicyWeeklyCycleDayOfWeek());
  o.add(buildResourcePolicyWeeklyCycleDayOfWeek());
  return o;
}

checkUnnamed1924(core.List<api.ResourcePolicyWeeklyCycleDayOfWeek> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkResourcePolicyWeeklyCycleDayOfWeek(o[0]);
  checkResourcePolicyWeeklyCycleDayOfWeek(o[1]);
}

core.int buildCounterResourcePolicyWeeklyCycle = 0;
buildResourcePolicyWeeklyCycle() {
  var o = new api.ResourcePolicyWeeklyCycle();
  buildCounterResourcePolicyWeeklyCycle++;
  if (buildCounterResourcePolicyWeeklyCycle < 3) {
    o.dayOfWeeks = buildUnnamed1924();
  }
  buildCounterResourcePolicyWeeklyCycle--;
  return o;
}

checkResourcePolicyWeeklyCycle(api.ResourcePolicyWeeklyCycle o) {
  buildCounterResourcePolicyWeeklyCycle++;
  if (buildCounterResourcePolicyWeeklyCycle < 3) {
    checkUnnamed1924(o.dayOfWeeks);
  }
  buildCounterResourcePolicyWeeklyCycle--;
}

core.int buildCounterResourcePolicyWeeklyCycleDayOfWeek = 0;
buildResourcePolicyWeeklyCycleDayOfWeek() {
  var o = new api.ResourcePolicyWeeklyCycleDayOfWeek();
  buildCounterResourcePolicyWeeklyCycleDayOfWeek++;
  if (buildCounterResourcePolicyWeeklyCycleDayOfWeek < 3) {
    o.day = "foo";
    o.duration = "foo";
    o.startTime = "foo";
  }
  buildCounterResourcePolicyWeeklyCycleDayOfWeek--;
  return o;
}

checkResourcePolicyWeeklyCycleDayOfWeek(
    api.ResourcePolicyWeeklyCycleDayOfWeek o) {
  buildCounterResourcePolicyWeeklyCycleDayOfWeek++;
  if (buildCounterResourcePolicyWeeklyCycleDayOfWeek < 3) {
    unittest.expect(o.day, unittest.equals('foo'));
    unittest.expect(o.duration, unittest.equals('foo'));
    unittest.expect(o.startTime, unittest.equals('foo'));
  }
  buildCounterResourcePolicyWeeklyCycleDayOfWeek--;
}

buildUnnamed1925() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1925(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterRouteWarningsData = 0;
buildRouteWarningsData() {
  var o = new api.RouteWarningsData();
  buildCounterRouteWarningsData++;
  if (buildCounterRouteWarningsData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterRouteWarningsData--;
  return o;
}

checkRouteWarningsData(api.RouteWarningsData o) {
  buildCounterRouteWarningsData++;
  if (buildCounterRouteWarningsData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterRouteWarningsData--;
}

buildUnnamed1926() {
  var o = new core.List<api.RouteWarningsData>();
  o.add(buildRouteWarningsData());
  o.add(buildRouteWarningsData());
  return o;
}

checkUnnamed1926(core.List<api.RouteWarningsData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouteWarningsData(o[0]);
  checkRouteWarningsData(o[1]);
}

core.int buildCounterRouteWarnings = 0;
buildRouteWarnings() {
  var o = new api.RouteWarnings();
  buildCounterRouteWarnings++;
  if (buildCounterRouteWarnings < 3) {
    o.code = "foo";
    o.data = buildUnnamed1926();
    o.message = "foo";
  }
  buildCounterRouteWarnings--;
  return o;
}

checkRouteWarnings(api.RouteWarnings o) {
  buildCounterRouteWarnings++;
  if (buildCounterRouteWarnings < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1926(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterRouteWarnings--;
}

buildUnnamed1927() {
  var o = new core.List<api.RouteWarnings>();
  o.add(buildRouteWarnings());
  o.add(buildRouteWarnings());
  return o;
}

checkUnnamed1927(core.List<api.RouteWarnings> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouteWarnings(o[0]);
  checkRouteWarnings(o[1]);
}

core.int buildCounterRoute = 0;
buildRoute() {
  var o = new api.Route();
  buildCounterRoute++;
  if (buildCounterRoute < 3) {
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.destRange = "foo";
    o.id = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.network = "foo";
    o.nextHopGateway = "foo";
    o.nextHopInstance = "foo";
    o.nextHopIp = "foo";
    o.nextHopNetwork = "foo";
    o.nextHopPeering = "foo";
    o.nextHopVpnTunnel = "foo";
    o.priority = 42;
    o.selfLink = "foo";
    o.tags = buildUnnamed1925();
    o.warnings = buildUnnamed1927();
  }
  buildCounterRoute--;
  return o;
}

checkRoute(api.Route o) {
  buildCounterRoute++;
  if (buildCounterRoute < 3) {
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.destRange, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.network, unittest.equals('foo'));
    unittest.expect(o.nextHopGateway, unittest.equals('foo'));
    unittest.expect(o.nextHopInstance, unittest.equals('foo'));
    unittest.expect(o.nextHopIp, unittest.equals('foo'));
    unittest.expect(o.nextHopNetwork, unittest.equals('foo'));
    unittest.expect(o.nextHopPeering, unittest.equals('foo'));
    unittest.expect(o.nextHopVpnTunnel, unittest.equals('foo'));
    unittest.expect(o.priority, unittest.equals(42));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkUnnamed1925(o.tags);
    checkUnnamed1927(o.warnings);
  }
  buildCounterRoute--;
}

buildUnnamed1928() {
  var o = new core.List<api.Route>();
  o.add(buildRoute());
  o.add(buildRoute());
  return o;
}

checkUnnamed1928(core.List<api.Route> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRoute(o[0]);
  checkRoute(o[1]);
}

core.int buildCounterRouteListWarningData = 0;
buildRouteListWarningData() {
  var o = new api.RouteListWarningData();
  buildCounterRouteListWarningData++;
  if (buildCounterRouteListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterRouteListWarningData--;
  return o;
}

checkRouteListWarningData(api.RouteListWarningData o) {
  buildCounterRouteListWarningData++;
  if (buildCounterRouteListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterRouteListWarningData--;
}

buildUnnamed1929() {
  var o = new core.List<api.RouteListWarningData>();
  o.add(buildRouteListWarningData());
  o.add(buildRouteListWarningData());
  return o;
}

checkUnnamed1929(core.List<api.RouteListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouteListWarningData(o[0]);
  checkRouteListWarningData(o[1]);
}

core.int buildCounterRouteListWarning = 0;
buildRouteListWarning() {
  var o = new api.RouteListWarning();
  buildCounterRouteListWarning++;
  if (buildCounterRouteListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1929();
    o.message = "foo";
  }
  buildCounterRouteListWarning--;
  return o;
}

checkRouteListWarning(api.RouteListWarning o) {
  buildCounterRouteListWarning++;
  if (buildCounterRouteListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1929(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterRouteListWarning--;
}

core.int buildCounterRouteList = 0;
buildRouteList() {
  var o = new api.RouteList();
  buildCounterRouteList++;
  if (buildCounterRouteList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1928();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildRouteListWarning();
  }
  buildCounterRouteList--;
  return o;
}

checkRouteList(api.RouteList o) {
  buildCounterRouteList++;
  if (buildCounterRouteList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1928(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkRouteListWarning(o.warning);
  }
  buildCounterRouteList--;
}

buildUnnamed1930() {
  var o = new core.List<api.RouterBgpPeer>();
  o.add(buildRouterBgpPeer());
  o.add(buildRouterBgpPeer());
  return o;
}

checkUnnamed1930(core.List<api.RouterBgpPeer> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouterBgpPeer(o[0]);
  checkRouterBgpPeer(o[1]);
}

buildUnnamed1931() {
  var o = new core.List<api.RouterInterface>();
  o.add(buildRouterInterface());
  o.add(buildRouterInterface());
  return o;
}

checkUnnamed1931(core.List<api.RouterInterface> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouterInterface(o[0]);
  checkRouterInterface(o[1]);
}

buildUnnamed1932() {
  var o = new core.List<api.RouterNat>();
  o.add(buildRouterNat());
  o.add(buildRouterNat());
  return o;
}

checkUnnamed1932(core.List<api.RouterNat> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouterNat(o[0]);
  checkRouterNat(o[1]);
}

core.int buildCounterRouter = 0;
buildRouter() {
  var o = new api.Router();
  buildCounterRouter++;
  if (buildCounterRouter < 3) {
    o.bgp = buildRouterBgp();
    o.bgpPeers = buildUnnamed1930();
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.id = "foo";
    o.interfaces = buildUnnamed1931();
    o.kind = "foo";
    o.name = "foo";
    o.nats = buildUnnamed1932();
    o.network = "foo";
    o.region = "foo";
    o.selfLink = "foo";
  }
  buildCounterRouter--;
  return o;
}

checkRouter(api.Router o) {
  buildCounterRouter++;
  if (buildCounterRouter < 3) {
    checkRouterBgp(o.bgp);
    checkUnnamed1930(o.bgpPeers);
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1931(o.interfaces);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    checkUnnamed1932(o.nats);
    unittest.expect(o.network, unittest.equals('foo'));
    unittest.expect(o.region, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
  }
  buildCounterRouter--;
}

core.int buildCounterRouterAdvertisedIpRange = 0;
buildRouterAdvertisedIpRange() {
  var o = new api.RouterAdvertisedIpRange();
  buildCounterRouterAdvertisedIpRange++;
  if (buildCounterRouterAdvertisedIpRange < 3) {
    o.description = "foo";
    o.range = "foo";
  }
  buildCounterRouterAdvertisedIpRange--;
  return o;
}

checkRouterAdvertisedIpRange(api.RouterAdvertisedIpRange o) {
  buildCounterRouterAdvertisedIpRange++;
  if (buildCounterRouterAdvertisedIpRange < 3) {
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.range, unittest.equals('foo'));
  }
  buildCounterRouterAdvertisedIpRange--;
}

buildUnnamed1933() {
  var o = new core.Map<core.String, api.RoutersScopedList>();
  o["x"] = buildRoutersScopedList();
  o["y"] = buildRoutersScopedList();
  return o;
}

checkUnnamed1933(core.Map<core.String, api.RoutersScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRoutersScopedList(o["x"]);
  checkRoutersScopedList(o["y"]);
}

core.int buildCounterRouterAggregatedListWarningData = 0;
buildRouterAggregatedListWarningData() {
  var o = new api.RouterAggregatedListWarningData();
  buildCounterRouterAggregatedListWarningData++;
  if (buildCounterRouterAggregatedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterRouterAggregatedListWarningData--;
  return o;
}

checkRouterAggregatedListWarningData(api.RouterAggregatedListWarningData o) {
  buildCounterRouterAggregatedListWarningData++;
  if (buildCounterRouterAggregatedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterRouterAggregatedListWarningData--;
}

buildUnnamed1934() {
  var o = new core.List<api.RouterAggregatedListWarningData>();
  o.add(buildRouterAggregatedListWarningData());
  o.add(buildRouterAggregatedListWarningData());
  return o;
}

checkUnnamed1934(core.List<api.RouterAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouterAggregatedListWarningData(o[0]);
  checkRouterAggregatedListWarningData(o[1]);
}

core.int buildCounterRouterAggregatedListWarning = 0;
buildRouterAggregatedListWarning() {
  var o = new api.RouterAggregatedListWarning();
  buildCounterRouterAggregatedListWarning++;
  if (buildCounterRouterAggregatedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1934();
    o.message = "foo";
  }
  buildCounterRouterAggregatedListWarning--;
  return o;
}

checkRouterAggregatedListWarning(api.RouterAggregatedListWarning o) {
  buildCounterRouterAggregatedListWarning++;
  if (buildCounterRouterAggregatedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1934(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterRouterAggregatedListWarning--;
}

core.int buildCounterRouterAggregatedList = 0;
buildRouterAggregatedList() {
  var o = new api.RouterAggregatedList();
  buildCounterRouterAggregatedList++;
  if (buildCounterRouterAggregatedList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1933();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildRouterAggregatedListWarning();
  }
  buildCounterRouterAggregatedList--;
  return o;
}

checkRouterAggregatedList(api.RouterAggregatedList o) {
  buildCounterRouterAggregatedList++;
  if (buildCounterRouterAggregatedList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1933(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkRouterAggregatedListWarning(o.warning);
  }
  buildCounterRouterAggregatedList--;
}

buildUnnamed1935() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1935(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

buildUnnamed1936() {
  var o = new core.List<api.RouterAdvertisedIpRange>();
  o.add(buildRouterAdvertisedIpRange());
  o.add(buildRouterAdvertisedIpRange());
  return o;
}

checkUnnamed1936(core.List<api.RouterAdvertisedIpRange> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouterAdvertisedIpRange(o[0]);
  checkRouterAdvertisedIpRange(o[1]);
}

core.int buildCounterRouterBgp = 0;
buildRouterBgp() {
  var o = new api.RouterBgp();
  buildCounterRouterBgp++;
  if (buildCounterRouterBgp < 3) {
    o.advertiseMode = "foo";
    o.advertisedGroups = buildUnnamed1935();
    o.advertisedIpRanges = buildUnnamed1936();
    o.asn = 42;
  }
  buildCounterRouterBgp--;
  return o;
}

checkRouterBgp(api.RouterBgp o) {
  buildCounterRouterBgp++;
  if (buildCounterRouterBgp < 3) {
    unittest.expect(o.advertiseMode, unittest.equals('foo'));
    checkUnnamed1935(o.advertisedGroups);
    checkUnnamed1936(o.advertisedIpRanges);
    unittest.expect(o.asn, unittest.equals(42));
  }
  buildCounterRouterBgp--;
}

buildUnnamed1937() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1937(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

buildUnnamed1938() {
  var o = new core.List<api.RouterAdvertisedIpRange>();
  o.add(buildRouterAdvertisedIpRange());
  o.add(buildRouterAdvertisedIpRange());
  return o;
}

checkUnnamed1938(core.List<api.RouterAdvertisedIpRange> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouterAdvertisedIpRange(o[0]);
  checkRouterAdvertisedIpRange(o[1]);
}

core.int buildCounterRouterBgpPeer = 0;
buildRouterBgpPeer() {
  var o = new api.RouterBgpPeer();
  buildCounterRouterBgpPeer++;
  if (buildCounterRouterBgpPeer < 3) {
    o.advertiseMode = "foo";
    o.advertisedGroups = buildUnnamed1937();
    o.advertisedIpRanges = buildUnnamed1938();
    o.advertisedRoutePriority = 42;
    o.interfaceName = "foo";
    o.ipAddress = "foo";
    o.managementType = "foo";
    o.name = "foo";
    o.peerAsn = 42;
    o.peerIpAddress = "foo";
  }
  buildCounterRouterBgpPeer--;
  return o;
}

checkRouterBgpPeer(api.RouterBgpPeer o) {
  buildCounterRouterBgpPeer++;
  if (buildCounterRouterBgpPeer < 3) {
    unittest.expect(o.advertiseMode, unittest.equals('foo'));
    checkUnnamed1937(o.advertisedGroups);
    checkUnnamed1938(o.advertisedIpRanges);
    unittest.expect(o.advertisedRoutePriority, unittest.equals(42));
    unittest.expect(o.interfaceName, unittest.equals('foo'));
    unittest.expect(o.ipAddress, unittest.equals('foo'));
    unittest.expect(o.managementType, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.peerAsn, unittest.equals(42));
    unittest.expect(o.peerIpAddress, unittest.equals('foo'));
  }
  buildCounterRouterBgpPeer--;
}

core.int buildCounterRouterInterface = 0;
buildRouterInterface() {
  var o = new api.RouterInterface();
  buildCounterRouterInterface++;
  if (buildCounterRouterInterface < 3) {
    o.ipRange = "foo";
    o.linkedInterconnectAttachment = "foo";
    o.linkedVpnTunnel = "foo";
    o.managementType = "foo";
    o.name = "foo";
  }
  buildCounterRouterInterface--;
  return o;
}

checkRouterInterface(api.RouterInterface o) {
  buildCounterRouterInterface++;
  if (buildCounterRouterInterface < 3) {
    unittest.expect(o.ipRange, unittest.equals('foo'));
    unittest.expect(o.linkedInterconnectAttachment, unittest.equals('foo'));
    unittest.expect(o.linkedVpnTunnel, unittest.equals('foo'));
    unittest.expect(o.managementType, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
  }
  buildCounterRouterInterface--;
}

buildUnnamed1939() {
  var o = new core.List<api.Router>();
  o.add(buildRouter());
  o.add(buildRouter());
  return o;
}

checkUnnamed1939(core.List<api.Router> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouter(o[0]);
  checkRouter(o[1]);
}

core.int buildCounterRouterListWarningData = 0;
buildRouterListWarningData() {
  var o = new api.RouterListWarningData();
  buildCounterRouterListWarningData++;
  if (buildCounterRouterListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterRouterListWarningData--;
  return o;
}

checkRouterListWarningData(api.RouterListWarningData o) {
  buildCounterRouterListWarningData++;
  if (buildCounterRouterListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterRouterListWarningData--;
}

buildUnnamed1940() {
  var o = new core.List<api.RouterListWarningData>();
  o.add(buildRouterListWarningData());
  o.add(buildRouterListWarningData());
  return o;
}

checkUnnamed1940(core.List<api.RouterListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouterListWarningData(o[0]);
  checkRouterListWarningData(o[1]);
}

core.int buildCounterRouterListWarning = 0;
buildRouterListWarning() {
  var o = new api.RouterListWarning();
  buildCounterRouterListWarning++;
  if (buildCounterRouterListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1940();
    o.message = "foo";
  }
  buildCounterRouterListWarning--;
  return o;
}

checkRouterListWarning(api.RouterListWarning o) {
  buildCounterRouterListWarning++;
  if (buildCounterRouterListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1940(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterRouterListWarning--;
}

core.int buildCounterRouterList = 0;
buildRouterList() {
  var o = new api.RouterList();
  buildCounterRouterList++;
  if (buildCounterRouterList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1939();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildRouterListWarning();
  }
  buildCounterRouterList--;
  return o;
}

checkRouterList(api.RouterList o) {
  buildCounterRouterList++;
  if (buildCounterRouterList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1939(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkRouterListWarning(o.warning);
  }
  buildCounterRouterList--;
}

buildUnnamed1941() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1941(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

buildUnnamed1942() {
  var o = new core.List<api.RouterNatSubnetworkToNat>();
  o.add(buildRouterNatSubnetworkToNat());
  o.add(buildRouterNatSubnetworkToNat());
  return o;
}

checkUnnamed1942(core.List<api.RouterNatSubnetworkToNat> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouterNatSubnetworkToNat(o[0]);
  checkRouterNatSubnetworkToNat(o[1]);
}

core.int buildCounterRouterNat = 0;
buildRouterNat() {
  var o = new api.RouterNat();
  buildCounterRouterNat++;
  if (buildCounterRouterNat < 3) {
    o.icmpIdleTimeoutSec = 42;
    o.logConfig = buildRouterNatLogConfig();
    o.minPortsPerVm = 42;
    o.name = "foo";
    o.natIpAllocateOption = "foo";
    o.natIps = buildUnnamed1941();
    o.sourceSubnetworkIpRangesToNat = "foo";
    o.subnetworks = buildUnnamed1942();
    o.tcpEstablishedIdleTimeoutSec = 42;
    o.tcpTransitoryIdleTimeoutSec = 42;
    o.udpIdleTimeoutSec = 42;
  }
  buildCounterRouterNat--;
  return o;
}

checkRouterNat(api.RouterNat o) {
  buildCounterRouterNat++;
  if (buildCounterRouterNat < 3) {
    unittest.expect(o.icmpIdleTimeoutSec, unittest.equals(42));
    checkRouterNatLogConfig(o.logConfig);
    unittest.expect(o.minPortsPerVm, unittest.equals(42));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.natIpAllocateOption, unittest.equals('foo'));
    checkUnnamed1941(o.natIps);
    unittest.expect(o.sourceSubnetworkIpRangesToNat, unittest.equals('foo'));
    checkUnnamed1942(o.subnetworks);
    unittest.expect(o.tcpEstablishedIdleTimeoutSec, unittest.equals(42));
    unittest.expect(o.tcpTransitoryIdleTimeoutSec, unittest.equals(42));
    unittest.expect(o.udpIdleTimeoutSec, unittest.equals(42));
  }
  buildCounterRouterNat--;
}

core.int buildCounterRouterNatLogConfig = 0;
buildRouterNatLogConfig() {
  var o = new api.RouterNatLogConfig();
  buildCounterRouterNatLogConfig++;
  if (buildCounterRouterNatLogConfig < 3) {
    o.enable = true;
    o.filter = "foo";
  }
  buildCounterRouterNatLogConfig--;
  return o;
}

checkRouterNatLogConfig(api.RouterNatLogConfig o) {
  buildCounterRouterNatLogConfig++;
  if (buildCounterRouterNatLogConfig < 3) {
    unittest.expect(o.enable, unittest.isTrue);
    unittest.expect(o.filter, unittest.equals('foo'));
  }
  buildCounterRouterNatLogConfig--;
}

buildUnnamed1943() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1943(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

buildUnnamed1944() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1944(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterRouterNatSubnetworkToNat = 0;
buildRouterNatSubnetworkToNat() {
  var o = new api.RouterNatSubnetworkToNat();
  buildCounterRouterNatSubnetworkToNat++;
  if (buildCounterRouterNatSubnetworkToNat < 3) {
    o.name = "foo";
    o.secondaryIpRangeNames = buildUnnamed1943();
    o.sourceIpRangesToNat = buildUnnamed1944();
  }
  buildCounterRouterNatSubnetworkToNat--;
  return o;
}

checkRouterNatSubnetworkToNat(api.RouterNatSubnetworkToNat o) {
  buildCounterRouterNatSubnetworkToNat++;
  if (buildCounterRouterNatSubnetworkToNat < 3) {
    unittest.expect(o.name, unittest.equals('foo'));
    checkUnnamed1943(o.secondaryIpRangeNames);
    checkUnnamed1944(o.sourceIpRangesToNat);
  }
  buildCounterRouterNatSubnetworkToNat--;
}

buildUnnamed1945() {
  var o = new core.List<api.Route>();
  o.add(buildRoute());
  o.add(buildRoute());
  return o;
}

checkUnnamed1945(core.List<api.Route> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRoute(o[0]);
  checkRoute(o[1]);
}

buildUnnamed1946() {
  var o = new core.List<api.Route>();
  o.add(buildRoute());
  o.add(buildRoute());
  return o;
}

checkUnnamed1946(core.List<api.Route> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRoute(o[0]);
  checkRoute(o[1]);
}

buildUnnamed1947() {
  var o = new core.List<api.RouterStatusBgpPeerStatus>();
  o.add(buildRouterStatusBgpPeerStatus());
  o.add(buildRouterStatusBgpPeerStatus());
  return o;
}

checkUnnamed1947(core.List<api.RouterStatusBgpPeerStatus> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouterStatusBgpPeerStatus(o[0]);
  checkRouterStatusBgpPeerStatus(o[1]);
}

buildUnnamed1948() {
  var o = new core.List<api.RouterStatusNatStatus>();
  o.add(buildRouterStatusNatStatus());
  o.add(buildRouterStatusNatStatus());
  return o;
}

checkUnnamed1948(core.List<api.RouterStatusNatStatus> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouterStatusNatStatus(o[0]);
  checkRouterStatusNatStatus(o[1]);
}

core.int buildCounterRouterStatus = 0;
buildRouterStatus() {
  var o = new api.RouterStatus();
  buildCounterRouterStatus++;
  if (buildCounterRouterStatus < 3) {
    o.bestRoutes = buildUnnamed1945();
    o.bestRoutesForRouter = buildUnnamed1946();
    o.bgpPeerStatus = buildUnnamed1947();
    o.natStatus = buildUnnamed1948();
    o.network = "foo";
  }
  buildCounterRouterStatus--;
  return o;
}

checkRouterStatus(api.RouterStatus o) {
  buildCounterRouterStatus++;
  if (buildCounterRouterStatus < 3) {
    checkUnnamed1945(o.bestRoutes);
    checkUnnamed1946(o.bestRoutesForRouter);
    checkUnnamed1947(o.bgpPeerStatus);
    checkUnnamed1948(o.natStatus);
    unittest.expect(o.network, unittest.equals('foo'));
  }
  buildCounterRouterStatus--;
}

buildUnnamed1949() {
  var o = new core.List<api.Route>();
  o.add(buildRoute());
  o.add(buildRoute());
  return o;
}

checkUnnamed1949(core.List<api.Route> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRoute(o[0]);
  checkRoute(o[1]);
}

core.int buildCounterRouterStatusBgpPeerStatus = 0;
buildRouterStatusBgpPeerStatus() {
  var o = new api.RouterStatusBgpPeerStatus();
  buildCounterRouterStatusBgpPeerStatus++;
  if (buildCounterRouterStatusBgpPeerStatus < 3) {
    o.advertisedRoutes = buildUnnamed1949();
    o.ipAddress = "foo";
    o.linkedVpnTunnel = "foo";
    o.name = "foo";
    o.numLearnedRoutes = 42;
    o.peerIpAddress = "foo";
    o.state = "foo";
    o.status = "foo";
    o.uptime = "foo";
    o.uptimeSeconds = "foo";
  }
  buildCounterRouterStatusBgpPeerStatus--;
  return o;
}

checkRouterStatusBgpPeerStatus(api.RouterStatusBgpPeerStatus o) {
  buildCounterRouterStatusBgpPeerStatus++;
  if (buildCounterRouterStatusBgpPeerStatus < 3) {
    checkUnnamed1949(o.advertisedRoutes);
    unittest.expect(o.ipAddress, unittest.equals('foo'));
    unittest.expect(o.linkedVpnTunnel, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.numLearnedRoutes, unittest.equals(42));
    unittest.expect(o.peerIpAddress, unittest.equals('foo'));
    unittest.expect(o.state, unittest.equals('foo'));
    unittest.expect(o.status, unittest.equals('foo'));
    unittest.expect(o.uptime, unittest.equals('foo'));
    unittest.expect(o.uptimeSeconds, unittest.equals('foo'));
  }
  buildCounterRouterStatusBgpPeerStatus--;
}

buildUnnamed1950() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1950(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

buildUnnamed1951() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1951(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

buildUnnamed1952() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1952(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterRouterStatusNatStatus = 0;
buildRouterStatusNatStatus() {
  var o = new api.RouterStatusNatStatus();
  buildCounterRouterStatusNatStatus++;
  if (buildCounterRouterStatusNatStatus < 3) {
    o.autoAllocatedNatIps = buildUnnamed1950();
    o.minExtraNatIpsNeeded = 42;
    o.name = "foo";
    o.numVmEndpointsWithNatMappings = 42;
    o.userAllocatedNatIpResources = buildUnnamed1951();
    o.userAllocatedNatIps = buildUnnamed1952();
  }
  buildCounterRouterStatusNatStatus--;
  return o;
}

checkRouterStatusNatStatus(api.RouterStatusNatStatus o) {
  buildCounterRouterStatusNatStatus++;
  if (buildCounterRouterStatusNatStatus < 3) {
    checkUnnamed1950(o.autoAllocatedNatIps);
    unittest.expect(o.minExtraNatIpsNeeded, unittest.equals(42));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.numVmEndpointsWithNatMappings, unittest.equals(42));
    checkUnnamed1951(o.userAllocatedNatIpResources);
    checkUnnamed1952(o.userAllocatedNatIps);
  }
  buildCounterRouterStatusNatStatus--;
}

core.int buildCounterRouterStatusResponse = 0;
buildRouterStatusResponse() {
  var o = new api.RouterStatusResponse();
  buildCounterRouterStatusResponse++;
  if (buildCounterRouterStatusResponse < 3) {
    o.kind = "foo";
    o.result = buildRouterStatus();
  }
  buildCounterRouterStatusResponse--;
  return o;
}

checkRouterStatusResponse(api.RouterStatusResponse o) {
  buildCounterRouterStatusResponse++;
  if (buildCounterRouterStatusResponse < 3) {
    unittest.expect(o.kind, unittest.equals('foo'));
    checkRouterStatus(o.result);
  }
  buildCounterRouterStatusResponse--;
}

core.int buildCounterRoutersPreviewResponse = 0;
buildRoutersPreviewResponse() {
  var o = new api.RoutersPreviewResponse();
  buildCounterRoutersPreviewResponse++;
  if (buildCounterRoutersPreviewResponse < 3) {
    o.resource = buildRouter();
  }
  buildCounterRoutersPreviewResponse--;
  return o;
}

checkRoutersPreviewResponse(api.RoutersPreviewResponse o) {
  buildCounterRoutersPreviewResponse++;
  if (buildCounterRoutersPreviewResponse < 3) {
    checkRouter(o.resource);
  }
  buildCounterRoutersPreviewResponse--;
}

buildUnnamed1953() {
  var o = new core.List<api.Router>();
  o.add(buildRouter());
  o.add(buildRouter());
  return o;
}

checkUnnamed1953(core.List<api.Router> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouter(o[0]);
  checkRouter(o[1]);
}

core.int buildCounterRoutersScopedListWarningData = 0;
buildRoutersScopedListWarningData() {
  var o = new api.RoutersScopedListWarningData();
  buildCounterRoutersScopedListWarningData++;
  if (buildCounterRoutersScopedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterRoutersScopedListWarningData--;
  return o;
}

checkRoutersScopedListWarningData(api.RoutersScopedListWarningData o) {
  buildCounterRoutersScopedListWarningData++;
  if (buildCounterRoutersScopedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterRoutersScopedListWarningData--;
}

buildUnnamed1954() {
  var o = new core.List<api.RoutersScopedListWarningData>();
  o.add(buildRoutersScopedListWarningData());
  o.add(buildRoutersScopedListWarningData());
  return o;
}

checkUnnamed1954(core.List<api.RoutersScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRoutersScopedListWarningData(o[0]);
  checkRoutersScopedListWarningData(o[1]);
}

core.int buildCounterRoutersScopedListWarning = 0;
buildRoutersScopedListWarning() {
  var o = new api.RoutersScopedListWarning();
  buildCounterRoutersScopedListWarning++;
  if (buildCounterRoutersScopedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1954();
    o.message = "foo";
  }
  buildCounterRoutersScopedListWarning--;
  return o;
}

checkRoutersScopedListWarning(api.RoutersScopedListWarning o) {
  buildCounterRoutersScopedListWarning++;
  if (buildCounterRoutersScopedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1954(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterRoutersScopedListWarning--;
}

core.int buildCounterRoutersScopedList = 0;
buildRoutersScopedList() {
  var o = new api.RoutersScopedList();
  buildCounterRoutersScopedList++;
  if (buildCounterRoutersScopedList < 3) {
    o.routers = buildUnnamed1953();
    o.warning = buildRoutersScopedListWarning();
  }
  buildCounterRoutersScopedList--;
  return o;
}

checkRoutersScopedList(api.RoutersScopedList o) {
  buildCounterRoutersScopedList++;
  if (buildCounterRoutersScopedList < 3) {
    checkUnnamed1953(o.routers);
    checkRoutersScopedListWarning(o.warning);
  }
  buildCounterRoutersScopedList--;
}

buildUnnamed1955() {
  var o = new core.List<api.Condition>();
  o.add(buildCondition());
  o.add(buildCondition());
  return o;
}

checkUnnamed1955(core.List<api.Condition> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkCondition(o[0]);
  checkCondition(o[1]);
}

buildUnnamed1956() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1956(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

buildUnnamed1957() {
  var o = new core.List<api.LogConfig>();
  o.add(buildLogConfig());
  o.add(buildLogConfig());
  return o;
}

checkUnnamed1957(core.List<api.LogConfig> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkLogConfig(o[0]);
  checkLogConfig(o[1]);
}

buildUnnamed1958() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1958(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

buildUnnamed1959() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1959(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterRule = 0;
buildRule() {
  var o = new api.Rule();
  buildCounterRule++;
  if (buildCounterRule < 3) {
    o.action = "foo";
    o.conditions = buildUnnamed1955();
    o.description = "foo";
    o.ins = buildUnnamed1956();
    o.logConfigs = buildUnnamed1957();
    o.notIns = buildUnnamed1958();
    o.permissions = buildUnnamed1959();
  }
  buildCounterRule--;
  return o;
}

checkRule(api.Rule o) {
  buildCounterRule++;
  if (buildCounterRule < 3) {
    unittest.expect(o.action, unittest.equals('foo'));
    checkUnnamed1955(o.conditions);
    unittest.expect(o.description, unittest.equals('foo'));
    checkUnnamed1956(o.ins);
    checkUnnamed1957(o.logConfigs);
    checkUnnamed1958(o.notIns);
    checkUnnamed1959(o.permissions);
  }
  buildCounterRule--;
}

core.int buildCounterSSLHealthCheck = 0;
buildSSLHealthCheck() {
  var o = new api.SSLHealthCheck();
  buildCounterSSLHealthCheck++;
  if (buildCounterSSLHealthCheck < 3) {
    o.port = 42;
    o.portName = "foo";
    o.portSpecification = "foo";
    o.proxyHeader = "foo";
    o.request = "foo";
    o.response = "foo";
  }
  buildCounterSSLHealthCheck--;
  return o;
}

checkSSLHealthCheck(api.SSLHealthCheck o) {
  buildCounterSSLHealthCheck++;
  if (buildCounterSSLHealthCheck < 3) {
    unittest.expect(o.port, unittest.equals(42));
    unittest.expect(o.portName, unittest.equals('foo'));
    unittest.expect(o.portSpecification, unittest.equals('foo'));
    unittest.expect(o.proxyHeader, unittest.equals('foo'));
    unittest.expect(o.request, unittest.equals('foo'));
    unittest.expect(o.response, unittest.equals('foo'));
  }
  buildCounterSSLHealthCheck--;
}

buildUnnamed1960() {
  var o = new core.List<api.SchedulingNodeAffinity>();
  o.add(buildSchedulingNodeAffinity());
  o.add(buildSchedulingNodeAffinity());
  return o;
}

checkUnnamed1960(core.List<api.SchedulingNodeAffinity> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSchedulingNodeAffinity(o[0]);
  checkSchedulingNodeAffinity(o[1]);
}

core.int buildCounterScheduling = 0;
buildScheduling() {
  var o = new api.Scheduling();
  buildCounterScheduling++;
  if (buildCounterScheduling < 3) {
    o.automaticRestart = true;
    o.nodeAffinities = buildUnnamed1960();
    o.onHostMaintenance = "foo";
    o.preemptible = true;
  }
  buildCounterScheduling--;
  return o;
}

checkScheduling(api.Scheduling o) {
  buildCounterScheduling++;
  if (buildCounterScheduling < 3) {
    unittest.expect(o.automaticRestart, unittest.isTrue);
    checkUnnamed1960(o.nodeAffinities);
    unittest.expect(o.onHostMaintenance, unittest.equals('foo'));
    unittest.expect(o.preemptible, unittest.isTrue);
  }
  buildCounterScheduling--;
}

buildUnnamed1961() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1961(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterSchedulingNodeAffinity = 0;
buildSchedulingNodeAffinity() {
  var o = new api.SchedulingNodeAffinity();
  buildCounterSchedulingNodeAffinity++;
  if (buildCounterSchedulingNodeAffinity < 3) {
    o.key = "foo";
    o.operator = "foo";
    o.values = buildUnnamed1961();
  }
  buildCounterSchedulingNodeAffinity--;
  return o;
}

checkSchedulingNodeAffinity(api.SchedulingNodeAffinity o) {
  buildCounterSchedulingNodeAffinity++;
  if (buildCounterSchedulingNodeAffinity < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.operator, unittest.equals('foo'));
    checkUnnamed1961(o.values);
  }
  buildCounterSchedulingNodeAffinity--;
}

buildUnnamed1962() {
  var o = new core.List<api.SecurityPolicyRule>();
  o.add(buildSecurityPolicyRule());
  o.add(buildSecurityPolicyRule());
  return o;
}

checkUnnamed1962(core.List<api.SecurityPolicyRule> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSecurityPolicyRule(o[0]);
  checkSecurityPolicyRule(o[1]);
}

core.int buildCounterSecurityPolicy = 0;
buildSecurityPolicy() {
  var o = new api.SecurityPolicy();
  buildCounterSecurityPolicy++;
  if (buildCounterSecurityPolicy < 3) {
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.fingerprint = "foo";
    o.id = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.rules = buildUnnamed1962();
    o.selfLink = "foo";
  }
  buildCounterSecurityPolicy--;
  return o;
}

checkSecurityPolicy(api.SecurityPolicy o) {
  buildCounterSecurityPolicy++;
  if (buildCounterSecurityPolicy < 3) {
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.fingerprint, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    checkUnnamed1962(o.rules);
    unittest.expect(o.selfLink, unittest.equals('foo'));
  }
  buildCounterSecurityPolicy--;
}

buildUnnamed1963() {
  var o = new core.List<api.SecurityPolicy>();
  o.add(buildSecurityPolicy());
  o.add(buildSecurityPolicy());
  return o;
}

checkUnnamed1963(core.List<api.SecurityPolicy> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSecurityPolicy(o[0]);
  checkSecurityPolicy(o[1]);
}

core.int buildCounterSecurityPolicyListWarningData = 0;
buildSecurityPolicyListWarningData() {
  var o = new api.SecurityPolicyListWarningData();
  buildCounterSecurityPolicyListWarningData++;
  if (buildCounterSecurityPolicyListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterSecurityPolicyListWarningData--;
  return o;
}

checkSecurityPolicyListWarningData(api.SecurityPolicyListWarningData o) {
  buildCounterSecurityPolicyListWarningData++;
  if (buildCounterSecurityPolicyListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterSecurityPolicyListWarningData--;
}

buildUnnamed1964() {
  var o = new core.List<api.SecurityPolicyListWarningData>();
  o.add(buildSecurityPolicyListWarningData());
  o.add(buildSecurityPolicyListWarningData());
  return o;
}

checkUnnamed1964(core.List<api.SecurityPolicyListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSecurityPolicyListWarningData(o[0]);
  checkSecurityPolicyListWarningData(o[1]);
}

core.int buildCounterSecurityPolicyListWarning = 0;
buildSecurityPolicyListWarning() {
  var o = new api.SecurityPolicyListWarning();
  buildCounterSecurityPolicyListWarning++;
  if (buildCounterSecurityPolicyListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1964();
    o.message = "foo";
  }
  buildCounterSecurityPolicyListWarning--;
  return o;
}

checkSecurityPolicyListWarning(api.SecurityPolicyListWarning o) {
  buildCounterSecurityPolicyListWarning++;
  if (buildCounterSecurityPolicyListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1964(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterSecurityPolicyListWarning--;
}

core.int buildCounterSecurityPolicyList = 0;
buildSecurityPolicyList() {
  var o = new api.SecurityPolicyList();
  buildCounterSecurityPolicyList++;
  if (buildCounterSecurityPolicyList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1963();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.warning = buildSecurityPolicyListWarning();
  }
  buildCounterSecurityPolicyList--;
  return o;
}

checkSecurityPolicyList(api.SecurityPolicyList o) {
  buildCounterSecurityPolicyList++;
  if (buildCounterSecurityPolicyList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1963(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    checkSecurityPolicyListWarning(o.warning);
  }
  buildCounterSecurityPolicyList--;
}

core.int buildCounterSecurityPolicyReference = 0;
buildSecurityPolicyReference() {
  var o = new api.SecurityPolicyReference();
  buildCounterSecurityPolicyReference++;
  if (buildCounterSecurityPolicyReference < 3) {
    o.securityPolicy = "foo";
  }
  buildCounterSecurityPolicyReference--;
  return o;
}

checkSecurityPolicyReference(api.SecurityPolicyReference o) {
  buildCounterSecurityPolicyReference++;
  if (buildCounterSecurityPolicyReference < 3) {
    unittest.expect(o.securityPolicy, unittest.equals('foo'));
  }
  buildCounterSecurityPolicyReference--;
}

core.int buildCounterSecurityPolicyRule = 0;
buildSecurityPolicyRule() {
  var o = new api.SecurityPolicyRule();
  buildCounterSecurityPolicyRule++;
  if (buildCounterSecurityPolicyRule < 3) {
    o.action = "foo";
    o.description = "foo";
    o.kind = "foo";
    o.match = buildSecurityPolicyRuleMatcher();
    o.preview = true;
    o.priority = 42;
  }
  buildCounterSecurityPolicyRule--;
  return o;
}

checkSecurityPolicyRule(api.SecurityPolicyRule o) {
  buildCounterSecurityPolicyRule++;
  if (buildCounterSecurityPolicyRule < 3) {
    unittest.expect(o.action, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    checkSecurityPolicyRuleMatcher(o.match);
    unittest.expect(o.preview, unittest.isTrue);
    unittest.expect(o.priority, unittest.equals(42));
  }
  buildCounterSecurityPolicyRule--;
}

core.int buildCounterSecurityPolicyRuleMatcher = 0;
buildSecurityPolicyRuleMatcher() {
  var o = new api.SecurityPolicyRuleMatcher();
  buildCounterSecurityPolicyRuleMatcher++;
  if (buildCounterSecurityPolicyRuleMatcher < 3) {
    o.config = buildSecurityPolicyRuleMatcherConfig();
    o.versionedExpr = "foo";
  }
  buildCounterSecurityPolicyRuleMatcher--;
  return o;
}

checkSecurityPolicyRuleMatcher(api.SecurityPolicyRuleMatcher o) {
  buildCounterSecurityPolicyRuleMatcher++;
  if (buildCounterSecurityPolicyRuleMatcher < 3) {
    checkSecurityPolicyRuleMatcherConfig(o.config);
    unittest.expect(o.versionedExpr, unittest.equals('foo'));
  }
  buildCounterSecurityPolicyRuleMatcher--;
}

buildUnnamed1965() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1965(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterSecurityPolicyRuleMatcherConfig = 0;
buildSecurityPolicyRuleMatcherConfig() {
  var o = new api.SecurityPolicyRuleMatcherConfig();
  buildCounterSecurityPolicyRuleMatcherConfig++;
  if (buildCounterSecurityPolicyRuleMatcherConfig < 3) {
    o.srcIpRanges = buildUnnamed1965();
  }
  buildCounterSecurityPolicyRuleMatcherConfig--;
  return o;
}

checkSecurityPolicyRuleMatcherConfig(api.SecurityPolicyRuleMatcherConfig o) {
  buildCounterSecurityPolicyRuleMatcherConfig++;
  if (buildCounterSecurityPolicyRuleMatcherConfig < 3) {
    checkUnnamed1965(o.srcIpRanges);
  }
  buildCounterSecurityPolicyRuleMatcherConfig--;
}

core.int buildCounterSerialPortOutput = 0;
buildSerialPortOutput() {
  var o = new api.SerialPortOutput();
  buildCounterSerialPortOutput++;
  if (buildCounterSerialPortOutput < 3) {
    o.contents = "foo";
    o.kind = "foo";
    o.next = "foo";
    o.selfLink = "foo";
    o.start = "foo";
  }
  buildCounterSerialPortOutput--;
  return o;
}

checkSerialPortOutput(api.SerialPortOutput o) {
  buildCounterSerialPortOutput++;
  if (buildCounterSerialPortOutput < 3) {
    unittest.expect(o.contents, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.next, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.start, unittest.equals('foo'));
  }
  buildCounterSerialPortOutput--;
}

core.int buildCounterServerBinding = 0;
buildServerBinding() {
  var o = new api.ServerBinding();
  buildCounterServerBinding++;
  if (buildCounterServerBinding < 3) {
    o.type = "foo";
  }
  buildCounterServerBinding--;
  return o;
}

checkServerBinding(api.ServerBinding o) {
  buildCounterServerBinding++;
  if (buildCounterServerBinding < 3) {
    unittest.expect(o.type, unittest.equals('foo'));
  }
  buildCounterServerBinding--;
}

buildUnnamed1966() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1966(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterServiceAccount = 0;
buildServiceAccount() {
  var o = new api.ServiceAccount();
  buildCounterServiceAccount++;
  if (buildCounterServiceAccount < 3) {
    o.email = "foo";
    o.scopes = buildUnnamed1966();
  }
  buildCounterServiceAccount--;
  return o;
}

checkServiceAccount(api.ServiceAccount o) {
  buildCounterServiceAccount++;
  if (buildCounterServiceAccount < 3) {
    unittest.expect(o.email, unittest.equals('foo'));
    checkUnnamed1966(o.scopes);
  }
  buildCounterServiceAccount--;
}

core.int buildCounterShieldedInstanceConfig = 0;
buildShieldedInstanceConfig() {
  var o = new api.ShieldedInstanceConfig();
  buildCounterShieldedInstanceConfig++;
  if (buildCounterShieldedInstanceConfig < 3) {
    o.enableIntegrityMonitoring = true;
    o.enableSecureBoot = true;
    o.enableVtpm = true;
  }
  buildCounterShieldedInstanceConfig--;
  return o;
}

checkShieldedInstanceConfig(api.ShieldedInstanceConfig o) {
  buildCounterShieldedInstanceConfig++;
  if (buildCounterShieldedInstanceConfig < 3) {
    unittest.expect(o.enableIntegrityMonitoring, unittest.isTrue);
    unittest.expect(o.enableSecureBoot, unittest.isTrue);
    unittest.expect(o.enableVtpm, unittest.isTrue);
  }
  buildCounterShieldedInstanceConfig--;
}

core.int buildCounterShieldedInstanceIdentity = 0;
buildShieldedInstanceIdentity() {
  var o = new api.ShieldedInstanceIdentity();
  buildCounterShieldedInstanceIdentity++;
  if (buildCounterShieldedInstanceIdentity < 3) {
    o.encryptionKey = buildShieldedInstanceIdentityEntry();
    o.kind = "foo";
    o.signingKey = buildShieldedInstanceIdentityEntry();
  }
  buildCounterShieldedInstanceIdentity--;
  return o;
}

checkShieldedInstanceIdentity(api.ShieldedInstanceIdentity o) {
  buildCounterShieldedInstanceIdentity++;
  if (buildCounterShieldedInstanceIdentity < 3) {
    checkShieldedInstanceIdentityEntry(o.encryptionKey);
    unittest.expect(o.kind, unittest.equals('foo'));
    checkShieldedInstanceIdentityEntry(o.signingKey);
  }
  buildCounterShieldedInstanceIdentity--;
}

core.int buildCounterShieldedInstanceIdentityEntry = 0;
buildShieldedInstanceIdentityEntry() {
  var o = new api.ShieldedInstanceIdentityEntry();
  buildCounterShieldedInstanceIdentityEntry++;
  if (buildCounterShieldedInstanceIdentityEntry < 3) {
    o.ekCert = "foo";
    o.ekPub = "foo";
  }
  buildCounterShieldedInstanceIdentityEntry--;
  return o;
}

checkShieldedInstanceIdentityEntry(api.ShieldedInstanceIdentityEntry o) {
  buildCounterShieldedInstanceIdentityEntry++;
  if (buildCounterShieldedInstanceIdentityEntry < 3) {
    unittest.expect(o.ekCert, unittest.equals('foo'));
    unittest.expect(o.ekPub, unittest.equals('foo'));
  }
  buildCounterShieldedInstanceIdentityEntry--;
}

core.int buildCounterShieldedInstanceIntegrityPolicy = 0;
buildShieldedInstanceIntegrityPolicy() {
  var o = new api.ShieldedInstanceIntegrityPolicy();
  buildCounterShieldedInstanceIntegrityPolicy++;
  if (buildCounterShieldedInstanceIntegrityPolicy < 3) {
    o.updateAutoLearnPolicy = true;
  }
  buildCounterShieldedInstanceIntegrityPolicy--;
  return o;
}

checkShieldedInstanceIntegrityPolicy(api.ShieldedInstanceIntegrityPolicy o) {
  buildCounterShieldedInstanceIntegrityPolicy++;
  if (buildCounterShieldedInstanceIntegrityPolicy < 3) {
    unittest.expect(o.updateAutoLearnPolicy, unittest.isTrue);
  }
  buildCounterShieldedInstanceIntegrityPolicy--;
}

core.int buildCounterSignedUrlKey = 0;
buildSignedUrlKey() {
  var o = new api.SignedUrlKey();
  buildCounterSignedUrlKey++;
  if (buildCounterSignedUrlKey < 3) {
    o.keyName = "foo";
    o.keyValue = "foo";
  }
  buildCounterSignedUrlKey--;
  return o;
}

checkSignedUrlKey(api.SignedUrlKey o) {
  buildCounterSignedUrlKey++;
  if (buildCounterSignedUrlKey < 3) {
    unittest.expect(o.keyName, unittest.equals('foo'));
    unittest.expect(o.keyValue, unittest.equals('foo'));
  }
  buildCounterSignedUrlKey--;
}

buildUnnamed1967() {
  var o = new core.Map<core.String, core.String>();
  o["x"] = "foo";
  o["y"] = "foo";
  return o;
}

checkUnnamed1967(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o["x"], unittest.equals('foo'));
  unittest.expect(o["y"], unittest.equals('foo'));
}

buildUnnamed1968() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1968(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

buildUnnamed1969() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1969(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

buildUnnamed1970() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1970(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterSnapshot = 0;
buildSnapshot() {
  var o = new api.Snapshot();
  buildCounterSnapshot++;
  if (buildCounterSnapshot < 3) {
    o.autoCreated = true;
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.diskSizeGb = "foo";
    o.id = "foo";
    o.kind = "foo";
    o.labelFingerprint = "foo";
    o.labels = buildUnnamed1967();
    o.licenseCodes = buildUnnamed1968();
    o.licenses = buildUnnamed1969();
    o.name = "foo";
    o.selfLink = "foo";
    o.snapshotEncryptionKey = buildCustomerEncryptionKey();
    o.sourceDisk = "foo";
    o.sourceDiskEncryptionKey = buildCustomerEncryptionKey();
    o.sourceDiskId = "foo";
    o.status = "foo";
    o.storageBytes = "foo";
    o.storageBytesStatus = "foo";
    o.storageLocations = buildUnnamed1970();
  }
  buildCounterSnapshot--;
  return o;
}

checkSnapshot(api.Snapshot o) {
  buildCounterSnapshot++;
  if (buildCounterSnapshot < 3) {
    unittest.expect(o.autoCreated, unittest.isTrue);
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.diskSizeGb, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.labelFingerprint, unittest.equals('foo'));
    checkUnnamed1967(o.labels);
    checkUnnamed1968(o.licenseCodes);
    checkUnnamed1969(o.licenses);
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkCustomerEncryptionKey(o.snapshotEncryptionKey);
    unittest.expect(o.sourceDisk, unittest.equals('foo'));
    checkCustomerEncryptionKey(o.sourceDiskEncryptionKey);
    unittest.expect(o.sourceDiskId, unittest.equals('foo'));
    unittest.expect(o.status, unittest.equals('foo'));
    unittest.expect(o.storageBytes, unittest.equals('foo'));
    unittest.expect(o.storageBytesStatus, unittest.equals('foo'));
    checkUnnamed1970(o.storageLocations);
  }
  buildCounterSnapshot--;
}

buildUnnamed1971() {
  var o = new core.List<api.Snapshot>();
  o.add(buildSnapshot());
  o.add(buildSnapshot());
  return o;
}

checkUnnamed1971(core.List<api.Snapshot> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSnapshot(o[0]);
  checkSnapshot(o[1]);
}

core.int buildCounterSnapshotListWarningData = 0;
buildSnapshotListWarningData() {
  var o = new api.SnapshotListWarningData();
  buildCounterSnapshotListWarningData++;
  if (buildCounterSnapshotListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterSnapshotListWarningData--;
  return o;
}

checkSnapshotListWarningData(api.SnapshotListWarningData o) {
  buildCounterSnapshotListWarningData++;
  if (buildCounterSnapshotListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterSnapshotListWarningData--;
}

buildUnnamed1972() {
  var o = new core.List<api.SnapshotListWarningData>();
  o.add(buildSnapshotListWarningData());
  o.add(buildSnapshotListWarningData());
  return o;
}

checkUnnamed1972(core.List<api.SnapshotListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSnapshotListWarningData(o[0]);
  checkSnapshotListWarningData(o[1]);
}

core.int buildCounterSnapshotListWarning = 0;
buildSnapshotListWarning() {
  var o = new api.SnapshotListWarning();
  buildCounterSnapshotListWarning++;
  if (buildCounterSnapshotListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1972();
    o.message = "foo";
  }
  buildCounterSnapshotListWarning--;
  return o;
}

checkSnapshotListWarning(api.SnapshotListWarning o) {
  buildCounterSnapshotListWarning++;
  if (buildCounterSnapshotListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1972(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterSnapshotListWarning--;
}

core.int buildCounterSnapshotList = 0;
buildSnapshotList() {
  var o = new api.SnapshotList();
  buildCounterSnapshotList++;
  if (buildCounterSnapshotList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1971();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildSnapshotListWarning();
  }
  buildCounterSnapshotList--;
  return o;
}

checkSnapshotList(api.SnapshotList o) {
  buildCounterSnapshotList++;
  if (buildCounterSnapshotList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1971(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkSnapshotListWarning(o.warning);
  }
  buildCounterSnapshotList--;
}

buildUnnamed1973() {
  var o = new core.List<api.DiskInstantiationConfig>();
  o.add(buildDiskInstantiationConfig());
  o.add(buildDiskInstantiationConfig());
  return o;
}

checkUnnamed1973(core.List<api.DiskInstantiationConfig> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkDiskInstantiationConfig(o[0]);
  checkDiskInstantiationConfig(o[1]);
}

core.int buildCounterSourceInstanceParams = 0;
buildSourceInstanceParams() {
  var o = new api.SourceInstanceParams();
  buildCounterSourceInstanceParams++;
  if (buildCounterSourceInstanceParams < 3) {
    o.diskConfigs = buildUnnamed1973();
  }
  buildCounterSourceInstanceParams--;
  return o;
}

checkSourceInstanceParams(api.SourceInstanceParams o) {
  buildCounterSourceInstanceParams++;
  if (buildCounterSourceInstanceParams < 3) {
    checkUnnamed1973(o.diskConfigs);
  }
  buildCounterSourceInstanceParams--;
}

core.int buildCounterSslCertificate = 0;
buildSslCertificate() {
  var o = new api.SslCertificate();
  buildCounterSslCertificate++;
  if (buildCounterSslCertificate < 3) {
    o.certificate = "foo";
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.id = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.privateKey = "foo";
    o.selfLink = "foo";
  }
  buildCounterSslCertificate--;
  return o;
}

checkSslCertificate(api.SslCertificate o) {
  buildCounterSslCertificate++;
  if (buildCounterSslCertificate < 3) {
    unittest.expect(o.certificate, unittest.equals('foo'));
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.privateKey, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
  }
  buildCounterSslCertificate--;
}

buildUnnamed1974() {
  var o = new core.List<api.SslCertificate>();
  o.add(buildSslCertificate());
  o.add(buildSslCertificate());
  return o;
}

checkUnnamed1974(core.List<api.SslCertificate> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSslCertificate(o[0]);
  checkSslCertificate(o[1]);
}

core.int buildCounterSslCertificateListWarningData = 0;
buildSslCertificateListWarningData() {
  var o = new api.SslCertificateListWarningData();
  buildCounterSslCertificateListWarningData++;
  if (buildCounterSslCertificateListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterSslCertificateListWarningData--;
  return o;
}

checkSslCertificateListWarningData(api.SslCertificateListWarningData o) {
  buildCounterSslCertificateListWarningData++;
  if (buildCounterSslCertificateListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterSslCertificateListWarningData--;
}

buildUnnamed1975() {
  var o = new core.List<api.SslCertificateListWarningData>();
  o.add(buildSslCertificateListWarningData());
  o.add(buildSslCertificateListWarningData());
  return o;
}

checkUnnamed1975(core.List<api.SslCertificateListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSslCertificateListWarningData(o[0]);
  checkSslCertificateListWarningData(o[1]);
}

core.int buildCounterSslCertificateListWarning = 0;
buildSslCertificateListWarning() {
  var o = new api.SslCertificateListWarning();
  buildCounterSslCertificateListWarning++;
  if (buildCounterSslCertificateListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1975();
    o.message = "foo";
  }
  buildCounterSslCertificateListWarning--;
  return o;
}

checkSslCertificateListWarning(api.SslCertificateListWarning o) {
  buildCounterSslCertificateListWarning++;
  if (buildCounterSslCertificateListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1975(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterSslCertificateListWarning--;
}

core.int buildCounterSslCertificateList = 0;
buildSslCertificateList() {
  var o = new api.SslCertificateList();
  buildCounterSslCertificateList++;
  if (buildCounterSslCertificateList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1974();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildSslCertificateListWarning();
  }
  buildCounterSslCertificateList--;
  return o;
}

checkSslCertificateList(api.SslCertificateList o) {
  buildCounterSslCertificateList++;
  if (buildCounterSslCertificateList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1974(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkSslCertificateListWarning(o.warning);
  }
  buildCounterSslCertificateList--;
}

buildUnnamed1976() {
  var o = new core.List<api.SslPolicy>();
  o.add(buildSslPolicy());
  o.add(buildSslPolicy());
  return o;
}

checkUnnamed1976(core.List<api.SslPolicy> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSslPolicy(o[0]);
  checkSslPolicy(o[1]);
}

core.int buildCounterSslPoliciesListWarningData = 0;
buildSslPoliciesListWarningData() {
  var o = new api.SslPoliciesListWarningData();
  buildCounterSslPoliciesListWarningData++;
  if (buildCounterSslPoliciesListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterSslPoliciesListWarningData--;
  return o;
}

checkSslPoliciesListWarningData(api.SslPoliciesListWarningData o) {
  buildCounterSslPoliciesListWarningData++;
  if (buildCounterSslPoliciesListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterSslPoliciesListWarningData--;
}

buildUnnamed1977() {
  var o = new core.List<api.SslPoliciesListWarningData>();
  o.add(buildSslPoliciesListWarningData());
  o.add(buildSslPoliciesListWarningData());
  return o;
}

checkUnnamed1977(core.List<api.SslPoliciesListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSslPoliciesListWarningData(o[0]);
  checkSslPoliciesListWarningData(o[1]);
}

core.int buildCounterSslPoliciesListWarning = 0;
buildSslPoliciesListWarning() {
  var o = new api.SslPoliciesListWarning();
  buildCounterSslPoliciesListWarning++;
  if (buildCounterSslPoliciesListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1977();
    o.message = "foo";
  }
  buildCounterSslPoliciesListWarning--;
  return o;
}

checkSslPoliciesListWarning(api.SslPoliciesListWarning o) {
  buildCounterSslPoliciesListWarning++;
  if (buildCounterSslPoliciesListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1977(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterSslPoliciesListWarning--;
}

core.int buildCounterSslPoliciesList = 0;
buildSslPoliciesList() {
  var o = new api.SslPoliciesList();
  buildCounterSslPoliciesList++;
  if (buildCounterSslPoliciesList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1976();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildSslPoliciesListWarning();
  }
  buildCounterSslPoliciesList--;
  return o;
}

checkSslPoliciesList(api.SslPoliciesList o) {
  buildCounterSslPoliciesList++;
  if (buildCounterSslPoliciesList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1976(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkSslPoliciesListWarning(o.warning);
  }
  buildCounterSslPoliciesList--;
}

buildUnnamed1978() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1978(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterSslPoliciesListAvailableFeaturesResponse = 0;
buildSslPoliciesListAvailableFeaturesResponse() {
  var o = new api.SslPoliciesListAvailableFeaturesResponse();
  buildCounterSslPoliciesListAvailableFeaturesResponse++;
  if (buildCounterSslPoliciesListAvailableFeaturesResponse < 3) {
    o.features = buildUnnamed1978();
  }
  buildCounterSslPoliciesListAvailableFeaturesResponse--;
  return o;
}

checkSslPoliciesListAvailableFeaturesResponse(
    api.SslPoliciesListAvailableFeaturesResponse o) {
  buildCounterSslPoliciesListAvailableFeaturesResponse++;
  if (buildCounterSslPoliciesListAvailableFeaturesResponse < 3) {
    checkUnnamed1978(o.features);
  }
  buildCounterSslPoliciesListAvailableFeaturesResponse--;
}

buildUnnamed1979() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1979(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

buildUnnamed1980() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1980(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterSslPolicyWarningsData = 0;
buildSslPolicyWarningsData() {
  var o = new api.SslPolicyWarningsData();
  buildCounterSslPolicyWarningsData++;
  if (buildCounterSslPolicyWarningsData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterSslPolicyWarningsData--;
  return o;
}

checkSslPolicyWarningsData(api.SslPolicyWarningsData o) {
  buildCounterSslPolicyWarningsData++;
  if (buildCounterSslPolicyWarningsData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterSslPolicyWarningsData--;
}

buildUnnamed1981() {
  var o = new core.List<api.SslPolicyWarningsData>();
  o.add(buildSslPolicyWarningsData());
  o.add(buildSslPolicyWarningsData());
  return o;
}

checkUnnamed1981(core.List<api.SslPolicyWarningsData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSslPolicyWarningsData(o[0]);
  checkSslPolicyWarningsData(o[1]);
}

core.int buildCounterSslPolicyWarnings = 0;
buildSslPolicyWarnings() {
  var o = new api.SslPolicyWarnings();
  buildCounterSslPolicyWarnings++;
  if (buildCounterSslPolicyWarnings < 3) {
    o.code = "foo";
    o.data = buildUnnamed1981();
    o.message = "foo";
  }
  buildCounterSslPolicyWarnings--;
  return o;
}

checkSslPolicyWarnings(api.SslPolicyWarnings o) {
  buildCounterSslPolicyWarnings++;
  if (buildCounterSslPolicyWarnings < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1981(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterSslPolicyWarnings--;
}

buildUnnamed1982() {
  var o = new core.List<api.SslPolicyWarnings>();
  o.add(buildSslPolicyWarnings());
  o.add(buildSslPolicyWarnings());
  return o;
}

checkUnnamed1982(core.List<api.SslPolicyWarnings> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSslPolicyWarnings(o[0]);
  checkSslPolicyWarnings(o[1]);
}

core.int buildCounterSslPolicy = 0;
buildSslPolicy() {
  var o = new api.SslPolicy();
  buildCounterSslPolicy++;
  if (buildCounterSslPolicy < 3) {
    o.creationTimestamp = "foo";
    o.customFeatures = buildUnnamed1979();
    o.description = "foo";
    o.enabledFeatures = buildUnnamed1980();
    o.fingerprint = "foo";
    o.id = "foo";
    o.kind = "foo";
    o.minTlsVersion = "foo";
    o.name = "foo";
    o.profile = "foo";
    o.selfLink = "foo";
    o.warnings = buildUnnamed1982();
  }
  buildCounterSslPolicy--;
  return o;
}

checkSslPolicy(api.SslPolicy o) {
  buildCounterSslPolicy++;
  if (buildCounterSslPolicy < 3) {
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    checkUnnamed1979(o.customFeatures);
    unittest.expect(o.description, unittest.equals('foo'));
    checkUnnamed1980(o.enabledFeatures);
    unittest.expect(o.fingerprint, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.minTlsVersion, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.profile, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkUnnamed1982(o.warnings);
  }
  buildCounterSslPolicy--;
}

core.int buildCounterSslPolicyReference = 0;
buildSslPolicyReference() {
  var o = new api.SslPolicyReference();
  buildCounterSslPolicyReference++;
  if (buildCounterSslPolicyReference < 3) {
    o.sslPolicy = "foo";
  }
  buildCounterSslPolicyReference--;
  return o;
}

checkSslPolicyReference(api.SslPolicyReference o) {
  buildCounterSslPolicyReference++;
  if (buildCounterSslPolicyReference < 3) {
    unittest.expect(o.sslPolicy, unittest.equals('foo'));
  }
  buildCounterSslPolicyReference--;
}

buildUnnamed1983() {
  var o = new core.List<api.SubnetworkSecondaryRange>();
  o.add(buildSubnetworkSecondaryRange());
  o.add(buildSubnetworkSecondaryRange());
  return o;
}

checkUnnamed1983(core.List<api.SubnetworkSecondaryRange> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSubnetworkSecondaryRange(o[0]);
  checkSubnetworkSecondaryRange(o[1]);
}

core.int buildCounterSubnetwork = 0;
buildSubnetwork() {
  var o = new api.Subnetwork();
  buildCounterSubnetwork++;
  if (buildCounterSubnetwork < 3) {
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.enableFlowLogs = true;
    o.fingerprint = "foo";
    o.gatewayAddress = "foo";
    o.id = "foo";
    o.ipCidrRange = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.network = "foo";
    o.privateIpGoogleAccess = true;
    o.region = "foo";
    o.secondaryIpRanges = buildUnnamed1983();
    o.selfLink = "foo";
  }
  buildCounterSubnetwork--;
  return o;
}

checkSubnetwork(api.Subnetwork o) {
  buildCounterSubnetwork++;
  if (buildCounterSubnetwork < 3) {
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.enableFlowLogs, unittest.isTrue);
    unittest.expect(o.fingerprint, unittest.equals('foo'));
    unittest.expect(o.gatewayAddress, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.ipCidrRange, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.network, unittest.equals('foo'));
    unittest.expect(o.privateIpGoogleAccess, unittest.isTrue);
    unittest.expect(o.region, unittest.equals('foo'));
    checkUnnamed1983(o.secondaryIpRanges);
    unittest.expect(o.selfLink, unittest.equals('foo'));
  }
  buildCounterSubnetwork--;
}

buildUnnamed1984() {
  var o = new core.Map<core.String, api.SubnetworksScopedList>();
  o["x"] = buildSubnetworksScopedList();
  o["y"] = buildSubnetworksScopedList();
  return o;
}

checkUnnamed1984(core.Map<core.String, api.SubnetworksScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSubnetworksScopedList(o["x"]);
  checkSubnetworksScopedList(o["y"]);
}

core.int buildCounterSubnetworkAggregatedListWarningData = 0;
buildSubnetworkAggregatedListWarningData() {
  var o = new api.SubnetworkAggregatedListWarningData();
  buildCounterSubnetworkAggregatedListWarningData++;
  if (buildCounterSubnetworkAggregatedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterSubnetworkAggregatedListWarningData--;
  return o;
}

checkSubnetworkAggregatedListWarningData(
    api.SubnetworkAggregatedListWarningData o) {
  buildCounterSubnetworkAggregatedListWarningData++;
  if (buildCounterSubnetworkAggregatedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterSubnetworkAggregatedListWarningData--;
}

buildUnnamed1985() {
  var o = new core.List<api.SubnetworkAggregatedListWarningData>();
  o.add(buildSubnetworkAggregatedListWarningData());
  o.add(buildSubnetworkAggregatedListWarningData());
  return o;
}

checkUnnamed1985(core.List<api.SubnetworkAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSubnetworkAggregatedListWarningData(o[0]);
  checkSubnetworkAggregatedListWarningData(o[1]);
}

core.int buildCounterSubnetworkAggregatedListWarning = 0;
buildSubnetworkAggregatedListWarning() {
  var o = new api.SubnetworkAggregatedListWarning();
  buildCounterSubnetworkAggregatedListWarning++;
  if (buildCounterSubnetworkAggregatedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1985();
    o.message = "foo";
  }
  buildCounterSubnetworkAggregatedListWarning--;
  return o;
}

checkSubnetworkAggregatedListWarning(api.SubnetworkAggregatedListWarning o) {
  buildCounterSubnetworkAggregatedListWarning++;
  if (buildCounterSubnetworkAggregatedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1985(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterSubnetworkAggregatedListWarning--;
}

core.int buildCounterSubnetworkAggregatedList = 0;
buildSubnetworkAggregatedList() {
  var o = new api.SubnetworkAggregatedList();
  buildCounterSubnetworkAggregatedList++;
  if (buildCounterSubnetworkAggregatedList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1984();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildSubnetworkAggregatedListWarning();
  }
  buildCounterSubnetworkAggregatedList--;
  return o;
}

checkSubnetworkAggregatedList(api.SubnetworkAggregatedList o) {
  buildCounterSubnetworkAggregatedList++;
  if (buildCounterSubnetworkAggregatedList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1984(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkSubnetworkAggregatedListWarning(o.warning);
  }
  buildCounterSubnetworkAggregatedList--;
}

buildUnnamed1986() {
  var o = new core.List<api.Subnetwork>();
  o.add(buildSubnetwork());
  o.add(buildSubnetwork());
  return o;
}

checkUnnamed1986(core.List<api.Subnetwork> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSubnetwork(o[0]);
  checkSubnetwork(o[1]);
}

core.int buildCounterSubnetworkListWarningData = 0;
buildSubnetworkListWarningData() {
  var o = new api.SubnetworkListWarningData();
  buildCounterSubnetworkListWarningData++;
  if (buildCounterSubnetworkListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterSubnetworkListWarningData--;
  return o;
}

checkSubnetworkListWarningData(api.SubnetworkListWarningData o) {
  buildCounterSubnetworkListWarningData++;
  if (buildCounterSubnetworkListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterSubnetworkListWarningData--;
}

buildUnnamed1987() {
  var o = new core.List<api.SubnetworkListWarningData>();
  o.add(buildSubnetworkListWarningData());
  o.add(buildSubnetworkListWarningData());
  return o;
}

checkUnnamed1987(core.List<api.SubnetworkListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSubnetworkListWarningData(o[0]);
  checkSubnetworkListWarningData(o[1]);
}

core.int buildCounterSubnetworkListWarning = 0;
buildSubnetworkListWarning() {
  var o = new api.SubnetworkListWarning();
  buildCounterSubnetworkListWarning++;
  if (buildCounterSubnetworkListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1987();
    o.message = "foo";
  }
  buildCounterSubnetworkListWarning--;
  return o;
}

checkSubnetworkListWarning(api.SubnetworkListWarning o) {
  buildCounterSubnetworkListWarning++;
  if (buildCounterSubnetworkListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1987(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterSubnetworkListWarning--;
}

core.int buildCounterSubnetworkList = 0;
buildSubnetworkList() {
  var o = new api.SubnetworkList();
  buildCounterSubnetworkList++;
  if (buildCounterSubnetworkList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1986();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildSubnetworkListWarning();
  }
  buildCounterSubnetworkList--;
  return o;
}

checkSubnetworkList(api.SubnetworkList o) {
  buildCounterSubnetworkList++;
  if (buildCounterSubnetworkList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1986(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkSubnetworkListWarning(o.warning);
  }
  buildCounterSubnetworkList--;
}

core.int buildCounterSubnetworkSecondaryRange = 0;
buildSubnetworkSecondaryRange() {
  var o = new api.SubnetworkSecondaryRange();
  buildCounterSubnetworkSecondaryRange++;
  if (buildCounterSubnetworkSecondaryRange < 3) {
    o.ipCidrRange = "foo";
    o.rangeName = "foo";
  }
  buildCounterSubnetworkSecondaryRange--;
  return o;
}

checkSubnetworkSecondaryRange(api.SubnetworkSecondaryRange o) {
  buildCounterSubnetworkSecondaryRange++;
  if (buildCounterSubnetworkSecondaryRange < 3) {
    unittest.expect(o.ipCidrRange, unittest.equals('foo'));
    unittest.expect(o.rangeName, unittest.equals('foo'));
  }
  buildCounterSubnetworkSecondaryRange--;
}

core.int buildCounterSubnetworksExpandIpCidrRangeRequest = 0;
buildSubnetworksExpandIpCidrRangeRequest() {
  var o = new api.SubnetworksExpandIpCidrRangeRequest();
  buildCounterSubnetworksExpandIpCidrRangeRequest++;
  if (buildCounterSubnetworksExpandIpCidrRangeRequest < 3) {
    o.ipCidrRange = "foo";
  }
  buildCounterSubnetworksExpandIpCidrRangeRequest--;
  return o;
}

checkSubnetworksExpandIpCidrRangeRequest(
    api.SubnetworksExpandIpCidrRangeRequest o) {
  buildCounterSubnetworksExpandIpCidrRangeRequest++;
  if (buildCounterSubnetworksExpandIpCidrRangeRequest < 3) {
    unittest.expect(o.ipCidrRange, unittest.equals('foo'));
  }
  buildCounterSubnetworksExpandIpCidrRangeRequest--;
}

buildUnnamed1988() {
  var o = new core.List<api.Subnetwork>();
  o.add(buildSubnetwork());
  o.add(buildSubnetwork());
  return o;
}

checkUnnamed1988(core.List<api.Subnetwork> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSubnetwork(o[0]);
  checkSubnetwork(o[1]);
}

core.int buildCounterSubnetworksScopedListWarningData = 0;
buildSubnetworksScopedListWarningData() {
  var o = new api.SubnetworksScopedListWarningData();
  buildCounterSubnetworksScopedListWarningData++;
  if (buildCounterSubnetworksScopedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterSubnetworksScopedListWarningData--;
  return o;
}

checkSubnetworksScopedListWarningData(api.SubnetworksScopedListWarningData o) {
  buildCounterSubnetworksScopedListWarningData++;
  if (buildCounterSubnetworksScopedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterSubnetworksScopedListWarningData--;
}

buildUnnamed1989() {
  var o = new core.List<api.SubnetworksScopedListWarningData>();
  o.add(buildSubnetworksScopedListWarningData());
  o.add(buildSubnetworksScopedListWarningData());
  return o;
}

checkUnnamed1989(core.List<api.SubnetworksScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSubnetworksScopedListWarningData(o[0]);
  checkSubnetworksScopedListWarningData(o[1]);
}

core.int buildCounterSubnetworksScopedListWarning = 0;
buildSubnetworksScopedListWarning() {
  var o = new api.SubnetworksScopedListWarning();
  buildCounterSubnetworksScopedListWarning++;
  if (buildCounterSubnetworksScopedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1989();
    o.message = "foo";
  }
  buildCounterSubnetworksScopedListWarning--;
  return o;
}

checkSubnetworksScopedListWarning(api.SubnetworksScopedListWarning o) {
  buildCounterSubnetworksScopedListWarning++;
  if (buildCounterSubnetworksScopedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1989(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterSubnetworksScopedListWarning--;
}

core.int buildCounterSubnetworksScopedList = 0;
buildSubnetworksScopedList() {
  var o = new api.SubnetworksScopedList();
  buildCounterSubnetworksScopedList++;
  if (buildCounterSubnetworksScopedList < 3) {
    o.subnetworks = buildUnnamed1988();
    o.warning = buildSubnetworksScopedListWarning();
  }
  buildCounterSubnetworksScopedList--;
  return o;
}

checkSubnetworksScopedList(api.SubnetworksScopedList o) {
  buildCounterSubnetworksScopedList++;
  if (buildCounterSubnetworksScopedList < 3) {
    checkUnnamed1988(o.subnetworks);
    checkSubnetworksScopedListWarning(o.warning);
  }
  buildCounterSubnetworksScopedList--;
}

core.int buildCounterSubnetworksSetPrivateIpGoogleAccessRequest = 0;
buildSubnetworksSetPrivateIpGoogleAccessRequest() {
  var o = new api.SubnetworksSetPrivateIpGoogleAccessRequest();
  buildCounterSubnetworksSetPrivateIpGoogleAccessRequest++;
  if (buildCounterSubnetworksSetPrivateIpGoogleAccessRequest < 3) {
    o.privateIpGoogleAccess = true;
  }
  buildCounterSubnetworksSetPrivateIpGoogleAccessRequest--;
  return o;
}

checkSubnetworksSetPrivateIpGoogleAccessRequest(
    api.SubnetworksSetPrivateIpGoogleAccessRequest o) {
  buildCounterSubnetworksSetPrivateIpGoogleAccessRequest++;
  if (buildCounterSubnetworksSetPrivateIpGoogleAccessRequest < 3) {
    unittest.expect(o.privateIpGoogleAccess, unittest.isTrue);
  }
  buildCounterSubnetworksSetPrivateIpGoogleAccessRequest--;
}

core.int buildCounterTCPHealthCheck = 0;
buildTCPHealthCheck() {
  var o = new api.TCPHealthCheck();
  buildCounterTCPHealthCheck++;
  if (buildCounterTCPHealthCheck < 3) {
    o.port = 42;
    o.portName = "foo";
    o.portSpecification = "foo";
    o.proxyHeader = "foo";
    o.request = "foo";
    o.response = "foo";
  }
  buildCounterTCPHealthCheck--;
  return o;
}

checkTCPHealthCheck(api.TCPHealthCheck o) {
  buildCounterTCPHealthCheck++;
  if (buildCounterTCPHealthCheck < 3) {
    unittest.expect(o.port, unittest.equals(42));
    unittest.expect(o.portName, unittest.equals('foo'));
    unittest.expect(o.portSpecification, unittest.equals('foo'));
    unittest.expect(o.proxyHeader, unittest.equals('foo'));
    unittest.expect(o.request, unittest.equals('foo'));
    unittest.expect(o.response, unittest.equals('foo'));
  }
  buildCounterTCPHealthCheck--;
}

buildUnnamed1990() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1990(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterTags = 0;
buildTags() {
  var o = new api.Tags();
  buildCounterTags++;
  if (buildCounterTags < 3) {
    o.fingerprint = "foo";
    o.items = buildUnnamed1990();
  }
  buildCounterTags--;
  return o;
}

checkTags(api.Tags o) {
  buildCounterTags++;
  if (buildCounterTags < 3) {
    unittest.expect(o.fingerprint, unittest.equals('foo'));
    checkUnnamed1990(o.items);
  }
  buildCounterTags--;
}

core.int buildCounterTargetHttpProxy = 0;
buildTargetHttpProxy() {
  var o = new api.TargetHttpProxy();
  buildCounterTargetHttpProxy++;
  if (buildCounterTargetHttpProxy < 3) {
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.id = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.selfLink = "foo";
    o.urlMap = "foo";
  }
  buildCounterTargetHttpProxy--;
  return o;
}

checkTargetHttpProxy(api.TargetHttpProxy o) {
  buildCounterTargetHttpProxy++;
  if (buildCounterTargetHttpProxy < 3) {
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.urlMap, unittest.equals('foo'));
  }
  buildCounterTargetHttpProxy--;
}

buildUnnamed1991() {
  var o = new core.List<api.TargetHttpProxy>();
  o.add(buildTargetHttpProxy());
  o.add(buildTargetHttpProxy());
  return o;
}

checkUnnamed1991(core.List<api.TargetHttpProxy> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkTargetHttpProxy(o[0]);
  checkTargetHttpProxy(o[1]);
}

core.int buildCounterTargetHttpProxyListWarningData = 0;
buildTargetHttpProxyListWarningData() {
  var o = new api.TargetHttpProxyListWarningData();
  buildCounterTargetHttpProxyListWarningData++;
  if (buildCounterTargetHttpProxyListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterTargetHttpProxyListWarningData--;
  return o;
}

checkTargetHttpProxyListWarningData(api.TargetHttpProxyListWarningData o) {
  buildCounterTargetHttpProxyListWarningData++;
  if (buildCounterTargetHttpProxyListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterTargetHttpProxyListWarningData--;
}

buildUnnamed1992() {
  var o = new core.List<api.TargetHttpProxyListWarningData>();
  o.add(buildTargetHttpProxyListWarningData());
  o.add(buildTargetHttpProxyListWarningData());
  return o;
}

checkUnnamed1992(core.List<api.TargetHttpProxyListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkTargetHttpProxyListWarningData(o[0]);
  checkTargetHttpProxyListWarningData(o[1]);
}

core.int buildCounterTargetHttpProxyListWarning = 0;
buildTargetHttpProxyListWarning() {
  var o = new api.TargetHttpProxyListWarning();
  buildCounterTargetHttpProxyListWarning++;
  if (buildCounterTargetHttpProxyListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1992();
    o.message = "foo";
  }
  buildCounterTargetHttpProxyListWarning--;
  return o;
}

checkTargetHttpProxyListWarning(api.TargetHttpProxyListWarning o) {
  buildCounterTargetHttpProxyListWarning++;
  if (buildCounterTargetHttpProxyListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1992(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterTargetHttpProxyListWarning--;
}

core.int buildCounterTargetHttpProxyList = 0;
buildTargetHttpProxyList() {
  var o = new api.TargetHttpProxyList();
  buildCounterTargetHttpProxyList++;
  if (buildCounterTargetHttpProxyList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1991();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildTargetHttpProxyListWarning();
  }
  buildCounterTargetHttpProxyList--;
  return o;
}

checkTargetHttpProxyList(api.TargetHttpProxyList o) {
  buildCounterTargetHttpProxyList++;
  if (buildCounterTargetHttpProxyList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1991(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkTargetHttpProxyListWarning(o.warning);
  }
  buildCounterTargetHttpProxyList--;
}

core.int buildCounterTargetHttpsProxiesSetQuicOverrideRequest = 0;
buildTargetHttpsProxiesSetQuicOverrideRequest() {
  var o = new api.TargetHttpsProxiesSetQuicOverrideRequest();
  buildCounterTargetHttpsProxiesSetQuicOverrideRequest++;
  if (buildCounterTargetHttpsProxiesSetQuicOverrideRequest < 3) {
    o.quicOverride = "foo";
  }
  buildCounterTargetHttpsProxiesSetQuicOverrideRequest--;
  return o;
}

checkTargetHttpsProxiesSetQuicOverrideRequest(
    api.TargetHttpsProxiesSetQuicOverrideRequest o) {
  buildCounterTargetHttpsProxiesSetQuicOverrideRequest++;
  if (buildCounterTargetHttpsProxiesSetQuicOverrideRequest < 3) {
    unittest.expect(o.quicOverride, unittest.equals('foo'));
  }
  buildCounterTargetHttpsProxiesSetQuicOverrideRequest--;
}

buildUnnamed1993() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1993(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterTargetHttpsProxiesSetSslCertificatesRequest = 0;
buildTargetHttpsProxiesSetSslCertificatesRequest() {
  var o = new api.TargetHttpsProxiesSetSslCertificatesRequest();
  buildCounterTargetHttpsProxiesSetSslCertificatesRequest++;
  if (buildCounterTargetHttpsProxiesSetSslCertificatesRequest < 3) {
    o.sslCertificates = buildUnnamed1993();
  }
  buildCounterTargetHttpsProxiesSetSslCertificatesRequest--;
  return o;
}

checkTargetHttpsProxiesSetSslCertificatesRequest(
    api.TargetHttpsProxiesSetSslCertificatesRequest o) {
  buildCounterTargetHttpsProxiesSetSslCertificatesRequest++;
  if (buildCounterTargetHttpsProxiesSetSslCertificatesRequest < 3) {
    checkUnnamed1993(o.sslCertificates);
  }
  buildCounterTargetHttpsProxiesSetSslCertificatesRequest--;
}

buildUnnamed1994() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed1994(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterTargetHttpsProxy = 0;
buildTargetHttpsProxy() {
  var o = new api.TargetHttpsProxy();
  buildCounterTargetHttpsProxy++;
  if (buildCounterTargetHttpsProxy < 3) {
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.id = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.quicOverride = "foo";
    o.selfLink = "foo";
    o.sslCertificates = buildUnnamed1994();
    o.sslPolicy = "foo";
    o.urlMap = "foo";
  }
  buildCounterTargetHttpsProxy--;
  return o;
}

checkTargetHttpsProxy(api.TargetHttpsProxy o) {
  buildCounterTargetHttpsProxy++;
  if (buildCounterTargetHttpsProxy < 3) {
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.quicOverride, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkUnnamed1994(o.sslCertificates);
    unittest.expect(o.sslPolicy, unittest.equals('foo'));
    unittest.expect(o.urlMap, unittest.equals('foo'));
  }
  buildCounterTargetHttpsProxy--;
}

buildUnnamed1995() {
  var o = new core.List<api.TargetHttpsProxy>();
  o.add(buildTargetHttpsProxy());
  o.add(buildTargetHttpsProxy());
  return o;
}

checkUnnamed1995(core.List<api.TargetHttpsProxy> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkTargetHttpsProxy(o[0]);
  checkTargetHttpsProxy(o[1]);
}

core.int buildCounterTargetHttpsProxyListWarningData = 0;
buildTargetHttpsProxyListWarningData() {
  var o = new api.TargetHttpsProxyListWarningData();
  buildCounterTargetHttpsProxyListWarningData++;
  if (buildCounterTargetHttpsProxyListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterTargetHttpsProxyListWarningData--;
  return o;
}

checkTargetHttpsProxyListWarningData(api.TargetHttpsProxyListWarningData o) {
  buildCounterTargetHttpsProxyListWarningData++;
  if (buildCounterTargetHttpsProxyListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterTargetHttpsProxyListWarningData--;
}

buildUnnamed1996() {
  var o = new core.List<api.TargetHttpsProxyListWarningData>();
  o.add(buildTargetHttpsProxyListWarningData());
  o.add(buildTargetHttpsProxyListWarningData());
  return o;
}

checkUnnamed1996(core.List<api.TargetHttpsProxyListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkTargetHttpsProxyListWarningData(o[0]);
  checkTargetHttpsProxyListWarningData(o[1]);
}

core.int buildCounterTargetHttpsProxyListWarning = 0;
buildTargetHttpsProxyListWarning() {
  var o = new api.TargetHttpsProxyListWarning();
  buildCounterTargetHttpsProxyListWarning++;
  if (buildCounterTargetHttpsProxyListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1996();
    o.message = "foo";
  }
  buildCounterTargetHttpsProxyListWarning--;
  return o;
}

checkTargetHttpsProxyListWarning(api.TargetHttpsProxyListWarning o) {
  buildCounterTargetHttpsProxyListWarning++;
  if (buildCounterTargetHttpsProxyListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1996(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterTargetHttpsProxyListWarning--;
}

core.int buildCounterTargetHttpsProxyList = 0;
buildTargetHttpsProxyList() {
  var o = new api.TargetHttpsProxyList();
  buildCounterTargetHttpsProxyList++;
  if (buildCounterTargetHttpsProxyList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1995();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildTargetHttpsProxyListWarning();
  }
  buildCounterTargetHttpsProxyList--;
  return o;
}

checkTargetHttpsProxyList(api.TargetHttpsProxyList o) {
  buildCounterTargetHttpsProxyList++;
  if (buildCounterTargetHttpsProxyList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1995(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkTargetHttpsProxyListWarning(o.warning);
  }
  buildCounterTargetHttpsProxyList--;
}

core.int buildCounterTargetInstance = 0;
buildTargetInstance() {
  var o = new api.TargetInstance();
  buildCounterTargetInstance++;
  if (buildCounterTargetInstance < 3) {
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.id = "foo";
    o.instance = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.natPolicy = "foo";
    o.selfLink = "foo";
    o.zone = "foo";
  }
  buildCounterTargetInstance--;
  return o;
}

checkTargetInstance(api.TargetInstance o) {
  buildCounterTargetInstance++;
  if (buildCounterTargetInstance < 3) {
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.instance, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.natPolicy, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.zone, unittest.equals('foo'));
  }
  buildCounterTargetInstance--;
}

buildUnnamed1997() {
  var o = new core.Map<core.String, api.TargetInstancesScopedList>();
  o["x"] = buildTargetInstancesScopedList();
  o["y"] = buildTargetInstancesScopedList();
  return o;
}

checkUnnamed1997(core.Map<core.String, api.TargetInstancesScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkTargetInstancesScopedList(o["x"]);
  checkTargetInstancesScopedList(o["y"]);
}

core.int buildCounterTargetInstanceAggregatedListWarningData = 0;
buildTargetInstanceAggregatedListWarningData() {
  var o = new api.TargetInstanceAggregatedListWarningData();
  buildCounterTargetInstanceAggregatedListWarningData++;
  if (buildCounterTargetInstanceAggregatedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterTargetInstanceAggregatedListWarningData--;
  return o;
}

checkTargetInstanceAggregatedListWarningData(
    api.TargetInstanceAggregatedListWarningData o) {
  buildCounterTargetInstanceAggregatedListWarningData++;
  if (buildCounterTargetInstanceAggregatedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterTargetInstanceAggregatedListWarningData--;
}

buildUnnamed1998() {
  var o = new core.List<api.TargetInstanceAggregatedListWarningData>();
  o.add(buildTargetInstanceAggregatedListWarningData());
  o.add(buildTargetInstanceAggregatedListWarningData());
  return o;
}

checkUnnamed1998(core.List<api.TargetInstanceAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkTargetInstanceAggregatedListWarningData(o[0]);
  checkTargetInstanceAggregatedListWarningData(o[1]);
}

core.int buildCounterTargetInstanceAggregatedListWarning = 0;
buildTargetInstanceAggregatedListWarning() {
  var o = new api.TargetInstanceAggregatedListWarning();
  buildCounterTargetInstanceAggregatedListWarning++;
  if (buildCounterTargetInstanceAggregatedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed1998();
    o.message = "foo";
  }
  buildCounterTargetInstanceAggregatedListWarning--;
  return o;
}

checkTargetInstanceAggregatedListWarning(
    api.TargetInstanceAggregatedListWarning o) {
  buildCounterTargetInstanceAggregatedListWarning++;
  if (buildCounterTargetInstanceAggregatedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed1998(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterTargetInstanceAggregatedListWarning--;
}

core.int buildCounterTargetInstanceAggregatedList = 0;
buildTargetInstanceAggregatedList() {
  var o = new api.TargetInstanceAggregatedList();
  buildCounterTargetInstanceAggregatedList++;
  if (buildCounterTargetInstanceAggregatedList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1997();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildTargetInstanceAggregatedListWarning();
  }
  buildCounterTargetInstanceAggregatedList--;
  return o;
}

checkTargetInstanceAggregatedList(api.TargetInstanceAggregatedList o) {
  buildCounterTargetInstanceAggregatedList++;
  if (buildCounterTargetInstanceAggregatedList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1997(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkTargetInstanceAggregatedListWarning(o.warning);
  }
  buildCounterTargetInstanceAggregatedList--;
}

buildUnnamed1999() {
  var o = new core.List<api.TargetInstance>();
  o.add(buildTargetInstance());
  o.add(buildTargetInstance());
  return o;
}

checkUnnamed1999(core.List<api.TargetInstance> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkTargetInstance(o[0]);
  checkTargetInstance(o[1]);
}

core.int buildCounterTargetInstanceListWarningData = 0;
buildTargetInstanceListWarningData() {
  var o = new api.TargetInstanceListWarningData();
  buildCounterTargetInstanceListWarningData++;
  if (buildCounterTargetInstanceListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterTargetInstanceListWarningData--;
  return o;
}

checkTargetInstanceListWarningData(api.TargetInstanceListWarningData o) {
  buildCounterTargetInstanceListWarningData++;
  if (buildCounterTargetInstanceListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterTargetInstanceListWarningData--;
}

buildUnnamed2000() {
  var o = new core.List<api.TargetInstanceListWarningData>();
  o.add(buildTargetInstanceListWarningData());
  o.add(buildTargetInstanceListWarningData());
  return o;
}

checkUnnamed2000(core.List<api.TargetInstanceListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkTargetInstanceListWarningData(o[0]);
  checkTargetInstanceListWarningData(o[1]);
}

core.int buildCounterTargetInstanceListWarning = 0;
buildTargetInstanceListWarning() {
  var o = new api.TargetInstanceListWarning();
  buildCounterTargetInstanceListWarning++;
  if (buildCounterTargetInstanceListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed2000();
    o.message = "foo";
  }
  buildCounterTargetInstanceListWarning--;
  return o;
}

checkTargetInstanceListWarning(api.TargetInstanceListWarning o) {
  buildCounterTargetInstanceListWarning++;
  if (buildCounterTargetInstanceListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed2000(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterTargetInstanceListWarning--;
}

core.int buildCounterTargetInstanceList = 0;
buildTargetInstanceList() {
  var o = new api.TargetInstanceList();
  buildCounterTargetInstanceList++;
  if (buildCounterTargetInstanceList < 3) {
    o.id = "foo";
    o.items = buildUnnamed1999();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildTargetInstanceListWarning();
  }
  buildCounterTargetInstanceList--;
  return o;
}

checkTargetInstanceList(api.TargetInstanceList o) {
  buildCounterTargetInstanceList++;
  if (buildCounterTargetInstanceList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed1999(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkTargetInstanceListWarning(o.warning);
  }
  buildCounterTargetInstanceList--;
}

buildUnnamed2001() {
  var o = new core.List<api.TargetInstance>();
  o.add(buildTargetInstance());
  o.add(buildTargetInstance());
  return o;
}

checkUnnamed2001(core.List<api.TargetInstance> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkTargetInstance(o[0]);
  checkTargetInstance(o[1]);
}

core.int buildCounterTargetInstancesScopedListWarningData = 0;
buildTargetInstancesScopedListWarningData() {
  var o = new api.TargetInstancesScopedListWarningData();
  buildCounterTargetInstancesScopedListWarningData++;
  if (buildCounterTargetInstancesScopedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterTargetInstancesScopedListWarningData--;
  return o;
}

checkTargetInstancesScopedListWarningData(
    api.TargetInstancesScopedListWarningData o) {
  buildCounterTargetInstancesScopedListWarningData++;
  if (buildCounterTargetInstancesScopedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterTargetInstancesScopedListWarningData--;
}

buildUnnamed2002() {
  var o = new core.List<api.TargetInstancesScopedListWarningData>();
  o.add(buildTargetInstancesScopedListWarningData());
  o.add(buildTargetInstancesScopedListWarningData());
  return o;
}

checkUnnamed2002(core.List<api.TargetInstancesScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkTargetInstancesScopedListWarningData(o[0]);
  checkTargetInstancesScopedListWarningData(o[1]);
}

core.int buildCounterTargetInstancesScopedListWarning = 0;
buildTargetInstancesScopedListWarning() {
  var o = new api.TargetInstancesScopedListWarning();
  buildCounterTargetInstancesScopedListWarning++;
  if (buildCounterTargetInstancesScopedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed2002();
    o.message = "foo";
  }
  buildCounterTargetInstancesScopedListWarning--;
  return o;
}

checkTargetInstancesScopedListWarning(api.TargetInstancesScopedListWarning o) {
  buildCounterTargetInstancesScopedListWarning++;
  if (buildCounterTargetInstancesScopedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed2002(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterTargetInstancesScopedListWarning--;
}

core.int buildCounterTargetInstancesScopedList = 0;
buildTargetInstancesScopedList() {
  var o = new api.TargetInstancesScopedList();
  buildCounterTargetInstancesScopedList++;
  if (buildCounterTargetInstancesScopedList < 3) {
    o.targetInstances = buildUnnamed2001();
    o.warning = buildTargetInstancesScopedListWarning();
  }
  buildCounterTargetInstancesScopedList--;
  return o;
}

checkTargetInstancesScopedList(api.TargetInstancesScopedList o) {
  buildCounterTargetInstancesScopedList++;
  if (buildCounterTargetInstancesScopedList < 3) {
    checkUnnamed2001(o.targetInstances);
    checkTargetInstancesScopedListWarning(o.warning);
  }
  buildCounterTargetInstancesScopedList--;
}

buildUnnamed2003() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed2003(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

buildUnnamed2004() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed2004(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterTargetPool = 0;
buildTargetPool() {
  var o = new api.TargetPool();
  buildCounterTargetPool++;
  if (buildCounterTargetPool < 3) {
    o.backupPool = "foo";
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.failoverRatio = 42.0;
    o.healthChecks = buildUnnamed2003();
    o.id = "foo";
    o.instances = buildUnnamed2004();
    o.kind = "foo";
    o.name = "foo";
    o.region = "foo";
    o.selfLink = "foo";
    o.sessionAffinity = "foo";
  }
  buildCounterTargetPool--;
  return o;
}

checkTargetPool(api.TargetPool o) {
  buildCounterTargetPool++;
  if (buildCounterTargetPool < 3) {
    unittest.expect(o.backupPool, unittest.equals('foo'));
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.failoverRatio, unittest.equals(42.0));
    checkUnnamed2003(o.healthChecks);
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed2004(o.instances);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.region, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.sessionAffinity, unittest.equals('foo'));
  }
  buildCounterTargetPool--;
}

buildUnnamed2005() {
  var o = new core.Map<core.String, api.TargetPoolsScopedList>();
  o["x"] = buildTargetPoolsScopedList();
  o["y"] = buildTargetPoolsScopedList();
  return o;
}

checkUnnamed2005(core.Map<core.String, api.TargetPoolsScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkTargetPoolsScopedList(o["x"]);
  checkTargetPoolsScopedList(o["y"]);
}

core.int buildCounterTargetPoolAggregatedListWarningData = 0;
buildTargetPoolAggregatedListWarningData() {
  var o = new api.TargetPoolAggregatedListWarningData();
  buildCounterTargetPoolAggregatedListWarningData++;
  if (buildCounterTargetPoolAggregatedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterTargetPoolAggregatedListWarningData--;
  return o;
}

checkTargetPoolAggregatedListWarningData(
    api.TargetPoolAggregatedListWarningData o) {
  buildCounterTargetPoolAggregatedListWarningData++;
  if (buildCounterTargetPoolAggregatedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterTargetPoolAggregatedListWarningData--;
}

buildUnnamed2006() {
  var o = new core.List<api.TargetPoolAggregatedListWarningData>();
  o.add(buildTargetPoolAggregatedListWarningData());
  o.add(buildTargetPoolAggregatedListWarningData());
  return o;
}

checkUnnamed2006(core.List<api.TargetPoolAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkTargetPoolAggregatedListWarningData(o[0]);
  checkTargetPoolAggregatedListWarningData(o[1]);
}

core.int buildCounterTargetPoolAggregatedListWarning = 0;
buildTargetPoolAggregatedListWarning() {
  var o = new api.TargetPoolAggregatedListWarning();
  buildCounterTargetPoolAggregatedListWarning++;
  if (buildCounterTargetPoolAggregatedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed2006();
    o.message = "foo";
  }
  buildCounterTargetPoolAggregatedListWarning--;
  return o;
}

checkTargetPoolAggregatedListWarning(api.TargetPoolAggregatedListWarning o) {
  buildCounterTargetPoolAggregatedListWarning++;
  if (buildCounterTargetPoolAggregatedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed2006(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterTargetPoolAggregatedListWarning--;
}

core.int buildCounterTargetPoolAggregatedList = 0;
buildTargetPoolAggregatedList() {
  var o = new api.TargetPoolAggregatedList();
  buildCounterTargetPoolAggregatedList++;
  if (buildCounterTargetPoolAggregatedList < 3) {
    o.id = "foo";
    o.items = buildUnnamed2005();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildTargetPoolAggregatedListWarning();
  }
  buildCounterTargetPoolAggregatedList--;
  return o;
}

checkTargetPoolAggregatedList(api.TargetPoolAggregatedList o) {
  buildCounterTargetPoolAggregatedList++;
  if (buildCounterTargetPoolAggregatedList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed2005(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkTargetPoolAggregatedListWarning(o.warning);
  }
  buildCounterTargetPoolAggregatedList--;
}

buildUnnamed2007() {
  var o = new core.List<api.HealthStatus>();
  o.add(buildHealthStatus());
  o.add(buildHealthStatus());
  return o;
}

checkUnnamed2007(core.List<api.HealthStatus> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkHealthStatus(o[0]);
  checkHealthStatus(o[1]);
}

core.int buildCounterTargetPoolInstanceHealth = 0;
buildTargetPoolInstanceHealth() {
  var o = new api.TargetPoolInstanceHealth();
  buildCounterTargetPoolInstanceHealth++;
  if (buildCounterTargetPoolInstanceHealth < 3) {
    o.healthStatus = buildUnnamed2007();
    o.kind = "foo";
  }
  buildCounterTargetPoolInstanceHealth--;
  return o;
}

checkTargetPoolInstanceHealth(api.TargetPoolInstanceHealth o) {
  buildCounterTargetPoolInstanceHealth++;
  if (buildCounterTargetPoolInstanceHealth < 3) {
    checkUnnamed2007(o.healthStatus);
    unittest.expect(o.kind, unittest.equals('foo'));
  }
  buildCounterTargetPoolInstanceHealth--;
}

buildUnnamed2008() {
  var o = new core.List<api.TargetPool>();
  o.add(buildTargetPool());
  o.add(buildTargetPool());
  return o;
}

checkUnnamed2008(core.List<api.TargetPool> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkTargetPool(o[0]);
  checkTargetPool(o[1]);
}

core.int buildCounterTargetPoolListWarningData = 0;
buildTargetPoolListWarningData() {
  var o = new api.TargetPoolListWarningData();
  buildCounterTargetPoolListWarningData++;
  if (buildCounterTargetPoolListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterTargetPoolListWarningData--;
  return o;
}

checkTargetPoolListWarningData(api.TargetPoolListWarningData o) {
  buildCounterTargetPoolListWarningData++;
  if (buildCounterTargetPoolListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterTargetPoolListWarningData--;
}

buildUnnamed2009() {
  var o = new core.List<api.TargetPoolListWarningData>();
  o.add(buildTargetPoolListWarningData());
  o.add(buildTargetPoolListWarningData());
  return o;
}

checkUnnamed2009(core.List<api.TargetPoolListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkTargetPoolListWarningData(o[0]);
  checkTargetPoolListWarningData(o[1]);
}

core.int buildCounterTargetPoolListWarning = 0;
buildTargetPoolListWarning() {
  var o = new api.TargetPoolListWarning();
  buildCounterTargetPoolListWarning++;
  if (buildCounterTargetPoolListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed2009();
    o.message = "foo";
  }
  buildCounterTargetPoolListWarning--;
  return o;
}

checkTargetPoolListWarning(api.TargetPoolListWarning o) {
  buildCounterTargetPoolListWarning++;
  if (buildCounterTargetPoolListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed2009(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterTargetPoolListWarning--;
}

core.int buildCounterTargetPoolList = 0;
buildTargetPoolList() {
  var o = new api.TargetPoolList();
  buildCounterTargetPoolList++;
  if (buildCounterTargetPoolList < 3) {
    o.id = "foo";
    o.items = buildUnnamed2008();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildTargetPoolListWarning();
  }
  buildCounterTargetPoolList--;
  return o;
}

checkTargetPoolList(api.TargetPoolList o) {
  buildCounterTargetPoolList++;
  if (buildCounterTargetPoolList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed2008(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkTargetPoolListWarning(o.warning);
  }
  buildCounterTargetPoolList--;
}

buildUnnamed2010() {
  var o = new core.List<api.HealthCheckReference>();
  o.add(buildHealthCheckReference());
  o.add(buildHealthCheckReference());
  return o;
}

checkUnnamed2010(core.List<api.HealthCheckReference> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkHealthCheckReference(o[0]);
  checkHealthCheckReference(o[1]);
}

core.int buildCounterTargetPoolsAddHealthCheckRequest = 0;
buildTargetPoolsAddHealthCheckRequest() {
  var o = new api.TargetPoolsAddHealthCheckRequest();
  buildCounterTargetPoolsAddHealthCheckRequest++;
  if (buildCounterTargetPoolsAddHealthCheckRequest < 3) {
    o.healthChecks = buildUnnamed2010();
  }
  buildCounterTargetPoolsAddHealthCheckRequest--;
  return o;
}

checkTargetPoolsAddHealthCheckRequest(api.TargetPoolsAddHealthCheckRequest o) {
  buildCounterTargetPoolsAddHealthCheckRequest++;
  if (buildCounterTargetPoolsAddHealthCheckRequest < 3) {
    checkUnnamed2010(o.healthChecks);
  }
  buildCounterTargetPoolsAddHealthCheckRequest--;
}

buildUnnamed2011() {
  var o = new core.List<api.InstanceReference>();
  o.add(buildInstanceReference());
  o.add(buildInstanceReference());
  return o;
}

checkUnnamed2011(core.List<api.InstanceReference> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceReference(o[0]);
  checkInstanceReference(o[1]);
}

core.int buildCounterTargetPoolsAddInstanceRequest = 0;
buildTargetPoolsAddInstanceRequest() {
  var o = new api.TargetPoolsAddInstanceRequest();
  buildCounterTargetPoolsAddInstanceRequest++;
  if (buildCounterTargetPoolsAddInstanceRequest < 3) {
    o.instances = buildUnnamed2011();
  }
  buildCounterTargetPoolsAddInstanceRequest--;
  return o;
}

checkTargetPoolsAddInstanceRequest(api.TargetPoolsAddInstanceRequest o) {
  buildCounterTargetPoolsAddInstanceRequest++;
  if (buildCounterTargetPoolsAddInstanceRequest < 3) {
    checkUnnamed2011(o.instances);
  }
  buildCounterTargetPoolsAddInstanceRequest--;
}

buildUnnamed2012() {
  var o = new core.List<api.HealthCheckReference>();
  o.add(buildHealthCheckReference());
  o.add(buildHealthCheckReference());
  return o;
}

checkUnnamed2012(core.List<api.HealthCheckReference> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkHealthCheckReference(o[0]);
  checkHealthCheckReference(o[1]);
}

core.int buildCounterTargetPoolsRemoveHealthCheckRequest = 0;
buildTargetPoolsRemoveHealthCheckRequest() {
  var o = new api.TargetPoolsRemoveHealthCheckRequest();
  buildCounterTargetPoolsRemoveHealthCheckRequest++;
  if (buildCounterTargetPoolsRemoveHealthCheckRequest < 3) {
    o.healthChecks = buildUnnamed2012();
  }
  buildCounterTargetPoolsRemoveHealthCheckRequest--;
  return o;
}

checkTargetPoolsRemoveHealthCheckRequest(
    api.TargetPoolsRemoveHealthCheckRequest o) {
  buildCounterTargetPoolsRemoveHealthCheckRequest++;
  if (buildCounterTargetPoolsRemoveHealthCheckRequest < 3) {
    checkUnnamed2012(o.healthChecks);
  }
  buildCounterTargetPoolsRemoveHealthCheckRequest--;
}

buildUnnamed2013() {
  var o = new core.List<api.InstanceReference>();
  o.add(buildInstanceReference());
  o.add(buildInstanceReference());
  return o;
}

checkUnnamed2013(core.List<api.InstanceReference> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceReference(o[0]);
  checkInstanceReference(o[1]);
}

core.int buildCounterTargetPoolsRemoveInstanceRequest = 0;
buildTargetPoolsRemoveInstanceRequest() {
  var o = new api.TargetPoolsRemoveInstanceRequest();
  buildCounterTargetPoolsRemoveInstanceRequest++;
  if (buildCounterTargetPoolsRemoveInstanceRequest < 3) {
    o.instances = buildUnnamed2013();
  }
  buildCounterTargetPoolsRemoveInstanceRequest--;
  return o;
}

checkTargetPoolsRemoveInstanceRequest(api.TargetPoolsRemoveInstanceRequest o) {
  buildCounterTargetPoolsRemoveInstanceRequest++;
  if (buildCounterTargetPoolsRemoveInstanceRequest < 3) {
    checkUnnamed2013(o.instances);
  }
  buildCounterTargetPoolsRemoveInstanceRequest--;
}

buildUnnamed2014() {
  var o = new core.List<api.TargetPool>();
  o.add(buildTargetPool());
  o.add(buildTargetPool());
  return o;
}

checkUnnamed2014(core.List<api.TargetPool> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkTargetPool(o[0]);
  checkTargetPool(o[1]);
}

core.int buildCounterTargetPoolsScopedListWarningData = 0;
buildTargetPoolsScopedListWarningData() {
  var o = new api.TargetPoolsScopedListWarningData();
  buildCounterTargetPoolsScopedListWarningData++;
  if (buildCounterTargetPoolsScopedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterTargetPoolsScopedListWarningData--;
  return o;
}

checkTargetPoolsScopedListWarningData(api.TargetPoolsScopedListWarningData o) {
  buildCounterTargetPoolsScopedListWarningData++;
  if (buildCounterTargetPoolsScopedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterTargetPoolsScopedListWarningData--;
}

buildUnnamed2015() {
  var o = new core.List<api.TargetPoolsScopedListWarningData>();
  o.add(buildTargetPoolsScopedListWarningData());
  o.add(buildTargetPoolsScopedListWarningData());
  return o;
}

checkUnnamed2015(core.List<api.TargetPoolsScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkTargetPoolsScopedListWarningData(o[0]);
  checkTargetPoolsScopedListWarningData(o[1]);
}

core.int buildCounterTargetPoolsScopedListWarning = 0;
buildTargetPoolsScopedListWarning() {
  var o = new api.TargetPoolsScopedListWarning();
  buildCounterTargetPoolsScopedListWarning++;
  if (buildCounterTargetPoolsScopedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed2015();
    o.message = "foo";
  }
  buildCounterTargetPoolsScopedListWarning--;
  return o;
}

checkTargetPoolsScopedListWarning(api.TargetPoolsScopedListWarning o) {
  buildCounterTargetPoolsScopedListWarning++;
  if (buildCounterTargetPoolsScopedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed2015(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterTargetPoolsScopedListWarning--;
}

core.int buildCounterTargetPoolsScopedList = 0;
buildTargetPoolsScopedList() {
  var o = new api.TargetPoolsScopedList();
  buildCounterTargetPoolsScopedList++;
  if (buildCounterTargetPoolsScopedList < 3) {
    o.targetPools = buildUnnamed2014();
    o.warning = buildTargetPoolsScopedListWarning();
  }
  buildCounterTargetPoolsScopedList--;
  return o;
}

checkTargetPoolsScopedList(api.TargetPoolsScopedList o) {
  buildCounterTargetPoolsScopedList++;
  if (buildCounterTargetPoolsScopedList < 3) {
    checkUnnamed2014(o.targetPools);
    checkTargetPoolsScopedListWarning(o.warning);
  }
  buildCounterTargetPoolsScopedList--;
}

core.int buildCounterTargetReference = 0;
buildTargetReference() {
  var o = new api.TargetReference();
  buildCounterTargetReference++;
  if (buildCounterTargetReference < 3) {
    o.target = "foo";
  }
  buildCounterTargetReference--;
  return o;
}

checkTargetReference(api.TargetReference o) {
  buildCounterTargetReference++;
  if (buildCounterTargetReference < 3) {
    unittest.expect(o.target, unittest.equals('foo'));
  }
  buildCounterTargetReference--;
}

core.int buildCounterTargetSslProxiesSetBackendServiceRequest = 0;
buildTargetSslProxiesSetBackendServiceRequest() {
  var o = new api.TargetSslProxiesSetBackendServiceRequest();
  buildCounterTargetSslProxiesSetBackendServiceRequest++;
  if (buildCounterTargetSslProxiesSetBackendServiceRequest < 3) {
    o.service = "foo";
  }
  buildCounterTargetSslProxiesSetBackendServiceRequest--;
  return o;
}

checkTargetSslProxiesSetBackendServiceRequest(
    api.TargetSslProxiesSetBackendServiceRequest o) {
  buildCounterTargetSslProxiesSetBackendServiceRequest++;
  if (buildCounterTargetSslProxiesSetBackendServiceRequest < 3) {
    unittest.expect(o.service, unittest.equals('foo'));
  }
  buildCounterTargetSslProxiesSetBackendServiceRequest--;
}

core.int buildCounterTargetSslProxiesSetProxyHeaderRequest = 0;
buildTargetSslProxiesSetProxyHeaderRequest() {
  var o = new api.TargetSslProxiesSetProxyHeaderRequest();
  buildCounterTargetSslProxiesSetProxyHeaderRequest++;
  if (buildCounterTargetSslProxiesSetProxyHeaderRequest < 3) {
    o.proxyHeader = "foo";
  }
  buildCounterTargetSslProxiesSetProxyHeaderRequest--;
  return o;
}

checkTargetSslProxiesSetProxyHeaderRequest(
    api.TargetSslProxiesSetProxyHeaderRequest o) {
  buildCounterTargetSslProxiesSetProxyHeaderRequest++;
  if (buildCounterTargetSslProxiesSetProxyHeaderRequest < 3) {
    unittest.expect(o.proxyHeader, unittest.equals('foo'));
  }
  buildCounterTargetSslProxiesSetProxyHeaderRequest--;
}

buildUnnamed2016() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed2016(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterTargetSslProxiesSetSslCertificatesRequest = 0;
buildTargetSslProxiesSetSslCertificatesRequest() {
  var o = new api.TargetSslProxiesSetSslCertificatesRequest();
  buildCounterTargetSslProxiesSetSslCertificatesRequest++;
  if (buildCounterTargetSslProxiesSetSslCertificatesRequest < 3) {
    o.sslCertificates = buildUnnamed2016();
  }
  buildCounterTargetSslProxiesSetSslCertificatesRequest--;
  return o;
}

checkTargetSslProxiesSetSslCertificatesRequest(
    api.TargetSslProxiesSetSslCertificatesRequest o) {
  buildCounterTargetSslProxiesSetSslCertificatesRequest++;
  if (buildCounterTargetSslProxiesSetSslCertificatesRequest < 3) {
    checkUnnamed2016(o.sslCertificates);
  }
  buildCounterTargetSslProxiesSetSslCertificatesRequest--;
}

buildUnnamed2017() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed2017(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterTargetSslProxy = 0;
buildTargetSslProxy() {
  var o = new api.TargetSslProxy();
  buildCounterTargetSslProxy++;
  if (buildCounterTargetSslProxy < 3) {
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.id = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.proxyHeader = "foo";
    o.selfLink = "foo";
    o.service = "foo";
    o.sslCertificates = buildUnnamed2017();
    o.sslPolicy = "foo";
  }
  buildCounterTargetSslProxy--;
  return o;
}

checkTargetSslProxy(api.TargetSslProxy o) {
  buildCounterTargetSslProxy++;
  if (buildCounterTargetSslProxy < 3) {
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.proxyHeader, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.service, unittest.equals('foo'));
    checkUnnamed2017(o.sslCertificates);
    unittest.expect(o.sslPolicy, unittest.equals('foo'));
  }
  buildCounterTargetSslProxy--;
}

buildUnnamed2018() {
  var o = new core.List<api.TargetSslProxy>();
  o.add(buildTargetSslProxy());
  o.add(buildTargetSslProxy());
  return o;
}

checkUnnamed2018(core.List<api.TargetSslProxy> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkTargetSslProxy(o[0]);
  checkTargetSslProxy(o[1]);
}

core.int buildCounterTargetSslProxyListWarningData = 0;
buildTargetSslProxyListWarningData() {
  var o = new api.TargetSslProxyListWarningData();
  buildCounterTargetSslProxyListWarningData++;
  if (buildCounterTargetSslProxyListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterTargetSslProxyListWarningData--;
  return o;
}

checkTargetSslProxyListWarningData(api.TargetSslProxyListWarningData o) {
  buildCounterTargetSslProxyListWarningData++;
  if (buildCounterTargetSslProxyListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterTargetSslProxyListWarningData--;
}

buildUnnamed2019() {
  var o = new core.List<api.TargetSslProxyListWarningData>();
  o.add(buildTargetSslProxyListWarningData());
  o.add(buildTargetSslProxyListWarningData());
  return o;
}

checkUnnamed2019(core.List<api.TargetSslProxyListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkTargetSslProxyListWarningData(o[0]);
  checkTargetSslProxyListWarningData(o[1]);
}

core.int buildCounterTargetSslProxyListWarning = 0;
buildTargetSslProxyListWarning() {
  var o = new api.TargetSslProxyListWarning();
  buildCounterTargetSslProxyListWarning++;
  if (buildCounterTargetSslProxyListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed2019();
    o.message = "foo";
  }
  buildCounterTargetSslProxyListWarning--;
  return o;
}

checkTargetSslProxyListWarning(api.TargetSslProxyListWarning o) {
  buildCounterTargetSslProxyListWarning++;
  if (buildCounterTargetSslProxyListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed2019(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterTargetSslProxyListWarning--;
}

core.int buildCounterTargetSslProxyList = 0;
buildTargetSslProxyList() {
  var o = new api.TargetSslProxyList();
  buildCounterTargetSslProxyList++;
  if (buildCounterTargetSslProxyList < 3) {
    o.id = "foo";
    o.items = buildUnnamed2018();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildTargetSslProxyListWarning();
  }
  buildCounterTargetSslProxyList--;
  return o;
}

checkTargetSslProxyList(api.TargetSslProxyList o) {
  buildCounterTargetSslProxyList++;
  if (buildCounterTargetSslProxyList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed2018(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkTargetSslProxyListWarning(o.warning);
  }
  buildCounterTargetSslProxyList--;
}

core.int buildCounterTargetTcpProxiesSetBackendServiceRequest = 0;
buildTargetTcpProxiesSetBackendServiceRequest() {
  var o = new api.TargetTcpProxiesSetBackendServiceRequest();
  buildCounterTargetTcpProxiesSetBackendServiceRequest++;
  if (buildCounterTargetTcpProxiesSetBackendServiceRequest < 3) {
    o.service = "foo";
  }
  buildCounterTargetTcpProxiesSetBackendServiceRequest--;
  return o;
}

checkTargetTcpProxiesSetBackendServiceRequest(
    api.TargetTcpProxiesSetBackendServiceRequest o) {
  buildCounterTargetTcpProxiesSetBackendServiceRequest++;
  if (buildCounterTargetTcpProxiesSetBackendServiceRequest < 3) {
    unittest.expect(o.service, unittest.equals('foo'));
  }
  buildCounterTargetTcpProxiesSetBackendServiceRequest--;
}

core.int buildCounterTargetTcpProxiesSetProxyHeaderRequest = 0;
buildTargetTcpProxiesSetProxyHeaderRequest() {
  var o = new api.TargetTcpProxiesSetProxyHeaderRequest();
  buildCounterTargetTcpProxiesSetProxyHeaderRequest++;
  if (buildCounterTargetTcpProxiesSetProxyHeaderRequest < 3) {
    o.proxyHeader = "foo";
  }
  buildCounterTargetTcpProxiesSetProxyHeaderRequest--;
  return o;
}

checkTargetTcpProxiesSetProxyHeaderRequest(
    api.TargetTcpProxiesSetProxyHeaderRequest o) {
  buildCounterTargetTcpProxiesSetProxyHeaderRequest++;
  if (buildCounterTargetTcpProxiesSetProxyHeaderRequest < 3) {
    unittest.expect(o.proxyHeader, unittest.equals('foo'));
  }
  buildCounterTargetTcpProxiesSetProxyHeaderRequest--;
}

core.int buildCounterTargetTcpProxy = 0;
buildTargetTcpProxy() {
  var o = new api.TargetTcpProxy();
  buildCounterTargetTcpProxy++;
  if (buildCounterTargetTcpProxy < 3) {
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.id = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.proxyHeader = "foo";
    o.selfLink = "foo";
    o.service = "foo";
  }
  buildCounterTargetTcpProxy--;
  return o;
}

checkTargetTcpProxy(api.TargetTcpProxy o) {
  buildCounterTargetTcpProxy++;
  if (buildCounterTargetTcpProxy < 3) {
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.proxyHeader, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.service, unittest.equals('foo'));
  }
  buildCounterTargetTcpProxy--;
}

buildUnnamed2020() {
  var o = new core.List<api.TargetTcpProxy>();
  o.add(buildTargetTcpProxy());
  o.add(buildTargetTcpProxy());
  return o;
}

checkUnnamed2020(core.List<api.TargetTcpProxy> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkTargetTcpProxy(o[0]);
  checkTargetTcpProxy(o[1]);
}

core.int buildCounterTargetTcpProxyListWarningData = 0;
buildTargetTcpProxyListWarningData() {
  var o = new api.TargetTcpProxyListWarningData();
  buildCounterTargetTcpProxyListWarningData++;
  if (buildCounterTargetTcpProxyListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterTargetTcpProxyListWarningData--;
  return o;
}

checkTargetTcpProxyListWarningData(api.TargetTcpProxyListWarningData o) {
  buildCounterTargetTcpProxyListWarningData++;
  if (buildCounterTargetTcpProxyListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterTargetTcpProxyListWarningData--;
}

buildUnnamed2021() {
  var o = new core.List<api.TargetTcpProxyListWarningData>();
  o.add(buildTargetTcpProxyListWarningData());
  o.add(buildTargetTcpProxyListWarningData());
  return o;
}

checkUnnamed2021(core.List<api.TargetTcpProxyListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkTargetTcpProxyListWarningData(o[0]);
  checkTargetTcpProxyListWarningData(o[1]);
}

core.int buildCounterTargetTcpProxyListWarning = 0;
buildTargetTcpProxyListWarning() {
  var o = new api.TargetTcpProxyListWarning();
  buildCounterTargetTcpProxyListWarning++;
  if (buildCounterTargetTcpProxyListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed2021();
    o.message = "foo";
  }
  buildCounterTargetTcpProxyListWarning--;
  return o;
}

checkTargetTcpProxyListWarning(api.TargetTcpProxyListWarning o) {
  buildCounterTargetTcpProxyListWarning++;
  if (buildCounterTargetTcpProxyListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed2021(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterTargetTcpProxyListWarning--;
}

core.int buildCounterTargetTcpProxyList = 0;
buildTargetTcpProxyList() {
  var o = new api.TargetTcpProxyList();
  buildCounterTargetTcpProxyList++;
  if (buildCounterTargetTcpProxyList < 3) {
    o.id = "foo";
    o.items = buildUnnamed2020();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildTargetTcpProxyListWarning();
  }
  buildCounterTargetTcpProxyList--;
  return o;
}

checkTargetTcpProxyList(api.TargetTcpProxyList o) {
  buildCounterTargetTcpProxyList++;
  if (buildCounterTargetTcpProxyList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed2020(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkTargetTcpProxyListWarning(o.warning);
  }
  buildCounterTargetTcpProxyList--;
}

buildUnnamed2022() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed2022(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

buildUnnamed2023() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed2023(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterTargetVpnGateway = 0;
buildTargetVpnGateway() {
  var o = new api.TargetVpnGateway();
  buildCounterTargetVpnGateway++;
  if (buildCounterTargetVpnGateway < 3) {
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.forwardingRules = buildUnnamed2022();
    o.id = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.network = "foo";
    o.region = "foo";
    o.selfLink = "foo";
    o.status = "foo";
    o.tunnels = buildUnnamed2023();
  }
  buildCounterTargetVpnGateway--;
  return o;
}

checkTargetVpnGateway(api.TargetVpnGateway o) {
  buildCounterTargetVpnGateway++;
  if (buildCounterTargetVpnGateway < 3) {
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    checkUnnamed2022(o.forwardingRules);
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.network, unittest.equals('foo'));
    unittest.expect(o.region, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.status, unittest.equals('foo'));
    checkUnnamed2023(o.tunnels);
  }
  buildCounterTargetVpnGateway--;
}

buildUnnamed2024() {
  var o = new core.Map<core.String, api.TargetVpnGatewaysScopedList>();
  o["x"] = buildTargetVpnGatewaysScopedList();
  o["y"] = buildTargetVpnGatewaysScopedList();
  return o;
}

checkUnnamed2024(core.Map<core.String, api.TargetVpnGatewaysScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkTargetVpnGatewaysScopedList(o["x"]);
  checkTargetVpnGatewaysScopedList(o["y"]);
}

core.int buildCounterTargetVpnGatewayAggregatedListWarningData = 0;
buildTargetVpnGatewayAggregatedListWarningData() {
  var o = new api.TargetVpnGatewayAggregatedListWarningData();
  buildCounterTargetVpnGatewayAggregatedListWarningData++;
  if (buildCounterTargetVpnGatewayAggregatedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterTargetVpnGatewayAggregatedListWarningData--;
  return o;
}

checkTargetVpnGatewayAggregatedListWarningData(
    api.TargetVpnGatewayAggregatedListWarningData o) {
  buildCounterTargetVpnGatewayAggregatedListWarningData++;
  if (buildCounterTargetVpnGatewayAggregatedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterTargetVpnGatewayAggregatedListWarningData--;
}

buildUnnamed2025() {
  var o = new core.List<api.TargetVpnGatewayAggregatedListWarningData>();
  o.add(buildTargetVpnGatewayAggregatedListWarningData());
  o.add(buildTargetVpnGatewayAggregatedListWarningData());
  return o;
}

checkUnnamed2025(core.List<api.TargetVpnGatewayAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkTargetVpnGatewayAggregatedListWarningData(o[0]);
  checkTargetVpnGatewayAggregatedListWarningData(o[1]);
}

core.int buildCounterTargetVpnGatewayAggregatedListWarning = 0;
buildTargetVpnGatewayAggregatedListWarning() {
  var o = new api.TargetVpnGatewayAggregatedListWarning();
  buildCounterTargetVpnGatewayAggregatedListWarning++;
  if (buildCounterTargetVpnGatewayAggregatedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed2025();
    o.message = "foo";
  }
  buildCounterTargetVpnGatewayAggregatedListWarning--;
  return o;
}

checkTargetVpnGatewayAggregatedListWarning(
    api.TargetVpnGatewayAggregatedListWarning o) {
  buildCounterTargetVpnGatewayAggregatedListWarning++;
  if (buildCounterTargetVpnGatewayAggregatedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed2025(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterTargetVpnGatewayAggregatedListWarning--;
}

core.int buildCounterTargetVpnGatewayAggregatedList = 0;
buildTargetVpnGatewayAggregatedList() {
  var o = new api.TargetVpnGatewayAggregatedList();
  buildCounterTargetVpnGatewayAggregatedList++;
  if (buildCounterTargetVpnGatewayAggregatedList < 3) {
    o.id = "foo";
    o.items = buildUnnamed2024();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildTargetVpnGatewayAggregatedListWarning();
  }
  buildCounterTargetVpnGatewayAggregatedList--;
  return o;
}

checkTargetVpnGatewayAggregatedList(api.TargetVpnGatewayAggregatedList o) {
  buildCounterTargetVpnGatewayAggregatedList++;
  if (buildCounterTargetVpnGatewayAggregatedList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed2024(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkTargetVpnGatewayAggregatedListWarning(o.warning);
  }
  buildCounterTargetVpnGatewayAggregatedList--;
}

buildUnnamed2026() {
  var o = new core.List<api.TargetVpnGateway>();
  o.add(buildTargetVpnGateway());
  o.add(buildTargetVpnGateway());
  return o;
}

checkUnnamed2026(core.List<api.TargetVpnGateway> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkTargetVpnGateway(o[0]);
  checkTargetVpnGateway(o[1]);
}

core.int buildCounterTargetVpnGatewayListWarningData = 0;
buildTargetVpnGatewayListWarningData() {
  var o = new api.TargetVpnGatewayListWarningData();
  buildCounterTargetVpnGatewayListWarningData++;
  if (buildCounterTargetVpnGatewayListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterTargetVpnGatewayListWarningData--;
  return o;
}

checkTargetVpnGatewayListWarningData(api.TargetVpnGatewayListWarningData o) {
  buildCounterTargetVpnGatewayListWarningData++;
  if (buildCounterTargetVpnGatewayListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterTargetVpnGatewayListWarningData--;
}

buildUnnamed2027() {
  var o = new core.List<api.TargetVpnGatewayListWarningData>();
  o.add(buildTargetVpnGatewayListWarningData());
  o.add(buildTargetVpnGatewayListWarningData());
  return o;
}

checkUnnamed2027(core.List<api.TargetVpnGatewayListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkTargetVpnGatewayListWarningData(o[0]);
  checkTargetVpnGatewayListWarningData(o[1]);
}

core.int buildCounterTargetVpnGatewayListWarning = 0;
buildTargetVpnGatewayListWarning() {
  var o = new api.TargetVpnGatewayListWarning();
  buildCounterTargetVpnGatewayListWarning++;
  if (buildCounterTargetVpnGatewayListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed2027();
    o.message = "foo";
  }
  buildCounterTargetVpnGatewayListWarning--;
  return o;
}

checkTargetVpnGatewayListWarning(api.TargetVpnGatewayListWarning o) {
  buildCounterTargetVpnGatewayListWarning++;
  if (buildCounterTargetVpnGatewayListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed2027(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterTargetVpnGatewayListWarning--;
}

core.int buildCounterTargetVpnGatewayList = 0;
buildTargetVpnGatewayList() {
  var o = new api.TargetVpnGatewayList();
  buildCounterTargetVpnGatewayList++;
  if (buildCounterTargetVpnGatewayList < 3) {
    o.id = "foo";
    o.items = buildUnnamed2026();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildTargetVpnGatewayListWarning();
  }
  buildCounterTargetVpnGatewayList--;
  return o;
}

checkTargetVpnGatewayList(api.TargetVpnGatewayList o) {
  buildCounterTargetVpnGatewayList++;
  if (buildCounterTargetVpnGatewayList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed2026(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkTargetVpnGatewayListWarning(o.warning);
  }
  buildCounterTargetVpnGatewayList--;
}

buildUnnamed2028() {
  var o = new core.List<api.TargetVpnGateway>();
  o.add(buildTargetVpnGateway());
  o.add(buildTargetVpnGateway());
  return o;
}

checkUnnamed2028(core.List<api.TargetVpnGateway> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkTargetVpnGateway(o[0]);
  checkTargetVpnGateway(o[1]);
}

core.int buildCounterTargetVpnGatewaysScopedListWarningData = 0;
buildTargetVpnGatewaysScopedListWarningData() {
  var o = new api.TargetVpnGatewaysScopedListWarningData();
  buildCounterTargetVpnGatewaysScopedListWarningData++;
  if (buildCounterTargetVpnGatewaysScopedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterTargetVpnGatewaysScopedListWarningData--;
  return o;
}

checkTargetVpnGatewaysScopedListWarningData(
    api.TargetVpnGatewaysScopedListWarningData o) {
  buildCounterTargetVpnGatewaysScopedListWarningData++;
  if (buildCounterTargetVpnGatewaysScopedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterTargetVpnGatewaysScopedListWarningData--;
}

buildUnnamed2029() {
  var o = new core.List<api.TargetVpnGatewaysScopedListWarningData>();
  o.add(buildTargetVpnGatewaysScopedListWarningData());
  o.add(buildTargetVpnGatewaysScopedListWarningData());
  return o;
}

checkUnnamed2029(core.List<api.TargetVpnGatewaysScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkTargetVpnGatewaysScopedListWarningData(o[0]);
  checkTargetVpnGatewaysScopedListWarningData(o[1]);
}

core.int buildCounterTargetVpnGatewaysScopedListWarning = 0;
buildTargetVpnGatewaysScopedListWarning() {
  var o = new api.TargetVpnGatewaysScopedListWarning();
  buildCounterTargetVpnGatewaysScopedListWarning++;
  if (buildCounterTargetVpnGatewaysScopedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed2029();
    o.message = "foo";
  }
  buildCounterTargetVpnGatewaysScopedListWarning--;
  return o;
}

checkTargetVpnGatewaysScopedListWarning(
    api.TargetVpnGatewaysScopedListWarning o) {
  buildCounterTargetVpnGatewaysScopedListWarning++;
  if (buildCounterTargetVpnGatewaysScopedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed2029(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterTargetVpnGatewaysScopedListWarning--;
}

core.int buildCounterTargetVpnGatewaysScopedList = 0;
buildTargetVpnGatewaysScopedList() {
  var o = new api.TargetVpnGatewaysScopedList();
  buildCounterTargetVpnGatewaysScopedList++;
  if (buildCounterTargetVpnGatewaysScopedList < 3) {
    o.targetVpnGateways = buildUnnamed2028();
    o.warning = buildTargetVpnGatewaysScopedListWarning();
  }
  buildCounterTargetVpnGatewaysScopedList--;
  return o;
}

checkTargetVpnGatewaysScopedList(api.TargetVpnGatewaysScopedList o) {
  buildCounterTargetVpnGatewaysScopedList++;
  if (buildCounterTargetVpnGatewaysScopedList < 3) {
    checkUnnamed2028(o.targetVpnGateways);
    checkTargetVpnGatewaysScopedListWarning(o.warning);
  }
  buildCounterTargetVpnGatewaysScopedList--;
}

core.int buildCounterTestFailure = 0;
buildTestFailure() {
  var o = new api.TestFailure();
  buildCounterTestFailure++;
  if (buildCounterTestFailure < 3) {
    o.actualService = "foo";
    o.expectedService = "foo";
    o.host = "foo";
    o.path = "foo";
  }
  buildCounterTestFailure--;
  return o;
}

checkTestFailure(api.TestFailure o) {
  buildCounterTestFailure++;
  if (buildCounterTestFailure < 3) {
    unittest.expect(o.actualService, unittest.equals('foo'));
    unittest.expect(o.expectedService, unittest.equals('foo'));
    unittest.expect(o.host, unittest.equals('foo'));
    unittest.expect(o.path, unittest.equals('foo'));
  }
  buildCounterTestFailure--;
}

buildUnnamed2030() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed2030(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterTestPermissionsRequest = 0;
buildTestPermissionsRequest() {
  var o = new api.TestPermissionsRequest();
  buildCounterTestPermissionsRequest++;
  if (buildCounterTestPermissionsRequest < 3) {
    o.permissions = buildUnnamed2030();
  }
  buildCounterTestPermissionsRequest--;
  return o;
}

checkTestPermissionsRequest(api.TestPermissionsRequest o) {
  buildCounterTestPermissionsRequest++;
  if (buildCounterTestPermissionsRequest < 3) {
    checkUnnamed2030(o.permissions);
  }
  buildCounterTestPermissionsRequest--;
}

buildUnnamed2031() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed2031(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterTestPermissionsResponse = 0;
buildTestPermissionsResponse() {
  var o = new api.TestPermissionsResponse();
  buildCounterTestPermissionsResponse++;
  if (buildCounterTestPermissionsResponse < 3) {
    o.permissions = buildUnnamed2031();
  }
  buildCounterTestPermissionsResponse--;
  return o;
}

checkTestPermissionsResponse(api.TestPermissionsResponse o) {
  buildCounterTestPermissionsResponse++;
  if (buildCounterTestPermissionsResponse < 3) {
    checkUnnamed2031(o.permissions);
  }
  buildCounterTestPermissionsResponse--;
}

buildUnnamed2032() {
  var o = new core.List<api.HostRule>();
  o.add(buildHostRule());
  o.add(buildHostRule());
  return o;
}

checkUnnamed2032(core.List<api.HostRule> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkHostRule(o[0]);
  checkHostRule(o[1]);
}

buildUnnamed2033() {
  var o = new core.List<api.PathMatcher>();
  o.add(buildPathMatcher());
  o.add(buildPathMatcher());
  return o;
}

checkUnnamed2033(core.List<api.PathMatcher> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkPathMatcher(o[0]);
  checkPathMatcher(o[1]);
}

buildUnnamed2034() {
  var o = new core.List<api.UrlMapTest>();
  o.add(buildUrlMapTest());
  o.add(buildUrlMapTest());
  return o;
}

checkUnnamed2034(core.List<api.UrlMapTest> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkUrlMapTest(o[0]);
  checkUrlMapTest(o[1]);
}

core.int buildCounterUrlMap = 0;
buildUrlMap() {
  var o = new api.UrlMap();
  buildCounterUrlMap++;
  if (buildCounterUrlMap < 3) {
    o.creationTimestamp = "foo";
    o.defaultService = "foo";
    o.description = "foo";
    o.fingerprint = "foo";
    o.hostRules = buildUnnamed2032();
    o.id = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.pathMatchers = buildUnnamed2033();
    o.selfLink = "foo";
    o.tests = buildUnnamed2034();
  }
  buildCounterUrlMap--;
  return o;
}

checkUrlMap(api.UrlMap o) {
  buildCounterUrlMap++;
  if (buildCounterUrlMap < 3) {
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.defaultService, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.fingerprint, unittest.equals('foo'));
    checkUnnamed2032(o.hostRules);
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    checkUnnamed2033(o.pathMatchers);
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkUnnamed2034(o.tests);
  }
  buildCounterUrlMap--;
}

buildUnnamed2035() {
  var o = new core.List<api.UrlMap>();
  o.add(buildUrlMap());
  o.add(buildUrlMap());
  return o;
}

checkUnnamed2035(core.List<api.UrlMap> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkUrlMap(o[0]);
  checkUrlMap(o[1]);
}

core.int buildCounterUrlMapListWarningData = 0;
buildUrlMapListWarningData() {
  var o = new api.UrlMapListWarningData();
  buildCounterUrlMapListWarningData++;
  if (buildCounterUrlMapListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterUrlMapListWarningData--;
  return o;
}

checkUrlMapListWarningData(api.UrlMapListWarningData o) {
  buildCounterUrlMapListWarningData++;
  if (buildCounterUrlMapListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterUrlMapListWarningData--;
}

buildUnnamed2036() {
  var o = new core.List<api.UrlMapListWarningData>();
  o.add(buildUrlMapListWarningData());
  o.add(buildUrlMapListWarningData());
  return o;
}

checkUnnamed2036(core.List<api.UrlMapListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkUrlMapListWarningData(o[0]);
  checkUrlMapListWarningData(o[1]);
}

core.int buildCounterUrlMapListWarning = 0;
buildUrlMapListWarning() {
  var o = new api.UrlMapListWarning();
  buildCounterUrlMapListWarning++;
  if (buildCounterUrlMapListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed2036();
    o.message = "foo";
  }
  buildCounterUrlMapListWarning--;
  return o;
}

checkUrlMapListWarning(api.UrlMapListWarning o) {
  buildCounterUrlMapListWarning++;
  if (buildCounterUrlMapListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed2036(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterUrlMapListWarning--;
}

core.int buildCounterUrlMapList = 0;
buildUrlMapList() {
  var o = new api.UrlMapList();
  buildCounterUrlMapList++;
  if (buildCounterUrlMapList < 3) {
    o.id = "foo";
    o.items = buildUnnamed2035();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildUrlMapListWarning();
  }
  buildCounterUrlMapList--;
  return o;
}

checkUrlMapList(api.UrlMapList o) {
  buildCounterUrlMapList++;
  if (buildCounterUrlMapList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed2035(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkUrlMapListWarning(o.warning);
  }
  buildCounterUrlMapList--;
}

core.int buildCounterUrlMapReference = 0;
buildUrlMapReference() {
  var o = new api.UrlMapReference();
  buildCounterUrlMapReference++;
  if (buildCounterUrlMapReference < 3) {
    o.urlMap = "foo";
  }
  buildCounterUrlMapReference--;
  return o;
}

checkUrlMapReference(api.UrlMapReference o) {
  buildCounterUrlMapReference++;
  if (buildCounterUrlMapReference < 3) {
    unittest.expect(o.urlMap, unittest.equals('foo'));
  }
  buildCounterUrlMapReference--;
}

core.int buildCounterUrlMapTest = 0;
buildUrlMapTest() {
  var o = new api.UrlMapTest();
  buildCounterUrlMapTest++;
  if (buildCounterUrlMapTest < 3) {
    o.description = "foo";
    o.host = "foo";
    o.path = "foo";
    o.service = "foo";
  }
  buildCounterUrlMapTest--;
  return o;
}

checkUrlMapTest(api.UrlMapTest o) {
  buildCounterUrlMapTest++;
  if (buildCounterUrlMapTest < 3) {
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.host, unittest.equals('foo'));
    unittest.expect(o.path, unittest.equals('foo'));
    unittest.expect(o.service, unittest.equals('foo'));
  }
  buildCounterUrlMapTest--;
}

buildUnnamed2037() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed2037(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

buildUnnamed2038() {
  var o = new core.List<api.TestFailure>();
  o.add(buildTestFailure());
  o.add(buildTestFailure());
  return o;
}

checkUnnamed2038(core.List<api.TestFailure> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkTestFailure(o[0]);
  checkTestFailure(o[1]);
}

core.int buildCounterUrlMapValidationResult = 0;
buildUrlMapValidationResult() {
  var o = new api.UrlMapValidationResult();
  buildCounterUrlMapValidationResult++;
  if (buildCounterUrlMapValidationResult < 3) {
    o.loadErrors = buildUnnamed2037();
    o.loadSucceeded = true;
    o.testFailures = buildUnnamed2038();
    o.testPassed = true;
  }
  buildCounterUrlMapValidationResult--;
  return o;
}

checkUrlMapValidationResult(api.UrlMapValidationResult o) {
  buildCounterUrlMapValidationResult++;
  if (buildCounterUrlMapValidationResult < 3) {
    checkUnnamed2037(o.loadErrors);
    unittest.expect(o.loadSucceeded, unittest.isTrue);
    checkUnnamed2038(o.testFailures);
    unittest.expect(o.testPassed, unittest.isTrue);
  }
  buildCounterUrlMapValidationResult--;
}

core.int buildCounterUrlMapsValidateRequest = 0;
buildUrlMapsValidateRequest() {
  var o = new api.UrlMapsValidateRequest();
  buildCounterUrlMapsValidateRequest++;
  if (buildCounterUrlMapsValidateRequest < 3) {
    o.resource = buildUrlMap();
  }
  buildCounterUrlMapsValidateRequest--;
  return o;
}

checkUrlMapsValidateRequest(api.UrlMapsValidateRequest o) {
  buildCounterUrlMapsValidateRequest++;
  if (buildCounterUrlMapsValidateRequest < 3) {
    checkUrlMap(o.resource);
  }
  buildCounterUrlMapsValidateRequest--;
}

core.int buildCounterUrlMapsValidateResponse = 0;
buildUrlMapsValidateResponse() {
  var o = new api.UrlMapsValidateResponse();
  buildCounterUrlMapsValidateResponse++;
  if (buildCounterUrlMapsValidateResponse < 3) {
    o.result = buildUrlMapValidationResult();
  }
  buildCounterUrlMapsValidateResponse--;
  return o;
}

checkUrlMapsValidateResponse(api.UrlMapsValidateResponse o) {
  buildCounterUrlMapsValidateResponse++;
  if (buildCounterUrlMapsValidateResponse < 3) {
    checkUrlMapValidationResult(o.result);
  }
  buildCounterUrlMapsValidateResponse--;
}

buildUnnamed2039() {
  var o = new core.List<api.UsableSubnetworkSecondaryRange>();
  o.add(buildUsableSubnetworkSecondaryRange());
  o.add(buildUsableSubnetworkSecondaryRange());
  return o;
}

checkUnnamed2039(core.List<api.UsableSubnetworkSecondaryRange> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkUsableSubnetworkSecondaryRange(o[0]);
  checkUsableSubnetworkSecondaryRange(o[1]);
}

core.int buildCounterUsableSubnetwork = 0;
buildUsableSubnetwork() {
  var o = new api.UsableSubnetwork();
  buildCounterUsableSubnetwork++;
  if (buildCounterUsableSubnetwork < 3) {
    o.ipCidrRange = "foo";
    o.network = "foo";
    o.secondaryIpRanges = buildUnnamed2039();
    o.subnetwork = "foo";
  }
  buildCounterUsableSubnetwork--;
  return o;
}

checkUsableSubnetwork(api.UsableSubnetwork o) {
  buildCounterUsableSubnetwork++;
  if (buildCounterUsableSubnetwork < 3) {
    unittest.expect(o.ipCidrRange, unittest.equals('foo'));
    unittest.expect(o.network, unittest.equals('foo'));
    checkUnnamed2039(o.secondaryIpRanges);
    unittest.expect(o.subnetwork, unittest.equals('foo'));
  }
  buildCounterUsableSubnetwork--;
}

core.int buildCounterUsableSubnetworkSecondaryRange = 0;
buildUsableSubnetworkSecondaryRange() {
  var o = new api.UsableSubnetworkSecondaryRange();
  buildCounterUsableSubnetworkSecondaryRange++;
  if (buildCounterUsableSubnetworkSecondaryRange < 3) {
    o.ipCidrRange = "foo";
    o.rangeName = "foo";
  }
  buildCounterUsableSubnetworkSecondaryRange--;
  return o;
}

checkUsableSubnetworkSecondaryRange(api.UsableSubnetworkSecondaryRange o) {
  buildCounterUsableSubnetworkSecondaryRange++;
  if (buildCounterUsableSubnetworkSecondaryRange < 3) {
    unittest.expect(o.ipCidrRange, unittest.equals('foo'));
    unittest.expect(o.rangeName, unittest.equals('foo'));
  }
  buildCounterUsableSubnetworkSecondaryRange--;
}

buildUnnamed2040() {
  var o = new core.List<api.UsableSubnetwork>();
  o.add(buildUsableSubnetwork());
  o.add(buildUsableSubnetwork());
  return o;
}

checkUnnamed2040(core.List<api.UsableSubnetwork> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkUsableSubnetwork(o[0]);
  checkUsableSubnetwork(o[1]);
}

core.int buildCounterUsableSubnetworksAggregatedListWarningData = 0;
buildUsableSubnetworksAggregatedListWarningData() {
  var o = new api.UsableSubnetworksAggregatedListWarningData();
  buildCounterUsableSubnetworksAggregatedListWarningData++;
  if (buildCounterUsableSubnetworksAggregatedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterUsableSubnetworksAggregatedListWarningData--;
  return o;
}

checkUsableSubnetworksAggregatedListWarningData(
    api.UsableSubnetworksAggregatedListWarningData o) {
  buildCounterUsableSubnetworksAggregatedListWarningData++;
  if (buildCounterUsableSubnetworksAggregatedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterUsableSubnetworksAggregatedListWarningData--;
}

buildUnnamed2041() {
  var o = new core.List<api.UsableSubnetworksAggregatedListWarningData>();
  o.add(buildUsableSubnetworksAggregatedListWarningData());
  o.add(buildUsableSubnetworksAggregatedListWarningData());
  return o;
}

checkUnnamed2041(core.List<api.UsableSubnetworksAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkUsableSubnetworksAggregatedListWarningData(o[0]);
  checkUsableSubnetworksAggregatedListWarningData(o[1]);
}

core.int buildCounterUsableSubnetworksAggregatedListWarning = 0;
buildUsableSubnetworksAggregatedListWarning() {
  var o = new api.UsableSubnetworksAggregatedListWarning();
  buildCounterUsableSubnetworksAggregatedListWarning++;
  if (buildCounterUsableSubnetworksAggregatedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed2041();
    o.message = "foo";
  }
  buildCounterUsableSubnetworksAggregatedListWarning--;
  return o;
}

checkUsableSubnetworksAggregatedListWarning(
    api.UsableSubnetworksAggregatedListWarning o) {
  buildCounterUsableSubnetworksAggregatedListWarning++;
  if (buildCounterUsableSubnetworksAggregatedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed2041(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterUsableSubnetworksAggregatedListWarning--;
}

core.int buildCounterUsableSubnetworksAggregatedList = 0;
buildUsableSubnetworksAggregatedList() {
  var o = new api.UsableSubnetworksAggregatedList();
  buildCounterUsableSubnetworksAggregatedList++;
  if (buildCounterUsableSubnetworksAggregatedList < 3) {
    o.id = "foo";
    o.items = buildUnnamed2040();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildUsableSubnetworksAggregatedListWarning();
  }
  buildCounterUsableSubnetworksAggregatedList--;
  return o;
}

checkUsableSubnetworksAggregatedList(api.UsableSubnetworksAggregatedList o) {
  buildCounterUsableSubnetworksAggregatedList++;
  if (buildCounterUsableSubnetworksAggregatedList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed2040(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkUsableSubnetworksAggregatedListWarning(o.warning);
  }
  buildCounterUsableSubnetworksAggregatedList--;
}

core.int buildCounterUsageExportLocation = 0;
buildUsageExportLocation() {
  var o = new api.UsageExportLocation();
  buildCounterUsageExportLocation++;
  if (buildCounterUsageExportLocation < 3) {
    o.bucketName = "foo";
    o.reportNamePrefix = "foo";
  }
  buildCounterUsageExportLocation--;
  return o;
}

checkUsageExportLocation(api.UsageExportLocation o) {
  buildCounterUsageExportLocation++;
  if (buildCounterUsageExportLocation < 3) {
    unittest.expect(o.bucketName, unittest.equals('foo'));
    unittest.expect(o.reportNamePrefix, unittest.equals('foo'));
  }
  buildCounterUsageExportLocation--;
}

buildUnnamed2042() {
  var o = new core.List<api.VmEndpointNatMappingsInterfaceNatMappings>();
  o.add(buildVmEndpointNatMappingsInterfaceNatMappings());
  o.add(buildVmEndpointNatMappingsInterfaceNatMappings());
  return o;
}

checkUnnamed2042(core.List<api.VmEndpointNatMappingsInterfaceNatMappings> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkVmEndpointNatMappingsInterfaceNatMappings(o[0]);
  checkVmEndpointNatMappingsInterfaceNatMappings(o[1]);
}

core.int buildCounterVmEndpointNatMappings = 0;
buildVmEndpointNatMappings() {
  var o = new api.VmEndpointNatMappings();
  buildCounterVmEndpointNatMappings++;
  if (buildCounterVmEndpointNatMappings < 3) {
    o.instanceName = "foo";
    o.interfaceNatMappings = buildUnnamed2042();
  }
  buildCounterVmEndpointNatMappings--;
  return o;
}

checkVmEndpointNatMappings(api.VmEndpointNatMappings o) {
  buildCounterVmEndpointNatMappings++;
  if (buildCounterVmEndpointNatMappings < 3) {
    unittest.expect(o.instanceName, unittest.equals('foo'));
    checkUnnamed2042(o.interfaceNatMappings);
  }
  buildCounterVmEndpointNatMappings--;
}

buildUnnamed2043() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed2043(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterVmEndpointNatMappingsInterfaceNatMappings = 0;
buildVmEndpointNatMappingsInterfaceNatMappings() {
  var o = new api.VmEndpointNatMappingsInterfaceNatMappings();
  buildCounterVmEndpointNatMappingsInterfaceNatMappings++;
  if (buildCounterVmEndpointNatMappingsInterfaceNatMappings < 3) {
    o.natIpPortRanges = buildUnnamed2043();
    o.numTotalNatPorts = 42;
    o.sourceAliasIpRange = "foo";
    o.sourceVirtualIp = "foo";
  }
  buildCounterVmEndpointNatMappingsInterfaceNatMappings--;
  return o;
}

checkVmEndpointNatMappingsInterfaceNatMappings(
    api.VmEndpointNatMappingsInterfaceNatMappings o) {
  buildCounterVmEndpointNatMappingsInterfaceNatMappings++;
  if (buildCounterVmEndpointNatMappingsInterfaceNatMappings < 3) {
    checkUnnamed2043(o.natIpPortRanges);
    unittest.expect(o.numTotalNatPorts, unittest.equals(42));
    unittest.expect(o.sourceAliasIpRange, unittest.equals('foo'));
    unittest.expect(o.sourceVirtualIp, unittest.equals('foo'));
  }
  buildCounterVmEndpointNatMappingsInterfaceNatMappings--;
}

buildUnnamed2044() {
  var o = new core.List<api.VmEndpointNatMappings>();
  o.add(buildVmEndpointNatMappings());
  o.add(buildVmEndpointNatMappings());
  return o;
}

checkUnnamed2044(core.List<api.VmEndpointNatMappings> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkVmEndpointNatMappings(o[0]);
  checkVmEndpointNatMappings(o[1]);
}

core.int buildCounterVmEndpointNatMappingsListWarningData = 0;
buildVmEndpointNatMappingsListWarningData() {
  var o = new api.VmEndpointNatMappingsListWarningData();
  buildCounterVmEndpointNatMappingsListWarningData++;
  if (buildCounterVmEndpointNatMappingsListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterVmEndpointNatMappingsListWarningData--;
  return o;
}

checkVmEndpointNatMappingsListWarningData(
    api.VmEndpointNatMappingsListWarningData o) {
  buildCounterVmEndpointNatMappingsListWarningData++;
  if (buildCounterVmEndpointNatMappingsListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterVmEndpointNatMappingsListWarningData--;
}

buildUnnamed2045() {
  var o = new core.List<api.VmEndpointNatMappingsListWarningData>();
  o.add(buildVmEndpointNatMappingsListWarningData());
  o.add(buildVmEndpointNatMappingsListWarningData());
  return o;
}

checkUnnamed2045(core.List<api.VmEndpointNatMappingsListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkVmEndpointNatMappingsListWarningData(o[0]);
  checkVmEndpointNatMappingsListWarningData(o[1]);
}

core.int buildCounterVmEndpointNatMappingsListWarning = 0;
buildVmEndpointNatMappingsListWarning() {
  var o = new api.VmEndpointNatMappingsListWarning();
  buildCounterVmEndpointNatMappingsListWarning++;
  if (buildCounterVmEndpointNatMappingsListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed2045();
    o.message = "foo";
  }
  buildCounterVmEndpointNatMappingsListWarning--;
  return o;
}

checkVmEndpointNatMappingsListWarning(api.VmEndpointNatMappingsListWarning o) {
  buildCounterVmEndpointNatMappingsListWarning++;
  if (buildCounterVmEndpointNatMappingsListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed2045(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterVmEndpointNatMappingsListWarning--;
}

core.int buildCounterVmEndpointNatMappingsList = 0;
buildVmEndpointNatMappingsList() {
  var o = new api.VmEndpointNatMappingsList();
  buildCounterVmEndpointNatMappingsList++;
  if (buildCounterVmEndpointNatMappingsList < 3) {
    o.id = "foo";
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.result = buildUnnamed2044();
    o.selfLink = "foo";
    o.warning = buildVmEndpointNatMappingsListWarning();
  }
  buildCounterVmEndpointNatMappingsList--;
  return o;
}

checkVmEndpointNatMappingsList(api.VmEndpointNatMappingsList o) {
  buildCounterVmEndpointNatMappingsList++;
  if (buildCounterVmEndpointNatMappingsList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    checkUnnamed2044(o.result);
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkVmEndpointNatMappingsListWarning(o.warning);
  }
  buildCounterVmEndpointNatMappingsList--;
}

buildUnnamed2046() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed2046(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

buildUnnamed2047() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed2047(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterVpnTunnel = 0;
buildVpnTunnel() {
  var o = new api.VpnTunnel();
  buildCounterVpnTunnel++;
  if (buildCounterVpnTunnel < 3) {
    o.creationTimestamp = "foo";
    o.description = "foo";
    o.detailedStatus = "foo";
    o.id = "foo";
    o.ikeVersion = 42;
    o.kind = "foo";
    o.localTrafficSelector = buildUnnamed2046();
    o.name = "foo";
    o.peerIp = "foo";
    o.region = "foo";
    o.remoteTrafficSelector = buildUnnamed2047();
    o.router = "foo";
    o.selfLink = "foo";
    o.sharedSecret = "foo";
    o.sharedSecretHash = "foo";
    o.status = "foo";
    o.targetVpnGateway = "foo";
  }
  buildCounterVpnTunnel--;
  return o;
}

checkVpnTunnel(api.VpnTunnel o) {
  buildCounterVpnTunnel++;
  if (buildCounterVpnTunnel < 3) {
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.detailedStatus, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.ikeVersion, unittest.equals(42));
    unittest.expect(o.kind, unittest.equals('foo'));
    checkUnnamed2046(o.localTrafficSelector);
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.peerIp, unittest.equals('foo'));
    unittest.expect(o.region, unittest.equals('foo'));
    checkUnnamed2047(o.remoteTrafficSelector);
    unittest.expect(o.router, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.sharedSecret, unittest.equals('foo'));
    unittest.expect(o.sharedSecretHash, unittest.equals('foo'));
    unittest.expect(o.status, unittest.equals('foo'));
    unittest.expect(o.targetVpnGateway, unittest.equals('foo'));
  }
  buildCounterVpnTunnel--;
}

buildUnnamed2048() {
  var o = new core.Map<core.String, api.VpnTunnelsScopedList>();
  o["x"] = buildVpnTunnelsScopedList();
  o["y"] = buildVpnTunnelsScopedList();
  return o;
}

checkUnnamed2048(core.Map<core.String, api.VpnTunnelsScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkVpnTunnelsScopedList(o["x"]);
  checkVpnTunnelsScopedList(o["y"]);
}

core.int buildCounterVpnTunnelAggregatedListWarningData = 0;
buildVpnTunnelAggregatedListWarningData() {
  var o = new api.VpnTunnelAggregatedListWarningData();
  buildCounterVpnTunnelAggregatedListWarningData++;
  if (buildCounterVpnTunnelAggregatedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterVpnTunnelAggregatedListWarningData--;
  return o;
}

checkVpnTunnelAggregatedListWarningData(
    api.VpnTunnelAggregatedListWarningData o) {
  buildCounterVpnTunnelAggregatedListWarningData++;
  if (buildCounterVpnTunnelAggregatedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterVpnTunnelAggregatedListWarningData--;
}

buildUnnamed2049() {
  var o = new core.List<api.VpnTunnelAggregatedListWarningData>();
  o.add(buildVpnTunnelAggregatedListWarningData());
  o.add(buildVpnTunnelAggregatedListWarningData());
  return o;
}

checkUnnamed2049(core.List<api.VpnTunnelAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkVpnTunnelAggregatedListWarningData(o[0]);
  checkVpnTunnelAggregatedListWarningData(o[1]);
}

core.int buildCounterVpnTunnelAggregatedListWarning = 0;
buildVpnTunnelAggregatedListWarning() {
  var o = new api.VpnTunnelAggregatedListWarning();
  buildCounterVpnTunnelAggregatedListWarning++;
  if (buildCounterVpnTunnelAggregatedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed2049();
    o.message = "foo";
  }
  buildCounterVpnTunnelAggregatedListWarning--;
  return o;
}

checkVpnTunnelAggregatedListWarning(api.VpnTunnelAggregatedListWarning o) {
  buildCounterVpnTunnelAggregatedListWarning++;
  if (buildCounterVpnTunnelAggregatedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed2049(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterVpnTunnelAggregatedListWarning--;
}

core.int buildCounterVpnTunnelAggregatedList = 0;
buildVpnTunnelAggregatedList() {
  var o = new api.VpnTunnelAggregatedList();
  buildCounterVpnTunnelAggregatedList++;
  if (buildCounterVpnTunnelAggregatedList < 3) {
    o.id = "foo";
    o.items = buildUnnamed2048();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildVpnTunnelAggregatedListWarning();
  }
  buildCounterVpnTunnelAggregatedList--;
  return o;
}

checkVpnTunnelAggregatedList(api.VpnTunnelAggregatedList o) {
  buildCounterVpnTunnelAggregatedList++;
  if (buildCounterVpnTunnelAggregatedList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed2048(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkVpnTunnelAggregatedListWarning(o.warning);
  }
  buildCounterVpnTunnelAggregatedList--;
}

buildUnnamed2050() {
  var o = new core.List<api.VpnTunnel>();
  o.add(buildVpnTunnel());
  o.add(buildVpnTunnel());
  return o;
}

checkUnnamed2050(core.List<api.VpnTunnel> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkVpnTunnel(o[0]);
  checkVpnTunnel(o[1]);
}

core.int buildCounterVpnTunnelListWarningData = 0;
buildVpnTunnelListWarningData() {
  var o = new api.VpnTunnelListWarningData();
  buildCounterVpnTunnelListWarningData++;
  if (buildCounterVpnTunnelListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterVpnTunnelListWarningData--;
  return o;
}

checkVpnTunnelListWarningData(api.VpnTunnelListWarningData o) {
  buildCounterVpnTunnelListWarningData++;
  if (buildCounterVpnTunnelListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterVpnTunnelListWarningData--;
}

buildUnnamed2051() {
  var o = new core.List<api.VpnTunnelListWarningData>();
  o.add(buildVpnTunnelListWarningData());
  o.add(buildVpnTunnelListWarningData());
  return o;
}

checkUnnamed2051(core.List<api.VpnTunnelListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkVpnTunnelListWarningData(o[0]);
  checkVpnTunnelListWarningData(o[1]);
}

core.int buildCounterVpnTunnelListWarning = 0;
buildVpnTunnelListWarning() {
  var o = new api.VpnTunnelListWarning();
  buildCounterVpnTunnelListWarning++;
  if (buildCounterVpnTunnelListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed2051();
    o.message = "foo";
  }
  buildCounterVpnTunnelListWarning--;
  return o;
}

checkVpnTunnelListWarning(api.VpnTunnelListWarning o) {
  buildCounterVpnTunnelListWarning++;
  if (buildCounterVpnTunnelListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed2051(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterVpnTunnelListWarning--;
}

core.int buildCounterVpnTunnelList = 0;
buildVpnTunnelList() {
  var o = new api.VpnTunnelList();
  buildCounterVpnTunnelList++;
  if (buildCounterVpnTunnelList < 3) {
    o.id = "foo";
    o.items = buildUnnamed2050();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildVpnTunnelListWarning();
  }
  buildCounterVpnTunnelList--;
  return o;
}

checkVpnTunnelList(api.VpnTunnelList o) {
  buildCounterVpnTunnelList++;
  if (buildCounterVpnTunnelList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed2050(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkVpnTunnelListWarning(o.warning);
  }
  buildCounterVpnTunnelList--;
}

buildUnnamed2052() {
  var o = new core.List<api.VpnTunnel>();
  o.add(buildVpnTunnel());
  o.add(buildVpnTunnel());
  return o;
}

checkUnnamed2052(core.List<api.VpnTunnel> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkVpnTunnel(o[0]);
  checkVpnTunnel(o[1]);
}

core.int buildCounterVpnTunnelsScopedListWarningData = 0;
buildVpnTunnelsScopedListWarningData() {
  var o = new api.VpnTunnelsScopedListWarningData();
  buildCounterVpnTunnelsScopedListWarningData++;
  if (buildCounterVpnTunnelsScopedListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterVpnTunnelsScopedListWarningData--;
  return o;
}

checkVpnTunnelsScopedListWarningData(api.VpnTunnelsScopedListWarningData o) {
  buildCounterVpnTunnelsScopedListWarningData++;
  if (buildCounterVpnTunnelsScopedListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterVpnTunnelsScopedListWarningData--;
}

buildUnnamed2053() {
  var o = new core.List<api.VpnTunnelsScopedListWarningData>();
  o.add(buildVpnTunnelsScopedListWarningData());
  o.add(buildVpnTunnelsScopedListWarningData());
  return o;
}

checkUnnamed2053(core.List<api.VpnTunnelsScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkVpnTunnelsScopedListWarningData(o[0]);
  checkVpnTunnelsScopedListWarningData(o[1]);
}

core.int buildCounterVpnTunnelsScopedListWarning = 0;
buildVpnTunnelsScopedListWarning() {
  var o = new api.VpnTunnelsScopedListWarning();
  buildCounterVpnTunnelsScopedListWarning++;
  if (buildCounterVpnTunnelsScopedListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed2053();
    o.message = "foo";
  }
  buildCounterVpnTunnelsScopedListWarning--;
  return o;
}

checkVpnTunnelsScopedListWarning(api.VpnTunnelsScopedListWarning o) {
  buildCounterVpnTunnelsScopedListWarning++;
  if (buildCounterVpnTunnelsScopedListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed2053(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterVpnTunnelsScopedListWarning--;
}

core.int buildCounterVpnTunnelsScopedList = 0;
buildVpnTunnelsScopedList() {
  var o = new api.VpnTunnelsScopedList();
  buildCounterVpnTunnelsScopedList++;
  if (buildCounterVpnTunnelsScopedList < 3) {
    o.vpnTunnels = buildUnnamed2052();
    o.warning = buildVpnTunnelsScopedListWarning();
  }
  buildCounterVpnTunnelsScopedList--;
  return o;
}

checkVpnTunnelsScopedList(api.VpnTunnelsScopedList o) {
  buildCounterVpnTunnelsScopedList++;
  if (buildCounterVpnTunnelsScopedList < 3) {
    checkUnnamed2052(o.vpnTunnels);
    checkVpnTunnelsScopedListWarning(o.warning);
  }
  buildCounterVpnTunnelsScopedList--;
}

buildUnnamed2054() {
  var o = new core.List<api.Project>();
  o.add(buildProject());
  o.add(buildProject());
  return o;
}

checkUnnamed2054(core.List<api.Project> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkProject(o[0]);
  checkProject(o[1]);
}

core.int buildCounterXpnHostListWarningData = 0;
buildXpnHostListWarningData() {
  var o = new api.XpnHostListWarningData();
  buildCounterXpnHostListWarningData++;
  if (buildCounterXpnHostListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterXpnHostListWarningData--;
  return o;
}

checkXpnHostListWarningData(api.XpnHostListWarningData o) {
  buildCounterXpnHostListWarningData++;
  if (buildCounterXpnHostListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterXpnHostListWarningData--;
}

buildUnnamed2055() {
  var o = new core.List<api.XpnHostListWarningData>();
  o.add(buildXpnHostListWarningData());
  o.add(buildXpnHostListWarningData());
  return o;
}

checkUnnamed2055(core.List<api.XpnHostListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkXpnHostListWarningData(o[0]);
  checkXpnHostListWarningData(o[1]);
}

core.int buildCounterXpnHostListWarning = 0;
buildXpnHostListWarning() {
  var o = new api.XpnHostListWarning();
  buildCounterXpnHostListWarning++;
  if (buildCounterXpnHostListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed2055();
    o.message = "foo";
  }
  buildCounterXpnHostListWarning--;
  return o;
}

checkXpnHostListWarning(api.XpnHostListWarning o) {
  buildCounterXpnHostListWarning++;
  if (buildCounterXpnHostListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed2055(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterXpnHostListWarning--;
}

core.int buildCounterXpnHostList = 0;
buildXpnHostList() {
  var o = new api.XpnHostList();
  buildCounterXpnHostList++;
  if (buildCounterXpnHostList < 3) {
    o.id = "foo";
    o.items = buildUnnamed2054();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildXpnHostListWarning();
  }
  buildCounterXpnHostList--;
  return o;
}

checkXpnHostList(api.XpnHostList o) {
  buildCounterXpnHostList++;
  if (buildCounterXpnHostList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed2054(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkXpnHostListWarning(o.warning);
  }
  buildCounterXpnHostList--;
}

core.int buildCounterXpnResourceId = 0;
buildXpnResourceId() {
  var o = new api.XpnResourceId();
  buildCounterXpnResourceId++;
  if (buildCounterXpnResourceId < 3) {
    o.id = "foo";
    o.type = "foo";
  }
  buildCounterXpnResourceId--;
  return o;
}

checkXpnResourceId(api.XpnResourceId o) {
  buildCounterXpnResourceId++;
  if (buildCounterXpnResourceId < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.type, unittest.equals('foo'));
  }
  buildCounterXpnResourceId--;
}

buildUnnamed2056() {
  var o = new core.List<core.String>();
  o.add("foo");
  o.add("foo");
  return o;
}

checkUnnamed2056(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o[0], unittest.equals('foo'));
  unittest.expect(o[1], unittest.equals('foo'));
}

core.int buildCounterZone = 0;
buildZone() {
  var o = new api.Zone();
  buildCounterZone++;
  if (buildCounterZone < 3) {
    o.availableCpuPlatforms = buildUnnamed2056();
    o.creationTimestamp = "foo";
    o.deprecated = buildDeprecationStatus();
    o.description = "foo";
    o.id = "foo";
    o.kind = "foo";
    o.name = "foo";
    o.region = "foo";
    o.selfLink = "foo";
    o.status = "foo";
  }
  buildCounterZone--;
  return o;
}

checkZone(api.Zone o) {
  buildCounterZone++;
  if (buildCounterZone < 3) {
    checkUnnamed2056(o.availableCpuPlatforms);
    unittest.expect(o.creationTimestamp, unittest.equals('foo'));
    checkDeprecationStatus(o.deprecated);
    unittest.expect(o.description, unittest.equals('foo'));
    unittest.expect(o.id, unittest.equals('foo'));
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.name, unittest.equals('foo'));
    unittest.expect(o.region, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    unittest.expect(o.status, unittest.equals('foo'));
  }
  buildCounterZone--;
}

buildUnnamed2057() {
  var o = new core.List<api.Zone>();
  o.add(buildZone());
  o.add(buildZone());
  return o;
}

checkUnnamed2057(core.List<api.Zone> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkZone(o[0]);
  checkZone(o[1]);
}

core.int buildCounterZoneListWarningData = 0;
buildZoneListWarningData() {
  var o = new api.ZoneListWarningData();
  buildCounterZoneListWarningData++;
  if (buildCounterZoneListWarningData < 3) {
    o.key = "foo";
    o.value = "foo";
  }
  buildCounterZoneListWarningData--;
  return o;
}

checkZoneListWarningData(api.ZoneListWarningData o) {
  buildCounterZoneListWarningData++;
  if (buildCounterZoneListWarningData < 3) {
    unittest.expect(o.key, unittest.equals('foo'));
    unittest.expect(o.value, unittest.equals('foo'));
  }
  buildCounterZoneListWarningData--;
}

buildUnnamed2058() {
  var o = new core.List<api.ZoneListWarningData>();
  o.add(buildZoneListWarningData());
  o.add(buildZoneListWarningData());
  return o;
}

checkUnnamed2058(core.List<api.ZoneListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkZoneListWarningData(o[0]);
  checkZoneListWarningData(o[1]);
}

core.int buildCounterZoneListWarning = 0;
buildZoneListWarning() {
  var o = new api.ZoneListWarning();
  buildCounterZoneListWarning++;
  if (buildCounterZoneListWarning < 3) {
    o.code = "foo";
    o.data = buildUnnamed2058();
    o.message = "foo";
  }
  buildCounterZoneListWarning--;
  return o;
}

checkZoneListWarning(api.ZoneListWarning o) {
  buildCounterZoneListWarning++;
  if (buildCounterZoneListWarning < 3) {
    unittest.expect(o.code, unittest.equals('foo'));
    checkUnnamed2058(o.data);
    unittest.expect(o.message, unittest.equals('foo'));
  }
  buildCounterZoneListWarning--;
}

core.int buildCounterZoneList = 0;
buildZoneList() {
  var o = new api.ZoneList();
  buildCounterZoneList++;
  if (buildCounterZoneList < 3) {
    o.id = "foo";
    o.items = buildUnnamed2057();
    o.kind = "foo";
    o.nextPageToken = "foo";
    o.selfLink = "foo";
    o.warning = buildZoneListWarning();
  }
  buildCounterZoneList--;
  return o;
}

checkZoneList(api.ZoneList o) {
  buildCounterZoneList++;
  if (buildCounterZoneList < 3) {
    unittest.expect(o.id, unittest.equals('foo'));
    checkUnnamed2057(o.items);
    unittest.expect(o.kind, unittest.equals('foo'));
    unittest.expect(o.nextPageToken, unittest.equals('foo'));
    unittest.expect(o.selfLink, unittest.equals('foo'));
    checkZoneListWarning(o.warning);
  }
  buildCounterZoneList--;
}

buildUnnamed2059() {
  var o = new core.Map<core.String, core.String>();
  o["x"] = "foo";
  o["y"] = "foo";
  return o;
}

checkUnnamed2059(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(o["x"], unittest.equals('foo'));
  unittest.expect(o["y"], unittest.equals('foo'));
}

core.int buildCounterZoneSetLabelsRequest = 0;
buildZoneSetLabelsRequest() {
  var o = new api.ZoneSetLabelsRequest();
  buildCounterZoneSetLabelsRequest++;
  if (buildCounterZoneSetLabelsRequest < 3) {
    o.labelFingerprint = "foo";
    o.labels = buildUnnamed2059();
  }
  buildCounterZoneSetLabelsRequest--;
  return o;
}

checkZoneSetLabelsRequest(api.ZoneSetLabelsRequest o) {
  buildCounterZoneSetLabelsRequest++;
  if (buildCounterZoneSetLabelsRequest < 3) {
    unittest.expect(o.labelFingerprint, unittest.equals('foo'));
    checkUnnamed2059(o.labels);
  }
  buildCounterZoneSetLabelsRequest--;
}

buildUnnamed2060() {
  var o = new core.List<api.Binding>();
  o.add(buildBinding());
  o.add(buildBinding());
  return o;
}

checkUnnamed2060(core.List<api.Binding> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBinding(o[0]);
  checkBinding(o[1]);
}

core.int buildCounterZoneSetPolicyRequest = 0;
buildZoneSetPolicyRequest() {
  var o = new api.ZoneSetPolicyRequest();
  buildCounterZoneSetPolicyRequest++;
  if (buildCounterZoneSetPolicyRequest < 3) {
    o.bindings = buildUnnamed2060();
    o.etag = "foo";
    o.policy = buildPolicy();
  }
  buildCounterZoneSetPolicyRequest--;
  return o;
}

checkZoneSetPolicyRequest(api.ZoneSetPolicyRequest o) {
  buildCounterZoneSetPolicyRequest++;
  if (buildCounterZoneSetPolicyRequest < 3) {
    checkUnnamed2060(o.bindings);
    unittest.expect(o.etag, unittest.equals('foo'));
    checkPolicy(o.policy);
  }
  buildCounterZoneSetPolicyRequest--;
}

main() {
  unittest.group("obj-schema-AcceleratorConfig", () {
    unittest.test("to-json--from-json", () {
      var o = buildAcceleratorConfig();
      var od = new api.AcceleratorConfig.fromJson(o.toJson());
      checkAcceleratorConfig(od);
    });
  });

  unittest.group("obj-schema-AcceleratorType", () {
    unittest.test("to-json--from-json", () {
      var o = buildAcceleratorType();
      var od = new api.AcceleratorType.fromJson(o.toJson());
      checkAcceleratorType(od);
    });
  });

  unittest.group("obj-schema-AcceleratorTypeAggregatedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildAcceleratorTypeAggregatedListWarningData();
      var od =
          new api.AcceleratorTypeAggregatedListWarningData.fromJson(o.toJson());
      checkAcceleratorTypeAggregatedListWarningData(od);
    });
  });

  unittest.group("obj-schema-AcceleratorTypeAggregatedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildAcceleratorTypeAggregatedListWarning();
      var od =
          new api.AcceleratorTypeAggregatedListWarning.fromJson(o.toJson());
      checkAcceleratorTypeAggregatedListWarning(od);
    });
  });

  unittest.group("obj-schema-AcceleratorTypeAggregatedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildAcceleratorTypeAggregatedList();
      var od = new api.AcceleratorTypeAggregatedList.fromJson(o.toJson());
      checkAcceleratorTypeAggregatedList(od);
    });
  });

  unittest.group("obj-schema-AcceleratorTypeListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildAcceleratorTypeListWarningData();
      var od = new api.AcceleratorTypeListWarningData.fromJson(o.toJson());
      checkAcceleratorTypeListWarningData(od);
    });
  });

  unittest.group("obj-schema-AcceleratorTypeListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildAcceleratorTypeListWarning();
      var od = new api.AcceleratorTypeListWarning.fromJson(o.toJson());
      checkAcceleratorTypeListWarning(od);
    });
  });

  unittest.group("obj-schema-AcceleratorTypeList", () {
    unittest.test("to-json--from-json", () {
      var o = buildAcceleratorTypeList();
      var od = new api.AcceleratorTypeList.fromJson(o.toJson());
      checkAcceleratorTypeList(od);
    });
  });

  unittest.group("obj-schema-AcceleratorTypesScopedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildAcceleratorTypesScopedListWarningData();
      var od =
          new api.AcceleratorTypesScopedListWarningData.fromJson(o.toJson());
      checkAcceleratorTypesScopedListWarningData(od);
    });
  });

  unittest.group("obj-schema-AcceleratorTypesScopedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildAcceleratorTypesScopedListWarning();
      var od = new api.AcceleratorTypesScopedListWarning.fromJson(o.toJson());
      checkAcceleratorTypesScopedListWarning(od);
    });
  });

  unittest.group("obj-schema-AcceleratorTypesScopedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildAcceleratorTypesScopedList();
      var od = new api.AcceleratorTypesScopedList.fromJson(o.toJson());
      checkAcceleratorTypesScopedList(od);
    });
  });

  unittest.group("obj-schema-AccessConfig", () {
    unittest.test("to-json--from-json", () {
      var o = buildAccessConfig();
      var od = new api.AccessConfig.fromJson(o.toJson());
      checkAccessConfig(od);
    });
  });

  unittest.group("obj-schema-Address", () {
    unittest.test("to-json--from-json", () {
      var o = buildAddress();
      var od = new api.Address.fromJson(o.toJson());
      checkAddress(od);
    });
  });

  unittest.group("obj-schema-AddressAggregatedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildAddressAggregatedListWarningData();
      var od = new api.AddressAggregatedListWarningData.fromJson(o.toJson());
      checkAddressAggregatedListWarningData(od);
    });
  });

  unittest.group("obj-schema-AddressAggregatedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildAddressAggregatedListWarning();
      var od = new api.AddressAggregatedListWarning.fromJson(o.toJson());
      checkAddressAggregatedListWarning(od);
    });
  });

  unittest.group("obj-schema-AddressAggregatedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildAddressAggregatedList();
      var od = new api.AddressAggregatedList.fromJson(o.toJson());
      checkAddressAggregatedList(od);
    });
  });

  unittest.group("obj-schema-AddressListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildAddressListWarningData();
      var od = new api.AddressListWarningData.fromJson(o.toJson());
      checkAddressListWarningData(od);
    });
  });

  unittest.group("obj-schema-AddressListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildAddressListWarning();
      var od = new api.AddressListWarning.fromJson(o.toJson());
      checkAddressListWarning(od);
    });
  });

  unittest.group("obj-schema-AddressList", () {
    unittest.test("to-json--from-json", () {
      var o = buildAddressList();
      var od = new api.AddressList.fromJson(o.toJson());
      checkAddressList(od);
    });
  });

  unittest.group("obj-schema-AddressesScopedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildAddressesScopedListWarningData();
      var od = new api.AddressesScopedListWarningData.fromJson(o.toJson());
      checkAddressesScopedListWarningData(od);
    });
  });

  unittest.group("obj-schema-AddressesScopedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildAddressesScopedListWarning();
      var od = new api.AddressesScopedListWarning.fromJson(o.toJson());
      checkAddressesScopedListWarning(od);
    });
  });

  unittest.group("obj-schema-AddressesScopedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildAddressesScopedList();
      var od = new api.AddressesScopedList.fromJson(o.toJson());
      checkAddressesScopedList(od);
    });
  });

  unittest.group("obj-schema-AliasIpRange", () {
    unittest.test("to-json--from-json", () {
      var o = buildAliasIpRange();
      var od = new api.AliasIpRange.fromJson(o.toJson());
      checkAliasIpRange(od);
    });
  });

  unittest.group(
      "obj-schema-AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk",
      () {
    unittest.test("to-json--from-json", () {
      var o =
          buildAllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk();
      var od = new api
              .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk.fromJson(
          o.toJson());
      checkAllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk(
          od);
    });
  });

  unittest.group(
      "obj-schema-AllocationSpecificSKUAllocationReservedInstanceProperties",
      () {
    unittest.test("to-json--from-json", () {
      var o = buildAllocationSpecificSKUAllocationReservedInstanceProperties();
      var od = new api
              .AllocationSpecificSKUAllocationReservedInstanceProperties.fromJson(
          o.toJson());
      checkAllocationSpecificSKUAllocationReservedInstanceProperties(od);
    });
  });

  unittest.group("obj-schema-AllocationSpecificSKUReservation", () {
    unittest.test("to-json--from-json", () {
      var o = buildAllocationSpecificSKUReservation();
      var od = new api.AllocationSpecificSKUReservation.fromJson(o.toJson());
      checkAllocationSpecificSKUReservation(od);
    });
  });

  unittest.group("obj-schema-AttachedDisk", () {
    unittest.test("to-json--from-json", () {
      var o = buildAttachedDisk();
      var od = new api.AttachedDisk.fromJson(o.toJson());
      checkAttachedDisk(od);
    });
  });

  unittest.group("obj-schema-AttachedDiskInitializeParams", () {
    unittest.test("to-json--from-json", () {
      var o = buildAttachedDiskInitializeParams();
      var od = new api.AttachedDiskInitializeParams.fromJson(o.toJson());
      checkAttachedDiskInitializeParams(od);
    });
  });

  unittest.group("obj-schema-AuditConfig", () {
    unittest.test("to-json--from-json", () {
      var o = buildAuditConfig();
      var od = new api.AuditConfig.fromJson(o.toJson());
      checkAuditConfig(od);
    });
  });

  unittest.group("obj-schema-AuditLogConfig", () {
    unittest.test("to-json--from-json", () {
      var o = buildAuditLogConfig();
      var od = new api.AuditLogConfig.fromJson(o.toJson());
      checkAuditLogConfig(od);
    });
  });

  unittest.group("obj-schema-AuthorizationLoggingOptions", () {
    unittest.test("to-json--from-json", () {
      var o = buildAuthorizationLoggingOptions();
      var od = new api.AuthorizationLoggingOptions.fromJson(o.toJson());
      checkAuthorizationLoggingOptions(od);
    });
  });

  unittest.group("obj-schema-Autoscaler", () {
    unittest.test("to-json--from-json", () {
      var o = buildAutoscaler();
      var od = new api.Autoscaler.fromJson(o.toJson());
      checkAutoscaler(od);
    });
  });

  unittest.group("obj-schema-AutoscalerAggregatedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildAutoscalerAggregatedListWarningData();
      var od = new api.AutoscalerAggregatedListWarningData.fromJson(o.toJson());
      checkAutoscalerAggregatedListWarningData(od);
    });
  });

  unittest.group("obj-schema-AutoscalerAggregatedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildAutoscalerAggregatedListWarning();
      var od = new api.AutoscalerAggregatedListWarning.fromJson(o.toJson());
      checkAutoscalerAggregatedListWarning(od);
    });
  });

  unittest.group("obj-schema-AutoscalerAggregatedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildAutoscalerAggregatedList();
      var od = new api.AutoscalerAggregatedList.fromJson(o.toJson());
      checkAutoscalerAggregatedList(od);
    });
  });

  unittest.group("obj-schema-AutoscalerListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildAutoscalerListWarningData();
      var od = new api.AutoscalerListWarningData.fromJson(o.toJson());
      checkAutoscalerListWarningData(od);
    });
  });

  unittest.group("obj-schema-AutoscalerListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildAutoscalerListWarning();
      var od = new api.AutoscalerListWarning.fromJson(o.toJson());
      checkAutoscalerListWarning(od);
    });
  });

  unittest.group("obj-schema-AutoscalerList", () {
    unittest.test("to-json--from-json", () {
      var o = buildAutoscalerList();
      var od = new api.AutoscalerList.fromJson(o.toJson());
      checkAutoscalerList(od);
    });
  });

  unittest.group("obj-schema-AutoscalerStatusDetails", () {
    unittest.test("to-json--from-json", () {
      var o = buildAutoscalerStatusDetails();
      var od = new api.AutoscalerStatusDetails.fromJson(o.toJson());
      checkAutoscalerStatusDetails(od);
    });
  });

  unittest.group("obj-schema-AutoscalersScopedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildAutoscalersScopedListWarningData();
      var od = new api.AutoscalersScopedListWarningData.fromJson(o.toJson());
      checkAutoscalersScopedListWarningData(od);
    });
  });

  unittest.group("obj-schema-AutoscalersScopedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildAutoscalersScopedListWarning();
      var od = new api.AutoscalersScopedListWarning.fromJson(o.toJson());
      checkAutoscalersScopedListWarning(od);
    });
  });

  unittest.group("obj-schema-AutoscalersScopedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildAutoscalersScopedList();
      var od = new api.AutoscalersScopedList.fromJson(o.toJson());
      checkAutoscalersScopedList(od);
    });
  });

  unittest.group("obj-schema-AutoscalingPolicy", () {
    unittest.test("to-json--from-json", () {
      var o = buildAutoscalingPolicy();
      var od = new api.AutoscalingPolicy.fromJson(o.toJson());
      checkAutoscalingPolicy(od);
    });
  });

  unittest.group("obj-schema-AutoscalingPolicyCpuUtilization", () {
    unittest.test("to-json--from-json", () {
      var o = buildAutoscalingPolicyCpuUtilization();
      var od = new api.AutoscalingPolicyCpuUtilization.fromJson(o.toJson());
      checkAutoscalingPolicyCpuUtilization(od);
    });
  });

  unittest.group("obj-schema-AutoscalingPolicyCustomMetricUtilization", () {
    unittest.test("to-json--from-json", () {
      var o = buildAutoscalingPolicyCustomMetricUtilization();
      var od =
          new api.AutoscalingPolicyCustomMetricUtilization.fromJson(o.toJson());
      checkAutoscalingPolicyCustomMetricUtilization(od);
    });
  });

  unittest.group("obj-schema-AutoscalingPolicyLoadBalancingUtilization", () {
    unittest.test("to-json--from-json", () {
      var o = buildAutoscalingPolicyLoadBalancingUtilization();
      var od = new api.AutoscalingPolicyLoadBalancingUtilization.fromJson(
          o.toJson());
      checkAutoscalingPolicyLoadBalancingUtilization(od);
    });
  });

  unittest.group("obj-schema-Backend", () {
    unittest.test("to-json--from-json", () {
      var o = buildBackend();
      var od = new api.Backend.fromJson(o.toJson());
      checkBackend(od);
    });
  });

  unittest.group("obj-schema-BackendBucket", () {
    unittest.test("to-json--from-json", () {
      var o = buildBackendBucket();
      var od = new api.BackendBucket.fromJson(o.toJson());
      checkBackendBucket(od);
    });
  });

  unittest.group("obj-schema-BackendBucketCdnPolicy", () {
    unittest.test("to-json--from-json", () {
      var o = buildBackendBucketCdnPolicy();
      var od = new api.BackendBucketCdnPolicy.fromJson(o.toJson());
      checkBackendBucketCdnPolicy(od);
    });
  });

  unittest.group("obj-schema-BackendBucketListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildBackendBucketListWarningData();
      var od = new api.BackendBucketListWarningData.fromJson(o.toJson());
      checkBackendBucketListWarningData(od);
    });
  });

  unittest.group("obj-schema-BackendBucketListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildBackendBucketListWarning();
      var od = new api.BackendBucketListWarning.fromJson(o.toJson());
      checkBackendBucketListWarning(od);
    });
  });

  unittest.group("obj-schema-BackendBucketList", () {
    unittest.test("to-json--from-json", () {
      var o = buildBackendBucketList();
      var od = new api.BackendBucketList.fromJson(o.toJson());
      checkBackendBucketList(od);
    });
  });

  unittest.group("obj-schema-BackendService", () {
    unittest.test("to-json--from-json", () {
      var o = buildBackendService();
      var od = new api.BackendService.fromJson(o.toJson());
      checkBackendService(od);
    });
  });

  unittest.group("obj-schema-BackendServiceAggregatedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildBackendServiceAggregatedListWarningData();
      var od =
          new api.BackendServiceAggregatedListWarningData.fromJson(o.toJson());
      checkBackendServiceAggregatedListWarningData(od);
    });
  });

  unittest.group("obj-schema-BackendServiceAggregatedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildBackendServiceAggregatedListWarning();
      var od = new api.BackendServiceAggregatedListWarning.fromJson(o.toJson());
      checkBackendServiceAggregatedListWarning(od);
    });
  });

  unittest.group("obj-schema-BackendServiceAggregatedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildBackendServiceAggregatedList();
      var od = new api.BackendServiceAggregatedList.fromJson(o.toJson());
      checkBackendServiceAggregatedList(od);
    });
  });

  unittest.group("obj-schema-BackendServiceCdnPolicy", () {
    unittest.test("to-json--from-json", () {
      var o = buildBackendServiceCdnPolicy();
      var od = new api.BackendServiceCdnPolicy.fromJson(o.toJson());
      checkBackendServiceCdnPolicy(od);
    });
  });

  unittest.group("obj-schema-BackendServiceGroupHealth", () {
    unittest.test("to-json--from-json", () {
      var o = buildBackendServiceGroupHealth();
      var od = new api.BackendServiceGroupHealth.fromJson(o.toJson());
      checkBackendServiceGroupHealth(od);
    });
  });

  unittest.group("obj-schema-BackendServiceIAP", () {
    unittest.test("to-json--from-json", () {
      var o = buildBackendServiceIAP();
      var od = new api.BackendServiceIAP.fromJson(o.toJson());
      checkBackendServiceIAP(od);
    });
  });

  unittest.group("obj-schema-BackendServiceListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildBackendServiceListWarningData();
      var od = new api.BackendServiceListWarningData.fromJson(o.toJson());
      checkBackendServiceListWarningData(od);
    });
  });

  unittest.group("obj-schema-BackendServiceListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildBackendServiceListWarning();
      var od = new api.BackendServiceListWarning.fromJson(o.toJson());
      checkBackendServiceListWarning(od);
    });
  });

  unittest.group("obj-schema-BackendServiceList", () {
    unittest.test("to-json--from-json", () {
      var o = buildBackendServiceList();
      var od = new api.BackendServiceList.fromJson(o.toJson());
      checkBackendServiceList(od);
    });
  });

  unittest.group("obj-schema-BackendServiceReference", () {
    unittest.test("to-json--from-json", () {
      var o = buildBackendServiceReference();
      var od = new api.BackendServiceReference.fromJson(o.toJson());
      checkBackendServiceReference(od);
    });
  });

  unittest.group("obj-schema-BackendServicesScopedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildBackendServicesScopedListWarningData();
      var od =
          new api.BackendServicesScopedListWarningData.fromJson(o.toJson());
      checkBackendServicesScopedListWarningData(od);
    });
  });

  unittest.group("obj-schema-BackendServicesScopedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildBackendServicesScopedListWarning();
      var od = new api.BackendServicesScopedListWarning.fromJson(o.toJson());
      checkBackendServicesScopedListWarning(od);
    });
  });

  unittest.group("obj-schema-BackendServicesScopedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildBackendServicesScopedList();
      var od = new api.BackendServicesScopedList.fromJson(o.toJson());
      checkBackendServicesScopedList(od);
    });
  });

  unittest.group("obj-schema-Binding", () {
    unittest.test("to-json--from-json", () {
      var o = buildBinding();
      var od = new api.Binding.fromJson(o.toJson());
      checkBinding(od);
    });
  });

  unittest.group("obj-schema-CacheInvalidationRule", () {
    unittest.test("to-json--from-json", () {
      var o = buildCacheInvalidationRule();
      var od = new api.CacheInvalidationRule.fromJson(o.toJson());
      checkCacheInvalidationRule(od);
    });
  });

  unittest.group("obj-schema-CacheKeyPolicy", () {
    unittest.test("to-json--from-json", () {
      var o = buildCacheKeyPolicy();
      var od = new api.CacheKeyPolicy.fromJson(o.toJson());
      checkCacheKeyPolicy(od);
    });
  });

  unittest.group("obj-schema-Commitment", () {
    unittest.test("to-json--from-json", () {
      var o = buildCommitment();
      var od = new api.Commitment.fromJson(o.toJson());
      checkCommitment(od);
    });
  });

  unittest.group("obj-schema-CommitmentAggregatedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildCommitmentAggregatedListWarningData();
      var od = new api.CommitmentAggregatedListWarningData.fromJson(o.toJson());
      checkCommitmentAggregatedListWarningData(od);
    });
  });

  unittest.group("obj-schema-CommitmentAggregatedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildCommitmentAggregatedListWarning();
      var od = new api.CommitmentAggregatedListWarning.fromJson(o.toJson());
      checkCommitmentAggregatedListWarning(od);
    });
  });

  unittest.group("obj-schema-CommitmentAggregatedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildCommitmentAggregatedList();
      var od = new api.CommitmentAggregatedList.fromJson(o.toJson());
      checkCommitmentAggregatedList(od);
    });
  });

  unittest.group("obj-schema-CommitmentListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildCommitmentListWarningData();
      var od = new api.CommitmentListWarningData.fromJson(o.toJson());
      checkCommitmentListWarningData(od);
    });
  });

  unittest.group("obj-schema-CommitmentListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildCommitmentListWarning();
      var od = new api.CommitmentListWarning.fromJson(o.toJson());
      checkCommitmentListWarning(od);
    });
  });

  unittest.group("obj-schema-CommitmentList", () {
    unittest.test("to-json--from-json", () {
      var o = buildCommitmentList();
      var od = new api.CommitmentList.fromJson(o.toJson());
      checkCommitmentList(od);
    });
  });

  unittest.group("obj-schema-CommitmentsScopedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildCommitmentsScopedListWarningData();
      var od = new api.CommitmentsScopedListWarningData.fromJson(o.toJson());
      checkCommitmentsScopedListWarningData(od);
    });
  });

  unittest.group("obj-schema-CommitmentsScopedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildCommitmentsScopedListWarning();
      var od = new api.CommitmentsScopedListWarning.fromJson(o.toJson());
      checkCommitmentsScopedListWarning(od);
    });
  });

  unittest.group("obj-schema-CommitmentsScopedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildCommitmentsScopedList();
      var od = new api.CommitmentsScopedList.fromJson(o.toJson());
      checkCommitmentsScopedList(od);
    });
  });

  unittest.group("obj-schema-Condition", () {
    unittest.test("to-json--from-json", () {
      var o = buildCondition();
      var od = new api.Condition.fromJson(o.toJson());
      checkCondition(od);
    });
  });

  unittest.group("obj-schema-ConnectionDraining", () {
    unittest.test("to-json--from-json", () {
      var o = buildConnectionDraining();
      var od = new api.ConnectionDraining.fromJson(o.toJson());
      checkConnectionDraining(od);
    });
  });

  unittest.group("obj-schema-CustomerEncryptionKey", () {
    unittest.test("to-json--from-json", () {
      var o = buildCustomerEncryptionKey();
      var od = new api.CustomerEncryptionKey.fromJson(o.toJson());
      checkCustomerEncryptionKey(od);
    });
  });

  unittest.group("obj-schema-CustomerEncryptionKeyProtectedDisk", () {
    unittest.test("to-json--from-json", () {
      var o = buildCustomerEncryptionKeyProtectedDisk();
      var od = new api.CustomerEncryptionKeyProtectedDisk.fromJson(o.toJson());
      checkCustomerEncryptionKeyProtectedDisk(od);
    });
  });

  unittest.group("obj-schema-DeprecationStatus", () {
    unittest.test("to-json--from-json", () {
      var o = buildDeprecationStatus();
      var od = new api.DeprecationStatus.fromJson(o.toJson());
      checkDeprecationStatus(od);
    });
  });

  unittest.group("obj-schema-Disk", () {
    unittest.test("to-json--from-json", () {
      var o = buildDisk();
      var od = new api.Disk.fromJson(o.toJson());
      checkDisk(od);
    });
  });

  unittest.group("obj-schema-DiskAggregatedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildDiskAggregatedListWarningData();
      var od = new api.DiskAggregatedListWarningData.fromJson(o.toJson());
      checkDiskAggregatedListWarningData(od);
    });
  });

  unittest.group("obj-schema-DiskAggregatedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildDiskAggregatedListWarning();
      var od = new api.DiskAggregatedListWarning.fromJson(o.toJson());
      checkDiskAggregatedListWarning(od);
    });
  });

  unittest.group("obj-schema-DiskAggregatedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildDiskAggregatedList();
      var od = new api.DiskAggregatedList.fromJson(o.toJson());
      checkDiskAggregatedList(od);
    });
  });

  unittest.group("obj-schema-DiskInstantiationConfig", () {
    unittest.test("to-json--from-json", () {
      var o = buildDiskInstantiationConfig();
      var od = new api.DiskInstantiationConfig.fromJson(o.toJson());
      checkDiskInstantiationConfig(od);
    });
  });

  unittest.group("obj-schema-DiskListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildDiskListWarningData();
      var od = new api.DiskListWarningData.fromJson(o.toJson());
      checkDiskListWarningData(od);
    });
  });

  unittest.group("obj-schema-DiskListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildDiskListWarning();
      var od = new api.DiskListWarning.fromJson(o.toJson());
      checkDiskListWarning(od);
    });
  });

  unittest.group("obj-schema-DiskList", () {
    unittest.test("to-json--from-json", () {
      var o = buildDiskList();
      var od = new api.DiskList.fromJson(o.toJson());
      checkDiskList(od);
    });
  });

  unittest.group("obj-schema-DiskMoveRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildDiskMoveRequest();
      var od = new api.DiskMoveRequest.fromJson(o.toJson());
      checkDiskMoveRequest(od);
    });
  });

  unittest.group("obj-schema-DiskType", () {
    unittest.test("to-json--from-json", () {
      var o = buildDiskType();
      var od = new api.DiskType.fromJson(o.toJson());
      checkDiskType(od);
    });
  });

  unittest.group("obj-schema-DiskTypeAggregatedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildDiskTypeAggregatedListWarningData();
      var od = new api.DiskTypeAggregatedListWarningData.fromJson(o.toJson());
      checkDiskTypeAggregatedListWarningData(od);
    });
  });

  unittest.group("obj-schema-DiskTypeAggregatedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildDiskTypeAggregatedListWarning();
      var od = new api.DiskTypeAggregatedListWarning.fromJson(o.toJson());
      checkDiskTypeAggregatedListWarning(od);
    });
  });

  unittest.group("obj-schema-DiskTypeAggregatedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildDiskTypeAggregatedList();
      var od = new api.DiskTypeAggregatedList.fromJson(o.toJson());
      checkDiskTypeAggregatedList(od);
    });
  });

  unittest.group("obj-schema-DiskTypeListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildDiskTypeListWarningData();
      var od = new api.DiskTypeListWarningData.fromJson(o.toJson());
      checkDiskTypeListWarningData(od);
    });
  });

  unittest.group("obj-schema-DiskTypeListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildDiskTypeListWarning();
      var od = new api.DiskTypeListWarning.fromJson(o.toJson());
      checkDiskTypeListWarning(od);
    });
  });

  unittest.group("obj-schema-DiskTypeList", () {
    unittest.test("to-json--from-json", () {
      var o = buildDiskTypeList();
      var od = new api.DiskTypeList.fromJson(o.toJson());
      checkDiskTypeList(od);
    });
  });

  unittest.group("obj-schema-DiskTypesScopedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildDiskTypesScopedListWarningData();
      var od = new api.DiskTypesScopedListWarningData.fromJson(o.toJson());
      checkDiskTypesScopedListWarningData(od);
    });
  });

  unittest.group("obj-schema-DiskTypesScopedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildDiskTypesScopedListWarning();
      var od = new api.DiskTypesScopedListWarning.fromJson(o.toJson());
      checkDiskTypesScopedListWarning(od);
    });
  });

  unittest.group("obj-schema-DiskTypesScopedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildDiskTypesScopedList();
      var od = new api.DiskTypesScopedList.fromJson(o.toJson());
      checkDiskTypesScopedList(od);
    });
  });

  unittest.group("obj-schema-DisksAddResourcePoliciesRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildDisksAddResourcePoliciesRequest();
      var od = new api.DisksAddResourcePoliciesRequest.fromJson(o.toJson());
      checkDisksAddResourcePoliciesRequest(od);
    });
  });

  unittest.group("obj-schema-DisksRemoveResourcePoliciesRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildDisksRemoveResourcePoliciesRequest();
      var od = new api.DisksRemoveResourcePoliciesRequest.fromJson(o.toJson());
      checkDisksRemoveResourcePoliciesRequest(od);
    });
  });

  unittest.group("obj-schema-DisksResizeRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildDisksResizeRequest();
      var od = new api.DisksResizeRequest.fromJson(o.toJson());
      checkDisksResizeRequest(od);
    });
  });

  unittest.group("obj-schema-DisksScopedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildDisksScopedListWarningData();
      var od = new api.DisksScopedListWarningData.fromJson(o.toJson());
      checkDisksScopedListWarningData(od);
    });
  });

  unittest.group("obj-schema-DisksScopedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildDisksScopedListWarning();
      var od = new api.DisksScopedListWarning.fromJson(o.toJson());
      checkDisksScopedListWarning(od);
    });
  });

  unittest.group("obj-schema-DisksScopedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildDisksScopedList();
      var od = new api.DisksScopedList.fromJson(o.toJson());
      checkDisksScopedList(od);
    });
  });

  unittest.group("obj-schema-DistributionPolicy", () {
    unittest.test("to-json--from-json", () {
      var o = buildDistributionPolicy();
      var od = new api.DistributionPolicy.fromJson(o.toJson());
      checkDistributionPolicy(od);
    });
  });

  unittest.group("obj-schema-DistributionPolicyZoneConfiguration", () {
    unittest.test("to-json--from-json", () {
      var o = buildDistributionPolicyZoneConfiguration();
      var od = new api.DistributionPolicyZoneConfiguration.fromJson(o.toJson());
      checkDistributionPolicyZoneConfiguration(od);
    });
  });

  unittest.group("obj-schema-Expr", () {
    unittest.test("to-json--from-json", () {
      var o = buildExpr();
      var od = new api.Expr.fromJson(o.toJson());
      checkExpr(od);
    });
  });

  unittest.group("obj-schema-FirewallAllowed", () {
    unittest.test("to-json--from-json", () {
      var o = buildFirewallAllowed();
      var od = new api.FirewallAllowed.fromJson(o.toJson());
      checkFirewallAllowed(od);
    });
  });

  unittest.group("obj-schema-FirewallDenied", () {
    unittest.test("to-json--from-json", () {
      var o = buildFirewallDenied();
      var od = new api.FirewallDenied.fromJson(o.toJson());
      checkFirewallDenied(od);
    });
  });

  unittest.group("obj-schema-Firewall", () {
    unittest.test("to-json--from-json", () {
      var o = buildFirewall();
      var od = new api.Firewall.fromJson(o.toJson());
      checkFirewall(od);
    });
  });

  unittest.group("obj-schema-FirewallListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildFirewallListWarningData();
      var od = new api.FirewallListWarningData.fromJson(o.toJson());
      checkFirewallListWarningData(od);
    });
  });

  unittest.group("obj-schema-FirewallListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildFirewallListWarning();
      var od = new api.FirewallListWarning.fromJson(o.toJson());
      checkFirewallListWarning(od);
    });
  });

  unittest.group("obj-schema-FirewallList", () {
    unittest.test("to-json--from-json", () {
      var o = buildFirewallList();
      var od = new api.FirewallList.fromJson(o.toJson());
      checkFirewallList(od);
    });
  });

  unittest.group("obj-schema-FirewallLogConfig", () {
    unittest.test("to-json--from-json", () {
      var o = buildFirewallLogConfig();
      var od = new api.FirewallLogConfig.fromJson(o.toJson());
      checkFirewallLogConfig(od);
    });
  });

  unittest.group("obj-schema-FixedOrPercent", () {
    unittest.test("to-json--from-json", () {
      var o = buildFixedOrPercent();
      var od = new api.FixedOrPercent.fromJson(o.toJson());
      checkFixedOrPercent(od);
    });
  });

  unittest.group("obj-schema-ForwardingRule", () {
    unittest.test("to-json--from-json", () {
      var o = buildForwardingRule();
      var od = new api.ForwardingRule.fromJson(o.toJson());
      checkForwardingRule(od);
    });
  });

  unittest.group("obj-schema-ForwardingRuleAggregatedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildForwardingRuleAggregatedListWarningData();
      var od =
          new api.ForwardingRuleAggregatedListWarningData.fromJson(o.toJson());
      checkForwardingRuleAggregatedListWarningData(od);
    });
  });

  unittest.group("obj-schema-ForwardingRuleAggregatedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildForwardingRuleAggregatedListWarning();
      var od = new api.ForwardingRuleAggregatedListWarning.fromJson(o.toJson());
      checkForwardingRuleAggregatedListWarning(od);
    });
  });

  unittest.group("obj-schema-ForwardingRuleAggregatedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildForwardingRuleAggregatedList();
      var od = new api.ForwardingRuleAggregatedList.fromJson(o.toJson());
      checkForwardingRuleAggregatedList(od);
    });
  });

  unittest.group("obj-schema-ForwardingRuleListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildForwardingRuleListWarningData();
      var od = new api.ForwardingRuleListWarningData.fromJson(o.toJson());
      checkForwardingRuleListWarningData(od);
    });
  });

  unittest.group("obj-schema-ForwardingRuleListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildForwardingRuleListWarning();
      var od = new api.ForwardingRuleListWarning.fromJson(o.toJson());
      checkForwardingRuleListWarning(od);
    });
  });

  unittest.group("obj-schema-ForwardingRuleList", () {
    unittest.test("to-json--from-json", () {
      var o = buildForwardingRuleList();
      var od = new api.ForwardingRuleList.fromJson(o.toJson());
      checkForwardingRuleList(od);
    });
  });

  unittest.group("obj-schema-ForwardingRuleReference", () {
    unittest.test("to-json--from-json", () {
      var o = buildForwardingRuleReference();
      var od = new api.ForwardingRuleReference.fromJson(o.toJson());
      checkForwardingRuleReference(od);
    });
  });

  unittest.group("obj-schema-ForwardingRulesScopedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildForwardingRulesScopedListWarningData();
      var od =
          new api.ForwardingRulesScopedListWarningData.fromJson(o.toJson());
      checkForwardingRulesScopedListWarningData(od);
    });
  });

  unittest.group("obj-schema-ForwardingRulesScopedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildForwardingRulesScopedListWarning();
      var od = new api.ForwardingRulesScopedListWarning.fromJson(o.toJson());
      checkForwardingRulesScopedListWarning(od);
    });
  });

  unittest.group("obj-schema-ForwardingRulesScopedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildForwardingRulesScopedList();
      var od = new api.ForwardingRulesScopedList.fromJson(o.toJson());
      checkForwardingRulesScopedList(od);
    });
  });

  unittest.group("obj-schema-GlobalSetLabelsRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildGlobalSetLabelsRequest();
      var od = new api.GlobalSetLabelsRequest.fromJson(o.toJson());
      checkGlobalSetLabelsRequest(od);
    });
  });

  unittest.group("obj-schema-GlobalSetPolicyRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildGlobalSetPolicyRequest();
      var od = new api.GlobalSetPolicyRequest.fromJson(o.toJson());
      checkGlobalSetPolicyRequest(od);
    });
  });

  unittest.group("obj-schema-GuestAttributes", () {
    unittest.test("to-json--from-json", () {
      var o = buildGuestAttributes();
      var od = new api.GuestAttributes.fromJson(o.toJson());
      checkGuestAttributes(od);
    });
  });

  unittest.group("obj-schema-GuestAttributesEntry", () {
    unittest.test("to-json--from-json", () {
      var o = buildGuestAttributesEntry();
      var od = new api.GuestAttributesEntry.fromJson(o.toJson());
      checkGuestAttributesEntry(od);
    });
  });

  unittest.group("obj-schema-GuestAttributesValue", () {
    unittest.test("to-json--from-json", () {
      var o = buildGuestAttributesValue();
      var od = new api.GuestAttributesValue.fromJson(o.toJson());
      checkGuestAttributesValue(od);
    });
  });

  unittest.group("obj-schema-GuestOsFeature", () {
    unittest.test("to-json--from-json", () {
      var o = buildGuestOsFeature();
      var od = new api.GuestOsFeature.fromJson(o.toJson());
      checkGuestOsFeature(od);
    });
  });

  unittest.group("obj-schema-HTTP2HealthCheck", () {
    unittest.test("to-json--from-json", () {
      var o = buildHTTP2HealthCheck();
      var od = new api.HTTP2HealthCheck.fromJson(o.toJson());
      checkHTTP2HealthCheck(od);
    });
  });

  unittest.group("obj-schema-HTTPHealthCheck", () {
    unittest.test("to-json--from-json", () {
      var o = buildHTTPHealthCheck();
      var od = new api.HTTPHealthCheck.fromJson(o.toJson());
      checkHTTPHealthCheck(od);
    });
  });

  unittest.group("obj-schema-HTTPSHealthCheck", () {
    unittest.test("to-json--from-json", () {
      var o = buildHTTPSHealthCheck();
      var od = new api.HTTPSHealthCheck.fromJson(o.toJson());
      checkHTTPSHealthCheck(od);
    });
  });

  unittest.group("obj-schema-HealthCheck", () {
    unittest.test("to-json--from-json", () {
      var o = buildHealthCheck();
      var od = new api.HealthCheck.fromJson(o.toJson());
      checkHealthCheck(od);
    });
  });

  unittest.group("obj-schema-HealthCheckListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildHealthCheckListWarningData();
      var od = new api.HealthCheckListWarningData.fromJson(o.toJson());
      checkHealthCheckListWarningData(od);
    });
  });

  unittest.group("obj-schema-HealthCheckListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildHealthCheckListWarning();
      var od = new api.HealthCheckListWarning.fromJson(o.toJson());
      checkHealthCheckListWarning(od);
    });
  });

  unittest.group("obj-schema-HealthCheckList", () {
    unittest.test("to-json--from-json", () {
      var o = buildHealthCheckList();
      var od = new api.HealthCheckList.fromJson(o.toJson());
      checkHealthCheckList(od);
    });
  });

  unittest.group("obj-schema-HealthCheckReference", () {
    unittest.test("to-json--from-json", () {
      var o = buildHealthCheckReference();
      var od = new api.HealthCheckReference.fromJson(o.toJson());
      checkHealthCheckReference(od);
    });
  });

  unittest.group("obj-schema-HealthStatus", () {
    unittest.test("to-json--from-json", () {
      var o = buildHealthStatus();
      var od = new api.HealthStatus.fromJson(o.toJson());
      checkHealthStatus(od);
    });
  });

  unittest.group("obj-schema-HealthStatusForNetworkEndpoint", () {
    unittest.test("to-json--from-json", () {
      var o = buildHealthStatusForNetworkEndpoint();
      var od = new api.HealthStatusForNetworkEndpoint.fromJson(o.toJson());
      checkHealthStatusForNetworkEndpoint(od);
    });
  });

  unittest.group("obj-schema-HostRule", () {
    unittest.test("to-json--from-json", () {
      var o = buildHostRule();
      var od = new api.HostRule.fromJson(o.toJson());
      checkHostRule(od);
    });
  });

  unittest.group("obj-schema-HttpHealthCheck", () {
    unittest.test("to-json--from-json", () {
      var o = buildHttpHealthCheck();
      var od = new api.HttpHealthCheck.fromJson(o.toJson());
      checkHttpHealthCheck(od);
    });
  });

  unittest.group("obj-schema-HttpHealthCheckListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildHttpHealthCheckListWarningData();
      var od = new api.HttpHealthCheckListWarningData.fromJson(o.toJson());
      checkHttpHealthCheckListWarningData(od);
    });
  });

  unittest.group("obj-schema-HttpHealthCheckListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildHttpHealthCheckListWarning();
      var od = new api.HttpHealthCheckListWarning.fromJson(o.toJson());
      checkHttpHealthCheckListWarning(od);
    });
  });

  unittest.group("obj-schema-HttpHealthCheckList", () {
    unittest.test("to-json--from-json", () {
      var o = buildHttpHealthCheckList();
      var od = new api.HttpHealthCheckList.fromJson(o.toJson());
      checkHttpHealthCheckList(od);
    });
  });

  unittest.group("obj-schema-HttpsHealthCheck", () {
    unittest.test("to-json--from-json", () {
      var o = buildHttpsHealthCheck();
      var od = new api.HttpsHealthCheck.fromJson(o.toJson());
      checkHttpsHealthCheck(od);
    });
  });

  unittest.group("obj-schema-HttpsHealthCheckListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildHttpsHealthCheckListWarningData();
      var od = new api.HttpsHealthCheckListWarningData.fromJson(o.toJson());
      checkHttpsHealthCheckListWarningData(od);
    });
  });

  unittest.group("obj-schema-HttpsHealthCheckListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildHttpsHealthCheckListWarning();
      var od = new api.HttpsHealthCheckListWarning.fromJson(o.toJson());
      checkHttpsHealthCheckListWarning(od);
    });
  });

  unittest.group("obj-schema-HttpsHealthCheckList", () {
    unittest.test("to-json--from-json", () {
      var o = buildHttpsHealthCheckList();
      var od = new api.HttpsHealthCheckList.fromJson(o.toJson());
      checkHttpsHealthCheckList(od);
    });
  });

  unittest.group("obj-schema-ImageRawDisk", () {
    unittest.test("to-json--from-json", () {
      var o = buildImageRawDisk();
      var od = new api.ImageRawDisk.fromJson(o.toJson());
      checkImageRawDisk(od);
    });
  });

  unittest.group("obj-schema-Image", () {
    unittest.test("to-json--from-json", () {
      var o = buildImage();
      var od = new api.Image.fromJson(o.toJson());
      checkImage(od);
    });
  });

  unittest.group("obj-schema-ImageListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildImageListWarningData();
      var od = new api.ImageListWarningData.fromJson(o.toJson());
      checkImageListWarningData(od);
    });
  });

  unittest.group("obj-schema-ImageListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildImageListWarning();
      var od = new api.ImageListWarning.fromJson(o.toJson());
      checkImageListWarning(od);
    });
  });

  unittest.group("obj-schema-ImageList", () {
    unittest.test("to-json--from-json", () {
      var o = buildImageList();
      var od = new api.ImageList.fromJson(o.toJson());
      checkImageList(od);
    });
  });

  unittest.group("obj-schema-Instance", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstance();
      var od = new api.Instance.fromJson(o.toJson());
      checkInstance(od);
    });
  });

  unittest.group("obj-schema-InstanceAggregatedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceAggregatedListWarningData();
      var od = new api.InstanceAggregatedListWarningData.fromJson(o.toJson());
      checkInstanceAggregatedListWarningData(od);
    });
  });

  unittest.group("obj-schema-InstanceAggregatedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceAggregatedListWarning();
      var od = new api.InstanceAggregatedListWarning.fromJson(o.toJson());
      checkInstanceAggregatedListWarning(od);
    });
  });

  unittest.group("obj-schema-InstanceAggregatedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceAggregatedList();
      var od = new api.InstanceAggregatedList.fromJson(o.toJson());
      checkInstanceAggregatedList(od);
    });
  });

  unittest.group("obj-schema-InstanceGroup", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroup();
      var od = new api.InstanceGroup.fromJson(o.toJson());
      checkInstanceGroup(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupAggregatedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupAggregatedListWarningData();
      var od =
          new api.InstanceGroupAggregatedListWarningData.fromJson(o.toJson());
      checkInstanceGroupAggregatedListWarningData(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupAggregatedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupAggregatedListWarning();
      var od = new api.InstanceGroupAggregatedListWarning.fromJson(o.toJson());
      checkInstanceGroupAggregatedListWarning(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupAggregatedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupAggregatedList();
      var od = new api.InstanceGroupAggregatedList.fromJson(o.toJson());
      checkInstanceGroupAggregatedList(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupListWarningData();
      var od = new api.InstanceGroupListWarningData.fromJson(o.toJson());
      checkInstanceGroupListWarningData(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupListWarning();
      var od = new api.InstanceGroupListWarning.fromJson(o.toJson());
      checkInstanceGroupListWarning(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupList", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupList();
      var od = new api.InstanceGroupList.fromJson(o.toJson());
      checkInstanceGroupList(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupManager", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupManager();
      var od = new api.InstanceGroupManager.fromJson(o.toJson());
      checkInstanceGroupManager(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupManagerActionsSummary", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupManagerActionsSummary();
      var od = new api.InstanceGroupManagerActionsSummary.fromJson(o.toJson());
      checkInstanceGroupManagerActionsSummary(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupManagerAggregatedListWarningData",
      () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupManagerAggregatedListWarningData();
      var od = new api.InstanceGroupManagerAggregatedListWarningData.fromJson(
          o.toJson());
      checkInstanceGroupManagerAggregatedListWarningData(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupManagerAggregatedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupManagerAggregatedListWarning();
      var od = new api.InstanceGroupManagerAggregatedListWarning.fromJson(
          o.toJson());
      checkInstanceGroupManagerAggregatedListWarning(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupManagerAggregatedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupManagerAggregatedList();
      var od = new api.InstanceGroupManagerAggregatedList.fromJson(o.toJson());
      checkInstanceGroupManagerAggregatedList(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupManagerAutoHealingPolicy", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupManagerAutoHealingPolicy();
      var od =
          new api.InstanceGroupManagerAutoHealingPolicy.fromJson(o.toJson());
      checkInstanceGroupManagerAutoHealingPolicy(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupManagerListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupManagerListWarningData();
      var od = new api.InstanceGroupManagerListWarningData.fromJson(o.toJson());
      checkInstanceGroupManagerListWarningData(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupManagerListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupManagerListWarning();
      var od = new api.InstanceGroupManagerListWarning.fromJson(o.toJson());
      checkInstanceGroupManagerListWarning(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupManagerList", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupManagerList();
      var od = new api.InstanceGroupManagerList.fromJson(o.toJson());
      checkInstanceGroupManagerList(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupManagerStatus", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupManagerStatus();
      var od = new api.InstanceGroupManagerStatus.fromJson(o.toJson());
      checkInstanceGroupManagerStatus(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupManagerUpdatePolicy", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupManagerUpdatePolicy();
      var od = new api.InstanceGroupManagerUpdatePolicy.fromJson(o.toJson());
      checkInstanceGroupManagerUpdatePolicy(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupManagerVersion", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupManagerVersion();
      var od = new api.InstanceGroupManagerVersion.fromJson(o.toJson());
      checkInstanceGroupManagerVersion(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupManagersAbandonInstancesRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupManagersAbandonInstancesRequest();
      var od = new api.InstanceGroupManagersAbandonInstancesRequest.fromJson(
          o.toJson());
      checkInstanceGroupManagersAbandonInstancesRequest(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupManagersDeleteInstancesRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupManagersDeleteInstancesRequest();
      var od = new api.InstanceGroupManagersDeleteInstancesRequest.fromJson(
          o.toJson());
      checkInstanceGroupManagersDeleteInstancesRequest(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupManagersListManagedInstancesResponse",
      () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupManagersListManagedInstancesResponse();
      var od =
          new api.InstanceGroupManagersListManagedInstancesResponse.fromJson(
              o.toJson());
      checkInstanceGroupManagersListManagedInstancesResponse(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupManagersRecreateInstancesRequest",
      () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupManagersRecreateInstancesRequest();
      var od = new api.InstanceGroupManagersRecreateInstancesRequest.fromJson(
          o.toJson());
      checkInstanceGroupManagersRecreateInstancesRequest(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupManagersScopedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupManagersScopedListWarningData();
      var od = new api.InstanceGroupManagersScopedListWarningData.fromJson(
          o.toJson());
      checkInstanceGroupManagersScopedListWarningData(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupManagersScopedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupManagersScopedListWarning();
      var od =
          new api.InstanceGroupManagersScopedListWarning.fromJson(o.toJson());
      checkInstanceGroupManagersScopedListWarning(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupManagersScopedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupManagersScopedList();
      var od = new api.InstanceGroupManagersScopedList.fromJson(o.toJson());
      checkInstanceGroupManagersScopedList(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupManagersSetInstanceTemplateRequest",
      () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupManagersSetInstanceTemplateRequest();
      var od = new api.InstanceGroupManagersSetInstanceTemplateRequest.fromJson(
          o.toJson());
      checkInstanceGroupManagersSetInstanceTemplateRequest(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupManagersSetTargetPoolsRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupManagersSetTargetPoolsRequest();
      var od = new api.InstanceGroupManagersSetTargetPoolsRequest.fromJson(
          o.toJson());
      checkInstanceGroupManagersSetTargetPoolsRequest(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupsAddInstancesRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupsAddInstancesRequest();
      var od = new api.InstanceGroupsAddInstancesRequest.fromJson(o.toJson());
      checkInstanceGroupsAddInstancesRequest(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupsListInstancesWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupsListInstancesWarningData();
      var od =
          new api.InstanceGroupsListInstancesWarningData.fromJson(o.toJson());
      checkInstanceGroupsListInstancesWarningData(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupsListInstancesWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupsListInstancesWarning();
      var od = new api.InstanceGroupsListInstancesWarning.fromJson(o.toJson());
      checkInstanceGroupsListInstancesWarning(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupsListInstances", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupsListInstances();
      var od = new api.InstanceGroupsListInstances.fromJson(o.toJson());
      checkInstanceGroupsListInstances(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupsListInstancesRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupsListInstancesRequest();
      var od = new api.InstanceGroupsListInstancesRequest.fromJson(o.toJson());
      checkInstanceGroupsListInstancesRequest(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupsRemoveInstancesRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupsRemoveInstancesRequest();
      var od =
          new api.InstanceGroupsRemoveInstancesRequest.fromJson(o.toJson());
      checkInstanceGroupsRemoveInstancesRequest(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupsScopedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupsScopedListWarningData();
      var od = new api.InstanceGroupsScopedListWarningData.fromJson(o.toJson());
      checkInstanceGroupsScopedListWarningData(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupsScopedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupsScopedListWarning();
      var od = new api.InstanceGroupsScopedListWarning.fromJson(o.toJson());
      checkInstanceGroupsScopedListWarning(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupsScopedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupsScopedList();
      var od = new api.InstanceGroupsScopedList.fromJson(o.toJson());
      checkInstanceGroupsScopedList(od);
    });
  });

  unittest.group("obj-schema-InstanceGroupsSetNamedPortsRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceGroupsSetNamedPortsRequest();
      var od = new api.InstanceGroupsSetNamedPortsRequest.fromJson(o.toJson());
      checkInstanceGroupsSetNamedPortsRequest(od);
    });
  });

  unittest.group("obj-schema-InstanceListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceListWarningData();
      var od = new api.InstanceListWarningData.fromJson(o.toJson());
      checkInstanceListWarningData(od);
    });
  });

  unittest.group("obj-schema-InstanceListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceListWarning();
      var od = new api.InstanceListWarning.fromJson(o.toJson());
      checkInstanceListWarning(od);
    });
  });

  unittest.group("obj-schema-InstanceList", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceList();
      var od = new api.InstanceList.fromJson(o.toJson());
      checkInstanceList(od);
    });
  });

  unittest.group("obj-schema-InstanceListReferrersWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceListReferrersWarningData();
      var od = new api.InstanceListReferrersWarningData.fromJson(o.toJson());
      checkInstanceListReferrersWarningData(od);
    });
  });

  unittest.group("obj-schema-InstanceListReferrersWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceListReferrersWarning();
      var od = new api.InstanceListReferrersWarning.fromJson(o.toJson());
      checkInstanceListReferrersWarning(od);
    });
  });

  unittest.group("obj-schema-InstanceListReferrers", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceListReferrers();
      var od = new api.InstanceListReferrers.fromJson(o.toJson());
      checkInstanceListReferrers(od);
    });
  });

  unittest.group("obj-schema-InstanceMoveRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceMoveRequest();
      var od = new api.InstanceMoveRequest.fromJson(o.toJson());
      checkInstanceMoveRequest(od);
    });
  });

  unittest.group("obj-schema-InstanceProperties", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceProperties();
      var od = new api.InstanceProperties.fromJson(o.toJson());
      checkInstanceProperties(od);
    });
  });

  unittest.group("obj-schema-InstanceReference", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceReference();
      var od = new api.InstanceReference.fromJson(o.toJson());
      checkInstanceReference(od);
    });
  });

  unittest.group("obj-schema-InstanceTemplate", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceTemplate();
      var od = new api.InstanceTemplate.fromJson(o.toJson());
      checkInstanceTemplate(od);
    });
  });

  unittest.group("obj-schema-InstanceTemplateListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceTemplateListWarningData();
      var od = new api.InstanceTemplateListWarningData.fromJson(o.toJson());
      checkInstanceTemplateListWarningData(od);
    });
  });

  unittest.group("obj-schema-InstanceTemplateListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceTemplateListWarning();
      var od = new api.InstanceTemplateListWarning.fromJson(o.toJson());
      checkInstanceTemplateListWarning(od);
    });
  });

  unittest.group("obj-schema-InstanceTemplateList", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceTemplateList();
      var od = new api.InstanceTemplateList.fromJson(o.toJson());
      checkInstanceTemplateList(od);
    });
  });

  unittest.group("obj-schema-InstanceWithNamedPorts", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstanceWithNamedPorts();
      var od = new api.InstanceWithNamedPorts.fromJson(o.toJson());
      checkInstanceWithNamedPorts(od);
    });
  });

  unittest.group("obj-schema-InstancesScopedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstancesScopedListWarningData();
      var od = new api.InstancesScopedListWarningData.fromJson(o.toJson());
      checkInstancesScopedListWarningData(od);
    });
  });

  unittest.group("obj-schema-InstancesScopedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstancesScopedListWarning();
      var od = new api.InstancesScopedListWarning.fromJson(o.toJson());
      checkInstancesScopedListWarning(od);
    });
  });

  unittest.group("obj-schema-InstancesScopedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstancesScopedList();
      var od = new api.InstancesScopedList.fromJson(o.toJson());
      checkInstancesScopedList(od);
    });
  });

  unittest.group("obj-schema-InstancesSetLabelsRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstancesSetLabelsRequest();
      var od = new api.InstancesSetLabelsRequest.fromJson(o.toJson());
      checkInstancesSetLabelsRequest(od);
    });
  });

  unittest.group("obj-schema-InstancesSetMachineResourcesRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstancesSetMachineResourcesRequest();
      var od = new api.InstancesSetMachineResourcesRequest.fromJson(o.toJson());
      checkInstancesSetMachineResourcesRequest(od);
    });
  });

  unittest.group("obj-schema-InstancesSetMachineTypeRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstancesSetMachineTypeRequest();
      var od = new api.InstancesSetMachineTypeRequest.fromJson(o.toJson());
      checkInstancesSetMachineTypeRequest(od);
    });
  });

  unittest.group("obj-schema-InstancesSetMinCpuPlatformRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstancesSetMinCpuPlatformRequest();
      var od = new api.InstancesSetMinCpuPlatformRequest.fromJson(o.toJson());
      checkInstancesSetMinCpuPlatformRequest(od);
    });
  });

  unittest.group("obj-schema-InstancesSetServiceAccountRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstancesSetServiceAccountRequest();
      var od = new api.InstancesSetServiceAccountRequest.fromJson(o.toJson());
      checkInstancesSetServiceAccountRequest(od);
    });
  });

  unittest.group("obj-schema-InstancesStartWithEncryptionKeyRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildInstancesStartWithEncryptionKeyRequest();
      var od =
          new api.InstancesStartWithEncryptionKeyRequest.fromJson(o.toJson());
      checkInstancesStartWithEncryptionKeyRequest(od);
    });
  });

  unittest.group("obj-schema-Interconnect", () {
    unittest.test("to-json--from-json", () {
      var o = buildInterconnect();
      var od = new api.Interconnect.fromJson(o.toJson());
      checkInterconnect(od);
    });
  });

  unittest.group("obj-schema-InterconnectAttachment", () {
    unittest.test("to-json--from-json", () {
      var o = buildInterconnectAttachment();
      var od = new api.InterconnectAttachment.fromJson(o.toJson());
      checkInterconnectAttachment(od);
    });
  });

  unittest.group("obj-schema-InterconnectAttachmentAggregatedListWarningData",
      () {
    unittest.test("to-json--from-json", () {
      var o = buildInterconnectAttachmentAggregatedListWarningData();
      var od = new api.InterconnectAttachmentAggregatedListWarningData.fromJson(
          o.toJson());
      checkInterconnectAttachmentAggregatedListWarningData(od);
    });
  });

  unittest.group("obj-schema-InterconnectAttachmentAggregatedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildInterconnectAttachmentAggregatedListWarning();
      var od = new api.InterconnectAttachmentAggregatedListWarning.fromJson(
          o.toJson());
      checkInterconnectAttachmentAggregatedListWarning(od);
    });
  });

  unittest.group("obj-schema-InterconnectAttachmentAggregatedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildInterconnectAttachmentAggregatedList();
      var od =
          new api.InterconnectAttachmentAggregatedList.fromJson(o.toJson());
      checkInterconnectAttachmentAggregatedList(od);
    });
  });

  unittest.group("obj-schema-InterconnectAttachmentListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildInterconnectAttachmentListWarningData();
      var od =
          new api.InterconnectAttachmentListWarningData.fromJson(o.toJson());
      checkInterconnectAttachmentListWarningData(od);
    });
  });

  unittest.group("obj-schema-InterconnectAttachmentListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildInterconnectAttachmentListWarning();
      var od = new api.InterconnectAttachmentListWarning.fromJson(o.toJson());
      checkInterconnectAttachmentListWarning(od);
    });
  });

  unittest.group("obj-schema-InterconnectAttachmentList", () {
    unittest.test("to-json--from-json", () {
      var o = buildInterconnectAttachmentList();
      var od = new api.InterconnectAttachmentList.fromJson(o.toJson());
      checkInterconnectAttachmentList(od);
    });
  });

  unittest.group("obj-schema-InterconnectAttachmentPartnerMetadata", () {
    unittest.test("to-json--from-json", () {
      var o = buildInterconnectAttachmentPartnerMetadata();
      var od =
          new api.InterconnectAttachmentPartnerMetadata.fromJson(o.toJson());
      checkInterconnectAttachmentPartnerMetadata(od);
    });
  });

  unittest.group("obj-schema-InterconnectAttachmentPrivateInfo", () {
    unittest.test("to-json--from-json", () {
      var o = buildInterconnectAttachmentPrivateInfo();
      var od = new api.InterconnectAttachmentPrivateInfo.fromJson(o.toJson());
      checkInterconnectAttachmentPrivateInfo(od);
    });
  });

  unittest.group("obj-schema-InterconnectAttachmentsScopedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildInterconnectAttachmentsScopedListWarningData();
      var od = new api.InterconnectAttachmentsScopedListWarningData.fromJson(
          o.toJson());
      checkInterconnectAttachmentsScopedListWarningData(od);
    });
  });

  unittest.group("obj-schema-InterconnectAttachmentsScopedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildInterconnectAttachmentsScopedListWarning();
      var od =
          new api.InterconnectAttachmentsScopedListWarning.fromJson(o.toJson());
      checkInterconnectAttachmentsScopedListWarning(od);
    });
  });

  unittest.group("obj-schema-InterconnectAttachmentsScopedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildInterconnectAttachmentsScopedList();
      var od = new api.InterconnectAttachmentsScopedList.fromJson(o.toJson());
      checkInterconnectAttachmentsScopedList(od);
    });
  });

  unittest.group("obj-schema-InterconnectCircuitInfo", () {
    unittest.test("to-json--from-json", () {
      var o = buildInterconnectCircuitInfo();
      var od = new api.InterconnectCircuitInfo.fromJson(o.toJson());
      checkInterconnectCircuitInfo(od);
    });
  });

  unittest.group("obj-schema-InterconnectDiagnostics", () {
    unittest.test("to-json--from-json", () {
      var o = buildInterconnectDiagnostics();
      var od = new api.InterconnectDiagnostics.fromJson(o.toJson());
      checkInterconnectDiagnostics(od);
    });
  });

  unittest.group("obj-schema-InterconnectDiagnosticsARPEntry", () {
    unittest.test("to-json--from-json", () {
      var o = buildInterconnectDiagnosticsARPEntry();
      var od = new api.InterconnectDiagnosticsARPEntry.fromJson(o.toJson());
      checkInterconnectDiagnosticsARPEntry(od);
    });
  });

  unittest.group("obj-schema-InterconnectDiagnosticsLinkLACPStatus", () {
    unittest.test("to-json--from-json", () {
      var o = buildInterconnectDiagnosticsLinkLACPStatus();
      var od =
          new api.InterconnectDiagnosticsLinkLACPStatus.fromJson(o.toJson());
      checkInterconnectDiagnosticsLinkLACPStatus(od);
    });
  });

  unittest.group("obj-schema-InterconnectDiagnosticsLinkOpticalPower", () {
    unittest.test("to-json--from-json", () {
      var o = buildInterconnectDiagnosticsLinkOpticalPower();
      var od =
          new api.InterconnectDiagnosticsLinkOpticalPower.fromJson(o.toJson());
      checkInterconnectDiagnosticsLinkOpticalPower(od);
    });
  });

  unittest.group("obj-schema-InterconnectDiagnosticsLinkStatus", () {
    unittest.test("to-json--from-json", () {
      var o = buildInterconnectDiagnosticsLinkStatus();
      var od = new api.InterconnectDiagnosticsLinkStatus.fromJson(o.toJson());
      checkInterconnectDiagnosticsLinkStatus(od);
    });
  });

  unittest.group("obj-schema-InterconnectListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildInterconnectListWarningData();
      var od = new api.InterconnectListWarningData.fromJson(o.toJson());
      checkInterconnectListWarningData(od);
    });
  });

  unittest.group("obj-schema-InterconnectListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildInterconnectListWarning();
      var od = new api.InterconnectListWarning.fromJson(o.toJson());
      checkInterconnectListWarning(od);
    });
  });

  unittest.group("obj-schema-InterconnectList", () {
    unittest.test("to-json--from-json", () {
      var o = buildInterconnectList();
      var od = new api.InterconnectList.fromJson(o.toJson());
      checkInterconnectList(od);
    });
  });

  unittest.group("obj-schema-InterconnectLocation", () {
    unittest.test("to-json--from-json", () {
      var o = buildInterconnectLocation();
      var od = new api.InterconnectLocation.fromJson(o.toJson());
      checkInterconnectLocation(od);
    });
  });

  unittest.group("obj-schema-InterconnectLocationListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildInterconnectLocationListWarningData();
      var od = new api.InterconnectLocationListWarningData.fromJson(o.toJson());
      checkInterconnectLocationListWarningData(od);
    });
  });

  unittest.group("obj-schema-InterconnectLocationListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildInterconnectLocationListWarning();
      var od = new api.InterconnectLocationListWarning.fromJson(o.toJson());
      checkInterconnectLocationListWarning(od);
    });
  });

  unittest.group("obj-schema-InterconnectLocationList", () {
    unittest.test("to-json--from-json", () {
      var o = buildInterconnectLocationList();
      var od = new api.InterconnectLocationList.fromJson(o.toJson());
      checkInterconnectLocationList(od);
    });
  });

  unittest.group("obj-schema-InterconnectLocationRegionInfo", () {
    unittest.test("to-json--from-json", () {
      var o = buildInterconnectLocationRegionInfo();
      var od = new api.InterconnectLocationRegionInfo.fromJson(o.toJson());
      checkInterconnectLocationRegionInfo(od);
    });
  });

  unittest.group("obj-schema-InterconnectOutageNotification", () {
    unittest.test("to-json--from-json", () {
      var o = buildInterconnectOutageNotification();
      var od = new api.InterconnectOutageNotification.fromJson(o.toJson());
      checkInterconnectOutageNotification(od);
    });
  });

  unittest.group("obj-schema-InterconnectsGetDiagnosticsResponse", () {
    unittest.test("to-json--from-json", () {
      var o = buildInterconnectsGetDiagnosticsResponse();
      var od = new api.InterconnectsGetDiagnosticsResponse.fromJson(o.toJson());
      checkInterconnectsGetDiagnosticsResponse(od);
    });
  });

  unittest.group("obj-schema-License", () {
    unittest.test("to-json--from-json", () {
      var o = buildLicense();
      var od = new api.License.fromJson(o.toJson());
      checkLicense(od);
    });
  });

  unittest.group("obj-schema-LicenseCode", () {
    unittest.test("to-json--from-json", () {
      var o = buildLicenseCode();
      var od = new api.LicenseCode.fromJson(o.toJson());
      checkLicenseCode(od);
    });
  });

  unittest.group("obj-schema-LicenseCodeLicenseAlias", () {
    unittest.test("to-json--from-json", () {
      var o = buildLicenseCodeLicenseAlias();
      var od = new api.LicenseCodeLicenseAlias.fromJson(o.toJson());
      checkLicenseCodeLicenseAlias(od);
    });
  });

  unittest.group("obj-schema-LicenseResourceRequirements", () {
    unittest.test("to-json--from-json", () {
      var o = buildLicenseResourceRequirements();
      var od = new api.LicenseResourceRequirements.fromJson(o.toJson());
      checkLicenseResourceRequirements(od);
    });
  });

  unittest.group("obj-schema-LicensesListResponseWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildLicensesListResponseWarningData();
      var od = new api.LicensesListResponseWarningData.fromJson(o.toJson());
      checkLicensesListResponseWarningData(od);
    });
  });

  unittest.group("obj-schema-LicensesListResponseWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildLicensesListResponseWarning();
      var od = new api.LicensesListResponseWarning.fromJson(o.toJson());
      checkLicensesListResponseWarning(od);
    });
  });

  unittest.group("obj-schema-LicensesListResponse", () {
    unittest.test("to-json--from-json", () {
      var o = buildLicensesListResponse();
      var od = new api.LicensesListResponse.fromJson(o.toJson());
      checkLicensesListResponse(od);
    });
  });

  unittest.group("obj-schema-LogConfig", () {
    unittest.test("to-json--from-json", () {
      var o = buildLogConfig();
      var od = new api.LogConfig.fromJson(o.toJson());
      checkLogConfig(od);
    });
  });

  unittest.group("obj-schema-LogConfigCloudAuditOptions", () {
    unittest.test("to-json--from-json", () {
      var o = buildLogConfigCloudAuditOptions();
      var od = new api.LogConfigCloudAuditOptions.fromJson(o.toJson());
      checkLogConfigCloudAuditOptions(od);
    });
  });

  unittest.group("obj-schema-LogConfigCounterOptions", () {
    unittest.test("to-json--from-json", () {
      var o = buildLogConfigCounterOptions();
      var od = new api.LogConfigCounterOptions.fromJson(o.toJson());
      checkLogConfigCounterOptions(od);
    });
  });

  unittest.group("obj-schema-LogConfigDataAccessOptions", () {
    unittest.test("to-json--from-json", () {
      var o = buildLogConfigDataAccessOptions();
      var od = new api.LogConfigDataAccessOptions.fromJson(o.toJson());
      checkLogConfigDataAccessOptions(od);
    });
  });

  unittest.group("obj-schema-MachineTypeScratchDisks", () {
    unittest.test("to-json--from-json", () {
      var o = buildMachineTypeScratchDisks();
      var od = new api.MachineTypeScratchDisks.fromJson(o.toJson());
      checkMachineTypeScratchDisks(od);
    });
  });

  unittest.group("obj-schema-MachineType", () {
    unittest.test("to-json--from-json", () {
      var o = buildMachineType();
      var od = new api.MachineType.fromJson(o.toJson());
      checkMachineType(od);
    });
  });

  unittest.group("obj-schema-MachineTypeAggregatedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildMachineTypeAggregatedListWarningData();
      var od =
          new api.MachineTypeAggregatedListWarningData.fromJson(o.toJson());
      checkMachineTypeAggregatedListWarningData(od);
    });
  });

  unittest.group("obj-schema-MachineTypeAggregatedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildMachineTypeAggregatedListWarning();
      var od = new api.MachineTypeAggregatedListWarning.fromJson(o.toJson());
      checkMachineTypeAggregatedListWarning(od);
    });
  });

  unittest.group("obj-schema-MachineTypeAggregatedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildMachineTypeAggregatedList();
      var od = new api.MachineTypeAggregatedList.fromJson(o.toJson());
      checkMachineTypeAggregatedList(od);
    });
  });

  unittest.group("obj-schema-MachineTypeListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildMachineTypeListWarningData();
      var od = new api.MachineTypeListWarningData.fromJson(o.toJson());
      checkMachineTypeListWarningData(od);
    });
  });

  unittest.group("obj-schema-MachineTypeListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildMachineTypeListWarning();
      var od = new api.MachineTypeListWarning.fromJson(o.toJson());
      checkMachineTypeListWarning(od);
    });
  });

  unittest.group("obj-schema-MachineTypeList", () {
    unittest.test("to-json--from-json", () {
      var o = buildMachineTypeList();
      var od = new api.MachineTypeList.fromJson(o.toJson());
      checkMachineTypeList(od);
    });
  });

  unittest.group("obj-schema-MachineTypesScopedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildMachineTypesScopedListWarningData();
      var od = new api.MachineTypesScopedListWarningData.fromJson(o.toJson());
      checkMachineTypesScopedListWarningData(od);
    });
  });

  unittest.group("obj-schema-MachineTypesScopedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildMachineTypesScopedListWarning();
      var od = new api.MachineTypesScopedListWarning.fromJson(o.toJson());
      checkMachineTypesScopedListWarning(od);
    });
  });

  unittest.group("obj-schema-MachineTypesScopedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildMachineTypesScopedList();
      var od = new api.MachineTypesScopedList.fromJson(o.toJson());
      checkMachineTypesScopedList(od);
    });
  });

  unittest.group("obj-schema-ManagedInstance", () {
    unittest.test("to-json--from-json", () {
      var o = buildManagedInstance();
      var od = new api.ManagedInstance.fromJson(o.toJson());
      checkManagedInstance(od);
    });
  });

  unittest.group("obj-schema-ManagedInstanceLastAttemptErrorsErrors", () {
    unittest.test("to-json--from-json", () {
      var o = buildManagedInstanceLastAttemptErrorsErrors();
      var od =
          new api.ManagedInstanceLastAttemptErrorsErrors.fromJson(o.toJson());
      checkManagedInstanceLastAttemptErrorsErrors(od);
    });
  });

  unittest.group("obj-schema-ManagedInstanceLastAttemptErrors", () {
    unittest.test("to-json--from-json", () {
      var o = buildManagedInstanceLastAttemptErrors();
      var od = new api.ManagedInstanceLastAttemptErrors.fromJson(o.toJson());
      checkManagedInstanceLastAttemptErrors(od);
    });
  });

  unittest.group("obj-schema-ManagedInstanceLastAttempt", () {
    unittest.test("to-json--from-json", () {
      var o = buildManagedInstanceLastAttempt();
      var od = new api.ManagedInstanceLastAttempt.fromJson(o.toJson());
      checkManagedInstanceLastAttempt(od);
    });
  });

  unittest.group("obj-schema-ManagedInstanceVersion", () {
    unittest.test("to-json--from-json", () {
      var o = buildManagedInstanceVersion();
      var od = new api.ManagedInstanceVersion.fromJson(o.toJson());
      checkManagedInstanceVersion(od);
    });
  });

  unittest.group("obj-schema-MetadataItems", () {
    unittest.test("to-json--from-json", () {
      var o = buildMetadataItems();
      var od = new api.MetadataItems.fromJson(o.toJson());
      checkMetadataItems(od);
    });
  });

  unittest.group("obj-schema-Metadata", () {
    unittest.test("to-json--from-json", () {
      var o = buildMetadata();
      var od = new api.Metadata.fromJson(o.toJson());
      checkMetadata(od);
    });
  });

  unittest.group("obj-schema-NamedPort", () {
    unittest.test("to-json--from-json", () {
      var o = buildNamedPort();
      var od = new api.NamedPort.fromJson(o.toJson());
      checkNamedPort(od);
    });
  });

  unittest.group("obj-schema-Network", () {
    unittest.test("to-json--from-json", () {
      var o = buildNetwork();
      var od = new api.Network.fromJson(o.toJson());
      checkNetwork(od);
    });
  });

  unittest.group("obj-schema-NetworkEndpoint", () {
    unittest.test("to-json--from-json", () {
      var o = buildNetworkEndpoint();
      var od = new api.NetworkEndpoint.fromJson(o.toJson());
      checkNetworkEndpoint(od);
    });
  });

  unittest.group("obj-schema-NetworkEndpointGroup", () {
    unittest.test("to-json--from-json", () {
      var o = buildNetworkEndpointGroup();
      var od = new api.NetworkEndpointGroup.fromJson(o.toJson());
      checkNetworkEndpointGroup(od);
    });
  });

  unittest.group("obj-schema-NetworkEndpointGroupAggregatedListWarningData",
      () {
    unittest.test("to-json--from-json", () {
      var o = buildNetworkEndpointGroupAggregatedListWarningData();
      var od = new api.NetworkEndpointGroupAggregatedListWarningData.fromJson(
          o.toJson());
      checkNetworkEndpointGroupAggregatedListWarningData(od);
    });
  });

  unittest.group("obj-schema-NetworkEndpointGroupAggregatedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildNetworkEndpointGroupAggregatedListWarning();
      var od = new api.NetworkEndpointGroupAggregatedListWarning.fromJson(
          o.toJson());
      checkNetworkEndpointGroupAggregatedListWarning(od);
    });
  });

  unittest.group("obj-schema-NetworkEndpointGroupAggregatedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildNetworkEndpointGroupAggregatedList();
      var od = new api.NetworkEndpointGroupAggregatedList.fromJson(o.toJson());
      checkNetworkEndpointGroupAggregatedList(od);
    });
  });

  unittest.group("obj-schema-NetworkEndpointGroupListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildNetworkEndpointGroupListWarningData();
      var od = new api.NetworkEndpointGroupListWarningData.fromJson(o.toJson());
      checkNetworkEndpointGroupListWarningData(od);
    });
  });

  unittest.group("obj-schema-NetworkEndpointGroupListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildNetworkEndpointGroupListWarning();
      var od = new api.NetworkEndpointGroupListWarning.fromJson(o.toJson());
      checkNetworkEndpointGroupListWarning(od);
    });
  });

  unittest.group("obj-schema-NetworkEndpointGroupList", () {
    unittest.test("to-json--from-json", () {
      var o = buildNetworkEndpointGroupList();
      var od = new api.NetworkEndpointGroupList.fromJson(o.toJson());
      checkNetworkEndpointGroupList(od);
    });
  });

  unittest.group("obj-schema-NetworkEndpointGroupsAttachEndpointsRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildNetworkEndpointGroupsAttachEndpointsRequest();
      var od = new api.NetworkEndpointGroupsAttachEndpointsRequest.fromJson(
          o.toJson());
      checkNetworkEndpointGroupsAttachEndpointsRequest(od);
    });
  });

  unittest.group("obj-schema-NetworkEndpointGroupsDetachEndpointsRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildNetworkEndpointGroupsDetachEndpointsRequest();
      var od = new api.NetworkEndpointGroupsDetachEndpointsRequest.fromJson(
          o.toJson());
      checkNetworkEndpointGroupsDetachEndpointsRequest(od);
    });
  });

  unittest.group("obj-schema-NetworkEndpointGroupsListEndpointsRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildNetworkEndpointGroupsListEndpointsRequest();
      var od = new api.NetworkEndpointGroupsListEndpointsRequest.fromJson(
          o.toJson());
      checkNetworkEndpointGroupsListEndpointsRequest(od);
    });
  });

  unittest.group(
      "obj-schema-NetworkEndpointGroupsListNetworkEndpointsWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildNetworkEndpointGroupsListNetworkEndpointsWarningData();
      var od =
          new api.NetworkEndpointGroupsListNetworkEndpointsWarningData.fromJson(
              o.toJson());
      checkNetworkEndpointGroupsListNetworkEndpointsWarningData(od);
    });
  });

  unittest.group("obj-schema-NetworkEndpointGroupsListNetworkEndpointsWarning",
      () {
    unittest.test("to-json--from-json", () {
      var o = buildNetworkEndpointGroupsListNetworkEndpointsWarning();
      var od =
          new api.NetworkEndpointGroupsListNetworkEndpointsWarning.fromJson(
              o.toJson());
      checkNetworkEndpointGroupsListNetworkEndpointsWarning(od);
    });
  });

  unittest.group("obj-schema-NetworkEndpointGroupsListNetworkEndpoints", () {
    unittest.test("to-json--from-json", () {
      var o = buildNetworkEndpointGroupsListNetworkEndpoints();
      var od = new api.NetworkEndpointGroupsListNetworkEndpoints.fromJson(
          o.toJson());
      checkNetworkEndpointGroupsListNetworkEndpoints(od);
    });
  });

  unittest.group("obj-schema-NetworkEndpointGroupsScopedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildNetworkEndpointGroupsScopedListWarningData();
      var od = new api.NetworkEndpointGroupsScopedListWarningData.fromJson(
          o.toJson());
      checkNetworkEndpointGroupsScopedListWarningData(od);
    });
  });

  unittest.group("obj-schema-NetworkEndpointGroupsScopedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildNetworkEndpointGroupsScopedListWarning();
      var od =
          new api.NetworkEndpointGroupsScopedListWarning.fromJson(o.toJson());
      checkNetworkEndpointGroupsScopedListWarning(od);
    });
  });

  unittest.group("obj-schema-NetworkEndpointGroupsScopedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildNetworkEndpointGroupsScopedList();
      var od = new api.NetworkEndpointGroupsScopedList.fromJson(o.toJson());
      checkNetworkEndpointGroupsScopedList(od);
    });
  });

  unittest.group("obj-schema-NetworkEndpointWithHealthStatus", () {
    unittest.test("to-json--from-json", () {
      var o = buildNetworkEndpointWithHealthStatus();
      var od = new api.NetworkEndpointWithHealthStatus.fromJson(o.toJson());
      checkNetworkEndpointWithHealthStatus(od);
    });
  });

  unittest.group("obj-schema-NetworkInterface", () {
    unittest.test("to-json--from-json", () {
      var o = buildNetworkInterface();
      var od = new api.NetworkInterface.fromJson(o.toJson());
      checkNetworkInterface(od);
    });
  });

  unittest.group("obj-schema-NetworkListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildNetworkListWarningData();
      var od = new api.NetworkListWarningData.fromJson(o.toJson());
      checkNetworkListWarningData(od);
    });
  });

  unittest.group("obj-schema-NetworkListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildNetworkListWarning();
      var od = new api.NetworkListWarning.fromJson(o.toJson());
      checkNetworkListWarning(od);
    });
  });

  unittest.group("obj-schema-NetworkList", () {
    unittest.test("to-json--from-json", () {
      var o = buildNetworkList();
      var od = new api.NetworkList.fromJson(o.toJson());
      checkNetworkList(od);
    });
  });

  unittest.group("obj-schema-NetworkPeering", () {
    unittest.test("to-json--from-json", () {
      var o = buildNetworkPeering();
      var od = new api.NetworkPeering.fromJson(o.toJson());
      checkNetworkPeering(od);
    });
  });

  unittest.group("obj-schema-NetworkRoutingConfig", () {
    unittest.test("to-json--from-json", () {
      var o = buildNetworkRoutingConfig();
      var od = new api.NetworkRoutingConfig.fromJson(o.toJson());
      checkNetworkRoutingConfig(od);
    });
  });

  unittest.group("obj-schema-NetworksAddPeeringRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildNetworksAddPeeringRequest();
      var od = new api.NetworksAddPeeringRequest.fromJson(o.toJson());
      checkNetworksAddPeeringRequest(od);
    });
  });

  unittest.group("obj-schema-NetworksRemovePeeringRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildNetworksRemovePeeringRequest();
      var od = new api.NetworksRemovePeeringRequest.fromJson(o.toJson());
      checkNetworksRemovePeeringRequest(od);
    });
  });

  unittest.group("obj-schema-NodeGroup", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeGroup();
      var od = new api.NodeGroup.fromJson(o.toJson());
      checkNodeGroup(od);
    });
  });

  unittest.group("obj-schema-NodeGroupAggregatedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeGroupAggregatedListWarningData();
      var od = new api.NodeGroupAggregatedListWarningData.fromJson(o.toJson());
      checkNodeGroupAggregatedListWarningData(od);
    });
  });

  unittest.group("obj-schema-NodeGroupAggregatedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeGroupAggregatedListWarning();
      var od = new api.NodeGroupAggregatedListWarning.fromJson(o.toJson());
      checkNodeGroupAggregatedListWarning(od);
    });
  });

  unittest.group("obj-schema-NodeGroupAggregatedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeGroupAggregatedList();
      var od = new api.NodeGroupAggregatedList.fromJson(o.toJson());
      checkNodeGroupAggregatedList(od);
    });
  });

  unittest.group("obj-schema-NodeGroupListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeGroupListWarningData();
      var od = new api.NodeGroupListWarningData.fromJson(o.toJson());
      checkNodeGroupListWarningData(od);
    });
  });

  unittest.group("obj-schema-NodeGroupListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeGroupListWarning();
      var od = new api.NodeGroupListWarning.fromJson(o.toJson());
      checkNodeGroupListWarning(od);
    });
  });

  unittest.group("obj-schema-NodeGroupList", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeGroupList();
      var od = new api.NodeGroupList.fromJson(o.toJson());
      checkNodeGroupList(od);
    });
  });

  unittest.group("obj-schema-NodeGroupNode", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeGroupNode();
      var od = new api.NodeGroupNode.fromJson(o.toJson());
      checkNodeGroupNode(od);
    });
  });

  unittest.group("obj-schema-NodeGroupsAddNodesRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeGroupsAddNodesRequest();
      var od = new api.NodeGroupsAddNodesRequest.fromJson(o.toJson());
      checkNodeGroupsAddNodesRequest(od);
    });
  });

  unittest.group("obj-schema-NodeGroupsDeleteNodesRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeGroupsDeleteNodesRequest();
      var od = new api.NodeGroupsDeleteNodesRequest.fromJson(o.toJson());
      checkNodeGroupsDeleteNodesRequest(od);
    });
  });

  unittest.group("obj-schema-NodeGroupsListNodesWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeGroupsListNodesWarningData();
      var od = new api.NodeGroupsListNodesWarningData.fromJson(o.toJson());
      checkNodeGroupsListNodesWarningData(od);
    });
  });

  unittest.group("obj-schema-NodeGroupsListNodesWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeGroupsListNodesWarning();
      var od = new api.NodeGroupsListNodesWarning.fromJson(o.toJson());
      checkNodeGroupsListNodesWarning(od);
    });
  });

  unittest.group("obj-schema-NodeGroupsListNodes", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeGroupsListNodes();
      var od = new api.NodeGroupsListNodes.fromJson(o.toJson());
      checkNodeGroupsListNodes(od);
    });
  });

  unittest.group("obj-schema-NodeGroupsScopedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeGroupsScopedListWarningData();
      var od = new api.NodeGroupsScopedListWarningData.fromJson(o.toJson());
      checkNodeGroupsScopedListWarningData(od);
    });
  });

  unittest.group("obj-schema-NodeGroupsScopedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeGroupsScopedListWarning();
      var od = new api.NodeGroupsScopedListWarning.fromJson(o.toJson());
      checkNodeGroupsScopedListWarning(od);
    });
  });

  unittest.group("obj-schema-NodeGroupsScopedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeGroupsScopedList();
      var od = new api.NodeGroupsScopedList.fromJson(o.toJson());
      checkNodeGroupsScopedList(od);
    });
  });

  unittest.group("obj-schema-NodeGroupsSetNodeTemplateRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeGroupsSetNodeTemplateRequest();
      var od = new api.NodeGroupsSetNodeTemplateRequest.fromJson(o.toJson());
      checkNodeGroupsSetNodeTemplateRequest(od);
    });
  });

  unittest.group("obj-schema-NodeTemplate", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeTemplate();
      var od = new api.NodeTemplate.fromJson(o.toJson());
      checkNodeTemplate(od);
    });
  });

  unittest.group("obj-schema-NodeTemplateAggregatedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeTemplateAggregatedListWarningData();
      var od =
          new api.NodeTemplateAggregatedListWarningData.fromJson(o.toJson());
      checkNodeTemplateAggregatedListWarningData(od);
    });
  });

  unittest.group("obj-schema-NodeTemplateAggregatedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeTemplateAggregatedListWarning();
      var od = new api.NodeTemplateAggregatedListWarning.fromJson(o.toJson());
      checkNodeTemplateAggregatedListWarning(od);
    });
  });

  unittest.group("obj-schema-NodeTemplateAggregatedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeTemplateAggregatedList();
      var od = new api.NodeTemplateAggregatedList.fromJson(o.toJson());
      checkNodeTemplateAggregatedList(od);
    });
  });

  unittest.group("obj-schema-NodeTemplateListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeTemplateListWarningData();
      var od = new api.NodeTemplateListWarningData.fromJson(o.toJson());
      checkNodeTemplateListWarningData(od);
    });
  });

  unittest.group("obj-schema-NodeTemplateListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeTemplateListWarning();
      var od = new api.NodeTemplateListWarning.fromJson(o.toJson());
      checkNodeTemplateListWarning(od);
    });
  });

  unittest.group("obj-schema-NodeTemplateList", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeTemplateList();
      var od = new api.NodeTemplateList.fromJson(o.toJson());
      checkNodeTemplateList(od);
    });
  });

  unittest.group("obj-schema-NodeTemplateNodeTypeFlexibility", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeTemplateNodeTypeFlexibility();
      var od = new api.NodeTemplateNodeTypeFlexibility.fromJson(o.toJson());
      checkNodeTemplateNodeTypeFlexibility(od);
    });
  });

  unittest.group("obj-schema-NodeTemplatesScopedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeTemplatesScopedListWarningData();
      var od = new api.NodeTemplatesScopedListWarningData.fromJson(o.toJson());
      checkNodeTemplatesScopedListWarningData(od);
    });
  });

  unittest.group("obj-schema-NodeTemplatesScopedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeTemplatesScopedListWarning();
      var od = new api.NodeTemplatesScopedListWarning.fromJson(o.toJson());
      checkNodeTemplatesScopedListWarning(od);
    });
  });

  unittest.group("obj-schema-NodeTemplatesScopedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeTemplatesScopedList();
      var od = new api.NodeTemplatesScopedList.fromJson(o.toJson());
      checkNodeTemplatesScopedList(od);
    });
  });

  unittest.group("obj-schema-NodeType", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeType();
      var od = new api.NodeType.fromJson(o.toJson());
      checkNodeType(od);
    });
  });

  unittest.group("obj-schema-NodeTypeAggregatedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeTypeAggregatedListWarningData();
      var od = new api.NodeTypeAggregatedListWarningData.fromJson(o.toJson());
      checkNodeTypeAggregatedListWarningData(od);
    });
  });

  unittest.group("obj-schema-NodeTypeAggregatedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeTypeAggregatedListWarning();
      var od = new api.NodeTypeAggregatedListWarning.fromJson(o.toJson());
      checkNodeTypeAggregatedListWarning(od);
    });
  });

  unittest.group("obj-schema-NodeTypeAggregatedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeTypeAggregatedList();
      var od = new api.NodeTypeAggregatedList.fromJson(o.toJson());
      checkNodeTypeAggregatedList(od);
    });
  });

  unittest.group("obj-schema-NodeTypeListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeTypeListWarningData();
      var od = new api.NodeTypeListWarningData.fromJson(o.toJson());
      checkNodeTypeListWarningData(od);
    });
  });

  unittest.group("obj-schema-NodeTypeListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeTypeListWarning();
      var od = new api.NodeTypeListWarning.fromJson(o.toJson());
      checkNodeTypeListWarning(od);
    });
  });

  unittest.group("obj-schema-NodeTypeList", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeTypeList();
      var od = new api.NodeTypeList.fromJson(o.toJson());
      checkNodeTypeList(od);
    });
  });

  unittest.group("obj-schema-NodeTypesScopedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeTypesScopedListWarningData();
      var od = new api.NodeTypesScopedListWarningData.fromJson(o.toJson());
      checkNodeTypesScopedListWarningData(od);
    });
  });

  unittest.group("obj-schema-NodeTypesScopedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeTypesScopedListWarning();
      var od = new api.NodeTypesScopedListWarning.fromJson(o.toJson());
      checkNodeTypesScopedListWarning(od);
    });
  });

  unittest.group("obj-schema-NodeTypesScopedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildNodeTypesScopedList();
      var od = new api.NodeTypesScopedList.fromJson(o.toJson());
      checkNodeTypesScopedList(od);
    });
  });

  unittest.group("obj-schema-OperationErrorErrors", () {
    unittest.test("to-json--from-json", () {
      var o = buildOperationErrorErrors();
      var od = new api.OperationErrorErrors.fromJson(o.toJson());
      checkOperationErrorErrors(od);
    });
  });

  unittest.group("obj-schema-OperationError", () {
    unittest.test("to-json--from-json", () {
      var o = buildOperationError();
      var od = new api.OperationError.fromJson(o.toJson());
      checkOperationError(od);
    });
  });

  unittest.group("obj-schema-OperationWarningsData", () {
    unittest.test("to-json--from-json", () {
      var o = buildOperationWarningsData();
      var od = new api.OperationWarningsData.fromJson(o.toJson());
      checkOperationWarningsData(od);
    });
  });

  unittest.group("obj-schema-OperationWarnings", () {
    unittest.test("to-json--from-json", () {
      var o = buildOperationWarnings();
      var od = new api.OperationWarnings.fromJson(o.toJson());
      checkOperationWarnings(od);
    });
  });

  unittest.group("obj-schema-Operation", () {
    unittest.test("to-json--from-json", () {
      var o = buildOperation();
      var od = new api.Operation.fromJson(o.toJson());
      checkOperation(od);
    });
  });

  unittest.group("obj-schema-OperationAggregatedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildOperationAggregatedListWarningData();
      var od = new api.OperationAggregatedListWarningData.fromJson(o.toJson());
      checkOperationAggregatedListWarningData(od);
    });
  });

  unittest.group("obj-schema-OperationAggregatedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildOperationAggregatedListWarning();
      var od = new api.OperationAggregatedListWarning.fromJson(o.toJson());
      checkOperationAggregatedListWarning(od);
    });
  });

  unittest.group("obj-schema-OperationAggregatedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildOperationAggregatedList();
      var od = new api.OperationAggregatedList.fromJson(o.toJson());
      checkOperationAggregatedList(od);
    });
  });

  unittest.group("obj-schema-OperationListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildOperationListWarningData();
      var od = new api.OperationListWarningData.fromJson(o.toJson());
      checkOperationListWarningData(od);
    });
  });

  unittest.group("obj-schema-OperationListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildOperationListWarning();
      var od = new api.OperationListWarning.fromJson(o.toJson());
      checkOperationListWarning(od);
    });
  });

  unittest.group("obj-schema-OperationList", () {
    unittest.test("to-json--from-json", () {
      var o = buildOperationList();
      var od = new api.OperationList.fromJson(o.toJson());
      checkOperationList(od);
    });
  });

  unittest.group("obj-schema-OperationsScopedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildOperationsScopedListWarningData();
      var od = new api.OperationsScopedListWarningData.fromJson(o.toJson());
      checkOperationsScopedListWarningData(od);
    });
  });

  unittest.group("obj-schema-OperationsScopedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildOperationsScopedListWarning();
      var od = new api.OperationsScopedListWarning.fromJson(o.toJson());
      checkOperationsScopedListWarning(od);
    });
  });

  unittest.group("obj-schema-OperationsScopedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildOperationsScopedList();
      var od = new api.OperationsScopedList.fromJson(o.toJson());
      checkOperationsScopedList(od);
    });
  });

  unittest.group("obj-schema-PathMatcher", () {
    unittest.test("to-json--from-json", () {
      var o = buildPathMatcher();
      var od = new api.PathMatcher.fromJson(o.toJson());
      checkPathMatcher(od);
    });
  });

  unittest.group("obj-schema-PathRule", () {
    unittest.test("to-json--from-json", () {
      var o = buildPathRule();
      var od = new api.PathRule.fromJson(o.toJson());
      checkPathRule(od);
    });
  });

  unittest.group("obj-schema-Policy", () {
    unittest.test("to-json--from-json", () {
      var o = buildPolicy();
      var od = new api.Policy.fromJson(o.toJson());
      checkPolicy(od);
    });
  });

  unittest.group("obj-schema-Project", () {
    unittest.test("to-json--from-json", () {
      var o = buildProject();
      var od = new api.Project.fromJson(o.toJson());
      checkProject(od);
    });
  });

  unittest.group("obj-schema-ProjectsDisableXpnResourceRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildProjectsDisableXpnResourceRequest();
      var od = new api.ProjectsDisableXpnResourceRequest.fromJson(o.toJson());
      checkProjectsDisableXpnResourceRequest(od);
    });
  });

  unittest.group("obj-schema-ProjectsEnableXpnResourceRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildProjectsEnableXpnResourceRequest();
      var od = new api.ProjectsEnableXpnResourceRequest.fromJson(o.toJson());
      checkProjectsEnableXpnResourceRequest(od);
    });
  });

  unittest.group("obj-schema-ProjectsGetXpnResources", () {
    unittest.test("to-json--from-json", () {
      var o = buildProjectsGetXpnResources();
      var od = new api.ProjectsGetXpnResources.fromJson(o.toJson());
      checkProjectsGetXpnResources(od);
    });
  });

  unittest.group("obj-schema-ProjectsListXpnHostsRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildProjectsListXpnHostsRequest();
      var od = new api.ProjectsListXpnHostsRequest.fromJson(o.toJson());
      checkProjectsListXpnHostsRequest(od);
    });
  });

  unittest.group("obj-schema-ProjectsSetDefaultNetworkTierRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildProjectsSetDefaultNetworkTierRequest();
      var od =
          new api.ProjectsSetDefaultNetworkTierRequest.fromJson(o.toJson());
      checkProjectsSetDefaultNetworkTierRequest(od);
    });
  });

  unittest.group("obj-schema-Quota", () {
    unittest.test("to-json--from-json", () {
      var o = buildQuota();
      var od = new api.Quota.fromJson(o.toJson());
      checkQuota(od);
    });
  });

  unittest.group("obj-schema-Reference", () {
    unittest.test("to-json--from-json", () {
      var o = buildReference();
      var od = new api.Reference.fromJson(o.toJson());
      checkReference(od);
    });
  });

  unittest.group("obj-schema-Region", () {
    unittest.test("to-json--from-json", () {
      var o = buildRegion();
      var od = new api.Region.fromJson(o.toJson());
      checkRegion(od);
    });
  });

  unittest.group("obj-schema-RegionAutoscalerListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildRegionAutoscalerListWarningData();
      var od = new api.RegionAutoscalerListWarningData.fromJson(o.toJson());
      checkRegionAutoscalerListWarningData(od);
    });
  });

  unittest.group("obj-schema-RegionAutoscalerListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildRegionAutoscalerListWarning();
      var od = new api.RegionAutoscalerListWarning.fromJson(o.toJson());
      checkRegionAutoscalerListWarning(od);
    });
  });

  unittest.group("obj-schema-RegionAutoscalerList", () {
    unittest.test("to-json--from-json", () {
      var o = buildRegionAutoscalerList();
      var od = new api.RegionAutoscalerList.fromJson(o.toJson());
      checkRegionAutoscalerList(od);
    });
  });

  unittest.group("obj-schema-RegionDiskTypeListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildRegionDiskTypeListWarningData();
      var od = new api.RegionDiskTypeListWarningData.fromJson(o.toJson());
      checkRegionDiskTypeListWarningData(od);
    });
  });

  unittest.group("obj-schema-RegionDiskTypeListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildRegionDiskTypeListWarning();
      var od = new api.RegionDiskTypeListWarning.fromJson(o.toJson());
      checkRegionDiskTypeListWarning(od);
    });
  });

  unittest.group("obj-schema-RegionDiskTypeList", () {
    unittest.test("to-json--from-json", () {
      var o = buildRegionDiskTypeList();
      var od = new api.RegionDiskTypeList.fromJson(o.toJson());
      checkRegionDiskTypeList(od);
    });
  });

  unittest.group("obj-schema-RegionDisksAddResourcePoliciesRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildRegionDisksAddResourcePoliciesRequest();
      var od =
          new api.RegionDisksAddResourcePoliciesRequest.fromJson(o.toJson());
      checkRegionDisksAddResourcePoliciesRequest(od);
    });
  });

  unittest.group("obj-schema-RegionDisksRemoveResourcePoliciesRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildRegionDisksRemoveResourcePoliciesRequest();
      var od =
          new api.RegionDisksRemoveResourcePoliciesRequest.fromJson(o.toJson());
      checkRegionDisksRemoveResourcePoliciesRequest(od);
    });
  });

  unittest.group("obj-schema-RegionDisksResizeRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildRegionDisksResizeRequest();
      var od = new api.RegionDisksResizeRequest.fromJson(o.toJson());
      checkRegionDisksResizeRequest(od);
    });
  });

  unittest.group("obj-schema-RegionInstanceGroupListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildRegionInstanceGroupListWarningData();
      var od = new api.RegionInstanceGroupListWarningData.fromJson(o.toJson());
      checkRegionInstanceGroupListWarningData(od);
    });
  });

  unittest.group("obj-schema-RegionInstanceGroupListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildRegionInstanceGroupListWarning();
      var od = new api.RegionInstanceGroupListWarning.fromJson(o.toJson());
      checkRegionInstanceGroupListWarning(od);
    });
  });

  unittest.group("obj-schema-RegionInstanceGroupList", () {
    unittest.test("to-json--from-json", () {
      var o = buildRegionInstanceGroupList();
      var od = new api.RegionInstanceGroupList.fromJson(o.toJson());
      checkRegionInstanceGroupList(od);
    });
  });

  unittest.group("obj-schema-RegionInstanceGroupManagerListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildRegionInstanceGroupManagerListWarningData();
      var od = new api.RegionInstanceGroupManagerListWarningData.fromJson(
          o.toJson());
      checkRegionInstanceGroupManagerListWarningData(od);
    });
  });

  unittest.group("obj-schema-RegionInstanceGroupManagerListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildRegionInstanceGroupManagerListWarning();
      var od =
          new api.RegionInstanceGroupManagerListWarning.fromJson(o.toJson());
      checkRegionInstanceGroupManagerListWarning(od);
    });
  });

  unittest.group("obj-schema-RegionInstanceGroupManagerList", () {
    unittest.test("to-json--from-json", () {
      var o = buildRegionInstanceGroupManagerList();
      var od = new api.RegionInstanceGroupManagerList.fromJson(o.toJson());
      checkRegionInstanceGroupManagerList(od);
    });
  });

  unittest.group(
      "obj-schema-RegionInstanceGroupManagersAbandonInstancesRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildRegionInstanceGroupManagersAbandonInstancesRequest();
      var od =
          new api.RegionInstanceGroupManagersAbandonInstancesRequest.fromJson(
              o.toJson());
      checkRegionInstanceGroupManagersAbandonInstancesRequest(od);
    });
  });

  unittest.group("obj-schema-RegionInstanceGroupManagersDeleteInstancesRequest",
      () {
    unittest.test("to-json--from-json", () {
      var o = buildRegionInstanceGroupManagersDeleteInstancesRequest();
      var od =
          new api.RegionInstanceGroupManagersDeleteInstancesRequest.fromJson(
              o.toJson());
      checkRegionInstanceGroupManagersDeleteInstancesRequest(od);
    });
  });

  unittest.group("obj-schema-RegionInstanceGroupManagersListInstancesResponse",
      () {
    unittest.test("to-json--from-json", () {
      var o = buildRegionInstanceGroupManagersListInstancesResponse();
      var od =
          new api.RegionInstanceGroupManagersListInstancesResponse.fromJson(
              o.toJson());
      checkRegionInstanceGroupManagersListInstancesResponse(od);
    });
  });

  unittest.group("obj-schema-RegionInstanceGroupManagersRecreateRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildRegionInstanceGroupManagersRecreateRequest();
      var od = new api.RegionInstanceGroupManagersRecreateRequest.fromJson(
          o.toJson());
      checkRegionInstanceGroupManagersRecreateRequest(od);
    });
  });

  unittest.group("obj-schema-RegionInstanceGroupManagersSetTargetPoolsRequest",
      () {
    unittest.test("to-json--from-json", () {
      var o = buildRegionInstanceGroupManagersSetTargetPoolsRequest();
      var od =
          new api.RegionInstanceGroupManagersSetTargetPoolsRequest.fromJson(
              o.toJson());
      checkRegionInstanceGroupManagersSetTargetPoolsRequest(od);
    });
  });

  unittest.group("obj-schema-RegionInstanceGroupManagersSetTemplateRequest",
      () {
    unittest.test("to-json--from-json", () {
      var o = buildRegionInstanceGroupManagersSetTemplateRequest();
      var od = new api.RegionInstanceGroupManagersSetTemplateRequest.fromJson(
          o.toJson());
      checkRegionInstanceGroupManagersSetTemplateRequest(od);
    });
  });

  unittest.group("obj-schema-RegionInstanceGroupsListInstancesWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildRegionInstanceGroupsListInstancesWarningData();
      var od = new api.RegionInstanceGroupsListInstancesWarningData.fromJson(
          o.toJson());
      checkRegionInstanceGroupsListInstancesWarningData(od);
    });
  });

  unittest.group("obj-schema-RegionInstanceGroupsListInstancesWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildRegionInstanceGroupsListInstancesWarning();
      var od =
          new api.RegionInstanceGroupsListInstancesWarning.fromJson(o.toJson());
      checkRegionInstanceGroupsListInstancesWarning(od);
    });
  });

  unittest.group("obj-schema-RegionInstanceGroupsListInstances", () {
    unittest.test("to-json--from-json", () {
      var o = buildRegionInstanceGroupsListInstances();
      var od = new api.RegionInstanceGroupsListInstances.fromJson(o.toJson());
      checkRegionInstanceGroupsListInstances(od);
    });
  });

  unittest.group("obj-schema-RegionInstanceGroupsListInstancesRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildRegionInstanceGroupsListInstancesRequest();
      var od =
          new api.RegionInstanceGroupsListInstancesRequest.fromJson(o.toJson());
      checkRegionInstanceGroupsListInstancesRequest(od);
    });
  });

  unittest.group("obj-schema-RegionInstanceGroupsSetNamedPortsRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildRegionInstanceGroupsSetNamedPortsRequest();
      var od =
          new api.RegionInstanceGroupsSetNamedPortsRequest.fromJson(o.toJson());
      checkRegionInstanceGroupsSetNamedPortsRequest(od);
    });
  });

  unittest.group("obj-schema-RegionListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildRegionListWarningData();
      var od = new api.RegionListWarningData.fromJson(o.toJson());
      checkRegionListWarningData(od);
    });
  });

  unittest.group("obj-schema-RegionListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildRegionListWarning();
      var od = new api.RegionListWarning.fromJson(o.toJson());
      checkRegionListWarning(od);
    });
  });

  unittest.group("obj-schema-RegionList", () {
    unittest.test("to-json--from-json", () {
      var o = buildRegionList();
      var od = new api.RegionList.fromJson(o.toJson());
      checkRegionList(od);
    });
  });

  unittest.group("obj-schema-RegionSetLabelsRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildRegionSetLabelsRequest();
      var od = new api.RegionSetLabelsRequest.fromJson(o.toJson());
      checkRegionSetLabelsRequest(od);
    });
  });

  unittest.group("obj-schema-RegionSetPolicyRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildRegionSetPolicyRequest();
      var od = new api.RegionSetPolicyRequest.fromJson(o.toJson());
      checkRegionSetPolicyRequest(od);
    });
  });

  unittest.group("obj-schema-Reservation", () {
    unittest.test("to-json--from-json", () {
      var o = buildReservation();
      var od = new api.Reservation.fromJson(o.toJson());
      checkReservation(od);
    });
  });

  unittest.group("obj-schema-ReservationAffinity", () {
    unittest.test("to-json--from-json", () {
      var o = buildReservationAffinity();
      var od = new api.ReservationAffinity.fromJson(o.toJson());
      checkReservationAffinity(od);
    });
  });

  unittest.group("obj-schema-ReservationAggregatedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildReservationAggregatedListWarningData();
      var od =
          new api.ReservationAggregatedListWarningData.fromJson(o.toJson());
      checkReservationAggregatedListWarningData(od);
    });
  });

  unittest.group("obj-schema-ReservationAggregatedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildReservationAggregatedListWarning();
      var od = new api.ReservationAggregatedListWarning.fromJson(o.toJson());
      checkReservationAggregatedListWarning(od);
    });
  });

  unittest.group("obj-schema-ReservationAggregatedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildReservationAggregatedList();
      var od = new api.ReservationAggregatedList.fromJson(o.toJson());
      checkReservationAggregatedList(od);
    });
  });

  unittest.group("obj-schema-ReservationListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildReservationListWarningData();
      var od = new api.ReservationListWarningData.fromJson(o.toJson());
      checkReservationListWarningData(od);
    });
  });

  unittest.group("obj-schema-ReservationListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildReservationListWarning();
      var od = new api.ReservationListWarning.fromJson(o.toJson());
      checkReservationListWarning(od);
    });
  });

  unittest.group("obj-schema-ReservationList", () {
    unittest.test("to-json--from-json", () {
      var o = buildReservationList();
      var od = new api.ReservationList.fromJson(o.toJson());
      checkReservationList(od);
    });
  });

  unittest.group("obj-schema-ReservationsResizeRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildReservationsResizeRequest();
      var od = new api.ReservationsResizeRequest.fromJson(o.toJson());
      checkReservationsResizeRequest(od);
    });
  });

  unittest.group("obj-schema-ReservationsScopedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildReservationsScopedListWarningData();
      var od = new api.ReservationsScopedListWarningData.fromJson(o.toJson());
      checkReservationsScopedListWarningData(od);
    });
  });

  unittest.group("obj-schema-ReservationsScopedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildReservationsScopedListWarning();
      var od = new api.ReservationsScopedListWarning.fromJson(o.toJson());
      checkReservationsScopedListWarning(od);
    });
  });

  unittest.group("obj-schema-ReservationsScopedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildReservationsScopedList();
      var od = new api.ReservationsScopedList.fromJson(o.toJson());
      checkReservationsScopedList(od);
    });
  });

  unittest.group("obj-schema-ResourceCommitment", () {
    unittest.test("to-json--from-json", () {
      var o = buildResourceCommitment();
      var od = new api.ResourceCommitment.fromJson(o.toJson());
      checkResourceCommitment(od);
    });
  });

  unittest.group("obj-schema-ResourceGroupReference", () {
    unittest.test("to-json--from-json", () {
      var o = buildResourceGroupReference();
      var od = new api.ResourceGroupReference.fromJson(o.toJson());
      checkResourceGroupReference(od);
    });
  });

  unittest.group("obj-schema-ResourcePoliciesScopedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildResourcePoliciesScopedListWarningData();
      var od =
          new api.ResourcePoliciesScopedListWarningData.fromJson(o.toJson());
      checkResourcePoliciesScopedListWarningData(od);
    });
  });

  unittest.group("obj-schema-ResourcePoliciesScopedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildResourcePoliciesScopedListWarning();
      var od = new api.ResourcePoliciesScopedListWarning.fromJson(o.toJson());
      checkResourcePoliciesScopedListWarning(od);
    });
  });

  unittest.group("obj-schema-ResourcePoliciesScopedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildResourcePoliciesScopedList();
      var od = new api.ResourcePoliciesScopedList.fromJson(o.toJson());
      checkResourcePoliciesScopedList(od);
    });
  });

  unittest.group("obj-schema-ResourcePolicy", () {
    unittest.test("to-json--from-json", () {
      var o = buildResourcePolicy();
      var od = new api.ResourcePolicy.fromJson(o.toJson());
      checkResourcePolicy(od);
    });
  });

  unittest.group("obj-schema-ResourcePolicyAggregatedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildResourcePolicyAggregatedListWarningData();
      var od =
          new api.ResourcePolicyAggregatedListWarningData.fromJson(o.toJson());
      checkResourcePolicyAggregatedListWarningData(od);
    });
  });

  unittest.group("obj-schema-ResourcePolicyAggregatedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildResourcePolicyAggregatedListWarning();
      var od = new api.ResourcePolicyAggregatedListWarning.fromJson(o.toJson());
      checkResourcePolicyAggregatedListWarning(od);
    });
  });

  unittest.group("obj-schema-ResourcePolicyAggregatedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildResourcePolicyAggregatedList();
      var od = new api.ResourcePolicyAggregatedList.fromJson(o.toJson());
      checkResourcePolicyAggregatedList(od);
    });
  });

  unittest.group("obj-schema-ResourcePolicyDailyCycle", () {
    unittest.test("to-json--from-json", () {
      var o = buildResourcePolicyDailyCycle();
      var od = new api.ResourcePolicyDailyCycle.fromJson(o.toJson());
      checkResourcePolicyDailyCycle(od);
    });
  });

  unittest.group("obj-schema-ResourcePolicyHourlyCycle", () {
    unittest.test("to-json--from-json", () {
      var o = buildResourcePolicyHourlyCycle();
      var od = new api.ResourcePolicyHourlyCycle.fromJson(o.toJson());
      checkResourcePolicyHourlyCycle(od);
    });
  });

  unittest.group("obj-schema-ResourcePolicyListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildResourcePolicyListWarningData();
      var od = new api.ResourcePolicyListWarningData.fromJson(o.toJson());
      checkResourcePolicyListWarningData(od);
    });
  });

  unittest.group("obj-schema-ResourcePolicyListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildResourcePolicyListWarning();
      var od = new api.ResourcePolicyListWarning.fromJson(o.toJson());
      checkResourcePolicyListWarning(od);
    });
  });

  unittest.group("obj-schema-ResourcePolicyList", () {
    unittest.test("to-json--from-json", () {
      var o = buildResourcePolicyList();
      var od = new api.ResourcePolicyList.fromJson(o.toJson());
      checkResourcePolicyList(od);
    });
  });

  unittest.group("obj-schema-ResourcePolicySnapshotSchedulePolicy", () {
    unittest.test("to-json--from-json", () {
      var o = buildResourcePolicySnapshotSchedulePolicy();
      var od =
          new api.ResourcePolicySnapshotSchedulePolicy.fromJson(o.toJson());
      checkResourcePolicySnapshotSchedulePolicy(od);
    });
  });

  unittest.group(
      "obj-schema-ResourcePolicySnapshotSchedulePolicyRetentionPolicy", () {
    unittest.test("to-json--from-json", () {
      var o = buildResourcePolicySnapshotSchedulePolicyRetentionPolicy();
      var od =
          new api.ResourcePolicySnapshotSchedulePolicyRetentionPolicy.fromJson(
              o.toJson());
      checkResourcePolicySnapshotSchedulePolicyRetentionPolicy(od);
    });
  });

  unittest.group("obj-schema-ResourcePolicySnapshotSchedulePolicySchedule", () {
    unittest.test("to-json--from-json", () {
      var o = buildResourcePolicySnapshotSchedulePolicySchedule();
      var od = new api.ResourcePolicySnapshotSchedulePolicySchedule.fromJson(
          o.toJson());
      checkResourcePolicySnapshotSchedulePolicySchedule(od);
    });
  });

  unittest.group(
      "obj-schema-ResourcePolicySnapshotSchedulePolicySnapshotProperties", () {
    unittest.test("to-json--from-json", () {
      var o = buildResourcePolicySnapshotSchedulePolicySnapshotProperties();
      var od = new api
              .ResourcePolicySnapshotSchedulePolicySnapshotProperties.fromJson(
          o.toJson());
      checkResourcePolicySnapshotSchedulePolicySnapshotProperties(od);
    });
  });

  unittest.group("obj-schema-ResourcePolicyWeeklyCycle", () {
    unittest.test("to-json--from-json", () {
      var o = buildResourcePolicyWeeklyCycle();
      var od = new api.ResourcePolicyWeeklyCycle.fromJson(o.toJson());
      checkResourcePolicyWeeklyCycle(od);
    });
  });

  unittest.group("obj-schema-ResourcePolicyWeeklyCycleDayOfWeek", () {
    unittest.test("to-json--from-json", () {
      var o = buildResourcePolicyWeeklyCycleDayOfWeek();
      var od = new api.ResourcePolicyWeeklyCycleDayOfWeek.fromJson(o.toJson());
      checkResourcePolicyWeeklyCycleDayOfWeek(od);
    });
  });

  unittest.group("obj-schema-RouteWarningsData", () {
    unittest.test("to-json--from-json", () {
      var o = buildRouteWarningsData();
      var od = new api.RouteWarningsData.fromJson(o.toJson());
      checkRouteWarningsData(od);
    });
  });

  unittest.group("obj-schema-RouteWarnings", () {
    unittest.test("to-json--from-json", () {
      var o = buildRouteWarnings();
      var od = new api.RouteWarnings.fromJson(o.toJson());
      checkRouteWarnings(od);
    });
  });

  unittest.group("obj-schema-Route", () {
    unittest.test("to-json--from-json", () {
      var o = buildRoute();
      var od = new api.Route.fromJson(o.toJson());
      checkRoute(od);
    });
  });

  unittest.group("obj-schema-RouteListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildRouteListWarningData();
      var od = new api.RouteListWarningData.fromJson(o.toJson());
      checkRouteListWarningData(od);
    });
  });

  unittest.group("obj-schema-RouteListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildRouteListWarning();
      var od = new api.RouteListWarning.fromJson(o.toJson());
      checkRouteListWarning(od);
    });
  });

  unittest.group("obj-schema-RouteList", () {
    unittest.test("to-json--from-json", () {
      var o = buildRouteList();
      var od = new api.RouteList.fromJson(o.toJson());
      checkRouteList(od);
    });
  });

  unittest.group("obj-schema-Router", () {
    unittest.test("to-json--from-json", () {
      var o = buildRouter();
      var od = new api.Router.fromJson(o.toJson());
      checkRouter(od);
    });
  });

  unittest.group("obj-schema-RouterAdvertisedIpRange", () {
    unittest.test("to-json--from-json", () {
      var o = buildRouterAdvertisedIpRange();
      var od = new api.RouterAdvertisedIpRange.fromJson(o.toJson());
      checkRouterAdvertisedIpRange(od);
    });
  });

  unittest.group("obj-schema-RouterAggregatedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildRouterAggregatedListWarningData();
      var od = new api.RouterAggregatedListWarningData.fromJson(o.toJson());
      checkRouterAggregatedListWarningData(od);
    });
  });

  unittest.group("obj-schema-RouterAggregatedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildRouterAggregatedListWarning();
      var od = new api.RouterAggregatedListWarning.fromJson(o.toJson());
      checkRouterAggregatedListWarning(od);
    });
  });

  unittest.group("obj-schema-RouterAggregatedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildRouterAggregatedList();
      var od = new api.RouterAggregatedList.fromJson(o.toJson());
      checkRouterAggregatedList(od);
    });
  });

  unittest.group("obj-schema-RouterBgp", () {
    unittest.test("to-json--from-json", () {
      var o = buildRouterBgp();
      var od = new api.RouterBgp.fromJson(o.toJson());
      checkRouterBgp(od);
    });
  });

  unittest.group("obj-schema-RouterBgpPeer", () {
    unittest.test("to-json--from-json", () {
      var o = buildRouterBgpPeer();
      var od = new api.RouterBgpPeer.fromJson(o.toJson());
      checkRouterBgpPeer(od);
    });
  });

  unittest.group("obj-schema-RouterInterface", () {
    unittest.test("to-json--from-json", () {
      var o = buildRouterInterface();
      var od = new api.RouterInterface.fromJson(o.toJson());
      checkRouterInterface(od);
    });
  });

  unittest.group("obj-schema-RouterListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildRouterListWarningData();
      var od = new api.RouterListWarningData.fromJson(o.toJson());
      checkRouterListWarningData(od);
    });
  });

  unittest.group("obj-schema-RouterListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildRouterListWarning();
      var od = new api.RouterListWarning.fromJson(o.toJson());
      checkRouterListWarning(od);
    });
  });

  unittest.group("obj-schema-RouterList", () {
    unittest.test("to-json--from-json", () {
      var o = buildRouterList();
      var od = new api.RouterList.fromJson(o.toJson());
      checkRouterList(od);
    });
  });

  unittest.group("obj-schema-RouterNat", () {
    unittest.test("to-json--from-json", () {
      var o = buildRouterNat();
      var od = new api.RouterNat.fromJson(o.toJson());
      checkRouterNat(od);
    });
  });

  unittest.group("obj-schema-RouterNatLogConfig", () {
    unittest.test("to-json--from-json", () {
      var o = buildRouterNatLogConfig();
      var od = new api.RouterNatLogConfig.fromJson(o.toJson());
      checkRouterNatLogConfig(od);
    });
  });

  unittest.group("obj-schema-RouterNatSubnetworkToNat", () {
    unittest.test("to-json--from-json", () {
      var o = buildRouterNatSubnetworkToNat();
      var od = new api.RouterNatSubnetworkToNat.fromJson(o.toJson());
      checkRouterNatSubnetworkToNat(od);
    });
  });

  unittest.group("obj-schema-RouterStatus", () {
    unittest.test("to-json--from-json", () {
      var o = buildRouterStatus();
      var od = new api.RouterStatus.fromJson(o.toJson());
      checkRouterStatus(od);
    });
  });

  unittest.group("obj-schema-RouterStatusBgpPeerStatus", () {
    unittest.test("to-json--from-json", () {
      var o = buildRouterStatusBgpPeerStatus();
      var od = new api.RouterStatusBgpPeerStatus.fromJson(o.toJson());
      checkRouterStatusBgpPeerStatus(od);
    });
  });

  unittest.group("obj-schema-RouterStatusNatStatus", () {
    unittest.test("to-json--from-json", () {
      var o = buildRouterStatusNatStatus();
      var od = new api.RouterStatusNatStatus.fromJson(o.toJson());
      checkRouterStatusNatStatus(od);
    });
  });

  unittest.group("obj-schema-RouterStatusResponse", () {
    unittest.test("to-json--from-json", () {
      var o = buildRouterStatusResponse();
      var od = new api.RouterStatusResponse.fromJson(o.toJson());
      checkRouterStatusResponse(od);
    });
  });

  unittest.group("obj-schema-RoutersPreviewResponse", () {
    unittest.test("to-json--from-json", () {
      var o = buildRoutersPreviewResponse();
      var od = new api.RoutersPreviewResponse.fromJson(o.toJson());
      checkRoutersPreviewResponse(od);
    });
  });

  unittest.group("obj-schema-RoutersScopedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildRoutersScopedListWarningData();
      var od = new api.RoutersScopedListWarningData.fromJson(o.toJson());
      checkRoutersScopedListWarningData(od);
    });
  });

  unittest.group("obj-schema-RoutersScopedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildRoutersScopedListWarning();
      var od = new api.RoutersScopedListWarning.fromJson(o.toJson());
      checkRoutersScopedListWarning(od);
    });
  });

  unittest.group("obj-schema-RoutersScopedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildRoutersScopedList();
      var od = new api.RoutersScopedList.fromJson(o.toJson());
      checkRoutersScopedList(od);
    });
  });

  unittest.group("obj-schema-Rule", () {
    unittest.test("to-json--from-json", () {
      var o = buildRule();
      var od = new api.Rule.fromJson(o.toJson());
      checkRule(od);
    });
  });

  unittest.group("obj-schema-SSLHealthCheck", () {
    unittest.test("to-json--from-json", () {
      var o = buildSSLHealthCheck();
      var od = new api.SSLHealthCheck.fromJson(o.toJson());
      checkSSLHealthCheck(od);
    });
  });

  unittest.group("obj-schema-Scheduling", () {
    unittest.test("to-json--from-json", () {
      var o = buildScheduling();
      var od = new api.Scheduling.fromJson(o.toJson());
      checkScheduling(od);
    });
  });

  unittest.group("obj-schema-SchedulingNodeAffinity", () {
    unittest.test("to-json--from-json", () {
      var o = buildSchedulingNodeAffinity();
      var od = new api.SchedulingNodeAffinity.fromJson(o.toJson());
      checkSchedulingNodeAffinity(od);
    });
  });

  unittest.group("obj-schema-SecurityPolicy", () {
    unittest.test("to-json--from-json", () {
      var o = buildSecurityPolicy();
      var od = new api.SecurityPolicy.fromJson(o.toJson());
      checkSecurityPolicy(od);
    });
  });

  unittest.group("obj-schema-SecurityPolicyListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildSecurityPolicyListWarningData();
      var od = new api.SecurityPolicyListWarningData.fromJson(o.toJson());
      checkSecurityPolicyListWarningData(od);
    });
  });

  unittest.group("obj-schema-SecurityPolicyListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildSecurityPolicyListWarning();
      var od = new api.SecurityPolicyListWarning.fromJson(o.toJson());
      checkSecurityPolicyListWarning(od);
    });
  });

  unittest.group("obj-schema-SecurityPolicyList", () {
    unittest.test("to-json--from-json", () {
      var o = buildSecurityPolicyList();
      var od = new api.SecurityPolicyList.fromJson(o.toJson());
      checkSecurityPolicyList(od);
    });
  });

  unittest.group("obj-schema-SecurityPolicyReference", () {
    unittest.test("to-json--from-json", () {
      var o = buildSecurityPolicyReference();
      var od = new api.SecurityPolicyReference.fromJson(o.toJson());
      checkSecurityPolicyReference(od);
    });
  });

  unittest.group("obj-schema-SecurityPolicyRule", () {
    unittest.test("to-json--from-json", () {
      var o = buildSecurityPolicyRule();
      var od = new api.SecurityPolicyRule.fromJson(o.toJson());
      checkSecurityPolicyRule(od);
    });
  });

  unittest.group("obj-schema-SecurityPolicyRuleMatcher", () {
    unittest.test("to-json--from-json", () {
      var o = buildSecurityPolicyRuleMatcher();
      var od = new api.SecurityPolicyRuleMatcher.fromJson(o.toJson());
      checkSecurityPolicyRuleMatcher(od);
    });
  });

  unittest.group("obj-schema-SecurityPolicyRuleMatcherConfig", () {
    unittest.test("to-json--from-json", () {
      var o = buildSecurityPolicyRuleMatcherConfig();
      var od = new api.SecurityPolicyRuleMatcherConfig.fromJson(o.toJson());
      checkSecurityPolicyRuleMatcherConfig(od);
    });
  });

  unittest.group("obj-schema-SerialPortOutput", () {
    unittest.test("to-json--from-json", () {
      var o = buildSerialPortOutput();
      var od = new api.SerialPortOutput.fromJson(o.toJson());
      checkSerialPortOutput(od);
    });
  });

  unittest.group("obj-schema-ServerBinding", () {
    unittest.test("to-json--from-json", () {
      var o = buildServerBinding();
      var od = new api.ServerBinding.fromJson(o.toJson());
      checkServerBinding(od);
    });
  });

  unittest.group("obj-schema-ServiceAccount", () {
    unittest.test("to-json--from-json", () {
      var o = buildServiceAccount();
      var od = new api.ServiceAccount.fromJson(o.toJson());
      checkServiceAccount(od);
    });
  });

  unittest.group("obj-schema-ShieldedInstanceConfig", () {
    unittest.test("to-json--from-json", () {
      var o = buildShieldedInstanceConfig();
      var od = new api.ShieldedInstanceConfig.fromJson(o.toJson());
      checkShieldedInstanceConfig(od);
    });
  });

  unittest.group("obj-schema-ShieldedInstanceIdentity", () {
    unittest.test("to-json--from-json", () {
      var o = buildShieldedInstanceIdentity();
      var od = new api.ShieldedInstanceIdentity.fromJson(o.toJson());
      checkShieldedInstanceIdentity(od);
    });
  });

  unittest.group("obj-schema-ShieldedInstanceIdentityEntry", () {
    unittest.test("to-json--from-json", () {
      var o = buildShieldedInstanceIdentityEntry();
      var od = new api.ShieldedInstanceIdentityEntry.fromJson(o.toJson());
      checkShieldedInstanceIdentityEntry(od);
    });
  });

  unittest.group("obj-schema-ShieldedInstanceIntegrityPolicy", () {
    unittest.test("to-json--from-json", () {
      var o = buildShieldedInstanceIntegrityPolicy();
      var od = new api.ShieldedInstanceIntegrityPolicy.fromJson(o.toJson());
      checkShieldedInstanceIntegrityPolicy(od);
    });
  });

  unittest.group("obj-schema-SignedUrlKey", () {
    unittest.test("to-json--from-json", () {
      var o = buildSignedUrlKey();
      var od = new api.SignedUrlKey.fromJson(o.toJson());
      checkSignedUrlKey(od);
    });
  });

  unittest.group("obj-schema-Snapshot", () {
    unittest.test("to-json--from-json", () {
      var o = buildSnapshot();
      var od = new api.Snapshot.fromJson(o.toJson());
      checkSnapshot(od);
    });
  });

  unittest.group("obj-schema-SnapshotListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildSnapshotListWarningData();
      var od = new api.SnapshotListWarningData.fromJson(o.toJson());
      checkSnapshotListWarningData(od);
    });
  });

  unittest.group("obj-schema-SnapshotListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildSnapshotListWarning();
      var od = new api.SnapshotListWarning.fromJson(o.toJson());
      checkSnapshotListWarning(od);
    });
  });

  unittest.group("obj-schema-SnapshotList", () {
    unittest.test("to-json--from-json", () {
      var o = buildSnapshotList();
      var od = new api.SnapshotList.fromJson(o.toJson());
      checkSnapshotList(od);
    });
  });

  unittest.group("obj-schema-SourceInstanceParams", () {
    unittest.test("to-json--from-json", () {
      var o = buildSourceInstanceParams();
      var od = new api.SourceInstanceParams.fromJson(o.toJson());
      checkSourceInstanceParams(od);
    });
  });

  unittest.group("obj-schema-SslCertificate", () {
    unittest.test("to-json--from-json", () {
      var o = buildSslCertificate();
      var od = new api.SslCertificate.fromJson(o.toJson());
      checkSslCertificate(od);
    });
  });

  unittest.group("obj-schema-SslCertificateListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildSslCertificateListWarningData();
      var od = new api.SslCertificateListWarningData.fromJson(o.toJson());
      checkSslCertificateListWarningData(od);
    });
  });

  unittest.group("obj-schema-SslCertificateListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildSslCertificateListWarning();
      var od = new api.SslCertificateListWarning.fromJson(o.toJson());
      checkSslCertificateListWarning(od);
    });
  });

  unittest.group("obj-schema-SslCertificateList", () {
    unittest.test("to-json--from-json", () {
      var o = buildSslCertificateList();
      var od = new api.SslCertificateList.fromJson(o.toJson());
      checkSslCertificateList(od);
    });
  });

  unittest.group("obj-schema-SslPoliciesListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildSslPoliciesListWarningData();
      var od = new api.SslPoliciesListWarningData.fromJson(o.toJson());
      checkSslPoliciesListWarningData(od);
    });
  });

  unittest.group("obj-schema-SslPoliciesListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildSslPoliciesListWarning();
      var od = new api.SslPoliciesListWarning.fromJson(o.toJson());
      checkSslPoliciesListWarning(od);
    });
  });

  unittest.group("obj-schema-SslPoliciesList", () {
    unittest.test("to-json--from-json", () {
      var o = buildSslPoliciesList();
      var od = new api.SslPoliciesList.fromJson(o.toJson());
      checkSslPoliciesList(od);
    });
  });

  unittest.group("obj-schema-SslPoliciesListAvailableFeaturesResponse", () {
    unittest.test("to-json--from-json", () {
      var o = buildSslPoliciesListAvailableFeaturesResponse();
      var od =
          new api.SslPoliciesListAvailableFeaturesResponse.fromJson(o.toJson());
      checkSslPoliciesListAvailableFeaturesResponse(od);
    });
  });

  unittest.group("obj-schema-SslPolicyWarningsData", () {
    unittest.test("to-json--from-json", () {
      var o = buildSslPolicyWarningsData();
      var od = new api.SslPolicyWarningsData.fromJson(o.toJson());
      checkSslPolicyWarningsData(od);
    });
  });

  unittest.group("obj-schema-SslPolicyWarnings", () {
    unittest.test("to-json--from-json", () {
      var o = buildSslPolicyWarnings();
      var od = new api.SslPolicyWarnings.fromJson(o.toJson());
      checkSslPolicyWarnings(od);
    });
  });

  unittest.group("obj-schema-SslPolicy", () {
    unittest.test("to-json--from-json", () {
      var o = buildSslPolicy();
      var od = new api.SslPolicy.fromJson(o.toJson());
      checkSslPolicy(od);
    });
  });

  unittest.group("obj-schema-SslPolicyReference", () {
    unittest.test("to-json--from-json", () {
      var o = buildSslPolicyReference();
      var od = new api.SslPolicyReference.fromJson(o.toJson());
      checkSslPolicyReference(od);
    });
  });

  unittest.group("obj-schema-Subnetwork", () {
    unittest.test("to-json--from-json", () {
      var o = buildSubnetwork();
      var od = new api.Subnetwork.fromJson(o.toJson());
      checkSubnetwork(od);
    });
  });

  unittest.group("obj-schema-SubnetworkAggregatedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildSubnetworkAggregatedListWarningData();
      var od = new api.SubnetworkAggregatedListWarningData.fromJson(o.toJson());
      checkSubnetworkAggregatedListWarningData(od);
    });
  });

  unittest.group("obj-schema-SubnetworkAggregatedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildSubnetworkAggregatedListWarning();
      var od = new api.SubnetworkAggregatedListWarning.fromJson(o.toJson());
      checkSubnetworkAggregatedListWarning(od);
    });
  });

  unittest.group("obj-schema-SubnetworkAggregatedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildSubnetworkAggregatedList();
      var od = new api.SubnetworkAggregatedList.fromJson(o.toJson());
      checkSubnetworkAggregatedList(od);
    });
  });

  unittest.group("obj-schema-SubnetworkListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildSubnetworkListWarningData();
      var od = new api.SubnetworkListWarningData.fromJson(o.toJson());
      checkSubnetworkListWarningData(od);
    });
  });

  unittest.group("obj-schema-SubnetworkListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildSubnetworkListWarning();
      var od = new api.SubnetworkListWarning.fromJson(o.toJson());
      checkSubnetworkListWarning(od);
    });
  });

  unittest.group("obj-schema-SubnetworkList", () {
    unittest.test("to-json--from-json", () {
      var o = buildSubnetworkList();
      var od = new api.SubnetworkList.fromJson(o.toJson());
      checkSubnetworkList(od);
    });
  });

  unittest.group("obj-schema-SubnetworkSecondaryRange", () {
    unittest.test("to-json--from-json", () {
      var o = buildSubnetworkSecondaryRange();
      var od = new api.SubnetworkSecondaryRange.fromJson(o.toJson());
      checkSubnetworkSecondaryRange(od);
    });
  });

  unittest.group("obj-schema-SubnetworksExpandIpCidrRangeRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildSubnetworksExpandIpCidrRangeRequest();
      var od = new api.SubnetworksExpandIpCidrRangeRequest.fromJson(o.toJson());
      checkSubnetworksExpandIpCidrRangeRequest(od);
    });
  });

  unittest.group("obj-schema-SubnetworksScopedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildSubnetworksScopedListWarningData();
      var od = new api.SubnetworksScopedListWarningData.fromJson(o.toJson());
      checkSubnetworksScopedListWarningData(od);
    });
  });

  unittest.group("obj-schema-SubnetworksScopedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildSubnetworksScopedListWarning();
      var od = new api.SubnetworksScopedListWarning.fromJson(o.toJson());
      checkSubnetworksScopedListWarning(od);
    });
  });

  unittest.group("obj-schema-SubnetworksScopedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildSubnetworksScopedList();
      var od = new api.SubnetworksScopedList.fromJson(o.toJson());
      checkSubnetworksScopedList(od);
    });
  });

  unittest.group("obj-schema-SubnetworksSetPrivateIpGoogleAccessRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildSubnetworksSetPrivateIpGoogleAccessRequest();
      var od = new api.SubnetworksSetPrivateIpGoogleAccessRequest.fromJson(
          o.toJson());
      checkSubnetworksSetPrivateIpGoogleAccessRequest(od);
    });
  });

  unittest.group("obj-schema-TCPHealthCheck", () {
    unittest.test("to-json--from-json", () {
      var o = buildTCPHealthCheck();
      var od = new api.TCPHealthCheck.fromJson(o.toJson());
      checkTCPHealthCheck(od);
    });
  });

  unittest.group("obj-schema-Tags", () {
    unittest.test("to-json--from-json", () {
      var o = buildTags();
      var od = new api.Tags.fromJson(o.toJson());
      checkTags(od);
    });
  });

  unittest.group("obj-schema-TargetHttpProxy", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetHttpProxy();
      var od = new api.TargetHttpProxy.fromJson(o.toJson());
      checkTargetHttpProxy(od);
    });
  });

  unittest.group("obj-schema-TargetHttpProxyListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetHttpProxyListWarningData();
      var od = new api.TargetHttpProxyListWarningData.fromJson(o.toJson());
      checkTargetHttpProxyListWarningData(od);
    });
  });

  unittest.group("obj-schema-TargetHttpProxyListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetHttpProxyListWarning();
      var od = new api.TargetHttpProxyListWarning.fromJson(o.toJson());
      checkTargetHttpProxyListWarning(od);
    });
  });

  unittest.group("obj-schema-TargetHttpProxyList", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetHttpProxyList();
      var od = new api.TargetHttpProxyList.fromJson(o.toJson());
      checkTargetHttpProxyList(od);
    });
  });

  unittest.group("obj-schema-TargetHttpsProxiesSetQuicOverrideRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetHttpsProxiesSetQuicOverrideRequest();
      var od =
          new api.TargetHttpsProxiesSetQuicOverrideRequest.fromJson(o.toJson());
      checkTargetHttpsProxiesSetQuicOverrideRequest(od);
    });
  });

  unittest.group("obj-schema-TargetHttpsProxiesSetSslCertificatesRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetHttpsProxiesSetSslCertificatesRequest();
      var od = new api.TargetHttpsProxiesSetSslCertificatesRequest.fromJson(
          o.toJson());
      checkTargetHttpsProxiesSetSslCertificatesRequest(od);
    });
  });

  unittest.group("obj-schema-TargetHttpsProxy", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetHttpsProxy();
      var od = new api.TargetHttpsProxy.fromJson(o.toJson());
      checkTargetHttpsProxy(od);
    });
  });

  unittest.group("obj-schema-TargetHttpsProxyListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetHttpsProxyListWarningData();
      var od = new api.TargetHttpsProxyListWarningData.fromJson(o.toJson());
      checkTargetHttpsProxyListWarningData(od);
    });
  });

  unittest.group("obj-schema-TargetHttpsProxyListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetHttpsProxyListWarning();
      var od = new api.TargetHttpsProxyListWarning.fromJson(o.toJson());
      checkTargetHttpsProxyListWarning(od);
    });
  });

  unittest.group("obj-schema-TargetHttpsProxyList", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetHttpsProxyList();
      var od = new api.TargetHttpsProxyList.fromJson(o.toJson());
      checkTargetHttpsProxyList(od);
    });
  });

  unittest.group("obj-schema-TargetInstance", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetInstance();
      var od = new api.TargetInstance.fromJson(o.toJson());
      checkTargetInstance(od);
    });
  });

  unittest.group("obj-schema-TargetInstanceAggregatedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetInstanceAggregatedListWarningData();
      var od =
          new api.TargetInstanceAggregatedListWarningData.fromJson(o.toJson());
      checkTargetInstanceAggregatedListWarningData(od);
    });
  });

  unittest.group("obj-schema-TargetInstanceAggregatedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetInstanceAggregatedListWarning();
      var od = new api.TargetInstanceAggregatedListWarning.fromJson(o.toJson());
      checkTargetInstanceAggregatedListWarning(od);
    });
  });

  unittest.group("obj-schema-TargetInstanceAggregatedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetInstanceAggregatedList();
      var od = new api.TargetInstanceAggregatedList.fromJson(o.toJson());
      checkTargetInstanceAggregatedList(od);
    });
  });

  unittest.group("obj-schema-TargetInstanceListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetInstanceListWarningData();
      var od = new api.TargetInstanceListWarningData.fromJson(o.toJson());
      checkTargetInstanceListWarningData(od);
    });
  });

  unittest.group("obj-schema-TargetInstanceListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetInstanceListWarning();
      var od = new api.TargetInstanceListWarning.fromJson(o.toJson());
      checkTargetInstanceListWarning(od);
    });
  });

  unittest.group("obj-schema-TargetInstanceList", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetInstanceList();
      var od = new api.TargetInstanceList.fromJson(o.toJson());
      checkTargetInstanceList(od);
    });
  });

  unittest.group("obj-schema-TargetInstancesScopedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetInstancesScopedListWarningData();
      var od =
          new api.TargetInstancesScopedListWarningData.fromJson(o.toJson());
      checkTargetInstancesScopedListWarningData(od);
    });
  });

  unittest.group("obj-schema-TargetInstancesScopedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetInstancesScopedListWarning();
      var od = new api.TargetInstancesScopedListWarning.fromJson(o.toJson());
      checkTargetInstancesScopedListWarning(od);
    });
  });

  unittest.group("obj-schema-TargetInstancesScopedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetInstancesScopedList();
      var od = new api.TargetInstancesScopedList.fromJson(o.toJson());
      checkTargetInstancesScopedList(od);
    });
  });

  unittest.group("obj-schema-TargetPool", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetPool();
      var od = new api.TargetPool.fromJson(o.toJson());
      checkTargetPool(od);
    });
  });

  unittest.group("obj-schema-TargetPoolAggregatedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetPoolAggregatedListWarningData();
      var od = new api.TargetPoolAggregatedListWarningData.fromJson(o.toJson());
      checkTargetPoolAggregatedListWarningData(od);
    });
  });

  unittest.group("obj-schema-TargetPoolAggregatedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetPoolAggregatedListWarning();
      var od = new api.TargetPoolAggregatedListWarning.fromJson(o.toJson());
      checkTargetPoolAggregatedListWarning(od);
    });
  });

  unittest.group("obj-schema-TargetPoolAggregatedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetPoolAggregatedList();
      var od = new api.TargetPoolAggregatedList.fromJson(o.toJson());
      checkTargetPoolAggregatedList(od);
    });
  });

  unittest.group("obj-schema-TargetPoolInstanceHealth", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetPoolInstanceHealth();
      var od = new api.TargetPoolInstanceHealth.fromJson(o.toJson());
      checkTargetPoolInstanceHealth(od);
    });
  });

  unittest.group("obj-schema-TargetPoolListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetPoolListWarningData();
      var od = new api.TargetPoolListWarningData.fromJson(o.toJson());
      checkTargetPoolListWarningData(od);
    });
  });

  unittest.group("obj-schema-TargetPoolListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetPoolListWarning();
      var od = new api.TargetPoolListWarning.fromJson(o.toJson());
      checkTargetPoolListWarning(od);
    });
  });

  unittest.group("obj-schema-TargetPoolList", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetPoolList();
      var od = new api.TargetPoolList.fromJson(o.toJson());
      checkTargetPoolList(od);
    });
  });

  unittest.group("obj-schema-TargetPoolsAddHealthCheckRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetPoolsAddHealthCheckRequest();
      var od = new api.TargetPoolsAddHealthCheckRequest.fromJson(o.toJson());
      checkTargetPoolsAddHealthCheckRequest(od);
    });
  });

  unittest.group("obj-schema-TargetPoolsAddInstanceRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetPoolsAddInstanceRequest();
      var od = new api.TargetPoolsAddInstanceRequest.fromJson(o.toJson());
      checkTargetPoolsAddInstanceRequest(od);
    });
  });

  unittest.group("obj-schema-TargetPoolsRemoveHealthCheckRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetPoolsRemoveHealthCheckRequest();
      var od = new api.TargetPoolsRemoveHealthCheckRequest.fromJson(o.toJson());
      checkTargetPoolsRemoveHealthCheckRequest(od);
    });
  });

  unittest.group("obj-schema-TargetPoolsRemoveInstanceRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetPoolsRemoveInstanceRequest();
      var od = new api.TargetPoolsRemoveInstanceRequest.fromJson(o.toJson());
      checkTargetPoolsRemoveInstanceRequest(od);
    });
  });

  unittest.group("obj-schema-TargetPoolsScopedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetPoolsScopedListWarningData();
      var od = new api.TargetPoolsScopedListWarningData.fromJson(o.toJson());
      checkTargetPoolsScopedListWarningData(od);
    });
  });

  unittest.group("obj-schema-TargetPoolsScopedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetPoolsScopedListWarning();
      var od = new api.TargetPoolsScopedListWarning.fromJson(o.toJson());
      checkTargetPoolsScopedListWarning(od);
    });
  });

  unittest.group("obj-schema-TargetPoolsScopedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetPoolsScopedList();
      var od = new api.TargetPoolsScopedList.fromJson(o.toJson());
      checkTargetPoolsScopedList(od);
    });
  });

  unittest.group("obj-schema-TargetReference", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetReference();
      var od = new api.TargetReference.fromJson(o.toJson());
      checkTargetReference(od);
    });
  });

  unittest.group("obj-schema-TargetSslProxiesSetBackendServiceRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetSslProxiesSetBackendServiceRequest();
      var od =
          new api.TargetSslProxiesSetBackendServiceRequest.fromJson(o.toJson());
      checkTargetSslProxiesSetBackendServiceRequest(od);
    });
  });

  unittest.group("obj-schema-TargetSslProxiesSetProxyHeaderRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetSslProxiesSetProxyHeaderRequest();
      var od =
          new api.TargetSslProxiesSetProxyHeaderRequest.fromJson(o.toJson());
      checkTargetSslProxiesSetProxyHeaderRequest(od);
    });
  });

  unittest.group("obj-schema-TargetSslProxiesSetSslCertificatesRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetSslProxiesSetSslCertificatesRequest();
      var od = new api.TargetSslProxiesSetSslCertificatesRequest.fromJson(
          o.toJson());
      checkTargetSslProxiesSetSslCertificatesRequest(od);
    });
  });

  unittest.group("obj-schema-TargetSslProxy", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetSslProxy();
      var od = new api.TargetSslProxy.fromJson(o.toJson());
      checkTargetSslProxy(od);
    });
  });

  unittest.group("obj-schema-TargetSslProxyListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetSslProxyListWarningData();
      var od = new api.TargetSslProxyListWarningData.fromJson(o.toJson());
      checkTargetSslProxyListWarningData(od);
    });
  });

  unittest.group("obj-schema-TargetSslProxyListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetSslProxyListWarning();
      var od = new api.TargetSslProxyListWarning.fromJson(o.toJson());
      checkTargetSslProxyListWarning(od);
    });
  });

  unittest.group("obj-schema-TargetSslProxyList", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetSslProxyList();
      var od = new api.TargetSslProxyList.fromJson(o.toJson());
      checkTargetSslProxyList(od);
    });
  });

  unittest.group("obj-schema-TargetTcpProxiesSetBackendServiceRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetTcpProxiesSetBackendServiceRequest();
      var od =
          new api.TargetTcpProxiesSetBackendServiceRequest.fromJson(o.toJson());
      checkTargetTcpProxiesSetBackendServiceRequest(od);
    });
  });

  unittest.group("obj-schema-TargetTcpProxiesSetProxyHeaderRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetTcpProxiesSetProxyHeaderRequest();
      var od =
          new api.TargetTcpProxiesSetProxyHeaderRequest.fromJson(o.toJson());
      checkTargetTcpProxiesSetProxyHeaderRequest(od);
    });
  });

  unittest.group("obj-schema-TargetTcpProxy", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetTcpProxy();
      var od = new api.TargetTcpProxy.fromJson(o.toJson());
      checkTargetTcpProxy(od);
    });
  });

  unittest.group("obj-schema-TargetTcpProxyListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetTcpProxyListWarningData();
      var od = new api.TargetTcpProxyListWarningData.fromJson(o.toJson());
      checkTargetTcpProxyListWarningData(od);
    });
  });

  unittest.group("obj-schema-TargetTcpProxyListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetTcpProxyListWarning();
      var od = new api.TargetTcpProxyListWarning.fromJson(o.toJson());
      checkTargetTcpProxyListWarning(od);
    });
  });

  unittest.group("obj-schema-TargetTcpProxyList", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetTcpProxyList();
      var od = new api.TargetTcpProxyList.fromJson(o.toJson());
      checkTargetTcpProxyList(od);
    });
  });

  unittest.group("obj-schema-TargetVpnGateway", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetVpnGateway();
      var od = new api.TargetVpnGateway.fromJson(o.toJson());
      checkTargetVpnGateway(od);
    });
  });

  unittest.group("obj-schema-TargetVpnGatewayAggregatedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetVpnGatewayAggregatedListWarningData();
      var od = new api.TargetVpnGatewayAggregatedListWarningData.fromJson(
          o.toJson());
      checkTargetVpnGatewayAggregatedListWarningData(od);
    });
  });

  unittest.group("obj-schema-TargetVpnGatewayAggregatedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetVpnGatewayAggregatedListWarning();
      var od =
          new api.TargetVpnGatewayAggregatedListWarning.fromJson(o.toJson());
      checkTargetVpnGatewayAggregatedListWarning(od);
    });
  });

  unittest.group("obj-schema-TargetVpnGatewayAggregatedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetVpnGatewayAggregatedList();
      var od = new api.TargetVpnGatewayAggregatedList.fromJson(o.toJson());
      checkTargetVpnGatewayAggregatedList(od);
    });
  });

  unittest.group("obj-schema-TargetVpnGatewayListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetVpnGatewayListWarningData();
      var od = new api.TargetVpnGatewayListWarningData.fromJson(o.toJson());
      checkTargetVpnGatewayListWarningData(od);
    });
  });

  unittest.group("obj-schema-TargetVpnGatewayListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetVpnGatewayListWarning();
      var od = new api.TargetVpnGatewayListWarning.fromJson(o.toJson());
      checkTargetVpnGatewayListWarning(od);
    });
  });

  unittest.group("obj-schema-TargetVpnGatewayList", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetVpnGatewayList();
      var od = new api.TargetVpnGatewayList.fromJson(o.toJson());
      checkTargetVpnGatewayList(od);
    });
  });

  unittest.group("obj-schema-TargetVpnGatewaysScopedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetVpnGatewaysScopedListWarningData();
      var od =
          new api.TargetVpnGatewaysScopedListWarningData.fromJson(o.toJson());
      checkTargetVpnGatewaysScopedListWarningData(od);
    });
  });

  unittest.group("obj-schema-TargetVpnGatewaysScopedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetVpnGatewaysScopedListWarning();
      var od = new api.TargetVpnGatewaysScopedListWarning.fromJson(o.toJson());
      checkTargetVpnGatewaysScopedListWarning(od);
    });
  });

  unittest.group("obj-schema-TargetVpnGatewaysScopedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildTargetVpnGatewaysScopedList();
      var od = new api.TargetVpnGatewaysScopedList.fromJson(o.toJson());
      checkTargetVpnGatewaysScopedList(od);
    });
  });

  unittest.group("obj-schema-TestFailure", () {
    unittest.test("to-json--from-json", () {
      var o = buildTestFailure();
      var od = new api.TestFailure.fromJson(o.toJson());
      checkTestFailure(od);
    });
  });

  unittest.group("obj-schema-TestPermissionsRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildTestPermissionsRequest();
      var od = new api.TestPermissionsRequest.fromJson(o.toJson());
      checkTestPermissionsRequest(od);
    });
  });

  unittest.group("obj-schema-TestPermissionsResponse", () {
    unittest.test("to-json--from-json", () {
      var o = buildTestPermissionsResponse();
      var od = new api.TestPermissionsResponse.fromJson(o.toJson());
      checkTestPermissionsResponse(od);
    });
  });

  unittest.group("obj-schema-UrlMap", () {
    unittest.test("to-json--from-json", () {
      var o = buildUrlMap();
      var od = new api.UrlMap.fromJson(o.toJson());
      checkUrlMap(od);
    });
  });

  unittest.group("obj-schema-UrlMapListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildUrlMapListWarningData();
      var od = new api.UrlMapListWarningData.fromJson(o.toJson());
      checkUrlMapListWarningData(od);
    });
  });

  unittest.group("obj-schema-UrlMapListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildUrlMapListWarning();
      var od = new api.UrlMapListWarning.fromJson(o.toJson());
      checkUrlMapListWarning(od);
    });
  });

  unittest.group("obj-schema-UrlMapList", () {
    unittest.test("to-json--from-json", () {
      var o = buildUrlMapList();
      var od = new api.UrlMapList.fromJson(o.toJson());
      checkUrlMapList(od);
    });
  });

  unittest.group("obj-schema-UrlMapReference", () {
    unittest.test("to-json--from-json", () {
      var o = buildUrlMapReference();
      var od = new api.UrlMapReference.fromJson(o.toJson());
      checkUrlMapReference(od);
    });
  });

  unittest.group("obj-schema-UrlMapTest", () {
    unittest.test("to-json--from-json", () {
      var o = buildUrlMapTest();
      var od = new api.UrlMapTest.fromJson(o.toJson());
      checkUrlMapTest(od);
    });
  });

  unittest.group("obj-schema-UrlMapValidationResult", () {
    unittest.test("to-json--from-json", () {
      var o = buildUrlMapValidationResult();
      var od = new api.UrlMapValidationResult.fromJson(o.toJson());
      checkUrlMapValidationResult(od);
    });
  });

  unittest.group("obj-schema-UrlMapsValidateRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildUrlMapsValidateRequest();
      var od = new api.UrlMapsValidateRequest.fromJson(o.toJson());
      checkUrlMapsValidateRequest(od);
    });
  });

  unittest.group("obj-schema-UrlMapsValidateResponse", () {
    unittest.test("to-json--from-json", () {
      var o = buildUrlMapsValidateResponse();
      var od = new api.UrlMapsValidateResponse.fromJson(o.toJson());
      checkUrlMapsValidateResponse(od);
    });
  });

  unittest.group("obj-schema-UsableSubnetwork", () {
    unittest.test("to-json--from-json", () {
      var o = buildUsableSubnetwork();
      var od = new api.UsableSubnetwork.fromJson(o.toJson());
      checkUsableSubnetwork(od);
    });
  });

  unittest.group("obj-schema-UsableSubnetworkSecondaryRange", () {
    unittest.test("to-json--from-json", () {
      var o = buildUsableSubnetworkSecondaryRange();
      var od = new api.UsableSubnetworkSecondaryRange.fromJson(o.toJson());
      checkUsableSubnetworkSecondaryRange(od);
    });
  });

  unittest.group("obj-schema-UsableSubnetworksAggregatedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildUsableSubnetworksAggregatedListWarningData();
      var od = new api.UsableSubnetworksAggregatedListWarningData.fromJson(
          o.toJson());
      checkUsableSubnetworksAggregatedListWarningData(od);
    });
  });

  unittest.group("obj-schema-UsableSubnetworksAggregatedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildUsableSubnetworksAggregatedListWarning();
      var od =
          new api.UsableSubnetworksAggregatedListWarning.fromJson(o.toJson());
      checkUsableSubnetworksAggregatedListWarning(od);
    });
  });

  unittest.group("obj-schema-UsableSubnetworksAggregatedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildUsableSubnetworksAggregatedList();
      var od = new api.UsableSubnetworksAggregatedList.fromJson(o.toJson());
      checkUsableSubnetworksAggregatedList(od);
    });
  });

  unittest.group("obj-schema-UsageExportLocation", () {
    unittest.test("to-json--from-json", () {
      var o = buildUsageExportLocation();
      var od = new api.UsageExportLocation.fromJson(o.toJson());
      checkUsageExportLocation(od);
    });
  });

  unittest.group("obj-schema-VmEndpointNatMappings", () {
    unittest.test("to-json--from-json", () {
      var o = buildVmEndpointNatMappings();
      var od = new api.VmEndpointNatMappings.fromJson(o.toJson());
      checkVmEndpointNatMappings(od);
    });
  });

  unittest.group("obj-schema-VmEndpointNatMappingsInterfaceNatMappings", () {
    unittest.test("to-json--from-json", () {
      var o = buildVmEndpointNatMappingsInterfaceNatMappings();
      var od = new api.VmEndpointNatMappingsInterfaceNatMappings.fromJson(
          o.toJson());
      checkVmEndpointNatMappingsInterfaceNatMappings(od);
    });
  });

  unittest.group("obj-schema-VmEndpointNatMappingsListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildVmEndpointNatMappingsListWarningData();
      var od =
          new api.VmEndpointNatMappingsListWarningData.fromJson(o.toJson());
      checkVmEndpointNatMappingsListWarningData(od);
    });
  });

  unittest.group("obj-schema-VmEndpointNatMappingsListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildVmEndpointNatMappingsListWarning();
      var od = new api.VmEndpointNatMappingsListWarning.fromJson(o.toJson());
      checkVmEndpointNatMappingsListWarning(od);
    });
  });

  unittest.group("obj-schema-VmEndpointNatMappingsList", () {
    unittest.test("to-json--from-json", () {
      var o = buildVmEndpointNatMappingsList();
      var od = new api.VmEndpointNatMappingsList.fromJson(o.toJson());
      checkVmEndpointNatMappingsList(od);
    });
  });

  unittest.group("obj-schema-VpnTunnel", () {
    unittest.test("to-json--from-json", () {
      var o = buildVpnTunnel();
      var od = new api.VpnTunnel.fromJson(o.toJson());
      checkVpnTunnel(od);
    });
  });

  unittest.group("obj-schema-VpnTunnelAggregatedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildVpnTunnelAggregatedListWarningData();
      var od = new api.VpnTunnelAggregatedListWarningData.fromJson(o.toJson());
      checkVpnTunnelAggregatedListWarningData(od);
    });
  });

  unittest.group("obj-schema-VpnTunnelAggregatedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildVpnTunnelAggregatedListWarning();
      var od = new api.VpnTunnelAggregatedListWarning.fromJson(o.toJson());
      checkVpnTunnelAggregatedListWarning(od);
    });
  });

  unittest.group("obj-schema-VpnTunnelAggregatedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildVpnTunnelAggregatedList();
      var od = new api.VpnTunnelAggregatedList.fromJson(o.toJson());
      checkVpnTunnelAggregatedList(od);
    });
  });

  unittest.group("obj-schema-VpnTunnelListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildVpnTunnelListWarningData();
      var od = new api.VpnTunnelListWarningData.fromJson(o.toJson());
      checkVpnTunnelListWarningData(od);
    });
  });

  unittest.group("obj-schema-VpnTunnelListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildVpnTunnelListWarning();
      var od = new api.VpnTunnelListWarning.fromJson(o.toJson());
      checkVpnTunnelListWarning(od);
    });
  });

  unittest.group("obj-schema-VpnTunnelList", () {
    unittest.test("to-json--from-json", () {
      var o = buildVpnTunnelList();
      var od = new api.VpnTunnelList.fromJson(o.toJson());
      checkVpnTunnelList(od);
    });
  });

  unittest.group("obj-schema-VpnTunnelsScopedListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildVpnTunnelsScopedListWarningData();
      var od = new api.VpnTunnelsScopedListWarningData.fromJson(o.toJson());
      checkVpnTunnelsScopedListWarningData(od);
    });
  });

  unittest.group("obj-schema-VpnTunnelsScopedListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildVpnTunnelsScopedListWarning();
      var od = new api.VpnTunnelsScopedListWarning.fromJson(o.toJson());
      checkVpnTunnelsScopedListWarning(od);
    });
  });

  unittest.group("obj-schema-VpnTunnelsScopedList", () {
    unittest.test("to-json--from-json", () {
      var o = buildVpnTunnelsScopedList();
      var od = new api.VpnTunnelsScopedList.fromJson(o.toJson());
      checkVpnTunnelsScopedList(od);
    });
  });

  unittest.group("obj-schema-XpnHostListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildXpnHostListWarningData();
      var od = new api.XpnHostListWarningData.fromJson(o.toJson());
      checkXpnHostListWarningData(od);
    });
  });

  unittest.group("obj-schema-XpnHostListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildXpnHostListWarning();
      var od = new api.XpnHostListWarning.fromJson(o.toJson());
      checkXpnHostListWarning(od);
    });
  });

  unittest.group("obj-schema-XpnHostList", () {
    unittest.test("to-json--from-json", () {
      var o = buildXpnHostList();
      var od = new api.XpnHostList.fromJson(o.toJson());
      checkXpnHostList(od);
    });
  });

  unittest.group("obj-schema-XpnResourceId", () {
    unittest.test("to-json--from-json", () {
      var o = buildXpnResourceId();
      var od = new api.XpnResourceId.fromJson(o.toJson());
      checkXpnResourceId(od);
    });
  });

  unittest.group("obj-schema-Zone", () {
    unittest.test("to-json--from-json", () {
      var o = buildZone();
      var od = new api.Zone.fromJson(o.toJson());
      checkZone(od);
    });
  });

  unittest.group("obj-schema-ZoneListWarningData", () {
    unittest.test("to-json--from-json", () {
      var o = buildZoneListWarningData();
      var od = new api.ZoneListWarningData.fromJson(o.toJson());
      checkZoneListWarningData(od);
    });
  });

  unittest.group("obj-schema-ZoneListWarning", () {
    unittest.test("to-json--from-json", () {
      var o = buildZoneListWarning();
      var od = new api.ZoneListWarning.fromJson(o.toJson());
      checkZoneListWarning(od);
    });
  });

  unittest.group("obj-schema-ZoneList", () {
    unittest.test("to-json--from-json", () {
      var o = buildZoneList();
      var od = new api.ZoneList.fromJson(o.toJson());
      checkZoneList(od);
    });
  });

  unittest.group("obj-schema-ZoneSetLabelsRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildZoneSetLabelsRequest();
      var od = new api.ZoneSetLabelsRequest.fromJson(o.toJson());
      checkZoneSetLabelsRequest(od);
    });
  });

  unittest.group("obj-schema-ZoneSetPolicyRequest", () {
    unittest.test("to-json--from-json", () {
      var o = buildZoneSetPolicyRequest();
      var od = new api.ZoneSetPolicyRequest.fromJson(o.toJson());
      checkZoneSetPolicyRequest(od);
    });
  });

  unittest.group("resource-AcceleratorTypesResourceApi", () {
    unittest.test("method--aggregatedList", () {
      var mock = new HttpServerMock();
      api.AcceleratorTypesResourceApi res =
          new api.ComputeApi(mock).acceleratorTypes;
      var arg_project = "foo";
      var arg_filter = "foo";
      var arg_maxResults = 42;
      var arg_orderBy = "foo";
      var arg_pageToken = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["filter"].first, unittest.equals(arg_filter));
        unittest.expect(core.int.parse(queryMap["maxResults"].first),
            unittest.equals(arg_maxResults));
        unittest.expect(
            queryMap["orderBy"].first, unittest.equals(arg_orderBy));
        unittest.expect(
            queryMap["pageToken"].first, unittest.equals(arg_pageToken));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildAcceleratorTypeAggregatedList());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .aggregatedList(arg_project,
              filter: arg_filter,
              maxResults: arg_maxResults,
              orderBy: arg_orderBy,
              pageToken: arg_pageToken,
              $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkAcceleratorTypeAggregatedList(response);
      })));
    });

    unittest.test("method--get", () {
      var mock = new HttpServerMock();
      api.AcceleratorTypesResourceApi res =
          new api.ComputeApi(mock).acceleratorTypes;
      var arg_project = "foo";
      var arg_zone = "foo";
      var arg_acceleratorType = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildAcceleratorType());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .get(arg_project, arg_zone, arg_acceleratorType, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkAcceleratorType(response);
      })));
    });

    unittest.test("method--list", () {
      var mock = new HttpServerMock();
      api.AcceleratorTypesResourceApi res =
          new api.ComputeApi(mock).acceleratorTypes;
      var arg_project = "foo";
      var arg_zone = "foo";
      var arg_filter = "foo";
      var arg_maxResults = 42;
      var arg_orderBy = "foo";
      var arg_pageToken = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["filter"].first, unittest.equals(arg_filter));
        unittest.expect(core.int.parse(queryMap["maxResults"].first),
            unittest.equals(arg_maxResults));
        unittest.expect(
            queryMap["orderBy"].first, unittest.equals(arg_orderBy));
        unittest.expect(
            queryMap["pageToken"].first, unittest.equals(arg_pageToken));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildAcceleratorTypeList());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .list(arg_project, arg_zone,
              filter: arg_filter,
              maxResults: arg_maxResults,
              orderBy: arg_orderBy,
              pageToken: arg_pageToken,
              $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkAcceleratorTypeList(response);
      })));
    });
  });

  unittest.group("resource-AddressesResourceApi", () {
    unittest.test("method--aggregatedList", () {
      var mock = new HttpServerMock();
      api.AddressesResourceApi res = new api.ComputeApi(mock).addresses;
      var arg_project = "foo";
      var arg_filter = "foo";
      var arg_maxResults = 42;
      var arg_orderBy = "foo";
      var arg_pageToken = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["filter"].first, unittest.equals(arg_filter));
        unittest.expect(core.int.parse(queryMap["maxResults"].first),
            unittest.equals(arg_maxResults));
        unittest.expect(
            queryMap["orderBy"].first, unittest.equals(arg_orderBy));
        unittest.expect(
            queryMap["pageToken"].first, unittest.equals(arg_pageToken));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildAddressAggregatedList());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .aggregatedList(arg_project,
              filter: arg_filter,
              maxResults: arg_maxResults,
              orderBy: arg_orderBy,
              pageToken: arg_pageToken,
              $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkAddressAggregatedList(response);
      })));
    });

    unittest.test("method--delete", () {
      var mock = new HttpServerMock();
      api.AddressesResourceApi res = new api.ComputeApi(mock).addresses;
      var arg_project = "foo";
      var arg_region = "foo";
      var arg_address = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .delete(arg_project, arg_region, arg_address,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--get", () {
      var mock = new HttpServerMock();
      api.AddressesResourceApi res = new api.ComputeApi(mock).addresses;
      var arg_project = "foo";
      var arg_region = "foo";
      var arg_address = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildAddress());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .get(arg_project, arg_region, arg_address, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkAddress(response);
      })));
    });

    unittest.test("method--insert", () {
      var mock = new HttpServerMock();
      api.AddressesResourceApi res = new api.ComputeApi(mock).addresses;
      var arg_request = buildAddress();
      var arg_project = "foo";
      var arg_region = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var obj = new api.Address.fromJson(json);
        checkAddress(obj);

        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .insert(arg_request, arg_project, arg_region,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--list", () {
      var mock = new HttpServerMock();
      api.AddressesResourceApi res = new api.ComputeApi(mock).addresses;
      var arg_project = "foo";
      var arg_region = "foo";
      var arg_filter = "foo";
      var arg_maxResults = 42;
      var arg_orderBy = "foo";
      var arg_pageToken = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["filter"].first, unittest.equals(arg_filter));
        unittest.expect(core.int.parse(queryMap["maxResults"].first),
            unittest.equals(arg_maxResults));
        unittest.expect(
            queryMap["orderBy"].first, unittest.equals(arg_orderBy));
        unittest.expect(
            queryMap["pageToken"].first, unittest.equals(arg_pageToken));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildAddressList());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .list(arg_project, arg_region,
              filter: arg_filter,
              maxResults: arg_maxResults,
              orderBy: arg_orderBy,
              pageToken: arg_pageToken,
              $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkAddressList(response);
      })));
    });
  });

  unittest.group("resource-AutoscalersResourceApi", () {
    unittest.test("method--aggregatedList", () {
      var mock = new HttpServerMock();
      api.AutoscalersResourceApi res = new api.ComputeApi(mock).autoscalers;
      var arg_project = "foo";
      var arg_filter = "foo";
      var arg_maxResults = 42;
      var arg_orderBy = "foo";
      var arg_pageToken = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["filter"].first, unittest.equals(arg_filter));
        unittest.expect(core.int.parse(queryMap["maxResults"].first),
            unittest.equals(arg_maxResults));
        unittest.expect(
            queryMap["orderBy"].first, unittest.equals(arg_orderBy));
        unittest.expect(
            queryMap["pageToken"].first, unittest.equals(arg_pageToken));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildAutoscalerAggregatedList());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .aggregatedList(arg_project,
              filter: arg_filter,
              maxResults: arg_maxResults,
              orderBy: arg_orderBy,
              pageToken: arg_pageToken,
              $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkAutoscalerAggregatedList(response);
      })));
    });

    unittest.test("method--delete", () {
      var mock = new HttpServerMock();
      api.AutoscalersResourceApi res = new api.ComputeApi(mock).autoscalers;
      var arg_project = "foo";
      var arg_zone = "foo";
      var arg_autoscaler = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .delete(arg_project, arg_zone, arg_autoscaler,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--get", () {
      var mock = new HttpServerMock();
      api.AutoscalersResourceApi res = new api.ComputeApi(mock).autoscalers;
      var arg_project = "foo";
      var arg_zone = "foo";
      var arg_autoscaler = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildAutoscaler());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .get(arg_project, arg_zone, arg_autoscaler, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkAutoscaler(response);
      })));
    });

    unittest.test("method--insert", () {
      var mock = new HttpServerMock();
      api.AutoscalersResourceApi res = new api.ComputeApi(mock).autoscalers;
      var arg_request = buildAutoscaler();
      var arg_project = "foo";
      var arg_zone = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var obj = new api.Autoscaler.fromJson(json);
        checkAutoscaler(obj);

        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .insert(arg_request, arg_project, arg_zone,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--list", () {
      var mock = new HttpServerMock();
      api.AutoscalersResourceApi res = new api.ComputeApi(mock).autoscalers;
      var arg_project = "foo";
      var arg_zone = "foo";
      var arg_filter = "foo";
      var arg_maxResults = 42;
      var arg_orderBy = "foo";
      var arg_pageToken = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["filter"].first, unittest.equals(arg_filter));
        unittest.expect(core.int.parse(queryMap["maxResults"].first),
            unittest.equals(arg_maxResults));
        unittest.expect(
            queryMap["orderBy"].first, unittest.equals(arg_orderBy));
        unittest.expect(
            queryMap["pageToken"].first, unittest.equals(arg_pageToken));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildAutoscalerList());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .list(arg_project, arg_zone,
              filter: arg_filter,
              maxResults: arg_maxResults,
              orderBy: arg_orderBy,
              pageToken: arg_pageToken,
              $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkAutoscalerList(response);
      })));
    });

    unittest.test("method--patch", () {
      var mock = new HttpServerMock();
      api.AutoscalersResourceApi res = new api.ComputeApi(mock).autoscalers;
      var arg_request = buildAutoscaler();
      var arg_project = "foo";
      var arg_zone = "foo";
      var arg_autoscaler = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var obj = new api.Autoscaler.fromJson(json);
        checkAutoscaler(obj);

        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["autoscaler"].first, unittest.equals(arg_autoscaler));
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .patch(arg_request, arg_project, arg_zone,
              autoscaler: arg_autoscaler,
              requestId: arg_requestId,
              $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--update", () {
      var mock = new HttpServerMock();
      api.AutoscalersResourceApi res = new api.ComputeApi(mock).autoscalers;
      var arg_request = buildAutoscaler();
      var arg_project = "foo";
      var arg_zone = "foo";
      var arg_autoscaler = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var obj = new api.Autoscaler.fromJson(json);
        checkAutoscaler(obj);

        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["autoscaler"].first, unittest.equals(arg_autoscaler));
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .update(arg_request, arg_project, arg_zone,
              autoscaler: arg_autoscaler,
              requestId: arg_requestId,
              $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });
  });

  unittest.group("resource-BackendBucketsResourceApi", () {
    unittest.test("method--addSignedUrlKey", () {
      var mock = new HttpServerMock();
      api.BackendBucketsResourceApi res =
          new api.ComputeApi(mock).backendBuckets;
      var arg_request = buildSignedUrlKey();
      var arg_project = "foo";
      var arg_backendBucket = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var obj = new api.SignedUrlKey.fromJson(json);
        checkSignedUrlKey(obj);

        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .addSignedUrlKey(arg_request, arg_project, arg_backendBucket,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--delete", () {
      var mock = new HttpServerMock();
      api.BackendBucketsResourceApi res =
          new api.ComputeApi(mock).backendBuckets;
      var arg_project = "foo";
      var arg_backendBucket = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .delete(arg_project, arg_backendBucket,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--deleteSignedUrlKey", () {
      var mock = new HttpServerMock();
      api.BackendBucketsResourceApi res =
          new api.ComputeApi(mock).backendBuckets;
      var arg_project = "foo";
      var arg_backendBucket = "foo";
      var arg_keyName = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["keyName"].first, unittest.equals(arg_keyName));
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .deleteSignedUrlKey(arg_project, arg_backendBucket, arg_keyName,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--get", () {
      var mock = new HttpServerMock();
      api.BackendBucketsResourceApi res =
          new api.ComputeApi(mock).backendBuckets;
      var arg_project = "foo";
      var arg_backendBucket = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildBackendBucket());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .get(arg_project, arg_backendBucket, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkBackendBucket(response);
      })));
    });

    unittest.test("method--insert", () {
      var mock = new HttpServerMock();
      api.BackendBucketsResourceApi res =
          new api.ComputeApi(mock).backendBuckets;
      var arg_request = buildBackendBucket();
      var arg_project = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var obj = new api.BackendBucket.fromJson(json);
        checkBackendBucket(obj);

        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .insert(arg_request, arg_project,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--list", () {
      var mock = new HttpServerMock();
      api.BackendBucketsResourceApi res =
          new api.ComputeApi(mock).backendBuckets;
      var arg_project = "foo";
      var arg_filter = "foo";
      var arg_maxResults = 42;
      var arg_orderBy = "foo";
      var arg_pageToken = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["filter"].first, unittest.equals(arg_filter));
        unittest.expect(core.int.parse(queryMap["maxResults"].first),
            unittest.equals(arg_maxResults));
        unittest.expect(
            queryMap["orderBy"].first, unittest.equals(arg_orderBy));
        unittest.expect(
            queryMap["pageToken"].first, unittest.equals(arg_pageToken));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildBackendBucketList());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .list(arg_project,
              filter: arg_filter,
              maxResults: arg_maxResults,
              orderBy: arg_orderBy,
              pageToken: arg_pageToken,
              $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkBackendBucketList(response);
      })));
    });

    unittest.test("method--patch", () {
      var mock = new HttpServerMock();
      api.BackendBucketsResourceApi res =
          new api.ComputeApi(mock).backendBuckets;
      var arg_request = buildBackendBucket();
      var arg_project = "foo";
      var arg_backendBucket = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var obj = new api.BackendBucket.fromJson(json);
        checkBackendBucket(obj);

        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .patch(arg_request, arg_project, arg_backendBucket,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--update", () {
      var mock = new HttpServerMock();
      api.BackendBucketsResourceApi res =
          new api.ComputeApi(mock).backendBuckets;
      var arg_request = buildBackendBucket();
      var arg_project = "foo";
      var arg_backendBucket = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var obj = new api.BackendBucket.fromJson(json);
        checkBackendBucket(obj);

        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .update(arg_request, arg_project, arg_backendBucket,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });
  });

  unittest.group("resource-BackendServicesResourceApi", () {
    unittest.test("method--addSignedUrlKey", () {
      var mock = new HttpServerMock();
      api.BackendServicesResourceApi res =
          new api.ComputeApi(mock).backendServices;
      var arg_request = buildSignedUrlKey();
      var arg_project = "foo";
      var arg_backendService = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var obj = new api.SignedUrlKey.fromJson(json);
        checkSignedUrlKey(obj);

        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .addSignedUrlKey(arg_request, arg_project, arg_backendService,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--aggregatedList", () {
      var mock = new HttpServerMock();
      api.BackendServicesResourceApi res =
          new api.ComputeApi(mock).backendServices;
      var arg_project = "foo";
      var arg_filter = "foo";
      var arg_maxResults = 42;
      var arg_orderBy = "foo";
      var arg_pageToken = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["filter"].first, unittest.equals(arg_filter));
        unittest.expect(core.int.parse(queryMap["maxResults"].first),
            unittest.equals(arg_maxResults));
        unittest.expect(
            queryMap["orderBy"].first, unittest.equals(arg_orderBy));
        unittest.expect(
            queryMap["pageToken"].first, unittest.equals(arg_pageToken));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildBackendServiceAggregatedList());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .aggregatedList(arg_project,
              filter: arg_filter,
              maxResults: arg_maxResults,
              orderBy: arg_orderBy,
              pageToken: arg_pageToken,
              $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkBackendServiceAggregatedList(response);
      })));
    });

    unittest.test("method--delete", () {
      var mock = new HttpServerMock();
      api.BackendServicesResourceApi res =
          new api.ComputeApi(mock).backendServices;
      var arg_project = "foo";
      var arg_backendService = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .delete(arg_project, arg_backendService,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--deleteSignedUrlKey", () {
      var mock = new HttpServerMock();
      api.BackendServicesResourceApi res =
          new api.ComputeApi(mock).backendServices;
      var arg_project = "foo";
      var arg_backendService = "foo";
      var arg_keyName = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["keyName"].first, unittest.equals(arg_keyName));
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .deleteSignedUrlKey(arg_project, arg_backendService, arg_keyName,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--get", () {
      var mock = new HttpServerMock();
      api.BackendServicesResourceApi res =
          new api.ComputeApi(mock).backendServices;
      var arg_project = "foo";
      var arg_backendService = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildBackendService());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .get(arg_project, arg_backendService, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkBackendService(response);
      })));
    });

    unittest.test("method--getHealth", () {
      var mock = new HttpServerMock();
      api.BackendServicesResourceApi res =
          new api.ComputeApi(mock).backendServices;
      var arg_request = buildResourceGroupReference();
      var arg_project = "foo";
      var arg_backendService = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var obj = new api.ResourceGroupReference.fromJson(json);
        checkResourceGroupReference(obj);

        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildBackendServiceGroupHealth());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .getHealth(arg_request, arg_project, arg_backendService,
              $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkBackendServiceGroupHealth(response);
      })));
    });

    unittest.test("method--insert", () {
      var mock = new HttpServerMock();
      api.BackendServicesResourceApi res =
          new api.ComputeApi(mock).backendServices;
      var arg_request = buildBackendService();
      var arg_project = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var obj = new api.BackendService.fromJson(json);
        checkBackendService(obj);

        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .insert(arg_request, arg_project,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--list", () {
      var mock = new HttpServerMock();
      api.BackendServicesResourceApi res =
          new api.ComputeApi(mock).backendServices;
      var arg_project = "foo";
      var arg_filter = "foo";
      var arg_maxResults = 42;
      var arg_orderBy = "foo";
      var arg_pageToken = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["filter"].first, unittest.equals(arg_filter));
        unittest.expect(core.int.parse(queryMap["maxResults"].first),
            unittest.equals(arg_maxResults));
        unittest.expect(
            queryMap["orderBy"].first, unittest.equals(arg_orderBy));
        unittest.expect(
            queryMap["pageToken"].first, unittest.equals(arg_pageToken));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildBackendServiceList());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .list(arg_project,
              filter: arg_filter,
              maxResults: arg_maxResults,
              orderBy: arg_orderBy,
              pageToken: arg_pageToken,
              $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkBackendServiceList(response);
      })));
    });

    unittest.test("method--patch", () {
      var mock = new HttpServerMock();
      api.BackendServicesResourceApi res =
          new api.ComputeApi(mock).backendServices;
      var arg_request = buildBackendService();
      var arg_project = "foo";
      var arg_backendService = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var obj = new api.BackendService.fromJson(json);
        checkBackendService(obj);

        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .patch(arg_request, arg_project, arg_backendService,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--setSecurityPolicy", () {
      var mock = new HttpServerMock();
      api.BackendServicesResourceApi res =
          new api.ComputeApi(mock).backendServices;
      var arg_request = buildSecurityPolicyReference();
      var arg_project = "foo";
      var arg_backendService = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var obj = new api.SecurityPolicyReference.fromJson(json);
        checkSecurityPolicyReference(obj);

        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .setSecurityPolicy(arg_request, arg_project, arg_backendService,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--update", () {
      var mock = new HttpServerMock();
      api.BackendServicesResourceApi res =
          new api.ComputeApi(mock).backendServices;
      var arg_request = buildBackendService();
      var arg_project = "foo";
      var arg_backendService = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var obj = new api.BackendService.fromJson(json);
        checkBackendService(obj);

        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .update(arg_request, arg_project, arg_backendService,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });
  });

  unittest.group("resource-DiskTypesResourceApi", () {
    unittest.test("method--aggregatedList", () {
      var mock = new HttpServerMock();
      api.DiskTypesResourceApi res = new api.ComputeApi(mock).diskTypes;
      var arg_project = "foo";
      var arg_filter = "foo";
      var arg_maxResults = 42;
      var arg_orderBy = "foo";
      var arg_pageToken = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["filter"].first, unittest.equals(arg_filter));
        unittest.expect(core.int.parse(queryMap["maxResults"].first),
            unittest.equals(arg_maxResults));
        unittest.expect(
            queryMap["orderBy"].first, unittest.equals(arg_orderBy));
        unittest.expect(
            queryMap["pageToken"].first, unittest.equals(arg_pageToken));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildDiskTypeAggregatedList());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .aggregatedList(arg_project,
              filter: arg_filter,
              maxResults: arg_maxResults,
              orderBy: arg_orderBy,
              pageToken: arg_pageToken,
              $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkDiskTypeAggregatedList(response);
      })));
    });

    unittest.test("method--get", () {
      var mock = new HttpServerMock();
      api.DiskTypesResourceApi res = new api.ComputeApi(mock).diskTypes;
      var arg_project = "foo";
      var arg_zone = "foo";
      var arg_diskType = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildDiskType());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .get(arg_project, arg_zone, arg_diskType, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkDiskType(response);
      })));
    });

    unittest.test("method--list", () {
      var mock = new HttpServerMock();
      api.DiskTypesResourceApi res = new api.ComputeApi(mock).diskTypes;
      var arg_project = "foo";
      var arg_zone = "foo";
      var arg_filter = "foo";
      var arg_maxResults = 42;
      var arg_orderBy = "foo";
      var arg_pageToken = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["filter"].first, unittest.equals(arg_filter));
        unittest.expect(core.int.parse(queryMap["maxResults"].first),
            unittest.equals(arg_maxResults));
        unittest.expect(
            queryMap["orderBy"].first, unittest.equals(arg_orderBy));
        unittest.expect(
            queryMap["pageToken"].first, unittest.equals(arg_pageToken));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildDiskTypeList());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .list(arg_project, arg_zone,
              filter: arg_filter,
              maxResults: arg_maxResults,
              orderBy: arg_orderBy,
              pageToken: arg_pageToken,
              $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkDiskTypeList(response);
      })));
    });
  });

  unittest.group("resource-DisksResourceApi", () {
    unittest.test("method--addResourcePolicies", () {
      var mock = new HttpServerMock();
      api.DisksResourceApi res = new api.ComputeApi(mock).disks;
      var arg_request = buildDisksAddResourcePoliciesRequest();
      var arg_project = "foo";
      var arg_zone = "foo";
      var arg_disk = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var obj = new api.DisksAddResourcePoliciesRequest.fromJson(json);
        checkDisksAddResourcePoliciesRequest(obj);

        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .addResourcePolicies(arg_request, arg_project, arg_zone, arg_disk,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--aggregatedList", () {
      var mock = new HttpServerMock();
      api.DisksResourceApi res = new api.ComputeApi(mock).disks;
      var arg_project = "foo";
      var arg_filter = "foo";
      var arg_maxResults = 42;
      var arg_orderBy = "foo";
      var arg_pageToken = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["filter"].first, unittest.equals(arg_filter));
        unittest.expect(core.int.parse(queryMap["maxResults"].first),
            unittest.equals(arg_maxResults));
        unittest.expect(
            queryMap["orderBy"].first, unittest.equals(arg_orderBy));
        unittest.expect(
            queryMap["pageToken"].first, unittest.equals(arg_pageToken));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildDiskAggregatedList());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .aggregatedList(arg_project,
              filter: arg_filter,
              maxResults: arg_maxResults,
              orderBy: arg_orderBy,
              pageToken: arg_pageToken,
              $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkDiskAggregatedList(response);
      })));
    });

    unittest.test("method--createSnapshot", () {
      var mock = new HttpServerMock();
      api.DisksResourceApi res = new api.ComputeApi(mock).disks;
      var arg_request = buildSnapshot();
      var arg_project = "foo";
      var arg_zone = "foo";
      var arg_disk = "foo";
      var arg_guestFlush = true;
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var obj = new api.Snapshot.fromJson(json);
        checkSnapshot(obj);

        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["guestFlush"].first, unittest.equals("$arg_guestFlush"));
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .createSnapshot(arg_request, arg_project, arg_zone, arg_disk,
              guestFlush: arg_guestFlush,
              requestId: arg_requestId,
              $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--delete", () {
      var mock = new HttpServerMock();
      api.DisksResourceApi res = new api.ComputeApi(mock).disks;
      var arg_project = "foo";
      var arg_zone = "foo";
      var arg_disk = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .delete(arg_project, arg_zone, arg_disk,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--get", () {
      var mock = new HttpServerMock();
      api.DisksResourceApi res = new api.ComputeApi(mock).disks;
      var arg_project = "foo";
      var arg_zone = "foo";
      var arg_disk = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildDisk());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .get(arg_project, arg_zone, arg_disk, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkDisk(response);
      })));
    });

    unittest.test("method--getIamPolicy", () {
      var mock = new HttpServerMock();
      api.DisksResourceApi res = new api.ComputeApi(mock).disks;
      var arg_project = "foo";
      var arg_zone = "foo";
      var arg_resource = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildPolicy());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .getIamPolicy(arg_project, arg_zone, arg_resource,
              $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkPolicy(response);
      })));
    });

    unittest.test("method--insert", () {
      var mock = new HttpServerMock();
      api.DisksResourceApi res = new api.ComputeApi(mock).disks;
      var arg_request = buildDisk();
      var arg_project = "foo";
      var arg_zone = "foo";
      var arg_requestId = "foo";
      var arg_sourceImage = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var obj = new api.Disk.fromJson(json);
        checkDisk(obj);

        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(
            queryMap["sourceImage"].first, unittest.equals(arg_sourceImage));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .insert(arg_request, arg_project, arg_zone,
              requestId: arg_requestId,
              sourceImage: arg_sourceImage,
              $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--list", () {
      var mock = new HttpServerMock();
      api.DisksResourceApi res = new api.ComputeApi(mock).disks;
      var arg_project = "foo";
      var arg_zone = "foo";
      var arg_filter = "foo";
      var arg_maxResults = 42;
      var arg_orderBy = "foo";
      var arg_pageToken = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["filter"].first, unittest.equals(arg_filter));
        unittest.expect(core.int.parse(queryMap["maxResults"].first),
            unittest.equals(arg_maxResults));
        unittest.expect(
            queryMap["orderBy"].first, unittest.equals(arg_orderBy));
        unittest.expect(
            queryMap["pageToken"].first, unittest.equals(arg_pageToken));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildDiskList());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .list(arg_project, arg_zone,
              filter: arg_filter,
              maxResults: arg_maxResults,
              orderBy: arg_orderBy,
              pageToken: arg_pageToken,
              $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkDiskList(response);
      })));
    });

    unittest.test("method--removeResourcePolicies", () {
      var mock = new HttpServerMock();
      api.DisksResourceApi res = new api.ComputeApi(mock).disks;
      var arg_request = buildDisksRemoveResourcePoliciesRequest();
      var arg_project = "foo";
      var arg_zone = "foo";
      var arg_disk = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var obj = new api.DisksRemoveResourcePoliciesRequest.fromJson(json);
        checkDisksRemoveResourcePoliciesRequest(obj);

        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .removeResourcePolicies(arg_request, arg_project, arg_zone, arg_disk,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--resize", () {
      var mock = new HttpServerMock();
      api.DisksResourceApi res = new api.ComputeApi(mock).disks;
      var arg_request = buildDisksResizeRequest();
      var arg_project = "foo";
      var arg_zone = "foo";
      var arg_disk = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var obj = new api.DisksResizeRequest.fromJson(json);
        checkDisksResizeRequest(obj);

        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .resize(arg_request, arg_project, arg_zone, arg_disk,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--setIamPolicy", () {
      var mock = new HttpServerMock();
      api.DisksResourceApi res = new api.ComputeApi(mock).disks;
      var arg_request = buildZoneSetPolicyRequest();
      var arg_project = "foo";
      var arg_zone = "foo";
      var arg_resource = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var obj = new api.ZoneSetPolicyRequest.fromJson(json);
        checkZoneSetPolicyRequest(obj);

        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildPolicy());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .setIamPolicy(arg_request, arg_project, arg_zone, arg_resource,
              $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkPolicy(response);
      })));
    });

    unittest.test("method--setLabels", () {
      var mock = new HttpServerMock();
      api.DisksResourceApi res = new api.ComputeApi(mock).disks;
      var arg_request = buildZoneSetLabelsRequest();
      var arg_project = "foo";
      var arg_zone = "foo";
      var arg_resource = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var obj = new api.ZoneSetLabelsRequest.fromJson(json);
        checkZoneSetLabelsRequest(obj);

        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .setLabels(arg_request, arg_project, arg_zone, arg_resource,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--testIamPermissions", () {
      var mock = new HttpServerMock();
      api.DisksResourceApi res = new api.ComputeApi(mock).disks;
      var arg_request = buildTestPermissionsRequest();
      var arg_project = "foo";
      var arg_zone = "foo";
      var arg_resource = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var obj = new api.TestPermissionsRequest.fromJson(json);
        checkTestPermissionsRequest(obj);

        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildTestPermissionsResponse());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .testIamPermissions(arg_request, arg_project, arg_zone, arg_resource,
              $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkTestPermissionsResponse(response);
      })));
    });
  });

  unittest.group("resource-FirewallsResourceApi", () {
    unittest.test("method--delete", () {
      var mock = new HttpServerMock();
      api.FirewallsResourceApi res = new api.ComputeApi(mock).firewalls;
      var arg_project = "foo";
      var arg_firewall = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .delete(arg_project, arg_firewall,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--get", () {
      var mock = new HttpServerMock();
      api.FirewallsResourceApi res = new api.ComputeApi(mock).firewalls;
      var arg_project = "foo";
      var arg_firewall = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildFirewall());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .get(arg_project, arg_firewall, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkFirewall(response);
      })));
    });

    unittest.test("method--insert", () {
      var mock = new HttpServerMock();
      api.FirewallsResourceApi res = new api.ComputeApi(mock).firewalls;
      var arg_request = buildFirewall();
      var arg_project = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var obj = new api.Firewall.fromJson(json);
        checkFirewall(obj);

        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .insert(arg_request, arg_project,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--list", () {
      var mock = new HttpServerMock();
      api.FirewallsResourceApi res = new api.ComputeApi(mock).firewalls;
      var arg_project = "foo";
      var arg_filter = "foo";
      var arg_maxResults = 42;
      var arg_orderBy = "foo";
      var arg_pageToken = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["filter"].first, unittest.equals(arg_filter));
        unittest.expect(core.int.parse(queryMap["maxResults"].first),
            unittest.equals(arg_maxResults));
        unittest.expect(
            queryMap["orderBy"].first, unittest.equals(arg_orderBy));
        unittest.expect(
            queryMap["pageToken"].first, unittest.equals(arg_pageToken));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildFirewallList());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .list(arg_project,
              filter: arg_filter,
              maxResults: arg_maxResults,
              orderBy: arg_orderBy,
              pageToken: arg_pageToken,
              $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkFirewallList(response);
      })));
    });

    unittest.test("method--patch", () {
      var mock = new HttpServerMock();
      api.FirewallsResourceApi res = new api.ComputeApi(mock).firewalls;
      var arg_request = buildFirewall();
      var arg_project = "foo";
      var arg_firewall = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var obj = new api.Firewall.fromJson(json);
        checkFirewall(obj);

        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .patch(arg_request, arg_project, arg_firewall,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--update", () {
      var mock = new HttpServerMock();
      api.FirewallsResourceApi res = new api.ComputeApi(mock).firewalls;
      var arg_request = buildFirewall();
      var arg_project = "foo";
      var arg_firewall = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var obj = new api.Firewall.fromJson(json);
        checkFirewall(obj);

        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .update(arg_request, arg_project, arg_firewall,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });
  });

  unittest.group("resource-ForwardingRulesResourceApi", () {
    unittest.test("method--aggregatedList", () {
      var mock = new HttpServerMock();
      api.ForwardingRulesResourceApi res =
          new api.ComputeApi(mock).forwardingRules;
      var arg_project = "foo";
      var arg_filter = "foo";
      var arg_maxResults = 42;
      var arg_orderBy = "foo";
      var arg_pageToken = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["filter"].first, unittest.equals(arg_filter));
        unittest.expect(core.int.parse(queryMap["maxResults"].first),
            unittest.equals(arg_maxResults));
        unittest.expect(
            queryMap["orderBy"].first, unittest.equals(arg_orderBy));
        unittest.expect(
            queryMap["pageToken"].first, unittest.equals(arg_pageToken));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildForwardingRuleAggregatedList());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .aggregatedList(arg_project,
              filter: arg_filter,
              maxResults: arg_maxResults,
              orderBy: arg_orderBy,
              pageToken: arg_pageToken,
              $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkForwardingRuleAggregatedList(response);
      })));
    });

    unittest.test("method--delete", () {
      var mock = new HttpServerMock();
      api.ForwardingRulesResourceApi res =
          new api.ComputeApi(mock).forwardingRules;
      var arg_project = "foo";
      var arg_region = "foo";
      var arg_forwardingRule = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .delete(arg_project, arg_region, arg_forwardingRule,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--get", () {
      var mock = new HttpServerMock();
      api.ForwardingRulesResourceApi res =
          new api.ComputeApi(mock).forwardingRules;
      var arg_project = "foo";
      var arg_region = "foo";
      var arg_forwardingRule = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildForwardingRule());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .get(arg_project, arg_region, arg_forwardingRule,
              $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkForwardingRule(response);
      })));
    });

    unittest.test("method--insert", () {
      var mock = new HttpServerMock();
      api.ForwardingRulesResourceApi res =
          new api.ComputeApi(mock).forwardingRules;
      var arg_request = buildForwardingRule();
      var arg_project = "foo";
      var arg_region = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var obj = new api.ForwardingRule.fromJson(json);
        checkForwardingRule(obj);

        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .insert(arg_request, arg_project, arg_region,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--list", () {
      var mock = new HttpServerMock();
      api.ForwardingRulesResourceApi res =
          new api.ComputeApi(mock).forwardingRules;
      var arg_project = "foo";
      var arg_region = "foo";
      var arg_filter = "foo";
      var arg_maxResults = 42;
      var arg_orderBy = "foo";
      var arg_pageToken = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["filter"].first, unittest.equals(arg_filter));
        unittest.expect(core.int.parse(queryMap["maxResults"].first),
            unittest.equals(arg_maxResults));
        unittest.expect(
            queryMap["orderBy"].first, unittest.equals(arg_orderBy));
        unittest.expect(
            queryMap["pageToken"].first, unittest.equals(arg_pageToken));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildForwardingRuleList());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .list(arg_project, arg_region,
              filter: arg_filter,
              maxResults: arg_maxResults,
              orderBy: arg_orderBy,
              pageToken: arg_pageToken,
              $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkForwardingRuleList(response);
      })));
    });

    unittest.test("method--setTarget", () {
      var mock = new HttpServerMock();
      api.ForwardingRulesResourceApi res =
          new api.ComputeApi(mock).forwardingRules;
      var arg_request = buildTargetReference();
      var arg_project = "foo";
      var arg_region = "foo";
      var arg_forwardingRule = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var obj = new api.TargetReference.fromJson(json);
        checkTargetReference(obj);

        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .setTarget(arg_request, arg_project, arg_region, arg_forwardingRule,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });
  });

  unittest.group("resource-GlobalAddressesResourceApi", () {
    unittest.test("method--delete", () {
      var mock = new HttpServerMock();
      api.GlobalAddressesResourceApi res =
          new api.ComputeApi(mock).globalAddresses;
      var arg_project = "foo";
      var arg_address = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .delete(arg_project, arg_address,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--get", () {
      var mock = new HttpServerMock();
      api.GlobalAddressesResourceApi res =
          new api.ComputeApi(mock).globalAddresses;
      var arg_project = "foo";
      var arg_address = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildAddress());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .get(arg_project, arg_address, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkAddress(response);
      })));
    });

    unittest.test("method--insert", () {
      var mock = new HttpServerMock();
      api.GlobalAddressesResourceApi res =
          new api.ComputeApi(mock).globalAddresses;
      var arg_request = buildAddress();
      var arg_project = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var obj = new api.Address.fromJson(json);
        checkAddress(obj);

        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .insert(arg_request, arg_project,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--list", () {
      var mock = new HttpServerMock();
      api.GlobalAddressesResourceApi res =
          new api.ComputeApi(mock).globalAddresses;
      var arg_project = "foo";
      var arg_filter = "foo";
      var arg_maxResults = 42;
      var arg_orderBy = "foo";
      var arg_pageToken = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["filter"].first, unittest.equals(arg_filter));
        unittest.expect(core.int.parse(queryMap["maxResults"].first),
            unittest.equals(arg_maxResults));
        unittest.expect(
            queryMap["orderBy"].first, unittest.equals(arg_orderBy));
        unittest.expect(
            queryMap["pageToken"].first, unittest.equals(arg_pageToken));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildAddressList());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .list(arg_project,
              filter: arg_filter,
              maxResults: arg_maxResults,
              orderBy: arg_orderBy,
              pageToken: arg_pageToken,
              $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkAddressList(response);
      })));
    });
  });

  unittest.group("resource-GlobalForwardingRulesResourceApi", () {
    unittest.test("method--delete", () {
      var mock = new HttpServerMock();
      api.GlobalForwardingRulesResourceApi res =
          new api.ComputeApi(mock).globalForwardingRules;
      var arg_project = "foo";
      var arg_forwardingRule = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .delete(arg_project, arg_forwardingRule,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--get", () {
      var mock = new HttpServerMock();
      api.GlobalForwardingRulesResourceApi res =
          new api.ComputeApi(mock).globalForwardingRules;
      var arg_project = "foo";
      var arg_forwardingRule = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildForwardingRule());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .get(arg_project, arg_forwardingRule, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkForwardingRule(response);
      })));
    });

    unittest.test("method--insert", () {
      var mock = new HttpServerMock();
      api.GlobalForwardingRulesResourceApi res =
          new api.ComputeApi(mock).globalForwardingRules;
      var arg_request = buildForwardingRule();
      var arg_project = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var obj = new api.ForwardingRule.fromJson(json);
        checkForwardingRule(obj);

        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .insert(arg_request, arg_project,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--list", () {
      var mock = new HttpServerMock();
      api.GlobalForwardingRulesResourceApi res =
          new api.ComputeApi(mock).globalForwardingRules;
      var arg_project = "foo";
      var arg_filter = "foo";
      var arg_maxResults = 42;
      var arg_orderBy = "foo";
      var arg_pageToken = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["filter"].first, unittest.equals(arg_filter));
        unittest.expect(core.int.parse(queryMap["maxResults"].first),
            unittest.equals(arg_maxResults));
        unittest.expect(
            queryMap["orderBy"].first, unittest.equals(arg_orderBy));
        unittest.expect(
            queryMap["pageToken"].first, unittest.equals(arg_pageToken));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildForwardingRuleList());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .list(arg_project,
              filter: arg_filter,
              maxResults: arg_maxResults,
              orderBy: arg_orderBy,
              pageToken: arg_pageToken,
              $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkForwardingRuleList(response);
      })));
    });

    unittest.test("method--setTarget", () {
      var mock = new HttpServerMock();
      api.GlobalForwardingRulesResourceApi res =
          new api.ComputeApi(mock).globalForwardingRules;
      var arg_request = buildTargetReference();
      var arg_project = "foo";
      var arg_forwardingRule = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var obj = new api.TargetReference.fromJson(json);
        checkTargetReference(obj);

        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .setTarget(arg_request, arg_project, arg_forwardingRule,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });
  });

  unittest.group("resource-GlobalOperationsResourceApi", () {
    unittest.test("method--aggregatedList", () {
      var mock = new HttpServerMock();
      api.GlobalOperationsResourceApi res =
          new api.ComputeApi(mock).globalOperations;
      var arg_project = "foo";
      var arg_filter = "foo";
      var arg_maxResults = 42;
      var arg_orderBy = "foo";
      var arg_pageToken = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["filter"].first, unittest.equals(arg_filter));
        unittest.expect(core.int.parse(queryMap["maxResults"].first),
            unittest.equals(arg_maxResults));
        unittest.expect(
            queryMap["orderBy"].first, unittest.equals(arg_orderBy));
        unittest.expect(
            queryMap["pageToken"].first, unittest.equals(arg_pageToken));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperationAggregatedList());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .aggregatedList(arg_project,
              filter: arg_filter,
              maxResults: arg_maxResults,
              orderBy: arg_orderBy,
              pageToken: arg_pageToken,
              $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperationAggregatedList(response);
      })));
    });

    unittest.test("method--delete", () {
      var mock = new HttpServerMock();
      api.GlobalOperationsResourceApi res =
          new api.ComputeApi(mock).globalOperations;
      var arg_project = "foo";
      var arg_operation = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = "";
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .delete(arg_project, arg_operation, $fields: arg_$fields)
          .then(unittest.expectAsync1((_) {}));
    });

    unittest.test("method--get", () {
      var mock = new HttpServerMock();
      api.GlobalOperationsResourceApi res =
          new api.ComputeApi(mock).globalOperations;
      var arg_project = "foo";
      var arg_operation = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .get(arg_project, arg_operation, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--list", () {
      var mock = new HttpServerMock();
      api.GlobalOperationsResourceApi res =
          new api.ComputeApi(mock).globalOperations;
      var arg_project = "foo";
      var arg_filter = "foo";
      var arg_maxResults = 42;
      var arg_orderBy = "foo";
      var arg_pageToken = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["filter"].first, unittest.equals(arg_filter));
        unittest.expect(core.int.parse(queryMap["maxResults"].first),
            unittest.equals(arg_maxResults));
        unittest.expect(
            queryMap["orderBy"].first, unittest.equals(arg_orderBy));
        unittest.expect(
            queryMap["pageToken"].first, unittest.equals(arg_pageToken));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperationList());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .list(arg_project,
              filter: arg_filter,
              maxResults: arg_maxResults,
              orderBy: arg_orderBy,
              pageToken: arg_pageToken,
              $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperationList(response);
      })));
    });
  });

  unittest.group("resource-HealthChecksResourceApi", () {
    unittest.test("method--delete", () {
      var mock = new HttpServerMock();
      api.HealthChecksResourceApi res = new api.ComputeApi(mock).healthChecks;
      var arg_project = "foo";
      var arg_healthCheck = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .delete(arg_project, arg_healthCheck,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--get", () {
      var mock = new HttpServerMock();
      api.HealthChecksResourceApi res = new api.ComputeApi(mock).healthChecks;
      var arg_project = "foo";
      var arg_healthCheck = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildHealthCheck());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .get(arg_project, arg_healthCheck, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkHealthCheck(response);
      })));
    });

    unittest.test("method--insert", () {
      var mock = new HttpServerMock();
      api.HealthChecksResourceApi res = new api.ComputeApi(mock).healthChecks;
      var arg_request = buildHealthCheck();
      var arg_project = "foo";
      var arg_requestId = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var obj = new api.HealthCheck.fromJson(json);
        checkHealthCheck(obj);

        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new core.ArgumentError("Invalid boolean: $n");
        }

        if (query.length > 0) {
          for (var part in query.split("&")) {
            var keyvalue = part.split("=");
            addQueryParam(core.Uri.decodeQueryComponent(keyvalue[0]),
                core.Uri.decodeQueryComponent(keyvalue[1]));
          }
        }
        unittest.expect(
            queryMap["requestId"].first, unittest.equals(arg_requestId));
        unittest.expect(queryMap["fields"].first, unittest.equals(arg_$fields));

        var h = {
          "content-type": "application/json; charset=utf-8",
        };
        var resp = convert.json.encode(buildOperation());
        return new async.Future.value(stringResponse(200, h, resp));
      }), true);
      res
          .insert(arg_request, arg_project,
              requestId: arg_requestId, $fields: arg_$fields)
          .then(unittest.expectAsync1(((response) {
        checkOperation(response);
      })));
    });

    unittest.test("method--list", () {
      var mock = new HttpServerMock();
      api.HealthChecksResourceApi res = new api.ComputeApi(mock).healthChecks;
      var arg_project = "foo";
      var arg_filter = "foo";
      var arg_maxResults = 42;
      var arg_orderBy = "foo";
      var arg_pageToken = "foo";
      var arg_$fields = "foo";
      mock.register(unittest.expectAsync2((http.BaseRequest req, json) {
        var path = (req.url).path;
        var pathOffset = 0;
        var index;
        var subPart;
        unittest.expect(
            path.substring(pathOffset, pathOffset + 1), unittest.equals("/"));
        pathOffset += 1;

        var query = (req.url).query;
        var queryOffset = 0;
        var queryMap = <core.String, core.List<core.String>>{};
        addQueryParam(n, v) => queryMap.putIfAbsent(n, () => []).add(v);
        parseBool(n) {
          if (n == "true") return true;
          if (n == "false") return false;
          if (n == null) return null;
          throw new 