// Copyright 2013 The Flutter Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Autogenerated from Pigeon (v9.2.5), do not edit directly.
// See also: https://pub.dev/packages/pigeon

package io.flutter.plugins.camerax;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.plugin.common.BasicMessageChannel;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MessageCodec;
import io.flutter.plugin.common.StandardMessageCodec;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/** Generated class from Pigeon. */
@SuppressWarnings({"unused", "unchecked", "CodeBlock2Expr", "RedundantSuppression", "serial"})
public class GeneratedCameraXLibrary {

  /** Error class for passing custom error details to Flutter via a thrown PlatformException. */
  public static class FlutterError extends RuntimeException {

    /** The error code. */
    public final String code;

    /** The error details. Must be a datatype supported by the api codec. */
    public final Object details;

    public FlutterError(@NonNull String code, @Nullable String message, @Nullable Object details) {
      super(message);
      this.code = code;
      this.details = details;
    }
  }

  @NonNull
  protected static ArrayList<Object> wrapError(@NonNull Throwable exception) {
    ArrayList<Object> errorList = new ArrayList<Object>(3);
    if (exception instanceof FlutterError) {
      FlutterError error = (FlutterError) exception;
      errorList.add(error.code);
      errorList.add(error.getMessage());
      errorList.add(error.details);
    } else {
      errorList.add(exception.toString());
      errorList.add(exception.getClass().getSimpleName());
      errorList.add(
          "Cause: " + exception.getCause() + ", Stacktrace: " + Log.getStackTraceString(exception));
    }
    return errorList;
  }

  /**
   * The states the camera can be in.
   *
   * <p>See https://developer.android.com/reference/androidx/camera/core/CameraState.Type.
   */
  public enum CameraStateType {
    CLOSED(0),
    CLOSING(1),
    OPEN(2),
    OPENING(3),
    PENDING_OPEN(4);

    final int index;

    private CameraStateType(final int index) {
      this.index = index;
    }
  }

  /**
   * The types (T) properly wrapped to be used as a LiveData<T>.
   *
   * <p>If you need to add another type to support a type S to use a LiveData<S> in this plugin,
   * ensure the following is done on the Dart side:
   *
   * <p>* In `camera_android_camerax/lib/src/live_data.dart`, add new cases for S in
   * `_LiveDataHostApiImpl#getValueFromInstances` to get the current value of type S from a
   * LiveData<S> instance and in `LiveDataFlutterApiImpl#create` to create the expected type of
   * LiveData<S> when requested.
   *
   * <p>On the native side, ensure the following is done:
   *
   * <p>* Make sure `LiveDataHostApiImpl#getValue` is updated to properly return identifiers for
   * instances of type S. * Update `ObserverFlutterApiWrapper#onChanged` to properly handle
   * receiving calls with instances of type S if a LiveData<S> instance is observed.
   */
  public enum LiveDataSupportedType {
    CAMERA_STATE(0),
    ZOOM_STATE(1);

    final int index;

    private LiveDataSupportedType(final int index) {
      this.index = index;
    }
  }

  /**
   * Video quality constraints that will be used by a QualitySelector to choose an appropriate video
   * resolution.
   *
   * <p>These are pre-defined quality constants that are universally used for video.
   *
   * <p>See https://developer.android.com/reference/androidx/camera/video/Quality.
   */
  public enum VideoQuality {
    SD(0),
    HD(1),
    FHD(2),
    UHD(3),
    LOWEST(4),
    HIGHEST(5);

    final int index;

    private VideoQuality(final int index) {
      this.index = index;
    }
  }

  /**
   * Fallback rules for selecting video resolution.
   *
   * <p>See https://developer.android.com/reference/androidx/camera/video/FallbackStrategy.
   */
  public enum VideoResolutionFallbackRule {
    HIGHER_QUALITY_OR_LOWER_THAN(0),
    HIGHER_QUALITY_THAN(1),
    LOWER_QUALITY_OR_HIGHER_THAN(2),
    LOWER_QUALITY_THAN(3);

    final int index;

    private VideoResolutionFallbackRule(final int index) {
      this.index = index;
    }
  }

  /**
   * Video recording status.
   *
   * <p>See https://developer.android.com/reference/androidx/camera/video/VideoRecordEvent.
   */
  public enum VideoRecordEvent {
    START(0),
    FINALIZE(1);

    final int index;

    private VideoRecordEvent(final int index) {
      this.index = index;
    }
  }

  /**
   * The types of capture request options this plugin currently supports.
   *
   * <p>If you need to add another option to support, ensure the following is done on the Dart side:
   *
   * <p>* In `camera_android_camerax/lib/src/capture_request_options.dart`, add new cases for this
   * option in `_CaptureRequestOptionsHostApiImpl#createFromInstances` to create the expected Map
   * entry of option key index and value to send to the native side.
   *
   * <p>On the native side, ensure the following is done:
   *
   * <p>* Update `CaptureRequestOptionsHostApiImpl#create` to set the correct `CaptureRequest` key
   * with a valid value type for this option.
   *
   * <p>See https://developer.android.com/reference/android/hardware/camera2/CaptureRequest for the
   * sorts of capture request options that can be supported via CameraX's interoperability with
   * Camera2.
   */
  public enum CaptureRequestKeySupportedType {
    CONTROL_AE_LOCK(0);

    final int index;

    private CaptureRequestKeySupportedType(final int index) {
      this.index = index;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class ResolutionInfo {
    private @NonNull Long width;

    public @NonNull Long getWidth() {
      return width;
    }

    public void setWidth(@NonNull Long setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"width\" is null.");
      }
      this.width = setterArg;
    }

    private @NonNull Long height;

    public @NonNull Long getHeight() {
      return height;
    }

    public void setHeight(@NonNull Long setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"height\" is null.");
      }
      this.height = setterArg;
    }

    /** Constructor is non-public to enforce null safety; use Builder. */
    ResolutionInfo() {}

    public static final class Builder {

      private @Nullable Long width;

      public @NonNull Builder setWidth(@NonNull Long setterArg) {
        this.width = setterArg;
        return this;
      }

      private @Nullable Long height;

      public @NonNull Builder setHeight(@NonNull Long setterArg) {
        this.height = setterArg;
        return this;
      }

      public @NonNull ResolutionInfo build() {
        ResolutionInfo pigeonReturn = new ResolutionInfo();
        pigeonReturn.setWidth(width);
        pigeonReturn.setHeight(height);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(2);
      toListResult.add(width);
      toListResult.add(height);
      return toListResult;
    }

    static @NonNull ResolutionInfo fromList(@NonNull ArrayList<Object> list) {
      ResolutionInfo pigeonResult = new ResolutionInfo();
      Object width = list.get(0);
      pigeonResult.setWidth(
          (width == null) ? null : ((width instanceof Integer) ? (Integer) width : (Long) width));
      Object height = list.get(1);
      pigeonResult.setHeight(
          (height == null)
              ? null
              : ((height instanceof Integer) ? (Integer) height : (Long) height));
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class CameraPermissionsErrorData {
    private @NonNull String errorCode;

    public @NonNull String getErrorCode() {
      return errorCode;
    }

    public void setErrorCode(@NonNull String setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"errorCode\" is null.");
      }
      this.errorCode = setterArg;
    }

    private @NonNull String description;

    public @NonNull String getDescription() {
      return description;
    }

    public void setDescription(@NonNull String setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"description\" is null.");
      }
      this.description = setterArg;
    }

    /** Constructor is non-public to enforce null safety; use Builder. */
    CameraPermissionsErrorData() {}

    public static final class Builder {

      private @Nullable String errorCode;

      public @NonNull Builder setErrorCode(@NonNull String setterArg) {
        this.errorCode = setterArg;
        return this;
      }

      private @Nullable String description;

      public @NonNull Builder setDescription(@NonNull String setterArg) {
        this.description = setterArg;
        return this;
      }

      public @NonNull CameraPermissionsErrorData build() {
        CameraPermissionsErrorData pigeonReturn = new CameraPermissionsErrorData();
        pigeonReturn.setErrorCode(errorCode);
        pigeonReturn.setDescription(description);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(2);
      toListResult.add(errorCode);
      toListResult.add(description);
      return toListResult;
    }

    static @NonNull CameraPermissionsErrorData fromList(@NonNull ArrayList<Object> list) {
      CameraPermissionsErrorData pigeonResult = new CameraPermissionsErrorData();
      Object errorCode = list.get(0);
      pigeonResult.setErrorCode((String) errorCode);
      Object description = list.get(1);
      pigeonResult.setDescription((String) description);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class CameraStateTypeData {
    private @NonNull CameraStateType value;

    public @NonNull CameraStateType getValue() {
      return value;
    }

    public void setValue(@NonNull CameraStateType setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"value\" is null.");
      }
      this.value = setterArg;
    }

    /** Constructor is non-public to enforce null safety; use Builder. */
    CameraStateTypeData() {}

    public static final class Builder {

      private @Nullable CameraStateType value;

      public @NonNull Builder setValue(@NonNull CameraStateType setterArg) {
        this.value = setterArg;
        return this;
      }

      public @NonNull CameraStateTypeData build() {
        CameraStateTypeData pigeonReturn = new CameraStateTypeData();
        pigeonReturn.setValue(value);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(1);
      toListResult.add(value == null ? null : value.index);
      return toListResult;
    }

    static @NonNull CameraStateTypeData fromList(@NonNull ArrayList<Object> list) {
      CameraStateTypeData pigeonResult = new CameraStateTypeData();
      Object value = list.get(0);
      pigeonResult.setValue(value == null ? null : CameraStateType.values()[(int) value]);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class LiveDataSupportedTypeData {
    private @NonNull LiveDataSupportedType value;

    public @NonNull LiveDataSupportedType getValue() {
      return value;
    }

    public void setValue(@NonNull LiveDataSupportedType setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"value\" is null.");
      }
      this.value = setterArg;
    }

    /** Constructor is non-public to enforce null safety; use Builder. */
    LiveDataSupportedTypeData() {}

    public static final class Builder {

      private @Nullable LiveDataSupportedType value;

      public @NonNull Builder setValue(@NonNull LiveDataSupportedType setterArg) {
        this.value = setterArg;
        return this;
      }

      public @NonNull LiveDataSupportedTypeData build() {
        LiveDataSupportedTypeData pigeonReturn = new LiveDataSupportedTypeData();
        pigeonReturn.setValue(value);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(1);
      toListResult.add(value == null ? null : value.index);
      return toListResult;
    }

    static @NonNull LiveDataSupportedTypeData fromList(@NonNull ArrayList<Object> list) {
      LiveDataSupportedTypeData pigeonResult = new LiveDataSupportedTypeData();
      Object value = list.get(0);
      pigeonResult.setValue(value == null ? null : LiveDataSupportedType.values()[(int) value]);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class ExposureCompensationRange {
    private @NonNull Long minCompensation;

    public @NonNull Long getMinCompensation() {
      return minCompensation;
    }

    public void setMinCompensation(@NonNull Long setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"minCompensation\" is null.");
      }
      this.minCompensation = setterArg;
    }

    private @NonNull Long maxCompensation;

    public @NonNull Long getMaxCompensation() {
      return maxCompensation;
    }

    public void setMaxCompensation(@NonNull Long setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"maxCompensation\" is null.");
      }
      this.maxCompensation = setterArg;
    }

    /** Constructor is non-public to enforce null safety; use Builder. */
    ExposureCompensationRange() {}

    public static final class Builder {

      private @Nullable Long minCompensation;

      public @NonNull Builder setMinCompensation(@NonNull Long setterArg) {
        this.minCompensation = setterArg;
        return this;
      }

      private @Nullable Long maxCompensation;

      public @NonNull Builder setMaxCompensation(@NonNull Long setterArg) {
        this.maxCompensation = setterArg;
        return this;
      }

      public @NonNull ExposureCompensationRange build() {
        ExposureCompensationRange pigeonReturn = new ExposureCompensationRange();
        pigeonReturn.setMinCompensation(minCompensation);
        pigeonReturn.setMaxCompensation(maxCompensation);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(2);
      toListResult.add(minCompensation);
      toListResult.add(maxCompensation);
      return toListResult;
    }

    static @NonNull ExposureCompensationRange fromList(@NonNull ArrayList<Object> list) {
      ExposureCompensationRange pigeonResult = new ExposureCompensationRange();
      Object minCompensation = list.get(0);
      pigeonResult.setMinCompensation(
          (minCompensation == null)
              ? null
              : ((minCompensation instanceof Integer)
                  ? (Integer) minCompensation
                  : (Long) minCompensation));
      Object maxCompensation = list.get(1);
      pigeonResult.setMaxCompensation(
          (maxCompensation == null)
              ? null
              : ((maxCompensation instanceof Integer)
                  ? (Integer) maxCompensation
                  : (Long) maxCompensation));
      return pigeonResult;
    }
  }

  /**
   * Convenience class for sending lists of [Quality]s.
   *
   * <p>Generated class from Pigeon that represents data sent in messages.
   */
  public static final class VideoQualityData {
    private @NonNull VideoQuality quality;

    public @NonNull VideoQuality getQuality() {
      return quality;
    }

    public void setQuality(@NonNull VideoQuality setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"quality\" is null.");
      }
      this.quality = setterArg;
    }

    /** Constructor is non-public to enforce null safety; use Builder. */
    VideoQualityData() {}

    public static final class Builder {

      private @Nullable VideoQuality quality;

      public @NonNull Builder setQuality(@NonNull VideoQuality setterArg) {
        this.quality = setterArg;
        return this;
      }

      public @NonNull VideoQualityData build() {
        VideoQualityData pigeonReturn = new VideoQualityData();
        pigeonReturn.setQuality(quality);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(1);
      toListResult.add(quality == null ? null : quality.index);
      return toListResult;
    }

    static @NonNull VideoQualityData fromList(@NonNull ArrayList<Object> list) {
      VideoQualityData pigeonResult = new VideoQualityData();
      Object quality = list.get(0);
      pigeonResult.setQuality(quality == null ? null : VideoQuality.values()[(int) quality]);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class VideoRecordEventData {
    private @NonNull VideoRecordEvent value;

    public @NonNull VideoRecordEvent getValue() {
      return value;
    }

    public void setValue(@NonNull VideoRecordEvent setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"value\" is null.");
      }
      this.value = setterArg;
    }

    /** Constructor is non-public to enforce null safety; use Builder. */
    VideoRecordEventData() {}

    public static final class Builder {

      private @Nullable VideoRecordEvent value;

      public @NonNull Builder setValue(@NonNull VideoRecordEvent setterArg) {
        this.value = setterArg;
        return this;
      }

      public @NonNull VideoRecordEventData build() {
        VideoRecordEventData pigeonReturn = new VideoRecordEventData();
        pigeonReturn.setValue(value);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(1);
      toListResult.add(value == null ? null : value.index);
      return toListResult;
    }

    static @NonNull VideoRecordEventData fromList(@NonNull ArrayList<Object> list) {
      VideoRecordEventData pigeonResult = new VideoRecordEventData();
      Object value = list.get(0);
      pigeonResult.setValue(value == null ? null : VideoRecordEvent.values()[(int) value]);
      return pigeonResult;
    }
  }

  /**
   * Convenience class for building [FocusMeteringAction]s with multiple metering points.
   *
   * <p>Generated class from Pigeon that represents data sent in messages.
   */
  public static final class MeteringPointInfo {
    /** InstanceManager ID for a [MeteringPoint]. */
    private @NonNull Long meteringPointId;

    public @NonNull Long getMeteringPointId() {
      return meteringPointId;
    }

    public void setMeteringPointId(@NonNull Long setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"meteringPointId\" is null.");
      }
      this.meteringPointId = setterArg;
    }

    /**
     * The metering mode of the [MeteringPoint] whose ID is [meteringPointId].
     *
     * <p>Metering mode should be one of the [FocusMeteringAction] constants.
     */
    private @Nullable Long meteringMode;

    public @Nullable Long getMeteringMode() {
      return meteringMode;
    }

    public void setMeteringMode(@Nullable Long setterArg) {
      this.meteringMode = setterArg;
    }

    /** Constructor is non-public to enforce null safety; use Builder. */
    MeteringPointInfo() {}

    public static final class Builder {

      private @Nullable Long meteringPointId;

      public @NonNull Builder setMeteringPointId(@NonNull Long setterArg) {
        this.meteringPointId = setterArg;
        return this;
      }

      private @Nullable Long meteringMode;

      public @NonNull Builder setMeteringMode(@Nullable Long setterArg) {
        this.meteringMode = setterArg;
        return this;
      }

      public @NonNull MeteringPointInfo build() {
        MeteringPointInfo pigeonReturn = new MeteringPointInfo();
        pigeonReturn.setMeteringPointId(meteringPointId);
        pigeonReturn.setMeteringMode(meteringMode);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(2);
      toListResult.add(meteringPointId);
      toListResult.add(meteringMode);
      return toListResult;
    }

    static @NonNull MeteringPointInfo fromList(@NonNull ArrayList<Object> list) {
      MeteringPointInfo pigeonResult = new MeteringPointInfo();
      Object meteringPointId = list.get(0);
      pigeonResult.setMeteringPointId(
          (meteringPointId == null)
              ? null
              : ((meteringPointId instanceof Integer)
                  ? (Integer) meteringPointId
                  : (Long) meteringPointId));
      Object meteringMode = list.get(1);
      pigeonResult.setMeteringMode(
          (meteringMode == null)
              ? null
              : ((meteringMode instanceof Integer) ? (Integer) meteringMode : (Long) meteringMode));
      return pigeonResult;
    }
  }

  public interface Result<T> {
    @SuppressWarnings("UnknownNullness")
    void success(T result);

    void error(@NonNull Throwable error);
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface InstanceManagerHostApi {
    /**
     * Clear the native `InstanceManager`.
     *
     * <p>This is typically only used after a hot restart.
     */
    void clear();

    /** The codec used by InstanceManagerHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `InstanceManagerHostApi` to handle messages through the
     * `binaryMessenger`.
     */
    static void setup(
        @NonNull BinaryMessenger binaryMessenger, @Nullable InstanceManagerHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.InstanceManagerHostApi.clear", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  api.clear();
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface JavaObjectHostApi {

    void dispose(@NonNull Long identifier);

    /** The codec used by JavaObjectHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `JavaObjectHostApi` to handle messages through the `binaryMessenger`.
     */
    static void setup(@NonNull BinaryMessenger binaryMessenger, @Nullable JavaObjectHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.JavaObjectHostApi.dispose", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                try {
                  api.dispose((identifierArg == null) ? null : identifierArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated class from Pigeon that represents Flutter messages that can be called from Java. */
  public static class JavaObjectFlutterApi {
    private final @NonNull BinaryMessenger binaryMessenger;

    public JavaObjectFlutterApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this.binaryMessenger = argBinaryMessenger;
    }

    /** Public interface for sending reply. */
    @SuppressWarnings("UnknownNullness")
    public interface Reply<T> {
      void reply(T reply);
    }
    /** The codec used by JavaObjectFlutterApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }

    public void dispose(@NonNull Long identifierArg, @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, "dev.flutter.pigeon.JavaObjectFlutterApi.dispose", getCodec());
      channel.send(
          new ArrayList<Object>(Collections.singletonList(identifierArg)),
          channelReply -> callback.reply(null));
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface CameraInfoHostApi {

    @NonNull
    Long getSensorRotationDegrees(@NonNull Long identifier);

    @NonNull
    Long getCameraState(@NonNull Long identifier);

    @NonNull
    Long getExposureState(@NonNull Long identifier);

    @NonNull
    Long getZoomState(@NonNull Long identifier);

    /** The codec used by CameraInfoHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `CameraInfoHostApi` to handle messages through the `binaryMessenger`.
     */
    static void setup(@NonNull BinaryMessenger binaryMessenger, @Nullable CameraInfoHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.CameraInfoHostApi.getSensorRotationDegrees",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                try {
                  Long output =
                      api.getSensorRotationDegrees(
                          (identifierArg == null) ? null : identifierArg.longValue());
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.CameraInfoHostApi.getCameraState", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                try {
                  Long output =
                      api.getCameraState(
                          (identifierArg == null) ? null : identifierArg.longValue());
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.CameraInfoHostApi.getExposureState",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                try {
                  Long output =
                      api.getExposureState(
                          (identifierArg == null) ? null : identifierArg.longValue());
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.CameraInfoHostApi.getZoomState", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                try {
                  Long output =
                      api.getZoomState((identifierArg == null) ? null : identifierArg.longValue());
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated class from Pigeon that represents Flutter messages that can be called from Java. */
  public static class CameraInfoFlutterApi {
    private final @NonNull BinaryMessenger binaryMessenger;

    public CameraInfoFlutterApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this.binaryMessenger = argBinaryMessenger;
    }

    /** Public interface for sending reply. */
    @SuppressWarnings("UnknownNullness")
    public interface Reply<T> {
      void reply(T reply);
    }
    /** The codec used by CameraInfoFlutterApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }

    public void create(@NonNull Long identifierArg, @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, "dev.flutter.pigeon.CameraInfoFlutterApi.create", getCodec());
      channel.send(
          new ArrayList<Object>(Collections.singletonList(identifierArg)),
          channelReply -> callback.reply(null));
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface CameraSelectorHostApi {

    void create(@NonNull Long identifier, @Nullable Long lensFacing);

    @NonNull
    List<Long> filter(@NonNull Long identifier, @NonNull List<Long> cameraInfoIds);

    /** The codec used by CameraSelectorHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `CameraSelectorHostApi` to handle messages through the
     * `binaryMessenger`.
     */
    static void setup(
        @NonNull BinaryMessenger binaryMessenger, @Nullable CameraSelectorHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.CameraSelectorHostApi.create", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                Number lensFacingArg = (Number) args.get(1);
                try {
                  api.create(
                      (identifierArg == null) ? null : identifierArg.longValue(),
                      (lensFacingArg == null) ? null : lensFacingArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.CameraSelectorHostApi.filter", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                List<Long> cameraInfoIdsArg = (List<Long>) args.get(1);
                try {
                  List<Long> output =
                      api.filter(
                          (identifierArg == null) ? null : identifierArg.longValue(),
                          cameraInfoIdsArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated class from Pigeon that represents Flutter messages that can be called from Java. */
  public static class CameraSelectorFlutterApi {
    private final @NonNull BinaryMessenger binaryMessenger;

    public CameraSelectorFlutterApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this.binaryMessenger = argBinaryMessenger;
    }

    /** Public interface for sending reply. */
    @SuppressWarnings("UnknownNullness")
    public interface Reply<T> {
      void reply(T reply);
    }
    /** The codec used by CameraSelectorFlutterApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }

    public void create(
        @NonNull Long identifierArg, @Nullable Long lensFacingArg, @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, "dev.flutter.pigeon.CameraSelectorFlutterApi.create", getCodec());
      channel.send(
          new ArrayList<Object>(Arrays.asList(identifierArg, lensFacingArg)),
          channelReply -> callback.reply(null));
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface ProcessCameraProviderHostApi {

    void getInstance(@NonNull Result<Long> result);

    @NonNull
    List<Long> getAvailableCameraInfos(@NonNull Long identifier);

    @NonNull
    Long bindToLifecycle(
        @NonNull Long identifier,
        @NonNull Long cameraSelectorIdentifier,
        @NonNull List<Long> useCaseIds);

    @NonNull
    Boolean isBound(@NonNull Long identifier, @NonNull Long useCaseIdentifier);

    void unbind(@NonNull Long identifier, @NonNull List<Long> useCaseIds);

    void unbindAll(@NonNull Long identifier);

    /** The codec used by ProcessCameraProviderHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `ProcessCameraProviderHostApi` to handle messages through the
     * `binaryMessenger`.
     */
    static void setup(
        @NonNull BinaryMessenger binaryMessenger, @Nullable ProcessCameraProviderHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.ProcessCameraProviderHostApi.getInstance",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                Result<Long> resultCallback =
                    new Result<Long>() {
                      public void success(Long result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.getInstance(resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.ProcessCameraProviderHostApi.getAvailableCameraInfos",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                try {
                  List<Long> output =
                      api.getAvailableCameraInfos(
                          (identifierArg == null) ? null : identifierArg.longValue());
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.ProcessCameraProviderHostApi.bindToLifecycle",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                Number cameraSelectorIdentifierArg = (Number) args.get(1);
                List<Long> useCaseIdsArg = (List<Long>) args.get(2);
                try {
                  Long output =
                      api.bindToLifecycle(
                          (identifierArg == null) ? null : identifierArg.longValue(),
                          (cameraSelectorIdentifierArg == null)
                              ? null
                              : cameraSelectorIdentifierArg.longValue(),
                          useCaseIdsArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.ProcessCameraProviderHostApi.isBound",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                Number useCaseIdentifierArg = (Number) args.get(1);
                try {
                  Boolean output =
                      api.isBound(
                          (identifierArg == null) ? null : identifierArg.longValue(),
                          (useCaseIdentifierArg == null) ? null : useCaseIdentifierArg.longValue());
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.ProcessCameraProviderHostApi.unbind",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                List<Long> useCaseIdsArg = (List<Long>) args.get(1);
                try {
                  api.unbind(
                      (identifierArg == null) ? null : identifierArg.longValue(), useCaseIdsArg);
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.ProcessCameraProviderHostApi.unbindAll",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                try {
                  api.unbindAll((identifierArg == null) ? null : identifierArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated class from Pigeon that represents Flutter messages that can be called from Java. */
  public static class ProcessCameraProviderFlutterApi {
    private final @NonNull BinaryMessenger binaryMessenger;

    public ProcessCameraProviderFlutterApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this.binaryMessenger = argBinaryMessenger;
    }

    /** Public interface for sending reply. */
    @SuppressWarnings("UnknownNullness")
    public interface Reply<T> {
      void reply(T reply);
    }
    /** The codec used by ProcessCameraProviderFlutterApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }

    public void create(@NonNull Long identifierArg, @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger,
              "dev.flutter.pigeon.ProcessCameraProviderFlutterApi.create",
              getCodec());
      channel.send(
          new ArrayList<Object>(Collections.singletonList(identifierArg)),
          channelReply -> callback.reply(null));
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface CameraHostApi {

    @NonNull
    Long getCameraInfo(@NonNull Long identifier);

    @NonNull
    Long getCameraControl(@NonNull Long identifier);

    /** The codec used by CameraHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /** Sets up an instance of `CameraHostApi` to handle messages through the `binaryMessenger`. */
    static void setup(@NonNull BinaryMessenger binaryMessenger, @Nullable CameraHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.CameraHostApi.getCameraInfo", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                try {
                  Long output =
                      api.getCameraInfo((identifierArg == null) ? null : identifierArg.longValue());
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.CameraHostApi.getCameraControl", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                try {
                  Long output =
                      api.getCameraControl(
                          (identifierArg == null) ? null : identifierArg.longValue());
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated class from Pigeon that represents Flutter messages that can be called from Java. */
  public static class CameraFlutterApi {
    private final @NonNull BinaryMessenger binaryMessenger;

    public CameraFlutterApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this.binaryMessenger = argBinaryMessenger;
    }

    /** Public interface for sending reply. */
    @SuppressWarnings("UnknownNullness")
    public interface Reply<T> {
      void reply(T reply);
    }
    /** The codec used by CameraFlutterApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }

    public void create(@NonNull Long identifierArg, @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, "dev.flutter.pigeon.CameraFlutterApi.create", getCodec());
      channel.send(
          new ArrayList<Object>(Collections.singletonList(identifierArg)),
          channelReply -> callback.reply(null));
    }
  }

  private static class SystemServicesHostApiCodec extends StandardMessageCodec {
    public static final SystemServicesHostApiCodec INSTANCE = new SystemServicesHostApiCodec();

    private SystemServicesHostApiCodec() {}

    @Override
    protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
      switch (type) {
        case (byte) 128:
          return CameraPermissionsErrorData.fromList((ArrayList<Object>) readValue(buffer));
        default:
          return super.readValueOfType(type, buffer);
      }
    }

    @Override
    protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
      if (value instanceof CameraPermissionsErrorData) {
        stream.write(128);
        writeValue(stream, ((CameraPermissionsErrorData) value).toList());
      } else {
        super.writeValue(stream, value);
      }
    }
  }

  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface SystemServicesHostApi {

    void requestCameraPermissions(
        @NonNull Boolean enableAudio, @NonNull Result<CameraPermissionsErrorData> result);

    @NonNull
    String getTempFilePath(@NonNull String prefix, @NonNull String suffix);

    /** The codec used by SystemServicesHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return SystemServicesHostApiCodec.INSTANCE;
    }
    /**
     * Sets up an instance of `SystemServicesHostApi` to handle messages through the
     * `binaryMessenger`.
     */
    static void setup(
        @NonNull BinaryMessenger binaryMessenger, @Nullable SystemServicesHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.SystemServicesHostApi.requestCameraPermissions",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Boolean enableAudioArg = (Boolean) args.get(0);
                Result<CameraPermissionsErrorData> resultCallback =
                    new Result<CameraPermissionsErrorData>() {
                      public void success(CameraPermissionsErrorData result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.requestCameraPermissions(enableAudioArg, resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.SystemServicesHostApi.getTempFilePath",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                String prefixArg = (String) args.get(0);
                String suffixArg = (String) args.get(1);
                try {
                  String output = api.getTempFilePath(prefixArg, suffixArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated class from Pigeon that represents Flutter messages that can be called from Java. */
  public static class SystemServicesFlutterApi {
    private final @NonNull BinaryMessenger binaryMessenger;

    public SystemServicesFlutterApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this.binaryMessenger = argBinaryMessenger;
    }

    /** Public interface for sending reply. */
    @SuppressWarnings("UnknownNullness")
    public interface Reply<T> {
      void reply(T reply);
    }
    /** The codec used by SystemServicesFlutterApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }

    public void onCameraError(@NonNull String errorDescriptionArg, @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger,
              "dev.flutter.pigeon.SystemServicesFlutterApi.onCameraError",
              getCodec());
      channel.send(
          new ArrayList<Object>(Collections.singletonList(errorDescriptionArg)),
          channelReply -> callback.reply(null));
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface DeviceOrientationManagerHostApi {

    void startListeningForDeviceOrientationChange(
        @NonNull Boolean isFrontFacing, @NonNull Long sensorOrientation);

    void stopListeningForDeviceOrientationChange();

    @NonNull
    Long getDefaultDisplayRotation();

    /** The codec used by DeviceOrientationManagerHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `DeviceOrientationManagerHostApi` to handle messages through the
     * `binaryMessenger`.
     */
    static void setup(
        @NonNull BinaryMessenger binaryMessenger, @Nullable DeviceOrientationManagerHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.DeviceOrientationManagerHostApi.startListeningForDeviceOrientationChange",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Boolean isFrontFacingArg = (Boolean) args.get(0);
                Number sensorOrientationArg = (Number) args.get(1);
                try {
                  api.startListeningForDeviceOrientationChange(
                      isFrontFacingArg,
                      (sensorOrientationArg == null) ? null : sensorOrientationArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.DeviceOrientationManagerHostApi.stopListeningForDeviceOrientationChange",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  api.stopListeningForDeviceOrientationChange();
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.DeviceOrientationManagerHostApi.getDefaultDisplayRotation",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  Long output = api.getDefaultDisplayRotation();
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated class from Pigeon that represents Flutter messages that can be called from Java. */
  public static class DeviceOrientationManagerFlutterApi {
    private final @NonNull BinaryMessenger binaryMessenger;

    public DeviceOrientationManagerFlutterApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this.binaryMessenger = argBinaryMessenger;
    }

    /** Public interface for sending reply. */
    @SuppressWarnings("UnknownNullness")
    public interface Reply<T> {
      void reply(T reply);
    }
    /** The codec used by DeviceOrientationManagerFlutterApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }

    public void onDeviceOrientationChanged(
        @NonNull String orientationArg, @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger,
              "dev.flutter.pigeon.DeviceOrientationManagerFlutterApi.onDeviceOrientationChanged",
              getCodec());
      channel.send(
          new ArrayList<Object>(Collections.singletonList(orientationArg)),
          channelReply -> callback.reply(null));
    }
  }

  private static class PreviewHostApiCodec extends StandardMessageCodec {
    public static final PreviewHostApiCodec INSTANCE = new PreviewHostApiCodec();

    private PreviewHostApiCodec() {}

    @Override
    protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
      switch (type) {
        case (byte) 128:
          return ResolutionInfo.fromList((ArrayList<Object>) readValue(buffer));
        default:
          return super.readValueOfType(type, buffer);
      }
    }

    @Override
    protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
      if (value instanceof ResolutionInfo) {
        stream.write(128);
        writeValue(stream, ((ResolutionInfo) value).toList());
      } else {
        super.writeValue(stream, value);
      }
    }
  }

  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface PreviewHostApi {

    void create(
        @NonNull Long identifier, @Nullable Long rotation, @Nullable Long resolutionSelectorId);

    @NonNull
    Long setSurfaceProvider(@NonNull Long identifier);

    void releaseFlutterSurfaceTexture();

    @NonNull
    ResolutionInfo getResolutionInfo(@NonNull Long identifier);

    void setTargetRotation(@NonNull Long identifier, @NonNull Long rotation);

    /** The codec used by PreviewHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return PreviewHostApiCodec.INSTANCE;
    }
    /** Sets up an instance of `PreviewHostApi` to handle messages through the `binaryMessenger`. */
    static void setup(@NonNull BinaryMessenger binaryMessenger, @Nullable PreviewHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.PreviewHostApi.create", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                Number rotationArg = (Number) args.get(1);
                Number resolutionSelectorIdArg = (Number) args.get(2);
                try {
                  api.create(
                      (identifierArg == null) ? null : identifierArg.longValue(),
                      (rotationArg == null) ? null : rotationArg.longValue(),
                      (resolutionSelectorIdArg == null)
                          ? null
                          : resolutionSelectorIdArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.PreviewHostApi.setSurfaceProvider",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                try {
                  Long output =
                      api.setSurfaceProvider(
                          (identifierArg == null) ? null : identifierArg.longValue());
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.PreviewHostApi.releaseFlutterSurfaceTexture",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  api.releaseFlutterSurfaceTexture();
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.PreviewHostApi.getResolutionInfo", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                try {
                  ResolutionInfo output =
                      api.getResolutionInfo(
                          (identifierArg == null) ? null : identifierArg.longValue());
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.PreviewHostApi.setTargetRotation", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                Number rotationArg = (Number) args.get(1);
                try {
                  api.setTargetRotation(
                      (identifierArg == null) ? null : identifierArg.longValue(),
                      (rotationArg == null) ? null : rotationArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface VideoCaptureHostApi {

    @NonNull
    Long withOutput(@NonNull Long videoOutputId);

    @NonNull
    Long getOutput(@NonNull Long identifier);

    void setTargetRotation(@NonNull Long identifier, @NonNull Long rotation);

    /** The codec used by VideoCaptureHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `VideoCaptureHostApi` to handle messages through the
     * `binaryMessenger`.
     */
    static void setup(@NonNull BinaryMessenger binaryMessenger, @Nullable VideoCaptureHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.VideoCaptureHostApi.withOutput", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number videoOutputIdArg = (Number) args.get(0);
                try {
                  Long output =
                      api.withOutput(
                          (videoOutputIdArg == null) ? null : videoOutputIdArg.longValue());
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.VideoCaptureHostApi.getOutput", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                try {
                  Long output =
                      api.getOutput((identifierArg == null) ? null : identifierArg.longValue());
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.VideoCaptureHostApi.setTargetRotation",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                Number rotationArg = (Number) args.get(1);
                try {
                  api.setTargetRotation(
                      (identifierArg == null) ? null : identifierArg.longValue(),
                      (rotationArg == null) ? null : rotationArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated class from Pigeon that represents Flutter messages that can be called from Java. */
  public static class VideoCaptureFlutterApi {
    private final @NonNull BinaryMessenger binaryMessenger;

    public VideoCaptureFlutterApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this.binaryMessenger = argBinaryMessenger;
    }

    /** Public interface for sending reply. */
    @SuppressWarnings("UnknownNullness")
    public interface Reply<T> {
      void reply(T reply);
    }
    /** The codec used by VideoCaptureFlutterApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }

    public void create(@NonNull Long identifierArg, @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, "dev.flutter.pigeon.VideoCaptureFlutterApi.create", getCodec());
      channel.send(
          new ArrayList<Object>(Collections.singletonList(identifierArg)),
          channelReply -> callback.reply(null));
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface RecorderHostApi {

    void create(
        @NonNull Long identifier,
        @Nullable Long aspectRatio,
        @Nullable Long bitRate,
        @Nullable Long qualitySelectorId);

    @NonNull
    Long getAspectRatio(@NonNull Long identifier);

    @NonNull
    Long getTargetVideoEncodingBitRate(@NonNull Long identifier);

    @NonNull
    Long prepareRecording(@NonNull Long identifier, @NonNull String path);

    /** The codec used by RecorderHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `RecorderHostApi` to handle messages through the `binaryMessenger`.
     */
    static void setup(@NonNull BinaryMessenger binaryMessenger, @Nullable RecorderHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.RecorderHostApi.create", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                Number aspectRatioArg = (Number) args.get(1);
                Number bitRateArg = (Number) args.get(2);
                Number qualitySelectorIdArg = (Number) args.get(3);
                try {
                  api.create(
                      (identifierArg == null) ? null : identifierArg.longValue(),
                      (aspectRatioArg == null) ? null : aspectRatioArg.longValue(),
                      (bitRateArg == null) ? null : bitRateArg.longValue(),
                      (qualitySelectorIdArg == null) ? null : qualitySelectorIdArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.RecorderHostApi.getAspectRatio", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                try {
                  Long output =
                      api.getAspectRatio(
                          (identifierArg == null) ? null : identifierArg.longValue());
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.RecorderHostApi.getTargetVideoEncodingBitRate",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                try {
                  Long output =
                      api.getTargetVideoEncodingBitRate(
                          (identifierArg == null) ? null : identifierArg.longValue());
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.RecorderHostApi.prepareRecording", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                String pathArg = (String) args.get(1);
                try {
                  Long output =
                      api.prepareRecording(
                          (identifierArg == null) ? null : identifierArg.longValue(), pathArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated class from Pigeon that represents Flutter messages that can be called from Java. */
  public static class RecorderFlutterApi {
    private final @NonNull BinaryMessenger binaryMessenger;

    public RecorderFlutterApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this.binaryMessenger = argBinaryMessenger;
    }

    /** Public interface for sending reply. */
    @SuppressWarnings("UnknownNullness")
    public interface Reply<T> {
      void reply(T reply);
    }
    /** The codec used by RecorderFlutterApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }

    public void create(
        @NonNull Long identifierArg,
        @Nullable Long aspectRatioArg,
        @Nullable Long bitRateArg,
        @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, "dev.flutter.pigeon.RecorderFlutterApi.create", getCodec());
      channel.send(
          new ArrayList<Object>(Arrays.asList(identifierArg, aspectRatioArg, bitRateArg)),
          channelReply -> callback.reply(null));
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface PendingRecordingHostApi {

    @NonNull
    Long start(@NonNull Long identifier);

    /** The codec used by PendingRecordingHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `PendingRecordingHostApi` to handle messages through the
     * `binaryMessenger`.
     */
    static void setup(
        @NonNull BinaryMessenger binaryMessenger, @Nullable PendingRecordingHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.PendingRecordingHostApi.start", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                try {
                  Long output =
                      api.start((identifierArg == null) ? null : identifierArg.longValue());
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }

  private static class PendingRecordingFlutterApiCodec extends StandardMessageCodec {
    public static final PendingRecordingFlutterApiCodec INSTANCE =
        new PendingRecordingFlutterApiCodec();

    private PendingRecordingFlutterApiCodec() {}

    @Override
    protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
      switch (type) {
        case (byte) 128:
          return VideoRecordEventData.fromList((ArrayList<Object>) readValue(buffer));
        default:
          return super.readValueOfType(type, buffer);
      }
    }

    @Override
    protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
      if (value instanceof VideoRecordEventData) {
        stream.write(128);
        writeValue(stream, ((VideoRecordEventData) value).toList());
      } else {
        super.writeValue(stream, value);
      }
    }
  }

  /** Generated class from Pigeon that represents Flutter messages that can be called from Java. */
  public static class PendingRecordingFlutterApi {
    private final @NonNull BinaryMessenger binaryMessenger;

    public PendingRecordingFlutterApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this.binaryMessenger = argBinaryMessenger;
    }

    /** Public interface for sending reply. */
    @SuppressWarnings("UnknownNullness")
    public interface Reply<T> {
      void reply(T reply);
    }
    /** The codec used by PendingRecordingFlutterApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return PendingRecordingFlutterApiCodec.INSTANCE;
    }

    public void create(@NonNull Long identifierArg, @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, "dev.flutter.pigeon.PendingRecordingFlutterApi.create", getCodec());
      channel.send(
          new ArrayList<Object>(Collections.singletonList(identifierArg)),
          channelReply -> callback.reply(null));
    }

    public void onVideoRecordingEvent(
        @NonNull VideoRecordEventData eventArg, @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger,
              "dev.flutter.pigeon.PendingRecordingFlutterApi.onVideoRecordingEvent",
              getCodec());
      channel.send(
          new ArrayList<Object>(Collections.singletonList(eventArg)),
          channelReply -> callback.reply(null));
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface RecordingHostApi {

    void close(@NonNull Long identifier);

    void pause(@NonNull Long identifier);

    void resume(@NonNull Long identifier);

    void stop(@NonNull Long identifier);

    /** The codec used by RecordingHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `RecordingHostApi` to handle messages through the `binaryMessenger`.
     */
    static void setup(@NonNull BinaryMessenger binaryMessenger, @Nullable RecordingHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.RecordingHostApi.close", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                try {
                  api.close((identifierArg == null) ? null : identifierArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.RecordingHostApi.pause", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                try {
                  api.pause((identifierArg == null) ? null : identifierArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.RecordingHostApi.resume", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                try {
                  api.resume((identifierArg == null) ? null : identifierArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.RecordingHostApi.stop", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                try {
                  api.stop((identifierArg == null) ? null : identifierArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated class from Pigeon that represents Flutter messages that can be called from Java. */
  public static class RecordingFlutterApi {
    private final @NonNull BinaryMessenger binaryMessenger;

    public RecordingFlutterApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this.binaryMessenger = argBinaryMessenger;
    }

    /** Public interface for sending reply. */
    @SuppressWarnings("UnknownNullness")
    public interface Reply<T> {
      void reply(T reply);
    }
    /** The codec used by RecordingFlutterApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }

    public void create(@NonNull Long identifierArg, @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, "dev.flutter.pigeon.RecordingFlutterApi.create", getCodec());
      channel.send(
          new ArrayList<Object>(Collections.singletonList(identifierArg)),
          channelReply -> callback.reply(null));
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface ImageCaptureHostApi {

    void create(
        @NonNull Long identifier,
        @Nullable Long targetRotation,
        @Nullable Long flashMode,
        @Nullable Long resolutionSelectorId);

    void setFlashMode(@NonNull Long identifier, @NonNull Long flashMode);

    void takePicture(@NonNull Long identifier, @NonNull Result<String> result);

    void setTargetRotation(@NonNull Long identifier, @NonNull Long rotation);

    /** The codec used by ImageCaptureHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `ImageCaptureHostApi` to handle messages through the
     * `binaryMessenger`.
     */
    static void setup(@NonNull BinaryMessenger binaryMessenger, @Nullable ImageCaptureHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.ImageCaptureHostApi.create", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                Number targetRotationArg = (Number) args.get(1);
                Number flashModeArg = (Number) args.get(2);
                Number resolutionSelectorIdArg = (Number) args.get(3);
                try {
                  api.create(
                      (identifierArg == null) ? null : identifierArg.longValue(),
                      (targetRotationArg == null) ? null : targetRotationArg.longValue(),
                      (flashModeArg == null) ? null : flashModeArg.longValue(),
                      (resolutionSelectorIdArg == null)
                          ? null
                          : resolutionSelectorIdArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.ImageCaptureHostApi.setFlashMode", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                Number flashModeArg = (Number) args.get(1);
                try {
                  api.setFlashMode(
                      (identifierArg == null) ? null : identifierArg.longValue(),
                      (flashModeArg == null) ? null : flashModeArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.ImageCaptureHostApi.takePicture", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                Result<String> resultCallback =
                    new Result<String>() {
                      public void success(String result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.takePicture(
                    (identifierArg == null) ? null : identifierArg.longValue(), resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.ImageCaptureHostApi.setTargetRotation",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                Number rotationArg = (Number) args.get(1);
                try {
                  api.setTargetRotation(
                      (identifierArg == null) ? null : identifierArg.longValue(),
                      (rotationArg == null) ? null : rotationArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }

  private static class ResolutionStrategyHostApiCodec extends StandardMessageCodec {
    public static final ResolutionStrategyHostApiCodec INSTANCE =
        new ResolutionStrategyHostApiCodec();

    private ResolutionStrategyHostApiCodec() {}

    @Override
    protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
      switch (type) {
        case (byte) 128:
          return ResolutionInfo.fromList((ArrayList<Object>) readValue(buffer));
        default:
          return super.readValueOfType(type, buffer);
      }
    }

    @Override
    protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
      if (value instanceof ResolutionInfo) {
        stream.write(128);
        writeValue(stream, ((ResolutionInfo) value).toList());
      } else {
        super.writeValue(stream, value);
      }
    }
  }

  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface ResolutionStrategyHostApi {

    void create(
        @NonNull Long identifier, @Nullable ResolutionInfo boundSize, @Nullable Long fallbackRule);

    /** The codec used by ResolutionStrategyHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return ResolutionStrategyHostApiCodec.INSTANCE;
    }
    /**
     * Sets up an instance of `ResolutionStrategyHostApi` to handle messages through the
     * `binaryMessenger`.
     */
    static void setup(
        @NonNull BinaryMessenger binaryMessenger, @Nullable ResolutionStrategyHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.ResolutionStrategyHostApi.create", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                ResolutionInfo boundSizeArg = (ResolutionInfo) args.get(1);
                Number fallbackRuleArg = (Number) args.get(2);
                try {
                  api.create(
                      (identifierArg == null) ? null : identifierArg.longValue(),
                      boundSizeArg,
                      (fallbackRuleArg == null) ? null : fallbackRuleArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface ResolutionSelectorHostApi {

    void create(
        @NonNull Long identifier,
        @Nullable Long resolutionStrategyIdentifier,
        @Nullable Long resolutionSelectorIdentifier,
        @Nullable Long aspectRatioStrategyIdentifier);

    /** The codec used by ResolutionSelectorHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `ResolutionSelectorHostApi` to handle messages through the
     * `binaryMessenger`.
     */
    static void setup(
        @NonNull BinaryMessenger binaryMessenger, @Nullable ResolutionSelectorHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.ResolutionSelectorHostApi.create", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                Number resolutionStrategyIdentifierArg = (Number) args.get(1);
                Number resolutionSelectorIdentifierArg = (Number) args.get(2);
                Number aspectRatioStrategyIdentifierArg = (Number) args.get(3);
                try {
                  api.create(
                      (identifierArg == null) ? null : identifierArg.longValue(),
                      (resolutionStrategyIdentifierArg == null)
                          ? null
                          : resolutionStrategyIdentifierArg.longValue(),
                      (resolutionSelectorIdentifierArg == null)
                          ? null
                          : resolutionSelectorIdentifierArg.longValue(),
                      (aspectRatioStrategyIdentifierArg == null)
                          ? null
                          : aspectRatioStrategyIdentifierArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface AspectRatioStrategyHostApi {

    void create(
        @NonNull Long identifier, @NonNull Long preferredAspectRatio, @NonNull Long fallbackRule);

    /** The codec used by AspectRatioStrategyHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `AspectRatioStrategyHostApi` to handle messages through the
     * `binaryMessenger`.
     */
    static void setup(
        @NonNull BinaryMessenger binaryMessenger, @Nullable AspectRatioStrategyHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.AspectRatioStrategyHostApi.create",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                Number preferredAspectRatioArg = (Number) args.get(1);
                Number fallbackRuleArg = (Number) args.get(2);
                try {
                  api.create(
                      (identifierArg == null) ? null : identifierArg.longValue(),
                      (preferredAspectRatioArg == null)
                          ? null
                          : preferredAspectRatioArg.longValue(),
                      (fallbackRuleArg == null) ? null : fallbackRuleArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }

  private static class CameraStateFlutterApiCodec extends StandardMessageCodec {
    public static final CameraStateFlutterApiCodec INSTANCE = new CameraStateFlutterApiCodec();

    private CameraStateFlutterApiCodec() {}

    @Override
    protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
      switch (type) {
        case (byte) 128:
          return CameraStateTypeData.fromList((ArrayList<Object>) readValue(buffer));
        default:
          return super.readValueOfType(type, buffer);
      }
    }

    @Override
    protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
      if (value instanceof CameraStateTypeData) {
        stream.write(128);
        writeValue(stream, ((CameraStateTypeData) value).toList());
      } else {
        super.writeValue(stream, value);
      }
    }
  }

  /** Generated class from Pigeon that represents Flutter messages that can be called from Java. */
  public static class CameraStateFlutterApi {
    private final @NonNull BinaryMessenger binaryMessenger;

    public CameraStateFlutterApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this.binaryMessenger = argBinaryMessenger;
    }

    /** Public interface for sending reply. */
    @SuppressWarnings("UnknownNullness")
    public interface Reply<T> {
      void reply(T reply);
    }
    /** The codec used by CameraStateFlutterApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return CameraStateFlutterApiCodec.INSTANCE;
    }

    public void create(
        @NonNull Long identifierArg,
        @NonNull CameraStateTypeData typeArg,
        @Nullable Long errorIdentifierArg,
        @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, "dev.flutter.pigeon.CameraStateFlutterApi.create", getCodec());
      channel.send(
          new ArrayList<Object>(Arrays.asList(identifierArg, typeArg, errorIdentifierArg)),
          channelReply -> callback.reply(null));
    }
  }

  private static class ExposureStateFlutterApiCodec extends StandardMessageCodec {
    public static final ExposureStateFlutterApiCodec INSTANCE = new ExposureStateFlutterApiCodec();

    private ExposureStateFlutterApiCodec() {}

    @Override
    protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
      switch (type) {
        case (byte) 128:
          return ExposureCompensationRange.fromList((ArrayList<Object>) readValue(buffer));
        default:
          return super.readValueOfType(type, buffer);
      }
    }

    @Override
    protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
      if (value instanceof ExposureCompensationRange) {
        stream.write(128);
        writeValue(stream, ((ExposureCompensationRange) value).toList());
      } else {
        super.writeValue(stream, value);
      }
    }
  }

  /** Generated class from Pigeon that represents Flutter messages that can be called from Java. */
  public static class ExposureStateFlutterApi {
    private final @NonNull BinaryMessenger binaryMessenger;

    public ExposureStateFlutterApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this.binaryMessenger = argBinaryMessenger;
    }

    /** Public interface for sending reply. */
    @SuppressWarnings("UnknownNullness")
    public interface Reply<T> {
      void reply(T reply);
    }
    /** The codec used by ExposureStateFlutterApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return ExposureStateFlutterApiCodec.INSTANCE;
    }

    public void create(
        @NonNull Long identifierArg,
        @NonNull ExposureCompensationRange exposureCompensationRangeArg,
        @NonNull Double exposureCompensationStepArg,
        @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, "dev.flutter.pigeon.ExposureStateFlutterApi.create", getCodec());
      channel.send(
          new ArrayList<Object>(
              Arrays.asList(
                  identifierArg, exposureCompensationRangeArg, exposureCompensationStepArg)),
          channelReply -> callback.reply(null));
    }
  }
  /** Generated class from Pigeon that represents Flutter messages that can be called from Java. */
  public static class ZoomStateFlutterApi {
    private final @NonNull BinaryMessenger binaryMessenger;

    public ZoomStateFlutterApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this.binaryMessenger = argBinaryMessenger;
    }

    /** Public interface for sending reply. */
    @SuppressWarnings("UnknownNullness")
    public interface Reply<T> {
      void reply(T reply);
    }
    /** The codec used by ZoomStateFlutterApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }

    public void create(
        @NonNull Long identifierArg,
        @NonNull Double minZoomRatioArg,
        @NonNull Double maxZoomRatioArg,
        @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, "dev.flutter.pigeon.ZoomStateFlutterApi.create", getCodec());
      channel.send(
          new ArrayList<Object>(Arrays.asList(identifierArg, minZoomRatioArg, maxZoomRatioArg)),
          channelReply -> callback.reply(null));
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface ImageAnalysisHostApi {

    void create(
        @NonNull Long identifier,
        @Nullable Long targetRotation,
        @Nullable Long resolutionSelectorId);

    void setAnalyzer(@NonNull Long identifier, @NonNull Long analyzerIdentifier);

    void clearAnalyzer(@NonNull Long identifier);

    void setTargetRotation(@NonNull Long identifier, @NonNull Long rotation);

    /** The codec used by ImageAnalysisHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `ImageAnalysisHostApi` to handle messages through the
     * `binaryMessenger`.
     */
    static void setup(
        @NonNull BinaryMessenger binaryMessenger, @Nullable ImageAnalysisHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.ImageAnalysisHostApi.create", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                Number targetRotationArg = (Number) args.get(1);
                Number resolutionSelectorIdArg = (Number) args.get(2);
                try {
                  api.create(
                      (identifierArg == null) ? null : identifierArg.longValue(),
                      (targetRotationArg == null) ? null : targetRotationArg.longValue(),
                      (resolutionSelectorIdArg == null)
                          ? null
                          : resolutionSelectorIdArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.ImageAnalysisHostApi.setAnalyzer", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                Number analyzerIdentifierArg = (Number) args.get(1);
                try {
                  api.setAnalyzer(
                      (identifierArg == null) ? null : identifierArg.longValue(),
                      (analyzerIdentifierArg == null) ? null : analyzerIdentifierArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.ImageAnalysisHostApi.clearAnalyzer",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                try {
                  api.clearAnalyzer((identifierArg == null) ? null : identifierArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.ImageAnalysisHostApi.setTargetRotation",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                Number rotationArg = (Number) args.get(1);
                try {
                  api.setTargetRotation(
                      (identifierArg == null) ? null : identifierArg.longValue(),
                      (rotationArg == null) ? null : rotationArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface AnalyzerHostApi {

    void create(@NonNull Long identifier);

    /** The codec used by AnalyzerHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `AnalyzerHostApi` to handle messages through the `binaryMessenger`.
     */
    static void setup(@NonNull BinaryMessenger binaryMessenger, @Nullable AnalyzerHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.AnalyzerHostApi.create", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                try {
                  api.create((identifierArg == null) ? null : identifierArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface ObserverHostApi {

    void create(@NonNull Long identifier);

    /** The codec used by ObserverHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `ObserverHostApi` to handle messages through the `binaryMessenger`.
     */
    static void setup(@NonNull BinaryMessenger binaryMessenger, @Nullable ObserverHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.ObserverHostApi.create", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                try {
                  api.create((identifierArg == null) ? null : identifierArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated class from Pigeon that represents Flutter messages that can be called from Java. */
  public static class ObserverFlutterApi {
    private final @NonNull BinaryMessenger binaryMessenger;

    public ObserverFlutterApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this.binaryMessenger = argBinaryMessenger;
    }

    /** Public interface for sending reply. */
    @SuppressWarnings("UnknownNullness")
    public interface Reply<T> {
      void reply(T reply);
    }
    /** The codec used by ObserverFlutterApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }

    public void onChanged(
        @NonNull Long identifierArg,
        @NonNull Long valueIdentifierArg,
        @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, "dev.flutter.pigeon.ObserverFlutterApi.onChanged", getCodec());
      channel.send(
          new ArrayList<Object>(Arrays.asList(identifierArg, valueIdentifierArg)),
          channelReply -> callback.reply(null));
    }
  }
  /** Generated class from Pigeon that represents Flutter messages that can be called from Java. */
  public static class CameraStateErrorFlutterApi {
    private final @NonNull BinaryMessenger binaryMessenger;

    public CameraStateErrorFlutterApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this.binaryMessenger = argBinaryMessenger;
    }

    /** Public interface for sending reply. */
    @SuppressWarnings("UnknownNullness")
    public interface Reply<T> {
      void reply(T reply);
    }
    /** The codec used by CameraStateErrorFlutterApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }

    public void create(
        @NonNull Long identifierArg, @NonNull Long codeArg, @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, "dev.flutter.pigeon.CameraStateErrorFlutterApi.create", getCodec());
      channel.send(
          new ArrayList<Object>(Arrays.asList(identifierArg, codeArg)),
          channelReply -> callback.reply(null));
    }
  }

  private static class LiveDataHostApiCodec extends StandardMessageCodec {
    public static final LiveDataHostApiCodec INSTANCE = new LiveDataHostApiCodec();

    private LiveDataHostApiCodec() {}

    @Override
    protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
      switch (type) {
        case (byte) 128:
          return LiveDataSupportedTypeData.fromList((ArrayList<Object>) readValue(buffer));
        default:
          return super.readValueOfType(type, buffer);
      }
    }

    @Override
    protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
      if (value instanceof LiveDataSupportedTypeData) {
        stream.write(128);
        writeValue(stream, ((LiveDataSupportedTypeData) value).toList());
      } else {
        super.writeValue(stream, value);
      }
    }
  }

  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface LiveDataHostApi {

    void observe(@NonNull Long identifier, @NonNull Long observerIdentifier);

    void removeObservers(@NonNull Long identifier);

    @Nullable
    Long getValue(@NonNull Long identifier, @NonNull LiveDataSupportedTypeData type);

    /** The codec used by LiveDataHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return LiveDataHostApiCodec.INSTANCE;
    }
    /**
     * Sets up an instance of `LiveDataHostApi` to handle messages through the `binaryMessenger`.
     */
    static void setup(@NonNull BinaryMessenger binaryMessenger, @Nullable LiveDataHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.LiveDataHostApi.observe", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                Number observerIdentifierArg = (Number) args.get(1);
                try {
                  api.observe(
                      (identifierArg == null) ? null : identifierArg.longValue(),
                      (observerIdentifierArg == null) ? null : observerIdentifierArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.LiveDataHostApi.removeObservers", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                try {
                  api.removeObservers((identifierArg == null) ? null : identifierArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.LiveDataHostApi.getValue", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                LiveDataSupportedTypeData typeArg = (LiveDataSupportedTypeData) args.get(1);
                try {
                  Long output =
                      api.getValue(
                          (identifierArg == null) ? null : identifierArg.longValue(), typeArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }

  private static class LiveDataFlutterApiCodec extends StandardMessageCodec {
    public static final LiveDataFlutterApiCodec INSTANCE = new LiveDataFlutterApiCodec();

    private LiveDataFlutterApiCodec() {}

    @Override
    protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
      switch (type) {
        case (byte) 128:
          return LiveDataSupportedTypeData.fromList((ArrayList<Object>) readValue(buffer));
        default:
          return super.readValueOfType(type, buffer);
      }
    }

    @Override
    protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
      if (value instanceof LiveDataSupportedTypeData) {
        stream.write(128);
        writeValue(stream, ((LiveDataSupportedTypeData) value).toList());
      } else {
        super.writeValue(stream, value);
      }
    }
  }

  /** Generated class from Pigeon that represents Flutter messages that can be called from Java. */
  public static class LiveDataFlutterApi {
    private final @NonNull BinaryMessenger binaryMessenger;

    public LiveDataFlutterApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this.binaryMessenger = argBinaryMessenger;
    }

    /** Public interface for sending reply. */
    @SuppressWarnings("UnknownNullness")
    public interface Reply<T> {
      void reply(T reply);
    }
    /** The codec used by LiveDataFlutterApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return LiveDataFlutterApiCodec.INSTANCE;
    }

    public void create(
        @NonNull Long identifierArg,
        @NonNull LiveDataSupportedTypeData typeArg,
        @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, "dev.flutter.pigeon.LiveDataFlutterApi.create", getCodec());
      channel.send(
          new ArrayList<Object>(Arrays.asList(identifierArg, typeArg)),
          channelReply -> callback.reply(null));
    }
  }
  /** Generated class from Pigeon that represents Flutter messages that can be called from Java. */
  public static class AnalyzerFlutterApi {
    private final @NonNull BinaryMessenger binaryMessenger;

    public AnalyzerFlutterApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this.binaryMessenger = argBinaryMessenger;
    }

    /** Public interface for sending reply. */
    @SuppressWarnings("UnknownNullness")
    public interface Reply<T> {
      void reply(T reply);
    }
    /** The codec used by AnalyzerFlutterApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }

    public void create(@NonNull Long identifierArg, @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, "dev.flutter.pigeon.AnalyzerFlutterApi.create", getCodec());
      channel.send(
          new ArrayList<Object>(Collections.singletonList(identifierArg)),
          channelReply -> callback.reply(null));
    }

    public void analyze(
        @NonNull Long identifierArg,
        @NonNull Long imageProxyIdentifierArg,
        @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, "dev.flutter.pigeon.AnalyzerFlutterApi.analyze", getCodec());
      channel.send(
          new ArrayList<Object>(Arrays.asList(identifierArg, imageProxyIdentifierArg)),
          channelReply -> callback.reply(null));
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface ImageProxyHostApi {

    @NonNull
    List<Long> getPlanes(@NonNull Long identifier);

    void close(@NonNull Long identifier);

    /** The codec used by ImageProxyHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `ImageProxyHostApi` to handle messages through the `binaryMessenger`.
     */
    static void setup(@NonNull BinaryMessenger binaryMessenger, @Nullable ImageProxyHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.ImageProxyHostApi.getPlanes", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                try {
                  List<Long> output =
                      api.getPlanes((identifierArg == null) ? null : identifierArg.longValue());
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.ImageProxyHostApi.close", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                try {
                  api.close((identifierArg == null) ? null : identifierArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated class from Pigeon that represents Flutter messages that can be called from Java. */
  public static class ImageProxyFlutterApi {
    private final @NonNull BinaryMessenger binaryMessenger;

    public ImageProxyFlutterApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this.binaryMessenger = argBinaryMessenger;
    }

    /** Public interface for sending reply. */
    @SuppressWarnings("UnknownNullness")
    public interface Reply<T> {
      void reply(T reply);
    }
    /** The codec used by ImageProxyFlutterApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }

    public void create(
        @NonNull Long identifierArg,
        @NonNull Long formatArg,
        @NonNull Long heightArg,
        @NonNull Long widthArg,
        @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, "dev.flutter.pigeon.ImageProxyFlutterApi.create", getCodec());
      channel.send(
          new ArrayList<Object>(Arrays.asList(identifierArg, formatArg, heightArg, widthArg)),
          channelReply -> callback.reply(null));
    }
  }
  /** Generated class from Pigeon that represents Flutter messages that can be called from Java. */
  public static class PlaneProxyFlutterApi {
    private final @NonNull BinaryMessenger binaryMessenger;

    public PlaneProxyFlutterApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this.binaryMessenger = argBinaryMessenger;
    }

    /** Public interface for sending reply. */
    @SuppressWarnings("UnknownNullness")
    public interface Reply<T> {
      void reply(T reply);
    }
    /** The codec used by PlaneProxyFlutterApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }

    public void create(
        @NonNull Long identifierArg,
        @NonNull byte[] bufferArg,
        @NonNull Long pixelStrideArg,
        @NonNull Long rowStrideArg,
        @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, "dev.flutter.pigeon.PlaneProxyFlutterApi.create", getCodec());
      channel.send(
          new ArrayList<Object>(
              Arrays.asList(identifierArg, bufferArg, pixelStrideArg, rowStrideArg)),
          channelReply -> callback.reply(null));
    }
  }

  private static class QualitySelectorHostApiCodec extends StandardMessageCodec {
    public static final QualitySelectorHostApiCodec INSTANCE = new QualitySelectorHostApiCodec();

    private QualitySelectorHostApiCodec() {}

    @Override
    protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
      switch (type) {
        case (byte) 128:
          return ResolutionInfo.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 129:
          return VideoQualityData.fromList((ArrayList<Object>) readValue(buffer));
        default:
          return super.readValueOfType(type, buffer);
      }
    }

    @Override
    protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
      if (value instanceof ResolutionInfo) {
        stream.write(128);
        writeValue(stream, ((ResolutionInfo) value).toList());
      } else if (value instanceof VideoQualityData) {
        stream.write(129);
        writeValue(stream, ((VideoQualityData) value).toList());
      } else {
        super.writeValue(stream, value);
      }
    }
  }

  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface QualitySelectorHostApi {

    void create(
        @NonNull Long identifier,
        @NonNull List<VideoQualityData> videoQualityDataList,
        @Nullable Long fallbackStrategyId);

    @NonNull
    ResolutionInfo getResolution(@NonNull Long cameraInfoId, @NonNull VideoQuality quality);

    /** The codec used by QualitySelectorHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return QualitySelectorHostApiCodec.INSTANCE;
    }
    /**
     * Sets up an instance of `QualitySelectorHostApi` to handle messages through the
     * `binaryMessenger`.
     */
    static void setup(
        @NonNull BinaryMessenger binaryMessenger, @Nullable QualitySelectorHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.QualitySelectorHostApi.create", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                List<VideoQualityData> videoQualityDataListArg =
                    (List<VideoQualityData>) args.get(1);
                Number fallbackStrategyIdArg = (Number) args.get(2);
                try {
                  api.create(
                      (identifierArg == null) ? null : identifierArg.longValue(),
                      videoQualityDataListArg,
                      (fallbackStrategyIdArg == null) ? null : fallbackStrategyIdArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.QualitySelectorHostApi.getResolution",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number cameraInfoIdArg = (Number) args.get(0);
                VideoQuality qualityArg =
                    args.get(1) == null ? null : VideoQuality.values()[(int) args.get(1)];
                try {
                  ResolutionInfo output =
                      api.getResolution(
                          (cameraInfoIdArg == null) ? null : cameraInfoIdArg.longValue(),
                          qualityArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface FallbackStrategyHostApi {

    void create(
        @NonNull Long identifier,
        @NonNull VideoQuality quality,
        @NonNull VideoResolutionFallbackRule fallbackRule);

    /** The codec used by FallbackStrategyHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `FallbackStrategyHostApi` to handle messages through the
     * `binaryMessenger`.
     */
    static void setup(
        @NonNull BinaryMessenger binaryMessenger, @Nullable FallbackStrategyHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.FallbackStrategyHostApi.create", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                VideoQuality qualityArg =
                    args.get(1) == null ? null : VideoQuality.values()[(int) args.get(1)];
                VideoResolutionFallbackRule fallbackRuleArg =
                    args.get(2) == null
                        ? null
                        : VideoResolutionFallbackRule.values()[(int) args.get(2)];
                try {
                  api.create(
                      (identifierArg == null) ? null : identifierArg.longValue(),
                      qualityArg,
                      fallbackRuleArg);
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface CameraControlHostApi {

    void enableTorch(
        @NonNull Long identifier, @NonNull Boolean torch, @NonNull Result<Void> result);

    void setZoomRatio(
        @NonNull Long identifier, @NonNull Double ratio, @NonNull Result<Void> result);

    void startFocusAndMetering(
        @NonNull Long identifier,
        @NonNull Long focusMeteringActionId,
        @NonNull Result<Long> result);

    void cancelFocusAndMetering(@NonNull Long identifier, @NonNull Result<Void> result);

    void setExposureCompensationIndex(
        @NonNull Long identifier, @NonNull Long index, @NonNull Result<Long> result);

    /** The codec used by CameraControlHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `CameraControlHostApi` to handle messages through the
     * `binaryMessenger`.
     */
    static void setup(
        @NonNull BinaryMessenger binaryMessenger, @Nullable CameraControlHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.CameraControlHostApi.enableTorch", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                Boolean torchArg = (Boolean) args.get(1);
                Result<Void> resultCallback =
                    new Result<Void>() {
                      public void success(Void result) {
                        wrapped.add(0, null);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.enableTorch(
                    (identifierArg == null) ? null : identifierArg.longValue(),
                    torchArg,
                    resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.CameraControlHostApi.setZoomRatio",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                Double ratioArg = (Double) args.get(1);
                Result<Void> resultCallback =
                    new Result<Void>() {
                      public void success(Void result) {
                        wrapped.add(0, null);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.setZoomRatio(
                    (identifierArg == null) ? null : identifierArg.longValue(),
                    ratioArg,
                    resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.CameraControlHostApi.startFocusAndMetering",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                Number focusMeteringActionIdArg = (Number) args.get(1);
                Result<Long> resultCallback =
                    new Result<Long>() {
                      public void success(Long result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.startFocusAndMetering(
                    (identifierArg == null) ? null : identifierArg.longValue(),
                    (focusMeteringActionIdArg == null)
                        ? null
                        : focusMeteringActionIdArg.longValue(),
                    resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.CameraControlHostApi.cancelFocusAndMetering",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                Result<Void> resultCallback =
                    new Result<Void>() {
                      public void success(Void result) {
                        wrapped.add(0, null);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.cancelFocusAndMetering(
                    (identifierArg == null) ? null : identifierArg.longValue(), resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.CameraControlHostApi.setExposureCompensationIndex",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                Number indexArg = (Number) args.get(1);
                Result<Long> resultCallback =
                    new Result<Long>() {
                      public void success(Long result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.setExposureCompensationIndex(
                    (identifierArg == null) ? null : identifierArg.longValue(),
                    (indexArg == null) ? null : indexArg.longValue(),
                    resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated class from Pigeon that represents Flutter messages that can be called from Java. */
  public static class CameraControlFlutterApi {
    private final @NonNull BinaryMessenger binaryMessenger;

    public CameraControlFlutterApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this.binaryMessenger = argBinaryMessenger;
    }

    /** Public interface for sending reply. */
    @SuppressWarnings("UnknownNullness")
    public interface Reply<T> {
      void reply(T reply);
    }
    /** The codec used by CameraControlFlutterApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }

    public void create(@NonNull Long identifierArg, @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, "dev.flutter.pigeon.CameraControlFlutterApi.create", getCodec());
      channel.send(
          new ArrayList<Object>(Collections.singletonList(identifierArg)),
          channelReply -> callback.reply(null));
    }
  }

  private static class FocusMeteringActionHostApiCodec extends StandardMessageCodec {
    public static final FocusMeteringActionHostApiCodec INSTANCE =
        new FocusMeteringActionHostApiCodec();

    private FocusMeteringActionHostApiCodec() {}

    @Override
    protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
      switch (type) {
        case (byte) 128:
          return MeteringPointInfo.fromList((ArrayList<Object>) readValue(buffer));
        default:
          return super.readValueOfType(type, buffer);
      }
    }

    @Override
    protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
      if (value instanceof MeteringPointInfo) {
        stream.write(128);
        writeValue(stream, ((MeteringPointInfo) value).toList());
      } else {
        super.writeValue(stream, value);
      }
    }
  }

  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface FocusMeteringActionHostApi {

    void create(
        @NonNull Long identifier,
        @NonNull List<MeteringPointInfo> meteringPointInfos,
        @Nullable Boolean disableAutoCancel);

    /** The codec used by FocusMeteringActionHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return FocusMeteringActionHostApiCodec.INSTANCE;
    }
    /**
     * Sets up an instance of `FocusMeteringActionHostApi` to handle messages through the
     * `binaryMessenger`.
     */
    static void setup(
        @NonNull BinaryMessenger binaryMessenger, @Nullable FocusMeteringActionHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.FocusMeteringActionHostApi.create",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                List<MeteringPointInfo> meteringPointInfosArg =
                    (List<MeteringPointInfo>) args.get(1);
                Boolean disableAutoCancelArg = (Boolean) args.get(2);
                try {
                  api.create(
                      (identifierArg == null) ? null : identifierArg.longValue(),
                      meteringPointInfosArg,
                      disableAutoCancelArg);
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface FocusMeteringResultHostApi {

    @NonNull
    Boolean isFocusSuccessful(@NonNull Long identifier);

    /** The codec used by FocusMeteringResultHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `FocusMeteringResultHostApi` to handle messages through the
     * `binaryMessenger`.
     */
    static void setup(
        @NonNull BinaryMessenger binaryMessenger, @Nullable FocusMeteringResultHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.FocusMeteringResultHostApi.isFocusSuccessful",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                try {
                  Boolean output =
                      api.isFocusSuccessful(
                          (identifierArg == null) ? null : identifierArg.longValue());
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated class from Pigeon that represents Flutter messages that can be called from Java. */
  public static class FocusMeteringResultFlutterApi {
    private final @NonNull BinaryMessenger binaryMessenger;

    public FocusMeteringResultFlutterApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this.binaryMessenger = argBinaryMessenger;
    }

    /** Public interface for sending reply. */
    @SuppressWarnings("UnknownNullness")
    public interface Reply<T> {
      void reply(T reply);
    }
    /** The codec used by FocusMeteringResultFlutterApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }

    public void create(@NonNull Long identifierArg, @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger,
              "dev.flutter.pigeon.FocusMeteringResultFlutterApi.create",
              getCodec());
      channel.send(
          new ArrayList<Object>(Collections.singletonList(identifierArg)),
          channelReply -> callback.reply(null));
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface MeteringPointHostApi {

    void create(
        @NonNull Long identifier,
        @NonNull Double x,
        @NonNull Double y,
        @Nullable Double size,
        @NonNull Long cameraInfoId);

    @NonNull
    Double getDefaultPointSize();

    /** The codec used by MeteringPointHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `MeteringPointHostApi` to handle messages through the
     * `binaryMessenger`.
     */
    static void setup(
        @NonNull BinaryMessenger binaryMessenger, @Nullable MeteringPointHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.MeteringPointHostApi.create", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                Double xArg = (Double) args.get(1);
                Double yArg = (Double) args.get(2);
                Double sizeArg = (Double) args.get(3);
                Number cameraInfoIdArg = (Number) args.get(4);
                try {
                  api.create(
                      (identifierArg == null) ? null : identifierArg.longValue(),
                      xArg,
                      yArg,
                      sizeArg,
                      (cameraInfoIdArg == null) ? null : cameraInfoIdArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.MeteringPointHostApi.getDefaultPointSize",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  Double output = api.getDefaultPointSize();
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }

  private static class CaptureRequestOptionsHostApiCodec extends StandardMessageCodec {
    public static final CaptureRequestOptionsHostApiCodec INSTANCE =
        new CaptureRequestOptionsHostApiCodec();

    private CaptureRequestOptionsHostApiCodec() {}

    @Override
    protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
      switch (type) {
        case (byte) 128:
          return CameraPermissionsErrorData.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 129:
          return CameraStateTypeData.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 130:
          return ExposureCompensationRange.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 131:
          return LiveDataSupportedTypeData.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 132:
          return MeteringPointInfo.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 133:
          return ResolutionInfo.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 134:
          return VideoQualityData.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 135:
          return VideoRecordEventData.fromList((ArrayList<Object>) readValue(buffer));
        default:
          return super.readValueOfType(type, buffer);
      }
    }

    @Override
    protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
      if (value instanceof CameraPermissionsErrorData) {
        stream.write(128);
        writeValue(stream, ((CameraPermissionsErrorData) value).toList());
      } else if (value instanceof CameraStateTypeData) {
        stream.write(129);
        writeValue(stream, ((CameraStateTypeData) value).toList());
      } else if (value instanceof ExposureCompensationRange) {
        stream.write(130);
        writeValue(stream, ((ExposureCompensationRange) value).toList());
      } else if (value instanceof LiveDataSupportedTypeData) {
        stream.write(131);
        writeValue(stream, ((LiveDataSupportedTypeData) value).toList());
      } else if (value instanceof MeteringPointInfo) {
        stream.write(132);
        writeValue(stream, ((MeteringPointInfo) value).toList());
      } else if (value instanceof ResolutionInfo) {
        stream.write(133);
        writeValue(stream, ((ResolutionInfo) value).toList());
      } else if (value instanceof VideoQualityData) {
        stream.write(134);
        writeValue(stream, ((VideoQualityData) value).toList());
      } else if (value instanceof VideoRecordEventData) {
        stream.write(135);
        writeValue(stream, ((VideoRecordEventData) value).toList());
      } else {
        super.writeValue(stream, value);
      }
    }
  }

  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface CaptureRequestOptionsHostApi {

    void create(@NonNull Long identifier, @NonNull Map<Long, Object> options);

    /** The codec used by CaptureRequestOptionsHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return CaptureRequestOptionsHostApiCodec.INSTANCE;
    }
    /**
     * Sets up an instance of `CaptureRequestOptionsHostApi` to handle messages through the
     * `binaryMessenger`.
     */
    static void setup(
        @NonNull BinaryMessenger binaryMessenger, @Nullable CaptureRequestOptionsHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.CaptureRequestOptionsHostApi.create",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                Map<Long, Object> optionsArg = (Map<Long, Object>) args.get(1);
                try {
                  api.create(
                      (identifierArg == null) ? null : identifierArg.longValue(), optionsArg);
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface Camera2CameraControlHostApi {

    void create(@NonNull Long identifier, @NonNull Long cameraControlIdentifier);

    void addCaptureRequestOptions(
        @NonNull Long identifier,
        @NonNull Long captureRequestOptionsIdentifier,
        @NonNull Result<Void> result);

    /** The codec used by Camera2CameraControlHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `Camera2CameraControlHostApi` to handle messages through the
     * `binaryMessenger`.
     */
    static void setup(
        @NonNull BinaryMessenger binaryMessenger, @Nullable Camera2CameraControlHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.Camera2CameraControlHostApi.create",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                Number cameraControlIdentifierArg = (Number) args.get(1);
                try {
                  api.create(
                      (identifierArg == null) ? null : identifierArg.longValue(),
                      (cameraControlIdentifierArg == null)
                          ? null
                          : cameraControlIdentifierArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.Camera2CameraControlHostApi.addCaptureRequestOptions",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                Number captureRequestOptionsIdentifierArg = (Number) args.get(1);
                Result<Void> resultCallback =
                    new Result<Void>() {
                      public void success(Void result) {
                        wrapped.add(0, null);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.addCaptureRequestOptions(
                    (identifierArg == null) ? null : identifierArg.longValue(),
                    (captureRequestOptionsIdentifierArg == null)
                        ? null
                        : captureRequestOptionsIdentifierArg.longValue(),
                    resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }

  private static class ResolutionFilterHostApiCodec extends StandardMessageCodec {
    public static final ResolutionFilterHostApiCodec INSTANCE = new ResolutionFilterHostApiCodec();

    private ResolutionFilterHostApiCodec() {}

    @Override
    protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
      switch (type) {
        case (byte) 128:
          return ResolutionInfo.fromList((ArrayList<Object>) readValue(buffer));
        default:
          return super.readValueOfType(type, buffer);
      }
    }

    @Override
    protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
      if (value instanceof ResolutionInfo) {
        stream.write(128);
        writeValue(stream, ((ResolutionInfo) value).toList());
      } else {
        super.writeValue(stream, value);
      }
    }
  }

  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface ResolutionFilterHostApi {

    void createWithOnePreferredSize(
        @NonNull Long identifier, @NonNull ResolutionInfo preferredResolution);

    /** The codec used by ResolutionFilterHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return ResolutionFilterHostApiCodec.INSTANCE;
    }
    /**
     * Sets up an instance of `ResolutionFilterHostApi` to handle messages through the
     * `binaryMessenger`.
     */
    static void setup(
        @NonNull BinaryMessenger binaryMessenger, @Nullable ResolutionFilterHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.ResolutionFilterHostApi.createWithOnePreferredSize",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                ResolutionInfo preferredResolutionArg = (ResolutionInfo) args.get(1);
                try {
                  api.createWithOnePreferredSize(
                      (identifierArg == null) ? null : identifierArg.longValue(),
                      preferredResolutionArg);
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface Camera2CameraInfoHostApi {

    @NonNull
    Long createFrom(@NonNull Long cameraInfoIdentifier);

    @NonNull
    Long getSupportedHardwareLevel(@NonNull Long identifier);

    @NonNull
    String getCameraId(@NonNull Long identifier);

    /** The codec used by Camera2CameraInfoHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `Camera2CameraInfoHostApi` to handle messages through the
     * `binaryMessenger`.
     */
    static void setup(
        @NonNull BinaryMessenger binaryMessenger, @Nullable Camera2CameraInfoHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.Camera2CameraInfoHostApi.createFrom",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number cameraInfoIdentifierArg = (Number) args.get(0);
                try {
                  Long output =
                      api.createFrom(
                          (cameraInfoIdentifierArg == null)
                              ? null
                              : cameraInfoIdentifierArg.longValue());
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.Camera2CameraInfoHostApi.getSupportedHardwareLevel",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                try {
                  Long output =
                      api.getSupportedHardwareLevel(
                          (identifierArg == null) ? null : identifierArg.longValue());
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.Camera2CameraInfoHostApi.getCameraId",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                try {
                  String output =
                      api.getCameraId((identifierArg == null) ? null : identifierArg.longValue());
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated class from Pigeon that represents Flutter messages that can be called from Java. */
  public static class Camera2CameraInfoFlutterApi {
    private final @NonNull BinaryMessenger binaryMessenger;

    public Camera2CameraInfoFlutterApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this.binaryMessenger = argBinaryMessenger;
    }

    /** Public interface for sending reply. */
    @SuppressWarnings("UnknownNullness")
    public interface Reply<T> {
      void reply(T reply);
    }
    /** The codec used by Camera2CameraInfoFlutterApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }

    public void create(@NonNull Long identifierArg, @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, "dev.flutter.pigeon.Camera2CameraInfoFlutterApi.create", getCodec());
      channel.send(
          new ArrayList<Object>(Collections.singletonList(identifierArg)),
          channelReply -> callback.reply(null));
    }
  }
}
