Generated Dart libraries for accessing
[Google APIs](https://developers.google.com/api-client-library).

To use these APIs from Flutter, see the
[Flutter Google APIs documentation](https://flutter.dev/docs/development/data-and-backend/google-apis).

For example of using these APIs from a Dart console example see the example in
this package. For an example of usage in a server application,
[see this example](https://github.com/dart-lang/samples/tree/master/server/google_apis).

## Available Google APIs

The following is a list of APIs that are currently available inside this
package.

#### Abusive Experience Report API - `abusiveexperiencereport_v1`

Views Abusive Experience Report data, and gets a list of sites that have a significant number of abusive experiences.

- [Documentation](https://developers.google.com/abusive-experience-report/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/abusiveexperiencereport_v1/abusiveexperiencereport_v1-library.html)

#### Accelerated Mobile Pages (AMP) URL API - `acceleratedmobilepageurl_v1`

Retrieves the list of AMP URLs (and equivalent AMP Cache URLs) for a given list of public URL(s). 

- [Documentation](https://developers.google.com/amp/cache/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/acceleratedmobilepageurl_v1/acceleratedmobilepageurl_v1-library.html)

#### Access Approval API - `accessapproval_v1`

An API for controlling access to data by Google personnel.

- [Documentation](https://cloud.google.com/assured-workloads/access-approval/docs)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/accessapproval_v1/accessapproval_v1-library.html)

#### Access Context Manager API - `accesscontextmanager_v1`

An API for setting attribute based access control to requests to Google Cloud services.

- [Documentation](https://cloud.google.com/access-context-manager/docs/reference/rest/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/accesscontextmanager_v1/accesscontextmanager_v1-library.html)

#### ACME DNS API - `acmedns_v1`

Google Domains ACME DNS API that allows users to complete ACME DNS-01 challenges for a domain.

- [Documentation](https://developers.google.com/domains/acme-dns/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/acmedns_v1/acmedns_v1-library.html)

#### Ad Experience Report API - `adexperiencereport_v1`

Views Ad Experience Report data, and gets a list of sites that have a significant number of annoying ads.

- [Documentation](https://developers.google.com/ad-experience-report/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/adexperiencereport_v1/adexperiencereport_v1-library.html)

#### Admin SDK API - `admin_datatransfer_v1`

Admin SDK lets administrators of enterprise domains to view and manage resources like user, groups etc. It also provides audit and usage reports of domain.

- [Documentation](https://developers.google.com/admin-sdk/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/admin_datatransfer_v1/admin_datatransfer_v1-library.html)

#### Admin SDK API - `admin_directory_v1`

Admin SDK lets administrators of enterprise domains to view and manage resources like user, groups etc. It also provides audit and usage reports of domain.

- [Documentation](https://developers.google.com/admin-sdk/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/admin_directory_v1/admin_directory_v1-library.html)

#### Admin SDK API - `admin_reports_v1`

Admin SDK lets administrators of enterprise domains to view and manage resources like user, groups etc. It also provides audit and usage reports of domain.

- [Documentation](https://developers.google.com/admin-sdk/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/admin_reports_v1/admin_reports_v1-library.html)

#### AdMob API - `admob_v1`

The AdMob API allows publishers to programmatically get information about their AdMob account. 

- [Documentation](https://developers.google.com/admob/api/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/admob_v1/admob_v1-library.html)

#### AdSense Management API - `adsense_v2`

The AdSense Management API allows publishers to access their inventory and run earnings and performance reports.

- [Documentation](https://developers.google.com/adsense/management/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/adsense_v2/adsense_v2-library.html)

#### ![Logo](https://www.google.com/images/icons/product/adsense-16.png) AdSense Host API - `adsensehost_v4_1`

Generates performance reports, generates ad codes, and provides publisher management capabilities for AdSense Hosts.

- [Documentation](https://developers.google.com/adsense/host/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/adsensehost_v4_1/adsensehost_v4_1-library.html)

#### Advisory Notifications API - `advisorynotifications_v1`

An API for accessing Advisory Notifications in Google Cloud

- [Documentation](https://cloud.google.com/advisory-notifications)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/advisorynotifications_v1/advisorynotifications_v1-library.html)

#### Vertex AI API - `aiplatform_v1`

Train high-quality custom machine learning models with minimal machine learning expertise and effort.

- [Documentation](https://cloud.google.com/vertex-ai/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/aiplatform_v1/aiplatform_v1-library.html)

#### AlloyDB API - `alloydb_v1`

AlloyDB for PostgreSQL is an open source-compatible database service that provides a powerful option for migrating, modernizing, or building commercial-grade applications. It offers full compatibility with standard PostgreSQL, and is more than 4x faster for transactional workloads and up to 100x faster for analytical queries than standard PostgreSQL in our performance tests. AlloyDB for PostgreSQL offers a 99.99 percent availability SLA inclusive of maintenance. AlloyDB is optimized for the most demanding use cases, allowing you to build new applications that require high transaction throughput, large database sizes, or multiple read resources; scale existing PostgreSQL workloads with no application changes; and modernize legacy proprietary databases. 

- [Documentation](https://cloud.google.com/alloydb/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/alloydb_v1/alloydb_v1-library.html)

#### ![Logo](https://www.google.com/images/icons/product/analytics-16.png) Google Analytics API - `analytics_v3`

Views and manages your Google Analytics data.

- [Documentation](https://developers.google.com/analytics/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/analytics_v3/analytics_v3-library.html)

#### Analytics Hub API - `analyticshub_v1`

Exchange data and analytics assets securely and efficiently.

- [Documentation](https://cloud.google.com/bigquery/docs/analytics-hub-introduction)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/analyticshub_v1/analyticshub_v1-library.html)

#### Analytics Reporting API - `analyticsreporting_v4`

Accesses Analytics report data.

- [Documentation](https://developers.google.com/analytics/devguides/reporting/core/v4/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/analyticsreporting_v4/analyticsreporting_v4-library.html)

#### Android Device Provisioning Partner API - `androiddeviceprovisioning_v1`

Automates Android zero-touch enrollment for device resellers, customers, and EMMs.

- [Documentation](https://developers.google.com/zero-touch/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/androiddeviceprovisioning_v1/androiddeviceprovisioning_v1-library.html)

#### Google Play EMM API - `androidenterprise_v1`

Manages the deployment of apps to Android Enterprise devices.

- [Documentation](https://developers.google.com/android/work/play/emm-api)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/androidenterprise_v1/androidenterprise_v1-library.html)

#### Android Management API - `androidmanagement_v1`

The Android Management API provides remote enterprise management of Android devices and apps.

- [Documentation](https://developers.google.com/android/management)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/androidmanagement_v1/androidmanagement_v1-library.html)

#### Google Play Android Developer API - `androidpublisher_v3`

Lets Android application developers access their Google Play accounts. At a high level, the expected workflow is to "insert" an Edit, make changes as necessary, and then "commit" it. 

- [Documentation](https://developers.google.com/android-publisher)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/androidpublisher_v3/androidpublisher_v3-library.html)

#### API Gateway API - `apigateway_v1`

- [Documentation](https://cloud.google.com/api-gateway/docs)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/apigateway_v1/apigateway_v1-library.html)

#### Apigee API - `apigee_v1`

Use the Apigee API to programmatically develop and manage APIs with a set of RESTful operations. Develop and secure API proxies, deploy and undeploy API proxy revisions, monitor APIs, configure environments, manage users, and more. Note: This product is available as a free trial for a time period of 60 days.

- [Documentation](https://cloud.google.com/apigee-api-management/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/apigee_v1/apigee_v1-library.html)

#### Apigee Registry API - `apigeeregistry_v1`

- [Documentation](https://cloud.google.com/apigee/docs/api-hub/what-is-api-hub)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/apigeeregistry_v1/apigeeregistry_v1-library.html)

#### API Keys API - `apikeys_v2`

Manages the API keys associated with developer projects.

- [Documentation](https://cloud.google.com/api-keys/docs)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/apikeys_v2/apikeys_v2-library.html)

#### App Engine Admin API - `appengine_v1`

Provisions and manages developers' App Engine applications.

- [Documentation](https://cloud.google.com/appengine/docs/admin-api/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/appengine_v1/appengine_v1-library.html)

#### Artifact Registry API - `artifactregistry_v1`

Store and manage build artifacts in a scalable and integrated service built on Google infrastructure.

- [Documentation](https://cloud.google.com/artifacts/docs/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/artifactregistry_v1/artifactregistry_v1-library.html)

#### Assured Workloads API - `assuredworkloads_v1`

- [Documentation](https://cloud.google.com/learnmoreurl)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/assuredworkloads_v1/assuredworkloads_v1-library.html)

#### Authorized Buyers Marketplace API - `authorizedbuyersmarketplace_v1`

The Authorized Buyers Marketplace API lets buyers programmatically discover inventory; propose, retrieve and negotiate deals with publishers.

- [Documentation](https://developers.google.com/authorized-buyers/apis/marketplace/reference/rest/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/authorizedbuyersmarketplace_v1/authorizedbuyersmarketplace_v1-library.html)

#### Backup and DR Service API - `backupdr_v1`

- [Documentation](https://cloud.google.com/backup-disaster-recovery)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/backupdr_v1/backupdr_v1-library.html)

#### Bare Metal Solution API - `baremetalsolution_v2`

Provides ways to manage Bare Metal Solution hardware installed in a regional extension located near a Google Cloud data center.

- [Documentation](https://cloud.google.com/bare-metal)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/baremetalsolution_v2/baremetalsolution_v2-library.html)

#### Batch API - `batch_v1`

An API to manage the running of batch jobs on Google Cloud Platform.

- [Documentation](https://cloud.google.com/batch/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/batch_v1/batch_v1-library.html)

#### BeyondCorp API - `beyondcorp_v1`

Beyondcorp Enterprise provides identity and context aware access controls for enterprise resources and enables zero-trust access. Using the Beyondcorp Enterprise APIs, enterprises can set up multi-cloud and on-prem connectivity solutions.

- [Documentation](https://cloud.google.com/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/beyondcorp_v1/beyondcorp_v1-library.html)

#### BigLake API - `biglake_v1`

The BigLake API provides access to BigLake Metastore, a serverless, fully managed, and highly available metastore for open-source data that can be used for querying Apache Iceberg tables in BigQuery.

- [Documentation](https://cloud.google.com/bigquery/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/biglake_v1/biglake_v1-library.html)

#### ![Logo](https://www.google.com/images/icons/product/search-16.gif) BigQuery API - `bigquery_v2`

A data platform for customers to create, manage, share and query data.

- [Documentation](https://cloud.google.com/bigquery/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/bigquery_v2/bigquery_v2-library.html)

#### BigQuery Data Policy API - `bigquerydatapolicy_v1`

Allows users to manage BigQuery data policies.

- [Documentation](https://cloud.google.com/bigquery/docs/column-data-masking)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/bigquerydatapolicy_v1/bigquerydatapolicy_v1-library.html)

#### BigQuery Data Transfer API - `bigquerydatatransfer_v1`

Schedule queries or transfer external data from SaaS applications to Google BigQuery on a regular basis.

- [Documentation](https://cloud.google.com/bigquery-transfer/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/bigquerydatatransfer_v1/bigquerydatatransfer_v1-library.html)

#### BigQuery Reservation API - `bigqueryreservation_v1`

A service to modify your BigQuery flat-rate reservations.

- [Documentation](https://cloud.google.com/bigquery/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/bigqueryreservation_v1/bigqueryreservation_v1-library.html)

#### Cloud Bigtable Admin API - `bigtableadmin_v2`

Administer your Cloud Bigtable tables and instances.

- [Documentation](https://cloud.google.com/bigtable/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/bigtableadmin_v2/bigtableadmin_v2-library.html)

#### Cloud Billing Budget API - `billingbudgets_v1`

The Cloud Billing Budget API stores Cloud Billing budgets, which define a budget plan and the rules to execute as spend is tracked against that plan.

- [Documentation](https://cloud.google.com/billing/docs/how-to/budget-api-overview)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/billingbudgets_v1/billingbudgets_v1-library.html)

#### Binary Authorization API - `binaryauthorization_v1`

The management interface for Binary Authorization, a service that provides policy-based deployment validation and control for images deployed to Google Kubernetes Engine (GKE), Anthos Service Mesh, Anthos Clusters, and Cloud Run. 

- [Documentation](https://cloud.google.com/binary-authorization/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/binaryauthorization_v1/binaryauthorization_v1-library.html)

#### Blockchain Node Engine API - `blockchainnodeengine_v1`

- [Documentation](https://cloud.google.com/blockchain-node-engine)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/blockchainnodeengine_v1/blockchainnodeengine_v1-library.html)

#### Blogger API - `blogger_v3`

The Blogger API provides access to posts, comments and pages of a Blogger blog.

- [Documentation](https://developers.google.com/blogger/docs/3.0/getting_started)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/blogger_v3/blogger_v3-library.html)

#### Books API - `books_v1`

The Google Books API allows clients to access the Google Books repository.

- [Documentation](https://code.google.com/apis/books/docs/v1/getting_started.html)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/books_v1/books_v1-library.html)

#### Business Profile Performance API - `businessprofileperformance_v1`

The Business Profile Performance API allows merchants to fetch performance reports about their business profile on Google. Note - If you have a quota of 0 after enabling the API, please request for GBP API access.

- [Documentation](https://developers.google.com/my-business/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/businessprofileperformance_v1/businessprofileperformance_v1-library.html)

#### Calendar API - `calendar_v3`

Manipulates events and other calendar data.

- [Documentation](https://developers.google.com/google-apps/calendar/firstapp)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/calendar_v3/calendar_v3-library.html)

#### Certificate Manager API - `certificatemanager_v1`

- [Documentation](https://cloud.google.com/certificate-manager)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/certificatemanager_v1/certificatemanager_v1-library.html)

#### Google Chat API - `chat_v1`

Enables apps to fetch information and perform actions in Google Chat. Authentication is a prerequisite for using the Google Chat REST API.

- [Documentation](https://developers.google.com/hangouts/chat)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/chat_v1/chat_v1-library.html)

#### Chrome Management API - `chromemanagement_v1`

The Chrome Management API is a suite of services that allows Chrome administrators to view, manage and gain insights on their Chrome OS and Chrome Browser devices.

- [Documentation](https://developers.google.com/chrome/management/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/chromemanagement_v1/chromemanagement_v1-library.html)

#### Chrome Policy API - `chromepolicy_v1`

The Chrome Policy API is a suite of services that allows Chrome administrators to control the policies applied to their managed Chrome OS devices and Chrome browsers.

- [Documentation](https://developers.google.com/chrome/policy)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/chromepolicy_v1/chromepolicy_v1-library.html)

#### Chrome UX Report API - `chromeuxreport_v1`

The Chrome UX Report API lets you view real user experience data for millions of websites. 

- [Documentation](https://developers.google.com/web/tools/chrome-user-experience-report/api/reference)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/chromeuxreport_v1/chromeuxreport_v1-library.html)

#### Google Civic Information API - `civicinfo_v2`

Provides polling places, early vote locations, contest data, election officials, and government representatives for U.S. residential addresses.

- [Documentation](https://developers.google.com/civic-information/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/civicinfo_v2/civicinfo_v2-library.html)

#### Google Classroom API - `classroom_v1`

Manages classes, rosters, and invitations in Google Classroom.

- [Documentation](https://developers.google.com/classroom/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/classroom_v1/classroom_v1-library.html)

#### Cloud Asset API - `cloudasset_v1`

The Cloud Asset API manages the history and inventory of Google Cloud resources.

- [Documentation](https://cloud.google.com/asset-inventory/docs/quickstart)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/cloudasset_v1/cloudasset_v1-library.html)

#### Cloud Billing API - `cloudbilling_v1`

Allows developers to manage billing for their Google Cloud Platform projects programmatically.

- [Documentation](https://cloud.google.com/billing/docs/apis)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/cloudbilling_v1/cloudbilling_v1-library.html)

#### Cloud Build API - `cloudbuild_v1`

Creates and manages builds on Google Cloud Platform.

- [Documentation](https://cloud.google.com/cloud-build/docs/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/cloudbuild_v1/cloudbuild_v1-library.html)

#### Cloud Build API - `cloudbuild_v2`

Creates and manages builds on Google Cloud Platform.

- [Documentation](https://cloud.google.com/cloud-build/docs/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/cloudbuild_v2/cloudbuild_v2-library.html)

#### Cloud Channel API - `cloudchannel_v1`

The Cloud Channel API enables Google Cloud partners to have a single unified resale platform and APIs across all of Google Cloud including GCP, Workspace, Maps and Chrome.

- [Documentation](https://cloud.google.com/channel)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/cloudchannel_v1/cloudchannel_v1-library.html)

#### Cloud Deploy API - `clouddeploy_v1`

- [Documentation](https://cloud.google.com/deploy/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/clouddeploy_v1/clouddeploy_v1-library.html)

#### Cloud Functions API - `cloudfunctions_v1`

Manages lightweight user-provided functions executed in response to events.

- [Documentation](https://cloud.google.com/functions)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/cloudfunctions_v1/cloudfunctions_v1-library.html)

#### Cloud Functions API - `cloudfunctions_v2`

Manages lightweight user-provided functions executed in response to events.

- [Documentation](https://cloud.google.com/functions)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/cloudfunctions_v2/cloudfunctions_v2-library.html)

#### Cloud Identity API - `cloudidentity_v1`

API for provisioning and managing identity resources.

- [Documentation](https://cloud.google.com/identity/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/cloudidentity_v1/cloudidentity_v1-library.html)

#### Cloud Key Management Service (KMS) API - `cloudkms_v1`

Manages keys and performs cryptographic operations in a central cloud service, for direct use by other cloud resources and applications. 

- [Documentation](https://cloud.google.com/kms/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/cloudkms_v1/cloudkms_v1-library.html)

#### Cloud Profiler API - `cloudprofiler_v2`

Manages continuous profiling information.

- [Documentation](https://cloud.google.com/profiler/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/cloudprofiler_v2/cloudprofiler_v2-library.html)

#### Cloud Resource Manager API - `cloudresourcemanager_v1`

Creates, reads, and updates metadata for Google Cloud Platform resource containers.

- [Documentation](https://cloud.google.com/resource-manager)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/cloudresourcemanager_v1/cloudresourcemanager_v1-library.html)

#### Cloud Resource Manager API - `cloudresourcemanager_v2`

Creates, reads, and updates metadata for Google Cloud Platform resource containers.

- [Documentation](https://cloud.google.com/resource-manager)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/cloudresourcemanager_v2/cloudresourcemanager_v2-library.html)

#### Cloud Resource Manager API - `cloudresourcemanager_v3`

Creates, reads, and updates metadata for Google Cloud Platform resource containers.

- [Documentation](https://cloud.google.com/resource-manager)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/cloudresourcemanager_v3/cloudresourcemanager_v3-library.html)

#### Cloud Scheduler API - `cloudscheduler_v1`

Creates and manages jobs run on a regular recurring schedule.

- [Documentation](https://cloud.google.com/scheduler/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/cloudscheduler_v1/cloudscheduler_v1-library.html)

#### Cloud Search API - `cloudsearch_v1`

Cloud Search provides cloud-based search capabilities over Google Workspace data. The Cloud Search API allows indexing of non-Google Workspace data into Cloud Search.

- [Documentation](https://developers.google.com/cloud-search/docs/guides/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/cloudsearch_v1/cloudsearch_v1-library.html)

#### Cloud Shell API - `cloudshell_v1`

Allows users to start, configure, and connect to interactive shell sessions running in the cloud. 

- [Documentation](https://cloud.google.com/shell/docs/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/cloudshell_v1/cloudshell_v1-library.html)

#### Google Cloud Support API - `cloudsupport_v2`

Manages Google Cloud technical support cases for Customer Care support offerings. 

- [Documentation](https://cloud.google.com/support/docs/apis)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/cloudsupport_v2/cloudsupport_v2-library.html)

#### Cloud Tasks API - `cloudtasks_v2`

Manages the execution of large numbers of distributed requests.

- [Documentation](https://cloud.google.com/tasks/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/cloudtasks_v2/cloudtasks_v2-library.html)

#### Cloud Trace API - `cloudtrace_v2`

Sends application trace data to Cloud Trace for viewing. Trace data is collected for all App Engine applications by default. Trace data from other applications can be provided using this API. This library is used to interact with the Cloud Trace API directly. If you are looking to instrument your application for Cloud Trace, we recommend using OpenTelemetry. 

- [Documentation](https://cloud.google.com/trace)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/cloudtrace_v2/cloudtrace_v2-library.html)

#### Cloud Composer API - `composer_v1`

Manages Apache Airflow environments on Google Cloud Platform.

- [Documentation](https://cloud.google.com/composer/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/composer_v1/composer_v1-library.html)

#### ![Logo](https://www.google.com/images/icons/product/compute_engine-16.png) Compute Engine API - `compute_v1`

Creates and runs virtual machines on Google Cloud Platform. 

- [Documentation](https://cloud.google.com/compute/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/compute_v1/compute_v1-library.html)

#### Connectors API - `connectors_v1`

Enables users to create and manage connections to Google Cloud services and third-party business applications using the Connectors interface.

- [Documentation](https://cloud.google.com/apigee/docs/api-platform/connectors/about-connectors)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/connectors_v1/connectors_v1-library.html)

#### Connectors API - `connectors_v2`

Enables users to create and manage connections to Google Cloud services and third-party business applications using the Connectors interface.

- [Documentation](https://cloud.google.com/apigee/docs/api-platform/connectors/about-connectors)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/connectors_v2/connectors_v2-library.html)

#### Contact Center AI Insights API - `contactcenterinsights_v1`

- [Documentation](https://cloud.google.com/contact-center/insights/docs)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/contactcenterinsights_v1/contactcenterinsights_v1-library.html)

#### Kubernetes Engine API - `container_v1`

Builds and manages container-based applications, powered by the open source Kubernetes technology.

- [Documentation](https://cloud.google.com/container-engine/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/container_v1/container_v1-library.html)

#### Container Analysis API - `containeranalysis_v1`

This API is a prerequisite for leveraging Artifact Analysis scanning capabilities in both Artifact Registry and with Advanced Vulnerability Insights (runtime scanning) in GKE. In addition, the Container Analysis API is an implementation of the Grafeas API, which enables storing, querying, and retrieval of critical metadata about all of your software artifacts.

- [Documentation](https://cloud.google.com/container-analysis/api/reference/rest/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/containeranalysis_v1/containeranalysis_v1-library.html)

#### Content API for Shopping - `content_v2_1`

Manage your product listings and accounts for Google Shopping

- [Documentation](https://developers.google.com/shopping-content/v2/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/content_v2_1/content_v2_1-library.html)

#### Document AI Warehouse API - `contentwarehouse_v1`

- [Documentation](https://cloud.google.com/document-warehouse)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/contentwarehouse_v1/contentwarehouse_v1-library.html)

#### Custom Search API - `customsearch_v1`

Searches over a website or collection of websites

- [Documentation](https://developers.google.com/custom-search/v1/introduction)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/customsearch_v1/customsearch_v1-library.html)

#### Google Cloud Data Catalog API - `datacatalog_v1`

A fully managed and highly scalable data discovery and metadata management service. 

- [Documentation](https://cloud.google.com/data-catalog/docs/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/datacatalog_v1/datacatalog_v1-library.html)

#### Cloud Data Fusion API - `datafusion_v1`

Cloud Data Fusion is a fully-managed, cloud native, enterprise data integration service for quickly building and managing data pipelines. It provides a graphical interface to increase time efficiency and reduce complexity, and allows business users, developers, and data scientists to easily and reliably build scalable data integration solutions to cleanse, prepare, blend, transfer and transform data without having to wrestle with infrastructure.

- [Documentation](https://cloud.google.com/data-fusion/docs)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/datafusion_v1/datafusion_v1-library.html)

#### Data Lineage API - `datalineage_v1`

- [Documentation](https://cloud.google.com/data-catalog)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/datalineage_v1/datalineage_v1-library.html)

#### Database Migration API - `datamigration_v1`

Manage Cloud Database Migration Service resources on Google Cloud Platform.

- [Documentation](https://cloud.google.com/database-migration/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/datamigration_v1/datamigration_v1-library.html)

#### Data pipelines API - `datapipelines_v1`

Data Pipelines provides an interface for creating, updating, and managing recurring Data Analytics jobs.

- [Documentation](https://cloud.google.com/dataflow/docs/guides/data-pipelines)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/datapipelines_v1/datapipelines_v1-library.html)

#### Cloud Dataplex API - `dataplex_v1`

Dataplex API is used to manage the lifecycle of data lakes.

- [Documentation](https://cloud.google.com/dataplex/docs)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/dataplex_v1/dataplex_v1-library.html)

#### Cloud Dataproc API - `dataproc_v1`

Manages Hadoop-based clusters and jobs on Google Cloud Platform.

- [Documentation](https://cloud.google.com/dataproc/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/dataproc_v1/dataproc_v1-library.html)

#### Cloud Datastore API - `datastore_v1`

Accesses the schemaless NoSQL database to provide fully managed, robust, scalable storage for your application. 

- [Documentation](https://cloud.google.com/datastore/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/datastore_v1/datastore_v1-library.html)

#### Datastream API - `datastream_v1`

- [Documentation](https://cloud.google.com/datastream/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/datastream_v1/datastream_v1-library.html)

#### Cloud Deployment Manager V2 API - `deploymentmanager_v2`

The Google Cloud Deployment Manager v2 API provides services for configuring, deploying, and viewing Google Cloud services and APIs via templates which specify deployments of Cloud resources.

- [Documentation](https://cloud.google.com/deployment-manager)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/deploymentmanager_v2/deploymentmanager_v2-library.html)

#### Campaign Manager 360 API - `dfareporting_v3_5`

Build applications to efficiently manage large or complex trafficking, reporting, and attribution workflows for Campaign Manager 360.

- [Documentation](https://developers.google.com/doubleclick-advertisers/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/dfareporting_v3_5/dfareporting_v3_5-library.html)

#### Campaign Manager 360 API - `dfareporting_v4`

Build applications to efficiently manage large or complex trafficking, reporting, and attribution workflows for Campaign Manager 360.

- [Documentation](https://developers.google.com/doubleclick-advertisers/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/dfareporting_v4/dfareporting_v4-library.html)

#### Dialogflow API - `dialogflow_v2`

Builds conversational interfaces (for example, chatbots, and voice-powered apps and devices).

- [Documentation](https://cloud.google.com/dialogflow/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/dialogflow_v2/dialogflow_v2-library.html)

#### Dialogflow API - `dialogflow_v3`

Builds conversational interfaces (for example, chatbots, and voice-powered apps and devices).

- [Documentation](https://cloud.google.com/dialogflow/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/dialogflow_v3/dialogflow_v3-library.html)

#### Digital Asset Links API - `digitalassetlinks_v1`

Discovers relationships between online assets such as websites or mobile apps.

- [Documentation](https://developers.google.com/digital-asset-links/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/digitalassetlinks_v1/digitalassetlinks_v1-library.html)

#### API Discovery Service - `discovery_v1`

Provides information about other Google APIs, such as what APIs are available, the resource, and method details for each API.

- [Documentation](https://developers.google.com/discovery/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/discovery_v1/discovery_v1-library.html)

#### Display & Video 360 API - `displayvideo_v1`

Display & Video 360 API allows users to automate complex Display & Video 360 workflows, such as creating insertion orders and setting targeting options for individual line items.

- [Documentation](https://developers.google.com/display-video/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/displayvideo_v1/displayvideo_v1-library.html)

#### Display & Video 360 API - `displayvideo_v2`

Display & Video 360 API allows users to automate complex Display & Video 360 workflows, such as creating insertion orders and setting targeting options for individual line items.

- [Documentation](https://developers.google.com/display-video/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/displayvideo_v2/displayvideo_v2-library.html)

#### Display & Video 360 API - `displayvideo_v3`

Display & Video 360 API allows users to automate complex Display & Video 360 workflows, such as creating insertion orders and setting targeting options for individual line items.

- [Documentation](https://developers.google.com/display-video/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/displayvideo_v3/displayvideo_v3-library.html)

#### Cloud Data Loss Prevention (DLP) - `dlp_v2`

Provides methods for detection, risk analysis, and de-identification of privacy-sensitive fragments in text, images, and Google Cloud Platform storage repositories.

- [Documentation](https://cloud.google.com/dlp/docs/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/dlp_v2/dlp_v2-library.html)

#### Cloud DNS API - `dns_v1`

- [Documentation](https://cloud.google.com/dns/docs)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/dns_v1/dns_v1-library.html)

#### Google Docs API - `docs_v1`

Reads and writes Google Docs documents.

- [Documentation](https://developers.google.com/docs/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/docs_v1/docs_v1-library.html)

#### Cloud Document AI API - `documentai_v1`

Service to parse structured information from unstructured or semi-structured documents using state-of-the-art Google AI such as natural language, computer vision, translation, and AutoML.

- [Documentation](https://cloud.google.com/document-ai/docs/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/documentai_v1/documentai_v1-library.html)

#### Cloud Domains API - `domains_v1`

Enables management and configuration of domain names.

- [Documentation](https://cloud.google.com/domains/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/domains_v1/domains_v1-library.html)

#### Domains RDAP API - `domainsrdap_v1`

Read-only public API that lets users search for information about domain names.

- [Documentation](https://developers.google.com/domains/rdap/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/domainsrdap_v1/domainsrdap_v1-library.html)

#### DoubleClick Bid Manager API - `doubleclickbidmanager_v2`

DoubleClick Bid Manager API allows users to manage and create campaigns and reports.

- [Documentation](https://developers.google.com/bid-manager/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/doubleclickbidmanager_v2/doubleclickbidmanager_v2-library.html)

#### Search Ads 360 API - `doubleclicksearch_v2`

The Search Ads 360 API allows developers to automate uploading conversions and downloading reports from Search Ads 360.

- [Documentation](https://developers.google.com/search-ads)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/doubleclicksearch_v2/doubleclicksearch_v2-library.html)

#### Google Drive API - `drive_v2`

The Google Drive API allows clients to access resources from Google Drive.

- [Documentation](https://developers.google.com/drive/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/drive_v2/drive_v2-library.html)

#### Google Drive API - `drive_v3`

The Google Drive API allows clients to access resources from Google Drive.

- [Documentation](https://developers.google.com/drive/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/drive_v3/drive_v3-library.html)

#### Drive Activity API - `driveactivity_v2`

Provides a historical view of activity in Google Drive.

- [Documentation](https://developers.google.com/drive/activity/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/driveactivity_v2/driveactivity_v2-library.html)

#### Drive Labels API - `drivelabels_v2`

An API for managing Drive Labels

- [Documentation](https://developers.google.com/drive/labels)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/drivelabels_v2/drivelabels_v2-library.html)

#### Essential Contacts API - `essentialcontacts_v1`

- [Documentation](https://cloud.google.com/essentialcontacts/docs/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/essentialcontacts_v1/essentialcontacts_v1-library.html)

#### Eventarc API - `eventarc_v1`

Build event-driven applications on Google Cloud Platform.

- [Documentation](https://cloud.google.com/eventarc)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/eventarc_v1/eventarc_v1-library.html)

#### Firebase Cloud Messaging API - `fcm_v1`

FCM send API that provides a cross-platform messaging solution to reliably deliver messages at no cost.

- [Documentation](https://firebase.google.com/docs/cloud-messaging)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/fcm_v1/fcm_v1-library.html)

#### Cloud Filestore API - `file_v1`

The Cloud Filestore API is used for creating and managing cloud file servers.

- [Documentation](https://cloud.google.com/filestore/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/file_v1/file_v1-library.html)

#### Firebase App Check API - `firebaseappcheck_v1`

Firebase App Check works alongside other Firebase services to help protect your backend resources from abuse, such as billing fraud or phishing.

- [Documentation](https://firebase.google.com/docs/app-check)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/firebaseappcheck_v1/firebaseappcheck_v1-library.html)

#### Firebase App Distribution API - `firebaseappdistribution_v1`

- [Documentation](https://firebase.google.com/products/app-distribution)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/firebaseappdistribution_v1/firebaseappdistribution_v1-library.html)

#### Firebase Dynamic Links API - `firebasedynamiclinks_v1`

Programmatically creates and manages Firebase Dynamic Links.

- [Documentation](https://firebase.google.com/docs/dynamic-links/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/firebasedynamiclinks_v1/firebasedynamiclinks_v1-library.html)

#### Firebase Hosting API - `firebasehosting_v1`

The Firebase Hosting REST API enables programmatic and customizable management and deployments to your Firebase-hosted sites. Use this REST API to create and manage channels and sites as well as to deploy new or updated hosting configurations and content files.

- [Documentation](https://firebase.google.com/docs/hosting/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/firebasehosting_v1/firebasehosting_v1-library.html)

#### Firebase ML API - `firebaseml_v1`

Access custom machine learning models hosted via Firebase ML.

- [Documentation](https://firebase.google.com)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/firebaseml_v1/firebaseml_v1-library.html)

#### Firebase Remote Config API - `firebaseremoteconfig_v1`

The Firebase Remote Config API lets developers change the behavior and appearance of their apps without requiring users to download an app update. It is an alternative to, but can be used in tandem with, the Firebase console at https://console.firebase.google.com.

- [Documentation](https://firebase.google.com/docs/remote-config/use-config-rest)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/firebaseremoteconfig_v1/firebaseremoteconfig_v1-library.html)

#### Firebase Rules API - `firebaserules_v1`

Creates and manages rules that determine when a Firebase Rules-enabled service should permit a request. 

- [Documentation](https://firebase.google.com/docs/storage/security)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/firebaserules_v1/firebaserules_v1-library.html)

#### Cloud Firestore API - `firestore_v1`

Accesses the NoSQL document database built for automatic scaling, high performance, and ease of application development. 

- [Documentation](https://cloud.google.com/firestore)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/firestore_v1/firestore_v1-library.html)

#### Fitness API - `fitness_v1`

The Fitness API for managing users' fitness tracking data.

- [Documentation](https://developers.google.com/fit/rest/v1/get-started)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/fitness_v1/fitness_v1-library.html)

#### Google Forms API - `forms_v1`

Reads and writes Google Forms and responses.

- [Documentation](https://developers.google.com/forms/api)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/forms_v1/forms_v1-library.html)

#### Google Play Game Services - `games_v1`

The Google Play games service allows developers to enhance games with social leaderboards, achievements, game state, sign-in with Google, and more.

- [Documentation](https://developers.google.com/games/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/games_v1/games_v1-library.html)

#### Google Play Game Services Publishing API - `gamesconfiguration_v1configuration`

The Google Play Game Services Publishing API allows developers to configure their games in Game Services.

- [Documentation](https://developers.google.com/games/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/gamesconfiguration_v1configuration/gamesconfiguration_v1configuration-library.html)

#### Google Play Game Management - `gamesmanagement_v1management`

The Google Play Game Management API allows developers to manage resources from the Google Play Game service.

- [Documentation](https://developers.google.com/games/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/gamesmanagement_v1management/gamesmanagement_v1management-library.html)

#### Backup for GKE API - `gkebackup_v1`

Backup for GKE is a managed Kubernetes workload backup and restore service for GKE clusters.

- [Documentation](https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/gkebackup_v1/gkebackup_v1-library.html)

#### GKE Hub API - `gkehub_v1`

- [Documentation](https://cloud.google.com/anthos/multicluster-management/connect/registering-a-cluster)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/gkehub_v1/gkehub_v1-library.html)

#### Anthos On-Prem API - `gkeonprem_v1`

- [Documentation](https://cloud.google.com/anthos/clusters/docs/on-prem/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/gkeonprem_v1/gkeonprem_v1-library.html)

#### Gmail API - `gmail_v1`

The Gmail API lets you view and manage Gmail mailbox data like threads, messages, and labels.

- [Documentation](https://developers.google.com/gmail/api/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/gmail_v1/gmail_v1-library.html)

#### Gmail Postmaster Tools API - `gmailpostmastertools_v1`

The Postmaster Tools API is a RESTful API that provides programmatic access to email traffic metrics (like spam reports, delivery errors etc) otherwise available through the Gmail Postmaster Tools UI currently.

- [Documentation](https://developers.google.com/gmail/postmaster)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/gmailpostmastertools_v1/gmailpostmastertools_v1-library.html)

#### Groups Migration API - `groupsmigration_v1`

The Groups Migration API allows domain administrators to archive emails into Google groups.

- [Documentation](https://developers.google.com/google-apps/groups-migration/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/groupsmigration_v1/groupsmigration_v1-library.html)

#### ![Logo](https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png) Groups Settings API - `groupssettings_v1`

Manages permission levels and related settings of a group.

- [Documentation](https://developers.google.com/google-apps/groups-settings/get_started)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/groupssettings_v1/groupssettings_v1-library.html)

#### Cloud Healthcare API - `healthcare_v1`

Manage, store, and access healthcare data in Google Cloud Platform.

- [Documentation](https://cloud.google.com/healthcare)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/healthcare_v1/healthcare_v1-library.html)

#### HomeGraph API - `homegraph_v1`

- [Documentation](https://developers.home.google.com/cloud-to-cloud/get-started)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/homegraph_v1/homegraph_v1-library.html)

#### Identity and Access Management (IAM) API - `iam_v1`

Manages identity and access control for Google Cloud Platform resources, including the creation of service accounts, which you can use to authenticate to Google and make API calls. 

- [Documentation](https://cloud.google.com/iam/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/iam_v1/iam_v1-library.html)

#### Identity and Access Management (IAM) API - `iam_v2`

Manages identity and access control for Google Cloud Platform resources, including the creation of service accounts, which you can use to authenticate to Google and make API calls. 

- [Documentation](https://cloud.google.com/iam/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/iam_v2/iam_v2-library.html)

#### IAM Service Account Credentials API - `iamcredentials_v1`

Creates short-lived credentials for impersonating IAM service accounts. To enable this API, you must enable the IAM API (iam.googleapis.com). 

- [Documentation](https://cloud.google.com/iam/docs/creating-short-lived-service-account-credentials)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/iamcredentials_v1/iamcredentials_v1-library.html)

#### Cloud Identity-Aware Proxy API - `iap_v1`

Controls access to cloud applications running on Google Cloud Platform.

- [Documentation](https://cloud.google.com/iap)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/iap_v1/iap_v1-library.html)

#### Identity Toolkit API - `identitytoolkit_v1`

The Google Identity Toolkit API lets you use open standards to verify a user's identity.

- [Documentation](https://cloud.google.com/identity-platform)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/identitytoolkit_v1/identitytoolkit_v1-library.html)

#### Identity Toolkit API - `identitytoolkit_v2`

The Google Identity Toolkit API lets you use open standards to verify a user's identity.

- [Documentation](https://cloud.google.com/identity-platform)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/identitytoolkit_v2/identitytoolkit_v2-library.html)

#### ![Logo](https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png) Google Identity Toolkit API - `identitytoolkit_v3`

Help the third party sites to implement federated login.

- [Documentation](https://developers.google.com/identity-toolkit/v3/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/identitytoolkit_v3/identitytoolkit_v3-library.html)

#### Cloud IDS API - `ids_v1`

Cloud IDS (Cloud Intrusion Detection System) detects malware, spyware, command-and-control attacks, and other network-based threats. Its security efficacy is industry leading, built with Palo Alto Networks technologies. When you use this product, your organization name and consumption levels will be shared with Palo Alto Networks.

- [Documentation](https://cloud.google.com/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/ids_v1/ids_v1-library.html)

#### Web Search Indexing API - `indexing_v3`

Notifies Google Web Search when your web pages change.

- [Documentation](https://developers.google.com/search/apis/indexing-api/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/indexing_v3/indexing_v3-library.html)

#### Cloud Talent Solution API - `jobs_v3`

Cloud Talent Solution provides the capability to create, read, update, and delete job postings, as well as search jobs based on keywords and filters. 

- [Documentation](https://cloud.google.com/talent-solution/job-search/docs/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/jobs_v3/jobs_v3-library.html)

#### Cloud Talent Solution API - `jobs_v4`

Cloud Talent Solution provides the capability to create, read, update, and delete job postings, as well as search jobs based on keywords and filters. 

- [Documentation](https://cloud.google.com/talent-solution/job-search/docs/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/jobs_v4/jobs_v4-library.html)

#### Google Keep API - `keep_v1`

The Google Keep API is used in an enterprise environment to manage Google Keep content and resolve issues identified by cloud security software.

- [Documentation](https://developers.google.com/keep/api)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/keep_v1/keep_v1-library.html)

#### Knowledge Graph Search API - `kgsearch_v1`

Searches the Google Knowledge Graph for entities.

- [Documentation](https://developers.google.com/knowledge-graph/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/kgsearch_v1/kgsearch_v1-library.html)

#### KMS Inventory API - `kmsinventory_v1`

- [Documentation](https://cloud.google.com/kms/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/kmsinventory_v1/kmsinventory_v1-library.html)

#### Cloud Natural Language API - `language_v1`

Provides natural language understanding technologies, such as sentiment analysis, entity recognition, entity sentiment analysis, and other text annotations, to developers.

- [Documentation](https://cloud.google.com/natural-language/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/language_v1/language_v1-library.html)

#### Cloud Natural Language API - `language_v2`

Provides natural language understanding technologies, such as sentiment analysis, entity recognition, entity sentiment analysis, and other text annotations, to developers.

- [Documentation](https://cloud.google.com/natural-language/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/language_v2/language_v2-library.html)

#### Library Agent API - `libraryagent_v1`

A simple Google Example Library API.

- [Documentation](https://cloud.google.com/docs/quota)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/libraryagent_v1/libraryagent_v1-library.html)

#### Enterprise License Manager API - `licensing_v1`

The Google Enterprise License Manager API lets you manage Google Workspace and related licenses for all users of a customer that you manage.

- [Documentation](https://developers.google.com/admin-sdk/licensing/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/licensing_v1/licensing_v1-library.html)

#### Local Services API - `localservices_v1`

- [Documentation](https://ads.google.com/local-services-ads/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/localservices_v1/localservices_v1-library.html)

#### Cloud Logging API - `logging_v2`

Writes log entries and manages your Cloud Logging configuration.

- [Documentation](https://cloud.google.com/logging/docs/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/logging_v2/logging_v2-library.html)

#### Looker (Google Cloud core) API - `looker_v1`

- [Documentation](https://cloud.google.com/looker/docs/reference/rest/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/looker_v1/looker_v1-library.html)

#### Managed Service for Microsoft Active Directory API - `managedidentities_v1`

The Managed Service for Microsoft Active Directory API is used for managing a highly available, hardened service running Microsoft Active Directory (AD).

- [Documentation](https://cloud.google.com/managed-microsoft-ad/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/managedidentities_v1/managedidentities_v1-library.html)

#### Manufacturer Center API - `manufacturers_v1`

Public API for managing Manufacturer Center related data.

- [Documentation](https://developers.google.com/manufacturers/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/manufacturers_v1/manufacturers_v1-library.html)

#### Cloud Memorystore for Memcached API - `memcache_v1`

Google Cloud Memorystore for Memcached API is used for creating and managing Memcached instances in GCP.

- [Documentation](https://cloud.google.com/memorystore/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/memcache_v1/memcache_v1-library.html)

#### Dataproc Metastore API - `metastore_v1`

The Dataproc Metastore API is used to manage the lifecycle and configuration of metastore services.

- [Documentation](https://cloud.google.com/dataproc-metastore/docs)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/metastore_v1/metastore_v1-library.html)

#### Migration Center API - `migrationcenter_v1`

A unified platform that helps you accelerate your end-to-end cloud journey from your current on-premises or cloud environments to Google Cloud.

- [Documentation](https://cloud.google.com/migration-center)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/migrationcenter_v1/migrationcenter_v1-library.html)

#### AI Platform Training & Prediction API - `ml_v1`

An API to enable creating and using machine learning models.

- [Documentation](https://cloud.google.com/ml/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/ml_v1/ml_v1-library.html)

#### Cloud Monitoring API - `monitoring_v3`

Manages your Cloud Monitoring data and configurations.

- [Documentation](https://cloud.google.com/monitoring/api/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/monitoring_v3/monitoring_v3-library.html)

#### My Business Account Management API - `mybusinessaccountmanagement_v1`

The My Business Account Management API provides an interface for managing access to a location on Google. Note - If you have a quota of 0 after enabling the API, please request for GBP API access.

- [Documentation](https://developers.google.com/my-business/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/mybusinessaccountmanagement_v1/mybusinessaccountmanagement_v1-library.html)

#### My Business Business Information API - `mybusinessbusinessinformation_v1`

The My Business Business Information API provides an interface for managing business information. Note - If you have a quota of 0 after enabling the API, please request for GBP API access.

- [Documentation](https://developers.google.com/my-business/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/mybusinessbusinessinformation_v1/mybusinessbusinessinformation_v1-library.html)

#### My Business Lodging API - `mybusinesslodging_v1`

The My Business Lodging API enables managing lodging business information on Google. Note - If you have a quota of 0 after enabling the API, please request for GBP API access.

- [Documentation](https://developers.google.com/my-business/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/mybusinesslodging_v1/mybusinesslodging_v1-library.html)

#### My Business Notifications API - `mybusinessnotifications_v1`

The My Business Notification Settings API enables managing notification settings for business accounts. Note - If you have a quota of 0 after enabling the API, please request for GBP API access.

- [Documentation](https://developers.google.com/my-business/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/mybusinessnotifications_v1/mybusinessnotifications_v1-library.html)

#### My Business Place Actions API - `mybusinessplaceactions_v1`

The My Business Place Actions API provides an interface for managing place action links of a location on Google. Note - If you have a quota of 0 after enabling the API, please request for GBP API access.

- [Documentation](https://developers.google.com/my-business/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/mybusinessplaceactions_v1/mybusinessplaceactions_v1-library.html)

#### My Business Q&A API - `mybusinessqanda_v1`

The My Business Q&A API allows questions and answers to be posted for specific listings. Note - If you have a quota of 0 after enabling the API, please request for GBP API access.

- [Documentation](https://developers.google.com/my-business/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/mybusinessqanda_v1/mybusinessqanda_v1-library.html)

#### My Business Verifications API - `mybusinessverifications_v1`

The My Business Verifications API provides an interface for taking verifications related actions for locations.

- [Documentation](https://developers.google.com/my-business/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/mybusinessverifications_v1/mybusinessverifications_v1-library.html)

#### Network Connectivity API - `networkconnectivity_v1`

This API enables connectivity with and between Google Cloud resources.

- [Documentation](https://cloud.google.com/network-connectivity/docs/reference/networkconnectivity/rest)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/networkconnectivity_v1/networkconnectivity_v1-library.html)

#### Network Management API - `networkmanagement_v1`

The Network Management API provides a collection of network performance monitoring and diagnostic capabilities.

- [Documentation](https://cloud.google.com/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/networkmanagement_v1/networkmanagement_v1-library.html)

#### Network Security API - `networksecurity_v1`

- [Documentation](https://cloud.google.com/networking)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/networksecurity_v1/networksecurity_v1-library.html)

#### Network Services API - `networkservices_v1`

- [Documentation](https://cloud.google.com/networking)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/networkservices_v1/networkservices_v1-library.html)

#### Notebooks API - `notebooks_v1`

Notebooks API is used to manage notebook resources in Google Cloud.

- [Documentation](https://cloud.google.com/notebooks/docs/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/notebooks_v1/notebooks_v1-library.html)

#### Notebooks API - `notebooks_v2`

Notebooks API is used to manage notebook resources in Google Cloud.

- [Documentation](https://cloud.google.com/notebooks/docs/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/notebooks_v2/notebooks_v2-library.html)

#### ![Logo](https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png) Google OAuth2 API - `oauth2_v2`

Obtains end-user authorization grants for use with other Google APIs.

- [Documentation](https://developers.google.com/identity/protocols/oauth2/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/oauth2_v2/oauth2_v2-library.html)

#### On-Demand Scanning API - `ondemandscanning_v1`

A service to scan container images for vulnerabilities.

- [Documentation](https://cloud.google.com/container-analysis/docs/on-demand-scanning/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/ondemandscanning_v1/ondemandscanning_v1-library.html)

#### Organization Policy API - `orgpolicy_v2`

The Organization Policy API allows users to configure governance rules on their Google Cloud resources across the resource hierarchy.

- [Documentation](https://cloud.google.com/orgpolicy/docs/reference/rest/index.html)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/orgpolicy_v2/orgpolicy_v2-library.html)

#### OS Config API - `osconfig_v1`

OS management tools that can be used for patch management, patch compliance, and configuration management on VM instances.

- [Documentation](https://cloud.google.com/compute/docs/osconfig/rest)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/osconfig_v1/osconfig_v1-library.html)

#### Cloud OS Login API - `oslogin_v1`

You can use OS Login to manage access to your VM instances using IAM roles.

- [Documentation](https://cloud.google.com/compute/docs/oslogin/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/oslogin_v1/oslogin_v1-library.html)

#### PageSpeed Insights API - `pagespeedonline_v5`

The PageSpeed Insights API lets you analyze the performance of your website with a simple API. It offers tailored suggestions for how you can optimize your site, and lets you easily integrate PageSpeed Insights analysis into your development tools and workflow. 

- [Documentation](https://developers.google.com/speed/docs/insights/v5/about)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/pagespeedonline_v5/pagespeedonline_v5-library.html)

#### Payments Reseller Subscription API - `paymentsresellersubscription_v1`

- [Documentation](https://developers.google.com/payments/reseller/subscription/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/paymentsresellersubscription_v1/paymentsresellersubscription_v1-library.html)

#### People API - `people_v1`

Provides access to information about profiles and contacts.

- [Documentation](https://developers.google.com/people/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/people_v1/people_v1-library.html)

#### Photos Library API - `photoslibrary_v1`

Manage photos, videos, and albums in Google Photos 

- [Documentation](https://developers.google.com/photos/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/photoslibrary_v1/photoslibrary_v1-library.html)

#### Places API (New) - `places_v1`

- [Documentation](https://mapsplatform.google.com/maps-products/#places-section)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/places_v1/places_v1-library.html)

#### Google Play Custom App Publishing API - `playcustomapp_v1`

API to create and publish custom Android apps

- [Documentation](https://developers.google.com/android/work/play/custom-app-api/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/playcustomapp_v1/playcustomapp_v1-library.html)

#### Google Play Integrity API - `playintegrity_v1`

The Play Integrity API helps you check that you're interacting with your genuine app on a genuine Android device powered by Google Play services. The Play Integrity API has replaced SafetyNet Attestation and Android Device Verification.

- [Documentation](https://developer.android.com/google/play/integrity)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/playintegrity_v1/playintegrity_v1-library.html)

#### Policy Analyzer API - `policyanalyzer_v1`

- [Documentation](https://www.google.com)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/policyanalyzer_v1/policyanalyzer_v1-library.html)

#### Policy Simulator API - `policysimulator_v1`

 Policy Simulator is a collection of endpoints for creating, running, and viewing a Replay. A `Replay` is a type of simulation that lets you see how your members' access to resources might change if you changed your IAM policy. During a `Replay`, Policy Simulator re-evaluates, or replays, past access attempts under both the current policy and your proposed policy, and compares those results to determine how your members' access might change under the proposed policy.

- [Documentation](https://cloud.google.com/iam/docs/simulating-access)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/policysimulator_v1/policysimulator_v1-library.html)

#### Policy Troubleshooter API - `policytroubleshooter_v1`

- [Documentation](https://cloud.google.com/iam/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/policytroubleshooter_v1/policytroubleshooter_v1-library.html)

#### Certificate Authority API - `privateca_v1`

The Certificate Authority Service API is a highly-available, scalable service that enables you to simplify and automate the management of private certificate authorities (CAs) while staying in control of your private keys. 

- [Documentation](https://cloud.google.com/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/privateca_v1/privateca_v1-library.html)

#### Public Certificate Authority API - `publicca_v1`

The Public Certificate Authority API may be used to create and manage ACME external account binding keys associated with Google Trust Services' publicly trusted certificate authority. 

- [Documentation](https://cloud.google.com/public-certificate-authority/docs)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/publicca_v1/publicca_v1-library.html)

#### Cloud Pub/Sub API - `pubsub_v1`

Provides reliable, many-to-many, asynchronous messaging between applications. 

- [Documentation](https://cloud.google.com/pubsub/docs)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/pubsub_v1/pubsub_v1-library.html)

#### Pub/Sub Lite API - `pubsublite_v1`

- [Documentation](https://cloud.google.com/pubsub/lite/docs)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/pubsublite_v1/pubsublite_v1-library.html)

#### Rapid Migration Assessment API - `rapidmigrationassessment_v1`

The Rapid Migration Assessment service is our first-party migration assessment and planning tool.

- [Documentation](https://cloud.google.com/migration-center)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/rapidmigrationassessment_v1/rapidmigrationassessment_v1-library.html)

#### Reader Revenue Subscription Linking API - `readerrevenuesubscriptionlinking_v1`

readerrevenuesubscriptionlinking.googleapis.com API.

- [Documentation](https://developers.google.com/news/subscribe/subscription-linking/overview)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/readerrevenuesubscriptionlinking_v1/readerrevenuesubscriptionlinking_v1-library.html)

#### Real-time Bidding API - `realtimebidding_v1`

Allows external bidders to manage their RTB integration with Google. This includes managing bidder endpoints, QPS quotas, configuring what ad inventory to receive via pretargeting, submitting creatives for verification, and accessing creative metadata such as approval status.

- [Documentation](https://developers.google.com/authorized-buyers/apis/realtimebidding/reference/rest/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/realtimebidding_v1/realtimebidding_v1-library.html)

#### reCAPTCHA Enterprise API - `recaptchaenterprise_v1`

Help protect your website from fraudulent activity, spam, and abuse without creating friction.

- [Documentation](https://cloud.google.com/recaptcha-enterprise/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/recaptchaenterprise_v1/recaptchaenterprise_v1-library.html)

#### Recommender API - `recommender_v1`

- [Documentation](https://cloud.google.com/recommender/docs/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/recommender_v1/recommender_v1-library.html)

#### Google Cloud Memorystore for Redis API - `redis_v1`

Creates and manages Redis instances on the Google Cloud Platform.

- [Documentation](https://cloud.google.com/memorystore/docs/redis/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/redis_v1/redis_v1-library.html)

#### Google Workspace Reseller API - `reseller_v1`

Perform common functions that are available on the Channel Services console at scale, like placing orders and viewing customer information

- [Documentation](https://developers.google.com/google-apps/reseller/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/reseller_v1/reseller_v1-library.html)

#### Resource Settings API - `resourcesettings_v1`

The Resource Settings API allows users to control and modify the behavior of their GCP resources (e.g., VM, firewall, Project, etc.) across the Cloud Resource Hierarchy.

- [Documentation](https://cloud.google.com/resource-manager/docs/resource-settings/overview)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/resourcesettings_v1/resourcesettings_v1-library.html)

#### Retail API - `retail_v2`

Cloud Retail service enables customers to build end-to-end personalized recommendation systems without requiring a high level of expertise in machine learning, recommendation system, or Google Cloud.

- [Documentation](https://cloud.google.com/recommendations)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/retail_v2/retail_v2-library.html)

#### Cloud Run Admin API - `run_v1`

Deploy and manage user provided container images that scale automatically based on incoming requests. The Cloud Run Admin API v1 follows the Knative Serving API specification, while v2 is aligned with Google Cloud AIP-based API standards, as described in https://google.aip.dev/.

- [Documentation](https://cloud.google.com/run/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/run_v1/run_v1-library.html)

#### Cloud Run Admin API - `run_v2`

Deploy and manage user provided container images that scale automatically based on incoming requests. The Cloud Run Admin API v1 follows the Knative Serving API specification, while v2 is aligned with Google Cloud AIP-based API standards, as described in https://google.aip.dev/.

- [Documentation](https://cloud.google.com/run/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/run_v2/run_v2-library.html)

#### Cloud Runtime Configuration API - `runtimeconfig_v1`

The Runtime Configurator allows you to dynamically configure and expose variables through Google Cloud Platform. In addition, you can also set Watchers and Waiters that will watch for changes to your data and return based on certain conditions.

- [Documentation](https://cloud.google.com/deployment-manager/runtime-configurator/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/runtimeconfig_v1/runtimeconfig_v1-library.html)

#### Safe Browsing API - `safebrowsing_v4`

Enables client applications to check web resources (most commonly URLs) against Google-generated lists of unsafe web resources. The Safe Browsing APIs are for non-commercial use only. If you need to use APIs to detect malicious URLs for commercial purposes – meaning “for sale or revenue-generating purposes” – please refer to the Web Risk API.

- [Documentation](https://developers.google.com/safe-browsing/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/safebrowsing_v4/safebrowsing_v4-library.html)

#### Safe Browsing API - `safebrowsing_v5`

Enables client applications to check web resources (most commonly URLs) against Google-generated lists of unsafe web resources. The Safe Browsing APIs are for non-commercial use only. If you need to use APIs to detect malicious URLs for commercial purposes – meaning “for sale or revenue-generating purposes” – please refer to the Web Risk API.

- [Documentation](https://developers.google.com/safe-browsing/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/safebrowsing_v5/safebrowsing_v5-library.html)

#### Apps Script API - `script_v1`

Manages and executes Google Apps Script projects. 

- [Documentation](https://developers.google.com/apps-script/api/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/script_v1/script_v1-library.html)

#### Google Search Console API - `searchconsole_v1`

The Search Console API provides access to both Search Console data (verified users only) and to public information on an URL basis (anyone)

- [Documentation](https://developers.google.com/webmaster-tools/search-console-api/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/searchconsole_v1/searchconsole_v1-library.html)

#### Secret Manager API - `secretmanager_v1`

Stores sensitive data such as API keys, passwords, and certificates. Provides convenience while improving security. 

- [Documentation](https://cloud.google.com/secret-manager/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/secretmanager_v1/secretmanager_v1-library.html)

#### Security Command Center API - `securitycenter_v1`

Security Command Center API provides access to temporal views of assets and findings within an organization.

- [Documentation](https://cloud.google.com/security-command-center)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/securitycenter_v1/securitycenter_v1-library.html)

#### Service Consumer Management API - `serviceconsumermanagement_v1`

Manages the service consumers of a Service Infrastructure service.

- [Documentation](https://cloud.google.com/service-consumer-management/docs/overview)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/serviceconsumermanagement_v1/serviceconsumermanagement_v1-library.html)

#### Service Control API - `servicecontrol_v1`

Provides admission control and telemetry reporting for services integrated with Service Infrastructure. 

- [Documentation](https://cloud.google.com/service-control/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/servicecontrol_v1/servicecontrol_v1-library.html)

#### Service Control API - `servicecontrol_v2`

Provides admission control and telemetry reporting for services integrated with Service Infrastructure. 

- [Documentation](https://cloud.google.com/service-control/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/servicecontrol_v2/servicecontrol_v2-library.html)

#### Service Directory API - `servicedirectory_v1`

Service Directory is a platform for discovering, publishing, and connecting services. 

- [Documentation](https://cloud.google.com/service-directory)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/servicedirectory_v1/servicedirectory_v1-library.html)

#### Service Management API - `servicemanagement_v1`

Google Service Management allows service producers to publish their services on Google Cloud Platform so that they can be discovered and used by service consumers.

- [Documentation](https://cloud.google.com/service-management/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/servicemanagement_v1/servicemanagement_v1-library.html)

#### Service Networking API - `servicenetworking_v1`

Provides automatic management of network configurations necessary for certain services.

- [Documentation](https://cloud.google.com/service-infrastructure/docs/service-networking/getting-started)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/servicenetworking_v1/servicenetworking_v1-library.html)

#### Service Usage API - `serviceusage_v1`

Enables services that service consumers want to use on Google Cloud Platform, lists the available or enabled services, or disables services that service consumers no longer use.

- [Documentation](https://cloud.google.com/service-usage/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/serviceusage_v1/serviceusage_v1-library.html)

#### Google Sheets API - `sheets_v4`

Reads and writes Google Sheets.

- [Documentation](https://developers.google.com/sheets/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/sheets_v4/sheets_v4-library.html)

#### ![Logo](https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png) Google Site Verification API - `siteverification_v1`

Verifies ownership of websites or domains with Google.

- [Documentation](https://developers.google.com/site-verification/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/siteverification_v1/siteverification_v1-library.html)

#### Google Slides API - `slides_v1`

Reads and writes Google Slides presentations.

- [Documentation](https://developers.google.com/slides/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/slides_v1/slides_v1-library.html)

#### Smart Device Management API - `smartdevicemanagement_v1`

Allow select enterprise partners to access, control, and manage Google and Nest devices programmatically.

- [Documentation](https://developers.google.com/nest/device-access)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/smartdevicemanagement_v1/smartdevicemanagement_v1-library.html)

#### Cloud Source Repositories API - `sourcerepo_v1`

Accesses source code repositories hosted by Google.

- [Documentation](https://cloud.google.com/source-repositories/docs/apis)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/sourcerepo_v1/sourcerepo_v1-library.html)

#### Cloud Spanner API - `spanner_v1`

Cloud Spanner is a managed, mission-critical, globally consistent and scalable relational database service.

- [Documentation](https://cloud.google.com/spanner/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/spanner_v1/spanner_v1-library.html)

#### Cloud Speech-to-Text API - `speech_v1`

Converts audio to text by applying powerful neural network models.

- [Documentation](https://cloud.google.com/speech-to-text/docs/quickstart-protocol)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/speech_v1/speech_v1-library.html)

#### ![Logo](https://www.google.com/images/icons/product/cloud_storage-16.png) Cloud Storage JSON API - `storage_v1`

Stores and retrieves potentially large, immutable data objects.

- [Documentation](https://developers.google.com/storage/docs/json_api/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/storage_v1/storage_v1-library.html)

#### Storage Transfer API - `storagetransfer_v1`

Transfers data from external data sources to a Google Cloud Storage bucket or between Google Cloud Storage buckets. 

- [Documentation](https://cloud.google.com/storage-transfer/docs)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/storagetransfer_v1/storagetransfer_v1-library.html)

#### Street View Publish API - `streetviewpublish_v1`

Publishes 360 photos to Google Maps, along with position, orientation, and connectivity metadata. Apps can offer an interface for positioning, connecting, and uploading user-generated Street View images. 

- [Documentation](https://developers.google.com/streetview/publish/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/streetviewpublish_v1/streetviewpublish_v1-library.html)

#### Security Token Service API - `sts_v1`

The Security Token Service exchanges Google or third-party credentials for a short-lived access token to Google Cloud resources.

- [Documentation](https://cloud.google.com/iam/docs/workload-identity-federation)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/sts_v1/sts_v1-library.html)

#### Tag Manager API - `tagmanager_v1`

This API allows clients to access and modify container and tag configuration.

- [Documentation](https://developers.google.com/tag-manager)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/tagmanager_v1/tagmanager_v1-library.html)

#### Tag Manager API - `tagmanager_v2`

This API allows clients to access and modify container and tag configuration.

- [Documentation](https://developers.google.com/tag-manager)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/tagmanager_v2/tagmanager_v2-library.html)

#### Google Tasks API - `tasks_v1`

The Google Tasks API lets you manage your tasks and task lists.

- [Documentation](https://developers.google.com/tasks/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/tasks_v1/tasks_v1-library.html)

#### Cloud Testing API - `testing_v1`

Allows developers to run automated tests for their mobile applications on Google infrastructure.

- [Documentation](https://developers.google.com/cloud-test-lab/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/testing_v1/testing_v1-library.html)

#### Cloud Text-to-Speech API - `texttospeech_v1`

Synthesizes natural-sounding speech by applying powerful neural network models.

- [Documentation](https://cloud.google.com/text-to-speech/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/texttospeech_v1/texttospeech_v1-library.html)

#### Cloud TPU API - `tpu_v1`

TPU API provides customers with access to Google TPU technology.

- [Documentation](https://cloud.google.com/tpu/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/tpu_v1/tpu_v1-library.html)

#### Cloud TPU API - `tpu_v2`

TPU API provides customers with access to Google TPU technology.

- [Documentation](https://cloud.google.com/tpu/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/tpu_v2/tpu_v2-library.html)

#### Traffic Director API - `trafficdirector_v2`

- [Documentation](https://cloud.google.com/traffic-director)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/trafficdirector_v2/trafficdirector_v2-library.html)

#### Traffic Director API - `trafficdirector_v3`

- [Documentation](https://cloud.google.com/traffic-director)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/trafficdirector_v3/trafficdirector_v3-library.html)

#### Transcoder API - `transcoder_v1`

This API converts video files into formats suitable for consumer distribution. For more information, see the Transcoder API overview. 

- [Documentation](https://cloud.google.com/transcoder/docs/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/transcoder_v1/transcoder_v1-library.html)

#### Cloud Translation API - `translate_v3`

Integrates text translation into your website or application.

- [Documentation](https://cloud.google.com/translate/docs/quickstarts)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/translate_v3/translate_v3-library.html)

#### Travel Impact Model API - `travelimpactmodel_v1`

Travel Impact Model API lets you query travel carbon emission estimates.

- [Documentation](https://developers.google.com/travel/impact-model)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/travelimpactmodel_v1/travelimpactmodel_v1-library.html)

#### Google Vault API - `vault_v1`

Retention and eDiscovery for Google Workspace. To work with Vault resources, the account must have the [required Vault privileges](https://support.google.com/vault/answer/2799699) and access to the matter. To access a matter, the account must have created the matter, have the matter shared with them, or have the **View All Matters** privilege. For example, to download an export, an account needs the **Manage Exports** privilege and the matter shared with them. 

- [Documentation](https://developers.google.com/vault)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/vault_v1/vault_v1-library.html)

#### Chrome Verified Access API - `verifiedaccess_v1`

API for Verified Access chrome extension to provide credential verification for chrome devices connecting to an enterprise network

- [Documentation](https://developers.google.com/chrome/verified-access)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/verifiedaccess_v1/verifiedaccess_v1-library.html)

#### Chrome Verified Access API - `verifiedaccess_v2`

API for Verified Access chrome extension to provide credential verification for chrome devices connecting to an enterprise network

- [Documentation](https://developers.google.com/chrome/verified-access)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/verifiedaccess_v2/verifiedaccess_v2-library.html)

#### versionhistory.googleapis.com API - `versionhistory_v1`

Version History API - Prod

- [Documentation](https://developer.chrome.com/docs/versionhistory/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/versionhistory_v1/versionhistory_v1-library.html)

#### Cloud Video Intelligence API - `videointelligence_v1`

Detects objects, explicit content, and scene changes in videos. It also specifies the region for annotation and transcribes speech to text. Supports both asynchronous API and streaming API.

- [Documentation](https://cloud.google.com/video-intelligence/docs/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/videointelligence_v1/videointelligence_v1-library.html)

#### Cloud Vision API - `vision_v1`

Integrates Google Vision features, including image labeling, face, logo, and landmark detection, optical character recognition (OCR), and detection of explicit content, into applications.

- [Documentation](https://cloud.google.com/vision/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/vision_v1/vision_v1-library.html)

#### VM Migration API - `vmmigration_v1`

Use the Migrate to Virtual Machines API to programmatically migrate workloads. 

- [Documentation](https://cloud.google.com/migrate/virtual-machines)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/vmmigration_v1/vmmigration_v1-library.html)

#### VMware Engine API - `vmwareengine_v1`

The Google VMware Engine API lets you programmatically manage VMware environments.

- [Documentation](https://cloud.google.com/solutions/vmware-as-a-service)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/vmwareengine_v1/vmwareengine_v1-library.html)

#### Serverless VPC Access API - `vpcaccess_v1`

API for managing VPC access connectors.

- [Documentation](https://cloud.google.com/vpc/docs/configure-serverless-vpc-access)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/vpcaccess_v1/vpcaccess_v1-library.html)

#### Web Fonts Developer API - `webfonts_v1`

The Google Web Fonts Developer API lets you retrieve information about web fonts served by Google.

- [Documentation](https://developers.google.com/fonts/docs/developer_api)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/webfonts_v1/webfonts_v1-library.html)

#### Web Risk API - `webrisk_v1`

- [Documentation](https://cloud.google.com/web-risk/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/webrisk_v1/webrisk_v1-library.html)

#### Web Security Scanner API - `websecurityscanner_v1`

Scans your Compute and App Engine apps for common web vulnerabilities.

- [Documentation](https://cloud.google.com/security-command-center/docs/concepts-web-security-scanner-overview/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/websecurityscanner_v1/websecurityscanner_v1-library.html)

#### Workflow Executions API - `workflowexecutions_v1`

Execute workflows created with Workflows API.

- [Documentation](https://cloud.google.com/workflows)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/workflowexecutions_v1/workflowexecutions_v1-library.html)

#### Workflows API - `workflows_v1`

Manage workflow definitions. To execute workflows and manage executions, see the Workflows Executions API.

- [Documentation](https://cloud.google.com/workflows)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/workflows_v1/workflows_v1-library.html)

#### Workload Manager API - `workloadmanager_v1`

Workload Manager is a service that provides tooling for enterprise workloads to automate the deployment and validation of your workloads against best practices and recommendations.

- [Documentation](https://cloud.google.com/workload-manager/docs)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/workloadmanager_v1/workloadmanager_v1-library.html)

#### Cloud Workstations API - `workstations_v1`

Allows administrators to create managed developer environments in the cloud. 

- [Documentation](https://cloud.google.com/workstations)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/workstations_v1/workstations_v1-library.html)

#### YouTube Data API v3 - `youtube_v3`

The YouTube Data API v3 is an API that provides access to YouTube data, such as videos, playlists, and channels.

- [Documentation](https://developers.google.com/youtube/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/youtube_v3/youtube_v3-library.html)

#### YouTube Analytics API - `youtubeanalytics_v2`

Retrieves your YouTube Analytics data.

- [Documentation](https://developers.google.com/youtube/analytics)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/youtubeanalytics_v2/youtubeanalytics_v2-library.html)

#### YouTube Reporting API - `youtubereporting_v1`

Schedules reporting jobs containing your YouTube Analytics data and downloads the resulting bulk data reports in the form of CSV files.

- [Documentation](https://developers.google.com/youtube/reporting/v1/reports/)
- [API details](https://pub.dev/documentation/googleapis/12.0.0/youtubereporting_v1/youtubereporting_v1-library.html)

