// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file has been automatically generated. Please do not edit it manually.
// To regenerate the file, use:
// dart dev/tools/localization/gen_localizations.dart --overwrite

import 'dart:collection';

import 'package:flutter/foundation.dart';
import 'package:flutter/cupertino.dart';
import 'package:intl/intl.dart' as intl;

import '../cupertino_localizations.dart';

// The classes defined here encode all of the translations found in the
// `flutter_localizations/lib/src/l10n/*.arb` files.
//
// These classes are constructed by the [getCupertinoTranslation] method at the
// bottom of this file, and used by the [_GlobalCupertinoLocalizationsDelegate.load]
// method defined in `flutter_localizations/lib/src/cupertino_localizations.dart`.

/// The translations for Arabic (`ar`).
class CupertinoLocalizationAr extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Arabic.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationAr({
    String localeName = 'ar',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'تنبيه';

  @override
  String get anteMeridiemAbbreviation => r'ص';

  @override
  String get copyButtonLabel => r'نسخ';

  @override
  String get cutButtonLabel => r'قص';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => r'$hour بالضبط';

  @override
  String get datePickerHourSemanticsLabelMany => r'$hour بالضبط';

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour بالضبط';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour بالضبط';

  @override
  String get datePickerHourSemanticsLabelTwo => r'$hour بالضبط';

  @override
  String get datePickerHourSemanticsLabelZero => r'$hour بالضبط';

  @override
  String get datePickerMinuteSemanticsLabelFew => r'$minute دقائق';

  @override
  String get datePickerMinuteSemanticsLabelMany => r'$minute دقيقة​';

  @override
  String get datePickerMinuteSemanticsLabelOne => r'دقيقة واحدة';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute دقيقة​';

  @override
  String get datePickerMinuteSemanticsLabelTwo => r'دقيقتان ($minute)';

  @override
  String get datePickerMinuteSemanticsLabelZero => r'$minute دقيقة​';

  @override
  String get pasteButtonLabel => r'لصق';

  @override
  String get postMeridiemAbbreviation => r'م';

  @override
  String get selectAllButtonLabel => r'اختيار الكل';

  @override
  String get timerPickerHourLabelFew => r'ساعات';

  @override
  String get timerPickerHourLabelMany => r'ساعة';

  @override
  String get timerPickerHourLabelOne => r'ساعة';

  @override
  String get timerPickerHourLabelOther => r'ساعة';

  @override
  String get timerPickerHourLabelTwo => r'ساعتان';

  @override
  String get timerPickerHourLabelZero => r'ساعة';

  @override
  String get timerPickerMinuteLabelFew => r'دقائق';

  @override
  String get timerPickerMinuteLabelMany => r'دقيقة';

  @override
  String get timerPickerMinuteLabelOne => r'دقيقة واحدة';

  @override
  String get timerPickerMinuteLabelOther => r'دقيقة';

  @override
  String get timerPickerMinuteLabelTwo => r'دقيقتان';

  @override
  String get timerPickerMinuteLabelZero => r'دقيقة';

  @override
  String get timerPickerSecondLabelFew => r'ثوانٍ';

  @override
  String get timerPickerSecondLabelMany => r'ثانية';

  @override
  String get timerPickerSecondLabelOne => r'ثانية واحدة';

  @override
  String get timerPickerSecondLabelOther => r'ثانية';

  @override
  String get timerPickerSecondLabelTwo => r'ثانيتان';

  @override
  String get timerPickerSecondLabelZero => r'ثانية';

  @override
  String get todayLabel => r'اليوم';
}

/// The translations for Bulgarian (`bg`).
class CupertinoLocalizationBg extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Bulgarian.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationBg({
    String localeName = 'bg',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Сигнал';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get copyButtonLabel => r'Копиране';

  @override
  String get cutButtonLabel => r'Изрязване';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour часа';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour часа';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 минута';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute минути';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Поставяне';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get selectAllButtonLabel => r'Избиране на всички';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'час';

  @override
  String get timerPickerHourLabelOther => r'часа';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'мин';

  @override
  String get timerPickerMinuteLabelOther => r'мин';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r'сек';

  @override
  String get timerPickerSecondLabelOther => r'сек';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Днес';
}

/// The translations for Bosnian (`bs`).
class CupertinoLocalizationBs extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Bosnian.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationBs({
    String localeName = 'bs',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Upozorenje';

  @override
  String get anteMeridiemAbbreviation => r'prijepodne';

  @override
  String get copyButtonLabel => r'Kopiraj';

  @override
  String get cutButtonLabel => r'Izreži';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => r'$hour sata';

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour sat';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour sati';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => r'$minute minute';

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'Jedna minuta';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute minuta';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Zalijepi';

  @override
  String get postMeridiemAbbreviation => r'popodne';

  @override
  String get selectAllButtonLabel => r'Odaberi sve';

  @override
  String get timerPickerHourLabelFew => r'sata';

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'sat';

  @override
  String get timerPickerHourLabelOther => r'sati';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => r'min';

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'min';

  @override
  String get timerPickerMinuteLabelOther => r'min';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => r's';

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r's';

  @override
  String get timerPickerSecondLabelOther => r's';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Danas';
}

/// The translations for Catalan Valencian (`ca`).
class CupertinoLocalizationCa extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Catalan Valencian.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationCa({
    String localeName = 'ca',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Alerta';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get copyButtonLabel => r'Copia';

  @override
  String get cutButtonLabel => r'Retalla';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour en punt';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour en punt';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 minut';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute minuts';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Enganxa';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get selectAllButtonLabel => r'Selecciona-ho tot';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'hora';

  @override
  String get timerPickerHourLabelOther => r'hores';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'min';

  @override
  String get timerPickerMinuteLabelOther => r'min';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r's';

  @override
  String get timerPickerSecondLabelOther => r's';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Avui';
}

/// The translations for Czech (`cs`).
class CupertinoLocalizationCs extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Czech.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationCs({
    String localeName = 'cs',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Upozornění';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get copyButtonLabel => r'Kopírovat';

  @override
  String get cutButtonLabel => r'Vyjmout';

  @override
  String get datePickerDateOrderString => r'mdy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => r'$hour hodiny';

  @override
  String get datePickerHourSemanticsLabelMany => r'$hour hodiny';

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour hodina';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour hodin';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => r'$minute minuty';

  @override
  String get datePickerMinuteSemanticsLabelMany => r'$minute minuty';

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 minuta';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute minut';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Vložit';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get selectAllButtonLabel => r'Vybrat vše';

  @override
  String get timerPickerHourLabelFew => r'hodiny';

  @override
  String get timerPickerHourLabelMany => r'hodiny';

  @override
  String get timerPickerHourLabelOne => r'hodina';

  @override
  String get timerPickerHourLabelOther => r'hodin';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => r'min';

  @override
  String get timerPickerMinuteLabelMany => r'min';

  @override
  String get timerPickerMinuteLabelOne => r'min';

  @override
  String get timerPickerMinuteLabelOther => r'min';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => r's';

  @override
  String get timerPickerSecondLabelMany => r's';

  @override
  String get timerPickerSecondLabelOne => r's';

  @override
  String get timerPickerSecondLabelOther => r's';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Dnes';
}

/// The translations for Danish (`da`).
class CupertinoLocalizationDa extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Danish.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationDa({
    String localeName = 'da',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Underretning';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get copyButtonLabel => r'Kopiér';

  @override
  String get cutButtonLabel => r'Klip';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'klokken $hour';

  @override
  String get datePickerHourSemanticsLabelOther => r'klokken $hour';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 minut';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute minutter';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Sæt ind';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get selectAllButtonLabel => r'Vælg alle';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'time';

  @override
  String get timerPickerHourLabelOther => r'timer';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'min.';

  @override
  String get timerPickerMinuteLabelOther => r'min.';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r'sek.';

  @override
  String get timerPickerSecondLabelOther => r'sek.';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'I dag';
}

/// The translations for German (`de`).
class CupertinoLocalizationDe extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for German.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationDe({
    String localeName = 'de',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Benachrichtigung';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get copyButtonLabel => r'Kopieren';

  @override
  String get cutButtonLabel => r'Ausschneiden';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour Uhr';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour Uhr';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 Minute';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute Minuten';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Einsetzen';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get selectAllButtonLabel => r'Alles auswählen';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'Stunde';

  @override
  String get timerPickerHourLabelOther => r'Stunden';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'min';

  @override
  String get timerPickerMinuteLabelOther => r'min';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r's';

  @override
  String get timerPickerSecondLabelOther => r's';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Heute';
}

/// The translations for Modern Greek (`el`).
class CupertinoLocalizationEl extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Modern Greek.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationEl({
    String localeName = 'el',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Ειδοποίηση';

  @override
  String get anteMeridiemAbbreviation => r'π.μ.';

  @override
  String get copyButtonLabel => r'Αντιγραφή';

  @override
  String get cutButtonLabel => r'Αποκοπή';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour ακριβώς';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour ακριβώς';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 λεπτό';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute λεπτά';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Επικόλληση';

  @override
  String get postMeridiemAbbreviation => r'μ.μ.';

  @override
  String get selectAllButtonLabel => r'Επιλογή όλων';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'ώρα';

  @override
  String get timerPickerHourLabelOther => r'ώρες';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'λεπ.';

  @override
  String get timerPickerMinuteLabelOther => r'λεπ.';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r'δευτ.';

  @override
  String get timerPickerSecondLabelOther => r'δευτ.';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Σήμερα';
}

/// The translations for English (`en`).
class CupertinoLocalizationEn extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for English.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationEn({
    String localeName = 'en',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Alert';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get copyButtonLabel => r'Copy';

  @override
  String get cutButtonLabel => r'Cut';

  @override
  String get datePickerDateOrderString => r'mdy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour o' "'" r'clock';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour o' "'" r'clock';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 minute';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute minutes';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Paste';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get selectAllButtonLabel => r'Select All';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'hour';

  @override
  String get timerPickerHourLabelOther => r'hours';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'min.';

  @override
  String get timerPickerMinuteLabelOther => r'min.';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r'sec.';

  @override
  String get timerPickerSecondLabelOther => r'sec.';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Today';
}

/// The translations for English, as used in Australia (`en_AU`).
class CupertinoLocalizationEnAu extends CupertinoLocalizationEn {
  /// Create an instance of the translation bundle for English, as used in Australia.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationEnAu({
    String localeName = 'en_AU',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get selectAllButtonLabel => r'Select all';
}

/// The translations for English, as used in Canada (`en_CA`).
class CupertinoLocalizationEnCa extends CupertinoLocalizationEn {
  /// Create an instance of the translation bundle for English, as used in Canada.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationEnCa({
    String localeName = 'en_CA',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get selectAllButtonLabel => r'Select all';
}

/// The translations for English, as used in the United Kingdom (`en_GB`).
class CupertinoLocalizationEnGb extends CupertinoLocalizationEn {
  /// Create an instance of the translation bundle for English, as used in the United Kingdom.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationEnGb({
    String localeName = 'en_GB',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get selectAllButtonLabel => r'Select all';
}

/// The translations for English, as used in Ireland (`en_IE`).
class CupertinoLocalizationEnIe extends CupertinoLocalizationEn {
  /// Create an instance of the translation bundle for English, as used in Ireland.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationEnIe({
    String localeName = 'en_IE',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get selectAllButtonLabel => r'Select all';
}

/// The translations for English, as used in India (`en_IN`).
class CupertinoLocalizationEnIn extends CupertinoLocalizationEn {
  /// Create an instance of the translation bundle for English, as used in India.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationEnIn({
    String localeName = 'en_IN',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get selectAllButtonLabel => r'Select all';
}

/// The translations for English, as used in Singapore (`en_SG`).
class CupertinoLocalizationEnSg extends CupertinoLocalizationEn {
  /// Create an instance of the translation bundle for English, as used in Singapore.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationEnSg({
    String localeName = 'en_SG',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get selectAllButtonLabel => r'Select all';
}

/// The translations for English, as used in South Africa (`en_ZA`).
class CupertinoLocalizationEnZa extends CupertinoLocalizationEn {
  /// Create an instance of the translation bundle for English, as used in South Africa.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationEnZa({
    String localeName = 'en_ZA',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get selectAllButtonLabel => r'Select all';
}

/// The translations for Spanish Castilian (`es`).
class CupertinoLocalizationEs extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Spanish Castilian.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationEs({
    String localeName = 'es',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Alerta';

  @override
  String get anteMeridiemAbbreviation => r'A.M.';

  @override
  String get copyButtonLabel => r'Copiar';

  @override
  String get cutButtonLabel => r'Cortar';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour en punto';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour en punto';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 minuto';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute minutos';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Pegar';

  @override
  String get postMeridiemAbbreviation => r'P.M.';

  @override
  String get selectAllButtonLabel => r'Seleccionar todo';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'hora';

  @override
  String get timerPickerHourLabelOther => r'horas';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'min';

  @override
  String get timerPickerMinuteLabelOther => r'min';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r's';

  @override
  String get timerPickerSecondLabelOther => r's';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Hoy';
}

/// The translations for Spanish Castilian, as used in Latin America and the Caribbean (`es_419`).
class CupertinoLocalizationEs419 extends CupertinoLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Latin America and the Caribbean.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationEs419({
    String localeName = 'es_419',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour en punto';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour en punto';

  @override
  String get datePickerDateOrderString => r'mdy';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get selectAllButtonLabel => r'Seleccionar todos';
}

/// The translations for Spanish Castilian, as used in Argentina (`es_AR`).
class CupertinoLocalizationEsAr extends CupertinoLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Argentina.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationEsAr({
    String localeName = 'es_AR',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour en punto';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour en punto';

  @override
  String get datePickerDateOrderString => r'mdy';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get selectAllButtonLabel => r'Seleccionar todos';
}

/// The translations for Spanish Castilian, as used in Bolivia (`es_BO`).
class CupertinoLocalizationEsBo extends CupertinoLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Bolivia.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationEsBo({
    String localeName = 'es_BO',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour en punto';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour en punto';

  @override
  String get datePickerDateOrderString => r'mdy';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get selectAllButtonLabel => r'Seleccionar todos';
}

/// The translations for Spanish Castilian, as used in Chile (`es_CL`).
class CupertinoLocalizationEsCl extends CupertinoLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Chile.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationEsCl({
    String localeName = 'es_CL',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour en punto';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour en punto';

  @override
  String get datePickerDateOrderString => r'mdy';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get selectAllButtonLabel => r'Seleccionar todos';
}

/// The translations for Spanish Castilian, as used in Colombia (`es_CO`).
class CupertinoLocalizationEsCo extends CupertinoLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Colombia.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationEsCo({
    String localeName = 'es_CO',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour en punto';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour en punto';

  @override
  String get datePickerDateOrderString => r'mdy';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get selectAllButtonLabel => r'Seleccionar todos';
}

/// The translations for Spanish Castilian, as used in Costa Rica (`es_CR`).
class CupertinoLocalizationEsCr extends CupertinoLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Costa Rica.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationEsCr({
    String localeName = 'es_CR',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour en punto';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour en punto';

  @override
  String get datePickerDateOrderString => r'mdy';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get selectAllButtonLabel => r'Seleccionar todos';
}

/// The translations for Spanish Castilian, as used in the Dominican Republic (`es_DO`).
class CupertinoLocalizationEsDo extends CupertinoLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in the Dominican Republic.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationEsDo({
    String localeName = 'es_DO',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour en punto';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour en punto';

  @override
  String get datePickerDateOrderString => r'mdy';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get selectAllButtonLabel => r'Seleccionar todos';
}

/// The translations for Spanish Castilian, as used in Ecuador (`es_EC`).
class CupertinoLocalizationEsEc extends CupertinoLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Ecuador.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationEsEc({
    String localeName = 'es_EC',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour en punto';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour en punto';

  @override
  String get datePickerDateOrderString => r'mdy';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get selectAllButtonLabel => r'Seleccionar todos';
}

/// The translations for Spanish Castilian, as used in Guatemala (`es_GT`).
class CupertinoLocalizationEsGt extends CupertinoLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Guatemala.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationEsGt({
    String localeName = 'es_GT',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour en punto';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour en punto';

  @override
  String get datePickerDateOrderString => r'mdy';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get selectAllButtonLabel => r'Seleccionar todos';
}

/// The translations for Spanish Castilian, as used in Honduras (`es_HN`).
class CupertinoLocalizationEsHn extends CupertinoLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Honduras.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationEsHn({
    String localeName = 'es_HN',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour en punto';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour en punto';

  @override
  String get datePickerDateOrderString => r'mdy';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get selectAllButtonLabel => r'Seleccionar todos';
}

/// The translations for Spanish Castilian, as used in Mexico (`es_MX`).
class CupertinoLocalizationEsMx extends CupertinoLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Mexico.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationEsMx({
    String localeName = 'es_MX',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour en punto';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour en punto';

  @override
  String get datePickerDateOrderString => r'mdy';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get selectAllButtonLabel => r'Seleccionar todos';
}

/// The translations for Spanish Castilian, as used in Nicaragua (`es_NI`).
class CupertinoLocalizationEsNi extends CupertinoLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Nicaragua.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationEsNi({
    String localeName = 'es_NI',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour en punto';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour en punto';

  @override
  String get datePickerDateOrderString => r'mdy';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get selectAllButtonLabel => r'Seleccionar todos';
}

/// The translations for Spanish Castilian, as used in Panama (`es_PA`).
class CupertinoLocalizationEsPa extends CupertinoLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Panama.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationEsPa({
    String localeName = 'es_PA',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour en punto';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour en punto';

  @override
  String get datePickerDateOrderString => r'mdy';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get selectAllButtonLabel => r'Seleccionar todos';
}

/// The translations for Spanish Castilian, as used in Peru (`es_PE`).
class CupertinoLocalizationEsPe extends CupertinoLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Peru.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationEsPe({
    String localeName = 'es_PE',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour en punto';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour en punto';

  @override
  String get datePickerDateOrderString => r'mdy';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get selectAllButtonLabel => r'Seleccionar todos';
}

/// The translations for Spanish Castilian, as used in Puerto Rico (`es_PR`).
class CupertinoLocalizationEsPr extends CupertinoLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Puerto Rico.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationEsPr({
    String localeName = 'es_PR',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour en punto';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour en punto';

  @override
  String get datePickerDateOrderString => r'mdy';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get selectAllButtonLabel => r'Seleccionar todos';
}

/// The translations for Spanish Castilian, as used in Paraguay (`es_PY`).
class CupertinoLocalizationEsPy extends CupertinoLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Paraguay.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationEsPy({
    String localeName = 'es_PY',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour en punto';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour en punto';

  @override
  String get datePickerDateOrderString => r'mdy';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get selectAllButtonLabel => r'Seleccionar todos';
}

/// The translations for Spanish Castilian, as used in El Salvador (`es_SV`).
class CupertinoLocalizationEsSv extends CupertinoLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in El Salvador.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationEsSv({
    String localeName = 'es_SV',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour en punto';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour en punto';

  @override
  String get datePickerDateOrderString => r'mdy';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get selectAllButtonLabel => r'Seleccionar todos';
}

/// The translations for Spanish Castilian, as used in the United States (`es_US`).
class CupertinoLocalizationEsUs extends CupertinoLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in the United States.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationEsUs({
    String localeName = 'es_US',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour en punto';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour en punto';

  @override
  String get datePickerDateOrderString => r'mdy';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get selectAllButtonLabel => r'Seleccionar todos';
}

/// The translations for Spanish Castilian, as used in Uruguay (`es_UY`).
class CupertinoLocalizationEsUy extends CupertinoLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Uruguay.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationEsUy({
    String localeName = 'es_UY',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour en punto';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour en punto';

  @override
  String get datePickerDateOrderString => r'mdy';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get selectAllButtonLabel => r'Seleccionar todos';
}

/// The translations for Spanish Castilian, as used in Venezuela (`es_VE`).
class CupertinoLocalizationEsVe extends CupertinoLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Venezuela.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationEsVe({
    String localeName = 'es_VE',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour en punto';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour en punto';

  @override
  String get datePickerDateOrderString => r'mdy';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get selectAllButtonLabel => r'Seleccionar todos';
}

/// The translations for Estonian (`et`).
class CupertinoLocalizationEt extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Estonian.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationEt({
    String localeName = 'et',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Märguanne';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get copyButtonLabel => r'Kopeeri';

  @override
  String get cutButtonLabel => r'Lõika';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'Kell $hour';

  @override
  String get datePickerHourSemanticsLabelOther => r'Kell $hour';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 minut';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute minutit';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Kleebi';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get selectAllButtonLabel => r'Vali kõik';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'tund';

  @override
  String get timerPickerHourLabelOther => r'tundi';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'min';

  @override
  String get timerPickerMinuteLabelOther => r'min';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r's';

  @override
  String get timerPickerSecondLabelOther => r's';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Täna';
}

/// The translations for Persian (`fa`).
class CupertinoLocalizationFa extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Persian.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationFa({
    String localeName = 'fa',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'هشدار';

  @override
  String get anteMeridiemAbbreviation => r'ق.ظ.';

  @override
  String get copyButtonLabel => r'کپی';

  @override
  String get cutButtonLabel => r'برش';

  @override
  String get datePickerDateOrderString => r'ymd';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'ساعت $hour';

  @override
  String get datePickerHourSemanticsLabelOther => r'ساعت $hour';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'۱ دقیقه';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute دقیقه';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'جای‌گذاری';

  @override
  String get postMeridiemAbbreviation => r'ب.ظ.';

  @override
  String get selectAllButtonLabel => r'انتخاب همه';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'ساعت';

  @override
  String get timerPickerHourLabelOther => r'ساعت';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'دقیقه';

  @override
  String get timerPickerMinuteLabelOther => r'دقیقه';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r'ثانیه';

  @override
  String get timerPickerSecondLabelOther => r'ثانیه';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'امروز';
}

/// The translations for Finnish (`fi`).
class CupertinoLocalizationFi extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Finnish.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationFi({
    String localeName = 'fi',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Ilmoitus';

  @override
  String get anteMeridiemAbbreviation => r'ap';

  @override
  String get copyButtonLabel => r'Kopioi';

  @override
  String get cutButtonLabel => r'Leikkaa';

  @override
  String get datePickerDateOrderString => r'mdy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'klo $hour';

  @override
  String get datePickerHourSemanticsLabelOther => r'klo $hour';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 minuutti';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute minuuttia';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Liitä';

  @override
  String get postMeridiemAbbreviation => r'ip';

  @override
  String get selectAllButtonLabel => r'Valitse kaikki';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'tunti';

  @override
  String get timerPickerHourLabelOther => r'tuntia';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'min';

  @override
  String get timerPickerMinuteLabelOther => r'min';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r's';

  @override
  String get timerPickerSecondLabelOther => r's';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Tänään';
}

/// The translations for Filipino Pilipino (`fil`).
class CupertinoLocalizationFil extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Filipino Pilipino.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationFil({
    String localeName = 'fil',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Alerto';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get copyButtonLabel => r'Kopyahin';

  @override
  String get cutButtonLabel => r'I-cut';

  @override
  String get datePickerDateOrderString => r'mdy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'Ala $hour';

  @override
  String get datePickerHourSemanticsLabelOther => r'Alas $hour';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 minuto';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute na minuto';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'I-paste';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get selectAllButtonLabel => r'Piliin Lahat';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'oras';

  @override
  String get timerPickerHourLabelOther => r'na oras';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'min.';

  @override
  String get timerPickerMinuteLabelOther => r'na min.';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r'seg.';

  @override
  String get timerPickerSecondLabelOther => r'na seg.';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Ngayon';
}

/// The translations for French (`fr`).
class CupertinoLocalizationFr extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for French.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationFr({
    String localeName = 'fr',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Alerte';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get copyButtonLabel => r'Copier';

  @override
  String get cutButtonLabel => r'Couper';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour heure';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour heures';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 minute';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute minutes';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Coller';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get selectAllButtonLabel => r'Tout sélect.';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'heure';

  @override
  String get timerPickerHourLabelOther => r'heures';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'minute';

  @override
  String get timerPickerMinuteLabelOther => r'minutes';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r's';

  @override
  String get timerPickerSecondLabelOther => r's';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'aujourd' "'" r'hui';
}

/// The translations for Galician (`gl`).
class CupertinoLocalizationGl extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Galician.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationGl({
    String localeName = 'gl',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Alerta';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get copyButtonLabel => r'Copiar';

  @override
  String get cutButtonLabel => r'Cortar';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour en punto';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour en punto';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 minuto';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute minutos';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Pegar';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get selectAllButtonLabel => r'Seleccionar todo';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'hora';

  @override
  String get timerPickerHourLabelOther => r'horas';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'min';

  @override
  String get timerPickerMinuteLabelOther => r'min';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r's';

  @override
  String get timerPickerSecondLabelOther => r's';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Hoxe';
}

/// The translations for Swiss German Alemannic Alsatian (`gsw`).
class CupertinoLocalizationGsw extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Swiss German Alemannic Alsatian.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationGsw({
    String localeName = 'gsw',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Benachrichtigung';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get copyButtonLabel => r'Kopieren';

  @override
  String get cutButtonLabel => r'Ausschneiden';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour Uhr';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour Uhr';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 Minute';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute Minuten';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Einsetzen';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get selectAllButtonLabel => r'Alles auswählen';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'Stunde';

  @override
  String get timerPickerHourLabelOther => r'Stunden';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'min';

  @override
  String get timerPickerMinuteLabelOther => r'min';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r's';

  @override
  String get timerPickerSecondLabelOther => r's';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Heute';
}

/// The translations for Hebrew (`he`).
class CupertinoLocalizationHe extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Hebrew.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationHe({
    String localeName = 'he',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'התראה';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get copyButtonLabel => r'העתקה';

  @override
  String get cutButtonLabel => r'גזירה';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => r'$hour בדיוק';

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour בדיוק';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour בדיוק';

  @override
  String get datePickerHourSemanticsLabelTwo => r'$hour בדיוק';

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => r'$minute דקות';

  @override
  String get datePickerMinuteSemanticsLabelOne => r'דקה אחת';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute דקות';

  @override
  String get datePickerMinuteSemanticsLabelTwo => r'$minute דקות';

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'הדבקה';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get selectAllButtonLabel => r'בחירת הכול';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => r'שעות';

  @override
  String get timerPickerHourLabelOne => r'שעה';

  @override
  String get timerPickerHourLabelOther => r'שעות';

  @override
  String get timerPickerHourLabelTwo => r'שעות';

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => r'דק’';

  @override
  String get timerPickerMinuteLabelOne => r'דק’';

  @override
  String get timerPickerMinuteLabelOther => r'דק’';

  @override
  String get timerPickerMinuteLabelTwo => r'דק’';

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => r'שנ’';

  @override
  String get timerPickerSecondLabelOne => r'שנ’';

  @override
  String get timerPickerSecondLabelOther => r'שנ’';

  @override
  String get timerPickerSecondLabelTwo => r'שנ’';

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'היום';
}

/// The translations for Hindi (`hi`).
class CupertinoLocalizationHi extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Hindi.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationHi({
    String localeName = 'hi',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'अलर्ट';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get copyButtonLabel => r'कॉपी करें';

  @override
  String get cutButtonLabel => r'काटें';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour बजे';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour बजे';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 मिनट';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute मिनट';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'चिपकाएं';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get selectAllButtonLabel => r'सभी चुनें';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'घंटा';

  @override
  String get timerPickerHourLabelOther => r'घंटे';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'मिनट';

  @override
  String get timerPickerMinuteLabelOther => r'मिनट';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r'सेकंड';

  @override
  String get timerPickerSecondLabelOther => r'सेकंड';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'आज';
}

/// The translations for Croatian (`hr`).
class CupertinoLocalizationHr extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Croatian.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationHr({
    String localeName = 'hr',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Upozorenje';

  @override
  String get anteMeridiemAbbreviation => r'prijepodne';

  @override
  String get copyButtonLabel => r'Kopiraj';

  @override
  String get cutButtonLabel => r'Izreži';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => r'$hour sata';

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour sat';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour sati';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => r'$minute minute';

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'Jedna minuta';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute minuta';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Zalijepi';

  @override
  String get postMeridiemAbbreviation => r'popodne';

  @override
  String get selectAllButtonLabel => r'Odaberi sve';

  @override
  String get timerPickerHourLabelFew => r'sata';

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'sat';

  @override
  String get timerPickerHourLabelOther => r'sati';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => r'min';

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'min';

  @override
  String get timerPickerMinuteLabelOther => r'min';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => r's';

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r's';

  @override
  String get timerPickerSecondLabelOther => r's';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Danas';
}

/// The translations for Hungarian (`hu`).
class CupertinoLocalizationHu extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Hungarian.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationHu({
    String localeName = 'hu',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Értesítés';

  @override
  String get anteMeridiemAbbreviation => r'de.';

  @override
  String get copyButtonLabel => r'Másolás';

  @override
  String get cutButtonLabel => r'Kivágás';

  @override
  String get datePickerDateOrderString => r'ymd';

  @override
  String get datePickerDateTimeOrderString => r'date_dayPeriod_time';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour óra';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour óra';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 perc';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute perc';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Beillesztés';

  @override
  String get postMeridiemAbbreviation => r'du.';

  @override
  String get selectAllButtonLabel => r'Összes kijelölése';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'óra';

  @override
  String get timerPickerHourLabelOther => r'óra';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'perc';

  @override
  String get timerPickerMinuteLabelOther => r'perc';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r'mp';

  @override
  String get timerPickerSecondLabelOther => r'mp';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Ma';
}

/// The translations for Armenian (`hy`).
class CupertinoLocalizationHy extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Armenian.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationHy({
    String localeName = 'hy',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Ծանուցում';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get copyButtonLabel => r'Պատճենել';

  @override
  String get cutButtonLabel => r'Կտրել';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour:00';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour:00';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 րոպե';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute րոպե';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Տեղադրել';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get selectAllButtonLabel => r'Նշել բոլորը';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'ժամ';

  @override
  String get timerPickerHourLabelOther => r'ժամ';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'րոպե';

  @override
  String get timerPickerMinuteLabelOther => r'րոպե';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r'վրկ';

  @override
  String get timerPickerSecondLabelOther => r'վրկ';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Այսօր';
}

/// The translations for Indonesian (`id`).
class CupertinoLocalizationId extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Indonesian.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationId({
    String localeName = 'id',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Notifikasi';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get copyButtonLabel => r'Salin';

  @override
  String get cutButtonLabel => r'Potong';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour tepat';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour tepat';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 menit';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute menit';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Tempel';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get selectAllButtonLabel => r'Pilih Semua';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'jam';

  @override
  String get timerPickerHourLabelOther => r'jam';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'mnt.';

  @override
  String get timerPickerMinuteLabelOther => r'mnt.';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r'dtk.';

  @override
  String get timerPickerSecondLabelOther => r'dtk.';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Hari ini';
}

/// The translations for Italian (`it`).
class CupertinoLocalizationIt extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Italian.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationIt({
    String localeName = 'it',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Avviso';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get copyButtonLabel => r'Copia';

  @override
  String get cutButtonLabel => r'Taglia';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour in punto';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour in punto';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 minuto';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute minuti';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Incolla';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get selectAllButtonLabel => r'Seleziona tutto';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'ora';

  @override
  String get timerPickerHourLabelOther => r'ore';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'min.';

  @override
  String get timerPickerMinuteLabelOther => r'min.';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r'sec.';

  @override
  String get timerPickerSecondLabelOther => r'sec.';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Oggi';
}

/// The translations for Japanese (`ja`).
class CupertinoLocalizationJa extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Japanese.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationJa({
    String localeName = 'ja',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'通知';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get copyButtonLabel => r'コピー';

  @override
  String get cutButtonLabel => r'切り取り';

  @override
  String get datePickerDateOrderString => r'mdy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour時';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour時';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1分';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute分';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'貼り付け';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get selectAllButtonLabel => r'すべて選択';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'時間';

  @override
  String get timerPickerHourLabelOther => r'時間';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'分';

  @override
  String get timerPickerMinuteLabelOther => r'分';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r'秒';

  @override
  String get timerPickerSecondLabelOther => r'秒';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'今日';
}

/// The translations for Kazakh (`kk`).
class CupertinoLocalizationKk extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Kazakh.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationKk({
    String localeName = 'kk',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Дабыл';

  @override
  String get anteMeridiemAbbreviation => r'түстен кейін';

  @override
  String get copyButtonLabel => r'Көшіру';

  @override
  String get cutButtonLabel => r'Қию';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'Сағат: $hour';

  @override
  String get datePickerHourSemanticsLabelOther => r'Сағат: $hour';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 минут';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute минут';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Қою';

  @override
  String get postMeridiemAbbreviation => r'түстен кейін';

  @override
  String get selectAllButtonLabel => r'Барлығын таңдау';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'сағат';

  @override
  String get timerPickerHourLabelOther => r'сағат';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'мин';

  @override
  String get timerPickerMinuteLabelOther => r'мин';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r'сек';

  @override
  String get timerPickerSecondLabelOther => r'сек';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Бүгін';
}

/// The translations for Khmer Central Khmer (`km`).
class CupertinoLocalizationKm extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Khmer Central Khmer.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationKm({
    String localeName = 'km',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'ជូនដំណឹង';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get copyButtonLabel => r'ចម្លង';

  @override
  String get cutButtonLabel => r'កាត់';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'ម៉ោង $hour';

  @override
  String get datePickerHourSemanticsLabelOther => r'ម៉ោង $hour';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 នាទី';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute នាទី';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'ដាក់​ចូល';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get selectAllButtonLabel => r'ជ្រើសរើស​ទាំងអស់';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'ម៉ោង';

  @override
  String get timerPickerHourLabelOther => r'ម៉ោង';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'នាទី';

  @override
  String get timerPickerMinuteLabelOther => r'នាទី';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r'វិនាទី';

  @override
  String get timerPickerSecondLabelOther => r'វិនាទី';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'ថ្ងៃនេះ';
}

/// The translations for Korean (`ko`).
class CupertinoLocalizationKo extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Korean.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationKo({
    String localeName = 'ko',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'알림';

  @override
  String get anteMeridiemAbbreviation => r'오전';

  @override
  String get copyButtonLabel => r'복사';

  @override
  String get cutButtonLabel => r'잘라냄';

  @override
  String get datePickerDateOrderString => r'ymd';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour시 정각';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour시 정각';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1분';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute분';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'붙여넣기';

  @override
  String get postMeridiemAbbreviation => r'오후';

  @override
  String get selectAllButtonLabel => r'전체 선택';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'시간';

  @override
  String get timerPickerHourLabelOther => r'시간';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'분';

  @override
  String get timerPickerMinuteLabelOther => r'분';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r'초';

  @override
  String get timerPickerSecondLabelOther => r'초';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'오늘';
}

/// The translations for Lithuanian (`lt`).
class CupertinoLocalizationLt extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Lithuanian.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationLt({
    String localeName = 'lt',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Įspėjimas';

  @override
  String get anteMeridiemAbbreviation => r'priešpiet';

  @override
  String get copyButtonLabel => r'Kopijuoti';

  @override
  String get cutButtonLabel => r'Iškirpti';

  @override
  String get datePickerDateOrderString => r'ymd';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => r'$hour val.';

  @override
  String get datePickerHourSemanticsLabelMany => r'$hour val.';

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour val.';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour val.';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => r'$minute min.';

  @override
  String get datePickerMinuteSemanticsLabelMany => r'$minute min.';

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 min.';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute min.';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Įklijuoti';

  @override
  String get postMeridiemAbbreviation => r'popiet';

  @override
  String get selectAllButtonLabel => r'Pasirinkti viską';

  @override
  String get timerPickerHourLabelFew => r'val.';

  @override
  String get timerPickerHourLabelMany => r'val.';

  @override
  String get timerPickerHourLabelOne => r'val.';

  @override
  String get timerPickerHourLabelOther => r'val.';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => r'min.';

  @override
  String get timerPickerMinuteLabelMany => r'min.';

  @override
  String get timerPickerMinuteLabelOne => r'min.';

  @override
  String get timerPickerMinuteLabelOther => r'min.';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => r'sek.';

  @override
  String get timerPickerSecondLabelMany => r'sek.';

  @override
  String get timerPickerSecondLabelOne => r'sek.';

  @override
  String get timerPickerSecondLabelOther => r'sek.';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Šiandien';
}

/// The translations for Latvian (`lv`).
class CupertinoLocalizationLv extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Latvian.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationLv({
    String localeName = 'lv',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Brīdinājums';

  @override
  String get anteMeridiemAbbreviation => r'priekšpusdienā';

  @override
  String get copyButtonLabel => r'Kopēt';

  @override
  String get cutButtonLabel => r'Izgriezt';

  @override
  String get datePickerDateOrderString => r'mdy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'plkst. $hour';

  @override
  String get datePickerHourSemanticsLabelOther => r'plkst. $hour';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => r'plkst. $hour';

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 minūte';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute minūtes';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => r'$minute minūtes';

  @override
  String get pasteButtonLabel => r'Ielīmēt';

  @override
  String get postMeridiemAbbreviation => r'pēcpusdienā';

  @override
  String get selectAllButtonLabel => r'Atlasīt visu';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'h';

  @override
  String get timerPickerHourLabelOther => r'h';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => r'h';

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'min';

  @override
  String get timerPickerMinuteLabelOther => r'min';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => r'min';

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r's';

  @override
  String get timerPickerSecondLabelOther => r's';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => r's';

  @override
  String get todayLabel => r'Šodien';
}

/// The translations for Mongolian (`mn`).
class CupertinoLocalizationMn extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Mongolian.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationMn({
    String localeName = 'mn',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Сэрэмжлүүлэг';

  @override
  String get anteMeridiemAbbreviation => r'ӨГЛӨӨ';

  @override
  String get copyButtonLabel => r'Хуулах';

  @override
  String get cutButtonLabel => r'Таслах';

  @override
  String get datePickerDateOrderString => r'mdy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour цаг';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour цаг';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 минут';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute минут';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Буулгах';

  @override
  String get postMeridiemAbbreviation => r'ОРОЙ';

  @override
  String get selectAllButtonLabel => r'Бүгдийг сонгох';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'цаг';

  @override
  String get timerPickerHourLabelOther => r'цаг';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'минут.';

  @override
  String get timerPickerMinuteLabelOther => r'минут.';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r'секунд.';

  @override
  String get timerPickerSecondLabelOther => r'секунд.';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Өнөөдөр';
}

/// The translations for Marathi (`mr`).
class CupertinoLocalizationMr extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Marathi.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationMr({
    String localeName = 'mr',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'सूचना';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get copyButtonLabel => r'कॉपी करा';

  @override
  String get cutButtonLabel => r'कट करा';

  @override
  String get datePickerDateOrderString => r'mdy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour वाजता';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour वाजता';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'एक मिनिट';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute मिनिटे';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'पेस्ट करा';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get selectAllButtonLabel => r'सर्व निवडा';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'तास';

  @override
  String get timerPickerHourLabelOther => r'तास';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'मि.';

  @override
  String get timerPickerMinuteLabelOther => r'मि.';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r'से.';

  @override
  String get timerPickerSecondLabelOther => r'से.';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'आज';
}

/// The translations for Malay (`ms`).
class CupertinoLocalizationMs extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Malay.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationMs({
    String localeName = 'ms',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Makluman';

  @override
  String get anteMeridiemAbbreviation => r'PG';

  @override
  String get copyButtonLabel => r'Salin';

  @override
  String get cutButtonLabel => r'Potong';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'Pukul $hour';

  @override
  String get datePickerHourSemanticsLabelOther => r'Pukul $hour';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 minit';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute minit';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Tampal';

  @override
  String get postMeridiemAbbreviation => r'PTG';

  @override
  String get selectAllButtonLabel => r'Pilih Semua';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'jam';

  @override
  String get timerPickerHourLabelOther => r'jam';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'minit';

  @override
  String get timerPickerMinuteLabelOther => r'minit';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r'saat';

  @override
  String get timerPickerSecondLabelOther => r'saat';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Hari ini';
}

/// The translations for Norwegian Bokmål (`nb`).
class CupertinoLocalizationNb extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Norwegian Bokmål.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationNb({
    String localeName = 'nb',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Varsel';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get copyButtonLabel => r'Kopiér';

  @override
  String get cutButtonLabel => r'Klipp ut';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour null-null';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour null-null';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 minutt';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute minutter';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Lim inn';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get selectAllButtonLabel => r'Velg alle';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'time';

  @override
  String get timerPickerHourLabelOther => r'timer';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'min.';

  @override
  String get timerPickerMinuteLabelOther => r'min.';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r'sek.';

  @override
  String get timerPickerSecondLabelOther => r'sek.';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'I dag';
}

/// The translations for Dutch Flemish (`nl`).
class CupertinoLocalizationNl extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Dutch Flemish.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationNl({
    String localeName = 'nl',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Melding';

  @override
  String get anteMeridiemAbbreviation => r'am';

  @override
  String get copyButtonLabel => r'Kopiëren';

  @override
  String get cutButtonLabel => r'Knippen';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour uur';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour uur';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 minuut';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute minuten';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Plakken';

  @override
  String get postMeridiemAbbreviation => r'pm';

  @override
  String get selectAllButtonLabel => r'Alles selecteren';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'uur';

  @override
  String get timerPickerHourLabelOther => r'uur';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'min.';

  @override
  String get timerPickerMinuteLabelOther => r'min.';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r'sec.';

  @override
  String get timerPickerSecondLabelOther => r'sec.';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Vandaag';
}

/// The translations for Polish (`pl`).
class CupertinoLocalizationPl extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Polish.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationPl({
    String localeName = 'pl',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Alert';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get copyButtonLabel => r'Kopiuj';

  @override
  String get cutButtonLabel => r'Wytnij';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => r'$hour';

  @override
  String get datePickerHourSemanticsLabelMany => r'$hour';

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => r'$minute minuty';

  @override
  String get datePickerMinuteSemanticsLabelMany => r'$minute minut';

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 minuta';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute minuty';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Wklej';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get selectAllButtonLabel => r'Wybierz wszystkie';

  @override
  String get timerPickerHourLabelFew => r'godziny';

  @override
  String get timerPickerHourLabelMany => r'godzin';

  @override
  String get timerPickerHourLabelOne => r'godzina';

  @override
  String get timerPickerHourLabelOther => r'godziny';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => r'min';

  @override
  String get timerPickerMinuteLabelMany => r'min';

  @override
  String get timerPickerMinuteLabelOne => r'min';

  @override
  String get timerPickerMinuteLabelOther => r'min';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => r's';

  @override
  String get timerPickerSecondLabelMany => r's';

  @override
  String get timerPickerSecondLabelOne => r's';

  @override
  String get timerPickerSecondLabelOther => r's';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Dziś';
}

/// The translations for Portuguese (`pt`).
class CupertinoLocalizationPt extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Portuguese.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationPt({
    String localeName = 'pt',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Alerta';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get copyButtonLabel => r'Copiar';

  @override
  String get cutButtonLabel => r'Cortar';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour hora';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour horas';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 minuto';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute minutos';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Colar';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get selectAllButtonLabel => r'Selecionar Tudo';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'hora';

  @override
  String get timerPickerHourLabelOther => r'horas';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'min';

  @override
  String get timerPickerMinuteLabelOther => r'min';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r's';

  @override
  String get timerPickerSecondLabelOther => r's';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Hoje';
}

/// The translations for Portuguese, as used in Portugal (`pt_PT`).
class CupertinoLocalizationPtPt extends CupertinoLocalizationPt {
  /// Create an instance of the translation bundle for Portuguese, as used in Portugal.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationPtPt({
    String localeName = 'pt_PT',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour hora';

  @override
  String get timerPickerSecondLabelOne => r'seg';

  @override
  String get timerPickerSecondLabelOther => r'seg';

  @override
  String get selectAllButtonLabel => r'Selecionar tudo';
}

/// The translations for Romanian Moldavian Moldovan (`ro`).
class CupertinoLocalizationRo extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Romanian Moldavian Moldovan.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationRo({
    String localeName = 'ro',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Alertă';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get copyButtonLabel => r'Copiați';

  @override
  String get cutButtonLabel => r'Decupați';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => r'Ora $hour';

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'Ora $hour';

  @override
  String get datePickerHourSemanticsLabelOther => r'Ora $hour';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => r'$minute minute';

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 minut';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute de minute';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Inserați';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get selectAllButtonLabel => r'Selectați-le pe toate';

  @override
  String get timerPickerHourLabelFew => r'ore';

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'oră';

  @override
  String get timerPickerHourLabelOther => r'de ore';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => r'min.';

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'min.';

  @override
  String get timerPickerMinuteLabelOther => r'min.';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => r'sec.';

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r'sec.';

  @override
  String get timerPickerSecondLabelOther => r'sec.';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Azi';
}

/// The translations for Russian (`ru`).
class CupertinoLocalizationRu extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Russian.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationRu({
    String localeName = 'ru',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Оповещение';

  @override
  String get anteMeridiemAbbreviation => r'АМ';

  @override
  String get copyButtonLabel => r'Копировать';

  @override
  String get cutButtonLabel => r'Вырезать';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => r'$hour часа';

  @override
  String get datePickerHourSemanticsLabelMany => r'$hour часов';

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour час';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour часа';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => r'$minute минуты';

  @override
  String get datePickerMinuteSemanticsLabelMany => r'$minute минут';

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 минута';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute минуты';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Вставить';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get selectAllButtonLabel => r'Выбрать все';

  @override
  String get timerPickerHourLabelFew => r'часа';

  @override
  String get timerPickerHourLabelMany => r'часов';

  @override
  String get timerPickerHourLabelOne => r'час';

  @override
  String get timerPickerHourLabelOther => r'часа';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => r'мин.';

  @override
  String get timerPickerMinuteLabelMany => r'мин.';

  @override
  String get timerPickerMinuteLabelOne => r'мин.';

  @override
  String get timerPickerMinuteLabelOther => r'мин.';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => r'сек.';

  @override
  String get timerPickerSecondLabelMany => r'сек.';

  @override
  String get timerPickerSecondLabelOne => r'сек.';

  @override
  String get timerPickerSecondLabelOther => r'сек.';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Сегодня';
}

/// The translations for Slovak (`sk`).
class CupertinoLocalizationSk extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Slovak.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationSk({
    String localeName = 'sk',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Upozornenie';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get copyButtonLabel => r'Kopírovať';

  @override
  String get cutButtonLabel => r'Vystrihnúť';

  @override
  String get datePickerDateOrderString => r'mdy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => r'$hour hodiny';

  @override
  String get datePickerHourSemanticsLabelMany => r'$hour hodiny';

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour hodina';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour hodín';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => r'$minute minúty';

  @override
  String get datePickerMinuteSemanticsLabelMany => r'$minute minúty';

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 minúta';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute minút';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Prilepiť';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get selectAllButtonLabel => r'Vybrať všetko';

  @override
  String get timerPickerHourLabelFew => r'hodiny';

  @override
  String get timerPickerHourLabelMany => r'hodiny';

  @override
  String get timerPickerHourLabelOne => r'hodina';

  @override
  String get timerPickerHourLabelOther => r'hodín';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => r'min';

  @override
  String get timerPickerMinuteLabelMany => r'min';

  @override
  String get timerPickerMinuteLabelOne => r'min';

  @override
  String get timerPickerMinuteLabelOther => r'min';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => r's';

  @override
  String get timerPickerSecondLabelMany => r's';

  @override
  String get timerPickerSecondLabelOne => r's';

  @override
  String get timerPickerSecondLabelOther => r's';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Dnes';
}

/// The translations for Slovenian (`sl`).
class CupertinoLocalizationSl extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Slovenian.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationSl({
    String localeName = 'sl',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Opozorilo';

  @override
  String get anteMeridiemAbbreviation => r'DOP.';

  @override
  String get copyButtonLabel => r'Kopiraj';

  @override
  String get cutButtonLabel => r'Izreži';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => r'$hour';

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour';

  @override
  String get datePickerHourSemanticsLabelTwo => r'$hour';

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => r'$minute minute';

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 minuta';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute minut';

  @override
  String get datePickerMinuteSemanticsLabelTwo => r'$minute minuti';

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Prilepi';

  @override
  String get postMeridiemAbbreviation => r'POP.';

  @override
  String get selectAllButtonLabel => r'Izberi vse';

  @override
  String get timerPickerHourLabelFew => r'ure';

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'ura';

  @override
  String get timerPickerHourLabelOther => r'ure';

  @override
  String get timerPickerHourLabelTwo => r'ure';

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => r'min';

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'min';

  @override
  String get timerPickerMinuteLabelOther => r'min';

  @override
  String get timerPickerMinuteLabelTwo => r'min';

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => r's';

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r's';

  @override
  String get timerPickerSecondLabelOther => r's';

  @override
  String get timerPickerSecondLabelTwo => r's';

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Danes';
}

/// The translations for Serbian (`sr`).
class CupertinoLocalizationSr extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Serbian.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationSr({
    String localeName = 'sr',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Обавештење';

  @override
  String get anteMeridiemAbbreviation => r'пре подне';

  @override
  String get copyButtonLabel => r'Копирај';

  @override
  String get cutButtonLabel => r'Исеци';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => r'$hour сата';

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour сат';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour сати';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => r'$minute минута';

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 минут';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute минута';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Налепи';

  @override
  String get postMeridiemAbbreviation => r'по подне';

  @override
  String get selectAllButtonLabel => r'Изабери све';

  @override
  String get timerPickerHourLabelFew => r'сата';

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'сат';

  @override
  String get timerPickerHourLabelOther => r'сати';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => r'мин';

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'мин';

  @override
  String get timerPickerMinuteLabelOther => r'мин';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => r'сек';

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r'сек';

  @override
  String get timerPickerSecondLabelOther => r'сек';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Данас';
}

/// The translations for Serbian, using the Cyrillic script (`sr_Cyrl`).
class CupertinoLocalizationSrCyrl extends CupertinoLocalizationSr {
  /// Create an instance of the translation bundle for Serbian, using the Cyrillic script.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationSrCyrl({
    String localeName = 'sr_Cyrl',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );
}

/// The translations for Serbian, using the Latin script (`sr_Latn`).
class CupertinoLocalizationSrLatn extends CupertinoLocalizationSr {
  /// Create an instance of the translation bundle for Serbian, using the Latin script.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationSrLatn({
    String localeName = 'sr_Latn',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get datePickerHourSemanticsLabelFew => r'$hour sata';

  @override
  String get datePickerMinuteSemanticsLabelFew => r'$minute minuta';

  @override
  String get timerPickerHourLabelFew => r'sata';

  @override
  String get timerPickerMinuteLabelFew => r'min';

  @override
  String get timerPickerSecondLabelFew => r'sek';

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour sat';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour sati';

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 minut';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute minuta';

  @override
  String get anteMeridiemAbbreviation => r'pre podne';

  @override
  String get postMeridiemAbbreviation => r'po podne';

  @override
  String get todayLabel => r'Danas';

  @override
  String get alertDialogLabel => r'Obaveštenje';

  @override
  String get timerPickerHourLabelOne => r'sat';

  @override
  String get timerPickerHourLabelOther => r'sati';

  @override
  String get timerPickerMinuteLabelOne => r'min';

  @override
  String get timerPickerMinuteLabelOther => r'min';

  @override
  String get timerPickerSecondLabelOne => r'sek';

  @override
  String get timerPickerSecondLabelOther => r'sek';

  @override
  String get cutButtonLabel => r'Iseci';

  @override
  String get copyButtonLabel => r'Kopiraj';

  @override
  String get pasteButtonLabel => r'Nalepi';

  @override
  String get selectAllButtonLabel => r'Izaberi sve';
}

/// The translations for Swedish (`sv`).
class CupertinoLocalizationSv extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Swedish.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationSv({
    String localeName = 'sv',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Varning';

  @override
  String get anteMeridiemAbbreviation => r'FM';

  @override
  String get copyButtonLabel => r'Kopiera';

  @override
  String get cutButtonLabel => r'Klipp ut';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'Klockan $hour';

  @override
  String get datePickerHourSemanticsLabelOther => r'Klockan $hour';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 minut';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute minuter';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Klistra in';

  @override
  String get postMeridiemAbbreviation => r'EM';

  @override
  String get selectAllButtonLabel => r'Markera alla';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'timme';

  @override
  String get timerPickerHourLabelOther => r'timmar';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'min';

  @override
  String get timerPickerMinuteLabelOther => r'min';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r'sek';

  @override
  String get timerPickerSecondLabelOther => r'sek';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'I dag';
}

/// The translations for Swahili (`sw`).
class CupertinoLocalizationSw extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Swahili.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationSw({
    String localeName = 'sw',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Arifa';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get copyButtonLabel => r'Nakili';

  @override
  String get cutButtonLabel => r'Kata';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'Saa $hour kamili';

  @override
  String get datePickerHourSemanticsLabelOther => r'Saa $hour kamili';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'Dakika 1';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'Dakika $minute';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Bandika';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get selectAllButtonLabel => r'Teua Zote';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'saa';

  @override
  String get timerPickerHourLabelOther => r'saa';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'dakika';

  @override
  String get timerPickerMinuteLabelOther => r'dakika';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r'sekunde';

  @override
  String get timerPickerSecondLabelOther => r'sekunde';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Leo';
}

/// The translations for Tamil (`ta`).
class CupertinoLocalizationTa extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Tamil.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationTa({
    String localeName = 'ta',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'விழிப்பூட்டல்';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get copyButtonLabel => r'நகலெடு';

  @override
  String get cutButtonLabel => r'வெட்டு';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour மணி';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour மணி';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 நிமிடம்';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute நிமிடங்கள்';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'ஒட்டு';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get selectAllButtonLabel => r'எல்லாம் தேர்ந்தெடு';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'மணிநேரம்';

  @override
  String get timerPickerHourLabelOther => r'மணிநேரம்';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'நிமி.';

  @override
  String get timerPickerMinuteLabelOther => r'நிமி.';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r'வி.';

  @override
  String get timerPickerSecondLabelOther => r'வி.';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'இன்று';
}

/// The translations for Thai (`th`).
class CupertinoLocalizationTh extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Thai.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationTh({
    String localeName = 'th',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'การแจ้งเตือน';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get copyButtonLabel => r'คัดลอก';

  @override
  String get cutButtonLabel => r'ตัด';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour นาฬิกา';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour นาฬิกา';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 นาที';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute นาที';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'วาง';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get selectAllButtonLabel => r'เลือกทั้งหมด';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'ชั่วโมง';

  @override
  String get timerPickerHourLabelOther => r'ชั่วโมง';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'นาที';

  @override
  String get timerPickerMinuteLabelOther => r'นาที';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r'วินาที';

  @override
  String get timerPickerSecondLabelOther => r'วินาที';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'วันนี้';
}

/// The translations for Tagalog (`tl`).
class CupertinoLocalizationTl extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Tagalog.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationTl({
    String localeName = 'tl',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Alerto';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get copyButtonLabel => r'Kopyahin';

  @override
  String get cutButtonLabel => r'I-cut';

  @override
  String get datePickerDateOrderString => r'mdy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'Ala $hour';

  @override
  String get datePickerHourSemanticsLabelOther => r'Alas $hour';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 minuto';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute na minuto';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'I-paste';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get selectAllButtonLabel => r'Piliin Lahat';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'oras';

  @override
  String get timerPickerHourLabelOther => r'na oras';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'min.';

  @override
  String get timerPickerMinuteLabelOther => r'na min.';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r'seg.';

  @override
  String get timerPickerSecondLabelOther => r'na seg.';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Ngayon';
}

/// The translations for Turkish (`tr`).
class CupertinoLocalizationTr extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Turkish.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationTr({
    String localeName = 'tr',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Uyarı';

  @override
  String get anteMeridiemAbbreviation => r'ÖÖ';

  @override
  String get copyButtonLabel => r'Kopyala';

  @override
  String get cutButtonLabel => r'Kes';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'Saat $hour';

  @override
  String get datePickerHourSemanticsLabelOther => r'Saat $hour';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 dakika';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute dakika';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Yapıştır';

  @override
  String get postMeridiemAbbreviation => r'ÖS';

  @override
  String get selectAllButtonLabel => r'Tümünü Seç';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'saat';

  @override
  String get timerPickerHourLabelOther => r'saat';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'dk.';

  @override
  String get timerPickerMinuteLabelOther => r'dk.';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r'sn.';

  @override
  String get timerPickerSecondLabelOther => r'sn.';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Bugün';
}

/// The translations for Ukrainian (`uk`).
class CupertinoLocalizationUk extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Ukrainian.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationUk({
    String localeName = 'uk',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Сповіщення';

  @override
  String get anteMeridiemAbbreviation => r'дп';

  @override
  String get copyButtonLabel => r'Копіювати';

  @override
  String get cutButtonLabel => r'Вирізати';

  @override
  String get datePickerDateOrderString => r'mdy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => r'$hour години';

  @override
  String get datePickerHourSemanticsLabelMany => r'$hour годин';

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour година';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour години';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => r'$minute хвилини';

  @override
  String get datePickerMinuteSemanticsLabelMany => r'$minute хвилин';

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 хвилина';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute хвилини';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Вставити';

  @override
  String get postMeridiemAbbreviation => r'пп';

  @override
  String get selectAllButtonLabel => r'Вибрати все';

  @override
  String get timerPickerHourLabelFew => r'години';

  @override
  String get timerPickerHourLabelMany => r'годин';

  @override
  String get timerPickerHourLabelOne => r'година';

  @override
  String get timerPickerHourLabelOther => r'години';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => r'хв';

  @override
  String get timerPickerMinuteLabelMany => r'хв';

  @override
  String get timerPickerMinuteLabelOne => r'хв';

  @override
  String get timerPickerMinuteLabelOther => r'хв';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => r'с';

  @override
  String get timerPickerSecondLabelMany => r'с';

  @override
  String get timerPickerSecondLabelOne => r'с';

  @override
  String get timerPickerSecondLabelOther => r'с';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Сьогодні';
}

/// The translations for Urdu (`ur`).
class CupertinoLocalizationUr extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Urdu.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationUr({
    String localeName = 'ur',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'الرٹ';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get copyButtonLabel => r'کاپی کریں';

  @override
  String get cutButtonLabel => r'کٹ کریں';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour بجے';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour بجے';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 منٹ';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute منٹس';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'پیسٹ کریں';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get selectAllButtonLabel => r'سبھی منتخب کریں';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'گھنٹہ';

  @override
  String get timerPickerHourLabelOther => r'گھنٹے';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'منٹ۔';

  @override
  String get timerPickerMinuteLabelOther => r'منٹ۔';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r'سیکنڈ۔';

  @override
  String get timerPickerSecondLabelOther => r'سیکنڈ۔';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'آج';
}

/// The translations for Vietnamese (`vi`).
class CupertinoLocalizationVi extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Vietnamese.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationVi({
    String localeName = 'vi',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Thông báo';

  @override
  String get anteMeridiemAbbreviation => r'SÁNG';

  @override
  String get copyButtonLabel => r'Sao chép';

  @override
  String get cutButtonLabel => r'Cắt';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour giờ';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour giờ';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 phút';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute phút';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'Dán';

  @override
  String get postMeridiemAbbreviation => r'CHIỀU';

  @override
  String get selectAllButtonLabel => r'Chọn tất cả';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'giờ';

  @override
  String get timerPickerHourLabelOther => r'giờ';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'phút';

  @override
  String get timerPickerMinuteLabelOther => r'phút';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r'giây';

  @override
  String get timerPickerSecondLabelOther => r'giây';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'Hôm nay';
}

/// The translations for Chinese (`zh`).
class CupertinoLocalizationZh extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Chinese.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationZh({
    String localeName = 'zh',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'提醒';

  @override
  String get anteMeridiemAbbreviation => r'上午';

  @override
  String get copyButtonLabel => r'复制';

  @override
  String get cutButtonLabel => r'剪切';

  @override
  String get datePickerDateOrderString => r'ymd';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelFew => null;

  @override
  String get datePickerHourSemanticsLabelMany => null;

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour 点';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour 点';

  @override
  String get datePickerHourSemanticsLabelTwo => null;

  @override
  String get datePickerHourSemanticsLabelZero => null;

  @override
  String get datePickerMinuteSemanticsLabelFew => null;

  @override
  String get datePickerMinuteSemanticsLabelMany => null;

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 分钟';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute 分钟';

  @override
  String get datePickerMinuteSemanticsLabelTwo => null;

  @override
  String get datePickerMinuteSemanticsLabelZero => null;

  @override
  String get pasteButtonLabel => r'粘贴';

  @override
  String get postMeridiemAbbreviation => r'下午';

  @override
  String get selectAllButtonLabel => r'全选';

  @override
  String get timerPickerHourLabelFew => null;

  @override
  String get timerPickerHourLabelMany => null;

  @override
  String get timerPickerHourLabelOne => r'小时';

  @override
  String get timerPickerHourLabelOther => r'小时';

  @override
  String get timerPickerHourLabelTwo => null;

  @override
  String get timerPickerHourLabelZero => null;

  @override
  String get timerPickerMinuteLabelFew => null;

  @override
  String get timerPickerMinuteLabelMany => null;

  @override
  String get timerPickerMinuteLabelOne => r'分钟';

  @override
  String get timerPickerMinuteLabelOther => r'分钟';

  @override
  String get timerPickerMinuteLabelTwo => null;

  @override
  String get timerPickerMinuteLabelZero => null;

  @override
  String get timerPickerSecondLabelFew => null;

  @override
  String get timerPickerSecondLabelMany => null;

  @override
  String get timerPickerSecondLabelOne => r'秒';

  @override
  String get timerPickerSecondLabelOther => r'秒';

  @override
  String get timerPickerSecondLabelTwo => null;

  @override
  String get timerPickerSecondLabelZero => null;

  @override
  String get todayLabel => r'今天';
}

/// The translations for Chinese, using the Han script (`zh_Hans`).
class CupertinoLocalizationZhHans extends CupertinoLocalizationZh {
  /// Create an instance of the translation bundle for Chinese, using the Han script.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationZhHans({
    String localeName = 'zh_Hans',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );
}

/// The translations for Chinese, using the Han script (`zh_Hant`).
class CupertinoLocalizationZhHant extends CupertinoLocalizationZh {
  /// Create an instance of the translation bundle for Chinese, using the Han script.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationZhHant({
    String localeName = 'zh_Hant',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour 點';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour 點';

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 分';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute 分';

  @override
  String get alertDialogLabel => r'快訊';

  @override
  String get timerPickerHourLabelOne => r'小時';

  @override
  String get timerPickerHourLabelOther => r'小時';

  @override
  String get timerPickerMinuteLabelOne => r'分';

  @override
  String get timerPickerMinuteLabelOther => r'分';

  @override
  String get cutButtonLabel => r'剪下';

  @override
  String get copyButtonLabel => r'複製';

  @override
  String get pasteButtonLabel => r'貼上';

  @override
  String get selectAllButtonLabel => r'全選';
}

/// The translations for Chinese, as used in Hong Kong, using the Han script (`zh_Hant_HK`).
class CupertinoLocalizationZhHantHk extends CupertinoLocalizationZhHant {
  /// Create an instance of the translation bundle for Chinese, as used in Hong Kong, using the Han script.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationZhHantHk({
    String localeName = 'zh_Hant_HK',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );
}

/// The translations for Chinese, as used in Taiwan, using the Han script (`zh_Hant_TW`).
class CupertinoLocalizationZhHantTw extends CupertinoLocalizationZhHant {
  /// Create an instance of the translation bundle for Chinese, as used in Taiwan, using the Han script.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationZhHantTw({
    String localeName = 'zh_Hant_TW',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );
}

/// The set of supported languages, as language code strings.
///
/// The [GlobalCupertinoLocalizations.delegate] can generate localizations for
/// any [Locale] with a language code from this set, regardless of the region.
/// Some regions have specific support (e.g. `de` covers all forms of German,
/// but there is support for `de-CH` specifically to override some of the
/// translations for Switzerland).
///
/// See also:
///
///  * [getCupertinoTranslation], whose documentation describes these values.
final Set<String> kCupertinoSupportedLanguages = HashSet<String>.from(const <String>[
  'ar', // Arabic
  'bg', // Bulgarian
  'bs', // Bosnian
  'ca', // Catalan Valencian
  'cs', // Czech
  'da', // Danish
  'de', // German
  'el', // Modern Greek
  'en', // English
  'es', // Spanish Castilian
  'et', // Estonian
  'fa', // Persian
  'fi', // Finnish
  'fil', // Filipino Pilipino
  'fr', // French
  'gl', // Galician
  'gsw', // Swiss German Alemannic Alsatian
  'he', // Hebrew
  'hi', // Hindi
  'hr', // Croatian
  'hu', // Hungarian
  'hy', // Armenian
  'id', // Indonesian
  'it', // Italian
  'ja', // Japanese
  'kk', // Kazakh
  'km', // Khmer Central Khmer
  'ko', // Korean
  'lt', // Lithuanian
  'lv', // Latvian
  'mn', // Mongolian
  'mr', // Marathi
  'ms', // Malay
  'nb', // Norwegian Bokmål
  'nl', // Dutch Flemish
  'pl', // Polish
  'pt', // Portuguese
  'ro', // Romanian Moldavian Moldovan
  'ru', // Russian
  'sk', // Slovak
  'sl', // Slovenian
  'sr', // Serbian
  'sv', // Swedish
  'sw', // Swahili
  'ta', // Tamil
  'th', // Thai
  'tl', // Tagalog
  'tr', // Turkish
  'uk', // Ukrainian
  'ur', // Urdu
  'vi', // Vietnamese
  'zh', // Chinese
]);

/// Creates a [GlobalCupertinoLocalizations] instance for the given `locale`.
///
/// All of the function's arguments except `locale` will be passed to the [
/// GlobalCupertinoLocalizations] constructor. (The `localeName` argument of that
/// constructor is specified by the actual subclass constructor by this
/// function.)
///
/// The following locales are supported by this package:
///
/// {@template flutter.localizations.cupertino.languages}
///  * `ar` - Arabic
///  * `bg` - Bulgarian
///  * `bs` - Bosnian
///  * `ca` - Catalan Valencian
///  * `cs` - Czech
///  * `da` - Danish
///  * `de` - German
///  * `el` - Modern Greek
///  * `en` - English (plus 7 country variations)
///  * `es` - Spanish Castilian (plus 20 country variations)
///  * `et` - Estonian
///  * `fa` - Persian
///  * `fi` - Finnish
///  * `fil` - Filipino Pilipino
///  * `fr` - French
///  * `gl` - Galician
///  * `gsw` - Swiss German Alemannic Alsatian
///  * `he` - Hebrew
///  * `hi` - Hindi
///  * `hr` - Croatian
///  * `hu` - Hungarian
///  * `hy` - Armenian
///  * `id` - Indonesian
///  * `it` - Italian
///  * `ja` - Japanese
///  * `kk` - Kazakh
///  * `km` - Khmer Central Khmer
///  * `ko` - Korean
///  * `lt` - Lithuanian
///  * `lv` - Latvian
///  * `mn` - Mongolian
///  * `mr` - Marathi
///  * `ms` - Malay
///  * `nb` - Norwegian Bokmål
///  * `nl` - Dutch Flemish
///  * `pl` - Polish
///  * `pt` - Portuguese (plus one country variation)
///  * `ro` - Romanian Moldavian Moldovan
///  * `ru` - Russian
///  * `sk` - Slovak
///  * `sl` - Slovenian
///  * `sr` - Serbian (plus 2 scripts)
///  * `sv` - Swedish
///  * `sw` - Swahili
///  * `ta` - Tamil
///  * `th` - Thai
///  * `tl` - Tagalog
///  * `tr` - Turkish
///  * `uk` - Ukrainian
///  * `ur` - Urdu
///  * `vi` - Vietnamese
///  * `zh` - Chinese (plus 2 country variations and 2 scripts)
/// {@endtemplate}
///
/// Generally speaking, this method is only intended to be used by
/// [GlobalCupertinoLocalizations.delegate].
GlobalCupertinoLocalizations getCupertinoTranslation(
  Locale locale,
  intl.DateFormat fullYearFormat,
  intl.DateFormat dayFormat,
  intl.DateFormat mediumDateFormat,
  intl.DateFormat singleDigitHourFormat,
  intl.DateFormat singleDigitMinuteFormat,
  intl.DateFormat doubleDigitMinuteFormat,
  intl.DateFormat singleDigitSecondFormat,
  intl.NumberFormat decimalFormat,
) {
  switch (locale.languageCode) {
    case 'ar':
      return CupertinoLocalizationAr(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'bg':
      return CupertinoLocalizationBg(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'bs':
      return CupertinoLocalizationBs(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'ca':
      return CupertinoLocalizationCa(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'cs':
      return CupertinoLocalizationCs(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'da':
      return CupertinoLocalizationDa(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'de':
      return CupertinoLocalizationDe(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'el':
      return CupertinoLocalizationEl(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'en': {
      switch (locale.countryCode) {
        case 'AU':
          return CupertinoLocalizationEnAu(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
        case 'CA':
          return CupertinoLocalizationEnCa(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
        case 'GB':
          return CupertinoLocalizationEnGb(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
        case 'IE':
          return CupertinoLocalizationEnIe(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
        case 'IN':
          return CupertinoLocalizationEnIn(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
        case 'SG':
          return CupertinoLocalizationEnSg(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
        case 'ZA':
          return CupertinoLocalizationEnZa(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
      }
      return CupertinoLocalizationEn(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    }
    case 'es': {
      switch (locale.countryCode) {
        case '419':
          return CupertinoLocalizationEs419(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
        case 'AR':
          return CupertinoLocalizationEsAr(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
        case 'BO':
          return CupertinoLocalizationEsBo(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
        case 'CL':
          return CupertinoLocalizationEsCl(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
        case 'CO':
          return CupertinoLocalizationEsCo(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
        case 'CR':
          return CupertinoLocalizationEsCr(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
        case 'DO':
          return CupertinoLocalizationEsDo(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
        case 'EC':
          return CupertinoLocalizationEsEc(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
        case 'GT':
          return CupertinoLocalizationEsGt(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
        case 'HN':
          return CupertinoLocalizationEsHn(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
        case 'MX':
          return CupertinoLocalizationEsMx(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
        case 'NI':
          return CupertinoLocalizationEsNi(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
        case 'PA':
          return CupertinoLocalizationEsPa(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
        case 'PE':
          return CupertinoLocalizationEsPe(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
        case 'PR':
          return CupertinoLocalizationEsPr(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
        case 'PY':
          return CupertinoLocalizationEsPy(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
        case 'SV':
          return CupertinoLocalizationEsSv(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
        case 'US':
          return CupertinoLocalizationEsUs(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
        case 'UY':
          return CupertinoLocalizationEsUy(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
        case 'VE':
          return CupertinoLocalizationEsVe(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
      }
      return CupertinoLocalizationEs(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    }
    case 'et':
      return CupertinoLocalizationEt(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'fa':
      return CupertinoLocalizationFa(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'fi':
      return CupertinoLocalizationFi(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'fil':
      return CupertinoLocalizationFil(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'fr':
      return CupertinoLocalizationFr(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'gl':
      return CupertinoLocalizationGl(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'gsw':
      return CupertinoLocalizationGsw(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'he':
      return CupertinoLocalizationHe(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'hi':
      return CupertinoLocalizationHi(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'hr':
      return CupertinoLocalizationHr(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'hu':
      return CupertinoLocalizationHu(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'hy':
      return CupertinoLocalizationHy(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'id':
      return CupertinoLocalizationId(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'it':
      return CupertinoLocalizationIt(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'ja':
      return CupertinoLocalizationJa(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'kk':
      return CupertinoLocalizationKk(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'km':
      return CupertinoLocalizationKm(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'ko':
      return CupertinoLocalizationKo(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'lt':
      return CupertinoLocalizationLt(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'lv':
      return CupertinoLocalizationLv(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'mn':
      return CupertinoLocalizationMn(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'mr':
      return CupertinoLocalizationMr(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'ms':
      return CupertinoLocalizationMs(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'nb':
      return CupertinoLocalizationNb(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'nl':
      return CupertinoLocalizationNl(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'pl':
      return CupertinoLocalizationPl(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'pt': {
      switch (locale.countryCode) {
        case 'PT':
          return CupertinoLocalizationPtPt(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
      }
      return CupertinoLocalizationPt(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    }
    case 'ro':
      return CupertinoLocalizationRo(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'ru':
      return CupertinoLocalizationRu(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'sk':
      return CupertinoLocalizationSk(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'sl':
      return CupertinoLocalizationSl(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'sr': {
      switch (locale.scriptCode) {
        case 'Cyrl': {
          return CupertinoLocalizationSrCyrl(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
        }
        case 'Latn': {
          return CupertinoLocalizationSrLatn(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
        }
      }
      return CupertinoLocalizationSr(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    }
    case 'sv':
      return CupertinoLocalizationSv(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'sw':
      return CupertinoLocalizationSw(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'ta':
      return CupertinoLocalizationTa(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'th':
      return CupertinoLocalizationTh(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'tl':
      return CupertinoLocalizationTl(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'tr':
      return CupertinoLocalizationTr(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'uk':
      return CupertinoLocalizationUk(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'ur':
      return CupertinoLocalizationUr(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'vi':
      return CupertinoLocalizationVi(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'zh': {
      switch (locale.scriptCode) {
        case 'Hans': {
          return CupertinoLocalizationZhHans(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
        }
        case 'Hant': {
          switch (locale.countryCode) {
            case 'HK':
              return CupertinoLocalizationZhHantHk(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
            case 'TW':
              return CupertinoLocalizationZhHantTw(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
          }
          return CupertinoLocalizationZhHant(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
        }
      }
      switch (locale.countryCode) {
        case 'HK':
          return CupertinoLocalizationZhHantHk(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
        case 'TW':
          return CupertinoLocalizationZhHantTw(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
      }
      return CupertinoLocalizationZh(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    }
  }
  assert(false, 'getCupertinoTranslation() called for unsupported locale "$locale"');
  return null;
}
