/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.platform;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.embedding.engine.systemchannels.PlatformViewsChannel;
import io.flutter.plugin.editing.TextInputPlugin;
import io.flutter.plugin.platform.AccessibilityEventsDelegate;
import io.flutter.plugin.platform.PlatformViewFactory;
import io.flutter.plugin.platform.PlatformViewRegistry;
import io.flutter.plugin.platform.PlatformViewRegistryImpl;
import io.flutter.plugin.platform.PlatformViewsAccessibilityDelegate;
import io.flutter.plugin.platform.VirtualDisplayController;
import io.flutter.view.AccessibilityBridge;
import io.flutter.view.TextureRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PlatformViewsController
implements PlatformViewsAccessibilityDelegate {
    private static final String TAG = "PlatformViewsController";
    private static final int MINIMAL_SDK = 20;
    private final PlatformViewRegistryImpl registry;
    private Context context;
    private View flutterView;
    private TextureRegistry textureRegistry;
    private TextInputPlugin textInputPlugin;
    private PlatformViewsChannel platformViewsChannel;
    private final AccessibilityEventsDelegate accessibilityEventsDelegate;
    @VisibleForTesting
    final HashMap<Integer, VirtualDisplayController> vdControllers;
    private final HashMap<Context, View> contextToPlatformView;
    private final PlatformViewsChannel.PlatformViewsHandler channelHandler = new PlatformViewsChannel.PlatformViewsHandler(){

        @Override
        @TargetApi(value=17)
        public long createPlatformView(@NonNull PlatformViewsChannel.PlatformViewCreationRequest request) {
            this.ensureValidAndroidVersion();
            if (!PlatformViewsController.validateDirection(request.direction)) {
                throw new IllegalStateException("Trying to create a view with unknown direction value: " + request.direction + "(view id: " + request.viewId + ")");
            }
            if (PlatformViewsController.this.vdControllers.containsKey(request.viewId)) {
                throw new IllegalStateException("Trying to create an already created platform view, view id: " + request.viewId);
            }
            PlatformViewFactory viewFactory = PlatformViewsController.this.registry.getFactory(request.viewType);
            if (viewFactory == null) {
                throw new IllegalStateException("Trying to create a platform view of unregistered type: " + request.viewType);
            }
            Object createParams = null;
            if (request.params != null) {
                createParams = viewFactory.getCreateArgsCodec().decodeMessage(request.params);
            }
            int physicalWidth = PlatformViewsController.this.toPhysicalPixels(request.logicalWidth);
            int physicalHeight = PlatformViewsController.this.toPhysicalPixels(request.logicalHeight);
            PlatformViewsController.this.validateVirtualDisplayDimensions(physicalWidth, physicalHeight);
            TextureRegistry.SurfaceTextureEntry textureEntry = PlatformViewsController.this.textureRegistry.createSurfaceTexture();
            VirtualDisplayController vdController = VirtualDisplayController.create(PlatformViewsController.this.context, PlatformViewsController.this.accessibilityEventsDelegate, viewFactory, textureEntry, physicalWidth, physicalHeight, request.viewId, createParams, (view, hasFocus) -> {
                if (hasFocus) {
                    PlatformViewsController.this.platformViewsChannel.invokeViewFocused(request.viewId);
                }
            });
            if (vdController == null) {
                throw new IllegalStateException("Failed creating virtual display for a " + request.viewType + " with id: " + request.viewId);
            }
            if (PlatformViewsController.this.flutterView != null) {
                vdController.onFlutterViewAttached(PlatformViewsController.this.flutterView);
            }
            PlatformViewsController.this.vdControllers.put(request.viewId, vdController);
            View platformView = vdController.getView();
            platformView.setLayoutDirection(request.direction);
            PlatformViewsController.this.contextToPlatformView.put(platformView.getContext(), platformView);
            return textureEntry.id();
        }

        @Override
        public void disposePlatformView(int viewId) {
            this.ensureValidAndroidVersion();
            VirtualDisplayController vdController = PlatformViewsController.this.vdControllers.get(viewId);
            if (vdController == null) {
                throw new IllegalStateException("Trying to dispose a platform view with unknown id: " + viewId);
            }
            if (PlatformViewsController.this.textInputPlugin != null) {
                PlatformViewsController.this.textInputPlugin.clearPlatformViewClient(viewId);
            }
            PlatformViewsController.this.contextToPlatformView.remove(vdController.getView().getContext());
            vdController.dispose();
            PlatformViewsController.this.vdControllers.remove(viewId);
        }

        @Override
        public void resizePlatformView(@NonNull PlatformViewsChannel.PlatformViewResizeRequest request, final @NonNull Runnable onComplete) {
            this.ensureValidAndroidVersion();
            final VirtualDisplayController vdController = PlatformViewsController.this.vdControllers.get(request.viewId);
            if (vdController == null) {
                throw new IllegalStateException("Trying to resize a platform view with unknown id: " + request.viewId);
            }
            int physicalWidth = PlatformViewsController.this.toPhysicalPixels(request.newLogicalWidth);
            int physicalHeight = PlatformViewsController.this.toPhysicalPixels(request.newLogicalHeight);
            PlatformViewsController.this.validateVirtualDisplayDimensions(physicalWidth, physicalHeight);
            PlatformViewsController.this.lockInputConnection(vdController);
            vdController.resize(physicalWidth, physicalHeight, new Runnable(){

                @Override
                public void run() {
                    PlatformViewsController.this.unlockInputConnection(vdController);
                    onComplete.run();
                }
            });
        }

        @Override
        public void onTouch(@NonNull PlatformViewsChannel.PlatformViewTouch touch) {
            this.ensureValidAndroidVersion();
            float density = ((PlatformViewsController)PlatformViewsController.this).context.getResources().getDisplayMetrics().density;
            MotionEvent.PointerProperties[] pointerProperties = PlatformViewsController.parsePointerPropertiesList(touch.rawPointerPropertiesList).toArray(new MotionEvent.PointerProperties[touch.pointerCount]);
            MotionEvent.PointerCoords[] pointerCoords = PlatformViewsController.parsePointerCoordsList(touch.rawPointerCoords, density).toArray(new MotionEvent.PointerCoords[touch.pointerCount]);
            if (!PlatformViewsController.this.vdControllers.containsKey(touch.viewId)) {
                throw new IllegalStateException("Sending touch to an unknown view with id: " + touch.viewId);
            }
            View view = PlatformViewsController.this.vdControllers.get(touch.viewId).getView();
            MotionEvent event = MotionEvent.obtain((long)touch.downTime.longValue(), (long)touch.eventTime.longValue(), (int)touch.action, (int)touch.pointerCount, (MotionEvent.PointerProperties[])pointerProperties, (MotionEvent.PointerCoords[])pointerCoords, (int)touch.metaState, (int)touch.buttonState, (float)touch.xPrecision, (float)touch.yPrecision, (int)touch.deviceId, (int)touch.edgeFlags, (int)touch.source, (int)touch.flags);
            view.dispatchTouchEvent(event);
        }

        @Override
        @TargetApi(value=17)
        public void setDirection(int viewId, int direction) {
            this.ensureValidAndroidVersion();
            if (!PlatformViewsController.validateDirection(direction)) {
                throw new IllegalStateException("Trying to set unknown direction value: " + direction + "(view id: " + viewId + ")");
            }
            View view = PlatformViewsController.this.vdControllers.get(viewId).getView();
            if (view == null) {
                throw new IllegalStateException("Sending touch to an unknown view with id: " + direction);
            }
            view.setLayoutDirection(direction);
        }

        @Override
        public void clearFocus(int viewId) {
            View view = PlatformViewsController.this.vdControllers.get(viewId).getView();
            view.clearFocus();
        }

        private void ensureValidAndroidVersion() {
            if (Build.VERSION.SDK_INT < 20) {
                throw new IllegalStateException("Trying to use platform views with API " + Build.VERSION.SDK_INT + ", required API level is: " + 20);
            }
        }
    };

    public PlatformViewsController() {
        this.registry = new PlatformViewRegistryImpl();
        this.vdControllers = new HashMap();
        this.accessibilityEventsDelegate = new AccessibilityEventsDelegate();
        this.contextToPlatformView = new HashMap();
    }

    public void attach(Context context, TextureRegistry textureRegistry, @NonNull DartExecutor dartExecutor) {
        if (this.context != null) {
            throw new AssertionError((Object)"A PlatformViewsController can only be attached to a single output target.\nattach was called while the PlatformViewsController was already attached.");
        }
        this.context = context;
        this.textureRegistry = textureRegistry;
        this.platformViewsChannel = new PlatformViewsChannel(dartExecutor);
        this.platformViewsChannel.setPlatformViewsHandler(this.channelHandler);
    }

    @UiThread
    public void detach() {
        this.platformViewsChannel.setPlatformViewsHandler(null);
        this.platformViewsChannel = null;
        this.context = null;
        this.textureRegistry = null;
    }

    public void attachToView(@NonNull View flutterView) {
        this.flutterView = flutterView;
        for (VirtualDisplayController controller : this.vdControllers.values()) {
            controller.onFlutterViewAttached(flutterView);
        }
    }

    public void detachFromView() {
        this.flutterView = null;
        for (VirtualDisplayController controller : this.vdControllers.values()) {
            controller.onFlutterViewDetached();
        }
    }

    @Override
    public void attachAccessibilityBridge(AccessibilityBridge accessibilityBridge) {
        this.accessibilityEventsDelegate.setAccessibilityBridge(accessibilityBridge);
    }

    @Override
    public void detachAccessibiltyBridge() {
        this.accessibilityEventsDelegate.setAccessibilityBridge(null);
    }

    public void attachTextInputPlugin(TextInputPlugin textInputPlugin) {
        this.textInputPlugin = textInputPlugin;
    }

    public void detachTextInputPlugin() {
        this.textInputPlugin = null;
    }

    public boolean checkInputConnectionProxy(View view) {
        if (!this.contextToPlatformView.containsKey(view.getContext())) {
            return false;
        }
        View platformView = this.contextToPlatformView.get(view.getContext());
        if (platformView == view) {
            return true;
        }
        return platformView.checkInputConnectionProxy(view);
    }

    public PlatformViewRegistry getRegistry() {
        return this.registry;
    }

    public void onFlutterViewDestroyed() {
        this.flushAllViews();
    }

    public void onPreEngineRestart() {
        this.flushAllViews();
    }

    @Override
    public View getPlatformViewById(Integer id2) {
        VirtualDisplayController controller = this.vdControllers.get(id2);
        if (controller == null) {
            return null;
        }
        return controller.getView();
    }

    private void lockInputConnection(@NonNull VirtualDisplayController controller) {
        if (this.textInputPlugin == null) {
            return;
        }
        this.textInputPlugin.lockPlatformViewInputConnection();
        controller.onInputConnectionLocked();
    }

    private void unlockInputConnection(@NonNull VirtualDisplayController controller) {
        if (this.textInputPlugin == null) {
            return;
        }
        this.textInputPlugin.unlockPlatformViewInputConnection();
        controller.onInputConnectionUnlocked();
    }

    private static boolean validateDirection(int direction) {
        return direction == 0 || direction == 1;
    }

    private static List<MotionEvent.PointerProperties> parsePointerPropertiesList(Object rawPropertiesList) {
        List rawProperties = (List)rawPropertiesList;
        ArrayList<MotionEvent.PointerProperties> pointerProperties = new ArrayList<MotionEvent.PointerProperties>();
        for (Object o : rawProperties) {
            pointerProperties.add(PlatformViewsController.parsePointerProperties(o));
        }
        return pointerProperties;
    }

    private static MotionEvent.PointerProperties parsePointerProperties(Object rawProperties) {
        List propertiesList = (List)rawProperties;
        MotionEvent.PointerProperties properties = new MotionEvent.PointerProperties();
        properties.id = (Integer)propertiesList.get(0);
        properties.toolType = (Integer)propertiesList.get(1);
        return properties;
    }

    private static List<MotionEvent.PointerCoords> parsePointerCoordsList(Object rawCoordsList, float density) {
        List rawCoords = (List)rawCoordsList;
        ArrayList<MotionEvent.PointerCoords> pointerCoords = new ArrayList<MotionEvent.PointerCoords>();
        for (Object o : rawCoords) {
            pointerCoords.add(PlatformViewsController.parsePointerCoords(o, density));
        }
        return pointerCoords;
    }

    private static MotionEvent.PointerCoords parsePointerCoords(Object rawCoords, float density) {
        List coordsList = (List)rawCoords;
        MotionEvent.PointerCoords coords = new MotionEvent.PointerCoords();
        coords.orientation = (float)((Double)coordsList.get(0)).doubleValue();
        coords.pressure = (float)((Double)coordsList.get(1)).doubleValue();
        coords.size = (float)((Double)coordsList.get(2)).doubleValue();
        coords.toolMajor = (float)((Double)coordsList.get(3)).doubleValue() * density;
        coords.toolMinor = (float)((Double)coordsList.get(4)).doubleValue() * density;
        coords.touchMajor = (float)((Double)coordsList.get(5)).doubleValue() * density;
        coords.touchMinor = (float)((Double)coordsList.get(6)).doubleValue() * density;
        coords.x = (float)((Double)coordsList.get(7)).doubleValue() * density;
        coords.y = (float)((Double)coordsList.get(8)).doubleValue() * density;
        return coords;
    }

    private void validateVirtualDisplayDimensions(int width, int height) {
        DisplayMetrics metrics = this.context.getResources().getDisplayMetrics();
        if (height > metrics.heightPixels || width > metrics.widthPixels) {
            String message = "Creating a virtual display of size: [" + width + ", " + height + "] may result in problems(https://github.com/flutter/flutter/issues/2897).It is larger than the device screen size: [" + metrics.widthPixels + ", " + metrics.heightPixels + "].";
            Log.w((String)TAG, (String)message);
        }
    }

    private int toPhysicalPixels(double logicalPixels) {
        float density = this.context.getResources().getDisplayMetrics().density;
        return (int)Math.round(logicalPixels * (double)density);
    }

    private void flushAllViews() {
        for (VirtualDisplayController controller : this.vdControllers.values()) {
            controller.dispose();
        }
        this.vdControllers.clear();
    }
}

