/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import android.annotation.SuppressLint;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.util.Log;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import android.view.accessibility.AccessibilityRecord;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

@Keep
final class AccessibilityViewEmbedder {
    private static final String TAG = "AccessibilityBridge";
    private final ReflectionAccessors reflectionAccessors = new ReflectionAccessors();
    private final View rootAccessibilityView;
    private final SparseArray<ViewAndId> flutterIdToOrigin = new SparseArray();
    private final Map<ViewAndId, Integer> originToFlutterId;
    private final Map<View, Rect> embeddedViewToDisplayBounds;
    private int nextFlutterId;

    AccessibilityViewEmbedder(@NonNull View rootAccessibiiltyView, int firstVirtualNodeId) {
        this.rootAccessibilityView = rootAccessibiiltyView;
        this.nextFlutterId = firstVirtualNodeId;
        this.originToFlutterId = new HashMap<ViewAndId, Integer>();
        this.embeddedViewToDisplayBounds = new HashMap<View, Rect>();
    }

    public AccessibilityNodeInfo getRootNode(@NonNull View embeddedView, int flutterId, @NonNull Rect displayBounds) {
        AccessibilityNodeInfo originNode = embeddedView.createAccessibilityNodeInfo();
        Long originPackedId = this.reflectionAccessors.getSourceNodeId(originNode);
        if (originPackedId == null) {
            return null;
        }
        this.embeddedViewToDisplayBounds.put(embeddedView, displayBounds);
        int originId = ReflectionAccessors.getVirtualNodeId(originPackedId);
        this.cacheVirtualIdMappings(embeddedView, originId, flutterId);
        return this.convertToFlutterNode(originNode, flutterId, embeddedView);
    }

    @Nullable
    public AccessibilityNodeInfo createAccessibilityNodeInfo(int flutterId) {
        ViewAndId origin = (ViewAndId)this.flutterIdToOrigin.get(flutterId);
        if (origin == null) {
            return null;
        }
        if (!this.embeddedViewToDisplayBounds.containsKey(origin.view)) {
            return null;
        }
        AccessibilityNodeProvider provider = origin.view.getAccessibilityNodeProvider();
        if (provider == null) {
            return null;
        }
        AccessibilityNodeInfo originNode = origin.view.getAccessibilityNodeProvider().createAccessibilityNodeInfo(origin.id);
        if (originNode == null) {
            return null;
        }
        return this.convertToFlutterNode(originNode, flutterId, origin.view);
    }

    @NonNull
    private AccessibilityNodeInfo convertToFlutterNode(@NonNull AccessibilityNodeInfo originNode, int flutterId, @NonNull View embeddedView) {
        AccessibilityNodeInfo result = AccessibilityNodeInfo.obtain((View)this.rootAccessibilityView, (int)flutterId);
        result.setPackageName((CharSequence)this.rootAccessibilityView.getContext().getPackageName());
        result.setSource(this.rootAccessibilityView, flutterId);
        result.setClassName(originNode.getClassName());
        Rect displayBounds = this.embeddedViewToDisplayBounds.get(embeddedView);
        this.copyAccessibilityFields(originNode, result);
        this.setFlutterNodesTranslateBounds(originNode, displayBounds, result);
        this.addChildrenToFlutterNode(originNode, embeddedView, result);
        this.setFlutterNodeParent(originNode, embeddedView, result);
        return result;
    }

    private void setFlutterNodeParent(@NonNull AccessibilityNodeInfo originNode, @NonNull View embeddedView, @NonNull AccessibilityNodeInfo result) {
        Long parentOriginPackedId = this.reflectionAccessors.getParentNodeId(originNode);
        if (parentOriginPackedId == null) {
            return;
        }
        int parentOriginId = ReflectionAccessors.getVirtualNodeId(parentOriginPackedId);
        Integer parentFlutterId = this.originToFlutterId.get(new ViewAndId(embeddedView, parentOriginId));
        if (parentFlutterId != null) {
            result.setParent(this.rootAccessibilityView, parentFlutterId.intValue());
        }
    }

    private void addChildrenToFlutterNode(@NonNull AccessibilityNodeInfo originNode, @NonNull View embeddedView, @NonNull AccessibilityNodeInfo resultNode) {
        for (int i = 0; i < originNode.getChildCount(); ++i) {
            int childFlutterId;
            Long originPackedId = this.reflectionAccessors.getChildId(originNode, i);
            if (originPackedId == null) continue;
            int originId = ReflectionAccessors.getVirtualNodeId(originPackedId);
            ViewAndId origin = new ViewAndId(embeddedView, originId);
            if (this.originToFlutterId.containsKey(origin)) {
                childFlutterId = this.originToFlutterId.get(origin);
            } else {
                ++this.nextFlutterId;
                this.cacheVirtualIdMappings(embeddedView, originId, childFlutterId);
            }
            resultNode.addChild(this.rootAccessibilityView, childFlutterId);
        }
    }

    private void cacheVirtualIdMappings(@NonNull View embeddedView, int originId, int flutterId) {
        ViewAndId origin = new ViewAndId(embeddedView, originId);
        this.originToFlutterId.put(origin, flutterId);
        this.flutterIdToOrigin.put(flutterId, (Object)origin);
    }

    private void setFlutterNodesTranslateBounds(@NonNull AccessibilityNodeInfo originNode, @NonNull Rect displayBounds, @NonNull AccessibilityNodeInfo resultNode) {
        Rect boundsInParent = new Rect();
        originNode.getBoundsInParent(boundsInParent);
        resultNode.setBoundsInParent(boundsInParent);
        Rect boundsInScreen = new Rect();
        originNode.getBoundsInScreen(boundsInScreen);
        boundsInScreen.offset(displayBounds.left, displayBounds.top);
        resultNode.setBoundsInScreen(boundsInScreen);
    }

    private void copyAccessibilityFields(@NonNull AccessibilityNodeInfo input, @NonNull AccessibilityNodeInfo output) {
        output.setAccessibilityFocused(input.isAccessibilityFocused());
        output.setCheckable(input.isCheckable());
        output.setChecked(input.isChecked());
        output.setContentDescription(input.getContentDescription());
        output.setEnabled(input.isEnabled());
        output.setClickable(input.isClickable());
        output.setFocusable(input.isFocusable());
        output.setFocused(input.isFocused());
        output.setLongClickable(input.isLongClickable());
        output.setMovementGranularities(input.getMovementGranularities());
        output.setPassword(input.isPassword());
        output.setScrollable(input.isScrollable());
        output.setSelected(input.isSelected());
        output.setText(input.getText());
        output.setVisibleToUser(input.isVisibleToUser());
        if (Build.VERSION.SDK_INT >= 18) {
            output.setEditable(input.isEditable());
        }
        if (Build.VERSION.SDK_INT >= 19) {
            output.setCanOpenPopup(input.canOpenPopup());
            output.setCollectionInfo(input.getCollectionInfo());
            output.setCollectionItemInfo(input.getCollectionItemInfo());
            output.setContentInvalid(input.isContentInvalid());
            output.setDismissable(input.isDismissable());
            output.setInputType(input.getInputType());
            output.setLiveRegion(input.getLiveRegion());
            output.setMultiLine(input.isMultiLine());
            output.setRangeInfo(input.getRangeInfo());
        }
        if (Build.VERSION.SDK_INT >= 21) {
            output.setError(input.getError());
            output.setMaxTextLength(input.getMaxTextLength());
        }
        if (Build.VERSION.SDK_INT >= 23) {
            output.setContextClickable(input.isContextClickable());
        }
        if (Build.VERSION.SDK_INT >= 24) {
            output.setDrawingOrder(input.getDrawingOrder());
            output.setImportantForAccessibility(input.isImportantForAccessibility());
        }
        if (Build.VERSION.SDK_INT >= 26) {
            output.setAvailableExtraData(input.getAvailableExtraData());
            output.setHintText(input.getHintText());
            output.setShowingHintText(input.isShowingHintText());
        }
    }

    public boolean requestSendAccessibilityEvent(@NonNull View embeddedView, @NonNull View eventOrigin, @NonNull AccessibilityEvent event) {
        AccessibilityEvent translatedEvent = AccessibilityEvent.obtain((AccessibilityEvent)event);
        Long originPackedId = this.reflectionAccessors.getRecordSourceNodeId((AccessibilityRecord)event);
        if (originPackedId == null) {
            return false;
        }
        int originVirtualId = ReflectionAccessors.getVirtualNodeId(originPackedId);
        Integer flutterId = this.originToFlutterId.get(new ViewAndId(embeddedView, originVirtualId));
        if (flutterId == null) {
            flutterId = this.nextFlutterId++;
            this.cacheVirtualIdMappings(embeddedView, originVirtualId, flutterId);
        }
        translatedEvent.setSource(this.rootAccessibilityView, flutterId.intValue());
        translatedEvent.setClassName(event.getClassName());
        translatedEvent.setPackageName(event.getPackageName());
        for (int i = 0; i < translatedEvent.getRecordCount(); ++i) {
            AccessibilityRecord record = translatedEvent.getRecord(i);
            Long recordOriginPackedId = this.reflectionAccessors.getRecordSourceNodeId(record);
            if (recordOriginPackedId == null) {
                return false;
            }
            int recordOriginVirtualID = ReflectionAccessors.getVirtualNodeId(recordOriginPackedId);
            ViewAndId originViewAndId = new ViewAndId(embeddedView, recordOriginVirtualID);
            if (!this.originToFlutterId.containsKey(originViewAndId)) {
                return false;
            }
            int recordFlutterId = this.originToFlutterId.get(originViewAndId);
            record.setSource(this.rootAccessibilityView, recordFlutterId);
        }
        return this.rootAccessibilityView.getParent().requestSendAccessibilityEvent(eventOrigin, translatedEvent);
    }

    public boolean performAction(int flutterId, int accessibilityAction, @Nullable Bundle arguments) {
        ViewAndId origin = (ViewAndId)this.flutterIdToOrigin.get(flutterId);
        if (origin == null) {
            return false;
        }
        View embeddedView = origin.view;
        AccessibilityNodeProvider provider = embeddedView.getAccessibilityNodeProvider();
        if (provider == null) {
            return false;
        }
        return provider.performAction(origin.id, accessibilityAction, arguments);
    }

    @Nullable
    public Integer getRecordFlutterId(@NonNull View embeddedView, @NonNull AccessibilityRecord record) {
        Long originPackedId = this.reflectionAccessors.getRecordSourceNodeId(record);
        if (originPackedId == null) {
            return null;
        }
        int originVirtualId = ReflectionAccessors.getVirtualNodeId(originPackedId);
        return this.originToFlutterId.get(new ViewAndId(embeddedView, originVirtualId));
    }

    public boolean onAccessibilityHoverEvent(int rootFlutterId, @NonNull MotionEvent event) {
        ViewAndId origin = (ViewAndId)this.flutterIdToOrigin.get(rootFlutterId);
        if (origin == null) {
            return false;
        }
        Rect displayBounds = this.embeddedViewToDisplayBounds.get(origin.view);
        int pointerCount = event.getPointerCount();
        MotionEvent.PointerProperties[] pointerProperties = new MotionEvent.PointerProperties[pointerCount];
        MotionEvent.PointerCoords[] pointerCoords = new MotionEvent.PointerCoords[pointerCount];
        for (int i = 0; i < event.getPointerCount(); ++i) {
            pointerProperties[i] = new MotionEvent.PointerProperties();
            event.getPointerProperties(i, pointerProperties[i]);
            MotionEvent.PointerCoords originCoords = new MotionEvent.PointerCoords();
            event.getPointerCoords(i, originCoords);
            pointerCoords[i] = new MotionEvent.PointerCoords(originCoords);
            pointerCoords[i].x -= (float)displayBounds.left;
            pointerCoords[i].y -= (float)displayBounds.top;
        }
        MotionEvent translatedEvent = MotionEvent.obtain((long)event.getDownTime(), (long)event.getEventTime(), (int)event.getAction(), (int)event.getPointerCount(), (MotionEvent.PointerProperties[])pointerProperties, (MotionEvent.PointerCoords[])pointerCoords, (int)event.getMetaState(), (int)event.getButtonState(), (float)event.getXPrecision(), (float)event.getYPrecision(), (int)event.getDeviceId(), (int)event.getEdgeFlags(), (int)event.getSource(), (int)event.getFlags());
        return origin.view.dispatchGenericMotionEvent(translatedEvent);
    }

    private static class ReflectionAccessors {
        @Nullable
        private final Method getSourceNodeId;
        @Nullable
        private final Method getParentNodeId;
        @Nullable
        private final Method getRecordSourceNodeId;
        @Nullable
        private final Method getChildId;
        @Nullable
        private final Field childNodeIdsField;
        @Nullable
        private final Method longArrayGetIndex;

        @SuppressLint(value={"PrivateApi"})
        private ReflectionAccessors() {
            Method getSourceNodeId = null;
            Method getParentNodeId = null;
            Method getRecordSourceNodeId = null;
            Method getChildId = null;
            Field childNodeIdsField = null;
            Method longArrayGetIndex = null;
            try {
                getSourceNodeId = AccessibilityNodeInfo.class.getMethod("getSourceNodeId", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                Log.w((String)AccessibilityViewEmbedder.TAG, (String)"can't invoke AccessibilityNodeInfo#getSourceNodeId with reflection");
            }
            try {
                getRecordSourceNodeId = AccessibilityRecord.class.getMethod("getSourceNodeId", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                Log.w((String)AccessibilityViewEmbedder.TAG, (String)"can't invoke AccessibiiltyRecord#getSourceNodeId with reflection");
            }
            if (Build.VERSION.SDK_INT <= 26) {
                try {
                    getParentNodeId = AccessibilityNodeInfo.class.getMethod("getParentNodeId", new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    Log.w((String)AccessibilityViewEmbedder.TAG, (String)"can't invoke getParentNodeId with reflection");
                }
                try {
                    getChildId = AccessibilityNodeInfo.class.getMethod("getChildId", Integer.TYPE);
                }
                catch (NoSuchMethodException e) {
                    Log.w((String)AccessibilityViewEmbedder.TAG, (String)"can't invoke getChildId with reflection");
                }
            } else {
                try {
                    childNodeIdsField = AccessibilityNodeInfo.class.getDeclaredField("mChildNodeIds");
                    childNodeIdsField.setAccessible(true);
                    longArrayGetIndex = Class.forName("android.util.LongArray").getMethod("get", Integer.TYPE);
                }
                catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException | NullPointerException e) {
                    Log.w((String)AccessibilityViewEmbedder.TAG, (String)"can't access childNodeIdsField with reflection");
                    childNodeIdsField = null;
                }
            }
            this.getSourceNodeId = getSourceNodeId;
            this.getParentNodeId = getParentNodeId;
            this.getRecordSourceNodeId = getRecordSourceNodeId;
            this.getChildId = getChildId;
            this.childNodeIdsField = childNodeIdsField;
            this.longArrayGetIndex = longArrayGetIndex;
        }

        private static int getVirtualNodeId(long nodeId) {
            return (int)(nodeId >> 32);
        }

        @Nullable
        private Long getSourceNodeId(@NonNull AccessibilityNodeInfo node) {
            if (this.getSourceNodeId == null) {
                return null;
            }
            try {
                return (Long)this.getSourceNodeId.invoke((Object)node, new Object[0]);
            }
            catch (IllegalAccessException e) {
                Log.w((String)AccessibilityViewEmbedder.TAG, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                Log.w((String)AccessibilityViewEmbedder.TAG, (Throwable)e);
            }
            return null;
        }

        @Nullable
        private Long getChildId(@NonNull AccessibilityNodeInfo node, int child) {
            block8: {
                if (this.getChildId == null && (this.childNodeIdsField == null || this.longArrayGetIndex == null)) {
                    return null;
                }
                if (this.getChildId != null) {
                    try {
                        return (Long)this.getChildId.invoke((Object)node, child);
                    }
                    catch (IllegalAccessException e) {
                        Log.w((String)AccessibilityViewEmbedder.TAG, (Throwable)e);
                        break block8;
                    }
                    catch (InvocationTargetException e) {
                        Log.w((String)AccessibilityViewEmbedder.TAG, (Throwable)e);
                        break block8;
                    }
                }
                try {
                    return (long)((Long)this.longArrayGetIndex.invoke(this.childNodeIdsField.get(node), child));
                }
                catch (IllegalAccessException e) {
                    Log.w((String)AccessibilityViewEmbedder.TAG, (Throwable)e);
                }
                catch (ArrayIndexOutOfBoundsException | InvocationTargetException e) {
                    Log.w((String)AccessibilityViewEmbedder.TAG, (Throwable)e);
                }
            }
            return null;
        }

        @Nullable
        private Long getParentNodeId(@NonNull AccessibilityNodeInfo node) {
            if (this.getParentNodeId != null) {
                try {
                    return (long)((Long)this.getParentNodeId.invoke((Object)node, new Object[0]));
                }
                catch (IllegalAccessException e) {
                    Log.w((String)AccessibilityViewEmbedder.TAG, (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    Log.w((String)AccessibilityViewEmbedder.TAG, (Throwable)e);
                }
            }
            return ReflectionAccessors.yoinkParentIdFromParcel(node);
        }

        @Nullable
        private static Long yoinkParentIdFromParcel(AccessibilityNodeInfo node) {
            if (Build.VERSION.SDK_INT < 26) {
                Log.w((String)AccessibilityViewEmbedder.TAG, (String)"Unexpected Android version. Unable to find the parent ID.");
                return null;
            }
            AccessibilityNodeInfo copy = AccessibilityNodeInfo.obtain((AccessibilityNodeInfo)node);
            Parcel parcel = Parcel.obtain();
            parcel.setDataPosition(0);
            copy.writeToParcel(parcel, 0);
            Long parentNodeId = null;
            parcel.setDataPosition(0);
            long nonDefaultFields = parcel.readLong();
            int fieldIndex = 0;
            if (ReflectionAccessors.isBitSet(nonDefaultFields, fieldIndex++)) {
                parcel.readInt();
            }
            if (ReflectionAccessors.isBitSet(nonDefaultFields, fieldIndex++)) {
                parcel.readLong();
            }
            if (ReflectionAccessors.isBitSet(nonDefaultFields, fieldIndex++)) {
                parcel.readInt();
            }
            if (ReflectionAccessors.isBitSet(nonDefaultFields, fieldIndex++)) {
                parentNodeId = parcel.readLong();
            }
            parcel.recycle();
            return parentNodeId;
        }

        private static boolean isBitSet(long flags, int bitIndex) {
            return (flags & 1L << bitIndex) != 0L;
        }

        @Nullable
        private Long getRecordSourceNodeId(@NonNull AccessibilityRecord node) {
            if (this.getRecordSourceNodeId == null) {
                return null;
            }
            try {
                return (Long)this.getRecordSourceNodeId.invoke((Object)node, new Object[0]);
            }
            catch (IllegalAccessException e) {
                Log.w((String)AccessibilityViewEmbedder.TAG, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                Log.w((String)AccessibilityViewEmbedder.TAG, (Throwable)e);
            }
            return null;
        }
    }

    private static class ViewAndId {
        final View view;
        final int id;

        private ViewAndId(View view, int id2) {
            this.view = view;
            this.id = id2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ViewAndId)) {
                return false;
            }
            ViewAndId viewAndId = (ViewAndId)o;
            return this.id == viewAndId.id && this.view.equals(viewAndId.view);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.view.hashCode();
            result = 31 * result + this.id;
            return result;
        }
    }
}

