/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.systemchannels;

import android.support.annotation.NonNull;
import io.flutter.Log;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.StandardMethodCodec;

public class RestorationChannel {
    private static final String TAG = "RestorationChannel";
    public final boolean waitForRestorationData;
    private byte[] restorationData;
    private MethodChannel channel;
    private MethodChannel.Result pendingFrameworkRestorationChannelRequest;
    private boolean engineHasProvidedData = false;
    private boolean frameworkHasRequestedData = false;
    private final MethodChannel.MethodCallHandler handler = new MethodChannel.MethodCallHandler(){

        @Override
        public void onMethodCall(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            String method = call.method;
            Object args = call.arguments;
            switch (method) {
                case "put": {
                    RestorationChannel.access$002(RestorationChannel.this, (byte[])args);
                    result.success(null);
                    break;
                }
                case "get": {
                    RestorationChannel.this.frameworkHasRequestedData = true;
                    if (RestorationChannel.this.engineHasProvidedData || !RestorationChannel.this.waitForRestorationData) {
                        result.success(RestorationChannel.this.restorationData);
                        break;
                    }
                    RestorationChannel.this.pendingFrameworkRestorationChannelRequest = result;
                    break;
                }
                default: {
                    result.notImplemented();
                }
            }
        }
    };

    public RestorationChannel(@NonNull DartExecutor dartExecutor, @NonNull boolean waitForRestorationData) {
        this(new MethodChannel(dartExecutor, "flutter/restoration", StandardMethodCodec.INSTANCE), waitForRestorationData);
    }

    RestorationChannel(MethodChannel channel, @NonNull boolean waitForRestorationData) {
        this.channel = channel;
        this.waitForRestorationData = waitForRestorationData;
        channel.setMethodCallHandler(this.handler);
    }

    public byte[] getRestorationData() {
        return this.restorationData;
    }

    public void setRestorationData(final byte[] data) {
        this.engineHasProvidedData = true;
        if (this.pendingFrameworkRestorationChannelRequest != null) {
            this.pendingFrameworkRestorationChannelRequest.success(data);
            this.pendingFrameworkRestorationChannelRequest = null;
            this.restorationData = data;
        } else if (this.frameworkHasRequestedData) {
            this.channel.invokeMethod("push", data, new MethodChannel.Result(){

                @Override
                public void success(Object result) {
                    RestorationChannel.access$002(RestorationChannel.this, data);
                }

                @Override
                public void error(String errorCode, String errorMessage, Object errorDetails) {
                    Log.e(RestorationChannel.TAG, "Error " + errorCode + " while sending restoration data to framework: " + errorMessage);
                }

                @Override
                public void notImplemented() {
                }
            });
        } else {
            this.restorationData = data;
        }
    }

    public void clearData() {
        this.restorationData = null;
    }

    static /* synthetic */ byte[] access$002(RestorationChannel x0, byte[] x1) {
        x0.restorationData = x1;
        return x1;
    }
}

