class PropertyTypes {
  static const int unknown = 0;
  static const int posX = 1;
  static const int posY = 2;
  static const int scaleX = 3;
  static const int scaleY = 4;
  static const int rotation = 5;
  static const int opacity = 6;
  static const int drawOrder = 7;
  static const int length = 8;
  static const int imageVertices = 9;
  static const int constraintStrength = 10;
  static const int trigger = 11;
  static const int intProperty = 12;
  static const int floatProperty = 13;
  static const int stringProperty = 14;
  static const int booleanProperty = 15;
  static const int collisionEnabled = 16;
  static const int sequence = 17;
  static const int activeChildIndex = 18;
  static const int pathVertices = 19;
  static const int fillColor = 20;
  static const int fillGradient = 21;
  static const int fillRadial = 22;
  static const int strokeColor = 23;
  static const int strokeGradient = 24;
  static const int strokeRadial = 25;
  static const int strokeWidth = 26;
  static const int strokeOpacity = 27;
  static const int fillOpacity = 28;
  static const int shapeWidth = 29;
  static const int shapeHeight = 30;
  static const int cornerRadius = 31;
  static const int innerRadius = 32;
  static const int strokeStart = 33;
  static const int strokeEnd = 34;
  static const int strokeOffset = 35;
  static const int color = 36;
  static const int offsetX = 37;
  static const int offsetY = 38;
  static const int blurX = 39;
  static const int blurY = 40;
}

const Map<String, int> propertyTypesMap = {
  "unknown": PropertyTypes.unknown,
  "posX": PropertyTypes.posX,
  "posY": PropertyTypes.posY,
  "scaleX": PropertyTypes.scaleX,
  "scaleY": PropertyTypes.scaleY,
  "rotation": PropertyTypes.rotation,
  "opacity": PropertyTypes.opacity,
  "drawOrder": PropertyTypes.drawOrder,
  "length": PropertyTypes.length,
  "vertices": PropertyTypes.imageVertices,
  "strength": PropertyTypes.constraintStrength,
  "trigger": PropertyTypes.trigger,
  "intValue": PropertyTypes.intProperty,
  "floatValue": PropertyTypes.floatProperty,
  "stringValue": PropertyTypes.stringProperty,
  "boolValue": PropertyTypes.booleanProperty,
  "isCollisionEnabled": PropertyTypes.collisionEnabled,
  "sequence": PropertyTypes.sequence,
  "activeChild": PropertyTypes.activeChildIndex,
  "pathVertices": PropertyTypes.pathVertices,
  "fillColor": PropertyTypes.fillColor,
  "fillGradient": PropertyTypes.fillGradient,
  "fillRadial": PropertyTypes.fillRadial,
  "strokeColor": PropertyTypes.strokeColor,
  "strokeGradient": PropertyTypes.strokeGradient,
  "strokeRadial": PropertyTypes.strokeRadial,
  "strokeWidth": PropertyTypes.strokeWidth,
  "strokeOpacity": PropertyTypes.strokeOpacity,
  "fillOpacity": PropertyTypes.fillOpacity,
  "width": PropertyTypes.shapeWidth,
  "height": PropertyTypes.shapeHeight,
  "cornerRadius": PropertyTypes.cornerRadius,
  "innerRadius": PropertyTypes.innerRadius,
  "strokeStart": PropertyTypes.strokeStart,
  "strokeEnd": PropertyTypes.strokeEnd,
  "strokeOffset": PropertyTypes.strokeOffset,
  "color": PropertyTypes.color,
  "offsetX": PropertyTypes.offsetX,
  "offsetY": PropertyTypes.offsetY,
  "blurX": PropertyTypes.blurX,
  "blurY": PropertyTypes.blurY
};
