/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.editing;

import io.flutter.embedding.engine.FlutterJNI;

class FlutterTextUtils {
    public static final int LINE_FEED = 10;
    public static final int CARRIAGE_RETURN = 13;
    public static final int COMBINING_ENCLOSING_KEYCAP = 8419;
    public static final int CANCEL_TAG = 917631;
    public static final int ZERO_WIDTH_JOINER = 8205;
    private final FlutterJNI flutterJNI;

    public FlutterTextUtils(FlutterJNI flutterJNI) {
        this.flutterJNI = flutterJNI;
    }

    public boolean isEmoji(int codePoint) {
        return this.flutterJNI.nativeFlutterTextUtilsIsEmoji(codePoint);
    }

    public boolean isEmojiModifier(int codePoint) {
        return this.flutterJNI.nativeFlutterTextUtilsIsEmojiModifier(codePoint);
    }

    public boolean isEmojiModifierBase(int codePoint) {
        return this.flutterJNI.nativeFlutterTextUtilsIsEmojiModifierBase(codePoint);
    }

    public boolean isVariationSelector(int codePoint) {
        return this.flutterJNI.nativeFlutterTextUtilsIsVariationSelector(codePoint);
    }

    public boolean isRegionalIndicatorSymbol(int codePoint) {
        return this.flutterJNI.nativeFlutterTextUtilsIsRegionalIndicator(codePoint);
    }

    public boolean isTagSpecChar(int codePoint) {
        return 917536 <= codePoint && codePoint <= 917630;
    }

    public boolean isKeycapBase(int codePoint) {
        return 48 <= codePoint && codePoint <= 57 || codePoint == 35 || codePoint == 42;
    }

    public int getOffsetBefore(CharSequence text, int offset) {
        if (offset <= 1) {
            return 0;
        }
        int codePoint = Character.codePointBefore(text, offset);
        int deleteCharCount = Character.charCount(codePoint);
        int lastOffset = offset - deleteCharCount;
        if (lastOffset == 0) {
            return 0;
        }
        if (codePoint == 10) {
            codePoint = Character.codePointBefore(text, lastOffset);
            if (codePoint == 13) {
                ++deleteCharCount;
            }
            return offset - deleteCharCount;
        }
        if (this.isRegionalIndicatorSymbol(codePoint)) {
            codePoint = Character.codePointBefore(text, lastOffset);
            lastOffset -= Character.charCount(codePoint);
            int regionalIndicatorSymbolCount = 1;
            while (lastOffset > 0 && this.isRegionalIndicatorSymbol(codePoint)) {
                codePoint = Character.codePointBefore(text, lastOffset);
                lastOffset -= Character.charCount(codePoint);
                ++regionalIndicatorSymbolCount;
            }
            if (regionalIndicatorSymbolCount % 2 == 0) {
                deleteCharCount += 2;
            }
            return offset - deleteCharCount;
        }
        if (codePoint == 8419) {
            if ((lastOffset -= Character.charCount(codePoint = Character.codePointBefore(text, lastOffset))) > 0 && this.isVariationSelector(codePoint)) {
                int tmpCodePoint = Character.codePointBefore(text, lastOffset);
                if (this.isKeycapBase(tmpCodePoint)) {
                    deleteCharCount += Character.charCount(codePoint) + Character.charCount(tmpCodePoint);
                }
            } else if (this.isKeycapBase(codePoint)) {
                deleteCharCount += Character.charCount(codePoint);
            }
            return offset - deleteCharCount;
        }
        if (codePoint == 917631) {
            codePoint = Character.codePointBefore(text, lastOffset);
            lastOffset -= Character.charCount(codePoint);
            while (lastOffset > 0 && this.isTagSpecChar(codePoint)) {
                deleteCharCount += Character.charCount(codePoint);
                codePoint = Character.codePointBefore(text, lastOffset);
                lastOffset -= Character.charCount(codePoint);
            }
            if (!this.isEmoji(codePoint)) {
                return offset - 2;
            }
            deleteCharCount += Character.charCount(codePoint);
        }
        if (this.isVariationSelector(codePoint)) {
            codePoint = Character.codePointBefore(text, lastOffset);
            if (!this.isEmoji(codePoint)) {
                return offset - deleteCharCount;
            }
            lastOffset -= (deleteCharCount += Character.charCount(codePoint));
        }
        if (this.isEmoji(codePoint)) {
            boolean isZwj = false;
            int lastSeenVariantSelectorCharCount = 0;
            do {
                if (isZwj) {
                    deleteCharCount += Character.charCount(codePoint) + lastSeenVariantSelectorCharCount + 1;
                    isZwj = false;
                }
                lastSeenVariantSelectorCharCount = 0;
                if (this.isEmojiModifier(codePoint)) {
                    if ((lastOffset -= Character.charCount(codePoint = Character.codePointBefore(text, lastOffset))) > 0 && this.isVariationSelector(codePoint)) {
                        codePoint = Character.codePointBefore(text, lastOffset);
                        if (!this.isEmoji(codePoint)) {
                            return offset - deleteCharCount;
                        }
                        lastSeenVariantSelectorCharCount = Character.charCount(codePoint);
                        lastOffset -= Character.charCount(codePoint);
                    }
                    if (!this.isEmojiModifierBase(codePoint)) break;
                    deleteCharCount += lastSeenVariantSelectorCharCount + Character.charCount(codePoint);
                    break;
                }
                if (lastOffset <= 0) continue;
                codePoint = Character.codePointBefore(text, lastOffset);
                lastOffset -= Character.charCount(codePoint);
                if (codePoint != 8205) continue;
                isZwj = true;
                if ((lastOffset -= Character.charCount(codePoint = Character.codePointBefore(text, lastOffset))) <= 0 || !this.isVariationSelector(codePoint)) continue;
                codePoint = Character.codePointBefore(text, lastOffset);
                lastSeenVariantSelectorCharCount = Character.charCount(codePoint);
                lastOffset -= Character.charCount(codePoint);
            } while (lastOffset != 0 && isZwj && this.isEmoji(codePoint));
        }
        return offset - deleteCharCount;
    }

    public int getOffsetAfter(CharSequence text, int offset) {
        int len = text.length();
        if (offset >= len - 1) {
            return len;
        }
        int codePoint = Character.codePointAt(text, offset);
        int nextCharCount = Character.charCount(codePoint);
        int nextOffset = offset + nextCharCount;
        if (nextOffset == 0) {
            return 0;
        }
        if (codePoint == 10) {
            codePoint = Character.codePointAt(text, nextOffset);
            if (codePoint == 13) {
                ++nextCharCount;
            }
            return offset + nextCharCount;
        }
        if (this.isRegionalIndicatorSymbol(codePoint)) {
            if (nextOffset >= len - 1 || !this.isRegionalIndicatorSymbol(Character.codePointAt(text, nextOffset))) {
                return offset + nextCharCount;
            }
            int regionalIndicatorSymbolCount = 0;
            int regionOffset = offset;
            while (regionOffset > 0 && this.isRegionalIndicatorSymbol(Character.codePointBefore(text, offset))) {
                regionOffset -= Character.charCount(Character.codePointBefore(text, offset));
                ++regionalIndicatorSymbolCount;
            }
            if (regionalIndicatorSymbolCount % 2 == 0) {
                nextCharCount += 2;
            }
            return offset + nextCharCount;
        }
        if (this.isKeycapBase(codePoint)) {
            nextCharCount += Character.charCount(codePoint);
        }
        if (codePoint == 8419) {
            if ((nextOffset += Character.charCount(codePoint = Character.codePointBefore(text, nextOffset))) < len && this.isVariationSelector(codePoint)) {
                int tmpCodePoint = Character.codePointAt(text, nextOffset);
                if (this.isKeycapBase(tmpCodePoint)) {
                    nextCharCount += Character.charCount(codePoint) + Character.charCount(tmpCodePoint);
                }
            } else if (this.isKeycapBase(codePoint)) {
                nextCharCount += Character.charCount(codePoint);
            }
            return offset + nextCharCount;
        }
        if (this.isEmoji(codePoint)) {
            boolean isZwj = false;
            int lastSeenVariantSelectorCharCount = 0;
            do {
                if (isZwj) {
                    nextCharCount += Character.charCount(codePoint) + lastSeenVariantSelectorCharCount + 1;
                    isZwj = false;
                }
                lastSeenVariantSelectorCharCount = 0;
                if (this.isEmojiModifier(codePoint)) break;
                if (nextOffset >= len) continue;
                codePoint = Character.codePointAt(text, nextOffset);
                nextOffset += Character.charCount(codePoint);
                if (codePoint == 8419) {
                    if ((nextOffset += Character.charCount(codePoint = Character.codePointBefore(text, nextOffset))) < len && this.isVariationSelector(codePoint)) {
                        int tmpCodePoint = Character.codePointAt(text, nextOffset);
                        if (this.isKeycapBase(tmpCodePoint)) {
                            nextCharCount += Character.charCount(codePoint) + Character.charCount(tmpCodePoint);
                        }
                    } else if (this.isKeycapBase(codePoint)) {
                        nextCharCount += Character.charCount(codePoint);
                    }
                    return offset + nextCharCount;
                }
                if (this.isEmojiModifier(codePoint)) {
                    nextCharCount += lastSeenVariantSelectorCharCount + Character.charCount(codePoint);
                    break;
                }
                if (this.isVariationSelector(codePoint)) {
                    nextCharCount += lastSeenVariantSelectorCharCount + Character.charCount(codePoint);
                    break;
                }
                if (codePoint != 8205) continue;
                isZwj = true;
                if ((nextOffset += Character.charCount(codePoint = Character.codePointAt(text, nextOffset))) >= len || !this.isVariationSelector(codePoint)) continue;
                codePoint = Character.codePointAt(text, nextOffset);
                lastSeenVariantSelectorCharCount = Character.charCount(codePoint);
                nextOffset += Character.charCount(codePoint);
            } while (nextOffset < len && isZwj && this.isEmoji(codePoint));
        }
        return offset + nextCharCount;
    }
}

