/*
 * Decompiled with CFR 0.152.
 */
package io.flutter;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.embedding.engine.deferredcomponents.DeferredComponentManager;
import io.flutter.embedding.engine.loader.FlutterLoader;

public final class FlutterInjector {
    private static FlutterInjector instance;
    private static boolean accessed;
    private FlutterLoader flutterLoader;
    private DeferredComponentManager deferredComponentManager;

    @VisibleForTesting
    public static void setInstance(@NonNull FlutterInjector injector) {
        if (accessed) {
            throw new IllegalStateException("Cannot change the FlutterInjector instance once it's been read. If you're trying to dependency inject, be sure to do so at the beginning of the program");
        }
        instance = injector;
    }

    public static FlutterInjector instance() {
        accessed = true;
        if (instance == null) {
            instance = new Builder().build();
        }
        return instance;
    }

    @VisibleForTesting
    public static void reset() {
        accessed = false;
        instance = null;
    }

    private FlutterInjector(@NonNull FlutterLoader flutterLoader, DeferredComponentManager deferredComponentManager) {
        this.flutterLoader = flutterLoader;
        this.deferredComponentManager = deferredComponentManager;
    }

    @NonNull
    public FlutterLoader flutterLoader() {
        return this.flutterLoader;
    }

    @Nullable
    public DeferredComponentManager deferredComponentManager() {
        return this.deferredComponentManager;
    }

    public static final class Builder {
        private FlutterLoader flutterLoader;
        private DeferredComponentManager deferredComponentManager;

        public Builder setFlutterLoader(@NonNull FlutterLoader flutterLoader) {
            this.flutterLoader = flutterLoader;
            return this;
        }

        public Builder setDeferredComponentManager(@Nullable DeferredComponentManager deferredComponentManager) {
            this.deferredComponentManager = deferredComponentManager;
            return this;
        }

        private void fillDefaults() {
            if (this.flutterLoader == null) {
                this.flutterLoader = new FlutterLoader();
            }
        }

        public FlutterInjector build() {
            this.fillDefaults();
            return new FlutterInjector(this.flutterLoader, this.deferredComponentManager);
        }
    }
}

