/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.editing;

import android.annotation.SuppressLint;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.text.Editable;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewStructure;
import android.view.WindowInsets;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillManager;
import android.view.autofill.AutofillValue;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.Log;
import io.flutter.embedding.android.AndroidKeyProcessor;
import io.flutter.embedding.engine.systemchannels.TextInputChannel;
import io.flutter.plugin.editing.ImeSyncDeferringInsetsCallback;
import io.flutter.plugin.editing.InputConnectionAdaptor;
import io.flutter.plugin.editing.ListenableEditingState;
import io.flutter.plugin.platform.PlatformViewsController;
import java.util.HashMap;

public class TextInputPlugin
implements ListenableEditingState.EditingStateWatcher {
    private static final String TAG = "TextInputPlugin";
    @NonNull
    private final View mView;
    @NonNull
    private final InputMethodManager mImm;
    @NonNull
    private final AutofillManager afm;
    @NonNull
    private final TextInputChannel textInputChannel;
    @NonNull
    private InputTarget inputTarget = new InputTarget(InputTarget.Type.NO_TARGET, 0);
    @Nullable
    private TextInputChannel.Configuration configuration;
    @Nullable
    private SparseArray<TextInputChannel.Configuration> mAutofillConfigurations;
    @Nullable
    private ListenableEditingState mEditable;
    private boolean mRestartInputPending;
    @Nullable
    private InputConnection lastInputConnection;
    @NonNull
    private PlatformViewsController platformViewsController;
    @Nullable
    private Rect lastClientRect;
    private ImeSyncDeferringInsetsCallback imeSyncCallback;
    private AndroidKeyProcessor keyProcessor;
    private TextInputChannel.TextEditState mLastKnownFrameworkTextEditingState;
    private boolean isInputConnectionLocked;

    @SuppressLint(value={"NewApi"})
    public TextInputPlugin(View view, @NonNull TextInputChannel textInputChannel, @NonNull PlatformViewsController platformViewsController) {
        this.mView = view;
        this.mImm = (InputMethodManager)view.getContext().getSystemService("input_method");
        this.afm = Build.VERSION.SDK_INT >= 26 ? (AutofillManager)view.getContext().getSystemService(AutofillManager.class) : null;
        if (Build.VERSION.SDK_INT >= 30) {
            int mask = 0;
            if ((2 & this.mView.getWindowSystemUiVisibility()) == 0) {
                mask |= WindowInsets.Type.navigationBars();
            }
            if ((4 & this.mView.getWindowSystemUiVisibility()) == 0) {
                mask |= WindowInsets.Type.statusBars();
            }
            this.imeSyncCallback = new ImeSyncDeferringInsetsCallback(view, mask, WindowInsets.Type.ime());
            this.imeSyncCallback.install();
        }
        this.textInputChannel = textInputChannel;
        textInputChannel.setTextInputMethodHandler(new TextInputChannel.TextInputMethodHandler(){

            @Override
            public void show() {
                TextInputPlugin.this.showTextInput(TextInputPlugin.this.mView);
            }

            @Override
            public void hide() {
                TextInputPlugin.this.hideTextInput(TextInputPlugin.this.mView);
            }

            @Override
            public void requestAutofill() {
                TextInputPlugin.this.notifyViewEntered();
            }

            @Override
            public void finishAutofillContext(boolean shouldSave) {
                if (Build.VERSION.SDK_INT < 26 || TextInputPlugin.this.afm == null) {
                    return;
                }
                if (shouldSave) {
                    TextInputPlugin.this.afm.commit();
                } else {
                    TextInputPlugin.this.afm.cancel();
                }
            }

            @Override
            public void setClient(int textInputClientId, TextInputChannel.Configuration configuration) {
                TextInputPlugin.this.setTextInputClient(textInputClientId, configuration);
            }

            @Override
            public void setPlatformViewClient(int platformViewId) {
                TextInputPlugin.this.setPlatformViewTextInputClient(platformViewId);
            }

            @Override
            public void setEditingState(TextInputChannel.TextEditState editingState) {
                TextInputPlugin.this.setTextInputEditingState(TextInputPlugin.this.mView, editingState);
            }

            @Override
            public void setEditableSizeAndTransform(double width, double height, double[] transform) {
                TextInputPlugin.this.saveEditableSizeAndTransform(width, height, transform);
            }

            @Override
            public void clearClient() {
                TextInputPlugin.this.clearTextInputClient();
            }

            @Override
            public void sendAppPrivateCommand(String action, Bundle data) {
                TextInputPlugin.this.sendTextInputAppPrivateCommand(action, data);
            }
        });
        textInputChannel.requestExistingInputState();
        this.platformViewsController = platformViewsController;
        this.platformViewsController.attachTextInputPlugin(this);
    }

    @NonNull
    public InputMethodManager getInputMethodManager() {
        return this.mImm;
    }

    @VisibleForTesting
    Editable getEditable() {
        return this.mEditable;
    }

    @VisibleForTesting
    ImeSyncDeferringInsetsCallback getImeSyncCallback() {
        return this.imeSyncCallback;
    }

    @NonNull
    public AndroidKeyProcessor getKeyEventProcessor() {
        return this.keyProcessor;
    }

    public void setKeyEventProcessor(AndroidKeyProcessor processor) {
        this.keyProcessor = processor;
    }

    public void lockPlatformViewInputConnection() {
        if (this.inputTarget.type == InputTarget.Type.PLATFORM_VIEW) {
            this.isInputConnectionLocked = true;
        }
    }

    public void unlockPlatformViewInputConnection() {
        this.isInputConnectionLocked = false;
    }

    @SuppressLint(value={"NewApi"})
    public void destroy() {
        this.platformViewsController.detachTextInputPlugin();
        this.textInputChannel.setTextInputMethodHandler(null);
        this.notifyViewExited();
        if (this.mEditable != null) {
            this.mEditable.removeEditingStateListener(this);
        }
        if (this.imeSyncCallback != null) {
            this.imeSyncCallback.remove();
        }
    }

    private static int inputTypeFromTextInputType(TextInputChannel.InputType type, boolean obscureText, boolean autocorrect, boolean enableSuggestions, TextInputChannel.TextCapitalization textCapitalization) {
        if (type.type == TextInputChannel.TextInputType.DATETIME) {
            return 4;
        }
        if (type.type == TextInputChannel.TextInputType.NUMBER) {
            int textType = 2;
            if (type.isSigned) {
                textType |= 0x1000;
            }
            if (type.isDecimal) {
                textType |= 0x2000;
            }
            return textType;
        }
        if (type.type == TextInputChannel.TextInputType.PHONE) {
            return 3;
        }
        int textType = 1;
        if (type.type == TextInputChannel.TextInputType.MULTILINE) {
            textType |= 0x20000;
        } else if (type.type == TextInputChannel.TextInputType.EMAIL_ADDRESS) {
            textType |= 0x20;
        } else if (type.type == TextInputChannel.TextInputType.URL) {
            textType |= 0x10;
        } else if (type.type == TextInputChannel.TextInputType.VISIBLE_PASSWORD) {
            textType |= 0x90;
        } else if (type.type == TextInputChannel.TextInputType.NAME) {
            textType |= 0x60;
        } else if (type.type == TextInputChannel.TextInputType.POSTAL_ADDRESS) {
            textType |= 0x70;
        }
        if (obscureText) {
            textType |= 0x80000;
            textType |= 0x80;
        } else {
            if (autocorrect) {
                textType |= 0x8000;
            }
            if (!enableSuggestions) {
                textType |= 0x80000;
            }
        }
        if (textCapitalization == TextInputChannel.TextCapitalization.CHARACTERS) {
            textType |= 0x1000;
        } else if (textCapitalization == TextInputChannel.TextCapitalization.WORDS) {
            textType |= 0x2000;
        } else if (textCapitalization == TextInputChannel.TextCapitalization.SENTENCES) {
            textType |= 0x4000;
        }
        return textType;
    }

    public InputConnection createInputConnection(View view, EditorInfo outAttrs) {
        if (this.inputTarget.type == InputTarget.Type.NO_TARGET) {
            this.lastInputConnection = null;
            return null;
        }
        if (this.inputTarget.type == InputTarget.Type.PLATFORM_VIEW) {
            if (this.isInputConnectionLocked) {
                return this.lastInputConnection;
            }
            this.lastInputConnection = this.platformViewsController.getPlatformViewById(this.inputTarget.id).onCreateInputConnection(outAttrs);
            return this.lastInputConnection;
        }
        outAttrs.inputType = TextInputPlugin.inputTypeFromTextInputType(this.configuration.inputType, this.configuration.obscureText, this.configuration.autocorrect, this.configuration.enableSuggestions, this.configuration.textCapitalization);
        outAttrs.imeOptions = 0x2000000;
        int enterAction = this.configuration.inputAction == null ? ((0x20000 & outAttrs.inputType) != 0 ? 1 : 6) : this.configuration.inputAction;
        if (this.configuration.actionLabel != null) {
            outAttrs.actionLabel = this.configuration.actionLabel;
            outAttrs.actionId = enterAction;
        }
        outAttrs.imeOptions |= enterAction;
        InputConnectionAdaptor connection = new InputConnectionAdaptor(view, this.inputTarget.id, this.textInputChannel, this.keyProcessor, this.mEditable, outAttrs);
        outAttrs.initialSelStart = this.mEditable.getSelectionStart();
        outAttrs.initialSelEnd = this.mEditable.getSelectionEnd();
        this.lastInputConnection = connection;
        return this.lastInputConnection;
    }

    @Nullable
    public InputConnection getLastInputConnection() {
        return this.lastInputConnection;
    }

    public void clearPlatformViewClient(int platformViewId) {
        if (this.inputTarget.type == InputTarget.Type.PLATFORM_VIEW && this.inputTarget.id == platformViewId) {
            this.inputTarget = new InputTarget(InputTarget.Type.NO_TARGET, 0);
            this.hideTextInput(this.mView);
            this.mImm.restartInput(this.mView);
            this.mRestartInputPending = false;
        }
    }

    public void sendTextInputAppPrivateCommand(String action, Bundle data) {
        this.mImm.sendAppPrivateCommand(this.mView, action, data);
    }

    private void showTextInput(View view) {
        view.requestFocus();
        this.mImm.showSoftInput(view, 0);
    }

    private void hideTextInput(View view) {
        this.notifyViewExited();
        this.mImm.hideSoftInputFromWindow(view.getApplicationWindowToken(), 0);
    }

    @VisibleForTesting
    void setTextInputClient(int client, TextInputChannel.Configuration configuration) {
        this.notifyViewExited();
        this.inputTarget = new InputTarget(InputTarget.Type.FRAMEWORK_CLIENT, client);
        if (this.mEditable != null) {
            this.mEditable.removeEditingStateListener(this);
        }
        this.mEditable = new ListenableEditingState(configuration.autofill != null ? configuration.autofill.editState : null, this.mView);
        this.configuration = configuration;
        this.updateAutofillConfigurationIfNeeded(configuration);
        this.mRestartInputPending = true;
        this.unlockPlatformViewInputConnection();
        this.lastClientRect = null;
        this.mEditable.addEditingStateListener(this);
    }

    private void setPlatformViewTextInputClient(int platformViewId) {
        this.mView.requestFocus();
        this.inputTarget = new InputTarget(InputTarget.Type.PLATFORM_VIEW, platformViewId);
        this.mImm.restartInput(this.mView);
        this.mRestartInputPending = false;
    }

    private static boolean composingChanged(TextInputChannel.TextEditState before, TextInputChannel.TextEditState after) {
        int composingRegionLength = before.composingEnd - before.composingStart;
        if (composingRegionLength != after.composingEnd - after.composingStart) {
            return true;
        }
        for (int index = 0; index < composingRegionLength; ++index) {
            if (before.text.charAt(index + before.composingStart) == after.text.charAt(index + after.composingStart)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    void setTextInputEditingState(View view, TextInputChannel.TextEditState state) {
        if (!this.mRestartInputPending && this.mLastKnownFrameworkTextEditingState != null && this.mLastKnownFrameworkTextEditingState.hasComposing()) {
            this.mRestartInputPending = TextInputPlugin.composingChanged(this.mLastKnownFrameworkTextEditingState, state);
            if (this.mRestartInputPending) {
                Log.w(TAG, "Changing the content within the the composing region may cause the input method to behave strangely, and is therefore discouraged. See https://github.com/flutter/flutter/issues/78827 for more details");
            }
        }
        this.mLastKnownFrameworkTextEditingState = state;
        this.mEditable.setEditingState(state);
        if (this.mRestartInputPending) {
            this.mImm.restartInput(view);
            this.mRestartInputPending = false;
        }
    }

    private void saveEditableSizeAndTransform(double width, double height, final double[] matrix) {
        final double[] minMax = new double[4];
        final boolean isAffine = matrix[3] == 0.0 && matrix[7] == 0.0 && matrix[15] == 1.0;
        minMax[0] = minMax[1] = matrix[12] / matrix[15];
        minMax[2] = minMax[3] = matrix[13] / matrix[15];
        MinMax finder = new MinMax(){

            @Override
            public void inspect(double x, double y) {
                double w = isAffine ? 1.0 : 1.0 / (matrix[3] * x + matrix[7] * y + matrix[15]);
                double tx = (matrix[0] * x + matrix[4] * y + matrix[12]) * w;
                double ty = (matrix[1] * x + matrix[5] * y + matrix[13]) * w;
                if (tx < minMax[0]) {
                    minMax[0] = tx;
                } else if (tx > minMax[1]) {
                    minMax[1] = tx;
                }
                if (ty < minMax[2]) {
                    minMax[2] = ty;
                } else if (ty > minMax[3]) {
                    minMax[3] = ty;
                }
            }
        };
        finder.inspect(width, 0.0);
        finder.inspect(width, height);
        finder.inspect(0.0, height);
        Float density = Float.valueOf(this.mView.getContext().getResources().getDisplayMetrics().density);
        this.lastClientRect = new Rect((int)(minMax[0] * (double)density.floatValue()), (int)(minMax[2] * (double)density.floatValue()), (int)Math.ceil(minMax[1] * (double)density.floatValue()), (int)Math.ceil(minMax[3] * (double)density.floatValue()));
    }

    @VisibleForTesting
    void clearTextInputClient() {
        if (this.inputTarget.type == InputTarget.Type.PLATFORM_VIEW) {
            return;
        }
        this.mEditable.removeEditingStateListener(this);
        this.notifyViewExited();
        this.updateAutofillConfigurationIfNeeded(null);
        this.inputTarget = new InputTarget(InputTarget.Type.NO_TARGET, 0);
        this.unlockPlatformViewInputConnection();
        this.lastClientRect = null;
    }

    @Override
    public void didChangeEditingState(boolean textChanged, boolean selectionChanged, boolean composingRegionChanged) {
        boolean skipFrameworkUpdate;
        if (textChanged) {
            this.notifyValueChanged(this.mEditable.toString());
        }
        int selectionStart = this.mEditable.getSelectionStart();
        int selectionEnd = this.mEditable.getSelectionEnd();
        int composingStart = this.mEditable.getComposingStart();
        int composingEnd = this.mEditable.getComposingEnd();
        boolean bl = skipFrameworkUpdate = this.mLastKnownFrameworkTextEditingState == null || this.mEditable.toString().equals(this.mLastKnownFrameworkTextEditingState.text) && selectionStart == this.mLastKnownFrameworkTextEditingState.selectionStart && selectionEnd == this.mLastKnownFrameworkTextEditingState.selectionEnd && composingStart == this.mLastKnownFrameworkTextEditingState.composingStart && composingEnd == this.mLastKnownFrameworkTextEditingState.composingEnd;
        if (!skipFrameworkUpdate) {
            Log.v(TAG, "send EditingState to flutter: " + this.mEditable.toString());
            this.textInputChannel.updateEditingState(this.inputTarget.id, this.mEditable.toString(), selectionStart, selectionEnd, composingStart, composingEnd);
            this.mLastKnownFrameworkTextEditingState = new TextInputChannel.TextEditState(this.mEditable.toString(), selectionStart, selectionEnd, composingStart, composingEnd);
        }
    }

    private boolean needsAutofill() {
        return this.mAutofillConfigurations != null;
    }

    private void notifyViewEntered() {
        if (Build.VERSION.SDK_INT < 26 || this.afm == null || !this.needsAutofill()) {
            return;
        }
        String triggerIdentifier = this.configuration.autofill.uniqueIdentifier;
        int[] offset = new int[2];
        this.mView.getLocationOnScreen(offset);
        Rect rect = new Rect(this.lastClientRect);
        rect.offset(offset[0], offset[1]);
        this.afm.notifyViewEntered(this.mView, triggerIdentifier.hashCode(), rect);
    }

    private void notifyViewExited() {
        if (Build.VERSION.SDK_INT < 26 || this.afm == null || this.configuration == null || this.configuration.autofill == null || !this.needsAutofill()) {
            return;
        }
        String triggerIdentifier = this.configuration.autofill.uniqueIdentifier;
        this.afm.notifyViewExited(this.mView, triggerIdentifier.hashCode());
    }

    private void notifyValueChanged(String newValue) {
        if (Build.VERSION.SDK_INT < 26 || this.afm == null || !this.needsAutofill()) {
            return;
        }
        String triggerIdentifier = this.configuration.autofill.uniqueIdentifier;
        this.afm.notifyValueChanged(this.mView, triggerIdentifier.hashCode(), AutofillValue.forText((CharSequence)newValue));
    }

    private void updateAutofillConfigurationIfNeeded(TextInputChannel.Configuration configuration) {
        if (Build.VERSION.SDK_INT < 26) {
            return;
        }
        if (configuration == null || configuration.autofill == null) {
            this.mAutofillConfigurations = null;
            return;
        }
        TextInputChannel.Configuration[] configurations = configuration.fields;
        this.mAutofillConfigurations = new SparseArray();
        if (configurations == null) {
            this.mAutofillConfigurations.put(configuration.autofill.uniqueIdentifier.hashCode(), (Object)configuration);
        } else {
            for (TextInputChannel.Configuration config : configurations) {
                TextInputChannel.Configuration.Autofill autofill = config.autofill;
                if (autofill == null) continue;
                this.mAutofillConfigurations.put(autofill.uniqueIdentifier.hashCode(), (Object)config);
                this.afm.notifyValueChanged(this.mView, autofill.uniqueIdentifier.hashCode(), AutofillValue.forText((CharSequence)autofill.editState.text));
            }
        }
    }

    public void onProvideAutofillVirtualStructure(ViewStructure structure, int flags) {
        if (Build.VERSION.SDK_INT < 26 || !this.needsAutofill()) {
            return;
        }
        String triggerIdentifier = this.configuration.autofill.uniqueIdentifier;
        AutofillId parentId = structure.getAutofillId();
        for (int i = 0; i < this.mAutofillConfigurations.size(); ++i) {
            int autofillId = this.mAutofillConfigurations.keyAt(i);
            TextInputChannel.Configuration config = (TextInputChannel.Configuration)this.mAutofillConfigurations.valueAt(i);
            TextInputChannel.Configuration.Autofill autofill = config.autofill;
            if (autofill == null) continue;
            structure.addChildCount(1);
            ViewStructure child = structure.newChild(i);
            child.setAutofillId(parentId, autofillId);
            child.setAutofillHints(autofill.hints);
            child.setAutofillType(1);
            child.setVisibility(0);
            if (triggerIdentifier.hashCode() == autofillId && this.lastClientRect != null) {
                child.setDimens(this.lastClientRect.left, this.lastClientRect.top, 0, 0, this.lastClientRect.width(), this.lastClientRect.height());
                child.setAutofillValue(AutofillValue.forText((CharSequence)((Object)this.mEditable)));
                continue;
            }
            child.setDimens(0, 0, 0, 0, 1, 1);
            child.setAutofillValue(AutofillValue.forText((CharSequence)autofill.editState.text));
        }
    }

    public void autofill(SparseArray<AutofillValue> values) {
        if (Build.VERSION.SDK_INT < 26) {
            return;
        }
        TextInputChannel.Configuration.Autofill currentAutofill = this.configuration.autofill;
        if (currentAutofill == null) {
            return;
        }
        HashMap<String, TextInputChannel.TextEditState> editingValues = new HashMap<String, TextInputChannel.TextEditState>();
        for (int i = 0; i < values.size(); ++i) {
            int virtualId = values.keyAt(i);
            TextInputChannel.Configuration config = (TextInputChannel.Configuration)this.mAutofillConfigurations.get(virtualId);
            if (config == null || config.autofill == null) continue;
            TextInputChannel.Configuration.Autofill autofill = config.autofill;
            String value = ((AutofillValue)values.valueAt(i)).getTextValue().toString();
            TextInputChannel.TextEditState newState = new TextInputChannel.TextEditState(value, value.length(), value.length(), -1, -1);
            if (autofill.uniqueIdentifier.equals(currentAutofill.uniqueIdentifier)) {
                this.mEditable.setEditingState(newState);
                continue;
            }
            editingValues.put(autofill.uniqueIdentifier, newState);
        }
        this.textInputChannel.updateEditingStateWithTag(this.inputTarget.id, editingValues);
    }

    private static class InputTarget {
        @NonNull
        Type type;
        int id;

        public InputTarget(@NonNull Type type, int id) {
            this.type = type;
            this.id = id;
        }

        static enum Type {
            NO_TARGET,
            FRAMEWORK_CLIENT,
            PLATFORM_VIEW;

        }
    }

    private static interface MinMax {
        public void inspect(double var1, double var3);
    }
}

