/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.view.KeyEvent;
import android.view.View;
import androidx.annotation.NonNull;
import io.flutter.Log;
import io.flutter.plugin.editing.TextInputPlugin;
import java.util.HashSet;

public class KeyboardManager {
    private static final String TAG = "KeyboardManager";
    @NonNull
    protected final Responder[] responders;
    @NonNull
    private final HashSet<KeyEvent> redispatchedEvents = new HashSet();
    @NonNull
    private final TextInputPlugin textInputPlugin;
    private final View view;

    public KeyboardManager(View view, @NonNull TextInputPlugin textInputPlugin, Responder[] responders) {
        this.view = view;
        this.textInputPlugin = textInputPlugin;
        this.responders = responders;
    }

    public boolean handleEvent(@NonNull KeyEvent keyEvent) {
        boolean isRedispatchedEvent = this.redispatchedEvents.remove(keyEvent);
        if (isRedispatchedEvent) {
            return false;
        }
        if (this.responders.length > 0) {
            PerEventCallbackBuilder callbackBuilder = new PerEventCallbackBuilder(keyEvent);
            for (Responder primaryResponder : this.responders) {
                primaryResponder.handleEvent(keyEvent, callbackBuilder.buildCallback());
            }
        } else {
            this.onUnhandled(keyEvent);
        }
        return true;
    }

    public void destroy() {
        int remainingRedispatchCount = this.redispatchedEvents.size();
        if (remainingRedispatchCount > 0) {
            Log.w(TAG, "A KeyboardManager was destroyed with " + String.valueOf(remainingRedispatchCount) + " unhandled redispatch event(s).");
        }
    }

    private void onUnhandled(@NonNull KeyEvent keyEvent) {
        if (this.textInputPlugin.handleKeyEvent(keyEvent) || this.view == null) {
            return;
        }
        this.redispatchedEvents.add(keyEvent);
        this.view.getRootView().dispatchKeyEvent(keyEvent);
        if (this.redispatchedEvents.remove(keyEvent)) {
            Log.w(TAG, "A redispatched key event was consumed before reaching KeyboardManager");
        }
    }

    private class PerEventCallbackBuilder {
        @NonNull
        final KeyEvent keyEvent;
        int unrepliedCount;
        boolean isEventHandled;

        PerEventCallbackBuilder(KeyEvent keyEvent) {
            this.unrepliedCount = KeyboardManager.this.responders.length;
            this.isEventHandled = false;
            this.keyEvent = keyEvent;
        }

        public Responder.OnKeyEventHandledCallback buildCallback() {
            return new Callback();
        }

        private class Callback
        implements Responder.OnKeyEventHandledCallback {
            boolean isCalled = false;

            private Callback() {
            }

            @Override
            public void onKeyEventHandled(Boolean canHandleEvent) {
                if (this.isCalled) {
                    throw new IllegalStateException("The onKeyEventHandledCallback should be called exactly once.");
                }
                this.isCalled = true;
                --PerEventCallbackBuilder.this.unrepliedCount;
                PerEventCallbackBuilder.this.isEventHandled |= canHandleEvent.booleanValue();
                if (PerEventCallbackBuilder.this.unrepliedCount == 0 && !PerEventCallbackBuilder.this.isEventHandled) {
                    KeyboardManager.this.onUnhandled(PerEventCallbackBuilder.this.keyEvent);
                }
            }
        }
    }

    static interface Responder {
        public void handleEvent(@NonNull KeyEvent var1, @NonNull OnKeyEventHandledCallback var2);

        public static interface OnKeyEventHandledCallback {
            public void onKeyEventHandled(Boolean var1);
        }
    }
}

