/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.systemchannels;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.FlutterInjector;
import io.flutter.Log;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.embedding.engine.deferredcomponents.DeferredComponentManager;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.StandardMethodCodec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeferredComponentChannel {
    private static final String TAG = "DeferredComponentChannel";
    @NonNull
    private final MethodChannel channel;
    @Nullable
    private DeferredComponentManager deferredComponentManager;
    @NonNull
    private Map<String, List<MethodChannel.Result>> componentNameToResults;
    @NonNull
    @VisibleForTesting
    final MethodChannel.MethodCallHandler parsingMethodHandler = new MethodChannel.MethodCallHandler(){

        @Override
        public void onMethodCall(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            if (DeferredComponentChannel.this.deferredComponentManager == null) {
                return;
            }
            String method = call.method;
            Map args = (Map)call.arguments();
            Log.v(DeferredComponentChannel.TAG, "Received '" + method + "' message.");
            int loadingUnitId = (Integer)args.get("loadingUnitId");
            String componentName = (String)args.get("componentName");
            switch (method) {
                case "installDeferredComponent": {
                    DeferredComponentChannel.this.deferredComponentManager.installDeferredComponent(loadingUnitId, componentName);
                    if (!DeferredComponentChannel.this.componentNameToResults.containsKey(componentName)) {
                        DeferredComponentChannel.this.componentNameToResults.put(componentName, new ArrayList());
                    }
                    ((List)DeferredComponentChannel.this.componentNameToResults.get(componentName)).add(result);
                    break;
                }
                case "getDeferredComponentInstallState": {
                    result.success(DeferredComponentChannel.this.deferredComponentManager.getDeferredComponentInstallState(loadingUnitId, componentName));
                    break;
                }
                case "uninstallDeferredComponent": {
                    DeferredComponentChannel.this.deferredComponentManager.uninstallDeferredComponent(loadingUnitId, componentName);
                    result.success(null);
                    break;
                }
                default: {
                    result.notImplemented();
                }
            }
        }
    };

    public DeferredComponentChannel(@NonNull DartExecutor dartExecutor) {
        this.channel = new MethodChannel(dartExecutor, "flutter/deferredcomponent", StandardMethodCodec.INSTANCE);
        this.channel.setMethodCallHandler(this.parsingMethodHandler);
        this.deferredComponentManager = FlutterInjector.instance().deferredComponentManager();
        this.componentNameToResults = new HashMap<String, List<MethodChannel.Result>>();
    }

    @VisibleForTesting
    public void setDeferredComponentManager(@Nullable DeferredComponentManager deferredComponentManager) {
        this.deferredComponentManager = deferredComponentManager;
    }

    public void completeInstallSuccess(String componentName) {
        if (this.componentNameToResults.containsKey(componentName)) {
            for (MethodChannel.Result result : this.componentNameToResults.get(componentName)) {
                result.success(null);
            }
            this.componentNameToResults.get(componentName).clear();
        }
    }

    public void completeInstallError(String componentName, String errorMessage) {
        if (this.componentNameToResults.containsKey(componentName)) {
            for (MethodChannel.Result result : this.componentNameToResults.get(componentName)) {
                result.error("DeferredComponent Install failure", errorMessage, null);
            }
            this.componentNameToResults.get(componentName).clear();
        }
    }
}

