// GENERATED CODE - DO NOT EDIT

// Copyright 2019 The Flutter team. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'dart:ui' as ui;
import 'package:flutter/material.dart';
import 'src/google_fonts_base.dart';
import 'src/google_fonts_descriptor.dart';
import 'src/google_fonts_variant.dart';

/// A collection of properties used to specify custom behavior of the
/// GoogleFonts library.
class _Config {
  /// Whether or not the GoogleFonts library can make requests to
  /// [fonts.google.com](https://fonts.google.com/) to retrieve font files.
  var allowRuntimeFetching = true;
}

/// Provides configuration, and static methods to obtain [TextStyle]s and [TextTheme]s.
///
/// {@youtube 560 315 https://www.youtube.com/watch?v=8Vzv2CdbEY0}
///
/// Obtain a map of available fonts with [asMap]. Retrieve a font by family name
/// with [getFont]. Retrieve a text theme by its font family name [getTextTheme].
///
/// Check out the [README](https://github.com/material-foundation/google-fonts-flutter/blob/main/README.md) for more info.
class GoogleFonts {
  /// Configuration for the [GoogleFonts] library.
  ///
  /// Use this to define custom behavior of the GoogleFonts library in your app.
  /// For example, if you do not want the GoogleFonts library to make any HTTP
  /// requests for fonts, add the following snippet to your app's `main` method.
  ///
  /// ```dart
  /// GoogleFonts.config.allowRuntimeFetching = false;
  /// ```
  static final config = _Config();

  /// Get a map of all available fonts.
  ///
  /// Returns a map where the key is the name of the font family and the value
  /// is the corresponding [GoogleFonts] method.
  static Map<
      String,
      TextStyle Function({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  })> asMap() => const {
        'ABeeZee': GoogleFonts.aBeeZee,
        'Abel': GoogleFonts.abel,
        'Abhaya Libre': GoogleFonts.abhayaLibre,
        'Abril Fatface': GoogleFonts.abrilFatface,
        'Aclonica': GoogleFonts.aclonica,
        'Acme': GoogleFonts.acme,
        'Actor': GoogleFonts.actor,
        'Adamina': GoogleFonts.adamina,
        'Advent Pro': GoogleFonts.adventPro,
        'Aguafina Script': GoogleFonts.aguafinaScript,
        'Akaya Kanadaka': GoogleFonts.akayaKanadaka,
        'Akaya Telivigala': GoogleFonts.akayaTelivigala,
        'Akronim': GoogleFonts.akronim,
        'Akshar': GoogleFonts.akshar,
        'Aladin': GoogleFonts.aladin,
        'Alata': GoogleFonts.alata,
        'Alatsi': GoogleFonts.alatsi,
        'Aldrich': GoogleFonts.aldrich,
        'Alef': GoogleFonts.alef,
        'Alegreya': GoogleFonts.alegreya,
        'Alegreya SC': GoogleFonts.alegreyaSc,
        'Alegreya Sans': GoogleFonts.alegreyaSans,
        'Alegreya Sans SC': GoogleFonts.alegreyaSansSc,
        'Aleo': GoogleFonts.aleo,
        'Alex Brush': GoogleFonts.alexBrush,
        'Alfa Slab One': GoogleFonts.alfaSlabOne,
        'Alice': GoogleFonts.alice,
        'Alike': GoogleFonts.alike,
        'Alike Angular': GoogleFonts.alikeAngular,
        'Allan': GoogleFonts.allan,
        'Allerta': GoogleFonts.allerta,
        'Allerta Stencil': GoogleFonts.allertaStencil,
        'Allison': GoogleFonts.allison,
        'Allura': GoogleFonts.allura,
        'Almarai': GoogleFonts.almarai,
        'Almendra': GoogleFonts.almendra,
        'Almendra Display': GoogleFonts.almendraDisplay,
        'Almendra SC': GoogleFonts.almendraSc,
        'Alumni Sans': GoogleFonts.alumniSans,
        'Alumni Sans Inline One': GoogleFonts.alumniSansInlineOne,
        'Amarante': GoogleFonts.amarante,
        'Amaranth': GoogleFonts.amaranth,
        'Amatic SC': GoogleFonts.amaticSc,
        'Amethysta': GoogleFonts.amethysta,
        'Amiko': GoogleFonts.amiko,
        'Amiri': GoogleFonts.amiri,
        'Amita': GoogleFonts.amita,
        'Anaheim': GoogleFonts.anaheim,
        'Andada Pro': GoogleFonts.andadaPro,
        'Andika': GoogleFonts.andika,
        'Andika New Basic': GoogleFonts.andikaNewBasic,
        'Anek Bangla': GoogleFonts.anekBangla,
        'Anek Devanagari': GoogleFonts.anekDevanagari,
        'Anek Gujarati': GoogleFonts.anekGujarati,
        'Anek Gurmukhi': GoogleFonts.anekGurmukhi,
        'Anek Kannada': GoogleFonts.anekKannada,
        'Anek Latin': GoogleFonts.anekLatin,
        'Anek Malayalam': GoogleFonts.anekMalayalam,
        'Anek Odia': GoogleFonts.anekOdia,
        'Anek Tamil': GoogleFonts.anekTamil,
        'Anek Telugu': GoogleFonts.anekTelugu,
        'Angkor': GoogleFonts.angkor,
        'Annie Use Your Telescope': GoogleFonts.annieUseYourTelescope,
        'Anonymous Pro': GoogleFonts.anonymousPro,
        'Antic': GoogleFonts.antic,
        'Antic Didone': GoogleFonts.anticDidone,
        'Antic Slab': GoogleFonts.anticSlab,
        'Anton': GoogleFonts.anton,
        'Antonio': GoogleFonts.antonio,
        'Anybody': GoogleFonts.anybody,
        'Arapey': GoogleFonts.arapey,
        'Arbutus': GoogleFonts.arbutus,
        'Arbutus Slab': GoogleFonts.arbutusSlab,
        'Architects Daughter': GoogleFonts.architectsDaughter,
        'Archivo': GoogleFonts.archivo,
        'Archivo Black': GoogleFonts.archivoBlack,
        'Archivo Narrow': GoogleFonts.archivoNarrow,
        'Are You Serious': GoogleFonts.areYouSerious,
        'Aref Ruqaa': GoogleFonts.arefRuqaa,
        'Arima Madurai': GoogleFonts.arimaMadurai,
        'Arimo': GoogleFonts.arimo,
        'Arizonia': GoogleFonts.arizonia,
        'Armata': GoogleFonts.armata,
        'Arsenal': GoogleFonts.arsenal,
        'Artifika': GoogleFonts.artifika,
        'Arvo': GoogleFonts.arvo,
        'Arya': GoogleFonts.arya,
        'Asap': GoogleFonts.asap,
        'Asap Condensed': GoogleFonts.asapCondensed,
        'Asar': GoogleFonts.asar,
        'Asset': GoogleFonts.asset,
        'Assistant': GoogleFonts.assistant,
        'Astloch': GoogleFonts.astloch,
        'Asul': GoogleFonts.asul,
        'Athiti': GoogleFonts.athiti,
        'Atkinson Hyperlegible': GoogleFonts.atkinsonHyperlegible,
        'Atma': GoogleFonts.atma,
        'Atomic Age': GoogleFonts.atomicAge,
        'Aubrey': GoogleFonts.aubrey,
        'Audiowide': GoogleFonts.audiowide,
        'Autour One': GoogleFonts.autourOne,
        'Average': GoogleFonts.average,
        'Average Sans': GoogleFonts.averageSans,
        'Averia Gruesa Libre': GoogleFonts.averiaGruesaLibre,
        'Averia Libre': GoogleFonts.averiaLibre,
        'Averia Sans Libre': GoogleFonts.averiaSansLibre,
        'Averia Serif Libre': GoogleFonts.averiaSerifLibre,
        'Azeret Mono': GoogleFonts.azeretMono,
        'B612': GoogleFonts.b612,
        'B612 Mono': GoogleFonts.b612Mono,
        'BIZ UDGothic': GoogleFonts.bizUDGothic,
        'BIZ UDMincho': GoogleFonts.bizUDMincho,
        'BIZ UDPGothic': GoogleFonts.bizUDPGothic,
        'BIZ UDPMincho': GoogleFonts.bizUDPMincho,
        'Babylonica': GoogleFonts.babylonica,
        'Bad Script': GoogleFonts.badScript,
        'Bahiana': GoogleFonts.bahiana,
        'Bahianita': GoogleFonts.bahianita,
        'Bai Jamjuree': GoogleFonts.baiJamjuree,
        'Bakbak One': GoogleFonts.bakbakOne,
        'Ballet': GoogleFonts.ballet,
        'Baloo 2': GoogleFonts.baloo2,
        'Baloo Bhai 2': GoogleFonts.balooBhai2,
        'Baloo Bhaijaan 2': GoogleFonts.balooBhaijaan2,
        'Baloo Bhaina 2': GoogleFonts.balooBhaina2,
        'Baloo Chettan 2': GoogleFonts.balooChettan2,
        'Baloo Da 2': GoogleFonts.balooDa2,
        'Baloo Paaji 2': GoogleFonts.balooPaaji2,
        'Baloo Tamma 2': GoogleFonts.balooTamma2,
        'Baloo Tammudu 2': GoogleFonts.balooTammudu2,
        'Baloo Thambi 2': GoogleFonts.balooThambi2,
        'Balsamiq Sans': GoogleFonts.balsamiqSans,
        'Balthazar': GoogleFonts.balthazar,
        'Bangers': GoogleFonts.bangers,
        'Barlow': GoogleFonts.barlow,
        'Barlow Condensed': GoogleFonts.barlowCondensed,
        'Barlow Semi Condensed': GoogleFonts.barlowSemiCondensed,
        'Barriecito': GoogleFonts.barriecito,
        'Barrio': GoogleFonts.barrio,
        'Basic': GoogleFonts.basic,
        'Baskervville': GoogleFonts.baskervville,
        'Battambang': GoogleFonts.battambang,
        'Baumans': GoogleFonts.baumans,
        'Bayon': GoogleFonts.bayon,
        'Be Vietnam Pro': GoogleFonts.beVietnamPro,
        'Beau Rivage': GoogleFonts.beauRivage,
        'Bebas Neue': GoogleFonts.bebasNeue,
        'Belgrano': GoogleFonts.belgrano,
        'Bellefair': GoogleFonts.bellefair,
        'Belleza': GoogleFonts.belleza,
        'Bellota': GoogleFonts.bellota,
        'Bellota Text': GoogleFonts.bellotaText,
        'BenchNine': GoogleFonts.benchNine,
        'Benne': GoogleFonts.benne,
        'Bentham': GoogleFonts.bentham,
        'Berkshire Swash': GoogleFonts.berkshireSwash,
        'Besley': GoogleFonts.besley,
        'Beth Ellen': GoogleFonts.bethEllen,
        'Bevan': GoogleFonts.bevan,
        'BhuTuka Expanded One': GoogleFonts.bhuTukaExpandedOne,
        'Big Shoulders Display': GoogleFonts.bigShouldersDisplay,
        'Big Shoulders Inline Display': GoogleFonts.bigShouldersInlineDisplay,
        'Big Shoulders Inline Text': GoogleFonts.bigShouldersInlineText,
        'Big Shoulders Stencil Display': GoogleFonts.bigShouldersStencilDisplay,
        'Big Shoulders Stencil Text': GoogleFonts.bigShouldersStencilText,
        'Big Shoulders Text': GoogleFonts.bigShouldersText,
        'Bigelow Rules': GoogleFonts.bigelowRules,
        'Bigshot One': GoogleFonts.bigshotOne,
        'Bilbo': GoogleFonts.bilbo,
        'Bilbo Swash Caps': GoogleFonts.bilboSwashCaps,
        'BioRhyme': GoogleFonts.bioRhyme,
        'BioRhyme Expanded': GoogleFonts.bioRhymeExpanded,
        'Birthstone': GoogleFonts.birthstone,
        'Birthstone Bounce': GoogleFonts.birthstoneBounce,
        'Biryani': GoogleFonts.biryani,
        'Bitter': GoogleFonts.bitter,
        'Black And White Picture': GoogleFonts.blackAndWhitePicture,
        'Black Han Sans': GoogleFonts.blackHanSans,
        'Black Ops One': GoogleFonts.blackOpsOne,
        'Blinker': GoogleFonts.blinker,
        'Bodoni Moda': GoogleFonts.bodoniModa,
        'Bokor': GoogleFonts.bokor,
        'Bona Nova': GoogleFonts.bonaNova,
        'Bonbon': GoogleFonts.bonbon,
        'Bonheur Royale': GoogleFonts.bonheurRoyale,
        'Boogaloo': GoogleFonts.boogaloo,
        'Bowlby One': GoogleFonts.bowlbyOne,
        'Bowlby One SC': GoogleFonts.bowlbyOneSc,
        'Brawler': GoogleFonts.brawler,
        'Bree Serif': GoogleFonts.breeSerif,
        'Brygada 1918': GoogleFonts.brygada1918,
        'Bubblegum Sans': GoogleFonts.bubblegumSans,
        'Bubbler One': GoogleFonts.bubblerOne,
        'Buda': GoogleFonts.buda,
        'Buenard': GoogleFonts.buenard,
        'Bungee': GoogleFonts.bungee,
        'Bungee Hairline': GoogleFonts.bungeeHairline,
        'Bungee Inline': GoogleFonts.bungeeInline,
        'Bungee Outline': GoogleFonts.bungeeOutline,
        'Bungee Shade': GoogleFonts.bungeeShade,
        'Butcherman': GoogleFonts.butcherman,
        'Butterfly Kids': GoogleFonts.butterflyKids,
        'Cabin': GoogleFonts.cabin,
        'Cabin Condensed': GoogleFonts.cabinCondensed,
        'Cabin Sketch': GoogleFonts.cabinSketch,
        'Caesar Dressing': GoogleFonts.caesarDressing,
        'Cagliostro': GoogleFonts.cagliostro,
        'Cairo': GoogleFonts.cairo,
        'Caladea': GoogleFonts.caladea,
        'Calistoga': GoogleFonts.calistoga,
        'Calligraffitti': GoogleFonts.calligraffitti,
        'Cambay': GoogleFonts.cambay,
        'Cambo': GoogleFonts.cambo,
        'Candal': GoogleFonts.candal,
        'Cantarell': GoogleFonts.cantarell,
        'Cantata One': GoogleFonts.cantataOne,
        'Cantora One': GoogleFonts.cantoraOne,
        'Capriola': GoogleFonts.capriola,
        'Caramel': GoogleFonts.caramel,
        'Carattere': GoogleFonts.carattere,
        'Cardo': GoogleFonts.cardo,
        'Carme': GoogleFonts.carme,
        'Carrois Gothic': GoogleFonts.carroisGothic,
        'Carrois Gothic SC': GoogleFonts.carroisGothicSc,
        'Carter One': GoogleFonts.carterOne,
        'Castoro': GoogleFonts.castoro,
        'Catamaran': GoogleFonts.catamaran,
        'Caudex': GoogleFonts.caudex,
        'Caveat': GoogleFonts.caveat,
        'Caveat Brush': GoogleFonts.caveatBrush,
        'Cedarville Cursive': GoogleFonts.cedarvilleCursive,
        'Ceviche One': GoogleFonts.cevicheOne,
        'Chakra Petch': GoogleFonts.chakraPetch,
        'Changa': GoogleFonts.changa,
        'Changa One': GoogleFonts.changaOne,
        'Chango': GoogleFonts.chango,
        'Charm': GoogleFonts.charm,
        'Charmonman': GoogleFonts.charmonman,
        'Chathura': GoogleFonts.chathura,
        'Chau Philomene One': GoogleFonts.chauPhilomeneOne,
        'Chela One': GoogleFonts.chelaOne,
        'Chelsea Market': GoogleFonts.chelseaMarket,
        'Chenla': GoogleFonts.chenla,
        'Cherish': GoogleFonts.cherish,
        'Cherry Cream Soda': GoogleFonts.cherryCreamSoda,
        'Cherry Swash': GoogleFonts.cherrySwash,
        'Chewy': GoogleFonts.chewy,
        'Chicle': GoogleFonts.chicle,
        'Chilanka': GoogleFonts.chilanka,
        'Chivo': GoogleFonts.chivo,
        'Chonburi': GoogleFonts.chonburi,
        'Cinzel': GoogleFonts.cinzel,
        'Cinzel Decorative': GoogleFonts.cinzelDecorative,
        'Clicker Script': GoogleFonts.clickerScript,
        'Coda': GoogleFonts.coda,
        'Coda Caption': GoogleFonts.codaCaption,
        'Codystar': GoogleFonts.codystar,
        'Coiny': GoogleFonts.coiny,
        'Combo': GoogleFonts.combo,
        'Comfortaa': GoogleFonts.comfortaa,
        'Comforter': GoogleFonts.comforter,
        'Comforter Brush': GoogleFonts.comforterBrush,
        'Comic Neue': GoogleFonts.comicNeue,
        'Coming Soon': GoogleFonts.comingSoon,
        'Commissioner': GoogleFonts.commissioner,
        'Concert One': GoogleFonts.concertOne,
        'Condiment': GoogleFonts.condiment,
        'Content': GoogleFonts.content,
        'Contrail One': GoogleFonts.contrailOne,
        'Convergence': GoogleFonts.convergence,
        'Cookie': GoogleFonts.cookie,
        'Copse': GoogleFonts.copse,
        'Corben': GoogleFonts.corben,
        'Corinthia': GoogleFonts.corinthia,
        'Cormorant': GoogleFonts.cormorant,
        'Cormorant Garamond': GoogleFonts.cormorantGaramond,
        'Cormorant Infant': GoogleFonts.cormorantInfant,
        'Cormorant SC': GoogleFonts.cormorantSc,
        'Cormorant Unicase': GoogleFonts.cormorantUnicase,
        'Cormorant Upright': GoogleFonts.cormorantUpright,
        'Courgette': GoogleFonts.courgette,
        'Courier Prime': GoogleFonts.courierPrime,
        'Cousine': GoogleFonts.cousine,
        'Coustard': GoogleFonts.coustard,
        'Covered By Your Grace': GoogleFonts.coveredByYourGrace,
        'Crafty Girls': GoogleFonts.craftyGirls,
        'Creepster': GoogleFonts.creepster,
        'Crete Round': GoogleFonts.creteRound,
        'Crimson Pro': GoogleFonts.crimsonPro,
        'Croissant One': GoogleFonts.croissantOne,
        'Crushed': GoogleFonts.crushed,
        'Cuprum': GoogleFonts.cuprum,
        'Cute Font': GoogleFonts.cuteFont,
        'Cutive': GoogleFonts.cutive,
        'Cutive Mono': GoogleFonts.cutiveMono,
        'DM Mono': GoogleFonts.dmMono,
        'DM Sans': GoogleFonts.dmSans,
        'DM Serif Display': GoogleFonts.dmSerifDisplay,
        'DM Serif Text': GoogleFonts.dmSerifText,
        'Damion': GoogleFonts.damion,
        'Dancing Script': GoogleFonts.dancingScript,
        'Dangrek': GoogleFonts.dangrek,
        'Darker Grotesque': GoogleFonts.darkerGrotesque,
        'David Libre': GoogleFonts.davidLibre,
        'Dawning of a New Day': GoogleFonts.dawningOfANewDay,
        'Days One': GoogleFonts.daysOne,
        'Dekko': GoogleFonts.dekko,
        'Dela Gothic One': GoogleFonts.delaGothicOne,
        'Delius': GoogleFonts.delius,
        'Delius Swash Caps': GoogleFonts.deliusSwashCaps,
        'Delius Unicase': GoogleFonts.deliusUnicase,
        'Della Respira': GoogleFonts.dellaRespira,
        'Denk One': GoogleFonts.denkOne,
        'Devonshire': GoogleFonts.devonshire,
        'Dhurjati': GoogleFonts.dhurjati,
        'Didact Gothic': GoogleFonts.didactGothic,
        'Diplomata': GoogleFonts.diplomata,
        'Diplomata SC': GoogleFonts.diplomataSc,
        'Do Hyeon': GoogleFonts.doHyeon,
        'Dokdo': GoogleFonts.dokdo,
        'Domine': GoogleFonts.domine,
        'Donegal One': GoogleFonts.donegalOne,
        'Dongle': GoogleFonts.dongle,
        'Doppio One': GoogleFonts.doppioOne,
        'Dorsa': GoogleFonts.dorsa,
        'Dosis': GoogleFonts.dosis,
        'DotGothic16': GoogleFonts.dotGothic16,
        'Dr Sugiyama': GoogleFonts.drSugiyama,
        'Duru Sans': GoogleFonts.duruSans,
        'Dynalight': GoogleFonts.dynalight,
        'EB Garamond': GoogleFonts.ebGaramond,
        'Eagle Lake': GoogleFonts.eagleLake,
        'East Sea Dokdo': GoogleFonts.eastSeaDokdo,
        'Eater': GoogleFonts.eater,
        'Economica': GoogleFonts.economica,
        'Eczar': GoogleFonts.eczar,
        'El Messiri': GoogleFonts.elMessiri,
        'Electrolize': GoogleFonts.electrolize,
        'Elsie': GoogleFonts.elsie,
        'Elsie Swash Caps': GoogleFonts.elsieSwashCaps,
        'Emblema One': GoogleFonts.emblemaOne,
        'Emilys Candy': GoogleFonts.emilysCandy,
        'Encode Sans': GoogleFonts.encodeSans,
        'Encode Sans Condensed': GoogleFonts.encodeSansCondensed,
        'Encode Sans Expanded': GoogleFonts.encodeSansExpanded,
        'Encode Sans SC': GoogleFonts.encodeSansSc,
        'Encode Sans Semi Condensed': GoogleFonts.encodeSansSemiCondensed,
        'Encode Sans Semi Expanded': GoogleFonts.encodeSansSemiExpanded,
        'Engagement': GoogleFonts.engagement,
        'Englebert': GoogleFonts.englebert,
        'Enriqueta': GoogleFonts.enriqueta,
        'Ephesis': GoogleFonts.ephesis,
        'Epilogue': GoogleFonts.epilogue,
        'Erica One': GoogleFonts.ericaOne,
        'Esteban': GoogleFonts.esteban,
        'Estonia': GoogleFonts.estonia,
        'Euphoria Script': GoogleFonts.euphoriaScript,
        'Ewert': GoogleFonts.ewert,
        'Exo': GoogleFonts.exo,
        'Exo 2': GoogleFonts.exo2,
        'Expletus Sans': GoogleFonts.expletusSans,
        'Explora': GoogleFonts.explora,
        'Fahkwang': GoogleFonts.fahkwang,
        'Familjen Grotesk': GoogleFonts.familjenGrotesk,
        'Fanwood Text': GoogleFonts.fanwoodText,
        'Farro': GoogleFonts.farro,
        'Farsan': GoogleFonts.farsan,
        'Fascinate': GoogleFonts.fascinate,
        'Fascinate Inline': GoogleFonts.fascinateInline,
        'Faster One': GoogleFonts.fasterOne,
        'Fasthand': GoogleFonts.fasthand,
        'Fauna One': GoogleFonts.faunaOne,
        'Faustina': GoogleFonts.faustina,
        'Federant': GoogleFonts.federant,
        'Federo': GoogleFonts.federo,
        'Felipa': GoogleFonts.felipa,
        'Fenix': GoogleFonts.fenix,
        'Festive': GoogleFonts.festive,
        'Finger Paint': GoogleFonts.fingerPaint,
        'Fira Code': GoogleFonts.firaCode,
        'Fira Mono': GoogleFonts.firaMono,
        'Fira Sans': GoogleFonts.firaSans,
        'Fira Sans Condensed': GoogleFonts.firaSansCondensed,
        'Fira Sans Extra Condensed': GoogleFonts.firaSansExtraCondensed,
        'Fjalla One': GoogleFonts.fjallaOne,
        'Fjord One': GoogleFonts.fjordOne,
        'Flamenco': GoogleFonts.flamenco,
        'Flavors': GoogleFonts.flavors,
        'Fleur De Leah': GoogleFonts.fleurDeLeah,
        'Flow Block': GoogleFonts.flowBlock,
        'Flow Circular': GoogleFonts.flowCircular,
        'Flow Rounded': GoogleFonts.flowRounded,
        'Fondamento': GoogleFonts.fondamento,
        'Fontdiner Swanky': GoogleFonts.fontdinerSwanky,
        'Forum': GoogleFonts.forum,
        'Francois One': GoogleFonts.francoisOne,
        'Frank Ruhl Libre': GoogleFonts.frankRuhlLibre,
        'Fraunces': GoogleFonts.fraunces,
        'Freckle Face': GoogleFonts.freckleFace,
        'Fredericka the Great': GoogleFonts.frederickaTheGreat,
        'Fredoka': GoogleFonts.fredoka,
        'Fredoka One': GoogleFonts.fredokaOne,
        'Freehand': GoogleFonts.freehand,
        'Fresca': GoogleFonts.fresca,
        'Frijole': GoogleFonts.frijole,
        'Fruktur': GoogleFonts.fruktur,
        'Fugaz One': GoogleFonts.fugazOne,
        'Fuggles': GoogleFonts.fuggles,
        'Fuzzy Bubbles': GoogleFonts.fuzzyBubbles,
        'GFS Didot': GoogleFonts.gfsDidot,
        'GFS Neohellenic': GoogleFonts.gfsNeohellenic,
        'Gabriela': GoogleFonts.gabriela,
        'Gaegu': GoogleFonts.gaegu,
        'Gafata': GoogleFonts.gafata,
        'Galada': GoogleFonts.galada,
        'Galdeano': GoogleFonts.galdeano,
        'Galindo': GoogleFonts.galindo,
        'Gamja Flower': GoogleFonts.gamjaFlower,
        'Gayathri': GoogleFonts.gayathri,
        'Gelasio': GoogleFonts.gelasio,
        'Gemunu Libre': GoogleFonts.gemunuLibre,
        'Genos': GoogleFonts.genos,
        'Gentium Basic': GoogleFonts.gentiumBasic,
        'Gentium Book Basic': GoogleFonts.gentiumBookBasic,
        'Geo': GoogleFonts.geo,
        'Georama': GoogleFonts.georama,
        'Geostar': GoogleFonts.geostar,
        'Geostar Fill': GoogleFonts.geostarFill,
        'Germania One': GoogleFonts.germaniaOne,
        'Gideon Roman': GoogleFonts.gideonRoman,
        'Gidugu': GoogleFonts.gidugu,
        'Gilda Display': GoogleFonts.gildaDisplay,
        'Girassol': GoogleFonts.girassol,
        'Give You Glory': GoogleFonts.giveYouGlory,
        'Glass Antiqua': GoogleFonts.glassAntiqua,
        'Glegoo': GoogleFonts.glegoo,
        'Gloria Hallelujah': GoogleFonts.gloriaHallelujah,
        'Glory': GoogleFonts.glory,
        'Gluten': GoogleFonts.gluten,
        'Goblin One': GoogleFonts.goblinOne,
        'Gochi Hand': GoogleFonts.gochiHand,
        'Goldman': GoogleFonts.goldman,
        'Gorditas': GoogleFonts.gorditas,
        'Gothic A1': GoogleFonts.gothicA1,
        'Gotu': GoogleFonts.gotu,
        'Goudy Bookletter 1911': GoogleFonts.goudyBookletter1911,
        'Gowun Batang': GoogleFonts.gowunBatang,
        'Gowun Dodum': GoogleFonts.gowunDodum,
        'Graduate': GoogleFonts.graduate,
        'Grand Hotel': GoogleFonts.grandHotel,
        'Grandstander': GoogleFonts.grandstander,
        'Grape Nuts': GoogleFonts.grapeNuts,
        'Gravitas One': GoogleFonts.gravitasOne,
        'Great Vibes': GoogleFonts.greatVibes,
        'Grechen Fuemen': GoogleFonts.grechenFuemen,
        'Grenze': GoogleFonts.grenze,
        'Grenze Gotisch': GoogleFonts.grenzeGotisch,
        'Grey Qo': GoogleFonts.greyQo,
        'Griffy': GoogleFonts.griffy,
        'Gruppo': GoogleFonts.gruppo,
        'Gudea': GoogleFonts.gudea,
        'Gugi': GoogleFonts.gugi,
        'Gupter': GoogleFonts.gupter,
        'Gurajada': GoogleFonts.gurajada,
        'Gwendolyn': GoogleFonts.gwendolyn,
        'Habibi': GoogleFonts.habibi,
        'Hachi Maru Pop': GoogleFonts.hachiMaruPop,
        'Hahmlet': GoogleFonts.hahmlet,
        'Halant': GoogleFonts.halant,
        'Hammersmith One': GoogleFonts.hammersmithOne,
        'Hanalei': GoogleFonts.hanalei,
        'Hanalei Fill': GoogleFonts.hanaleiFill,
        'Handlee': GoogleFonts.handlee,
        'Hanuman': GoogleFonts.hanuman,
        'Happy Monkey': GoogleFonts.happyMonkey,
        'Harmattan': GoogleFonts.harmattan,
        'Headland One': GoogleFonts.headlandOne,
        'Heebo': GoogleFonts.heebo,
        'Henny Penny': GoogleFonts.hennyPenny,
        'Hepta Slab': GoogleFonts.heptaSlab,
        'Herr Von Muellerhoff': GoogleFonts.herrVonMuellerhoff,
        'Hi Melody': GoogleFonts.hiMelody,
        'Hina Mincho': GoogleFonts.hinaMincho,
        'Hind': GoogleFonts.hind,
        'Hind Guntur': GoogleFonts.hindGuntur,
        'Hind Madurai': GoogleFonts.hindMadurai,
        'Hind Siliguri': GoogleFonts.hindSiliguri,
        'Hind Vadodara': GoogleFonts.hindVadodara,
        'Holtwood One SC': GoogleFonts.holtwoodOneSc,
        'Homemade Apple': GoogleFonts.homemadeApple,
        'Homenaje': GoogleFonts.homenaje,
        'Hubballi': GoogleFonts.hubballi,
        'Hurricane': GoogleFonts.hurricane,
        'IBM Plex Mono': GoogleFonts.ibmPlexMono,
        'IBM Plex Sans': GoogleFonts.ibmPlexSans,
        'IBM Plex Sans Arabic': GoogleFonts.ibmPlexSansArabic,
        'IBM Plex Sans Condensed': GoogleFonts.ibmPlexSansCondensed,
        'IBM Plex Sans Devanagari': GoogleFonts.ibmPlexSansDevanagari,
        'IBM Plex Sans Hebrew': GoogleFonts.ibmPlexSansHebrew,
        'IBM Plex Sans KR': GoogleFonts.ibmPlexSansKr,
        'IBM Plex Sans Thai': GoogleFonts.ibmPlexSansThai,
        'IBM Plex Sans Thai Looped': GoogleFonts.ibmPlexSansThaiLooped,
        'IBM Plex Serif': GoogleFonts.ibmPlexSerif,
        'IM Fell DW Pica': GoogleFonts.imFellDwPica,
        'IM Fell DW Pica SC': GoogleFonts.imFellDwPicaSc,
        'IM Fell Double Pica': GoogleFonts.imFellDoublePica,
        'IM Fell Double Pica SC': GoogleFonts.imFellDoublePicaSc,
        'IM Fell English': GoogleFonts.imFellEnglish,
        'IM Fell English SC': GoogleFonts.imFellEnglishSc,
        'IM Fell French Canon': GoogleFonts.imFellFrenchCanon,
        'IM Fell French Canon SC': GoogleFonts.imFellFrenchCanonSc,
        'IM Fell Great Primer': GoogleFonts.imFellGreatPrimer,
        'IM Fell Great Primer SC': GoogleFonts.imFellGreatPrimerSc,
        'Ibarra Real Nova': GoogleFonts.ibarraRealNova,
        'Iceberg': GoogleFonts.iceberg,
        'Iceland': GoogleFonts.iceland,
        'Imbue': GoogleFonts.imbue,
        'Imperial Script': GoogleFonts.imperialScript,
        'Imprima': GoogleFonts.imprima,
        'Inconsolata': GoogleFonts.inconsolata,
        'Inder': GoogleFonts.inder,
        'Indie Flower': GoogleFonts.indieFlower,
        'Ingrid Darling': GoogleFonts.ingridDarling,
        'Inika': GoogleFonts.inika,
        'Inknut Antiqua': GoogleFonts.inknutAntiqua,
        'Inria Sans': GoogleFonts.inriaSans,
        'Inria Serif': GoogleFonts.inriaSerif,
        'Inspiration': GoogleFonts.inspiration,
        'Inter': GoogleFonts.inter,
        'Irish Grover': GoogleFonts.irishGrover,
        'Island Moments': GoogleFonts.islandMoments,
        'Istok Web': GoogleFonts.istokWeb,
        'Italiana': GoogleFonts.italiana,
        'Italianno': GoogleFonts.italianno,
        'Itim': GoogleFonts.itim,
        'Jacques Francois': GoogleFonts.jacquesFrancois,
        'Jacques Francois Shadow': GoogleFonts.jacquesFrancoisShadow,
        'Jaldi': GoogleFonts.jaldi,
        'JetBrains Mono': GoogleFonts.jetBrainsMono,
        'Jim Nightshade': GoogleFonts.jimNightshade,
        'Jockey One': GoogleFonts.jockeyOne,
        'Jolly Lodger': GoogleFonts.jollyLodger,
        'Jomhuria': GoogleFonts.jomhuria,
        'Jomolhari': GoogleFonts.jomolhari,
        'Josefin Sans': GoogleFonts.josefinSans,
        'Josefin Slab': GoogleFonts.josefinSlab,
        'Jost': GoogleFonts.jost,
        'Joti One': GoogleFonts.jotiOne,
        'Jua': GoogleFonts.jua,
        'Judson': GoogleFonts.judson,
        'Julee': GoogleFonts.julee,
        'Julius Sans One': GoogleFonts.juliusSansOne,
        'Junge': GoogleFonts.junge,
        'Jura': GoogleFonts.jura,
        'Just Another Hand': GoogleFonts.justAnotherHand,
        'Just Me Again Down Here': GoogleFonts.justMeAgainDownHere,
        'K2D': GoogleFonts.k2d,
        'Kadwa': GoogleFonts.kadwa,
        'Kaisei Decol': GoogleFonts.kaiseiDecol,
        'Kaisei HarunoUmi': GoogleFonts.kaiseiHarunoUmi,
        'Kaisei Opti': GoogleFonts.kaiseiOpti,
        'Kaisei Tokumin': GoogleFonts.kaiseiTokumin,
        'Kalam': GoogleFonts.kalam,
        'Kameron': GoogleFonts.kameron,
        'Kanit': GoogleFonts.kanit,
        'Kantumruy': GoogleFonts.kantumruy,
        'Karantina': GoogleFonts.karantina,
        'Karla': GoogleFonts.karla,
        'Karma': GoogleFonts.karma,
        'Katibeh': GoogleFonts.katibeh,
        'Kaushan Script': GoogleFonts.kaushanScript,
        'Kavivanar': GoogleFonts.kavivanar,
        'Kavoon': GoogleFonts.kavoon,
        'Kdam Thmor': GoogleFonts.kdamThmor,
        'Keania One': GoogleFonts.keaniaOne,
        'Kelly Slab': GoogleFonts.kellySlab,
        'Kenia': GoogleFonts.kenia,
        'Khand': GoogleFonts.khand,
        'Khmer': GoogleFonts.khmer,
        'Khula': GoogleFonts.khula,
        'Kings': GoogleFonts.kings,
        'Kirang Haerang': GoogleFonts.kirangHaerang,
        'Kite One': GoogleFonts.kiteOne,
        'Kiwi Maru': GoogleFonts.kiwiMaru,
        'Klee One': GoogleFonts.kleeOne,
        'Knewave': GoogleFonts.knewave,
        'KoHo': GoogleFonts.koHo,
        'Kodchasan': GoogleFonts.kodchasan,
        'Koh Santepheap': GoogleFonts.kohSantepheap,
        'Kolker Brush': GoogleFonts.kolkerBrush,
        'Kosugi': GoogleFonts.kosugi,
        'Kosugi Maru': GoogleFonts.kosugiMaru,
        'Kotta One': GoogleFonts.kottaOne,
        'Koulen': GoogleFonts.koulen,
        'Kranky': GoogleFonts.kranky,
        'Kreon': GoogleFonts.kreon,
        'Kristi': GoogleFonts.kristi,
        'Krona One': GoogleFonts.kronaOne,
        'Krub': GoogleFonts.krub,
        'Kufam': GoogleFonts.kufam,
        'Kulim Park': GoogleFonts.kulimPark,
        'Kumar One': GoogleFonts.kumarOne,
        'Kumar One Outline': GoogleFonts.kumarOneOutline,
        'Kumbh Sans': GoogleFonts.kumbhSans,
        'Kurale': GoogleFonts.kurale,
        'La Belle Aurore': GoogleFonts.laBelleAurore,
        'Lacquer': GoogleFonts.lacquer,
        'Laila': GoogleFonts.laila,
        'Lakki Reddy': GoogleFonts.lakkiReddy,
        'Lalezar': GoogleFonts.lalezar,
        'Lancelot': GoogleFonts.lancelot,
        'Langar': GoogleFonts.langar,
        'Lateef': GoogleFonts.lateef,
        'Lato': GoogleFonts.lato,
        'Lavishly Yours': GoogleFonts.lavishlyYours,
        'League Gothic': GoogleFonts.leagueGothic,
        'League Script': GoogleFonts.leagueScript,
        'League Spartan': GoogleFonts.leagueSpartan,
        'Leckerli One': GoogleFonts.leckerliOne,
        'Ledger': GoogleFonts.ledger,
        'Lekton': GoogleFonts.lekton,
        'Lemon': GoogleFonts.lemon,
        'Lemonada': GoogleFonts.lemonada,
        'Lexend': GoogleFonts.lexend,
        'Lexend Deca': GoogleFonts.lexendDeca,
        'Lexend Exa': GoogleFonts.lexendExa,
        'Lexend Giga': GoogleFonts.lexendGiga,
        'Lexend Mega': GoogleFonts.lexendMega,
        'Lexend Peta': GoogleFonts.lexendPeta,
        'Lexend Tera': GoogleFonts.lexendTera,
        'Lexend Zetta': GoogleFonts.lexendZetta,
        'Libre Barcode 128': GoogleFonts.libreBarcode128,
        'Libre Barcode 128 Text': GoogleFonts.libreBarcode128Text,
        'Libre Barcode 39': GoogleFonts.libreBarcode39,
        'Libre Barcode 39 Extended': GoogleFonts.libreBarcode39Extended,
        'Libre Barcode 39 Extended Text':
            GoogleFonts.libreBarcode39ExtendedText,
        'Libre Barcode 39 Text': GoogleFonts.libreBarcode39Text,
        'Libre Barcode EAN13 Text': GoogleFonts.libreBarcodeEan13Text,
        'Libre Baskerville': GoogleFonts.libreBaskerville,
        'Libre Bodoni': GoogleFonts.libreBodoni,
        'Libre Caslon Display': GoogleFonts.libreCaslonDisplay,
        'Libre Caslon Text': GoogleFonts.libreCaslonText,
        'Libre Franklin': GoogleFonts.libreFranklin,
        'Licorice': GoogleFonts.licorice,
        'Life Savers': GoogleFonts.lifeSavers,
        'Lilita One': GoogleFonts.lilitaOne,
        'Lily Script One': GoogleFonts.lilyScriptOne,
        'Limelight': GoogleFonts.limelight,
        'Linden Hill': GoogleFonts.lindenHill,
        'Literata': GoogleFonts.literata,
        'Liu Jian Mao Cao': GoogleFonts.liuJianMaoCao,
        'Livvic': GoogleFonts.livvic,
        'Lobster': GoogleFonts.lobster,
        'Lobster Two': GoogleFonts.lobsterTwo,
        'Londrina Outline': GoogleFonts.londrinaOutline,
        'Londrina Shadow': GoogleFonts.londrinaShadow,
        'Londrina Sketch': GoogleFonts.londrinaSketch,
        'Londrina Solid': GoogleFonts.londrinaSolid,
        'Long Cang': GoogleFonts.longCang,
        'Lora': GoogleFonts.lora,
        'Love Light': GoogleFonts.loveLight,
        'Love Ya Like A Sister': GoogleFonts.loveYaLikeASister,
        'Loved by the King': GoogleFonts.lovedByTheKing,
        'Lovers Quarrel': GoogleFonts.loversQuarrel,
        'Luckiest Guy': GoogleFonts.luckiestGuy,
        'Lusitana': GoogleFonts.lusitana,
        'Lustria': GoogleFonts.lustria,
        'Luxurious Roman': GoogleFonts.luxuriousRoman,
        'Luxurious Script': GoogleFonts.luxuriousScript,
        'M PLUS 1': GoogleFonts.mPlus1,
        'M PLUS 1 Code': GoogleFonts.mPlus1Code,
        'M PLUS 1p': GoogleFonts.mPlus1p,
        'M PLUS 2': GoogleFonts.mPlus2,
        'M PLUS Code Latin': GoogleFonts.mPlusCodeLatin,
        'M PLUS Rounded 1c': GoogleFonts.mPlusRounded1c,
        'Ma Shan Zheng': GoogleFonts.maShanZheng,
        'Macondo': GoogleFonts.macondo,
        'Macondo Swash Caps': GoogleFonts.macondoSwashCaps,
        'Mada': GoogleFonts.mada,
        'Magra': GoogleFonts.magra,
        'Maiden Orange': GoogleFonts.maidenOrange,
        'Maitree': GoogleFonts.maitree,
        'Major Mono Display': GoogleFonts.majorMonoDisplay,
        'Mako': GoogleFonts.mako,
        'Mali': GoogleFonts.mali,
        'Mallanna': GoogleFonts.mallanna,
        'Mandali': GoogleFonts.mandali,
        'Manjari': GoogleFonts.manjari,
        'Manrope': GoogleFonts.manrope,
        'Mansalva': GoogleFonts.mansalva,
        'Manuale': GoogleFonts.manuale,
        'Marcellus': GoogleFonts.marcellus,
        'Marcellus SC': GoogleFonts.marcellusSc,
        'Marck Script': GoogleFonts.marckScript,
        'Margarine': GoogleFonts.margarine,
        'Markazi Text': GoogleFonts.markaziText,
        'Marko One': GoogleFonts.markoOne,
        'Marmelad': GoogleFonts.marmelad,
        'Martel': GoogleFonts.martel,
        'Martel Sans': GoogleFonts.martelSans,
        'Marvel': GoogleFonts.marvel,
        'Mate': GoogleFonts.mate,
        'Mate SC': GoogleFonts.mateSc,
        'Maven Pro': GoogleFonts.mavenPro,
        'McLaren': GoogleFonts.mcLaren,
        'Mea Culpa': GoogleFonts.meaCulpa,
        'Meddon': GoogleFonts.meddon,
        'MedievalSharp': GoogleFonts.medievalSharp,
        'Medula One': GoogleFonts.medulaOne,
        'Meera Inimai': GoogleFonts.meeraInimai,
        'Megrim': GoogleFonts.megrim,
        'Meie Script': GoogleFonts.meieScript,
        'Meow Script': GoogleFonts.meowScript,
        'Merienda': GoogleFonts.merienda,
        'Merienda One': GoogleFonts.meriendaOne,
        'Merriweather': GoogleFonts.merriweather,
        'Merriweather Sans': GoogleFonts.merriweatherSans,
        'Metal': GoogleFonts.metal,
        'Metal Mania': GoogleFonts.metalMania,
        'Metamorphous': GoogleFonts.metamorphous,
        'Metrophobic': GoogleFonts.metrophobic,
        'Michroma': GoogleFonts.michroma,
        'Milonga': GoogleFonts.milonga,
        'Miltonian': GoogleFonts.miltonian,
        'Miltonian Tattoo': GoogleFonts.miltonianTattoo,
        'Mina': GoogleFonts.mina,
        'Miniver': GoogleFonts.miniver,
        'Miriam Libre': GoogleFonts.miriamLibre,
        'Mirza': GoogleFonts.mirza,
        'Miss Fajardose': GoogleFonts.missFajardose,
        'Mitr': GoogleFonts.mitr,
        'Mochiy Pop One': GoogleFonts.mochiyPopOne,
        'Mochiy Pop P One': GoogleFonts.mochiyPopPOne,
        'Modak': GoogleFonts.modak,
        'Modern Antiqua': GoogleFonts.modernAntiqua,
        'Mogra': GoogleFonts.mogra,
        'Mohave': GoogleFonts.mohave,
        'Molengo': GoogleFonts.molengo,
        'Molle': GoogleFonts.molle,
        'Monda': GoogleFonts.monda,
        'Monofett': GoogleFonts.monofett,
        'Monoton': GoogleFonts.monoton,
        'Monsieur La Doulaise': GoogleFonts.monsieurLaDoulaise,
        'Montaga': GoogleFonts.montaga,
        'Montagu Slab': GoogleFonts.montaguSlab,
        'MonteCarlo': GoogleFonts.monteCarlo,
        'Montez': GoogleFonts.montez,
        'Montserrat': GoogleFonts.montserrat,
        'Montserrat Alternates': GoogleFonts.montserratAlternates,
        'Montserrat Subrayada': GoogleFonts.montserratSubrayada,
        'Moo Lah Lah': GoogleFonts.mooLahLah,
        'Moon Dance': GoogleFonts.moonDance,
        'Moul': GoogleFonts.moul,
        'Moulpali': GoogleFonts.moulpali,
        'Mountains of Christmas': GoogleFonts.mountainsOfChristmas,
        'Mouse Memoirs': GoogleFonts.mouseMemoirs,
        'Mr Bedfort': GoogleFonts.mrBedfort,
        'Mr Dafoe': GoogleFonts.mrDafoe,
        'Mr De Haviland': GoogleFonts.mrDeHaviland,
        'Mrs Saint Delafield': GoogleFonts.mrsSaintDelafield,
        'Mrs Sheppards': GoogleFonts.mrsSheppards,
        'Ms Madi': GoogleFonts.msMadi,
        'Mukta': GoogleFonts.mukta,
        'Mukta Mahee': GoogleFonts.muktaMahee,
        'Mukta Malar': GoogleFonts.muktaMalar,
        'Mukta Vaani': GoogleFonts.muktaVaani,
        'Mulish': GoogleFonts.mulish,
        'Murecho': GoogleFonts.murecho,
        'MuseoModerno': GoogleFonts.museoModerno,
        'My Soul': GoogleFonts.mySoul,
        'Mystery Quest': GoogleFonts.mysteryQuest,
        'NTR': GoogleFonts.ntr,
        'Nanum Brush Script': GoogleFonts.nanumBrushScript,
        'Nanum Gothic': GoogleFonts.nanumGothic,
        'Nanum Gothic Coding': GoogleFonts.nanumGothicCoding,
        'Nanum Myeongjo': GoogleFonts.nanumMyeongjo,
        'Nanum Pen Script': GoogleFonts.nanumPenScript,
        'Neonderthaw': GoogleFonts.neonderthaw,
        'Nerko One': GoogleFonts.nerkoOne,
        'Neucha': GoogleFonts.neucha,
        'Neuton': GoogleFonts.neuton,
        'New Rocker': GoogleFonts.newRocker,
        'New Tegomin': GoogleFonts.newTegomin,
        'News Cycle': GoogleFonts.newsCycle,
        'Newsreader': GoogleFonts.newsreader,
        'Niconne': GoogleFonts.niconne,
        'Niramit': GoogleFonts.niramit,
        'Nixie One': GoogleFonts.nixieOne,
        'Nobile': GoogleFonts.nobile,
        'Nokora': GoogleFonts.nokora,
        'Norican': GoogleFonts.norican,
        'Nosifer': GoogleFonts.nosifer,
        'Notable': GoogleFonts.notable,
        'Nothing You Could Do': GoogleFonts.nothingYouCouldDo,
        'Noticia Text': GoogleFonts.noticiaText,
        'Noto Emoji': GoogleFonts.notoEmoji,
        'Noto Kufi Arabic': GoogleFonts.notoKufiArabic,
        'Noto Music': GoogleFonts.notoMusic,
        'Noto Naskh Arabic': GoogleFonts.notoNaskhArabic,
        'Noto Nastaliq Urdu': GoogleFonts.notoNastaliqUrdu,
        'Noto Rashi Hebrew': GoogleFonts.notoRashiHebrew,
        'Noto Sans': GoogleFonts.notoSans,
        'Noto Sans Adlam': GoogleFonts.notoSansAdlam,
        'Noto Sans Adlam Unjoined': GoogleFonts.notoSansAdlamUnjoined,
        'Noto Sans Anatolian Hieroglyphs':
            GoogleFonts.notoSansAnatolianHieroglyphs,
        'Noto Sans Arabic': GoogleFonts.notoSansArabic,
        'Noto Sans Armenian': GoogleFonts.notoSansArmenian,
        'Noto Sans Avestan': GoogleFonts.notoSansAvestan,
        'Noto Sans Balinese': GoogleFonts.notoSansBalinese,
        'Noto Sans Bamum': GoogleFonts.notoSansBamum,
        'Noto Sans Bassa Vah': GoogleFonts.notoSansBassaVah,
        'Noto Sans Batak': GoogleFonts.notoSansBatak,
        'Noto Sans Bengali': GoogleFonts.notoSansBengali,
        'Noto Sans Bhaiksuki': GoogleFonts.notoSansBhaiksuki,
        'Noto Sans Brahmi': GoogleFonts.notoSansBrahmi,
        'Noto Sans Buginese': GoogleFonts.notoSansBuginese,
        'Noto Sans Buhid': GoogleFonts.notoSansBuhid,
        'Noto Sans Canadian Aboriginal': GoogleFonts.notoSansCanadianAboriginal,
        'Noto Sans Carian': GoogleFonts.notoSansCarian,
        'Noto Sans Caucasian Albanian': GoogleFonts.notoSansCaucasianAlbanian,
        'Noto Sans Chakma': GoogleFonts.notoSansChakma,
        'Noto Sans Cham': GoogleFonts.notoSansCham,
        'Noto Sans Cherokee': GoogleFonts.notoSansCherokee,
        'Noto Sans Coptic': GoogleFonts.notoSansCoptic,
        'Noto Sans Cuneiform': GoogleFonts.notoSansCuneiform,
        'Noto Sans Cypriot': GoogleFonts.notoSansCypriot,
        'Noto Sans Deseret': GoogleFonts.notoSansDeseret,
        'Noto Sans Devanagari': GoogleFonts.notoSansDevanagari,
        'Noto Sans Display': GoogleFonts.notoSansDisplay,
        'Noto Sans Duployan': GoogleFonts.notoSansDuployan,
        'Noto Sans Egyptian Hieroglyphs':
            GoogleFonts.notoSansEgyptianHieroglyphs,
        'Noto Sans Elbasan': GoogleFonts.notoSansElbasan,
        'Noto Sans Elymaic': GoogleFonts.notoSansElymaic,
        'Noto Sans Georgian': GoogleFonts.notoSansGeorgian,
        'Noto Sans Glagolitic': GoogleFonts.notoSansGlagolitic,
        'Noto Sans Gothic': GoogleFonts.notoSansGothic,
        'Noto Sans Grantha': GoogleFonts.notoSansGrantha,
        'Noto Sans Gujarati': GoogleFonts.notoSansGujarati,
        'Noto Sans Gunjala Gondi': GoogleFonts.notoSansGunjalaGondi,
        'Noto Sans Gurmukhi': GoogleFonts.notoSansGurmukhi,
        'Noto Sans Hanifi Rohingya': GoogleFonts.notoSansHanifiRohingya,
        'Noto Sans Hanunoo': GoogleFonts.notoSansHanunoo,
        'Noto Sans Hatran': GoogleFonts.notoSansHatran,
        'Noto Sans Hebrew': GoogleFonts.notoSansHebrew,
        'Noto Sans Imperial Aramaic': GoogleFonts.notoSansImperialAramaic,
        'Noto Sans Indic Siyaq Numbers': GoogleFonts.notoSansIndicSiyaqNumbers,
        'Noto Sans Inscriptional Pahlavi':
            GoogleFonts.notoSansInscriptionalPahlavi,
        'Noto Sans Inscriptional Parthian':
            GoogleFonts.notoSansInscriptionalParthian,
        'Noto Sans Javanese': GoogleFonts.notoSansJavanese,
        'Noto Sans Kaithi': GoogleFonts.notoSansKaithi,
        'Noto Sans Kannada': GoogleFonts.notoSansKannada,
        'Noto Sans Kayah Li': GoogleFonts.notoSansKayahLi,
        'Noto Sans Kharoshthi': GoogleFonts.notoSansKharoshthi,
        'Noto Sans Khmer': GoogleFonts.notoSansKhmer,
        'Noto Sans Khojki': GoogleFonts.notoSansKhojki,
        'Noto Sans Khudawadi': GoogleFonts.notoSansKhudawadi,
        'Noto Sans Lao': GoogleFonts.notoSansLao,
        'Noto Sans Lepcha': GoogleFonts.notoSansLepcha,
        'Noto Sans Limbu': GoogleFonts.notoSansLimbu,
        'Noto Sans Linear A': GoogleFonts.notoSansLinearA,
        'Noto Sans Linear B': GoogleFonts.notoSansLinearB,
        'Noto Sans Lisu': GoogleFonts.notoSansLisu,
        'Noto Sans Lycian': GoogleFonts.notoSansLycian,
        'Noto Sans Lydian': GoogleFonts.notoSansLydian,
        'Noto Sans Mahajani': GoogleFonts.notoSansMahajani,
        'Noto Sans Malayalam': GoogleFonts.notoSansMalayalam,
        'Noto Sans Mandaic': GoogleFonts.notoSansMandaic,
        'Noto Sans Manichaean': GoogleFonts.notoSansManichaean,
        'Noto Sans Marchen': GoogleFonts.notoSansMarchen,
        'Noto Sans Masaram Gondi': GoogleFonts.notoSansMasaramGondi,
        'Noto Sans Math': GoogleFonts.notoSansMath,
        'Noto Sans Mayan Numerals': GoogleFonts.notoSansMayanNumerals,
        'Noto Sans Medefaidrin': GoogleFonts.notoSansMedefaidrin,
        'Noto Sans Meetei Mayek': GoogleFonts.notoSansMeeteiMayek,
        'Noto Sans Meroitic': GoogleFonts.notoSansMeroitic,
        'Noto Sans Miao': GoogleFonts.notoSansMiao,
        'Noto Sans Modi': GoogleFonts.notoSansModi,
        'Noto Sans Mongolian': GoogleFonts.notoSansMongolian,
        'Noto Sans Mono': GoogleFonts.notoSansMono,
        'Noto Sans Mro': GoogleFonts.notoSansMro,
        'Noto Sans Multani': GoogleFonts.notoSansMultani,
        'Noto Sans Myanmar': GoogleFonts.notoSansMyanmar,
        'Noto Sans N Ko': GoogleFonts.notoSansNKo,
        'Noto Sans Nabataean': GoogleFonts.notoSansNabataean,
        'Noto Sans New Tai Lue': GoogleFonts.notoSansNewTaiLue,
        'Noto Sans Newa': GoogleFonts.notoSansNewa,
        'Noto Sans Nushu': GoogleFonts.notoSansNushu,
        'Noto Sans Ogham': GoogleFonts.notoSansOgham,
        'Noto Sans Ol Chiki': GoogleFonts.notoSansOlChiki,
        'Noto Sans Old Hungarian': GoogleFonts.notoSansOldHungarian,
        'Noto Sans Old Italic': GoogleFonts.notoSansOldItalic,
        'Noto Sans Old North Arabian': GoogleFonts.notoSansOldNorthArabian,
        'Noto Sans Old Permic': GoogleFonts.notoSansOldPermic,
        'Noto Sans Old Persian': GoogleFonts.notoSansOldPersian,
        'Noto Sans Old Sogdian': GoogleFonts.notoSansOldSogdian,
        'Noto Sans Old South Arabian': GoogleFonts.notoSansOldSouthArabian,
        'Noto Sans Old Turkic': GoogleFonts.notoSansOldTurkic,
        'Noto Sans Oriya': GoogleFonts.notoSansOriya,
        'Noto Sans Osage': GoogleFonts.notoSansOsage,
        'Noto Sans Osmanya': GoogleFonts.notoSansOsmanya,
        'Noto Sans Pahawh Hmong': GoogleFonts.notoSansPahawhHmong,
        'Noto Sans Palmyrene': GoogleFonts.notoSansPalmyrene,
        'Noto Sans Pau Cin Hau': GoogleFonts.notoSansPauCinHau,
        'Noto Sans Phags Pa': GoogleFonts.notoSansPhagsPa,
        'Noto Sans Phoenician': GoogleFonts.notoSansPhoenician,
        'Noto Sans Psalter Pahlavi': GoogleFonts.notoSansPsalterPahlavi,
        'Noto Sans Rejang': GoogleFonts.notoSansRejang,
        'Noto Sans Runic': GoogleFonts.notoSansRunic,
        'Noto Sans Samaritan': GoogleFonts.notoSansSamaritan,
        'Noto Sans Saurashtra': GoogleFonts.notoSansSaurashtra,
        'Noto Sans Sharada': GoogleFonts.notoSansSharada,
        'Noto Sans Shavian': GoogleFonts.notoSansShavian,
        'Noto Sans Siddham': GoogleFonts.notoSansSiddham,
        'Noto Sans Sinhala': GoogleFonts.notoSansSinhala,
        'Noto Sans Sogdian': GoogleFonts.notoSansSogdian,
        'Noto Sans Sora Sompeng': GoogleFonts.notoSansSoraSompeng,
        'Noto Sans Soyombo': GoogleFonts.notoSansSoyombo,
        'Noto Sans Sundanese': GoogleFonts.notoSansSundanese,
        'Noto Sans Syloti Nagri': GoogleFonts.notoSansSylotiNagri,
        'Noto Sans Symbols': GoogleFonts.notoSansSymbols,
        'Noto Sans Symbols 2': GoogleFonts.notoSansSymbols2,
        'Noto Sans Syriac': GoogleFonts.notoSansSyriac,
        'Noto Sans Tagalog': GoogleFonts.notoSansTagalog,
        'Noto Sans Tagbanwa': GoogleFonts.notoSansTagbanwa,
        'Noto Sans Tai Le': GoogleFonts.notoSansTaiLe,
        'Noto Sans Tai Tham': GoogleFonts.notoSansTaiTham,
        'Noto Sans Tai Viet': GoogleFonts.notoSansTaiViet,
        'Noto Sans Takri': GoogleFonts.notoSansTakri,
        'Noto Sans Tamil': GoogleFonts.notoSansTamil,
        'Noto Sans Tamil Supplement': GoogleFonts.notoSansTamilSupplement,
        'Noto Sans Telugu': GoogleFonts.notoSansTelugu,
        'Noto Sans Thaana': GoogleFonts.notoSansThaana,
        'Noto Sans Thai': GoogleFonts.notoSansThai,
        'Noto Sans Thai Looped': GoogleFonts.notoSansThaiLooped,
        'Noto Sans Tifinagh': GoogleFonts.notoSansTifinagh,
        'Noto Sans Tirhuta': GoogleFonts.notoSansTirhuta,
        'Noto Sans Ugaritic': GoogleFonts.notoSansUgaritic,
        'Noto Sans Vai': GoogleFonts.notoSansVai,
        'Noto Sans Wancho': GoogleFonts.notoSansWancho,
        'Noto Sans Warang Citi': GoogleFonts.notoSansWarangCiti,
        'Noto Sans Yi': GoogleFonts.notoSansYi,
        'Noto Sans Zanabazar Square': GoogleFonts.notoSansZanabazarSquare,
        'Noto Serif': GoogleFonts.notoSerif,
        'Noto Serif Ahom': GoogleFonts.notoSerifAhom,
        'Noto Serif Armenian': GoogleFonts.notoSerifArmenian,
        'Noto Serif Balinese': GoogleFonts.notoSerifBalinese,
        'Noto Serif Bengali': GoogleFonts.notoSerifBengali,
        'Noto Serif Devanagari': GoogleFonts.notoSerifDevanagari,
        'Noto Serif Display': GoogleFonts.notoSerifDisplay,
        'Noto Serif Dogra': GoogleFonts.notoSerifDogra,
        'Noto Serif Ethiopic': GoogleFonts.notoSerifEthiopic,
        'Noto Serif Georgian': GoogleFonts.notoSerifGeorgian,
        'Noto Serif Grantha': GoogleFonts.notoSerifGrantha,
        'Noto Serif Gujarati': GoogleFonts.notoSerifGujarati,
        'Noto Serif Gurmukhi': GoogleFonts.notoSerifGurmukhi,
        'Noto Serif Hebrew': GoogleFonts.notoSerifHebrew,
        'Noto Serif Kannada': GoogleFonts.notoSerifKannada,
        'Noto Serif Khmer': GoogleFonts.notoSerifKhmer,
        'Noto Serif Lao': GoogleFonts.notoSerifLao,
        'Noto Serif Malayalam': GoogleFonts.notoSerifMalayalam,
        'Noto Serif Myanmar': GoogleFonts.notoSerifMyanmar,
        'Noto Serif Nyiakeng Puachue Hmong':
            GoogleFonts.notoSerifNyiakengPuachueHmong,
        'Noto Serif Sinhala': GoogleFonts.notoSerifSinhala,
        'Noto Serif Tamil': GoogleFonts.notoSerifTamil,
        'Noto Serif Tangut': GoogleFonts.notoSerifTangut,
        'Noto Serif Telugu': GoogleFonts.notoSerifTelugu,
        'Noto Serif Thai': GoogleFonts.notoSerifThai,
        'Noto Serif Tibetan': GoogleFonts.notoSerifTibetan,
        'Noto Serif Yezidi': GoogleFonts.notoSerifYezidi,
        'Noto Traditional Nushu': GoogleFonts.notoTraditionalNushu,
        'Nova Cut': GoogleFonts.novaCut,
        'Nova Flat': GoogleFonts.novaFlat,
        'Nova Mono': GoogleFonts.novaMono,
        'Nova Oval': GoogleFonts.novaOval,
        'Nova Round': GoogleFonts.novaRound,
        'Nova Script': GoogleFonts.novaScript,
        'Nova Slim': GoogleFonts.novaSlim,
        'Nova Square': GoogleFonts.novaSquare,
        'Numans': GoogleFonts.numans,
        'Nunito': GoogleFonts.nunito,
        'Nunito Sans': GoogleFonts.nunitoSans,
        'Odibee Sans': GoogleFonts.odibeeSans,
        'Odor Mean Chey': GoogleFonts.odorMeanChey,
        'Offside': GoogleFonts.offside,
        'Oi': GoogleFonts.oi,
        'Old Standard TT': GoogleFonts.oldStandardTt,
        'Oldenburg': GoogleFonts.oldenburg,
        'Ole': GoogleFonts.ole,
        'Oleo Script': GoogleFonts.oleoScript,
        'Oleo Script Swash Caps': GoogleFonts.oleoScriptSwashCaps,
        'Oooh Baby': GoogleFonts.ooohBaby,
        'Open Sans': GoogleFonts.openSans,
        'Open Sans Condensed': GoogleFonts.openSansCondensed,
        'Oranienbaum': GoogleFonts.oranienbaum,
        'Orbitron': GoogleFonts.orbitron,
        'Oregano': GoogleFonts.oregano,
        'Orelega One': GoogleFonts.orelegaOne,
        'Orienta': GoogleFonts.orienta,
        'Original Surfer': GoogleFonts.originalSurfer,
        'Oswald': GoogleFonts.oswald,
        'Otomanopee One': GoogleFonts.otomanopeeOne,
        'Outfit': GoogleFonts.outfit,
        'Over the Rainbow': GoogleFonts.overTheRainbow,
        'Overlock': GoogleFonts.overlock,
        'Overlock SC': GoogleFonts.overlockSc,
        'Overpass': GoogleFonts.overpass,
        'Overpass Mono': GoogleFonts.overpassMono,
        'Ovo': GoogleFonts.ovo,
        'Oxanium': GoogleFonts.oxanium,
        'Oxygen': GoogleFonts.oxygen,
        'Oxygen Mono': GoogleFonts.oxygenMono,
        'PT Mono': GoogleFonts.ptMono,
        'PT Sans': GoogleFonts.ptSans,
        'PT Sans Caption': GoogleFonts.ptSansCaption,
        'PT Sans Narrow': GoogleFonts.ptSansNarrow,
        'PT Serif': GoogleFonts.ptSerif,
        'PT Serif Caption': GoogleFonts.ptSerifCaption,
        'Pacifico': GoogleFonts.pacifico,
        'Padauk': GoogleFonts.padauk,
        'Palanquin': GoogleFonts.palanquin,
        'Palanquin Dark': GoogleFonts.palanquinDark,
        'Palette Mosaic': GoogleFonts.paletteMosaic,
        'Pangolin': GoogleFonts.pangolin,
        'Paprika': GoogleFonts.paprika,
        'Parisienne': GoogleFonts.parisienne,
        'Passero One': GoogleFonts.passeroOne,
        'Passion One': GoogleFonts.passionOne,
        'Passions Conflict': GoogleFonts.passionsConflict,
        'Pathway Gothic One': GoogleFonts.pathwayGothicOne,
        'Patrick Hand': GoogleFonts.patrickHand,
        'Patrick Hand SC': GoogleFonts.patrickHandSc,
        'Pattaya': GoogleFonts.pattaya,
        'Patua One': GoogleFonts.patuaOne,
        'Pavanam': GoogleFonts.pavanam,
        'Paytone One': GoogleFonts.paytoneOne,
        'Peddana': GoogleFonts.peddana,
        'Peralta': GoogleFonts.peralta,
        'Permanent Marker': GoogleFonts.permanentMarker,
        'Petemoss': GoogleFonts.petemoss,
        'Petit Formal Script': GoogleFonts.petitFormalScript,
        'Petrona': GoogleFonts.petrona,
        'Philosopher': GoogleFonts.philosopher,
        'Piazzolla': GoogleFonts.piazzolla,
        'Piedra': GoogleFonts.piedra,
        'Pinyon Script': GoogleFonts.pinyonScript,
        'Pirata One': GoogleFonts.pirataOne,
        'Plaster': GoogleFonts.plaster,
        'Play': GoogleFonts.play,
        'Playball': GoogleFonts.playball,
        'Playfair Display': GoogleFonts.playfairDisplay,
        'Playfair Display SC': GoogleFonts.playfairDisplaySc,
        'Plus Jakarta Sans': GoogleFonts.plusJakartaSans,
        'Podkova': GoogleFonts.podkova,
        'Poiret One': GoogleFonts.poiretOne,
        'Poller One': GoogleFonts.pollerOne,
        'Poly': GoogleFonts.poly,
        'Pompiere': GoogleFonts.pompiere,
        'Pontano Sans': GoogleFonts.pontanoSans,
        'Poor Story': GoogleFonts.poorStory,
        'Poppins': GoogleFonts.poppins,
        'Port Lligat Sans': GoogleFonts.portLligatSans,
        'Port Lligat Slab': GoogleFonts.portLligatSlab,
        'Potta One': GoogleFonts.pottaOne,
        'Pragati Narrow': GoogleFonts.pragatiNarrow,
        'Praise': GoogleFonts.praise,
        'Prata': GoogleFonts.prata,
        'Preahvihear': GoogleFonts.preahvihear,
        'Press Start 2P': GoogleFonts.pressStart2p,
        'Pridi': GoogleFonts.pridi,
        'Princess Sofia': GoogleFonts.princessSofia,
        'Prociono': GoogleFonts.prociono,
        'Prompt': GoogleFonts.prompt,
        'Prosto One': GoogleFonts.prostoOne,
        'Proza Libre': GoogleFonts.prozaLibre,
        'Public Sans': GoogleFonts.publicSans,
        'Puppies Play': GoogleFonts.puppiesPlay,
        'Puritan': GoogleFonts.puritan,
        'Purple Purse': GoogleFonts.purplePurse,
        'Qahiri': GoogleFonts.qahiri,
        'Quando': GoogleFonts.quando,
        'Quantico': GoogleFonts.quantico,
        'Quattrocento': GoogleFonts.quattrocento,
        'Quattrocento Sans': GoogleFonts.quattrocentoSans,
        'Questrial': GoogleFonts.questrial,
        'Quicksand': GoogleFonts.quicksand,
        'Quintessential': GoogleFonts.quintessential,
        'Qwigley': GoogleFonts.qwigley,
        'Qwitcher Grypen': GoogleFonts.qwitcherGrypen,
        'Racing Sans One': GoogleFonts.racingSansOne,
        'Radio Canada': GoogleFonts.radioCanada,
        'Radley': GoogleFonts.radley,
        'Rajdhani': GoogleFonts.rajdhani,
        'Rakkas': GoogleFonts.rakkas,
        'Raleway': GoogleFonts.raleway,
        'Raleway Dots': GoogleFonts.ralewayDots,
        'Ramabhadra': GoogleFonts.ramabhadra,
        'Ramaraja': GoogleFonts.ramaraja,
        'Rambla': GoogleFonts.rambla,
        'Rammetto One': GoogleFonts.rammettoOne,
        'Rampart One': GoogleFonts.rampartOne,
        'Ranchers': GoogleFonts.ranchers,
        'Rancho': GoogleFonts.rancho,
        'Ranga': GoogleFonts.ranga,
        'Rasa': GoogleFonts.rasa,
        'Rationale': GoogleFonts.rationale,
        'Ravi Prakash': GoogleFonts.raviPrakash,
        'Readex Pro': GoogleFonts.readexPro,
        'Recursive': GoogleFonts.recursive,
        'Red Hat Display': GoogleFonts.redHatDisplay,
        'Red Hat Mono': GoogleFonts.redHatMono,
        'Red Hat Text': GoogleFonts.redHatText,
        'Red Rose': GoogleFonts.redRose,
        'Redacted': GoogleFonts.redacted,
        'Redacted Script': GoogleFonts.redactedScript,
        'Redressed': GoogleFonts.redressed,
        'Reem Kufi': GoogleFonts.reemKufi,
        'Reenie Beanie': GoogleFonts.reenieBeanie,
        'Reggae One': GoogleFonts.reggaeOne,
        'Revalia': GoogleFonts.revalia,
        'Rhodium Libre': GoogleFonts.rhodiumLibre,
        'Ribeye': GoogleFonts.ribeye,
        'Ribeye Marrow': GoogleFonts.ribeyeMarrow,
        'Righteous': GoogleFonts.righteous,
        'Risque': GoogleFonts.risque,
        'Road Rage': GoogleFonts.roadRage,
        'Roboto': GoogleFonts.roboto,
        'Roboto Condensed': GoogleFonts.robotoCondensed,
        'Roboto Flex': GoogleFonts.robotoFlex,
        'Roboto Mono': GoogleFonts.robotoMono,
        'Roboto Serif': GoogleFonts.robotoSerif,
        'Roboto Slab': GoogleFonts.robotoSlab,
        'Rochester': GoogleFonts.rochester,
        'Rock 3D': GoogleFonts.rock3d,
        'Rock Salt': GoogleFonts.rockSalt,
        'RocknRoll One': GoogleFonts.rocknRollOne,
        'Rokkitt': GoogleFonts.rokkitt,
        'Romanesco': GoogleFonts.romanesco,
        'Ropa Sans': GoogleFonts.ropaSans,
        'Rosario': GoogleFonts.rosario,
        'Rosarivo': GoogleFonts.rosarivo,
        'Rouge Script': GoogleFonts.rougeScript,
        'Rowdies': GoogleFonts.rowdies,
        'Rozha One': GoogleFonts.rozhaOne,
        'Rubik': GoogleFonts.rubik,
        'Rubik Beastly': GoogleFonts.rubikBeastly,
        'Rubik Bubbles': GoogleFonts.rubikBubbles,
        'Rubik Glitch': GoogleFonts.rubikGlitch,
        'Rubik Microbe': GoogleFonts.rubikMicrobe,
        'Rubik Mono One': GoogleFonts.rubikMonoOne,
        'Rubik Moonrocks': GoogleFonts.rubikMoonrocks,
        'Rubik Puddles': GoogleFonts.rubikPuddles,
        'Rubik Wet Paint': GoogleFonts.rubikWetPaint,
        'Ruda': GoogleFonts.ruda,
        'Rufina': GoogleFonts.rufina,
        'Ruge Boogie': GoogleFonts.rugeBoogie,
        'Ruluko': GoogleFonts.ruluko,
        'Rum Raisin': GoogleFonts.rumRaisin,
        'Ruslan Display': GoogleFonts.ruslanDisplay,
        'Russo One': GoogleFonts.russoOne,
        'Ruthie': GoogleFonts.ruthie,
        'Rye': GoogleFonts.rye,
        'STIX Two Text': GoogleFonts.stixTwoText,
        'Sacramento': GoogleFonts.sacramento,
        'Sahitya': GoogleFonts.sahitya,
        'Sail': GoogleFonts.sail,
        'Saira': GoogleFonts.saira,
        'Saira Condensed': GoogleFonts.sairaCondensed,
        'Saira Extra Condensed': GoogleFonts.sairaExtraCondensed,
        'Saira Semi Condensed': GoogleFonts.sairaSemiCondensed,
        'Saira Stencil One': GoogleFonts.sairaStencilOne,
        'Salsa': GoogleFonts.salsa,
        'Sanchez': GoogleFonts.sanchez,
        'Sancreek': GoogleFonts.sancreek,
        'Sansita': GoogleFonts.sansita,
        'Sansita Swashed': GoogleFonts.sansitaSwashed,
        'Sarabun': GoogleFonts.sarabun,
        'Sarala': GoogleFonts.sarala,
        'Sarina': GoogleFonts.sarina,
        'Sarpanch': GoogleFonts.sarpanch,
        'Sassy Frass': GoogleFonts.sassyFrass,
        'Satisfy': GoogleFonts.satisfy,
        'Sawarabi Gothic': GoogleFonts.sawarabiGothic,
        'Sawarabi Mincho': GoogleFonts.sawarabiMincho,
        'Scada': GoogleFonts.scada,
        'Scheherazade New': GoogleFonts.scheherazadeNew,
        'Schoolbell': GoogleFonts.schoolbell,
        'Scope One': GoogleFonts.scopeOne,
        'Seaweed Script': GoogleFonts.seaweedScript,
        'Secular One': GoogleFonts.secularOne,
        'Sedgwick Ave': GoogleFonts.sedgwickAve,
        'Sedgwick Ave Display': GoogleFonts.sedgwickAveDisplay,
        'Sen': GoogleFonts.sen,
        'Send Flowers': GoogleFonts.sendFlowers,
        'Sevillana': GoogleFonts.sevillana,
        'Seymour One': GoogleFonts.seymourOne,
        'Shadows Into Light': GoogleFonts.shadowsIntoLight,
        'Shadows Into Light Two': GoogleFonts.shadowsIntoLightTwo,
        'Shalimar': GoogleFonts.shalimar,
        'Shanti': GoogleFonts.shanti,
        'Share': GoogleFonts.share,
        'Share Tech': GoogleFonts.shareTech,
        'Share Tech Mono': GoogleFonts.shareTechMono,
        'Shippori Antique': GoogleFonts.shipporiAntique,
        'Shippori Antique B1': GoogleFonts.shipporiAntiqueB1,
        'Shippori Mincho': GoogleFonts.shipporiMincho,
        'Shippori Mincho B1': GoogleFonts.shipporiMinchoB1,
        'Shizuru': GoogleFonts.shizuru,
        'Shojumaru': GoogleFonts.shojumaru,
        'Short Stack': GoogleFonts.shortStack,
        'Shrikhand': GoogleFonts.shrikhand,
        'Siemreap': GoogleFonts.siemreap,
        'Sigmar One': GoogleFonts.sigmarOne,
        'Signika': GoogleFonts.signika,
        'Signika Negative': GoogleFonts.signikaNegative,
        'Simonetta': GoogleFonts.simonetta,
        'Single Day': GoogleFonts.singleDay,
        'Sintony': GoogleFonts.sintony,
        'Sirin Stencil': GoogleFonts.sirinStencil,
        'Six Caps': GoogleFonts.sixCaps,
        'Skranji': GoogleFonts.skranji,
        'Slabo 13px': GoogleFonts.slabo13px,
        'Slabo 27px': GoogleFonts.slabo27px,
        'Slackey': GoogleFonts.slackey,
        'Smokum': GoogleFonts.smokum,
        'Smooch': GoogleFonts.smooch,
        'Smooch Sans': GoogleFonts.smoochSans,
        'Smythe': GoogleFonts.smythe,
        'Sniglet': GoogleFonts.sniglet,
        'Snippet': GoogleFonts.snippet,
        'Snowburst One': GoogleFonts.snowburstOne,
        'Sofadi One': GoogleFonts.sofadiOne,
        'Sofia': GoogleFonts.sofia,
        'Solway': GoogleFonts.solway,
        'Song Myung': GoogleFonts.songMyung,
        'Sonsie One': GoogleFonts.sonsieOne,
        'Sora': GoogleFonts.sora,
        'Sorts Mill Goudy': GoogleFonts.sortsMillGoudy,
        'Source Code Pro': GoogleFonts.sourceCodePro,
        'Source Sans 3': GoogleFonts.sourceSans3,
        'Source Sans Pro': GoogleFonts.sourceSansPro,
        'Source Serif 4': GoogleFonts.sourceSerif4,
        'Source Serif Pro': GoogleFonts.sourceSerifPro,
        'Space Grotesk': GoogleFonts.spaceGrotesk,
        'Space Mono': GoogleFonts.spaceMono,
        'Special Elite': GoogleFonts.specialElite,
        'Spectral': GoogleFonts.spectral,
        'Spectral SC': GoogleFonts.spectralSc,
        'Spicy Rice': GoogleFonts.spicyRice,
        'Spinnaker': GoogleFonts.spinnaker,
        'Spirax': GoogleFonts.spirax,
        'Spline Sans': GoogleFonts.splineSans,
        'Squada One': GoogleFonts.squadaOne,
        'Square Peg': GoogleFonts.squarePeg,
        'Sree Krushnadevaraya': GoogleFonts.sreeKrushnadevaraya,
        'Sriracha': GoogleFonts.sriracha,
        'Srisakdi': GoogleFonts.srisakdi,
        'Staatliches': GoogleFonts.staatliches,
        'Stalemate': GoogleFonts.stalemate,
        'Stalinist One': GoogleFonts.stalinistOne,
        'Stardos Stencil': GoogleFonts.stardosStencil,
        'Stick': GoogleFonts.stick,
        'Stick No Bills': GoogleFonts.stickNoBills,
        'Stint Ultra Condensed': GoogleFonts.stintUltraCondensed,
        'Stint Ultra Expanded': GoogleFonts.stintUltraExpanded,
        'Stoke': GoogleFonts.stoke,
        'Strait': GoogleFonts.strait,
        'Style Script': GoogleFonts.styleScript,
        'Stylish': GoogleFonts.stylish,
        'Sue Ellen Francisco': GoogleFonts.sueEllenFrancisco,
        'Suez One': GoogleFonts.suezOne,
        'Sulphur Point': GoogleFonts.sulphurPoint,
        'Sumana': GoogleFonts.sumana,
        'Sunflower': GoogleFonts.sunflower,
        'Sunshiney': GoogleFonts.sunshiney,
        'Supermercado One': GoogleFonts.supermercadoOne,
        'Sura': GoogleFonts.sura,
        'Suranna': GoogleFonts.suranna,
        'Suravaram': GoogleFonts.suravaram,
        'Suwannaphum': GoogleFonts.suwannaphum,
        'Swanky and Moo Moo': GoogleFonts.swankyAndMooMoo,
        'Syncopate': GoogleFonts.syncopate,
        'Syne': GoogleFonts.syne,
        'Syne Mono': GoogleFonts.syneMono,
        'Syne Tactile': GoogleFonts.syneTactile,
        'Tajawal': GoogleFonts.tajawal,
        'Tangerine': GoogleFonts.tangerine,
        'Tapestry': GoogleFonts.tapestry,
        'Taprom': GoogleFonts.taprom,
        'Tauri': GoogleFonts.tauri,
        'Taviraj': GoogleFonts.taviraj,
        'Teko': GoogleFonts.teko,
        'Telex': GoogleFonts.telex,
        'Tenali Ramakrishna': GoogleFonts.tenaliRamakrishna,
        'Tenor Sans': GoogleFonts.tenorSans,
        'Text Me One': GoogleFonts.textMeOne,
        'Texturina': GoogleFonts.texturina,
        'Thasadith': GoogleFonts.thasadith,
        'The Girl Next Door': GoogleFonts.theGirlNextDoor,
        'The Nautigal': GoogleFonts.theNautigal,
        'Tienne': GoogleFonts.tienne,
        'Tillana': GoogleFonts.tillana,
        'Timmana': GoogleFonts.timmana,
        'Tinos': GoogleFonts.tinos,
        'Titan One': GoogleFonts.titanOne,
        'Titillium Web': GoogleFonts.titilliumWeb,
        'Tomorrow': GoogleFonts.tomorrow,
        'Tourney': GoogleFonts.tourney,
        'Trade Winds': GoogleFonts.tradeWinds,
        'Train One': GoogleFonts.trainOne,
        'Trirong': GoogleFonts.trirong,
        'Trispace': GoogleFonts.trispace,
        'Trocchi': GoogleFonts.trocchi,
        'Trochut': GoogleFonts.trochut,
        'Truculenta': GoogleFonts.truculenta,
        'Trykker': GoogleFonts.trykker,
        'Tulpen One': GoogleFonts.tulpenOne,
        'Turret Road': GoogleFonts.turretRoad,
        'Twinkle Star': GoogleFonts.twinkleStar,
        'Ubuntu': GoogleFonts.ubuntu,
        'Ubuntu Condensed': GoogleFonts.ubuntuCondensed,
        'Ubuntu Mono': GoogleFonts.ubuntuMono,
        'Uchen': GoogleFonts.uchen,
        'Ultra': GoogleFonts.ultra,
        'Uncial Antiqua': GoogleFonts.uncialAntiqua,
        'Underdog': GoogleFonts.underdog,
        'Unica One': GoogleFonts.unicaOne,
        'UnifrakturCook': GoogleFonts.unifrakturCook,
        'UnifrakturMaguntia': GoogleFonts.unifrakturMaguntia,
        'Unkempt': GoogleFonts.unkempt,
        'Unlock': GoogleFonts.unlock,
        'Unna': GoogleFonts.unna,
        'Updock': GoogleFonts.updock,
        'Urbanist': GoogleFonts.urbanist,
        'VT323': GoogleFonts.vt323,
        'Vampiro One': GoogleFonts.vampiroOne,
        'Varela': GoogleFonts.varela,
        'Varela Round': GoogleFonts.varelaRound,
        'Varta': GoogleFonts.varta,
        'Vast Shadow': GoogleFonts.vastShadow,
        'Vazirmatn': GoogleFonts.vazirmatn,
        'Vesper Libre': GoogleFonts.vesperLibre,
        'Viaoda Libre': GoogleFonts.viaodaLibre,
        'Vibes': GoogleFonts.vibes,
        'Vibur': GoogleFonts.vibur,
        'Vidaloka': GoogleFonts.vidaloka,
        'Viga': GoogleFonts.viga,
        'Voces': GoogleFonts.voces,
        'Volkhov': GoogleFonts.volkhov,
        'Vollkorn': GoogleFonts.vollkorn,
        'Vollkorn SC': GoogleFonts.vollkornSc,
        'Voltaire': GoogleFonts.voltaire,
        'Vujahday Script': GoogleFonts.vujahdayScript,
        'Waiting for the Sunrise': GoogleFonts.waitingForTheSunrise,
        'Wallpoet': GoogleFonts.wallpoet,
        'Walter Turncoat': GoogleFonts.walterTurncoat,
        'Warnes': GoogleFonts.warnes,
        'Water Brush': GoogleFonts.waterBrush,
        'Waterfall': GoogleFonts.waterfall,
        'Wellfleet': GoogleFonts.wellfleet,
        'Wendy One': GoogleFonts.wendyOne,
        'Whisper': GoogleFonts.whisper,
        'WindSong': GoogleFonts.windSong,
        'Wire One': GoogleFonts.wireOne,
        'Work Sans': GoogleFonts.workSans,
        'Xanh Mono': GoogleFonts.xanhMono,
        'Yaldevi': GoogleFonts.yaldevi,
        'Yanone Kaffeesatz': GoogleFonts.yanoneKaffeesatz,
        'Yantramanav': GoogleFonts.yantramanav,
        'Yatra One': GoogleFonts.yatraOne,
        'Yellowtail': GoogleFonts.yellowtail,
        'Yeon Sung': GoogleFonts.yeonSung,
        'Yeseva One': GoogleFonts.yesevaOne,
        'Yesteryear': GoogleFonts.yesteryear,
        'Yomogi': GoogleFonts.yomogi,
        'Yrsa': GoogleFonts.yrsa,
        'Yuji Boku': GoogleFonts.yujiBoku,
        'Yuji Hentaigana Akari': GoogleFonts.yujiHentaiganaAkari,
        'Yuji Hentaigana Akebono': GoogleFonts.yujiHentaiganaAkebono,
        'Yuji Mai': GoogleFonts.yujiMai,
        'Yuji Syuku': GoogleFonts.yujiSyuku,
        'Yusei Magic': GoogleFonts.yuseiMagic,
        'ZCOOL KuaiLe': GoogleFonts.zcoolKuaiLe,
        'ZCOOL QingKe HuangYou': GoogleFonts.zcoolQingKeHuangYou,
        'ZCOOL XiaoWei': GoogleFonts.zcoolXiaoWei,
        'Zen Antique': GoogleFonts.zenAntique,
        'Zen Antique Soft': GoogleFonts.zenAntiqueSoft,
        'Zen Dots': GoogleFonts.zenDots,
        'Zen Kaku Gothic Antique': GoogleFonts.zenKakuGothicAntique,
        'Zen Kaku Gothic New': GoogleFonts.zenKakuGothicNew,
        'Zen Kurenaido': GoogleFonts.zenKurenaido,
        'Zen Loop': GoogleFonts.zenLoop,
        'Zen Maru Gothic': GoogleFonts.zenMaruGothic,
        'Zen Old Mincho': GoogleFonts.zenOldMincho,
        'Zen Tokyo Zoo': GoogleFonts.zenTokyoZoo,
        'Zeyada': GoogleFonts.zeyada,
        'Zhi Mang Xing': GoogleFonts.zhiMangXing,
        'Zilla Slab': GoogleFonts.zillaSlab,
        'Zilla Slab Highlight': GoogleFonts.zillaSlabHighlight,
      };

  /// Get a map of all available fonts and their associated text themes.
  ///
  /// Returns a map where the key is the name of the font family and the value
  /// is the corresponding [GoogleFonts] `TextTheme` method.
  static Map<String, TextTheme Function([TextTheme?])> _asMapOfTextThemes() =>
      const {
        'ABeeZee': GoogleFonts.aBeeZeeTextTheme,
        'Abel': GoogleFonts.abelTextTheme,
        'Abhaya Libre': GoogleFonts.abhayaLibreTextTheme,
        'Abril Fatface': GoogleFonts.abrilFatfaceTextTheme,
        'Aclonica': GoogleFonts.aclonicaTextTheme,
        'Acme': GoogleFonts.acmeTextTheme,
        'Actor': GoogleFonts.actorTextTheme,
        'Adamina': GoogleFonts.adaminaTextTheme,
        'Advent Pro': GoogleFonts.adventProTextTheme,
        'Aguafina Script': GoogleFonts.aguafinaScriptTextTheme,
        'Akaya Kanadaka': GoogleFonts.akayaKanadakaTextTheme,
        'Akaya Telivigala': GoogleFonts.akayaTelivigalaTextTheme,
        'Akronim': GoogleFonts.akronimTextTheme,
        'Akshar': GoogleFonts.aksharTextTheme,
        'Aladin': GoogleFonts.aladinTextTheme,
        'Alata': GoogleFonts.alataTextTheme,
        'Alatsi': GoogleFonts.alatsiTextTheme,
        'Aldrich': GoogleFonts.aldrichTextTheme,
        'Alef': GoogleFonts.alefTextTheme,
        'Alegreya': GoogleFonts.alegreyaTextTheme,
        'Alegreya SC': GoogleFonts.alegreyaScTextTheme,
        'Alegreya Sans': GoogleFonts.alegreyaSansTextTheme,
        'Alegreya Sans SC': GoogleFonts.alegreyaSansScTextTheme,
        'Aleo': GoogleFonts.aleoTextTheme,
        'Alex Brush': GoogleFonts.alexBrushTextTheme,
        'Alfa Slab One': GoogleFonts.alfaSlabOneTextTheme,
        'Alice': GoogleFonts.aliceTextTheme,
        'Alike': GoogleFonts.alikeTextTheme,
        'Alike Angular': GoogleFonts.alikeAngularTextTheme,
        'Allan': GoogleFonts.allanTextTheme,
        'Allerta': GoogleFonts.allertaTextTheme,
        'Allerta Stencil': GoogleFonts.allertaStencilTextTheme,
        'Allison': GoogleFonts.allisonTextTheme,
        'Allura': GoogleFonts.alluraTextTheme,
        'Almarai': GoogleFonts.almaraiTextTheme,
        'Almendra': GoogleFonts.almendraTextTheme,
        'Almendra Display': GoogleFonts.almendraDisplayTextTheme,
        'Almendra SC': GoogleFonts.almendraScTextTheme,
        'Alumni Sans': GoogleFonts.alumniSansTextTheme,
        'Alumni Sans Inline One': GoogleFonts.alumniSansInlineOneTextTheme,
        'Amarante': GoogleFonts.amaranteTextTheme,
        'Amaranth': GoogleFonts.amaranthTextTheme,
        'Amatic SC': GoogleFonts.amaticScTextTheme,
        'Amethysta': GoogleFonts.amethystaTextTheme,
        'Amiko': GoogleFonts.amikoTextTheme,
        'Amiri': GoogleFonts.amiriTextTheme,
        'Amita': GoogleFonts.amitaTextTheme,
        'Anaheim': GoogleFonts.anaheimTextTheme,
        'Andada Pro': GoogleFonts.andadaProTextTheme,
        'Andika': GoogleFonts.andikaTextTheme,
        'Andika New Basic': GoogleFonts.andikaNewBasicTextTheme,
        'Anek Bangla': GoogleFonts.anekBanglaTextTheme,
        'Anek Devanagari': GoogleFonts.anekDevanagariTextTheme,
        'Anek Gujarati': GoogleFonts.anekGujaratiTextTheme,
        'Anek Gurmukhi': GoogleFonts.anekGurmukhiTextTheme,
        'Anek Kannada': GoogleFonts.anekKannadaTextTheme,
        'Anek Latin': GoogleFonts.anekLatinTextTheme,
        'Anek Malayalam': GoogleFonts.anekMalayalamTextTheme,
        'Anek Odia': GoogleFonts.anekOdiaTextTheme,
        'Anek Tamil': GoogleFonts.anekTamilTextTheme,
        'Anek Telugu': GoogleFonts.anekTeluguTextTheme,
        'Angkor': GoogleFonts.angkorTextTheme,
        'Annie Use Your Telescope': GoogleFonts.annieUseYourTelescopeTextTheme,
        'Anonymous Pro': GoogleFonts.anonymousProTextTheme,
        'Antic': GoogleFonts.anticTextTheme,
        'Antic Didone': GoogleFonts.anticDidoneTextTheme,
        'Antic Slab': GoogleFonts.anticSlabTextTheme,
        'Anton': GoogleFonts.antonTextTheme,
        'Antonio': GoogleFonts.antonioTextTheme,
        'Anybody': GoogleFonts.anybodyTextTheme,
        'Arapey': GoogleFonts.arapeyTextTheme,
        'Arbutus': GoogleFonts.arbutusTextTheme,
        'Arbutus Slab': GoogleFonts.arbutusSlabTextTheme,
        'Architects Daughter': GoogleFonts.architectsDaughterTextTheme,
        'Archivo': GoogleFonts.archivoTextTheme,
        'Archivo Black': GoogleFonts.archivoBlackTextTheme,
        'Archivo Narrow': GoogleFonts.archivoNarrowTextTheme,
        'Are You Serious': GoogleFonts.areYouSeriousTextTheme,
        'Aref Ruqaa': GoogleFonts.arefRuqaaTextTheme,
        'Arima Madurai': GoogleFonts.arimaMaduraiTextTheme,
        'Arimo': GoogleFonts.arimoTextTheme,
        'Arizonia': GoogleFonts.arizoniaTextTheme,
        'Armata': GoogleFonts.armataTextTheme,
        'Arsenal': GoogleFonts.arsenalTextTheme,
        'Artifika': GoogleFonts.artifikaTextTheme,
        'Arvo': GoogleFonts.arvoTextTheme,
        'Arya': GoogleFonts.aryaTextTheme,
        'Asap': GoogleFonts.asapTextTheme,
        'Asap Condensed': GoogleFonts.asapCondensedTextTheme,
        'Asar': GoogleFonts.asarTextTheme,
        'Asset': GoogleFonts.assetTextTheme,
        'Assistant': GoogleFonts.assistantTextTheme,
        'Astloch': GoogleFonts.astlochTextTheme,
        'Asul': GoogleFonts.asulTextTheme,
        'Athiti': GoogleFonts.athitiTextTheme,
        'Atkinson Hyperlegible': GoogleFonts.atkinsonHyperlegibleTextTheme,
        'Atma': GoogleFonts.atmaTextTheme,
        'Atomic Age': GoogleFonts.atomicAgeTextTheme,
        'Aubrey': GoogleFonts.aubreyTextTheme,
        'Audiowide': GoogleFonts.audiowideTextTheme,
        'Autour One': GoogleFonts.autourOneTextTheme,
        'Average': GoogleFonts.averageTextTheme,
        'Average Sans': GoogleFonts.averageSansTextTheme,
        'Averia Gruesa Libre': GoogleFonts.averiaGruesaLibreTextTheme,
        'Averia Libre': GoogleFonts.averiaLibreTextTheme,
        'Averia Sans Libre': GoogleFonts.averiaSansLibreTextTheme,
        'Averia Serif Libre': GoogleFonts.averiaSerifLibreTextTheme,
        'Azeret Mono': GoogleFonts.azeretMonoTextTheme,
        'B612': GoogleFonts.b612TextTheme,
        'B612 Mono': GoogleFonts.b612MonoTextTheme,
        'BIZ UDGothic': GoogleFonts.bizUDGothicTextTheme,
        'BIZ UDMincho': GoogleFonts.bizUDMinchoTextTheme,
        'BIZ UDPGothic': GoogleFonts.bizUDPGothicTextTheme,
        'BIZ UDPMincho': GoogleFonts.bizUDPMinchoTextTheme,
        'Babylonica': GoogleFonts.babylonicaTextTheme,
        'Bad Script': GoogleFonts.badScriptTextTheme,
        'Bahiana': GoogleFonts.bahianaTextTheme,
        'Bahianita': GoogleFonts.bahianitaTextTheme,
        'Bai Jamjuree': GoogleFonts.baiJamjureeTextTheme,
        'Bakbak One': GoogleFonts.bakbakOneTextTheme,
        'Ballet': GoogleFonts.balletTextTheme,
        'Baloo 2': GoogleFonts.baloo2TextTheme,
        'Baloo Bhai 2': GoogleFonts.balooBhai2TextTheme,
        'Baloo Bhaijaan 2': GoogleFonts.balooBhaijaan2TextTheme,
        'Baloo Bhaina 2': GoogleFonts.balooBhaina2TextTheme,
        'Baloo Chettan 2': GoogleFonts.balooChettan2TextTheme,
        'Baloo Da 2': GoogleFonts.balooDa2TextTheme,
        'Baloo Paaji 2': GoogleFonts.balooPaaji2TextTheme,
        'Baloo Tamma 2': GoogleFonts.balooTamma2TextTheme,
        'Baloo Tammudu 2': GoogleFonts.balooTammudu2TextTheme,
        'Baloo Thambi 2': GoogleFonts.balooThambi2TextTheme,
        'Balsamiq Sans': GoogleFonts.balsamiqSansTextTheme,
        'Balthazar': GoogleFonts.balthazarTextTheme,
        'Bangers': GoogleFonts.bangersTextTheme,
        'Barlow': GoogleFonts.barlowTextTheme,
        'Barlow Condensed': GoogleFonts.barlowCondensedTextTheme,
        'Barlow Semi Condensed': GoogleFonts.barlowSemiCondensedTextTheme,
        'Barriecito': GoogleFonts.barriecitoTextTheme,
        'Barrio': GoogleFonts.barrioTextTheme,
        'Basic': GoogleFonts.basicTextTheme,
        'Baskervville': GoogleFonts.baskervvilleTextTheme,
        'Battambang': GoogleFonts.battambangTextTheme,
        'Baumans': GoogleFonts.baumansTextTheme,
        'Bayon': GoogleFonts.bayonTextTheme,
        'Be Vietnam Pro': GoogleFonts.beVietnamProTextTheme,
        'Beau Rivage': GoogleFonts.beauRivageTextTheme,
        'Bebas Neue': GoogleFonts.bebasNeueTextTheme,
        'Belgrano': GoogleFonts.belgranoTextTheme,
        'Bellefair': GoogleFonts.bellefairTextTheme,
        'Belleza': GoogleFonts.bellezaTextTheme,
        'Bellota': GoogleFonts.bellotaTextTheme,
        'Bellota Text': GoogleFonts.bellotaTextTextTheme,
        'BenchNine': GoogleFonts.benchNineTextTheme,
        'Benne': GoogleFonts.benneTextTheme,
        'Bentham': GoogleFonts.benthamTextTheme,
        'Berkshire Swash': GoogleFonts.berkshireSwashTextTheme,
        'Besley': GoogleFonts.besleyTextTheme,
        'Beth Ellen': GoogleFonts.bethEllenTextTheme,
        'Bevan': GoogleFonts.bevanTextTheme,
        'BhuTuka Expanded One': GoogleFonts.bhuTukaExpandedOneTextTheme,
        'Big Shoulders Display': GoogleFonts.bigShouldersDisplayTextTheme,
        'Big Shoulders Inline Display':
            GoogleFonts.bigShouldersInlineDisplayTextTheme,
        'Big Shoulders Inline Text':
            GoogleFonts.bigShouldersInlineTextTextTheme,
        'Big Shoulders Stencil Display':
            GoogleFonts.bigShouldersStencilDisplayTextTheme,
        'Big Shoulders Stencil Text':
            GoogleFonts.bigShouldersStencilTextTextTheme,
        'Big Shoulders Text': GoogleFonts.bigShouldersTextTextTheme,
        'Bigelow Rules': GoogleFonts.bigelowRulesTextTheme,
        'Bigshot One': GoogleFonts.bigshotOneTextTheme,
        'Bilbo': GoogleFonts.bilboTextTheme,
        'Bilbo Swash Caps': GoogleFonts.bilboSwashCapsTextTheme,
        'BioRhyme': GoogleFonts.bioRhymeTextTheme,
        'BioRhyme Expanded': GoogleFonts.bioRhymeExpandedTextTheme,
        'Birthstone': GoogleFonts.birthstoneTextTheme,
        'Birthstone Bounce': GoogleFonts.birthstoneBounceTextTheme,
        'Biryani': GoogleFonts.biryaniTextTheme,
        'Bitter': GoogleFonts.bitterTextTheme,
        'Black And White Picture': GoogleFonts.blackAndWhitePictureTextTheme,
        'Black Han Sans': GoogleFonts.blackHanSansTextTheme,
        'Black Ops One': GoogleFonts.blackOpsOneTextTheme,
        'Blinker': GoogleFonts.blinkerTextTheme,
        'Bodoni Moda': GoogleFonts.bodoniModaTextTheme,
        'Bokor': GoogleFonts.bokorTextTheme,
        'Bona Nova': GoogleFonts.bonaNovaTextTheme,
        'Bonbon': GoogleFonts.bonbonTextTheme,
        'Bonheur Royale': GoogleFonts.bonheurRoyaleTextTheme,
        'Boogaloo': GoogleFonts.boogalooTextTheme,
        'Bowlby One': GoogleFonts.bowlbyOneTextTheme,
        'Bowlby One SC': GoogleFonts.bowlbyOneScTextTheme,
        'Brawler': GoogleFonts.brawlerTextTheme,
        'Bree Serif': GoogleFonts.breeSerifTextTheme,
        'Brygada 1918': GoogleFonts.brygada1918TextTheme,
        'Bubblegum Sans': GoogleFonts.bubblegumSansTextTheme,
        'Bubbler One': GoogleFonts.bubblerOneTextTheme,
        'Buda': GoogleFonts.budaTextTheme,
        'Buenard': GoogleFonts.buenardTextTheme,
        'Bungee': GoogleFonts.bungeeTextTheme,
        'Bungee Hairline': GoogleFonts.bungeeHairlineTextTheme,
        'Bungee Inline': GoogleFonts.bungeeInlineTextTheme,
        'Bungee Outline': GoogleFonts.bungeeOutlineTextTheme,
        'Bungee Shade': GoogleFonts.bungeeShadeTextTheme,
        'Butcherman': GoogleFonts.butchermanTextTheme,
        'Butterfly Kids': GoogleFonts.butterflyKidsTextTheme,
        'Cabin': GoogleFonts.cabinTextTheme,
        'Cabin Condensed': GoogleFonts.cabinCondensedTextTheme,
        'Cabin Sketch': GoogleFonts.cabinSketchTextTheme,
        'Caesar Dressing': GoogleFonts.caesarDressingTextTheme,
        'Cagliostro': GoogleFonts.cagliostroTextTheme,
        'Cairo': GoogleFonts.cairoTextTheme,
        'Caladea': GoogleFonts.caladeaTextTheme,
        'Calistoga': GoogleFonts.calistogaTextTheme,
        'Calligraffitti': GoogleFonts.calligraffittiTextTheme,
        'Cambay': GoogleFonts.cambayTextTheme,
        'Cambo': GoogleFonts.camboTextTheme,
        'Candal': GoogleFonts.candalTextTheme,
        'Cantarell': GoogleFonts.cantarellTextTheme,
        'Cantata One': GoogleFonts.cantataOneTextTheme,
        'Cantora One': GoogleFonts.cantoraOneTextTheme,
        'Capriola': GoogleFonts.capriolaTextTheme,
        'Caramel': GoogleFonts.caramelTextTheme,
        'Carattere': GoogleFonts.carattereTextTheme,
        'Cardo': GoogleFonts.cardoTextTheme,
        'Carme': GoogleFonts.carmeTextTheme,
        'Carrois Gothic': GoogleFonts.carroisGothicTextTheme,
        'Carrois Gothic SC': GoogleFonts.carroisGothicScTextTheme,
        'Carter One': GoogleFonts.carterOneTextTheme,
        'Castoro': GoogleFonts.castoroTextTheme,
        'Catamaran': GoogleFonts.catamaranTextTheme,
        'Caudex': GoogleFonts.caudexTextTheme,
        'Caveat': GoogleFonts.caveatTextTheme,
        'Caveat Brush': GoogleFonts.caveatBrushTextTheme,
        'Cedarville Cursive': GoogleFonts.cedarvilleCursiveTextTheme,
        'Ceviche One': GoogleFonts.cevicheOneTextTheme,
        'Chakra Petch': GoogleFonts.chakraPetchTextTheme,
        'Changa': GoogleFonts.changaTextTheme,
        'Changa One': GoogleFonts.changaOneTextTheme,
        'Chango': GoogleFonts.changoTextTheme,
        'Charm': GoogleFonts.charmTextTheme,
        'Charmonman': GoogleFonts.charmonmanTextTheme,
        'Chathura': GoogleFonts.chathuraTextTheme,
        'Chau Philomene One': GoogleFonts.chauPhilomeneOneTextTheme,
        'Chela One': GoogleFonts.chelaOneTextTheme,
        'Chelsea Market': GoogleFonts.chelseaMarketTextTheme,
        'Chenla': GoogleFonts.chenlaTextTheme,
        'Cherish': GoogleFonts.cherishTextTheme,
        'Cherry Cream Soda': GoogleFonts.cherryCreamSodaTextTheme,
        'Cherry Swash': GoogleFonts.cherrySwashTextTheme,
        'Chewy': GoogleFonts.chewyTextTheme,
        'Chicle': GoogleFonts.chicleTextTheme,
        'Chilanka': GoogleFonts.chilankaTextTheme,
        'Chivo': GoogleFonts.chivoTextTheme,
        'Chonburi': GoogleFonts.chonburiTextTheme,
        'Cinzel': GoogleFonts.cinzelTextTheme,
        'Cinzel Decorative': GoogleFonts.cinzelDecorativeTextTheme,
        'Clicker Script': GoogleFonts.clickerScriptTextTheme,
        'Coda': GoogleFonts.codaTextTheme,
        'Coda Caption': GoogleFonts.codaCaptionTextTheme,
        'Codystar': GoogleFonts.codystarTextTheme,
        'Coiny': GoogleFonts.coinyTextTheme,
        'Combo': GoogleFonts.comboTextTheme,
        'Comfortaa': GoogleFonts.comfortaaTextTheme,
        'Comforter': GoogleFonts.comforterTextTheme,
        'Comforter Brush': GoogleFonts.comforterBrushTextTheme,
        'Comic Neue': GoogleFonts.comicNeueTextTheme,
        'Coming Soon': GoogleFonts.comingSoonTextTheme,
        'Commissioner': GoogleFonts.commissionerTextTheme,
        'Concert One': GoogleFonts.concertOneTextTheme,
        'Condiment': GoogleFonts.condimentTextTheme,
        'Content': GoogleFonts.contentTextTheme,
        'Contrail One': GoogleFonts.contrailOneTextTheme,
        'Convergence': GoogleFonts.convergenceTextTheme,
        'Cookie': GoogleFonts.cookieTextTheme,
        'Copse': GoogleFonts.copseTextTheme,
        'Corben': GoogleFonts.corbenTextTheme,
        'Corinthia': GoogleFonts.corinthiaTextTheme,
        'Cormorant': GoogleFonts.cormorantTextTheme,
        'Cormorant Garamond': GoogleFonts.cormorantGaramondTextTheme,
        'Cormorant Infant': GoogleFonts.cormorantInfantTextTheme,
        'Cormorant SC': GoogleFonts.cormorantScTextTheme,
        'Cormorant Unicase': GoogleFonts.cormorantUnicaseTextTheme,
        'Cormorant Upright': GoogleFonts.cormorantUprightTextTheme,
        'Courgette': GoogleFonts.courgetteTextTheme,
        'Courier Prime': GoogleFonts.courierPrimeTextTheme,
        'Cousine': GoogleFonts.cousineTextTheme,
        'Coustard': GoogleFonts.coustardTextTheme,
        'Covered By Your Grace': GoogleFonts.coveredByYourGraceTextTheme,
        'Crafty Girls': GoogleFonts.craftyGirlsTextTheme,
        'Creepster': GoogleFonts.creepsterTextTheme,
        'Crete Round': GoogleFonts.creteRoundTextTheme,
        'Crimson Pro': GoogleFonts.crimsonProTextTheme,
        'Croissant One': GoogleFonts.croissantOneTextTheme,
        'Crushed': GoogleFonts.crushedTextTheme,
        'Cuprum': GoogleFonts.cuprumTextTheme,
        'Cute Font': GoogleFonts.cuteFontTextTheme,
        'Cutive': GoogleFonts.cutiveTextTheme,
        'Cutive Mono': GoogleFonts.cutiveMonoTextTheme,
        'DM Mono': GoogleFonts.dmMonoTextTheme,
        'DM Sans': GoogleFonts.dmSansTextTheme,
        'DM Serif Display': GoogleFonts.dmSerifDisplayTextTheme,
        'DM Serif Text': GoogleFonts.dmSerifTextTextTheme,
        'Damion': GoogleFonts.damionTextTheme,
        'Dancing Script': GoogleFonts.dancingScriptTextTheme,
        'Dangrek': GoogleFonts.dangrekTextTheme,
        'Darker Grotesque': GoogleFonts.darkerGrotesqueTextTheme,
        'David Libre': GoogleFonts.davidLibreTextTheme,
        'Dawning of a New Day': GoogleFonts.dawningOfANewDayTextTheme,
        'Days One': GoogleFonts.daysOneTextTheme,
        'Dekko': GoogleFonts.dekkoTextTheme,
        'Dela Gothic One': GoogleFonts.delaGothicOneTextTheme,
        'Delius': GoogleFonts.deliusTextTheme,
        'Delius Swash Caps': GoogleFonts.deliusSwashCapsTextTheme,
        'Delius Unicase': GoogleFonts.deliusUnicaseTextTheme,
        'Della Respira': GoogleFonts.dellaRespiraTextTheme,
        'Denk One': GoogleFonts.denkOneTextTheme,
        'Devonshire': GoogleFonts.devonshireTextTheme,
        'Dhurjati': GoogleFonts.dhurjatiTextTheme,
        'Didact Gothic': GoogleFonts.didactGothicTextTheme,
        'Diplomata': GoogleFonts.diplomataTextTheme,
        'Diplomata SC': GoogleFonts.diplomataScTextTheme,
        'Do Hyeon': GoogleFonts.doHyeonTextTheme,
        'Dokdo': GoogleFonts.dokdoTextTheme,
        'Domine': GoogleFonts.domineTextTheme,
        'Donegal One': GoogleFonts.donegalOneTextTheme,
        'Dongle': GoogleFonts.dongleTextTheme,
        'Doppio One': GoogleFonts.doppioOneTextTheme,
        'Dorsa': GoogleFonts.dorsaTextTheme,
        'Dosis': GoogleFonts.dosisTextTheme,
        'DotGothic16': GoogleFonts.dotGothic16TextTheme,
        'Dr Sugiyama': GoogleFonts.drSugiyamaTextTheme,
        'Duru Sans': GoogleFonts.duruSansTextTheme,
        'Dynalight': GoogleFonts.dynalightTextTheme,
        'EB Garamond': GoogleFonts.ebGaramondTextTheme,
        'Eagle Lake': GoogleFonts.eagleLakeTextTheme,
        'East Sea Dokdo': GoogleFonts.eastSeaDokdoTextTheme,
        'Eater': GoogleFonts.eaterTextTheme,
        'Economica': GoogleFonts.economicaTextTheme,
        'Eczar': GoogleFonts.eczarTextTheme,
        'El Messiri': GoogleFonts.elMessiriTextTheme,
        'Electrolize': GoogleFonts.electrolizeTextTheme,
        'Elsie': GoogleFonts.elsieTextTheme,
        'Elsie Swash Caps': GoogleFonts.elsieSwashCapsTextTheme,
        'Emblema One': GoogleFonts.emblemaOneTextTheme,
        'Emilys Candy': GoogleFonts.emilysCandyTextTheme,
        'Encode Sans': GoogleFonts.encodeSansTextTheme,
        'Encode Sans Condensed': GoogleFonts.encodeSansCondensedTextTheme,
        'Encode Sans Expanded': GoogleFonts.encodeSansExpandedTextTheme,
        'Encode Sans SC': GoogleFonts.encodeSansScTextTheme,
        'Encode Sans Semi Condensed':
            GoogleFonts.encodeSansSemiCondensedTextTheme,
        'Encode Sans Semi Expanded':
            GoogleFonts.encodeSansSemiExpandedTextTheme,
        'Engagement': GoogleFonts.engagementTextTheme,
        'Englebert': GoogleFonts.englebertTextTheme,
        'Enriqueta': GoogleFonts.enriquetaTextTheme,
        'Ephesis': GoogleFonts.ephesisTextTheme,
        'Epilogue': GoogleFonts.epilogueTextTheme,
        'Erica One': GoogleFonts.ericaOneTextTheme,
        'Esteban': GoogleFonts.estebanTextTheme,
        'Estonia': GoogleFonts.estoniaTextTheme,
        'Euphoria Script': GoogleFonts.euphoriaScriptTextTheme,
        'Ewert': GoogleFonts.ewertTextTheme,
        'Exo': GoogleFonts.exoTextTheme,
        'Exo 2': GoogleFonts.exo2TextTheme,
        'Expletus Sans': GoogleFonts.expletusSansTextTheme,
        'Explora': GoogleFonts.exploraTextTheme,
        'Fahkwang': GoogleFonts.fahkwangTextTheme,
        'Familjen Grotesk': GoogleFonts.familjenGroteskTextTheme,
        'Fanwood Text': GoogleFonts.fanwoodTextTextTheme,
        'Farro': GoogleFonts.farroTextTheme,
        'Farsan': GoogleFonts.farsanTextTheme,
        'Fascinate': GoogleFonts.fascinateTextTheme,
        'Fascinate Inline': GoogleFonts.fascinateInlineTextTheme,
        'Faster One': GoogleFonts.fasterOneTextTheme,
        'Fasthand': GoogleFonts.fasthandTextTheme,
        'Fauna One': GoogleFonts.faunaOneTextTheme,
        'Faustina': GoogleFonts.faustinaTextTheme,
        'Federant': GoogleFonts.federantTextTheme,
        'Federo': GoogleFonts.federoTextTheme,
        'Felipa': GoogleFonts.felipaTextTheme,
        'Fenix': GoogleFonts.fenixTextTheme,
        'Festive': GoogleFonts.festiveTextTheme,
        'Finger Paint': GoogleFonts.fingerPaintTextTheme,
        'Fira Code': GoogleFonts.firaCodeTextTheme,
        'Fira Mono': GoogleFonts.firaMonoTextTheme,
        'Fira Sans': GoogleFonts.firaSansTextTheme,
        'Fira Sans Condensed': GoogleFonts.firaSansCondensedTextTheme,
        'Fira Sans Extra Condensed':
            GoogleFonts.firaSansExtraCondensedTextTheme,
        'Fjalla One': GoogleFonts.fjallaOneTextTheme,
        'Fjord One': GoogleFonts.fjordOneTextTheme,
        'Flamenco': GoogleFonts.flamencoTextTheme,
        'Flavors': GoogleFonts.flavorsTextTheme,
        'Fleur De Leah': GoogleFonts.fleurDeLeahTextTheme,
        'Flow Block': GoogleFonts.flowBlockTextTheme,
        'Flow Circular': GoogleFonts.flowCircularTextTheme,
        'Flow Rounded': GoogleFonts.flowRoundedTextTheme,
        'Fondamento': GoogleFonts.fondamentoTextTheme,
        'Fontdiner Swanky': GoogleFonts.fontdinerSwankyTextTheme,
        'Forum': GoogleFonts.forumTextTheme,
        'Francois One': GoogleFonts.francoisOneTextTheme,
        'Frank Ruhl Libre': GoogleFonts.frankRuhlLibreTextTheme,
        'Fraunces': GoogleFonts.frauncesTextTheme,
        'Freckle Face': GoogleFonts.freckleFaceTextTheme,
        'Fredericka the Great': GoogleFonts.frederickaTheGreatTextTheme,
        'Fredoka': GoogleFonts.fredokaTextTheme,
        'Fredoka One': GoogleFonts.fredokaOneTextTheme,
        'Freehand': GoogleFonts.freehandTextTheme,
        'Fresca': GoogleFonts.frescaTextTheme,
        'Frijole': GoogleFonts.frijoleTextTheme,
        'Fruktur': GoogleFonts.frukturTextTheme,
        'Fugaz One': GoogleFonts.fugazOneTextTheme,
        'Fuggles': GoogleFonts.fugglesTextTheme,
        'Fuzzy Bubbles': GoogleFonts.fuzzyBubblesTextTheme,
        'GFS Didot': GoogleFonts.gfsDidotTextTheme,
        'GFS Neohellenic': GoogleFonts.gfsNeohellenicTextTheme,
        'Gabriela': GoogleFonts.gabrielaTextTheme,
        'Gaegu': GoogleFonts.gaeguTextTheme,
        'Gafata': GoogleFonts.gafataTextTheme,
        'Galada': GoogleFonts.galadaTextTheme,
        'Galdeano': GoogleFonts.galdeanoTextTheme,
        'Galindo': GoogleFonts.galindoTextTheme,
        'Gamja Flower': GoogleFonts.gamjaFlowerTextTheme,
        'Gayathri': GoogleFonts.gayathriTextTheme,
        'Gelasio': GoogleFonts.gelasioTextTheme,
        'Gemunu Libre': GoogleFonts.gemunuLibreTextTheme,
        'Genos': GoogleFonts.genosTextTheme,
        'Gentium Basic': GoogleFonts.gentiumBasicTextTheme,
        'Gentium Book Basic': GoogleFonts.gentiumBookBasicTextTheme,
        'Geo': GoogleFonts.geoTextTheme,
        'Georama': GoogleFonts.georamaTextTheme,
        'Geostar': GoogleFonts.geostarTextTheme,
        'Geostar Fill': GoogleFonts.geostarFillTextTheme,
        'Germania One': GoogleFonts.germaniaOneTextTheme,
        'Gideon Roman': GoogleFonts.gideonRomanTextTheme,
        'Gidugu': GoogleFonts.giduguTextTheme,
        'Gilda Display': GoogleFonts.gildaDisplayTextTheme,
        'Girassol': GoogleFonts.girassolTextTheme,
        'Give You Glory': GoogleFonts.giveYouGloryTextTheme,
        'Glass Antiqua': GoogleFonts.glassAntiquaTextTheme,
        'Glegoo': GoogleFonts.glegooTextTheme,
        'Gloria Hallelujah': GoogleFonts.gloriaHallelujahTextTheme,
        'Glory': GoogleFonts.gloryTextTheme,
        'Gluten': GoogleFonts.glutenTextTheme,
        'Goblin One': GoogleFonts.goblinOneTextTheme,
        'Gochi Hand': GoogleFonts.gochiHandTextTheme,
        'Goldman': GoogleFonts.goldmanTextTheme,
        'Gorditas': GoogleFonts.gorditasTextTheme,
        'Gothic A1': GoogleFonts.gothicA1TextTheme,
        'Gotu': GoogleFonts.gotuTextTheme,
        'Goudy Bookletter 1911': GoogleFonts.goudyBookletter1911TextTheme,
        'Gowun Batang': GoogleFonts.gowunBatangTextTheme,
        'Gowun Dodum': GoogleFonts.gowunDodumTextTheme,
        'Graduate': GoogleFonts.graduateTextTheme,
        'Grand Hotel': GoogleFonts.grandHotelTextTheme,
        'Grandstander': GoogleFonts.grandstanderTextTheme,
        'Grape Nuts': GoogleFonts.grapeNutsTextTheme,
        'Gravitas One': GoogleFonts.gravitasOneTextTheme,
        'Great Vibes': GoogleFonts.greatVibesTextTheme,
        'Grechen Fuemen': GoogleFonts.grechenFuemenTextTheme,
        'Grenze': GoogleFonts.grenzeTextTheme,
        'Grenze Gotisch': GoogleFonts.grenzeGotischTextTheme,
        'Grey Qo': GoogleFonts.greyQoTextTheme,
        'Griffy': GoogleFonts.griffyTextTheme,
        'Gruppo': GoogleFonts.gruppoTextTheme,
        'Gudea': GoogleFonts.gudeaTextTheme,
        'Gugi': GoogleFonts.gugiTextTheme,
        'Gupter': GoogleFonts.gupterTextTheme,
        'Gurajada': GoogleFonts.gurajadaTextTheme,
        'Gwendolyn': GoogleFonts.gwendolynTextTheme,
        'Habibi': GoogleFonts.habibiTextTheme,
        'Hachi Maru Pop': GoogleFonts.hachiMaruPopTextTheme,
        'Hahmlet': GoogleFonts.hahmletTextTheme,
        'Halant': GoogleFonts.halantTextTheme,
        'Hammersmith One': GoogleFonts.hammersmithOneTextTheme,
        'Hanalei': GoogleFonts.hanaleiTextTheme,
        'Hanalei Fill': GoogleFonts.hanaleiFillTextTheme,
        'Handlee': GoogleFonts.handleeTextTheme,
        'Hanuman': GoogleFonts.hanumanTextTheme,
        'Happy Monkey': GoogleFonts.happyMonkeyTextTheme,
        'Harmattan': GoogleFonts.harmattanTextTheme,
        'Headland One': GoogleFonts.headlandOneTextTheme,
        'Heebo': GoogleFonts.heeboTextTheme,
        'Henny Penny': GoogleFonts.hennyPennyTextTheme,
        'Hepta Slab': GoogleFonts.heptaSlabTextTheme,
        'Herr Von Muellerhoff': GoogleFonts.herrVonMuellerhoffTextTheme,
        'Hi Melody': GoogleFonts.hiMelodyTextTheme,
        'Hina Mincho': GoogleFonts.hinaMinchoTextTheme,
        'Hind': GoogleFonts.hindTextTheme,
        'Hind Guntur': GoogleFonts.hindGunturTextTheme,
        'Hind Madurai': GoogleFonts.hindMaduraiTextTheme,
        'Hind Siliguri': GoogleFonts.hindSiliguriTextTheme,
        'Hind Vadodara': GoogleFonts.hindVadodaraTextTheme,
        'Holtwood One SC': GoogleFonts.holtwoodOneScTextTheme,
        'Homemade Apple': GoogleFonts.homemadeAppleTextTheme,
        'Homenaje': GoogleFonts.homenajeTextTheme,
        'Hubballi': GoogleFonts.hubballiTextTheme,
        'Hurricane': GoogleFonts.hurricaneTextTheme,
        'IBM Plex Mono': GoogleFonts.ibmPlexMonoTextTheme,
        'IBM Plex Sans': GoogleFonts.ibmPlexSansTextTheme,
        'IBM Plex Sans Arabic': GoogleFonts.ibmPlexSansArabicTextTheme,
        'IBM Plex Sans Condensed': GoogleFonts.ibmPlexSansCondensedTextTheme,
        'IBM Plex Sans Devanagari': GoogleFonts.ibmPlexSansDevanagariTextTheme,
        'IBM Plex Sans Hebrew': GoogleFonts.ibmPlexSansHebrewTextTheme,
        'IBM Plex Sans KR': GoogleFonts.ibmPlexSansKrTextTheme,
        'IBM Plex Sans Thai': GoogleFonts.ibmPlexSansThaiTextTheme,
        'IBM Plex Sans Thai Looped': GoogleFonts.ibmPlexSansThaiLoopedTextTheme,
        'IBM Plex Serif': GoogleFonts.ibmPlexSerifTextTheme,
        'IM Fell DW Pica': GoogleFonts.imFellDwPicaTextTheme,
        'IM Fell DW Pica SC': GoogleFonts.imFellDwPicaScTextTheme,
        'IM Fell Double Pica': GoogleFonts.imFellDoublePicaTextTheme,
        'IM Fell Double Pica SC': GoogleFonts.imFellDoublePicaScTextTheme,
        'IM Fell English': GoogleFonts.imFellEnglishTextTheme,
        'IM Fell English SC': GoogleFonts.imFellEnglishScTextTheme,
        'IM Fell French Canon': GoogleFonts.imFellFrenchCanonTextTheme,
        'IM Fell French Canon SC': GoogleFonts.imFellFrenchCanonScTextTheme,
        'IM Fell Great Primer': GoogleFonts.imFellGreatPrimerTextTheme,
        'IM Fell Great Primer SC': GoogleFonts.imFellGreatPrimerScTextTheme,
        'Ibarra Real Nova': GoogleFonts.ibarraRealNovaTextTheme,
        'Iceberg': GoogleFonts.icebergTextTheme,
        'Iceland': GoogleFonts.icelandTextTheme,
        'Imbue': GoogleFonts.imbueTextTheme,
        'Imperial Script': GoogleFonts.imperialScriptTextTheme,
        'Imprima': GoogleFonts.imprimaTextTheme,
        'Inconsolata': GoogleFonts.inconsolataTextTheme,
        'Inder': GoogleFonts.inderTextTheme,
        'Indie Flower': GoogleFonts.indieFlowerTextTheme,
        'Ingrid Darling': GoogleFonts.ingridDarlingTextTheme,
        'Inika': GoogleFonts.inikaTextTheme,
        'Inknut Antiqua': GoogleFonts.inknutAntiquaTextTheme,
        'Inria Sans': GoogleFonts.inriaSansTextTheme,
        'Inria Serif': GoogleFonts.inriaSerifTextTheme,
        'Inspiration': GoogleFonts.inspirationTextTheme,
        'Inter': GoogleFonts.interTextTheme,
        'Irish Grover': GoogleFonts.irishGroverTextTheme,
        'Island Moments': GoogleFonts.islandMomentsTextTheme,
        'Istok Web': GoogleFonts.istokWebTextTheme,
        'Italiana': GoogleFonts.italianaTextTheme,
        'Italianno': GoogleFonts.italiannoTextTheme,
        'Itim': GoogleFonts.itimTextTheme,
        'Jacques Francois': GoogleFonts.jacquesFrancoisTextTheme,
        'Jacques Francois Shadow': GoogleFonts.jacquesFrancoisShadowTextTheme,
        'Jaldi': GoogleFonts.jaldiTextTheme,
        'JetBrains Mono': GoogleFonts.jetBrainsMonoTextTheme,
        'Jim Nightshade': GoogleFonts.jimNightshadeTextTheme,
        'Jockey One': GoogleFonts.jockeyOneTextTheme,
        'Jolly Lodger': GoogleFonts.jollyLodgerTextTheme,
        'Jomhuria': GoogleFonts.jomhuriaTextTheme,
        'Jomolhari': GoogleFonts.jomolhariTextTheme,
        'Josefin Sans': GoogleFonts.josefinSansTextTheme,
        'Josefin Slab': GoogleFonts.josefinSlabTextTheme,
        'Jost': GoogleFonts.jostTextTheme,
        'Joti One': GoogleFonts.jotiOneTextTheme,
        'Jua': GoogleFonts.juaTextTheme,
        'Judson': GoogleFonts.judsonTextTheme,
        'Julee': GoogleFonts.juleeTextTheme,
        'Julius Sans One': GoogleFonts.juliusSansOneTextTheme,
        'Junge': GoogleFonts.jungeTextTheme,
        'Jura': GoogleFonts.juraTextTheme,
        'Just Another Hand': GoogleFonts.justAnotherHandTextTheme,
        'Just Me Again Down Here': GoogleFonts.justMeAgainDownHereTextTheme,
        'K2D': GoogleFonts.k2dTextTheme,
        'Kadwa': GoogleFonts.kadwaTextTheme,
        'Kaisei Decol': GoogleFonts.kaiseiDecolTextTheme,
        'Kaisei HarunoUmi': GoogleFonts.kaiseiHarunoUmiTextTheme,
        'Kaisei Opti': GoogleFonts.kaiseiOptiTextTheme,
        'Kaisei Tokumin': GoogleFonts.kaiseiTokuminTextTheme,
        'Kalam': GoogleFonts.kalamTextTheme,
        'Kameron': GoogleFonts.kameronTextTheme,
        'Kanit': GoogleFonts.kanitTextTheme,
        'Kantumruy': GoogleFonts.kantumruyTextTheme,
        'Karantina': GoogleFonts.karantinaTextTheme,
        'Karla': GoogleFonts.karlaTextTheme,
        'Karma': GoogleFonts.karmaTextTheme,
        'Katibeh': GoogleFonts.katibehTextTheme,
        'Kaushan Script': GoogleFonts.kaushanScriptTextTheme,
        'Kavivanar': GoogleFonts.kavivanarTextTheme,
        'Kavoon': GoogleFonts.kavoonTextTheme,
        'Kdam Thmor': GoogleFonts.kdamThmorTextTheme,
        'Keania One': GoogleFonts.keaniaOneTextTheme,
        'Kelly Slab': GoogleFonts.kellySlabTextTheme,
        'Kenia': GoogleFonts.keniaTextTheme,
        'Khand': GoogleFonts.khandTextTheme,
        'Khmer': GoogleFonts.khmerTextTheme,
        'Khula': GoogleFonts.khulaTextTheme,
        'Kings': GoogleFonts.kingsTextTheme,
        'Kirang Haerang': GoogleFonts.kirangHaerangTextTheme,
        'Kite One': GoogleFonts.kiteOneTextTheme,
        'Kiwi Maru': GoogleFonts.kiwiMaruTextTheme,
        'Klee One': GoogleFonts.kleeOneTextTheme,
        'Knewave': GoogleFonts.knewaveTextTheme,
        'KoHo': GoogleFonts.koHoTextTheme,
        'Kodchasan': GoogleFonts.kodchasanTextTheme,
        'Koh Santepheap': GoogleFonts.kohSantepheapTextTheme,
        'Kolker Brush': GoogleFonts.kolkerBrushTextTheme,
        'Kosugi': GoogleFonts.kosugiTextTheme,
        'Kosugi Maru': GoogleFonts.kosugiMaruTextTheme,
        'Kotta One': GoogleFonts.kottaOneTextTheme,
        'Koulen': GoogleFonts.koulenTextTheme,
        'Kranky': GoogleFonts.krankyTextTheme,
        'Kreon': GoogleFonts.kreonTextTheme,
        'Kristi': GoogleFonts.kristiTextTheme,
        'Krona One': GoogleFonts.kronaOneTextTheme,
        'Krub': GoogleFonts.krubTextTheme,
        'Kufam': GoogleFonts.kufamTextTheme,
        'Kulim Park': GoogleFonts.kulimParkTextTheme,
        'Kumar One': GoogleFonts.kumarOneTextTheme,
        'Kumar One Outline': GoogleFonts.kumarOneOutlineTextTheme,
        'Kumbh Sans': GoogleFonts.kumbhSansTextTheme,
        'Kurale': GoogleFonts.kuraleTextTheme,
        'La Belle Aurore': GoogleFonts.laBelleAuroreTextTheme,
        'Lacquer': GoogleFonts.lacquerTextTheme,
        'Laila': GoogleFonts.lailaTextTheme,
        'Lakki Reddy': GoogleFonts.lakkiReddyTextTheme,
        'Lalezar': GoogleFonts.lalezarTextTheme,
        'Lancelot': GoogleFonts.lancelotTextTheme,
        'Langar': GoogleFonts.langarTextTheme,
        'Lateef': GoogleFonts.lateefTextTheme,
        'Lato': GoogleFonts.latoTextTheme,
        'Lavishly Yours': GoogleFonts.lavishlyYoursTextTheme,
        'League Gothic': GoogleFonts.leagueGothicTextTheme,
        'League Script': GoogleFonts.leagueScriptTextTheme,
        'League Spartan': GoogleFonts.leagueSpartanTextTheme,
        'Leckerli One': GoogleFonts.leckerliOneTextTheme,
        'Ledger': GoogleFonts.ledgerTextTheme,
        'Lekton': GoogleFonts.lektonTextTheme,
        'Lemon': GoogleFonts.lemonTextTheme,
        'Lemonada': GoogleFonts.lemonadaTextTheme,
        'Lexend': GoogleFonts.lexendTextTheme,
        'Lexend Deca': GoogleFonts.lexendDecaTextTheme,
        'Lexend Exa': GoogleFonts.lexendExaTextTheme,
        'Lexend Giga': GoogleFonts.lexendGigaTextTheme,
        'Lexend Mega': GoogleFonts.lexendMegaTextTheme,
        'Lexend Peta': GoogleFonts.lexendPetaTextTheme,
        'Lexend Tera': GoogleFonts.lexendTeraTextTheme,
        'Lexend Zetta': GoogleFonts.lexendZettaTextTheme,
        'Libre Barcode 128': GoogleFonts.libreBarcode128TextTheme,
        'Libre Barcode 128 Text': GoogleFonts.libreBarcode128TextTextTheme,
        'Libre Barcode 39': GoogleFonts.libreBarcode39TextTheme,
        'Libre Barcode 39 Extended':
            GoogleFonts.libreBarcode39ExtendedTextTheme,
        'Libre Barcode 39 Extended Text':
            GoogleFonts.libreBarcode39ExtendedTextTextTheme,
        'Libre Barcode 39 Text': GoogleFonts.libreBarcode39TextTextTheme,
        'Libre Barcode EAN13 Text': GoogleFonts.libreBarcodeEan13TextTextTheme,
        'Libre Baskerville': GoogleFonts.libreBaskervilleTextTheme,
        'Libre Bodoni': GoogleFonts.libreBodoniTextTheme,
        'Libre Caslon Display': GoogleFonts.libreCaslonDisplayTextTheme,
        'Libre Caslon Text': GoogleFonts.libreCaslonTextTextTheme,
        'Libre Franklin': GoogleFonts.libreFranklinTextTheme,
        'Licorice': GoogleFonts.licoriceTextTheme,
        'Life Savers': GoogleFonts.lifeSaversTextTheme,
        'Lilita One': GoogleFonts.lilitaOneTextTheme,
        'Lily Script One': GoogleFonts.lilyScriptOneTextTheme,
        'Limelight': GoogleFonts.limelightTextTheme,
        'Linden Hill': GoogleFonts.lindenHillTextTheme,
        'Literata': GoogleFonts.literataTextTheme,
        'Liu Jian Mao Cao': GoogleFonts.liuJianMaoCaoTextTheme,
        'Livvic': GoogleFonts.livvicTextTheme,
        'Lobster': GoogleFonts.lobsterTextTheme,
        'Lobster Two': GoogleFonts.lobsterTwoTextTheme,
        'Londrina Outline': GoogleFonts.londrinaOutlineTextTheme,
        'Londrina Shadow': GoogleFonts.londrinaShadowTextTheme,
        'Londrina Sketch': GoogleFonts.londrinaSketchTextTheme,
        'Londrina Solid': GoogleFonts.londrinaSolidTextTheme,
        'Long Cang': GoogleFonts.longCangTextTheme,
        'Lora': GoogleFonts.loraTextTheme,
        'Love Light': GoogleFonts.loveLightTextTheme,
        'Love Ya Like A Sister': GoogleFonts.loveYaLikeASisterTextTheme,
        'Loved by the King': GoogleFonts.lovedByTheKingTextTheme,
        'Lovers Quarrel': GoogleFonts.loversQuarrelTextTheme,
        'Luckiest Guy': GoogleFonts.luckiestGuyTextTheme,
        'Lusitana': GoogleFonts.lusitanaTextTheme,
        'Lustria': GoogleFonts.lustriaTextTheme,
        'Luxurious Roman': GoogleFonts.luxuriousRomanTextTheme,
        'Luxurious Script': GoogleFonts.luxuriousScriptTextTheme,
        'M PLUS 1': GoogleFonts.mPlus1TextTheme,
        'M PLUS 1 Code': GoogleFonts.mPlus1CodeTextTheme,
        'M PLUS 1p': GoogleFonts.mPlus1pTextTheme,
        'M PLUS 2': GoogleFonts.mPlus2TextTheme,
        'M PLUS Code Latin': GoogleFonts.mPlusCodeLatinTextTheme,
        'M PLUS Rounded 1c': GoogleFonts.mPlusRounded1cTextTheme,
        'Ma Shan Zheng': GoogleFonts.maShanZhengTextTheme,
        'Macondo': GoogleFonts.macondoTextTheme,
        'Macondo Swash Caps': GoogleFonts.macondoSwashCapsTextTheme,
        'Mada': GoogleFonts.madaTextTheme,
        'Magra': GoogleFonts.magraTextTheme,
        'Maiden Orange': GoogleFonts.maidenOrangeTextTheme,
        'Maitree': GoogleFonts.maitreeTextTheme,
        'Major Mono Display': GoogleFonts.majorMonoDisplayTextTheme,
        'Mako': GoogleFonts.makoTextTheme,
        'Mali': GoogleFonts.maliTextTheme,
        'Mallanna': GoogleFonts.mallannaTextTheme,
        'Mandali': GoogleFonts.mandaliTextTheme,
        'Manjari': GoogleFonts.manjariTextTheme,
        'Manrope': GoogleFonts.manropeTextTheme,
        'Mansalva': GoogleFonts.mansalvaTextTheme,
        'Manuale': GoogleFonts.manualeTextTheme,
        'Marcellus': GoogleFonts.marcellusTextTheme,
        'Marcellus SC': GoogleFonts.marcellusScTextTheme,
        'Marck Script': GoogleFonts.marckScriptTextTheme,
        'Margarine': GoogleFonts.margarineTextTheme,
        'Markazi Text': GoogleFonts.markaziTextTextTheme,
        'Marko One': GoogleFonts.markoOneTextTheme,
        'Marmelad': GoogleFonts.marmeladTextTheme,
        'Martel': GoogleFonts.martelTextTheme,
        'Martel Sans': GoogleFonts.martelSansTextTheme,
        'Marvel': GoogleFonts.marvelTextTheme,
        'Mate': GoogleFonts.mateTextTheme,
        'Mate SC': GoogleFonts.mateScTextTheme,
        'Maven Pro': GoogleFonts.mavenProTextTheme,
        'McLaren': GoogleFonts.mcLarenTextTheme,
        'Mea Culpa': GoogleFonts.meaCulpaTextTheme,
        'Meddon': GoogleFonts.meddonTextTheme,
        'MedievalSharp': GoogleFonts.medievalSharpTextTheme,
        'Medula One': GoogleFonts.medulaOneTextTheme,
        'Meera Inimai': GoogleFonts.meeraInimaiTextTheme,
        'Megrim': GoogleFonts.megrimTextTheme,
        'Meie Script': GoogleFonts.meieScriptTextTheme,
        'Meow Script': GoogleFonts.meowScriptTextTheme,
        'Merienda': GoogleFonts.meriendaTextTheme,
        'Merienda One': GoogleFonts.meriendaOneTextTheme,
        'Merriweather': GoogleFonts.merriweatherTextTheme,
        'Merriweather Sans': GoogleFonts.merriweatherSansTextTheme,
        'Metal': GoogleFonts.metalTextTheme,
        'Metal Mania': GoogleFonts.metalManiaTextTheme,
        'Metamorphous': GoogleFonts.metamorphousTextTheme,
        'Metrophobic': GoogleFonts.metrophobicTextTheme,
        'Michroma': GoogleFonts.michromaTextTheme,
        'Milonga': GoogleFonts.milongaTextTheme,
        'Miltonian': GoogleFonts.miltonianTextTheme,
        'Miltonian Tattoo': GoogleFonts.miltonianTattooTextTheme,
        'Mina': GoogleFonts.minaTextTheme,
        'Miniver': GoogleFonts.miniverTextTheme,
        'Miriam Libre': GoogleFonts.miriamLibreTextTheme,
        'Mirza': GoogleFonts.mirzaTextTheme,
        'Miss Fajardose': GoogleFonts.missFajardoseTextTheme,
        'Mitr': GoogleFonts.mitrTextTheme,
        'Mochiy Pop One': GoogleFonts.mochiyPopOneTextTheme,
        'Mochiy Pop P One': GoogleFonts.mochiyPopPOneTextTheme,
        'Modak': GoogleFonts.modakTextTheme,
        'Modern Antiqua': GoogleFonts.modernAntiquaTextTheme,
        'Mogra': GoogleFonts.mograTextTheme,
        'Mohave': GoogleFonts.mohaveTextTheme,
        'Molengo': GoogleFonts.molengoTextTheme,
        'Molle': GoogleFonts.molleTextTheme,
        'Monda': GoogleFonts.mondaTextTheme,
        'Monofett': GoogleFonts.monofettTextTheme,
        'Monoton': GoogleFonts.monotonTextTheme,
        'Monsieur La Doulaise': GoogleFonts.monsieurLaDoulaiseTextTheme,
        'Montaga': GoogleFonts.montagaTextTheme,
        'Montagu Slab': GoogleFonts.montaguSlabTextTheme,
        'MonteCarlo': GoogleFonts.monteCarloTextTheme,
        'Montez': GoogleFonts.montezTextTheme,
        'Montserrat': GoogleFonts.montserratTextTheme,
        'Montserrat Alternates': GoogleFonts.montserratAlternatesTextTheme,
        'Montserrat Subrayada': GoogleFonts.montserratSubrayadaTextTheme,
        'Moo Lah Lah': GoogleFonts.mooLahLahTextTheme,
        'Moon Dance': GoogleFonts.moonDanceTextTheme,
        'Moul': GoogleFonts.moulTextTheme,
        'Moulpali': GoogleFonts.moulpaliTextTheme,
        'Mountains of Christmas': GoogleFonts.mountainsOfChristmasTextTheme,
        'Mouse Memoirs': GoogleFonts.mouseMemoirsTextTheme,
        'Mr Bedfort': GoogleFonts.mrBedfortTextTheme,
        'Mr Dafoe': GoogleFonts.mrDafoeTextTheme,
        'Mr De Haviland': GoogleFonts.mrDeHavilandTextTheme,
        'Mrs Saint Delafield': GoogleFonts.mrsSaintDelafieldTextTheme,
        'Mrs Sheppards': GoogleFonts.mrsSheppardsTextTheme,
        'Ms Madi': GoogleFonts.msMadiTextTheme,
        'Mukta': GoogleFonts.muktaTextTheme,
        'Mukta Mahee': GoogleFonts.muktaMaheeTextTheme,
        'Mukta Malar': GoogleFonts.muktaMalarTextTheme,
        'Mukta Vaani': GoogleFonts.muktaVaaniTextTheme,
        'Mulish': GoogleFonts.mulishTextTheme,
        'Murecho': GoogleFonts.murechoTextTheme,
        'MuseoModerno': GoogleFonts.museoModernoTextTheme,
        'My Soul': GoogleFonts.mySoulTextTheme,
        'Mystery Quest': GoogleFonts.mysteryQuestTextTheme,
        'NTR': GoogleFonts.ntrTextTheme,
        'Nanum Brush Script': GoogleFonts.nanumBrushScriptTextTheme,
        'Nanum Gothic': GoogleFonts.nanumGothicTextTheme,
        'Nanum Gothic Coding': GoogleFonts.nanumGothicCodingTextTheme,
        'Nanum Myeongjo': GoogleFonts.nanumMyeongjoTextTheme,
        'Nanum Pen Script': GoogleFonts.nanumPenScriptTextTheme,
        'Neonderthaw': GoogleFonts.neonderthawTextTheme,
        'Nerko One': GoogleFonts.nerkoOneTextTheme,
        'Neucha': GoogleFonts.neuchaTextTheme,
        'Neuton': GoogleFonts.neutonTextTheme,
        'New Rocker': GoogleFonts.newRockerTextTheme,
        'New Tegomin': GoogleFonts.newTegominTextTheme,
        'News Cycle': GoogleFonts.newsCycleTextTheme,
        'Newsreader': GoogleFonts.newsreaderTextTheme,
        'Niconne': GoogleFonts.niconneTextTheme,
        'Niramit': GoogleFonts.niramitTextTheme,
        'Nixie One': GoogleFonts.nixieOneTextTheme,
        'Nobile': GoogleFonts.nobileTextTheme,
        'Nokora': GoogleFonts.nokoraTextTheme,
        'Norican': GoogleFonts.noricanTextTheme,
        'Nosifer': GoogleFonts.nosiferTextTheme,
        'Notable': GoogleFonts.notableTextTheme,
        'Nothing You Could Do': GoogleFonts.nothingYouCouldDoTextTheme,
        'Noticia Text': GoogleFonts.noticiaTextTextTheme,
        'Noto Emoji': GoogleFonts.notoEmojiTextTheme,
        'Noto Kufi Arabic': GoogleFonts.notoKufiArabicTextTheme,
        'Noto Music': GoogleFonts.notoMusicTextTheme,
        'Noto Naskh Arabic': GoogleFonts.notoNaskhArabicTextTheme,
        'Noto Nastaliq Urdu': GoogleFonts.notoNastaliqUrduTextTheme,
        'Noto Rashi Hebrew': GoogleFonts.notoRashiHebrewTextTheme,
        'Noto Sans': GoogleFonts.notoSansTextTheme,
        'Noto Sans Adlam': GoogleFonts.notoSansAdlamTextTheme,
        'Noto Sans Adlam Unjoined': GoogleFonts.notoSansAdlamUnjoinedTextTheme,
        'Noto Sans Anatolian Hieroglyphs':
            GoogleFonts.notoSansAnatolianHieroglyphsTextTheme,
        'Noto Sans Arabic': GoogleFonts.notoSansArabicTextTheme,
        'Noto Sans Armenian': GoogleFonts.notoSansArmenianTextTheme,
        'Noto Sans Avestan': GoogleFonts.notoSansAvestanTextTheme,
        'Noto Sans Balinese': GoogleFonts.notoSansBalineseTextTheme,
        'Noto Sans Bamum': GoogleFonts.notoSansBamumTextTheme,
        'Noto Sans Bassa Vah': GoogleFonts.notoSansBassaVahTextTheme,
        'Noto Sans Batak': GoogleFonts.notoSansBatakTextTheme,
        'Noto Sans Bengali': GoogleFonts.notoSansBengaliTextTheme,
        'Noto Sans Bhaiksuki': GoogleFonts.notoSansBhaiksukiTextTheme,
        'Noto Sans Brahmi': GoogleFonts.notoSansBrahmiTextTheme,
        'Noto Sans Buginese': GoogleFonts.notoSansBugineseTextTheme,
        'Noto Sans Buhid': GoogleFonts.notoSansBuhidTextTheme,
        'Noto Sans Canadian Aboriginal':
            GoogleFonts.notoSansCanadianAboriginalTextTheme,
        'Noto Sans Carian': GoogleFonts.notoSansCarianTextTheme,
        'Noto Sans Caucasian Albanian':
            GoogleFonts.notoSansCaucasianAlbanianTextTheme,
        'Noto Sans Chakma': GoogleFonts.notoSansChakmaTextTheme,
        'Noto Sans Cham': GoogleFonts.notoSansChamTextTheme,
        'Noto Sans Cherokee': GoogleFonts.notoSansCherokeeTextTheme,
        'Noto Sans Coptic': GoogleFonts.notoSansCopticTextTheme,
        'Noto Sans Cuneiform': GoogleFonts.notoSansCuneiformTextTheme,
        'Noto Sans Cypriot': GoogleFonts.notoSansCypriotTextTheme,
        'Noto Sans Deseret': GoogleFonts.notoSansDeseretTextTheme,
        'Noto Sans Devanagari': GoogleFonts.notoSansDevanagariTextTheme,
        'Noto Sans Display': GoogleFonts.notoSansDisplayTextTheme,
        'Noto Sans Duployan': GoogleFonts.notoSansDuployanTextTheme,
        'Noto Sans Egyptian Hieroglyphs':
            GoogleFonts.notoSansEgyptianHieroglyphsTextTheme,
        'Noto Sans Elbasan': GoogleFonts.notoSansElbasanTextTheme,
        'Noto Sans Elymaic': GoogleFonts.notoSansElymaicTextTheme,
        'Noto Sans Georgian': GoogleFonts.notoSansGeorgianTextTheme,
        'Noto Sans Glagolitic': GoogleFonts.notoSansGlagoliticTextTheme,
        'Noto Sans Gothic': GoogleFonts.notoSansGothicTextTheme,
        'Noto Sans Grantha': GoogleFonts.notoSansGranthaTextTheme,
        'Noto Sans Gujarati': GoogleFonts.notoSansGujaratiTextTheme,
        'Noto Sans Gunjala Gondi': GoogleFonts.notoSansGunjalaGondiTextTheme,
        'Noto Sans Gurmukhi': GoogleFonts.notoSansGurmukhiTextTheme,
        'Noto Sans Hanifi Rohingya':
            GoogleFonts.notoSansHanifiRohingyaTextTheme,
        'Noto Sans Hanunoo': GoogleFonts.notoSansHanunooTextTheme,
        'Noto Sans Hatran': GoogleFonts.notoSansHatranTextTheme,
        'Noto Sans Hebrew': GoogleFonts.notoSansHebrewTextTheme,
        'Noto Sans Imperial Aramaic':
            GoogleFonts.notoSansImperialAramaicTextTheme,
        'Noto Sans Indic Siyaq Numbers':
            GoogleFonts.notoSansIndicSiyaqNumbersTextTheme,
        'Noto Sans Inscriptional Pahlavi':
            GoogleFonts.notoSansInscriptionalPahlaviTextTheme,
        'Noto Sans Inscriptional Parthian':
            GoogleFonts.notoSansInscriptionalParthianTextTheme,
        'Noto Sans Javanese': GoogleFonts.notoSansJavaneseTextTheme,
        'Noto Sans Kaithi': GoogleFonts.notoSansKaithiTextTheme,
        'Noto Sans Kannada': GoogleFonts.notoSansKannadaTextTheme,
        'Noto Sans Kayah Li': GoogleFonts.notoSansKayahLiTextTheme,
        'Noto Sans Kharoshthi': GoogleFonts.notoSansKharoshthiTextTheme,
        'Noto Sans Khmer': GoogleFonts.notoSansKhmerTextTheme,
        'Noto Sans Khojki': GoogleFonts.notoSansKhojkiTextTheme,
        'Noto Sans Khudawadi': GoogleFonts.notoSansKhudawadiTextTheme,
        'Noto Sans Lao': GoogleFonts.notoSansLaoTextTheme,
        'Noto Sans Lepcha': GoogleFonts.notoSansLepchaTextTheme,
        'Noto Sans Limbu': GoogleFonts.notoSansLimbuTextTheme,
        'Noto Sans Linear A': GoogleFonts.notoSansLinearATextTheme,
        'Noto Sans Linear B': GoogleFonts.notoSansLinearBTextTheme,
        'Noto Sans Lisu': GoogleFonts.notoSansLisuTextTheme,
        'Noto Sans Lycian': GoogleFonts.notoSansLycianTextTheme,
        'Noto Sans Lydian': GoogleFonts.notoSansLydianTextTheme,
        'Noto Sans Mahajani': GoogleFonts.notoSansMahajaniTextTheme,
        'Noto Sans Malayalam': GoogleFonts.notoSansMalayalamTextTheme,
        'Noto Sans Mandaic': GoogleFonts.notoSansMandaicTextTheme,
        'Noto Sans Manichaean': GoogleFonts.notoSansManichaeanTextTheme,
        'Noto Sans Marchen': GoogleFonts.notoSansMarchenTextTheme,
        'Noto Sans Masaram Gondi': GoogleFonts.notoSansMasaramGondiTextTheme,
        'Noto Sans Math': GoogleFonts.notoSansMathTextTheme,
        'Noto Sans Mayan Numerals': GoogleFonts.notoSansMayanNumeralsTextTheme,
        'Noto Sans Medefaidrin': GoogleFonts.notoSansMedefaidrinTextTheme,
        'Noto Sans Meetei Mayek': GoogleFonts.notoSansMeeteiMayekTextTheme,
        'Noto Sans Meroitic': GoogleFonts.notoSansMeroiticTextTheme,
        'Noto Sans Miao': GoogleFonts.notoSansMiaoTextTheme,
        'Noto Sans Modi': GoogleFonts.notoSansModiTextTheme,
        'Noto Sans Mongolian': GoogleFonts.notoSansMongolianTextTheme,
        'Noto Sans Mono': GoogleFonts.notoSansMonoTextTheme,
        'Noto Sans Mro': GoogleFonts.notoSansMroTextTheme,
        'Noto Sans Multani': GoogleFonts.notoSansMultaniTextTheme,
        'Noto Sans Myanmar': GoogleFonts.notoSansMyanmarTextTheme,
        'Noto Sans N Ko': GoogleFonts.notoSansNKoTextTheme,
        'Noto Sans Nabataean': GoogleFonts.notoSansNabataeanTextTheme,
        'Noto Sans New Tai Lue': GoogleFonts.notoSansNewTaiLueTextTheme,
        'Noto Sans Newa': GoogleFonts.notoSansNewaTextTheme,
        'Noto Sans Nushu': GoogleFonts.notoSansNushuTextTheme,
        'Noto Sans Ogham': GoogleFonts.notoSansOghamTextTheme,
        'Noto Sans Ol Chiki': GoogleFonts.notoSansOlChikiTextTheme,
        'Noto Sans Old Hungarian': GoogleFonts.notoSansOldHungarianTextTheme,
        'Noto Sans Old Italic': GoogleFonts.notoSansOldItalicTextTheme,
        'Noto Sans Old North Arabian':
            GoogleFonts.notoSansOldNorthArabianTextTheme,
        'Noto Sans Old Permic': GoogleFonts.notoSansOldPermicTextTheme,
        'Noto Sans Old Persian': GoogleFonts.notoSansOldPersianTextTheme,
        'Noto Sans Old Sogdian': GoogleFonts.notoSansOldSogdianTextTheme,
        'Noto Sans Old South Arabian':
            GoogleFonts.notoSansOldSouthArabianTextTheme,
        'Noto Sans Old Turkic': GoogleFonts.notoSansOldTurkicTextTheme,
        'Noto Sans Oriya': GoogleFonts.notoSansOriyaTextTheme,
        'Noto Sans Osage': GoogleFonts.notoSansOsageTextTheme,
        'Noto Sans Osmanya': GoogleFonts.notoSansOsmanyaTextTheme,
        'Noto Sans Pahawh Hmong': GoogleFonts.notoSansPahawhHmongTextTheme,
        'Noto Sans Palmyrene': GoogleFonts.notoSansPalmyreneTextTheme,
        'Noto Sans Pau Cin Hau': GoogleFonts.notoSansPauCinHauTextTheme,
        'Noto Sans Phags Pa': GoogleFonts.notoSansPhagsPaTextTheme,
        'Noto Sans Phoenician': GoogleFonts.notoSansPhoenicianTextTheme,
        'Noto Sans Psalter Pahlavi':
            GoogleFonts.notoSansPsalterPahlaviTextTheme,
        'Noto Sans Rejang': GoogleFonts.notoSansRejangTextTheme,
        'Noto Sans Runic': GoogleFonts.notoSansRunicTextTheme,
        'Noto Sans Samaritan': GoogleFonts.notoSansSamaritanTextTheme,
        'Noto Sans Saurashtra': GoogleFonts.notoSansSaurashtraTextTheme,
        'Noto Sans Sharada': GoogleFonts.notoSansSharadaTextTheme,
        'Noto Sans Shavian': GoogleFonts.notoSansShavianTextTheme,
        'Noto Sans Siddham': GoogleFonts.notoSansSiddhamTextTheme,
        'Noto Sans Sinhala': GoogleFonts.notoSansSinhalaTextTheme,
        'Noto Sans Sogdian': GoogleFonts.notoSansSogdianTextTheme,
        'Noto Sans Sora Sompeng': GoogleFonts.notoSansSoraSompengTextTheme,
        'Noto Sans Soyombo': GoogleFonts.notoSansSoyomboTextTheme,
        'Noto Sans Sundanese': GoogleFonts.notoSansSundaneseTextTheme,
        'Noto Sans Syloti Nagri': GoogleFonts.notoSansSylotiNagriTextTheme,
        'Noto Sans Symbols': GoogleFonts.notoSansSymbolsTextTheme,
        'Noto Sans Symbols 2': GoogleFonts.notoSansSymbols2TextTheme,
        'Noto Sans Syriac': GoogleFonts.notoSansSyriacTextTheme,
        'Noto Sans Tagalog': GoogleFonts.notoSansTagalogTextTheme,
        'Noto Sans Tagbanwa': GoogleFonts.notoSansTagbanwaTextTheme,
        'Noto Sans Tai Le': GoogleFonts.notoSansTaiLeTextTheme,
        'Noto Sans Tai Tham': GoogleFonts.notoSansTaiThamTextTheme,
        'Noto Sans Tai Viet': GoogleFonts.notoSansTaiVietTextTheme,
        'Noto Sans Takri': GoogleFonts.notoSansTakriTextTheme,
        'Noto Sans Tamil': GoogleFonts.notoSansTamilTextTheme,
        'Noto Sans Tamil Supplement':
            GoogleFonts.notoSansTamilSupplementTextTheme,
        'Noto Sans Telugu': GoogleFonts.notoSansTeluguTextTheme,
        'Noto Sans Thaana': GoogleFonts.notoSansThaanaTextTheme,
        'Noto Sans Thai': GoogleFonts.notoSansThaiTextTheme,
        'Noto Sans Thai Looped': GoogleFonts.notoSansThaiLoopedTextTheme,
        'Noto Sans Tifinagh': GoogleFonts.notoSansTifinaghTextTheme,
        'Noto Sans Tirhuta': GoogleFonts.notoSansTirhutaTextTheme,
        'Noto Sans Ugaritic': GoogleFonts.notoSansUgariticTextTheme,
        'Noto Sans Vai': GoogleFonts.notoSansVaiTextTheme,
        'Noto Sans Wancho': GoogleFonts.notoSansWanchoTextTheme,
        'Noto Sans Warang Citi': GoogleFonts.notoSansWarangCitiTextTheme,
        'Noto Sans Yi': GoogleFonts.notoSansYiTextTheme,
        'Noto Sans Zanabazar Square':
            GoogleFonts.notoSansZanabazarSquareTextTheme,
        'Noto Serif': GoogleFonts.notoSerifTextTheme,
        'Noto Serif Ahom': GoogleFonts.notoSerifAhomTextTheme,
        'Noto Serif Armenian': GoogleFonts.notoSerifArmenianTextTheme,
        'Noto Serif Balinese': GoogleFonts.notoSerifBalineseTextTheme,
        'Noto Serif Bengali': GoogleFonts.notoSerifBengaliTextTheme,
        'Noto Serif Devanagari': GoogleFonts.notoSerifDevanagariTextTheme,
        'Noto Serif Display': GoogleFonts.notoSerifDisplayTextTheme,
        'Noto Serif Dogra': GoogleFonts.notoSerifDograTextTheme,
        'Noto Serif Ethiopic': GoogleFonts.notoSerifEthiopicTextTheme,
        'Noto Serif Georgian': GoogleFonts.notoSerifGeorgianTextTheme,
        'Noto Serif Grantha': GoogleFonts.notoSerifGranthaTextTheme,
        'Noto Serif Gujarati': GoogleFonts.notoSerifGujaratiTextTheme,
        'Noto Serif Gurmukhi': GoogleFonts.notoSerifGurmukhiTextTheme,
        'Noto Serif Hebrew': GoogleFonts.notoSerifHebrewTextTheme,
        'Noto Serif Kannada': GoogleFonts.notoSerifKannadaTextTheme,
        'Noto Serif Khmer': GoogleFonts.notoSerifKhmerTextTheme,
        'Noto Serif Lao': GoogleFonts.notoSerifLaoTextTheme,
        'Noto Serif Malayalam': GoogleFonts.notoSerifMalayalamTextTheme,
        'Noto Serif Myanmar': GoogleFonts.notoSerifMyanmarTextTheme,
        'Noto Serif Nyiakeng Puachue Hmong':
            GoogleFonts.notoSerifNyiakengPuachueHmongTextTheme,
        'Noto Serif Sinhala': GoogleFonts.notoSerifSinhalaTextTheme,
        'Noto Serif Tamil': GoogleFonts.notoSerifTamilTextTheme,
        'Noto Serif Tangut': GoogleFonts.notoSerifTangutTextTheme,
        'Noto Serif Telugu': GoogleFonts.notoSerifTeluguTextTheme,
        'Noto Serif Thai': GoogleFonts.notoSerifThaiTextTheme,
        'Noto Serif Tibetan': GoogleFonts.notoSerifTibetanTextTheme,
        'Noto Serif Yezidi': GoogleFonts.notoSerifYezidiTextTheme,
        'Noto Traditional Nushu': GoogleFonts.notoTraditionalNushuTextTheme,
        'Nova Cut': GoogleFonts.novaCutTextTheme,
        'Nova Flat': GoogleFonts.novaFlatTextTheme,
        'Nova Mono': GoogleFonts.novaMonoTextTheme,
        'Nova Oval': GoogleFonts.novaOvalTextTheme,
        'Nova Round': GoogleFonts.novaRoundTextTheme,
        'Nova Script': GoogleFonts.novaScriptTextTheme,
        'Nova Slim': GoogleFonts.novaSlimTextTheme,
        'Nova Square': GoogleFonts.novaSquareTextTheme,
        'Numans': GoogleFonts.numansTextTheme,
        'Nunito': GoogleFonts.nunitoTextTheme,
        'Nunito Sans': GoogleFonts.nunitoSansTextTheme,
        'Odibee Sans': GoogleFonts.odibeeSansTextTheme,
        'Odor Mean Chey': GoogleFonts.odorMeanCheyTextTheme,
        'Offside': GoogleFonts.offsideTextTheme,
        'Oi': GoogleFonts.oiTextTheme,
        'Old Standard TT': GoogleFonts.oldStandardTtTextTheme,
        'Oldenburg': GoogleFonts.oldenburgTextTheme,
        'Ole': GoogleFonts.oleTextTheme,
        'Oleo Script': GoogleFonts.oleoScriptTextTheme,
        'Oleo Script Swash Caps': GoogleFonts.oleoScriptSwashCapsTextTheme,
        'Oooh Baby': GoogleFonts.ooohBabyTextTheme,
        'Open Sans': GoogleFonts.openSansTextTheme,
        'Open Sans Condensed': GoogleFonts.openSansCondensedTextTheme,
        'Oranienbaum': GoogleFonts.oranienbaumTextTheme,
        'Orbitron': GoogleFonts.orbitronTextTheme,
        'Oregano': GoogleFonts.oreganoTextTheme,
        'Orelega One': GoogleFonts.orelegaOneTextTheme,
        'Orienta': GoogleFonts.orientaTextTheme,
        'Original Surfer': GoogleFonts.originalSurferTextTheme,
        'Oswald': GoogleFonts.oswaldTextTheme,
        'Otomanopee One': GoogleFonts.otomanopeeOneTextTheme,
        'Outfit': GoogleFonts.outfitTextTheme,
        'Over the Rainbow': GoogleFonts.overTheRainbowTextTheme,
        'Overlock': GoogleFonts.overlockTextTheme,
        'Overlock SC': GoogleFonts.overlockScTextTheme,
        'Overpass': GoogleFonts.overpassTextTheme,
        'Overpass Mono': GoogleFonts.overpassMonoTextTheme,
        'Ovo': GoogleFonts.ovoTextTheme,
        'Oxanium': GoogleFonts.oxaniumTextTheme,
        'Oxygen': GoogleFonts.oxygenTextTheme,
        'Oxygen Mono': GoogleFonts.oxygenMonoTextTheme,
        'PT Mono': GoogleFonts.ptMonoTextTheme,
        'PT Sans': GoogleFonts.ptSansTextTheme,
        'PT Sans Caption': GoogleFonts.ptSansCaptionTextTheme,
        'PT Sans Narrow': GoogleFonts.ptSansNarrowTextTheme,
        'PT Serif': GoogleFonts.ptSerifTextTheme,
        'PT Serif Caption': GoogleFonts.ptSerifCaptionTextTheme,
        'Pacifico': GoogleFonts.pacificoTextTheme,
        'Padauk': GoogleFonts.padaukTextTheme,
        'Palanquin': GoogleFonts.palanquinTextTheme,
        'Palanquin Dark': GoogleFonts.palanquinDarkTextTheme,
        'Palette Mosaic': GoogleFonts.paletteMosaicTextTheme,
        'Pangolin': GoogleFonts.pangolinTextTheme,
        'Paprika': GoogleFonts.paprikaTextTheme,
        'Parisienne': GoogleFonts.parisienneTextTheme,
        'Passero One': GoogleFonts.passeroOneTextTheme,
        'Passion One': GoogleFonts.passionOneTextTheme,
        'Passions Conflict': GoogleFonts.passionsConflictTextTheme,
        'Pathway Gothic One': GoogleFonts.pathwayGothicOneTextTheme,
        'Patrick Hand': GoogleFonts.patrickHandTextTheme,
        'Patrick Hand SC': GoogleFonts.patrickHandScTextTheme,
        'Pattaya': GoogleFonts.pattayaTextTheme,
        'Patua One': GoogleFonts.patuaOneTextTheme,
        'Pavanam': GoogleFonts.pavanamTextTheme,
        'Paytone One': GoogleFonts.paytoneOneTextTheme,
        'Peddana': GoogleFonts.peddanaTextTheme,
        'Peralta': GoogleFonts.peraltaTextTheme,
        'Permanent Marker': GoogleFonts.permanentMarkerTextTheme,
        'Petemoss': GoogleFonts.petemossTextTheme,
        'Petit Formal Script': GoogleFonts.petitFormalScriptTextTheme,
        'Petrona': GoogleFonts.petronaTextTheme,
        'Philosopher': GoogleFonts.philosopherTextTheme,
        'Piazzolla': GoogleFonts.piazzollaTextTheme,
        'Piedra': GoogleFonts.piedraTextTheme,
        'Pinyon Script': GoogleFonts.pinyonScriptTextTheme,
        'Pirata One': GoogleFonts.pirataOneTextTheme,
        'Plaster': GoogleFonts.plasterTextTheme,
        'Play': GoogleFonts.playTextTheme,
        'Playball': GoogleFonts.playballTextTheme,
        'Playfair Display': GoogleFonts.playfairDisplayTextTheme,
        'Playfair Display SC': GoogleFonts.playfairDisplayScTextTheme,
        'Plus Jakarta Sans': GoogleFonts.plusJakartaSansTextTheme,
        'Podkova': GoogleFonts.podkovaTextTheme,
        'Poiret One': GoogleFonts.poiretOneTextTheme,
        'Poller One': GoogleFonts.pollerOneTextTheme,
        'Poly': GoogleFonts.polyTextTheme,
        'Pompiere': GoogleFonts.pompiereTextTheme,
        'Pontano Sans': GoogleFonts.pontanoSansTextTheme,
        'Poor Story': GoogleFonts.poorStoryTextTheme,
        'Poppins': GoogleFonts.poppinsTextTheme,
        'Port Lligat Sans': GoogleFonts.portLligatSansTextTheme,
        'Port Lligat Slab': GoogleFonts.portLligatSlabTextTheme,
        'Potta One': GoogleFonts.pottaOneTextTheme,
        'Pragati Narrow': GoogleFonts.pragatiNarrowTextTheme,
        'Praise': GoogleFonts.praiseTextTheme,
        'Prata': GoogleFonts.prataTextTheme,
        'Preahvihear': GoogleFonts.preahvihearTextTheme,
        'Press Start 2P': GoogleFonts.pressStart2pTextTheme,
        'Pridi': GoogleFonts.pridiTextTheme,
        'Princess Sofia': GoogleFonts.princessSofiaTextTheme,
        'Prociono': GoogleFonts.procionoTextTheme,
        'Prompt': GoogleFonts.promptTextTheme,
        'Prosto One': GoogleFonts.prostoOneTextTheme,
        'Proza Libre': GoogleFonts.prozaLibreTextTheme,
        'Public Sans': GoogleFonts.publicSansTextTheme,
        'Puppies Play': GoogleFonts.puppiesPlayTextTheme,
        'Puritan': GoogleFonts.puritanTextTheme,
        'Purple Purse': GoogleFonts.purplePurseTextTheme,
        'Qahiri': GoogleFonts.qahiriTextTheme,
        'Quando': GoogleFonts.quandoTextTheme,
        'Quantico': GoogleFonts.quanticoTextTheme,
        'Quattrocento': GoogleFonts.quattrocentoTextTheme,
        'Quattrocento Sans': GoogleFonts.quattrocentoSansTextTheme,
        'Questrial': GoogleFonts.questrialTextTheme,
        'Quicksand': GoogleFonts.quicksandTextTheme,
        'Quintessential': GoogleFonts.quintessentialTextTheme,
        'Qwigley': GoogleFonts.qwigleyTextTheme,
        'Qwitcher Grypen': GoogleFonts.qwitcherGrypenTextTheme,
        'Racing Sans One': GoogleFonts.racingSansOneTextTheme,
        'Radio Canada': GoogleFonts.radioCanadaTextTheme,
        'Radley': GoogleFonts.radleyTextTheme,
        'Rajdhani': GoogleFonts.rajdhaniTextTheme,
        'Rakkas': GoogleFonts.rakkasTextTheme,
        'Raleway': GoogleFonts.ralewayTextTheme,
        'Raleway Dots': GoogleFonts.ralewayDotsTextTheme,
        'Ramabhadra': GoogleFonts.ramabhadraTextTheme,
        'Ramaraja': GoogleFonts.ramarajaTextTheme,
        'Rambla': GoogleFonts.ramblaTextTheme,
        'Rammetto One': GoogleFonts.rammettoOneTextTheme,
        'Rampart One': GoogleFonts.rampartOneTextTheme,
        'Ranchers': GoogleFonts.ranchersTextTheme,
        'Rancho': GoogleFonts.ranchoTextTheme,
        'Ranga': GoogleFonts.rangaTextTheme,
        'Rasa': GoogleFonts.rasaTextTheme,
        'Rationale': GoogleFonts.rationaleTextTheme,
        'Ravi Prakash': GoogleFonts.raviPrakashTextTheme,
        'Readex Pro': GoogleFonts.readexProTextTheme,
        'Recursive': GoogleFonts.recursiveTextTheme,
        'Red Hat Display': GoogleFonts.redHatDisplayTextTheme,
        'Red Hat Mono': GoogleFonts.redHatMonoTextTheme,
        'Red Hat Text': GoogleFonts.redHatTextTextTheme,
        'Red Rose': GoogleFonts.redRoseTextTheme,
        'Redacted': GoogleFonts.redactedTextTheme,
        'Redacted Script': GoogleFonts.redactedScriptTextTheme,
        'Redressed': GoogleFonts.redressedTextTheme,
        'Reem Kufi': GoogleFonts.reemKufiTextTheme,
        'Reenie Beanie': GoogleFonts.reenieBeanieTextTheme,
        'Reggae One': GoogleFonts.reggaeOneTextTheme,
        'Revalia': GoogleFonts.revaliaTextTheme,
        'Rhodium Libre': GoogleFonts.rhodiumLibreTextTheme,
        'Ribeye': GoogleFonts.ribeyeTextTheme,
        'Ribeye Marrow': GoogleFonts.ribeyeMarrowTextTheme,
        'Righteous': GoogleFonts.righteousTextTheme,
        'Risque': GoogleFonts.risqueTextTheme,
        'Road Rage': GoogleFonts.roadRageTextTheme,
        'Roboto': GoogleFonts.robotoTextTheme,
        'Roboto Condensed': GoogleFonts.robotoCondensedTextTheme,
        'Roboto Flex': GoogleFonts.robotoFlexTextTheme,
        'Roboto Mono': GoogleFonts.robotoMonoTextTheme,
        'Roboto Serif': GoogleFonts.robotoSerifTextTheme,
        'Roboto Slab': GoogleFonts.robotoSlabTextTheme,
        'Rochester': GoogleFonts.rochesterTextTheme,
        'Rock 3D': GoogleFonts.rock3dTextTheme,
        'Rock Salt': GoogleFonts.rockSaltTextTheme,
        'RocknRoll One': GoogleFonts.rocknRollOneTextTheme,
        'Rokkitt': GoogleFonts.rokkittTextTheme,
        'Romanesco': GoogleFonts.romanescoTextTheme,
        'Ropa Sans': GoogleFonts.ropaSansTextTheme,
        'Rosario': GoogleFonts.rosarioTextTheme,
        'Rosarivo': GoogleFonts.rosarivoTextTheme,
        'Rouge Script': GoogleFonts.rougeScriptTextTheme,
        'Rowdies': GoogleFonts.rowdiesTextTheme,
        'Rozha One': GoogleFonts.rozhaOneTextTheme,
        'Rubik': GoogleFonts.rubikTextTheme,
        'Rubik Beastly': GoogleFonts.rubikBeastlyTextTheme,
        'Rubik Bubbles': GoogleFonts.rubikBubblesTextTheme,
        'Rubik Glitch': GoogleFonts.rubikGlitchTextTheme,
        'Rubik Microbe': GoogleFonts.rubikMicrobeTextTheme,
        'Rubik Mono One': GoogleFonts.rubikMonoOneTextTheme,
        'Rubik Moonrocks': GoogleFonts.rubikMoonrocksTextTheme,
        'Rubik Puddles': GoogleFonts.rubikPuddlesTextTheme,
        'Rubik Wet Paint': GoogleFonts.rubikWetPaintTextTheme,
        'Ruda': GoogleFonts.rudaTextTheme,
        'Rufina': GoogleFonts.rufinaTextTheme,
        'Ruge Boogie': GoogleFonts.rugeBoogieTextTheme,
        'Ruluko': GoogleFonts.rulukoTextTheme,
        'Rum Raisin': GoogleFonts.rumRaisinTextTheme,
        'Ruslan Display': GoogleFonts.ruslanDisplayTextTheme,
        'Russo One': GoogleFonts.russoOneTextTheme,
        'Ruthie': GoogleFonts.ruthieTextTheme,
        'Rye': GoogleFonts.ryeTextTheme,
        'STIX Two Text': GoogleFonts.stixTwoTextTextTheme,
        'Sacramento': GoogleFonts.sacramentoTextTheme,
        'Sahitya': GoogleFonts.sahityaTextTheme,
        'Sail': GoogleFonts.sailTextTheme,
        'Saira': GoogleFonts.sairaTextTheme,
        'Saira Condensed': GoogleFonts.sairaCondensedTextTheme,
        'Saira Extra Condensed': GoogleFonts.sairaExtraCondensedTextTheme,
        'Saira Semi Condensed': GoogleFonts.sairaSemiCondensedTextTheme,
        'Saira Stencil One': GoogleFonts.sairaStencilOneTextTheme,
        'Salsa': GoogleFonts.salsaTextTheme,
        'Sanchez': GoogleFonts.sanchezTextTheme,
        'Sancreek': GoogleFonts.sancreekTextTheme,
        'Sansita': GoogleFonts.sansitaTextTheme,
        'Sansita Swashed': GoogleFonts.sansitaSwashedTextTheme,
        'Sarabun': GoogleFonts.sarabunTextTheme,
        'Sarala': GoogleFonts.saralaTextTheme,
        'Sarina': GoogleFonts.sarinaTextTheme,
        'Sarpanch': GoogleFonts.sarpanchTextTheme,
        'Sassy Frass': GoogleFonts.sassyFrassTextTheme,
        'Satisfy': GoogleFonts.satisfyTextTheme,
        'Sawarabi Gothic': GoogleFonts.sawarabiGothicTextTheme,
        'Sawarabi Mincho': GoogleFonts.sawarabiMinchoTextTheme,
        'Scada': GoogleFonts.scadaTextTheme,
        'Scheherazade New': GoogleFonts.scheherazadeNewTextTheme,
        'Schoolbell': GoogleFonts.schoolbellTextTheme,
        'Scope One': GoogleFonts.scopeOneTextTheme,
        'Seaweed Script': GoogleFonts.seaweedScriptTextTheme,
        'Secular One': GoogleFonts.secularOneTextTheme,
        'Sedgwick Ave': GoogleFonts.sedgwickAveTextTheme,
        'Sedgwick Ave Display': GoogleFonts.sedgwickAveDisplayTextTheme,
        'Sen': GoogleFonts.senTextTheme,
        'Send Flowers': GoogleFonts.sendFlowersTextTheme,
        'Sevillana': GoogleFonts.sevillanaTextTheme,
        'Seymour One': GoogleFonts.seymourOneTextTheme,
        'Shadows Into Light': GoogleFonts.shadowsIntoLightTextTheme,
        'Shadows Into Light Two': GoogleFonts.shadowsIntoLightTwoTextTheme,
        'Shalimar': GoogleFonts.shalimarTextTheme,
        'Shanti': GoogleFonts.shantiTextTheme,
        'Share': GoogleFonts.shareTextTheme,
        'Share Tech': GoogleFonts.shareTechTextTheme,
        'Share Tech Mono': GoogleFonts.shareTechMonoTextTheme,
        'Shippori Antique': GoogleFonts.shipporiAntiqueTextTheme,
        'Shippori Antique B1': GoogleFonts.shipporiAntiqueB1TextTheme,
        'Shippori Mincho': GoogleFonts.shipporiMinchoTextTheme,
        'Shippori Mincho B1': GoogleFonts.shipporiMinchoB1TextTheme,
        'Shizuru': GoogleFonts.shizuruTextTheme,
        'Shojumaru': GoogleFonts.shojumaruTextTheme,
        'Short Stack': GoogleFonts.shortStackTextTheme,
        'Shrikhand': GoogleFonts.shrikhandTextTheme,
        'Siemreap': GoogleFonts.siemreapTextTheme,
        'Sigmar One': GoogleFonts.sigmarOneTextTheme,
        'Signika': GoogleFonts.signikaTextTheme,
        'Signika Negative': GoogleFonts.signikaNegativeTextTheme,
        'Simonetta': GoogleFonts.simonettaTextTheme,
        'Single Day': GoogleFonts.singleDayTextTheme,
        'Sintony': GoogleFonts.sintonyTextTheme,
        'Sirin Stencil': GoogleFonts.sirinStencilTextTheme,
        'Six Caps': GoogleFonts.sixCapsTextTheme,
        'Skranji': GoogleFonts.skranjiTextTheme,
        'Slabo 13px': GoogleFonts.slabo13pxTextTheme,
        'Slabo 27px': GoogleFonts.slabo27pxTextTheme,
        'Slackey': GoogleFonts.slackeyTextTheme,
        'Smokum': GoogleFonts.smokumTextTheme,
        'Smooch': GoogleFonts.smoochTextTheme,
        'Smooch Sans': GoogleFonts.smoochSansTextTheme,
        'Smythe': GoogleFonts.smytheTextTheme,
        'Sniglet': GoogleFonts.snigletTextTheme,
        'Snippet': GoogleFonts.snippetTextTheme,
        'Snowburst One': GoogleFonts.snowburstOneTextTheme,
        'Sofadi One': GoogleFonts.sofadiOneTextTheme,
        'Sofia': GoogleFonts.sofiaTextTheme,
        'Solway': GoogleFonts.solwayTextTheme,
        'Song Myung': GoogleFonts.songMyungTextTheme,
        'Sonsie One': GoogleFonts.sonsieOneTextTheme,
        'Sora': GoogleFonts.soraTextTheme,
        'Sorts Mill Goudy': GoogleFonts.sortsMillGoudyTextTheme,
        'Source Code Pro': GoogleFonts.sourceCodeProTextTheme,
        'Source Sans 3': GoogleFonts.sourceSans3TextTheme,
        'Source Sans Pro': GoogleFonts.sourceSansProTextTheme,
        'Source Serif 4': GoogleFonts.sourceSerif4TextTheme,
        'Source Serif Pro': GoogleFonts.sourceSerifProTextTheme,
        'Space Grotesk': GoogleFonts.spaceGroteskTextTheme,
        'Space Mono': GoogleFonts.spaceMonoTextTheme,
        'Special Elite': GoogleFonts.specialEliteTextTheme,
        'Spectral': GoogleFonts.spectralTextTheme,
        'Spectral SC': GoogleFonts.spectralScTextTheme,
        'Spicy Rice': GoogleFonts.spicyRiceTextTheme,
        'Spinnaker': GoogleFonts.spinnakerTextTheme,
        'Spirax': GoogleFonts.spiraxTextTheme,
        'Spline Sans': GoogleFonts.splineSansTextTheme,
        'Squada One': GoogleFonts.squadaOneTextTheme,
        'Square Peg': GoogleFonts.squarePegTextTheme,
        'Sree Krushnadevaraya': GoogleFonts.sreeKrushnadevarayaTextTheme,
        'Sriracha': GoogleFonts.srirachaTextTheme,
        'Srisakdi': GoogleFonts.srisakdiTextTheme,
        'Staatliches': GoogleFonts.staatlichesTextTheme,
        'Stalemate': GoogleFonts.stalemateTextTheme,
        'Stalinist One': GoogleFonts.stalinistOneTextTheme,
        'Stardos Stencil': GoogleFonts.stardosStencilTextTheme,
        'Stick': GoogleFonts.stickTextTheme,
        'Stick No Bills': GoogleFonts.stickNoBillsTextTheme,
        'Stint Ultra Condensed': GoogleFonts.stintUltraCondensedTextTheme,
        'Stint Ultra Expanded': GoogleFonts.stintUltraExpandedTextTheme,
        'Stoke': GoogleFonts.stokeTextTheme,
        'Strait': GoogleFonts.straitTextTheme,
        'Style Script': GoogleFonts.styleScriptTextTheme,
        'Stylish': GoogleFonts.stylishTextTheme,
        'Sue Ellen Francisco': GoogleFonts.sueEllenFranciscoTextTheme,
        'Suez One': GoogleFonts.suezOneTextTheme,
        'Sulphur Point': GoogleFonts.sulphurPointTextTheme,
        'Sumana': GoogleFonts.sumanaTextTheme,
        'Sunflower': GoogleFonts.sunflowerTextTheme,
        'Sunshiney': GoogleFonts.sunshineyTextTheme,
        'Supermercado One': GoogleFonts.supermercadoOneTextTheme,
        'Sura': GoogleFonts.suraTextTheme,
        'Suranna': GoogleFonts.surannaTextTheme,
        'Suravaram': GoogleFonts.suravaramTextTheme,
        'Suwannaphum': GoogleFonts.suwannaphumTextTheme,
        'Swanky and Moo Moo': GoogleFonts.swankyAndMooMooTextTheme,
        'Syncopate': GoogleFonts.syncopateTextTheme,
        'Syne': GoogleFonts.syneTextTheme,
        'Syne Mono': GoogleFonts.syneMonoTextTheme,
        'Syne Tactile': GoogleFonts.syneTactileTextTheme,
        'Tajawal': GoogleFonts.tajawalTextTheme,
        'Tangerine': GoogleFonts.tangerineTextTheme,
        'Tapestry': GoogleFonts.tapestryTextTheme,
        'Taprom': GoogleFonts.tapromTextTheme,
        'Tauri': GoogleFonts.tauriTextTheme,
        'Taviraj': GoogleFonts.tavirajTextTheme,
        'Teko': GoogleFonts.tekoTextTheme,
        'Telex': GoogleFonts.telexTextTheme,
        'Tenali Ramakrishna': GoogleFonts.tenaliRamakrishnaTextTheme,
        'Tenor Sans': GoogleFonts.tenorSansTextTheme,
        'Text Me One': GoogleFonts.textMeOneTextTheme,
        'Texturina': GoogleFonts.texturinaTextTheme,
        'Thasadith': GoogleFonts.thasadithTextTheme,
        'The Girl Next Door': GoogleFonts.theGirlNextDoorTextTheme,
        'The Nautigal': GoogleFonts.theNautigalTextTheme,
        'Tienne': GoogleFonts.tienneTextTheme,
        'Tillana': GoogleFonts.tillanaTextTheme,
        'Timmana': GoogleFonts.timmanaTextTheme,
        'Tinos': GoogleFonts.tinosTextTheme,
        'Titan One': GoogleFonts.titanOneTextTheme,
        'Titillium Web': GoogleFonts.titilliumWebTextTheme,
        'Tomorrow': GoogleFonts.tomorrowTextTheme,
        'Tourney': GoogleFonts.tourneyTextTheme,
        'Trade Winds': GoogleFonts.tradeWindsTextTheme,
        'Train One': GoogleFonts.trainOneTextTheme,
        'Trirong': GoogleFonts.trirongTextTheme,
        'Trispace': GoogleFonts.trispaceTextTheme,
        'Trocchi': GoogleFonts.trocchiTextTheme,
        'Trochut': GoogleFonts.trochutTextTheme,
        'Truculenta': GoogleFonts.truculentaTextTheme,
        'Trykker': GoogleFonts.trykkerTextTheme,
        'Tulpen One': GoogleFonts.tulpenOneTextTheme,
        'Turret Road': GoogleFonts.turretRoadTextTheme,
        'Twinkle Star': GoogleFonts.twinkleStarTextTheme,
        'Ubuntu': GoogleFonts.ubuntuTextTheme,
        'Ubuntu Condensed': GoogleFonts.ubuntuCondensedTextTheme,
        'Ubuntu Mono': GoogleFonts.ubuntuMonoTextTheme,
        'Uchen': GoogleFonts.uchenTextTheme,
        'Ultra': GoogleFonts.ultraTextTheme,
        'Uncial Antiqua': GoogleFonts.uncialAntiquaTextTheme,
        'Underdog': GoogleFonts.underdogTextTheme,
        'Unica One': GoogleFonts.unicaOneTextTheme,
        'UnifrakturCook': GoogleFonts.unifrakturCookTextTheme,
        'UnifrakturMaguntia': GoogleFonts.unifrakturMaguntiaTextTheme,
        'Unkempt': GoogleFonts.unkemptTextTheme,
        'Unlock': GoogleFonts.unlockTextTheme,
        'Unna': GoogleFonts.unnaTextTheme,
        'Updock': GoogleFonts.updockTextTheme,
        'Urbanist': GoogleFonts.urbanistTextTheme,
        'VT323': GoogleFonts.vt323TextTheme,
        'Vampiro One': GoogleFonts.vampiroOneTextTheme,
        'Varela': GoogleFonts.varelaTextTheme,
        'Varela Round': GoogleFonts.varelaRoundTextTheme,
        'Varta': GoogleFonts.vartaTextTheme,
        'Vast Shadow': GoogleFonts.vastShadowTextTheme,
        'Vazirmatn': GoogleFonts.vazirmatnTextTheme,
        'Vesper Libre': GoogleFonts.vesperLibreTextTheme,
        'Viaoda Libre': GoogleFonts.viaodaLibreTextTheme,
        'Vibes': GoogleFonts.vibesTextTheme,
        'Vibur': GoogleFonts.viburTextTheme,
        'Vidaloka': GoogleFonts.vidalokaTextTheme,
        'Viga': GoogleFonts.vigaTextTheme,
        'Voces': GoogleFonts.vocesTextTheme,
        'Volkhov': GoogleFonts.volkhovTextTheme,
        'Vollkorn': GoogleFonts.vollkornTextTheme,
        'Vollkorn SC': GoogleFonts.vollkornScTextTheme,
        'Voltaire': GoogleFonts.voltaireTextTheme,
        'Vujahday Script': GoogleFonts.vujahdayScriptTextTheme,
        'Waiting for the Sunrise': GoogleFonts.waitingForTheSunriseTextTheme,
        'Wallpoet': GoogleFonts.wallpoetTextTheme,
        'Walter Turncoat': GoogleFonts.walterTurncoatTextTheme,
        'Warnes': GoogleFonts.warnesTextTheme,
        'Water Brush': GoogleFonts.waterBrushTextTheme,
        'Waterfall': GoogleFonts.waterfallTextTheme,
        'Wellfleet': GoogleFonts.wellfleetTextTheme,
        'Wendy One': GoogleFonts.wendyOneTextTheme,
        'Whisper': GoogleFonts.whisperTextTheme,
        'WindSong': GoogleFonts.windSongTextTheme,
        'Wire One': GoogleFonts.wireOneTextTheme,
        'Work Sans': GoogleFonts.workSansTextTheme,
        'Xanh Mono': GoogleFonts.xanhMonoTextTheme,
        'Yaldevi': GoogleFonts.yaldeviTextTheme,
        'Yanone Kaffeesatz': GoogleFonts.yanoneKaffeesatzTextTheme,
        'Yantramanav': GoogleFonts.yantramanavTextTheme,
        'Yatra One': GoogleFonts.yatraOneTextTheme,
        'Yellowtail': GoogleFonts.yellowtailTextTheme,
        'Yeon Sung': GoogleFonts.yeonSungTextTheme,
        'Yeseva One': GoogleFonts.yesevaOneTextTheme,
        'Yesteryear': GoogleFonts.yesteryearTextTheme,
        'Yomogi': GoogleFonts.yomogiTextTheme,
        'Yrsa': GoogleFonts.yrsaTextTheme,
        'Yuji Boku': GoogleFonts.yujiBokuTextTheme,
        'Yuji Hentaigana Akari': GoogleFonts.yujiHentaiganaAkariTextTheme,
        'Yuji Hentaigana Akebono': GoogleFonts.yujiHentaiganaAkebonoTextTheme,
        'Yuji Mai': GoogleFonts.yujiMaiTextTheme,
        'Yuji Syuku': GoogleFonts.yujiSyukuTextTheme,
        'Yusei Magic': GoogleFonts.yuseiMagicTextTheme,
        'ZCOOL KuaiLe': GoogleFonts.zcoolKuaiLeTextTheme,
        'ZCOOL QingKe HuangYou': GoogleFonts.zcoolQingKeHuangYouTextTheme,
        'ZCOOL XiaoWei': GoogleFonts.zcoolXiaoWeiTextTheme,
        'Zen Antique': GoogleFonts.zenAntiqueTextTheme,
        'Zen Antique Soft': GoogleFonts.zenAntiqueSoftTextTheme,
        'Zen Dots': GoogleFonts.zenDotsTextTheme,
        'Zen Kaku Gothic Antique': GoogleFonts.zenKakuGothicAntiqueTextTheme,
        'Zen Kaku Gothic New': GoogleFonts.zenKakuGothicNewTextTheme,
        'Zen Kurenaido': GoogleFonts.zenKurenaidoTextTheme,
        'Zen Loop': GoogleFonts.zenLoopTextTheme,
        'Zen Maru Gothic': GoogleFonts.zenMaruGothicTextTheme,
        'Zen Old Mincho': GoogleFonts.zenOldMinchoTextTheme,
        'Zen Tokyo Zoo': GoogleFonts.zenTokyoZooTextTheme,
        'Zeyada': GoogleFonts.zeyadaTextTheme,
        'Zhi Mang Xing': GoogleFonts.zhiMangXingTextTheme,
        'Zilla Slab': GoogleFonts.zillaSlabTextTheme,
        'Zilla Slab Highlight': GoogleFonts.zillaSlabHighlightTextTheme,
      };

  /// Retrieve a font by family name.
  ///
  /// Applies the given font family from Google Fonts to the given [textStyle]
  /// and returns the resulting [TextStyle].
  ///
  /// Note: [fontFamily] is case-sensitive.
  ///
  /// Parameter [fontFamily] must not be `null`. Throws if no font by name
  /// [fontFamily] exists.
  static TextStyle getFont(
    String fontFamily, {
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = GoogleFonts.asMap();
    if (!fonts.containsKey(fontFamily)) {
      throw Exception("No font family by name '$fontFamily' was found.");
    }
    return fonts[fontFamily]!(
      textStyle: textStyle,
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
    );
  }

  /// Retrieve a text theme by its font family name.
  ///
  /// Applies the given font family from Google Fonts to the given [textTheme]
  /// and returns the resulting [textTheme].
  ///
  /// Note: [fontFamily] is case-sensitive.
  ///
  /// Parameter [fontFamily] must not be `null`. Throws if no font by name
  /// [fontFamily] exists.
  static TextTheme getTextTheme(String fontFamily, [TextTheme? textTheme]) {
    final fonts = _asMapOfTextThemes();
    if (!fonts.containsKey(fontFamily)) {
      throw Exception("No font family by name '$fontFamily' was found.");
    }
    return fonts[fontFamily]!(textTheme);
  }

  /// Applies the ABeeZee font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/ABeeZee
  static TextStyle aBeeZee({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4ed0069c1454d476c52e8d8c43ffdbdd648c6a3d382da8cf078b3bb45ff82479',
        30600,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fb76fef50d4920b8ae51fa41329989b7dff2d0f0208d37b34127645a85352fa2',
        32116,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ABeeZee',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the ABeeZee font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/ABeeZee
  static TextTheme aBeeZeeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.aBeeZee(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.aBeeZee(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.aBeeZee(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.aBeeZee(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.aBeeZee(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.aBeeZee(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.aBeeZee(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.aBeeZee(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.aBeeZee(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.aBeeZee(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.aBeeZee(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.aBeeZee(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.aBeeZee(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.aBeeZee(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.aBeeZee(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Abel font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Abel
  static TextStyle abel({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fbef0740397e2ca38a05f204f7129be38b2ab6bb3994a69e14d3a245e489aece',
        32648,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Abel',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Abel font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Abel
  static TextTheme abelTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.abel(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.abel(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.abel(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.abel(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.abel(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.abel(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.abel(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.abel(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.abel(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.abel(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.abel(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.abel(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.abel(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.abel(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.abel(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Abhaya Libre font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Abhaya+Libre
  static TextStyle abhayaLibre({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c458f0cdbbe374f302c17f1ec4abbdd2a379f3a25f8651eb6780eabaf697dcfa',
        260860,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8a8e2de361c071cdaee84e07bd7e390ce587c8a1fe8c4ba0fc9902a04911e43b',
        260976,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '06219ea7f05ca18e796cbd2d6bd179775bf53827844ff68507a294e8ade7e5fa',
        260144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ae16e2ff929e02be31ddf36b9565470d65c96e896f0f4274ad873f6af48a1867',
        259828,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ec1520d99087cc369e27ec998a406c900ca73dc725206f004da6795ac8a9d465',
        259032,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AbhayaLibre',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Abhaya Libre font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Abhaya+Libre
  static TextTheme abhayaLibreTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.abhayaLibre(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.abhayaLibre(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.abhayaLibre(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.abhayaLibre(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.abhayaLibre(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.abhayaLibre(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.abhayaLibre(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.abhayaLibre(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.abhayaLibre(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.abhayaLibre(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.abhayaLibre(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.abhayaLibre(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.abhayaLibre(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.abhayaLibre(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.abhayaLibre(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Abril Fatface font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Abril+Fatface
  static TextStyle abrilFatface({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9c67883c76234315fcefa9a0a99620e0818f0b7a3fa98634bcb7935a18c61e92',
        56208,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AbrilFatface',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Abril Fatface font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Abril+Fatface
  static TextTheme abrilFatfaceTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.abrilFatface(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.abrilFatface(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.abrilFatface(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.abrilFatface(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.abrilFatface(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.abrilFatface(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.abrilFatface(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.abrilFatface(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.abrilFatface(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.abrilFatface(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.abrilFatface(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.abrilFatface(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.abrilFatface(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.abrilFatface(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.abrilFatface(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Aclonica font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aclonica
  static TextStyle aclonica({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd08d5411909adfa9d768acc3fe8f0251bfa60ba7733280d9303c246485d09425',
        53112,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Aclonica',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Aclonica font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aclonica
  static TextTheme aclonicaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.aclonica(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.aclonica(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.aclonica(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.aclonica(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.aclonica(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.aclonica(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.aclonica(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.aclonica(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.aclonica(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.aclonica(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.aclonica(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.aclonica(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.aclonica(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.aclonica(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.aclonica(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Acme font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Acme
  static TextStyle acme({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bcee0555968b2f5a138a387888020ead2e9adb025b1fd6cca3b00276f055d7b9',
        21392,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Acme',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Acme font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Acme
  static TextTheme acmeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.acme(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.acme(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.acme(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.acme(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.acme(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.acme(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.acme(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.acme(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.acme(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.acme(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.acme(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.acme(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.acme(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.acme(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.acme(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Actor font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Actor
  static TextStyle actor({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '62d4580d4d42de39d74b4087814e559b5480f30604b8d5d2929f391cda48adda',
        32508,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Actor',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Actor font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Actor
  static TextTheme actorTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.actor(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.actor(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.actor(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.actor(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.actor(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.actor(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.actor(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.actor(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.actor(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.actor(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.actor(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.actor(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.actor(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.actor(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.actor(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Adamina font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Adamina
  static TextStyle adamina({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e123026cff37baee8a9e66a14d3cb57d9a5e1c7cebc75b143e4955e88e6be1a3',
        34172,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Adamina',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Adamina font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Adamina
  static TextTheme adaminaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.adamina(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.adamina(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.adamina(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.adamina(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.adamina(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.adamina(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.adamina(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.adamina(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.adamina(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.adamina(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.adamina(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.adamina(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.adamina(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.adamina(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.adamina(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Advent Pro font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Advent+Pro
  static TextStyle adventPro({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bd6ab2b98496edfe8717c4a3fc36a3772f98320008b525d5e6ad460bdaa24846',
        49476,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3658dee07ef103eb3d7bcbad142c36c14a2558b5f26c552ba2ffb91aebad7040',
        49084,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1ebb3b726ba2c390c4eae43119ef4ec252c807cdbbcebdcc09b376fafc808e7b',
        48920,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '25bbecb42e816b8bdb20e1f9f6bea4e4ea33348a47849ad6dff41d9d3f30dcf6',
        48632,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4e88005f2c6ff35830fa3e5a4430cd4eaaf2aac72acfa4efd0f0addd6db27340',
        49120,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ac900b9117504fc723ca4b97ff56c60c405cea35339d3d38990cf115da914d0c',
        49136,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'db429403a404bb84de36065df7675d11fa3b6e3f175850577cf4feb9508d6aa3',
        49240,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AdventPro',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Advent Pro font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Advent+Pro
  static TextTheme adventProTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.adventPro(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.adventPro(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.adventPro(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.adventPro(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.adventPro(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.adventPro(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.adventPro(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.adventPro(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.adventPro(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.adventPro(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.adventPro(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.adventPro(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.adventPro(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.adventPro(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.adventPro(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Aguafina Script font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aguafina+Script
  static TextStyle aguafinaScript({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f2cff91a7c40b18733b4e5b16e83607684db5d5cc09872455092ff6b0996d561',
        44884,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AguafinaScript',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Aguafina Script font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aguafina+Script
  static TextTheme aguafinaScriptTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.aguafinaScript(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.aguafinaScript(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.aguafinaScript(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.aguafinaScript(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.aguafinaScript(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.aguafinaScript(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.aguafinaScript(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.aguafinaScript(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.aguafinaScript(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.aguafinaScript(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.aguafinaScript(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.aguafinaScript(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.aguafinaScript(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.aguafinaScript(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.aguafinaScript(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Akaya Kanadaka font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Akaya+Kanadaka
  static TextStyle akayaKanadaka({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ae7b926a2c06f3a871d8f8927aee721c0caaa9a0b8193531c2c7c919d4ff6e8a',
        204196,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AkayaKanadaka',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Akaya Kanadaka font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Akaya+Kanadaka
  static TextTheme akayaKanadakaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.akayaKanadaka(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.akayaKanadaka(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.akayaKanadaka(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.akayaKanadaka(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.akayaKanadaka(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.akayaKanadaka(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.akayaKanadaka(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.akayaKanadaka(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.akayaKanadaka(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.akayaKanadaka(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.akayaKanadaka(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.akayaKanadaka(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.akayaKanadaka(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.akayaKanadaka(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.akayaKanadaka(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Akaya Telivigala font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Akaya+Telivigala
  static TextStyle akayaTelivigala({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '69b20a196e4a5f48efc33d7ec372bb02a6bc4cadbe3600b7341bccbefd8ad707',
        319968,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AkayaTelivigala',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Akaya Telivigala font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Akaya+Telivigala
  static TextTheme akayaTelivigalaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.akayaTelivigala(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.akayaTelivigala(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.akayaTelivigala(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.akayaTelivigala(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.akayaTelivigala(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.akayaTelivigala(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.akayaTelivigala(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.akayaTelivigala(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.akayaTelivigala(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.akayaTelivigala(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.akayaTelivigala(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.akayaTelivigala(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.akayaTelivigala(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.akayaTelivigala(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.akayaTelivigala(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Akronim font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Akronim
  static TextStyle akronim({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2092a1a3699c69bb9776d37189bc8601dbdf4546f015d3c2c2cc826eb5162915',
        105652,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Akronim',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Akronim font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Akronim
  static TextTheme akronimTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.akronim(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.akronim(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.akronim(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.akronim(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.akronim(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.akronim(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.akronim(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.akronim(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.akronim(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.akronim(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.akronim(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.akronim(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.akronim(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.akronim(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.akronim(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Akshar font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Akshar
  static TextStyle akshar({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f3b9afc40abb8a416fcd004320a57292965569ea99a357c126af5f456a1e1369',
        134988,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '63e3a5a324e7529ca1bcdf484deb9e796c13b2a12962cd0724b2089483c4fd4a',
        135684,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '022839490f3b7d513dd04a44297a6f65df456959d4b4face86f136f2b7062d10',
        135868,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5cbf02e39b94514e8281dda137c12c3d66df966f7aa596fbe8358aea49e9aec8',
        136088,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5f3db82a993dda7c9d2a89075de11931f876eb35181c4da24bef2eaef7146a8e',
        136088,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Akshar',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Akshar font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Akshar
  static TextTheme aksharTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.akshar(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.akshar(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.akshar(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.akshar(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.akshar(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.akshar(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.akshar(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.akshar(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.akshar(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.akshar(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.akshar(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.akshar(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.akshar(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.akshar(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.akshar(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Aladin font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aladin
  static TextStyle aladin({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '261414164a67c7aaf3d3a8845b63b04d289942868d771b18c5be93a8bca26a38',
        39832,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Aladin',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Aladin font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aladin
  static TextTheme aladinTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.aladin(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.aladin(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.aladin(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.aladin(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.aladin(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.aladin(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.aladin(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.aladin(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.aladin(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.aladin(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.aladin(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.aladin(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.aladin(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.aladin(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.aladin(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alata font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alata
  static TextStyle alata({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4d6d1a876ec561e28b937360e72c7a923c4e70d6b296d0e02ab975f905541542',
        63888,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Alata',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alata font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alata
  static TextTheme alataTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.alata(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.alata(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.alata(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.alata(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.alata(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.alata(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.alata(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.alata(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.alata(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.alata(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.alata(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.alata(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.alata(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.alata(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.alata(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alatsi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alatsi
  static TextStyle alatsi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a6ee9ecbf8ddb9016fe1fcf4e22f0457c6edfc037c8a0475206b6dcd680026d7',
        71468,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Alatsi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alatsi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alatsi
  static TextTheme alatsiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.alatsi(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.alatsi(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.alatsi(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.alatsi(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.alatsi(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.alatsi(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.alatsi(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.alatsi(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.alatsi(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.alatsi(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.alatsi(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.alatsi(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.alatsi(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.alatsi(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.alatsi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Aldrich font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aldrich
  static TextStyle aldrich({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b0d9febf96b39ccb564cc9710fa842a7bf1e8abd45fad6615cfb788fc17a13d5',
        25440,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Aldrich',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Aldrich font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aldrich
  static TextTheme aldrichTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.aldrich(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.aldrich(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.aldrich(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.aldrich(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.aldrich(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.aldrich(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.aldrich(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.aldrich(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.aldrich(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.aldrich(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.aldrich(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.aldrich(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.aldrich(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.aldrich(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.aldrich(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alef font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alef
  static TextStyle alef({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '34ced41c88a6c966490ce1a85c40eab4c9fdb1d6f20114da8edba261c0180a55',
        57172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6c0fdebc49a6f30dd1912bf2f08920758704b733176699bf177607ce23ba91a0',
        58820,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Alef',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alef font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alef
  static TextTheme alefTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.alef(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.alef(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.alef(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.alef(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.alef(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.alef(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.alef(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.alef(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.alef(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.alef(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.alef(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.alef(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.alef(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.alef(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.alef(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alegreya font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alegreya
  static TextStyle alegreya({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f037480bf7f56c16419b9a8d73b21c8ef39d022e7060ef5bb8004d7da654dc12',
        164756,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7e5441ebd7efa5984bf25827ee4ed08c4e935a2f512ba2a06235d4160cf8a0a9',
        165236,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ee9c9f9f4c74337c4ce5798848e26534626a0470e00fcafa143a83389c97f6b5',
        165284,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6061439302a2a4bd34e365d6b3c5d21f017391ba20a1bfb1b37d627fe9020d5e',
        165140,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '71765a8be738e843e4c4523892523da69cd4b87723c229242ccd65d78c627c42',
        165200,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a0c90081aa6ed9afd90e37dd5589e37bf2c8ecf492df8d10f631a9f655f65b5b',
        164688,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd653f2acdfceb4c7941f461eb3bcecaa56dd4e02eee953b43c06672896661c73',
        163848,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7ca0d6ee3697cd5276e8c7c070e4a858c2d37db6f78bb777cdea9aeef2c2d0be',
        164184,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7fbe29fec803e0c9c1cd0a765f080d25f97a9e8e23a6e22026a69a0931318a37',
        164160,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b3e7c053d359e924e2fa2315b85966190cd17cff265c0619143c21fde5ac029a',
        164164,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4535a89a6640d526682e70523d135effc813a56c130e5977ef7a6e7f544a6be7',
        164252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '37262bbdcc529682a334b6e9717b48bea11d3f3149e451e120e82e88f2d92771',
        163772,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Alegreya',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alegreya font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alegreya
  static TextTheme alegreyaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.alegreya(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.alegreya(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.alegreya(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.alegreya(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.alegreya(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.alegreya(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.alegreya(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.alegreya(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.alegreya(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.alegreya(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.alegreya(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.alegreya(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.alegreya(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.alegreya(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.alegreya(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alegreya SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alegreya+SC
  static TextStyle alegreyaSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c9484a508b55eb8eb6e8cecce0a0dd01b22893def0247245c207c2d3557f4520',
        221956,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ad1445afc298d8dcc5e5375ed0701fc5ecdee507a66e6711b49f7c16f6c51475',
        228040,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '70149b5096ea2f1019a9275f544ea40aa0b6c6de9e0af224d2db64860d0cb595',
        221400,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '380cbbdb49a7920b1c64fd52d9cec0d845a90081379f3e311718e8236c096d77',
        226976,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5d72f0cbf01d553236b99c25b7d93c4f7dfa376b5ea2b9a68d0fb9fc8978574a',
        218680,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '220bf264f4dc23ee359a69242cd3be905a01654bbe5787ec686d66d0bb84d366',
        225592,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2cd28305dde134872ff3b095b19da66fa34cc358400769b2a129b2c7c8ef3d87',
        217252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '66b4862bee541f0b94f90af2a20d0f2f890118fa443d2b215166b2970ffb551f',
        220544,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2a7cde33f7f214537e307b01bcf3346929a345550221574af80e5cb03bfc9077',
        214424,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0db199068d1a0890c97023f7eca9ac3899099f7ad3af2b646ed75a1f8bc34ab7',
        219916,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlegreyaSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alegreya SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alegreya+SC
  static TextTheme alegreyaScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.alegreyaSc(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.alegreyaSc(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.alegreyaSc(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.alegreyaSc(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.alegreyaSc(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.alegreyaSc(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.alegreyaSc(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.alegreyaSc(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.alegreyaSc(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.alegreyaSc(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.alegreyaSc(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.alegreyaSc(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.alegreyaSc(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.alegreyaSc(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.alegreyaSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alegreya Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alegreya+Sans
  static TextStyle alegreyaSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8d0e59e05f84bec4ce68d241dbdfa8b1eeff985301ae04cd22c8c514abf77b9d',
        124052,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'bac8ce3d4443fed88ec013859456317a1ad8d24e8b2d7c9b377afaa15ec637d3',
        129040,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '698c3b511f6218fcd375d39c3f8c74d7a6761087e679758027ea5fe066e9243a',
        126780,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e83c8c6689a19ca21cee0a46a616d85bdbd8d71a3cb7c50f68afd25a65d1ccfe',
        129828,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c204b2f8ad4a91b88b6217b24e5deb10eff4307677899d187280e79a361ab533',
        126856,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fed2193199a6365ae0d55f324b29056944d3f98b228eb4ac70a1425a3a636f5a',
        129460,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '71dedcf7e6714c202080ec7669e3e5e933884f389078001f14d3a9dcbfb8acc0',
        127264,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5b3a79ce30711cd50ca94d33b2404f154206d01c0274e3d31e27d6846cbc2fd7',
        130636,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f64b022e8b5109439835bf42f246086abba5106a9aba190c4cfd1ed6691438d8',
        127144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4b2eb1030f4dcc0c08db2633f56b838456106f838c6e701296f3c537ed35c70b',
        130300,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a14f7bc1d806ae9f704637e7f7a916e82e09f44726e9b706ef83a7365cda3118',
        127160,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'eace86cda23b5d42c8b1a946bd5c38b9cd874b9cf8c3fbe1900b2bdfa55f0546',
        130176,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2989679eb764c7070e7eb56ca862f49282ca3cc1f1c5d90756ffd91b1327739e',
        125248,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a877fb889f6aa458ea1e321773121959a8a8278a715ac5a30f3fbdf39d8a1b3e',
        128996,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlegreyaSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alegreya Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alegreya+Sans
  static TextTheme alegreyaSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.alegreyaSans(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.alegreyaSans(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.alegreyaSans(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.alegreyaSans(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.alegreyaSans(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.alegreyaSans(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.alegreyaSans(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.alegreyaSans(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.alegreyaSans(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.alegreyaSans(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.alegreyaSans(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.alegreyaSans(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.alegreyaSans(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.alegreyaSans(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.alegreyaSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alegreya Sans SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alegreya+Sans+SC
  static TextStyle alegreyaSansSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fa96c9ec18d4b6f4b3bf6668d7c8121e41c9089164331136c6f5bb48a4a42208',
        151440,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '297426e98a068ad1b58b52361173181330392de38d707821000888b2b60c90db',
        155464,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd27609d8069136c03abbb6960fb8138ddf4068023fc89f9e80b52a4e19d92c69',
        155284,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8afd38384720cacbeb72732f5935c538d4f1b21803d37382a71a2d0f545644bc',
        156796,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '80d79bf445e7110b689cb486b7a54978b6a059c06a92e78dcfe07c2164e616a8',
        156572,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0e4f6f8a6c630a226b85f22c76da36a6f961d2cabd26d9819bfb549097a28005',
        156828,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4f7e7fec167c7c04b9e9c0517b3061d678beaa4f248357c3931f4473bf6d50d0',
        156876,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1a7e871c8804c9a0df56d003af691ee74248d1d77d8c331ca416ec5b275a8820',
        157932,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '53a2a550eebec78401ad84f14e720d5b07cf31735d2814daea83c3e36a205a14',
        157436,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '51f31cee882b2adc11d69ebe07a0bf2d5eb916cdd058d2aea6f13fd45699a44e',
        157784,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c810a1642e52acf2fc2eb88c32dc7aae8d45cb3d4debfd46d9019688f8da30ce',
        157688,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd850a11abcaad9887ad4dbf359e7d56e92935d449ea2d282fd7b8ed203b3dc34',
        158468,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0d5566617757a1e2ca2ca8934938d246b1bcc7eec37d4abf64faa199d5dd211b',
        156868,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '27ee0cca89ca354a1bdeeafa2dd46712f106eb0152b45ce96b2ca44279f4cbc6',
        158056,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlegreyaSansSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alegreya Sans SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alegreya+Sans+SC
  static TextTheme alegreyaSansScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.alegreyaSansSc(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.alegreyaSansSc(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.alegreyaSansSc(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.alegreyaSansSc(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.alegreyaSansSc(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.alegreyaSansSc(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.alegreyaSansSc(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.alegreyaSansSc(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.alegreyaSansSc(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.alegreyaSansSc(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.alegreyaSansSc(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.alegreyaSansSc(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.alegreyaSansSc(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.alegreyaSansSc(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.alegreyaSansSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Aleo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aleo
  static TextStyle aleo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f1ed2ab50bb0cbcdfdaa8a17794451274a0eef72d5999ffb1a67fac0919bad37',
        35800,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd173d2b99e2112fbb3377e7b00e8ab1e378f088d37101d53f32a2380741b29db',
        45124,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '810f3506e12833adc40f85683b0e48e7ab95c58bfb9d6897b05816d7af1d5f3e',
        65892,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '53979c3561ba3e33e60e1470fec4bff2ef9a708ccee2d116359d31ee669c68e9',
        68788,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6d23aaa77877b2c671ea9971643323fcf507d28dc66a6a21e6406ba5601097f6',
        60744,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6472c795d6d5a1324555750ba1402c98d84c262f9413c91d94c055b635ed8c1f',
        64516,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Aleo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Aleo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aleo
  static TextTheme aleoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.aleo(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.aleo(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.aleo(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.aleo(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.aleo(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.aleo(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.aleo(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.aleo(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.aleo(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.aleo(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.aleo(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.aleo(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.aleo(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.aleo(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.aleo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alex Brush font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alex+Brush
  static TextStyle alexBrush({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1827c06dc42e438af24992b44ac57ec2ca159aca67530e6833d89b8aa45dda9b',
        61524,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlexBrush',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alex Brush font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alex+Brush
  static TextTheme alexBrushTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.alexBrush(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.alexBrush(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.alexBrush(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.alexBrush(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.alexBrush(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.alexBrush(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.alexBrush(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.alexBrush(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.alexBrush(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.alexBrush(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.alexBrush(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.alexBrush(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.alexBrush(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.alexBrush(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.alexBrush(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alfa Slab One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alfa+Slab+One
  static TextStyle alfaSlabOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '74947f8da3cf383b59c3241c2f6800655593849b02f185006f2018b1d883dbc0',
        59060,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlfaSlabOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alfa Slab One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alfa+Slab+One
  static TextTheme alfaSlabOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.alfaSlabOne(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.alfaSlabOne(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.alfaSlabOne(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.alfaSlabOne(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.alfaSlabOne(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.alfaSlabOne(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.alfaSlabOne(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.alfaSlabOne(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.alfaSlabOne(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.alfaSlabOne(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.alfaSlabOne(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.alfaSlabOne(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.alfaSlabOne(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.alfaSlabOne(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.alfaSlabOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alice font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alice
  static TextStyle alice({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e749db529af801dece7d5ddc3cc139ea81e17fcf1da06f09dab98e4e72b28afc',
        89536,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Alice',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alice font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alice
  static TextTheme aliceTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.alice(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.alice(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.alice(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.alice(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.alice(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.alice(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.alice(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.alice(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.alice(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.alice(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.alice(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.alice(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.alice(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.alice(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.alice(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alike font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alike
  static TextStyle alike({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f4a83c00aa9e628112f3eb3abf06d241dcbf8709bb948a31ef1a35da1e7e8668',
        34688,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Alike',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alike font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alike
  static TextTheme alikeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.alike(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.alike(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.alike(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.alike(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.alike(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.alike(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.alike(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.alike(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.alike(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.alike(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.alike(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.alike(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.alike(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.alike(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.alike(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alike Angular font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alike+Angular
  static TextStyle alikeAngular({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7c0ee7a3210c78d42eefd23fe8caeee6156110556cbbf376cdd11be7658bbb51',
        31548,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlikeAngular',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alike Angular font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alike+Angular
  static TextTheme alikeAngularTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.alikeAngular(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.alikeAngular(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.alikeAngular(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.alikeAngular(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.alikeAngular(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.alikeAngular(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.alikeAngular(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.alikeAngular(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.alikeAngular(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.alikeAngular(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.alikeAngular(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.alikeAngular(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.alikeAngular(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.alikeAngular(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.alikeAngular(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Allan font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allan
  static TextStyle allan({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e8f31ed930184a5215b2cd17605657048d9efef386dd3fc013585ef88d46732f',
        28860,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '62b42c332920d94cd7310db802fb178d81e0b4613ac91dd96cab4204fe5c9ac3',
        43000,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Allan',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Allan font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allan
  static TextTheme allanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.allan(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.allan(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.allan(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.allan(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.allan(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.allan(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.allan(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.allan(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.allan(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.allan(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.allan(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.allan(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.allan(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.allan(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.allan(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Allerta font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allerta
  static TextStyle allerta({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '966ff64339f556e7b5cd72638a17f46ce434fcaa9a36e04017cf34540c27e5cc',
        15184,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Allerta',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Allerta font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allerta
  static TextTheme allertaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.allerta(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.allerta(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.allerta(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.allerta(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.allerta(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.allerta(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.allerta(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.allerta(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.allerta(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.allerta(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.allerta(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.allerta(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.allerta(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.allerta(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.allerta(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Allerta Stencil font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allerta+Stencil
  static TextStyle allertaStencil({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fc7944a84a58458e35f26073bbd84a073d657632f2910be8cafe52a9fd9a6a95',
        15648,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AllertaStencil',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Allerta Stencil font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allerta+Stencil
  static TextTheme allertaStencilTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.allertaStencil(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.allertaStencil(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.allertaStencil(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.allertaStencil(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.allertaStencil(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.allertaStencil(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.allertaStencil(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.allertaStencil(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.allertaStencil(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.allertaStencil(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.allertaStencil(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.allertaStencil(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.allertaStencil(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.allertaStencil(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.allertaStencil(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Allison font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allison
  static TextStyle allison({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd9a2afdaf9e19bae8275d7e758caa167d7378dd4def732cf707de5cb8da6c5c7',
        93716,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Allison',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Allison font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allison
  static TextTheme allisonTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.allison(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.allison(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.allison(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.allison(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.allison(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.allison(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.allison(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.allison(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.allison(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.allison(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.allison(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.allison(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.allison(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.allison(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.allison(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Allura font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allura
  static TextStyle allura({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c13b82a1f5bef4f9a7e082d7b3dc42b4f2b538c1b9aeeba90f8f4c055a839994',
        120612,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Allura',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Allura font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allura
  static TextTheme alluraTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.allura(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.allura(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.allura(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.allura(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.allura(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.allura(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.allura(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.allura(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.allura(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.allura(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.allura(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.allura(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.allura(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.allura(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.allura(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Almarai font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Almarai
  static TextStyle almarai({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '82a22b76b0460a3bc66a94d16aae567637288d1c3c77a5cc5a1c71f235eba150',
        85828,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8123e9cd0c430e569e83475765af4fb01bb148d60534df3f96fb2669bae2c6bc',
        85912,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '52025e83b24d3c5cf43ee005e784af9dbbe14cfd4eb77b6546cdf90d86cb0bda',
        85696,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e2a1cb321bae24a4995bb6c3ff42b26355de1915c89be5465448a4bded2bbb33',
        86588,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Almarai',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Almarai font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Almarai
  static TextTheme almaraiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.almarai(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.almarai(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.almarai(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.almarai(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.almarai(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.almarai(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.almarai(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.almarai(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.almarai(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.almarai(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.almarai(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.almarai(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.almarai(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.almarai(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.almarai(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Almendra font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Almendra
  static TextStyle almendra({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b5671515be8c1a6960889b1efa6afc0c1f635c6d382480c23d77018eb983c689',
        57300,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd8c9d6359f4d79792da93da31dbc43a88efa93acee4a8412e76dc128d386a0a0',
        32852,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '05fe1d528b44639dee6339e2200b6f766e710088e8c644ee4c5bd2ddb0ee2007',
        34200,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7ca3d972da531f5b0810a95983aea29be9c891ce3bd595d2dd466e7290dd8ce1',
        32964,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Almendra',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Almendra font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Almendra
  static TextTheme almendraTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.almendra(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.almendra(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.almendra(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.almendra(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.almendra(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.almendra(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.almendra(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.almendra(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.almendra(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.almendra(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.almendra(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.almendra(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.almendra(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.almendra(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.almendra(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Almendra Display font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Almendra+Display
  static TextStyle almendraDisplay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'effe355f6a86a56fd3ab0816b63201ef3d9fbb5785130bded4f987872f816d71',
        36816,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlmendraDisplay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Almendra Display font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Almendra+Display
  static TextTheme almendraDisplayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.almendraDisplay(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.almendraDisplay(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.almendraDisplay(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.almendraDisplay(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.almendraDisplay(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.almendraDisplay(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.almendraDisplay(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.almendraDisplay(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.almendraDisplay(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.almendraDisplay(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.almendraDisplay(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.almendraDisplay(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.almendraDisplay(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.almendraDisplay(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.almendraDisplay(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Almendra SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Almendra+SC
  static TextStyle almendraSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3b0cd7a2defa989eceb6b6b654282f035287cccc700f5a5a62fa002c94807152',
        33560,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlmendraSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Almendra SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Almendra+SC
  static TextTheme almendraScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.almendraSc(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.almendraSc(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.almendraSc(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.almendraSc(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.almendraSc(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.almendraSc(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.almendraSc(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.almendraSc(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.almendraSc(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.almendraSc(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.almendraSc(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.almendraSc(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.almendraSc(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.almendraSc(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.almendraSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alumni Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alumni+Sans
  static TextStyle alumniSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f64a60502aa1b1d9c8435f9a08f261b2f2f98385961ff3fb5525651c09d5d2e4',
        65360,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '55cceeb01f76ee742cef7f9580a1e63cebdf06561f43f5d0506750f841467be2',
        65564,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7032f6b18e9e7eb42a2461eedfd362089641c55de4f723fcba7f6fef68d05d7a',
        65544,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '67434bcda0d850b5ff0c511a2a3924b4dfe70aef260efdd9c55c9631492710a3',
        65584,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '343d5650ab3f85dacb8702579d8adb2305c119d005e3852e8912bb2634c7d6ba',
        65684,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e05f5ee7628e0b3ec69e984d19fcc0e0f7d30439898e77b9a72acf1db86962a6',
        65708,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e8a86c3345e0648172b531b97b3768bd7fb5d48dca6b8a28ff7d3c0eb0e7a8ce',
        65648,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c6ea293c511e247ff3cd720f3973c417faab944b9901a6976096800e1a40a8f9',
        65688,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '569492a6e9691e962a4fed7139082944170ae28d7eaadc1ef78da380e9125b14',
        65360,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e71e4056e6af5960191b1adcc11e4cec064319fb6d7cc7a156ce6e002a546f0f',
        68152,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b1d15cf645b539561b3642459a940d7296b342097fc281040856fc740f77faf3',
        68296,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '54634790ad4dd681f2644ac1f106cf1a0ba7f4d5142bbdaffb55f8fe1787f608',
        68224,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '61c96189e2a05d93e96b3138c9db25381153114612bb430340e3049e7c87dbf7',
        68144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '76a7446ba25936fd608e60a4d283998c2063700a106445b0ee01026ef1646846',
        68272,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e7ff920f7fc51abf852aa8f0520f6244603c3219eb9b5a53a26c2d0888a4ee1c',
        68328,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '57ae750ffe381af308ebbeedbed354a9b8e2734c3390ebe7b3e681bce7a1dc74',
        68220,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3b170032fc312d04ceba035fdced21557c108e4d0c97cfe7b17094a3d4e22437',
        68256,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '420dd8a90262bbae2f4f0638299fe077005ae232cbae9b0aaef7dabbe8dfb60e',
        68052,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlumniSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alumni Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alumni+Sans
  static TextTheme alumniSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.alumniSans(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.alumniSans(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.alumniSans(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.alumniSans(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.alumniSans(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.alumniSans(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.alumniSans(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.alumniSans(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.alumniSans(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.alumniSans(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.alumniSans(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.alumniSans(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.alumniSans(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.alumniSans(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.alumniSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alumni Sans Inline One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alumni+Sans+Inline+One
  static TextStyle alumniSansInlineOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4650c5bf3131ed0fb46502f58edbf6022ac283a93a76142a4e939bcf13eb0292',
        72184,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c34244c2705ebbb7dc5cccb65bc25edf97bd2bc3cc4c019697583e7c23be2609',
        76124,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlumniSansInlineOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alumni Sans Inline One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alumni+Sans+Inline+One
  static TextTheme alumniSansInlineOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.alumniSansInlineOne(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.alumniSansInlineOne(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.alumniSansInlineOne(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.alumniSansInlineOne(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.alumniSansInlineOne(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.alumniSansInlineOne(textStyle: textTheme.headlineSmall),
      titleLarge:
          GoogleFonts.alumniSansInlineOne(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.alumniSansInlineOne(textStyle: textTheme.titleMedium),
      titleSmall:
          GoogleFonts.alumniSansInlineOne(textStyle: textTheme.titleSmall),
      bodyLarge:
          GoogleFonts.alumniSansInlineOne(textStyle: textTheme.bodyLarge),
      bodyMedium:
          GoogleFonts.alumniSansInlineOne(textStyle: textTheme.bodyMedium),
      bodySmall:
          GoogleFonts.alumniSansInlineOne(textStyle: textTheme.bodySmall),
      labelLarge:
          GoogleFonts.alumniSansInlineOne(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.alumniSansInlineOne(textStyle: textTheme.labelMedium),
      labelSmall:
          GoogleFonts.alumniSansInlineOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Amarante font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amarante
  static TextStyle amarante({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '890ec741bd034fc3d5439728b4913144c2365b222041b797979ae9f95b4b4914',
        69428,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Amarante',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Amarante font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amarante
  static TextTheme amaranteTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.amarante(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.amarante(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.amarante(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.amarante(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.amarante(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.amarante(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.amarante(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.amarante(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.amarante(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.amarante(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.amarante(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.amarante(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.amarante(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.amarante(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.amarante(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Amaranth font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amaranth
  static TextStyle amaranth({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3686273f732592e770fead7f911c7d7a8f281e98c325dbf7fccddd3da291aa62',
        41744,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3c6a40add2c4b1adc53423a1cf451bdfa8e293d34ba6c9e46cb61591fa434140',
        46900,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '37bf53dc84920307ac64820d8a30124f16c8b56f72082e6c5accf66fdb6267ab',
        41216,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9a21fadfc70d4e1272aee014ef3fcf8829c70c5c96324492b3e7f93bcaf62502',
        46680,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Amaranth',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Amaranth font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amaranth
  static TextTheme amaranthTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.amaranth(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.amaranth(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.amaranth(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.amaranth(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.amaranth(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.amaranth(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.amaranth(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.amaranth(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.amaranth(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.amaranth(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.amaranth(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.amaranth(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.amaranth(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.amaranth(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.amaranth(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Amatic SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amatic+SC
  static TextStyle amaticSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0aa2708434e42321de8ebdee7c28337f11f8a72dbaefaf3e8b74d8b73898b934',
        103564,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '702ee59e1cf56041e86b1611f4ff6572688b94c9e227aca589b5cdbaf7d347d1',
        101212,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AmaticSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Amatic SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amatic+SC
  static TextTheme amaticScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.amaticSc(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.amaticSc(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.amaticSc(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.amaticSc(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.amaticSc(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.amaticSc(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.amaticSc(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.amaticSc(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.amaticSc(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.amaticSc(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.amaticSc(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.amaticSc(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.amaticSc(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.amaticSc(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.amaticSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Amethysta font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amethysta
  static TextStyle amethysta({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cdc0246bf774ad00a0c305ed9853782f799293cfff59e08f7b38c5f156f3726b',
        20232,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Amethysta',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Amethysta font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amethysta
  static TextTheme amethystaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.amethysta(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.amethysta(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.amethysta(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.amethysta(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.amethysta(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.amethysta(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.amethysta(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.amethysta(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.amethysta(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.amethysta(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.amethysta(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.amethysta(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.amethysta(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.amethysta(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.amethysta(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Amiko font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amiko
  static TextStyle amiko({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b3e56ced59b11ce9474df6f7ba4315fc04083bbbd39ac720e9f14d842fab3b78',
        122308,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '223ae4f44ff22c32095018b5df4ec7fc3f9800d1860964812fe19ac3e3682d82',
        121800,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e59c0515a445bb871d186032eb247daa110f70c4baba542544c9378a593ca41d',
        121316,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Amiko',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Amiko font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amiko
  static TextTheme amikoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.amiko(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.amiko(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.amiko(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.amiko(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.amiko(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.amiko(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.amiko(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.amiko(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.amiko(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.amiko(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.amiko(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.amiko(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.amiko(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.amiko(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.amiko(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Amiri font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amiri
  static TextStyle amiri({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '94e0eefe1701e8e7e725071a6fddcbf4ad3db7b6a81557b52e5dc110f73f64bb',
        502076,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0cdc35dc33c636c6dd32d4144a7674a47194919c3da4235f4256597c1e0e7a38',
        504772,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2cacd7e67fa2073de1a836f9f59c5385e0ca95ae2bf0ef53b7b4531f399cfec6',
        479572,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3118590daa6dc7d8977001327578bced97a51695b81f54a543fd66abcb2f9e89',
        479576,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Amiri',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Amiri font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amiri
  static TextTheme amiriTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.amiri(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.amiri(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.amiri(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.amiri(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.amiri(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.amiri(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.amiri(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.amiri(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.amiri(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.amiri(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.amiri(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.amiri(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.amiri(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.amiri(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.amiri(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Amita font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amita
  static TextStyle amita({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3cc2396707f06b62198d8e4411f1a7cef80227e98718887369fd879715fcb58f',
        132428,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd73a96ce44869b2d166232e154d0c96cbf8de8ec3581d38fa8f3d5f0b407dd64',
        132364,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Amita',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Amita font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amita
  static TextTheme amitaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.amita(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.amita(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.amita(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.amita(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.amita(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.amita(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.amita(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.amita(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.amita(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.amita(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.amita(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.amita(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.amita(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.amita(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.amita(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Anaheim font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anaheim
  static TextStyle anaheim({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5f20dc30b8de25a3b4110660e82f540abb5e93fcb0a316430d07a0c0fb2a65da',
        25804,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Anaheim',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anaheim font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anaheim
  static TextTheme anaheimTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.anaheim(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.anaheim(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.anaheim(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.anaheim(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.anaheim(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.anaheim(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.anaheim(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.anaheim(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.anaheim(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.anaheim(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.anaheim(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.anaheim(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.anaheim(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.anaheim(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.anaheim(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Andada Pro font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Andada+Pro
  static TextStyle andadaPro({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7ed76387fc9d8338e38a60301b4eb45b6a0312aa0f0aea7f7dbb36af00ce93ec',
        91072,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '59b2abc3156af3c0b9290b80215007e5361cedd91df77af007d181f189554e7a',
        91172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7df6a3c84c9d210af208960990461be21ab58ff81eece8153c7017e9040be2ee',
        91200,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'baa2fb757366dafa8722259957a668f3d8dcd7f9da72efc64fe8740d6b6a60f7',
        91168,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '97c10f4348eac46e4413e2a06cfd708f1e681ef0ab4ff58953df4d5f5eb7cc41',
        91236,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '52fe324b4b0e03e8955414d84f932a2303cd8d4ed4e8dd4e634e95fedcd82067',
        89836,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9a87f6de59cb013572282fa45df1ba695f7070fbdfc7eff33c6a85fd66b5ca5e',
        89908,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3dad17cd3fa0d44dd7a7948f8d73739ee109cd70a505d9be31bfeef60d072d6e',
        89916,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4e93af0d8bcc75c67660fbdf94f50eaeb7ff456488e3d4dd20469cc8697ee86f',
        89848,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd8d922389d2631a5f89ec0fefde3f9bb68ed681a1e2d2341e7b4c4567bd11b35',
        89896,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AndadaPro',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Andada Pro font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Andada+Pro
  static TextTheme andadaProTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.andadaPro(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.andadaPro(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.andadaPro(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.andadaPro(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.andadaPro(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.andadaPro(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.andadaPro(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.andadaPro(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.andadaPro(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.andadaPro(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.andadaPro(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.andadaPro(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.andadaPro(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.andadaPro(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.andadaPro(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Andika font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Andika
  static TextStyle andika({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '556e05f5095a90b8ef1036c6456df0bba6939f9da1b79c7111b5fd8a3ee2e752',
        279176,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Andika',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Andika font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Andika
  static TextTheme andikaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.andika(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.andika(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.andika(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.andika(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.andika(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.andika(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.andika(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.andika(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.andika(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.andika(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.andika(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.andika(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.andika(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.andika(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.andika(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Andika New Basic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Andika+New+Basic
  static TextStyle andikaNewBasic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f9f6e1386a0bb2f5578fab759e4e52de14cda9ec45803beb74551da95a945588',
        71420,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '27524004e6bfb54a0402e3475eba79935dbfd1ab9775535d57dcce3942bb0d9f',
        75508,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ca01dd4c7f243312a5c07cd6f83e8ab97ab0d6378d464fc14fcb0f56a29fcae6',
        72220,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a0b7929093205c73ee52461fcb5ae4d0b2ce0bcedb3e99adee8d3a4fbfa1d938',
        76148,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AndikaNewBasic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Andika New Basic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Andika+New+Basic
  static TextTheme andikaNewBasicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.andikaNewBasic(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.andikaNewBasic(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.andikaNewBasic(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.andikaNewBasic(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.andikaNewBasic(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.andikaNewBasic(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.andikaNewBasic(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.andikaNewBasic(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.andikaNewBasic(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.andikaNewBasic(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.andikaNewBasic(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.andikaNewBasic(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.andikaNewBasic(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.andikaNewBasic(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.andikaNewBasic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Anek Bangla font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Bangla
  static TextStyle anekBangla({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6455b078dd714e60a2103ac412a7aa3eaaa8d95e30c516d6a11a87c039aee9a8',
        240616,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '041269d8ef9f1b418fbf512b0dddcc6339c679cda41f767f9534968da589207d',
        241800,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '53a3e15542c76b1844e861328ffa30a56be07e33129e52ecc275ab6115bf8271',
        241960,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '42aeabd3a97822fee9a0a73e63d4d14eb20f4d3edd39f216ab2cf39cfdc2f91e',
        242448,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '301f75b64f1b6f58916ad9f8eea989887f3388201ee2601f40ba3b88de452837',
        242424,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd16846288947c9a7b52ac94489606db6bbbe16b1ecde035242861eed067cbfa9',
        242896,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b63abf024d395b295279513a391f639019d65e54d16ba0bc02afb96a99e4a14d',
        244416,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a0d7a991eca0307770391d3219b8970bfca5df7d915ab72d4d00a717d5047d75',
        244952,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnekBangla',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anek Bangla font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Bangla
  static TextTheme anekBanglaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.anekBangla(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.anekBangla(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.anekBangla(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.anekBangla(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.anekBangla(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.anekBangla(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.anekBangla(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.anekBangla(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.anekBangla(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.anekBangla(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.anekBangla(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.anekBangla(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.anekBangla(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.anekBangla(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.anekBangla(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Anek Devanagari font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Devanagari
  static TextStyle anekDevanagari({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9e96cd79f0280dca569616fc2cf227c0f982f1d9418ab4d4391f7d8f96e42ad4',
        405624,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8086b706c1f4ff2b7ec874311b64ba4b7d6b1890471288ebc8a61e733fe74f6a',
        406324,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '12cb36add8b4eb9e49e5e9a99a2e9d632b30111f872b782392e254394e9921f0',
        406816,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'adecfb756e79101ec5a89f85578a804d29ffcd4dd9ae497109ef7920c29305b5',
        407600,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fec8b010dc4f0837cf81c54150bffe0d1007aef4054b448149a19eb6b0a42fb9',
        407676,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b31e3e1d26d176caca25576a4785d9b30183f64447e7a821ff3ead83a019802d',
        408484,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3d231d3632424736aeec78a8d81351d6b3bd2e3ee0eccd761cab1e42585cf405',
        411792,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8facec0f0ba24568c86e3188b99d4eadf54b456bfda22127784a411777925508',
        413100,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnekDevanagari',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anek Devanagari font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Devanagari
  static TextTheme anekDevanagariTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.anekDevanagari(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.anekDevanagari(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.anekDevanagari(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.anekDevanagari(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.anekDevanagari(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.anekDevanagari(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.anekDevanagari(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.anekDevanagari(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.anekDevanagari(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.anekDevanagari(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.anekDevanagari(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.anekDevanagari(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.anekDevanagari(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.anekDevanagari(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.anekDevanagari(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Anek Gujarati font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Gujarati
  static TextStyle anekGujarati({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '653fc93a3651b096923afef8ffea8975e227b12cf92ee83400342c73b2630491',
        285252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4fc887db39cbabfde2138b82ab2b75d7460169fa121443d4b12149fd7daf515c',
        286376,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '29af91bf0c44de20b77edf911128cd46ce7dc4be456961cc0c3573e8dd806180',
        286284,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '270583640d25d90c2d7d8b85ae002178b0fc9ef816c6274597e0204bd4d38c2e',
        286540,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'af14d3c9bddfc7d995b20af53528bbd891b75677da387a0f74ada7b3df07000a',
        286488,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fd035fbc1e4f62e9722068d20a5a83f5c527579c82e0b23742d221354ce2e4f5',
        288148,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '27d5cc6fa8ee0e61d167c534ad6c872ab699bdb25a23937a3c0394b0b78280b6',
        290120,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1ff9e9a9aa27da9cb6ff222d1ff4f9be3b7389ca8bbe0f88dfc32bf99e905848',
        291872,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnekGujarati',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anek Gujarati font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Gujarati
  static TextTheme anekGujaratiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.anekGujarati(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.anekGujarati(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.anekGujarati(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.anekGujarati(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.anekGujarati(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.anekGujarati(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.anekGujarati(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.anekGujarati(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.anekGujarati(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.anekGujarati(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.anekGujarati(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.anekGujarati(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.anekGujarati(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.anekGujarati(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.anekGujarati(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Anek Gurmukhi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Gurmukhi
  static TextStyle anekGurmukhi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '014322de59730e3d12b9442f0bf10348f736f93005d46b219863bafd1696598a',
        83456,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '723ad2027e4f39c01bdf6e1963d4ec76832941dd00bcb230bd81a44c893994ed',
        83696,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '53507088ea3e9a3cbfad8f2a929af23cca1921907affde0c68e79d8eece4c420',
        83696,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd9989e354dc5af038fc1bb5ac39f7ccf2d3c711a4676e46d57374b22eb52ec1c',
        83796,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '418301d843c68842c0befd081de01c5a4cb6010794d1b7dcbb3029900efb32c1',
        83724,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5d3ec79f790f398317262043ddd7e782e068f0e63a9e4bbcb4c9758fe4ea6e7a',
        83984,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '864d447cfb0820822f6fe3b6ff4a010e27de5dc289d5f9ec59aa4479b7955b21',
        84128,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a437b31b9f55468ab365b5e999d7c95e2f080acfdf878c3dff41fa438c64b10f',
        84528,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnekGurmukhi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anek Gurmukhi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Gurmukhi
  static TextTheme anekGurmukhiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.anekGurmukhi(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.anekGurmukhi(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.anekGurmukhi(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.anekGurmukhi(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.anekGurmukhi(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.anekGurmukhi(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.anekGurmukhi(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.anekGurmukhi(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.anekGurmukhi(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.anekGurmukhi(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.anekGurmukhi(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.anekGurmukhi(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.anekGurmukhi(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.anekGurmukhi(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.anekGurmukhi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Anek Kannada font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Kannada
  static TextStyle anekKannada({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cbdb765d6ce2d76ed3d8a32147ce246002cdbdd994922203dfe8cd02002ded71',
        240420,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5fd6af96d09582b426d77c4d97023741adc48a6eb6c99521b22dcf4634e5da42',
        243224,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '59721a98662fa2d522442931784d99acfb02382bafd3f5d335a749c811d0c0b2',
        243348,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3c5ecd78bd780b04aab86469b742c98ade0ad54401631866d29ad1a8c31f24c6',
        243676,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8865067afb93b6f8b528b966a18128c51fa63e20b1606219fa2796f5b22e84da',
        243840,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e4422ff46c7c3309f5fcc9c931ab90afcc10622da4df222fa431f5a9a6c2491c',
        245148,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3e0da0d8eadc2e067cc1ab241fd69346b695713c20bc83cad96947dad064f79e',
        246408,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b3353c97924b1c7b13ac33f5c4468be9d68406f87dba6991444fd45ec2e6795a',
        247240,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnekKannada',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anek Kannada font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Kannada
  static TextTheme anekKannadaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.anekKannada(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.anekKannada(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.anekKannada(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.anekKannada(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.anekKannada(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.anekKannada(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.anekKannada(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.anekKannada(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.anekKannada(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.anekKannada(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.anekKannada(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.anekKannada(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.anekKannada(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.anekKannada(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.anekKannada(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Anek Latin font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Latin
  static TextStyle anekLatin({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '83dd13ceb0e83df05b30bd183b07776522637eb617cd582f00882bcca9acb0a8',
        104136,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'efbdd1ff42ce3131e5cdab2a7f37d71b34f62706958aaf80d93d1975d5fbce22',
        104848,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '64b303bfca96dd6057e52c58ba45a7f1ed769b94cd19ee2b80c58affbff59a74',
        105012,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0872373646ec03d54e18b32177385f1a0b3198b656ef0296425d641bb219ef26',
        104996,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e81f0d3f34c51414d85c40a15607792fa7d96bc85ea617c84cee61e0215fc32a',
        104928,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6dd168ac9eaf1c41feab80e6d29524b12d20477234f389aecaaa6e18d1df6353',
        105276,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '722325277bb27f10e0ba171858ec2e0831cd28a1f0616d604713c3c33911b561',
        105448,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '39e843231a2673fe9ecce47d2bc5c0bd8ec939fdc1631a403018f7fcda6f74ce',
        105388,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnekLatin',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anek Latin font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Latin
  static TextTheme anekLatinTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.anekLatin(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.anekLatin(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.anekLatin(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.anekLatin(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.anekLatin(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.anekLatin(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.anekLatin(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.anekLatin(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.anekLatin(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.anekLatin(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.anekLatin(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.anekLatin(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.anekLatin(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.anekLatin(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.anekLatin(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Anek Malayalam font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Malayalam
  static TextStyle anekMalayalam({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0d140e6538f8198bfcd16fb263da386145f36f35271b6641d028c2db988bcf26',
        113092,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cd443e79b375a8e56579fffb53ce45252c69dce6ccd4d078a7c7a313603b32e9',
        113400,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '349e2a4964cec452a67cf95d193893816c9d9c7eb758a7808bc0e47f432614a2',
        113448,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '43ea67481fdaadd2fcea721dabd312aacb2f159ba744bf9d6efdc4cb46bcade6',
        113408,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '61eda5b1403bdf7a69f1d5fdffe5e9cfc41bb182902f49863c46d84f5f303586',
        113416,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '832dd1257256aabbf6fb41a3f0eaf3c1ed4b7b6b536c07fce3e37b2817d93d0c',
        113624,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '99b255032b28c03704f538b99ffaa2270349b4444e603f0bf9a30d066be0f6a7',
        114300,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '371536637bef21ccb1be6938287068f0a45f8a834394e1f35ebe5ef7a5515c30',
        114624,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnekMalayalam',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anek Malayalam font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Malayalam
  static TextTheme anekMalayalamTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.anekMalayalam(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.anekMalayalam(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.anekMalayalam(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.anekMalayalam(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.anekMalayalam(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.anekMalayalam(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.anekMalayalam(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.anekMalayalam(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.anekMalayalam(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.anekMalayalam(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.anekMalayalam(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.anekMalayalam(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.anekMalayalam(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.anekMalayalam(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.anekMalayalam(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Anek Odia font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Odia
  static TextStyle anekOdia({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f9c73cc1c0961948edc945710754a5f25b827d533608b0c991e7147f435e58fa',
        163076,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f9d05b440e2b0ab06ef17c3c907d698a1496ab2fb23091664cd7760f387feba1',
        164188,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3960965bc3e8fcda512686d6b43b0ee4790373e4f9c8636f1bec5d88e3857904',
        164320,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3a8003cd28be356ef4cf7f4c342156f326462fb6a26d959a3eb78acc2f582642',
        164268,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0a55f08d270dc081f8af2b074f4dde3ffcd799d462d09e2456d2377dcc1a9d06',
        164148,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '35207eaa8c5ff3c387fdfd2311e1e477c7985925c4bfb824f41743f260afe78c',
        164464,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1d4ee5f81efb84aa374baf875de6fc2cad7971d57cee26d2dec2c920057f1802',
        164816,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '79421e0c452ee138e78205448451ee07aa4950c789460aa358cc96ffbdb3ee6c',
        164916,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnekOdia',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anek Odia font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Odia
  static TextTheme anekOdiaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.anekOdia(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.anekOdia(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.anekOdia(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.anekOdia(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.anekOdia(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.anekOdia(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.anekOdia(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.anekOdia(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.anekOdia(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.anekOdia(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.anekOdia(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.anekOdia(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.anekOdia(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.anekOdia(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.anekOdia(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Anek Tamil font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Tamil
  static TextStyle anekTamil({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f0e7eee2c09279255c9cc328569b4c0b35c61f2e659bc370449892c197c5a433',
        133392,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '912e7d409a9bd0f08125fa1d35eb3264c57a48a885d5631e5b7bb88a2b9ea1dd',
        133924,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e1055a7f877c7f7eb23853bb047377b36b82e9a29c5f03395c91f43704c69fe4',
        133860,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '553ab108fd82a4686117d4a52cc34b9481dba103b7b8a70e9dba74bbf80231d0',
        133944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9e63be212c7c822647189da58365a5065e66864be2032be2be7f5a46b5863a9c',
        134008,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'beaa41eb70f7756d95890f6af5dd6683eb4677ed0fba4e7f4bf6281a2ecdcecb',
        134380,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '42601caea872256d2eefc997ceff2d72ee55a268167ad598d9de7c60f6476a9a',
        135360,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5bd2066079c0b327bad4dcdd6eb3a85e1a2e1ffa63fa49d951c1804a9151ca1a',
        136060,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnekTamil',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anek Tamil font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Tamil
  static TextTheme anekTamilTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.anekTamil(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.anekTamil(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.anekTamil(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.anekTamil(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.anekTamil(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.anekTamil(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.anekTamil(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.anekTamil(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.anekTamil(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.anekTamil(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.anekTamil(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.anekTamil(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.anekTamil(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.anekTamil(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.anekTamil(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Anek Telugu font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Telugu
  static TextStyle anekTelugu({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7f61f611e52113dd4e8b47e3dbcf3a70bc55546a0c611a816a4a9c3524df4640',
        306868,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '11ce76a711dacf09c5b5bc0ed18696a100ade09009a49a43138d2dbe061b9779',
        309656,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9cf22323680270dc8e8e56cfffad4cbaf9ef2edceb3b4599c4151dd323dfc99e',
        309284,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd00238b161c374a7b426c5fd58fe10991bc7a8a30c7d0e6beca8034a88e5324a',
        309392,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '59b016844619b1fc4a84d2cf40764fc6b9b99130fb4ae63e28c3a34a45abbb1b',
        309320,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5f1faabdf29886d91cd264047bd55bc2aa49de70efca60ecc23a5cbf8ee3a06a',
        310104,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e22aabef01adf18360861912baa0daf35540de8a462141506b0095839f320be0',
        311316,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '872b063e79b1ef61930c5272e99d88c5c4b5dc64f4a10b4b0dc57c8aa96763ca',
        312020,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnekTelugu',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anek Telugu font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Telugu
  static TextTheme anekTeluguTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.anekTelugu(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.anekTelugu(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.anekTelugu(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.anekTelugu(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.anekTelugu(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.anekTelugu(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.anekTelugu(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.anekTelugu(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.anekTelugu(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.anekTelugu(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.anekTelugu(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.anekTelugu(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.anekTelugu(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.anekTelugu(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.anekTelugu(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Angkor font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Angkor
  static TextStyle angkor({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd9a2d2cba1c7487e703bf379ecdce28396729e54702f9c3623c0a16cbf900154',
        38724,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Angkor',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Angkor font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Angkor
  static TextTheme angkorTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.angkor(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.angkor(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.angkor(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.angkor(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.angkor(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.angkor(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.angkor(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.angkor(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.angkor(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.angkor(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.angkor(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.angkor(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.angkor(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.angkor(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.angkor(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Annie Use Your Telescope font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Annie+Use+Your+Telescope
  static TextStyle annieUseYourTelescope({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ff1575b5a063d09826bf441c2dc27619c4187c98c907003f3cd80e546a8b6915',
        35952,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnnieUseYourTelescope',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Annie Use Your Telescope font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Annie+Use+Your+Telescope
  static TextTheme annieUseYourTelescopeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.annieUseYourTelescope(
          textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.headlineSmall),
      titleLarge:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.titleMedium),
      titleSmall:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.titleSmall),
      bodyLarge:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.bodyLarge),
      bodyMedium:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.bodyMedium),
      bodySmall:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.bodySmall),
      labelLarge:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.labelMedium),
      labelSmall:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Anonymous Pro font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anonymous+Pro
  static TextStyle anonymousPro({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '081f36c2edbd80b4a96997bdd985999dab018d0c1735edf36329ab603148258c',
        47292,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e9e045b28fc60e1f94b3a4c75009ba35d377129a7cb650621b08d2dee98429e5',
        49384,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '17ff337f134c8ac8d93bc157bd1d6b8f3f493a09bf3cb84a4c34d1824d7edde7',
        46980,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '47dfbc3cf4b4554c464c3420d6c8e42033d01450296705a5fe207287cc6afd9c',
        49108,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnonymousPro',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anonymous Pro font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anonymous+Pro
  static TextTheme anonymousProTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.anonymousPro(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.anonymousPro(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.anonymousPro(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.anonymousPro(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.anonymousPro(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.anonymousPro(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.anonymousPro(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.anonymousPro(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.anonymousPro(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.anonymousPro(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.anonymousPro(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.anonymousPro(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.anonymousPro(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.anonymousPro(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.anonymousPro(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Antic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Antic
  static TextStyle antic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b8397fbf4e6ab293dd34d5a1ae6230e13c401b9d182ca1993c4a1a6aa7410238',
        37584,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Antic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Antic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Antic
  static TextTheme anticTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.antic(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.antic(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.antic(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.antic(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.antic(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.antic(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.antic(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.antic(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.antic(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.antic(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.antic(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.antic(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.antic(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.antic(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.antic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Antic Didone font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Antic+Didone
  static TextStyle anticDidone({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e9d67d68d8e18677c34d73fe7fe4104402ad32dd69b2ffb1cc4018e5c0e791e8',
        34000,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnticDidone',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Antic Didone font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Antic+Didone
  static TextTheme anticDidoneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.anticDidone(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.anticDidone(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.anticDidone(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.anticDidone(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.anticDidone(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.anticDidone(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.anticDidone(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.anticDidone(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.anticDidone(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.anticDidone(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.anticDidone(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.anticDidone(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.anticDidone(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.anticDidone(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.anticDidone(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Antic Slab font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Antic+Slab
  static TextStyle anticSlab({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f5b8fded4efad3094f3b441a77f4ed0d70f0cb36c863a78948f418d5486a1471',
        31252,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnticSlab',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Antic Slab font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Antic+Slab
  static TextTheme anticSlabTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.anticSlab(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.anticSlab(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.anticSlab(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.anticSlab(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.anticSlab(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.anticSlab(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.anticSlab(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.anticSlab(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.anticSlab(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.anticSlab(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.anticSlab(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.anticSlab(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.anticSlab(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.anticSlab(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.anticSlab(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Anton font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anton
  static TextStyle anton({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1cac14046e308fb2d413c940504165948086c9edd4f49adfd8420e4973894989',
        87404,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Anton',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anton font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anton
  static TextTheme antonTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.anton(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.anton(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.anton(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.anton(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.anton(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.anton(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.anton(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.anton(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.anton(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.anton(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.anton(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.anton(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.anton(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.anton(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.anton(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Antonio font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Antonio
  static TextStyle antonio({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f2bbc60547e38ce844fcd3d9bf5c690c971f4c739e2e0c41b5291ec9f92ae005',
        36648,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '475bb0ff6a96f5206a5065a7f9bcf2e017f62d241e8b21a82b71944d04157479',
        36736,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6adee06cdfc62667252a4eefa2f871ba9b252a75689d0e3bb39fa2563ee214ca',
        36756,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b2ca74598fbbf95d39dc36fc609d407a535522e4f13d109603cc8da0a1507f24',
        36672,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '676fce49ff26c768e300d6a5a4a0c7a7cb2547328697b62bfa8db1b15c918a83',
        36744,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'be4f7d93bc7b1fef2b37d474153d31d89432dd362f466b0f6e950cda921430af',
        36728,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f9fdb21da349ba09252f808d3fbf36a0d3d6d84b44ec4bad78b498960b96054e',
        36760,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Antonio',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Antonio font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Antonio
  static TextTheme antonioTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.antonio(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.antonio(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.antonio(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.antonio(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.antonio(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.antonio(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.antonio(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.antonio(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.antonio(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.antonio(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.antonio(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.antonio(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.antonio(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.antonio(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.antonio(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Anybody font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anybody
  static TextStyle anybody({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'aa90b42c97f8394a0c3d4d54a4f41e680c0561c512babb4c3d3acd2842115cae',
        59092,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '98217a8194db49e2744c3de3ddd8fd315392da07506fef2e122ee731903f0cda',
        59268,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '80c0cb247fad3d95d20a970169f23ebd67d4da0c62e21d4913214d2fc1d802be',
        59364,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1721ffb0beb9f21fb3b39ed6745fdd032da40c731d780edbbcc25b15ab2384c4',
        59316,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '00e34b6ad14191ae48eb3488011ce50c17417d1ce766e04184005758cd5b918f',
        59508,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '03386bd73ac588e296b1d6ea11839a305f0ee67062bf8ea97732480433c4cb72',
        59760,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ae65f0560fb09ec7604b5d9c60df3a23ff2755f331f46e70dedaf71188a1af36',
        59744,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c3f84cc2e8c85277afcaadf75ffb6b18ce1940fdbefab8906096e72117818cde',
        60028,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5337cbdc260382f5fb963508086e112492b2612ccb05bafaab9ec9d0f1713673',
        60092,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9e288b09ed695bd1755a05d4e7bfe711201a619c3b9651ed44673c8f179675d0',
        60448,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3d8aa7dcfd25ed4b41f83544297a4ed043feec36464db5a19ea3faea76816b05',
        60700,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '587c5844786d7870c2f76f87cd8db623bcbe5af7acea3bb11be354101fbaf6c6',
        60656,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4bffecfc287c58b33bbb2bc9e6c0d31904fbacc5700a0657fe61fe3ec36118a4',
        60660,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '97f51f18b3a6fb5973ba723795256579676bd994f16db31595730e50560a4f39',
        60772,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '700f3bbdcfbbc27d775b9a6d2460d58a90e326702545884911f2d71ce29f122e',
        61064,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9108cc7f88f375dba57822d3fc8736b06f94983099f6aa403a317996add8f36e',
        61028,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '982333ed3f3c2b4387fce372129a0e48123b0b01756ecfe64e37038c7ddf2679',
        61348,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0fb80c816adfe37a93d735e737f912dcc5adfd72d344b03f45afd0a9eb5082a7',
        61300,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Anybody',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anybody font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anybody
  static TextTheme anybodyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.anybody(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.anybody(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.anybody(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.anybody(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.anybody(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.anybody(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.anybody(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.anybody(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.anybody(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.anybody(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.anybody(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.anybody(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.anybody(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.anybody(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.anybody(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Arapey font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arapey
  static TextStyle arapey({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8dcb113d8c3f16a124e56ea34d4486f28192f9eea9a0e9b86d784a332dc1dde7',
        24096,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3bf34afbf43de8a92261f42fcf6d19a0eeef2e1fae33ec84fe054c5465fd802b',
        26812,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Arapey',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arapey font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arapey
  static TextTheme arapeyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.arapey(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.arapey(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.arapey(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.arapey(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.arapey(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.arapey(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.arapey(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.arapey(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.arapey(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.arapey(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.arapey(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.arapey(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.arapey(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.arapey(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.arapey(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Arbutus font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arbutus
  static TextStyle arbutus({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ee31618abcc9f54bd2df9278b59d54f3d7b78fdcce78392dfcdca21e1ba91a05',
        78780,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Arbutus',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arbutus font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arbutus
  static TextTheme arbutusTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.arbutus(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.arbutus(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.arbutus(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.arbutus(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.arbutus(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.arbutus(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.arbutus(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.arbutus(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.arbutus(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.arbutus(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.arbutus(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.arbutus(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.arbutus(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.arbutus(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.arbutus(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Arbutus Slab font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arbutus+Slab
  static TextStyle arbutusSlab({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '04431538aed147aa226942f7676d1d7c0ec00b5de643a138cdf981e387f8296c',
        36956,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ArbutusSlab',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arbutus Slab font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arbutus+Slab
  static TextTheme arbutusSlabTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.arbutusSlab(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.arbutusSlab(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.arbutusSlab(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.arbutusSlab(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.arbutusSlab(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.arbutusSlab(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.arbutusSlab(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.arbutusSlab(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.arbutusSlab(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.arbutusSlab(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.arbutusSlab(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.arbutusSlab(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.arbutusSlab(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.arbutusSlab(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.arbutusSlab(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Architects Daughter font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Architects+Daughter
  static TextStyle architectsDaughter({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '87659fc9ea9955f9b1fd8cf5cd2f5282c8ed2783cd6e720f958dd37a6a920fc4',
        28660,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ArchitectsDaughter',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Architects Daughter font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Architects+Daughter
  static TextTheme architectsDaughterTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.architectsDaughter(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.architectsDaughter(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.architectsDaughter(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.architectsDaughter(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.architectsDaughter(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.architectsDaughter(textStyle: textTheme.headlineSmall),
      titleLarge:
          GoogleFonts.architectsDaughter(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.architectsDaughter(textStyle: textTheme.titleMedium),
      titleSmall:
          GoogleFonts.architectsDaughter(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.architectsDaughter(textStyle: textTheme.bodyLarge),
      bodyMedium:
          GoogleFonts.architectsDaughter(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.architectsDaughter(textStyle: textTheme.bodySmall),
      labelLarge:
          GoogleFonts.architectsDaughter(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.architectsDaughter(textStyle: textTheme.labelMedium),
      labelSmall:
          GoogleFonts.architectsDaughter(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Archivo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Archivo
  static TextStyle archivo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '668512388452032c9a624edfd79bc4622ebfc98373678658c9c799be5a535b9d',
        111924,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '02d40875d852fc5cf43f42e0d33331ffce56707586841d33aab3c619beb20666',
        112024,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f493e569c29151439304990a275a83eb71fe3e13e08f1124f0eb856e9ea67e48',
        112024,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd989979cb9bdb7572414ca4b91597d9601f9a084b024eff41f7d7f8e598d7596',
        112036,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '20af5b7d0edb9a99f5031e33e029f5be8b5c65b8e0270a78f621b4dd1e56f60a',
        112116,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a27129808e034b7a07ba521c636c4093663c6b5030343692d32dd5a8bebf1eca',
        111852,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2aa9975741dd5a04b80b2527395c40ae8b0a7a50324c58322a9f580428249faf',
        111928,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9700c0042ac085118319a5dd4c8b6385f88dffa711d82df44c66daad6614d7af',
        111928,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cc4034e25974c6ed79433014b5d77443cf9e5ed5b39f822e7b1e39b2df7a1912',
        111284,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f02a73c10f438f4e75f763e6678f0cf8dcab5856bf1aae06fbb5f749c6b65d77',
        123560,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'bab1fea3c2ae6ea61dc392d4844c9a17184344bba3b45436c0594bddd7dff2f6',
        123660,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '883359a1215bef8d63aa5c944fc9b8a8c463df2ac163118dad57fd4ca4808bf9',
        123540,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0d59fd4d2cbd307c6a919f247efc722551e25231dcf914fda4b8955ef0639ed7',
        123400,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4c380328303da05c4e0341ab47a62d0d8e6c3732a1a887cbb6fb497a321d83d9',
        123484,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '124f26cfe4c3090f0798b869d505b0d28209c805071695e75f8a40ab955a0fb2',
        123348,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '046212e2810a3fe7904e5d39975108c64ef5f61ca4604b0c5909e05d1aad5c4f',
        123324,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8b0f55fb9deca56dd40dcd9ccfaf72bf5e53d02d7185f5d9c5498fa006420743',
        123612,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '03fd8816f8723b92ec62ed650ab9a1c98fdda13696cbe451c551fd0634aabf7f',
        123296,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Archivo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Archivo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Archivo
  static TextTheme archivoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.archivo(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.archivo(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.archivo(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.archivo(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.archivo(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.archivo(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.archivo(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.archivo(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.archivo(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.archivo(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.archivo(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.archivo(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.archivo(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.archivo(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.archivo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Archivo Black font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Archivo+Black
  static TextStyle archivoBlack({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cb9584812618e21cc2f47b20558d7de558b494bb64d9623415cf292feb6d1c85',
        44844,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ArchivoBlack',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Archivo Black font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Archivo+Black
  static TextTheme archivoBlackTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.archivoBlack(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.archivoBlack(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.archivoBlack(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.archivoBlack(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.archivoBlack(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.archivoBlack(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.archivoBlack(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.archivoBlack(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.archivoBlack(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.archivoBlack(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.archivoBlack(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.archivoBlack(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.archivoBlack(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.archivoBlack(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.archivoBlack(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Archivo Narrow font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Archivo+Narrow
  static TextStyle archivoNarrow({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4f08c066252ece67e75e48b59d0589a31e8c4628c6a5ee5423187b86963244cb',
        58072,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8461707e06f16a8996dccd7df7610fd93f5aee158aeff31504f0158af8639228',
        58476,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0e9b1298a1e3e64f3371b788fc7091d76e689ca10f483e78a5eb0be279109fc3',
        58488,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0b33c4fdee17be90200b8cce78a31d5c6dd319d34460e62cf20b356b8bde704b',
        58068,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0b83f371245fa8e34b1ca3f0ec9f045f89bdfa6d7bc4db61711e2e7672ff5ea2',
        60768,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ae7428ca3927f5c814e8cbaf7eb584d18676f3775a46cfefe7bb710525ffe875',
        61060,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '68f2bd97639d31273d98fa2c4d72ab5ff448e2728835cb73ee3f10626daeda47',
        61064,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fb339203bb5fe22f1fff668d8ff58bf0c3a0086ce5a0841d77c904a8176deeee',
        60684,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ArchivoNarrow',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Archivo Narrow font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Archivo+Narrow
  static TextTheme archivoNarrowTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.archivoNarrow(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.archivoNarrow(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.archivoNarrow(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.archivoNarrow(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.archivoNarrow(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.archivoNarrow(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.archivoNarrow(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.archivoNarrow(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.archivoNarrow(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.archivoNarrow(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.archivoNarrow(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.archivoNarrow(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.archivoNarrow(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.archivoNarrow(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.archivoNarrow(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Are You Serious font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Are+You+Serious
  static TextStyle areYouSerious({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7f5c158df53c0056890d3850938a75e61af027316853dc7eaa83dc29d32341f4',
        149320,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AreYouSerious',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Are You Serious font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Are+You+Serious
  static TextTheme areYouSeriousTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.areYouSerious(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.areYouSerious(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.areYouSerious(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.areYouSerious(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.areYouSerious(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.areYouSerious(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.areYouSerious(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.areYouSerious(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.areYouSerious(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.areYouSerious(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.areYouSerious(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.areYouSerious(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.areYouSerious(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.areYouSerious(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.areYouSerious(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Aref Ruqaa font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aref+Ruqaa
  static TextStyle arefRuqaa({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '47206330beb6bed04e32d60d16aa0a4bb870524234eb91e0b1628dc755333d1c',
        103416,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dbbb38bdcaed9a84640798c95aacfdd797c2fa3830b4fb15eaa3f55045586317',
        115420,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ArefRuqaa',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Aref Ruqaa font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aref+Ruqaa
  static TextTheme arefRuqaaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.arefRuqaa(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.arefRuqaa(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.arefRuqaa(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.arefRuqaa(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.arefRuqaa(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.arefRuqaa(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.arefRuqaa(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.arefRuqaa(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.arefRuqaa(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.arefRuqaa(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.arefRuqaa(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.arefRuqaa(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.arefRuqaa(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.arefRuqaa(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.arefRuqaa(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Arima Madurai font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arima+Madurai
  static TextStyle arimaMadurai({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8a08b5db8265f4b5daa75fbecdd4df5414f309b5e67452f8bd725f42c1200620',
        87116,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a87b0eb6c95729593340c1fa3cfbd279f271e9940696d2c605fd6528ef7c1ec6',
        87876,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f114fb9dfdb5f47ba87e34a7d9bfbf8ae802af70c46fd45a782871e6efda6174',
        88016,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ae4101536568e5bf682b019f2515eee5c0bdc86cfe8c4419a859b7ff1b2f2ace',
        88512,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8a5541253f37b14b18e88fadc5a27378379a09fd94568456d241a4456eeb71ab',
        88540,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '05716f6b04e8d338bcb66877f359054613ee72d1e35e06f95b9c4bd3c76482a4',
        88512,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1021ffc3c2b5624fc1fdf2818b20390c6745860308a0b2f7856316e97de93747',
        88488,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c3879ff66d6ee6e82740a9b921b1b51e90469ed50428b22e19f621260cd3c350',
        88516,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ArimaMadurai',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arima Madurai font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arima+Madurai
  static TextTheme arimaMaduraiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.arimaMadurai(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.arimaMadurai(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.arimaMadurai(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.arimaMadurai(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.arimaMadurai(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.arimaMadurai(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.arimaMadurai(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.arimaMadurai(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.arimaMadurai(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.arimaMadurai(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.arimaMadurai(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.arimaMadurai(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.arimaMadurai(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.arimaMadurai(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.arimaMadurai(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Arimo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arimo
  static TextStyle arimo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '02759d4a5f66450c55103d219041160aae2a704fd0ef1267d7780b7298cb987c',
        315712,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f1e452b334ef0db49d283e9eb0d0a4d29272d4c050704f9a1481f110a5860110',
        318680,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '85834b9a21db61a774d8aa819e60c26e322aca27feb8947a1f7a97bda36e8cb1',
        319672,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '71ec96ee5fc89c61e9c0a5f9caa38d5cd3225dfbd04346864799c7813542586f',
        316208,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9465b2b030f2a1953b7e8c152e4e5de99711677ecf207eb57da13f9a515d2114',
        337984,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '79a56a9b93a4d98ad5de86003f775cc4fa62f88a8a47bf1e3ce49dc7b4c5144b',
        342500,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f3e6a31b0bebb0e695b68def2f8a680699f8f5268ec68b7c32fbd0f47792862e',
        343008,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7a6891f0ed1247b534b9d3715088f22d534520430b159c06fd800a57103c853a',
        339336,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Arimo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arimo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arimo
  static TextTheme arimoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.arimo(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.arimo(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.arimo(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.arimo(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.arimo(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.arimo(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.arimo(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.arimo(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.arimo(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.arimo(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.arimo(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.arimo(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.arimo(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.arimo(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.arimo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Arizonia font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arizonia
  static TextStyle arizonia({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7cdbff2a2b1155329f26fe8a352a224277129963887327eaac835a804511ba19',
        87984,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Arizonia',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arizonia font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arizonia
  static TextTheme arizoniaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.arizonia(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.arizonia(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.arizonia(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.arizonia(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.arizonia(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.arizonia(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.arizonia(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.arizonia(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.arizonia(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.arizonia(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.arizonia(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.arizonia(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.arizonia(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.arizonia(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.arizonia(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Armata font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Armata
  static TextStyle armata({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f38d96d2dae06acedb19222a35e8865b5cc5711490ad3e86f988ef5def6fa27b',
        49964,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Armata',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Armata font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Armata
  static TextTheme armataTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.armata(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.armata(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.armata(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.armata(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.armata(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.armata(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.armata(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.armata(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.armata(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.armata(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.armata(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.armata(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.armata(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.armata(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.armata(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Arsenal font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arsenal
  static TextStyle arsenal({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b5f695f889f166bd03a347f103b3bc671e167458595c8d02994b7fa1763e3e86',
        76692,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a5f085824395aaea9d08f1baad23b3fe697f8214a27e871c4ef04df58d3559ea',
        82296,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a8ba6c5b0c941ce0588b8095560c835724c810d579d505f01e9eedf7fae53cf9',
        77208,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '56f6907247178ab293265b7dd74616db07072abca641f4a05046a57665fc0ce8',
        82340,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Arsenal',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arsenal font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arsenal
  static TextTheme arsenalTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.arsenal(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.arsenal(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.arsenal(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.arsenal(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.arsenal(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.arsenal(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.arsenal(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.arsenal(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.arsenal(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.arsenal(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.arsenal(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.arsenal(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.arsenal(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.arsenal(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.arsenal(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Artifika font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Artifika
  static TextStyle artifika({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fa267a0781f8d1430425a0fbc3f3a803dc4ce3be46e6ebb8915ea0a836e99fde',
        40396,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Artifika',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Artifika font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Artifika
  static TextTheme artifikaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.artifika(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.artifika(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.artifika(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.artifika(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.artifika(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.artifika(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.artifika(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.artifika(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.artifika(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.artifika(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.artifika(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.artifika(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.artifika(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.artifika(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.artifika(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Arvo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arvo
  static TextStyle arvo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '06604b28f68ab6bd331ce34e39d3d25e5571d234dd859a67002a03b52ff54434',
        20668,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'be30ff68b3a6569309e4cdb97520171f9c2b00644bda658aea76c6a3cd1211d0',
        21104,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4e8ee167cbaa92f9e5bd0961c8a405a38520bd3e0ac487d94ffc7122d75a98ea',
        20556,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5ead9ae374f4c2b25c767d68c772879cb84f33c5ddf213b4608c2cc7639d61ed',
        21668,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Arvo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arvo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arvo
  static TextTheme arvoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.arvo(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.arvo(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.arvo(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.arvo(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.arvo(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.arvo(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.arvo(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.arvo(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.arvo(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.arvo(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.arvo(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.arvo(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.arvo(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.arvo(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.arvo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Arya font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arya
  static TextStyle arya({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a939aada447f5c1bc764a8f9960c6424d3f38d85972df751c73e54c7362afc64',
        107792,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '00ca32f8ce8b566199068fbd0a93b788998d103f60dfe43263e2959b328245db',
        107528,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Arya',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arya font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arya
  static TextTheme aryaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.arya(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.arya(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.arya(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.arya(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.arya(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.arya(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.arya(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.arya(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.arya(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.arya(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.arya(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.arya(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.arya(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.arya(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.arya(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Asap font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asap
  static TextStyle asap({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'df4ff13dc0f2d0d8bac4699114715db118e3d4f3eed74dff66310dcb69f67b7b',
        139620,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '92444d013a70c7c3f6a4f9c53a70822bbd27058ef650fbe9bb24959ceb81d69b',
        139588,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '547be10c0d370aedc5d15297865a77a8481c9cc02f7d95044d4cdf3f0515a525',
        139580,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '50f2fda6fea472f8de069944826f08bfd970c36d5aae93da1a72df5c57ec621f',
        139292,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e7119bb02311ab53400b4447baa23f873e2719ee8494434b8c0542e89c0234a8',
        150852,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5e3e99695c0879f07155cdfa1cdae158d987f284f1cfecb9f5cbf7998f76c1f3',
        150976,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f8c4e0e3c8b4f7c3bfad148af8d26f27f41f199a19831e84beb7025d3094baaf',
        150972,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ed8b0ed2dfd585728278afe5ca0c75e07377c48eeb4fe8ddac9a5c3097cea7c0',
        150632,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Asap',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Asap font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asap
  static TextTheme asapTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.asap(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.asap(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.asap(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.asap(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.asap(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.asap(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.asap(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.asap(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.asap(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.asap(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.asap(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.asap(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.asap(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.asap(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.asap(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Asap Condensed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asap+Condensed
  static TextStyle asapCondensed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fbb71e04ad3dd6063a27eabe525162b253f3bc25cb18ad9d5b6cbf6b888c8a39',
        67440,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '96bdbe53588d00ebad14ed7a2ad9c348a4204d1975736c69e8cb7a6e6ea3fcda',
        73860,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8ef3916f8918264ae319af5a6f385d5acb3cd1bdeb29358186eb2d0e24e0bda5',
        67736,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'cb1e4acf25720442b0a6a382620be387cf6889a2446cc15c01d50a9f8fa658eb',
        74216,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2f2a6498098d7b358f9b8c6cc69dafa79864f4fbc746892a57f13d6a1cda27ed',
        68132,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '15ee44d449ba901f620ce99485c672968dd34e073b979b09a5483ef555b002b0',
        74356,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '30d86bb97fa6065d8a8b01ae728b70a43854918af75ab116b1ec2bb60bb57861',
        68220,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4909e06e95af8c3ab42dbc7b84d674426c1fafd4f8c2cc64b966302b5c062a7f',
        74288,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AsapCondensed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Asap Condensed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asap+Condensed
  static TextTheme asapCondensedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.asapCondensed(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.asapCondensed(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.asapCondensed(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.asapCondensed(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.asapCondensed(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.asapCondensed(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.asapCondensed(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.asapCondensed(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.asapCondensed(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.asapCondensed(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.asapCondensed(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.asapCondensed(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.asapCondensed(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.asapCondensed(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.asapCondensed(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Asar font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asar
  static TextStyle asar({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9f5c57c47471c19a020f356b7153fa11a8ceb320745319fd004076634bfebd4e',
        399888,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Asar',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Asar font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asar
  static TextTheme asarTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.asar(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.asar(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.asar(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.asar(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.asar(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.asar(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.asar(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.asar(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.asar(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.asar(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.asar(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.asar(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.asar(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.asar(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.asar(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Asset font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asset
  static TextStyle asset({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '590f0e7d49f7b0a93d4c0a42e85b33e1ccc03395228859ffacd9a16769817730',
        48040,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Asset',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Asset font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asset
  static TextTheme assetTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.asset(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.asset(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.asset(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.asset(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.asset(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.asset(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.asset(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.asset(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.asset(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.asset(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.asset(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.asset(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.asset(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.asset(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.asset(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Assistant font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Assistant
  static TextStyle assistant({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a6d35f2619ecda85c313c1dc2cbf05362a91bb4851f7357b081d5e4738d51592',
        47472,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'af730acece7e06c6de98758f301895fd04100a681661c74cb48f8c5441a6cc62',
        47700,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '54052d2cae49ae55ccf003afc089fa720c2df64f511d9baf9a5069f05783dd15',
        47692,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dab51754537a72ccd3dd50c4eb1a4321d64595db44e981febd7d2804d82a45b9',
        47640,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2190f8684c4e98ad2b84e3b53633bd3617c63d919427e7727678847a1b935347',
        47716,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '668ace46b4b854a9e30c6d17a6ba593026a0833dffd4bfeab6bfb0a4283d3280',
        47652,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e86801c5eac14c462f1fe66aa44faf8edc82df3cc4f4a78eb07e473e7fe53de7',
        47532,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Assistant',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Assistant font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Assistant
  static TextTheme assistantTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.assistant(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.assistant(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.assistant(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.assistant(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.assistant(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.assistant(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.assistant(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.assistant(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.assistant(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.assistant(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.assistant(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.assistant(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.assistant(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.assistant(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.assistant(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Astloch font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Astloch
  static TextStyle astloch({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a7a7c68cac2873d07058859ca8ea09c343c2d86b4856fc4228d747cc66738e71',
        49252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a5d9efacd4b695ad23eea17dc7c59305ddc3ce9db72cb9508be52cb932ea6de0',
        50852,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Astloch',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Astloch font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Astloch
  static TextTheme astlochTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.astloch(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.astloch(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.astloch(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.astloch(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.astloch(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.astloch(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.astloch(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.astloch(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.astloch(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.astloch(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.astloch(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.astloch(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.astloch(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.astloch(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.astloch(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Asul font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asul
  static TextStyle asul({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4feba4db5d8e0b1cf68e5b07dc1722f0167acd191ffb56e0ea11dea93b12dbcd',
        31008,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f94c10cb7b5ea59055ef4efe754a091874f873c8b7a82dfe3d577cdcb4939c22',
        30988,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Asul',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Asul font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asul
  static TextTheme asulTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.asul(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.asul(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.asul(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.asul(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.asul(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.asul(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.asul(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.asul(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.asul(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.asul(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.asul(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.asul(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.asul(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.asul(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.asul(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Athiti font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Athiti
  static TextStyle athiti({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '696cbfd50124dc9018b35cd34f14c2087a57e8a1a4f5b85412930f5a8b0d927d',
        96028,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bc712088d5e10d28733039df5b64a70792596852e2b3476d106d3ab0eb764c98',
        94860,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2616631b1611fdb8b7ce24b5a7ca2fcc9ed30c586f57109005e4dae361cfae1c',
        95952,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2a3112766cdc5e82e50149f5422d4e7ac6d90ba554076d429c00c361725c6c1c',
        96036,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd486640632fcfc522d9013c7ae37991f4da6fd251dfc845736f1534208999d89',
        95560,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '389e4c7f43470ba0f7a9fb90fcb73eb264aae54974e0befa5bdc6258c4fc16c9',
        96436,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Athiti',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Athiti font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Athiti
  static TextTheme athitiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.athiti(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.athiti(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.athiti(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.athiti(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.athiti(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.athiti(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.athiti(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.athiti(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.athiti(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.athiti(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.athiti(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.athiti(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.athiti(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.athiti(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.athiti(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Atkinson Hyperlegible font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Atkinson+Hyperlegible
  static TextStyle atkinsonHyperlegible({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '34cbbb160a161e76615409702bd11d517714be485035c724a5b4823609e128f3',
        35240,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'de702b1afd3d264aaff860cd5aa76e5a28a9d5d4194616f8ab58461aa732ac2e',
        35640,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd1d77f8ab92ba17799673d4b74349ec47450a40ec2e275ccfb1521e4b411808b',
        35432,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6ae3af7b85ce5c0e45767b9ba419340fe3f91c78c181b9f09c5ebca7eb6505d0',
        35960,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AtkinsonHyperlegible',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Atkinson Hyperlegible font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Atkinson+Hyperlegible
  static TextTheme atkinsonHyperlegibleTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.atkinsonHyperlegible(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.atkinsonHyperlegible(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.atkinsonHyperlegible(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.atkinsonHyperlegible(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.atkinsonHyperlegible(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.atkinsonHyperlegible(textStyle: textTheme.headlineSmall),
      titleLarge:
          GoogleFonts.atkinsonHyperlegible(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.atkinsonHyperlegible(textStyle: textTheme.titleMedium),
      titleSmall:
          GoogleFonts.atkinsonHyperlegible(textStyle: textTheme.titleSmall),
      bodyLarge:
          GoogleFonts.atkinsonHyperlegible(textStyle: textTheme.bodyLarge),
      bodyMedium:
          GoogleFonts.atkinsonHyperlegible(textStyle: textTheme.bodyMedium),
      bodySmall:
          GoogleFonts.atkinsonHyperlegible(textStyle: textTheme.bodySmall),
      labelLarge:
          GoogleFonts.atkinsonHyperlegible(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.atkinsonHyperlegible(textStyle: textTheme.labelMedium),
      labelSmall:
          GoogleFonts.atkinsonHyperlegible(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Atma font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Atma
  static TextStyle atma({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5f580b765fbc4d048fe2c3a1985ac963dedfbe786e43311d74b25cf7d6fc502e',
        189740,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eabee54d2b8466839ed36b765c7de139ee67027a27efa29a9b9e37602fb66270',
        191388,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9c76b5c9f816441315dfcb82de5ad22bb9673cd83d318032501458a5b45cc52f',
        190840,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fdcd004557ebdfffd517781fded8dc560759f5ece7d1febdad29d7ba83a108cd',
        189940,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '69c7cc1dd98eb4623cb9a51d7b7ed548bb5366508856497b089a1be242e4641b',
        186912,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Atma',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Atma font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Atma
  static TextTheme atmaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.atma(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.atma(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.atma(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.atma(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.atma(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.atma(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.atma(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.atma(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.atma(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.atma(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.atma(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.atma(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.atma(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.atma(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.atma(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Atomic Age font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Atomic+Age
  static TextStyle atomicAge({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a9f2142938d6ee0e74907390e66d9ea05265c756dc4b93fa8e81a160ca449ab1',
        40672,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AtomicAge',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Atomic Age font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Atomic+Age
  static TextTheme atomicAgeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.atomicAge(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.atomicAge(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.atomicAge(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.atomicAge(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.atomicAge(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.atomicAge(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.atomicAge(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.atomicAge(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.atomicAge(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.atomicAge(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.atomicAge(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.atomicAge(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.atomicAge(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.atomicAge(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.atomicAge(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Aubrey font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aubrey
  static TextStyle aubrey({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8ca62b5d441c31bf4bb2af48b336acbd0c109ead24d4b7dcc734c428d66b7f1a',
        32668,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Aubrey',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Aubrey font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aubrey
  static TextTheme aubreyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.aubrey(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.aubrey(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.aubrey(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.aubrey(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.aubrey(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.aubrey(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.aubrey(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.aubrey(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.aubrey(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.aubrey(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.aubrey(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.aubrey(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.aubrey(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.aubrey(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.aubrey(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Audiowide font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Audiowide
  static TextStyle audiowide({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7e9ec109a765df96029af9e206207a6c0bc739bbd1476dd01f15eb6de459b07b',
        46484,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Audiowide',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Audiowide font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Audiowide
  static TextTheme audiowideTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.audiowide(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.audiowide(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.audiowide(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.audiowide(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.audiowide(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.audiowide(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.audiowide(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.audiowide(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.audiowide(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.audiowide(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.audiowide(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.audiowide(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.audiowide(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.audiowide(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.audiowide(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Autour One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Autour+One
  static TextStyle autourOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '835e4cf3882094e87b1cc6738455d27c58666e50595b7304fe641bb9d371bddf',
        56644,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AutourOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Autour One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Autour+One
  static TextTheme autourOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.autourOne(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.autourOne(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.autourOne(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.autourOne(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.autourOne(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.autourOne(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.autourOne(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.autourOne(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.autourOne(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.autourOne(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.autourOne(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.autourOne(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.autourOne(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.autourOne(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.autourOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Average font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Average
  static TextStyle average({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '566d63002fc4b58afe36523fb27700b2f4c33105869907447703edf0e3803ecc',
        35344,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Average',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Average font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Average
  static TextTheme averageTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.average(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.average(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.average(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.average(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.average(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.average(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.average(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.average(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.average(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.average(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.average(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.average(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.average(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.average(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.average(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Average Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Average+Sans
  static TextStyle averageSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'db7e01f028c635aef313afbb32495c914fa586be304b27ef0f93996e1d861d76',
        40392,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AverageSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Average Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Average+Sans
  static TextTheme averageSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.averageSans(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.averageSans(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.averageSans(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.averageSans(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.averageSans(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.averageSans(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.averageSans(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.averageSans(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.averageSans(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.averageSans(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.averageSans(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.averageSans(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.averageSans(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.averageSans(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.averageSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Averia Gruesa Libre font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Averia+Gruesa+Libre
  static TextStyle averiaGruesaLibre({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '879c55ff64c5c857842f76d67c79f6a96ed3e5a90b4dc3bee62a508b87ce77da',
        110136,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AveriaGruesaLibre',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Averia Gruesa Libre font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Averia+Gruesa+Libre
  static TextTheme averiaGruesaLibreTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.averiaGruesaLibre(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.averiaGruesaLibre(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.averiaGruesaLibre(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.averiaGruesaLibre(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.averiaGruesaLibre(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.averiaGruesaLibre(textStyle: textTheme.headlineSmall),
      titleLarge:
          GoogleFonts.averiaGruesaLibre(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.averiaGruesaLibre(textStyle: textTheme.titleMedium),
      titleSmall:
          GoogleFonts.averiaGruesaLibre(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.averiaGruesaLibre(textStyle: textTheme.bodyLarge),
      bodyMedium:
          GoogleFonts.averiaGruesaLibre(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.averiaGruesaLibre(textStyle: textTheme.bodySmall),
      labelLarge:
          GoogleFonts.averiaGruesaLibre(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.averiaGruesaLibre(textStyle: textTheme.labelMedium),
      labelSmall:
          GoogleFonts.averiaGruesaLibre(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Averia Libre font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Averia+Libre
  static TextStyle averiaLibre({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7e7822881be83db88a6a6674b8ef18760d8fb01b44cc07898b1b686204f22c24',
        106720,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '478d586176da94e754eda5ef0481c71000c7a82be20445a3f04dbf2ecf276ba5',
        132056,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e5dbc6d83b9f1a68d3be7cc777ec96e097a2a02ae5ca2a3f18f39e720f6e379b',
        107020,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c592b4893f6fa2059fdbf44bf1a29bf18ef204851d4775bf3ec3878283c54d4e',
        127372,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '41216d0ca8e7db003bdafb5f53bd3425def86c7321217f68da77baf0feac4769',
        110832,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '20f2ca7436a510cc1acc4be8a1340bb9a981f734e07ae1049d66c576d3112871',
        134260,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AveriaLibre',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Averia Libre font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Averia+Libre
  static TextTheme averiaLibreTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.averiaLibre(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.averiaLibre(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.averiaLibre(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.averiaLibre(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.averiaLibre(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.averiaLibre(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.averiaLibre(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.averiaLibre(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.averiaLibre(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.averiaLibre(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.averiaLibre(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.averiaLibre(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.averiaLibre(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.averiaLibre(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.averiaLibre(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Averia Sans Libre font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Averia+Sans+Libre
  static TextStyle averiaSansLibre({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f43b980899fbc0ad129c49237f36a2076ad9eb2c44ed5d2a23716fd4f46fb09a',
        106264,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '813ba1a2a72ae8743892a407d7e08722e3b6bf741fb4aaff118dbbf899d00d6e',
        132696,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0c2df70769b1c1296c22f0f3662b1ab6e2ddfd965c362367520152b6b7d8d491',
        106888,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '34fe21ecb0fd3fd41b365d43957d002f9a55e235dbf6e498de79f1991fcab2a3',
        127404,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd21143e34828cbea15e0e25b4d60a1d5d54497462a6bfc593c81f47f113bb09d',
        111544,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '21d1bb981da69b3f53a010c0400d9da53258f3ee566789ced34dd4aa405462e0',
        134372,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AveriaSansLibre',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Averia Sans Libre font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Averia+Sans+Libre
  static TextTheme averiaSansLibreTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.averiaSansLibre(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.averiaSansLibre(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.averiaSansLibre(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.averiaSansLibre(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.averiaSansLibre(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.averiaSansLibre(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.averiaSansLibre(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.averiaSansLibre(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.averiaSansLibre(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.averiaSansLibre(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.averiaSansLibre(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.averiaSansLibre(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.averiaSansLibre(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.averiaSansLibre(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.averiaSansLibre(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Averia Serif Libre font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Averia+Serif+Libre
  static TextStyle averiaSerifLibre({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd3a467f0e37820449e1475e6383de9c38241c60381309645688c3ba3557b502a',
        108484,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '45c314aaa2c85ba19ad5a3f9ac64410a7db1b583780387869df22b1c3e387777',
        134468,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b4488ef076b0b60a6ed348d12a5ee756214a3cc9e37832056a75f719ea90cb7e',
        108508,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c70379414feb6e1da3ea3d5f3d93bcc16459abc62ae2954246a5e9437aadd4e9',
        129480,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '62f7ac807e87023da6b428ceb6c9fbbf59117d77ae1805975a74e6d904953d0a',
        112472,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '99c96dec4d9ce146602048e4c0c532937c6b75678d8317e6221f510a78cec9a0',
        136700,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AveriaSerifLibre',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Averia Serif Libre font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Averia+Serif+Libre
  static TextTheme averiaSerifLibreTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.averiaSerifLibre(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.averiaSerifLibre(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.averiaSerifLibre(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.averiaSerifLibre(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.averiaSerifLibre(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.averiaSerifLibre(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.averiaSerifLibre(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.averiaSerifLibre(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.averiaSerifLibre(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.averiaSerifLibre(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.averiaSerifLibre(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.averiaSerifLibre(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.averiaSerifLibre(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.averiaSerifLibre(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.averiaSerifLibre(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Azeret Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Azeret+Mono
  static TextStyle azeretMono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '17eadd900e8697179e86daa8727665092ebec16832f9ee199de8b8e54fda5aa7',
        36332,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3fbb2b6e56d74da49cd1b04d6ed9cfc80aaa81561b455427db77b7b1a12759b4',
        36372,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a3d65bcd9f306acf8c3744450b92f85380524a8dfa9b586dcccf56eb1c400c1d',
        36288,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '966e02b75e7454d55d4b1a2974a330c2b76779ccba8f6d684d848de14dce93ce',
        36248,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '03fda14a0ebe8a246f3f9521b14c6a9a91dc70f72072d4b746308def23eec808',
        36312,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd729517045d72ae5a8787d73efb2290c35d850c6729525a10d485421cc057889',
        36188,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd04e67b0254378c3a21eb212f76251a059f22b5e23d47f38c4e1d1187fe8919a',
        36100,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '54e96a6c30b11221465bf0071fbd2d431b9053cd1aceae988b3ab0edf7f5bcaa',
        36272,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8067b9c0891f914b2e18396d78759a447a7f05e9e9962bfcced62c5ac17451f6',
        36320,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'bb9d34f997abe93294bac0aeb7f3a3a0890ddc714764ec04efacb5dd4d3ad804',
        37464,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ae97ba631af094633e309222572eac2797a918e9b915b16b00fb951079f2e88b',
        37556,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8f8e6637fa70bd1135e9a8a8e948df66e815acbaa4bb7276e7d11b299ec8070f',
        37448,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '296c839ed98ffa90d3501f16cbda77bbfc970812fd973684ca4e9d810d96935e',
        37344,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1617eb8b69ff5da2019ed9928aa01fe94ecd8772c4c74142f5cdffbd85113482',
        37496,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '91ddb90e7301d3c70287c8c2e8aa1e78e0abe3a98885fe318d7a64c4cbf4be5d',
        37464,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '00eb258d2de95fbe13fb792f6489d0ca99bf660874bde4af33b6fe4c225bfb41',
        37236,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd6f6f39f052a155a9dcf80659f3740a1477100fa486592f4bd51d70079cbd3fb',
        37412,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6836a6e60b3516ec45ba9a8ccb68f827c2ec3880feaaa71d6258aa021eaf63ae',
        37468,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AzeretMono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Azeret Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Azeret+Mono
  static TextTheme azeretMonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.azeretMono(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.azeretMono(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.azeretMono(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.azeretMono(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.azeretMono(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.azeretMono(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.azeretMono(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.azeretMono(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.azeretMono(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.azeretMono(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.azeretMono(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.azeretMono(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.azeretMono(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.azeretMono(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.azeretMono(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the B612 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/B612
  static TextStyle b612({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4d0347457a725a93a2de2b562174a4b53958bc94347bce5dadf7c220d4d18742',
        89040,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'aec7755bb68cd9fe7939fe6a51bb5a19fb8328a23038e03476d09e62c1acc917',
        92724,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2585f7be03fe5213564bf53b9cafc085be0080aead7fc2c19224098f7b595309',
        88692,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '23dc0ce0dd72a74b7beda1106ffd47f011134d17ef56a5009c64005c7d81c90d',
        91732,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'B612',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the B612 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/B612
  static TextTheme b612TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.b612(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.b612(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.b612(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.b612(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.b612(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.b612(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.b612(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.b612(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.b612(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.b612(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.b612(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.b612(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.b612(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.b612(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.b612(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the B612 Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/B612+Mono
  static TextStyle b612Mono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '935a9de8c5697c8c22fc2e56c14db9d801f38264e677aa95a9b8c89698f60db7',
        86192,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3c02e7bb121c758ae4fe699a54db9ef5f1ae2cd310f0d838f307961db5205c15',
        88680,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f338ed1e45a339fab8ddcd7d8a593d155a270679757aa775d906b77d0331dd56',
        85168,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b405e3bda420eb48b4b1eb6570ee6c69bf93e31fa6089c9d6a6561fbedb662d9',
        87484,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'B612Mono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the B612 Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/B612+Mono
  static TextTheme b612MonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.b612Mono(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.b612Mono(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.b612Mono(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.b612Mono(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.b612Mono(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.b612Mono(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.b612Mono(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.b612Mono(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.b612Mono(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.b612Mono(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.b612Mono(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.b612Mono(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.b612Mono(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.b612Mono(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.b612Mono(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the BIZ UDGothic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BIZ+UDGothic
  static TextStyle bizUDGothic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5dd746204013e82a5744526c9461fda5a807d03f09db5cb2ec8a9e5bb83d72f0',
        3449768,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a9cc8decefdfaaef2b97547ef53b3542a9e9af6b1eb30b9cda8ea43fe72de2fc',
        3434196,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BIZUDGothic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the BIZ UDGothic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BIZ+UDGothic
  static TextTheme bizUDGothicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bizUDGothic(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.bizUDGothic(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bizUDGothic(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.bizUDGothic(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bizUDGothic(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.bizUDGothic(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bizUDGothic(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bizUDGothic(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bizUDGothic(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bizUDGothic(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bizUDGothic(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bizUDGothic(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bizUDGothic(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bizUDGothic(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bizUDGothic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the BIZ UDMincho font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BIZ+UDMincho
  static TextStyle bizUDMincho({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c130db40f3000821ddef558cfd648c685413fbe18a297e4d3451a5ed3d66e607',
        4827492,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BIZUDMincho',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the BIZ UDMincho font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BIZ+UDMincho
  static TextTheme bizUDMinchoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bizUDMincho(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.bizUDMincho(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bizUDMincho(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.bizUDMincho(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bizUDMincho(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.bizUDMincho(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bizUDMincho(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bizUDMincho(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bizUDMincho(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bizUDMincho(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bizUDMincho(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bizUDMincho(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bizUDMincho(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bizUDMincho(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bizUDMincho(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the BIZ UDPGothic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BIZ+UDPGothic
  static TextStyle bizUDPGothic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6a248748cad1575c05e3b9a47683306315ba40eeb095082b60d9b7f8f1589b61',
        3495428,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2bbb34a980dfd7efd8ab64e337ee84ca0a8f26ac9cb5113028e9b1ce90fa7519',
        3479404,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BIZUDPGothic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the BIZ UDPGothic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BIZ+UDPGothic
  static TextTheme bizUDPGothicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bizUDPGothic(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.bizUDPGothic(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bizUDPGothic(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.bizUDPGothic(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bizUDPGothic(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.bizUDPGothic(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bizUDPGothic(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bizUDPGothic(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bizUDPGothic(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bizUDPGothic(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bizUDPGothic(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bizUDPGothic(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bizUDPGothic(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bizUDPGothic(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bizUDPGothic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the BIZ UDPMincho font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BIZ+UDPMincho
  static TextStyle bizUDPMincho({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7165695407cdb0b818e61e0718d01a2cfb9002f0bde185d4350899b3d861126d',
        4900008,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BIZUDPMincho',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the BIZ UDPMincho font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BIZ+UDPMincho
  static TextTheme bizUDPMinchoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bizUDPMincho(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.bizUDPMincho(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bizUDPMincho(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.bizUDPMincho(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bizUDPMincho(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.bizUDPMincho(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bizUDPMincho(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bizUDPMincho(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bizUDPMincho(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bizUDPMincho(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bizUDPMincho(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bizUDPMincho(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bizUDPMincho(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bizUDPMincho(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bizUDPMincho(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Babylonica font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Babylonica
  static TextStyle babylonica({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '75ec9d48dc4312873b400a3a00a1d2ec7c06f917423ecff9d08400ad7197df19',
        333852,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Babylonica',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Babylonica font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Babylonica
  static TextTheme babylonicaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.babylonica(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.babylonica(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.babylonica(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.babylonica(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.babylonica(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.babylonica(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.babylonica(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.babylonica(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.babylonica(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.babylonica(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.babylonica(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.babylonica(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.babylonica(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.babylonica(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.babylonica(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bad Script font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bad+Script
  static TextStyle badScript({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c62d8477f536f5e0939e0a67dae8aab90bcc8d72c5fc36642a8cc668250c761b',
        50028,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BadScript',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bad Script font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bad+Script
  static TextTheme badScriptTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.badScript(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.badScript(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.badScript(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.badScript(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.badScript(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.badScript(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.badScript(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.badScript(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.badScript(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.badScript(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.badScript(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.badScript(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.badScript(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.badScript(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.badScript(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bahiana font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bahiana
  static TextStyle bahiana({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5c5521386859d5ed8cd450a36fc6a896f8c2e9f86f48f4f0635d0423a2f2c1ff',
        46648,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bahiana',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bahiana font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bahiana
  static TextTheme bahianaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bahiana(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bahiana(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bahiana(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bahiana(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.bahiana(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bahiana(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bahiana(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bahiana(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bahiana(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bahiana(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bahiana(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bahiana(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bahiana(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bahiana(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bahiana(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bahianita font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bahianita
  static TextStyle bahianita({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7346dfe8cd43d5469022e346b0246d41b98dc2298755cb9405aaa417aee8817c',
        92132,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bahianita',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bahianita font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bahianita
  static TextTheme bahianitaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bahianita(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bahianita(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bahianita(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bahianita(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bahianita(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bahianita(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bahianita(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bahianita(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bahianita(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bahianita(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bahianita(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bahianita(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bahianita(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bahianita(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bahianita(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bai Jamjuree font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bai+Jamjuree
  static TextStyle baiJamjuree({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '45ef472a0bd6f81b528804dc98f3ba4b56e789d55d793ab3b6a88a638646b28c',
        78044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '17f2cce743e3276c95ff6383c235328f5e97b8889c4d1e93a2073edcad336f82',
        83600,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '134cfc83d825085fb79694e5b4a0791a44d50367d6bfbaa0aff3cd3ea735330e',
        78384,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3e459a85b71ea5fe1a2a7779a731cb5f137f710ee70d565935001f6fbcee666a',
        83780,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '477ceaa5c1f1bbdfc31023cad25ab089ed1689737e4078f64b88141dde2874dc',
        78416,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fcc54ca860ceb502e5a24cf34c84d1f4ed451c3a60c56206115af44be3998af0',
        83856,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0d1630b17316408ccb87e59aa817256f20270197833d9fce7dc84f8fdaffe519',
        78428,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '254fc13896c665383d6192c9a5cb1efe824a2d28b0511698edb6f2befad1df31',
        83944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9c0fd790fb689c4ce76399c8f4edda636d9ecf05aafe376bdb33923444917cdd',
        78412,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3fbdadddca86a1635e36cc7bce48f51f4fbbd72c5d0c1b8e425ad2322cc14614',
        83776,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '949fc9581d9010403dfffcd8e1f13ff58ddf3a32eb5390b060081045fc31059a',
        78104,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8709e86b66d84a0be9bcb6b71d5512d832c861ba549b3678f2dca36d699d9e22',
        83360,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BaiJamjuree',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bai Jamjuree font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bai+Jamjuree
  static TextTheme baiJamjureeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.baiJamjuree(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.baiJamjuree(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.baiJamjuree(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.baiJamjuree(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.baiJamjuree(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.baiJamjuree(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.baiJamjuree(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.baiJamjuree(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.baiJamjuree(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.baiJamjuree(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.baiJamjuree(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.baiJamjuree(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.baiJamjuree(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.baiJamjuree(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.baiJamjuree(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bakbak One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bakbak+One
  static TextStyle bakbakOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3330722dc74dbd09aed21bf32ff32064bd34bdc07730b30d71793060af24fe23',
        146444,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BakbakOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bakbak One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bakbak+One
  static TextTheme bakbakOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bakbakOne(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bakbakOne(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bakbakOne(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bakbakOne(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bakbakOne(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bakbakOne(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bakbakOne(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bakbakOne(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bakbakOne(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bakbakOne(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bakbakOne(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bakbakOne(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bakbakOne(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bakbakOne(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bakbakOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ballet font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ballet
  static TextStyle ballet({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8dba4d9355df9077eba9e394f02be0cd903dd38ea96353028adabe16c19ddd59',
        74396,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Ballet',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ballet font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ballet
  static TextTheme balletTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.ballet(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.ballet(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.ballet(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.ballet(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.ballet(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.ballet(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.ballet(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.ballet(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.ballet(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.ballet(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.ballet(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.ballet(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.ballet(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.ballet(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.ballet(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo 2 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+2
  static TextStyle baloo2({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0368cde88f69727dba2f40dfb3fa4a85f16cbf22616a91d3beb2860ca5aa3260',
        418572,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '11cab06bafce1d3cdfc4ef800fcd562cc14b94ce08ef6c65cb5092520b13b547',
        418880,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '88331c5e7ba18d8b7a378bf6a004dee351f710f833770f6346dd34a134472fae',
        418788,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bfa9ac340ef603cfad11f6a7571a3eb7c210bbbb2db5bf79325bbcdb0cd23a00',
        418660,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '110da45a9e9c9c37bf1ac0b961951b547d7a52bd6322d54e4adab513809dbb1c',
        418268,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Baloo2',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo 2 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+2
  static TextTheme baloo2TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.baloo2(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.baloo2(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.baloo2(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.baloo2(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.baloo2(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.baloo2(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.baloo2(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.baloo2(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.baloo2(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.baloo2(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.baloo2(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.baloo2(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.baloo2(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.baloo2(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.baloo2(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Bhai 2 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Bhai+2
  static TextStyle balooBhai2({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4f77231e378c1e0f35889351005528d442b76a08b428547f8681a58d8a25018d',
        539732,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e8256fc1059c0c31c79bf1055af14dfbf465482649e9aaf7b46ae7037a1ee46d',
        539852,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '543bb68e0d2faeab4410e4bbb6304a4e64cbf1ea00eff0afc875fb5476f3d64d',
        540084,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ddd339d75d662fd3a7e3df7a3ecb9f7b63b9f644edbdf30f10d5cd30f4269608',
        539956,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2c5414d8fbd676015be0628b947eba4b4ca682a2e13e759d308a53a56b6d3ae1',
        539476,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooBhai2',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Bhai 2 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Bhai+2
  static TextTheme balooBhai2TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.balooBhai2(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.balooBhai2(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.balooBhai2(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.balooBhai2(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.balooBhai2(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.balooBhai2(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.balooBhai2(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.balooBhai2(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.balooBhai2(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.balooBhai2(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.balooBhai2(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.balooBhai2(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.balooBhai2(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.balooBhai2(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.balooBhai2(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Bhaijaan 2 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Bhaijaan+2
  static TextStyle balooBhaijaan2({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1bdf9cf4da53391e4964ce53fa661740d80743524fc9c63410fa46975b1c6bb9',
        167644,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '015ae39bc2f2da3e78cba0e127c7d2a12354e09a5347cf3b1399840ed12ebeb4',
        167880,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5458f762cd4c6c4bd759c1040c9768a3f4dd6a7192fd8c7ec53c6ae3d3c24707',
        167896,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd0a76003e8d5c7207e0b2c47761dc720f2a641c917788860e7668e03583c5333',
        167880,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a93ab0920d84c5e00dc61f4c359999f8a1e5a5d05c7997b8b86a50fe3ee07d73',
        167716,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooBhaijaan2',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Bhaijaan 2 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Bhaijaan+2
  static TextTheme balooBhaijaan2TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.balooBhaijaan2(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.balooBhaijaan2(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.balooBhaijaan2(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.balooBhaijaan2(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.balooBhaijaan2(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.balooBhaijaan2(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.balooBhaijaan2(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.balooBhaijaan2(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.balooBhaijaan2(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.balooBhaijaan2(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.balooBhaijaan2(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.balooBhaijaan2(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.balooBhaijaan2(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.balooBhaijaan2(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.balooBhaijaan2(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Bhaina 2 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Bhaina+2
  static TextStyle balooBhaina2({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '82601ec75b3b97ab3b81b42acba375b0661b205afb95cca951f816249b2e4c82',
        273836,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1e69ddf65905d0fc8977af4bd0776a45719c3533143144d909332b4c66ee914b',
        274884,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5ebf672bf0e6817e060808ec24a74fdcaff87246fabbaf0398be29dffd474866',
        274916,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7c60822cf451f94bf6ef8d26d24a390a93deecbdfc280c9405cdd8b9046802f5',
        274752,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '82a0e3304aa8fa9478f745f40d58eed61e826be2a35281e55430ac40f7cd0a5f',
        273236,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooBhaina2',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Bhaina 2 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Bhaina+2
  static TextTheme balooBhaina2TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.balooBhaina2(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.balooBhaina2(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.balooBhaina2(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.balooBhaina2(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.balooBhaina2(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.balooBhaina2(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.balooBhaina2(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.balooBhaina2(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.balooBhaina2(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.balooBhaina2(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.balooBhaina2(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.balooBhaina2(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.balooBhaina2(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.balooBhaina2(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.balooBhaina2(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Chettan 2 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Chettan+2
  static TextStyle balooChettan2({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'af187faa14f0b4d90d4b7fe397e38be6fd453e3aa17a729b517c0ef726922ad4',
        191080,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '96aea35a01a609c9b9684550058fb7bf16b63c3f66fd6e90179350f0f9495a05',
        191676,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '05698cf8974676fc630d827c82d2d9c3551cc40539fcd5cd5bc139b320445ab0',
        191668,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4a3cdaa152c3ac6d72497123ce30e38cd5e698598db3ae1b9a29f374e2528c8d',
        191576,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ee8f98eeeaae014a51bcc36d2f594d850842e4eeeb155b7edb6404c9d567593e',
        191428,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooChettan2',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Chettan 2 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Chettan+2
  static TextTheme balooChettan2TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.balooChettan2(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.balooChettan2(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.balooChettan2(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.balooChettan2(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.balooChettan2(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.balooChettan2(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.balooChettan2(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.balooChettan2(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.balooChettan2(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.balooChettan2(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.balooChettan2(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.balooChettan2(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.balooChettan2(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.balooChettan2(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.balooChettan2(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Da 2 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Da+2
  static TextStyle balooDa2({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a4320e8c2c249a46f3d46e23da2f071abe081b23cf282495ba93a3d6f79d52c3',
        269952,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'db6079f2c759d759c23845143ca2279d4a7dcc4750d38092979d3a97e53be87c',
        270480,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7ab5d23427bc5a4390f10308d0ebf872aad08181af3d50b23a1c2b1bfd7847dd',
        270608,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'efbd830048983225f35b73d86f55eb1ccc8a6fb89967ac8187570c946f4275ad',
        270288,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd8d1033cf085ab33c1c97619c67bdc6f46d6656a955227f30a7cc79390327a52',
        269412,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooDa2',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Da 2 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Da+2
  static TextTheme balooDa2TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.balooDa2(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.balooDa2(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.balooDa2(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.balooDa2(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.balooDa2(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.balooDa2(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.balooDa2(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.balooDa2(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.balooDa2(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.balooDa2(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.balooDa2(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.balooDa2(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.balooDa2(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.balooDa2(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.balooDa2(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Paaji 2 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Paaji+2
  static TextStyle balooPaaji2({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5a99cd8c935313e394111a744d82a8f539a54d43b38cf43797f1ffe788b157b2',
        148084,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd686d10ca6d4b9ecfe632d22b6cfaa345cd6ce5ff327f65fd0de3b083b8481e1',
        148324,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cf268c63ba37c47821e4e9322f3e865d0921f0de24cdd5c1f59e63a61da79db2',
        148316,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c54e7da8c2ced370202fb07d7d8136c0e739f5eaa321585db788716f48801d04',
        148188,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '664ee4d64437ca980964284054825a3241c268749e439537f993ff69025bacba',
        148120,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooPaaji2',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Paaji 2 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Paaji+2
  static TextTheme balooPaaji2TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.balooPaaji2(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.balooPaaji2(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.balooPaaji2(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.balooPaaji2(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.balooPaaji2(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.balooPaaji2(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.balooPaaji2(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.balooPaaji2(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.balooPaaji2(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.balooPaaji2(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.balooPaaji2(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.balooPaaji2(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.balooPaaji2(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.balooPaaji2(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.balooPaaji2(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Tamma 2 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Tamma+2
  static TextStyle balooTamma2({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4f92657afb4b2f15e8fac2d4691d62acee86045cca51a987f8f4f04873bf38e1',
        280440,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3a73e821f0858fd50d0cce6b298e3d40d04548f464385f283118dde9aeccc0ac',
        281528,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'de3910900e7a20797c8ea9ccad5c24ec1593ce226f1c7258bb39e08e900a2386',
        281668,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ebe046951e426194621fe77ed17a6f500e804a1016d550c34817e4010e87d505',
        281592,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '224e88a3618a2dd207255fb20e5981bc75d28fff2efe84200280bbac80a42a26',
        280984,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooTamma2',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Tamma 2 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Tamma+2
  static TextTheme balooTamma2TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.balooTamma2(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.balooTamma2(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.balooTamma2(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.balooTamma2(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.balooTamma2(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.balooTamma2(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.balooTamma2(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.balooTamma2(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.balooTamma2(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.balooTamma2(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.balooTamma2(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.balooTamma2(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.balooTamma2(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.balooTamma2(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.balooTamma2(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Tammudu 2 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Tammudu+2
  static TextStyle balooTammudu2({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '93b8c62bf2f4ae93e5e88598ba0f7117f02d80d496c835172cb7546f6d5533e9',
        388516,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7e3e198a94e46596c57330a4a27738cff1c26f523f1b886bf030a16c1b1bbbab',
        389972,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4ac36a22bfdc5cb8ed9708d55bf0d920f2814c54f70cf3542f3cf46719591535',
        389948,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '211f0d309f9c28c5ab07275b99f5634dd6cd1b1f884e8ed4f1cfc11f26abcf2b',
        389896,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ce5e787b89dcd64f40f60ffac84319daa2d2dbe7e855dca318069aafef068c70',
        388192,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooTammudu2',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Tammudu 2 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Tammudu+2
  static TextTheme balooTammudu2TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.balooTammudu2(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.balooTammudu2(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.balooTammudu2(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.balooTammudu2(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.balooTammudu2(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.balooTammudu2(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.balooTammudu2(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.balooTammudu2(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.balooTammudu2(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.balooTammudu2(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.balooTammudu2(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.balooTammudu2(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.balooTammudu2(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.balooTammudu2(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.balooTammudu2(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baloo Thambi 2 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Thambi+2
  static TextStyle balooThambi2({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0832b1721d4a2eaacea1a3ea56da049a7ac7bc37e948ba4ea6a7055aac3233cf',
        171208,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1bf994fbad7fcb711fc55e9a3873edbef46b1ac4f147c0922c0c3f13831057f7',
        171444,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '74c3fee0953424c375ad7dd24c84125a3ad2b582171e7d5aa4fafd74493cd3ac',
        171516,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a983a3ba859b623947f3e05e74976932e533aa647a5a992bedc19bc034b0fb8d',
        171152,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f02c70eca53d0c0e93cd1aa4811516f597efc42ca65f6f3830a55958e855ce54',
        171152,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooThambi2',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Thambi 2 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Thambi+2
  static TextTheme balooThambi2TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.balooThambi2(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.balooThambi2(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.balooThambi2(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.balooThambi2(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.balooThambi2(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.balooThambi2(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.balooThambi2(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.balooThambi2(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.balooThambi2(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.balooThambi2(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.balooThambi2(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.balooThambi2(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.balooThambi2(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.balooThambi2(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.balooThambi2(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Balsamiq Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Balsamiq+Sans
  static TextStyle balsamiqSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '335ab432a04191cc3cf74a6a03948c15b190d5483bf9d50b3b400daa48487484',
        303080,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5970b503a539284714c51a6fd6089976e0471dd9632d68153b05c944ef186726',
        283784,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2ad89d2e2fbc24c8bc73c8af4275fe81a95862af760cacd96164de767aad449b',
        275828,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e1d5c0b734c866a07a45922cf6b393e1d6966172648c37169a21d7362e6de3cd',
        257136,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalsamiqSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Balsamiq Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Balsamiq+Sans
  static TextTheme balsamiqSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.balsamiqSans(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.balsamiqSans(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.balsamiqSans(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.balsamiqSans(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.balsamiqSans(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.balsamiqSans(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.balsamiqSans(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.balsamiqSans(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.balsamiqSans(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.balsamiqSans(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.balsamiqSans(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.balsamiqSans(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.balsamiqSans(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.balsamiqSans(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.balsamiqSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Balthazar font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Balthazar
  static TextStyle balthazar({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1cd0347fd14d420937d59e562bbaf7728e58f405b7ab633dc27d3d0df5abc46a',
        26212,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Balthazar',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Balthazar font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Balthazar
  static TextTheme balthazarTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.balthazar(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.balthazar(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.balthazar(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.balthazar(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.balthazar(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.balthazar(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.balthazar(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.balthazar(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.balthazar(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.balthazar(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.balthazar(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.balthazar(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.balthazar(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.balthazar(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.balthazar(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bangers font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bangers
  static TextStyle bangers({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '689209f1743b437304e2c5ce9d0581a432da1c476d1212af9a38349af7ea10e6',
        69780,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bangers',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bangers font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bangers
  static TextTheme bangersTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bangers(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bangers(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bangers(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bangers(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.bangers(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bangers(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bangers(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bangers(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bangers(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bangers(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bangers(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bangers(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bangers(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bangers(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bangers(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Barlow font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barlow
  static TextStyle barlow({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5bbc16834974bcc4e4f9db973c37e0cf4fc0f6ddac524fe984b7ad06cfd71a72',
        60968,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '14ce45a1495d15909f8bb25df6cdc1138abe3e164503c344d9f980c2cbece06b',
        65044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f0b7f7aa2d67a8c0202bf067a5bd032555506852f3417ca94aadc16700e64e20',
        61172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1d2e410b5be890aa411650d1887b2b3cf4ad9f64ce2a75d88084aa9009f1f349',
        65156,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '881e00245da07ebe51751aa48d551d8c06322b0b9e3f27d81d4274c414b9c397',
        61108,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1d31c8922e328b7a504216718a2657373a0b560b6a3695d5c567500fe162813a',
        65384,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cfd8787b4714f9c02f53da1b24bf172f95c01a9d0c685ad57ed129c3fcdae407',
        61220,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd10c46da72515f099bcd89f43f335141ffa754c6022509fbc5c247b139862841',
        65404,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '72a094cf0a618a5dfdef5e4577be76a733457eae3ab4bebab26cfa72d56d6061',
        61192,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0233802dc86c8576f52854ee4c856a709d9a72578aad65b1832bfdc817337f4a',
        65236,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '73a13e2e61ce8da6ecb02864f6a560ce358ed01067e64872d318d71d51e23979',
        63624,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '09d36dbb4ca7e1fba56fa9317aa27b899dbc9ab19eb81e414a332096345164b9',
        66716,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c5333515554675f6137f66c245fa199a4e917d03178b7605b8f54a87010b5c18',
        63432,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '478ee598ade213bd6dffcfeb5063f62ae2bdb7ae5cac8640301396b78ca93785',
        66428,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cc5d3129f605f97c96b56a641f50a40ed4b595e315131b462391b0b38f4b8638',
        63352,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd2fe8d712bf086745e5263df81b7800701aa1d50c8d41fb62263acc12d6b94d6',
        66300,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '136bfaeda32a19ef87e4fcfa5b9abe08ff61e2d6caf241d1bc0f0c596acf4b55',
        62648,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6e8ccc4cc688b301539e9fbc1b245a4e8adac7e27457312667b4cf30eaec1f89',
        65820,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Barlow',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Barlow font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barlow
  static TextTheme barlowTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.barlow(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.barlow(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.barlow(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.barlow(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.barlow(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.barlow(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.barlow(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.barlow(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.barlow(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.barlow(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.barlow(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.barlow(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.barlow(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.barlow(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.barlow(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Barlow Condensed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barlow+Condensed
  static TextStyle barlowCondensed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1dee1e0b2a0e92f8c159c64be477d5ce921ab414875dd2b27fddbd3225145e59',
        59116,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1d8a3427ca351ad43d44ebf56065be6dff6c6b8ca07e84f23fa6530382bdaf5a',
        64192,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '653ee54fee2f8f7bb3767619199f793bb1535213047ec3f9692d9ede7a32b29f',
        59404,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '58c71ddcda8a2e87b56af7f0330cc38ed1fbcd2ad44e046e5e06fe0bc14fe38c',
        64148,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b32c0a732bbc6b8548600c07f0613cbd907fc9e5a612172b769773a0f9a105f3',
        59368,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '727434e82ca27aa74575ac071aa22dee19e53ef5fb9989d33afd8da08daea5b3',
        64076,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '55945685c8354c029c443b9cb6ecede593e2b1d39b06af4252d539c4086153ea',
        59388,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ddfaa73e1fa79e3ca93f652e782cd76ef2258c173e9c9ce4b00866846ef99629',
        64216,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '50f9954bab84f7ccea0afe7cf13823533027b5efd0417a1387141e977b4efbe0',
        59296,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1c6f759c51923225d37d188e0cfc338654bfea90558ebeb414a0902243db59f6',
        63936,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ad2be76c190d3802305d220324830b70a75f10048dc13ec3586aabfc2a3fe9e7',
        61748,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '818f7627df56558c6af408c51cc3006542b5b3345d95bd68b00165106cdf57cc',
        65044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0b49c74d0e2ab43e60c2d626f3d773b479503b5b3ecc93dd53214ccef6fb96d8',
        61656,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a9dab89ddf5e643d6ddeabbb4cee0529dd18d3765df25598494f0600b8bfd38a',
        64824,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '541bda3b787018f37ad1188cb6a3ce1dec84e698b16b5e42f558ba31b684bacb',
        61744,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '87a22408de0b27c113ae7d6b5e5df3e32d15ba1a3144ad54825b602df6c6edfd',
        64692,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a8c8ee9c3537ef2e0630589f34fb63c05ca0709941d83c65ca3a9afe765017d0',
        60364,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0011fea9ffaffb7d88568511ebfcb6fe446dbafd0b0461289db897e01fa5b5fc',
        63364,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BarlowCondensed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Barlow Condensed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barlow+Condensed
  static TextTheme barlowCondensedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.barlowCondensed(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.barlowCondensed(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.barlowCondensed(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.barlowCondensed(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.barlowCondensed(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.barlowCondensed(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.barlowCondensed(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.barlowCondensed(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.barlowCondensed(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.barlowCondensed(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.barlowCondensed(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.barlowCondensed(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.barlowCondensed(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.barlowCondensed(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.barlowCondensed(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Barlow Semi Condensed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barlow+Semi+Condensed
  static TextStyle barlowSemiCondensed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '89818a86f326cb1fa15b2706043de6f2c999ed16e70e72ba25d3e690ee4c4d33',
        61528,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '19ed019b658c781ec627f351b00eeb535ea908d1ede6f2b7c3ac6e50ce19fbcb',
        66004,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c9d0c8ff49d5e765dce34246ecd4a3156391db071cda5ab2c047509c2408b571',
        61716,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '80ebfc9722b4b6b42b2285d7e46a7edd903b81c011d9121de8544804246a1119',
        66012,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '52b690571a0704facf69aa1b54078acc0343ced70027a6480413969da16e992a',
        61812,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '395b671ebf4a7b7198fb4416508b3fdfd6d288dffdb8b82bffea7a40e4507bf9',
        65936,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bd6c806ca535d0ce1180ba8c0f0d07d51597be4f148af673c7c3b39e6614d391',
        61888,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0763857ec6ff64573e7d61797c40e519f7b76a0e2b739a95dd9738dc75465af5',
        65864,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4bfd63bc5e79e3a04ba6ddbefb2ce1d9f62a955ad41e3119cdb4cbf5eaceb994',
        61784,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '60ac397706683f7bc0ee75a2f75236b42a87ed2c4d8b3c67b76d5c24520a0926',
        65760,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '244e8a9cd7d8a5fe1e0ce2a19d07bce2028c2c92ca8eff380977827b8738b648',
        64216,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0aa25b8c8d300f88fecf503e1d1b8cadd69254330d89690084bba4a08c4d0b9f',
        67292,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '03322f9a9edf8031532ed962b7172f14dba9d318ae0c90a9bb5f718c92c232a1',
        64196,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f8b0bb8a92f7123de02f2c7cf49621754789843775cb8c318848502b934ab8f4',
        67032,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9ce5e171b6822bb2b7b7f1d017d94791a71443deadc32e49cfb6bb4415edb4db',
        64224,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'dcbde2ed7553bd05e71b64af8d8b87f6e0098879781604da0269c2394817f246',
        67024,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8578b062ec4b7e229bef1eab8834e2458b2536bc776306a7ed6327493b587a52',
        63252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'baeb5ff8b88a49d4dd171bdee7541101b805e263699ddcdfd9738c760c44107c',
        66268,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BarlowSemiCondensed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Barlow Semi Condensed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barlow+Semi+Condensed
  static TextTheme barlowSemiCondensedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.headlineSmall),
      titleLarge:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.titleMedium),
      titleSmall:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.titleSmall),
      bodyLarge:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.bodyLarge),
      bodyMedium:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.bodyMedium),
      bodySmall:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.bodySmall),
      labelLarge:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.labelMedium),
      labelSmall:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Barriecito font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barriecito
  static TextStyle barriecito({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5a5f70fd22056cbcd57b1d4921971a147653d249e82c95012bb6546692bc1b35',
        168228,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Barriecito',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Barriecito font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barriecito
  static TextTheme barriecitoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.barriecito(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.barriecito(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.barriecito(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.barriecito(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.barriecito(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.barriecito(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.barriecito(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.barriecito(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.barriecito(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.barriecito(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.barriecito(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.barriecito(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.barriecito(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.barriecito(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.barriecito(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Barrio font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barrio
  static TextStyle barrio({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b6e639586ec1a9532c089c61020e3d092aeefbf3c496b2c1104acb3904f5ec2e',
        141000,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Barrio',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Barrio font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barrio
  static TextTheme barrioTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.barrio(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.barrio(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.barrio(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.barrio(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.barrio(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.barrio(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.barrio(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.barrio(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.barrio(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.barrio(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.barrio(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.barrio(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.barrio(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.barrio(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.barrio(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Basic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Basic
  static TextStyle basic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e3b02abd4d2201f0462807909df410bb7ce384e02bb619853d0397f687ed2777',
        42096,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Basic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Basic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Basic
  static TextTheme basicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.basic(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.basic(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.basic(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.basic(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.basic(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.basic(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.basic(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.basic(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.basic(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.basic(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.basic(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.basic(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.basic(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.basic(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.basic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baskervville font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baskervville
  static TextStyle baskervville({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '83ba1043f0c567dc37866c0e8c7b2895e54aed1fa3d88774d4b3d466fcaf66a3',
        51596,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '87ff6b605b4a5621a1b22ed0f4792023269d6af51e16ce5dd68726296603cc58',
        53684,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Baskervville',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baskervville font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baskervville
  static TextTheme baskervvilleTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.baskervville(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.baskervville(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.baskervville(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.baskervville(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.baskervville(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.baskervville(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.baskervville(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.baskervville(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.baskervville(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.baskervville(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.baskervville(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.baskervville(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.baskervville(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.baskervville(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.baskervville(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Battambang font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Battambang
  static TextStyle battambang({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8dfb3df55c4d870b04583a168df47ae7877c0ea2f9c336d21066033c88bed45d',
        59292,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4ca7aeb911833408ae168a627d3083c87bdc38868b0b8ba1320696006e40f59b',
        58724,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e05fe4fcc6f87bf09c6db7eda1420c9d92af3e9f0e6f09e0364dfd2ac00b77ae',
        63732,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4a0d66e43fea8fb305efcd3afec4f9f08664026126669b5ac3dade4439653f66',
        62124,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '404868ce8f69e04f2fb5cc302059c4910d9e4bf2576f1c41c450a54c92d46ff2',
        59948,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Battambang',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Battambang font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Battambang
  static TextTheme battambangTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.battambang(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.battambang(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.battambang(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.battambang(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.battambang(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.battambang(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.battambang(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.battambang(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.battambang(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.battambang(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.battambang(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.battambang(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.battambang(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.battambang(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.battambang(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Baumans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baumans
  static TextStyle baumans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1de2ab6656da7508c9eff19007f47390e9eb2f1472851910525141f81fb42aad',
        16352,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Baumans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baumans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baumans
  static TextTheme baumansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.baumans(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.baumans(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.baumans(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.baumans(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.baumans(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.baumans(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.baumans(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.baumans(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.baumans(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.baumans(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.baumans(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.baumans(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.baumans(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.baumans(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.baumans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bayon font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bayon
  static TextStyle bayon({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8f7455ccf43a80750000f199a2206c47cf20d70033b42e1618fe81bd3e2cb19f',
        31820,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bayon',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bayon font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bayon
  static TextTheme bayonTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bayon(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bayon(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bayon(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bayon(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.bayon(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bayon(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bayon(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bayon(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bayon(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bayon(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bayon(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bayon(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bayon(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bayon(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bayon(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Be Vietnam Pro font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Be+Vietnam+Pro
  static TextStyle beVietnamPro({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '031b377b332f95da1996500fb97fca5a8cd5f95522e852083d196c0bcefca6b2',
        72348,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '623f374adea67c8f650c9c6e5d90b30602e7e5eccfb92bdbd59f607381e3d685',
        73916,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b6d33c91e88361e46ef97084811ce5943e715f130e6c5eb655c509cb61e56cd6',
        72252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'beca4da968f8fd5d2ff57f072c08b3ef5b719a6177c0cdaf5af411352ccac3ee',
        74416,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '640424e70dcdaa495bf299facdf0bd803ea0492bd99642ff227a3f7a57b8ebdd',
        72484,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c5a100db64d132fccebb61d4bd41cdbe878baba40f6d4969a091b3e9c5835fab',
        74252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0bec39a3895ccc7eec7131ac011754fa70315afed0061ec49d08dd587215174b',
        72288,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'efcd7cebb01e08925565bf7304c7721c3846ab9ad36fe89f9dc79c49cdd4379a',
        74040,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bb68c949987e445999e4f0474fb0224289c6bc8fb00e56d7d9dfcc3006114598',
        72424,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '377d647aa2a9f0f0220ca01557c18d98375005eb4e971aef8bee1a048bf2c90c',
        73976,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2966316c8748b3e3167941ae9b48ee38c4af7e5c110202875d7cc0567a0169e9',
        72268,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f243bdb9ef0545663215bfdfa72ddc42fa004725b443b4670fb52adb61480284',
        73448,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9d6b7608799789c3f8e5c896afc5f11d07402482092f341a4224e4d362f58b68',
        72172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a18cf3c2a37908a0d2bfbfd37376f4029e5709763df1e4df858ec281407afe8c',
        73308,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '77e480c26df369171a0dcddf6eef76082774637010ae0bacefbae59159e34224',
        71864,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0ffebfacff73e9d3225844e5efde238061ea50ac72c7eed5536f0334c1efae2b',
        73248,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '632cec316b2bd7f440c0c647b9d1e95ef6e55338d4cc8c1979d642f0178ce981',
        70768,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fd41536742311aacb3cada2492ea78f67ff700057c9af14f8fcb2cb05b45c37e',
        72052,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BeVietnamPro',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Be Vietnam Pro font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Be+Vietnam+Pro
  static TextTheme beVietnamProTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.beVietnamPro(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.beVietnamPro(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.beVietnamPro(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.beVietnamPro(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.beVietnamPro(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.beVietnamPro(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.beVietnamPro(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.beVietnamPro(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.beVietnamPro(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.beVietnamPro(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.beVietnamPro(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.beVietnamPro(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.beVietnamPro(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.beVietnamPro(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.beVietnamPro(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Beau Rivage font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Beau+Rivage
  static TextStyle beauRivage({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ddd83eb0bdacceb749d27c2e8b767cc38b522153db450931f1ca8b682c8b423e',
        110720,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BeauRivage',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Beau Rivage font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Beau+Rivage
  static TextTheme beauRivageTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.beauRivage(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.beauRivage(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.beauRivage(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.beauRivage(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.beauRivage(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.beauRivage(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.beauRivage(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.beauRivage(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.beauRivage(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.beauRivage(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.beauRivage(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.beauRivage(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.beauRivage(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.beauRivage(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.beauRivage(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bebas Neue font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bebas+Neue
  static TextStyle bebasNeue({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c5499c3bed4e43463a663689f06f5026ea12c96997495b857ca0d3ea94d69978',
        38180,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BebasNeue',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bebas Neue font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bebas+Neue
  static TextTheme bebasNeueTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bebasNeue(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bebasNeue(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bebasNeue(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bebasNeue(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bebasNeue(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bebasNeue(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bebasNeue(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bebasNeue(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bebasNeue(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bebasNeue(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bebasNeue(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bebasNeue(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bebasNeue(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bebasNeue(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bebasNeue(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Belgrano font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Belgrano
  static TextStyle belgrano({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '041815a440e3d2b468ffa830185903956b5925796cfa68c5b61fa3c3b3f0f2cb',
        26620,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Belgrano',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Belgrano font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Belgrano
  static TextTheme belgranoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.belgrano(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.belgrano(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.belgrano(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.belgrano(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.belgrano(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.belgrano(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.belgrano(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.belgrano(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.belgrano(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.belgrano(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.belgrano(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.belgrano(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.belgrano(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.belgrano(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.belgrano(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bellefair font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bellefair
  static TextStyle bellefair({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '60d4678f2a36e34ae045ea7aead21892c2ec638cc5a5177d5323befdbd8ee4d4',
        43872,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bellefair',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bellefair font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bellefair
  static TextTheme bellefairTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bellefair(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bellefair(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bellefair(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bellefair(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bellefair(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bellefair(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bellefair(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bellefair(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bellefair(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bellefair(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bellefair(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bellefair(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bellefair(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bellefair(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bellefair(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Belleza font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Belleza
  static TextStyle belleza({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '15f9d431ff65be1394faf8234cedec1083ec542b4a25f7298c6891882a1454f6',
        25036,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Belleza',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Belleza font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Belleza
  static TextTheme bellezaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.belleza(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.belleza(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.belleza(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.belleza(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.belleza(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.belleza(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.belleza(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.belleza(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.belleza(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.belleza(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.belleza(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.belleza(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.belleza(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.belleza(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.belleza(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bellota font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bellota
  static TextStyle bellota({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9f7a6cbf9af154f216b945d1ec258fb7eb1bdf1e00d778f0099bb1ea6786c2e0',
        87240,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a5c833f7fcb9a2cba29e00cdbdafd29119591093254b59a86c799af6abb966a8',
        90100,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f824b2ca133fa906c1450368789a3588ec9bab058ccbe4f76c8448a7d12e3236',
        86912,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ac652d8c98a501302c1872a404e8f7f1d793005ccd41994a7c3e5b68facb7c85',
        89752,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '94282dcf76c3c3db14eeed279164c722a17043095768956c2b08d13b159ddfb8',
        87136,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5f4ade05bfb3150be2cb3791738df00ce698dbf6c883cd2a2a67998081b5c8ec',
        89968,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bellota',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bellota font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bellota
  static TextTheme bellotaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bellota(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bellota(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bellota(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bellota(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.bellota(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bellota(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bellota(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bellota(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bellota(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bellota(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bellota(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bellota(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bellota(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bellota(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bellota(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bellota Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bellota+Text
  static TextStyle bellotaText({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cf0bcc318432914f99a92516b9d725b4f5e70989691d03a39085e2d22ea96e48',
        85396,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '05792399873861d4fbb6f373bc828d3397e36270ba0a5aca9761cdc899dca643',
        88396,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fe2110fd2761c598f3f839b1903718ab5fd09f216235b2c871c6c22590718b87',
        85276,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'db1408f9b3af622c28fcef93569e5988a6aea9d082b1fa2827ac36d0c9f6f632',
        88112,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '138b64db8901a807f366e04b3196f9609cc49ec57c2ea5d78100c876aac7ce08',
        85352,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3303b1143952ec355dfcd4cd8ea1ab92c3176ededf3dec3bdc05b21bf121d589',
        88192,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BellotaText',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bellota Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bellota+Text
  static TextTheme bellotaTextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bellotaText(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.bellotaText(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bellotaText(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.bellotaText(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bellotaText(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.bellotaText(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bellotaText(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bellotaText(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bellotaText(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bellotaText(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bellotaText(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bellotaText(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bellotaText(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bellotaText(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bellotaText(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the BenchNine font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BenchNine
  static TextStyle benchNine({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bbf92d32cea16a7289556b36b99b6cc8b19b1b64e32604ee79b563e8eb17791a',
        36144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fbad55cfa6a05a2521130d836d2b0f7f4009bbe0ec3c41feb99f246fce39ed47',
        36912,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fb209270d0bd7f1f9655cacccb53fc569a44b807f89c4a4d6db282d8a70e5969',
        36888,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BenchNine',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the BenchNine font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BenchNine
  static TextTheme benchNineTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.benchNine(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.benchNine(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.benchNine(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.benchNine(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.benchNine(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.benchNine(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.benchNine(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.benchNine(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.benchNine(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.benchNine(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.benchNine(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.benchNine(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.benchNine(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.benchNine(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.benchNine(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Benne font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Benne
  static TextStyle benne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '65574b4e0c539d996fd10054ca151357f17e7351b0a255ac2c2daad620577842',
        208536,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Benne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Benne font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Benne
  static TextTheme benneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.benne(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.benne(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.benne(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.benne(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.benne(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.benne(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.benne(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.benne(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.benne(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.benne(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.benne(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.benne(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.benne(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.benne(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.benne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bentham font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bentham
  static TextStyle bentham({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b68a3b96cd2207a360ccce762bd77b9494035ddd3643b1bb3b260aea85063ff5',
        25772,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bentham',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bentham font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bentham
  static TextTheme benthamTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bentham(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bentham(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bentham(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bentham(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.bentham(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bentham(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bentham(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bentham(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bentham(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bentham(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bentham(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bentham(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bentham(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bentham(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bentham(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Berkshire Swash font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Berkshire+Swash
  static TextStyle berkshireSwash({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9aa7634aa39372daa01225389c598308ac180e48f1802577efe622cbaa48e458',
        51832,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BerkshireSwash',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Berkshire Swash font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Berkshire+Swash
  static TextTheme berkshireSwashTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.berkshireSwash(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.berkshireSwash(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.berkshireSwash(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.berkshireSwash(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.berkshireSwash(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.berkshireSwash(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.berkshireSwash(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.berkshireSwash(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.berkshireSwash(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.berkshireSwash(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.berkshireSwash(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.berkshireSwash(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.berkshireSwash(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.berkshireSwash(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.berkshireSwash(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Besley font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Besley
  static TextStyle besley({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '996fc0a7ae5a8dd33cf37073dc2ce08b220591215bcca76fe67834abc8962810',
        55960,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5f9bbdb98ffb8273aa66a11445e812d98e8e11542cc38b1def0ec270814a042a',
        56036,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0c3a17ae1149f3cdb1158266bb4b5c22ae62ce044e951124fe273d065f8fda1b',
        56044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f37839fc3286096ea12deb215849f68765998f3f2a4854d9c631f0183317bf87',
        55988,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '51a4fdf8f05eed2b6fb62479e644dcfcac56c8bb7fcc26fae2192486e0c5b5e8',
        56048,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '62dfbeb5cf9e9f58e47c752855ac2890cf1ae580028e5e93bf916a8bbad416e7',
        56008,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '56678de811af0d473572cc095f2cd93e18e10a82207b54ec581a6ad4b4375d81',
        56532,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ff33ded3060192d7714b5bd91a5d7df7dc6d3393150f7a3df190f6a0e6b83e81',
        56728,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '13401ce4349820156fcec4b0e53b29a81820897114e081a0e8f35ddd1ecd96c3',
        56764,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7ce81f5bd7d1a13df8b7f99836d01b64d645545ec261172a638b3d31f176a436',
        56684,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'abff22f994971a0ca872d74e8a52b95d4c77955822766b5633eed8789b70dd1e',
        56784,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '18a9e8ab8c41769a85ac8bdf65517815fb36c31c37238b5f8063337073577b9a',
        56728,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Besley',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Besley font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Besley
  static TextTheme besleyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.besley(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.besley(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.besley(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.besley(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.besley(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.besley(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.besley(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.besley(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.besley(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.besley(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.besley(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.besley(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.besley(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.besley(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.besley(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Beth Ellen font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Beth+Ellen
  static TextStyle bethEllen({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e7fc599d346e76d81bc166bc148f072f40705635a6e2ce02731f1e5646da55d9',
        115600,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BethEllen',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Beth Ellen font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Beth+Ellen
  static TextTheme bethEllenTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bethEllen(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bethEllen(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bethEllen(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bethEllen(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bethEllen(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bethEllen(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bethEllen(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bethEllen(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bethEllen(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bethEllen(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bethEllen(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bethEllen(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bethEllen(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bethEllen(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bethEllen(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bevan font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bevan
  static TextStyle bevan({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'aba5d9d2efd1ef26c925e88adcb1fa2ccc1dd8777c4f2ae4dd63db06b222aeb0',
        69996,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd46344f30e511e194fa8ae32aa1b8c9fd205ca76dcacbc92a3f089e4e6d00a2d',
        71192,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bevan',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bevan font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bevan
  static TextTheme bevanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bevan(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bevan(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bevan(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bevan(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.bevan(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bevan(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bevan(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bevan(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bevan(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bevan(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bevan(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bevan(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bevan(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bevan(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bevan(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the BhuTuka Expanded One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BhuTuka+Expanded+One
  static TextStyle bhuTukaExpandedOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '477762dd13466bb3fa88661e2b031ad6b56844bd78311b7e412eee1ff413f850',
        63844,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BhuTukaExpandedOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the BhuTuka Expanded One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BhuTuka+Expanded+One
  static TextTheme bhuTukaExpandedOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.bhuTukaExpandedOne(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.bhuTukaExpandedOne(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.bhuTukaExpandedOne(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.bhuTukaExpandedOne(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bhuTukaExpandedOne(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.bhuTukaExpandedOne(textStyle: textTheme.headlineSmall),
      titleLarge:
          GoogleFonts.bhuTukaExpandedOne(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.bhuTukaExpandedOne(textStyle: textTheme.titleMedium),
      titleSmall:
          GoogleFonts.bhuTukaExpandedOne(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bhuTukaExpandedOne(textStyle: textTheme.bodyLarge),
      bodyMedium:
          GoogleFonts.bhuTukaExpandedOne(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bhuTukaExpandedOne(textStyle: textTheme.bodySmall),
      labelLarge:
          GoogleFonts.bhuTukaExpandedOne(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.bhuTukaExpandedOne(textStyle: textTheme.labelMedium),
      labelSmall:
          GoogleFonts.bhuTukaExpandedOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Big Shoulders Display font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Display
  static TextStyle bigShouldersDisplay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c2f059f118b71bf6db58c7aa72a53ec97053c1d085dcc9611d9a104ac4e7d0b1',
        67936,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1c1f361e201ac9f02c9b01c6a7c8cff9c09ee9c706f567a2300ff4f3f326ea1a',
        68296,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e9ad6d53c1c518d625693243d834695b30e652365484d15c0957668e85bcc1c3',
        68340,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bcf4fa4f49cd22355c5c97c13efca3fbf2c9317e2dd85a15f30bc3baf591aac8',
        68452,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c7a932aca15eacde445070f6615ed8099338af53c137865379b881243567951f',
        68568,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1367d2e9c7f234d333eb5052c712f151937431b1e944f27f025584c3a6fceb01',
        68548,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0facef1b0dcb07c5900cde0f8723bd23c4324ced52b786822ffb8782a6370dd3',
        68428,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '139ca15de53fe5710fac0b43eb3afc394162536de85104882e4bc74b7f0c90c9',
        68604,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5080770b655e036ab38b1b7aaec470e14ea23b5cfe58d10559ec6166f9a84ebe',
        68696,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BigShouldersDisplay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Big Shoulders Display font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Display
  static TextTheme bigShouldersDisplayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.headlineSmall),
      titleLarge:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.titleMedium),
      titleSmall:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.titleSmall),
      bodyLarge:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.bodyLarge),
      bodyMedium:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.bodyMedium),
      bodySmall:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.bodySmall),
      labelLarge:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.labelMedium),
      labelSmall:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Big Shoulders Inline Display font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Inline+Display
  static TextStyle bigShouldersInlineDisplay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2e5d1cf4d944ed0e96008a4910c766dd4fb1980bf2f5a9edabac8e2e0ee961f4',
        117212,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6fd6e1af92f834a6582a455b4f54a58edaa2cdf9e72f183c412a5db8862d5685',
        117564,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7fb48300a37b2762cf6790e6db21825e995ac46a1944ca3de038463bdc551405',
        117560,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e6aea7c97d28392ccad9054ac3e9f82ab86b4a20794cfac7ba721a6a25163633',
        118084,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '14b60e25bbd227ddf3fa91947c40bbcb49959f9b06b4e3420573067474780dba',
        118492,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2ba775a6fb5ae84ea412e1c871b559cebf50929f572d4e2d4f3ea11f07958e96',
        118868,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd60d1a64023939079cfb9a6b5c36896f0f2b0021431a1d73bf2e30861964ffc9',
        119508,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '982b9e65ce17d0e19296a17f8ffb6d9935c25f7d0e837beca79acfbd8529c340',
        120300,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd31e9347d30a4c186e618b1b99a9868e869efb5ae06cc82a1af44a03310e9a8b',
        120340,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BigShouldersInlineDisplay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Big Shoulders Inline Display font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Inline+Display
  static TextTheme bigShouldersInlineDisplayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bigShouldersInlineDisplay(
          textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bigShouldersInlineDisplay(
          textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bigShouldersInlineDisplay(
          textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bigShouldersInlineDisplay(
          textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.bigShouldersInlineDisplay(
          textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bigShouldersInlineDisplay(
          textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bigShouldersInlineDisplay(
          textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bigShouldersInlineDisplay(
          textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bigShouldersInlineDisplay(
          textStyle: textTheme.titleSmall),
      bodyLarge:
          GoogleFonts.bigShouldersInlineDisplay(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bigShouldersInlineDisplay(
          textStyle: textTheme.bodyMedium),
      bodySmall:
          GoogleFonts.bigShouldersInlineDisplay(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bigShouldersInlineDisplay(
          textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bigShouldersInlineDisplay(
          textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bigShouldersInlineDisplay(
          textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Big Shoulders Inline Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Inline+Text
  static TextStyle bigShouldersInlineText({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b69f0881e17c4d18d1feee31862e3645f7b75201396ef3e2dbb86e17034370c8',
        117628,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c9b896c3029c755916fd5b26663fd8c9e319476305eca8b1b85c395db9d08063',
        117984,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fd714e14fea1c0910e42ef929606c26aeb5595be3f8b8af47bd32c600ab6dd91',
        118380,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '27ccc6006d11cd6985fb64fd0687394878ea8067ee835099fc9cf5b7658c39a4',
        119152,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '53d4452f53c047dc42235e9186d29e09aba2c875ae148cf4126d66ddb91e3ab9',
        119408,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '364e3e25c19e647c71294bbcafbc7705a690bf0a514b2f813284917fefdee10c',
        119736,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '036f04ec10694bae91fe0ce959d7003de1536e27a8d2f3c2e6803c24b2f5f780',
        120172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eee09e94736f939d9f42ca919cf2a0d3b51559117fd21cf7a5027e340eef01d9',
        120908,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bded165118312a05b530c85edbcfdc69ad1d21e3e44b94c330510ca6b582f373',
        120660,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BigShouldersInlineText',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Big Shoulders Inline Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Inline+Text
  static TextTheme bigShouldersInlineTextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.bigShouldersInlineText(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bigShouldersInlineText(
          textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.bigShouldersInlineText(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bigShouldersInlineText(
          textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.bigShouldersInlineText(
          textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bigShouldersInlineText(
          textStyle: textTheme.headlineSmall),
      titleLarge:
          GoogleFonts.bigShouldersInlineText(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.bigShouldersInlineText(textStyle: textTheme.titleMedium),
      titleSmall:
          GoogleFonts.bigShouldersInlineText(textStyle: textTheme.titleSmall),
      bodyLarge:
          GoogleFonts.bigShouldersInlineText(textStyle: textTheme.bodyLarge),
      bodyMedium:
          GoogleFonts.bigShouldersInlineText(textStyle: textTheme.bodyMedium),
      bodySmall:
          GoogleFonts.bigShouldersInlineText(textStyle: textTheme.bodySmall),
      labelLarge:
          GoogleFonts.bigShouldersInlineText(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.bigShouldersInlineText(textStyle: textTheme.labelMedium),
      labelSmall:
          GoogleFonts.bigShouldersInlineText(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Big Shoulders Stencil Display font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Stencil+Display
  static TextStyle bigShouldersStencilDisplay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eabbc355b0d0465092961ca6fae48cd6159057c463cbb82e1969a2996c7c6e12',
        69944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'aad9df4c493a62185f144b9d9d1bca803e872573de3a78732cee421c563af16a',
        70508,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '93b4f8acec1cdd1cfa2af123e9ea2cca3e3150f302129ac85b51b376a1ca997f',
        70660,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9f34ba7d640cf6b2c5f5b19fd5c07f125c7850f3020cdae3c1a37e6f7b85229a',
        70752,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '801f03cf662a019d5e33b9e0a0ce188d7a309508cd218f5df996bc1debfc83df',
        70852,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'daf8edf2f0809b1e56d124a66f40bab70bed0b41fc2f075a58a36eb1a430130c',
        70876,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c24345c110d8d01c1d672219589a4808f68396bfce02dd92894c9b2f7386ea1d',
        70804,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c9b3148723c3f1b9aae82f5f153206b729fc9e00ce3fd9093a4682a2e214a2e6',
        70988,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dec34c0019dd1c1c751a3e14347fd36994f2d997490b7f44f9904a31142a80f7',
        71172,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BigShouldersStencilDisplay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Big Shoulders Stencil Display font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Stencil+Display
  static TextTheme bigShouldersStencilDisplayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Big Shoulders Stencil Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Stencil+Text
  static TextStyle bigShouldersStencilText({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0e0abc416e3da80605574eab33ae260541c931467052aaeff3ddac8cb2bc692d',
        70580,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bf544c9deab6f34a3f98c13f44fab98d4a2470957ba21081630329958369c4c7',
        70800,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '531eba2096fa1cd74ac4bf1dac5b1f0de6a6ff14a24aec33ea24422f4f689cad',
        70916,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0c283d623ece3b61c3cbc0b4701f43cc32b4c76d47ae9f2c80a61c97f8c726fa',
        70872,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2439bde77972abdeb1f0de09004f3b6982a99ec0a5fba772b8423dab73e40c3c',
        70964,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eca1d1b107d80771db4b3f6d460210ba8cccab99ae36a561e5e95e5d842ab908',
        70976,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '66b08e1d1279eea5b2a0f01c6581d509dcb466570d8599988e4d9cdde09b16e9',
        70920,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fb39895a23b2eccd98b604715d0f81db0ae8850c8db7343c1f8aa260834e28fd',
        71216,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7fefc4530dafa014fa577c193a42f8d6d31e5449b96a29d2e893783be01c76ff',
        71016,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BigShouldersStencilText',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Big Shoulders Stencil Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Stencil+Text
  static TextTheme bigShouldersStencilTextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bigShouldersStencilText(
          textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bigShouldersStencilText(
          textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bigShouldersStencilText(
          textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bigShouldersStencilText(
          textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.bigShouldersStencilText(
          textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bigShouldersStencilText(
          textStyle: textTheme.headlineSmall),
      titleLarge:
          GoogleFonts.bigShouldersStencilText(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.bigShouldersStencilText(textStyle: textTheme.titleMedium),
      titleSmall:
          GoogleFonts.bigShouldersStencilText(textStyle: textTheme.titleSmall),
      bodyLarge:
          GoogleFonts.bigShouldersStencilText(textStyle: textTheme.bodyLarge),
      bodyMedium:
          GoogleFonts.bigShouldersStencilText(textStyle: textTheme.bodyMedium),
      bodySmall:
          GoogleFonts.bigShouldersStencilText(textStyle: textTheme.bodySmall),
      labelLarge:
          GoogleFonts.bigShouldersStencilText(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.bigShouldersStencilText(textStyle: textTheme.labelMedium),
      labelSmall:
          GoogleFonts.bigShouldersStencilText(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Big Shoulders Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Text
  static TextStyle bigShouldersText({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9a728478429c0a37f66255e5d7f389d6a919f155e88545a3bc437f43a98f8bcc',
        68232,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b53df4ee1357e155e0b4bd789438f8e16ed42fc9dc7738840ee71732e566cecb',
        68552,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fdd6ff9acbb91d3af18e608aa53a650160a3d574458906418b4960cbb4921d80',
        68608,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '919967cbf829fb68646fd651b16c9062a7e3a58d607b0870d75d4cb29e1604ff',
        68648,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e8963f6f3f6a85fef9a86bdc9bc67f893eec119472d2dd53b85b98f03bfe83f1',
        68648,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b66ac9d17a8788adf874c7a294d0588185c94a985f8749774fdba53bc0113c4d',
        68656,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6f44c2eb2795452722b53d9c51ec9c5c11417ded217b3ca0935018d7854dc441',
        68492,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '88204747df4ad8b738846ab7771cbb993f6c138a15bc2bb3d29148b4aad1d0a3',
        68788,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2c5c2eebabafc198594ffc99278e302a6cc29949d1a13f92345c3adb9f82657f',
        68552,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BigShouldersText',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Big Shoulders Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Text
  static TextTheme bigShouldersTextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.bigShouldersText(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.bigShouldersText(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.bigShouldersText(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.bigShouldersText(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bigShouldersText(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.bigShouldersText(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bigShouldersText(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.bigShouldersText(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bigShouldersText(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bigShouldersText(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bigShouldersText(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bigShouldersText(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bigShouldersText(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.bigShouldersText(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bigShouldersText(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bigelow Rules font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bigelow+Rules
  static TextStyle bigelowRules({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'efbeb0c4e0e9e760c7987d0aa8270448e9f24652c2f7d3a1d0952dbfb5a37cf1',
        56636,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BigelowRules',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bigelow Rules font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bigelow+Rules
  static TextTheme bigelowRulesTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bigelowRules(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.bigelowRules(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bigelowRules(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.bigelowRules(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bigelowRules(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.bigelowRules(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bigelowRules(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bigelowRules(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bigelowRules(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bigelowRules(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bigelowRules(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bigelowRules(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bigelowRules(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bigelowRules(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bigelowRules(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bigshot One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bigshot+One
  static TextStyle bigshotOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f081174a9d1b0590b7b76774254bfe66401bff9a429270827357701c6d5dc735',
        34916,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BigshotOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bigshot One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bigshot+One
  static TextTheme bigshotOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bigshotOne(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bigshotOne(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bigshotOne(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bigshotOne(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bigshotOne(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bigshotOne(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bigshotOne(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bigshotOne(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bigshotOne(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bigshotOne(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bigshotOne(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bigshotOne(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bigshotOne(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bigshotOne(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bigshotOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bilbo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bilbo
  static TextStyle bilbo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0174301b7104430b8e205fe4a1d0a4b2986563fccb28c8f9720ffd796e1504b7',
        61336,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bilbo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bilbo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bilbo
  static TextTheme bilboTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bilbo(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bilbo(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bilbo(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bilbo(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.bilbo(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bilbo(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bilbo(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bilbo(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bilbo(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bilbo(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bilbo(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bilbo(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bilbo(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bilbo(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bilbo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bilbo Swash Caps font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bilbo+Swash+Caps
  static TextStyle bilboSwashCaps({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '827a279b346b5d528b5720ab1c184e7234eb24ae26c68624704db247f3c2ad05',
        56284,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BilboSwashCaps',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bilbo Swash Caps font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bilbo+Swash+Caps
  static TextTheme bilboSwashCapsTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.bilboSwashCaps(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.bilboSwashCaps(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.bilboSwashCaps(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.bilboSwashCaps(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bilboSwashCaps(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.bilboSwashCaps(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bilboSwashCaps(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bilboSwashCaps(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bilboSwashCaps(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bilboSwashCaps(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bilboSwashCaps(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bilboSwashCaps(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bilboSwashCaps(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bilboSwashCaps(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bilboSwashCaps(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the BioRhyme font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BioRhyme
  static TextStyle bioRhyme({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9e1d22f6c2b8fd3f4030e8cd1d3d6c0d20ef77bef1783c572e85df017cfa95d6',
        52400,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '63ba145799e5d9355743edd28edb631c3529417c409a22c057076c719ba5eebb',
        54012,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ac9cec6779aa06a1dd58d81b1cbb3fd36964db6d5aa9910338c1dbb80e0ddb8f',
        53532,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8ba09a328383d8719ba6fb290081759ed43283ac6b344c67828a561579c96a76',
        53420,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5217cd95a2137f0a25a00eccfe99dd21f5749ae15c78075ba64b1ea2a36b1f45',
        51668,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BioRhyme',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the BioRhyme font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BioRhyme
  static TextTheme bioRhymeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bioRhyme(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bioRhyme(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bioRhyme(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bioRhyme(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.bioRhyme(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bioRhyme(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bioRhyme(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bioRhyme(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bioRhyme(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bioRhyme(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bioRhyme(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bioRhyme(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bioRhyme(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bioRhyme(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bioRhyme(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the BioRhyme Expanded font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BioRhyme+Expanded
  static TextStyle bioRhymeExpanded({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '881a92128652817d4d4d82e1ab0118b68f229f6d5d846be2dcde00387180b327',
        52336,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '23e1a724ab0bcca5fdcdcff044cf548f96346cf5e968db03cff3afdc332b2bf7',
        54192,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '26f20b17b099ab193d86802d065e2447d8a0a6625f6db52af3b79c160ae5962c',
        53724,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1ed9fa721120ce4e679f0824b6ecfc042e4eead68b1a4fb78ab3a807e361d5ce',
        53704,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'da158566950535c86f49930e7faaca68722adaf0f67c7f20048c76f45f004484',
        53064,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BioRhymeExpanded',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the BioRhyme Expanded font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BioRhyme+Expanded
  static TextTheme bioRhymeExpandedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.bioRhymeExpanded(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.bioRhymeExpanded(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.bioRhymeExpanded(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.bioRhymeExpanded(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bioRhymeExpanded(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.bioRhymeExpanded(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bioRhymeExpanded(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.bioRhymeExpanded(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bioRhymeExpanded(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bioRhymeExpanded(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bioRhymeExpanded(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bioRhymeExpanded(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bioRhymeExpanded(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.bioRhymeExpanded(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bioRhymeExpanded(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Birthstone font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Birthstone
  static TextStyle birthstone({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f3d248062a495d35e1234712de6d4e67724c5ebe2436f5597a457129950a850c',
        97112,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Birthstone',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Birthstone font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Birthstone
  static TextTheme birthstoneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.birthstone(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.birthstone(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.birthstone(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.birthstone(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.birthstone(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.birthstone(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.birthstone(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.birthstone(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.birthstone(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.birthstone(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.birthstone(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.birthstone(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.birthstone(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.birthstone(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.birthstone(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Birthstone Bounce font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Birthstone+Bounce
  static TextStyle birthstoneBounce({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'db4a20734f94b167a8b7b97639a8c07289d1f25c41afec846ea4d0fa0863fcf0',
        131944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '87c3ba7dc30ec3cc8a7538a0a49d8a2b382dadbee3bd9b366843510f7a6f6357',
        129296,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BirthstoneBounce',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Birthstone Bounce font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Birthstone+Bounce
  static TextTheme birthstoneBounceTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.birthstoneBounce(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.birthstoneBounce(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.birthstoneBounce(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.birthstoneBounce(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.birthstoneBounce(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.birthstoneBounce(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.birthstoneBounce(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.birthstoneBounce(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.birthstoneBounce(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.birthstoneBounce(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.birthstoneBounce(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.birthstoneBounce(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.birthstoneBounce(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.birthstoneBounce(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.birthstoneBounce(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Biryani font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Biryani
  static TextStyle biryani({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9e7dcec71c8253473d19a2c3d1de421262308136b9214f475718d265bd9ffc1a',
        116780,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e57ece68a386e84e678522598d31f5a19d88072f68a6692998097cbea121afbb',
        117180,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c55ac2d7c724034dc3579a4eeeb05d782e0eefe97cf34cdb97290ed1f10e4b6b',
        116488,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '37d035dd717b7dbd22491fbbda7503213a8e1ccc2133a8acdda1606fa97a58fe',
        116460,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f245fc809af34283afedd64b5598a9cd97ef9ca446c6cdd76794d738c67a23da',
        116280,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '540e82650fb8d83eaeaf29f6c5130af4191caefbdac343eb7961a3410d4143b9',
        116244,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7bf8aab125d9bb490cb552060c2a7cae508ba90769a9071e34c1f4396319ec0e',
        115348,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Biryani',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Biryani font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Biryani
  static TextTheme biryaniTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.biryani(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.biryani(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.biryani(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.biryani(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.biryani(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.biryani(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.biryani(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.biryani(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.biryani(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.biryani(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.biryani(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.biryani(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.biryani(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.biryani(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.biryani(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bitter font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bitter
  static TextStyle bitter({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f17a165144701641df6b2744e02c82832a519761eaa9e5048c2c6da1968a4e59',
        141592,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '452a977073c54b94897015a16021be36d9a0f2e02fa4ec03804120b85dc29c03',
        142900,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1eaecd52edd3ee94e4346e796dba245b0d7d1323d7996e16f51ffc2e7d01b157',
        142968,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6b2aefc0b2e78458ed9e9b22172ca759377e3fe411483172d4440b370dbb6c4d',
        143048,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '80a89601751473c6fae921ec8343ef11a5936b30dc9378cef38e3dfc387ee5bc',
        143176,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3a58c8005008f312d018b71a8746104c4c0f9befd6920a78d17fe8a9f07ad54d',
        143224,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e78f30fbb2e02e8c49249616ce88b291aa75a856010cf0f702c1e32fbeb4e1d2',
        143148,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '27f7ba98b95a17426352c16a04efa4db8150be23f1399800ab7e699e154c1482',
        143320,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0a2bd0e8116634646943791734a54b169060e9f41f55c8b1740676a2fdc5c635',
        142940,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '587d34e61bc33f9c0ea8655db39fa783060010dbd706995367830cf3ae9b3635',
        139172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6ff686beb2aa1e5d8b199895639619af52defbbba0985de9c4a56dd8fffc78e4',
        139992,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3267071c05833e7e4cdc52abcc9ecdace03d03c69e209c108fd72a84e3984829',
        139992,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5e6e17d5e1f75443f11eedcbe0eb1bec4a5c8c4dfd5f6a9e4db925116ef9925e',
        140012,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a1825d2ae2a9cf8435f0d065aef9bab012787ca09c138f676887d77b69a7396f',
        140112,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b542b8f09fab4350c5c48cab2e982ec37d0cb603386852ca4bb5f9a9549ea2b8',
        140028,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b54598360de0d9e2ae0641f0b3490a30a08fee00550f5453652f0551486e4a6d',
        139932,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b219eae9fe3e53879dd13b4afa2ed54a6fdb88e0df546046f21482a084f92622',
        140080,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6ff23bac5f13c262cd6f4d0ee486f6a52e543090e1c2d52d660359a007e0c0e4',
        139904,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bitter',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bitter font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bitter
  static TextTheme bitterTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bitter(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bitter(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bitter(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bitter(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.bitter(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bitter(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bitter(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bitter(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bitter(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bitter(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bitter(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bitter(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bitter(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bitter(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bitter(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Black And White Picture font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Black+And+White+Picture
  static TextStyle blackAndWhitePicture({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd07457649aa55560e0447e1a1e68f9fdb4fb18e354e8d59e114de7822c9095be',
        9586668,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BlackAndWhitePicture',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Black And White Picture font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Black+And+White+Picture
  static TextTheme blackAndWhitePictureTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.headlineSmall),
      titleLarge:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.titleLarge),
      titleMedium:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.titleMedium),
      titleSmall:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.titleSmall),
      bodyLarge:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.bodyLarge),
      bodyMedium:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.bodyMedium),
      bodySmall:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.bodySmall),
      labelLarge:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.labelLarge),
      labelMedium:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.labelMedium),
      labelSmall:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Black Han Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Black+Han+Sans
  static TextStyle blackHanSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8dcf48b16536fac5d24f2f07525984fadf5906f9488c7228f6af3d9b75cb9401',
        382948,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BlackHanSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Black Han Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Black+Han+Sans
  static TextTheme blackHanSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.blackHanSans(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.blackHanSans(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.blackHanSans(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.blackHanSans(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.blackHanSans(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.blackHanSans(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.blackHanSans(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.blackHanSans(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.blackHanSans(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.blackHanSans(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.blackHanSans(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.blackHanSans(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.blackHanSans(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.blackHanSans(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.blackHanSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Black Ops One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Black+Ops+One
  static TextStyle blackOpsOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '816f46d22aeeb3addf5fde41a11d30ac690ceb32decf4c56c455cb4d3fb90bfe',
        37612,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BlackOpsOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Black Ops One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Black+Ops+One
  static TextTheme blackOpsOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.blackOpsOne(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.blackOpsOne(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.blackOpsOne(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.blackOpsOne(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.blackOpsOne(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.blackOpsOne(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.blackOpsOne(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.blackOpsOne(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.blackOpsOne(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.blackOpsOne(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.blackOpsOne(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.blackOpsOne(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.blackOpsOne(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.blackOpsOne(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.blackOpsOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Blinker font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Blinker
  static TextStyle blinker({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '51b809278a949f05dafcc101824deeab10c80e0221d1734f654a51d0bf796fbc',
        48360,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '61a63131a99d2435ed7299527f3885301138703e44a7cfbb6dffba6c9ceb01df',
        49784,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6723b02106db85856f4bb2ba1eebc1ae56f1dabe226edc46309904991f7da479',
        49632,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9a5d55082962f20a84279ed71094bc130144f2ac5b3079ada3baa1d1af1c1ba7',
        48848,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '384f2be475e8c439c77d203a5f3140cc1d375b5ad598b8bb329f61b4b034661b',
        54592,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '425f71e0903f9bc13229300987926eed3c8fee62bbf604257da452af7e4ec780',
        50068,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '92853879e3b9211cb569cb80cf217a294e2206fc11b9117b6b8b06298d7889af',
        54240,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8633fde2851097965b5c3c95cb937ecbf2f8104a73887b7194ef35d52cb8f4a5',
        53496,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Blinker',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Blinker font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Blinker
  static TextTheme blinkerTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.blinker(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.blinker(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.blinker(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.blinker(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.blinker(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.blinker(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.blinker(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.blinker(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.blinker(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.blinker(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.blinker(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.blinker(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.blinker(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.blinker(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.blinker(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bodoni Moda font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bodoni+Moda
  static TextStyle bodoniModa({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f69437cfe3e26893e37bf96a2340db64c6e74d1511b30aed4a4253209605648d',
        40240,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0d3ef99a323d6aceebe327b7bb15e0e69ab71343f17fdee6bc4162a5929b5f8f',
        40316,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bfa9d9bbdd48390fb77e5fbb2cb6d100b41939fc7c832e1995528c926f405e92',
        40352,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f9c4f8ff9bdbb2c18210e4ca73904a2f31ed7b97735fd697bf30afe4f2c247a0',
        40332,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1308b28b7c85048f2d3a8d072ab64f05dadb439b0c30dc43eec0aae2a299fcfb',
        40404,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b8fbea1abab4a41a99e2df9c52b5fc068bc2b5a409e27fc1c00ff5820011d373',
        40344,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6da3c02e992a1809b85b0e15473ad5327ae332fb36fe59f2bb371b8ee0ab4925',
        44120,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '519bb993829978dab11275f56cfd087d96ae3c7fae8c4aecb5cb66bb8d46e56f',
        44260,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7330e93cbc626eec14be85ee284dc27afa642da7f5d9e51053746ae42351af85',
        44320,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4264d0b03e9efe8de3355a08923cdb27dda80b504d13c6d6d018c51c4cb70815',
        44284,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd01427766fd8727dc6bb300ca459fa7e0379ae1edfe9bfa6832435c7797bff2d',
        44416,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'dd85ad3b22536e77cad5165e67953e19c089f0a5bd196b33c64b15325127d987',
        44384,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BodoniModa',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bodoni Moda font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bodoni+Moda
  static TextTheme bodoniModaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bodoniModa(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bodoniModa(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bodoniModa(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bodoniModa(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bodoniModa(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bodoniModa(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bodoniModa(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bodoniModa(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bodoniModa(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bodoniModa(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bodoniModa(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bodoniModa(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bodoniModa(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bodoniModa(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bodoniModa(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bokor font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bokor
  static TextStyle bokor({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '48dc3bbb53942fe0f1dcda871b0b6600f23c80b68ea80345c182f17f10e36639',
        75392,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bokor',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bokor font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bokor
  static TextTheme bokorTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bokor(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bokor(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bokor(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bokor(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.bokor(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bokor(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bokor(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bokor(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bokor(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bokor(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bokor(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bokor(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bokor(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bokor(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bokor(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bona Nova font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bona+Nova
  static TextStyle bonaNova({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '078d2bfcfc80d682132d953545812db70e0f9f0b98ae0cac142ea71b158d1318',
        198112,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f09688cecf4b8ba9818a169e25b836f04679a229109cb520cc95adef6e6ad81d',
        215808,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '43adb619f6b73f11f25abeeb80e1afc75285c402742402228abf38595b558505',
        196232,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BonaNova',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bona Nova font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bona+Nova
  static TextTheme bonaNovaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bonaNova(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bonaNova(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bonaNova(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bonaNova(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.bonaNova(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bonaNova(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bonaNova(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bonaNova(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bonaNova(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bonaNova(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bonaNova(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bonaNova(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bonaNova(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bonaNova(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bonaNova(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bonbon font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bonbon
  static TextStyle bonbon({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c04cb293742f9b01b0a1ebcf45eef3904303d0777d8289f8ed5202731bcf9e2d',
        33764,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bonbon',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bonbon font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bonbon
  static TextTheme bonbonTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bonbon(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bonbon(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bonbon(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bonbon(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.bonbon(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bonbon(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bonbon(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bonbon(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bonbon(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bonbon(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bonbon(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bonbon(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bonbon(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bonbon(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bonbon(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bonheur Royale font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bonheur+Royale
  static TextStyle bonheurRoyale({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '962bd9c44fd65031a838196c18c0b1056fa2a0e51177c9bfa257707464c1cd34',
        87220,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BonheurRoyale',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bonheur Royale font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bonheur+Royale
  static TextTheme bonheurRoyaleTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.bonheurRoyale(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.bonheurRoyale(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.bonheurRoyale(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.bonheurRoyale(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bonheurRoyale(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.bonheurRoyale(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bonheurRoyale(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bonheurRoyale(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bonheurRoyale(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bonheurRoyale(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bonheurRoyale(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bonheurRoyale(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bonheurRoyale(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bonheurRoyale(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bonheurRoyale(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Boogaloo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Boogaloo
  static TextStyle boogaloo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '486b374056bf3e62615ffa5d53c779645aac9675c237d6d509d390dc877590dc',
        31224,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Boogaloo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Boogaloo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Boogaloo
  static TextTheme boogalooTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.boogaloo(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.boogaloo(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.boogaloo(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.boogaloo(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.boogaloo(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.boogaloo(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.boogaloo(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.boogaloo(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.boogaloo(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.boogaloo(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.boogaloo(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.boogaloo(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.boogaloo(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.boogaloo(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.boogaloo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bowlby One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bowlby+One
  static TextStyle bowlbyOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c1fd01bc4cbebc94ca1244ef3704cf4e2c15b1d6437a8b79c5ee7a7ab4bdb772',
        58032,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BowlbyOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bowlby One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bowlby+One
  static TextTheme bowlbyOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bowlbyOne(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bowlbyOne(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bowlbyOne(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bowlbyOne(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bowlbyOne(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bowlbyOne(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bowlbyOne(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bowlbyOne(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bowlbyOne(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bowlbyOne(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bowlbyOne(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bowlbyOne(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bowlbyOne(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bowlbyOne(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bowlbyOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bowlby One SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bowlby+One+SC
  static TextStyle bowlbyOneSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0ba36536cd70dbef95603215ca6c79c9c8f711b0ed8e88f5fb1c2a2521cf5306',
        42508,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BowlbyOneSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bowlby One SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bowlby+One+SC
  static TextTheme bowlbyOneScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bowlbyOneSc(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.bowlbyOneSc(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bowlbyOneSc(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.bowlbyOneSc(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bowlbyOneSc(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.bowlbyOneSc(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bowlbyOneSc(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bowlbyOneSc(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bowlbyOneSc(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bowlbyOneSc(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bowlbyOneSc(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bowlbyOneSc(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bowlbyOneSc(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bowlbyOneSc(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bowlbyOneSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Brawler font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Brawler
  static TextStyle brawler({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd1d99ea60caa66d62f590c76f585d98017a2ec6218ac780cadc9e70b1ed635ea',
        39088,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '46ec2bf8116aad4bac1627a1270e6313a630b72aa32acb27e5c8a8365ed4aa34',
        32472,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Brawler',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Brawler font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Brawler
  static TextTheme brawlerTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.brawler(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.brawler(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.brawler(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.brawler(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.brawler(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.brawler(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.brawler(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.brawler(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.brawler(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.brawler(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.brawler(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.brawler(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.brawler(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.brawler(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.brawler(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bree Serif font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bree+Serif
  static TextStyle breeSerif({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5502b26521a10457b7069809f6b093a2f84697033833fc0d231c14fc3d98449f',
        42876,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BreeSerif',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bree Serif font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bree+Serif
  static TextTheme breeSerifTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.breeSerif(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.breeSerif(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.breeSerif(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.breeSerif(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.breeSerif(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.breeSerif(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.breeSerif(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.breeSerif(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.breeSerif(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.breeSerif(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.breeSerif(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.breeSerif(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.breeSerif(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.breeSerif(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.breeSerif(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Brygada 1918 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Brygada+1918
  static TextStyle brygada1918({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e7fcc3f4acfcaa3d245edff8d0218d3330b35bbaa5a62c069edd37caa13c764e',
        121484,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '087e581b96d490f120e58844c91fffb13af8934bfc433bb8e34ee28838d9b989',
        122024,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ed5884598cf23102d8295885a8e4ff3e48a0b978407ff2374331c2efb8f84bbd',
        121992,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '76749402ad6df348c5ed7d152476f687e8bcff08e6686495979d6624036f2102',
        121920,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '81286c6a2d8405995a5c5b45e325a5e281a816bc60f7f912596c468032408045',
        120804,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1d3d91639e7be0623deaffe68fb0a69c19a1e3af86cfb94b9741d53a90cc1bd4',
        121000,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5944de849b60ea9ce63de8e400e74bdb6a5e988ad1d32ec474f98316ac2a2b86',
        121124,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c024f6b3f3ca23a435568420b6d9ee12cc4c6c325b844775af731595bc8da8cd',
        121028,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Brygada1918',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Brygada 1918 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Brygada+1918
  static TextTheme brygada1918TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.brygada1918(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.brygada1918(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.brygada1918(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.brygada1918(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.brygada1918(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.brygada1918(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.brygada1918(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.brygada1918(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.brygada1918(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.brygada1918(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.brygada1918(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.brygada1918(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.brygada1918(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.brygada1918(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.brygada1918(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bubblegum Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bubblegum+Sans
  static TextStyle bubblegumSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '92696a5b4ea36589da7abe61c35ed8a1c4f801c6ff3620dea990247dda3ed78e',
        36660,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BubblegumSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bubblegum Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bubblegum+Sans
  static TextTheme bubblegumSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.bubblegumSans(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.bubblegumSans(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.bubblegumSans(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.bubblegumSans(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bubblegumSans(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.bubblegumSans(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bubblegumSans(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bubblegumSans(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bubblegumSans(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bubblegumSans(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bubblegumSans(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bubblegumSans(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bubblegumSans(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bubblegumSans(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bubblegumSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bubbler One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bubbler+One
  static TextStyle bubblerOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bc352921d088df991317e810a93f04557ee49583ae17895e9fd7970bf30f6b52',
        29220,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BubblerOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bubbler One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bubbler+One
  static TextTheme bubblerOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bubblerOne(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bubblerOne(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bubblerOne(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bubblerOne(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bubblerOne(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bubblerOne(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bubblerOne(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bubblerOne(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bubblerOne(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bubblerOne(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bubblerOne(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bubblerOne(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bubblerOne(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bubblerOne(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bubblerOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Buda font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Buda
  static TextStyle buda({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ddf9a00ad35f40985a1676848fc4fab5a143849227030354f494772914814d3f',
        33320,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Buda',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Buda font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Buda
  static TextTheme budaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.buda(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.buda(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.buda(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.buda(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.buda(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.buda(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.buda(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.buda(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.buda(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.buda(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.buda(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.buda(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.buda(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.buda(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.buda(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Buenard font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Buenard
  static TextStyle buenard({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c6530a057f44e97cf7b5124e45286942b0dd5cb652533e320357df9c3a712d26',
        56568,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3098b97edeca864f79b6d2b8433c04363b80a8219f40e2f05b5fa2481e2e38e7',
        55608,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Buenard',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Buenard font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Buenard
  static TextTheme buenardTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.buenard(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.buenard(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.buenard(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.buenard(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.buenard(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.buenard(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.buenard(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.buenard(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.buenard(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.buenard(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.buenard(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.buenard(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.buenard(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.buenard(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.buenard(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bungee font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee
  static TextStyle bungee({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e2569977dab0311f3a357de2a9c5abeb40eb1d7951efb106f1e67571d140236a',
        105464,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bungee',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bungee font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee
  static TextTheme bungeeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bungee(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.bungee(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bungee(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.bungee(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.bungee(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.bungee(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bungee(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bungee(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bungee(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bungee(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bungee(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bungee(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bungee(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bungee(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bungee(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bungee Hairline font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Hairline
  static TextStyle bungeeHairline({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '115ae14e03cd0ce05ffef17d611ec60bbc1a0136ef36096f7f0fdf7ca8d2c0b0',
        86124,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BungeeHairline',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bungee Hairline font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Hairline
  static TextTheme bungeeHairlineTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.bungeeHairline(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.bungeeHairline(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.bungeeHairline(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.bungeeHairline(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bungeeHairline(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.bungeeHairline(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bungeeHairline(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bungeeHairline(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bungeeHairline(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bungeeHairline(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bungeeHairline(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bungeeHairline(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bungeeHairline(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bungeeHairline(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bungeeHairline(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bungee Inline font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Inline
  static TextStyle bungeeInline({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6ed32d345a9b6d5d529836f293c9f2a16822f7134f459840824200da44ce2a8c',
        136280,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BungeeInline',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bungee Inline font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Inline
  static TextTheme bungeeInlineTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bungeeInline(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.bungeeInline(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bungeeInline(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.bungeeInline(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bungeeInline(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.bungeeInline(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bungeeInline(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bungeeInline(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bungeeInline(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bungeeInline(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bungeeInline(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bungeeInline(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bungeeInline(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bungeeInline(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bungeeInline(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bungee Outline font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Outline
  static TextStyle bungeeOutline({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '09a3971e578125a8179bb13ee7156b0b3f1500ad59a574b9c30645fd6b534e75',
        188572,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BungeeOutline',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bungee Outline font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Outline
  static TextTheme bungeeOutlineTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.bungeeOutline(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.bungeeOutline(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.bungeeOutline(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.bungeeOutline(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bungeeOutline(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.bungeeOutline(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bungeeOutline(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bungeeOutline(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bungeeOutline(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bungeeOutline(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bungeeOutline(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bungeeOutline(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bungeeOutline(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bungeeOutline(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bungeeOutline(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Bungee Shade font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Shade
  static TextStyle bungeeShade({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '61b279c3dedd9d40cc0351dc8847c2529f7b04f578cc7ecb0cb290aaf7f7ca41',
        322132,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BungeeShade',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bungee Shade font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Shade
  static TextTheme bungeeShadeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.bungeeShade(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.bungeeShade(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.bungeeShade(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.bungeeShade(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.bungeeShade(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.bungeeShade(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.bungeeShade(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.bungeeShade(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.bungeeShade(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.bungeeShade(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.bungeeShade(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.bungeeShade(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.bungeeShade(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.bungeeShade(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.bungeeShade(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Butcherman font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Butcherman
  static TextStyle butcherman({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '60fbc7f29a31d0500a432d0723b8770f65ea6319fdd801b6c45c1ad83b505c04',
        63296,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Butcherman',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Butcherman font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Butcherman
  static TextTheme butchermanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.butcherman(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.butcherman(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.butcherman(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.butcherman(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.butcherman(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.butcherman(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.butcherman(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.butcherman(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.butcherman(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.butcherman(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.butcherman(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.butcherman(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.butcherman(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.butcherman(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.butcherman(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Butterfly Kids font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Butterfly+Kids
  static TextStyle butterflyKids({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a6b60f81c67fe1ad20fc13cb44ab4f48fc51a94b066e9b7d9b47e0c32ebeb4a9',
        200392,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ButterflyKids',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Butterfly Kids font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Butterfly+Kids
  static TextTheme butterflyKidsTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.butterflyKids(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.butterflyKids(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.butterflyKids(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.butterflyKids(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.butterflyKids(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.butterflyKids(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.butterflyKids(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.butterflyKids(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.butterflyKids(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.butterflyKids(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.butterflyKids(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.butterflyKids(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.butterflyKids(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.butterflyKids(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.butterflyKids(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cabin font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cabin
  static TextStyle cabin({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ed5b29d612dde4107ede74a224cd1c8f31ff9eed393fcd6d2e5b5f188aa94b5c',
        74532,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '08f84fe11da1e806d21e425e00ad4c8816caad60ac8b88770c821c4c9fd36059',
        74612,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b6000f23574dd9ad5475537064b99ec840d69977f373e257abef1fce0b039231',
        74624,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fea4ef3c4efd745c6bbbe22b78f5d25aed1eb64e76a363bd19befc3c31c7785b',
        74312,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c8a0d557e341b8cc191a1bf8cb1ba1e797ded81b801cf0fbb46240911baef466',
        64624,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '55644d60717f27db49319774f52c99d4a75345072ba58263667251cd3eb16b55',
        64848,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2d0e16da298a0f08e9f50cfb48d7bb9366237971c956a37c7cc32ea5c0206d34',
        64896,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8ccda1c8d54e60d19cd24818957d83322556812412740edd95af2eb943e12fb8',
        64480,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cabin',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cabin font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cabin
  static TextTheme cabinTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.cabin(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.cabin(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.cabin(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.cabin(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.cabin(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.cabin(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.cabin(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.cabin(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.cabin(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.cabin(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.cabin(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.cabin(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.cabin(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.cabin(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.cabin(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cabin Condensed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cabin+Condensed
  static TextStyle cabinCondensed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e7b1fe0fb3be326f98c9054e2071a08d58a6a5b81ab59b67060f66d752a440c3',
        67168,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8dcee43bf621fd803a278926895c6ab619871af4a2808562255e8eca58b62227',
        66768,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2b967310e5c94787ae27a63f52593db860f28be18497886fcd5c550d6dc70841',
        66760,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8f1bd3239cc7437ba9b197545412080d7325a7ae460c779f0aa8033b642ab178',
        66768,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CabinCondensed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cabin Condensed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cabin+Condensed
  static TextTheme cabinCondensedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.cabinCondensed(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.cabinCondensed(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.cabinCondensed(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.cabinCondensed(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.cabinCondensed(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.cabinCondensed(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.cabinCondensed(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.cabinCondensed(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.cabinCondensed(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.cabinCondensed(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.cabinCondensed(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.cabinCondensed(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.cabinCondensed(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.cabinCondensed(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.cabinCondensed(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cabin Sketch font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cabin+Sketch
  static TextStyle cabinSketch({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6a821d6a98e37151c44a6d1226a34ebfaf705a7414b049dff06dda2517e238c2',
        152760,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f5a372191df6c57b4e514bc8e3dae0fcc2e0a64359c8253e70dca96533ed11d5',
        267556,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CabinSketch',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cabin Sketch font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cabin+Sketch
  static TextTheme cabinSketchTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.cabinSketch(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.cabinSketch(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.cabinSketch(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.cabinSketch(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.cabinSketch(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.cabinSketch(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.cabinSketch(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.cabinSketch(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.cabinSketch(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.cabinSketch(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.cabinSketch(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.cabinSketch(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.cabinSketch(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.cabinSketch(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.cabinSketch(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Caesar Dressing font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caesar+Dressing
  static TextStyle caesarDressing({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '52b849458b688259ce15c907f0722ddc2c4dd6b45dd71a0f287191ce0e4db40e',
        87520,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CaesarDressing',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Caesar Dressing font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caesar+Dressing
  static TextTheme caesarDressingTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.caesarDressing(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.caesarDressing(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.caesarDressing(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.caesarDressing(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.caesarDressing(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.caesarDressing(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.caesarDressing(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.caesarDressing(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.caesarDressing(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.caesarDressing(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.caesarDressing(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.caesarDressing(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.caesarDressing(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.caesarDressing(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.caesarDressing(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cagliostro font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cagliostro
  static TextStyle cagliostro({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4ece09548add33daa4de57fc47a300709075535ebb0c8dcefa275e36a6eec55e',
        34876,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cagliostro',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cagliostro font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cagliostro
  static TextTheme cagliostroTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.cagliostro(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.cagliostro(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.cagliostro(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.cagliostro(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.cagliostro(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.cagliostro(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.cagliostro(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.cagliostro(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.cagliostro(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.cagliostro(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.cagliostro(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.cagliostro(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.cagliostro(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.cagliostro(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.cagliostro(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cairo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cairo
  static TextStyle cairo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '84bc0593d685b370e8b22e9b7bc17d945e81b4b7217989500c1fd1b8e44383ae',
        91280,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5e5b1dd727d1bb77da39bababcf60cb4143bd22e02f811cd9575d00c7c3db9f9',
        91340,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '778738a35ed7648c76b52fd1527c9db12ea3155b9323682ce35c2f5529ae4c13',
        91296,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2f513d4b6f905c28357d363efc780cfaa22e3d1218a8b749d3b55685c81a2940',
        91488,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9e1ae32a0797ab853bf226b1f34802e25c2b4521af432c62e65f05eb7f5ef042',
        91528,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '93fc07d3272d2cc54ca3b224f45f250639e58492823eb633650189975106fed3',
        91436,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e58f2ce40805b6e051718bf9a238bfe7c2057e384ab9d71d5e0cfca40b3aad82',
        91516,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '51d40d737853595ab3884abbc2af47ca39e49b98885d479e2399f2ef784adb93',
        91488,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cairo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cairo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cairo
  static TextTheme cairoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.cairo(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.cairo(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.cairo(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.cairo(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.cairo(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.cairo(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.cairo(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.cairo(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.cairo(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.cairo(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.cairo(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.cairo(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.cairo(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.cairo(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.cairo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Caladea font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caladea
  static TextStyle caladea({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b4c002a10d755da4ccaa3ebc0cdbdea21a315a95a327a41471ba4a04e0b8001d',
        52664,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1711d83d00881cbfd246656598ac8a659f41e61b337e8631118e37f415f8da49',
        52160,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '16b835559468154283080ca19d8634a28fa0f0edf71cef558a2739e7484d6cb2',
        53724,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd107506a3253ab8d36e5ac5c8a09979da3d17fccaa1addea2b31d5db7696caa5',
        52288,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Caladea',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Caladea font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caladea
  static TextTheme caladeaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.caladea(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.caladea(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.caladea(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.caladea(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.caladea(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.caladea(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.caladea(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.caladea(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.caladea(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.caladea(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.caladea(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.caladea(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.caladea(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.caladea(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.caladea(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Calistoga font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Calistoga
  static TextStyle calistoga({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '060d7a5a8892c7bae4d2e568e5154dc941220b56eab554bab647e0995e903d4a',
        78992,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Calistoga',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Calistoga font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Calistoga
  static TextTheme calistogaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.calistoga(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.calistoga(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.calistoga(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.calistoga(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.calistoga(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.calistoga(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.calistoga(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.calistoga(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.calistoga(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.calistoga(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.calistoga(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.calistoga(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.calistoga(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.calistoga(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.calistoga(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Calligraffitti font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Calligraffitti
  static TextStyle calligraffitti({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '03f3f28aba9473b7488aba63f600070b40a9d8ad73c679250b5aa2eb8cd5ab36',
        45580,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Calligraffitti',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Calligraffitti font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Calligraffitti
  static TextTheme calligraffittiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          GoogleFonts.calligraffitti(textStyle: textTheme.displayLarge),
      displayMedium:
          GoogleFonts.calligraffitti(textStyle: textTheme.displayMedium),
      displaySmall:
          GoogleFonts.calligraffitti(textStyle: textTheme.displaySmall),
      headlineLarge:
          GoogleFonts.calligraffitti(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.calligraffitti(textStyle: textTheme.headlineMedium),
      headlineSmall:
          GoogleFonts.calligraffitti(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.calligraffitti(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.calligraffitti(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.calligraffitti(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.calligraffitti(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.calligraffitti(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.calligraffitti(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.calligraffitti(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.calligraffitti(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.calligraffitti(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cambay font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cambay
  static TextStyle cambay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5cb782bada62515a174b78ca681b30681cc8466212e769e01cf54b31ee3c779d',
        136424,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7767eea34f2a90cb411f48363e42d684f425c451c00bb71bfc6a432a64a44f1d',
        152112,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7916fc2456f74f87dcafbcb796f751c53dda9565b29156f280d07f17681a045a',
        136044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c8709ac37ebf71b74486d26d90f89cdf7d5c4a2c5c7732520258af964f87693c',
        147412,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cambay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cambay font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cambay
  static TextTheme cambayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.cambay(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.cambay(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.cambay(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.cambay(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.cambay(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.cambay(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.cambay(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.cambay(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.cambay(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.cambay(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.cambay(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.cambay(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.cambay(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.cambay(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.cambay(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cambo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cambo
  static TextStyle cambo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '22fb8f1d769aae196632c166b782c40892aa85481b0e74bb931731c6dfa9104e',
        26564,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cambo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cambo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cambo
  static TextTheme camboTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.cambo(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.cambo(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.cambo(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.cambo(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.cambo(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.cambo(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.cambo(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.cambo(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.cambo(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.cambo(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.cambo(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.cambo(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.cambo(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.cambo(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.cambo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Candal font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Candal
  static TextStyle candal({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8fb20c6aeb13ec31b04077e0ff5ad4257b090fb656d3528ead0c1362df8172d2',
        30428,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Candal',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Candal font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Candal
  static TextTheme candalTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.candal(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.candal(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.candal(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.candal(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.candal(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.candal(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.candal(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.candal(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.candal(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.candal(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.candal(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.candal(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.candal(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.candal(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.candal(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cantarell font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cantarell
  static TextStyle cantarell({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '56113179ea306fa3742b7c13a96ded0677869508b82a50e273673015d49f2112',
        41992,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ab7c664b6dc0baa8dccdd6e9bd6438f520603189423355619ef4a9eba879eb9b',
        44568,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6ac4b1d4bedb7f2191931602f870bd98e258cbb47e6946011aa66235634598bd',
        43772,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3803bfcf91bfdeb45ec9873905786a1913484959994e65543b35eb7f6f07ba15',
        46688,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cantarell',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cantarell font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cantarell
  static TextTheme cantarellTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.cantarell(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.cantarell(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.cantarell(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.cantarell(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.cantarell(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.cantarell(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.cantarell(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.cantarell(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.cantarell(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.cantarell(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.cantarell(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.cantarell(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.cantarell(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.cantarell(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.cantarell(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cantata One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cantata+One
  static TextStyle cantataOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fa58eb9b16658fa12cf9c191d8c985c5f18a6cb95b8a007e674d0a1fccd1f53e',
        53244,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CantataOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cantata One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cantata+One
  static TextTheme cantataOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.cantataOne(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.cantataOne(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.cantataOne(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.cantataOne(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.cantataOne(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.cantataOne(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.cantataOne(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.cantataOne(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.cantataOne(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.cantataOne(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.cantataOne(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.cantataOne(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.cantataOne(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.cantataOne(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.cantataOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cantora One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cantora+One
  static TextStyle cantoraOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '826fb1175ba4bf0cbb5f127b52432fa0b16e332b9c13d35d81f9394b0c5a6772',
        89724,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CantoraOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cantora One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cantora+One
  static TextTheme cantoraOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.cantoraOne(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.cantoraOne(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.cantoraOne(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.cantoraOne(textStyle: textTheme.headlineLarge),
      headlineMedium:
          GoogleFonts.cantoraOne(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.cantoraOne(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.cantoraOne(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.cantoraOne(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.cantoraOne(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.cantoraOne(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.cantoraOne(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.cantoraOne(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.cantoraOne(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.cantoraOne(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.cantoraOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Capriola font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Capriola
  static TextStyle capriola({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5218e72847a9f73f64d3e1ff4784222d816bbedf85bbf565a838dba35a953755',
        71856,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Capriola',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Capriola font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Capriola
  static TextTheme capriolaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.capriola(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.capriola(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.capriola(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.capriola(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.capriola(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.capriola(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.capriola(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.capriola(textStyle: textTheme.titleMedium),
      titleSmall: GoogleFonts.capriola(textStyle: textTheme.titleSmall),
      bodyLarge: GoogleFonts.capriola(textStyle: textTheme.bodyLarge),
      bodyMedium: GoogleFonts.capriola(textStyle: textTheme.bodyMedium),
      bodySmall: GoogleFonts.capriola(textStyle: textTheme.bodySmall),
      labelLarge: GoogleFonts.capriola(textStyle: textTheme.labelLarge),
      labelMedium: GoogleFonts.capriola(textStyle: textTheme.labelMedium),
      labelSmall: GoogleFonts.capriola(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Caramel font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caramel
  static TextStyle caramel({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a80d114cb9fa5025551733589efa28c9b6f18d17fa1d0a64a019760e66369bac',
        77520,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Caramel',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Caramel font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caramel
  static TextTheme caramelTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: GoogleFonts.caramel(textStyle: textTheme.displayLarge),
      displayMedium: GoogleFonts.caramel(textStyle: textTheme.displayMedium),
      displaySmall: GoogleFonts.caramel(textStyle: textTheme.displaySmall),
      headlineLarge: GoogleFonts.caramel(textStyle: textTheme.headlineLarge),
      headlineMedium: GoogleFonts.caramel(textStyle: textTheme.headlineMedium),
      headlineSmall: GoogleFonts.caramel(textStyle: textTheme.headlineSmall),
      titleLarge: GoogleFonts.caramel(textStyle: textTheme.titleLarge),
      titleMedium: GoogleFonts.caramel(textStyle: textTheme.titl