// GENERATED CODE - DO NOT EDIT

// Copyright 2019 The Flutter team. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'dart:ui' as ui;
import 'package:flutter/material.dart';
import '../google_fonts_base.dart';
import '../google_fonts_descriptor.dart';
import '../google_fonts_variant.dart';

/// Methods for fonts starting with 'A'.
class PartA {
  /// Applies the ABeeZee font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/ABeeZee
  static TextStyle aBeeZee({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4ed0069c1454d476c52e8d8c43ffdbdd648c6a3d382da8cf078b3bb45ff82479',
        30600,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fb76fef50d4920b8ae51fa41329989b7dff2d0f0208d37b34127645a85352fa2',
        32116,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ABeeZee',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the ABeeZee font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/ABeeZee
  static TextTheme aBeeZeeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: aBeeZee(textStyle: textTheme.displayLarge),
      displayMedium: aBeeZee(textStyle: textTheme.displayMedium),
      displaySmall: aBeeZee(textStyle: textTheme.displaySmall),
      headlineLarge: aBeeZee(textStyle: textTheme.headlineLarge),
      headlineMedium: aBeeZee(textStyle: textTheme.headlineMedium),
      headlineSmall: aBeeZee(textStyle: textTheme.headlineSmall),
      titleLarge: aBeeZee(textStyle: textTheme.titleLarge),
      titleMedium: aBeeZee(textStyle: textTheme.titleMedium),
      titleSmall: aBeeZee(textStyle: textTheme.titleSmall),
      bodyLarge: aBeeZee(textStyle: textTheme.bodyLarge),
      bodyMedium: aBeeZee(textStyle: textTheme.bodyMedium),
      bodySmall: aBeeZee(textStyle: textTheme.bodySmall),
      labelLarge: aBeeZee(textStyle: textTheme.labelLarge),
      labelMedium: aBeeZee(textStyle: textTheme.labelMedium),
      labelSmall: aBeeZee(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the ADLaM Display font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/ADLaM+Display
  static TextStyle aDLaMDisplay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e74d94f2fc63b888e816efe6e5368aa9f123b03832a9199b76bd62957f0f52f3',
        69068,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ADLaMDisplay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the ADLaM Display font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/ADLaM+Display
  static TextTheme aDLaMDisplayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: aDLaMDisplay(textStyle: textTheme.displayLarge),
      displayMedium: aDLaMDisplay(textStyle: textTheme.displayMedium),
      displaySmall: aDLaMDisplay(textStyle: textTheme.displaySmall),
      headlineLarge: aDLaMDisplay(textStyle: textTheme.headlineLarge),
      headlineMedium: aDLaMDisplay(textStyle: textTheme.headlineMedium),
      headlineSmall: aDLaMDisplay(textStyle: textTheme.headlineSmall),
      titleLarge: aDLaMDisplay(textStyle: textTheme.titleLarge),
      titleMedium: aDLaMDisplay(textStyle: textTheme.titleMedium),
      titleSmall: aDLaMDisplay(textStyle: textTheme.titleSmall),
      bodyLarge: aDLaMDisplay(textStyle: textTheme.bodyLarge),
      bodyMedium: aDLaMDisplay(textStyle: textTheme.bodyMedium),
      bodySmall: aDLaMDisplay(textStyle: textTheme.bodySmall),
      labelLarge: aDLaMDisplay(textStyle: textTheme.labelLarge),
      labelMedium: aDLaMDisplay(textStyle: textTheme.labelMedium),
      labelSmall: aDLaMDisplay(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the AR One Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/AR+One+Sans
  static TextStyle arOneSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bb23754540a4bc540f92729db39384cdbef9cea606533cd81748cdb467917e77',
        95440,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '16ebf63f066f366d01b1dfed469cb2f28176c507ac66081e464666063d2f6962',
        95452,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '906fc2cf48da67d94ad35f09ebaa5cd4cbcea18e3f8417d92a84751c1c88bde3',
        95440,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'df0e676b8cfaa31736a3cedccb7d71010839dbecc53f9e78579e571e43afe6ab',
        95316,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AROneSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the AR One Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/AR+One+Sans
  static TextTheme arOneSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: arOneSans(textStyle: textTheme.displayLarge),
      displayMedium: arOneSans(textStyle: textTheme.displayMedium),
      displaySmall: arOneSans(textStyle: textTheme.displaySmall),
      headlineLarge: arOneSans(textStyle: textTheme.headlineLarge),
      headlineMedium: arOneSans(textStyle: textTheme.headlineMedium),
      headlineSmall: arOneSans(textStyle: textTheme.headlineSmall),
      titleLarge: arOneSans(textStyle: textTheme.titleLarge),
      titleMedium: arOneSans(textStyle: textTheme.titleMedium),
      titleSmall: arOneSans(textStyle: textTheme.titleSmall),
      bodyLarge: arOneSans(textStyle: textTheme.bodyLarge),
      bodyMedium: arOneSans(textStyle: textTheme.bodyMedium),
      bodySmall: arOneSans(textStyle: textTheme.bodySmall),
      labelLarge: arOneSans(textStyle: textTheme.labelLarge),
      labelMedium: arOneSans(textStyle: textTheme.labelMedium),
      labelSmall: arOneSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Abel font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Abel
  static TextStyle abel({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fbef0740397e2ca38a05f204f7129be38b2ab6bb3994a69e14d3a245e489aece',
        32648,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Abel',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Abel font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Abel
  static TextTheme abelTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: abel(textStyle: textTheme.displayLarge),
      displayMedium: abel(textStyle: textTheme.displayMedium),
      displaySmall: abel(textStyle: textTheme.displaySmall),
      headlineLarge: abel(textStyle: textTheme.headlineLarge),
      headlineMedium: abel(textStyle: textTheme.headlineMedium),
      headlineSmall: abel(textStyle: textTheme.headlineSmall),
      titleLarge: abel(textStyle: textTheme.titleLarge),
      titleMedium: abel(textStyle: textTheme.titleMedium),
      titleSmall: abel(textStyle: textTheme.titleSmall),
      bodyLarge: abel(textStyle: textTheme.bodyLarge),
      bodyMedium: abel(textStyle: textTheme.bodyMedium),
      bodySmall: abel(textStyle: textTheme.bodySmall),
      labelLarge: abel(textStyle: textTheme.labelLarge),
      labelMedium: abel(textStyle: textTheme.labelMedium),
      labelSmall: abel(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Abhaya Libre font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Abhaya+Libre
  static TextStyle abhayaLibre({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '50e5cb049d0e3e04e498852e95102fe5883c78e1f92b34455e8ee053826f9c66',
        260860,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '84a6d3b4e0c34e7d6250b09a7e403e729d20b11d9d9b2cbd9cccd39ea2d95ce9',
        260976,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fc5ba43fd560019994cbef12d484793b0bb0ec58ea16c1964d342caec8023346',
        260144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '668223a249ceff3d577d8e116471dfaf79440271ba99b3f5fd74aba6260ef866',
        259828,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0a2994a83922a275a5e31d364a484804f3c98a6ee47106b8d3a7cfe0d981a548',
        259032,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AbhayaLibre',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Abhaya Libre font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Abhaya+Libre
  static TextTheme abhayaLibreTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: abhayaLibre(textStyle: textTheme.displayLarge),
      displayMedium: abhayaLibre(textStyle: textTheme.displayMedium),
      displaySmall: abhayaLibre(textStyle: textTheme.displaySmall),
      headlineLarge: abhayaLibre(textStyle: textTheme.headlineLarge),
      headlineMedium: abhayaLibre(textStyle: textTheme.headlineMedium),
      headlineSmall: abhayaLibre(textStyle: textTheme.headlineSmall),
      titleLarge: abhayaLibre(textStyle: textTheme.titleLarge),
      titleMedium: abhayaLibre(textStyle: textTheme.titleMedium),
      titleSmall: abhayaLibre(textStyle: textTheme.titleSmall),
      bodyLarge: abhayaLibre(textStyle: textTheme.bodyLarge),
      bodyMedium: abhayaLibre(textStyle: textTheme.bodyMedium),
      bodySmall: abhayaLibre(textStyle: textTheme.bodySmall),
      labelLarge: abhayaLibre(textStyle: textTheme.labelLarge),
      labelMedium: abhayaLibre(textStyle: textTheme.labelMedium),
      labelSmall: abhayaLibre(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Aboreto font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aboreto
  static TextStyle aboreto({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0077414ca4d77ab34c9aaae57c9b5de9e28b475d0ca8bcd9af3da80ffdad2726',
        34204,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Aboreto',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Aboreto font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aboreto
  static TextTheme aboretoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: aboreto(textStyle: textTheme.displayLarge),
      displayMedium: aboreto(textStyle: textTheme.displayMedium),
      displaySmall: aboreto(textStyle: textTheme.displaySmall),
      headlineLarge: aboreto(textStyle: textTheme.headlineLarge),
      headlineMedium: aboreto(textStyle: textTheme.headlineMedium),
      headlineSmall: aboreto(textStyle: textTheme.headlineSmall),
      titleLarge: aboreto(textStyle: textTheme.titleLarge),
      titleMedium: aboreto(textStyle: textTheme.titleMedium),
      titleSmall: aboreto(textStyle: textTheme.titleSmall),
      bodyLarge: aboreto(textStyle: textTheme.bodyLarge),
      bodyMedium: aboreto(textStyle: textTheme.bodyMedium),
      bodySmall: aboreto(textStyle: textTheme.bodySmall),
      labelLarge: aboreto(textStyle: textTheme.labelLarge),
      labelMedium: aboreto(textStyle: textTheme.labelMedium),
      labelSmall: aboreto(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Abril Fatface font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Abril+Fatface
  static TextStyle abrilFatface({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '95247ed0ac42215bff3c50489b91942a912e755ef30f32cac5450e0d3245d72a',
        56284,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AbrilFatface',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Abril Fatface font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Abril+Fatface
  static TextTheme abrilFatfaceTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: abrilFatface(textStyle: textTheme.displayLarge),
      displayMedium: abrilFatface(textStyle: textTheme.displayMedium),
      displaySmall: abrilFatface(textStyle: textTheme.displaySmall),
      headlineLarge: abrilFatface(textStyle: textTheme.headlineLarge),
      headlineMedium: abrilFatface(textStyle: textTheme.headlineMedium),
      headlineSmall: abrilFatface(textStyle: textTheme.headlineSmall),
      titleLarge: abrilFatface(textStyle: textTheme.titleLarge),
      titleMedium: abrilFatface(textStyle: textTheme.titleMedium),
      titleSmall: abrilFatface(textStyle: textTheme.titleSmall),
      bodyLarge: abrilFatface(textStyle: textTheme.bodyLarge),
      bodyMedium: abrilFatface(textStyle: textTheme.bodyMedium),
      bodySmall: abrilFatface(textStyle: textTheme.bodySmall),
      labelLarge: abrilFatface(textStyle: textTheme.labelLarge),
      labelMedium: abrilFatface(textStyle: textTheme.labelMedium),
      labelSmall: abrilFatface(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Abyssinica SIL font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Abyssinica+SIL
  static TextStyle abyssinicaSil({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '24c82694d36fa880dfd9972fae017e9f5ef8506b62562ef6918e2c2364c47336',
        210132,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AbyssinicaSIL',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Abyssinica SIL font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Abyssinica+SIL
  static TextTheme abyssinicaSilTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: abyssinicaSil(textStyle: textTheme.displayLarge),
      displayMedium: abyssinicaSil(textStyle: textTheme.displayMedium),
      displaySmall: abyssinicaSil(textStyle: textTheme.displaySmall),
      headlineLarge: abyssinicaSil(textStyle: textTheme.headlineLarge),
      headlineMedium: abyssinicaSil(textStyle: textTheme.headlineMedium),
      headlineSmall: abyssinicaSil(textStyle: textTheme.headlineSmall),
      titleLarge: abyssinicaSil(textStyle: textTheme.titleLarge),
      titleMedium: abyssinicaSil(textStyle: textTheme.titleMedium),
      titleSmall: abyssinicaSil(textStyle: textTheme.titleSmall),
      bodyLarge: abyssinicaSil(textStyle: textTheme.bodyLarge),
      bodyMedium: abyssinicaSil(textStyle: textTheme.bodyMedium),
      bodySmall: abyssinicaSil(textStyle: textTheme.bodySmall),
      labelLarge: abyssinicaSil(textStyle: textTheme.labelLarge),
      labelMedium: abyssinicaSil(textStyle: textTheme.labelMedium),
      labelSmall: abyssinicaSil(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Aclonica font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aclonica
  static TextStyle aclonica({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9cb4387809cda19f417138f419c71d11f7d7f5e179edf9ddbd7e76e84ed01c11',
        53120,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Aclonica',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Aclonica font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aclonica
  static TextTheme aclonicaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: aclonica(textStyle: textTheme.displayLarge),
      displayMedium: aclonica(textStyle: textTheme.displayMedium),
      displaySmall: aclonica(textStyle: textTheme.displaySmall),
      headlineLarge: aclonica(textStyle: textTheme.headlineLarge),
      headlineMedium: aclonica(textStyle: textTheme.headlineMedium),
      headlineSmall: aclonica(textStyle: textTheme.headlineSmall),
      titleLarge: aclonica(textStyle: textTheme.titleLarge),
      titleMedium: aclonica(textStyle: textTheme.titleMedium),
      titleSmall: aclonica(textStyle: textTheme.titleSmall),
      bodyLarge: aclonica(textStyle: textTheme.bodyLarge),
      bodyMedium: aclonica(textStyle: textTheme.bodyMedium),
      bodySmall: aclonica(textStyle: textTheme.bodySmall),
      labelLarge: aclonica(textStyle: textTheme.labelLarge),
      labelMedium: aclonica(textStyle: textTheme.labelMedium),
      labelSmall: aclonica(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Acme font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Acme
  static TextStyle acme({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bb057c2fe8ba04cd3a8abc8e4d985898dcdaccd6f9fa1d5ed9881e3f26d6e6d0',
        21392,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Acme',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Acme font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Acme
  static TextTheme acmeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: acme(textStyle: textTheme.displayLarge),
      displayMedium: acme(textStyle: textTheme.displayMedium),
      displaySmall: acme(textStyle: textTheme.displaySmall),
      headlineLarge: acme(textStyle: textTheme.headlineLarge),
      headlineMedium: acme(textStyle: textTheme.headlineMedium),
      headlineSmall: acme(textStyle: textTheme.headlineSmall),
      titleLarge: acme(textStyle: textTheme.titleLarge),
      titleMedium: acme(textStyle: textTheme.titleMedium),
      titleSmall: acme(textStyle: textTheme.titleSmall),
      bodyLarge: acme(textStyle: textTheme.bodyLarge),
      bodyMedium: acme(textStyle: textTheme.bodyMedium),
      bodySmall: acme(textStyle: textTheme.bodySmall),
      labelLarge: acme(textStyle: textTheme.labelLarge),
      labelMedium: acme(textStyle: textTheme.labelMedium),
      labelSmall: acme(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Actor font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Actor
  static TextStyle actor({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '62d4580d4d42de39d74b4087814e559b5480f30604b8d5d2929f391cda48adda',
        32508,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Actor',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Actor font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Actor
  static TextTheme actorTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: actor(textStyle: textTheme.displayLarge),
      displayMedium: actor(textStyle: textTheme.displayMedium),
      displaySmall: actor(textStyle: textTheme.displaySmall),
      headlineLarge: actor(textStyle: textTheme.headlineLarge),
      headlineMedium: actor(textStyle: textTheme.headlineMedium),
      headlineSmall: actor(textStyle: textTheme.headlineSmall),
      titleLarge: actor(textStyle: textTheme.titleLarge),
      titleMedium: actor(textStyle: textTheme.titleMedium),
      titleSmall: actor(textStyle: textTheme.titleSmall),
      bodyLarge: actor(textStyle: textTheme.bodyLarge),
      bodyMedium: actor(textStyle: textTheme.bodyMedium),
      bodySmall: actor(textStyle: textTheme.bodySmall),
      labelLarge: actor(textStyle: textTheme.labelLarge),
      labelMedium: actor(textStyle: textTheme.labelMedium),
      labelSmall: actor(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Adamina font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Adamina
  static TextStyle adamina({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e123026cff37baee8a9e66a14d3cb57d9a5e1c7cebc75b143e4955e88e6be1a3',
        34172,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Adamina',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Adamina font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Adamina
  static TextTheme adaminaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: adamina(textStyle: textTheme.displayLarge),
      displayMedium: adamina(textStyle: textTheme.displayMedium),
      displaySmall: adamina(textStyle: textTheme.displaySmall),
      headlineLarge: adamina(textStyle: textTheme.headlineLarge),
      headlineMedium: adamina(textStyle: textTheme.headlineMedium),
      headlineSmall: adamina(textStyle: textTheme.headlineSmall),
      titleLarge: adamina(textStyle: textTheme.titleLarge),
      titleMedium: adamina(textStyle: textTheme.titleMedium),
      titleSmall: adamina(textStyle: textTheme.titleSmall),
      bodyLarge: adamina(textStyle: textTheme.bodyLarge),
      bodyMedium: adamina(textStyle: textTheme.bodyMedium),
      bodySmall: adamina(textStyle: textTheme.bodySmall),
      labelLarge: adamina(textStyle: textTheme.labelLarge),
      labelMedium: adamina(textStyle: textTheme.labelMedium),
      labelSmall: adamina(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Advent Pro font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Advent+Pro
  static TextStyle adventPro({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '45aa581592cafdd4f154b7a5eb39021efe26c3f841f03f86e061c066e51f6b74',
        73424,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4ab63e5c3dcf8cafd470d33af3bb9f06aa0c80fe8e256e7c0c73c40107e443d5',
        73492,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0cb12692d5b7882c647e4216e805fa0f18d0d461d293f633d7519a065734ba25',
        73408,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1b72d73906761a60fc04d662021aa0650e5a127766930820d987f2917d99b6cb',
        73280,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '790c5cebec92960a267f08d8f2e9fdaef11bb6078315bb1da981f558fb53822f',
        73348,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4f8ce9d5061e7b52adfbd63cb01bd012171993ea14d2be95b7deeff56f3f3497',
        73268,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '083413c94dede71e324a15905bfea13922910bd1579e08fae41bc3d9431dc05c',
        73112,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cf79f09c48a430844664c2688c0edde5fd47ffe63a47860b78931d7bcbdcde55',
        73152,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a737cc97f47ace95ec83fb033ebb146a0eb9fa3407c7083f5b54f9148e49bbdf',
        73064,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '18bb9075d8c4e91e76e9765680389fe658ac038444b62a10997b644152a95814',
        75356,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c3b9dd175d65d069da3955c4cadf1106c032040ad71a8166bff07864e622ceb2',
        75440,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '162bd0a3f6560fa38ad4cf86870c716c2c4f166de1a6188ff56815b342409117',
        75348,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '49f4a337a56e2c44198413a760eaff48adb35f3f2279a16d441e1db1b9bdd85b',
        75148,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a34f535f405dc30b0b11181b4f9ffd76220b4cedcc312a581a67300fcb0b280a',
        75256,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '180a2b5cf24c4b2c2f7b0cbecca849bb018816d532bb8257261261aa1455f304',
        75188,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f9e26c55d6051e017ac97ea24311a5dabc2036284dfee8c3db344bfa33aea150',
        75008,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'bcbbbb4a782a0580feb95fa7317a19e984bc6a347d7dd975ffead3eda6490db0',
        75096,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c7fe24d1b0f8905029e4b0b441844e4ba602d789180e26f62e253cb25fc629eb',
        74968,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AdventPro',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Advent Pro font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Advent+Pro
  static TextTheme adventProTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: adventPro(textStyle: textTheme.displayLarge),
      displayMedium: adventPro(textStyle: textTheme.displayMedium),
      displaySmall: adventPro(textStyle: textTheme.displaySmall),
      headlineLarge: adventPro(textStyle: textTheme.headlineLarge),
      headlineMedium: adventPro(textStyle: textTheme.headlineMedium),
      headlineSmall: adventPro(textStyle: textTheme.headlineSmall),
      titleLarge: adventPro(textStyle: textTheme.titleLarge),
      titleMedium: adventPro(textStyle: textTheme.titleMedium),
      titleSmall: adventPro(textStyle: textTheme.titleSmall),
      bodyLarge: adventPro(textStyle: textTheme.bodyLarge),
      bodyMedium: adventPro(textStyle: textTheme.bodyMedium),
      bodySmall: adventPro(textStyle: textTheme.bodySmall),
      labelLarge: adventPro(textStyle: textTheme.labelLarge),
      labelMedium: adventPro(textStyle: textTheme.labelMedium),
      labelSmall: adventPro(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Afacad font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Afacad
  static TextStyle afacad({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '100d049149154c90bf511199eae295834c70c33f5b8cfe646f22fcd2f214a6ff',
        67504,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '03d74b4bea9a16d712267173c9e7971812d7fd67b07122cbe98c04862cdbe228',
        67976,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fdb616585dfe26e4c3331c6ecff78200634157f3da93008a412b47f01f95407e',
        67932,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2f3beff8acd1c9587e2afcc985dfe945d1a5f86e1b37163d6f36f5199065e84f',
        67708,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c765bf1b21da4a1dafa1f7634cd435592a68e4fc9e652913119da18cfed2a762',
        68632,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '508711db361584b58af2988e851a2f7f6694c34092fbd362c3044e718dff6e22',
        69036,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'baff24ff7de5944d79951e25ba33c20e80f5880c6aa475dd4119d67c3204652d',
        68984,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '235d7622ec3a2b635ce5a7630db2360454534b13cca9080a704f37005197dd47',
        68856,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Afacad',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Afacad font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Afacad
  static TextTheme afacadTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: afacad(textStyle: textTheme.displayLarge),
      displayMedium: afacad(textStyle: textTheme.displayMedium),
      displaySmall: afacad(textStyle: textTheme.displaySmall),
      headlineLarge: afacad(textStyle: textTheme.headlineLarge),
      headlineMedium: afacad(textStyle: textTheme.headlineMedium),
      headlineSmall: afacad(textStyle: textTheme.headlineSmall),
      titleLarge: afacad(textStyle: textTheme.titleLarge),
      titleMedium: afacad(textStyle: textTheme.titleMedium),
      titleSmall: afacad(textStyle: textTheme.titleSmall),
      bodyLarge: afacad(textStyle: textTheme.bodyLarge),
      bodyMedium: afacad(textStyle: textTheme.bodyMedium),
      bodySmall: afacad(textStyle: textTheme.bodySmall),
      labelLarge: afacad(textStyle: textTheme.labelLarge),
      labelMedium: afacad(textStyle: textTheme.labelMedium),
      labelSmall: afacad(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Agbalumo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Agbalumo
  static TextStyle agbalumo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '30b22b774c5efe7953976fdb5b09abac0f490083f44de5fbcb0942a0c594843b',
        337796,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Agbalumo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Agbalumo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Agbalumo
  static TextTheme agbalumoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: agbalumo(textStyle: textTheme.displayLarge),
      displayMedium: agbalumo(textStyle: textTheme.displayMedium),
      displaySmall: agbalumo(textStyle: textTheme.displaySmall),
      headlineLarge: agbalumo(textStyle: textTheme.headlineLarge),
      headlineMedium: agbalumo(textStyle: textTheme.headlineMedium),
      headlineSmall: agbalumo(textStyle: textTheme.headlineSmall),
      titleLarge: agbalumo(textStyle: textTheme.titleLarge),
      titleMedium: agbalumo(textStyle: textTheme.titleMedium),
      titleSmall: agbalumo(textStyle: textTheme.titleSmall),
      bodyLarge: agbalumo(textStyle: textTheme.bodyLarge),
      bodyMedium: agbalumo(textStyle: textTheme.bodyMedium),
      bodySmall: agbalumo(textStyle: textTheme.bodySmall),
      labelLarge: agbalumo(textStyle: textTheme.labelLarge),
      labelMedium: agbalumo(textStyle: textTheme.labelMedium),
      labelSmall: agbalumo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Agdasima font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Agdasima
  static TextStyle agdasima({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3b632f82cd39b82c2c8100b7d53878d551769116a0f047e7c763a2e71d336c99',
        22552,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6cb3f3184e01ccdb75eedf10c9ed33b98cc3001cec077ddc46b62b0e4846db24',
        22412,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Agdasima',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Agdasima font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Agdasima
  static TextTheme agdasimaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: agdasima(textStyle: textTheme.displayLarge),
      displayMedium: agdasima(textStyle: textTheme.displayMedium),
      displaySmall: agdasima(textStyle: textTheme.displaySmall),
      headlineLarge: agdasima(textStyle: textTheme.headlineLarge),
      headlineMedium: agdasima(textStyle: textTheme.headlineMedium),
      headlineSmall: agdasima(textStyle: textTheme.headlineSmall),
      titleLarge: agdasima(textStyle: textTheme.titleLarge),
      titleMedium: agdasima(textStyle: textTheme.titleMedium),
      titleSmall: agdasima(textStyle: textTheme.titleSmall),
      bodyLarge: agdasima(textStyle: textTheme.bodyLarge),
      bodyMedium: agdasima(textStyle: textTheme.bodyMedium),
      bodySmall: agdasima(textStyle: textTheme.bodySmall),
      labelLarge: agdasima(textStyle: textTheme.labelLarge),
      labelMedium: agdasima(textStyle: textTheme.labelMedium),
      labelSmall: agdasima(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Aguafina Script font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aguafina+Script
  static TextStyle aguafinaScript({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '67d457ebe8c906c7a08c078f6e2b8334724664ebd83cdcc015444afd7bc947f1',
        44884,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AguafinaScript',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Aguafina Script font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aguafina+Script
  static TextTheme aguafinaScriptTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: aguafinaScript(textStyle: textTheme.displayLarge),
      displayMedium: aguafinaScript(textStyle: textTheme.displayMedium),
      displaySmall: aguafinaScript(textStyle: textTheme.displaySmall),
      headlineLarge: aguafinaScript(textStyle: textTheme.headlineLarge),
      headlineMedium: aguafinaScript(textStyle: textTheme.headlineMedium),
      headlineSmall: aguafinaScript(textStyle: textTheme.headlineSmall),
      titleLarge: aguafinaScript(textStyle: textTheme.titleLarge),
      titleMedium: aguafinaScript(textStyle: textTheme.titleMedium),
      titleSmall: aguafinaScript(textStyle: textTheme.titleSmall),
      bodyLarge: aguafinaScript(textStyle: textTheme.bodyLarge),
      bodyMedium: aguafinaScript(textStyle: textTheme.bodyMedium),
      bodySmall: aguafinaScript(textStyle: textTheme.bodySmall),
      labelLarge: aguafinaScript(textStyle: textTheme.labelLarge),
      labelMedium: aguafinaScript(textStyle: textTheme.labelMedium),
      labelSmall: aguafinaScript(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Akatab font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Akatab
  static TextStyle akatab({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '31d990f9e9871c35b3b2cd23c1f6c57f50993d69c39b130a5e6a03993a17ed72',
        57368,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f0834b6cdecb208743aa7bb9731577b02a179932141221242e6e025d497065e7',
        57492,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5bb8c14a363ce2d58668c08d90d2dd5027c3fc7ccb98a37246fe62033176d065',
        57748,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6fb2f1906c5eb7925d5b2cd600daf21556652cbef6fe0ab88c3c1ed17e437261',
        57652,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1edacad1c18f04c2166b86b72d86f6a7c3c2fb2608412ddb38a27e23b915bc5d',
        57976,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c16dc9b33033e0242f55c04f879e9a97ab5c813de0d1b21f7bcc3106b22f1c26',
        58196,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Akatab',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Akatab font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Akatab
  static TextTheme akatabTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: akatab(textStyle: textTheme.displayLarge),
      displayMedium: akatab(textStyle: textTheme.displayMedium),
      displaySmall: akatab(textStyle: textTheme.displaySmall),
      headlineLarge: akatab(textStyle: textTheme.headlineLarge),
      headlineMedium: akatab(textStyle: textTheme.headlineMedium),
      headlineSmall: akatab(textStyle: textTheme.headlineSmall),
      titleLarge: akatab(textStyle: textTheme.titleLarge),
      titleMedium: akatab(textStyle: textTheme.titleMedium),
      titleSmall: akatab(textStyle: textTheme.titleSmall),
      bodyLarge: akatab(textStyle: textTheme.bodyLarge),
      bodyMedium: akatab(textStyle: textTheme.bodyMedium),
      bodySmall: akatab(textStyle: textTheme.bodySmall),
      labelLarge: akatab(textStyle: textTheme.labelLarge),
      labelMedium: akatab(textStyle: textTheme.labelMedium),
      labelSmall: akatab(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Akaya Kanadaka font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Akaya+Kanadaka
  static TextStyle akayaKanadaka({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ae7b926a2c06f3a871d8f8927aee721c0caaa9a0b8193531c2c7c919d4ff6e8a',
        204196,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AkayaKanadaka',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Akaya Kanadaka font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Akaya+Kanadaka
  static TextTheme akayaKanadakaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: akayaKanadaka(textStyle: textTheme.displayLarge),
      displayMedium: akayaKanadaka(textStyle: textTheme.displayMedium),
      displaySmall: akayaKanadaka(textStyle: textTheme.displaySmall),
      headlineLarge: akayaKanadaka(textStyle: textTheme.headlineLarge),
      headlineMedium: akayaKanadaka(textStyle: textTheme.headlineMedium),
      headlineSmall: akayaKanadaka(textStyle: textTheme.headlineSmall),
      titleLarge: akayaKanadaka(textStyle: textTheme.titleLarge),
      titleMedium: akayaKanadaka(textStyle: textTheme.titleMedium),
      titleSmall: akayaKanadaka(textStyle: textTheme.titleSmall),
      bodyLarge: akayaKanadaka(textStyle: textTheme.bodyLarge),
      bodyMedium: akayaKanadaka(textStyle: textTheme.bodyMedium),
      bodySmall: akayaKanadaka(textStyle: textTheme.bodySmall),
      labelLarge: akayaKanadaka(textStyle: textTheme.labelLarge),
      labelMedium: akayaKanadaka(textStyle: textTheme.labelMedium),
      labelSmall: akayaKanadaka(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Akaya Telivigala font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Akaya+Telivigala
  static TextStyle akayaTelivigala({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '69b20a196e4a5f48efc33d7ec372bb02a6bc4cadbe3600b7341bccbefd8ad707',
        319968,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AkayaTelivigala',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Akaya Telivigala font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Akaya+Telivigala
  static TextTheme akayaTelivigalaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: akayaTelivigala(textStyle: textTheme.displayLarge),
      displayMedium: akayaTelivigala(textStyle: textTheme.displayMedium),
      displaySmall: akayaTelivigala(textStyle: textTheme.displaySmall),
      headlineLarge: akayaTelivigala(textStyle: textTheme.headlineLarge),
      headlineMedium: akayaTelivigala(textStyle: textTheme.headlineMedium),
      headlineSmall: akayaTelivigala(textStyle: textTheme.headlineSmall),
      titleLarge: akayaTelivigala(textStyle: textTheme.titleLarge),
      titleMedium: akayaTelivigala(textStyle: textTheme.titleMedium),
      titleSmall: akayaTelivigala(textStyle: textTheme.titleSmall),
      bodyLarge: akayaTelivigala(textStyle: textTheme.bodyLarge),
      bodyMedium: akayaTelivigala(textStyle: textTheme.bodyMedium),
      bodySmall: akayaTelivigala(textStyle: textTheme.bodySmall),
      labelLarge: akayaTelivigala(textStyle: textTheme.labelLarge),
      labelMedium: akayaTelivigala(textStyle: textTheme.labelMedium),
      labelSmall: akayaTelivigala(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Akronim font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Akronim
  static TextStyle akronim({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2092a1a3699c69bb9776d37189bc8601dbdf4546f015d3c2c2cc826eb5162915',
        105652,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Akronim',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Akronim font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Akronim
  static TextTheme akronimTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: akronim(textStyle: textTheme.displayLarge),
      displayMedium: akronim(textStyle: textTheme.displayMedium),
      displaySmall: akronim(textStyle: textTheme.displaySmall),
      headlineLarge: akronim(textStyle: textTheme.headlineLarge),
      headlineMedium: akronim(textStyle: textTheme.headlineMedium),
      headlineSmall: akronim(textStyle: textTheme.headlineSmall),
      titleLarge: akronim(textStyle: textTheme.titleLarge),
      titleMedium: akronim(textStyle: textTheme.titleMedium),
      titleSmall: akronim(textStyle: textTheme.titleSmall),
      bodyLarge: akronim(textStyle: textTheme.bodyLarge),
      bodyMedium: akronim(textStyle: textTheme.bodyMedium),
      bodySmall: akronim(textStyle: textTheme.bodySmall),
      labelLarge: akronim(textStyle: textTheme.labelLarge),
      labelMedium: akronim(textStyle: textTheme.labelMedium),
      labelSmall: akronim(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Akshar font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Akshar
  static TextStyle akshar({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0e820b80836bfafb14d1822dca072524922ae409262897b87489fe315d9221dd',
        119084,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7786a61b9b2b2457b6513aabd5b8122998d08aaed1de65d7c971276481ab320c',
        119740,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1488c52e8afd8271fbe50d5b59b9db44b176c54368b69a579eb8853fa284748b',
        119900,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fb2bf224538ec29047717b92ce3cae90a2f1102d252a1afe7af5bb96485b939b',
        120052,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ca1c65c76e3be7226d31d3d59a9aaa0f6d85e71be8837472bea4eb92b126213c',
        120000,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Akshar',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Akshar font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Akshar
  static TextTheme aksharTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: akshar(textStyle: textTheme.displayLarge),
      displayMedium: akshar(textStyle: textTheme.displayMedium),
      displaySmall: akshar(textStyle: textTheme.displaySmall),
      headlineLarge: akshar(textStyle: textTheme.headlineLarge),
      headlineMedium: akshar(textStyle: textTheme.headlineMedium),
      headlineSmall: akshar(textStyle: textTheme.headlineSmall),
      titleLarge: akshar(textStyle: textTheme.titleLarge),
      titleMedium: akshar(textStyle: textTheme.titleMedium),
      titleSmall: akshar(textStyle: textTheme.titleSmall),
      bodyLarge: akshar(textStyle: textTheme.bodyLarge),
      bodyMedium: akshar(textStyle: textTheme.bodyMedium),
      bodySmall: akshar(textStyle: textTheme.bodySmall),
      labelLarge: akshar(textStyle: textTheme.labelLarge),
      labelMedium: akshar(textStyle: textTheme.labelMedium),
      labelSmall: akshar(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Aladin font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aladin
  static TextStyle aladin({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '55d0d65ec7e0251db1d8e2f46bb9ee8ec36ad55237f1c834897e75a9a75ba405',
        39832,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Aladin',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Aladin font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aladin
  static TextTheme aladinTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: aladin(textStyle: textTheme.displayLarge),
      displayMedium: aladin(textStyle: textTheme.displayMedium),
      displaySmall: aladin(textStyle: textTheme.displaySmall),
      headlineLarge: aladin(textStyle: textTheme.headlineLarge),
      headlineMedium: aladin(textStyle: textTheme.headlineMedium),
      headlineSmall: aladin(textStyle: textTheme.headlineSmall),
      titleLarge: aladin(textStyle: textTheme.titleLarge),
      titleMedium: aladin(textStyle: textTheme.titleMedium),
      titleSmall: aladin(textStyle: textTheme.titleSmall),
      bodyLarge: aladin(textStyle: textTheme.bodyLarge),
      bodyMedium: aladin(textStyle: textTheme.bodyMedium),
      bodySmall: aladin(textStyle: textTheme.bodySmall),
      labelLarge: aladin(textStyle: textTheme.labelLarge),
      labelMedium: aladin(textStyle: textTheme.labelMedium),
      labelSmall: aladin(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alata font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alata
  static TextStyle alata({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4d6d1a876ec561e28b937360e72c7a923c4e70d6b296d0e02ab975f905541542',
        63888,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Alata',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alata font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alata
  static TextTheme alataTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: alata(textStyle: textTheme.displayLarge),
      displayMedium: alata(textStyle: textTheme.displayMedium),
      displaySmall: alata(textStyle: textTheme.displaySmall),
      headlineLarge: alata(textStyle: textTheme.headlineLarge),
      headlineMedium: alata(textStyle: textTheme.headlineMedium),
      headlineSmall: alata(textStyle: textTheme.headlineSmall),
      titleLarge: alata(textStyle: textTheme.titleLarge),
      titleMedium: alata(textStyle: textTheme.titleMedium),
      titleSmall: alata(textStyle: textTheme.titleSmall),
      bodyLarge: alata(textStyle: textTheme.bodyLarge),
      bodyMedium: alata(textStyle: textTheme.bodyMedium),
      bodySmall: alata(textStyle: textTheme.bodySmall),
      labelLarge: alata(textStyle: textTheme.labelLarge),
      labelMedium: alata(textStyle: textTheme.labelMedium),
      labelSmall: alata(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alatsi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alatsi
  static TextStyle alatsi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9d0fb3f76a4356859b1290a86bdcaa2d07b4924e58af54062df6a7e4c4f62689',
        88900,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Alatsi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alatsi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alatsi
  static TextTheme alatsiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: alatsi(textStyle: textTheme.displayLarge),
      displayMedium: alatsi(textStyle: textTheme.displayMedium),
      displaySmall: alatsi(textStyle: textTheme.displaySmall),
      headlineLarge: alatsi(textStyle: textTheme.headlineLarge),
      headlineMedium: alatsi(textStyle: textTheme.headlineMedium),
      headlineSmall: alatsi(textStyle: textTheme.headlineSmall),
      titleLarge: alatsi(textStyle: textTheme.titleLarge),
      titleMedium: alatsi(textStyle: textTheme.titleMedium),
      titleSmall: alatsi(textStyle: textTheme.titleSmall),
      bodyLarge: alatsi(textStyle: textTheme.bodyLarge),
      bodyMedium: alatsi(textStyle: textTheme.bodyMedium),
      bodySmall: alatsi(textStyle: textTheme.bodySmall),
      labelLarge: alatsi(textStyle: textTheme.labelLarge),
      labelMedium: alatsi(textStyle: textTheme.labelMedium),
      labelSmall: alatsi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Albert Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Albert+Sans
  static TextStyle albertSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '54a007a5eea0c9be80b85b85de65b5757e40a53f181ac48237113e0908a9fbe1',
        44564,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1443a5a2128ccf4625103e26180132ae5d10677582e66ff7bc8dbe9737241047',
        44668,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0a9f40c255e15a8d81c58c9c0fe8d46156a765d3db6a4bde0547323070a62c73',
        44620,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7ed6dcdfccb8a8593acc745f79d66fb2cd6131781c13e413c1289f2744062615',
        44560,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '86c35dcde6fd6a3c6589330b2f873d22744f87ec2b77e5d55af7e2a5695720c9',
        44552,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4ea4bf6b0777a9eaf35b3b50fac8c7cab4477f590e23ef4a51fb0c8afbfad306',
        44532,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9a50f6ec5ee4075a430aa437152f8c25b35720aab417d581a147a4d255f79362',
        44472,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1bd44561e7627a1e41ac1053ee90bdd610500dab5af4546ea0fe8dc5cb845018',
        44604,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bd782f1f4887e9191885e6517f136e00797ab8668b2585e23c826cfda536a6ed',
        44572,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e1ec42a421e5df094bb01c478404ac97a84df568d33aec4226d57859f23db71d',
        49676,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e8b8b885a0d01a5f3ced4a14af18bd528716bade127c6c88a82fcff8ef4a0f05',
        49744,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '68729606728a20b565eb14c81f0fd5a121d29367fa7a2be5554ea0d266a6c088',
        49672,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '68d5a3d5b302916f065bf9973c8c34f5479b85ee50254c4c62ee0fd7db9155b8',
        49532,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '475a8e1c14248e5028486de3a8fad10f76346615046b7a65dce32b8abd9b2b44',
        49632,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1dac8f43b181aac125a8ad2e138b2aed82b7fec8c2b416b4436a2007699f43b3',
        49624,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '975996804e4e42b5a43e7f0a76df4a33e3337c084b656fd0f10d2c8e02826cbf',
        49524,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '48fcb6eb47b8977312fd817bba291a293c5af817318066863b2fd6e5d57db786',
        49676,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e4496eb28e10ee5a255f8e863f962424cc2a34b510c480f4b6625b59b943fd63',
        49596,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlbertSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Albert Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Albert+Sans
  static TextTheme albertSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: albertSans(textStyle: textTheme.displayLarge),
      displayMedium: albertSans(textStyle: textTheme.displayMedium),
      displaySmall: albertSans(textStyle: textTheme.displaySmall),
      headlineLarge: albertSans(textStyle: textTheme.headlineLarge),
      headlineMedium: albertSans(textStyle: textTheme.headlineMedium),
      headlineSmall: albertSans(textStyle: textTheme.headlineSmall),
      titleLarge: albertSans(textStyle: textTheme.titleLarge),
      titleMedium: albertSans(textStyle: textTheme.titleMedium),
      titleSmall: albertSans(textStyle: textTheme.titleSmall),
      bodyLarge: albertSans(textStyle: textTheme.bodyLarge),
      bodyMedium: albertSans(textStyle: textTheme.bodyMedium),
      bodySmall: albertSans(textStyle: textTheme.bodySmall),
      labelLarge: albertSans(textStyle: textTheme.labelLarge),
      labelMedium: albertSans(textStyle: textTheme.labelMedium),
      labelSmall: albertSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Aldrich font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aldrich
  static TextStyle aldrich({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ffe893f4593d0a58e30f6f764534b13534722ed22970a2ce3303a185e7ce0c02',
        25440,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Aldrich',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Aldrich font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aldrich
  static TextTheme aldrichTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: aldrich(textStyle: textTheme.displayLarge),
      displayMedium: aldrich(textStyle: textTheme.displayMedium),
      displaySmall: aldrich(textStyle: textTheme.displaySmall),
      headlineLarge: aldrich(textStyle: textTheme.headlineLarge),
      headlineMedium: aldrich(textStyle: textTheme.headlineMedium),
      headlineSmall: aldrich(textStyle: textTheme.headlineSmall),
      titleLarge: aldrich(textStyle: textTheme.titleLarge),
      titleMedium: aldrich(textStyle: textTheme.titleMedium),
      titleSmall: aldrich(textStyle: textTheme.titleSmall),
      bodyLarge: aldrich(textStyle: textTheme.bodyLarge),
      bodyMedium: aldrich(textStyle: textTheme.bodyMedium),
      bodySmall: aldrich(textStyle: textTheme.bodySmall),
      labelLarge: aldrich(textStyle: textTheme.labelLarge),
      labelMedium: aldrich(textStyle: textTheme.labelMedium),
      labelSmall: aldrich(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alef font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alef
  static TextStyle alef({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '34ced41c88a6c966490ce1a85c40eab4c9fdb1d6f20114da8edba261c0180a55',
        57172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6c0fdebc49a6f30dd1912bf2f08920758704b733176699bf177607ce23ba91a0',
        58820,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Alef',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alef font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alef
  static TextTheme alefTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: alef(textStyle: textTheme.displayLarge),
      displayMedium: alef(textStyle: textTheme.displayMedium),
      displaySmall: alef(textStyle: textTheme.displaySmall),
      headlineLarge: alef(textStyle: textTheme.headlineLarge),
      headlineMedium: alef(textStyle: textTheme.headlineMedium),
      headlineSmall: alef(textStyle: textTheme.headlineSmall),
      titleLarge: alef(textStyle: textTheme.titleLarge),
      titleMedium: alef(textStyle: textTheme.titleMedium),
      titleSmall: alef(textStyle: textTheme.titleSmall),
      bodyLarge: alef(textStyle: textTheme.bodyLarge),
      bodyMedium: alef(textStyle: textTheme.bodyMedium),
      bodySmall: alef(textStyle: textTheme.bodySmall),
      labelLarge: alef(textStyle: textTheme.labelLarge),
      labelMedium: alef(textStyle: textTheme.labelMedium),
      labelSmall: alef(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alegreya font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alegreya
  static TextStyle alegreya({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '52c57d4634c08bab444b3085533c5ed72f8141117b91fc2a19e55d8b9c82c1b3',
        161920,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd66315f95dd17004927b3ac5a5a0b15678cd999e297b99d083a411b3553fea4c',
        163388,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2864185324c76741f7618c96d513ef421135641952ac00dde808487815895afd',
        164720,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '82b4aeeafcf5e3ac0b94879dab79d8aa6e345e853d8cc3675e2f57df7fbd1edc',
        164572,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '28df28c4851b91d886c22780862fecac37153fdf62e261e9254573342aa294f4',
        165184,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4e36cfcb5d3c2171cd4f3990fc6b3319cc942a153323d95f5571c81655c540cf',
        164696,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f3cd48dd98aca02a49f3d5135507c9d12443105d88c20f71e1f2e8be397a3515',
        161024,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e60a185aa31508f057243142a3956e9f4f0c307306d2461544a96bf2f35b5ec7',
        162076,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '66d923f19d7409efed07b734d0b023f3ca54fb92659bee394fbda3af37678be5',
        162056,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '55c6b7ea58482a974a6219f5712f968772b09dda3cc5cdef27c85e267b826170',
        163596,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '50dfff4b0a2a1ca0fa3801c41505b7f3df28e345ffc2ad497df6552602867045',
        164208,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '60f00096645be3a965344cb0e383661ec693e9bec7e31a9c8cfb4045690dec69',
        163748,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Alegreya',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alegreya font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alegreya
  static TextTheme alegreyaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: alegreya(textStyle: textTheme.displayLarge),
      displayMedium: alegreya(textStyle: textTheme.displayMedium),
      displaySmall: alegreya(textStyle: textTheme.displaySmall),
      headlineLarge: alegreya(textStyle: textTheme.headlineLarge),
      headlineMedium: alegreya(textStyle: textTheme.headlineMedium),
      headlineSmall: alegreya(textStyle: textTheme.headlineSmall),
      titleLarge: alegreya(textStyle: textTheme.titleLarge),
      titleMedium: alegreya(textStyle: textTheme.titleMedium),
      titleSmall: alegreya(textStyle: textTheme.titleSmall),
      bodyLarge: alegreya(textStyle: textTheme.bodyLarge),
      bodyMedium: alegreya(textStyle: textTheme.bodyMedium),
      bodySmall: alegreya(textStyle: textTheme.bodySmall),
      labelLarge: alegreya(textStyle: textTheme.labelLarge),
      labelMedium: alegreya(textStyle: textTheme.labelMedium),
      labelSmall: alegreya(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alegreya SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alegreya+SC
  static TextStyle alegreyaSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c9484a508b55eb8eb6e8cecce0a0dd01b22893def0247245c207c2d3557f4520',
        221956,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ad1445afc298d8dcc5e5375ed0701fc5ecdee507a66e6711b49f7c16f6c51475',
        228040,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '70149b5096ea2f1019a9275f544ea40aa0b6c6de9e0af224d2db64860d0cb595',
        221400,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '380cbbdb49a7920b1c64fd52d9cec0d845a90081379f3e311718e8236c096d77',
        226976,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5d72f0cbf01d553236b99c25b7d93c4f7dfa376b5ea2b9a68d0fb9fc8978574a',
        218680,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '220bf264f4dc23ee359a69242cd3be905a01654bbe5787ec686d66d0bb84d366',
        225592,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2cd28305dde134872ff3b095b19da66fa34cc358400769b2a129b2c7c8ef3d87',
        217252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '66b4862bee541f0b94f90af2a20d0f2f890118fa443d2b215166b2970ffb551f',
        220544,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2a7cde33f7f214537e307b01bcf3346929a345550221574af80e5cb03bfc9077',
        214424,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0db199068d1a0890c97023f7eca9ac3899099f7ad3af2b646ed75a1f8bc34ab7',
        219916,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlegreyaSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alegreya SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alegreya+SC
  static TextTheme alegreyaScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: alegreyaSc(textStyle: textTheme.displayLarge),
      displayMedium: alegreyaSc(textStyle: textTheme.displayMedium),
      displaySmall: alegreyaSc(textStyle: textTheme.displaySmall),
      headlineLarge: alegreyaSc(textStyle: textTheme.headlineLarge),
      headlineMedium: alegreyaSc(textStyle: textTheme.headlineMedium),
      headlineSmall: alegreyaSc(textStyle: textTheme.headlineSmall),
      titleLarge: alegreyaSc(textStyle: textTheme.titleLarge),
      titleMedium: alegreyaSc(textStyle: textTheme.titleMedium),
      titleSmall: alegreyaSc(textStyle: textTheme.titleSmall),
      bodyLarge: alegreyaSc(textStyle: textTheme.bodyLarge),
      bodyMedium: alegreyaSc(textStyle: textTheme.bodyMedium),
      bodySmall: alegreyaSc(textStyle: textTheme.bodySmall),
      labelLarge: alegreyaSc(textStyle: textTheme.labelLarge),
      labelMedium: alegreyaSc(textStyle: textTheme.labelMedium),
      labelSmall: alegreyaSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alegreya Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alegreya+Sans
  static TextStyle alegreyaSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8d0e59e05f84bec4ce68d241dbdfa8b1eeff985301ae04cd22c8c514abf77b9d',
        124052,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'bac8ce3d4443fed88ec013859456317a1ad8d24e8b2d7c9b377afaa15ec637d3',
        129040,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '698c3b511f6218fcd375d39c3f8c74d7a6761087e679758027ea5fe066e9243a',
        126780,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e83c8c6689a19ca21cee0a46a616d85bdbd8d71a3cb7c50f68afd25a65d1ccfe',
        129828,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c204b2f8ad4a91b88b6217b24e5deb10eff4307677899d187280e79a361ab533',
        126856,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fed2193199a6365ae0d55f324b29056944d3f98b228eb4ac70a1425a3a636f5a',
        129460,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '71dedcf7e6714c202080ec7669e3e5e933884f389078001f14d3a9dcbfb8acc0',
        127264,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5b3a79ce30711cd50ca94d33b2404f154206d01c0274e3d31e27d6846cbc2fd7',
        130636,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f64b022e8b5109439835bf42f246086abba5106a9aba190c4cfd1ed6691438d8',
        127144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4b2eb1030f4dcc0c08db2633f56b838456106f838c6e701296f3c537ed35c70b',
        130300,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a14f7bc1d806ae9f704637e7f7a916e82e09f44726e9b706ef83a7365cda3118',
        127160,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'eace86cda23b5d42c8b1a946bd5c38b9cd874b9cf8c3fbe1900b2bdfa55f0546',
        130176,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2989679eb764c7070e7eb56ca862f49282ca3cc1f1c5d90756ffd91b1327739e',
        125248,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a877fb889f6aa458ea1e321773121959a8a8278a715ac5a30f3fbdf39d8a1b3e',
        128996,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlegreyaSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alegreya Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alegreya+Sans
  static TextTheme alegreyaSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: alegreyaSans(textStyle: textTheme.displayLarge),
      displayMedium: alegreyaSans(textStyle: textTheme.displayMedium),
      displaySmall: alegreyaSans(textStyle: textTheme.displaySmall),
      headlineLarge: alegreyaSans(textStyle: textTheme.headlineLarge),
      headlineMedium: alegreyaSans(textStyle: textTheme.headlineMedium),
      headlineSmall: alegreyaSans(textStyle: textTheme.headlineSmall),
      titleLarge: alegreyaSans(textStyle: textTheme.titleLarge),
      titleMedium: alegreyaSans(textStyle: textTheme.titleMedium),
      titleSmall: alegreyaSans(textStyle: textTheme.titleSmall),
      bodyLarge: alegreyaSans(textStyle: textTheme.bodyLarge),
      bodyMedium: alegreyaSans(textStyle: textTheme.bodyMedium),
      bodySmall: alegreyaSans(textStyle: textTheme.bodySmall),
      labelLarge: alegreyaSans(textStyle: textTheme.labelLarge),
      labelMedium: alegreyaSans(textStyle: textTheme.labelMedium),
      labelSmall: alegreyaSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alegreya Sans SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alegreya+Sans+SC
  static TextStyle alegreyaSansSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fa96c9ec18d4b6f4b3bf6668d7c8121e41c9089164331136c6f5bb48a4a42208',
        151440,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '297426e98a068ad1b58b52361173181330392de38d707821000888b2b60c90db',
        155464,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd27609d8069136c03abbb6960fb8138ddf4068023fc89f9e80b52a4e19d92c69',
        155284,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8afd38384720cacbeb72732f5935c538d4f1b21803d37382a71a2d0f545644bc',
        156796,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '80d79bf445e7110b689cb486b7a54978b6a059c06a92e78dcfe07c2164e616a8',
        156572,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0e4f6f8a6c630a226b85f22c76da36a6f961d2cabd26d9819bfb549097a28005',
        156828,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4f7e7fec167c7c04b9e9c0517b3061d678beaa4f248357c3931f4473bf6d50d0',
        156876,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1a7e871c8804c9a0df56d003af691ee74248d1d77d8c331ca416ec5b275a8820',
        157932,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '53a2a550eebec78401ad84f14e720d5b07cf31735d2814daea83c3e36a205a14',
        157436,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '51f31cee882b2adc11d69ebe07a0bf2d5eb916cdd058d2aea6f13fd45699a44e',
        157784,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c810a1642e52acf2fc2eb88c32dc7aae8d45cb3d4debfd46d9019688f8da30ce',
        157688,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd850a11abcaad9887ad4dbf359e7d56e92935d449ea2d282fd7b8ed203b3dc34',
        158468,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0d5566617757a1e2ca2ca8934938d246b1bcc7eec37d4abf64faa199d5dd211b',
        156868,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '27ee0cca89ca354a1bdeeafa2dd46712f106eb0152b45ce96b2ca44279f4cbc6',
        158056,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlegreyaSansSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alegreya Sans SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alegreya+Sans+SC
  static TextTheme alegreyaSansScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: alegreyaSansSc(textStyle: textTheme.displayLarge),
      displayMedium: alegreyaSansSc(textStyle: textTheme.displayMedium),
      displaySmall: alegreyaSansSc(textStyle: textTheme.displaySmall),
      headlineLarge: alegreyaSansSc(textStyle: textTheme.headlineLarge),
      headlineMedium: alegreyaSansSc(textStyle: textTheme.headlineMedium),
      headlineSmall: alegreyaSansSc(textStyle: textTheme.headlineSmall),
      titleLarge: alegreyaSansSc(textStyle: textTheme.titleLarge),
      titleMedium: alegreyaSansSc(textStyle: textTheme.titleMedium),
      titleSmall: alegreyaSansSc(textStyle: textTheme.titleSmall),
      bodyLarge: alegreyaSansSc(textStyle: textTheme.bodyLarge),
      bodyMedium: alegreyaSansSc(textStyle: textTheme.bodyMedium),
      bodySmall: alegreyaSansSc(textStyle: textTheme.bodySmall),
      labelLarge: alegreyaSansSc(textStyle: textTheme.labelLarge),
      labelMedium: alegreyaSansSc(textStyle: textTheme.labelMedium),
      labelSmall: alegreyaSansSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Aleo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aleo
  static TextStyle aleo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'df6831adf33cfd11ce6332e3b8a76e269bd211d9eae3ddc69f89f6f0c93bf6c8',
        71120,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3b5e4c089abec84aeb35c29255425be71854eb68f603f32d934ac33f1d74eac5',
        71520,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '468e2aae65cbfe2f9f81ba2ad8222695368613ae0173fead12f3965434dd94c6',
        71464,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '822c1b364d147734965f0517599f19ba72ed35af00dfa06d4bc07d3b55537980',
        71408,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9bef16c0f165e734a574cbfb0ac121ce30bc11ad09f0927898d2f56204fb83d3',
        71528,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fdeb0cd4c741216a4153119d6f2600816e6b2276d5746b87b1d09f625e75a8b3',
        71572,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c727243528c75e0d10b138ebcb9546456909ad184686eb3de9b4c66899808484',
        71592,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3b621db67e71d583afa1bcb6c15c380ff2d6564ffc8fb0b6c86595135a8e0164',
        71628,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f4db68d21d0947f496db7b88463c62be49893b85a3f7abd23c135dca6f85d933',
        71516,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '24f4755933bd763f10ab074a1cd2a01148b7199f92c5fb31930e36da481eb556',
        73864,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '065ebbaa191c3163a7738508e0667533f226d821c85283fdf931af051246da15',
        74484,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8bc3129830c25856c42a2222161d6fe66006eb27f82f20a1970aedb44c09a948',
        74548,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ddf561faadfc734f81a6d429f99db87431fe9763cd55181ea2ba8215a086f9d4',
        74528,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '22c6a2556ea04378043de6ca25251f7836b4f57885318f309de844db5ca9dff6',
        74696,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f1202961893c40273e025cf531ab4d2fbfbfa64b417a5cf7c2176b7335d27bd9',
        74664,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '190e18d29c51a2ae31c6732529b46b12edc74bc1fef3919321688e39d24de0e0',
        74656,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '03b4dbe0b9a061626763fadbefca8d7fd3386e8b3e71b05182252c69439a3443',
        74692,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1c18a23baa36c8908704a21c94393474731b9fc23835a3b5aef4fd481e930874',
        74692,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Aleo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Aleo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aleo
  static TextTheme aleoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: aleo(textStyle: textTheme.displayLarge),
      displayMedium: aleo(textStyle: textTheme.displayMedium),
      displaySmall: aleo(textStyle: textTheme.displaySmall),
      headlineLarge: aleo(textStyle: textTheme.headlineLarge),
      headlineMedium: aleo(textStyle: textTheme.headlineMedium),
      headlineSmall: aleo(textStyle: textTheme.headlineSmall),
      titleLarge: aleo(textStyle: textTheme.titleLarge),
      titleMedium: aleo(textStyle: textTheme.titleMedium),
      titleSmall: aleo(textStyle: textTheme.titleSmall),
      bodyLarge: aleo(textStyle: textTheme.bodyLarge),
      bodyMedium: aleo(textStyle: textTheme.bodyMedium),
      bodySmall: aleo(textStyle: textTheme.bodySmall),
      labelLarge: aleo(textStyle: textTheme.labelLarge),
      labelMedium: aleo(textStyle: textTheme.labelMedium),
      labelSmall: aleo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alex Brush font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alex+Brush
  static TextStyle alexBrush({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '20f20a3ed637f2b0ec78effca5e4d8d1544a18129a6c184eaefd1a16b6e4a03b',
        76384,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlexBrush',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alex Brush font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alex+Brush
  static TextTheme alexBrushTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: alexBrush(textStyle: textTheme.displayLarge),
      displayMedium: alexBrush(textStyle: textTheme.displayMedium),
      displaySmall: alexBrush(textStyle: textTheme.displaySmall),
      headlineLarge: alexBrush(textStyle: textTheme.headlineLarge),
      headlineMedium: alexBrush(textStyle: textTheme.headlineMedium),
      headlineSmall: alexBrush(textStyle: textTheme.headlineSmall),
      titleLarge: alexBrush(textStyle: textTheme.titleLarge),
      titleMedium: alexBrush(textStyle: textTheme.titleMedium),
      titleSmall: alexBrush(textStyle: textTheme.titleSmall),
      bodyLarge: alexBrush(textStyle: textTheme.bodyLarge),
      bodyMedium: alexBrush(textStyle: textTheme.bodyMedium),
      bodySmall: alexBrush(textStyle: textTheme.bodySmall),
      labelLarge: alexBrush(textStyle: textTheme.labelLarge),
      labelMedium: alexBrush(textStyle: textTheme.labelMedium),
      labelSmall: alexBrush(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alexandria font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alexandria
  static TextStyle alexandria({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9b6815b2a80bef6cc7cf1417bf0ab1da07b35a5895091ae968ad5a1dd6fbdf4c',
        101496,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dbc709565e116d6f45ad3197c34bdc2737ae422cc26a70958b7ab6fb48d3e2aa',
        101972,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e4ecf07ee412d45628ac91a1c08fceb01fa188b4f5044bccf5f7702beb881cde',
        101936,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2e3111e55cca474072cf85b56df2df4d48874c2666a2d3b57c2613ccd7606a9b',
        101580,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7d3fdc9002c28252eac2c6e012b1213e70c801b1ec542d476a34f4753ea27143',
        102848,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a41df93995df23aca1d67fef8887eb48280ff7e6ebde4e2e7185fdcb63ddccdc',
        102956,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '640f146379762b2692dd459ae6e2530f75f01d9aaf3e928b9f8c3c12882dbf63',
        102888,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '684a064f3030d179ae1a1e995f0814ac85d8044228291a831963bed424b3065c',
        102936,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7ebd3f2bda7cadbd784b284dece25740d21c8b88cb2e24e5a85a77c0303f419c',
        102720,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Alexandria',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alexandria font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alexandria
  static TextTheme alexandriaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: alexandria(textStyle: textTheme.displayLarge),
      displayMedium: alexandria(textStyle: textTheme.displayMedium),
      displaySmall: alexandria(textStyle: textTheme.displaySmall),
      headlineLarge: alexandria(textStyle: textTheme.headlineLarge),
      headlineMedium: alexandria(textStyle: textTheme.headlineMedium),
      headlineSmall: alexandria(textStyle: textTheme.headlineSmall),
      titleLarge: alexandria(textStyle: textTheme.titleLarge),
      titleMedium: alexandria(textStyle: textTheme.titleMedium),
      titleSmall: alexandria(textStyle: textTheme.titleSmall),
      bodyLarge: alexandria(textStyle: textTheme.bodyLarge),
      bodyMedium: alexandria(textStyle: textTheme.bodyMedium),
      bodySmall: alexandria(textStyle: textTheme.bodySmall),
      labelLarge: alexandria(textStyle: textTheme.labelLarge),
      labelMedium: alexandria(textStyle: textTheme.labelMedium),
      labelSmall: alexandria(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alfa Slab One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alfa+Slab+One
  static TextStyle alfaSlabOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c8fdd2d13c762eace9a89ef14ec1439f788062d7bb7dac53d3dc1e4da50abc78',
        59060,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlfaSlabOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alfa Slab One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alfa+Slab+One
  static TextTheme alfaSlabOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: alfaSlabOne(textStyle: textTheme.displayLarge),
      displayMedium: alfaSlabOne(textStyle: textTheme.displayMedium),
      displaySmall: alfaSlabOne(textStyle: textTheme.displaySmall),
      headlineLarge: alfaSlabOne(textStyle: textTheme.headlineLarge),
      headlineMedium: alfaSlabOne(textStyle: textTheme.headlineMedium),
      headlineSmall: alfaSlabOne(textStyle: textTheme.headlineSmall),
      titleLarge: alfaSlabOne(textStyle: textTheme.titleLarge),
      titleMedium: alfaSlabOne(textStyle: textTheme.titleMedium),
      titleSmall: alfaSlabOne(textStyle: textTheme.titleSmall),
      bodyLarge: alfaSlabOne(textStyle: textTheme.bodyLarge),
      bodyMedium: alfaSlabOne(textStyle: textTheme.bodyMedium),
      bodySmall: alfaSlabOne(textStyle: textTheme.bodySmall),
      labelLarge: alfaSlabOne(textStyle: textTheme.labelLarge),
      labelMedium: alfaSlabOne(textStyle: textTheme.labelMedium),
      labelSmall: alfaSlabOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alice font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alice
  static TextStyle alice({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e749db529af801dece7d5ddc3cc139ea81e17fcf1da06f09dab98e4e72b28afc',
        89536,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Alice',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alice font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alice
  static TextTheme aliceTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: alice(textStyle: textTheme.displayLarge),
      displayMedium: alice(textStyle: textTheme.displayMedium),
      displaySmall: alice(textStyle: textTheme.displaySmall),
      headlineLarge: alice(textStyle: textTheme.headlineLarge),
      headlineMedium: alice(textStyle: textTheme.headlineMedium),
      headlineSmall: alice(textStyle: textTheme.headlineSmall),
      titleLarge: alice(textStyle: textTheme.titleLarge),
      titleMedium: alice(textStyle: textTheme.titleMedium),
      titleSmall: alice(textStyle: textTheme.titleSmall),
      bodyLarge: alice(textStyle: textTheme.bodyLarge),
      bodyMedium: alice(textStyle: textTheme.bodyMedium),
      bodySmall: alice(textStyle: textTheme.bodySmall),
      labelLarge: alice(textStyle: textTheme.labelLarge),
      labelMedium: alice(textStyle: textTheme.labelMedium),
      labelSmall: alice(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alike font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alike
  static TextStyle alike({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f915f266b2f2dad39c843bbc1e70c74c1722031a5b3db7c52733cdf3a987a7e2',
        49924,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Alike',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alike font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alike
  static TextTheme alikeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: alike(textStyle: textTheme.displayLarge),
      displayMedium: alike(textStyle: textTheme.displayMedium),
      displaySmall: alike(textStyle: textTheme.displaySmall),
      headlineLarge: alike(textStyle: textTheme.headlineLarge),
      headlineMedium: alike(textStyle: textTheme.headlineMedium),
      headlineSmall: alike(textStyle: textTheme.headlineSmall),
      titleLarge: alike(textStyle: textTheme.titleLarge),
      titleMedium: alike(textStyle: textTheme.titleMedium),
      titleSmall: alike(textStyle: textTheme.titleSmall),
      bodyLarge: alike(textStyle: textTheme.bodyLarge),
      bodyMedium: alike(textStyle: textTheme.bodyMedium),
      bodySmall: alike(textStyle: textTheme.bodySmall),
      labelLarge: alike(textStyle: textTheme.labelLarge),
      labelMedium: alike(textStyle: textTheme.labelMedium),
      labelSmall: alike(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alike Angular font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alike+Angular
  static TextStyle alikeAngular({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c1a5bdb1afb2df6e6da2aa95b5dd2cd7f7de46e5d39d06a166e7245d5fe03be4',
        44400,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlikeAngular',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alike Angular font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alike+Angular
  static TextTheme alikeAngularTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: alikeAngular(textStyle: textTheme.displayLarge),
      displayMedium: alikeAngular(textStyle: textTheme.displayMedium),
      displaySmall: alikeAngular(textStyle: textTheme.displaySmall),
      headlineLarge: alikeAngular(textStyle: textTheme.headlineLarge),
      headlineMedium: alikeAngular(textStyle: textTheme.headlineMedium),
      headlineSmall: alikeAngular(textStyle: textTheme.headlineSmall),
      titleLarge: alikeAngular(textStyle: textTheme.titleLarge),
      titleMedium: alikeAngular(textStyle: textTheme.titleMedium),
      titleSmall: alikeAngular(textStyle: textTheme.titleSmall),
      bodyLarge: alikeAngular(textStyle: textTheme.bodyLarge),
      bodyMedium: alikeAngular(textStyle: textTheme.bodyMedium),
      bodySmall: alikeAngular(textStyle: textTheme.bodySmall),
      labelLarge: alikeAngular(textStyle: textTheme.labelLarge),
      labelMedium: alikeAngular(textStyle: textTheme.labelMedium),
      labelSmall: alikeAngular(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alkalami font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alkalami
  static TextStyle alkalami({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5029cad74704c5c2113426243c68574047c74fbf772096805717ddd9c2dd132d',
        123592,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Alkalami',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alkalami font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alkalami
  static TextTheme alkalamiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: alkalami(textStyle: textTheme.displayLarge),
      displayMedium: alkalami(textStyle: textTheme.displayMedium),
      displaySmall: alkalami(textStyle: textTheme.displaySmall),
      headlineLarge: alkalami(textStyle: textTheme.headlineLarge),
      headlineMedium: alkalami(textStyle: textTheme.headlineMedium),
      headlineSmall: alkalami(textStyle: textTheme.headlineSmall),
      titleLarge: alkalami(textStyle: textTheme.titleLarge),
      titleMedium: alkalami(textStyle: textTheme.titleMedium),
      titleSmall: alkalami(textStyle: textTheme.titleSmall),
      bodyLarge: alkalami(textStyle: textTheme.bodyLarge),
      bodyMedium: alkalami(textStyle: textTheme.bodyMedium),
      bodySmall: alkalami(textStyle: textTheme.bodySmall),
      labelLarge: alkalami(textStyle: textTheme.labelLarge),
      labelMedium: alkalami(textStyle: textTheme.labelMedium),
      labelSmall: alkalami(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alkatra font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alkatra
  static TextStyle alkatra({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '006aa1cf290a6de355508ee70592add5dee5dcdf43d47085a01a733cb5bb8e33',
        507432,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '39dccff4c7a394a81a9a737a7d103feb88b30ce3391b4ca921b7c237538bae17',
        508816,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2b0c037b299139fcc55583b65177472ceeff5d0449d60f32a51bb7a2566dfcb3',
        508868,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c18ca8b0e467523a56b3fef0f87ab159b47dff04c427e255238cd744810097c5',
        508092,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Alkatra',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alkatra font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alkatra
  static TextTheme alkatraTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: alkatra(textStyle: textTheme.displayLarge),
      displayMedium: alkatra(textStyle: textTheme.displayMedium),
      displaySmall: alkatra(textStyle: textTheme.displaySmall),
      headlineLarge: alkatra(textStyle: textTheme.headlineLarge),
      headlineMedium: alkatra(textStyle: textTheme.headlineMedium),
      headlineSmall: alkatra(textStyle: textTheme.headlineSmall),
      titleLarge: alkatra(textStyle: textTheme.titleLarge),
      titleMedium: alkatra(textStyle: textTheme.titleMedium),
      titleSmall: alkatra(textStyle: textTheme.titleSmall),
      bodyLarge: alkatra(textStyle: textTheme.bodyLarge),
      bodyMedium: alkatra(textStyle: textTheme.bodyMedium),
      bodySmall: alkatra(textStyle: textTheme.bodySmall),
      labelLarge: alkatra(textStyle: textTheme.labelLarge),
      labelMedium: alkatra(textStyle: textTheme.labelMedium),
      labelSmall: alkatra(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Allan font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allan
  static TextStyle allan({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6af8f59b73a97c889439b898eba9bdd1c0f9059b2956d93f1dc71e7ece4d93ea',
        28924,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6e1c058c7e2a98326e1ae63cef4238e826976fb6008082c497872c59c7c7eeea',
        43028,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Allan',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Allan font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allan
  static TextTheme allanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: allan(textStyle: textTheme.displayLarge),
      displayMedium: allan(textStyle: textTheme.displayMedium),
      displaySmall: allan(textStyle: textTheme.displaySmall),
      headlineLarge: allan(textStyle: textTheme.headlineLarge),
      headlineMedium: allan(textStyle: textTheme.headlineMedium),
      headlineSmall: allan(textStyle: textTheme.headlineSmall),
      titleLarge: allan(textStyle: textTheme.titleLarge),
      titleMedium: allan(textStyle: textTheme.titleMedium),
      titleSmall: allan(textStyle: textTheme.titleSmall),
      bodyLarge: allan(textStyle: textTheme.bodyLarge),
      bodyMedium: allan(textStyle: textTheme.bodyMedium),
      bodySmall: allan(textStyle: textTheme.bodySmall),
      labelLarge: allan(textStyle: textTheme.labelLarge),
      labelMedium: allan(textStyle: textTheme.labelMedium),
      labelSmall: allan(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Allerta font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allerta
  static TextStyle allerta({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '966ff64339f556e7b5cd72638a17f46ce434fcaa9a36e04017cf34540c27e5cc',
        15184,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Allerta',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Allerta font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allerta
  static TextTheme allertaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: allerta(textStyle: textTheme.displayLarge),
      displayMedium: allerta(textStyle: textTheme.displayMedium),
      displaySmall: allerta(textStyle: textTheme.displaySmall),
      headlineLarge: allerta(textStyle: textTheme.headlineLarge),
      headlineMedium: allerta(textStyle: textTheme.headlineMedium),
      headlineSmall: allerta(textStyle: textTheme.headlineSmall),
      titleLarge: allerta(textStyle: textTheme.titleLarge),
      titleMedium: allerta(textStyle: textTheme.titleMedium),
      titleSmall: allerta(textStyle: textTheme.titleSmall),
      bodyLarge: allerta(textStyle: textTheme.bodyLarge),
      bodyMedium: allerta(textStyle: textTheme.bodyMedium),
      bodySmall: allerta(textStyle: textTheme.bodySmall),
      labelLarge: allerta(textStyle: textTheme.labelLarge),
      labelMedium: allerta(textStyle: textTheme.labelMedium),
      labelSmall: allerta(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Allerta Stencil font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allerta+Stencil
  static TextStyle allertaStencil({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '14ad8d8d5ad8fd1a841290ae1d281bdb7e491df21221aef4c38e5de309fd7cb6',
        15684,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AllertaStencil',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Allerta Stencil font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allerta+Stencil
  static TextTheme allertaStencilTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: allertaStencil(textStyle: textTheme.displayLarge),
      displayMedium: allertaStencil(textStyle: textTheme.displayMedium),
      displaySmall: allertaStencil(textStyle: textTheme.displaySmall),
      headlineLarge: allertaStencil(textStyle: textTheme.headlineLarge),
      headlineMedium: allertaStencil(textStyle: textTheme.headlineMedium),
      headlineSmall: allertaStencil(textStyle: textTheme.headlineSmall),
      titleLarge: allertaStencil(textStyle: textTheme.titleLarge),
      titleMedium: allertaStencil(textStyle: textTheme.titleMedium),
      titleSmall: allertaStencil(textStyle: textTheme.titleSmall),
      bodyLarge: allertaStencil(textStyle: textTheme.bodyLarge),
      bodyMedium: allertaStencil(textStyle: textTheme.bodyMedium),
      bodySmall: allertaStencil(textStyle: textTheme.bodySmall),
      labelLarge: allertaStencil(textStyle: textTheme.labelLarge),
      labelMedium: allertaStencil(textStyle: textTheme.labelMedium),
      labelSmall: allertaStencil(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Allison font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allison
  static TextStyle allison({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c4e42eedfd31d1afecc52ce28994727e06f07ad83555e3f63d13a9a4e9f8a1bc',
        93744,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Allison',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Allison font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allison
  static TextTheme allisonTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: allison(textStyle: textTheme.displayLarge),
      displayMedium: allison(textStyle: textTheme.displayMedium),
      displaySmall: allison(textStyle: textTheme.displaySmall),
      headlineLarge: allison(textStyle: textTheme.headlineLarge),
      headlineMedium: allison(textStyle: textTheme.headlineMedium),
      headlineSmall: allison(textStyle: textTheme.headlineSmall),
      titleLarge: allison(textStyle: textTheme.titleLarge),
      titleMedium: allison(textStyle: textTheme.titleMedium),
      titleSmall: allison(textStyle: textTheme.titleSmall),
      bodyLarge: allison(textStyle: textTheme.bodyLarge),
      bodyMedium: allison(textStyle: textTheme.bodyMedium),
      bodySmall: allison(textStyle: textTheme.bodySmall),
      labelLarge: allison(textStyle: textTheme.labelLarge),
      labelMedium: allison(textStyle: textTheme.labelMedium),
      labelSmall: allison(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Allura font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allura
  static TextStyle allura({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e84e30d1e22e3c4ae60ded0ac6683007c358ba996c352a5edf6599a0ba8aafa0',
        109228,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Allura',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Allura font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allura
  static TextTheme alluraTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: allura(textStyle: textTheme.displayLarge),
      displayMedium: allura(textStyle: textTheme.displayMedium),
      displaySmall: allura(textStyle: textTheme.displaySmall),
      headlineLarge: allura(textStyle: textTheme.headlineLarge),
      headlineMedium: allura(textStyle: textTheme.headlineMedium),
      headlineSmall: allura(textStyle: textTheme.headlineSmall),
      titleLarge: allura(textStyle: textTheme.titleLarge),
      titleMedium: allura(textStyle: textTheme.titleMedium),
      titleSmall: allura(textStyle: textTheme.titleSmall),
      bodyLarge: allura(textStyle: textTheme.bodyLarge),
      bodyMedium: allura(textStyle: textTheme.bodyMedium),
      bodySmall: allura(textStyle: textTheme.bodySmall),
      labelLarge: allura(textStyle: textTheme.labelLarge),
      labelMedium: allura(textStyle: textTheme.labelMedium),
      labelSmall: allura(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Almarai font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Almarai
  static TextStyle almarai({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '82a22b76b0460a3bc66a94d16aae567637288d1c3c77a5cc5a1c71f235eba150',
        85828,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8123e9cd0c430e569e83475765af4fb01bb148d60534df3f96fb2669bae2c6bc',
        85912,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '52025e83b24d3c5cf43ee005e784af9dbbe14cfd4eb77b6546cdf90d86cb0bda',
        85696,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e2a1cb321bae24a4995bb6c3ff42b26355de1915c89be5465448a4bded2bbb33',
        86588,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Almarai',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Almarai font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Almarai
  static TextTheme almaraiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: almarai(textStyle: textTheme.displayLarge),
      displayMedium: almarai(textStyle: textTheme.displayMedium),
      displaySmall: almarai(textStyle: textTheme.displaySmall),
      headlineLarge: almarai(textStyle: textTheme.headlineLarge),
      headlineMedium: almarai(textStyle: textTheme.headlineMedium),
      headlineSmall: almarai(textStyle: textTheme.headlineSmall),
      titleLarge: almarai(textStyle: textTheme.titleLarge),
      titleMedium: almarai(textStyle: textTheme.titleMedium),
      titleSmall: almarai(textStyle: textTheme.titleSmall),
      bodyLarge: almarai(textStyle: textTheme.bodyLarge),
      bodyMedium: almarai(textStyle: textTheme.bodyMedium),
      bodySmall: almarai(textStyle: textTheme.bodySmall),
      labelLarge: almarai(textStyle: textTheme.labelLarge),
      labelMedium: almarai(textStyle: textTheme.labelMedium),
      labelSmall: almarai(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Almendra font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Almendra
  static TextStyle almendra({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c89f19adbceeb351c7c89568fbeabd3c801df1e262f84242fbd01284dfe5ae97',
        57300,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '40a5892e1283273ad00379928c370f78309c9a17627ceb57f678606ef2646daa',
        32852,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6064dade838bed7b29151972ff2740044097f5ca6a1ed9450043b766a07506cc',
        34200,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '44a9959853400a337d8d6c8e144e74380d13740a0b357b4169d241ba05c6fcfc',
        32964,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Almendra',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Almendra font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Almendra
  static TextTheme almendraTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: almendra(textStyle: textTheme.displayLarge),
      displayMedium: almendra(textStyle: textTheme.displayMedium),
      displaySmall: almendra(textStyle: textTheme.displaySmall),
      headlineLarge: almendra(textStyle: textTheme.headlineLarge),
      headlineMedium: almendra(textStyle: textTheme.headlineMedium),
      headlineSmall: almendra(textStyle: textTheme.headlineSmall),
      titleLarge: almendra(textStyle: textTheme.titleLarge),
      titleMedium: almendra(textStyle: textTheme.titleMedium),
      titleSmall: almendra(textStyle: textTheme.titleSmall),
      bodyLarge: almendra(textStyle: textTheme.bodyLarge),
      bodyMedium: almendra(textStyle: textTheme.bodyMedium),
      bodySmall: almendra(textStyle: textTheme.bodySmall),
      labelLarge: almendra(textStyle: textTheme.labelLarge),
      labelMedium: almendra(textStyle: textTheme.labelMedium),
      labelSmall: almendra(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Almendra Display font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Almendra+Display
  static TextStyle almendraDisplay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '83d146faecfa0ccf42536ddc4acf30eeb3ca34f6ebc1c923c80e72a8c611b70b',
        36816,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlmendraDisplay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Almendra Display font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Almendra+Display
  static TextTheme almendraDisplayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: almendraDisplay(textStyle: textTheme.displayLarge),
      displayMedium: almendraDisplay(textStyle: textTheme.displayMedium),
      displaySmall: almendraDisplay(textStyle: textTheme.displaySmall),
      headlineLarge: almendraDisplay(textStyle: textTheme.headlineLarge),
      headlineMedium: almendraDisplay(textStyle: textTheme.headlineMedium),
      headlineSmall: almendraDisplay(textStyle: textTheme.headlineSmall),
      titleLarge: almendraDisplay(textStyle: textTheme.titleLarge),
      titleMedium: almendraDisplay(textStyle: textTheme.titleMedium),
      titleSmall: almendraDisplay(textStyle: textTheme.titleSmall),
      bodyLarge: almendraDisplay(textStyle: textTheme.bodyLarge),
      bodyMedium: almendraDisplay(textStyle: textTheme.bodyMedium),
      bodySmall: almendraDisplay(textStyle: textTheme.bodySmall),
      labelLarge: almendraDisplay(textStyle: textTheme.labelLarge),
      labelMedium: almendraDisplay(textStyle: textTheme.labelMedium),
      labelSmall: almendraDisplay(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Almendra SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Almendra+SC
  static TextStyle almendraSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6b2742a31660bb8974d980f89345e91bfa56beba91c56c50db4beb89f5d56c81',
        33572,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlmendraSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Almendra SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Almendra+SC
  static TextTheme almendraScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: almendraSc(textStyle: textTheme.displayLarge),
      displayMedium: almendraSc(textStyle: textTheme.displayMedium),
      displaySmall: almendraSc(textStyle: textTheme.displaySmall),
      headlineLarge: almendraSc(textStyle: textTheme.headlineLarge),
      headlineMedium: almendraSc(textStyle: textTheme.headlineMedium),
      headlineSmall: almendraSc(textStyle: textTheme.headlineSmall),
      titleLarge: almendraSc(textStyle: textTheme.titleLarge),
      titleMedium: almendraSc(textStyle: textTheme.titleMedium),
      titleSmall: almendraSc(textStyle: textTheme.titleSmall),
      bodyLarge: almendraSc(textStyle: textTheme.bodyLarge),
      bodyMedium: almendraSc(textStyle: textTheme.bodyMedium),
      bodySmall: almendraSc(textStyle: textTheme.bodySmall),
      labelLarge: almendraSc(textStyle: textTheme.labelLarge),
      labelMedium: almendraSc(textStyle: textTheme.labelMedium),
      labelSmall: almendraSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alumni Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alumni+Sans
  static TextStyle alumniSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '964b1adcd76b6c17b940944548871145339a1e4d4d73bd617b2807e10b6b07ad',
        63948,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '523ea4a4be84452aec7cb167b926cc98cc63b086bc84fcb365ca58231f164a91',
        64160,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3a8a27615378d9205bf7488c94e901eaa5dc06a07b2aaf37c86940dc00aa89c9',
        64148,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '85ea2eaf4231d3084dbee44b4156108dabc72f7ec75697493509ae7a8d29a11d',
        64208,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '74ae9c63424c75a5c7befc7ef5ec853c04b3c80a4cbb28d49bf787c300242db5',
        65004,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '86eb1ffa7917a8e5fdf639648f6331d3f1c9a3a0925918d5e3c055b94963f816',
        65760,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '260dbce0e67d2c8e2927e03360ed6db7a7afd20c6a152181f0a83197109dc794',
        65732,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1740bc61b53bb27d1dfadd4cc0d7fc1e683c3bda393a43d5395729b8b962e38a',
        65784,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7113d0a080855484c6e76c019b73266a910e96a96e32aa906cd23dc02268ed62',
        65476,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'bfdbbbe08a6dc854aa12f8b72d8e2d6abfb9c33e1f25bc9e01304e2c50b0dfe0',
        66616,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9c263ad9d87d46f4b18cb408b85e30cd6584be8e13984b6a65fb6644470e131a',
        66772,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd6f8650bd87ba55aa93f329d6ecd39d2c61eba1458e766205956d198ccd6ff01',
        66716,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ddfa5772f9876e577993d7410487dcd4c8091dd773cfb0a220f2974b5985d5d3',
        66640,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '11f4b5840181d2477b10a0c4d2750759f1f4e4e3cb41a85dffe2167618d4b642',
        67532,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '38e373a2f5d385c5130818b436ecc461684bacd60a06e88ace1580c50c274591',
        68384,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '44eb05621e005f1f857cb09af5ee2424bb6cdaa6a21eafc77ab3d9dcd37e1e86',
        68292,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a5f7fac04ef17561c4bece1bbd10e123c2765375d9c423581415fca05d1dd9ca',
        68360,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '219dc689e3537bd34e7d8a54a0f63567fe0e8f60a391b2345d8d3e6493cd0962',
        68168,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlumniSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alumni Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alumni+Sans
  static TextTheme alumniSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: alumniSans(textStyle: textTheme.displayLarge),
      displayMedium: alumniSans(textStyle: textTheme.displayMedium),
      displaySmall: alumniSans(textStyle: textTheme.displaySmall),
      headlineLarge: alumniSans(textStyle: textTheme.headlineLarge),
      headlineMedium: alumniSans(textStyle: textTheme.headlineMedium),
      headlineSmall: alumniSans(textStyle: textTheme.headlineSmall),
      titleLarge: alumniSans(textStyle: textTheme.titleLarge),
      titleMedium: alumniSans(textStyle: textTheme.titleMedium),
      titleSmall: alumniSans(textStyle: textTheme.titleSmall),
      bodyLarge: alumniSans(textStyle: textTheme.bodyLarge),
      bodyMedium: alumniSans(textStyle: textTheme.bodyMedium),
      bodySmall: alumniSans(textStyle: textTheme.bodySmall),
      labelLarge: alumniSans(textStyle: textTheme.labelLarge),
      labelMedium: alumniSans(textStyle: textTheme.labelMedium),
      labelSmall: alumniSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alumni Sans Collegiate One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alumni+Sans+Collegiate+One
  static TextStyle alumniSansCollegiateOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '36aa50c9dac2ac09d41760e9d2a404bcfba618dc409d392b24455b3a334291ab',
        110172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ce49e1ba13cc8aea97ca7662cf005c2d0e66fd30733e342136996e32f5fce181',
        116612,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlumniSansCollegiateOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alumni Sans Collegiate One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alumni+Sans+Collegiate+One
  static TextTheme alumniSansCollegiateOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: alumniSansCollegiateOne(textStyle: textTheme.displayLarge),
      displayMedium:
          alumniSansCollegiateOne(textStyle: textTheme.displayMedium),
      displaySmall: alumniSansCollegiateOne(textStyle: textTheme.displaySmall),
      headlineLarge:
          alumniSansCollegiateOne(textStyle: textTheme.headlineLarge),
      headlineMedium:
          alumniSansCollegiateOne(textStyle: textTheme.headlineMedium),
      headlineSmall:
          alumniSansCollegiateOne(textStyle: textTheme.headlineSmall),
      titleLarge: alumniSansCollegiateOne(textStyle: textTheme.titleLarge),
      titleMedium: alumniSansCollegiateOne(textStyle: textTheme.titleMedium),
      titleSmall: alumniSansCollegiateOne(textStyle: textTheme.titleSmall),
      bodyLarge: alumniSansCollegiateOne(textStyle: textTheme.bodyLarge),
      bodyMedium: alumniSansCollegiateOne(textStyle: textTheme.bodyMedium),
      bodySmall: alumniSansCollegiateOne(textStyle: textTheme.bodySmall),
      labelLarge: alumniSansCollegiateOne(textStyle: textTheme.labelLarge),
      labelMedium: alumniSansCollegiateOne(textStyle: textTheme.labelMedium),
      labelSmall: alumniSansCollegiateOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alumni Sans Inline One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alumni+Sans+Inline+One
  static TextStyle alumniSansInlineOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '14d45facd03a99018658d0f4b42d042881f20495a9d2c544e1284bea8be27318',
        72424,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '56df03fce4c95d92416eb2141ccad5aba44f47fa68eee4015f6fe8331e006e5e',
        76416,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlumniSansInlineOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alumni Sans Inline One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alumni+Sans+Inline+One
  static TextTheme alumniSansInlineOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: alumniSansInlineOne(textStyle: textTheme.displayLarge),
      displayMedium: alumniSansInlineOne(textStyle: textTheme.displayMedium),
      displaySmall: alumniSansInlineOne(textStyle: textTheme.displaySmall),
      headlineLarge: alumniSansInlineOne(textStyle: textTheme.headlineLarge),
      headlineMedium: alumniSansInlineOne(textStyle: textTheme.headlineMedium),
      headlineSmall: alumniSansInlineOne(textStyle: textTheme.headlineSmall),
      titleLarge: alumniSansInlineOne(textStyle: textTheme.titleLarge),
      titleMedium: alumniSansInlineOne(textStyle: textTheme.titleMedium),
      titleSmall: alumniSansInlineOne(textStyle: textTheme.titleSmall),
      bodyLarge: alumniSansInlineOne(textStyle: textTheme.bodyLarge),
      bodyMedium: alumniSansInlineOne(textStyle: textTheme.bodyMedium),
      bodySmall: alumniSansInlineOne(textStyle: textTheme.bodySmall),
      labelLarge: alumniSansInlineOne(textStyle: textTheme.labelLarge),
      labelMedium: alumniSansInlineOne(textStyle: textTheme.labelMedium),
      labelSmall: alumniSansInlineOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Alumni Sans Pinstripe font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alumni+Sans+Pinstripe
  static TextStyle alumniSansPinstripe({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '91bbe00afe72f0c71b9f0918130ae560a7952dabb003dfa9d389a0f2afd920e9',
        76104,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4029d2bcae2ff604d6a89f2e310b66b0e181d27d20c9de8c4d4dfaa88457efde',
        80984,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlumniSansPinstripe',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alumni Sans Pinstripe font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alumni+Sans+Pinstripe
  static TextTheme alumniSansPinstripeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: alumniSansPinstripe(textStyle: textTheme.displayLarge),
      displayMedium: alumniSansPinstripe(textStyle: textTheme.displayMedium),
      displaySmall: alumniSansPinstripe(textStyle: textTheme.displaySmall),
      headlineLarge: alumniSansPinstripe(textStyle: textTheme.headlineLarge),
      headlineMedium: alumniSansPinstripe(textStyle: textTheme.headlineMedium),
      headlineSmall: alumniSansPinstripe(textStyle: textTheme.headlineSmall),
      titleLarge: alumniSansPinstripe(textStyle: textTheme.titleLarge),
      titleMedium: alumniSansPinstripe(textStyle: textTheme.titleMedium),
      titleSmall: alumniSansPinstripe(textStyle: textTheme.titleSmall),
      bodyLarge: alumniSansPinstripe(textStyle: textTheme.bodyLarge),
      bodyMedium: alumniSansPinstripe(textStyle: textTheme.bodyMedium),
      bodySmall: alumniSansPinstripe(textStyle: textTheme.bodySmall),
      labelLarge: alumniSansPinstripe(textStyle: textTheme.labelLarge),
      labelMedium: alumniSansPinstripe(textStyle: textTheme.labelMedium),
      labelSmall: alumniSansPinstripe(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Amarante font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amarante
  static TextStyle amarante({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a429147d4b4024562801d9dc3eb8869b757b41dde1af156fa1eb432ff47f92ee',
        69428,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Amarante',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Amarante font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amarante
  static TextTheme amaranteTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: amarante(textStyle: textTheme.displayLarge),
      displayMedium: amarante(textStyle: textTheme.displayMedium),
      displaySmall: amarante(textStyle: textTheme.displaySmall),
      headlineLarge: amarante(textStyle: textTheme.headlineLarge),
      headlineMedium: amarante(textStyle: textTheme.headlineMedium),
      headlineSmall: amarante(textStyle: textTheme.headlineSmall),
      titleLarge: amarante(textStyle: textTheme.titleLarge),
      titleMedium: amarante(textStyle: textTheme.titleMedium),
      titleSmall: amarante(textStyle: textTheme.titleSmall),
      bodyLarge: amarante(textStyle: textTheme.bodyLarge),
      bodyMedium: amarante(textStyle: textTheme.bodyMedium),
      bodySmall: amarante(textStyle: textTheme.bodySmall),
      labelLarge: amarante(textStyle: textTheme.labelLarge),
      labelMedium: amarante(textStyle: textTheme.labelMedium),
      labelSmall: amarante(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Amaranth font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amaranth
  static TextStyle amaranth({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3686273f732592e770fead7f911c7d7a8f281e98c325dbf7fccddd3da291aa62',
        41744,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3c6a40add2c4b1adc53423a1cf451bdfa8e293d34ba6c9e46cb61591fa434140',
        46900,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '37bf53dc84920307ac64820d8a30124f16c8b56f72082e6c5accf66fdb6267ab',
        41216,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9a21fadfc70d4e1272aee014ef3fcf8829c70c5c96324492b3e7f93bcaf62502',
        46680,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Amaranth',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Amaranth font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amaranth
  static TextTheme amaranthTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: amaranth(textStyle: textTheme.displayLarge),
      displayMedium: amaranth(textStyle: textTheme.displayMedium),
      displaySmall: amaranth(textStyle: textTheme.displaySmall),
      headlineLarge: amaranth(textStyle: textTheme.headlineLarge),
      headlineMedium: amaranth(textStyle: textTheme.headlineMedium),
      headlineSmall: amaranth(textStyle: textTheme.headlineSmall),
      titleLarge: amaranth(textStyle: textTheme.titleLarge),
      titleMedium: amaranth(textStyle: textTheme.titleMedium),
      titleSmall: amaranth(textStyle: textTheme.titleSmall),
      bodyLarge: amaranth(textStyle: textTheme.bodyLarge),
      bodyMedium: amaranth(textStyle: textTheme.bodyMedium),
      bodySmall: amaranth(textStyle: textTheme.bodySmall),
      labelLarge: amaranth(textStyle: textTheme.labelLarge),
      labelMedium: amaranth(textStyle: textTheme.labelMedium),
      labelSmall: amaranth(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Amatic SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amatic+SC
  static TextStyle amaticSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '06a80a564c495610f0e552c7088d9b2cba6293c27d1338e0be693a6c51ef7819',
        103632,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'aac2c7ecfcd66f4e77dc1eeb67bae2c0d1684dbe691c4d584956c6799dae815b',
        101308,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AmaticSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Amatic SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amatic+SC
  static TextTheme amaticScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: amaticSc(textStyle: textTheme.displayLarge),
      displayMedium: amaticSc(textStyle: textTheme.displayMedium),
      displaySmall: amaticSc(textStyle: textTheme.displaySmall),
      headlineLarge: amaticSc(textStyle: textTheme.headlineLarge),
      headlineMedium: amaticSc(textStyle: textTheme.headlineMedium),
      headlineSmall: amaticSc(textStyle: textTheme.headlineSmall),
      titleLarge: amaticSc(textStyle: textTheme.titleLarge),
      titleMedium: amaticSc(textStyle: textTheme.titleMedium),
      titleSmall: amaticSc(textStyle: textTheme.titleSmall),
      bodyLarge: amaticSc(textStyle: textTheme.bodyLarge),
      bodyMedium: amaticSc(textStyle: textTheme.bodyMedium),
      bodySmall: amaticSc(textStyle: textTheme.bodySmall),
      labelLarge: amaticSc(textStyle: textTheme.labelLarge),
      labelMedium: amaticSc(textStyle: textTheme.labelMedium),
      labelSmall: amaticSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Amethysta font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amethysta
  static TextStyle amethysta({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cdc0246bf774ad00a0c305ed9853782f799293cfff59e08f7b38c5f156f3726b',
        20232,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Amethysta',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Amethysta font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amethysta
  static TextTheme amethystaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: amethysta(textStyle: textTheme.displayLarge),
      displayMedium: amethysta(textStyle: textTheme.displayMedium),
      displaySmall: amethysta(textStyle: textTheme.displaySmall),
      headlineLarge: amethysta(textStyle: textTheme.headlineLarge),
      headlineMedium: amethysta(textStyle: textTheme.headlineMedium),
      headlineSmall: amethysta(textStyle: textTheme.headlineSmall),
      titleLarge: amethysta(textStyle: textTheme.titleLarge),
      titleMedium: amethysta(textStyle: textTheme.titleMedium),
      titleSmall: amethysta(textStyle: textTheme.titleSmall),
      bodyLarge: amethysta(textStyle: textTheme.bodyLarge),
      bodyMedium: amethysta(textStyle: textTheme.bodyMedium),
      bodySmall: amethysta(textStyle: textTheme.bodySmall),
      labelLarge: amethysta(textStyle: textTheme.labelLarge),
      labelMedium: amethysta(textStyle: textTheme.labelMedium),
      labelSmall: amethysta(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Amiko font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amiko
  static TextStyle amiko({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '939cdfc80fa6aa02a7825f0ba1b649e6b1c90a6781189dcd2050e10cb15642db',
        122356,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bf0ddb1a0ad742f6450e8e6279c86a672152661ed925823d61d34b1da309bd11',
        121820,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6e8c6780a6f6cabbd4019c8d0beeb9177d17fbb576265c2ff7e8e2766836ce15',
        121340,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Amiko',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Amiko font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amiko
  static TextTheme amikoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: amiko(textStyle: textTheme.displayLarge),
      displayMedium: amiko(textStyle: textTheme.displayMedium),
      displaySmall: amiko(textStyle: textTheme.displaySmall),
      headlineLarge: amiko(textStyle: textTheme.headlineLarge),
      headlineMedium: amiko(textStyle: textTheme.headlineMedium),
      headlineSmall: amiko(textStyle: textTheme.headlineSmall),
      titleLarge: amiko(textStyle: textTheme.titleLarge),
      titleMedium: amiko(textStyle: textTheme.titleMedium),
      titleSmall: amiko(textStyle: textTheme.titleSmall),
      bodyLarge: amiko(textStyle: textTheme.bodyLarge),
      bodyMedium: amiko(textStyle: textTheme.bodyMedium),
      bodySmall: amiko(textStyle: textTheme.bodySmall),
      labelLarge: amiko(textStyle: textTheme.labelLarge),
      labelMedium: amiko(textStyle: textTheme.labelMedium),
      labelSmall: amiko(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Amiri font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amiri
  static TextStyle amiri({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '82b49c37cfb90dd8fff8aab7508c2078bb32a200648acb2237dc02c30f4492ad',
        403728,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '635b094bdc2448d6d35f9ebe9ce0ac4a5437ff07d83fd42100f515cd94428cf0',
        401896,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '53c460187d4f6d8fa2bde7a1a6587ca6487f807c31b094037164bb58e3b2bd4c',
        379988,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'aa51030c8eda6555d210cf652976f140b8c4c47e521a2ab4b16e72d2907852cc',
        377412,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Amiri',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Amiri font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amiri
  static TextTheme amiriTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: amiri(textStyle: textTheme.displayLarge),
      displayMedium: amiri(textStyle: textTheme.displayMedium),
      displaySmall: amiri(textStyle: textTheme.displaySmall),
      headlineLarge: amiri(textStyle: textTheme.headlineLarge),
      headlineMedium: amiri(textStyle: textTheme.headlineMedium),
      headlineSmall: amiri(textStyle: textTheme.headlineSmall),
      titleLarge: amiri(textStyle: textTheme.titleLarge),
      titleMedium: amiri(textStyle: textTheme.titleMedium),
      titleSmall: amiri(textStyle: textTheme.titleSmall),
      bodyLarge: amiri(textStyle: textTheme.bodyLarge),
      bodyMedium: amiri(textStyle: textTheme.bodyMedium),
      bodySmall: amiri(textStyle: textTheme.bodySmall),
      labelLarge: amiri(textStyle: textTheme.labelLarge),
      labelMedium: amiri(textStyle: textTheme.labelMedium),
      labelSmall: amiri(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Amiri Quran font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amiri+Quran
  static TextStyle amiriQuran({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6fb463ac2d53b77b67d274bec99e39a4288a2d0a962437c7b1c1f6e9a9ee799f',
        318964,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AmiriQuran',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Amiri Quran font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amiri+Quran
  static TextTheme amiriQuranTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: amiriQuran(textStyle: textTheme.displayLarge),
      displayMedium: amiriQuran(textStyle: textTheme.displayMedium),
      displaySmall: amiriQuran(textStyle: textTheme.displaySmall),
      headlineLarge: amiriQuran(textStyle: textTheme.headlineLarge),
      headlineMedium: amiriQuran(textStyle: textTheme.headlineMedium),
      headlineSmall: amiriQuran(textStyle: textTheme.headlineSmall),
      titleLarge: amiriQuran(textStyle: textTheme.titleLarge),
      titleMedium: amiriQuran(textStyle: textTheme.titleMedium),
      titleSmall: amiriQuran(textStyle: textTheme.titleSmall),
      bodyLarge: amiriQuran(textStyle: textTheme.bodyLarge),
      bodyMedium: amiriQuran(textStyle: textTheme.bodyMedium),
      bodySmall: amiriQuran(textStyle: textTheme.bodySmall),
      labelLarge: amiriQuran(textStyle: textTheme.labelLarge),
      labelMedium: amiriQuran(textStyle: textTheme.labelMedium),
      labelSmall: amiriQuran(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Amita font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amita
  static TextStyle amita({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c64cbfa2902d9e6efa46ef0cdd549aeb41343180d7339eab30b5c11503e66333',
        132428,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'aa8e9f127f206a0c8b60f87a39f6c7bbfbe845b2d37951c3322a1ccda46848a3',
        132364,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Amita',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Amita font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amita
  static TextTheme amitaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: amita(textStyle: textTheme.displayLarge),
      displayMedium: amita(textStyle: textTheme.displayMedium),
      displaySmall: amita(textStyle: textTheme.displaySmall),
      headlineLarge: amita(textStyle: textTheme.headlineLarge),
      headlineMedium: amita(textStyle: textTheme.headlineMedium),
      headlineSmall: amita(textStyle: textTheme.headlineSmall),
      titleLarge: amita(textStyle: textTheme.titleLarge),
      titleMedium: amita(textStyle: textTheme.titleMedium),
      titleSmall: amita(textStyle: textTheme.titleSmall),
      bodyLarge: amita(textStyle: textTheme.bodyLarge),
      bodyMedium: amita(textStyle: textTheme.bodyMedium),
      bodySmall: amita(textStyle: textTheme.bodySmall),
      labelLarge: amita(textStyle: textTheme.labelLarge),
      labelMedium: amita(textStyle: textTheme.labelMedium),
      labelSmall: amita(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Anaheim font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anaheim
  static TextStyle anaheim({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5f20dc30b8de25a3b4110660e82f540abb5e93fcb0a316430d07a0c0fb2a65da',
        25804,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Anaheim',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anaheim font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anaheim
  static TextTheme anaheimTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: anaheim(textStyle: textTheme.displayLarge),
      displayMedium: anaheim(textStyle: textTheme.displayMedium),
      displaySmall: anaheim(textStyle: textTheme.displaySmall),
      headlineLarge: anaheim(textStyle: textTheme.headlineLarge),
      headlineMedium: anaheim(textStyle: textTheme.headlineMedium),
      headlineSmall: anaheim(textStyle: textTheme.headlineSmall),
      titleLarge: anaheim(textStyle: textTheme.titleLarge),
      titleMedium: anaheim(textStyle: textTheme.titleMedium),
      titleSmall: anaheim(textStyle: textTheme.titleSmall),
      bodyLarge: anaheim(textStyle: textTheme.bodyLarge),
      bodyMedium: anaheim(textStyle: textTheme.bodyMedium),
      bodySmall: anaheim(textStyle: textTheme.bodySmall),
      labelLarge: anaheim(textStyle: textTheme.labelLarge),
      labelMedium: anaheim(textStyle: textTheme.labelMedium),
      labelSmall: anaheim(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Andada Pro font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Andada+Pro
  static TextStyle andadaPro({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '127855ac19fff1cbb37e2d194534b819da0c91580acb1d0b097e9874cccc8ce4',
        90996,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7390dd3a9faabd8b338e73aad5231a9ceeaeacd19bbc5b943fc89c473d53acda',
        91100,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6fa9b6ccb871320d6c5ca2a3214a3e9bb8d207aee61300e73915f5403f99f49e',
        91132,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bd367c9f316cee8f97596c80bd1704f398ccd26b90f57008271d376f0ef90ce0',
        91100,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8308cbab6ad9b6fefe16b7e56f09f2e4f6e6e6f880c179fba562856574319e6a',
        91164,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5b1186f658c25ab439a280b26c7300fbeb8aa704d0b69efa1ee89901391af090',
        89860,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5dc0a65e0e3be30dab4617e34091e1fe1eed6fb427d7ebb3b77b19508f8488e3',
        89932,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fb7e19bb8f1e3dc1abd7db3b2daad692560011baa166a5255a348f5079afe37f',
        89940,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e8feedfe10684ac5efdd94c1ec410649cec9354f380974ab519e16a2f7ded70a',
        89872,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ab4152eb78fad2c20011214fc543ad0edee9ec7bd10ee43e8bc6cd01a7405c9d',
        89924,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AndadaPro',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Andada Pro font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Andada+Pro
  static TextTheme andadaProTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: andadaPro(textStyle: textTheme.displayLarge),
      displayMedium: andadaPro(textStyle: textTheme.displayMedium),
      displaySmall: andadaPro(textStyle: textTheme.displaySmall),
      headlineLarge: andadaPro(textStyle: textTheme.headlineLarge),
      headlineMedium: andadaPro(textStyle: textTheme.headlineMedium),
      headlineSmall: andadaPro(textStyle: textTheme.headlineSmall),
      titleLarge: andadaPro(textStyle: textTheme.titleLarge),
      titleMedium: andadaPro(textStyle: textTheme.titleMedium),
      titleSmall: andadaPro(textStyle: textTheme.titleSmall),
      bodyLarge: andadaPro(textStyle: textTheme.bodyLarge),
      bodyMedium: andadaPro(textStyle: textTheme.bodyMedium),
      bodySmall: andadaPro(textStyle: textTheme.bodySmall),
      labelLarge: andadaPro(textStyle: textTheme.labelLarge),
      labelMedium: andadaPro(textStyle: textTheme.labelMedium),
      labelSmall: andadaPro(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Andika font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Andika
  static TextStyle andika({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'aa89f7c86a9ce85528fcbf29f52ea88903bd95e65c16666f0b534d199bf168b7',
        321288,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1b109d4a84cdfe960d2c4c2bb495c59d85286cb6c498bdb4200815c761b1d733',
        344736,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e09bb3be60fd30559102d9b31e60d06c6b2673fea3289de097a0e869423ccadf',
        322828,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c164d7fe2c796a182403e29a49c5599b9b5c7bf72e1330947eb87703a92f96a0',
        345560,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Andika',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Andika font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Andika
  static TextTheme andikaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: andika(textStyle: textTheme.displayLarge),
      displayMedium: andika(textStyle: textTheme.displayMedium),
      displaySmall: andika(textStyle: textTheme.displaySmall),
      headlineLarge: andika(textStyle: textTheme.headlineLarge),
      headlineMedium: andika(textStyle: textTheme.headlineMedium),
      headlineSmall: andika(textStyle: textTheme.headlineSmall),
      titleLarge: andika(textStyle: textTheme.titleLarge),
      titleMedium: andika(textStyle: textTheme.titleMedium),
      titleSmall: andika(textStyle: textTheme.titleSmall),
      bodyLarge: andika(textStyle: textTheme.bodyLarge),
      bodyMedium: andika(textStyle: textTheme.bodyMedium),
      bodySmall: andika(textStyle: textTheme.bodySmall),
      labelLarge: andika(textStyle: textTheme.labelLarge),
      labelMedium: andika(textStyle: textTheme.labelMedium),
      labelSmall: andika(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Anek Bangla font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Bangla
  static TextStyle anekBangla({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f97a0cd0ae21fa8502b00ace3f4d27898df19e99987f2babab6c05f4ddbef5e3',
        240720,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4d82d51076101c889b97acb126b8e0e85f6bfa21b91a7c0270759a07f0dea818',
        241884,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6920caf29911946576054ed4848f006bac52043c6905be3c67600b54b0fae8ee',
        242040,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ded105b4460c18ce51f870c88ea4809b27c568e9f68ab2cf4000e09291d899a8',
        242532,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a99b88ae8aa36ffb05807901ce9c21b7e724953c1da94a82c30204555d716589',
        242280,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '337a29d895e8b54bde1ee4d29b9f57a0ff1c43965b872a60bc5a53d763c35949',
        242728,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c7f8e90f5942178b4775cccc5a4e799d4993b711c1e44e7c9abffad2b7ec14f7',
        244248,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f826fbfbf43617644f0861b88ddf0eb5e1e79733bf277646a4bd52d69ca5a847',
        244804,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnekBangla',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anek Bangla font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Bangla
  static TextTheme anekBanglaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: anekBangla(textStyle: textTheme.displayLarge),
      displayMedium: anekBangla(textStyle: textTheme.displayMedium),
      displaySmall: anekBangla(textStyle: textTheme.displaySmall),
      headlineLarge: anekBangla(textStyle: textTheme.headlineLarge),
      headlineMedium: anekBangla(textStyle: textTheme.headlineMedium),
      headlineSmall: anekBangla(textStyle: textTheme.headlineSmall),
      titleLarge: anekBangla(textStyle: textTheme.titleLarge),
      titleMedium: anekBangla(textStyle: textTheme.titleMedium),
      titleSmall: anekBangla(textStyle: textTheme.titleSmall),
      bodyLarge: anekBangla(textStyle: textTheme.bodyLarge),
      bodyMedium: anekBangla(textStyle: textTheme.bodyMedium),
      bodySmall: anekBangla(textStyle: textTheme.bodySmall),
      labelLarge: anekBangla(textStyle: textTheme.labelLarge),
      labelMedium: anekBangla(textStyle: textTheme.labelMedium),
      labelSmall: anekBangla(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Anek Devanagari font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Devanagari
  static TextStyle anekDevanagari({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0bc0187d28bf231609c939b14cb3cef93bbf138598ca19e1efdc1e55d735627d',
        404280,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '25c8cb78a2ac78dc00ae5705f8fe3586f3f5ac4e87db41592ce12c2ff56c9300',
        404944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8526bd1b827854e945f67104e3bdafff0016165688ed7f62f20491780fc73546',
        405416,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ac8aa77520934aec810245a99b9089ae1aebac242bb918792fd35c6c295c040a',
        406240,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '38b6a223f72a1be64ab0a01b939013f6e57dc6ebe164d9cbfae3648a3ca6b839',
        406116,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a2fad1e50e1a37bf4d122922c9de2098b3a277a825a985dc48a49a1ec30dfb8a',
        406884,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '38d41cd66281e991c712a10002f7bb4fbb281cb4a6d57335a80dc583349fac35',
        410184,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3483a4f99b1d7849e7d5ed14bab14f0096079cdab5ba1d79eef3840db61f7bef',
        411564,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnekDevanagari',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anek Devanagari font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Devanagari
  static TextTheme anekDevanagariTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: anekDevanagari(textStyle: textTheme.displayLarge),
      displayMedium: anekDevanagari(textStyle: textTheme.displayMedium),
      displaySmall: anekDevanagari(textStyle: textTheme.displaySmall),
      headlineLarge: anekDevanagari(textStyle: textTheme.headlineLarge),
      headlineMedium: anekDevanagari(textStyle: textTheme.headlineMedium),
      headlineSmall: anekDevanagari(textStyle: textTheme.headlineSmall),
      titleLarge: anekDevanagari(textStyle: textTheme.titleLarge),
      titleMedium: anekDevanagari(textStyle: textTheme.titleMedium),
      titleSmall: anekDevanagari(textStyle: textTheme.titleSmall),
      bodyLarge: anekDevanagari(textStyle: textTheme.bodyLarge),
      bodyMedium: anekDevanagari(textStyle: textTheme.bodyMedium),
      bodySmall: anekDevanagari(textStyle: textTheme.bodySmall),
      labelLarge: anekDevanagari(textStyle: textTheme.labelLarge),
      labelMedium: anekDevanagari(textStyle: textTheme.labelMedium),
      labelSmall: anekDevanagari(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Anek Gujarati font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Gujarati
  static TextStyle anekGujarati({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4f6b493a0c88e173cf2b29804db486acbfc5e518f09228313ec5ac242c46d65f',
        285304,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8f1d3ebca3427bb401a2fe10647a9c0f027aa3f2cc4ca05b41e72366cd19a67a',
        286428,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '57812ef90d39b948b0f59dbe2c77f749a84eb9362d3a5c052ed143145c563556',
        286340,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b9bbdbf4252e14947dc39df987510addff8e7dbdd9a884cd78b75fac4a9da078',
        286592,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '050f224a79c5a834c852b9c02f1c26a824f9b82d3ea7284a50e15df5a172e16c',
        286384,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '625c2e99d58e6097101111532c70c27dfa75c66bf04eca4d823007c0ca834465',
        288056,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f526e52e6e0b2d41ef85710d763c403de2478dea677d4d76b8955726b1e19b29',
        290028,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0e8354f5e1bd21d5e5c2480b7901a6ac5f35fa15b8cf0eb8cf56c84e6223e68c',
        291780,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnekGujarati',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anek Gujarati font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Gujarati
  static TextTheme anekGujaratiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: anekGujarati(textStyle: textTheme.displayLarge),
      displayMedium: anekGujarati(textStyle: textTheme.displayMedium),
      displaySmall: anekGujarati(textStyle: textTheme.displaySmall),
      headlineLarge: anekGujarati(textStyle: textTheme.headlineLarge),
      headlineMedium: anekGujarati(textStyle: textTheme.headlineMedium),
      headlineSmall: anekGujarati(textStyle: textTheme.headlineSmall),
      titleLarge: anekGujarati(textStyle: textTheme.titleLarge),
      titleMedium: anekGujarati(textStyle: textTheme.titleMedium),
      titleSmall: anekGujarati(textStyle: textTheme.titleSmall),
      bodyLarge: anekGujarati(textStyle: textTheme.bodyLarge),
      bodyMedium: anekGujarati(textStyle: textTheme.bodyMedium),
      bodySmall: anekGujarati(textStyle: textTheme.bodySmall),
      labelLarge: anekGujarati(textStyle: textTheme.labelLarge),
      labelMedium: anekGujarati(textStyle: textTheme.labelMedium),
      labelSmall: anekGujarati(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Anek Gurmukhi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Gurmukhi
  static TextStyle anekGurmukhi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ab85332df30caad4defdaea0b3066888f2afc8c08500716eb6a5bdbe48bf9123',
        83508,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0ca94e0a7b5793e3ee59694adc8b549e45fa0f076c9b27d6686a84f5a1246350',
        83752,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e2d3b18a180793427e9e1fd4f74d7f1c443ddd908c3116cb159dc6fd41d499cf',
        83752,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1c7fa2e13e7d8f8a51f393f18541c6e3340872c5f1a98cc542796d99f8d5d095',
        83848,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8b1b72ac04e67c5f131386939117035ada9294f9b45d38dc7e634bc8f525498f',
        83544,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '56de10b4b21c4fede11ce2f27dde3f7d8b1cac3da677b97420a99754b0f82980',
        83816,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '169508ee548cee83163764b3d2887d30564629b9bf2b3423f5cbe90350a9ef76',
        83960,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '58dd596495be3efda772dcb4d6e0943df2e0084817bd0db5290f51f3d0b8465d',
        84364,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnekGurmukhi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anek Gurmukhi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Gurmukhi
  static TextTheme anekGurmukhiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: anekGurmukhi(textStyle: textTheme.displayLarge),
      displayMedium: anekGurmukhi(textStyle: textTheme.displayMedium),
      displaySmall: anekGurmukhi(textStyle: textTheme.displaySmall),
      headlineLarge: anekGurmukhi(textStyle: textTheme.headlineLarge),
      headlineMedium: anekGurmukhi(textStyle: textTheme.headlineMedium),
      headlineSmall: anekGurmukhi(textStyle: textTheme.headlineSmall),
      titleLarge: anekGurmukhi(textStyle: textTheme.titleLarge),
      titleMedium: anekGurmukhi(textStyle: textTheme.titleMedium),
      titleSmall: anekGurmukhi(textStyle: textTheme.titleSmall),
      bodyLarge: anekGurmukhi(textStyle: textTheme.bodyLarge),
      bodyMedium: anekGurmukhi(textStyle: textTheme.bodyMedium),
      bodySmall: anekGurmukhi(textStyle: textTheme.bodySmall),
      labelLarge: anekGurmukhi(textStyle: textTheme.labelLarge),
      labelMedium: anekGurmukhi(textStyle: textTheme.labelMedium),
      labelSmall: anekGurmukhi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Anek Kannada font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Kannada
  static TextStyle anekKannada({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '904b8c23bd587c8c45cb3d3ee0137307fbca7022cc02fed3f460cd24b7c8aa53',
        240360,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd8b0d06f38dd80d4467b24b40836fbf76922fe78f6a1940c20cbda98a87009e8',
        243160,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f691bd47fa9801c88026aade0bbc4475afddf28d2022818cc2ef91cf30b9a408',
        243280,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c7ca45a8ab105fa61ecb89b1d42c043a2246655d876b6e1d9820db01c19c1535',
        240908,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1cacf9f36a94e013537f377f42d3c71e41094ccbb0c4dcc06533c3c014a18efb',
        240272,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b750f8f859d5cbd87ae11cd573a48dd23e5f921d0808472c9c853beea98ee67b',
        241564,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0fc099c3befba33a7ba7999398a8cbea89ddde83d79be7e5ef78a75edebd4983',
        242816,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0fbf7173885c4529f94bc0170b64d75d3c340119a8c4158c9b8bc3cc4468ef4a',
        243652,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnekKannada',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anek Kannada font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Kannada
  static TextTheme anekKannadaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: anekKannada(textStyle: textTheme.displayLarge),
      displayMedium: anekKannada(textStyle: textTheme.displayMedium),
      displaySmall: anekKannada(textStyle: textTheme.displaySmall),
      headlineLarge: anekKannada(textStyle: textTheme.headlineLarge),
      headlineMedium: anekKannada(textStyle: textTheme.headlineMedium),
      headlineSmall: anekKannada(textStyle: textTheme.headlineSmall),
      titleLarge: anekKannada(textStyle: textTheme.titleLarge),
      titleMedium: anekKannada(textStyle: textTheme.titleMedium),
      titleSmall: anekKannada(textStyle: textTheme.titleSmall),
      bodyLarge: anekKannada(textStyle: textTheme.bodyLarge),
      bodyMedium: anekKannada(textStyle: textTheme.bodyMedium),
      bodySmall: anekKannada(textStyle: textTheme.bodySmall),
      labelLarge: anekKannada(textStyle: textTheme.labelLarge),
      labelMedium: anekKannada(textStyle: textTheme.labelMedium),
      labelSmall: anekKannada(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Anek Latin font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Latin
  static TextStyle anekLatin({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '786fd9336bf036bea0b8905b496b97f04fc73d0cef2c8ad69d1590819ba55915',
        104188,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '88cd257aa2860ff5d53e9887aaa1344cd7817b1fe5fc099d6308455d388481f1',
        104900,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7be2d9ee400d5ebff43945e7106da2eb1103ef54175a052337940ec002151e66',
        105064,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4d0f412228986f3b554062e76ad7ca2c7af946f8872c9e9a3473cddadec7e5bc',
        105044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7f7dcee796f93ddacc87f6fa48ee8d3586b3cf8cd7b45bc08be5f05c8afb2c3f',
        104816,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c9ce2fdfcc6bc1cd17c0f861aeb378c77ad840e656e022812dd4d9a3e5a84c94',
        105204,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8b32692e3166a3c04f4767cfd8f843a69be5b4ff65e0fc86372680ca1c464205',
        105388,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c9e69906e1628f1e7683934256f171aa9b8e9c18971a887d562365bb2f55a036',
        105344,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnekLatin',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anek Latin font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Latin
  static TextTheme anekLatinTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: anekLatin(textStyle: textTheme.displayLarge),
      displayMedium: anekLatin(textStyle: textTheme.displayMedium),
      displaySmall: anekLatin(textStyle: textTheme.displaySmall),
      headlineLarge: anekLatin(textStyle: textTheme.headlineLarge),
      headlineMedium: anekLatin(textStyle: textTheme.headlineMedium),
      headlineSmall: anekLatin(textStyle: textTheme.headlineSmall),
      titleLarge: anekLatin(textStyle: textTheme.titleLarge),
      titleMedium: anekLatin(textStyle: textTheme.titleMedium),
      titleSmall: anekLatin(textStyle: textTheme.titleSmall),
      bodyLarge: anekLatin(textStyle: textTheme.bodyLarge),
      bodyMedium: anekLatin(textStyle: textTheme.bodyMedium),
      bodySmall: anekLatin(textStyle: textTheme.bodySmall),
      labelLarge: anekLatin(textStyle: textTheme.labelLarge),
      labelMedium: anekLatin(textStyle: textTheme.labelMedium),
      labelSmall: anekLatin(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Anek Malayalam font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Malayalam
  static TextStyle anekMalayalam({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c8f751fb0c621883b3e33f8642de428b172a23a0e1ab622c33dce7b449b260ea',
        107536,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5969c950db6387018c0eb70ba1e41a2193e8a2b2d092bd2a8e98cfeec4b39f43',
        107804,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd8d0727872857ab06b7bcc271088f0990338b1552c19be06c71efbd498d09575',
        107844,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ce96415310dc73fbef1d44216f7879d61ae1d2d4a8c780d8c2176102ed301131',
        107796,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3f0117d17bb8715f339af13ec763d7f6bdad462ec3dcda3d2c56b8f777beafa9',
        106992,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0906cf3d1af1ef081887fc287ccb672d7564d35f86879d27607ff3c3502d356e',
        107200,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f6a12cf6fd2532cfff0d1a6eaba3661bcc9604608f9399936df344e44bbb60df',
        109832,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3f4718714e158f83dbb10b1bc3d0be86c90f2dec6298b0cb8e30b61ed36f3468',
        110232,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnekMalayalam',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anek Malayalam font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Malayalam
  static TextTheme anekMalayalamTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: anekMalayalam(textStyle: textTheme.displayLarge),
      displayMedium: anekMalayalam(textStyle: textTheme.displayMedium),
      displaySmall: anekMalayalam(textStyle: textTheme.displaySmall),
      headlineLarge: anekMalayalam(textStyle: textTheme.headlineLarge),
      headlineMedium: anekMalayalam(textStyle: textTheme.headlineMedium),
      headlineSmall: anekMalayalam(textStyle: textTheme.headlineSmall),
      titleLarge: anekMalayalam(textStyle: textTheme.titleLarge),
      titleMedium: anekMalayalam(textStyle: textTheme.titleMedium),
      titleSmall: anekMalayalam(textStyle: textTheme.titleSmall),
      bodyLarge: anekMalayalam(textStyle: textTheme.bodyLarge),
      bodyMedium: anekMalayalam(textStyle: textTheme.bodyMedium),
      bodySmall: anekMalayalam(textStyle: textTheme.bodySmall),
      labelLarge: anekMalayalam(textStyle: textTheme.labelLarge),
      labelMedium: anekMalayalam(textStyle: textTheme.labelMedium),
      labelSmall: anekMalayalam(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Anek Odia font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Odia
  static TextStyle anekOdia({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd93d9d4eb54d67b8eaef680e51cbcf7243bfbe6dd4aa29a0bd1e2b8799d1d052',
        163140,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1b08889e9a62ccc6c38eb85b76e1ab3f1645b22abfcbb3cee74a088a47c32570',
        164252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8ccba9768773c422ffe8119aa33f85a02b09bce1ae7fc86877f12fa84a990cf9',
        164388,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1f19cb70f8bcc7fc64e1d86c60e7bee04e7e6b0e8a15a76fbf1b8a1f576d6712',
        164332,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5962616f70a508f27d29997054b1e8dc6838550ac7230829dd43b8116b5360e6',
        164036,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '756d3eed77c9c65178513dc25ab4aeb8b13880ad59eaf9c1dbd9044f140aedd0',
        164360,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f901dc66a6159f0fa11c9cea5e5f65b6c4771f563047e4ca0beee46e422e1bbe',
        164712,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5b716c49bba4a6e83ad95c38caa665f4ee26dc57e8fdd2ad5c5e8c67bec59c4b',
        164816,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnekOdia',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anek Odia font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Odia
  static TextTheme anekOdiaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: anekOdia(textStyle: textTheme.displayLarge),
      displayMedium: anekOdia(textStyle: textTheme.displayMedium),
      displaySmall: anekOdia(textStyle: textTheme.displaySmall),
      headlineLarge: anekOdia(textStyle: textTheme.headlineLarge),
      headlineMedium: anekOdia(textStyle: textTheme.headlineMedium),
      headlineSmall: anekOdia(textStyle: textTheme.headlineSmall),
      titleLarge: anekOdia(textStyle: textTheme.titleLarge),
      titleMedium: anekOdia(textStyle: textTheme.titleMedium),
      titleSmall: anekOdia(textStyle: textTheme.titleSmall),
      bodyLarge: anekOdia(textStyle: textTheme.bodyLarge),
      bodyMedium: anekOdia(textStyle: textTheme.bodyMedium),
      bodySmall: anekOdia(textStyle: textTheme.bodySmall),
      labelLarge: anekOdia(textStyle: textTheme.labelLarge),
      labelMedium: anekOdia(textStyle: textTheme.labelMedium),
      labelSmall: anekOdia(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Anek Tamil font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Tamil
  static TextStyle anekTamil({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b1db05c794a93ad2f0a6d609fd141cddeb1a61b699c437c462c9c24bce9e6975',
        98556,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '748cce3e358622607b832be1e84551eb67673f64d68603ebcff3e6e90c4a6bf8',
        98940,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2ac5f8a005a4dd50a921950cbca9ce025963b94b5147559628aa25f608b7e46f',
        98912,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0e9985f49352fec194621b96b2f13c97a39d2f7fad1bbf6b1ea739d505d43b76',
        98964,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5716782d18dbbf18b249c4f32ec9a3eb1254f62e437ee00244296597ab132390',
        102776,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '06f65d7d7c37ae8f018a01b058eef39bdffa75a7afd49df24a6da5a34248f608',
        103068,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c194f457a9ea658a4c4362500f2ec874daf76ca0bbcd4281352283a0792848a4',
        104496,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f77befe464d9125e73181a80a0d8cc1ca2457d84cf2bcae25a3fe9c667269751',
        104944,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnekTamil',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anek Tamil font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Tamil
  static TextTheme anekTamilTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: anekTamil(textStyle: textTheme.displayLarge),
      displayMedium: anekTamil(textStyle: textTheme.displayMedium),
      displaySmall: anekTamil(textStyle: textTheme.displaySmall),
      headlineLarge: anekTamil(textStyle: textTheme.headlineLarge),
      headlineMedium: anekTamil(textStyle: textTheme.headlineMedium),
      headlineSmall: anekTamil(textStyle: textTheme.headlineSmall),
      titleLarge: anekTamil(textStyle: textTheme.titleLarge),
      titleMedium: anekTamil(textStyle: textTheme.titleMedium),
      titleSmall: anekTamil(textStyle: textTheme.titleSmall),
      bodyLarge: anekTamil(textStyle: textTheme.bodyLarge),
      bodyMedium: anekTamil(textStyle: textTheme.bodyMedium),
      bodySmall: anekTamil(textStyle: textTheme.bodySmall),
      labelLarge: anekTamil(textStyle: textTheme.labelLarge),
      labelMedium: anekTamil(textStyle: textTheme.labelMedium),
      labelSmall: anekTamil(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Anek Telugu font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Telugu
  static TextStyle anekTelugu({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9330d53ef394715ade39d971437dd73bf66c077513467829c7528bacb9ac89ad',
        306056,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '55d3194231a8afb34cf6cc06c9e1f3a98abfe45516278b9763a4b29f290fe76d',
        308840,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '95532eca141f794d1458fdb3c42192873f135d693a2c0b06e6ad3af7b72d3cf6',
        308472,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '769b3065754f665dbf74fae04f5fe33464b86f45916c93ab4eefbe1429a38a42',
        308572,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '11b1ed2340fa798b214fbe6fe5f57e8b889a2348693c530665b315c8067f47af',
        308172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c0fd55d8180d9b8aed59f506c7a57c7a8ff987d0686ed37d21478bfc8d2a0989',
        308964,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f907ee030ac09a1010d7d31f5884e0dfca0b23b93de0a88a99a6f1cce04ac6e4',
        310200,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '04e24acd960b57e5925583de52079635a55f7371f9803eeb5555df753514b1d9',
        310964,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnekTelugu',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anek Telugu font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anek+Telugu
  static TextTheme anekTeluguTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: anekTelugu(textStyle: textTheme.displayLarge),
      displayMedium: anekTelugu(textStyle: textTheme.displayMedium),
      displaySmall: anekTelugu(textStyle: textTheme.displaySmall),
      headlineLarge: anekTelugu(textStyle: textTheme.headlineLarge),
      headlineMedium: anekTelugu(textStyle: textTheme.headlineMedium),
      headlineSmall: anekTelugu(textStyle: textTheme.headlineSmall),
      titleLarge: anekTelugu(textStyle: textTheme.titleLarge),
      titleMedium: anekTelugu(textStyle: textTheme.titleMedium),
      titleSmall: anekTelugu(textStyle: textTheme.titleSmall),
      bodyLarge: anekTelugu(textStyle: textTheme.bodyLarge),
      bodyMedium: anekTelugu(textStyle: textTheme.bodyMedium),
      bodySmall: anekTelugu(textStyle: textTheme.bodySmall),
      labelLarge: anekTelugu(textStyle: textTheme.labelLarge),
      labelMedium: anekTelugu(textStyle: textTheme.labelMedium),
      labelSmall: anekTelugu(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Angkor font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Angkor
  static TextStyle angkor({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '265909626caeaea30d32cde547a8dbbeffe00b8daa950a7b13c8145b54a97505',
        38724,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Angkor',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Angkor font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Angkor
  static TextTheme angkorTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: angkor(textStyle: textTheme.displayLarge),
      displayMedium: angkor(textStyle: textTheme.displayMedium),
      displaySmall: angkor(textStyle: textTheme.displaySmall),
      headlineLarge: angkor(textStyle: textTheme.headlineLarge),
      headlineMedium: angkor(textStyle: textTheme.headlineMedium),
      headlineSmall: angkor(textStyle: textTheme.headlineSmall),
      titleLarge: angkor(textStyle: textTheme.titleLarge),
      titleMedium: angkor(textStyle: textTheme.titleMedium),
      titleSmall: angkor(textStyle: textTheme.titleSmall),
      bodyLarge: angkor(textStyle: textTheme.bodyLarge),
      bodyMedium: angkor(textStyle: textTheme.bodyMedium),
      bodySmall: angkor(textStyle: textTheme.bodySmall),
      labelLarge: angkor(textStyle: textTheme.labelLarge),
      labelMedium: angkor(textStyle: textTheme.labelMedium),
      labelSmall: angkor(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Annapurna SIL font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Annapurna+SIL
  static TextStyle annapurnaSil({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4b7b182a4539603ff5059767d4264ecb03a04df70150ff560156ecd38e211faf',
        181716,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '10a71f76936d7c4aef493065d97a5e1b249dd8fca08322c3e6581480a9dd0292',
        187932,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnnapurnaSIL',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Annapurna SIL font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Annapurna+SIL
  static TextTheme annapurnaSilTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: annapurnaSil(textStyle: textTheme.displayLarge),
      displayMedium: annapurnaSil(textStyle: textTheme.displayMedium),
      displaySmall: annapurnaSil(textStyle: textTheme.displaySmall),
      headlineLarge: annapurnaSil(textStyle: textTheme.headlineLarge),
      headlineMedium: annapurnaSil(textStyle: textTheme.headlineMedium),
      headlineSmall: annapurnaSil(textStyle: textTheme.headlineSmall),
      titleLarge: annapurnaSil(textStyle: textTheme.titleLarge),
      titleMedium: annapurnaSil(textStyle: textTheme.titleMedium),
      titleSmall: annapurnaSil(textStyle: textTheme.titleSmall),
      bodyLarge: annapurnaSil(textStyle: textTheme.bodyLarge),
      bodyMedium: annapurnaSil(textStyle: textTheme.bodyMedium),
      bodySmall: annapurnaSil(textStyle: textTheme.bodySmall),
      labelLarge: annapurnaSil(textStyle: textTheme.labelLarge),
      labelMedium: annapurnaSil(textStyle: textTheme.labelMedium),
      labelSmall: annapurnaSil(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Annie Use Your Telescope font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Annie+Use+Your+Telescope
  static TextStyle annieUseYourTelescope({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ff1575b5a063d09826bf441c2dc27619c4187c98c907003f3cd80e546a8b6915',
        35952,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnnieUseYourTelescope',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Annie Use Your Telescope font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Annie+Use+Your+Telescope
  static TextTheme annieUseYourTelescopeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: annieUseYourTelescope(textStyle: textTheme.displayLarge),
      displayMedium: annieUseYourTelescope(textStyle: textTheme.displayMedium),
      displaySmall: annieUseYourTelescope(textStyle: textTheme.displaySmall),
      headlineLarge: annieUseYourTelescope(textStyle: textTheme.headlineLarge),
      headlineMedium:
          annieUseYourTelescope(textStyle: textTheme.headlineMedium),
      headlineSmall: annieUseYourTelescope(textStyle: textTheme.headlineSmall),
      titleLarge: annieUseYourTelescope(textStyle: textTheme.titleLarge),
      titleMedium: annieUseYourTelescope(textStyle: textTheme.titleMedium),
      titleSmall: annieUseYourTelescope(textStyle: textTheme.titleSmall),
      bodyLarge: annieUseYourTelescope(textStyle: textTheme.bodyLarge),
      bodyMedium: annieUseYourTelescope(textStyle: textTheme.bodyMedium),
      bodySmall: annieUseYourTelescope(textStyle: textTheme.bodySmall),
      labelLarge: annieUseYourTelescope(textStyle: textTheme.labelLarge),
      labelMedium: annieUseYourTelescope(textStyle: textTheme.labelMedium),
      labelSmall: annieUseYourTelescope(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Anonymous Pro font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anonymous+Pro
  static TextStyle anonymousPro({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '081f36c2edbd80b4a96997bdd985999dab018d0c1735edf36329ab603148258c',
        47292,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e9e045b28fc60e1f94b3a4c75009ba35d377129a7cb650621b08d2dee98429e5',
        49384,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '17ff337f134c8ac8d93bc157bd1d6b8f3f493a09bf3cb84a4c34d1824d7edde7',
        46980,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '47dfbc3cf4b4554c464c3420d6c8e42033d01450296705a5fe207287cc6afd9c',
        49108,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnonymousPro',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anonymous Pro font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anonymous+Pro
  static TextTheme anonymousProTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: anonymousPro(textStyle: textTheme.displayLarge),
      displayMedium: anonymousPro(textStyle: textTheme.displayMedium),
      displaySmall: anonymousPro(textStyle: textTheme.displaySmall),
      headlineLarge: anonymousPro(textStyle: textTheme.headlineLarge),
      headlineMedium: anonymousPro(textStyle: textTheme.headlineMedium),
      headlineSmall: anonymousPro(textStyle: textTheme.headlineSmall),
      titleLarge: anonymousPro(textStyle: textTheme.titleLarge),
      titleMedium: anonymousPro(textStyle: textTheme.titleMedium),
      titleSmall: anonymousPro(textStyle: textTheme.titleSmall),
      bodyLarge: anonymousPro(textStyle: textTheme.bodyLarge),
      bodyMedium: anonymousPro(textStyle: textTheme.bodyMedium),
      bodySmall: anonymousPro(textStyle: textTheme.bodySmall),
      labelLarge: anonymousPro(textStyle: textTheme.labelLarge),
      labelMedium: anonymousPro(textStyle: textTheme.labelMedium),
      labelSmall: anonymousPro(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Anta font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anta
  static TextStyle anta({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3ae97fe71a58efbc643d4f14321f6647139063c17dc68ea5977866642b79765b',
        49080,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Anta',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anta font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anta
  static TextTheme antaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: anta(textStyle: textTheme.displayLarge),
      displayMedium: anta(textStyle: textTheme.displayMedium),
      displaySmall: anta(textStyle: textTheme.displaySmall),
      headlineLarge: anta(textStyle: textTheme.headlineLarge),
      headlineMedium: anta(textStyle: textTheme.headlineMedium),
      headlineSmall: anta(textStyle: textTheme.headlineSmall),
      titleLarge: anta(textStyle: textTheme.titleLarge),
      titleMedium: anta(textStyle: textTheme.titleMedium),
      titleSmall: anta(textStyle: textTheme.titleSmall),
      bodyLarge: anta(textStyle: textTheme.bodyLarge),
      bodyMedium: anta(textStyle: textTheme.bodyMedium),
      bodySmall: anta(textStyle: textTheme.bodySmall),
      labelLarge: anta(textStyle: textTheme.labelLarge),
      labelMedium: anta(textStyle: textTheme.labelMedium),
      labelSmall: anta(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Antic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Antic
  static TextStyle antic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b8397fbf4e6ab293dd34d5a1ae6230e13c401b9d182ca1993c4a1a6aa7410238',
        37584,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Antic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Antic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Antic
  static TextTheme anticTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: antic(textStyle: textTheme.displayLarge),
      displayMedium: antic(textStyle: textTheme.displayMedium),
      displaySmall: antic(textStyle: textTheme.displaySmall),
      headlineLarge: antic(textStyle: textTheme.headlineLarge),
      headlineMedium: antic(textStyle: textTheme.headlineMedium),
      headlineSmall: antic(textStyle: textTheme.headlineSmall),
      titleLarge: antic(textStyle: textTheme.titleLarge),
      titleMedium: antic(textStyle: textTheme.titleMedium),
      titleSmall: antic(textStyle: textTheme.titleSmall),
      bodyLarge: antic(textStyle: textTheme.bodyLarge),
      bodyMedium: antic(textStyle: textTheme.bodyMedium),
      bodySmall: antic(textStyle: textTheme.bodySmall),
      labelLarge: antic(textStyle: textTheme.labelLarge),
      labelMedium: antic(textStyle: textTheme.labelMedium),
      labelSmall: antic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Antic Didone font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Antic+Didone
  static TextStyle anticDidone({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e9d67d68d8e18677c34d73fe7fe4104402ad32dd69b2ffb1cc4018e5c0e791e8',
        34000,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnticDidone',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Antic Didone font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Antic+Didone
  static TextTheme anticDidoneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: anticDidone(textStyle: textTheme.displayLarge),
      displayMedium: anticDidone(textStyle: textTheme.displayMedium),
      displaySmall: anticDidone(textStyle: textTheme.displaySmall),
      headlineLarge: anticDidone(textStyle: textTheme.headlineLarge),
      headlineMedium: anticDidone(textStyle: textTheme.headlineMedium),
      headlineSmall: anticDidone(textStyle: textTheme.headlineSmall),
      titleLarge: anticDidone(textStyle: textTheme.titleLarge),
      titleMedium: anticDidone(textStyle: textTheme.titleMedium),
      titleSmall: anticDidone(textStyle: textTheme.titleSmall),
      bodyLarge: anticDidone(textStyle: textTheme.bodyLarge),
      bodyMedium: anticDidone(textStyle: textTheme.bodyMedium),
      bodySmall: anticDidone(textStyle: textTheme.bodySmall),
      labelLarge: anticDidone(textStyle: textTheme.labelLarge),
      labelMedium: anticDidone(textStyle: textTheme.labelMedium),
      labelSmall: anticDidone(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Antic Slab font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Antic+Slab
  static TextStyle anticSlab({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f5b8fded4efad3094f3b441a77f4ed0d70f0cb36c863a78948f418d5486a1471',
        31252,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnticSlab',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Antic Slab font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Antic+Slab
  static TextTheme anticSlabTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: anticSlab(textStyle: textTheme.displayLarge),
      displayMedium: anticSlab(textStyle: textTheme.displayMedium),
      displaySmall: anticSlab(textStyle: textTheme.displaySmall),
      headlineLarge: anticSlab(textStyle: textTheme.headlineLarge),
      headlineMedium: anticSlab(textStyle: textTheme.headlineMedium),
      headlineSmall: anticSlab(textStyle: textTheme.headlineSmall),
      titleLarge: anticSlab(textStyle: textTheme.titleLarge),
      titleMedium: anticSlab(textStyle: textTheme.titleMedium),
      titleSmall: anticSlab(textStyle: textTheme.titleSmall),
      bodyLarge: anticSlab(textStyle: textTheme.bodyLarge),
      bodyMedium: anticSlab(textStyle: textTheme.bodyMedium),
      bodySmall: anticSlab(textStyle: textTheme.bodySmall),
      labelLarge: anticSlab(textStyle: textTheme.labelLarge),
      labelMedium: anticSlab(textStyle: textTheme.labelMedium),
      labelSmall: anticSlab(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Anton font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anton
  static TextStyle anton({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c5d7acc3d35a9c00ee68ea6c797feecd74e283fdb750ed618e36621c2f506dcb',
        87420,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Anton',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anton font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anton
  static TextTheme antonTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: anton(textStyle: textTheme.displayLarge),
      displayMedium: anton(textStyle: textTheme.displayMedium),
      displaySmall: anton(textStyle: textTheme.displaySmall),
      headlineLarge: anton(textStyle: textTheme.headlineLarge),
      headlineMedium: anton(textStyle: textTheme.headlineMedium),
      headlineSmall: anton(textStyle: textTheme.headlineSmall),
      titleLarge: anton(textStyle: textTheme.titleLarge),
      titleMedium: anton(textStyle: textTheme.titleMedium),
      titleSmall: anton(textStyle: textTheme.titleSmall),
      bodyLarge: anton(textStyle: textTheme.bodyLarge),
      bodyMedium: anton(textStyle: textTheme.bodyMedium),
      bodySmall: anton(textStyle: textTheme.bodySmall),
      labelLarge: anton(textStyle: textTheme.labelLarge),
      labelMedium: anton(textStyle: textTheme.labelMedium),
      labelSmall: anton(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Antonio font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Antonio
  static TextStyle antonio({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9543dfa9322d8739ca8db99a828a1c37d10ad5d2937f868670a955d925f4e6a6',
        36664,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e55c7f2ed74b7c42df03f90e377a253c01d6884834e03c435e0c3045ba28d376',
        36744,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dfd2861fbc21c4ac22010754a12b4aa8cee1f4dd76ff78c1cc38b0e28589e4a8',
        36756,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7c8e7e8999b27d9b13fc07bc812df95c2050d4cc850489cb9bdb2c8fd8aa0345',
        36672,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0ca0f550ce547cd7801b42b48c07340f96c2ad6f69228c904e9d517f6f514948',
        36748,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bc1ed518b7d3d53117c61116c3bc3fc37fbbf54d4d96f7bac95b6b08482ff868',
        36732,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9bea1c566ac5e92ba1e01dcbdd8112186e3fe475f348ac09bf8a1a8aa3cddeef',
        36772,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Antonio',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Antonio font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Antonio
  static TextTheme antonioTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: antonio(textStyle: textTheme.displayLarge),
      displayMedium: antonio(textStyle: textTheme.displayMedium),
      displaySmall: antonio(textStyle: textTheme.displaySmall),
      headlineLarge: antonio(textStyle: textTheme.headlineLarge),
      headlineMedium: antonio(textStyle: textTheme.headlineMedium),
      headlineSmall: antonio(textStyle: textTheme.headlineSmall),
      titleLarge: antonio(textStyle: textTheme.titleLarge),
      titleMedium: antonio(textStyle: textTheme.titleMedium),
      titleSmall: antonio(textStyle: textTheme.titleSmall),
      bodyLarge: antonio(textStyle: textTheme.bodyLarge),
      bodyMedium: antonio(textStyle: textTheme.bodyMedium),
      bodySmall: antonio(textStyle: textTheme.bodySmall),
      labelLarge: antonio(textStyle: textTheme.labelLarge),
      labelMedium: antonio(textStyle: textTheme.labelMedium),
      labelSmall: antonio(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Anuphan font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anuphan
  static TextStyle anuphan({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cd47f3b4668fa2ea83632a23330bf1abe85e4f74c4d42c4d7c79cb2fbd997de1',
        109888,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e75f1a3971189df6a1041fe01757b64815b957fb0ae7c7ef4e48706114a3124c',
        110200,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1b4abcd364cc96ea7868a90e0124dc2e873df033d3cd060b017bdad11cdac90b',
        110068,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'efeadd4e490310829527b631ef62b4f2a28d87d28075bfad98fbbf3c97cc0014',
        109576,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1082c078ad8592a5223ee52cab08994f97d09ff9960bb04a4f493dee44c27331',
        110160,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '366781bfcc9ba31fb2f5f2f79559316b0b845895a56a83a6b4f6ef6c859c25cd',
        110080,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8baedffc23caa1c33e7238245329e499b00edc34ec08de9820f3e4566a89acee',
        109880,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Anuphan',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anuphan font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anuphan
  static TextTheme anuphanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: anuphan(textStyle: textTheme.displayLarge),
      displayMedium: anuphan(textStyle: textTheme.displayMedium),
      displaySmall: anuphan(textStyle: textTheme.displaySmall),
      headlineLarge: anuphan(textStyle: textTheme.headlineLarge),
      headlineMedium: anuphan(textStyle: textTheme.headlineMedium),
      headlineSmall: anuphan(textStyle: textTheme.headlineSmall),
      titleLarge: anuphan(textStyle: textTheme.titleLarge),
      titleMedium: anuphan(textStyle: textTheme.titleMedium),
      titleSmall: anuphan(textStyle: textTheme.titleSmall),
      bodyLarge: anuphan(textStyle: textTheme.bodyLarge),
      bodyMedium: anuphan(textStyle: textTheme.bodyMedium),
      bodySmall: anuphan(textStyle: textTheme.bodySmall),
      labelLarge: anuphan(textStyle: textTheme.labelLarge),
      labelMedium: anuphan(textStyle: textTheme.labelMedium),
      labelSmall: anuphan(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Anybody font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anybody
  static TextStyle anybody({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ac29a5ad92a93b0a58ad70b34d8c224b6b2833f7d8d05c9d57e76ba021ed8654',
        59196,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9acb8ae69ecce97e1d7afaeb97ec696c11a4870510fb81a9951c3b83a091dfc2',
        59396,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '59e4e28ccdf8ca37c04250f88a96be8d753ab1ea22e15f55087529ee0868f121',
        59452,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e014c0cdb2a235b483a000eddc98c167e9879f147f87414d53114bd3c533429f',
        59548,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a98ca25bb0aa62dbcc53cdc48af3c1d183c6603fa4302cb8736fb2ec260f1c36',
        59608,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9d995e39b94de13679107b248e553d0a75eee118aa7c0805a4f81f4a30d2dbab',
        59840,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '06ebee36a6b0e741ef8783515f7d36af25f0a6ebac78abcf3a9338968d21a227',
        59860,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '23dca5346d63c81b910d82e539d8688d46299867a59c2094a97f960f541dc971',
        60220,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1031eb36e95198059f991780c55ca1bb92d7d566eafb9b6a7c043950af241b18',
        60276,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c3f5a6f11c5368ffb5a83f013e01ec8e6520f9b098f1edcd9c924275eefd7890',
        60544,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '27ed66c91163b409d5baafe1ced9d6e2e3252ff254346363232a23a65acad459',
        60800,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f83218c7e5ee78646866c3f5edaf87b4216f4a785f115e09b6b2adb780f65a30',
        60812,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '75fa18ec60ce0be603a3363532f40f299298c35f198a2ec0b8d48e6b97aba096',
        60808,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '20a9989184a1deb8f96388cff42a363596601345ce1903606ac2fb8c9e048626',
        60868,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '315d0f909041d8a8a1ad67159ca78e72306256ae6122e8938947766acefc4329',
        61180,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f1c7aae7b73d263efead2701ca513d9bcdb4e50a3380aaf3596bc333f94d9033',
        61140,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f83f585f47288d1f75da135d9fc28b7248f21057ce416bc9a81cf87e98ba1031',
        61516,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '21c625200859cc21156ff16c41a4ad203d6b46fc6173b7a1099fadc6ed345497',
        61476,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Anybody',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anybody font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anybody
  static TextTheme anybodyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: anybody(textStyle: textTheme.displayLarge),
      displayMedium: anybody(textStyle: textTheme.displayMedium),
      displaySmall: anybody(textStyle: textTheme.displaySmall),
      headlineLarge: anybody(textStyle: textTheme.headlineLarge),
      headlineMedium: anybody(textStyle: textTheme.headlineMedium),
      headlineSmall: anybody(textStyle: textTheme.headlineSmall),
      titleLarge: anybody(textStyle: textTheme.titleLarge),
      titleMedium: anybody(textStyle: textTheme.titleMedium),
      titleSmall: anybody(textStyle: textTheme.titleSmall),
      bodyLarge: anybody(textStyle: textTheme.bodyLarge),
      bodyMedium: anybody(textStyle: textTheme.bodyMedium),
      bodySmall: anybody(textStyle: textTheme.bodySmall),
      labelLarge: anybody(textStyle: textTheme.labelLarge),
      labelMedium: anybody(textStyle: textTheme.labelMedium),
      labelSmall: anybody(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Aoboshi One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aoboshi+One
  static TextStyle aoboshiOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c2034cba1eb814acce447cc3f7bbf7621890501d1a7c45b637379130622f1d76',
        71032,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AoboshiOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Aoboshi One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aoboshi+One
  static TextTheme aoboshiOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: aoboshiOne(textStyle: textTheme.displayLarge),
      displayMedium: aoboshiOne(textStyle: textTheme.displayMedium),
      displaySmall: aoboshiOne(textStyle: textTheme.displaySmall),
      headlineLarge: aoboshiOne(textStyle: textTheme.headlineLarge),
      headlineMedium: aoboshiOne(textStyle: textTheme.headlineMedium),
      headlineSmall: aoboshiOne(textStyle: textTheme.headlineSmall),
      titleLarge: aoboshiOne(textStyle: textTheme.titleLarge),
      titleMedium: aoboshiOne(textStyle: textTheme.titleMedium),
      titleSmall: aoboshiOne(textStyle: textTheme.titleSmall),
      bodyLarge: aoboshiOne(textStyle: textTheme.bodyLarge),
      bodyMedium: aoboshiOne(textStyle: textTheme.bodyMedium),
      bodySmall: aoboshiOne(textStyle: textTheme.bodySmall),
      labelLarge: aoboshiOne(textStyle: textTheme.labelLarge),
      labelMedium: aoboshiOne(textStyle: textTheme.labelMedium),
      labelSmall: aoboshiOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Arapey font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arapey
  static TextStyle arapey({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8dcb113d8c3f16a124e56ea34d4486f28192f9eea9a0e9b86d784a332dc1dde7',
        24096,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3bf34afbf43de8a92261f42fcf6d19a0eeef2e1fae33ec84fe054c5465fd802b',
        26812,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Arapey',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arapey font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arapey
  static TextTheme arapeyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: arapey(textStyle: textTheme.displayLarge),
      displayMedium: arapey(textStyle: textTheme.displayMedium),
      displaySmall: arapey(textStyle: textTheme.displaySmall),
      headlineLarge: arapey(textStyle: textTheme.headlineLarge),
      headlineMedium: arapey(textStyle: textTheme.headlineMedium),
      headlineSmall: arapey(textStyle: textTheme.headlineSmall),
      titleLarge: arapey(textStyle: textTheme.titleLarge),
      titleMedium: arapey(textStyle: textTheme.titleMedium),
      titleSmall: arapey(textStyle: textTheme.titleSmall),
      bodyLarge: arapey(textStyle: textTheme.bodyLarge),
      bodyMedium: arapey(textStyle: textTheme.bodyMedium),
      bodySmall: arapey(textStyle: textTheme.bodySmall),
      labelLarge: arapey(textStyle: textTheme.labelLarge),
      labelMedium: arapey(textStyle: textTheme.labelMedium),
      labelSmall: arapey(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Arbutus font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arbutus
  static TextStyle arbutus({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cc275606ada840841239505e30e12169121ecc461d2e23a845818611870cb559',
        78872,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Arbutus',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arbutus font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arbutus
  static TextTheme arbutusTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: arbutus(textStyle: textTheme.displayLarge),
      displayMedium: arbutus(textStyle: textTheme.displayMedium),
      displaySmall: arbutus(textStyle: textTheme.displaySmall),
      headlineLarge: arbutus(textStyle: textTheme.headlineLarge),
      headlineMedium: arbutus(textStyle: textTheme.headlineMedium),
      headlineSmall: arbutus(textStyle: textTheme.headlineSmall),
      titleLarge: arbutus(textStyle: textTheme.titleLarge),
      titleMedium: arbutus(textStyle: textTheme.titleMedium),
      titleSmall: arbutus(textStyle: textTheme.titleSmall),
      bodyLarge: arbutus(textStyle: textTheme.bodyLarge),
      bodyMedium: arbutus(textStyle: textTheme.bodyMedium),
      bodySmall: arbutus(textStyle: textTheme.bodySmall),
      labelLarge: arbutus(textStyle: textTheme.labelLarge),
      labelMedium: arbutus(textStyle: textTheme.labelMedium),
      labelSmall: arbutus(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Arbutus Slab font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arbutus+Slab
  static TextStyle arbutusSlab({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '04431538aed147aa226942f7676d1d7c0ec00b5de643a138cdf981e387f8296c',
        36956,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ArbutusSlab',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arbutus Slab font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arbutus+Slab
  static TextTheme arbutusSlabTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: arbutusSlab(textStyle: textTheme.displayLarge),
      displayMedium: arbutusSlab(textStyle: textTheme.displayMedium),
      displaySmall: arbutusSlab(textStyle: textTheme.displaySmall),
      headlineLarge: arbutusSlab(textStyle: textTheme.headlineLarge),
      headlineMedium: arbutusSlab(textStyle: textTheme.headlineMedium),
      headlineSmall: arbutusSlab(textStyle: textTheme.headlineSmall),
      titleLarge: arbutusSlab(textStyle: textTheme.titleLarge),
      titleMedium: arbutusSlab(textStyle: textTheme.titleMedium),
      titleSmall: arbutusSlab(textStyle: textTheme.titleSmall),
      bodyLarge: arbutusSlab(textStyle: textTheme.bodyLarge),
      bodyMedium: arbutusSlab(textStyle: textTheme.bodyMedium),
      bodySmall: arbutusSlab(textStyle: textTheme.bodySmall),
      labelLarge: arbutusSlab(textStyle: textTheme.labelLarge),
      labelMedium: arbutusSlab(textStyle: textTheme.labelMedium),
      labelSmall: arbutusSlab(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Architects Daughter font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Architects+Daughter
  static TextStyle architectsDaughter({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '87659fc9ea9955f9b1fd8cf5cd2f5282c8ed2783cd6e720f958dd37a6a920fc4',
        28660,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ArchitectsDaughter',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Architects Daughter font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Architects+Daughter
  static TextTheme architectsDaughterTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: architectsDaughter(textStyle: textTheme.displayLarge),
      displayMedium: architectsDaughter(textStyle: textTheme.displayMedium),
      displaySmall: architectsDaughter(textStyle: textTheme.displaySmall),
      headlineLarge: architectsDaughter(textStyle: textTheme.headlineLarge),
      headlineMedium: architectsDaughter(textStyle: textTheme.headlineMedium),
      headlineSmall: architectsDaughter(textStyle: textTheme.headlineSmall),
      titleLarge: architectsDaughter(textStyle: textTheme.titleLarge),
      titleMedium: architectsDaughter(textStyle: textTheme.titleMedium),
      titleSmall: architectsDaughter(textStyle: textTheme.titleSmall),
      bodyLarge: architectsDaughter(textStyle: textTheme.bodyLarge),
      bodyMedium: architectsDaughter(textStyle: textTheme.bodyMedium),
      bodySmall: architectsDaughter(textStyle: textTheme.bodySmall),
      labelLarge: architectsDaughter(textStyle: textTheme.labelLarge),
      labelMedium: architectsDaughter(textStyle: textTheme.labelMedium),
      labelSmall: architectsDaughter(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Archivo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Archivo
  static TextStyle archivo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c4e423cc75be416bdc0d91b001f52ed47bd6d86690942e53bc5989ff5617c233',
        110576,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c9a334303ae67ac6cf3876415eeac2413965ff26f7cdb67e5c69b1c40e60eeee',
        110672,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e9947862b7c8d6ab16a5804dd121764230bec12f7a4c7b41a38a488298a9bd74',
        110672,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '684bc629814f1b68b989ae1f93d52c6fb7b18ff8dcf75a438a9318923225314c',
        110684,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '28bd000d078762e02db018fdae6af450c799de492b205175006d4dea9ef28278',
        112112,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0e9ab637da5681b824860f9312b3f57c9d7bef39c77afffddd6b2266ce6d4ae0',
        111848,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9b8f60ab74ff80f5cec94e81333187af5959312d2cb4e500d52299c5dc042ee7',
        111924,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '74a0070a6246dc4c9062124ce0999176b44248e076b14c072d16a3dee2a5faeb',
        111924,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '50b37f1512ea5babb4b270604666b2f9f0480a550449493764feba96feace7df',
        111280,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '44941897381f742b617e7bb80a3df1de7fa0be10f6ea253cf80ddb5a3910e14b',
        122024,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd3d23eeeda72fdfc908589f2a8bf224028e2d2c85d5af82382e1a9a8f86025d5',
        122124,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f6086f2d7556fb2e391f737543987d97edc9268ad574843d73ee1815493773db',
        122008,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b01540f19107f908dfa689a6aa282b10dc95c98654750ce8c5374d191f0331ce',
        121868,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '74f0f155b23523d8ebba2bc4ae6be4d12e90ff7bb2f08bfc276c1d009de95ca2',
        123480,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b3d35ed05286a25c56a9cc5fadb3dff9645d111ff37becd3a94fc7b3f754981c',
        123344,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'bc3d2ad522133c6c8441cd4868bcf580fcee94f5626c181e58e5aab6717d1b85',
        123320,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '64b8260d04a3fb6bbd1c3d0fa8a854a5bc3c4f7a20b466bb3fcb348571141c18',
        123608,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '275a17d4206098e983c796b718947ca1d5256b50bfd588a806eaa456203f5911',
        123292,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Archivo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Archivo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Archivo
  static TextTheme archivoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: archivo(textStyle: textTheme.displayLarge),
      displayMedium: archivo(textStyle: textTheme.displayMedium),
      displaySmall: archivo(textStyle: textTheme.displaySmall),
      headlineLarge: archivo(textStyle: textTheme.headlineLarge),
      headlineMedium: archivo(textStyle: textTheme.headlineMedium),
      headlineSmall: archivo(textStyle: textTheme.headlineSmall),
      titleLarge: archivo(textStyle: textTheme.titleLarge),
      titleMedium: archivo(textStyle: textTheme.titleMedium),
      titleSmall: archivo(textStyle: textTheme.titleSmall),
      bodyLarge: archivo(textStyle: textTheme.bodyLarge),
      bodyMedium: archivo(textStyle: textTheme.bodyMedium),
      bodySmall: archivo(textStyle: textTheme.bodySmall),
      labelLarge: archivo(textStyle: textTheme.labelLarge),
      labelMedium: archivo(textStyle: textTheme.labelMedium),
      labelSmall: archivo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Archivo Black font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Archivo+Black
  static TextStyle archivoBlack({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '34faa332783c7fd86f7134ff30d724f33c4fe7221f9ecb7d39f0fef2aa078229',
        44844,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ArchivoBlack',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Archivo Black font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Archivo+Black
  static TextTheme archivoBlackTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: archivoBlack(textStyle: textTheme.displayLarge),
      displayMedium: archivoBlack(textStyle: textTheme.displayMedium),
      displaySmall: archivoBlack(textStyle: textTheme.displaySmall),
      headlineLarge: archivoBlack(textStyle: textTheme.headlineLarge),
      headlineMedium: archivoBlack(textStyle: textTheme.headlineMedium),
      headlineSmall: archivoBlack(textStyle: textTheme.headlineSmall),
      titleLarge: archivoBlack(textStyle: textTheme.titleLarge),
      titleMedium: archivoBlack(textStyle: textTheme.titleMedium),
      titleSmall: archivoBlack(textStyle: textTheme.titleSmall),
      bodyLarge: archivoBlack(textStyle: textTheme.bodyLarge),
      bodyMedium: archivoBlack(textStyle: textTheme.bodyMedium),
      bodySmall: archivoBlack(textStyle: textTheme.bodySmall),
      labelLarge: archivoBlack(textStyle: textTheme.labelLarge),
      labelMedium: archivoBlack(textStyle: textTheme.labelMedium),
      labelSmall: archivoBlack(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Archivo Narrow font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Archivo+Narrow
  static TextStyle archivoNarrow({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '87579d5f7c8e291f72865575e99bafd42ddf2a976033ac75b61f13b93bd19d71',
        58336,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '170894a98b4ff5152409dcda4ac23e89be885964ce12e174d2aab15a412270d3',
        58732,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '36eaf8f0a1bc9df263eb6647c32435e43559b90b778f41661fe0694f650b64fe',
        58752,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2a372c78164626347bf5e9b7901b1f6ff5de669e3526460d13a21be209df752f',
        58316,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b2f53270fa26eb7b7317c2a6e46660fab24f02bf48a56be47cad9280003ed0a9',
        60812,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '632f244776126b5f558e797d5537f0de20cb5c47106aec136f039abed8e9a8de',
        61104,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '708113ac8f976d691607f563eee91f0f7873cc97bb9d0b8f7e6224446565871c',
        61108,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1e0b86c3e6c8db797a7ec86c89a950b587c763f650389cf18b233005721a498d',
        60708,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ArchivoNarrow',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Archivo Narrow font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Archivo+Narrow
  static TextTheme archivoNarrowTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: archivoNarrow(textStyle: textTheme.displayLarge),
      displayMedium: archivoNarrow(textStyle: textTheme.displayMedium),
      displaySmall: archivoNarrow(textStyle: textTheme.displaySmall),
      headlineLarge: archivoNarrow(textStyle: textTheme.headlineLarge),
      headlineMedium: archivoNarrow(textStyle: textTheme.headlineMedium),
      headlineSmall: archivoNarrow(textStyle: textTheme.headlineSmall),
      titleLarge: archivoNarrow(textStyle: textTheme.titleLarge),
      titleMedium: archivoNarrow(textStyle: textTheme.titleMedium),
      titleSmall: archivoNarrow(textStyle: textTheme.titleSmall),
      bodyLarge: archivoNarrow(textStyle: textTheme.bodyLarge),
      bodyMedium: archivoNarrow(textStyle: textTheme.bodyMedium),
      bodySmall: archivoNarrow(textStyle: textTheme.bodySmall),
      labelLarge: archivoNarrow(textStyle: textTheme.labelLarge),
      labelMedium: archivoNarrow(textStyle: textTheme.labelMedium),
      labelSmall: archivoNarrow(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Are You Serious font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Are+You+Serious
  static TextStyle areYouSerious({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6b99249b48dcbbd6e71212db613f05b8ddcca2401774e640be391114eefca26e',
        149320,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AreYouSerious',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Are You Serious font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Are+You+Serious
  static TextTheme areYouSeriousTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: areYouSerious(textStyle: textTheme.displayLarge),
      displayMedium: areYouSerious(textStyle: textTheme.displayMedium),
      displaySmall: areYouSerious(textStyle: textTheme.displaySmall),
      headlineLarge: areYouSerious(textStyle: textTheme.headlineLarge),
      headlineMedium: areYouSerious(textStyle: textTheme.headlineMedium),
      headlineSmall: areYouSerious(textStyle: textTheme.headlineSmall),
      titleLarge: areYouSerious(textStyle: textTheme.titleLarge),
      titleMedium: areYouSerious(textStyle: textTheme.titleMedium),
      titleSmall: areYouSerious(textStyle: textTheme.titleSmall),
      bodyLarge: areYouSerious(textStyle: textTheme.bodyLarge),
      bodyMedium: areYouSerious(textStyle: textTheme.bodyMedium),
      bodySmall: areYouSerious(textStyle: textTheme.bodySmall),
      labelLarge: areYouSerious(textStyle: textTheme.labelLarge),
      labelMedium: areYouSerious(textStyle: textTheme.labelMedium),
      labelSmall: areYouSerious(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Aref Ruqaa font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aref+Ruqaa
  static TextStyle arefRuqaa({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ee5d099cdd37221896c5168f36a91e7ed66cba3ff30da3ba74aaddfddfd53a0e',
        108040,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b6e533cd4e2e04a879aa03f33ae815af69fad4518eb47833d64fbdc163d033a6',
        121028,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ArefRuqaa',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Aref Ruqaa font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aref+Ruqaa
  static TextTheme arefRuqaaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: arefRuqaa(textStyle: textTheme.displayLarge),
      displayMedium: arefRuqaa(textStyle: textTheme.displayMedium),
      displaySmall: arefRuqaa(textStyle: textTheme.displaySmall),
      headlineLarge: arefRuqaa(textStyle: textTheme.headlineLarge),
      headlineMedium: arefRuqaa(textStyle: textTheme.headlineMedium),
      headlineSmall: arefRuqaa(textStyle: textTheme.headlineSmall),
      titleLarge: arefRuqaa(textStyle: textTheme.titleLarge),
      titleMedium: arefRuqaa(textStyle: textTheme.titleMedium),
      titleSmall: arefRuqaa(textStyle: textTheme.titleSmall),
      bodyLarge: arefRuqaa(textStyle: textTheme.bodyLarge),
      bodyMedium: arefRuqaa(textStyle: textTheme.bodyMedium),
      bodySmall: arefRuqaa(textStyle: textTheme.bodySmall),
      labelLarge: arefRuqaa(textStyle: textTheme.labelLarge),
      labelMedium: arefRuqaa(textStyle: textTheme.labelMedium),
      labelSmall: arefRuqaa(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Aref Ruqaa Ink font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aref+Ruqaa+Ink
  static TextStyle arefRuqaaInk({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '74782bc46ebe6fac61765ba995db1b7ec540db397cdbcac821afa40e7de1a9ee',
        565188,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fec5801ddb6763908db553e7b57cb8bca86bd11f1ee4ce28042eb5398be5abaf',
        628000,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ArefRuqaaInk',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Aref Ruqaa Ink font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aref+Ruqaa+Ink
  static TextTheme arefRuqaaInkTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: arefRuqaaInk(textStyle: textTheme.displayLarge),
      displayMedium: arefRuqaaInk(textStyle: textTheme.displayMedium),
      displaySmall: arefRuqaaInk(textStyle: textTheme.displaySmall),
      headlineLarge: arefRuqaaInk(textStyle: textTheme.headlineLarge),
      headlineMedium: arefRuqaaInk(textStyle: textTheme.headlineMedium),
      headlineSmall: arefRuqaaInk(textStyle: textTheme.headlineSmall),
      titleLarge: arefRuqaaInk(textStyle: textTheme.titleLarge),
      titleMedium: arefRuqaaInk(textStyle: textTheme.titleMedium),
      titleSmall: arefRuqaaInk(textStyle: textTheme.titleSmall),
      bodyLarge: arefRuqaaInk(textStyle: textTheme.bodyLarge),
      bodyMedium: arefRuqaaInk(textStyle: textTheme.bodyMedium),
      bodySmall: arefRuqaaInk(textStyle: textTheme.bodySmall),
      labelLarge: arefRuqaaInk(textStyle: textTheme.labelLarge),
      labelMedium: arefRuqaaInk(textStyle: textTheme.labelMedium),
      labelSmall: arefRuqaaInk(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Arima font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arima
  static TextStyle arima({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3f53624e0a3b1ac13805174ee559ba3412c4871de8265b89c7068b90fe788ab5',
        191192,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '88c42f9d784e4b8eca201dc55885f4084b0eba223131443724a308ae72cc5c16',
        191812,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5dbbf2f1c6ccea41e27a782d0eeb61c3b5014ac023fc80684ddf78bca9fc946c',
        192192,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8480f252378e4b5baa8d892747be8df704ae4b258ab1b425c01b337dd8730703',
        192164,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4929f43046fe323074cdad119f09ef05dab0ad09d54aeb3754bf2579e039f213',
        192568,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a29b89383081bceee9e1af386b022fcc9a25b40b577e6afd28c774048b0b8420',
        192412,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '64dc4250fa5875a42506e7ccb750eb55537d31dc24ae3528789d7df8e8170f65',
        192356,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Arima',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arima font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arima
  static TextTheme arimaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: arima(textStyle: textTheme.displayLarge),
      displayMedium: arima(textStyle: textTheme.displayMedium),
      displaySmall: arima(textStyle: textTheme.displaySmall),
      headlineLarge: arima(textStyle: textTheme.headlineLarge),
      headlineMedium: arima(textStyle: textTheme.headlineMedium),
      headlineSmall: arima(textStyle: textTheme.headlineSmall),
      titleLarge: arima(textStyle: textTheme.titleLarge),
      titleMedium: arima(textStyle: textTheme.titleMedium),
      titleSmall: arima(textStyle: textTheme.titleSmall),
      bodyLarge: arima(textStyle: textTheme.bodyLarge),
      bodyMedium: arima(textStyle: textTheme.bodyMedium),
      bodySmall: arima(textStyle: textTheme.bodySmall),
      labelLarge: arima(textStyle: textTheme.labelLarge),
      labelMedium: arima(textStyle: textTheme.labelMedium),
      labelSmall: arima(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Arimo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arimo
  static TextStyle arimo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dbc3f5256cfcb1aa62736daaab3bea7dc85c7c68028cd408671a796537da3a0e',
        315684,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a853459fe429fbc56342801939f6abd1bd18700830e2f34895d3ea74cf90ed56',
        318660,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4c91b9aff501566727a4386c973afa730f2ca6af63776681e73bbefb062c86ab',
        319656,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ae8ae33dbafc8b8759404c8f812d36fe44067f5c6b90b38495a2be5daa57c5da',
        316204,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '963985e80cf691a33ca6b4879232d4b34d3f8f631f0c6353d60a1595a519a6bf',
        337860,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '393deb90793814a70d0bdcbbf8e1c16c3f86fa348de25b6f915b12f86a284e75',
        342400,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '15fd3e30d1fcc180ad52f205cb4d1e56a2ee66633ffb716a034a2d522cd6be3b',
        342948,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4232c2585c5833abe3d7e3adb1dc11dd367cdeefd26135499eb04c5d2c697096',
        339292,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Arimo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arimo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arimo
  static TextTheme arimoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: arimo(textStyle: textTheme.displayLarge),
      displayMedium: arimo(textStyle: textTheme.displayMedium),
      displaySmall: arimo(textStyle: textTheme.displaySmall),
      headlineLarge: arimo(textStyle: textTheme.headlineLarge),
      headlineMedium: arimo(textStyle: textTheme.headlineMedium),
      headlineSmall: arimo(textStyle: textTheme.headlineSmall),
      titleLarge: arimo(textStyle: textTheme.titleLarge),
      titleMedium: arimo(textStyle: textTheme.titleMedium),
      titleSmall: arimo(textStyle: textTheme.titleSmall),
      bodyLarge: arimo(textStyle: textTheme.bodyLarge),
      bodyMedium: arimo(textStyle: textTheme.bodyMedium),
      bodySmall: arimo(textStyle: textTheme.bodySmall),
      labelLarge: arimo(textStyle: textTheme.labelLarge),
      labelMedium: arimo(textStyle: textTheme.labelMedium),
      labelSmall: arimo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Arizonia font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arizonia
  static TextStyle arizonia({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7aa8e5281e45c32f01512a4832037a62ad85020cce660a1eca1784a72e483b66',
        88192,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Arizonia',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arizonia font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arizonia
  static TextTheme arizoniaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: arizonia(textStyle: textTheme.displayLarge),
      displayMedium: arizonia(textStyle: textTheme.displayMedium),
      displaySmall: arizonia(textStyle: textTheme.displaySmall),
      headlineLarge: arizonia(textStyle: textTheme.headlineLarge),
      headlineMedium: arizonia(textStyle: textTheme.headlineMedium),
      headlineSmall: arizonia(textStyle: textTheme.headlineSmall),
      titleLarge: arizonia(textStyle: textTheme.titleLarge),
      titleMedium: arizonia(textStyle: textTheme.titleMedium),
      titleSmall: arizonia(textStyle: textTheme.titleSmall),
      bodyLarge: arizonia(textStyle: textTheme.bodyLarge),
      bodyMedium: arizonia(textStyle: textTheme.bodyMedium),
      bodySmall: arizonia(textStyle: textTheme.bodySmall),
      labelLarge: arizonia(textStyle: textTheme.labelLarge),
      labelMedium: arizonia(textStyle: textTheme.labelMedium),
      labelSmall: arizonia(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Armata font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Armata
  static TextStyle armata({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7653dd9ee79fc9669bf68296b378d9f94a37e2f8fe2a8501ed2bb072ad55de82',
        49964,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Armata',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Armata font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Armata
  static TextTheme armataTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: armata(textStyle: textTheme.displayLarge),
      displayMedium: armata(textStyle: textTheme.displayMedium),
      displaySmall: armata(textStyle: textTheme.displaySmall),
      headlineLarge: armata(textStyle: textTheme.headlineLarge),
      headlineMedium: armata(textStyle: textTheme.headlineMedium),
      headlineSmall: armata(textStyle: textTheme.headlineSmall),
      titleLarge: armata(textStyle: textTheme.titleLarge),
      titleMedium: armata(textStyle: textTheme.titleMedium),
      titleSmall: armata(textStyle: textTheme.titleSmall),
      bodyLarge: armata(textStyle: textTheme.bodyLarge),
      bodyMedium: armata(textStyle: textTheme.bodyMedium),
      bodySmall: armata(textStyle: textTheme.bodySmall),
      labelLarge: armata(textStyle: textTheme.labelLarge),
      labelMedium: armata(textStyle: textTheme.labelMedium),
      labelSmall: armata(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Arsenal font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arsenal
  static TextStyle arsenal({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b5f695f889f166bd03a347f103b3bc671e167458595c8d02994b7fa1763e3e86',
        76692,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a5f085824395aaea9d08f1baad23b3fe697f8214a27e871c4ef04df58d3559ea',
        82296,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a8ba6c5b0c941ce0588b8095560c835724c810d579d505f01e9eedf7fae53cf9',
        77208,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '56f6907247178ab293265b7dd74616db07072abca641f4a05046a57665fc0ce8',
        82340,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Arsenal',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arsenal font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arsenal
  static TextTheme arsenalTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: arsenal(textStyle: textTheme.displayLarge),
      displayMedium: arsenal(textStyle: textTheme.displayMedium),
      displaySmall: arsenal(textStyle: textTheme.displaySmall),
      headlineLarge: arsenal(textStyle: textTheme.headlineLarge),
      headlineMedium: arsenal(textStyle: textTheme.headlineMedium),
      headlineSmall: arsenal(textStyle: textTheme.headlineSmall),
      titleLarge: arsenal(textStyle: textTheme.titleLarge),
      titleMedium: arsenal(textStyle: textTheme.titleMedium),
      titleSmall: arsenal(textStyle: textTheme.titleSmall),
      bodyLarge: arsenal(textStyle: textTheme.bodyLarge),
      bodyMedium: arsenal(textStyle: textTheme.bodyMedium),
      bodySmall: arsenal(textStyle: textTheme.bodySmall),
      labelLarge: arsenal(textStyle: textTheme.labelLarge),
      labelMedium: arsenal(textStyle: textTheme.labelMedium),
      labelSmall: arsenal(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Artifika font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Artifika
  static TextStyle artifika({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2d366647b42c50a5c4a1a96ac78630df49d1bedb60e89f5b32bd9e187b3e3c15',
        36888,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Artifika',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Artifika font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Artifika
  static TextTheme artifikaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: artifika(textStyle: textTheme.displayLarge),
      displayMedium: artifika(textStyle: textTheme.displayMedium),
      displaySmall: artifika(textStyle: textTheme.displaySmall),
      headlineLarge: artifika(textStyle: textTheme.headlineLarge),
      headlineMedium: artifika(textStyle: textTheme.headlineMedium),
      headlineSmall: artifika(textStyle: textTheme.headlineSmall),
      titleLarge: artifika(textStyle: textTheme.titleLarge),
      titleMedium: artifika(textStyle: textTheme.titleMedium),
      titleSmall: artifika(textStyle: textTheme.titleSmall),
      bodyLarge: artifika(textStyle: textTheme.bodyLarge),
      bodyMedium: artifika(textStyle: textTheme.bodyMedium),
      bodySmall: artifika(textStyle: textTheme.bodySmall),
      labelLarge: artifika(textStyle: textTheme.labelLarge),
      labelMedium: artifika(textStyle: textTheme.labelMedium),
      labelSmall: artifika(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Arvo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arvo
  static TextStyle arvo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '20dead8f57ec394f44f6bf59e087cba69339169ba2a4557d2d3c4748b97498bc',
        20668,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '58988cc9ca01776a0de0ae7a93ef72541a9ac38ac196e98e7c1ba8a5234eb93d',
        21104,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e67caf3b0bea80c6cc490964fe7c03954ecfad4dccc515d9c87ab047a1d04697',
        20556,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b9f89dbe72c3a8c6526e16d93f8386ba532a2bf4ff6e6e22fa842ec28b209388',
        21668,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Arvo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arvo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arvo
  static TextTheme arvoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: arvo(textStyle: textTheme.displayLarge),
      displayMedium: arvo(textStyle: textTheme.displayMedium),
      displaySmall: arvo(textStyle: textTheme.displaySmall),
      headlineLarge: arvo(textStyle: textTheme.headlineLarge),
      headlineMedium: arvo(textStyle: textTheme.headlineMedium),
      headlineSmall: arvo(textStyle: textTheme.headlineSmall),
      titleLarge: arvo(textStyle: textTheme.titleLarge),
      titleMedium: arvo(textStyle: textTheme.titleMedium),
      titleSmall: arvo(textStyle: textTheme.titleSmall),
      bodyLarge: arvo(textStyle: textTheme.bodyLarge),
      bodyMedium: arvo(textStyle: textTheme.bodyMedium),
      bodySmall: arvo(textStyle: textTheme.bodySmall),
      labelLarge: arvo(textStyle: textTheme.labelLarge),
      labelMedium: arvo(textStyle: textTheme.labelMedium),
      labelSmall: arvo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Arya font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arya
  static TextStyle arya({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a939aada447f5c1bc764a8f9960c6424d3f38d85972df751c73e54c7362afc64',
        107792,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '00ca32f8ce8b566199068fbd0a93b788998d103f60dfe43263e2959b328245db',
        107528,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Arya',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arya font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arya
  static TextTheme aryaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: arya(textStyle: textTheme.displayLarge),
      displayMedium: arya(textStyle: textTheme.displayMedium),
      displaySmall: arya(textStyle: textTheme.displaySmall),
      headlineLarge: arya(textStyle: textTheme.headlineLarge),
      headlineMedium: arya(textStyle: textTheme.headlineMedium),
      headlineSmall: arya(textStyle: textTheme.headlineSmall),
      titleLarge: arya(textStyle: textTheme.titleLarge),
      titleMedium: arya(textStyle: textTheme.titleMedium),
      titleSmall: arya(textStyle: textTheme.titleSmall),
      bodyLarge: arya(textStyle: textTheme.bodyLarge),
      bodyMedium: arya(textStyle: textTheme.bodyMedium),
      bodySmall: arya(textStyle: textTheme.bodySmall),
      labelLarge: arya(textStyle: textTheme.labelLarge),
      labelMedium: arya(textStyle: textTheme.labelMedium),
      labelSmall: arya(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Asap font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asap
  static TextStyle asap({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b5016c02ae475df8fc1a45a7c62e01b41a8f17a903e2dd17b0f26c7e02da4d72',
        76744,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cf3c3c54f867345b405c2032b0752865216005620c1d884d9a981fcb4bf8543b',
        76828,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a30d35ca3b72ca1d10bb6bb6589178b3522197fa86c1e9f8651f1e8b814779ab',
        76804,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9a8d3eb61a6203d9ef199fe4f1873b2095002da35f6081d97cafb4236eb49c13',
        76760,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7a2ead9a3102f4552495489efe9ee98f5a55adc58549e87046e4ee052b60f58d',
        76764,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e802aead031e6a5c10036a6d60bbedf7e102b0eaf74c33fdf3e0647b6b622806',
        77340,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1a72d2f649a186c225ed37869282f780015a11ad9eafe198350ebdbe7c83ec05',
        77068,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '45e0f9b3dea45b9c9013f843b7aa477c432cf24acfb94e0e9cbab055af14457e',
        77268,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9735c69f3f1eb4db656757037a87a35c2de6e9237c3d963bfc6e7d59ecb77ac3',
        77176,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '64cbfc8e0b2957b4f41943ad6cc792d1a08ebf94679c3d6612f88a6091c91b5f',
        83948,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f49da0598fc7fb264b32c34bc5518358f08bfc52b80c60afd9f7ff99c4bb5bd5',
        83936,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '36d5d03baf26472e7f4012174038f301e00573cc1fbe9252ecac4357792829ae',
        83864,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5b33b1a634fe720a390f465c7feb47e7ad64614c31faf9268ca1821b00806023',
        83776,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b47ca3770b2d338d3e2b3bac9a9b366bbfcfe9543d064138b5b662f36ebf2553',
        83872,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2d9d782b18dd908cffe6002b0a9091221ed6592996991292e87c294b532ecdd4',
        84464,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1890e7d7ba479a884edfcda83be9078268b44e3b329f89fe2dfa7b89fcd09f86',
        84308,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '233497ddf7d6e16e8efa6c9db2a1d5c8baf2d0d52443e656d6f73b7e2fa57323',
        84448,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '56e1ccf40569e80b3971244c3ce36a362f55f4ffa96d516c7c32ebd97e6fb533',
        84456,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Asap',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Asap font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asap
  static TextTheme asapTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: asap(textStyle: textTheme.displayLarge),
      displayMedium: asap(textStyle: textTheme.displayMedium),
      displaySmall: asap(textStyle: textTheme.displaySmall),
      headlineLarge: asap(textStyle: textTheme.headlineLarge),
      headlineMedium: asap(textStyle: textTheme.headlineMedium),
      headlineSmall: asap(textStyle: textTheme.headlineSmall),
      titleLarge: asap(textStyle: textTheme.titleLarge),
      titleMedium: asap(textStyle: textTheme.titleMedium),
      titleSmall: asap(textStyle: textTheme.titleSmall),
      bodyLarge: asap(textStyle: textTheme.bodyLarge),
      bodyMedium: asap(textStyle: textTheme.bodyMedium),
      bodySmall: asap(textStyle: textTheme.bodySmall),
      labelLarge: asap(textStyle: textTheme.labelLarge),
      labelMedium: asap(textStyle: textTheme.labelMedium),
      labelSmall: asap(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Asap Condensed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asap+Condensed
  static TextStyle asapCondensed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ade484514fc686d95088ecc9068746f65f9f6adc0a696b0da2acff890854cf65',
        70152,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b90f2758c6c2a0ce9c6eaec199b338330157f35f221cf442ccb7401e28d3f04c',
        76572,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b3c62c07961f8c1cc819f2413c4c3ee66209f87ac7f8911f5cceaf6ae7e9f20b',
        70320,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5e8644c93790b8e8f02af72b59ab4bd483bcafe8bf61c742c2e47a135a6ff996',
        77020,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '67187fc586421b75621b755d18a693668eea2597145df23beb9fde48a8882929',
        71612,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '63625d89a9573f702e3dd30ed912336425338fe219fe28894871b2f37cae3a0c',
        77984,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6d71e7ff09d019e9fa4eae958644a8190be57bb346e2d0873d8b44e81bba61c4',
        71836,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a9542b8c9b49dd59dd7a0194dbf978aa7217da8934385cb89942677033ff916b',
        77880,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '42a52e3883395e911536e1324ae049b48724416320a3112534c52180dba1dcc9',
        72296,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6bcc4b65aac2d82d21074f772e1bb4664700ee41ff8555abeaa104f2472c3936',
        78172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e0b3138a6a67eeb7069e32ec786b225609fede9574da5247a078090343655a86',
        72360,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e44fb2e1f383540efaa32f627502156a8dfac857e2fd492a6841f2ba695bde93',
        78608,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5fe738ea8f89313a07b24b4817151afe1fd74e018a6fce55fcf463cbd284c004',
        72540,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0329db6b59363ed37615e30425df1482ed5da743d38b4bbfdfd3cca986a6a765',
        78160,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd2674e90f25213c78dafb5d64b4879b2387705cd77d762f1adbee7803d84815e',
        72772,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8042bcbfdcf6ad0d79d7991669c88cee49b2f4964ee918b0cb3d7d62656e2101',
        78708,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AsapCondensed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Asap Condensed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asap+Condensed
  static TextTheme asapCondensedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: asapCondensed(textStyle: textTheme.displayLarge),
      displayMedium: asapCondensed(textStyle: textTheme.displayMedium),
      displaySmall: asapCondensed(textStyle: textTheme.displaySmall),
      headlineLarge: asapCondensed(textStyle: textTheme.headlineLarge),
      headlineMedium: asapCondensed(textStyle: textTheme.headlineMedium),
      headlineSmall: asapCondensed(textStyle: textTheme.headlineSmall),
      titleLarge: asapCondensed(textStyle: textTheme.titleLarge),
      titleMedium: asapCondensed(textStyle: textTheme.titleMedium),
      titleSmall: asapCondensed(textStyle: textTheme.titleSmall),
      bodyLarge: asapCondensed(textStyle: textTheme.bodyLarge),
      bodyMedium: asapCondensed(textStyle: textTheme.bodyMedium),
      bodySmall: asapCondensed(textStyle: textTheme.bodySmall),
      labelLarge: asapCondensed(textStyle: textTheme.labelLarge),
      labelMedium: asapCondensed(textStyle: textTheme.labelMedium),
      labelSmall: asapCondensed(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Asar font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asar
  static TextStyle asar({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9f5c57c47471c19a020f356b7153fa11a8ceb320745319fd004076634bfebd4e',
        399888,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Asar',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Asar font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asar
  static TextTheme asarTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: asar(textStyle: textTheme.displayLarge),
      displayMedium: asar(textStyle: textTheme.displayMedium),
      displaySmall: asar(textStyle: textTheme.displaySmall),
      headlineLarge: asar(textStyle: textTheme.headlineLarge),
      headlineMedium: asar(textStyle: textTheme.headlineMedium),
      headlineSmall: asar(textStyle: textTheme.headlineSmall),
      titleLarge: asar(textStyle: textTheme.titleLarge),
      titleMedium: asar(textStyle: textTheme.titleMedium),
      titleSmall: asar(textStyle: textTheme.titleSmall),
      bodyLarge: asar(textStyle: textTheme.bodyLarge),
      bodyMedium: asar(textStyle: textTheme.bodyMedium),
      bodySmall: asar(textStyle: textTheme.bodySmall),
      labelLarge: asar(textStyle: textTheme.labelLarge),
      labelMedium: asar(textStyle: textTheme.labelMedium),
      labelSmall: asar(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Asset font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asset
  static TextStyle asset({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1747efdd1042b2553f1b11592ccc72a603d6ab33595545bfc1ddbcbc71e97295',
        155988,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Asset',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Asset font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asset
  static TextTheme assetTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: asset(textStyle: textTheme.displayLarge),
      displayMedium: asset(textStyle: textTheme.displayMedium),
      displaySmall: asset(textStyle: textTheme.displaySmall),
      headlineLarge: asset(textStyle: textTheme.headlineLarge),
      headlineMedium: asset(textStyle: textTheme.headlineMedium),
      headlineSmall: asset(textStyle: textTheme.headlineSmall),
      titleLarge: asset(textStyle: textTheme.titleLarge),
      titleMedium: asset(textStyle: textTheme.titleMedium),
      titleSmall: asset(textStyle: textTheme.titleSmall),
      bodyLarge: asset(textStyle: textTheme.bodyLarge),
      bodyMedium: asset(textStyle: textTheme.bodyMedium),
      bodySmall: asset(textStyle: textTheme.bodySmall),
      labelLarge: asset(textStyle: textTheme.labelLarge),
      labelMedium: asset(textStyle: textTheme.labelMedium),
      labelSmall: asset(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Assistant font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Assistant
  static TextStyle assistant({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2472cf1087b9041e4f23f32dbc7cd12ce17b1f1b8aff3da5acf9d43d89964652',
        47472,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd0656f09a302a02a5ff702649e0d40d472fabac486ed222e3ebafc46f8dd1077',
        47704,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cc548e1f7dd1568030a232418066e0228d8e50eb31624857b953549dd253125a',
        47700,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b1462f9586af89df77bbbecba3256c59b7866faf7db45e3dd21b293f095027c7',
        47644,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e426465fc596c9c24f5739db629bfc6790cc3478ede52f42b290745732a1546e',
        47720,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2bab03974a64ddd44e13fbb97af69c422c96ace6b107234e8088410b4262e612',
        47656,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7592bb3e0ec5f54abb17f59aa387561216385597f2d878cc788e1a166ada2c96',
        47536,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Assistant',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Assistant font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Assistant
  static TextTheme assistantTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: assistant(textStyle: textTheme.displayLarge),
      displayMedium: assistant(textStyle: textTheme.displayMedium),
      displaySmall: assistant(textStyle: textTheme.displaySmall),
      headlineLarge: assistant(textStyle: textTheme.headlineLarge),
      headlineMedium: assistant(textStyle: textTheme.headlineMedium),
      headlineSmall: assistant(textStyle: textTheme.headlineSmall),
      titleLarge: assistant(textStyle: textTheme.titleLarge),
      titleMedium: assistant(textStyle: textTheme.titleMedium),
      titleSmall: assistant(textStyle: textTheme.titleSmall),
      bodyLarge: assistant(textStyle: textTheme.bodyLarge),
      bodyMedium: assistant(textStyle: textTheme.bodyMedium),
      bodySmall: assistant(textStyle: textTheme.bodySmall),
      labelLarge: assistant(textStyle: textTheme.labelLarge),
      labelMedium: assistant(textStyle: textTheme.labelMedium),
      labelSmall: assistant(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Astloch font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Astloch
  static TextStyle astloch({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a7a7c68cac2873d07058859ca8ea09c343c2d86b4856fc4228d747cc66738e71',
        49252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a5d9efacd4b695ad23eea17dc7c59305ddc3ce9db72cb9508be52cb932ea6de0',
        50852,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Astloch',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Astloch font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Astloch
  static TextTheme astlochTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: astloch(textStyle: textTheme.displayLarge),
      displayMedium: astloch(textStyle: textTheme.displayMedium),
      displaySmall: astloch(textStyle: textTheme.displaySmall),
      headlineLarge: astloch(textStyle: textTheme.headlineLarge),
      headlineMedium: astloch(textStyle: textTheme.headlineMedium),
      headlineSmall: astloch(textStyle: textTheme.headlineSmall),
      titleLarge: astloch(textStyle: textTheme.titleLarge),
      titleMedium: astloch(textStyle: textTheme.titleMedium),
      titleSmall: astloch(textStyle: textTheme.titleSmall),
      bodyLarge: astloch(textStyle: textTheme.bodyLarge),
      bodyMedium: astloch(textStyle: textTheme.bodyMedium),
      bodySmall: astloch(textStyle: textTheme.bodySmall),
      labelLarge: astloch(textStyle: textTheme.labelLarge),
      labelMedium: astloch(textStyle: textTheme.labelMedium),
      labelSmall: astloch(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Asul font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asul
  static TextStyle asul({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd0ebee9c24737bfbf7941531211f0a3a74d695e20f0a0eefb3833aa64a85c4bf',
        31008,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '71b1dd571c850e1639994da171f0249f3955ac41d5d31153bf29f29da1e10779',
        30988,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Asul',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Asul font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asul
  static TextTheme asulTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: asul(textStyle: textTheme.displayLarge),
      displayMedium: asul(textStyle: textTheme.displayMedium),
      displaySmall: asul(textStyle: textTheme.displaySmall),
      headlineLarge: asul(textStyle: textTheme.headlineLarge),
      headlineMedium: asul(textStyle: textTheme.headlineMedium),
      headlineSmall: asul(textStyle: textTheme.headlineSmall),
      titleLarge: asul(textStyle: textTheme.titleLarge),
      titleMedium: asul(textStyle: textTheme.titleMedium),
      titleSmall: asul(textStyle: textTheme.titleSmall),
      bodyLarge: asul(textStyle: textTheme.bodyLarge),
      bodyMedium: asul(textStyle: textTheme.bodyMedium),
      bodySmall: asul(textStyle: textTheme.bodySmall),
      labelLarge: asul(textStyle: textTheme.labelLarge),
      labelMedium: asul(textStyle: textTheme.labelMedium),
      labelSmall: asul(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Athiti font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Athiti
  static TextStyle athiti({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '696cbfd50124dc9018b35cd34f14c2087a57e8a1a4f5b85412930f5a8b0d927d',
        96028,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bc712088d5e10d28733039df5b64a70792596852e2b3476d106d3ab0eb764c98',
        94860,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2616631b1611fdb8b7ce24b5a7ca2fcc9ed30c586f57109005e4dae361cfae1c',
        95952,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2a3112766cdc5e82e50149f5422d4e7ac6d90ba554076d429c00c361725c6c1c',
        96036,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd486640632fcfc522d9013c7ae37991f4da6fd251dfc845736f1534208999d89',
        95560,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '389e4c7f43470ba0f7a9fb90fcb73eb264aae54974e0befa5bdc6258c4fc16c9',
        96436,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Athiti',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Athiti font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Athiti
  static TextTheme athitiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: athiti(textStyle: textTheme.displayLarge),
      displayMedium: athiti(textStyle: textTheme.displayMedium),
      displaySmall: athiti(textStyle: textTheme.displaySmall),
      headlineLarge: athiti(textStyle: textTheme.headlineLarge),
      headlineMedium: athiti(textStyle: textTheme.headlineMedium),
      headlineSmall: athiti(textStyle: textTheme.headlineSmall),
      titleLarge: athiti(textStyle: textTheme.titleLarge),
      titleMedium: athiti(textStyle: textTheme.titleMedium),
      titleSmall: athiti(textStyle: textTheme.titleSmall),
      bodyLarge: athiti(textStyle: textTheme.bodyLarge),
      bodyMedium: athiti(textStyle: textTheme.bodyMedium),
      bodySmall: athiti(textStyle: textTheme.bodySmall),
      labelLarge: athiti(textStyle: textTheme.labelLarge),
      labelMedium: athiti(textStyle: textTheme.labelMedium),
      labelSmall: athiti(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Atkinson Hyperlegible font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Atkinson+Hyperlegible
  static TextStyle atkinsonHyperlegible({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ee6c7c3c6598f81ae3ec64565252b7f85f2031e129fa9d4ee4a0c12839889264',
        35304,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0c3580a9c2f9fc899b61f5a7eca7e6fd73982d2cea63a100232d524b9278495b',
        35728,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0fc08c96a91a8628172873529de9df0edb16de404ff7c2c109df2ca7745b0820',
        35496,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9d2a564178567b3fccc75106d67b487e6b583dd2028056142b62788671a8af5f',
        36056,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AtkinsonHyperlegible',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Atkinson Hyperlegible font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Atkinson+Hyperlegible
  static TextTheme atkinsonHyperlegibleTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: atkinsonHyperlegible(textStyle: textTheme.displayLarge),
      displayMedium: atkinsonHyperlegible(textStyle: textTheme.displayMedium),
      displaySmall: atkinsonHyperlegible(textStyle: textTheme.displaySmall),
      headlineLarge: atkinsonHyperlegible(textStyle: textTheme.headlineLarge),
      headlineMedium: atkinsonHyperlegible(textStyle: textTheme.headlineMedium),
      headlineSmall: atkinsonHyperlegible(textStyle: textTheme.headlineSmall),
      titleLarge: atkinsonHyperlegible(textStyle: textTheme.titleLarge),
      titleMedium: atkinsonHyperlegible(textStyle: textTheme.titleMedium),
      titleSmall: atkinsonHyperlegible(textStyle: textTheme.titleSmall),
      bodyLarge: atkinsonHyperlegible(textStyle: textTheme.bodyLarge),
      bodyMedium: atkinsonHyperlegible(textStyle: textTheme.bodyMedium),
      bodySmall: atkinsonHyperlegible(textStyle: textTheme.bodySmall),
      labelLarge: atkinsonHyperlegible(textStyle: textTheme.labelLarge),
      labelMedium: atkinsonHyperlegible(textStyle: textTheme.labelMedium),
      labelSmall: atkinsonHyperlegible(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Atma font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Atma
  static TextStyle atma({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '21d24feb8932a5ec944a0bb087e8c1e33ca1c507249ea04a9a1abbd0a6d211de',
        189740,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '70176c593f928f5d887f72a285ffdd740818e7ae96648878f721b78f2ce65c56',
        191388,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1f7bd4f49bac741683b8f145d6f52956bbe0f8614ca0beb0b7105ff30c5a8748',
        190840,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7929b2c30b891226514c0e917a60ac5cc650b0fb94dc4aaa7006836720159776',
        189940,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a61d48250e608b03a3e0ec56a2bd28e07a880b144acfcbd757ad6bad3d563a66',
        186912,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Atma',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Atma font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Atma
  static TextTheme atmaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: atma(textStyle: textTheme.displayLarge),
      displayMedium: atma(textStyle: textTheme.displayMedium),
      displaySmall: atma(textStyle: textTheme.displaySmall),
      headlineLarge: atma(textStyle: textTheme.headlineLarge),
      headlineMedium: atma(textStyle: textTheme.headlineMedium),
      headlineSmall: atma(textStyle: textTheme.headlineSmall),
      titleLarge: atma(textStyle: textTheme.titleLarge),
      titleMedium: atma(textStyle: textTheme.titleMedium),
      titleSmall: atma(textStyle: textTheme.titleSmall),
      bodyLarge: atma(textStyle: textTheme.bodyLarge),
      bodyMedium: atma(textStyle: textTheme.bodyMedium),
      bodySmall: atma(textStyle: textTheme.bodySmall),
      labelLarge: atma(textStyle: textTheme.labelLarge),
      labelMedium: atma(textStyle: textTheme.labelMedium),
      labelSmall: atma(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Atomic Age font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Atomic+Age
  static TextStyle atomicAge({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a9f2142938d6ee0e74907390e66d9ea05265c756dc4b93fa8e81a160ca449ab1',
        40672,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AtomicAge',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Atomic Age font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Atomic+Age
  static TextTheme atomicAgeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: atomicAge(textStyle: textTheme.displayLarge),
      displayMedium: atomicAge(textStyle: textTheme.displayMedium),
      displaySmall: atomicAge(textStyle: textTheme.displaySmall),
      headlineLarge: atomicAge(textStyle: textTheme.headlineLarge),
      headlineMedium: atomicAge(textStyle: textTheme.headlineMedium),
      headlineSmall: atomicAge(textStyle: textTheme.headlineSmall),
      titleLarge: atomicAge(textStyle: textTheme.titleLarge),
      titleMedium: atomicAge(textStyle: textTheme.titleMedium),
      titleSmall: atomicAge(textStyle: textTheme.titleSmall),
      bodyLarge: atomicAge(textStyle: textTheme.bodyLarge),
      bodyMedium: atomicAge(textStyle: textTheme.bodyMedium),
      bodySmall: atomicAge(textStyle: textTheme.bodySmall),
      labelLarge: atomicAge(textStyle: textTheme.labelLarge),
      labelMedium: atomicAge(textStyle: textTheme.labelMedium),
      labelSmall: atomicAge(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Aubrey font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aubrey
  static TextStyle aubrey({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8ca62b5d441c31bf4bb2af48b336acbd0c109ead24d4b7dcc734c428d66b7f1a',
        32668,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Aubrey',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Aubrey font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aubrey
  static TextTheme aubreyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: aubrey(textStyle: textTheme.displayLarge),
      displayMedium: aubrey(textStyle: textTheme.displayMedium),
      displaySmall: aubrey(textStyle: textTheme.displaySmall),
      headlineLarge: aubrey(textStyle: textTheme.headlineLarge),
      headlineMedium: aubrey(textStyle: textTheme.headlineMedium),
      headlineSmall: aubrey(textStyle: textTheme.headlineSmall),
      titleLarge: aubrey(textStyle: textTheme.titleLarge),
      titleMedium: aubrey(textStyle: textTheme.titleMedium),
      titleSmall: aubrey(textStyle: textTheme.titleSmall),
      bodyLarge: aubrey(textStyle: textTheme.bodyLarge),
      bodyMedium: aubrey(textStyle: textTheme.bodyMedium),
      bodySmall: aubrey(textStyle: textTheme.bodySmall),
      labelLarge: aubrey(textStyle: textTheme.labelLarge),
      labelMedium: aubrey(textStyle: textTheme.labelMedium),
      labelSmall: aubrey(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Audiowide font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Audiowide
  static TextStyle audiowide({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '078dd790aa7505065d5d579077bde98a59edcfbdc4e8efeff86813e8b7ae2859',
        46544,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Audiowide',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Audiowide font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Audiowide
  static TextTheme audiowideTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: audiowide(textStyle: textTheme.displayLarge),
      displayMedium: audiowide(textStyle: textTheme.displayMedium),
      displaySmall: audiowide(textStyle: textTheme.displaySmall),
      headlineLarge: audiowide(textStyle: textTheme.headlineLarge),
      headlineMedium: audiowide(textStyle: textTheme.headlineMedium),
      headlineSmall: audiowide(textStyle: textTheme.headlineSmall),
      titleLarge: audiowide(textStyle: textTheme.titleLarge),
      titleMedium: audiowide(textStyle: textTheme.titleMedium),
      titleSmall: audiowide(textStyle: textTheme.titleSmall),
      bodyLarge: audiowide(textStyle: textTheme.bodyLarge),
      bodyMedium: audiowide(textStyle: textTheme.bodyMedium),
      bodySmall: audiowide(textStyle: textTheme.bodySmall),
      labelLarge: audiowide(textStyle: textTheme.labelLarge),
      labelMedium: audiowide(textStyle: textTheme.labelMedium),
      labelSmall: audiowide(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Autour One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Autour+One
  static TextStyle autourOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '835e4cf3882094e87b1cc6738455d27c58666e50595b7304fe641bb9d371bddf',
        56644,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AutourOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Autour One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Autour+One
  static TextTheme autourOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: autourOne(textStyle: textTheme.displayLarge),
      displayMedium: autourOne(textStyle: textTheme.displayMedium),
      displaySmall: autourOne(textStyle: textTheme.displaySmall),
      headlineLarge: autourOne(textStyle: textTheme.headlineLarge),
      headlineMedium: autourOne(textStyle: textTheme.headlineMedium),
      headlineSmall: autourOne(textStyle: textTheme.headlineSmall),
      titleLarge: autourOne(textStyle: textTheme.titleLarge),
      titleMedium: autourOne(textStyle: textTheme.titleMedium),
      titleSmall: autourOne(textStyle: textTheme.titleSmall),
      bodyLarge: autourOne(textStyle: textTheme.bodyLarge),
      bodyMedium: autourOne(textStyle: textTheme.bodyMedium),
      bodySmall: autourOne(textStyle: textTheme.bodySmall),
      labelLarge: autourOne(textStyle: textTheme.labelLarge),
      labelMedium: autourOne(textStyle: textTheme.labelMedium),
      labelSmall: autourOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Average font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Average
  static TextStyle average({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '22aaa82479b458375c6ae410aa74bb669225d52d9782cb3f301ac70db520b723',
        51556,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Average',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Average font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Average
  static TextTheme averageTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: average(textStyle: textTheme.displayLarge),
      displayMedium: average(textStyle: textTheme.displayMedium),
      displaySmall: average(textStyle: textTheme.displaySmall),
      headlineLarge: average(textStyle: textTheme.headlineLarge),
      headlineMedium: average(textStyle: textTheme.headlineMedium),
      headlineSmall: average(textStyle: textTheme.headlineSmall),
      titleLarge: average(textStyle: textTheme.titleLarge),
      titleMedium: average(textStyle: textTheme.titleMedium),
      titleSmall: average(textStyle: textTheme.titleSmall),
      bodyLarge: average(textStyle: textTheme.bodyLarge),
      bodyMedium: average(textStyle: textTheme.bodyMedium),
      bodySmall: average(textStyle: textTheme.bodySmall),
      labelLarge: average(textStyle: textTheme.labelLarge),
      labelMedium: average(textStyle: textTheme.labelMedium),
      labelSmall: average(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Average Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Average+Sans
  static TextStyle averageSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'db7e01f028c635aef313afbb32495c914fa586be304b27ef0f93996e1d861d76',
        40392,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AverageSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Average Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Average+Sans
  static TextTheme averageSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: averageSans(textStyle: textTheme.displayLarge),
      displayMedium: averageSans(textStyle: textTheme.displayMedium),
      displaySmall: averageSans(textStyle: textTheme.displaySmall),
      headlineLarge: averageSans(textStyle: textTheme.headlineLarge),
      headlineMedium: averageSans(textStyle: textTheme.headlineMedium),
      headlineSmall: averageSans(textStyle: textTheme.headlineSmall),
      titleLarge: averageSans(textStyle: textTheme.titleLarge),
      titleMedium: averageSans(textStyle: textTheme.titleMedium),
      titleSmall: averageSans(textStyle: textTheme.titleSmall),
      bodyLarge: averageSans(textStyle: textTheme.bodyLarge),
      bodyMedium: averageSans(textStyle: textTheme.bodyMedium),
      bodySmall: averageSans(textStyle: textTheme.bodySmall),
      labelLarge: averageSans(textStyle: textTheme.labelLarge),
      labelMedium: averageSans(textStyle: textTheme.labelMedium),
      labelSmall: averageSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Averia Gruesa Libre font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Averia+Gruesa+Libre
  static TextStyle averiaGruesaLibre({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '879c55ff64c5c857842f76d67c79f6a96ed3e5a90b4dc3bee62a508b87ce77da',
        110136,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AveriaGruesaLibre',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Averia Gruesa Libre font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Averia+Gruesa+Libre
  static TextTheme averiaGruesaLibreTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: averiaGruesaLibre(textStyle: textTheme.displayLarge),
      displayMedium: averiaGruesaLibre(textStyle: textTheme.displayMedium),
      displaySmall: averiaGruesaLibre(textStyle: textTheme.displaySmall),
      headlineLarge: averiaGruesaLibre(textStyle: textTheme.headlineLarge),
      headlineMedium: averiaGruesaLibre(textStyle: textTheme.headlineMedium),
      headlineSmall: averiaGruesaLibre(textStyle: textTheme.headlineSmall),
      titleLarge: averiaGruesaLibre(textStyle: textTheme.titleLarge),
      titleMedium: averiaGruesaLibre(textStyle: textTheme.titleMedium),
      titleSmall: averiaGruesaLibre(textStyle: textTheme.titleSmall),
      bodyLarge: averiaGruesaLibre(textStyle: textTheme.bodyLarge),
      bodyMedium: averiaGruesaLibre(textStyle: textTheme.bodyMedium),
      bodySmall: averiaGruesaLibre(textStyle: textTheme.bodySmall),
      labelLarge: averiaGruesaLibre(textStyle: textTheme.labelLarge),
      labelMedium: averiaGruesaLibre(textStyle: textTheme.labelMedium),
      labelSmall: averiaGruesaLibre(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Averia Libre font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Averia+Libre
  static TextStyle averiaLibre({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7e7822881be83db88a6a6674b8ef18760d8fb01b44cc07898b1b686204f22c24',
        106720,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '478d586176da94e754eda5ef0481c71000c7a82be20445a3f04dbf2ecf276ba5',
        132056,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e5dbc6d83b9f1a68d3be7cc777ec96e097a2a02ae5ca2a3f18f39e720f6e379b',
        107020,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c592b4893f6fa2059fdbf44bf1a29bf18ef204851d4775bf3ec3878283c54d4e',
        127372,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '41216d0ca8e7db003bdafb5f53bd3425def86c7321217f68da77baf0feac4769',
        110832,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '20f2ca7436a510cc1acc4be8a1340bb9a981f734e07ae1049d66c576d3112871',
        134260,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AveriaLibre',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Averia Libre font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Averia+Libre
  static TextTheme averiaLibreTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: averiaLibre(textStyle: textTheme.displayLarge),
      displayMedium: averiaLibre(textStyle: textTheme.displayMedium),
      displaySmall: averiaLibre(textStyle: textTheme.displaySmall),
      headlineLarge: averiaLibre(textStyle: textTheme.headlineLarge),
      headlineMedium: averiaLibre(textStyle: textTheme.headlineMedium),
      headlineSmall: averiaLibre(textStyle: textTheme.headlineSmall),
      titleLarge: averiaLibre(textStyle: textTheme.titleLarge),
      titleMedium: averiaLibre(textStyle: textTheme.titleMedium),
      titleSmall: averiaLibre(textStyle: textTheme.titleSmall),
      bodyLarge: averiaLibre(textStyle: textTheme.bodyLarge),
      bodyMedium: averiaLibre(textStyle: textTheme.bodyMedium),
      bodySmall: averiaLibre(textStyle: textTheme.bodySmall),
      labelLarge: averiaLibre(textStyle: textTheme.labelLarge),
      labelMedium: averiaLibre(textStyle: textTheme.labelMedium),
      labelSmall: averiaLibre(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Averia Sans Libre font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Averia+Sans+Libre
  static TextStyle averiaSansLibre({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6fd813c721322675b22117fb87bdd15056500778edde8f452bcd82ced8a3f492',
        106264,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5ff26e28a2cdc307146940b4cb95860cb6f6e2da4b0657be9790357e36c2f99e',
        132696,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '94795aa3af0b8abf865caa303e6a8204dbf2fbac7fd4bd479026b6a8f1c62d0a',
        106888,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ab985b05b0660f341b1d7af94b178478dafb1441a052997b59affa822b1cd001',
        127404,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5409e213a481c70a749bf668a35f379ad538eeb4b974a84b7717a23ae41280aa',
        111544,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fdfcd86a49a065706fde33a5de437070e5218f93af70579b548529871d93b457',
        134372,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AveriaSansLibre',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Averia Sans Libre font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Averia+Sans+Libre
  static TextTheme averiaSansLibreTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: averiaSansLibre(textStyle: textTheme.displayLarge),
      displayMedium: averiaSansLibre(textStyle: textTheme.displayMedium),
      displaySmall: averiaSansLibre(textStyle: textTheme.displaySmall),
      headlineLarge: averiaSansLibre(textStyle: textTheme.headlineLarge),
      headlineMedium: averiaSansLibre(textStyle: textTheme.headlineMedium),
      headlineSmall: averiaSansLibre(textStyle: textTheme.headlineSmall),
      titleLarge: averiaSansLibre(textStyle: textTheme.titleLarge),
      titleMedium: averiaSansLibre(textStyle: textTheme.titleMedium),
      titleSmall: averiaSansLibre(textStyle: textTheme.titleSmall),
      bodyLarge: averiaSansLibre(textStyle: textTheme.bodyLarge),
      bodyMedium: averiaSansLibre(textStyle: textTheme.bodyMedium),
      bodySmall: averiaSansLibre(textStyle: textTheme.bodySmall),
      labelLarge: averiaSansLibre(textStyle: textTheme.labelLarge),
      labelMedium: averiaSansLibre(textStyle: textTheme.labelMedium),
      labelSmall: averiaSansLibre(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Averia Serif Libre font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Averia+Serif+Libre
  static TextStyle averiaSerifLibre({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '32aa4d80e559da5451c0cb6050ab11f77f328ebfa53e42c0386e9321cc89f323',
        108484,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e88db886cc7c076f44e9332224f6036ce194f436d8fd0895fc754b0f6a263f50',
        134468,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c35b8a9a2e23a7ce4701d84eff2545820fbab71354afa2934c347a018d9666a9',
        108508,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '23d5fb1d7dc8852645bb89985e453c865af069908dbf59bb0f6d3421d589844e',
        129480,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0ae837bda22640e15d8c380d4eb2bd97ae69cdddd5f4966c9909cb127077825f',
        112472,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ca61b0379b7e928b63dcb87b94d856bc0d0288038fc53f5ad6e3387c4b1891e7',
        136700,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AveriaSerifLibre',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Averia Serif Libre font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Averia+Serif+Libre
  static TextTheme averiaSerifLibreTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: averiaSerifLibre(textStyle: textTheme.displayLarge),
      displayMedium: averiaSerifLibre(textStyle: textTheme.displayMedium),
      displaySmall: averiaSerifLibre(textStyle: textTheme.displaySmall),
      headlineLarge: averiaSerifLibre(textStyle: textTheme.headlineLarge),
      headlineMedium: averiaSerifLibre(textStyle: textTheme.headlineMedium),
      headlineSmall: averiaSerifLibre(textStyle: textTheme.headlineSmall),
      titleLarge: averiaSerifLibre(textStyle: textTheme.titleLarge),
      titleMedium: averiaSerifLibre(textStyle: textTheme.titleMedium),
      titleSmall: averiaSerifLibre(textStyle: textTheme.titleSmall),
      bodyLarge: averiaSerifLibre(textStyle: textTheme.bodyLarge),
      bodyMedium: averiaSerifLibre(textStyle: textTheme.bodyMedium),
      bodySmall: averiaSerifLibre(textStyle: textTheme.bodySmall),
      labelLarge: averiaSerifLibre(textStyle: textTheme.labelLarge),
      labelMedium: averiaSerifLibre(textStyle: textTheme.labelMedium),
      labelSmall: averiaSerifLibre(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Azeret Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Azeret+Mono
  static TextStyle azeretMono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e376dc172013c157a84376a8c103e21fe0e00136117c6ede635f6d7041a80aec',
        36332,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c84e04b76228e1699753b6ffb045442da0eaddbf69ac68e7515e489eb598bd37',
        36372,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '63beec477c3111e9c6848ee48d05bb30c9b38791bdbc6203fcf3addf0cd8b929',
        36292,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c8fbb726b1e15b8e6fd5f0d01fe74eac5612c451126e6d18de2dd79dd45f2076',
        36252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '56c6b02d6b8bf9d5af614b87f65a169dc173dafaba91555b009bf4f286cad919',
        36316,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4345cabf13b67f88be2af61e58df98c0bb3703ad05996c9539f67a48a8a86757',
        36208,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ccb4627d3e722e6ba1e1d577ab03f583dc5d265e58392d24ccd68abbe41d1a3a',
        36120,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a33c609257c09b9acdee6a95cfe187feb019e1038db2a4d3c8bdc2b84255dc22',
        36292,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1f82d72f542e396469f795d3e8bc382fc38d7354781b2ac386b8339d8b813e82',
        36340,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '568788fb7b88d3ac1b1da81d4b3fe391c5160c524f5627f28fc64196e0defbb2',
        37464,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6c4852ffbc91796e558d139523b059f4b7c9f217bb213c7c8cf66ecb95440033',
        37556,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '47c8f756184a4ab76ffb1da899a7c8c24446c8a024cc92fb0b8398171acfadfb',
        37452,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3b34f251e08faac5a23373adad83969c247110c5ee90b114665d379470db790a',
        37360,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'df19d816542b6967040cdc509d395151af7a58579d2af43517043785b4a23b03',
        37516,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0dbb7dff740e5d9edc0234e99338ceccc7127bd36046387cd67e599b3c5a49d1',
        37484,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '039eeeaa5d4fb10910a83d7566140f0ea3cd1039ba7582740a5a55f7b9867d0f',
        37256,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '749d9513d509c099a2e28225af6c2e73bf900a7694957228b9531714d4b6bbec',
        37432,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8ece4e25cbe91414408b36478a19ee0a7bcfd8f0bc546f2bb4f4404a00ef5b21',
        37488,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AzeretMono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Azeret Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Azeret+Mono
  static TextTheme azeretMonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: azeretMono(textStyle: textTheme.displayLarge),
      displayMedium: azeretMono(textStyle: textTheme.displayMedium),
      displaySmall: azeretMono(textStyle: textTheme.displaySmall),
      headlineLarge: azeretMono(textStyle: textTheme.headlineLarge),
      headlineMedium: azeretMono(textStyle: textTheme.headlineMedium),
      headlineSmall: azeretMono(textStyle: textTheme.headlineSmall),
      titleLarge: azeretMono(textStyle: textTheme.titleLarge),
      titleMedium: azeretMono(textStyle: textTheme.titleMedium),
      titleSmall: azeretMono(textStyle: textTheme.titleSmall),
      bodyLarge: azeretMono(textStyle: textTheme.bodyLarge),
      bodyMedium: azeretMono(textStyle: textTheme.bodyMedium),
      bodySmall: azeretMono(textStyle: textTheme.bodySmall),
      labelLarge: azeretMono(textStyle: textTheme.labelLarge),
      labelMedium: azeretMono(textStyle: textTheme.labelMedium),
      labelSmall: azeretMono(textStyle: textTheme.labelSmall),
    );
  }
}
