/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.systemchannels;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import java.nio.ByteBuffer;

public class PlatformViewCreationRequest {
    public final int viewId;
    @NonNull
    public final String viewType;
    public final double logicalWidth;
    public final double logicalHeight;
    public final double logicalTop;
    public final double logicalLeft;
    public final int direction;
    public final RequestedDisplayMode displayMode;
    @Nullable
    public final ByteBuffer params;

    public static PlatformViewCreationRequest createHCPPRequest(int viewId, String viewType, int direction, ByteBuffer params) {
        return new PlatformViewCreationRequest(viewId, viewType, 0.0, 0.0, 0.0, 0.0, direction, null, params);
    }

    public static PlatformViewCreationRequest createHybridCompositionRequest(int viewId, String viewType, int direction, ByteBuffer params) {
        return new PlatformViewCreationRequest(viewId, viewType, 0.0, 0.0, 0.0, 0.0, direction, RequestedDisplayMode.HYBRID_ONLY, params);
    }

    public static PlatformViewCreationRequest createTLHCWithFallbackRequest(int viewId, String viewType, double top, double left, double width, double height, int direction, boolean hybridFallback, ByteBuffer params) {
        return new PlatformViewCreationRequest(viewId, viewType, top, left, width, height, direction, hybridFallback ? RequestedDisplayMode.TEXTURE_WITH_HYBRID_FALLBACK : RequestedDisplayMode.TEXTURE_WITH_VIRTUAL_FALLBACK, params);
    }

    @VisibleForTesting
    public PlatformViewCreationRequest(int viewId, @NonNull String viewType, double logicalTop, double logicalLeft, double logicalWidth, double logicalHeight, int direction, @Nullable ByteBuffer params) {
        this(viewId, viewType, logicalTop, logicalLeft, logicalWidth, logicalHeight, direction, RequestedDisplayMode.TEXTURE_WITH_VIRTUAL_FALLBACK, params);
    }

    public PlatformViewCreationRequest(int viewId, @NonNull String viewType, double logicalTop, double logicalLeft, double logicalWidth, double logicalHeight, int direction, @Nullable RequestedDisplayMode displayMode, @Nullable ByteBuffer params) {
        this.viewId = viewId;
        this.viewType = viewType;
        this.logicalTop = logicalTop;
        this.logicalLeft = logicalLeft;
        this.logicalWidth = logicalWidth;
        this.logicalHeight = logicalHeight;
        this.direction = direction;
        this.displayMode = displayMode;
        this.params = params;
    }

    public static enum RequestedDisplayMode {
        TEXTURE_WITH_VIRTUAL_FALLBACK,
        TEXTURE_WITH_HYBRID_FALLBACK,
        HYBRID_ONLY;

    }
}

