/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.android;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import io.flutter.embedding.engine.systemchannels.KeyEventChannel;

public class AndroidKeyProcessor {
    private final KeyEventChannel keyEventChannel;
    private int combiningCharacter;

    public AndroidKeyProcessor(@NonNull KeyEventChannel keyEventChannel) {
        this.keyEventChannel = keyEventChannel;
    }

    public void onKeyUp(@NonNull KeyEvent keyEvent) {
        Character complexCharacter = this.applyCombiningCharacterToBaseCharacter(keyEvent.getUnicodeChar());
        this.keyEventChannel.keyUp(new KeyEventChannel.FlutterKeyEvent(keyEvent, complexCharacter));
    }

    public void onKeyDown(@NonNull KeyEvent keyEvent) {
        Character complexCharacter = this.applyCombiningCharacterToBaseCharacter(keyEvent.getUnicodeChar());
        this.keyEventChannel.keyDown(new KeyEventChannel.FlutterKeyEvent(keyEvent, complexCharacter));
    }

    @Nullable
    private Character applyCombiningCharacterToBaseCharacter(int newCharacterCodePoint) {
        boolean isNewCodePointACombiningCharacter;
        if (newCharacterCodePoint == 0) {
            return null;
        }
        Character complexCharacter = Character.valueOf((char)newCharacterCodePoint);
        boolean bl = isNewCodePointACombiningCharacter = (newCharacterCodePoint & Integer.MIN_VALUE) != 0;
        if (isNewCodePointACombiningCharacter) {
            int plainCodePoint = newCharacterCodePoint & Integer.MAX_VALUE;
            this.combiningCharacter = this.combiningCharacter != 0 ? KeyCharacterMap.getDeadChar((int)this.combiningCharacter, (int)plainCodePoint) : plainCodePoint;
        } else if (this.combiningCharacter != 0) {
            int combinedChar = KeyCharacterMap.getDeadChar((int)this.combiningCharacter, (int)newCharacterCodePoint);
            if (combinedChar > 0) {
                complexCharacter = Character.valueOf((char)combinedChar);
            }
            this.combiningCharacter = 0;
        }
        return complexCharacter;
    }
}

