/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public abstract class BSDiff {
    public static byte[] bspatch(byte[] olddata, byte[] diffdata) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(diffdata, 0, diffdata.length);
        DataInputStream header = new DataInputStream(in);
        byte[] magic = new byte[8];
        header.read(magic);
        if (!new String(magic).equals("BZDIFF40")) {
            throw new IOException("Invalid magic");
        }
        int ctrllen = (int)header.readLong();
        int datalen = (int)header.readLong();
        int newsize = (int)header.readLong();
        header.close();
        in = new ByteArrayInputStream(diffdata, 0, diffdata.length);
        ((InputStream)in).skip(32L);
        DataInputStream cpf = new DataInputStream(new GZIPInputStream(in));
        in = new ByteArrayInputStream(diffdata, 0, diffdata.length);
        ((InputStream)in).skip(32 + ctrllen);
        GZIPInputStream dpf = new GZIPInputStream(in);
        in = new ByteArrayInputStream(diffdata, 0, diffdata.length);
        ((InputStream)in).skip(32 + ctrllen + datalen);
        GZIPInputStream epf = new GZIPInputStream(in);
        byte[] newdata = new byte[newsize];
        int oldpos = 0;
        int newpos = 0;
        while (newpos < newsize) {
            int i;
            int[] ctrl = new int[3];
            for (i = 0; i <= 2; ++i) {
                ctrl[i] = (int)cpf.readLong();
            }
            if (newpos + ctrl[0] > newsize) {
                throw new IOException("Invalid ctrl[0]");
            }
            BSDiff.read(dpf, newdata, newpos, ctrl[0]);
            for (i = 0; i < ctrl[0]; ++i) {
                if (oldpos + i < 0 || oldpos + i >= olddata.length) continue;
                int n = newpos + i;
                newdata[n] = (byte)(newdata[n] + olddata[oldpos + i]);
            }
            oldpos += ctrl[0];
            if ((newpos += ctrl[0]) + ctrl[1] > newsize) {
                throw new IOException("Invalid ctrl[0]");
            }
            BSDiff.read(epf, newdata, newpos, ctrl[1]);
            newpos += ctrl[1];
            oldpos += ctrl[2];
        }
        cpf.close();
        ((InputStream)dpf).close();
        ((InputStream)epf).close();
        return newdata;
    }

    private static void read(InputStream in, byte[] buf, int off, int len) throws IOException {
        int i;
        for (int n = 0; n < len; n += i) {
            i = in.read(buf, off + n, len - n);
            if (i >= 0) continue;
            throw new IOException("Unexpected EOF");
        }
    }
}

