/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import io.flutter.Log;
import io.flutter.embedding.android.FlutterView;
import io.flutter.embedding.engine.FlutterEngine;
import io.flutter.embedding.engine.FlutterShellArgs;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.embedding.engine.renderer.OnFirstFrameRenderedListener;
import io.flutter.plugin.platform.PlatformPlugin;
import io.flutter.view.FlutterMain;
import java.util.Arrays;

public class FlutterFragment
extends Fragment {
    private static final String TAG = "FlutterFragment";
    protected static final String ARG_DART_ENTRYPOINT = "dart_entrypoint";
    protected static final String ARG_INITIAL_ROUTE = "initial_route";
    protected static final String ARG_APP_BUNDLE_PATH = "app_bundle_path";
    protected static final String ARG_FLUTTER_INITIALIZATION_ARGS = "initialization_args";
    protected static final String ARG_FLUTTERVIEW_RENDER_MODE = "flutterview_render_mode";
    protected static final String ARG_FLUTTERVIEW_TRANSPARENCY_MODE = "flutterview_transparency_mode";
    protected static final String ARG_SHOULD_ATTACH_ENGINE_TO_ACTIVITY = "should_attach_engine_to_activity";
    @Nullable
    private FlutterEngine flutterEngine;
    private boolean isFlutterEngineFromActivity;
    @Nullable
    private FlutterView flutterView;
    @Nullable
    private PlatformPlugin platformPlugin;
    private final OnFirstFrameRenderedListener onFirstFrameRenderedListener = new OnFirstFrameRenderedListener(){

        @Override
        public void onFirstFrameRendered() {
            FlutterFragment.this.onFirstFrameRendered();
            FragmentActivity fragmentActivity = FlutterFragment.this.getActivity();
            if (fragmentActivity != null && fragmentActivity instanceof OnFirstFrameRenderedListener) {
                OnFirstFrameRenderedListener activityAsListener = (OnFirstFrameRenderedListener)fragmentActivity;
                activityAsListener.onFirstFrameRendered();
            }
        }
    };

    public FlutterFragment() {
        this.setArguments(new Bundle());
    }

    @Nullable
    public FlutterEngine getFlutterEngine() {
        return this.flutterEngine;
    }

    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
        this.initializeFlutter(this.getContextCompat());
        if (this.flutterEngine == null) {
            this.setupFlutterEngine();
        }
        this.platformPlugin = new PlatformPlugin((Activity)this.getActivity(), this.flutterEngine.getPlatformChannel());
        if (this.shouldAttachEngineToActivity()) {
            Log.d(TAG, "Attaching FlutterEngine to the Activity that owns this Fragment.");
            this.flutterEngine.getActivityControlSurface().attachToActivity((Activity)this.getActivity(), this.getLifecycle());
        }
    }

    private void initializeFlutter(@NonNull Context context) {
        String[] flutterShellArgsArray = this.getArguments().getStringArray(ARG_FLUTTER_INITIALIZATION_ARGS);
        FlutterShellArgs flutterShellArgs = new FlutterShellArgs(flutterShellArgsArray != null ? flutterShellArgsArray : new String[]{});
        FlutterMain.ensureInitializationComplete(context.getApplicationContext(), flutterShellArgs.toArray());
    }

    private void setupFlutterEngine() {
        Log.d(TAG, "Setting up FlutterEngine.");
        this.flutterEngine = this.createFlutterEngine(this.getContextCompat());
        if (this.flutterEngine != null) {
            return;
        }
        FragmentActivity attachedActivity = this.getActivity();
        if (attachedActivity instanceof FlutterEngineProvider) {
            Log.d(TAG, "Deferring to attached Activity to provide a FlutterEngine.");
            FlutterEngineProvider flutterEngineProvider = (FlutterEngineProvider)attachedActivity;
            this.flutterEngine = flutterEngineProvider.getFlutterEngine(this.getContext());
            if (this.flutterEngine != null) {
                this.isFlutterEngineFromActivity = true;
            }
            return;
        }
        Log.d(TAG, "No preferred FlutterEngine was provided. Creating a new FlutterEngine for this FlutterFragment.");
        this.flutterEngine = new FlutterEngine(this.getContext());
        this.isFlutterEngineFromActivity = false;
    }

    @Nullable
    protected FlutterEngine createFlutterEngine(@NonNull Context context) {
        return null;
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Log.v(TAG, "Creating FlutterView.");
        this.flutterView = new FlutterView(this.getContext(), this.getRenderMode(), this.getTransparencyMode());
        this.flutterView.addOnFirstFrameRenderedListener(this.onFirstFrameRenderedListener);
        return this.flutterView;
    }

    private void doInitialFlutterViewRun() {
        if (this.flutterEngine.getDartExecutor().isExecutingDart()) {
            return;
        }
        Log.d(TAG, "Executing Dart entrypoint: " + this.getDartEntrypointFunctionName() + ", and sending initial route: " + this.getInitialRoute());
        if (this.getInitialRoute() != null) {
            this.flutterEngine.getNavigationChannel().setInitialRoute(this.getInitialRoute());
        }
        DartExecutor.DartEntrypoint entrypoint = new DartExecutor.DartEntrypoint(this.getResources().getAssets(), this.getAppBundlePath(), this.getDartEntrypointFunctionName());
        this.flutterEngine.getDartExecutor().executeDartEntrypoint(entrypoint);
    }

    @Nullable
    protected String getInitialRoute() {
        return this.getArguments().getString(ARG_INITIAL_ROUTE);
    }

    @NonNull
    protected String getAppBundlePath() {
        return this.getArguments().getString(ARG_APP_BUNDLE_PATH, FlutterMain.findAppBundlePath(this.getContextCompat()));
    }

    @NonNull
    protected String getDartEntrypointFunctionName() {
        return this.getArguments().getString(ARG_DART_ENTRYPOINT, "main");
    }

    @NonNull
    protected FlutterView.RenderMode getRenderMode() {
        String renderModeName = this.getArguments().getString(ARG_FLUTTERVIEW_RENDER_MODE, FlutterView.RenderMode.surface.name());
        return FlutterView.RenderMode.valueOf(renderModeName);
    }

    @NonNull
    protected FlutterView.TransparencyMode getTransparencyMode() {
        String transparencyModeName = this.getArguments().getString(ARG_FLUTTERVIEW_TRANSPARENCY_MODE, FlutterView.TransparencyMode.transparent.name());
        return FlutterView.TransparencyMode.valueOf(transparencyModeName);
    }

    public void onStart() {
        super.onStart();
        Log.v(TAG, "onStart()");
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                Log.v(FlutterFragment.TAG, "Attaching FlutterEngine to FlutterView.");
                FlutterFragment.this.flutterView.attachToFlutterEngine(FlutterFragment.this.flutterEngine);
                FlutterFragment.this.doInitialFlutterViewRun();
            }
        });
    }

    public void onResume() {
        super.onResume();
        Log.v(TAG, "onResume()");
        this.flutterEngine.getLifecycleChannel().appIsResumed();
    }

    public void onPostResume() {
        Log.v(TAG, "onPostResume()");
        if (this.flutterEngine != null) {
            this.platformPlugin.onPostResume();
        } else {
            Log.w(TAG, "onPostResume() invoked before FlutterFragment was attached to an Activity.");
        }
    }

    public void onPause() {
        super.onPause();
        Log.v(TAG, "onPause()");
        this.flutterEngine.getLifecycleChannel().appIsInactive();
    }

    public void onStop() {
        super.onStop();
        Log.v(TAG, "onStop()");
        this.flutterEngine.getLifecycleChannel().appIsPaused();
        this.flutterView.detachFromFlutterEngine();
    }

    public void onDestroyView() {
        super.onDestroyView();
        Log.v(TAG, "onDestroyView()");
        this.flutterView.removeOnFirstFrameRenderedListener(this.onFirstFrameRenderedListener);
    }

    public void onDetach() {
        super.onDetach();
        Log.v(TAG, "onDetach()");
        if (this.shouldAttachEngineToActivity()) {
            Log.d(TAG, "Detaching FlutterEngine from the Activity that owns this Fragment.");
            if (this.getActivity().isChangingConfigurations()) {
                this.flutterEngine.getActivityControlSurface().detachFromActivityForConfigChanges();
            } else {
                this.flutterEngine.getActivityControlSurface().detachFromActivity();
            }
        }
        this.platformPlugin.destroy();
        this.platformPlugin = null;
        if (!this.retainFlutterEngineAfterFragmentDestruction() && !this.isFlutterEngineFromActivity) {
            this.flutterEngine.destroy();
            this.flutterEngine = null;
        }
    }

    protected boolean retainFlutterEngineAfterFragmentDestruction() {
        return false;
    }

    protected boolean shouldAttachEngineToActivity() {
        return this.getArguments().getBoolean(ARG_SHOULD_ATTACH_ENGINE_TO_ACTIVITY);
    }

    public void onBackPressed() {
        if (this.flutterEngine != null) {
            Log.v(TAG, "Forwarding onBackPressed() to FlutterEngine.");
            this.flutterEngine.getNavigationChannel().popRoute();
        } else {
            Log.w(TAG, "Invoked onBackPressed() before FlutterFragment was attached to an Activity.");
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (this.flutterEngine != null) {
            Log.v(TAG, "Forwarding onRequestPermissionsResult() to FlutterEngine:\nrequestCode: " + requestCode + "\npermissions: " + Arrays.toString(permissions) + "\ngrantResults: " + Arrays.toString(grantResults));
            this.flutterEngine.getActivityControlSurface().onRequestPermissionsResult(requestCode, permissions, grantResults);
        } else {
            Log.w(TAG, "onRequestPermissionResult() invoked before FlutterFragment was attached to an Activity.");
        }
    }

    public void onNewIntent(@NonNull Intent intent) {
        if (this.flutterEngine != null) {
            Log.v(TAG, "Forwarding onNewIntent() to FlutterEngine.");
            this.flutterEngine.getActivityControlSurface().onNewIntent(intent);
        } else {
            Log.w(TAG, "onNewIntent() invoked before FlutterFragment was attached to an Activity.");
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.flutterEngine != null) {
            Log.v(TAG, "Forwarding onActivityResult() to FlutterEngine:\nrequestCode: " + requestCode + "\nresultCode: " + resultCode + "\ndata: " + data);
            this.flutterEngine.getActivityControlSurface().onActivityResult(requestCode, resultCode, data);
        } else {
            Log.w(TAG, "onActivityResult() invoked before FlutterFragment was attached to an Activity.");
        }
    }

    public void onUserLeaveHint() {
        if (this.flutterEngine != null) {
            Log.v(TAG, "Forwarding onUserLeaveHint() to FlutterEngine.");
            this.flutterEngine.getActivityControlSurface().onUserLeaveHint();
        } else {
            Log.w(TAG, "onUserLeaveHint() invoked before FlutterFragment was attached to an Activity.");
        }
    }

    public void onTrimMemory(int level) {
        if (this.flutterEngine != null) {
            if (level == 10) {
                Log.v(TAG, "Forwarding onTrimMemory() to FlutterEngine. Level: " + level);
                this.flutterEngine.getSystemChannel().sendMemoryPressureWarning();
            }
        } else {
            Log.w(TAG, "onTrimMemory() invoked before FlutterFragment was attached to an Activity.");
        }
    }

    public void onLowMemory() {
        super.onLowMemory();
        Log.v(TAG, "Forwarding onLowMemory() to FlutterEngine.");
        this.flutterEngine.getSystemChannel().sendMemoryPressureWarning();
    }

    @NonNull
    private Context getContextCompat() {
        return Build.VERSION.SDK_INT >= 23 ? this.getContext() : this.getActivity();
    }

    protected void onFirstFrameRendered() {
    }

    public static interface FlutterEngineProvider {
        @Nullable
        public FlutterEngine getFlutterEngine(@NonNull Context var1);
    }

    public static class Builder {
        private final Class<? extends FlutterFragment> fragmentClass;
        private String dartEntrypoint = "main";
        private String initialRoute = "/";
        private String appBundlePath = null;
        private FlutterShellArgs shellArgs = null;
        private FlutterView.RenderMode renderMode = FlutterView.RenderMode.surface;
        private FlutterView.TransparencyMode transparencyMode = FlutterView.TransparencyMode.transparent;
        private boolean shouldAttachEngineToActivity = true;

        public Builder() {
            this.fragmentClass = FlutterFragment.class;
        }

        public Builder(@NonNull Class<? extends FlutterFragment> subclass) {
            this.fragmentClass = subclass;
        }

        @NonNull
        public Builder dartEntrypoint(@NonNull String dartEntrypoint) {
            this.dartEntrypoint = dartEntrypoint;
            return this;
        }

        @NonNull
        public Builder initialRoute(@NonNull String initialRoute) {
            this.initialRoute = initialRoute;
            return this;
        }

        @NonNull
        public Builder appBundlePath(@NonNull String appBundlePath) {
            this.appBundlePath = appBundlePath;
            return this;
        }

        @NonNull
        public Builder flutterShellArgs(@NonNull FlutterShellArgs shellArgs) {
            this.shellArgs = shellArgs;
            return this;
        }

        @NonNull
        public Builder renderMode(@NonNull FlutterView.RenderMode renderMode) {
            this.renderMode = renderMode;
            return this;
        }

        @NonNull
        public Builder transparencyMode(@NonNull FlutterView.TransparencyMode transparencyMode) {
            this.transparencyMode = transparencyMode;
            return this;
        }

        @NonNull
        public Builder shouldAttachEngineToActivity(boolean shouldAttachEngineToActivity) {
            this.shouldAttachEngineToActivity = shouldAttachEngineToActivity;
            return this;
        }

        @NonNull
        protected Bundle createArgs() {
            Bundle args = new Bundle();
            args.putString(FlutterFragment.ARG_INITIAL_ROUTE, this.initialRoute);
            args.putString(FlutterFragment.ARG_APP_BUNDLE_PATH, this.appBundlePath);
            args.putString(FlutterFragment.ARG_DART_ENTRYPOINT, this.dartEntrypoint);
            if (null != this.shellArgs) {
                args.putStringArray(FlutterFragment.ARG_FLUTTER_INITIALIZATION_ARGS, this.shellArgs.toArray());
            }
            args.putString(FlutterFragment.ARG_FLUTTERVIEW_RENDER_MODE, this.renderMode != null ? this.renderMode.name() : FlutterView.RenderMode.surface.name());
            args.putString(FlutterFragment.ARG_FLUTTERVIEW_TRANSPARENCY_MODE, this.transparencyMode != null ? this.transparencyMode.name() : FlutterView.TransparencyMode.transparent.name());
            args.putBoolean(FlutterFragment.ARG_SHOULD_ATTACH_ENGINE_TO_ACTIVITY, this.shouldAttachEngineToActivity);
            return args;
        }

        @NonNull
        public <T extends FlutterFragment> T build() {
            try {
                FlutterFragment frag = this.fragmentClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (frag == null) {
                    throw new RuntimeException("The FlutterFragment subclass sent in the constructor (" + this.fragmentClass.getCanonicalName() + ") does not match the expected return type.");
                }
                Bundle args = this.createArgs();
                frag.setArguments(args);
                return (T)((Object)frag);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instantiate FlutterFragment subclass (" + this.fragmentClass.getName() + ")", e);
            }
        }
    }
}

