// Copyright (c) 2014, the Dart project authors.
// Please see the AUTHORS file
// for details. All rights reserved. Use of this source code
// is governed by a
// BSD-style license that can be found in the LICENSE file.

/// Date/time formatting symbols for all locales.
///
/// DO NOT EDIT. This file is autogenerated by script.  See
/// 'http://go/generate_datetime_constants.py' using the --for_dart
/// flag.
/// File generated from CLDR ver. 33
///
/// Before checkin, this file could have been manually edited. This is
/// to incorporate changes before we could correct CLDR. All manual
/// modification must be documented in this section, and should be
/// removed after those changes land to CLDR.
library date_symbol_data_local;

import "date_symbols.dart";
import "src/date_format_internal.dart";
import "date_time_patterns.dart";
import "dart:async";

/// This should be called for at least one [locale] before any date
/// formatting methods are called. It sets up the lookup for date
/// symbols. Both the [locale] and [ignored] parameter are ignored, as
/// the data for all locales is directly available.
Future initializeDateFormatting([String locale, String ignored]) {
  initializeDateSymbols(dateTimeSymbolMap);
  initializeDatePatterns(dateTimePatternMap);
  return new Future.value(null);
}

/// Returns a Map from locale names to the DateSymbols instance for
/// that locale. Internal use only. Call initializeDateFormatting
/// instead.
Map dateTimeSymbolMap() => {
      // Date/time formatting symbols for locale en_ISO.
      "en_ISO": new DateSymbols(
          NAME: 'en_ISO',
          ERAS: const ['BC', 'AD'],
          ERANAMES: const ['Before Christ', 'Anno Domini'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'January',
            'February',
            'March',
            'April',
            'May',
            'June',
            'July',
            'August',
            'September',
            'October',
            'November',
            'December'
          ],
          STANDALONEMONTHS: const [
            'January',
            'February',
            'March',
            'April',
            'May',
            'June',
            'July',
            'August',
            'September',
            'October',
            'November',
            'December'
          ],
          SHORTMONTHS: const [
            'Jan',
            'Feb',
            'Mar',
            'Apr',
            'May',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Oct',
            'Nov',
            'Dec'
          ],
          STANDALONESHORTMONTHS: const [
            'Jan',
            'Feb',
            'Mar',
            'Apr',
            'May',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Oct',
            'Nov',
            'Dec'
          ],
          WEEKDAYS: const [
            'Sunday',
            'Monday',
            'Tuesday',
            'Wednesday',
            'Thursday',
            'Friday',
            'Saturday'
          ],
          STANDALONEWEEKDAYS: const [
            'Sunday',
            'Monday',
            'Tuesday',
            'Wednesday',
            'Thursday',
            'Friday',
            'Saturday'
          ],
          SHORTWEEKDAYS: const [
            'Sun',
            'Mon',
            'Tue',
            'Wed',
            'Thu',
            'Fri',
            'Sat'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'Sun',
            'Mon',
            'Tue',
            'Wed',
            'Thu',
            'Fri',
            'Sat'
          ],
          NARROWWEEKDAYS: const ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
          STANDALONENARROWWEEKDAYS: const ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
          SHORTQUARTERS: const ['Q1', 'Q2', 'Q3', 'Q4'],
          QUARTERS: const [
            '1st quarter',
            '2nd quarter',
            '3rd quarter',
            '4th quarter'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'EEEE, y MMMM dd',
            'y MMMM d',
            'y MMM d',
            'yyyy-MM-dd'
          ],
          TIMEFORMATS: const ['HH:mm:ss v', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
          DATETIMEFORMATS: const [
            '{1} \'at\' {0}',
            '{1} \'at\' {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),

      // Date/time formatting symbols for locale af.
      "af": new DateSymbols(
          NAME: "af",
          ERAS: const ['v.C.', 'n.C.'],
          ERANAMES: const ['voor Christus', 'na Christus'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'Januarie',
            'Februarie',
            'Maart',
            'April',
            'Mei',
            'Junie',
            'Julie',
            'Augustus',
            'September',
            'Oktober',
            'November',
            'Desember'
          ],
          STANDALONEMONTHS: const [
            'Januarie',
            'Februarie',
            'Maart',
            'April',
            'Mei',
            'Junie',
            'Julie',
            'Augustus',
            'September',
            'Oktober',
            'November',
            'Desember'
          ],
          SHORTMONTHS: const [
            'Jan.',
            'Feb.',
            'Mrt.',
            'Apr.',
            'Mei',
            'Jun.',
            'Jul.',
            'Aug.',
            'Sep.',
            'Okt.',
            'Nov.',
            'Des.'
          ],
          STANDALONESHORTMONTHS: const [
            'Jan.',
            'Feb.',
            'Mrt.',
            'Apr.',
            'Mei',
            'Jun.',
            'Jul.',
            'Aug.',
            'Sep.',
            'Okt.',
            'Nov.',
            'Des.'
          ],
          WEEKDAYS: const [
            'Sondag',
            'Maandag',
            'Dinsdag',
            'Woensdag',
            'Donderdag',
            'Vrydag',
            'Saterdag'
          ],
          STANDALONEWEEKDAYS: const [
            'Sondag',
            'Maandag',
            'Dinsdag',
            'Woensdag',
            'Donderdag',
            'Vrydag',
            'Saterdag'
          ],
          SHORTWEEKDAYS: const [
            'So.',
            'Ma.',
            'Di.',
            'Wo.',
            'Do.',
            'Vr.',
            'Sa.'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'So.',
            'Ma.',
            'Di.',
            'Wo.',
            'Do.',
            'Vr.',
            'Sa.'
          ],
          NARROWWEEKDAYS: const ['S', 'M', 'D', 'W', 'D', 'V', 'S'],
          STANDALONENARROWWEEKDAYS: const ['S', 'M', 'D', 'W', 'D', 'V', 'S'],
          SHORTQUARTERS: const ['K1', 'K2', 'K3', 'K4'],
          QUARTERS: const [
            '1ste kwartaal',
            '2de kwartaal',
            '3de kwartaal',
            '4de kwartaal'
          ],
          AMPMS: const ['vm.', 'nm.'],
          DATEFORMATS: const [
            'EEEE, dd MMMM y',
            'dd MMMM y',
            'dd MMM y',
            'y-MM-dd'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale am.
      "am": new DateSymbols(
          NAME: "am",
          ERAS: const ['ዓ/ዓ', 'ዓ/ም'],
          ERANAMES: const ['ዓመተ ዓለም', 'ዓመተ ምሕረት'],
          NARROWMONTHS: const [
            'ጃ',
            'ፌ',
            'ማ',
            'ኤ',
            'ሜ',
            'ጁ',
            'ጁ',
            'ኦ',
            'ሴ',
            'ኦ',
            'ኖ',
            'ዲ'
          ],
          STANDALONENARROWMONTHS: const [
            'ጃ',
            'ፌ',
            'ማ',
            'ኤ',
            'ሜ',
            'ጁ',
            'ጁ',
            'ኦ',
            'ሴ',
            'ኦ',
            'ኖ',
            'ዲ'
          ],
          MONTHS: const [
            'ጃንዩወሪ',
            'ፌብሩወሪ',
            'ማርች',
            'ኤፕሪል',
            'ሜይ',
            'ጁን',
            'ጁላይ',
            'ኦገስት',
            'ሴፕቴምበር',
            'ኦክቶበር',
            'ኖቬምበር',
            'ዲሴምበር'
          ],
          STANDALONEMONTHS: const [
            'ጃንዩወሪ',
            'ፌብሩወሪ',
            'ማርች',
            'ኤፕሪል',
            'ሜይ',
            'ጁን',
            'ጁላይ',
            'ኦገስት',
            'ሴፕቴምበር',
            'ኦክቶበር',
            'ኖቬምበር',
            'ዲሴምበር'
          ],
          SHORTMONTHS: const [
            'ጃንዩ',
            'ፌብሩ',
            'ማርች',
            'ኤፕሪ',
            'ሜይ',
            'ጁን',
            'ጁላይ',
            'ኦገስ',
            'ሴፕቴ',
            'ኦክቶ',
            'ኖቬም',
            'ዲሴም'
          ],
          STANDALONESHORTMONTHS: const [
            'ጃንዩ',
            'ፌብሩ',
            'ማርች',
            'ኤፕሪ',
            'ሜይ',
            'ጁን',
            'ጁላይ',
            'ኦገስ',
            'ሴፕቴ',
            'ኦክቶ',
            'ኖቬም',
            'ዲሴም'
          ],
          WEEKDAYS: const ['እሑድ', 'ሰኞ', 'ማክሰኞ', 'ረቡዕ', 'ሐሙስ', 'ዓርብ', 'ቅዳሜ'],
          STANDALONEWEEKDAYS: const [
            'እሑድ',
            'ሰኞ',
            'ማክሰኞ',
            'ረቡዕ',
            'ሐሙስ',
            'ዓርብ',
            'ቅዳሜ'
          ],
          SHORTWEEKDAYS: const ['እሑድ', 'ሰኞ', 'ማክሰ', 'ረቡዕ', 'ሐሙስ', 'ዓርብ', 'ቅዳሜ'],
          STANDALONESHORTWEEKDAYS: const [
            'እሑድ',
            'ሰኞ',
            'ማክሰ',
            'ረቡዕ',
            'ሐሙስ',
            'ዓርብ',
            'ቅዳሜ'
          ],
          NARROWWEEKDAYS: const ['እ', 'ሰ', 'ማ', 'ረ', 'ሐ', 'ዓ', 'ቅ'],
          STANDALONENARROWWEEKDAYS: const ['እ', 'ሰ', 'ማ', 'ረ', 'ሐ', 'ዓ', 'ቅ'],
          SHORTQUARTERS: const ['ሩብ1', 'ሩብ2', 'ሩብ3', 'ሩብ4'],
          QUARTERS: const ['1ኛው ሩብ', '2ኛው ሩብ', '3ኛው ሩብ', '4ኛው ሩብ'],
          AMPMS: const ['ጥዋት', 'ከሰዓት'],
          DATEFORMATS: const [
            'EEEE ፣d MMMM y',
            'd MMMM y',
            'd MMM y',
            'dd/MM/y'
          ],
          TIMEFORMATS: const [
            'h:mm:ss a zzzz',
            'h:mm:ss a z',
            'h:mm:ss a',
            'h:mm a'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale ar.
      "ar": new DateSymbols(
          NAME: "ar",
          ZERODIGIT: '\u0660',
          ERAS: const ['ق.م', 'م'],
          ERANAMES: const ['قبل الميلاد', 'ميلادي'],
          NARROWMONTHS: const [
            'ي',
            'ف',
            'م',
            'أ',
            'و',
            'ن',
            'ل',
            'غ',
            'س',
            'ك',
            'ب',
            'د'
          ],
          STANDALONENARROWMONTHS: const [
            'ي',
            'ف',
            'م',
            'أ',
            'و',
            'ن',
            'ل',
            'غ',
            'س',
            'ك',
            'ب',
            'د'
          ],
          MONTHS: const [
            'يناير',
            'فبراير',
            'مارس',
            'أبريل',
            'مايو',
            'يونيو',
            'يوليو',
            'أغسطس',
            'سبتمبر',
            'أكتوبر',
            'نوفمبر',
            'ديسمبر'
          ],
          STANDALONEMONTHS: const [
            'يناير',
            'فبراير',
            'مارس',
            'أبريل',
            'مايو',
            'يونيو',
            'يوليو',
            'أغسطس',
            'سبتمبر',
            'أكتوبر',
            'نوفمبر',
            'ديسمبر'
          ],
          SHORTMONTHS: const [
            'يناير',
            'فبراير',
            'مارس',
            'أبريل',
            'مايو',
            'يونيو',
            'يوليو',
            'أغسطس',
            'سبتمبر',
            'أكتوبر',
            'نوفمبر',
            'ديسمبر'
          ],
          STANDALONESHORTMONTHS: const [
            'يناير',
            'فبراير',
            'مارس',
            'أبريل',
            'مايو',
            'يونيو',
            'يوليو',
            'أغسطس',
            'سبتمبر',
            'أكتوبر',
            'نوفمبر',
            'ديسمبر'
          ],
          WEEKDAYS: const [
            'الأحد',
            'الاثنين',
            'الثلاثاء',
            'الأربعاء',
            'الخميس',
            'الجمعة',
            'السبت'
          ],
          STANDALONEWEEKDAYS: const [
            'الأحد',
            'الاثنين',
            'الثلاثاء',
            'الأربعاء',
            'الخميس',
            'الجمعة',
            'السبت'
          ],
          SHORTWEEKDAYS: const [
            'الأحد',
            'الاثنين',
            'الثلاثاء',
            'الأربعاء',
            'الخميس',
            'الجمعة',
            'السبت'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'الأحد',
            'الاثنين',
            'الثلاثاء',
            'الأربعاء',
            'الخميس',
            'الجمعة',
            'السبت'
          ],
          NARROWWEEKDAYS: const ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
          STANDALONENARROWWEEKDAYS: const ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
          SHORTQUARTERS: const [
            'الربع الأول',
            'الربع الثاني',
            'الربع الثالث',
            'الربع الرابع'
          ],
          QUARTERS: const [
            'الربع الأول',
            'الربع الثاني',
            'الربع الثالث',
            'الربع الرابع'
          ],
          AMPMS: const ['ص', 'م'],
          DATEFORMATS: const [
            'EEEE، d MMMM y',
            'd MMMM y',
            'dd‏/MM‏/y',
            'd‏/M‏/y'
          ],
          TIMEFORMATS: const [
            'h:mm:ss a zzzz',
            'h:mm:ss a z',
            'h:mm:ss a',
            'h:mm a'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 5,
          WEEKENDRANGE: const [4, 5],
          FIRSTWEEKCUTOFFDAY: 4),
      // Date/time formatting symbols for locale ar_DZ.
      "ar_DZ": new DateSymbols(
          NAME: "ar_DZ",
          ERAS: const ['ق.م', 'م'],
          ERANAMES: const ['قبل الميلاد', 'ميلادي'],
          NARROWMONTHS: const [
            'ج',
            'ف',
            'م',
            'أ',
            'م',
            'ج',
            'ج',
            'أ',
            'س',
            'أ',
            'ن',
            'د'
          ],
          STANDALONENARROWMONTHS: const [
            'ج',
            'ف',
            'م',
            'أ',
            'م',
            'ج',
            'ج',
            'أ',
            'س',
            'أ',
            'ن',
            'د'
          ],
          MONTHS: const [
            'جانفي',
            'فيفري',
            'مارس',
            'أفريل',
            'ماي',
            'جوان',
            'جويلية',
            'أوت',
            'سبتمبر',
            'أكتوبر',
            'نوفمبر',
            'ديسمبر'
          ],
          STANDALONEMONTHS: const [
            'جانفي',
            'فيفري',
            'مارس',
            'أفريل',
            'ماي',
            'جوان',
            'جويلية',
            'أوت',
            'سبتمبر',
            'أكتوبر',
            'نوفمبر',
            'ديسمبر'
          ],
          SHORTMONTHS: const [
            'جانفي',
            'فيفري',
            'مارس',
            'أفريل',
            'ماي',
            'جوان',
            'جويلية',
            'أوت',
            'سبتمبر',
            'أكتوبر',
            'نوفمبر',
            'ديسمبر'
          ],
          STANDALONESHORTMONTHS: const [
            'جانفي',
            'فيفري',
            'مارس',
            'أفريل',
            'ماي',
            'جوان',
            'جويلية',
            'أوت',
            'سبتمبر',
            'أكتوبر',
            'نوفمبر',
            'ديسمبر'
          ],
          WEEKDAYS: const [
            'الأحد',
            'الاثنين',
            'الثلاثاء',
            'الأربعاء',
            'الخميس',
            'الجمعة',
            'السبت'
          ],
          STANDALONEWEEKDAYS: const [
            'الأحد',
            'الاثنين',
            'الثلاثاء',
            'الأربعاء',
            'الخميس',
            'الجمعة',
            'السبت'
          ],
          SHORTWEEKDAYS: const [
            'الأحد',
            'الاثنين',
            'الثلاثاء',
            'الأربعاء',
            'الخميس',
            'الجمعة',
            'السبت'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'الأحد',
            'الاثنين',
            'الثلاثاء',
            'الأربعاء',
            'الخميس',
            'الجمعة',
            'السبت'
          ],
          NARROWWEEKDAYS: const ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
          STANDALONENARROWWEEKDAYS: const ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
          SHORTQUARTERS: const [
            'الربع الأول',
            'الربع الثاني',
            'الربع الثالث',
            'الربع الرابع'
          ],
          QUARTERS: const [
            'الربع الأول',
            'الربع الثاني',
            'الربع الثالث',
            'الربع الرابع'
          ],
          AMPMS: const ['ص', 'م'],
          DATEFORMATS: const [
            'EEEE، d MMMM y',
            'd MMMM y',
            'dd‏/MM‏/y',
            'd‏/M‏/y'
          ],
          TIMEFORMATS: const [
            'h:mm:ss a zzzz',
            'h:mm:ss a z',
            'h:mm:ss a',
            'h:mm a'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 5,
          WEEKENDRANGE: const [4, 5],
          FIRSTWEEKCUTOFFDAY: 4),
      // Date/time formatting symbols for locale ar_EG.
      // Date/time formatting symbols for locale ar_EG.
      "ar_EG": new DateSymbols(
          NAME: "ar_EG",
          ZERODIGIT: '\u0660',
          ERAS: const ['ق.م', 'م'],
          ERANAMES: const ['قبل الميلاد', 'ميلادي'],
          NARROWMONTHS: const [
            'ي',
            'ف',
            'م',
            'أ',
            'و',
            'ن',
            'ل',
            'غ',
            'س',
            'ك',
            'ب',
            'د'
          ],
          STANDALONENARROWMONTHS: const [
            'ي',
            'ف',
            'م',
            'أ',
            'و',
            'ن',
            'ل',
            'غ',
            'س',
            'ك',
            'ب',
            'د'
          ],
          MONTHS: const [
            'يناير',
            'فبراير',
            'مارس',
            'أبريل',
            'مايو',
            'يونيو',
            'يوليو',
            'أغسطس',
            'سبتمبر',
            'أكتوبر',
            'نوفمبر',
            'ديسمبر'
          ],
          STANDALONEMONTHS: const [
            'يناير',
            'فبراير',
            'مارس',
            'أبريل',
            'مايو',
            'يونيو',
            'يوليو',
            'أغسطس',
            'سبتمبر',
            'أكتوبر',
            'نوفمبر',
            'ديسمبر'
          ],
          SHORTMONTHS: const [
            'يناير',
            'فبراير',
            'مارس',
            'أبريل',
            'مايو',
            'يونيو',
            'يوليو',
            'أغسطس',
            'سبتمبر',
            'أكتوبر',
            'نوفمبر',
            'ديسمبر'
          ],
          STANDALONESHORTMONTHS: const [
            'يناير',
            'فبراير',
            'مارس',
            'أبريل',
            'مايو',
            'يونيو',
            'يوليو',
            'أغسطس',
            'سبتمبر',
            'أكتوبر',
            'نوفمبر',
            'ديسمبر'
          ],
          WEEKDAYS: const [
            'الأحد',
            'الاثنين',
            'الثلاثاء',
            'الأربعاء',
            'الخميس',
            'الجمعة',
            'السبت'
          ],
          STANDALONEWEEKDAYS: const [
            'الأحد',
            'الاثنين',
            'الثلاثاء',
            'الأربعاء',
            'الخميس',
            'الجمعة',
            'السبت'
          ],
          SHORTWEEKDAYS: const [
            'الأحد',
            'الاثنين',
            'الثلاثاء',
            'الأربعاء',
            'الخميس',
            'الجمعة',
            'السبت'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'الأحد',
            'الاثنين',
            'الثلاثاء',
            'الأربعاء',
            'الخميس',
            'الجمعة',
            'السبت'
          ],
          NARROWWEEKDAYS: const ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
          STANDALONENARROWWEEKDAYS: const ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
          SHORTQUARTERS: const [
            'الربع الأول',
            'الربع الثاني',
            'الربع الثالث',
            'الربع الرابع'
          ],
          QUARTERS: const [
            'الربع الأول',
            'الربع الثاني',
            'الربع الثالث',
            'الربع الرابع'
          ],
          AMPMS: const ['ص', 'م'],
          DATEFORMATS: const [
            'EEEE، d MMMM y',
            'd MMMM y',
            'dd‏/MM‏/y',
            'd‏/M‏/y'
          ],
          TIMEFORMATS: const [
            'h:mm:ss a zzzz',
            'h:mm:ss a z',
            'h:mm:ss a',
            'h:mm a'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 5,
          WEEKENDRANGE: const [4, 5],
          FIRSTWEEKCUTOFFDAY: 4),
      // Date/time formatting symbols for locale az.
      "az": new DateSymbols(
          NAME: "az",
          ERAS: const ['e.ə.', 'y.e.'],
          ERANAMES: const ['eramızdan əvvəl', 'yeni era'],
          NARROWMONTHS: const [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12'
          ],
          STANDALONENARROWMONTHS: const [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12'
          ],
          MONTHS: const [
            'yanvar',
            'fevral',
            'mart',
            'aprel',
            'may',
            'iyun',
            'iyul',
            'avqust',
            'sentyabr',
            'oktyabr',
            'noyabr',
            'dekabr'
          ],
          STANDALONEMONTHS: const [
            'Yanvar',
            'Fevral',
            'Mart',
            'Aprel',
            'May',
            'İyun',
            'İyul',
            'Avqust',
            'Sentyabr',
            'Oktyabr',
            'Noyabr',
            'Dekabr'
          ],
          SHORTMONTHS: const [
            'yan',
            'fev',
            'mar',
            'apr',
            'may',
            'iyn',
            'iyl',
            'avq',
            'sen',
            'okt',
            'noy',
            'dek'
          ],
          STANDALONESHORTMONTHS: const [
            'yan',
            'fev',
            'mar',
            'apr',
            'may',
            'iyn',
            'iyl',
            'avq',
            'sen',
            'okt',
            'noy',
            'dek'
          ],
          WEEKDAYS: const [
            'bazar',
            'bazar ertəsi',
            'çərşənbə axşamı',
            'çərşənbə',
            'cümə axşamı',
            'cümə',
            'şənbə'
          ],
          STANDALONEWEEKDAYS: const [
            'bazar',
            'bazar ertəsi',
            'çərşənbə axşamı',
            'çərşənbə',
            'cümə axşamı',
            'cümə',
            'şənbə'
          ],
          SHORTWEEKDAYS: const ['B.', 'B.E.', 'Ç.A.', 'Ç.', 'C.A.', 'C.', 'Ş.'],
          STANDALONESHORTWEEKDAYS: const [
            'B.',
            'B.E.',
            'Ç.A.',
            'Ç.',
            'C.A.',
            'C.',
            'Ş.'
          ],
          NARROWWEEKDAYS: const ['7', '1', '2', '3', '4', '5', '6'],
          STANDALONENARROWWEEKDAYS: const ['7', '1', '2', '3', '4', '5', '6'],
          SHORTQUARTERS: const ['1-ci kv.', '2-ci kv.', '3-cü kv.', '4-cü kv.'],
          QUARTERS: const [
            '1-ci kvartal',
            '2-ci kvartal',
            '3-cü kvartal',
            '4-cü kvartal'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'd MMMM y, EEEE',
            'd MMMM y',
            'd MMM y',
            'dd.MM.yy'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 6),
      // Date/time formatting symbols for locale be.
      "be": new DateSymbols(
          NAME: "be",
          ERAS: const ['да н.э.', 'н.э.'],
          ERANAMES: const ['да нараджэння Хрыстова', 'ад нараджэння Хрыстова'],
          NARROWMONTHS: const [
            'с',
            'л',
            'с',
            'к',
            'м',
            'ч',
            'л',
            'ж',
            'в',
            'к',
            'л',
            'с'
          ],
          STANDALONENARROWMONTHS: const [
            'с',
            'л',
            'с',
            'к',
            'м',
            'ч',
            'л',
            'ж',
            'в',
            'к',
            'л',
            'с'
          ],
          MONTHS: const [
            'студзеня',
            'лютага',
            'сакавіка',
            'красавіка',
            'мая',
            'чэрвеня',
            'ліпеня',
            'жніўня',
            'верасня',
            'кастрычніка',
            'лістапада',
            'снежня'
          ],
          STANDALONEMONTHS: const [
            'студзень',
            'люты',
            'сакавік',
            'красавік',
            'май',
            'чэрвень',
            'ліпень',
            'жнівень',
            'верасень',
            'кастрычнік',
            'лістапад',
            'снежань'
          ],
          SHORTMONTHS: const [
            'сту',
            'лют',
            'сак',
            'кра',
            'мая',
            'чэр',
            'ліп',
            'жні',
            'вер',
            'кас',
            'ліс',
            'сне'
          ],
          STANDALONESHORTMONTHS: const [
            'сту',
            'лют',
            'сак',
            'кра',
            'май',
            'чэр',
            'ліп',
            'жні',
            'вер',
            'кас',
            'ліс',
            'сне'
          ],
          WEEKDAYS: const [
            'нядзеля',
            'панядзелак',
            'аўторак',
            'серада',
            'чацвер',
            'пятніца',
            'субота'
          ],
          STANDALONEWEEKDAYS: const [
            'нядзеля',
            'панядзелак',
            'аўторак',
            'серада',
            'чацвер',
            'пятніца',
            'субота'
          ],
          SHORTWEEKDAYS: const ['нд', 'пн', 'аў', 'ср', 'чц', 'пт', 'сб'],
          STANDALONESHORTWEEKDAYS: const [
            'нд',
            'пн',
            'аў',
            'ср',
            'чц',
            'пт',
            'сб'
          ],
          NARROWWEEKDAYS: const ['н', 'п', 'а', 'с', 'ч', 'п', 'с'],
          STANDALONENARROWWEEKDAYS: const ['н', 'п', 'а', 'с', 'ч', 'п', 'с'],
          SHORTQUARTERS: const ['1-шы кв.', '2-гі кв.', '3-ці кв.', '4-ты кв.'],
          QUARTERS: const [
            '1-шы квартал',
            '2-гі квартал',
            '3-ці квартал',
            '4-ты квартал'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'EEEE, d MMMM y \'г\'.',
            'd MMMM y \'г\'.',
            'd.MM.y',
            'd.MM.yy'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss, zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const [
            '{1} \'у\' {0}',
            '{1} \'у\' {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 6),
      // Date/time formatting symbols for locale bg.
      "bg": new DateSymbols(
          NAME: "bg",
          ERAS: const ['пр.Хр.', 'сл.Хр.'],
          ERANAMES: const ['преди Христа', 'след Христа'],
          NARROWMONTHS: const [
            'я',
            'ф',
            'м',
            'а',
            'м',
            'ю',
            'ю',
            'а',
            'с',
            'о',
            'н',
            'д'
          ],
          STANDALONENARROWMONTHS: const [
            'я',
            'ф',
            'м',
            'а',
            'м',
            'ю',
            'ю',
            'а',
            'с',
            'о',
            'н',
            'д'
          ],
          MONTHS: const [
            'януари',
            'февруари',
            'март',
            'април',
            'май',
            'юни',
            'юли',
            'август',
            'септември',
            'октомври',
            'ноември',
            'декември'
          ],
          STANDALONEMONTHS: const [
            'януари',
            'февруари',
            'март',
            'април',
            'май',
            'юни',
            'юли',
            'август',
            'септември',
            'октомври',
            'ноември',
            'декември'
          ],
          SHORTMONTHS: const [
            'яну',
            'фев',
            'март',
            'апр',
            'май',
            'юни',
            'юли',
            'авг',
            'сеп',
            'окт',
            'ное',
            'дек'
          ],
          STANDALONESHORTMONTHS: const [
            'яну',
            'фев',
            'март',
            'апр',
            'май',
            'юни',
            'юли',
            'авг',
            'сеп',
            'окт',
            'ное',
            'дек'
          ],
          WEEKDAYS: const [
            'неделя',
            'понеделник',
            'вторник',
            'сряда',
            'четвъртък',
            'петък',
            'събота'
          ],
          STANDALONEWEEKDAYS: const [
            'неделя',
            'понеделник',
            'вторник',
            'сряда',
            'четвъртък',
            'петък',
            'събота'
          ],
          SHORTWEEKDAYS: const ['нд', 'пн', 'вт', 'ср', 'чт', 'пт', 'сб'],
          STANDALONESHORTWEEKDAYS: const [
            'нд',
            'пн',
            'вт',
            'ср',
            'чт',
            'пт',
            'сб'
          ],
          NARROWWEEKDAYS: const ['н', 'п', 'в', 'с', 'ч', 'п', 'с'],
          STANDALONENARROWWEEKDAYS: const ['н', 'п', 'в', 'с', 'ч', 'п', 'с'],
          SHORTQUARTERS: const ['1. трим.', '2. трим.', '3. трим.', '4. трим.'],
          QUARTERS: const [
            '1. тримесечие',
            '2. тримесечие',
            '3. тримесечие',
            '4. тримесечие'
          ],
          AMPMS: const ['пр.об.', 'сл.об.'],
          DATEFORMATS: const [
            'EEEE, d MMMM y \'г\'.',
            'd MMMM y \'г\'.',
            'd.MM.y \'г\'.',
            'd.MM.yy \'г\'.'
          ],
          TIMEFORMATS: const [
            'H:mm:ss \'ч\'. zzzz',
            'H:mm:ss \'ч\'. z',
            'H:mm:ss \'ч\'.',
            'H:mm \'ч\'.'
          ],
          DATETIMEFORMATS: const [
            '{1}, {0}',
            '{1}, {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale bn.
      "bn": new DateSymbols(
          NAME: "bn",
          ZERODIGIT: '\u09E6',
          ERAS: const ['খ্রিস্টপূর্ব', 'খৃষ্টাব্দ'],
          ERANAMES: const ['খ্রিস্টপূর্ব', 'খ্রীষ্টাব্দ'],
          NARROWMONTHS: const [
            'জা',
            'ফে',
            'মা',
            'এ',
            'মে',
            'জুন',
            'জু',
            'আ',
            'সে',
            'অ',
            'ন',
            'ডি'
          ],
          STANDALONENARROWMONTHS: const [
            'জা',
            'ফে',
            'মা',
            'এ',
            'মে',
            'জুন',
            'জু',
            'আ',
            'সে',
            'অ',
            'ন',
            'ডি'
          ],
          MONTHS: const [
            'জানুয়ারী',
            'ফেব্রুয়ারী',
            'মার্চ',
            'এপ্রিল',
            'মে',
            'জুন',
            'জুলাই',
            'আগস্ট',
            'সেপ্টেম্বর',
            'অক্টোবর',
            'নভেম্বর',
            'ডিসেম্বর'
          ],
          STANDALONEMONTHS: const [
            'জানুয়ারী',
            'ফেব্রুয়ারী',
            'মার্চ',
            'এপ্রিল',
            'মে',
            'জুন',
            'জুলাই',
            'আগস্ট',
            'সেপ্টেম্বর',
            'অক্টোবর',
            'নভেম্বর',
            'ডিসেম্বর'
          ],
          SHORTMONTHS: const [
            'জানু',
            'ফেব',
            'মার্চ',
            'এপ্রিল',
            'মে',
            'জুন',
            'জুলাই',
            'আগস্ট',
            'সেপ্টেম্বর',
            'অক্টোবর',
            'নভেম্বর',
            'ডিসেম্বর'
          ],
          STANDALONESHORTMONTHS: const [
            'জানুয়ারী',
            'ফেব্রুয়ারী',
            'মার্চ',
            'এপ্রিল',
            'মে',
            'জুন',
            'জুলাই',
            'আগস্ট',
            'সেপ্টেম্বর',
            'অক্টোবর',
            'নভেম্বর',
            'ডিসেম্বর'
          ],
          WEEKDAYS: const [
            'রবিবার',
            'সোমবার',
            'মঙ্গলবার',
            'বুধবার',
            'বৃহস্পতিবার',
            'শুক্রবার',
            'শনিবার'
          ],
          STANDALONEWEEKDAYS: const [
            'রবিবার',
            'সোমবার',
            'মঙ্গলবার',
            'বুধবার',
            'বৃহষ্পতিবার',
            'শুক্রবার',
            'শনিবার'
          ],
          SHORTWEEKDAYS: const [
            'রবি',
            'সোম',
            'মঙ্গল',
            'বুধ',
            'বৃহস্পতি',
            'শুক্র',
            'শনি'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'রবি',
            'সোম',
            'মঙ্গল',
            'বুধ',
            'বৃহস্পতি',
            'শুক্র',
            'শনি'
          ],
          NARROWWEEKDAYS: const ['র', 'সো', 'ম', 'বু', 'বৃ', 'শু', 'শ'],
          STANDALONENARROWWEEKDAYS: const [
            'র',
            'সো',
            'ম',
            'বু',
            'বৃ',
            'শু',
            'শ'
          ],
          SHORTQUARTERS: const ['Q1', 'Q2', 'Q3', 'Q4'],
          QUARTERS: const [
            'ত্রৈমাসিক',
            'দ্বিতীয় ত্রৈমাসিক',
            'তৃতীয় ত্রৈমাসিক',
            'চতুর্থ ত্রৈমাসিক'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'EEEE, d MMMM, y',
            'd MMMM, y',
            'd MMM, y',
            'd/M/yy'
          ],
          TIMEFORMATS: const [
            'h:mm:ss a zzzz',
            'h:mm:ss a z',
            'h:mm:ss a',
            'h:mm a'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale br.
      "br": new DateSymbols(
          NAME: "br",
          ERAS: const ['a-raok J.K.', 'goude J.K.'],
          ERANAMES: const ['a-raok Jezuz-Krist', 'goude Jezuz-Krist'],
          NARROWMONTHS: const [
            '01',
            '02',
            '03',
            '04',
            '05',
            '06',
            '07',
            '08',
            '09',
            '10',
            '11',
            '12'
          ],
          STANDALONENARROWMONTHS: const [
            '01',
            '02',
            '03',
            '04',
            '05',
            '06',
            '07',
            '08',
            '09',
            '10',
            '11',
            '12'
          ],
          MONTHS: const [
            'Genver',
            'Cʼhwevrer',
            'Meurzh',
            'Ebrel',
            'Mae',
            'Mezheven',
            'Gouere',
            'Eost',
            'Gwengolo',
            'Here',
            'Du',
            'Kerzu'
          ],
          STANDALONEMONTHS: const [
            'Genver',
            'Cʼhwevrer',
            'Meurzh',
            'Ebrel',
            'Mae',
            'Mezheven',
            'Gouere',
            'Eost',
            'Gwengolo',
            'Here',
            'Du',
            'Kerzu'
          ],
          SHORTMONTHS: const [
            'Gen.',
            'Cʼhwe.',
            'Meur.',
            'Ebr.',
            'Mae',
            'Mezh.',
            'Goue.',
            'Eost',
            'Gwen.',
            'Here',
            'Du',
            'Kzu.'
          ],
          STANDALONESHORTMONTHS: const [
            'Gen.',
            'Cʼhwe.',
            'Meur.',
            'Ebr.',
            'Mae',
            'Mezh.',
            'Goue.',
            'Eost',
            'Gwen.',
            'Here',
            'Du',
            'Kzu.'
          ],
          WEEKDAYS: const [
            'Sul',
            'Lun',
            'Meurzh',
            'Mercʼher',
            'Yaou',
            'Gwener',
            'Sadorn'
          ],
          STANDALONEWEEKDAYS: const [
            'Sul',
            'Lun',
            'Meurzh',
            'Mercʼher',
            'Yaou',
            'Gwener',
            'Sadorn'
          ],
          SHORTWEEKDAYS: const [
            'Sul',
            'Lun',
            'Meu.',
            'Mer.',
            'Yaou',
            'Gwe.',
            'Sad.'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'Sul',
            'Lun',
            'Meu.',
            'Mer.',
            'Yaou',
            'Gwe.',
            'Sad.'
          ],
          NARROWWEEKDAYS: const ['Su', 'L', 'Mz', 'Mc', 'Y', 'G', 'Sa'],
          STANDALONENARROWWEEKDAYS: const [
            'Su',
            'L',
            'Mz',
            'Mc',
            'Y',
            'G',
            'Sa'
          ],
          SHORTQUARTERS: const [
            '1añ trim.',
            '2l trim.',
            '3e trim.',
            '4e trim.'
          ],
          QUARTERS: const [
            '1añ trimiziad',
            '2l trimiziad',
            '3e trimiziad',
            '4e trimiziad'
          ],
          AMPMS: const ['A.M.', 'G.M.'],
          DATEFORMATS: const [
            'EEEE d MMMM y',
            'd MMMM y',
            'd MMM y',
            'dd/MM/y'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const [
            '{1} \'da\' {0}',
            '{1} \'da\' {0}',
            '{1}, {0}',
            '{1} {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 6),
      // Date/time formatting symbols for locale bs.
      "bs": new DateSymbols(
          NAME: "bs",
          ERAS: const ['p. n. e.', 'n. e.'],
          ERANAMES: const ['prije nove ere', 'nove ere'],
          NARROWMONTHS: const [
            'j',
            'f',
            'm',
            'a',
            'm',
            'j',
            'j',
            'a',
            's',
            'o',
            'n',
            'd'
          ],
          STANDALONENARROWMONTHS: const [
            'j',
            'f',
            'm',
            'a',
            'm',
            'j',
            'j',
            'a',
            's',
            'o',
            'n',
            'd'
          ],
          MONTHS: const [
            'januar',
            'februar',
            'mart',
            'april',
            'maj',
            'juni',
            'juli',
            'avgust',
            'septembar',
            'oktobar',
            'novembar',
            'decembar'
          ],
          STANDALONEMONTHS: const [
            'januar',
            'februar',
            'mart',
            'april',
            'maj',
            'juni',
            'juli',
            'avgust',
            'septembar',
            'oktobar',
            'novembar',
            'decembar'
          ],
          SHORTMONTHS: const [
            'jan',
            'feb',
            'mar',
            'apr',
            'maj',
            'jun',
            'jul',
            'avg',
            'sep',
            'okt',
            'nov',
            'dec'
          ],
          STANDALONESHORTMONTHS: const [
            'jan',
            'feb',
            'mar',
            'apr',
            'maj',
            'jun',
            'jul',
            'avg',
            'sep',
            'okt',
            'nov',
            'dec'
          ],
          WEEKDAYS: const [
            'nedjelja',
            'ponedjeljak',
            'utorak',
            'srijeda',
            'četvrtak',
            'petak',
            'subota'
          ],
          STANDALONEWEEKDAYS: const [
            'nedjelja',
            'ponedjeljak',
            'utorak',
            'srijeda',
            'četvrtak',
            'petak',
            'subota'
          ],
          SHORTWEEKDAYS: const [
            'ned',
            'pon',
            'uto',
            'sri',
            'čet',
            'pet',
            'sub'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'ned',
            'pon',
            'uto',
            'sri',
            'čet',
            'pet',
            'sub'
          ],
          NARROWWEEKDAYS: const ['N', 'P', 'U', 'S', 'Č', 'P', 'S'],
          STANDALONENARROWWEEKDAYS: const ['n', 'p', 'u', 's', 'č', 'p', 's'],
          SHORTQUARTERS: const ['KV1', 'KV2', 'KV3', 'KV4'],
          QUARTERS: const [
            'Prvi kvartal',
            'Drugi kvartal',
            'Treći kvartal',
            'Četvrti kvartal'
          ],
          AMPMS: const ['prijepodne', 'popodne'],
          DATEFORMATS: const [
            'EEEE, d. MMMM y.',
            'd. MMMM y.',
            'd. MMM y.',
            'd.M.yy.'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const [
            '{1} \'u\' {0}',
            '{1} \'u\' {0}',
            '{1} {0}',
            '{1} {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 6),
      // Date/time formatting symbols for locale ca.
      "ca": new DateSymbols(
          NAME: "ca",
          ERAS: const ['aC', 'dC'],
          ERANAMES: const ['abans de Crist', 'després de Crist'],
          NARROWMONTHS: const [
            'GN',
            'FB',
            'MÇ',
            'AB',
            'MG',
            'JN',
            'JL',
            'AG',
            'ST',
            'OC',
            'NV',
            'DS'
          ],
          STANDALONENARROWMONTHS: const [
            'GN',
            'FB',
            'MÇ',
            'AB',
            'MG',
            'JN',
            'JL',
            'AG',
            'ST',
            'OC',
            'NV',
            'DS'
          ],
          MONTHS: const [
            'de gener',
            'de febrer',
            'de març',
            'd’abril',
            'de maig',
            'de juny',
            'de juliol',
            'd’agost',
            'de setembre',
            'd’octubre',
            'de novembre',
            'de desembre'
          ],
          STANDALONEMONTHS: const [
            'gener',
            'febrer',
            'març',
            'abril',
            'maig',
            'juny',
            'juliol',
            'agost',
            'setembre',
            'octubre',
            'novembre',
            'desembre'
          ],
          SHORTMONTHS: const [
            'de gen.',
            'de febr.',
            'de març',
            'd’abr.',
            'de maig',
            'de juny',
            'de jul.',
            'd’ag.',
            'de set.',
            'd’oct.',
            'de nov.',
            'de des.'
          ],
          STANDALONESHORTMONTHS: const [
            'gen.',
            'febr.',
            'març',
            'abr.',
            'maig',
            'juny',
            'jul.',
            'ag.',
            'set.',
            'oct.',
            'nov.',
            'des.'
          ],
          WEEKDAYS: const [
            'diumenge',
            'dilluns',
            'dimarts',
            'dimecres',
            'dijous',
            'divendres',
            'dissabte'
          ],
          STANDALONEWEEKDAYS: const [
            'diumenge',
            'dilluns',
            'dimarts',
            'dimecres',
            'dijous',
            'divendres',
            'dissabte'
          ],
          SHORTWEEKDAYS: const [
            'dg.',
            'dl.',
            'dt.',
            'dc.',
            'dj.',
            'dv.',
            'ds.'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'dg.',
            'dl.',
            'dt.',
            'dc.',
            'dj.',
            'dv.',
            'ds.'
          ],
          NARROWWEEKDAYS: const ['dg', 'dl', 'dt', 'dc', 'dj', 'dv', 'ds'],
          STANDALONENARROWWEEKDAYS: const [
            'dg',
            'dl',
            'dt',
            'dc',
            'dj',
            'dv',
            'ds'
          ],
          SHORTQUARTERS: const ['1T', '2T', '3T', '4T'],
          QUARTERS: const [
            '1r trimestre',
            '2n trimestre',
            '3r trimestre',
            '4t trimestre'
          ],
          AMPMS: const ['a. m.', 'p. m.'],
          DATEFORMATS: const [
            'EEEE, d MMMM \'de\' y',
            'd MMMM \'de\' y',
            'd MMM y',
            'd/M/yy'
          ],
          TIMEFORMATS: const ['H:mm:ss zzzz', 'H:mm:ss z', 'H:mm:ss', 'H:mm'],
          DATETIMEFORMATS: const [
            '{1} \'a\' \'les\' {0}',
            '{1} \'a\' \'les\' {0}',
            '{1}, {0}',
            '{1} {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale chr.
      "chr": new DateSymbols(
          NAME: "chr",
          ERAS: const ['BC', 'AD'],
          ERANAMES: const ['ᏧᏓᎷᎸ ᎤᎷᎯᏍᏗ ᎦᎶᏁᏛ', 'ᎠᏃ ᏙᎻᏂ'],
          NARROWMONTHS: const [
            'Ꭴ',
            'Ꭷ',
            'Ꭰ',
            'Ꭷ',
            'Ꭰ',
            'Ꮥ',
            'Ꭻ',
            'Ꭶ',
            'Ꮪ',
            'Ꮪ',
            'Ꮕ',
            'Ꭵ'
          ],
          STANDALONENARROWMONTHS: const [
            'Ꭴ',
            'Ꭷ',
            'Ꭰ',
            'Ꭷ',
            'Ꭰ',
            'Ꮥ',
            'Ꭻ',
            'Ꭶ',
            'Ꮪ',
            'Ꮪ',
            'Ꮕ',
            'Ꭵ'
          ],
          MONTHS: const [
            'ᎤᏃᎸᏔᏅ',
            'ᎧᎦᎵ',
            'ᎠᏅᏱ',
            'ᎧᏬᏂ',
            'ᎠᏂᏍᎬᏘ',
            'ᏕᎭᎷᏱ',
            'ᎫᏰᏉᏂ',
            'ᎦᎶᏂ',
            'ᏚᎵᏍᏗ',
            'ᏚᏂᏅᏗ',
            'ᏅᏓᏕᏆ',
            'ᎥᏍᎩᏱ'
          ],
          STANDALONEMONTHS: const [
            'ᎤᏃᎸᏔᏅ',
            'ᎧᎦᎵ',
            'ᎠᏅᏱ',
            'ᎧᏬᏂ',
            'ᎠᏂᏍᎬᏘ',
            'ᏕᎭᎷᏱ',
            'ᎫᏰᏉᏂ',
            'ᎦᎶᏂ',
            'ᏚᎵᏍᏗ',
            'ᏚᏂᏅᏗ',
            'ᏅᏓᏕᏆ',
            'ᎥᏍᎩᏱ'
          ],
          SHORTMONTHS: const [
            'ᎤᏃ',
            'ᎧᎦ',
            'ᎠᏅ',
            'ᎧᏬ',
            'ᎠᏂ',
            'ᏕᎭ',
            'ᎫᏰ',
            'ᎦᎶ',
            'ᏚᎵ',
            'ᏚᏂ',
            'ᏅᏓ',
            'ᎥᏍ'
          ],
          STANDALONESHORTMONTHS: const [
            'ᎤᏃ',
            'ᎧᎦ',
            'ᎠᏅ',
            'ᎧᏬ',
            'ᎠᏂ',
            'ᏕᎭ',
            'ᎫᏰ',
            'ᎦᎶ',
            'ᏚᎵ',
            'ᏚᏂ',
            'ᏅᏓ',
            'ᎥᏍ'
          ],
          WEEKDAYS: const [
            'ᎤᎾᏙᏓᏆᏍᎬ',
            'ᎤᎾᏙᏓᏉᏅᎯ',
            'ᏔᎵᏁᎢᎦ',
            'ᏦᎢᏁᎢᎦ',
            'ᏅᎩᏁᎢᎦ',
            'ᏧᎾᎩᎶᏍᏗ',
            'ᎤᎾᏙᏓᏈᏕᎾ'
          ],
          STANDALONEWEEKDAYS: const [
            'ᎤᎾᏙᏓᏆᏍᎬ',
            'ᎤᎾᏙᏓᏉᏅᎯ',
            'ᏔᎵᏁᎢᎦ',
            'ᏦᎢᏁᎢᎦ',
            'ᏅᎩᏁᎢᎦ',
            'ᏧᎾᎩᎶᏍᏗ',
            'ᎤᎾᏙᏓᏈᏕᎾ'
          ],
          SHORTWEEKDAYS: const [
            'ᏆᏍᎬ',
            'ᏉᏅᎯ',
            'ᏔᎵᏁ',
            'ᏦᎢᏁ',
            'ᏅᎩᏁ',
            'ᏧᎾᎩ',
            'ᏈᏕᎾ'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'ᏆᏍᎬ',
            'ᏉᏅᎯ',
            'ᏔᎵᏁ',
            'ᏦᎢᏁ',
            'ᏅᎩᏁ',
            'ᏧᎾᎩ',
            'ᏈᏕᎾ'
          ],
          NARROWWEEKDAYS: const ['Ꮖ', 'Ꮙ', 'Ꮤ', 'Ꮶ', 'Ꮕ', 'Ꮷ', 'Ꭴ'],
          STANDALONENARROWWEEKDAYS: const ['Ꮖ', 'Ꮙ', 'Ꮤ', 'Ꮶ', 'Ꮕ', 'Ꮷ', 'Ꭴ'],
          SHORTQUARTERS: const ['Q1', 'Q2', 'Q3', 'Q4'],
          QUARTERS: const ['1st ᎩᏄᏙᏗ', '2nd ᎩᏄᏙᏗ', '3rd ᎩᏄᏙᏗ', '4th ᎩᏄᏙᏗ'],
          AMPMS: const ['ᏌᎾᎴ', 'ᏒᎯᏱᎢᏗᏢ'],
          DATEFORMATS: const [
            'EEEE, MMMM d, y',
            'MMMM d, y',
            'MMM d, y',
            'M/d/yy'
          ],
          TIMEFORMATS: const [
            'h:mm:ss a zzzz',
            'h:mm:ss a z',
            'h:mm:ss a',
            'h:mm a'
          ],
          DATETIMEFORMATS: const [
            '{1} ᎤᎾᎢ {0}',
            '{1} ᎤᎾᎢ {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 6),
      // Date/time formatting symbols for locale cs.
      "cs": new DateSymbols(
          NAME: "cs",
          ERAS: const ['př. n. l.', 'n. l.'],
          ERANAMES: const ['před naším letopočtem', 'našeho letopočtu'],
          NARROWMONTHS: const [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12'
          ],
          STANDALONENARROWMONTHS: const [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12'
          ],
          MONTHS: const [
            'ledna',
            'února',
            'března',
            'dubna',
            'května',
            'června',
            'července',
            'srpna',
            'září',
            'října',
            'listopadu',
            'prosince'
          ],
          STANDALONEMONTHS: const [
            'leden',
            'únor',
            'březen',
            'duben',
            'květen',
            'červen',
            'červenec',
            'srpen',
            'září',
            'říjen',
            'listopad',
            'prosinec'
          ],
          SHORTMONTHS: const [
            'led',
            'úno',
            'bře',
            'dub',
            'kvě',
            'čvn',
            'čvc',
            'srp',
            'zář',
            'říj',
            'lis',
            'pro'
          ],
          STANDALONESHORTMONTHS: const [
            'led',
            'úno',
            'bře',
            'dub',
            'kvě',
            'čvn',
            'čvc',
            'srp',
            'zář',
            'říj',
            'lis',
            'pro'
          ],
          WEEKDAYS: const [
            'neděle',
            'pondělí',
            'úterý',
            'středa',
            'čtvrtek',
            'pátek',
            'sobota'
          ],
          STANDALONEWEEKDAYS: const [
            'neděle',
            'pondělí',
            'úterý',
            'středa',
            'čtvrtek',
            'pátek',
            'sobota'
          ],
          SHORTWEEKDAYS: const ['ne', 'po', 'út', 'st', 'čt', 'pá', 'so'],
          STANDALONESHORTWEEKDAYS: const [
            'ne',
            'po',
            'út',
            'st',
            'čt',
            'pá',
            'so'
          ],
          NARROWWEEKDAYS: const ['N', 'P', 'Ú', 'S', 'Č', 'P', 'S'],
          STANDALONENARROWWEEKDAYS: const ['N', 'P', 'Ú', 'S', 'Č', 'P', 'S'],
          SHORTQUARTERS: const ['Q1', 'Q2', 'Q3', 'Q4'],
          QUARTERS: const [
            '1. čtvrtletí',
            '2. čtvrtletí',
            '3. čtvrtletí',
            '4. čtvrtletí'
          ],
          AMPMS: const ['dop.', 'odp.'],
          DATEFORMATS: const [
            'EEEE d. MMMM y',
            'd. MMMM y',
            'd. M. y',
            'dd.MM.yy'
          ],
          TIMEFORMATS: const ['H:mm:ss zzzz', 'H:mm:ss z', 'H:mm:ss', 'H:mm'],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale cy.
      "cy": new DateSymbols(
          NAME: "cy",
          ERAS: const ['CC', 'OC'],
          ERANAMES: const ['Cyn Crist', 'Oed Crist'],
          NARROWMONTHS: const [
            'I',
            'Ch',
            'M',
            'E',
            'M',
            'M',
            'G',
            'A',
            'M',
            'H',
            'T',
            'Rh'
          ],
          STANDALONENARROWMONTHS: const [
            'I',
            'Ch',
            'M',
            'E',
            'M',
            'M',
            'G',
            'A',
            'M',
            'H',
            'T',
            'Rh'
          ],
          MONTHS: const [
            'Ionawr',
            'Chwefror',
            'Mawrth',
            'Ebrill',
            'Mai',
            'Mehefin',
            'Gorffennaf',
            'Awst',
            'Medi',
            'Hydref',
            'Tachwedd',
            'Rhagfyr'
          ],
          STANDALONEMONTHS: const [
            'Ionawr',
            'Chwefror',
            'Mawrth',
            'Ebrill',
            'Mai',
            'Mehefin',
            'Gorffennaf',
            'Awst',
            'Medi',
            'Hydref',
            'Tachwedd',
            'Rhagfyr'
          ],
          SHORTMONTHS: const [
            'Ion',
            'Chwef',
            'Maw',
            'Ebrill',
            'Mai',
            'Meh',
            'Gorff',
            'Awst',
            'Medi',
            'Hyd',
            'Tach',
            'Rhag'
          ],
          STANDALONESHORTMONTHS: const [
            'Ion',
            'Chw',
            'Maw',
            'Ebr',
            'Mai',
            'Meh',
            'Gor',
            'Awst',
            'Medi',
            'Hyd',
            'Tach',
            'Rhag'
          ],
          WEEKDAYS: const [
            'Dydd Sul',
            'Dydd Llun',
            'Dydd Mawrth',
            'Dydd Mercher',
            'Dydd Iau',
            'Dydd Gwener',
            'Dydd Sadwrn'
          ],
          STANDALONEWEEKDAYS: const [
            'Dydd Sul',
            'Dydd Llun',
            'Dydd Mawrth',
            'Dydd Mercher',
            'Dydd Iau',
            'Dydd Gwener',
            'Dydd Sadwrn'
          ],
          SHORTWEEKDAYS: const [
            'Sul',
            'Llun',
            'Maw',
            'Mer',
            'Iau',
            'Gwen',
            'Sad'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'Sul',
            'Llun',
            'Maw',
            'Mer',
            'Iau',
            'Gwe',
            'Sad'
          ],
          NARROWWEEKDAYS: const ['S', 'Ll', 'M', 'M', 'I', 'G', 'S'],
          STANDALONENARROWWEEKDAYS: const ['S', 'Ll', 'M', 'M', 'I', 'G', 'S'],
          SHORTQUARTERS: const ['Ch1', 'Ch2', 'Ch3', 'Ch4'],
          QUARTERS: const [
            'chwarter 1af',
            '2il chwarter',
            '3ydd chwarter',
            '4ydd chwarter'
          ],
          AMPMS: const ['yb', 'yh'],
          DATEFORMATS: const [
            'EEEE, d MMMM y',
            'd MMMM y',
            'd MMM y',
            'dd/MM/yy'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const [
            '{1} \'am\' {0}',
            '{1} \'am\' {0}',
            '{1} {0}',
            '{1} {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale da.
      "da": new DateSymbols(
          NAME: "da",
          ERAS: const ['f.Kr.', 'e.Kr.'],
          ERANAMES: const ['f.Kr.', 'e.Kr.'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'januar',
            'februar',
            'marts',
            'april',
            'maj',
            'juni',
            'juli',
            'august',
            'september',
            'oktober',
            'november',
            'december'
          ],
          STANDALONEMONTHS: const [
            'januar',
            'februar',
            'marts',
            'april',
            'maj',
            'juni',
            'juli',
            'august',
            'september',
            'oktober',
            'november',
            'december'
          ],
          SHORTMONTHS: const [
            'jan.',
            'feb.',
            'mar.',
            'apr.',
            'maj',
            'jun.',
            'jul.',
            'aug.',
            'sep.',
            'okt.',
            'nov.',
            'dec.'
          ],
          STANDALONESHORTMONTHS: const [
            'jan.',
            'feb.',
            'mar.',
            'apr.',
            'maj',
            'jun.',
            'jul.',
            'aug.',
            'sep.',
            'okt.',
            'nov.',
            'dec.'
          ],
          WEEKDAYS: const [
            'søndag',
            'mandag',
            'tirsdag',
            'onsdag',
            'torsdag',
            'fredag',
            'lørdag'
          ],
          STANDALONEWEEKDAYS: const [
            'søndag',
            'mandag',
            'tirsdag',
            'onsdag',
            'torsdag',
            'fredag',
            'lørdag'
          ],
          SHORTWEEKDAYS: const [
            'søn.',
            'man.',
            'tir.',
            'ons.',
            'tor.',
            'fre.',
            'lør.'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'søn',
            'man',
            'tir',
            'ons',
            'tor',
            'fre',
            'lør'
          ],
          NARROWWEEKDAYS: const ['S', 'M', 'T', 'O', 'T', 'F', 'L'],
          STANDALONENARROWWEEKDAYS: const ['S', 'M', 'T', 'O', 'T', 'F', 'L'],
          SHORTQUARTERS: const ['1. kvt.', '2. kvt.', '3. kvt.', '4. kvt.'],
          QUARTERS: const [
            '1. kvartal',
            '2. kvartal',
            '3. kvartal',
            '4. kvartal'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'EEEE \'den\' d. MMMM y',
            'd. MMMM y',
            'd. MMM y',
            'dd/MM/y'
          ],
          TIMEFORMATS: const [
            'HH.mm.ss zzzz',
            'HH.mm.ss z',
            'HH.mm.ss',
            'HH.mm'
          ],
          DATETIMEFORMATS: const [
            '{1} \'kl\'. {0}',
            '{1} \'kl\'. {0}',
            '{1} {0}',
            '{1} {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale de.
      "de": new DateSymbols(
          NAME: "de",
          ERAS: const ['v. Chr.', 'n. Chr.'],
          ERANAMES: const ['v. Chr.', 'n. Chr.'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'Januar',
            'Februar',
            'März',
            'April',
            'Mai',
            'Juni',
            'Juli',
            'August',
            'September',
            'Oktober',
            'November',
            'Dezember'
          ],
          STANDALONEMONTHS: const [
            'Januar',
            'Februar',
            'März',
            'April',
            'Mai',
            'Juni',
            'Juli',
            'August',
            'September',
            'Oktober',
            'November',
            'Dezember'
          ],
          SHORTMONTHS: const [
            'Jan.',
            'Feb.',
            'März',
            'Apr.',
            'Mai',
            'Juni',
            'Juli',
            'Aug.',
            'Sep.',
            'Okt.',
            'Nov.',
            'Dez.'
          ],
          STANDALONESHORTMONTHS: const [
            'Jan',
            'Feb',
            'Mär',
            'Apr',
            'Mai',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Okt',
            'Nov',
            'Dez'
          ],
          WEEKDAYS: const [
            'Sonntag',
            'Montag',
            'Dienstag',
            'Mittwoch',
            'Donnerstag',
            'Freitag',
            'Samstag'
          ],
          STANDALONEWEEKDAYS: const [
            'Sonntag',
            'Montag',
            'Dienstag',
            'Mittwoch',
            'Donnerstag',
            'Freitag',
            'Samstag'
          ],
          SHORTWEEKDAYS: const [
            'So.',
            'Mo.',
            'Di.',
            'Mi.',
            'Do.',
            'Fr.',
            'Sa.'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'So',
            'Mo',
            'Di',
            'Mi',
            'Do',
            'Fr',
            'Sa'
          ],
          NARROWWEEKDAYS: const ['S', 'M', 'D', 'M', 'D', 'F', 'S'],
          STANDALONENARROWWEEKDAYS: const ['S', 'M', 'D', 'M', 'D', 'F', 'S'],
          SHORTQUARTERS: const ['Q1', 'Q2', 'Q3', 'Q4'],
          QUARTERS: const [
            '1. Quartal',
            '2. Quartal',
            '3. Quartal',
            '4. Quartal'
          ],
          AMPMS: const ['vorm.', 'nachm.'],
          DATEFORMATS: const [
            'EEEE, d. MMMM y',
            'd. MMMM y',
            'dd.MM.y',
            'dd.MM.yy'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const [
            '{1} \'um\' {0}',
            '{1} \'um\' {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale de_AT.
      "de_AT": new DateSymbols(
          NAME: "de_AT",
          ERAS: const ['v. Chr.', 'n. Chr.'],
          ERANAMES: const ['v. Chr.', 'n. Chr.'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'Jänner',
            'Februar',
            'März',
            'April',
            'Mai',
            'Juni',
            'Juli',
            'August',
            'September',
            'Oktober',
            'November',
            'Dezember'
          ],
          STANDALONEMONTHS: const [
            'Jänner',
            'Februar',
            'März',
            'April',
            'Mai',
            'Juni',
            'Juli',
            'August',
            'September',
            'Oktober',
            'November',
            'Dezember'
          ],
          SHORTMONTHS: const [
            'Jän.',
            'Feb.',
            'März',
            'Apr.',
            'Mai',
            'Juni',
            'Juli',
            'Aug.',
            'Sep.',
            'Okt.',
            'Nov.',
            'Dez.'
          ],
          STANDALONESHORTMONTHS: const [
            'Jän',
            'Feb',
            'Mär',
            'Apr',
            'Mai',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Okt',
            'Nov',
            'Dez'
          ],
          WEEKDAYS: const [
            'Sonntag',
            'Montag',
            'Dienstag',
            'Mittwoch',
            'Donnerstag',
            'Freitag',
            'Samstag'
          ],
          STANDALONEWEEKDAYS: const [
            'Sonntag',
            'Montag',
            'Dienstag',
            'Mittwoch',
            'Donnerstag',
            'Freitag',
            'Samstag'
          ],
          SHORTWEEKDAYS: const [
            'So.',
            'Mo.',
            'Di.',
            'Mi.',
            'Do.',
            'Fr.',
            'Sa.'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'So',
            'Mo',
            'Di',
            'Mi',
            'Do',
            'Fr',
            'Sa'
          ],
          NARROWWEEKDAYS: const ['S', 'M', 'D', 'M', 'D', 'F', 'S'],
          STANDALONENARROWWEEKDAYS: const ['S', 'M', 'D', 'M', 'D', 'F', 'S'],
          SHORTQUARTERS: const ['Q1', 'Q2', 'Q3', 'Q4'],
          QUARTERS: const [
            '1. Quartal',
            '2. Quartal',
            '3. Quartal',
            '4. Quartal'
          ],
          AMPMS: const ['vorm.', 'nachm.'],
          DATEFORMATS: const [
            'EEEE, d. MMMM y',
            'd. MMMM y',
            'dd.MM.y',
            'dd.MM.yy'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const [
            '{1} \'um\' {0}',
            '{1} \'um\' {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale de_CH.
      // Date/time formatting symbols for locale de_CH.
      "de_CH": new DateSymbols(
          NAME: "de_CH",
          ERAS: const ['v. Chr.', 'n. Chr.'],
          ERANAMES: const ['v. Chr.', 'n. Chr.'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'Januar',
            'Februar',
            'März',
            'April',
            'Mai',
            'Juni',
            'Juli',
            'August',
            'September',
            'Oktober',
            'November',
            'Dezember'
          ],
          STANDALONEMONTHS: const [
            'Januar',
            'Februar',
            'März',
            'April',
            'Mai',
            'Juni',
            'Juli',
            'August',
            'September',
            'Oktober',
            'November',
            'Dezember'
          ],
          SHORTMONTHS: const [
            'Jan.',
            'Feb.',
            'März',
            'Apr.',
            'Mai',
            'Juni',
            'Juli',
            'Aug.',
            'Sep.',
            'Okt.',
            'Nov.',
            'Dez.'
          ],
          STANDALONESHORTMONTHS: const [
            'Jan',
            'Feb',
            'Mär',
            'Apr',
            'Mai',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Okt',
            'Nov',
            'Dez'
          ],
          WEEKDAYS: const [
            'Sonntag',
            'Montag',
            'Dienstag',
            'Mittwoch',
            'Donnerstag',
            'Freitag',
            'Samstag'
          ],
          STANDALONEWEEKDAYS: const [
            'Sonntag',
            'Montag',
            'Dienstag',
            'Mittwoch',
            'Donnerstag',
            'Freitag',
            'Samstag'
          ],
          SHORTWEEKDAYS: const [
            'So.',
            'Mo.',
            'Di.',
            'Mi.',
            'Do.',
            'Fr.',
            'Sa.'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'So',
            'Mo',
            'Di',
            'Mi',
            'Do',
            'Fr',
            'Sa'
          ],
          NARROWWEEKDAYS: const ['S', 'M', 'D', 'M', 'D', 'F', 'S'],
          STANDALONENARROWWEEKDAYS: const ['S', 'M', 'D', 'M', 'D', 'F', 'S'],
          SHORTQUARTERS: const ['Q1', 'Q2', 'Q3', 'Q4'],
          QUARTERS: const [
            '1. Quartal',
            '2. Quartal',
            '3. Quartal',
            '4. Quartal'
          ],
          AMPMS: const ['vorm.', 'nachm.'],
          DATEFORMATS: const [
            'EEEE, d. MMMM y',
            'd. MMMM y',
            'dd.MM.y',
            'dd.MM.yy'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const [
            '{1} \'um\' {0}',
            '{1} \'um\' {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale el.
      "el": new DateSymbols(
          NAME: "el",
          ERAS: const ['π.Χ.', 'μ.Χ.'],
          ERANAMES: const ['προ Χριστού', 'μετά Χριστόν'],
          NARROWMONTHS: const [
            'Ι',
            'Φ',
            'Μ',
            'Α',
            'Μ',
            'Ι',
            'Ι',
            'Α',
            'Σ',
            'Ο',
            'Ν',
            'Δ'
          ],
          STANDALONENARROWMONTHS: const [
            'Ι',
            'Φ',
            'Μ',
            'Α',
            'Μ',
            'Ι',
            'Ι',
            'Α',
            'Σ',
            'Ο',
            'Ν',
            'Δ'
          ],
          MONTHS: const [
            'Ιανουαρίου',
            'Φεβρουαρίου',
            'Μαρτίου',
            'Απριλίου',
            'Μαΐου',
            'Ιουνίου',
            'Ιουλίου',
            'Αυγούστου',
            'Σεπτεμβρίου',
            'Οκτωβρίου',
            'Νοεμβρίου',
            'Δεκεμβρίου'
          ],
          STANDALONEMONTHS: const [
            'Ιανουάριος',
            'Φεβρουάριος',
            'Μάρτιος',
            'Απρίλιος',
            'Μάιος',
            'Ιούνιος',
            'Ιούλιος',
            'Αύγουστος',
            'Σεπτέμβριος',
            'Οκτώβριος',
            'Νοέμβριος',
            'Δεκέμβριος'
          ],
          SHORTMONTHS: const [
            'Ιαν',
            'Φεβ',
            'Μαρ',
            'Απρ',
            'Μαΐ',
            'Ιουν',
            'Ιουλ',
            'Αυγ',
            'Σεπ',
            'Οκτ',
            'Νοε',
            'Δεκ'
          ],
          STANDALONESHORTMONTHS: const [
            'Ιαν',
            'Φεβ',
            'Μάρ',
            'Απρ',
            'Μάι',
            'Ιούν',
            'Ιούλ',
            'Αύγ',
            'Σεπ',
            'Οκτ',
            'Νοέ',
            'Δεκ'
          ],
          WEEKDAYS: const [
            'Κυριακή',
            'Δευτέρα',
            'Τρίτη',
            'Τετάρτη',
            'Πέμπτη',
            'Παρασκευή',
            'Σάββατο'
          ],
          STANDALONEWEEKDAYS: const [
            'Κυριακή',
            'Δευτέρα',
            'Τρίτη',
            'Τετάρτη',
            'Πέμπτη',
            'Παρασκευή',
            'Σάββατο'
          ],
          SHORTWEEKDAYS: const [
            'Κυρ',
            'Δευ',
            'Τρί',
            'Τετ',
            'Πέμ',
            'Παρ',
            'Σάβ'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'Κυρ',
            'Δευ',
            'Τρί',
            'Τετ',
            'Πέμ',
            'Παρ',
            'Σάβ'
          ],
          NARROWWEEKDAYS: const ['Κ', 'Δ', 'Τ', 'Τ', 'Π', 'Π', 'Σ'],
          STANDALONENARROWWEEKDAYS: const ['Κ', 'Δ', 'Τ', 'Τ', 'Π', 'Π', 'Σ'],
          SHORTQUARTERS: const ['Τ1', 'Τ2', 'Τ3', 'Τ4'],
          QUARTERS: const [
            '1ο τρίμηνο',
            '2ο τρίμηνο',
            '3ο τρίμηνο',
            '4ο τρίμηνο'
          ],
          AMPMS: const ['π.μ.', 'μ.μ.'],
          DATEFORMATS: const [
            'EEEE, d MMMM y',
            'd MMMM y',
            'd MMM y',
            'd/M/yy'
          ],
          TIMEFORMATS: const [
            'h:mm:ss a zzzz',
            'h:mm:ss a z',
            'h:mm:ss a',
            'h:mm a'
          ],
          DATETIMEFORMATS: const [
            '{1} - {0}',
            '{1} - {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale en.
      "en": new DateSymbols(
          NAME: "en",
          ERAS: const ['BC', 'AD'],
          ERANAMES: const ['Before Christ', 'Anno Domini'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'January',
            'February',
            'March',
            'April',
            'May',
            'June',
            'July',
            'August',
            'September',
            'October',
            'November',
            'December'
          ],
          STANDALONEMONTHS: const [
            'January',
            'February',
            'March',
            'April',
            'May',
            'June',
            'July',
            'August',
            'September',
            'October',
            'November',
            'December'
          ],
          SHORTMONTHS: const [
            'Jan',
            'Feb',
            'Mar',
            'Apr',
            'May',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Oct',
            'Nov',
            'Dec'
          ],
          STANDALONESHORTMONTHS: const [
            'Jan',
            'Feb',
            'Mar',
            'Apr',
            'May',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Oct',
            'Nov',
            'Dec'
          ],
          WEEKDAYS: const [
            'Sunday',
            'Monday',
            'Tuesday',
            'Wednesday',
            'Thursday',
            'Friday',
            'Saturday'
          ],
          STANDALONEWEEKDAYS: const [
            'Sunday',
            'Monday',
            'Tuesday',
            'Wednesday',
            'Thursday',
            'Friday',
            'Saturday'
          ],
          SHORTWEEKDAYS: const [
            'Sun',
            'Mon',
            'Tue',
            'Wed',
            'Thu',
            'Fri',
            'Sat'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'Sun',
            'Mon',
            'Tue',
            'Wed',
            'Thu',
            'Fri',
            'Sat'
          ],
          NARROWWEEKDAYS: const ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
          STANDALONENARROWWEEKDAYS: const ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
          SHORTQUARTERS: const ['Q1', 'Q2', 'Q3', 'Q4'],
          QUARTERS: const [
            '1st quarter',
            '2nd quarter',
            '3rd quarter',
            '4th quarter'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'EEEE, MMMM d, y',
            'MMMM d, y',
            'MMM d, y',
            'M/d/yy'
          ],
          TIMEFORMATS: const [
            'h:mm:ss a zzzz',
            'h:mm:ss a z',
            'h:mm:ss a',
            'h:mm a'
          ],
          DATETIMEFORMATS: const [
            '{1} \'at\' {0}',
            '{1} \'at\' {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale en_AU.
      "en_AU": new DateSymbols(
          NAME: "en_AU",
          ERAS: const ['BC', 'AD'],
          ERANAMES: const ['Before Christ', 'Anno Domini'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'January',
            'February',
            'March',
            'April',
            'May',
            'June',
            'July',
            'August',
            'September',
            'October',
            'November',
            'December'
          ],
          STANDALONEMONTHS: const [
            'January',
            'February',
            'March',
            'April',
            'May',
            'June',
            'July',
            'August',
            'September',
            'October',
            'November',
            'December'
          ],
          SHORTMONTHS: const [
            'Jan.',
            'Feb.',
            'Mar.',
            'Apr.',
            'May',
            'Jun.',
            'Jul.',
            'Aug.',
            'Sep.',
            'Oct.',
            'Nov.',
            'Dec.'
          ],
          STANDALONESHORTMONTHS: const [
            'Jan.',
            'Feb.',
            'Mar.',
            'Apr.',
            'May',
            'Jun.',
            'Jul.',
            'Aug.',
            'Sep.',
            'Oct.',
            'Nov.',
            'Dec.'
          ],
          WEEKDAYS: const [
            'Sunday',
            'Monday',
            'Tuesday',
            'Wednesday',
            'Thursday',
            'Friday',
            'Saturday'
          ],
          STANDALONEWEEKDAYS: const [
            'Sunday',
            'Monday',
            'Tuesday',
            'Wednesday',
            'Thursday',
            'Friday',
            'Saturday'
          ],
          SHORTWEEKDAYS: const [
            'Sun.',
            'Mon.',
            'Tue.',
            'Wed.',
            'Thu.',
            'Fri.',
            'Sat.'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'Sun.',
            'Mon.',
            'Tue.',
            'Wed.',
            'Thu.',
            'Fri.',
            'Sat.'
          ],
          NARROWWEEKDAYS: const ['Su.', 'M.', 'Tu.', 'W.', 'Th.', 'F.', 'Sa.'],
          STANDALONENARROWWEEKDAYS: const [
            'Su.',
            'M.',
            'Tu.',
            'W.',
            'Th.',
            'F.',
            'Sa.'
          ],
          SHORTQUARTERS: const ['Q1', 'Q2', 'Q3', 'Q4'],
          QUARTERS: const [
            '1st quarter',
            '2nd quarter',
            '3rd quarter',
            '4th quarter'
          ],
          AMPMS: const ['am', 'pm'],
          DATEFORMATS: const [
            'EEEE, d MMMM y',
            'd MMMM y',
            'd MMM y',
            'd/M/yy'
          ],
          TIMEFORMATS: const [
            'h:mm:ss a zzzz',
            'h:mm:ss a z',
            'h:mm:ss a',
            'h:mm a'
          ],
          DATETIMEFORMATS: const [
            '{1} \'at\' {0}',
            '{1} \'at\' {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale en_CA.
      "en_CA": new DateSymbols(
          NAME: "en_CA",
          ERAS: const ['BC', 'AD'],
          ERANAMES: const ['Before Christ', 'Anno Domini'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'January',
            'February',
            'March',
            'April',
            'May',
            'June',
            'July',
            'August',
            'September',
            'October',
            'November',
            'December'
          ],
          STANDALONEMONTHS: const [
            'January',
            'February',
            'March',
            'April',
            'May',
            'June',
            'July',
            'August',
            'September',
            'October',
            'November',
            'December'
          ],
          SHORTMONTHS: const [
            'Jan.',
            'Feb.',
            'Mar.',
            'Apr.',
            'May',
            'Jun.',
            'Jul.',
            'Aug.',
            'Sep.',
            'Oct.',
            'Nov.',
            'Dec.'
          ],
          STANDALONESHORTMONTHS: const [
            'Jan',
            'Feb',
            'Mar',
            'Apr',
            'May',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Oct',
            'Nov',
            'Dec'
          ],
          WEEKDAYS: const [
            'Sunday',
            'Monday',
            'Tuesday',
            'Wednesday',
            'Thursday',
            'Friday',
            'Saturday'
          ],
          STANDALONEWEEKDAYS: const [
            'Sunday',
            'Monday',
            'Tuesday',
            'Wednesday',
            'Thursday',
            'Friday',
            'Saturday'
          ],
          SHORTWEEKDAYS: const [
            'Sun.',
            'Mon.',
            'Tue.',
            'Wed.',
            'Thu.',
            'Fri.',
            'Sat.'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'Sun.',
            'Mon.',
            'Tue.',
            'Wed.',
            'Thu.',
            'Fri.',
            'Sat.'
          ],
          NARROWWEEKDAYS: const ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
          STANDALONENARROWWEEKDAYS: const ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
          SHORTQUARTERS: const ['Q1', 'Q2', 'Q3', 'Q4'],
          QUARTERS: const [
            '1st quarter',
            '2nd quarter',
            '3rd quarter',
            '4th quarter'
          ],
          AMPMS: const ['a.m.', 'p.m.'],
          DATEFORMATS: const [
            'EEEE, MMMM d, y',
            'MMMM d, y',
            'MMM d, y',
            'y-MM-dd'
          ],
          TIMEFORMATS: const [
            'h:mm:ss a zzzz',
            'h:mm:ss a z',
            'h:mm:ss a',
            'h:mm a'
          ],
          DATETIMEFORMATS: const [
            '{1} \'at\' {0}',
            '{1} \'at\' {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale en_GB.
      "en_GB": new DateSymbols(
          NAME: "en_GB",
          ERAS: const ['BC', 'AD'],
          ERANAMES: const ['Before Christ', 'Anno Domini'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'January',
            'February',
            'March',
            'April',
            'May',
            'June',
            'July',
            'August',
            'September',
            'October',
            'November',
            'December'
          ],
          STANDALONEMONTHS: const [
            'January',
            'February',
            'March',
            'April',
            'May',
            'June',
            'July',
            'August',
            'September',
            'October',
            'November',
            'December'
          ],
          SHORTMONTHS: const [
            'Jan',
            'Feb',
            'Mar',
            'Apr',
            'May',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Oct',
            'Nov',
            'Dec'
          ],
          STANDALONESHORTMONTHS: const [
            'Jan',
            'Feb',
            'Mar',
            'Apr',
            'May',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Oct',
            'Nov',
            'Dec'
          ],
          WEEKDAYS: const [
            'Sunday',
            'Monday',
            'Tuesday',
            'Wednesday',
            'Thursday',
            'Friday',
            'Saturday'
          ],
          STANDALONEWEEKDAYS: const [
            'Sunday',
            'Monday',
            'Tuesday',
            'Wednesday',
            'Thursday',
            'Friday',
            'Saturday'
          ],
          SHORTWEEKDAYS: const [
            'Sun',
            'Mon',
            'Tue',
            'Wed',
            'Thu',
            'Fri',
            'Sat'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'Sun',
            'Mon',
            'Tue',
            'Wed',
            'Thu',
            'Fri',
            'Sat'
          ],
          NARROWWEEKDAYS: const ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
          STANDALONENARROWWEEKDAYS: const ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
          SHORTQUARTERS: const ['Q1', 'Q2', 'Q3', 'Q4'],
          QUARTERS: const [
            '1st quarter',
            '2nd quarter',
            '3rd quarter',
            '4th quarter'
          ],
          AMPMS: const ['am', 'pm'],
          DATEFORMATS: const [
            'EEEE, d MMMM y',
            'd MMMM y',
            'd MMM y',
            'dd/MM/y'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const [
            '{1} \'at\' {0}',
            '{1} \'at\' {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale en_IE.
      "en_IE": new DateSymbols(
          NAME: "en_IE",
          ERAS: const ['BC', 'AD'],
          ERANAMES: const ['Before Christ', 'Anno Domini'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'January',
            'February',
            'March',
            'April',
            'May',
            'June',
            'July',
            'August',
            'September',
            'October',
            'November',
            'December'
          ],
          STANDALONEMONTHS: const [
            'January',
            'February',
            'March',
            'April',
            'May',
            'June',
            'July',
            'August',
            'September',
            'October',
            'November',
            'December'
          ],
          SHORTMONTHS: const [
            'Jan',
            'Feb',
            'Mar',
            'Apr',
            'May',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Oct',
            'Nov',
            'Dec'
          ],
          STANDALONESHORTMONTHS: const [
            'Jan',
            'Feb',
            'Mar',
            'Apr',
            'May',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Oct',
            'Nov',
            'Dec'
          ],
          WEEKDAYS: const [
            'Sunday',
            'Monday',
            'Tuesday',
            'Wednesday',
            'Thursday',
            'Friday',
            'Saturday'
          ],
          STANDALONEWEEKDAYS: const [
            'Sunday',
            'Monday',
            'Tuesday',
            'Wednesday',
            'Thursday',
            'Friday',
            'Saturday'
          ],
          SHORTWEEKDAYS: const [
            'Sun',
            'Mon',
            'Tue',
            'Wed',
            'Thu',
            'Fri',
            'Sat'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'Sun',
            'Mon',
            'Tue',
            'Wed',
            'Thu',
            'Fri',
            'Sat'
          ],
          NARROWWEEKDAYS: const ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
          STANDALONENARROWWEEKDAYS: const ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
          SHORTQUARTERS: const ['Q1', 'Q2', 'Q3', 'Q4'],
          QUARTERS: const [
            '1st quarter',
            '2nd quarter',
            '3rd quarter',
            '4th quarter'
          ],
          AMPMS: const ['a.m.', 'p.m.'],
          DATEFORMATS: const [
            'EEEE d MMMM y',
            'd MMMM y',
            'd MMM y',
            'dd/MM/y'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const [
            '{1} \'at\' {0}',
            '{1} \'at\' {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 2),
      // Date/time formatting symbols for locale en_IN.
      "en_IN": new DateSymbols(
          NAME: "en_IN",
          ERAS: const ['BC', 'AD'],
          ERANAMES: const ['Before Christ', 'Anno Domini'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'January',
            'February',
            'March',
            'April',
            'May',
            'June',
            'July',
            'August',
            'September',
            'October',
            'November',
            'December'
          ],
          STANDALONEMONTHS: const [
            'January',
            'February',
            'March',
            'April',
            'May',
            'June',
            'July',
            'August',
            'September',
            'October',
            'November',
            'December'
          ],
          SHORTMONTHS: const [
            'Jan',
            'Feb',
            'Mar',
            'Apr',
            'May',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Oct',
            'Nov',
            'Dec'
          ],
          STANDALONESHORTMONTHS: const [
            'Jan',
            'Feb',
            'Mar',
            'Apr',
            'May',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Oct',
            'Nov',
            'Dec'
          ],
          WEEKDAYS: const [
            'Sunday',
            'Monday',
            'Tuesday',
            'Wednesday',
            'Thursday',
            'Friday',
            'Saturday'
          ],
          STANDALONEWEEKDAYS: const [
            'Sunday',
            'Monday',
            'Tuesday',
            'Wednesday',
            'Thursday',
            'Friday',
            'Saturday'
          ],
          SHORTWEEKDAYS: const [
            'Sun',
            'Mon',
            'Tue',
            'Wed',
            'Thu',
            'Fri',
            'Sat'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'Sun',
            'Mon',
            'Tue',
            'Wed',
            'Thu',
            'Fri',
            'Sat'
          ],
          NARROWWEEKDAYS: const ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
          STANDALONENARROWWEEKDAYS: const ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
          SHORTQUARTERS: const ['Q1', 'Q2', 'Q3', 'Q4'],
          QUARTERS: const [
            '1st quarter',
            '2nd quarter',
            '3rd quarter',
            '4th quarter'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'EEEE, d MMMM, y',
            'd MMMM y',
            'dd-MMM-y',
            'dd/MM/yy'
          ],
          TIMEFORMATS: const [
            'h:mm:ss a zzzz',
            'h:mm:ss a z',
            'h:mm:ss a',
            'h:mm a'
          ],
          DATETIMEFORMATS: const [
            '{1} \'at\' {0}',
            '{1} \'at\' {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [6, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale en_MY.
      "en_MY": new DateSymbols(
          NAME: "en_MY",
          ERAS: const ['BC', 'AD'],
          ERANAMES: const ['Before Christ', 'Anno Domini'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'January',
            'February',
            'March',
            'April',
            'May',
            'June',
            'July',
            'August',
            'September',
            'October',
            'November',
            'December'
          ],
          STANDALONEMONTHS: const [
            'January',
            'February',
            'March',
            'April',
            'May',
            'June',
            'July',
            'August',
            'September',
            'October',
            'November',
            'December'
          ],
          SHORTMONTHS: const [
            'Jan',
            'Feb',
            'Mar',
            'Apr',
            'May',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Oct',
            'Nov',
            'Dec'
          ],
          STANDALONESHORTMONTHS: const [
            'Jan',
            'Feb',
            'Mar',
            'Apr',
            'May',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Oct',
            'Nov',
            'Dec'
          ],
          WEEKDAYS: const [
            'Sunday',
            'Monday',
            'Tuesday',
            'Wednesday',
            'Thursday',
            'Friday',
            'Saturday'
          ],
          STANDALONEWEEKDAYS: const [
            'Sunday',
            'Monday',
            'Tuesday',
            'Wednesday',
            'Thursday',
            'Friday',
            'Saturday'
          ],
          SHORTWEEKDAYS: const [
            'Sun',
            'Mon',
            'Tue',
            'Wed',
            'Thu',
            'Fri',
            'Sat'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'Sun',
            'Mon',
            'Tue',
            'Wed',
            'Thu',
            'Fri',
            'Sat'
          ],
          NARROWWEEKDAYS: const ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
          STANDALONENARROWWEEKDAYS: const ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
          SHORTQUARTERS: const ['Q1', 'Q2', 'Q3', 'Q4'],
          QUARTERS: const [
            '1st quarter',
            '2nd quarter',
            '3rd quarter',
            '4th quarter'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'EEEE, d MMMM y',
            'd MMMM y',
            'd MMM y',
            'dd/MM/y'
          ],
          TIMEFORMATS: const [
            'h:mm:ss a zzzz',
            'h:mm:ss a z',
            'h:mm:ss a',
            'h:mm a'
          ],
          DATETIMEFORMATS: const [
            '{1} \'at\' {0}',
            '{1} \'at\' {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 6),
      // Date/time formatting symbols for locale en_SG.
      "en_SG": new DateSymbols(
          NAME: "en_SG",
          ERAS: const ['BC', 'AD'],
          ERANAMES: const ['Before Christ', 'Anno Domini'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'January',
            'February',
            'March',
            'April',
            'May',
            'June',
            'July',
            'August',
            'September',
            'October',
            'November',
            'December'
          ],
          STANDALONEMONTHS: const [
            'January',
            'February',
            'March',
            'April',
            'May',
            'June',
            'July',
            'August',
            'September',
            'October',
            'November',
            'December'
          ],
          SHORTMONTHS: const [
            'Jan',
            'Feb',
            'Mar',
            'Apr',
            'May',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Oct',
            'Nov',
            'Dec'
          ],
          STANDALONESHORTMONTHS: const [
            'Jan',
            'Feb',
            'Mar',
            'Apr',
            'May',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Oct',
            'Nov',
            'Dec'
          ],
          WEEKDAYS: const [
            'Sunday',
            'Monday',
            'Tuesday',
            'Wednesday',
            'Thursday',
            'Friday',
            'Saturday'
          ],
          STANDALONEWEEKDAYS: const [
            'Sunday',
            'Monday',
            'Tuesday',
            'Wednesday',
            'Thursday',
            'Friday',
            'Saturday'
          ],
          SHORTWEEKDAYS: const [
            'Sun',
            'Mon',
            'Tue',
            'Wed',
            'Thu',
            'Fri',
            'Sat'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'Sun',
            'Mon',
            'Tue',
            'Wed',
            'Thu',
            'Fri',
            'Sat'
          ],
          NARROWWEEKDAYS: const ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
          STANDALONENARROWWEEKDAYS: const ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
          SHORTQUARTERS: const ['Q1', 'Q2', 'Q3', 'Q4'],
          QUARTERS: const [
            '1st quarter',
            '2nd quarter',
            '3rd quarter',
            '4th quarter'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'EEEE, d MMMM y',
            'd MMMM y',
            'd MMM y',
            'd/M/yy'
          ],
          TIMEFORMATS: const [
            'h:mm:ss a zzzz',
            'h:mm:ss a z',
            'h:mm:ss a',
            'h:mm a'
          ],
          DATETIMEFORMATS: const [
            '{1} \'at\' {0}',
            '{1} \'at\' {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale en_US.
      // Date/time formatting symbols for locale en_US.
      "en_US": new DateSymbols(
          NAME: "en_US",
          ERAS: const ['BC', 'AD'],
          ERANAMES: const ['Before Christ', 'Anno Domini'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'January',
            'February',
            'March',
            'April',
            'May',
            'June',
            'July',
            'August',
            'September',
            'October',
            'November',
            'December'
          ],
          STANDALONEMONTHS: const [
            'January',
            'February',
            'March',
            'April',
            'May',
            'June',
            'July',
            'August',
            'September',
            'October',
            'November',
            'December'
          ],
          SHORTMONTHS: const [
            'Jan',
            'Feb',
            'Mar',
            'Apr',
            'May',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Oct',
            'Nov',
            'Dec'
          ],
          STANDALONESHORTMONTHS: const [
            'Jan',
            'Feb',
            'Mar',
            'Apr',
            'May',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Oct',
            'Nov',
            'Dec'
          ],
          WEEKDAYS: const [
            'Sunday',
            'Monday',
            'Tuesday',
            'Wednesday',
            'Thursday',
            'Friday',
            'Saturday'
          ],
          STANDALONEWEEKDAYS: const [
            'Sunday',
            'Monday',
            'Tuesday',
            'Wednesday',
            'Thursday',
            'Friday',
            'Saturday'
          ],
          SHORTWEEKDAYS: const [
            'Sun',
            'Mon',
            'Tue',
            'Wed',
            'Thu',
            'Fri',
            'Sat'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'Sun',
            'Mon',
            'Tue',
            'Wed',
            'Thu',
            'Fri',
            'Sat'
          ],
          NARROWWEEKDAYS: const ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
          STANDALONENARROWWEEKDAYS: const ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
          SHORTQUARTERS: const ['Q1', 'Q2', 'Q3', 'Q4'],
          QUARTERS: const [
            '1st quarter',
            '2nd quarter',
            '3rd quarter',
            '4th quarter'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'EEEE, MMMM d, y',
            'MMMM d, y',
            'MMM d, y',
            'M/d/yy'
          ],
          TIMEFORMATS: const [
            'h:mm:ss a zzzz',
            'h:mm:ss a z',
            'h:mm:ss a',
            'h:mm a'
          ],
          DATETIMEFORMATS: const [
            '{1} \'at\' {0}',
            '{1} \'at\' {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale en_ZA.
      "en_ZA": new DateSymbols(
          NAME: "en_ZA",
          ERAS: const ['BC', 'AD'],
          ERANAMES: const ['Before Christ', 'Anno Domini'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'January',
            'February',
            'March',
            'April',
            'May',
            'June',
            'July',
            'August',
            'September',
            'October',
            'November',
            'December'
          ],
          STANDALONEMONTHS: const [
            'January',
            'February',
            'March',
            'April',
            'May',
            'June',
            'July',
            'August',
            'September',
            'October',
            'November',
            'December'
          ],
          SHORTMONTHS: const [
            'Jan',
            'Feb',
            'Mar',
            'Apr',
            'May',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Oct',
            'Nov',
            'Dec'
          ],
          STANDALONESHORTMONTHS: const [
            'Jan',
            'Feb',
            'Mar',
            'Apr',
            'May',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Oct',
            'Nov',
            'Dec'
          ],
          WEEKDAYS: const [
            'Sunday',
            'Monday',
            'Tuesday',
            'Wednesday',
            'Thursday',
            'Friday',
            'Saturday'
          ],
          STANDALONEWEEKDAYS: const [
            'Sunday',
            'Monday',
            'Tuesday',
            'Wednesday',
            'Thursday',
            'Friday',
            'Saturday'
          ],
          SHORTWEEKDAYS: const [
            'Sun',
            'Mon',
            'Tue',
            'Wed',
            'Thu',
            'Fri',
            'Sat'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'Sun',
            'Mon',
            'Tue',
            'Wed',
            'Thu',
            'Fri',
            'Sat'
          ],
          NARROWWEEKDAYS: const ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
          STANDALONENARROWWEEKDAYS: const ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
          SHORTQUARTERS: const ['Q1', 'Q2', 'Q3', 'Q4'],
          QUARTERS: const [
            '1st quarter',
            '2nd quarter',
            '3rd quarter',
            '4th quarter'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'EEEE, dd MMMM y',
            'dd MMMM y',
            'dd MMM y',
            'y/MM/dd'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const [
            '{1} \'at\' {0}',
            '{1} \'at\' {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale es.
      "es": new DateSymbols(
          NAME: "es",
          ERAS: const ['a. C.', 'd. C.'],
          ERANAMES: const ['antes de Cristo', 'después de Cristo'],
          NARROWMONTHS: const [
            'E',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'E',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'enero',
            'febrero',
            'marzo',
            'abril',
            'mayo',
            'junio',
            'julio',
            'agosto',
            'septiembre',
            'octubre',
            'noviembre',
            'diciembre'
          ],
          STANDALONEMONTHS: const [
            'enero',
            'febrero',
            'marzo',
            'abril',
            'mayo',
            'junio',
            'julio',
            'agosto',
            'septiembre',
            'octubre',
            'noviembre',
            'diciembre'
          ],
          SHORTMONTHS: const [
            'ene.',
            'feb.',
            'mar.',
            'abr.',
            'may.',
            'jun.',
            'jul.',
            'ago.',
            'sept.',
            'oct.',
            'nov.',
            'dic.'
          ],
          STANDALONESHORTMONTHS: const [
            'ene.',
            'feb.',
            'mar.',
            'abr.',
            'may.',
            'jun.',
            'jul.',
            'ago.',
            'sept.',
            'oct.',
            'nov.',
            'dic.'
          ],
          WEEKDAYS: const [
            'domingo',
            'lunes',
            'martes',
            'miércoles',
            'jueves',
            'viernes',
            'sábado'
          ],
          STANDALONEWEEKDAYS: const [
            'domingo',
            'lunes',
            'martes',
            'miércoles',
            'jueves',
            'viernes',
            'sábado'
          ],
          SHORTWEEKDAYS: const [
            'dom.',
            'lun.',
            'mar.',
            'mié.',
            'jue.',
            'vie.',
            'sáb.'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'dom.',
            'lun.',
            'mar.',
            'mié.',
            'jue.',
            'vie.',
            'sáb.'
          ],
          NARROWWEEKDAYS: const ['D', 'L', 'M', 'X', 'J', 'V', 'S'],
          STANDALONENARROWWEEKDAYS: const ['D', 'L', 'M', 'X', 'J', 'V', 'S'],
          SHORTQUARTERS: const ['T1', 'T2', 'T3', 'T4'],
          QUARTERS: const [
            '1.er trimestre',
            '2.º trimestre',
            '3.er trimestre',
            '4.º trimestre'
          ],
          AMPMS: const ['a. m.', 'p. m.'],
          DATEFORMATS: const [
            'EEEE, d \'de\' MMMM \'de\' y',
            'd \'de\' MMMM \'de\' y',
            'd MMM y',
            'd/M/yy'
          ],
          TIMEFORMATS: const ['H:mm:ss (zzzz)', 'H:mm:ss z', 'H:mm:ss', 'H:mm'],
          DATETIMEFORMATS: const ['{1}, {0}', '{1}, {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale es_419.
      "es_419": new DateSymbols(
          NAME: "es_419",
          ERAS: const ['a. C.', 'd. C.'],
          ERANAMES: const ['antes de Cristo', 'después de Cristo'],
          NARROWMONTHS: const [
            'E',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'E',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'enero',
            'febrero',
            'marzo',
            'abril',
            'mayo',
            'junio',
            'julio',
            'agosto',
            'septiembre',
            'octubre',
            'noviembre',
            'diciembre'
          ],
          STANDALONEMONTHS: const [
            'enero',
            'febrero',
            'marzo',
            'abril',
            'mayo',
            'junio',
            'julio',
            'agosto',
            'septiembre',
            'octubre',
            'noviembre',
            'diciembre'
          ],
          SHORTMONTHS: const [
            'ene.',
            'feb.',
            'mar.',
            'abr.',
            'may.',
            'jun.',
            'jul.',
            'ago.',
            'sep.',
            'oct.',
            'nov.',
            'dic.'
          ],
          STANDALONESHORTMONTHS: const [
            'ene.',
            'feb.',
            'mar.',
            'abr.',
            'may.',
            'jun.',
            'jul.',
            'ago.',
            'sep.',
            'oct.',
            'nov.',
            'dic.'
          ],
          WEEKDAYS: const [
            'domingo',
            'lunes',
            'martes',
            'miércoles',
            'jueves',
            'viernes',
            'sábado'
          ],
          STANDALONEWEEKDAYS: const [
            'domingo',
            'lunes',
            'martes',
            'miércoles',
            'jueves',
            'viernes',
            'sábado'
          ],
          SHORTWEEKDAYS: const [
            'dom.',
            'lun.',
            'mar.',
            'mié.',
            'jue.',
            'vie.',
            'sáb.'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'dom.',
            'lun.',
            'mar.',
            'mié.',
            'jue.',
            'vie.',
            'sáb.'
          ],
          NARROWWEEKDAYS: const ['d', 'l', 'm', 'm', 'j', 'v', 's'],
          STANDALONENARROWWEEKDAYS: const ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
          SHORTQUARTERS: const ['T1', 'T2', 'T3', 'T4'],
          QUARTERS: const [
            '1.º trimestre',
            '2.º trimestre',
            '3.º trimestre',
            '4.º trimestre'
          ],
          AMPMS: const ['a.m.', 'p.m.'],
          DATEFORMATS: const [
            'EEEE, d \'de\' MMMM \'de\' y',
            'd \'de\' MMMM \'de\' y',
            'd MMM y',
            'd/M/yy'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const ['{1}, {0}', '{1}, {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale es_ES.
      // Date/time formatting symbols for locale es_ES.
      "es_ES": new DateSymbols(
          NAME: "es_ES",
          ERAS: const ['a. C.', 'd. C.'],
          ERANAMES: const ['antes de Cristo', 'después de Cristo'],
          NARROWMONTHS: const [
            'E',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'E',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'enero',
            'febrero',
            'marzo',
            'abril',
            'mayo',
            'junio',
            'julio',
            'agosto',
            'septiembre',
            'octubre',
            'noviembre',
            'diciembre'
          ],
          STANDALONEMONTHS: const [
            'enero',
            'febrero',
            'marzo',
            'abril',
            'mayo',
            'junio',
            'julio',
            'agosto',
            'septiembre',
            'octubre',
            'noviembre',
            'diciembre'
          ],
          SHORTMONTHS: const [
            'ene.',
            'feb.',
            'mar.',
            'abr.',
            'may.',
            'jun.',
            'jul.',
            'ago.',
            'sept.',
            'oct.',
            'nov.',
            'dic.'
          ],
          STANDALONESHORTMONTHS: const [
            'ene.',
            'feb.',
            'mar.',
            'abr.',
            'may.',
            'jun.',
            'jul.',
            'ago.',
            'sept.',
            'oct.',
            'nov.',
            'dic.'
          ],
          WEEKDAYS: const [
            'domingo',
            'lunes',
            'martes',
            'miércoles',
            'jueves',
            'viernes',
            'sábado'
          ],
          STANDALONEWEEKDAYS: const [
            'domingo',
            'lunes',
            'martes',
            'miércoles',
            'jueves',
            'viernes',
            'sábado'
          ],
          SHORTWEEKDAYS: const [
            'dom.',
            'lun.',
            'mar.',
            'mié.',
            'jue.',
            'vie.',
            'sáb.'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'dom.',
            'lun.',
            'mar.',
            'mié.',
            'jue.',
            'vie.',
            'sáb.'
          ],
          NARROWWEEKDAYS: const ['D', 'L', 'M', 'X', 'J', 'V', 'S'],
          STANDALONENARROWWEEKDAYS: const ['D', 'L', 'M', 'X', 'J', 'V', 'S'],
          SHORTQUARTERS: const ['T1', 'T2', 'T3', 'T4'],
          QUARTERS: const [
            '1.er trimestre',
            '2.º trimestre',
            '3.er trimestre',
            '4.º trimestre'
          ],
          AMPMS: const ['a. m.', 'p. m.'],
          DATEFORMATS: const [
            'EEEE, d \'de\' MMMM \'de\' y',
            'd \'de\' MMMM \'de\' y',
            'd MMM y',
            'd/M/yy'
          ],
          TIMEFORMATS: const ['H:mm:ss (zzzz)', 'H:mm:ss z', 'H:mm:ss', 'H:mm'],
          DATETIMEFORMATS: const ['{1}, {0}', '{1}, {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale es_MX.
      "es_MX": new DateSymbols(
          NAME: "es_MX",
          ERAS: const ['a. C.', 'd. C.'],
          ERANAMES: const ['antes de Cristo', 'después de Cristo'],
          NARROWMONTHS: const [
            'E',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'E',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'enero',
            'febrero',
            'marzo',
            'abril',
            'mayo',
            'junio',
            'julio',
            'agosto',
            'septiembre',
            'octubre',
            'noviembre',
            'diciembre'
          ],
          STANDALONEMONTHS: const [
            'enero',
            'febrero',
            'marzo',
            'abril',
            'mayo',
            'junio',
            'julio',
            'agosto',
            'septiembre',
            'octubre',
            'noviembre',
            'diciembre'
          ],
          SHORTMONTHS: const [
            'ene',
            'feb',
            'mar',
            'abr',
            'may',
            'jun',
            'jul',
            'ago',
            'sep',
            'oct',
            'nov',
            'dic'
          ],
          STANDALONESHORTMONTHS: const [
            'ene.',
            'feb.',
            'mar.',
            'abr.',
            'may.',
            'jun.',
            'jul.',
            'ago.',
            'sep.',
            'oct.',
            'nov.',
            'dic.'
          ],
          WEEKDAYS: const [
            'domingo',
            'lunes',
            'martes',
            'miércoles',
            'jueves',
            'viernes',
            'sábado'
          ],
          STANDALONEWEEKDAYS: const [
            'domingo',
            'lunes',
            'martes',
            'miércoles',
            'jueves',
            'viernes',
            'sábado'
          ],
          SHORTWEEKDAYS: const [
            'dom.',
            'lun.',
            'mar.',
            'mié.',
            'jue.',
            'vie.',
            'sáb.'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'dom.',
            'lun.',
            'mar.',
            'mié.',
            'jue.',
            'vie.',
            'sáb.'
          ],
          NARROWWEEKDAYS: const ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
          STANDALONENARROWWEEKDAYS: const ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
          SHORTQUARTERS: const [
            '1er. trim.',
            '2º. trim.',
            '3er. trim.',
            '4º trim.'
          ],
          QUARTERS: const [
            '1.er trimestre',
            '2º. trimestre',
            '3.er trimestre',
            '4o. trimestre'
          ],
          AMPMS: const ['a. m.', 'p. m.'],
          DATEFORMATS: const [
            'EEEE, d \'de\' MMMM \'de\' y',
            'd \'de\' MMMM \'de\' y',
            'd MMM y',
            'dd/MM/yy'
          ],
          TIMEFORMATS: const ['H:mm:ss zzzz', 'H:mm:ss z', 'H:mm:ss', 'H:mm'],
          DATETIMEFORMATS: const ['{1}, {0}', '{1}, {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale es_US.
      "es_US": new DateSymbols(
          NAME: "es_US",
          ERAS: const ['a. C.', 'd. C.'],
          ERANAMES: const ['antes de Cristo', 'después de Cristo'],
          NARROWMONTHS: const [
            'E',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'E',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'enero',
            'febrero',
            'marzo',
            'abril',
            'mayo',
            'junio',
            'julio',
            'agosto',
            'septiembre',
            'octubre',
            'noviembre',
            'diciembre'
          ],
          STANDALONEMONTHS: const [
            'enero',
            'febrero',
            'marzo',
            'abril',
            'mayo',
            'junio',
            'julio',
            'agosto',
            'septiembre',
            'octubre',
            'noviembre',
            'diciembre'
          ],
          SHORTMONTHS: const [
            'ene.',
            'feb.',
            'mar.',
            'abr.',
            'may.',
            'jun.',
            'jul.',
            'ago.',
            'sep.',
            'oct.',
            'nov.',
            'dic.'
          ],
          STANDALONESHORTMONTHS: const [
            'ene.',
            'feb.',
            'mar.',
            'abr.',
            'may.',
            'jun.',
            'jul.',
            'ago.',
            'sep.',
            'oct.',
            'nov.',
            'dic.'
          ],
          WEEKDAYS: const [
            'domingo',
            'lunes',
            'martes',
            'miércoles',
            'jueves',
            'viernes',
            'sábado'
          ],
          STANDALONEWEEKDAYS: const [
            'domingo',
            'lunes',
            'martes',
            'miércoles',
            'jueves',
            'viernes',
            'sábado'
          ],
          SHORTWEEKDAYS: const [
            'dom.',
            'lun.',
            'mar.',
            'mié.',
            'jue.',
            'vie.',
            'sáb.'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'dom.',
            'lun.',
            'mar.',
            'mié.',
            'jue.',
            'vie.',
            'sáb.'
          ],
          NARROWWEEKDAYS: const ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
          STANDALONENARROWWEEKDAYS: const ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
          SHORTQUARTERS: const ['T1', 'T2', 'T3', 'T4'],
          QUARTERS: const [
            '1.er trimestre',
            '2.º trimestre',
            '3.er trimestre',
            '4.º trimestre'
          ],
          AMPMS: const ['a. m.', 'p. m.'],
          DATEFORMATS: const [
            'EEEE, d \'de\' MMMM \'de\' y',
            'd \'de\' MMMM \'de\' y',
            'd MMM y',
            'd/M/y'
          ],
          TIMEFORMATS: const [
            'h:mm:ss a zzzz',
            'h:mm:ss a z',
            'h:mm:ss a',
            'h:mm a'
          ],
          DATETIMEFORMATS: const ['{1}, {0}', '{1}, {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale et.
      "et": new DateSymbols(
          NAME: "et",
          ERAS: const ['eKr', 'pKr'],
          ERANAMES: const ['enne Kristust', 'pärast Kristust'],
          NARROWMONTHS: const [
            'J',
            'V',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'V',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'jaanuar',
            'veebruar',
            'märts',
            'aprill',
            'mai',
            'juuni',
            'juuli',
            'august',
            'september',
            'oktoober',
            'november',
            'detsember'
          ],
          STANDALONEMONTHS: const [
            'jaanuar',
            'veebruar',
            'märts',
            'aprill',
            'mai',
            'juuni',
            'juuli',
            'august',
            'september',
            'oktoober',
            'november',
            'detsember'
          ],
          SHORTMONTHS: const [
            'jaan',
            'veebr',
            'märts',
            'apr',
            'mai',
            'juuni',
            'juuli',
            'aug',
            'sept',
            'okt',
            'nov',
            'dets'
          ],
          STANDALONESHORTMONTHS: const [
            'jaan',
            'veebr',
            'märts',
            'apr',
            'mai',
            'juuni',
            'juuli',
            'aug',
            'sept',
            'okt',
            'nov',
            'dets'
          ],
          WEEKDAYS: const [
            'pühapäev',
            'esmaspäev',
            'teisipäev',
            'kolmapäev',
            'neljapäev',
            'reede',
            'laupäev'
          ],
          STANDALONEWEEKDAYS: const [
            'pühapäev',
            'esmaspäev',
            'teisipäev',
            'kolmapäev',
            'neljapäev',
            'reede',
            'laupäev'
          ],
          SHORTWEEKDAYS: const ['P', 'E', 'T', 'K', 'N', 'R', 'L'],
          STANDALONESHORTWEEKDAYS: const ['P', 'E', 'T', 'K', 'N', 'R', 'L'],
          NARROWWEEKDAYS: const ['P', 'E', 'T', 'K', 'N', 'R', 'L'],
          STANDALONENARROWWEEKDAYS: const ['P', 'E', 'T', 'K', 'N', 'R', 'L'],
          SHORTQUARTERS: const ['K1', 'K2', 'K3', 'K4'],
          QUARTERS: const [
            '1. kvartal',
            '2. kvartal',
            '3. kvartal',
            '4. kvartal'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'EEEE, d. MMMM y',
            'd. MMMM y',
            'd. MMM y',
            'dd.MM.yy'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale eu.
      "eu": new DateSymbols(
          NAME: "eu",
          ERAS: const ['K.a.', 'K.o.'],
          ERANAMES: const ['K.a.', 'Kristo ondoren'],
          NARROWMONTHS: const [
            'U',
            'O',
            'M',
            'A',
            'M',
            'E',
            'U',
            'A',
            'I',
            'U',
            'A',
            'A'
          ],
          STANDALONENARROWMONTHS: const [
            'U',
            'O',
            'M',
            'A',
            'M',
            'E',
            'U',
            'A',
            'I',
            'U',
            'A',
            'A'
          ],
          MONTHS: const [
            'urtarrila',
            'otsaila',
            'martxoa',
            'apirila',
            'maiatza',
            'ekaina',
            'uztaila',
            'abuztua',
            'iraila',
            'urria',
            'azaroa',
            'abendua'
          ],
          STANDALONEMONTHS: const [
            'urtarrila',
            'Otsaila',
            'Martxoa',
            'Apirila',
            'Maiatza',
            'Ekaina',
            'Uztaila',
            'Abuztua',
            'Iraila',
            'Urria',
            'Azaroa',
            'Abendua'
          ],
          SHORTMONTHS: const [
            'urt.',
            'ots.',
            'mar.',
            'api.',
            'mai.',
            'eka.',
            'uzt.',
            'abu.',
            'ira.',
            'urr.',
            'aza.',
            'abe.'
          ],
          STANDALONESHORTMONTHS: const [
            'urt.',
            'ots.',
            'mar.',
            'api.',
            'mai.',
            'eka.',
            'uzt.',
            'abu.',
            'ira.',
            'urr.',
            'aza.',
            'abe.'
          ],
          WEEKDAYS: const [
            'igandea',
            'astelehena',
            'asteartea',
            'asteazkena',
            'osteguna',
            'ostirala',
            'larunbata'
          ],
          STANDALONEWEEKDAYS: const [
            'Igandea',
            'Astelehena',
            'Asteartea',
            'Asteazkena',
            'Osteguna',
            'Ostirala',
            'Larunbata'
          ],
          SHORTWEEKDAYS: const [
            'ig.',
            'al.',
            'ar.',
            'az.',
            'og.',
            'or.',
            'lr.'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'ig.',
            'al.',
            'ar.',
            'az.',
            'og.',
            'or.',
            'lr.'
          ],
          NARROWWEEKDAYS: const ['I', 'A', 'A', 'A', 'O', 'O', 'L'],
          STANDALONENARROWWEEKDAYS: const ['I', 'A', 'A', 'A', 'O', 'O', 'L'],
          SHORTQUARTERS: const ['1Hh', '2Hh', '3Hh', '4Hh'],
          QUARTERS: const [
            '1. hiruhilekoa',
            '2. hiruhilekoa',
            '3. hiruhilekoa',
            '4. hiruhilekoa'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'y(\'e\')\'ko\' MMMM\'ren\' d(\'a\'), EEEE',
            'y(\'e\')\'ko\' MMMM\'ren\' d(\'a\')',
            'y MMM d',
            'yy/M/d'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss (zzzz)',
            'HH:mm:ss (z)',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale fa.
      "fa": new DateSymbols(
          NAME: "fa",
          ZERODIGIT: '\u06F0',
          ERAS: const ['ق.م.', 'م.'],
          ERANAMES: const ['قبل از میلاد', 'میلادی'],
          NARROWMONTHS: const [
            'ژ',
            'ف',
            'م',
            'آ',
            'م',
            'ژ',
            'ژ',
            'ا',
            'س',
            'ا',
            'ن',
            'د'
          ],
          STANDALONENARROWMONTHS: const [
            'ژ',
            'ف',
            'م',
            'آ',
            'م',
            'ژ',
            'ژ',
            'ا',
            'س',
            'ا',
            'ن',
            'د'
          ],
          MONTHS: const [
            'ژانویهٔ',
            'فوریهٔ',
            'مارس',
            'آوریل',
            'مهٔ',
            'ژوئن',
            'ژوئیهٔ',
            'اوت',
            'سپتامبر',
            'اکتبر',
            'نوامبر',
            'دسامبر'
          ],
          STANDALONEMONTHS: const [
            'ژانویه',
            'فوریه',
            'مارس',
            'آوریل',
            'مه',
            'ژوئن',
            'ژوئیه',
            'اوت',
            'سپتامبر',
            'اکتبر',
            'نوامبر',
            'دسامبر'
          ],
          SHORTMONTHS: const [
            'ژانویهٔ',
            'فوریهٔ',
            'مارس',
            'آوریل',
            'مهٔ',
            'ژوئن',
            'ژوئیهٔ',
            'اوت',
            'سپتامبر',
            'اکتبر',
            'نوامبر',
            'دسامبر'
          ],
          STANDALONESHORTMONTHS: const [
            'ژانویه',
            'فوریه',
            'مارس',
            'آوریل',
            'مه',
            'ژوئن',
            'ژوئیه',
            'اوت',
            'سپتامبر',
            'اکتبر',
            'نوامبر',
            'دسامبر'
          ],
          WEEKDAYS: const [
            'یکشنبه',
            'دوشنبه',
            'سه‌شنبه',
            'چهارشنبه',
            'پنجشنبه',
            'جمعه',
            'شنبه'
          ],
          STANDALONEWEEKDAYS: const [
            'یکشنبه',
            'دوشنبه',
            'سه‌شنبه',
            'چهارشنبه',
            'پنجشنبه',
            'جمعه',
            'شنبه'
          ],
          SHORTWEEKDAYS: const [
            'یکشنبه',
            'دوشنبه',
            'سه‌شنبه',
            'چهارشنبه',
            'پنجشنبه',
            'جمعه',
            'شنبه'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'یکشنبه',
            'دوشنبه',
            'سه‌شنبه',
            'چهارشنبه',
            'پنجشنبه',
            'جمعه',
            'شنبه'
          ],
          NARROWWEEKDAYS: const ['ی', 'د', 'س', 'چ', 'پ', 'ج', 'ش'],
          STANDALONENARROWWEEKDAYS: const ['ی', 'د', 'س', 'چ', 'پ', 'ج', 'ش'],
          SHORTQUARTERS: const ['س‌م۱', 'س‌م۲', 'س‌م۳', 'س‌م۴'],
          QUARTERS: const [
            'سه‌ماههٔ اول',
            'سه‌ماههٔ دوم',
            'سه‌ماههٔ سوم',
            'سه‌ماههٔ چهارم'
          ],
          AMPMS: const ['قبل‌ازظهر', 'بعدازظهر'],
          DATEFORMATS: const ['EEEE d MMMM y', 'd MMMM y', 'd MMM y', 'y/M/d'],
          TIMEFORMATS: const [
            'H:mm:ss (zzzz)',
            'H:mm:ss (z)',
            'H:mm:ss',
            'H:mm'
          ],
          DATETIMEFORMATS: const [
            '{1}، ساعت {0}',
            '{1}، ساعت {0}',
            '{1}،‏ {0}',
            '{1}،‏ {0}'
          ],
          FIRSTDAYOFWEEK: 5,
          WEEKENDRANGE: const [4, 4],
          FIRSTWEEKCUTOFFDAY: 4),
      // Date/time formatting symbols for locale fi.
      "fi": new DateSymbols(
          NAME: "fi",
          ERAS: const ['eKr.', 'jKr.'],
          ERANAMES: const [
            'ennen Kristuksen syntymää',
            'jälkeen Kristuksen syntymän'
          ],
          NARROWMONTHS: const [
            'T',
            'H',
            'M',
            'H',
            'T',
            'K',
            'H',
            'E',
            'S',
            'L',
            'M',
            'J'
          ],
          STANDALONENARROWMONTHS: const [
            'T',
            'H',
            'M',
            'H',
            'T',
            'K',
            'H',
            'E',
            'S',
            'L',
            'M',
            'J'
          ],
          MONTHS: const [
            'tammikuuta',
            'helmikuuta',
            'maaliskuuta',
            'huhtikuuta',
            'toukokuuta',
            'kesäkuuta',
            'heinäkuuta',
            'elokuuta',
            'syyskuuta',
            'lokakuuta',
            'marraskuuta',
            'joulukuuta'
          ],
          STANDALONEMONTHS: const [
            'tammikuu',
            'helmikuu',
            'maaliskuu',
            'huhtikuu',
            'toukokuu',
            'kesäkuu',
            'heinäkuu',
            'elokuu',
            'syyskuu',
            'lokakuu',
            'marraskuu',
            'joulukuu'
          ],
          SHORTMONTHS: const [
            'tammik.',
            'helmik.',
            'maalisk.',
            'huhtik.',
            'toukok.',
            'kesäk.',
            'heinäk.',
            'elok.',
            'syysk.',
            'lokak.',
            'marrask.',
            'jouluk.'
          ],
          STANDALONESHORTMONTHS: const [
            'tammi',
            'helmi',
            'maalis',
            'huhti',
            'touko',
            'kesä',
            'heinä',
            'elo',
            'syys',
            'loka',
            'marras',
            'joulu'
          ],
          WEEKDAYS: const [
            'sunnuntaina',
            'maanantaina',
            'tiistaina',
            'keskiviikkona',
            'torstaina',
            'perjantaina',
            'lauantaina'
          ],
          STANDALONEWEEKDAYS: const [
            'sunnuntai',
            'maanantai',
            'tiistai',
            'keskiviikko',
            'torstai',
            'perjantai',
            'lauantai'
          ],
          SHORTWEEKDAYS: const ['su', 'ma', 'ti', 'ke', 'to', 'pe', 'la'],
          STANDALONESHORTWEEKDAYS: const [
            'su',
            'ma',
            'ti',
            'ke',
            'to',
            'pe',
            'la'
          ],
          NARROWWEEKDAYS: const ['S', 'M', 'T', 'K', 'T', 'P', 'L'],
          STANDALONENARROWWEEKDAYS: const ['S', 'M', 'T', 'K', 'T', 'P', 'L'],
          SHORTQUARTERS: const ['1. nelj.', '2. nelj.', '3. nelj.', '4. nelj.'],
          QUARTERS: const [
            '1. neljännes',
            '2. neljännes',
            '3. neljännes',
            '4. neljännes'
          ],
          AMPMS: const ['ap.', 'ip.'],
          DATEFORMATS: const ['cccc d. MMMM y', 'd. MMMM y', 'd.M.y', 'd.M.y'],
          TIMEFORMATS: const ['H.mm.ss zzzz', 'H.mm.ss z', 'H.mm.ss', 'H.mm'],
          DATETIMEFORMATS: const [
            '{1} \'klo\' {0}',
            '{1} \'klo\' {0}',
            '{1} \'klo\' {0}',
            '{1} {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale fil.
      "fil": new DateSymbols(
          NAME: "fil",
          ERAS: const ['BC', 'AD'],
          ERANAMES: const ['Before Christ', 'Anno Domini'],
          NARROWMONTHS: const [
            'Ene',
            'Peb',
            'Mar',
            'Abr',
            'May',
            'Hun',
            'Hul',
            'Ago',
            'Set',
            'Okt',
            'Nob',
            'Dis'
          ],
          STANDALONENARROWMONTHS: const [
            'E',
            'P',
            'M',
            'A',
            'M',
            'Hun',
            'Hul',
            'Ago',
            'Set',
            'Okt',
            'Nob',
            'Dis'
          ],
          MONTHS: const [
            'Enero',
            'Pebrero',
            'Marso',
            'Abril',
            'Mayo',
            'Hunyo',
            'Hulyo',
            'Agosto',
            'Setyembre',
            'Oktubre',
            'Nobyembre',
            'Disyembre'
          ],
          STANDALONEMONTHS: const [
            'Enero',
            'Pebrero',
            'Marso',
            'Abril',
            'Mayo',
            'Hunyo',
            'Hulyo',
            'Agosto',
            'Setyembre',
            'Oktubre',
            'Nobyembre',
            'Disyembre'
          ],
          SHORTMONTHS: const [
            'Ene',
            'Peb',
            'Mar',
            'Abr',
            'May',
            'Hun',
            'Hul',
            'Ago',
            'Set',
            'Okt',
            'Nob',
            'Dis'
          ],
          STANDALONESHORTMONTHS: const [
            'Ene',
            'Peb',
            'Mar',
            'Abr',
            'May',
            'Hun',
            'Hul',
            'Ago',
            'Set',
            'Okt',
            'Nob',
            'Dis'
          ],
          WEEKDAYS: const [
            'Linggo',
            'Lunes',
            'Martes',
            'Miyerkules',
            'Huwebes',
            'Biyernes',
            'Sabado'
          ],
          STANDALONEWEEKDAYS: const [
            'Linggo',
            'Lunes',
            'Martes',
            'Miyerkules',
            'Huwebes',
            'Biyernes',
            'Sabado'
          ],
          SHORTWEEKDAYS: const [
            'Lin',
            'Lun',
            'Mar',
            'Miy',
            'Huw',
            'Biy',
            'Sab'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'Lin',
            'Lun',
            'Mar',
            'Miy',
            'Huw',
            'Biy',
            'Sab'
          ],
          NARROWWEEKDAYS: const [
            'Lin',
            'Lun',
            'Mar',
            'Miy',
            'Huw',
            'Biy',
            'Sab'
          ],
          STANDALONENARROWWEEKDAYS: const [
            'Lin',
            'Lun',
            'Mar',
            'Miy',
            'Huw',
            'Biy',
            'Sab'
          ],
          SHORTQUARTERS: const ['Q1', 'Q2', 'Q3', 'Q4'],
          QUARTERS: const [
            'ika-1 quarter',
            'ika-2 quarter',
            'ika-3 quarter',
            'ika-4 na quarter'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'EEEE, MMMM d, y',
            'MMMM d, y',
            'MMM d, y',
            'M/d/yy'
          ],
          TIMEFORMATS: const [
            'h:mm:ss a zzzz',
            'h:mm:ss a z',
            'h:mm:ss a',
            'h:mm a'
          ],
          DATETIMEFORMATS: const [
            '{1} \'nang\' {0}',
            '{1} \'nang\' {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale fr.
      "fr": new DateSymbols(
          NAME: "fr",
          ERAS: const ['av. J.-C.', 'ap. J.-C.'],
          ERANAMES: const ['avant Jésus-Christ', 'après Jésus-Christ'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'janvier',
            'février',
            'mars',
            'avril',
            'mai',
            'juin',
            'juillet',
            'août',
            'septembre',
            'octobre',
            'novembre',
            'décembre'
          ],
          STANDALONEMONTHS: const [
            'janvier',
            'février',
            'mars',
            'avril',
            'mai',
            'juin',
            'juillet',
            'août',
            'septembre',
            'octobre',
            'novembre',
            'décembre'
          ],
          SHORTMONTHS: const [
            'janv.',
            'févr.',
            'mars',
            'avr.',
            'mai',
            'juin',
            'juil.',
            'août',
            'sept.',
            'oct.',
            'nov.',
            'déc.'
          ],
          STANDALONESHORTMONTHS: const [
            'janv.',
            'févr.',
            'mars',
            'avr.',
            'mai',
            'juin',
            'juil.',
            'août',
            'sept.',
            'oct.',
            'nov.',
            'déc.'
          ],
          WEEKDAYS: const [
            'dimanche',
            'lundi',
            'mardi',
            'mercredi',
            'jeudi',
            'vendredi',
            'samedi'
          ],
          STANDALONEWEEKDAYS: const [
            'dimanche',
            'lundi',
            'mardi',
            'mercredi',
            'jeudi',
            'vendredi',
            'samedi'
          ],
          SHORTWEEKDAYS: const [
            'dim.',
            'lun.',
            'mar.',
            'mer.',
            'jeu.',
            'ven.',
            'sam.'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'dim.',
            'lun.',
            'mar.',
            'mer.',
            'jeu.',
            'ven.',
            'sam.'
          ],
          NARROWWEEKDAYS: const ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
          STANDALONENARROWWEEKDAYS: const ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
          SHORTQUARTERS: const ['T1', 'T2', 'T3', 'T4'],
          QUARTERS: const [
            '1er trimestre',
            '2e trimestre',
            '3e trimestre',
            '4e trimestre'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'EEEE d MMMM y',
            'd MMMM y',
            'd MMM y',
            'dd/MM/y'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const [
            '{1} \'à\' {0}',
            '{1} \'à\' {0}',
            '{1} \'à\' {0}',
            '{1} {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale fr_CA.
      "fr_CA": new DateSymbols(
          NAME: "fr_CA",
          ERAS: const ['av. J.-C.', 'ap. J.-C.'],
          ERANAMES: const ['avant Jésus-Christ', 'après Jésus-Christ'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'janvier',
            'février',
            'mars',
            'avril',
            'mai',
            'juin',
            'juillet',
            'août',
            'septembre',
            'octobre',
            'novembre',
            'décembre'
          ],
          STANDALONEMONTHS: const [
            'janvier',
            'février',
            'mars',
            'avril',
            'mai',
            'juin',
            'juillet',
            'août',
            'septembre',
            'octobre',
            'novembre',
            'décembre'
          ],
          SHORTMONTHS: const [
            'janv.',
            'févr.',
            'mars',
            'avr.',
            'mai',
            'juin',
            'juill.',
            'août',
            'sept.',
            'oct.',
            'nov.',
            'déc.'
          ],
          STANDALONESHORTMONTHS: const [
            'janv.',
            'févr.',
            'mars',
            'avr.',
            'mai',
            'juin',
            'juill.',
            'août',
            'sept.',
            'oct.',
            'nov.',
            'déc.'
          ],
          WEEKDAYS: const [
            'dimanche',
            'lundi',
            'mardi',
            'mercredi',
            'jeudi',
            'vendredi',
            'samedi'
          ],
          STANDALONEWEEKDAYS: const [
            'dimanche',
            'lundi',
            'mardi',
            'mercredi',
            'jeudi',
            'vendredi',
            'samedi'
          ],
          SHORTWEEKDAYS: const [
            'dim.',
            'lun.',
            'mar.',
            'mer.',
            'jeu.',
            'ven.',
            'sam.'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'dim.',
            'lun.',
            'mar.',
            'mer.',
            'jeu.',
            'ven.',
            'sam.'
          ],
          NARROWWEEKDAYS: const ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
          STANDALONENARROWWEEKDAYS: const ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
          SHORTQUARTERS: const ['T1', 'T2', 'T3', 'T4'],
          QUARTERS: const [
            '1er trimestre',
            '2e trimestre',
            '3e trimestre',
            '4e trimestre'
          ],
          AMPMS: const ['a.m.', 'p.m.'],
          DATEFORMATS: const [
            'EEEE d MMMM y',
            'd MMMM y',
            'd MMM y',
            'yy-MM-dd'
          ],
          TIMEFORMATS: const [
            'HH \'h\' mm \'min\' ss \'s\' zzzz',
            'HH \'h\' mm \'min\' ss \'s\' z',
            'HH \'h\' mm \'min\' ss \'s\'',
            'HH \'h\' mm'
          ],
          DATETIMEFORMATS: const [
            '{1} \'à\' {0}',
            '{1} \'à\' {0}',
            '{1} {0}',
            '{1} {0}'
          ],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale fr_CH.
      "fr_CH": new DateSymbols(
          NAME: "fr_CH",
          ERAS: const ['av. J.-C.', 'ap. J.-C.'],
          ERANAMES: const ['avant Jésus-Christ', 'après Jésus-Christ'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'janvier',
            'février',
            'mars',
            'avril',
            'mai',
            'juin',
            'juillet',
            'août',
            'septembre',
            'octobre',
            'novembre',
            'décembre'
          ],
          STANDALONEMONTHS: const [
            'janvier',
            'février',
            'mars',
            'avril',
            'mai',
            'juin',
            'juillet',
            'août',
            'septembre',
            'octobre',
            'novembre',
            'décembre'
          ],
          SHORTMONTHS: const [
            'janv.',
            'févr.',
            'mars',
            'avr.',
            'mai',
            'juin',
            'juil.',
            'août',
            'sept.',
            'oct.',
            'nov.',
            'déc.'
          ],
          STANDALONESHORTMONTHS: const [
            'janv.',
            'févr.',
            'mars',
            'avr.',
            'mai',
            'juin',
            'juil.',
            'août',
            'sept.',
            'oct.',
            'nov.',
            'déc.'
          ],
          WEEKDAYS: const [
            'dimanche',
            'lundi',
            'mardi',
            'mercredi',
            'jeudi',
            'vendredi',
            'samedi'
          ],
          STANDALONEWEEKDAYS: const [
            'dimanche',
            'lundi',
            'mardi',
            'mercredi',
            'jeudi',
            'vendredi',
            'samedi'
          ],
          SHORTWEEKDAYS: const [
            'dim.',
            'lun.',
            'mar.',
            'mer.',
            'jeu.',
            'ven.',
            'sam.'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'dim.',
            'lun.',
            'mar.',
            'mer.',
            'jeu.',
            'ven.',
            'sam.'
          ],
          NARROWWEEKDAYS: const ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
          STANDALONENARROWWEEKDAYS: const ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
          SHORTQUARTERS: const ['T1', 'T2', 'T3', 'T4'],
          QUARTERS: const [
            '1er trimestre',
            '2e trimestre',
            '3e trimestre',
            '4e trimestre'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'EEEE, d MMMM y',
            'd MMMM y',
            'd MMM y',
            'dd.MM.yy'
          ],
          TIMEFORMATS: const [
            'HH.mm:ss \'h\' zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const [
            '{1} \'à\' {0}',
            '{1} \'à\' {0}',
            '{1} \'à\' {0}',
            '{1} {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale ga.
      "ga": new DateSymbols(
          NAME: "ga",
          ERAS: const ['RC', 'AD'],
          ERANAMES: const ['Roimh Chríost', 'Anno Domini'],
          NARROWMONTHS: const [
            'E',
            'F',
            'M',
            'A',
            'B',
            'M',
            'I',
            'L',
            'M',
            'D',
            'S',
            'N'
          ],
          STANDALONENARROWMONTHS: const [
            'E',
            'F',
            'M',
            'A',
            'B',
            'M',
            'I',
            'L',
            'M',
            'D',
            'S',
            'N'
          ],
          MONTHS: const [
            'Eanáir',
            'Feabhra',
            'Márta',
            'Aibreán',
            'Bealtaine',
            'Meitheamh',
            'Iúil',
            'Lúnasa',
            'Meán Fómhair',
            'Deireadh Fómhair',
            'Samhain',
            'Nollaig'
          ],
          STANDALONEMONTHS: const [
            'Eanáir',
            'Feabhra',
            'Márta',
            'Aibreán',
            'Bealtaine',
            'Meitheamh',
            'Iúil',
            'Lúnasa',
            'Meán Fómhair',
            'Deireadh Fómhair',
            'Samhain',
            'Nollaig'
          ],
          SHORTMONTHS: const [
            'Ean',
            'Feabh',
            'Márta',
            'Aib',
            'Beal',
            'Meith',
            'Iúil',
            'Lún',
            'MFómh',
            'DFómh',
            'Samh',
            'Noll'
          ],
          STANDALONESHORTMONTHS: const [
            'Ean',
            'Feabh',
            'Márta',
            'Aib',
            'Beal',
            'Meith',
            'Iúil',
            'Lún',
            'MFómh',
            'DFómh',
            'Samh',
            'Noll'
          ],
          WEEKDAYS: const [
            'Dé Domhnaigh',
            'Dé Luain',
            'Dé Máirt',
            'Dé Céadaoin',
            'Déardaoin',
            'Dé hAoine',
            'Dé Sathairn'
          ],
          STANDALONEWEEKDAYS: const [
            'Dé Domhnaigh',
            'Dé Luain',
            'Dé Máirt',
            'Dé Céadaoin',
            'Déardaoin',
            'Dé hAoine',
            'Dé Sathairn'
          ],
          SHORTWEEKDAYS: const [
            'Domh',
            'Luan',
            'Máirt',
            'Céad',
            'Déar',
            'Aoine',
            'Sath'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'Domh',
            'Luan',
            'Máirt',
            'Céad',
            'Déar',
            'Aoine',
            'Sath'
          ],
          NARROWWEEKDAYS: const ['D', 'L', 'M', 'C', 'D', 'A', 'S'],
          STANDALONENARROWWEEKDAYS: const ['D', 'L', 'M', 'C', 'D', 'A', 'S'],
          SHORTQUARTERS: const ['R1', 'R2', 'R3', 'R4'],
          QUARTERS: const ['1ú ráithe', '2ú ráithe', '3ú ráithe', '4ú ráithe'],
          AMPMS: const ['r.n.', 'i.n.'],
          DATEFORMATS: const [
            'EEEE d MMMM y',
            'd MMMM y',
            'd MMM y',
            'dd/MM/y'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 2),
      // Date/time formatting symbols for locale gl.
      "gl": new DateSymbols(
          NAME: "gl",
          ERAS: const ['a.C.', 'd.C.'],
          ERANAMES: const ['antes de Cristo', 'despois de Cristo'],
          NARROWMONTHS: const [
            'x.',
            'f.',
            'm.',
            'a.',
            'm.',
            'x.',
            'x.',
            'a.',
            's.',
            'o.',
            'n.',
            'd.'
          ],
          STANDALONENARROWMONTHS: const [
            'X',
            'F',
            'M',
            'A',
            'M',
            'X',
            'X',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'xaneiro',
            'febreiro',
            'marzo',
            'abril',
            'maio',
            'xuño',
            'xullo',
            'agosto',
            'setembro',
            'outubro',
            'novembro',
            'decembro'
          ],
          STANDALONEMONTHS: const [
            'Xaneiro',
            'Febreiro',
            'Marzo',
            'Abril',
            'Maio',
            'Xuño',
            'Xullo',
            'Agosto',
            'Setembro',
            'Outubro',
            'Novembro',
            'Decembro'
          ],
          SHORTMONTHS: const [
            'xan.',
            'feb.',
            'mar.',
            'abr.',
            'maio',
            'xuño',
            'xul.',
            'ago.',
            'set.',
            'out.',
            'nov.',
            'dec.'
          ],
          STANDALONESHORTMONTHS: const [
            'Xan.',
            'Feb.',
            'Mar.',
            'Abr.',
            'Maio',
            'Xuño',
            'Xul.',
            'Ago.',
            'Set.',
            'Out.',
            'Nov.',
            'Dec.'
          ],
          WEEKDAYS: const [
            'domingo',
            'luns',
            'martes',
            'mércores',
            'xoves',
            'venres',
            'sábado'
          ],
          STANDALONEWEEKDAYS: const [
            'Domingo',
            'Luns',
            'Martes',
            'Mércores',
            'Xoves',
            'Venres',
            'Sábado'
          ],
          SHORTWEEKDAYS: const [
            'dom.',
            'luns',
            'mar.',
            'mér.',
            'xov.',
            'ven.',
            'sáb.'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'Dom.',
            'Luns',
            'Mar.',
            'Mér.',
            'Xov.',
            'Ven.',
            'Sáb.'
          ],
          NARROWWEEKDAYS: const ['d.', 'l.', 'm.', 'm.', 'x.', 'v.', 's.'],
          STANDALONENARROWWEEKDAYS: const ['D', 'L', 'M', 'M', 'X', 'V', 'S'],
          SHORTQUARTERS: const ['T1', 'T2', 'T3', 'T4'],
          QUARTERS: const [
            '1.º trimestre',
            '2.º trimestre',
            '3.º trimestre',
            '4.º trimestre'
          ],
          AMPMS: const ['a.m.', 'p.m.'],
          DATEFORMATS: const [
            'EEEE, d \'de\' MMMM \'de\' y',
            'd \'de\' MMMM \'de\' y',
            'dd/MM/y',
            'dd/MM/yy'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const [
            '{0} \'do\' {1}',
            '{0} \'do\' {1}',
            '{0}, {1}',
            '{0}, {1}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale gsw.
      "gsw": new DateSymbols(
          NAME: "gsw",
          ERAS: const ['v. Chr.', 'n. Chr.'],
          ERANAMES: const ['v. Chr.', 'n. Chr.'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'Januar',
            'Februar',
            'März',
            'April',
            'Mai',
            'Juni',
            'Juli',
            'Auguscht',
            'Septämber',
            'Oktoober',
            'Novämber',
            'Dezämber'
          ],
          STANDALONEMONTHS: const [
            'Januar',
            'Februar',
            'März',
            'April',
            'Mai',
            'Juni',
            'Juli',
            'Auguscht',
            'Septämber',
            'Oktoober',
            'Novämber',
            'Dezämber'
          ],
          SHORTMONTHS: const [
            'Jan',
            'Feb',
            'Mär',
            'Apr',
            'Mai',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Okt',
            'Nov',
            'Dez'
          ],
          STANDALONESHORTMONTHS: const [
            'Jan',
            'Feb',
            'Mär',
            'Apr',
            'Mai',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Okt',
            'Nov',
            'Dez'
          ],
          WEEKDAYS: const [
            'Sunntig',
            'Määntig',
            'Ziischtig',
            'Mittwuch',
            'Dunschtig',
            'Friitig',
            'Samschtig'
          ],
          STANDALONEWEEKDAYS: const [
            'Sunntig',
            'Määntig',
            'Ziischtig',
            'Mittwuch',
            'Dunschtig',
            'Friitig',
            'Samschtig'
          ],
          SHORTWEEKDAYS: const [
            'Su.',
            'Mä.',
            'Zi.',
            'Mi.',
            'Du.',
            'Fr.',
            'Sa.'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'Su.',
            'Mä.',
            'Zi.',
            'Mi.',
            'Du.',
            'Fr.',
            'Sa.'
          ],
          NARROWWEEKDAYS: const ['S', 'M', 'D', 'M', 'D', 'F', 'S'],
          STANDALONENARROWWEEKDAYS: const ['S', 'M', 'D', 'M', 'D', 'F', 'S'],
          SHORTQUARTERS: const ['Q1', 'Q2', 'Q3', 'Q4'],
          QUARTERS: const [
            '1. Quartal',
            '2. Quartal',
            '3. Quartal',
            '4. Quartal'
          ],
          AMPMS: const ['am Vormittag', 'am Namittag'],
          DATEFORMATS: const [
            'EEEE, d. MMMM y',
            'd. MMMM y',
            'dd.MM.y',
            'dd.MM.yy'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale gu.
      "gu": new DateSymbols(
          NAME: "gu",
          ERAS: const ['ઈ.સ.પૂર્વે', 'ઈ.સ.'],
          ERANAMES: const ['ઈસવીસન પૂર્વે', 'ઇસવીસન'],
          NARROWMONTHS: const [
            'જા',
            'ફે',
            'મા',
            'એ',
            'મે',
            'જૂ',
            'જુ',
            'ઑ',
            'સ',
            'ઑ',
            'ન',
            'ડિ'
          ],
          STANDALONENARROWMONTHS: const [
            'જા',
            'ફે',
            'મા',
            'એ',
            'મે',
            'જૂ',
            'જુ',
            'ઑ',
            'સ',
            'ઑ',
            'ન',
            'ડિ'
          ],
          MONTHS: const [
            'જાન્યુઆરી',
            'ફેબ્રુઆરી',
            'માર્ચ',
            'એપ્રિલ',
            'મે',
            'જૂન',
            'જુલાઈ',
            'ઑગસ્ટ',
            'સપ્ટેમ્બર',
            'ઑક્ટોબર',
            'નવેમ્બર',
            'ડિસેમ્બર'
          ],
          STANDALONEMONTHS: const [
            'જાન્યુઆરી',
            'ફેબ્રુઆરી',
            'માર્ચ',
            'એપ્રિલ',
            'મે',
            'જૂન',
            'જુલાઈ',
            'ઑગસ્ટ',
            'સપ્ટેમ્બર',
            'ઑક્ટોબર',
            'નવેમ્બર',
            'ડિસેમ્બર'
          ],
          SHORTMONTHS: const [
            'જાન્યુ',
            'ફેબ્રુ',
            'માર્ચ',
            'એપ્રિલ',
            'મે',
            'જૂન',
            'જુલાઈ',
            'ઑગસ્ટ',
            'સપ્ટે',
            'ઑક્ટો',
            'નવે',
            'ડિસે'
          ],
          STANDALONESHORTMONTHS: const [
            'જાન્યુ',
            'ફેબ્રુ',
            'માર્ચ',
            'એપ્રિલ',
            'મે',
            'જૂન',
            'જુલાઈ',
            'ઑગસ્ટ',
            'સપ્ટે',
            'ઑક્ટો',
            'નવે',
            'ડિસે'
          ],
          WEEKDAYS: const [
            'રવિવાર',
            'સોમવાર',
            'મંગળવાર',
            'બુધવાર',
            'ગુરુવાર',
            'શુક્રવાર',
            'શનિવાર'
          ],
          STANDALONEWEEKDAYS: const [
            'રવિવાર',
            'સોમવાર',
            'મંગળવાર',
            'બુધવાર',
            'ગુરુવાર',
            'શુક્રવાર',
            'શનિવાર'
          ],
          SHORTWEEKDAYS: const [
            'રવિ',
            'સોમ',
            'મંગળ',
            'બુધ',
            'ગુરુ',
            'શુક્ર',
            'શનિ'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'રવિ',
            'સોમ',
            'મંગળ',
            'બુધ',
            'ગુરુ',
            'શુક્ર',
            'શનિ'
          ],
          NARROWWEEKDAYS: const ['ર', 'સો', 'મં', 'બુ', 'ગુ', 'શુ', 'શ'],
          STANDALONENARROWWEEKDAYS: const [
            'ર',
            'સો',
            'મં',
            'બુ',
            'ગુ',
            'શુ',
            'શ'
          ],
          SHORTQUARTERS: const ['Q1', 'Q2', 'Q3', 'Q4'],
          QUARTERS: const [
            '1લો ત્રિમાસ',
            '2જો ત્રિમાસ',
            '3જો ત્રિમાસ',
            '4થો ત્રિમાસ'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'EEEE, d MMMM, y',
            'd MMMM, y',
            'd MMM, y',
            'd/M/yy'
          ],
          TIMEFORMATS: const [
            'hh:mm:ss a zzzz',
            'hh:mm:ss a z',
            'hh:mm:ss a',
            'hh:mm a'
          ],
          DATETIMEFORMATS: const [
            '{1} એ {0} વાગ્યે',
            '{1} એ {0} વાગ્યે',
            '{1} {0}',
            '{1} {0}'
          ],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [6, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale haw.
      "haw": new DateSymbols(
          NAME: "haw",
          ERAS: const ['BCE', 'CE'],
          ERANAMES: const ['BCE', 'CE'],
          NARROWMONTHS: const [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12'
          ],
          STANDALONENARROWMONTHS: const [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12'
          ],
          MONTHS: const [
            'Ianuali',
            'Pepeluali',
            'Malaki',
            'ʻApelila',
            'Mei',
            'Iune',
            'Iulai',
            'ʻAukake',
            'Kepakemapa',
            'ʻOkakopa',
            'Nowemapa',
            'Kekemapa'
          ],
          STANDALONEMONTHS: const [
            'Ianuali',
            'Pepeluali',
            'Malaki',
            'ʻApelila',
            'Mei',
            'Iune',
            'Iulai',
            'ʻAukake',
            'Kepakemapa',
            'ʻOkakopa',
            'Nowemapa',
            'Kekemapa'
          ],
          SHORTMONTHS: const [
            'Ian.',
            'Pep.',
            'Mal.',
            'ʻAp.',
            'Mei',
            'Iun.',
            'Iul.',
            'ʻAu.',
            'Kep.',
            'ʻOk.',
            'Now.',
            'Kek.'
          ],
          STANDALONESHORTMONTHS: const [
            'Ian.',
            'Pep.',
            'Mal.',
            'ʻAp.',
            'Mei',
            'Iun.',
            'Iul.',
            'ʻAu.',
            'Kep.',
            'ʻOk.',
            'Now.',
            'Kek.'
          ],
          WEEKDAYS: const [
            'Lāpule',
            'Poʻakahi',
            'Poʻalua',
            'Poʻakolu',
            'Poʻahā',
            'Poʻalima',
            'Poʻaono'
          ],
          STANDALONEWEEKDAYS: const [
            'Lāpule',
            'Poʻakahi',
            'Poʻalua',
            'Poʻakolu',
            'Poʻahā',
            'Poʻalima',
            'Poʻaono'
          ],
          SHORTWEEKDAYS: const ['LP', 'P1', 'P2', 'P3', 'P4', 'P5', 'P6'],
          STANDALONESHORTWEEKDAYS: const [
            'LP',
            'P1',
            'P2',
            'P3',
            'P4',
            'P5',
            'P6'
          ],
          NARROWWEEKDAYS: const ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
          STANDALONENARROWWEEKDAYS: const ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
          SHORTQUARTERS: const ['Q1', 'Q2', 'Q3', 'Q4'],
          QUARTERS: const ['Q1', 'Q2', 'Q3', 'Q4'],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'EEEE, d MMMM y',
            'd MMMM y',
            'd MMM y',
            'd/M/yy'
          ],
          TIMEFORMATS: const [
            'h:mm:ss a zzzz',
            'h:mm:ss a z',
            'h:mm:ss a',
            'h:mm a'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale he.
      "he": new DateSymbols(
          NAME: "he",
          ERAS: const ['לפנה״ס', 'לספירה'],
          ERANAMES: const ['לפני הספירה', 'לספירה'],
          NARROWMONTHS: const [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12'
          ],
          STANDALONENARROWMONTHS: const [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12'
          ],
          MONTHS: const [
            'ינואר',
            'פברואר',
            'מרץ',
            'אפריל',
            'מאי',
            'יוני',
            'יולי',
            'אוגוסט',
            'ספטמבר',
            'אוקטובר',
            'נובמבר',
            'דצמבר'
          ],
          STANDALONEMONTHS: const [
            'ינואר',
            'פברואר',
            'מרץ',
            'אפריל',
            'מאי',
            'יוני',
            'יולי',
            'אוגוסט',
            'ספטמבר',
            'אוקטובר',
            'נובמבר',
            'דצמבר'
          ],
          SHORTMONTHS: const [
            'ינו׳',
            'פבר׳',
            'מרץ',
            'אפר׳',
            'מאי',
            'יוני',
            'יולי',
            'אוג׳',
            'ספט׳',
            'אוק׳',
            'נוב׳',
            'דצמ׳'
          ],
          STANDALONESHORTMONTHS: const [
            'ינו׳',
            'פבר׳',
            'מרץ',
            'אפר׳',
            'מאי',
            'יוני',
            'יולי',
            'אוג׳',
            'ספט׳',
            'אוק׳',
            'נוב׳',
            'דצמ׳'
          ],
          WEEKDAYS: const [
            'יום ראשון',
            'יום שני',
            'יום שלישי',
            'יום רביעי',
            'יום חמישי',
            'יום שישי',
            'יום שבת'
          ],
          STANDALONEWEEKDAYS: const [
            'יום ראשון',
            'יום שני',
            'יום שלישי',
            'יום רביעי',
            'יום חמישי',
            'יום שישי',
            'יום שבת'
          ],
          SHORTWEEKDAYS: const [
            'יום א׳',
            'יום ב׳',
            'יום ג׳',
            'יום ד׳',
            'יום ה׳',
            'יום ו׳',
            'שבת'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'יום א׳',
            'יום ב׳',
            'יום ג׳',
            'יום ד׳',
            'יום ה׳',
            'יום ו׳',
            'שבת'
          ],
          NARROWWEEKDAYS: const ['א׳', 'ב׳', 'ג׳', 'ד׳', 'ה׳', 'ו׳', 'ש׳'],
          STANDALONENARROWWEEKDAYS: const [
            'א׳',
            'ב׳',
            'ג׳',
            'ד׳',
            'ה׳',
            'ו׳',
            'ש׳'
          ],
          SHORTQUARTERS: const ['Q1', 'Q2', 'Q3', 'Q4'],
          QUARTERS: const ['רבעון 1', 'רבעון 2', 'רבעון 3', 'רבעון 4'],
          AMPMS: const ['לפנה״צ', 'אחה״צ'],
          DATEFORMATS: const [
            'EEEE, d בMMMM y',
            'd בMMMM y',
            'd בMMM y',
            'd.M.y'
          ],
          TIMEFORMATS: const ['H:mm:ss zzzz', 'H:mm:ss z', 'H:mm:ss', 'H:mm'],
          DATETIMEFORMATS: const [
            '{1} בשעה {0}',
            '{1} בשעה {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [4, 5],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale hi.
      "hi": new DateSymbols(
          NAME: "hi",
          ERAS: const ['ईसा-पूर्व', 'ईस्वी'],
          ERANAMES: const ['ईसा-पूर्व', 'ईसवी सन'],
          NARROWMONTHS: const [
            'ज',
            'फ़',
            'मा',
            'अ',
            'म',
            'जू',
            'जु',
            'अ',
            'सि',
            'अ',
            'न',
            'दि'
          ],
          STANDALONENARROWMONTHS: const [
            'ज',
            'फ़',
            'मा',
            'अ',
            'म',
            'जू',
            'जु',
            'अ',
            'सि',
            'अ',
            'न',
            'दि'
          ],
          MONTHS: const [
            'जनवरी',
            'फ़रवरी',
            'मार्च',
            'अप्रैल',
            'मई',
            'जून',
            'जुलाई',
            'अगस्त',
            'सितंबर',
            'अक्तूबर',
            'नवंबर',
            'दिसंबर'
          ],
          STANDALONEMONTHS: const [
            'जनवरी',
            'फ़रवरी',
            'मार्च',
            'अप्रैल',
            'मई',
            'जून',
            'जुलाई',
            'अगस्त',
            'सितंबर',
            'अक्तूबर',
            'नवंबर',
            'दिसंबर'
          ],
          SHORTMONTHS: const [
            'जन॰',
            'फ़र॰',
            'मार्च',
            'अप्रैल',
            'मई',
            'जून',
            'जुल॰',
            'अग॰',
            'सित॰',
            'अक्तू॰',
            'नव॰',
            'दिस॰'
          ],
          STANDALONESHORTMONTHS: const [
            'जन॰',
            'फ़र॰',
            'मार्च',
            'अप्रैल',
            'मई',
            'जून',
            'जुल॰',
            'अग॰',
            'सित॰',
            'अक्तू॰',
            'नव॰',
            'दिस॰'
          ],
          WEEKDAYS: const [
            'रविवार',
            'सोमवार',
            'मंगलवार',
            'बुधवार',
            'गुरुवार',
            'शुक्रवार',
            'शनिवार'
          ],
          STANDALONEWEEKDAYS: const [
            'रविवार',
            'सोमवार',
            'मंगलवार',
            'बुधवार',
            'गुरुवार',
            'शुक्रवार',
            'शनिवार'
          ],
          SHORTWEEKDAYS: const [
            'रवि',
            'सोम',
            'मंगल',
            'बुध',
            'गुरु',
            'शुक्र',
            'शनि'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'रवि',
            'सोम',
            'मंगल',
            'बुध',
            'गुरु',
            'शुक्र',
            'शनि'
          ],
          NARROWWEEKDAYS: const ['र', 'सो', 'मं', 'बु', 'गु', 'शु', 'श'],
          STANDALONENARROWWEEKDAYS: const [
            'र',
            'सो',
            'मं',
            'बु',
            'गु',
            'शु',
            'श'
          ],
          SHORTQUARTERS: const ['ति1', 'ति2', 'ति3', 'ति4'],
          QUARTERS: const [
            'पहली तिमाही',
            'दूसरी तिमाही',
            'तीसरी तिमाही',
            'चौथी तिमाही'
          ],
          AMPMS: const ['am', 'pm'],
          DATEFORMATS: const [
            'EEEE, d MMMM y',
            'd MMMM y',
            'd MMM y',
            'd/M/yy'
          ],
          TIMEFORMATS: const [
            'h:mm:ss a zzzz',
            'h:mm:ss a z',
            'h:mm:ss a',
            'h:mm a'
          ],
          DATETIMEFORMATS: const [
            '{1} को {0}',
            '{1} को {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [6, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale hr.
      "hr": new DateSymbols(
          NAME: "hr",
          ERAS: const ['pr. Kr.', 'po. Kr.'],
          ERANAMES: const ['prije Krista', 'poslije Krista'],
          NARROWMONTHS: const [
            '1.',
            '2.',
            '3.',
            '4.',
            '5.',
            '6.',
            '7.',
            '8.',
            '9.',
            '10.',
            '11.',
            '12.'
          ],
          STANDALONENARROWMONTHS: const [
            '1.',
            '2.',
            '3.',
            '4.',
            '5.',
            '6.',
            '7.',
            '8.',
            '9.',
            '10.',
            '11.',
            '12.'
          ],
          MONTHS: const [
            'siječnja',
            'veljače',
            'ožujka',
            'travnja',
            'svibnja',
            'lipnja',
            'srpnja',
            'kolovoza',
            'rujna',
            'listopada',
            'studenoga',
            'prosinca'
          ],
          STANDALONEMONTHS: const [
            'siječanj',
            'veljača',
            'ožujak',
            'travanj',
            'svibanj',
            'lipanj',
            'srpanj',
            'kolovoz',
            'rujan',
            'listopad',
            'studeni',
            'prosinac'
          ],
          SHORTMONTHS: const [
            'sij',
            'velj',
            'ožu',
            'tra',
            'svi',
            'lip',
            'srp',
            'kol',
            'ruj',
            'lis',
            'stu',
            'pro'
          ],
          STANDALONESHORTMONTHS: const [
            'sij',
            'velj',
            'ožu',
            'tra',
            'svi',
            'lip',
            'srp',
            'kol',
            'ruj',
            'lis',
            'stu',
            'pro'
          ],
          WEEKDAYS: const [
            'nedjelja',
            'ponedjeljak',
            'utorak',
            'srijeda',
            'četvrtak',
            'petak',
            'subota'
          ],
          STANDALONEWEEKDAYS: const [
            'nedjelja',
            'ponedjeljak',
            'utorak',
            'srijeda',
            'četvrtak',
            'petak',
            'subota'
          ],
          SHORTWEEKDAYS: const [
            'ned',
            'pon',
            'uto',
            'sri',
            'čet',
            'pet',
            'sub'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'ned',
            'pon',
            'uto',
            'sri',
            'čet',
            'pet',
            'sub'
          ],
          NARROWWEEKDAYS: const ['N', 'P', 'U', 'S', 'Č', 'P', 'S'],
          STANDALONENARROWWEEKDAYS: const ['n', 'p', 'u', 's', 'č', 'p', 's'],
          SHORTQUARTERS: const ['1kv', '2kv', '3kv', '4kv'],
          QUARTERS: const [
            '1. kvartal',
            '2. kvartal',
            '3. kvartal',
            '4. kvartal'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'EEEE, d. MMMM y.',
            'd. MMMM y.',
            'd. MMM y.',
            'dd. MM. y.'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss (zzzz)',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const [
            '{1} \'u\' {0}',
            '{1} \'u\' {0}',
            '{1} {0}',
            '{1} {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 6),
      // Date/time formatting symbols for locale hu.
      "hu": new DateSymbols(
          NAME: "hu",
          ERAS: const ['i. e.', 'i. sz.'],
          ERANAMES: const ['Krisztus előtt', 'időszámításunk szerint'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'Á',
            'M',
            'J',
            'J',
            'A',
            'Sz',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'Á',
            'M',
            'J',
            'J',
            'A',
            'Sz',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'január',
            'február',
            'március',
            'április',
            'május',
            'június',
            'július',
            'augusztus',
            'szeptember',
            'október',
            'november',
            'december'
          ],
          STANDALONEMONTHS: const [
            'január',
            'február',
            'március',
            'április',
            'május',
            'június',
            'július',
            'augusztus',
            'szeptember',
            'október',
            'november',
            'december'
          ],
          SHORTMONTHS: const [
            'jan.',
            'febr.',
            'márc.',
            'ápr.',
            'máj.',
            'jún.',
            'júl.',
            'aug.',
            'szept.',
            'okt.',
            'nov.',
            'dec.'
          ],
          STANDALONESHORTMONTHS: const [
            'jan.',
            'febr.',
            'márc.',
            'ápr.',
            'máj.',
            'jún.',
            'júl.',
            'aug.',
            'szept.',
            'okt.',
            'nov.',
            'dec.'
          ],
          WEEKDAYS: const [
            'vasárnap',
            'hétfő',
            'kedd',
            'szerda',
            'csütörtök',
            'péntek',
            'szombat'
          ],
          STANDALONEWEEKDAYS: const [
            'vasárnap',
            'hétfő',
            'kedd',
            'szerda',
            'csütörtök',
            'péntek',
            'szombat'
          ],
          SHORTWEEKDAYS: const ['V', 'H', 'K', 'Sze', 'Cs', 'P', 'Szo'],
          STANDALONESHORTWEEKDAYS: const [
            'V',
            'H',
            'K',
            'Sze',
            'Cs',
            'P',
            'Szo'
          ],
          NARROWWEEKDAYS: const ['V', 'H', 'K', 'Sz', 'Cs', 'P', 'Sz'],
          STANDALONENARROWWEEKDAYS: const [
            'V',
            'H',
            'K',
            'Sz',
            'Cs',
            'P',
            'Sz'
          ],
          SHORTQUARTERS: const ['I. n.év', 'II. n.év', 'III. n.év', 'IV. n.év'],
          QUARTERS: const [
            'I. negyedév',
            'II. negyedév',
            'III. negyedév',
            'IV. negyedév'
          ],
          AMPMS: const ['de.', 'du.'],
          DATEFORMATS: const [
            'y. MMMM d., EEEE',
            'y. MMMM d.',
            'y. MMM d.',
            'y. MM. dd.'
          ],
          TIMEFORMATS: const ['H:mm:ss zzzz', 'H:mm:ss z', 'H:mm:ss', 'H:mm'],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale hy.
      "hy": new DateSymbols(
          NAME: "hy",
          ERAS: const ['մ.թ.ա.', 'մ.թ.'],
          ERANAMES: const ['Քրիստոսից առաջ', 'Քրիստոսից հետո'],
          NARROWMONTHS: const [
            'Հ',
            'Փ',
            'Մ',
            'Ա',
            'Մ',
            'Հ',
            'Հ',
            'Օ',
            'Ս',
            'Հ',
            'Ն',
            'Դ'
          ],
          STANDALONENARROWMONTHS: const [
            'Հ',
            'Փ',
            'Մ',
            'Ա',
            'Մ',
            'Հ',
            'Հ',
            'Օ',
            'Ս',
            'Հ',
            'Ն',
            'Դ'
          ],
          MONTHS: const [
            'հունվարի',
            'փետրվարի',
            'մարտի',
            'ապրիլի',
            'մայիսի',
            'հունիսի',
            'հուլիսի',
            'օգոստոսի',
            'սեպտեմբերի',
            'հոկտեմբերի',
            'նոյեմբերի',
            'դեկտեմբերի'
          ],
          STANDALONEMONTHS: const [
            'հունվար',
            'փետրվար',
            'մարտ',
            'ապրիլ',
            'մայիս',
            'հունիս',
            'հուլիս',
            'օգոստոս',
            'սեպտեմբեր',
            'հոկտեմբեր',
            'նոյեմբեր',
            'դեկտեմբեր'
          ],
          SHORTMONTHS: const [
            'հնվ',
            'փտվ',
            'մրտ',
            'ապր',
            'մյս',
            'հնս',
            'հլս',
            'օգս',
            'սեպ',
            'հոկ',
            'նոյ',
            'դեկ'
          ],
          STANDALONESHORTMONTHS: const [
            'հնվ',
            'փտվ',
            'մրտ',
            'ապր',
            'մյս',
            'հնս',
            'հլս',
            'օգս',
            'սեպ',
            'հոկ',
            'նոյ',
            'դեկ'
          ],
          WEEKDAYS: const [
            'կիրակի',
            'երկուշաբթի',
            'երեքշաբթի',
            'չորեքշաբթի',
            'հինգշաբթի',
            'ուրբաթ',
            'շաբաթ'
          ],
          STANDALONEWEEKDAYS: const [
            'կիրակի',
            'երկուշաբթի',
            'երեքշաբթի',
            'չորեքշաբթի',
            'հինգշաբթի',
            'ուրբաթ',
            'շաբաթ'
          ],
          SHORTWEEKDAYS: const [
            'կիր',
            'երկ',
            'երք',
            'չրք',
            'հնգ',
            'ուր',
            'շբթ'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'կիր',
            'երկ',
            'երք',
            'չրք',
            'հնգ',
            'ուր',
            'շբթ'
          ],
          NARROWWEEKDAYS: const ['Կ', 'Ե', 'Ե', 'Չ', 'Հ', 'Ո', 'Շ'],
          STANDALONENARROWWEEKDAYS: const ['Կ', 'Ե', 'Ե', 'Չ', 'Հ', 'Ո', 'Շ'],
          SHORTQUARTERS: const [
            '1-ին եռմս.',
            '2-րդ եռմս.',
            '3-րդ եռմս.',
            '4-րդ եռմս.'
          ],
          QUARTERS: const [
            '1-ին եռամսյակ',
            '2-րդ եռամսյակ',
            '3-րդ եռամսյակ',
            '4-րդ եռամսյակ'
          ],
          AMPMS: const ['ԿԱ', 'ԿՀ'],
          DATEFORMATS: const [
            'y թ. MMMM d, EEEE',
            'dd MMMM, y թ.',
            'dd MMM, y թ.',
            'dd.MM.yy'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const [
            '{1}, {0}',
            '{1}, {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 6),
      // Date/time formatting symbols for locale id.
      "id": new DateSymbols(
          NAME: "id",
          ERAS: const ['SM', 'M'],
          ERANAMES: const ['Sebelum Masehi', 'Masehi'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'Januari',
            'Februari',
            'Maret',
            'April',
            'Mei',
            'Juni',
            'Juli',
            'Agustus',
            'September',
            'Oktober',
            'November',
            'Desember'
          ],
          STANDALONEMONTHS: const [
            'Januari',
            'Februari',
            'Maret',
            'April',
            'Mei',
            'Juni',
            'Juli',
            'Agustus',
            'September',
            'Oktober',
            'November',
            'Desember'
          ],
          SHORTMONTHS: const [
            'Jan',
            'Feb',
            'Mar',
            'Apr',
            'Mei',
            'Jun',
            'Jul',
            'Agt',
            'Sep',
            'Okt',
            'Nov',
            'Des'
          ],
          STANDALONESHORTMONTHS: const [
            'Jan',
            'Feb',
            'Mar',
            'Apr',
            'Mei',
            'Jun',
            'Jul',
            'Agt',
            'Sep',
            'Okt',
            'Nov',
            'Des'
          ],
          WEEKDAYS: const [
            'Minggu',
            'Senin',
            'Selasa',
            'Rabu',
            'Kamis',
            'Jumat',
            'Sabtu'
          ],
          STANDALONEWEEKDAYS: const [
            'Minggu',
            'Senin',
            'Selasa',
            'Rabu',
            'Kamis',
            'Jumat',
            'Sabtu'
          ],
          SHORTWEEKDAYS: const [
            'Min',
            'Sen',
            'Sel',
            'Rab',
            'Kam',
            'Jum',
            'Sab'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'Min',
            'Sen',
            'Sel',
            'Rab',
            'Kam',
            'Jum',
            'Sab'
          ],
          NARROWWEEKDAYS: const ['M', 'S', 'S', 'R', 'K', 'J', 'S'],
          STANDALONENARROWWEEKDAYS: const ['M', 'S', 'S', 'R', 'K', 'J', 'S'],
          SHORTQUARTERS: const ['K1', 'K2', 'K3', 'K4'],
          QUARTERS: const [
            'Kuartal ke-1',
            'Kuartal ke-2',
            'Kuartal ke-3',
            'Kuartal ke-4'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'EEEE, dd MMMM y',
            'd MMMM y',
            'd MMM y',
            'dd/MM/yy'
          ],
          TIMEFORMATS: const [
            'HH.mm.ss zzzz',
            'HH.mm.ss z',
            'HH.mm.ss',
            'HH.mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale in.
      "in": new DateSymbols(
          NAME: "in",
          ERAS: const ['SM', 'M'],
          ERANAMES: const ['Sebelum Masehi', 'Masehi'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'Januari',
            'Februari',
            'Maret',
            'April',
            'Mei',
            'Juni',
            'Juli',
            'Agustus',
            'September',
            'Oktober',
            'November',
            'Desember'
          ],
          STANDALONEMONTHS: const [
            'Januari',
            'Februari',
            'Maret',
            'April',
            'Mei',
            'Juni',
            'Juli',
            'Agustus',
            'September',
            'Oktober',
            'November',
            'Desember'
          ],
          SHORTMONTHS: const [
            'Jan',
            'Feb',
            'Mar',
            'Apr',
            'Mei',
            'Jun',
            'Jul',
            'Agt',
            'Sep',
            'Okt',
            'Nov',
            'Des'
          ],
          STANDALONESHORTMONTHS: const [
            'Jan',
            'Feb',
            'Mar',
            'Apr',
            'Mei',
            'Jun',
            'Jul',
            'Agt',
            'Sep',
            'Okt',
            'Nov',
            'Des'
          ],
          WEEKDAYS: const [
            'Minggu',
            'Senin',
            'Selasa',
            'Rabu',
            'Kamis',
            'Jumat',
            'Sabtu'
          ],
          STANDALONEWEEKDAYS: const [
            'Minggu',
            'Senin',
            'Selasa',
            'Rabu',
            'Kamis',
            'Jumat',
            'Sabtu'
          ],
          SHORTWEEKDAYS: const [
            'Min',
            'Sen',
            'Sel',
            'Rab',
            'Kam',
            'Jum',
            'Sab'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'Min',
            'Sen',
            'Sel',
            'Rab',
            'Kam',
            'Jum',
            'Sab'
          ],
          NARROWWEEKDAYS: const ['M', 'S', 'S', 'R', 'K', 'J', 'S'],
          STANDALONENARROWWEEKDAYS: const ['M', 'S', 'S', 'R', 'K', 'J', 'S'],
          SHORTQUARTERS: const ['K1', 'K2', 'K3', 'K4'],
          QUARTERS: const [
            'Kuartal ke-1',
            'Kuartal ke-2',
            'Kuartal ke-3',
            'Kuartal ke-4'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'EEEE, dd MMMM y',
            'd MMMM y',
            'd MMM y',
            'dd/MM/yy'
          ],
          TIMEFORMATS: const [
            'HH.mm.ss zzzz',
            'HH.mm.ss z',
            'HH.mm.ss',
            'HH.mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale is.
      "is": new DateSymbols(
          NAME: "is",
          ERAS: const ['f.Kr.', 'e.Kr.'],
          ERANAMES: const ['fyrir Krist', 'eftir Krist'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'Á',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'Á',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'janúar',
            'febrúar',
            'mars',
            'apríl',
            'maí',
            'júní',
            'júlí',
            'ágúst',
            'september',
            'október',
            'nóvember',
            'desember'
          ],
          STANDALONEMONTHS: const [
            'janúar',
            'febrúar',
            'mars',
            'apríl',
            'maí',
            'júní',
            'júlí',
            'ágúst',
            'september',
            'október',
            'nóvember',
            'desember'
          ],
          SHORTMONTHS: const [
            'jan.',
            'feb.',
            'mar.',
            'apr.',
            'maí',
            'jún.',
            'júl.',
            'ágú.',
            'sep.',
            'okt.',
            'nóv.',
            'des.'
          ],
          STANDALONESHORTMONTHS: const [
            'jan.',
            'feb.',
            'mar.',
            'apr.',
            'maí',
            'jún.',
            'júl.',
            'ágú.',
            'sep.',
            'okt.',
            'nóv.',
            'des.'
          ],
          WEEKDAYS: const [
            'sunnudagur',
            'mánudagur',
            'þriðjudagur',
            'miðvikudagur',
            'fimmtudagur',
            'föstudagur',
            'laugardagur'
          ],
          STANDALONEWEEKDAYS: const [
            'sunnudagur',
            'mánudagur',
            'þriðjudagur',
            'miðvikudagur',
            'fimmtudagur',
            'föstudagur',
            'laugardagur'
          ],
          SHORTWEEKDAYS: const [
            'sun.',
            'mán.',
            'þri.',
            'mið.',
            'fim.',
            'fös.',
            'lau.'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'sun.',
            'mán.',
            'þri.',
            'mið.',
            'fim.',
            'fös.',
            'lau.'
          ],
          NARROWWEEKDAYS: const ['S', 'M', 'Þ', 'M', 'F', 'F', 'L'],
          STANDALONENARROWWEEKDAYS: const ['S', 'M', 'Þ', 'M', 'F', 'F', 'L'],
          SHORTQUARTERS: const ['F1', 'F2', 'F3', 'F4'],
          QUARTERS: const [
            '1. fjórðungur',
            '2. fjórðungur',
            '3. fjórðungur',
            '4. fjórðungur'
          ],
          AMPMS: const ['f.h.', 'e.h.'],
          DATEFORMATS: const [
            'EEEE, d. MMMM y',
            'd. MMMM y',
            'd. MMM y',
            'd.M.y'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const [
            '{1} \'kl\'. {0}',
            '{1} \'kl\'. {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale it.
      "it": new DateSymbols(
          NAME: "it",
          ERAS: const ['a.C.', 'd.C.'],
          ERANAMES: const ['avanti Cristo', 'dopo Cristo'],
          NARROWMONTHS: const [
            'G',
            'F',
            'M',
            'A',
            'M',
            'G',
            'L',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'G',
            'F',
            'M',
            'A',
            'M',
            'G',
            'L',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'gennaio',
            'febbraio',
            'marzo',
            'aprile',
            'maggio',
            'giugno',
            'luglio',
            'agosto',
            'settembre',
            'ottobre',
            'novembre',
            'dicembre'
          ],
          STANDALONEMONTHS: const [
            'gennaio',
            'febbraio',
            'marzo',
            'aprile',
            'maggio',
            'giugno',
            'luglio',
            'agosto',
            'settembre',
            'ottobre',
            'novembre',
            'dicembre'
          ],
          SHORTMONTHS: const [
            'gen',
            'feb',
            'mar',
            'apr',
            'mag',
            'giu',
            'lug',
            'ago',
            'set',
            'ott',
            'nov',
            'dic'
          ],
          STANDALONESHORTMONTHS: const [
            'gen',
            'feb',
            'mar',
            'apr',
            'mag',
            'giu',
            'lug',
            'ago',
            'set',
            'ott',
            'nov',
            'dic'
          ],
          WEEKDAYS: const [
            'domenica',
            'lunedì',
            'martedì',
            'mercoledì',
            'giovedì',
            'venerdì',
            'sabato'
          ],
          STANDALONEWEEKDAYS: const [
            'domenica',
            'lunedì',
            'martedì',
            'mercoledì',
            'giovedì',
            'venerdì',
            'sabato'
          ],
          SHORTWEEKDAYS: const [
            'dom',
            'lun',
            'mar',
            'mer',
            'gio',
            'ven',
            'sab'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'dom',
            'lun',
            'mar',
            'mer',
            'gio',
            'ven',
            'sab'
          ],
          NARROWWEEKDAYS: const ['D', 'L', 'M', 'M', 'G', 'V', 'S'],
          STANDALONENARROWWEEKDAYS: const ['D', 'L', 'M', 'M', 'G', 'V', 'S'],
          SHORTQUARTERS: const ['T1', 'T2', 'T3', 'T4'],
          QUARTERS: const [
            '1º trimestre',
            '2º trimestre',
            '3º trimestre',
            '4º trimestre'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'EEEE d MMMM y',
            'd MMMM y',
            'd MMM y',
            'dd/MM/yy'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1}, {0}', '{1}, {0}'],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale it_CH.
      "it_CH": new DateSymbols(
          NAME: "it_CH",
          ERAS: const ['a.C.', 'd.C.'],
          ERANAMES: const ['avanti Cristo', 'dopo Cristo'],
          NARROWMONTHS: const [
            'G',
            'F',
            'M',
            'A',
            'M',
            'G',
            'L',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'G',
            'F',
            'M',
            'A',
            'M',
            'G',
            'L',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'gennaio',
            'febbraio',
            'marzo',
            'aprile',
            'maggio',
            'giugno',
            'luglio',
            'agosto',
            'settembre',
            'ottobre',
            'novembre',
            'dicembre'
          ],
          STANDALONEMONTHS: const [
            'gennaio',
            'febbraio',
            'marzo',
            'aprile',
            'maggio',
            'giugno',
            'luglio',
            'agosto',
            'settembre',
            'ottobre',
            'novembre',
            'dicembre'
          ],
          SHORTMONTHS: const [
            'gen',
            'feb',
            'mar',
            'apr',
            'mag',
            'giu',
            'lug',
            'ago',
            'set',
            'ott',
            'nov',
            'dic'
          ],
          STANDALONESHORTMONTHS: const [
            'gen',
            'feb',
            'mar',
            'apr',
            'mag',
            'giu',
            'lug',
            'ago',
            'set',
            'ott',
            'nov',
            'dic'
          ],
          WEEKDAYS: const [
            'domenica',
            'lunedì',
            'martedì',
            'mercoledì',
            'giovedì',
            'venerdì',
            'sabato'
          ],
          STANDALONEWEEKDAYS: const [
            'domenica',
            'lunedì',
            'martedì',
            'mercoledì',
            'giovedì',
            'venerdì',
            'sabato'
          ],
          SHORTWEEKDAYS: const [
            'dom',
            'lun',
            'mar',
            'mer',
            'gio',
            'ven',
            'sab'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'dom',
            'lun',
            'mar',
            'mer',
            'gio',
            'ven',
            'sab'
          ],
          NARROWWEEKDAYS: const ['D', 'L', 'M', 'M', 'G', 'V', 'S'],
          STANDALONENARROWWEEKDAYS: const ['D', 'L', 'M', 'M', 'G', 'V', 'S'],
          SHORTQUARTERS: const ['T1', 'T2', 'T3', 'T4'],
          QUARTERS: const [
            '1º trimestre',
            '2º trimestre',
            '3º trimestre',
            '4º trimestre'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'EEEE, d MMMM y',
            'd MMMM y',
            'd MMM y',
            'dd.MM.yy'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1}, {0}', '{1}, {0}'],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale iw.
      "iw": new DateSymbols(
          NAME: "iw",
          ERAS: const ['לפנה״ס', 'לספירה'],
          ERANAMES: const ['לפני הספירה', 'לספירה'],
          NARROWMONTHS: const [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12'
          ],
          STANDALONENARROWMONTHS: const [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12'
          ],
          MONTHS: const [
            'ינואר',
            'פברואר',
            'מרץ',
            'אפריל',
            'מאי',
            'יוני',
            'יולי',
            'אוגוסט',
            'ספטמבר',
            'אוקטובר',
            'נובמבר',
            'דצמבר'
          ],
          STANDALONEMONTHS: const [
            'ינואר',
            'פברואר',
            'מרץ',
            'אפריל',
            'מאי',
            'יוני',
            'יולי',
            'אוגוסט',
            'ספטמבר',
            'אוקטובר',
            'נובמבר',
            'דצמבר'
          ],
          SHORTMONTHS: const [
            'ינו׳',
            'פבר׳',
            'מרץ',
            'אפר׳',
            'מאי',
            'יוני',
            'יולי',
            'אוג׳',
            'ספט׳',
            'אוק׳',
            'נוב׳',
            'דצמ׳'
          ],
          STANDALONESHORTMONTHS: const [
            'ינו׳',
            'פבר׳',
            'מרץ',
            'אפר׳',
            'מאי',
            'יוני',
            'יולי',
            'אוג׳',
            'ספט׳',
            'אוק׳',
            'נוב׳',
            'דצמ׳'
          ],
          WEEKDAYS: const [
            'יום ראשון',
            'יום שני',
            'יום שלישי',
            'יום רביעי',
            'יום חמישי',
            'יום שישי',
            'יום שבת'
          ],
          STANDALONEWEEKDAYS: const [
            'יום ראשון',
            'יום שני',
            'יום שלישי',
            'יום רביעי',
            'יום חמישי',
            'יום שישי',
            'יום שבת'
          ],
          SHORTWEEKDAYS: const [
            'יום א׳',
            'יום ב׳',
            'יום ג׳',
            'יום ד׳',
            'יום ה׳',
            'יום ו׳',
            'שבת'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'יום א׳',
            'יום ב׳',
            'יום ג׳',
            'יום ד׳',
            'יום ה׳',
            'יום ו׳',
            'שבת'
          ],
          NARROWWEEKDAYS: const ['א׳', 'ב׳', 'ג׳', 'ד׳', 'ה׳', 'ו׳', 'ש׳'],
          STANDALONENARROWWEEKDAYS: const [
            'א׳',
            'ב׳',
            'ג׳',
            'ד׳',
            'ה׳',
            'ו׳',
            'ש׳'
          ],
          SHORTQUARTERS: const ['Q1', 'Q2', 'Q3', 'Q4'],
          QUARTERS: const ['רבעון 1', 'רבעון 2', 'רבעון 3', 'רבעון 4'],
          AMPMS: const ['לפנה״צ', 'אחה״צ'],
          DATEFORMATS: const [
            'EEEE, d בMMMM y',
            'd בMMMM y',
            'd בMMM y',
            'd.M.y'
          ],
          TIMEFORMATS: const ['H:mm:ss zzzz', 'H:mm:ss z', 'H:mm:ss', 'H:mm'],
          DATETIMEFORMATS: const [
            '{1} בשעה {0}',
            '{1} בשעה {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [4, 5],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale ja.
      "ja": new DateSymbols(
          NAME: "ja",
          ERAS: const ['紀元前', '西暦'],
          ERANAMES: const ['紀元前', '西暦'],
          NARROWMONTHS: const [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12'
          ],
          STANDALONENARROWMONTHS: const [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12'
          ],
          MONTHS: const [
            '1月',
            '2月',
            '3月',
            '4月',
            '5月',
            '6月',
            '7月',
            '8月',
            '9月',
            '10月',
            '11月',
            '12月'
          ],
          STANDALONEMONTHS: const [
            '1月',
            '2月',
            '3月',
            '4月',
            '5月',
            '6月',
            '7月',
            '8月',
            '9月',
            '10月',
            '11月',
            '12月'
          ],
          SHORTMONTHS: const [
            '1月',
            '2月',
            '3月',
            '4月',
            '5月',
            '6月',
            '7月',
            '8月',
            '9月',
            '10月',
            '11月',
            '12月'
          ],
          STANDALONESHORTMONTHS: const [
            '1月',
            '2月',
            '3月',
            '4月',
            '5月',
            '6月',
            '7月',
            '8月',
            '9月',
            '10月',
            '11月',
            '12月'
          ],
          WEEKDAYS: const ['日曜日', '月曜日', '火曜日', '水曜日', '木曜日', '金曜日', '土曜日'],
          STANDALONEWEEKDAYS: const [
            '日曜日',
            '月曜日',
            '火曜日',
            '水曜日',
            '木曜日',
            '金曜日',
            '土曜日'
          ],
          SHORTWEEKDAYS: const ['日', '月', '火', '水', '木', '金', '土'],
          STANDALONESHORTWEEKDAYS: const ['日', '月', '火', '水', '木', '金', '土'],
          NARROWWEEKDAYS: const ['日', '月', '火', '水', '木', '金', '土'],
          STANDALONENARROWWEEKDAYS: const ['日', '月', '火', '水', '木', '金', '土'],
          SHORTQUARTERS: const ['Q1', 'Q2', 'Q3', 'Q4'],
          QUARTERS: const ['第1四半期', '第2四半期', '第3四半期', '第4四半期'],
          AMPMS: const ['午前', '午後'],
          DATEFORMATS: const ['y年M月d日EEEE', 'y年M月d日', 'y/MM/dd', 'y/MM/dd'],
          TIMEFORMATS: const ['H時mm分ss秒 zzzz', 'H:mm:ss z', 'H:mm:ss', 'H:mm'],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale ka.
      "ka": new DateSymbols(
          NAME: "ka",
          ERAS: const ['ძვ. წ.', 'ახ. წ.'],
          ERANAMES: const ['ძველი წელთაღრიცხვით', 'ახალი წელთაღრიცხვით'],
          NARROWMONTHS: const [
            'ი',
            'თ',
            'მ',
            'ა',
            'მ',
            'ი',
            'ი',
            'ა',
            'ს',
            'ო',
            'ნ',
            'დ'
          ],
          STANDALONENARROWMONTHS: const [
            'ი',
            'თ',
            'მ',
            'ა',
            'მ',
            'ი',
            'ი',
            'ა',
            'ს',
            'ო',
            'ნ',
            'დ'
          ],
          MONTHS: const [
            'იანვარი',
            'თებერვალი',
            'მარტი',
            'აპრილი',
            'მაისი',
            'ივნისი',
            'ივლისი',
            'აგვისტო',
            'სექტემბერი',
            'ოქტომბერი',
            'ნოემბერი',
            'დეკემბერი'
          ],
          STANDALONEMONTHS: const [
            'იანვარი',
            'თებერვალი',
            'მარტი',
            'აპრილი',
            'მაისი',
            'ივნისი',
            'ივლისი',
            'აგვისტო',
            'სექტემბერი',
            'ოქტომბერი',
            'ნოემბერი',
            'დეკემბერი'
          ],
          SHORTMONTHS: const [
            'იან',
            'თებ',
            'მარ',
            'აპრ',
            'მაი',
            'ივნ',
            'ივლ',
            'აგვ',
            'სექ',
            'ოქტ',
            'ნოე',
            'დეკ'
          ],
          STANDALONESHORTMONTHS: const [
            'იან',
            'თებ',
            'მარ',
            'აპრ',
            'მაი',
            'ივნ',
            'ივლ',
            'აგვ',
            'სექ',
            'ოქტ',
            'ნოე',
            'დეკ'
          ],
          WEEKDAYS: const [
            'კვირა',
            'ორშაბათი',
            'სამშაბათი',
            'ოთხშაბათი',
            'ხუთშაბათი',
            'პარასკევი',
            'შაბათი'
          ],
          STANDALONEWEEKDAYS: const [
            'კვირა',
            'ორშაბათი',
            'სამშაბათი',
            'ოთხშაბათი',
            'ხუთშაბათი',
            'პარასკევი',
            'შაბათი'
          ],
          SHORTWEEKDAYS: const [
            'კვი',
            'ორშ',
            'სამ',
            'ოთხ',
            'ხუთ',
            'პარ',
            'შაბ'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'კვი',
            'ორშ',
            'სამ',
            'ოთხ',
            'ხუთ',
            'პარ',
            'შაბ'
          ],
          NARROWWEEKDAYS: const ['კ', 'ო', 'ს', 'ო', 'ხ', 'პ', 'შ'],
          STANDALONENARROWWEEKDAYS: const ['კ', 'ო', 'ს', 'ო', 'ხ', 'პ', 'შ'],
          SHORTQUARTERS: const ['I კვ.', 'II კვ.', 'III კვ.', 'IV კვ.'],
          QUARTERS: const [
            'I კვარტალი',
            'II კვარტალი',
            'III კვარტალი',
            'IV კვარტალი'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'EEEE, dd MMMM, y',
            'd MMMM, y',
            'd MMM. y',
            'dd.MM.yy'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const [
            '{1}, {0}',
            '{1}, {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 6),
      // Date/time formatting symbols for locale kk.
      "kk": new DateSymbols(
          NAME: "kk",
          ERAS: const ['б.з.д.', 'б.з.'],
          ERANAMES: const ['Біздің заманымызға дейін', 'біздің заманымыз'],
          NARROWMONTHS: const [
            'Қ',
            'А',
            'Н',
            'С',
            'М',
            'М',
            'Ш',
            'Т',
            'Қ',
            'Қ',
            'Қ',
            'Ж'
          ],
          STANDALONENARROWMONTHS: const [
            'Қ',
            'А',
            'Н',
            'С',
            'М',
            'М',
            'Ш',
            'Т',
            'Қ',
            'Қ',
            'Қ',
            'Ж'
          ],
          MONTHS: const [
            'қаңтар',
            'ақпан',
            'наурыз',
            'сәуір',
            'мамыр',
            'маусым',
            'шілде',
            'тамыз',
            'қыркүйек',
            'қазан',
            'қараша',
            'желтоқсан'
          ],
          STANDALONEMONTHS: const [
            'Қаңтар',
            'Ақпан',
            'Наурыз',
            'Сәуір',
            'Мамыр',
            'Маусым',
            'Шілде',
            'Тамыз',
            'Қыркүйек',
            'Қазан',
            'Қараша',
            'Желтоқсан'
          ],
          SHORTMONTHS: const [
            'қаң.',
            'ақп.',
            'нау.',
            'сәу.',
            'мам.',
            'мау.',
            'шіл.',
            'там.',
            'қыр.',
            'қаз.',
            'қар.',
            'жел.'
          ],
          STANDALONESHORTMONTHS: const [
            'Қаң.',
            'Ақп.',
            'Нау.',
            'Сәу.',
            'Мам.',
            'Мау.',
            'Шіл.',
            'Там.',
            'Қыр.',
            'Қаз.',
            'Қар.',
            'Жел.'
          ],
          WEEKDAYS: const [
            'жексенбі',
            'дүйсенбі',
            'сейсенбі',
            'сәрсенбі',
            'бейсенбі',
            'жұма',
            'сенбі'
          ],
          STANDALONEWEEKDAYS: const [
            'Жексенбі',
            'Дүйсенбі',
            'Сейсенбі',
            'Сәрсенбі',
            'Бейсенбі',
            'Жұма',
            'Сенбі'
          ],
          SHORTWEEKDAYS: const ['Жс', 'Дс', 'Сс', 'Ср', 'Бс', 'Жм', 'Сб'],
          STANDALONESHORTWEEKDAYS: const [
            'Жс',
            'Дс',
            'Сс',
            'Ср',
            'Бс',
            'Жм',
            'Сб'
          ],
          NARROWWEEKDAYS: const ['Ж', 'Д', 'С', 'С', 'Б', 'Ж', 'С'],
          STANDALONENARROWWEEKDAYS: const ['Ж', 'Д', 'С', 'С', 'Б', 'Ж', 'С'],
          SHORTQUARTERS: const ['І тқс.', 'ІІ тқс.', 'ІІІ тқс.', 'IV тқс.'],
          QUARTERS: const ['І тоқсан', 'ІІ тоқсан', 'ІІІ тоқсан', 'IV тоқсан'],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'y \'ж\'. d MMMM, EEEE',
            'y \'ж\'. d MMMM',
            'y \'ж\'. dd MMM',
            'dd.MM.yy'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const [
            '{1}, {0}',
            '{1}, {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 6),
      // Date/time formatting symbols for locale km.
      "km": new DateSymbols(
          NAME: "km",
          ERAS: const ['មុន គ.ស.', 'គ.ស.'],
          ERANAMES: const ['មុន​គ្រិស្តសករាជ', 'គ្រិស្តសករាជ'],
          NARROWMONTHS: const [
            'ម',
            'ក',
            'ម',
            'ម',
            'ឧ',
            'ម',
            'ក',
            'ស',
            'ក',
            'ត',
            'វ',
            'ធ'
          ],
          STANDALONENARROWMONTHS: const [
            'ម',
            'ក',
            'ម',
            'ម',
            'ឧ',
            'ម',
            'ក',
            'ស',
            'ក',
            'ត',
            'វ',
            'ធ'
          ],
          MONTHS: const [
            'មករា',
            'កុម្ភៈ',
            'មីនា',
            'មេសា',
            'ឧសភា',
            'មិថុនា',
            'កក្កដា',
            'សីហា',
            'កញ្ញា',
            'តុលា',
            'វិច្ឆិកា',
            'ធ្នូ'
          ],
          STANDALONEMONTHS: const [
            'មករា',
            'កុម្ភៈ',
            'មីនា',
            'មេសា',
            'ឧសភា',
            'មិថុនា',
            'កក្កដា',
            'សីហា',
            'កញ្ញា',
            'តុលា',
            'វិច្ឆិកា',
            'ធ្នូ'
          ],
          SHORTMONTHS: const [
            'មករា',
            'កុម្ភៈ',
            'មីនា',
            'មេសា',
            'ឧសភា',
            'មិថុនា',
            'កក្កដា',
            'សីហា',
            'កញ្ញា',
            'តុលា',
            'វិច្ឆិកា',
            'ធ្នូ'
          ],
          STANDALONESHORTMONTHS: const [
            'មករា',
            'កុម្ភៈ',
            'មីនា',
            'មេសា',
            'ឧសភា',
            'មិថុនា',
            'កក្កដា',
            'សីហា',
            'កញ្ញា',
            'តុលា',
            'វិច្ឆិកា',
            'ធ្នូ'
          ],
          WEEKDAYS: const [
            'អាទិត្យ',
            'ច័ន្ទ',
            'អង្គារ',
            'ពុធ',
            'ព្រហស្បតិ៍',
            'សុក្រ',
            'សៅរ៍'
          ],
          STANDALONEWEEKDAYS: const [
            'អាទិត្យ',
            'ច័ន្ទ',
            'អង្គារ',
            'ពុធ',
            'ព្រហស្បតិ៍',
            'សុក្រ',
            'សៅរ៍'
          ],
          SHORTWEEKDAYS: const [
            'អាទិត្យ',
            'ច័ន្ទ',
            'អង្គារ',
            'ពុធ',
            'ព្រហស្បតិ៍',
            'សុក្រ',
            'សៅរ៍'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'អាទិត្យ',
            'ច័ន្ទ',
            'អង្គារ',
            'ពុធ',
            'ព្រហស្បតិ៍',
            'សុក្រ',
            'សៅរ៍'
          ],
          NARROWWEEKDAYS: const ['អ', 'ច', 'អ', 'ព', 'ព', 'ស', 'ស'],
          STANDALONENARROWWEEKDAYS: const ['អ', 'ច', 'អ', 'ព', 'ព', 'ស', 'ស'],
          SHORTQUARTERS: const [
            'ត្រីមាសទី 1',
            'ត្រីមាសទី 2',
            'ត្រីមាសទី 3',
            'ត្រីមាសទី 4'
          ],
          QUARTERS: const [
            'ត្រីមាសទី 1',
            'ត្រីមាសទី 2',
            'ត្រីមាសទី 3',
            'ត្រីមាសទី 4'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const ['EEEE d MMMM y', 'd MMMM y', 'd MMM y', 'd/M/yy'],
          TIMEFORMATS: const [
            'h:mm:ss a zzzz',
            'h:mm:ss a z',
            'h:mm:ss a',
            'h:mm a'
          ],
          DATETIMEFORMATS: const [
            '{1} នៅ​ម៉ោង {0}',
            '{1} នៅ​ម៉ោង {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale kn.
      "kn": new DateSymbols(
          NAME: "kn",
          ERAS: const ['ಕ್ರಿ.ಪೂ', 'ಕ್ರಿ.ಶ'],
          ERANAMES: const ['ಕ್ರಿಸ್ತ ಪೂರ್ವ', 'ಕ್ರಿಸ್ತ ಶಕ'],
          NARROWMONTHS: const [
            'ಜ',
            'ಫೆ',
            'ಮಾ',
            'ಏ',
            'ಮೇ',
            'ಜೂ',
            'ಜು',
            'ಆ',
            'ಸೆ',
            'ಅ',
            'ನ',
            'ಡಿ'
          ],
          STANDALONENARROWMONTHS: const [
            'ಜ',
            'ಫೆ',
            'ಮಾ',
            'ಏ',
            'ಮೇ',
            'ಜೂ',
            'ಜು',
            'ಆ',
            'ಸೆ',
            'ಅ',
            'ನ',
            'ಡಿ'
          ],
          MONTHS: const [
            'ಜನವರಿ',
            'ಫೆಬ್ರವರಿ',
            'ಮಾರ್ಚ್',
            'ಏಪ್ರಿಲ್',
            'ಮೇ',
            'ಜೂನ್',
            'ಜುಲೈ',
            'ಆಗಸ್ಟ್',
            'ಸೆಪ್ಟೆಂಬರ್',
            'ಅಕ್ಟೋಬರ್',
            'ನವೆಂಬರ್',
            'ಡಿಸೆಂಬರ್'
          ],
          STANDALONEMONTHS: const [
            'ಜನವರಿ',
            'ಫೆಬ್ರವರಿ',
            'ಮಾರ್ಚ್',
            'ಏಪ್ರಿಲ್',
            'ಮೇ',
            'ಜೂನ್',
            'ಜುಲೈ',
            'ಆಗಸ್ಟ್',
            'ಸೆಪ್ಟೆಂಬರ್',
            'ಅಕ್ಟೋಬರ್',
            'ನವೆಂಬರ್',
            'ಡಿಸೆಂಬರ್'
          ],
          SHORTMONTHS: const [
            'ಜನವರಿ',
            'ಫೆಬ್ರವರಿ',
            'ಮಾರ್ಚ್',
            'ಏಪ್ರಿ',
            'ಮೇ',
            'ಜೂನ್',
            'ಜುಲೈ',
            'ಆಗ',
            'ಸೆಪ್ಟೆಂ',
            'ಅಕ್ಟೋ',
            'ನವೆಂ',
            'ಡಿಸೆಂ'
          ],
          STANDALONESHORTMONTHS: const [
            'ಜನ',
            'ಫೆಬ್ರ',
            'ಮಾರ್ಚ್',
            'ಏಪ್ರಿ',
            'ಮೇ',
            'ಜೂನ್',
            'ಜುಲೈ',
            'ಆಗ',
            'ಸೆಪ್ಟೆಂ',
            'ಅಕ್ಟೋ',
            'ನವೆಂ',
            'ಡಿಸೆಂ'
          ],
          WEEKDAYS: const [
            'ಭಾನುವಾರ',
            'ಸೋಮವಾರ',
            'ಮಂಗಳವಾರ',
            'ಬುಧವಾರ',
            'ಗುರುವಾರ',
            'ಶುಕ್ರವಾರ',
            'ಶನಿವಾರ'
          ],
          STANDALONEWEEKDAYS: const [
            'ಭಾನುವಾರ',
            'ಸೋಮವಾರ',
            'ಮಂಗಳವಾರ',
            'ಬುಧವಾರ',
            'ಗುರುವಾರ',
            'ಶುಕ್ರವಾರ',
            'ಶನಿವಾರ'
          ],
          SHORTWEEKDAYS: const [
            'ಭಾನು',
            'ಸೋಮ',
            'ಮಂಗಳ',
            'ಬುಧ',
            'ಗುರು',
            'ಶುಕ್ರ',
            'ಶನಿ'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'ಭಾನು',
            'ಸೋಮ',
            'ಮಂಗಳ',
            'ಬುಧ',
            'ಗುರು',
            'ಶುಕ್ರ',
            'ಶನಿ'
          ],
          NARROWWEEKDAYS: const ['ಭಾ', 'ಸೋ', 'ಮಂ', 'ಬು', 'ಗು', 'ಶು', 'ಶ'],
          STANDALONENARROWWEEKDAYS: const [
            'ಭಾ',
            'ಸೋ',
            'ಮಂ',
            'ಬು',
            'ಗು',
            'ಶು',
            'ಶ'
          ],
          SHORTQUARTERS: const ['ತ್ರೈ 1', 'ತ್ರೈ 2', 'ತ್ರೈ 3', 'ತ್ರೈ 4'],
          QUARTERS: const [
            '1ನೇ ತ್ರೈಮಾಸಿಕ',
            '2ನೇ ತ್ರೈಮಾಸಿಕ',
            '3ನೇ ತ್ರೈಮಾಸಿಕ',
            '4ನೇ ತ್ರೈಮಾಸಿಕ'
          ],
          AMPMS: const ['ಪೂರ್ವಾಹ್ನ', 'ಅಪರಾಹ್ನ'],
          DATEFORMATS: const [
            'EEEE, MMMM d, y',
            'MMMM d, y',
            'MMM d, y',
            'd/M/yy'
          ],
          TIMEFORMATS: const [
            'hh:mm:ss a zzzz',
            'hh:mm:ss a z',
            'hh:mm:ss a',
            'hh:mm a'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [6, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale ko.
      "ko": new DateSymbols(
          NAME: "ko",
          ERAS: const ['BC', 'AD'],
          ERANAMES: const ['기원전', '서기'],
          NARROWMONTHS: const [
            '1월',
            '2월',
            '3월',
            '4월',
            '5월',
            '6월',
            '7월',
            '8월',
            '9월',
            '10월',
            '11월',
            '12월'
          ],
          STANDALONENARROWMONTHS: const [
            '1월',
            '2월',
            '3월',
            '4월',
            '5월',
            '6월',
            '7월',
            '8월',
            '9월',
            '10월',
            '11월',
            '12월'
          ],
          MONTHS: const [
            '1월',
            '2월',
            '3월',
            '4월',
            '5월',
            '6월',
            '7월',
            '8월',
            '9월',
            '10월',
            '11월',
            '12월'
          ],
          STANDALONEMONTHS: const [
            '1월',
            '2월',
            '3월',
            '4월',
            '5월',
            '6월',
            '7월',
            '8월',
            '9월',
            '10월',
            '11월',
            '12월'
          ],
          SHORTMONTHS: const [
            '1월',
            '2월',
            '3월',
            '4월',
            '5월',
            '6월',
            '7월',
            '8월',
            '9월',
            '10월',
            '11월',
            '12월'
          ],
          STANDALONESHORTMONTHS: const [
            '1월',
            '2월',
            '3월',
            '4월',
            '5월',
            '6월',
            '7월',
            '8월',
            '9월',
            '10월',
            '11월',
            '12월'
          ],
          WEEKDAYS: const ['일요일', '월요일', '화요일', '수요일', '목요일', '금요일', '토요일'],
          STANDALONEWEEKDAYS: const [
            '일요일',
            '월요일',
            '화요일',
            '수요일',
            '목요일',
            '금요일',
            '토요일'
          ],
          SHORTWEEKDAYS: const ['일', '월', '화', '수', '목', '금', '토'],
          STANDALONESHORTWEEKDAYS: const ['일', '월', '화', '수', '목', '금', '토'],
          NARROWWEEKDAYS: const ['일', '월', '화', '수', '목', '금', '토'],
          STANDALONENARROWWEEKDAYS: const ['일', '월', '화', '수', '목', '금', '토'],
          SHORTQUARTERS: const ['1분기', '2분기', '3분기', '4분기'],
          QUARTERS: const ['제 1/4분기', '제 2/4분기', '제 3/4분기', '제 4/4분기'],
          AMPMS: const ['오전', '오후'],
          DATEFORMATS: const [
            'y년 M월 d일 EEEE',
            'y년 M월 d일',
            'y. M. d.',
            'yy. M. d.'
          ],
          TIMEFORMATS: const [
            'a h시 m분 s초 zzzz',
            'a h시 m분 s초 z',
            'a h:mm:ss',
            'a h:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale ky.
      "ky": new DateSymbols(
          NAME: "ky",
          ERAS: const ['б.з.ч.', 'б.з.'],
          ERANAMES: const ['биздин заманга чейин', 'биздин заман'],
          NARROWMONTHS: const [
            'Я',
            'Ф',
            'М',
            'А',
            'М',
            'И',
            'И',
            'А',
            'С',
            'О',
            'Н',
            'Д'
          ],
          STANDALONENARROWMONTHS: const [
            'Я',
            'Ф',
            'М',
            'А',
            'М',
            'И',
            'И',
            'А',
            'С',
            'О',
            'Н',
            'Д'
          ],
          MONTHS: const [
            'январь',
            'февраль',
            'март',
            'апрель',
            'май',
            'июнь',
            'июль',
            'август',
            'сентябрь',
            'октябрь',
            'ноябрь',
            'декабрь'
          ],
          STANDALONEMONTHS: const [
            'Январь',
            'Февраль',
            'Март',
            'Апрель',
            'Май',
            'Июнь',
            'Июль',
            'Август',
            'Сентябрь',
            'Октябрь',
            'Ноябрь',
            'Декабрь'
          ],
          SHORTMONTHS: const [
            'янв.',
            'фев.',
            'мар.',
            'апр.',
            'май',
            'июн.',
            'июл.',
            'авг.',
            'сен.',
            'окт.',
            'ноя.',
            'дек.'
          ],
          STANDALONESHORTMONTHS: const [
            'Янв',
            'Фев',
            'Мар',
            'Апр',
            'Май',
            'Июн',
            'Июл',
            'Авг',
            'Сен',
            'Окт',
            'Ноя',
            'Дек'
          ],
          WEEKDAYS: const [
            'жекшемби',
            'дүйшөмбү',
            'шейшемби',
            'шаршемби',
            'бейшемби',
            'жума',
            'ишемби'
          ],
          STANDALONEWEEKDAYS: const [
            'жекшемби',
            'дүйшөмбү',
            'шейшемби',
            'шаршемби',
            'бейшемби',
            'жума',
            'ишемби'
          ],
          SHORTWEEKDAYS: const [
            'жек.',
            'дүй.',
            'шейш.',
            'шарш.',
            'бейш.',
            'жума',
            'ишм.'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'жек.',
            'дүй.',
            'шейш.',
            'шарш.',
            'бейш.',
            'жума',
            'ишм.'
          ],
          NARROWWEEKDAYS: const ['Ж', 'Д', 'Ш', 'Ш', 'Б', 'Ж', 'И'],
          STANDALONENARROWWEEKDAYS: const ['Ж', 'Д', 'Ш', 'Ш', 'Б', 'Ж', 'И'],
          SHORTQUARTERS: const ['1-чей.', '2-чей.', '3-чей.', '4-чей.'],
          QUARTERS: const ['1-чейрек', '2-чейрек', '3-чейрек', '4-чейрек'],
          AMPMS: const ['таңкы', 'түштөн кийинки'],
          DATEFORMATS: const [
            'y-\'ж\'., d-MMMM, EEEE',
            'y-\'ж\'., d-MMMM',
            'y-\'ж\'., d-MMM',
            'd/M/yy'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 6),
      // Date/time formatting symbols for locale ln.
      "ln": new DateSymbols(
          NAME: "ln",
          ERAS: const ['libóso ya', 'nsima ya Y'],
          ERANAMES: const ['Yambo ya Yézu Krís', 'Nsima ya Yézu Krís'],
          NARROWMONTHS: const [
            'y',
            'f',
            'm',
            'a',
            'm',
            'y',
            'y',
            'a',
            's',
            'ɔ',
            'n',
            'd'
          ],
          STANDALONENARROWMONTHS: const [
            'y',
            'f',
            'm',
            'a',
            'm',
            'y',
            'y',
            'a',
            's',
            'ɔ',
            'n',
            'd'
          ],
          MONTHS: const [
            'sánzá ya yambo',
            'sánzá ya míbalé',
            'sánzá ya mísáto',
            'sánzá ya mínei',
            'sánzá ya mítáno',
            'sánzá ya motóbá',
            'sánzá ya nsambo',
            'sánzá ya mwambe',
            'sánzá ya libwa',
            'sánzá ya zómi',
            'sánzá ya zómi na mɔ̌kɔ́',
            'sánzá ya zómi na míbalé'
          ],
          STANDALONEMONTHS: const [
            'sánzá ya yambo',
            'sánzá ya míbalé',
            'sánzá ya mísáto',
            'sánzá ya mínei',
            'sánzá ya mítáno',
            'sánzá ya motóbá',
            'sánzá ya nsambo',
            'sánzá ya mwambe',
            'sánzá ya libwa',
            'sánzá ya zómi',
            'sánzá ya zómi na mɔ̌kɔ́',
            'sánzá ya zómi na míbalé'
          ],
          SHORTMONTHS: const [
            'yan',
            'fbl',
            'msi',
            'apl',
            'mai',
            'yun',
            'yul',
            'agt',
            'stb',
            'ɔtb',
            'nvb',
            'dsb'
          ],
          STANDALONESHORTMONTHS: const [
            'yan',
            'fbl',
            'msi',
            'apl',
            'mai',
            'yun',
            'yul',
            'agt',
            'stb',
            'ɔtb',
            'nvb',
            'dsb'
          ],
          WEEKDAYS: const [
            'eyenga',
            'mokɔlɔ mwa yambo',
            'mokɔlɔ mwa míbalé',
            'mokɔlɔ mwa mísáto',
            'mokɔlɔ ya mínéi',
            'mokɔlɔ ya mítáno',
            'mpɔ́sɔ'
          ],
          STANDALONEWEEKDAYS: const [
            'eyenga',
            'mokɔlɔ mwa yambo',
            'mokɔlɔ mwa míbalé',
            'mokɔlɔ mwa mísáto',
            'mokɔlɔ ya mínéi',
            'mokɔlɔ ya mítáno',
            'mpɔ́sɔ'
          ],
          SHORTWEEKDAYS: const [
            'eye',
            'ybo',
            'mbl',
            'mst',
            'min',
            'mtn',
            'mps'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'eye',
            'ybo',
            'mbl',
            'mst',
            'min',
            'mtn',
            'mps'
          ],
          NARROWWEEKDAYS: const ['e', 'y', 'm', 'm', 'm', 'm', 'p'],
          STANDALONENARROWWEEKDAYS: const ['e', 'y', 'm', 'm', 'm', 'm', 'p'],
          SHORTQUARTERS: const ['SM1', 'SM2', 'SM3', 'SM4'],
          QUARTERS: const [
            'sánzá mísáto ya yambo',
            'sánzá mísáto ya míbalé',
            'sánzá mísáto ya mísáto',
            'sánzá mísáto ya mínei'
          ],
          AMPMS: const ['ntɔ́ngɔ́', 'mpókwa'],
          DATEFORMATS: const ['EEEE d MMMM y', 'd MMMM y', 'd MMM y', 'd/M/y'],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 6),
      // Date/time formatting symbols for locale lo.
      "lo": new DateSymbols(
          NAME: "lo",
          ERAS: const ['ກ່ອນ ຄ.ສ.', 'ຄ.ສ.'],
          ERANAMES: const ['ກ່ອນຄຣິດສັກກະລາດ', 'ຄຣິດສັກກະລາດ'],
          NARROWMONTHS: const [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12'
          ],
          STANDALONENARROWMONTHS: const [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12'
          ],
          MONTHS: const [
            'ມັງກອນ',
            'ກຸມພາ',
            'ມີນາ',
            'ເມສາ',
            'ພຶດສະພາ',
            'ມິຖຸນາ',
            'ກໍລະກົດ',
            'ສິງຫາ',
            'ກັນຍາ',
            'ຕຸລາ',
            'ພະຈິກ',
            'ທັນວາ'
          ],
          STANDALONEMONTHS: const [
            'ມັງກອນ',
            'ກຸມພາ',
            'ມີນາ',
            'ເມສາ',
            'ພຶດສະພາ',
            'ມິຖຸນາ',
            'ກໍລະກົດ',
            'ສິງຫາ',
            'ກັນຍາ',
            'ຕຸລາ',
            'ພະຈິກ',
            'ທັນວາ'
          ],
          SHORTMONTHS: const [
            'ມ.ກ.',
            'ກ.ພ.',
            'ມ.ນ.',
            'ມ.ສ.',
            'ພ.ພ.',
            'ມິ.ຖ.',
            'ກ.ລ.',
            'ສ.ຫ.',
            'ກ.ຍ.',
            'ຕ.ລ.',
            'ພ.ຈ.',
            'ທ.ວ.'
          ],
          STANDALONESHORTMONTHS: const [
            'ມ.ກ.',
            'ກ.ພ.',
            'ມ.ນ.',
            'ມ.ສ.',
            'ພ.ພ.',
            'ມິ.ຖ.',
            'ກ.ລ.',
            'ສ.ຫ.',
            'ກ.ຍ.',
            'ຕ.ລ.',
            'ພ.ຈ.',
            'ທ.ວ.'
          ],
          WEEKDAYS: const [
            'ວັນອາທິດ',
            'ວັນຈັນ',
            'ວັນອັງຄານ',
            'ວັນພຸດ',
            'ວັນພະຫັດ',
            'ວັນສຸກ',
            'ວັນເສົາ'
          ],
          STANDALONEWEEKDAYS: const [
            'ວັນອາທິດ',
            'ວັນຈັນ',
            'ວັນອັງຄານ',
            'ວັນພຸດ',
            'ວັນພະຫັດ',
            'ວັນສຸກ',
            'ວັນເສົາ'
          ],
          SHORTWEEKDAYS: const [
            'ອາທິດ',
            'ຈັນ',
            'ອັງຄານ',
            'ພຸດ',
            'ພະຫັດ',
            'ສຸກ',
            'ເສົາ'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'ອາທິດ',
            'ຈັນ',
            'ອັງຄານ',
            'ພຸດ',
            'ພະຫັດ',
            'ສຸກ',
            'ເສົາ'
          ],
          NARROWWEEKDAYS: const ['ອາ', 'ຈ', 'ອ', 'ພ', 'ພຫ', 'ສຸ', 'ສ'],
          STANDALONENARROWWEEKDAYS: const [
            'ອາ',
            'ຈ',
            'ອ',
            'ພ',
            'ພຫ',
            'ສຸ',
            'ສ'
          ],
          SHORTQUARTERS: const ['ຕມ1', 'ຕມ2', 'ຕມ3', 'ຕມ4'],
          QUARTERS: const ['ໄຕຣມາດ 1', 'ໄຕຣມາດ 2', 'ໄຕຣມາດ 3', 'ໄຕຣມາດ 4'],
          AMPMS: const ['ກ່ອນທ່ຽງ', 'ຫຼັງທ່ຽງ'],
          DATEFORMATS: const [
            'EEEE ທີ d MMMM G y',
            'd MMMM y',
            'd MMM y',
            'd/M/y'
          ],
          TIMEFORMATS: const [
            'H ໂມງ m ນາທີ ss ວິນາທີ zzzz',
            'H ໂມງ m ນາທີ ss ວິນາທີ z',
            'H:mm:ss',
            'H:mm'
          ],
          DATETIMEFORMATS: const [
            '{1}, {0}',
            '{1}, {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale lt.
      "lt": new DateSymbols(
          NAME: "lt",
          ERAS: const ['pr. Kr.', 'po Kr.'],
          ERANAMES: const ['prieš Kristų', 'po Kristaus'],
          NARROWMONTHS: const [
            'S',
            'V',
            'K',
            'B',
            'G',
            'B',
            'L',
            'R',
            'R',
            'S',
            'L',
            'G'
          ],
          STANDALONENARROWMONTHS: const [
            'S',
            'V',
            'K',
            'B',
            'G',
            'B',
            'L',
            'R',
            'R',
            'S',
            'L',
            'G'
          ],
          MONTHS: const [
            'sausio',
            'vasario',
            'kovo',
            'balandžio',
            'gegužės',
            'birželio',
            'liepos',
            'rugpjūčio',
            'rugsėjo',
            'spalio',
            'lapkričio',
            'gruodžio'
          ],
          STANDALONEMONTHS: const [
            'sausis',
            'vasaris',
            'kovas',
            'balandis',
            'gegužė',
            'birželis',
            'liepa',
            'rugpjūtis',
            'rugsėjis',
            'spalis',
            'lapkritis',
            'gruodis'
          ],
          SHORTMONTHS: const [
            'saus.',
            'vas.',
            'kov.',
            'bal.',
            'geg.',
            'birž.',
            'liep.',
            'rugp.',
            'rugs.',
            'spal.',
            'lapkr.',
            'gruod.'
          ],
          STANDALONESHORTMONTHS: const [
            'saus.',
            'vas.',
            'kov.',
            'bal.',
            'geg.',
            'birž.',
            'liep.',
            'rugp.',
            'rugs.',
            'spal.',
            'lapkr.',
            'gruod.'
          ],
          WEEKDAYS: const [
            'sekmadienis',
            'pirmadienis',
            'antradienis',
            'trečiadienis',
            'ketvirtadienis',
            'penktadienis',
            'šeštadienis'
          ],
          STANDALONEWEEKDAYS: const [
            'sekmadienis',
            'pirmadienis',
            'antradienis',
            'trečiadienis',
            'ketvirtadienis',
            'penktadienis',
            'šeštadienis'
          ],
          SHORTWEEKDAYS: const ['sk', 'pr', 'an', 'tr', 'kt', 'pn', 'št'],
          STANDALONESHORTWEEKDAYS: const [
            'sk',
            'pr',
            'an',
            'tr',
            'kt',
            'pn',
            'št'
          ],
          NARROWWEEKDAYS: const ['S', 'P', 'A', 'T', 'K', 'P', 'Š'],
          STANDALONENARROWWEEKDAYS: const ['S', 'P', 'A', 'T', 'K', 'P', 'Š'],
          SHORTQUARTERS: const ['I k.', 'II k.', 'III k.', 'IV k.'],
          QUARTERS: const [
            'I ketvirtis',
            'II ketvirtis',
            'III ketvirtis',
            'IV ketvirtis'
          ],
          AMPMS: const ['priešpiet', 'popiet'],
          DATEFORMATS: const [
            'y \'m\'. MMMM d \'d\'., EEEE',
            'y \'m\'. MMMM d \'d\'.',
            'y-MM-dd',
            'y-MM-dd'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale lv.
      "lv": new DateSymbols(
          NAME: "lv",
          ERAS: const ['p.m.ē.', 'm.ē.'],
          ERANAMES: const ['pirms mūsu ēras', 'mūsu ērā'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'janvāris',
            'februāris',
            'marts',
            'aprīlis',
            'maijs',
            'jūnijs',
            'jūlijs',
            'augusts',
            'septembris',
            'oktobris',
            'novembris',
            'decembris'
          ],
          STANDALONEMONTHS: const [
            'janvāris',
            'februāris',
            'marts',
            'aprīlis',
            'maijs',
            'jūnijs',
            'jūlijs',
            'augusts',
            'septembris',
            'oktobris',
            'novembris',
            'decembris'
          ],
          SHORTMONTHS: const [
            'janv.',
            'febr.',
            'marts',
            'apr.',
            'maijs',
            'jūn.',
            'jūl.',
            'aug.',
            'sept.',
            'okt.',
            'nov.',
            'dec.'
          ],
          STANDALONESHORTMONTHS: const [
            'janv.',
            'febr.',
            'marts',
            'apr.',
            'maijs',
            'jūn.',
            'jūl.',
            'aug.',
            'sept.',
            'okt.',
            'nov.',
            'dec.'
          ],
          WEEKDAYS: const [
            'svētdiena',
            'pirmdiena',
            'otrdiena',
            'trešdiena',
            'ceturtdiena',
            'piektdiena',
            'sestdiena'
          ],
          STANDALONEWEEKDAYS: const [
            'Svētdiena',
            'Pirmdiena',
            'Otrdiena',
            'Trešdiena',
            'Ceturtdiena',
            'Piektdiena',
            'Sestdiena'
          ],
          SHORTWEEKDAYS: const [
            'svētd.',
            'pirmd.',
            'otrd.',
            'trešd.',
            'ceturtd.',
            'piektd.',
            'sestd.'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'Svētd.',
            'Pirmd.',
            'Otrd.',
            'Trešd.',
            'Ceturtd.',
            'Piektd.',
            'Sestd.'
          ],
          NARROWWEEKDAYS: const ['S', 'P', 'O', 'T', 'C', 'P', 'S'],
          STANDALONENARROWWEEKDAYS: const ['S', 'P', 'O', 'T', 'C', 'P', 'S'],
          SHORTQUARTERS: const ['1. cet.', '2. cet.', '3. cet.', '4. cet.'],
          QUARTERS: const [
            '1. ceturksnis',
            '2. ceturksnis',
            '3. ceturksnis',
            '4. ceturksnis'
          ],
          AMPMS: const ['priekšpusdienā', 'pēcpusdienā'],
          DATEFORMATS: const [
            'EEEE, y. \'gada\' d. MMMM',
            'y. \'gada\' d. MMMM',
            'y. \'gada\' d. MMM',
            'dd.MM.yy'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 6),
      // Date/time formatting symbols for locale mk.
      "mk": new DateSymbols(
          NAME: "mk",
          ERAS: const ['пр.н.е.', 'н.е.'],
          ERANAMES: const ['пред нашата ера', 'од нашата ера'],
          NARROWMONTHS: const [
            'ј',
            'ф',
            'м',
            'а',
            'м',
            'ј',
            'ј',
            'а',
            'с',
            'о',
            'н',
            'д'
          ],
          STANDALONENARROWMONTHS: const [
            'ј',
            'ф',
            'м',
            'а',
            'м',
            'ј',
            'ј',
            'а',
            'с',
            'о',
            'н',
            'д'
          ],
          MONTHS: const [
            'јануари',
            'февруари',
            'март',
            'април',
            'мај',
            'јуни',
            'јули',
            'август',
            'септември',
            'октомври',
            'ноември',
            'декември'
          ],
          STANDALONEMONTHS: const [
            'јануари',
            'февруари',
            'март',
            'април',
            'мај',
            'јуни',
            'јули',
            'август',
            'септември',
            'октомври',
            'ноември',
            'декември'
          ],
          SHORTMONTHS: const [
            'јан.',
            'фев.',
            'мар.',
            'апр.',
            'мај',
            'јун.',
            'јул.',
            'авг.',
            'септ.',
            'окт.',
            'ноем.',
            'дек.'
          ],
          STANDALONESHORTMONTHS: const [
            'јан.',
            'фев.',
            'мар.',
            'апр.',
            'мај',
            'јун.',
            'јул.',
            'авг.',
            'септ.',
            'окт.',
            'ноем.',
            'дек.'
          ],
          WEEKDAYS: const [
            'недела',
            'понеделник',
            'вторник',
            'среда',
            'четврток',
            'петок',
            'сабота'
          ],
          STANDALONEWEEKDAYS: const [
            'недела',
            'понеделник',
            'вторник',
            'среда',
            'четврток',
            'петок',
            'сабота'
          ],
          SHORTWEEKDAYS: const [
            'нед.',
            'пон.',
            'вт.',
            'сре.',
            'чет.',
            'пет.',
            'саб.'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'нед.',
            'пон.',
            'вто.',
            'сре.',
            'чет.',
            'пет.',
            'саб.'
          ],
          NARROWWEEKDAYS: const ['н', 'п', 'в', 'с', 'ч', 'п', 'с'],
          STANDALONENARROWWEEKDAYS: const ['н', 'п', 'в', 'с', 'ч', 'п', 'с'],
          SHORTQUARTERS: const ['јан-мар', 'апр-јун', 'јул-сеп', 'окт-дек'],
          QUARTERS: const [
            'прво тромесечје',
            'второ тромесечје',
            'трето тромесечје',
            'четврто тромесечје'
          ],
          AMPMS: const ['претпладне', 'попладне'],
          DATEFORMATS: const [
            'EEEE, dd MMMM y',
            'dd MMMM y',
            'dd.M.y',
            'dd.M.yy'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 6),
      // Date/time formatting symbols for locale ml.
      "ml": new DateSymbols(
          NAME: "ml",
          ERAS: const ['ക്രി.മു.', 'എഡി'],
          ERANAMES: const ['ക്രിസ്‌തുവിന് മുമ്പ്', 'ആന്നോ ഡൊമിനി'],
          NARROWMONTHS: const [
            'ജ',
            'ഫെ',
            'മാ',
            'ഏ',
            'മെ',
            'ജൂൺ',
            'ജൂ',
            'ഓ',
            'സെ',
            'ഒ',
            'ന',
            'ഡി'
          ],
          STANDALONENARROWMONTHS: const [
            'ജ',
            'ഫെ',
            'മാ',
            'ഏ',
            'മെ',
            'ജൂൺ',
            'ജൂ',
            'ഓ',
            'സെ',
            'ഒ',
            'ന',
            'ഡി'
          ],
          MONTHS: const [
            'ജനുവരി',
            'ഫെബ്രുവരി',
            'മാർച്ച്',
            'ഏപ്രിൽ',
            'മേയ്',
            'ജൂൺ',
            'ജൂലൈ',
            'ഓഗസ്റ്റ്',
            'സെപ്റ്റംബർ',
            'ഒക്‌ടോബർ',
            'നവംബർ',
            'ഡിസംബർ'
          ],
          STANDALONEMONTHS: const [
            'ജനുവരി',
            'ഫെബ്രുവരി',
            'മാർച്ച്',
            'ഏപ്രിൽ',
            'മേയ്',
            'ജൂൺ',
            'ജൂലൈ',
            'ഓഗസ്റ്റ്',
            'സെപ്റ്റംബർ',
            'ഒക്‌ടോബർ',
            'നവംബർ',
            'ഡിസംബർ'
          ],
          SHORTMONTHS: const [
            'ജനു',
            'ഫെബ്രു',
            'മാർ',
            'ഏപ്രി',
            'മേയ്',
            'ജൂൺ',
            'ജൂലൈ',
            'ഓഗ',
            'സെപ്റ്റം',
            'ഒക്ടോ',
            'നവം',
            'ഡിസം'
          ],
          STANDALONESHORTMONTHS: const [
            'ജനു',
            'ഫെബ്രു',
            'മാർ',
            'ഏപ്രി',
            'മേയ്',
            'ജൂൺ',
            'ജൂലൈ',
            'ഓഗ',
            'സെപ്റ്റം',
            'ഒക്ടോ',
            'നവം',
            'ഡിസം'
          ],
          WEEKDAYS: const [
            'ഞായറാഴ്‌ച',
            'തിങ്കളാഴ്‌ച',
            'ചൊവ്വാഴ്ച',
            'ബുധനാഴ്‌ച',
            'വ്യാഴാഴ്‌ച',
            'വെള്ളിയാഴ്‌ച',
            'ശനിയാഴ്‌ച'
          ],
          STANDALONEWEEKDAYS: const [
            'ഞായറാഴ്‌ച',
            'തിങ്കളാഴ്‌ച',
            'ചൊവ്വാഴ്‌ച',
            'ബുധനാഴ്‌ച',
            'വ്യാഴാഴ്‌ച',
            'വെള്ളിയാഴ്‌ച',
            'ശനിയാഴ്‌ച'
          ],
          SHORTWEEKDAYS: const [
            'ഞായർ',
            'തിങ്കൾ',
            'ചൊവ്വ',
            'ബുധൻ',
            'വ്യാഴം',
            'വെള്ളി',
            'ശനി'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'ഞായർ',
            'തിങ്കൾ',
            'ചൊവ്വ',
            'ബുധൻ',
            'വ്യാഴം',
            'വെള്ളി',
            'ശനി'
          ],
          NARROWWEEKDAYS: const ['ഞ', 'തി', 'ചൊ', 'ബു', 'വ്യാ', 'വെ', 'ശ'],
          STANDALONENARROWWEEKDAYS: const [
            'ഞാ',
            'തി',
            'ചൊ',
            'ബു',
            'വ്യാ',
            'വെ',
            'ശ'
          ],
          SHORTQUARTERS: const [
            'ഒന്നാം പാദം',
            'രണ്ടാം പാദം',
            'മൂന്നാം പാദം',
            'നാലാം പാദം'
          ],
          QUARTERS: const [
            'ഒന്നാം പാദം',
            'രണ്ടാം പാദം',
            'മൂന്നാം പാദം',
            'നാലാം പാദം'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'y, MMMM d, EEEE',
            'y, MMMM d',
            'y, MMM d',
            'd/M/yy'
          ],
          TIMEFORMATS: const [
            'h:mm:ss a zzzz',
            'h:mm:ss a z',
            'h:mm:ss a',
            'h:mm a'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [6, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale mn.
      "mn": new DateSymbols(
          NAME: "mn",
          ERAS: const ['МЭӨ', 'МЭ'],
          ERANAMES: const ['манай эриний өмнөх', 'манай эриний'],
          NARROWMONTHS: const [
            'I',
            'II',
            'III',
            'IV',
            'V',
            'VI',
            'VII',
            'VIII',
            'IX',
            'X',
            'XI',
            'XII'
          ],
          STANDALONENARROWMONTHS: const [
            'I',
            'II',
            'III',
            'IV',
            'V',
            'VI',
            'VII',
            'VIII',
            'IX',
            'X',
            'XI',
            'XII'
          ],
          MONTHS: const [
            'Нэгдүгээр сар',
            'Хоёрдугаар сар',
            'Гуравдугаар сар',
            'Дөрөвдүгээр сар',
            'Тавдугаар сар',
            'Зургаадугаар сар',
            'Долдугаар сар',
            'Наймдугаар сар',
            'Есдүгээр сар',
            'Аравдугаар сар',
            'Арван нэгдүгээр сар',
            'Арван хоёрдугаар сар'
          ],
          STANDALONEMONTHS: const [
            'Нэгдүгээр сар',
            'Хоёрдугаар сар',
            'Гуравдугаар сар',
            'Дөрөвдүгээр сар',
            'Тавдугаар сар',
            'Зургаадугаар сар',
            'Долдугаар сар',
            'Наймдугаар сар',
            'Есдүгээр сар',
            'Аравдугаар сар',
            'Арван нэгдүгээр сар',
            'Арван хоёрдугаар сар'
          ],
          SHORTMONTHS: const [
            '1-р сар',
            '2-р сар',
            '3-р сар',
            '4-р сар',
            '5-р сар',
            '6-р сар',
            '7-р сар',
            '8-р сар',
            '9-р сар',
            '10-р сар',
            '11-р сар',
            '12-р сар'
          ],
          STANDALONESHORTMONTHS: const [
            '1-р сар',
            '2-р сар',
            '3-р сар',
            '4-р сар',
            '5-р сар',
            '6-р сар',
            '7-р сар',
            '8-р сар',
            '9-р сар',
            '10-р сар',
            '11-р сар',
            '12-р сар'
          ],
          WEEKDAYS: const [
            'ням',
            'даваа',
            'мягмар',
            'лхагва',
            'пүрэв',
            'баасан',
            'бямба'
          ],
          STANDALONEWEEKDAYS: const [
            'ням',
            'даваа',
            'мягмар',
            'лхагва',
            'пүрэв',
            'баасан',
            'бямба'
          ],
          SHORTWEEKDAYS: const ['Ня', 'Да', 'Мя', 'Лх', 'Пү', 'Ба', 'Бя'],
          STANDALONESHORTWEEKDAYS: const [
            'Ня',
            'Да',
            'Мя',
            'Лх',
            'Пү',
            'Ба',
            'Бя'
          ],
          NARROWWEEKDAYS: const ['Ня', 'Да', 'Мя', 'Лх', 'Пү', 'Ба', 'Бя'],
          STANDALONENARROWWEEKDAYS: const [
            'Ня',
            'Да',
            'Мя',
            'Лх',
            'Пү',
            'Ба',
            'Бя'
          ],
          SHORTQUARTERS: const [
            'I улирал',
            'II улирал',
            'III улирал',
            'IV улирал'
          ],
          QUARTERS: const [
            '1-р улирал',
            '2-р улирал',
            '3-р улирал',
            '4-р улирал'
          ],
          AMPMS: const ['ү.ө', 'ү.х'],
          DATEFORMATS: const ['y.MM.dd, EEEE', 'y.MM.dd', 'y.MM.dd', 'y.MM.dd'],
          TIMEFORMATS: const [
            'HH:mm:ss (zzzz)',
            'HH:mm:ss (z)',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale mr.
      "mr": new DateSymbols(
          NAME: "mr",
          ZERODIGIT: '\u0966',
          ERAS: const ['इ. स. पू.', 'इ. स.'],
          ERANAMES: const ['ईसवीसनपूर्व', 'ईसवीसन'],
          NARROWMONTHS: const [
            'जा',
            'फे',
            'मा',
            'ए',
            'मे',
            'जू',
            'जु',
            'ऑ',
            'स',
            'ऑ',
            'नो',
            'डि'
          ],
          STANDALONENARROWMONTHS: const [
            'जा',
            'फे',
            'मा',
            'ए',
            'मे',
            'जू',
            'जु',
            'ऑ',
            'स',
            'ऑ',
            'नो',
            'डि'
          ],
          MONTHS: const [
            'जानेवारी',
            'फेब्रुवारी',
            'मार्च',
            'एप्रिल',
            'मे',
            'जून',
            'जुलै',
            'ऑगस्ट',
            'सप्टेंबर',
            'ऑक्टोबर',
            'नोव्हेंबर',
            'डिसेंबर'
          ],
          STANDALONEMONTHS: const [
            'जानेवारी',
            'फेब्रुवारी',
            'मार्च',
            'एप्रिल',
            'मे',
            'जून',
            'जुलै',
            'ऑगस्ट',
            'सप्टेंबर',
            'ऑक्टोबर',
            'नोव्हेंबर',
            'डिसेंबर'
          ],
          SHORTMONTHS: const [
            'जाने',
            'फेब्रु',
            'मार्च',
            'एप्रि',
            'मे',
            'जून',
            'जुलै',
            'ऑग',
            'सप्टें',
            'ऑक्टो',
            'नोव्हें',
            'डिसें'
          ],
          STANDALONESHORTMONTHS: const [
            'जाने',
            'फेब्रु',
            'मार्च',
            'एप्रि',
            'मे',
            'जून',
            'जुलै',
            'ऑग',
            'सप्टें',
            'ऑक्टो',
            'नोव्हें',
            'डिसें'
          ],
          WEEKDAYS: const [
            'रविवार',
            'सोमवार',
            'मंगळवार',
            'बुधवार',
            'गुरुवार',
            'शुक्रवार',
            'शनिवार'
          ],
          STANDALONEWEEKDAYS: const [
            'रविवार',
            'सोमवार',
            'मंगळवार',
            'बुधवार',
            'गुरुवार',
            'शुक्रवार',
            'शनिवार'
          ],
          SHORTWEEKDAYS: const [
            'रवि',
            'सोम',
            'मंगळ',
            'बुध',
            'गुरु',
            'शुक्र',
            'शनि'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'रवि',
            'सोम',
            'मंगळ',
            'बुध',
            'गुरु',
            'शुक्र',
            'शनि'
          ],
          NARROWWEEKDAYS: const ['र', 'सो', 'मं', 'बु', 'गु', 'शु', 'श'],
          STANDALONENARROWWEEKDAYS: const [
            'र',
            'सो',
            'मं',
            'बु',
            'गु',
            'शु',
            'श'
          ],
          SHORTQUARTERS: const ['ति१', 'ति२', 'ति३', 'ति४'],
          QUARTERS: const [
            'प्रथम तिमाही',
            'द्वितीय तिमाही',
            'तृतीय तिमाही',
            'चतुर्थ तिमाही'
          ],
          AMPMS: const ['म.पू.', 'म.उ.'],
          DATEFORMATS: const [
            'EEEE, d MMMM, y',
            'd MMMM, y',
            'd MMM, y',
            'd/M/yy'
          ],
          TIMEFORMATS: const [
            'h:mm:ss a zzzz',
            'h:mm:ss a z',
            'h:mm:ss a',
            'h:mm a'
          ],
          DATETIMEFORMATS: const [
            '{1} रोजी {0}',
            '{1} रोजी {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [6, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale ms.
      "ms": new DateSymbols(
          NAME: "ms",
          ERAS: const ['S.M.', 'TM'],
          ERANAMES: const ['S.M.', 'TM'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'O',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'O',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'Januari',
            'Februari',
            'Mac',
            'April',
            'Mei',
            'Jun',
            'Julai',
            'Ogos',
            'September',
            'Oktober',
            'November',
            'Disember'
          ],
          STANDALONEMONTHS: const [
            'Januari',
            'Februari',
            'Mac',
            'April',
            'Mei',
            'Jun',
            'Julai',
            'Ogos',
            'September',
            'Oktober',
            'November',
            'Disember'
          ],
          SHORTMONTHS: const [
            'Jan',
            'Feb',
            'Mac',
            'Apr',
            'Mei',
            'Jun',
            'Jul',
            'Ogo',
            'Sep',
            'Okt',
            'Nov',
            'Dis'
          ],
          STANDALONESHORTMONTHS: const [
            'Jan',
            'Feb',
            'Mac',
            'Apr',
            'Mei',
            'Jun',
            'Jul',
            'Ogo',
            'Sep',
            'Okt',
            'Nov',
            'Dis'
          ],
          WEEKDAYS: const [
            'Ahad',
            'Isnin',
            'Selasa',
            'Rabu',
            'Khamis',
            'Jumaat',
            'Sabtu'
          ],
          STANDALONEWEEKDAYS: const [
            'Ahad',
            'Isnin',
            'Selasa',
            'Rabu',
            'Khamis',
            'Jumaat',
            'Sabtu'
          ],
          SHORTWEEKDAYS: const [
            'Ahd',
            'Isn',
            'Sel',
            'Rab',
            'Kha',
            'Jum',
            'Sab'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'Ahd',
            'Isn',
            'Sel',
            'Rab',
            'Kha',
            'Jum',
            'Sab'
          ],
          NARROWWEEKDAYS: const ['A', 'I', 'S', 'R', 'K', 'J', 'S'],
          STANDALONENARROWWEEKDAYS: const ['A', 'I', 'S', 'R', 'K', 'J', 'S'],
          SHORTQUARTERS: const ['S1', 'S2', 'S3', 'S4'],
          QUARTERS: const [
            'Suku pertama',
            'Suku Ke-2',
            'Suku Ke-3',
            'Suku Ke-4'
          ],
          AMPMS: const ['PG', 'PTG'],
          DATEFORMATS: const [
            'EEEE, d MMMM y',
            'd MMMM y',
            'd MMM y',
            'd/MM/yy'
          ],
          TIMEFORMATS: const [
            'h:mm:ss a zzzz',
            'h:mm:ss a z',
            'h:mm:ss a',
            'h:mm a'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1}, {0}', '{1}, {0}'],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 6),
      // Date/time formatting symbols for locale mt.
      "mt": new DateSymbols(
          NAME: "mt",
          ERAS: const ['QK', 'WK'],
          ERANAMES: const ['Qabel Kristu', 'Wara Kristu'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'Ġ',
            'L',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'Jn',
            'Fr',
            'Mz',
            'Ap',
            'Mj',
            'Ġn',
            'Lj',
            'Aw',
            'St',
            'Ob',
            'Nv',
            'Dċ'
          ],
          MONTHS: const [
            'Jannar',
            'Frar',
            'Marzu',
            'April',
            'Mejju',
            'Ġunju',
            'Lulju',
            'Awwissu',
            'Settembru',
            'Ottubru',
            'Novembru',
            'Diċembru'
          ],
          STANDALONEMONTHS: const [
            'Jannar',
            'Frar',
            'Marzu',
            'April',
            'Mejju',
            'Ġunju',
            'Lulju',
            'Awwissu',
            'Settembru',
            'Ottubru',
            'Novembru',
            'Diċembru'
          ],
          SHORTMONTHS: const [
            'Jan',
            'Fra',
            'Mar',
            'Apr',
            'Mej',
            'Ġun',
            'Lul',
            'Aww',
            'Set',
            'Ott',
            'Nov',
            'Diċ'
          ],
          STANDALONESHORTMONTHS: const [
            'Jan',
            'Fra',
            'Mar',
            'Apr',
            'Mej',
            'Ġun',
            'Lul',
            'Aww',
            'Set',
            'Ott',
            'Nov',
            'Diċ'
          ],
          WEEKDAYS: const [
            'Il-Ħadd',
            'It-Tnejn',
            'It-Tlieta',
            'L-Erbgħa',
            'Il-Ħamis',
            'Il-Ġimgħa',
            'Is-Sibt'
          ],
          STANDALONEWEEKDAYS: const [
            'Il-Ħadd',
            'It-Tnejn',
            'It-Tlieta',
            'L-Erbgħa',
            'Il-Ħamis',
            'Il-Ġimgħa',
            'Is-Sibt'
          ],
          SHORTWEEKDAYS: const [
            'Ħad',
            'Tne',
            'Tli',
            'Erb',
            'Ħam',
            'Ġim',
            'Sib'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'Ħad',
            'Tne',
            'Tli',
            'Erb',
            'Ħam',
            'Ġim',
            'Sib'
          ],
          NARROWWEEKDAYS: const ['Ħd', 'T', 'Tl', 'Er', 'Ħm', 'Ġm', 'Sb'],
          STANDALONENARROWWEEKDAYS: const [
            'Ħd',
            'Tn',
            'Tl',
            'Er',
            'Ħm',
            'Ġm',
            'Sb'
          ],
          SHORTQUARTERS: const ['K1', 'K2', 'K3', 'K4'],
          QUARTERS: const ['1el kwart', '2ni kwart', '3et kwart', '4ba’ kwart'],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'EEEE, d \'ta\'’ MMMM y',
            'd \'ta\'’ MMMM y',
            'dd MMM y',
            'dd/MM/y'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale my.
      "my": new DateSymbols(
          NAME: "my",
          ZERODIGIT: '\u1040',
          ERAS: const ['ဘီစီ', 'အေဒီ'],
          ERANAMES: const ['ခရစ်တော် မပေါ်မီနှစ်', 'ခရစ်နှစ်'],
          NARROWMONTHS: const [
            'ဇ',
            'ဖ',
            'မ',
            'ဧ',
            'မ',
            'ဇ',
            'ဇ',
            'ဩ',
            'စ',
            'အ',
            'န',
            'ဒ'
          ],
          STANDALONENARROWMONTHS: const [
            'ဇ',
            'ဖ',
            'မ',
            'ဧ',
            'မ',
            'ဇ',
            'ဇ',
            'ဩ',
            'စ',
            'အ',
            'န',
            'ဒ'
          ],
          MONTHS: const [
            'ဇန်နဝါရီ',
            'ဖေဖော်ဝါရီ',
            'မတ်',
            'ဧပြီ',
            'မေ',
            'ဇွန်',
            'ဇူလိုင်',
            'ဩဂုတ်',
            'စက်တင်ဘာ',
            'အောက်တိုဘာ',
            'နိုဝင်ဘာ',
            'ဒီဇင်ဘာ'
          ],
          STANDALONEMONTHS: const [
            'ဇန်နဝါရီ',
            'ဖေဖော်ဝါရီ',
            'မတ်',
            'ဧပြီ',
            'မေ',
            'ဇွန်',
            'ဇူလိုင်',
            'ဩဂုတ်',
            'စက်တင်ဘာ',
            'အောက်တိုဘာ',
            'နိုဝင်ဘာ',
            'ဒီဇင်ဘာ'
          ],
          SHORTMONTHS: const [
            'ဇန်',
            'ဖေ',
            'မတ်',
            'ဧ',
            'မေ',
            'ဇွန်',
            'ဇူ',
            'ဩ',
            'စက်',
            'အောက်',
            'နို',
            'ဒီ'
          ],
          STANDALONESHORTMONTHS: const [
            'ဇန်',
            'ဖေ',
            'မတ်',
            'ဧ',
            'မေ',
            'ဇွန်',
            'ဇူ',
            'ဩ',
            'စက်',
            'အောက်',
            'နို',
            'ဒီ'
          ],
          WEEKDAYS: const [
            'တနင်္ဂနွေ',
            'တနင်္လာ',
            'အင်္ဂါ',
            'ဗုဒ္ဓဟူး',
            'ကြာသပတေး',
            'သောကြာ',
            'စနေ'
          ],
          STANDALONEWEEKDAYS: const [
            'တနင်္ဂနွေ',
            'တနင်္လာ',
            'အင်္ဂါ',
            'ဗုဒ္ဓဟူး',
            'ကြာသပတေး',
            'သောကြာ',
            'စနေ'
          ],
          SHORTWEEKDAYS: const [
            'တနင်္ဂနွေ',
            'တနင်္လာ',
            'အင်္ဂါ',
            'ဗုဒ္ဓဟူး',
            'ကြာသပတေး',
            'သောကြာ',
            'စနေ'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'တနင်္ဂနွေ',
            'တနင်္လာ',
            'အင်္ဂါ',
            'ဗုဒ္ဓဟူး',
            'ကြာသပတေး',
            'သောကြာ',
            'စနေ'
          ],
          NARROWWEEKDAYS: const ['တ', 'တ', 'အ', 'ဗ', 'က', 'သ', 'စ'],
          STANDALONENARROWWEEKDAYS: const ['တ', 'တ', 'အ', 'ဗ', 'က', 'သ', 'စ'],
          SHORTQUARTERS: const [
            'ပထမ သုံးလပတ်',
            'ဒုတိယ သုံးလပတ်',
            'တတိယ သုံးလပတ်',
            'စတုတ္ထ သုံးလပတ်'
          ],
          QUARTERS: const [
            'ပထမ သုံးလပတ်',
            'ဒုတိယ သုံးလပတ်',
            'တတိယ သုံးလပတ်',
            'စတုတ္ထ သုံးလပတ်'
          ],
          AMPMS: const ['နံနက်', 'ညနေ'],
          DATEFORMATS: const [
            'y၊ MMMM d၊ EEEE',
            'y၊ d MMMM',
            'y၊ MMM d',
            'dd-MM-yy'
          ],
          TIMEFORMATS: const [
            'zzzz HH:mm:ss',
            'z HH:mm:ss',
            'B HH:mm:ss',
            'B H:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale nb.
      "nb": new DateSymbols(
          NAME: "nb",
          ERAS: const ['f.Kr.', 'e.Kr.'],
          ERANAMES: const ['før Kristus', 'etter Kristus'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'januar',
            'februar',
            'mars',
            'april',
            'mai',
            'juni',
            'juli',
            'august',
            'september',
            'oktober',
            'november',
            'desember'
          ],
          STANDALONEMONTHS: const [
            'januar',
            'februar',
            'mars',
            'april',
            'mai',
            'juni',
            'juli',
            'august',
            'september',
            'oktober',
            'november',
            'desember'
          ],
          SHORTMONTHS: const [
            'jan.',
            'feb.',
            'mar.',
            'apr.',
            'mai',
            'jun.',
            'jul.',
            'aug.',
            'sep.',
            'okt.',
            'nov.',
            'des.'
          ],
          STANDALONESHORTMONTHS: const [
            'jan',
            'feb',
            'mar',
            'apr',
            'mai',
            'jun',
            'jul',
            'aug',
            'sep',
            'okt',
            'nov',
            'des'
          ],
          WEEKDAYS: const [
            'søndag',
            'mandag',
            'tirsdag',
            'onsdag',
            'torsdag',
            'fredag',
            'lørdag'
          ],
          STANDALONEWEEKDAYS: const [
            'søndag',
            'mandag',
            'tirsdag',
            'onsdag',
            'torsdag',
            'fredag',
            'lørdag'
          ],
          SHORTWEEKDAYS: const [
            'søn.',
            'man.',
            'tir.',
            'ons.',
            'tor.',
            'fre.',
            'lør.'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'søn.',
            'man.',
            'tir.',
            'ons.',
            'tor.',
            'fre.',
            'lør.'
          ],
          NARROWWEEKDAYS: const ['S', 'M', 'T', 'O', 'T', 'F', 'L'],
          STANDALONENARROWWEEKDAYS: const ['S', 'M', 'T', 'O', 'T', 'F', 'L'],
          SHORTQUARTERS: const ['K1', 'K2', 'K3', 'K4'],
          QUARTERS: const [
            '1. kvartal',
            '2. kvartal',
            '3. kvartal',
            '4. kvartal'
          ],
          AMPMS: const ['a.m.', 'p.m.'],
          DATEFORMATS: const [
            'EEEE d. MMMM y',
            'd. MMMM y',
            'd. MMM y',
            'dd.MM.y'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const [
            '{1} {0}',
            '{1} \'kl\'. {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale ne.
      "ne": new DateSymbols(
          NAME: "ne",
          ZERODIGIT: '\u0966',
          ERAS: const ['ईसा पूर्व', 'सन्'],
          ERANAMES: const ['ईसा पूर्व', 'सन्'],
          NARROWMONTHS: const [
            'जन',
            'फेब',
            'मार्च',
            'अप्र',
            'मे',
            'जुन',
            'जुल',
            'अग',
            'सेप',
            'अक्टो',
            'नोभे',
            'डिसे'
          ],
          STANDALONENARROWMONTHS: const [
            'जन',
            'फेेब',
            'मार्च',
            'अप्र',
            'मे',
            'जुन',
            'जुल',
            'अग',
            'सेप',
            'अक्टो',
            'नोभे',
            'डिसे'
          ],
          MONTHS: const [
            'जनवरी',
            'फेब्रुअरी',
            'मार्च',
            'अप्रिल',
            'मे',
            'जुन',
            'जुलाई',
            'अगस्ट',
            'सेप्टेम्बर',
            'अक्टोबर',
            'नोभेम्बर',
            'डिसेम्बर'
          ],
          STANDALONEMONTHS: const [
            'जनवरी',
            'फेब्रुअरी',
            'मार्च',
            'अप्रिल',
            'मे',
            'जुन',
            'जुलाई',
            'अगस्ट',
            'सेप्टेम्बर',
            'अक्टोबर',
            'नोभेम्बर',
            'डिसेम्बर'
          ],
          SHORTMONTHS: const [
            'जनवरी',
            'फेब्रुअरी',
            'मार्च',
            'अप्रिल',
            'मे',
            'जुन',
            'जुलाई',
            'अगस्ट',
            'सेप्टेम्बर',
            'अक्टोबर',
            'नोभेम्बर',
            'डिसेम्बर'
          ],
          STANDALONESHORTMONTHS: const [
            'जनवरी',
            'फेब्रुअरी',
            'मार्च',
            'अप्रिल',
            'मे',
            'जुन',
            'जुलाई',
            'अगस्ट',
            'सेप्टेम्बर',
            'अक्टोबर',
            'नोभेम्बर',
            'डिसेम्बर'
          ],
          WEEKDAYS: const [
            'आइतबार',
            'सोमबार',
            'मङ्गलबार',
            'बुधबार',
            'बिहिबार',
            'शुक्रबार',
            'शनिबार'
          ],
          STANDALONEWEEKDAYS: const [
            'आइतबार',
            'सोमबार',
            'मङ्गलबार',
            'बुधबार',
            'बिहिबार',
            'शुक्रबार',
            'शनिबार'
          ],
          SHORTWEEKDAYS: const [
            'आइत',
            'सोम',
            'मङ्गल',
            'बुध',
            'बिहि',
            'शुक्र',
            'शनि'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'आइत',
            'सोम',
            'मङ्गल',
            'बुध',
            'बिहि',
            'शुक्र',
            'शनि'
          ],
          NARROWWEEKDAYS: const ['आ', 'सो', 'म', 'बु', 'बि', 'शु', 'श'],
          STANDALONENARROWWEEKDAYS: const [
            'आ',
            'सो',
            'म',
            'बु',
            'बि',
            'शु',
            'श'
          ],
          SHORTQUARTERS: const [
            'पहिलो सत्र',
            'दोस्रो सत्र',
            'तेस्रो सत्र',
            'चौथो सत्र'
          ],
          QUARTERS: const [
            'पहिलो सत्र',
            'दोस्रो सत्र',
            'तेस्रो सत्र',
            'चौथो सत्र'
          ],
          AMPMS: const ['पूर्वाह्न', 'अपराह्न'],
          DATEFORMATS: const [
            'y MMMM d, EEEE',
            'y MMMM d',
            'y MMM d',
            'yy/M/d'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1}, {0}', '{1}, {0}'],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale nl.
      "nl": new DateSymbols(
          NAME: "nl",
          ERAS: const ['v.Chr.', 'n.Chr.'],
          ERANAMES: const ['voor Christus', 'na Christus'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'januari',
            'februari',
            'maart',
            'april',
            'mei',
            'juni',
            'juli',
            'augustus',
            'september',
            'oktober',
            'november',
            'december'
          ],
          STANDALONEMONTHS: const [
            'januari',
            'februari',
            'maart',
            'april',
            'mei',
            'juni',
            'juli',
            'augustus',
            'september',
            'oktober',
            'november',
            'december'
          ],
          SHORTMONTHS: const [
            'jan.',
            'feb.',
            'mrt.',
            'apr.',
            'mei',
            'jun.',
            'jul.',
            'aug.',
            'sep.',
            'okt.',
            'nov.',
            'dec.'
          ],
          STANDALONESHORTMONTHS: const [
            'jan.',
            'feb.',
            'mrt.',
            'apr.',
            'mei',
            'jun.',
            'jul.',
            'aug.',
            'sep.',
            'okt.',
            'nov.',
            'dec.'
          ],
          WEEKDAYS: const [
            'zondag',
            'maandag',
            'dinsdag',
            'woensdag',
            'donderdag',
            'vrijdag',
            'zaterdag'
          ],
          STANDALONEWEEKDAYS: const [
            'zondag',
            'maandag',
            'dinsdag',
            'woensdag',
            'donderdag',
            'vrijdag',
            'zaterdag'
          ],
          SHORTWEEKDAYS: const ['zo', 'ma', 'di', 'wo', 'do', 'vr', 'za'],
          STANDALONESHORTWEEKDAYS: const [
            'zo',
            'ma',
            'di',
            'wo',
            'do',
            'vr',
            'za'
          ],
          NARROWWEEKDAYS: const ['Z', 'M', 'D', 'W', 'D', 'V', 'Z'],
          STANDALONENARROWWEEKDAYS: const ['Z', 'M', 'D', 'W', 'D', 'V', 'Z'],
          SHORTQUARTERS: const ['K1', 'K2', 'K3', 'K4'],
          QUARTERS: const [
            '1e kwartaal',
            '2e kwartaal',
            '3e kwartaal',
            '4e kwartaal'
          ],
          AMPMS: const ['a.m.', 'p.m.'],
          DATEFORMATS: const [
            'EEEE d MMMM y',
            'd MMMM y',
            'd MMM y',
            'dd-MM-yy'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const [
            '{1} \'om\' {0}',
            '{1} \'om\' {0}',
            '{1} {0}',
            '{1} {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale no.
      "no": new DateSymbols(
          NAME: "no",
          ERAS: const ['f.Kr.', 'e.Kr.'],
          ERANAMES: const ['før Kristus', 'etter Kristus'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'januar',
            'februar',
            'mars',
            'april',
            'mai',
            'juni',
            'juli',
            'august',
            'september',
            'oktober',
            'november',
            'desember'
          ],
          STANDALONEMONTHS: const [
            'januar',
            'februar',
            'mars',
            'april',
            'mai',
            'juni',
            'juli',
            'august',
            'september',
            'oktober',
            'november',
            'desember'
          ],
          SHORTMONTHS: const [
            'jan.',
            'feb.',
            'mar.',
            'apr.',
            'mai',
            'jun.',
            'jul.',
            'aug.',
            'sep.',
            'okt.',
            'nov.',
            'des.'
          ],
          STANDALONESHORTMONTHS: const [
            'jan',
            'feb',
            'mar',
            'apr',
            'mai',
            'jun',
            'jul',
            'aug',
            'sep',
            'okt',
            'nov',
            'des'
          ],
          WEEKDAYS: const [
            'søndag',
            'mandag',
            'tirsdag',
            'onsdag',
            'torsdag',
            'fredag',
            'lørdag'
          ],
          STANDALONEWEEKDAYS: const [
            'søndag',
            'mandag',
            'tirsdag',
            'onsdag',
            'torsdag',
            'fredag',
            'lørdag'
          ],
          SHORTWEEKDAYS: const [
            'søn.',
            'man.',
            'tir.',
            'ons.',
            'tor.',
            'fre.',
            'lør.'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'søn.',
            'man.',
            'tir.',
            'ons.',
            'tor.',
            'fre.',
            'lør.'
          ],
          NARROWWEEKDAYS: const ['S', 'M', 'T', 'O', 'T', 'F', 'L'],
          STANDALONENARROWWEEKDAYS: const ['S', 'M', 'T', 'O', 'T', 'F', 'L'],
          SHORTQUARTERS: const ['K1', 'K2', 'K3', 'K4'],
          QUARTERS: const [
            '1. kvartal',
            '2. kvartal',
            '3. kvartal',
            '4. kvartal'
          ],
          AMPMS: const ['a.m.', 'p.m.'],
          DATEFORMATS: const [
            'EEEE d. MMMM y',
            'd. MMMM y',
            'd. MMM y',
            'dd.MM.y'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const [
            '{1} {0}',
            '{1} \'kl\'. {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale no_NO.
      // Date/time formatting symbols for locale no_NO.
      "no_NO": new DateSymbols(
          NAME: "no_NO",
          ERAS: const ['f.Kr.', 'e.Kr.'],
          ERANAMES: const ['før Kristus', 'etter Kristus'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'januar',
            'februar',
            'mars',
            'april',
            'mai',
            'juni',
            'juli',
            'august',
            'september',
            'oktober',
            'november',
            'desember'
          ],
          STANDALONEMONTHS: const [
            'januar',
            'februar',
            'mars',
            'april',
            'mai',
            'juni',
            'juli',
            'august',
            'september',
            'oktober',
            'november',
            'desember'
          ],
          SHORTMONTHS: const [
            'jan.',
            'feb.',
            'mar.',
            'apr.',
            'mai',
            'jun.',
            'jul.',
            'aug.',
            'sep.',
            'okt.',
            'nov.',
            'des.'
          ],
          STANDALONESHORTMONTHS: const [
            'jan',
            'feb',
            'mar',
            'apr',
            'mai',
            'jun',
            'jul',
            'aug',
            'sep',
            'okt',
            'nov',
            'des'
          ],
          WEEKDAYS: const [
            'søndag',
            'mandag',
            'tirsdag',
            'onsdag',
            'torsdag',
            'fredag',
            'lørdag'
          ],
          STANDALONEWEEKDAYS: const [
            'søndag',
            'mandag',
            'tirsdag',
            'onsdag',
            'torsdag',
            'fredag',
            'lørdag'
          ],
          SHORTWEEKDAYS: const [
            'søn.',
            'man.',
            'tir.',
            'ons.',
            'tor.',
            'fre.',
            'lør.'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'søn.',
            'man.',
            'tir.',
            'ons.',
            'tor.',
            'fre.',
            'lør.'
          ],
          NARROWWEEKDAYS: const ['S', 'M', 'T', 'O', 'T', 'F', 'L'],
          STANDALONENARROWWEEKDAYS: const ['S', 'M', 'T', 'O', 'T', 'F', 'L'],
          SHORTQUARTERS: const ['K1', 'K2', 'K3', 'K4'],
          QUARTERS: const [
            '1. kvartal',
            '2. kvartal',
            '3. kvartal',
            '4. kvartal'
          ],
          AMPMS: const ['a.m.', 'p.m.'],
          DATEFORMATS: const [
            'EEEE d. MMMM y',
            'd. MMMM y',
            'd. MMM y',
            'dd.MM.y'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const [
            '{1} {0}',
            '{1} \'kl\'. {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale or.
      "or": new DateSymbols(
          NAME: "or",
          ERAS: const ['BC', 'AD'],
          ERANAMES: const ['ଖ୍ରୀଷ୍ଟପୂର୍ବ', 'ଖ୍ରୀଷ୍ଟାବ୍ଦ'],
          NARROWMONTHS: const [
            'ଜା',
            'ଫେ',
            'ମା',
            'ଅ',
            'ମଇ',
            'ଜୁ',
            'ଜୁ',
            'ଅ',
            'ସେ',
            'ଅ',
            'ନ',
            'ଡି'
          ],
          STANDALONENARROWMONTHS: const [
            'ଜା',
            'ଫେ',
            'ମା',
            'ଅ',
            'ମଇ',
            'ଜୁ',
            'ଜୁ',
            'ଅ',
            'ସେ',
            'ଅ',
            'ନ',
            'ଡି'
          ],
          MONTHS: const [
            'ଜାନୁଆରୀ',
            'ଫେବୃଆରୀ',
            'ମାର୍ଚ୍ଚ',
            'ଅପ୍ରେଲ',
            'ମଇ',
            'ଜୁନ',
            'ଜୁଲାଇ',
            'ଅଗଷ୍ଟ',
            'ସେପ୍ଟେମ୍ବର',
            'ଅକ୍ଟୋବର',
            'ନଭେମ୍ବର',
            'ଡିସେମ୍ବର'
          ],
          STANDALONEMONTHS: const [
            'ଜାନୁଆରୀ',
            'ଫେବୃଆରୀ',
            'ମାର୍ଚ୍ଚ',
            'ଅପ୍ରେଲ',
            'ମଇ',
            'ଜୁନ',
            'ଜୁଲାଇ',
            'ଅଗଷ୍ଟ',
            'ସେପ୍ଟେମ୍ବର',
            'ଅକ୍ଟୋବର',
            'ନଭେମ୍ବର',
            'ଡିସେମ୍ବର'
          ],
          SHORTMONTHS: const [
            'ଜାନୁଆରୀ',
            'ଫେବୃଆରୀ',
            'ମାର୍ଚ୍ଚ',
            'ଅପ୍ରେଲ',
            'ମଇ',
            'ଜୁନ',
            'ଜୁଲାଇ',
            'ଅଗଷ୍ଟ',
            'ସେପ୍ଟେମ୍ବର',
            'ଅକ୍ଟୋବର',
            'ନଭେମ୍ବର',
            'ଡିସେମ୍ବର'
          ],
          STANDALONESHORTMONTHS: const [
            'ଜାନୁଆରୀ',
            'ଫେବୃଆରୀ',
            'ମାର୍ଚ୍ଚ',
            'ଅପ୍ରେଲ',
            'ମଇ',
            'ଜୁନ',
            'ଜୁଲାଇ',
            'ଅଗଷ୍ଟ',
            'ସେପ୍ଟେମ୍ବର',
            'ଅକ୍ଟୋବର',
            'ନଭେମ୍ବର',
            'ଡିସେମ୍ବର'
          ],
          WEEKDAYS: const [
            'ରବିବାର',
            'ସୋମବାର',
            'ମଙ୍ଗଳବାର',
            'ବୁଧବାର',
            'ଗୁରୁବାର',
            'ଶୁକ୍ରବାର',
            'ଶନିବାର'
          ],
          STANDALONEWEEKDAYS: const [
            'ରବିବାର',
            'ସୋମବାର',
            'ମଙ୍ଗଳବାର',
            'ବୁଧବାର',
            'ଗୁରୁବାର',
            'ଶୁକ୍ରବାର',
            'ଶନିବାର'
          ],
          SHORTWEEKDAYS: const [
            'ରବି',
            'ସୋମ',
            'ମଙ୍ଗଳ',
            'ବୁଧ',
            'ଗୁରୁ',
            'ଶୁକ୍ର',
            'ଶନି'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'ରବି',
            'ସୋମ',
            'ମଙ୍ଗଳ',
            'ବୁଧ',
            'ଗୁରୁ',
            'ଶୁକ୍ର',
            'ଶନି'
          ],
          NARROWWEEKDAYS: const ['ର', 'ସୋ', 'ମ', 'ବୁ', 'ଗୁ', 'ଶୁ', 'ଶ'],
          STANDALONENARROWWEEKDAYS: const [
            'ର',
            'ସୋ',
            'ମ',
            'ବୁ',
            'ଗୁ',
            'ଶୁ',
            'ଶ'
          ],
          SHORTQUARTERS: const [
            '1ମ ତ୍ରୟମାସ',
            '2ୟ ତ୍ରୟମାସ',
            '3ୟ ତ୍ରୟମାସ',
            '4ର୍ଥ ତ୍ରୟମାସ'
          ],
          QUARTERS: const [
            '1ମ ତ୍ରୟମାସ',
            '2ୟ ତ୍ରୟମାସ',
            '3ୟ ତ୍ରୟମାସ',
            '4ର୍ଥ ତ୍ରୟମାସ'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'EEEE, MMMM d, y',
            'MMMM d, y',
            'MMM d, y',
            'M/d/yy'
          ],
          TIMEFORMATS: const [
            'h:mm:ss a zzzz',
            'h:mm:ss a z',
            'h:mm:ss a',
            'h:mm a'
          ],
          DATETIMEFORMATS: const [
            '{0} ଠାରେ {1}',
            '{0} ଠାରେ {1}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [6, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale pa.
      "pa": new DateSymbols(
          NAME: "pa",
          ERAS: const ['ਈ. ਪੂ.', 'ਸੰਨ'],
          ERANAMES: const ['ਈਸਵੀ ਪੂਰਵ', 'ਈਸਵੀ ਸੰਨ'],
          NARROWMONTHS: const [
            'ਜ',
            'ਫ਼',
            'ਮਾ',
            'ਅ',
            'ਮ',
            'ਜੂ',
            'ਜੁ',
            'ਅ',
            'ਸ',
            'ਅ',
            'ਨ',
            'ਦ'
          ],
          STANDALONENARROWMONTHS: const [
            'ਜ',
            'ਫ਼',
            'ਮਾ',
            'ਅ',
            'ਮ',
            'ਜੂ',
            'ਜੁ',
            'ਅ',
            'ਸ',
            'ਅ',
            'ਨ',
            'ਦ'
          ],
          MONTHS: const [
            'ਜਨਵਰੀ',
            'ਫ਼ਰਵਰੀ',
            'ਮਾਰਚ',
            'ਅਪ੍ਰੈਲ',
            'ਮਈ',
            'ਜੂਨ',
            'ਜੁਲਾਈ',
            'ਅਗਸਤ',
            'ਸਤੰਬਰ',
            'ਅਕਤੂਬਰ',
            'ਨਵੰਬਰ',
            'ਦਸੰਬਰ'
          ],
          STANDALONEMONTHS: const [
            'ਜਨਵਰੀ',
            'ਫ਼ਰਵਰੀ',
            'ਮਾਰਚ',
            'ਅਪ੍ਰੈਲ',
            'ਮਈ',
            'ਜੂਨ',
            'ਜੁਲਾਈ',
            'ਅਗਸਤ',
            'ਸਤੰਬਰ',
            'ਅਕਤੂਬਰ',
            'ਨਵੰਬਰ',
            'ਦਸੰਬਰ'
          ],
          SHORTMONTHS: const [
            'ਜਨ',
            'ਫ਼ਰ',
            'ਮਾਰਚ',
            'ਅਪ੍ਰੈ',
            'ਮਈ',
            'ਜੂਨ',
            'ਜੁਲਾ',
            'ਅਗ',
            'ਸਤੰ',
            'ਅਕਤੂ',
            'ਨਵੰ',
            'ਦਸੰ'
          ],
          STANDALONESHORTMONTHS: const [
            'ਜਨ',
            'ਫ਼ਰ',
            'ਮਾਰਚ',
            'ਅਪ੍ਰੈ',
            'ਮਈ',
            'ਜੂਨ',
            'ਜੁਲਾ',
            'ਅਗ',
            'ਸਤੰ',
            'ਅਕਤੂ',
            'ਨਵੰ',
            'ਦਸੰ'
          ],
          WEEKDAYS: const [
            'ਐਤਵਾਰ',
            'ਸੋਮਵਾਰ',
            'ਮੰਗਲਵਾਰ',
            'ਬੁੱਧਵਾਰ',
            'ਵੀਰਵਾਰ',
            'ਸ਼ੁੱਕਰਵਾਰ',
            'ਸ਼ਨਿੱਚਰਵਾਰ'
          ],
          STANDALONEWEEKDAYS: const [
            'ਐਤਵਾਰ',
            'ਸੋਮਵਾਰ',
            'ਮੰਗਲਵਾਰ',
            'ਬੁੱਧਵਾਰ',
            'ਵੀਰਵਾਰ',
            'ਸ਼ੁੱਕਰਵਾਰ',
            'ਸ਼ਨਿੱਚਰਵਾਰ'
          ],
          SHORTWEEKDAYS: const [
            'ਐਤ',
            'ਸੋਮ',
            'ਮੰਗਲ',
            'ਬੁੱਧ',
            'ਵੀਰ',
            'ਸ਼ੁੱਕਰ',
            'ਸ਼ਨਿੱਚਰ'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'ਐਤ',
            'ਸੋਮ',
            'ਮੰਗਲ',
            'ਬੁੱਧ',
            'ਵੀਰ',
            'ਸ਼ੁੱਕਰ',
            'ਸ਼ਨਿੱਚਰ'
          ],
          NARROWWEEKDAYS: const ['ਐ', 'ਸੋ', 'ਮੰ', 'ਬੁੱ', 'ਵੀ', 'ਸ਼ੁੱ', 'ਸ਼'],
          STANDALONENARROWWEEKDAYS: const [
            'ਐ',
            'ਸੋ',
            'ਮੰ',
            'ਬੁੱ',
            'ਵੀ',
            'ਸ਼ੁੱ',
            'ਸ਼'
          ],
          SHORTQUARTERS: const ['ਤਿਮਾਹੀ1', 'ਤਿਮਾਹੀ2', 'ਤਿਮਾਹੀ3', 'ਤਿਮਾਹੀ4'],
          QUARTERS: const [
            'ਪਹਿਲੀ ਤਿਮਾਹੀ',
            'ਦੂਜੀ ਤਿਮਾਹੀ',
            'ਤੀਜੀ ਤਿਮਾਹੀ',
            'ਚੌਥੀ ਤਿਮਾਹੀ'
          ],
          AMPMS: const ['ਪੂ.ਦੁ.', 'ਬਾ.ਦੁ.'],
          DATEFORMATS: const [
            'EEEE, d MMMM y',
            'd MMMM y',
            'd MMM y',
            'd/M/yy'
          ],
          TIMEFORMATS: const [
            'h:mm:ss a zzzz',
            'h:mm:ss a z',
            'h:mm:ss a',
            'h:mm a'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1}, {0}', '{1}, {0}'],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [6, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale pl.
      "pl": new DateSymbols(
          NAME: "pl",
          ERAS: const ['p.n.e.', 'n.e.'],
          ERANAMES: const ['przed naszą erą', 'naszej ery'],
          NARROWMONTHS: const [
            's',
            'l',
            'm',
            'k',
            'm',
            'c',
            'l',
            's',
            'w',
            'p',
            'l',
            'g'
          ],
          STANDALONENARROWMONTHS: const [
            'S',
            'L',
            'M',
            'K',
            'M',
            'C',
            'L',
            'S',
            'W',
            'P',
            'L',
            'G'
          ],
          MONTHS: const [
            'stycznia',
            'lutego',
            'marca',
            'kwietnia',
            'maja',
            'czerwca',
            'lipca',
            'sierpnia',
            'września',
            'października',
            'listopada',
            'grudnia'
          ],
          STANDALONEMONTHS: const [
            'styczeń',
            'luty',
            'marzec',
            'kwiecień',
            'maj',
            'czerwiec',
            'lipiec',
            'sierpień',
            'wrzesień',
            'październik',
            'listopad',
            'grudzień'
          ],
          SHORTMONTHS: const [
            'sty',
            'lut',
            'mar',
            'kwi',
            'maj',
            'cze',
            'lip',
            'sie',
            'wrz',
            'paź',
            'lis',
            'gru'
          ],
          STANDALONESHORTMONTHS: const [
            'sty',
            'lut',
            'mar',
            'kwi',
            'maj',
            'cze',
            'lip',
            'sie',
            'wrz',
            'paź',
            'lis',
            'gru'
          ],
          WEEKDAYS: const [
            'niedziela',
            'poniedziałek',
            'wtorek',
            'środa',
            'czwartek',
            'piątek',
            'sobota'
          ],
          STANDALONEWEEKDAYS: const [
            'niedziela',
            'poniedziałek',
            'wtorek',
            'środa',
            'czwartek',
            'piątek',
            'sobota'
          ],
          SHORTWEEKDAYS: const [
            'niedz.',
            'pon.',
            'wt.',
            'śr.',
            'czw.',
            'pt.',
            'sob.'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'niedz.',
            'pon.',
            'wt.',
            'śr.',
            'czw.',
            'pt.',
            'sob.'
          ],
          NARROWWEEKDAYS: const ['n', 'p', 'w', 'ś', 'c', 'p', 's'],
          STANDALONENARROWWEEKDAYS: const ['N', 'P', 'W', 'Ś', 'C', 'P', 'S'],
          SHORTQUARTERS: const ['I kw.', 'II kw.', 'III kw.', 'IV kw.'],
          QUARTERS: const [
            'I kwartał',
            'II kwartał',
            'III kwartał',
            'IV kwartał'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'EEEE, d MMMM y',
            'd MMMM y',
            'd MMM y',
            'dd.MM.y'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1}, {0}', '{1}, {0}'],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale ps.
      "ps": new DateSymbols(
          NAME: "ps",
          ZERODIGIT: '\u06F0',
          ERAS: const ['له میلاد وړاندې', 'م.'],
          ERANAMES: const ['له میلاد څخه وړاندې', 'له میلاد څخه وروسته'],
          NARROWMONTHS: const [
            'ج',
            'ف',
            'م',
            'ا',
            'م',
            'ج',
            'ج',
            'ا',
            'س',
            'ا',
            'ن',
            'د'
          ],
          STANDALONENARROWMONTHS: const [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12'
          ],
          MONTHS: const [
            'جنوري',
            'فبروري',
            'مارچ',
            'اپریل',
            'مۍ',
            'جون',
            'جولای',
            'اگست',
            'سېپتمبر',
            'اکتوبر',
            'نومبر',
            'دسمبر'
          ],
          STANDALONEMONTHS: const [
            'جنوري',
            'فېبروري',
            'مارچ',
            'اپریل',
            'مۍ',
            'جون',
            'جولای',
            'اگست',
            'سپتمبر',
            'اکتوبر',
            'نومبر',
            'دسمبر'
          ],
          SHORTMONTHS: const [
            'جنوري',
            'فبروري',
            'مارچ',
            'اپریل',
            'مۍ',
            'جون',
            'جولای',
            'اگست',
            'سېپتمبر',
            'اکتوبر',
            'نومبر',
            'دسمبر'
          ],
          STANDALONESHORTMONTHS: const [
            'جنوري',
            'فبروري',
            'مارچ',
            'اپریل',
            'مۍ',
            'جون',
            'جولای',
            'اگست',
            'سپتمبر',
            'اکتوبر',
            'نومبر',
            'دسمبر'
          ],
          WEEKDAYS: const [
            'يونۍ',
            'دونۍ',
            'درېنۍ',
            'څلرنۍ',
            'پينځنۍ',
            'جمعه',
            'اونۍ'
          ],
          STANDALONEWEEKDAYS: const [
            'يونۍ',
            'دونۍ',
            'درېنۍ',
            'څلرنۍ',
            'پينځنۍ',
            'جمعه',
            'اونۍ'
          ],
          SHORTWEEKDAYS: const [
            'يونۍ',
            'دونۍ',
            'درېنۍ',
            'څلرنۍ',
            'پينځنۍ',
            'جمعه',
            'اونۍ'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'يونۍ',
            'دونۍ',
            'درېنۍ',
            'څلرنۍ',
            'پينځنۍ',
            'جمعه',
            'اونۍ'
          ],
          NARROWWEEKDAYS: const ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
          STANDALONENARROWWEEKDAYS: const ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
          SHORTQUARTERS: const [
            'لومړۍ ربعه',
            '۲مه ربعه',
            '۳مه ربعه',
            '۴مه ربعه'
          ],
          QUARTERS: const ['لومړۍ ربعه', '۲مه ربعه', '۳مه ربعه', '۴مه ربعه'],
          AMPMS: const ['غ.م.', 'غ.و.'],
          DATEFORMATS: const [
            'EEEE د y د MMMM d',
            'د y د MMMM d',
            'y MMM d',
            'y/M/d'
          ],
          TIMEFORMATS: const [
            'H:mm:ss (zzzz)',
            'H:mm:ss (z)',
            'H:mm:ss',
            'H:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 5,
          WEEKENDRANGE: const [3, 4],
          FIRSTWEEKCUTOFFDAY: 4),
      // Date/time formatting symbols for locale pt.
      "pt": new DateSymbols(
          NAME: "pt",
          ERAS: const ['a.C.', 'd.C.'],
          ERANAMES: const ['antes de Cristo', 'depois de Cristo'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'janeiro',
            'fevereiro',
            'março',
            'abril',
            'maio',
            'junho',
            'julho',
            'agosto',
            'setembro',
            'outubro',
            'novembro',
            'dezembro'
          ],
          STANDALONEMONTHS: const [
            'janeiro',
            'fevereiro',
            'março',
            'abril',
            'maio',
            'junho',
            'julho',
            'agosto',
            'setembro',
            'outubro',
            'novembro',
            'dezembro'
          ],
          SHORTMONTHS: const [
            'jan',
            'fev',
            'mar',
            'abr',
            'mai',
            'jun',
            'jul',
            'ago',
            'set',
            'out',
            'nov',
            'dez'
          ],
          STANDALONESHORTMONTHS: const [
            'jan',
            'fev',
            'mar',
            'abr',
            'mai',
            'jun',
            'jul',
            'ago',
            'set',
            'out',
            'nov',
            'dez'
          ],
          WEEKDAYS: const [
            'domingo',
            'segunda-feira',
            'terça-feira',
            'quarta-feira',
            'quinta-feira',
            'sexta-feira',
            'sábado'
          ],
          STANDALONEWEEKDAYS: const [
            'domingo',
            'segunda-feira',
            'terça-feira',
            'quarta-feira',
            'quinta-feira',
            'sexta-feira',
            'sábado'
          ],
          SHORTWEEKDAYS: const [
            'dom',
            'seg',
            'ter',
            'qua',
            'qui',
            'sex',
            'sáb'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'dom',
            'seg',
            'ter',
            'qua',
            'qui',
            'sex',
            'sáb'
          ],
          NARROWWEEKDAYS: const ['D', 'S', 'T', 'Q', 'Q', 'S', 'S'],
          STANDALONENARROWWEEKDAYS: const ['D', 'S', 'T', 'Q', 'Q', 'S', 'S'],
          SHORTQUARTERS: const ['T1', 'T2', 'T3', 'T4'],
          QUARTERS: const [
            '1º trimestre',
            '2º trimestre',
            '3º trimestre',
            '4º trimestre'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'EEEE, d \'de\' MMMM \'de\' y',
            'd \'de\' MMMM \'de\' y',
            'd \'de\' MMM \'de\' y',
            'dd/MM/y'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale pt_BR.
      // Date/time formatting symbols for locale pt_BR.
      "pt_BR": new DateSymbols(
          NAME: "pt_BR",
          ERAS: const ['a.C.', 'd.C.'],
          ERANAMES: const ['antes de Cristo', 'depois de Cristo'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'janeiro',
            'fevereiro',
            'março',
            'abril',
            'maio',
            'junho',
            'julho',
            'agosto',
            'setembro',
            'outubro',
            'novembro',
            'dezembro'
          ],
          STANDALONEMONTHS: const [
            'janeiro',
            'fevereiro',
            'março',
            'abril',
            'maio',
            'junho',
            'julho',
            'agosto',
            'setembro',
            'outubro',
            'novembro',
            'dezembro'
          ],
          SHORTMONTHS: const [
            'jan',
            'fev',
            'mar',
            'abr',
            'mai',
            'jun',
            'jul',
            'ago',
            'set',
            'out',
            'nov',
            'dez'
          ],
          STANDALONESHORTMONTHS: const [
            'jan',
            'fev',
            'mar',
            'abr',
            'mai',
            'jun',
            'jul',
            'ago',
            'set',
            'out',
            'nov',
            'dez'
          ],
          WEEKDAYS: const [
            'domingo',
            'segunda-feira',
            'terça-feira',
            'quarta-feira',
            'quinta-feira',
            'sexta-feira',
            'sábado'
          ],
          STANDALONEWEEKDAYS: const [
            'domingo',
            'segunda-feira',
            'terça-feira',
            'quarta-feira',
            'quinta-feira',
            'sexta-feira',
            'sábado'
          ],
          SHORTWEEKDAYS: const [
            'dom',
            'seg',
            'ter',
            'qua',
            'qui',
            'sex',
            'sáb'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'dom',
            'seg',
            'ter',
            'qua',
            'qui',
            'sex',
            'sáb'
          ],
          NARROWWEEKDAYS: const ['D', 'S', 'T', 'Q', 'Q', 'S', 'S'],
          STANDALONENARROWWEEKDAYS: const ['D', 'S', 'T', 'Q', 'Q', 'S', 'S'],
          SHORTQUARTERS: const ['T1', 'T2', 'T3', 'T4'],
          QUARTERS: const [
            '1º trimestre',
            '2º trimestre',
            '3º trimestre',
            '4º trimestre'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'EEEE, d \'de\' MMMM \'de\' y',
            'd \'de\' MMMM \'de\' y',
            'd \'de\' MMM \'de\' y',
            'dd/MM/y'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale pt_PT.
      "pt_PT": new DateSymbols(
          NAME: "pt_PT",
          ERAS: const ['a.C.', 'd.C.'],
          ERANAMES: const ['antes de Cristo', 'depois de Cristo'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'janeiro',
            'fevereiro',
            'março',
            'abril',
            'maio',
            'junho',
            'julho',
            'agosto',
            'setembro',
            'outubro',
            'novembro',
            'dezembro'
          ],
          STANDALONEMONTHS: const [
            'janeiro',
            'fevereiro',
            'março',
            'abril',
            'maio',
            'junho',
            'julho',
            'agosto',
            'setembro',
            'outubro',
            'novembro',
            'dezembro'
          ],
          SHORTMONTHS: const [
            'jan',
            'fev',
            'mar',
            'abr',
            'mai',
            'jun',
            'jul',
            'ago',
            'set',
            'out',
            'nov',
            'dez'
          ],
          STANDALONESHORTMONTHS: const [
            'jan',
            'fev',
            'mar',
            'abr',
            'mai',
            'jun',
            'jul',
            'ago',
            'set',
            'out',
            'nov',
            'dez'
          ],
          WEEKDAYS: const [
            'domingo',
            'segunda-feira',
            'terça-feira',
            'quarta-feira',
            'quinta-feira',
            'sexta-feira',
            'sábado'
          ],
          STANDALONEWEEKDAYS: const [
            'domingo',
            'segunda-feira',
            'terça-feira',
            'quarta-feira',
            'quinta-feira',
            'sexta-feira',
            'sábado'
          ],
          SHORTWEEKDAYS: const [
            'domingo',
            'segunda',
            'terça',
            'quarta',
            'quinta',
            'sexta',
            'sábado'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'domingo',
            'segunda',
            'terça',
            'quarta',
            'quinta',
            'sexta',
            'sábado'
          ],
          NARROWWEEKDAYS: const ['D', 'S', 'T', 'Q', 'Q', 'S', 'S'],
          STANDALONENARROWWEEKDAYS: const ['D', 'S', 'T', 'Q', 'Q', 'S', 'S'],
          SHORTQUARTERS: const ['T1', 'T2', 'T3', 'T4'],
          QUARTERS: const [
            '1.º trimestre',
            '2.º trimestre',
            '3.º trimestre',
            '4.º trimestre'
          ],
          AMPMS: const ['da manhã', 'da tarde'],
          DATEFORMATS: const [
            'EEEE, d \'de\' MMMM \'de\' y',
            'd \'de\' MMMM \'de\' y',
            'dd/MM/y',
            'dd/MM/yy'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const [
            '{1} \'às\' {0}',
            '{1} \'às\' {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale ro.
      "ro": new DateSymbols(
          NAME: "ro",
          ERAS: const ['î.Hr.', 'd.Hr.'],
          ERANAMES: const ['înainte de Hristos', 'după Hristos'],
          NARROWMONTHS: const [
            'I',
            'F',
            'M',
            'A',
            'M',
            'I',
            'I',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'I',
            'F',
            'M',
            'A',
            'M',
            'I',
            'I',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'ianuarie',
            'februarie',
            'martie',
            'aprilie',
            'mai',
            'iunie',
            'iulie',
            'august',
            'septembrie',
            'octombrie',
            'noiembrie',
            'decembrie'
          ],
          STANDALONEMONTHS: const [
            'ianuarie',
            'februarie',
            'martie',
            'aprilie',
            'mai',
            'iunie',
            'iulie',
            'august',
            'septembrie',
            'octombrie',
            'noiembrie',
            'decembrie'
          ],
          SHORTMONTHS: const [
            'ian.',
            'feb.',
            'mar.',
            'apr.',
            'mai',
            'iun.',
            'iul.',
            'aug.',
            'sept.',
            'oct.',
            'nov.',
            'dec.'
          ],
          STANDALONESHORTMONTHS: const [
            'ian.',
            'feb.',
            'mar.',
            'apr.',
            'mai',
            'iun.',
            'iul.',
            'aug.',
            'sept.',
            'oct.',
            'nov.',
            'dec.'
          ],
          WEEKDAYS: const [
            'duminică',
            'luni',
            'marți',
            'miercuri',
            'joi',
            'vineri',
            'sâmbătă'
          ],
          STANDALONEWEEKDAYS: const [
            'duminică',
            'luni',
            'marți',
            'miercuri',
            'joi',
            'vineri',
            'sâmbătă'
          ],
          SHORTWEEKDAYS: const [
            'dum.',
            'lun.',
            'mar.',
            'mie.',
            'joi',
            'vin.',
            'sâm.'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'dum.',
            'lun.',
            'mar.',
            'mie.',
            'joi',
            'vin.',
            'sâm.'
          ],
          NARROWWEEKDAYS: const ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
          STANDALONENARROWWEEKDAYS: const ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
          SHORTQUARTERS: const ['trim. I', 'trim. II', 'trim. III', 'trim. IV'],
          QUARTERS: const [
            'trimestrul I',
            'trimestrul al II-lea',
            'trimestrul al III-lea',
            'trimestrul al IV-lea'
          ],
          AMPMS: const ['a.m.', 'p.m.'],
          DATEFORMATS: const [
            'EEEE, d MMMM y',
            'd MMMM y',
            'd MMM y',
            'dd.MM.y'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const [
            '{1}, {0}',
            '{1}, {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 6),
      // Date/time formatting symbols for locale ru.
      "ru": new DateSymbols(
          NAME: "ru",
          ERAS: const ['до н. э.', 'н. э.'],
          ERANAMES: const ['до Рождества Христова', 'от Рождества Христова'],
          NARROWMONTHS: const [
            'Я',
            'Ф',
            'М',
            'А',
            'М',
            'И',
            'И',
            'А',
            'С',
            'О',
            'Н',
            'Д'
          ],
          STANDALONENARROWMONTHS: const [
            'Я',
            'Ф',
            'М',
            'А',
            'М',
            'И',
            'И',
            'А',
            'С',
            'О',
            'Н',
            'Д'
          ],
          MONTHS: const [
            'января',
            'февраля',
            'марта',
            'апреля',
            'мая',
            'июня',
            'июля',
            'августа',
            'сентября',
            'октября',
            'ноября',
            'декабря'
          ],
          STANDALONEMONTHS: const [
            'январь',
            'февраль',
            'март',
            'апрель',
            'май',
            'июнь',
            'июль',
            'август',
            'сентябрь',
            'октябрь',
            'ноябрь',
            'декабрь'
          ],
          SHORTMONTHS: const [
            'янв.',
            'февр.',
            'мар.',
            'апр.',
            'мая',
            'июн.',
            'июл.',
            'авг.',
            'сент.',
            'окт.',
            'нояб.',
            'дек.'
          ],
          STANDALONESHORTMONTHS: const [
            'янв.',
            'февр.',
            'март',
            'апр.',
            'май',
            'июнь',
            'июль',
            'авг.',
            'сент.',
            'окт.',
            'нояб.',
            'дек.'
          ],
          WEEKDAYS: const [
            'воскресенье',
            'понедельник',
            'вторник',
            'среда',
            'четверг',
            'пятница',
            'суббота'
          ],
          STANDALONEWEEKDAYS: const [
            'воскресенье',
            'понедельник',
            'вторник',
            'среда',
            'четверг',
            'пятница',
            'суббота'
          ],
          SHORTWEEKDAYS: const ['вс', 'пн', 'вт', 'ср', 'чт', 'пт', 'сб'],
          STANDALONESHORTWEEKDAYS: const [
            'вс',
            'пн',
            'вт',
            'ср',
            'чт',
            'пт',
            'сб'
          ],
          NARROWWEEKDAYS: const ['вс', 'пн', 'вт', 'ср', 'чт', 'пт', 'сб'],
          STANDALONENARROWWEEKDAYS: const ['В', 'П', 'В', 'С', 'Ч', 'П', 'С'],
          SHORTQUARTERS: const ['1-й кв.', '2-й кв.', '3-й кв.', '4-й кв.'],
          QUARTERS: const [
            '1-й квартал',
            '2-й квартал',
            '3-й квартал',
            '4-й квартал'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'EEEE, d MMMM y \'г\'.',
            'd MMMM y \'г\'.',
            'd MMM y \'г\'.',
            'dd.MM.y'
          ],
          TIMEFORMATS: const ['H:mm:ss zzzz', 'H:mm:ss z', 'H:mm:ss', 'H:mm'],
          DATETIMEFORMATS: const [
            '{1}, {0}',
            '{1}, {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale si.
      "si": new DateSymbols(
          NAME: "si",
          ERAS: const ['ක්‍රි.පූ.', 'ක්‍රි.ව.'],
          ERANAMES: const ['ක්‍රිස්තු පූර්ව', 'ක්‍රිස්තු වර්ෂ'],
          NARROWMONTHS: const [
            'ජ',
            'පෙ',
            'මා',
            'අ',
            'මැ',
            'ජූ',
            'ජූ',
            'අ',
            'සැ',
            'ඔ',
            'නෙ',
            'දෙ'
          ],
          STANDALONENARROWMONTHS: const [
            'ජ',
            'පෙ',
            'මා',
            'අ',
            'මැ',
            'ජූ',
            'ජූ',
            'අ',
            'සැ',
            'ඔ',
            'නෙ',
            'දෙ'
          ],
          MONTHS: const [
            'ජනවාරි',
            'පෙබරවාරි',
            'මාර්තු',
            'අප්‍රේල්',
            'මැයි',
            'ජූනි',
            'ජූලි',
            'අගෝස්තු',
            'සැප්තැම්බර්',
            'ඔක්තෝබර්',
            'නොවැම්බර්',
            'දෙසැම්බර්'
          ],
          STANDALONEMONTHS: const [
            'ජනවාරි',
            'පෙබරවාරි',
            'මාර්තු',
            'අප්‍රේල්',
            'මැයි',
            'ජූනි',
            'ජූලි',
            'අගෝස්තු',
            'සැප්තැම්බර්',
            'ඔක්තෝබර්',
            'නොවැම්බර්',
            'දෙසැම්බර්'
          ],
          SHORTMONTHS: const [
            'ජන',
            'පෙබ',
            'මාර්තු',
            'අප්‍රේල්',
            'මැයි',
            'ජූනි',
            'ජූලි',
            'අගෝ',
            'සැප්',
            'ඔක්',
            'නොවැ',
            'දෙසැ'
          ],
          STANDALONESHORTMONTHS: const [
            'ජන',
            'පෙබ',
            'මාර්',
            'අප්‍රේල්',
            'මැයි',
            'ජූනි',
            'ජූලි',
            'අගෝ',
            'සැප්',
            'ඔක්',
            'නොවැ',
            'දෙසැ'
          ],
          WEEKDAYS: const [
            'ඉරිදා',
            'සඳුදා',
            'අඟහරුවාදා',
            'බදාදා',
            'බ්‍රහස්පතින්දා',
            'සිකුරාදා',
            'සෙනසුරාදා'
          ],
          STANDALONEWEEKDAYS: const [
            'ඉරිදා',
            'සඳුදා',
            'අඟහරුවාදා',
            'බදාදා',
            'බ්‍රහස්පතින්දා',
            'සිකුරාදා',
            'සෙනසුරාදා'
          ],
          SHORTWEEKDAYS: const [
            'ඉරිදා',
            'සඳුදා',
            'අඟහ',
            'බදාදා',
            'බ්‍රහස්',
            'සිකු',
            'සෙන'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'ඉරිදා',
            'සඳුදා',
            'අඟහ',
            'බදාදා',
            'බ්‍රහස්',
            'සිකු',
            'සෙන'
          ],
          NARROWWEEKDAYS: const ['ඉ', 'ස', 'අ', 'බ', 'බ්‍ර', 'සි', 'සෙ'],
          STANDALONENARROWWEEKDAYS: const [
            'ඉ',
            'ස',
            'අ',
            'බ',
            'බ්‍ර',
            'සි',
            'සෙ'
          ],
          SHORTQUARTERS: const ['කාර්:1', 'කාර්:2', 'කාර්:3', 'කාර්:4'],
          QUARTERS: const [
            '1 වන කාර්තුව',
            '2 වන කාර්තුව',
            '3 වන කාර්තුව',
            '4 වන කාර්තුව'
          ],
          AMPMS: const ['පෙ.ව.', 'ප.ව.'],
          DATEFORMATS: const [
            'y MMMM d, EEEE',
            'y MMMM d',
            'y MMM d',
            'y-MM-dd'
          ],
          TIMEFORMATS: const [
            'HH.mm.ss zzzz',
            'HH.mm.ss z',
            'HH.mm.ss',
            'HH.mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 6),
      // Date/time formatting symbols for locale sk.
      "sk": new DateSymbols(
          NAME: "sk",
          ERAS: const ['pred Kr.', 'po Kr.'],
          ERANAMES: const ['pred Kristom', 'po Kristovi'],
          NARROWMONTHS: const [
            'j',
            'f',
            'm',
            'a',
            'm',
            'j',
            'j',
            'a',
            's',
            'o',
            'n',
            'd'
          ],
          STANDALONENARROWMONTHS: const [
            'j',
            'f',
            'm',
            'a',
            'm',
            'j',
            'j',
            'a',
            's',
            'o',
            'n',
            'd'
          ],
          MONTHS: const [
            'januára',
            'februára',
            'marca',
            'apríla',
            'mája',
            'júna',
            'júla',
            'augusta',
            'septembra',
            'októbra',
            'novembra',
            'decembra'
          ],
          STANDALONEMONTHS: const [
            'január',
            'február',
            'marec',
            'apríl',
            'máj',
            'jún',
            'júl',
            'august',
            'september',
            'október',
            'november',
            'december'
          ],
          SHORTMONTHS: const [
            'jan',
            'feb',
            'mar',
            'apr',
            'máj',
            'jún',
            'júl',
            'aug',
            'sep',
            'okt',
            'nov',
            'dec'
          ],
          STANDALONESHORTMONTHS: const [
            'jan',
            'feb',
            'mar',
            'apr',
            'máj',
            'jún',
            'júl',
            'aug',
            'sep',
            'okt',
            'nov',
            'dec'
          ],
          WEEKDAYS: const [
            'nedeľa',
            'pondelok',
            'utorok',
            'streda',
            'štvrtok',
            'piatok',
            'sobota'
          ],
          STANDALONEWEEKDAYS: const [
            'nedeľa',
            'pondelok',
            'utorok',
            'streda',
            'štvrtok',
            'piatok',
            'sobota'
          ],
          SHORTWEEKDAYS: const ['ne', 'po', 'ut', 'st', 'št', 'pi', 'so'],
          STANDALONESHORTWEEKDAYS: const [
            'ne',
            'po',
            'ut',
            'st',
            'št',
            'pi',
            'so'
          ],
          NARROWWEEKDAYS: const ['n', 'p', 'u', 's', 'š', 'p', 's'],
          STANDALONENARROWWEEKDAYS: const ['n', 'p', 'u', 's', 'š', 'p', 's'],
          SHORTQUARTERS: const ['Q1', 'Q2', 'Q3', 'Q4'],
          QUARTERS: const [
            '1. štvrťrok',
            '2. štvrťrok',
            '3. štvrťrok',
            '4. štvrťrok'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'EEEE d. MMMM y',
            'd. MMMM y',
            'd. M. y',
            'd. M. y'
          ],
          TIMEFORMATS: const ['H:mm:ss zzzz', 'H:mm:ss z', 'H:mm:ss', 'H:mm'],
          DATETIMEFORMATS: const [
            '{1}, {0}',
            '{1}, {0}',
            '{1}, {0}',
            '{1} {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale sl.
      "sl": new DateSymbols(
          NAME: "sl",
          ERAS: const ['pr. Kr.', 'po Kr.'],
          ERANAMES: const ['pred Kristusom', 'po Kristusu'],
          NARROWMONTHS: const [
            'j',
            'f',
            'm',
            'a',
            'm',
            'j',
            'j',
            'a',
            's',
            'o',
            'n',
            'd'
          ],
          STANDALONENARROWMONTHS: const [
            'j',
            'f',
            'm',
            'a',
            'm',
            'j',
            'j',
            'a',
            's',
            'o',
            'n',
            'd'
          ],
          MONTHS: const [
            'januar',
            'februar',
            'marec',
            'april',
            'maj',
            'junij',
            'julij',
            'avgust',
            'september',
            'oktober',
            'november',
            'december'
          ],
          STANDALONEMONTHS: const [
            'januar',
            'februar',
            'marec',
            'april',
            'maj',
            'junij',
            'julij',
            'avgust',
            'september',
            'oktober',
            'november',
            'december'
          ],
          SHORTMONTHS: const [
            'jan.',
            'feb.',
            'mar.',
            'apr.',
            'maj',
            'jun.',
            'jul.',
            'avg.',
            'sep.',
            'okt.',
            'nov.',
            'dec.'
          ],
          STANDALONESHORTMONTHS: const [
            'jan.',
            'feb.',
            'mar.',
            'apr.',
            'maj',
            'jun.',
            'jul.',
            'avg.',
            'sep.',
            'okt.',
            'nov.',
            'dec.'
          ],
          WEEKDAYS: const [
            'nedelja',
            'ponedeljek',
            'torek',
            'sreda',
            'četrtek',
            'petek',
            'sobota'
          ],
          STANDALONEWEEKDAYS: const [
            'nedelja',
            'ponedeljek',
            'torek',
            'sreda',
            'četrtek',
            'petek',
            'sobota'
          ],
          SHORTWEEKDAYS: const [
            'ned.',
            'pon.',
            'tor.',
            'sre.',
            'čet.',
            'pet.',
            'sob.'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'ned.',
            'pon.',
            'tor.',
            'sre.',
            'čet.',
            'pet.',
            'sob.'
          ],
          NARROWWEEKDAYS: const ['n', 'p', 't', 's', 'č', 'p', 's'],
          STANDALONENARROWWEEKDAYS: const ['n', 'p', 't', 's', 'č', 'p', 's'],
          SHORTQUARTERS: const ['1. čet.', '2. čet.', '3. čet.', '4. čet.'],
          QUARTERS: const [
            '1. četrtletje',
            '2. četrtletje',
            '3. četrtletje',
            '4. četrtletje'
          ],
          AMPMS: const ['dop.', 'pop.'],
          DATEFORMATS: const [
            'EEEE, dd. MMMM y',
            'dd. MMMM y',
            'd. MMM y',
            'd. MM. yy'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 6),
      // Date/time formatting symbols for locale sq.
      "sq": new DateSymbols(
          NAME: "sq",
          ERAS: const ['p.K.', 'mb.K.'],
          ERANAMES: const ['para Krishtit', 'mbas Krishtit'],
          NARROWMONTHS: const [
            'j',
            'sh',
            'm',
            'p',
            'm',
            'q',
            'k',
            'g',
            'sh',
            't',
            'n',
            'dh'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'Sh',
            'M',
            'P',
            'M',
            'Q',
            'K',
            'G',
            'Sh',
            'T',
            'N',
            'Dh'
          ],
          MONTHS: const [
            'janar',
            'shkurt',
            'mars',
            'prill',
            'maj',
            'qershor',
            'korrik',
            'gusht',
            'shtator',
            'tetor',
            'nëntor',
            'dhjetor'
          ],
          STANDALONEMONTHS: const [
            'Janar',
            'Shkurt',
            'Mars',
            'Prill',
            'Maj',
            'Qershor',
            'Korrik',
            'Gusht',
            'Shtator',
            'Tetor',
            'Nëntor',
            'Dhjetor'
          ],
          SHORTMONTHS: const [
            'jan',
            'shk',
            'mar',
            'pri',
            'maj',
            'qer',
            'korr',
            'gush',
            'sht',
            'tet',
            'nën',
            'dhj'
          ],
          STANDALONESHORTMONTHS: const [
            'Jan',
            'Shk',
            'Mar',
            'Pri',
            'Maj',
            'Qer',
            'Korr',
            'Gush',
            'Sht',
            'Tet',
            'Nën',
            'Dhj'
          ],
          WEEKDAYS: const [
            'e diel',
            'e hënë',
            'e martë',
            'e mërkurë',
            'e enjte',
            'e premte',
            'e shtunë'
          ],
          STANDALONEWEEKDAYS: const [
            'E diel',
            'E hënë',
            'E martë',
            'E mërkurë',
            'E enjte',
            'E premte',
            'E shtunë'
          ],
          SHORTWEEKDAYS: const [
            'Die',
            'Hën',
            'Mar',
            'Mër',
            'Enj',
            'Pre',
            'Sht'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'Die',
            'Hën',
            'Mar',
            'Mër',
            'Enj',
            'Pre',
            'Sht'
          ],
          NARROWWEEKDAYS: const ['D', 'H', 'M', 'M', 'E', 'P', 'Sh'],
          STANDALONENARROWWEEKDAYS: const ['D', 'H', 'M', 'M', 'E', 'P', 'Sh'],
          SHORTQUARTERS: const [
            'tremujori I',
            'tremujori II',
            'tremujori III',
            'tremujori IV'
          ],
          QUARTERS: const [
            'tremujori i parë',
            'tremujori i dytë',
            'tremujori i tretë',
            'tremujori i katërt'
          ],
          AMPMS: const ['e paradites', 'e pasdites'],
          DATEFORMATS: const [
            'EEEE, d MMMM y',
            'd MMMM y',
            'd MMM y',
            'd.M.yy'
          ],
          TIMEFORMATS: const [
            'h:mm:ss a, zzzz',
            'h:mm:ss a, z',
            'h:mm:ss a',
            'h:mm a'
          ],
          DATETIMEFORMATS: const [
            '{1} \'në\' {0}',
            '{1} \'në\' {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 6),
      // Date/time formatting symbols for locale sr.
      "sr": new DateSymbols(
          NAME: "sr",
          ERAS: const ['п. н. е.', 'н. е.'],
          ERANAMES: const ['пре нове ере', 'нове ере'],
          NARROWMONTHS: const [
            'ј',
            'ф',
            'м',
            'а',
            'м',
            'ј',
            'ј',
            'а',
            'с',
            'о',
            'н',
            'д'
          ],
          STANDALONENARROWMONTHS: const [
            'ј',
            'ф',
            'м',
            'а',
            'м',
            'ј',
            'ј',
            'а',
            'с',
            'о',
            'н',
            'д'
          ],
          MONTHS: const [
            'јануар',
            'фебруар',
            'март',
            'април',
            'мај',
            'јун',
            'јул',
            'август',
            'септембар',
            'октобар',
            'новембар',
            'децембар'
          ],
          STANDALONEMONTHS: const [
            'јануар',
            'фебруар',
            'март',
            'април',
            'мај',
            'јун',
            'јул',
            'август',
            'септембар',
            'октобар',
            'новембар',
            'децембар'
          ],
          SHORTMONTHS: const [
            'јан',
            'феб',
            'мар',
            'апр',
            'мај',
            'јун',
            'јул',
            'авг',
            'сеп',
            'окт',
            'нов',
            'дец'
          ],
          STANDALONESHORTMONTHS: const [
            'јан',
            'феб',
            'мар',
            'апр',
            'мај',
            'јун',
            'јул',
            'авг',
            'сеп',
            'окт',
            'нов',
            'дец'
          ],
          WEEKDAYS: const [
            'недеља',
            'понедељак',
            'уторак',
            'среда',
            'четвртак',
            'петак',
            'субота'
          ],
          STANDALONEWEEKDAYS: const [
            'недеља',
            'понедељак',
            'уторак',
            'среда',
            'четвртак',
            'петак',
            'субота'
          ],
          SHORTWEEKDAYS: const [
            'нед',
            'пон',
            'уто',
            'сре',
            'чет',
            'пет',
            'суб'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'нед',
            'пон',
            'уто',
            'сре',
            'чет',
            'пет',
            'суб'
          ],
          NARROWWEEKDAYS: const ['н', 'п', 'у', 'с', 'ч', 'п', 'с'],
          STANDALONENARROWWEEKDAYS: const ['н', 'п', 'у', 'с', 'ч', 'п', 'с'],
          SHORTQUARTERS: const ['К1', 'К2', 'К3', 'К4'],
          QUARTERS: const [
            'први квартал',
            'други квартал',
            'трећи квартал',
            'четврти квартал'
          ],
          AMPMS: const ['пре подне', 'по подне'],
          DATEFORMATS: const [
            'EEEE, dd. MMMM y.',
            'dd. MMMM y.',
            'dd.MM.y.',
            'd.M.yy.'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 6),
      // Date/time formatting symbols for locale sr_Latn.
      "sr_Latn": new DateSymbols(
          NAME: "sr_Latn",
          ERAS: const ['p. n. e.', 'n. e.'],
          ERANAMES: const ['pre nove ere', 'nove ere'],
          NARROWMONTHS: const [
            'j',
            'f',
            'm',
            'a',
            'm',
            'j',
            'j',
            'a',
            's',
            'o',
            'n',
            'd'
          ],
          STANDALONENARROWMONTHS: const [
            'j',
            'f',
            'm',
            'a',
            'm',
            'j',
            'j',
            'a',
            's',
            'o',
            'n',
            'd'
          ],
          MONTHS: const [
            'januar',
            'februar',
            'mart',
            'april',
            'maj',
            'jun',
            'jul',
            'avgust',
            'septembar',
            'oktobar',
            'novembar',
            'decembar'
          ],
          STANDALONEMONTHS: const [
            'januar',
            'februar',
            'mart',
            'april',
            'maj',
            'jun',
            'jul',
            'avgust',
            'septembar',
            'oktobar',
            'novembar',
            'decembar'
          ],
          SHORTMONTHS: const [
            'jan',
            'feb',
            'mar',
            'apr',
            'maj',
            'jun',
            'jul',
            'avg',
            'sep',
            'okt',
            'nov',
            'dec'
          ],
          STANDALONESHORTMONTHS: const [
            'jan',
            'feb',
            'mar',
            'apr',
            'maj',
            'jun',
            'jul',
            'avg',
            'sep',
            'okt',
            'nov',
            'dec'
          ],
          WEEKDAYS: const [
            'nedelja',
            'ponedeljak',
            'utorak',
            'sreda',
            'četvrtak',
            'petak',
            'subota'
          ],
          STANDALONEWEEKDAYS: const [
            'nedelja',
            'ponedeljak',
            'utorak',
            'sreda',
            'četvrtak',
            'petak',
            'subota'
          ],
          SHORTWEEKDAYS: const [
            'ned',
            'pon',
            'uto',
            'sre',
            'čet',
            'pet',
            'sub'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'ned',
            'pon',
            'uto',
            'sre',
            'čet',
            'pet',
            'sub'
          ],
          NARROWWEEKDAYS: const ['n', 'p', 'u', 's', 'č', 'p', 's'],
          STANDALONENARROWWEEKDAYS: const ['n', 'p', 'u', 's', 'č', 'p', 's'],
          SHORTQUARTERS: const ['K1', 'K2', 'K3', 'K4'],
          QUARTERS: const [
            'prvi kvartal',
            'drugi kvartal',
            'treći kvartal',
            'četvrti kvartal'
          ],
          AMPMS: const ['pre podne', 'po podne'],
          DATEFORMATS: const [
            'EEEE, dd. MMMM y.',
            'dd. MMMM y.',
            'dd.MM.y.',
            'd.M.yy.'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 6),
      // Date/time formatting symbols for locale sv.
      "sv": new DateSymbols(
          NAME: "sv",
          ERAS: const ['f.Kr.', 'e.Kr.'],
          ERANAMES: const ['före Kristus', 'efter Kristus'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'januari',
            'februari',
            'mars',
            'april',
            'maj',
            'juni',
            'juli',
            'augusti',
            'september',
            'oktober',
            'november',
            'december'
          ],
          STANDALONEMONTHS: const [
            'januari',
            'februari',
            'mars',
            'april',
            'maj',
            'juni',
            'juli',
            'augusti',
            'september',
            'oktober',
            'november',
            'december'
          ],
          SHORTMONTHS: const [
            'jan.',
            'feb.',
            'mars',
            'apr.',
            'maj',
            'juni',
            'juli',
            'aug.',
            'sep.',
            'okt.',
            'nov.',
            'dec.'
          ],
          STANDALONESHORTMONTHS: const [
            'jan.',
            'feb.',
            'mars',
            'apr.',
            'maj',
            'juni',
            'juli',
            'aug.',
            'sep.',
            'okt.',
            'nov.',
            'dec.'
          ],
          WEEKDAYS: const [
            'söndag',
            'måndag',
            'tisdag',
            'onsdag',
            'torsdag',
            'fredag',
            'lördag'
          ],
          STANDALONEWEEKDAYS: const [
            'söndag',
            'måndag',
            'tisdag',
            'onsdag',
            'torsdag',
            'fredag',
            'lördag'
          ],
          SHORTWEEKDAYS: const [
            'sön',
            'mån',
            'tis',
            'ons',
            'tors',
            'fre',
            'lör'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'sön',
            'mån',
            'tis',
            'ons',
            'tors',
            'fre',
            'lör'
          ],
          NARROWWEEKDAYS: const ['S', 'M', 'T', 'O', 'T', 'F', 'L'],
          STANDALONENARROWWEEKDAYS: const ['S', 'M', 'T', 'O', 'T', 'F', 'L'],
          SHORTQUARTERS: const ['K1', 'K2', 'K3', 'K4'],
          QUARTERS: const [
            '1:a kvartalet',
            '2:a kvartalet',
            '3:e kvartalet',
            '4:e kvartalet'
          ],
          AMPMS: const ['fm', 'em'],
          DATEFORMATS: const [
            'EEEE d MMMM y',
            'd MMMM y',
            'd MMM y',
            'y-MM-dd'
          ],
          TIMEFORMATS: const [
            '\'kl\'. HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 3),
      // Date/time formatting symbols for locale sw.
      "sw": new DateSymbols(
          NAME: "sw",
          ERAS: const ['KK', 'BK'],
          ERANAMES: const ['Kabla ya Kristo', 'Baada ya Kristo'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'Januari',
            'Februari',
            'Machi',
            'Aprili',
            'Mei',
            'Juni',
            'Julai',
            'Agosti',
            'Septemba',
            'Oktoba',
            'Novemba',
            'Desemba'
          ],
          STANDALONEMONTHS: const [
            'Januari',
            'Februari',
            'Machi',
            'Aprili',
            'Mei',
            'Juni',
            'Julai',
            'Agosti',
            'Septemba',
            'Oktoba',
            'Novemba',
            'Desemba'
          ],
          SHORTMONTHS: const [
            'Jan',
            'Feb',
            'Mac',
            'Apr',
            'Mei',
            'Jun',
            'Jul',
            'Ago',
            'Sep',
            'Okt',
            'Nov',
            'Des'
          ],
          STANDALONESHORTMONTHS: const [
            'Jan',
            'Feb',
            'Mac',
            'Apr',
            'Mei',
            'Jun',
            'Jul',
            'Ago',
            'Sep',
            'Okt',
            'Nov',
            'Des'
          ],
          WEEKDAYS: const [
            'Jumapili',
            'Jumatatu',
            'Jumanne',
            'Jumatano',
            'Alhamisi',
            'Ijumaa',
            'Jumamosi'
          ],
          STANDALONEWEEKDAYS: const [
            'Jumapili',
            'Jumatatu',
            'Jumanne',
            'Jumatano',
            'Alhamisi',
            'Ijumaa',
            'Jumamosi'
          ],
          SHORTWEEKDAYS: const [
            'Jumapili',
            'Jumatatu',
            'Jumanne',
            'Jumatano',
            'Alhamisi',
            'Ijumaa',
            'Jumamosi'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'Jumapili',
            'Jumatatu',
            'Jumanne',
            'Jumatano',
            'Alhamisi',
            'Ijumaa',
            'Jumamosi'
          ],
          NARROWWEEKDAYS: const ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
          STANDALONENARROWWEEKDAYS: const ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
          SHORTQUARTERS: const [
            'Robo ya 1',
            'Robo ya 2',
            'Robo ya 3',
            'Robo ya 4'
          ],
          QUARTERS: const ['Robo ya 1', 'Robo ya 2', 'Robo ya 3', 'Robo ya 4'],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'EEEE, d MMMM y',
            'd MMMM y',
            'd MMM y',
            'dd/MM/y'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 6),
      // Date/time formatting symbols for locale ta.
      "ta": new DateSymbols(
          NAME: "ta",
          ERAS: const ['கி.மு.', 'கி.பி.'],
          ERANAMES: const ['கிறிஸ்துவுக்கு முன்', 'அன்னோ டோமினி'],
          NARROWMONTHS: const [
            'ஜ',
            'பி',
            'மா',
            'ஏ',
            'மே',
            'ஜூ',
            'ஜூ',
            'ஆ',
            'செ',
            'அ',
            'ந',
            'டி'
          ],
          STANDALONENARROWMONTHS: const [
            'ஜ',
            'பி',
            'மா',
            'ஏ',
            'மே',
            'ஜூ',
            'ஜூ',
            'ஆ',
            'செ',
            'அ',
            'ந',
            'டி'
          ],
          MONTHS: const [
            'ஜனவரி',
            'பிப்ரவரி',
            'மார்ச்',
            'ஏப்ரல்',
            'மே',
            'ஜூன்',
            'ஜூலை',
            'ஆகஸ்ட்',
            'செப்டம்பர்',
            'அக்டோபர்',
            'நவம்பர்',
            'டிசம்பர்'
          ],
          STANDALONEMONTHS: const [
            'ஜனவரி',
            'பிப்ரவரி',
            'மார்ச்',
            'ஏப்ரல்',
            'மே',
            'ஜூன்',
            'ஜூலை',
            'ஆகஸ்ட்',
            'செப்டம்பர்',
            'அக்டோபர்',
            'நவம்பர்',
            'டிசம்பர்'
          ],
          SHORTMONTHS: const [
            'ஜன.',
            'பிப்.',
            'மார்.',
            'ஏப்.',
            'மே',
            'ஜூன்',
            'ஜூலை',
            'ஆக.',
            'செப்.',
            'அக்.',
            'நவ.',
            'டிச.'
          ],
          STANDALONESHORTMONTHS: const [
            'ஜன.',
            'பிப்.',
            'மார்.',
            'ஏப்.',
            'மே',
            'ஜூன்',
            'ஜூலை',
            'ஆக.',
            'செப்.',
            'அக்.',
            'நவ.',
            'டிச.'
          ],
          WEEKDAYS: const [
            'ஞாயிறு',
            'திங்கள்',
            'செவ்வாய்',
            'புதன்',
            'வியாழன்',
            'வெள்ளி',
            'சனி'
          ],
          STANDALONEWEEKDAYS: const [
            'ஞாயிறு',
            'திங்கள்',
            'செவ்வாய்',
            'புதன்',
            'வியாழன்',
            'வெள்ளி',
            'சனி'
          ],
          SHORTWEEKDAYS: const [
            'ஞாயி.',
            'திங்.',
            'செவ்.',
            'புத.',
            'வியா.',
            'வெள்.',
            'சனி'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'ஞாயி.',
            'திங்.',
            'செவ்.',
            'புத.',
            'வியா.',
            'வெள்.',
            'சனி'
          ],
          NARROWWEEKDAYS: const ['ஞா', 'தி', 'செ', 'பு', 'வி', 'வெ', 'ச'],
          STANDALONENARROWWEEKDAYS: const [
            'ஞா',
            'தி',
            'செ',
            'பு',
            'வி',
            'வெ',
            'ச'
          ],
          SHORTQUARTERS: const ['காலா.1', 'காலா.2', 'காலா.3', 'காலா.4'],
          QUARTERS: const [
            'ஒன்றாம் காலாண்டு',
            'இரண்டாம் காலாண்டு',
            'மூன்றாம் காலாண்டு',
            'நான்காம் காலாண்டு'
          ],
          AMPMS: const ['முற்பகல்', 'பிற்பகல்'],
          DATEFORMATS: const [
            'EEEE, d MMMM, y',
            'd MMMM, y',
            'd MMM, y',
            'd/M/yy'
          ],
          TIMEFORMATS: const [
            'a h:mm:ss zzzz',
            'a h:mm:ss z',
            'a h:mm:ss',
            'a h:mm'
          ],
          DATETIMEFORMATS: const [
            '{1} ’அன்று’ {0}',
            '{1} ’அன்று’ {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [6, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale te.
      "te": new DateSymbols(
          NAME: "te",
          ERAS: const ['క్రీపూ', 'క్రీశ'],
          ERANAMES: const ['క్రీస్తు పూర్వం', 'క్రీస్తు శకం'],
          NARROWMONTHS: const [
            'జ',
            'ఫి',
            'మా',
            'ఏ',
            'మే',
            'జూ',
            'జు',
            'ఆ',
            'సె',
            'అ',
            'న',
            'డి'
          ],
          STANDALONENARROWMONTHS: const [
            'జ',
            'ఫి',
            'మా',
            'ఏ',
            'మే',
            'జూ',
            'జు',
            'ఆ',
            'సె',
            'అ',
            'న',
            'డి'
          ],
          MONTHS: const [
            'జనవరి',
            'ఫిబ్రవరి',
            'మార్చి',
            'ఏప్రిల్',
            'మే',
            'జూన్',
            'జులై',
            'ఆగస్టు',
            'సెప్టెంబర్',
            'అక్టోబర్',
            'నవంబర్',
            'డిసెంబర్'
          ],
          STANDALONEMONTHS: const [
            'జనవరి',
            'ఫిబ్రవరి',
            'మార్చి',
            'ఏప్రిల్',
            'మే',
            'జూన్',
            'జులై',
            'ఆగస్టు',
            'సెప్టెంబర్',
            'అక్టోబర్',
            'నవంబర్',
            'డిసెంబర్'
          ],
          SHORTMONTHS: const [
            'జన',
            'ఫిబ్ర',
            'మార్చి',
            'ఏప్రి',
            'మే',
            'జూన్',
            'జులై',
            'ఆగ',
            'సెప్టెం',
            'అక్టో',
            'నవం',
            'డిసెం'
          ],
          STANDALONESHORTMONTHS: const [
            'జన',
            'ఫిబ్ర',
            'మార్చి',
            'ఏప్రి',
            'మే',
            'జూన్',
            'జులై',
            'ఆగ',
            'సెప్టెం',
            'అక్టో',
            'నవం',
            'డిసెం'
          ],
          WEEKDAYS: const [
            'ఆదివారం',
            'సోమవారం',
            'మంగళవారం',
            'బుధవారం',
            'గురువారం',
            'శుక్రవారం',
            'శనివారం'
          ],
          STANDALONEWEEKDAYS: const [
            'ఆదివారం',
            'సోమవారం',
            'మంగళవారం',
            'బుధవారం',
            'గురువారం',
            'శుక్రవారం',
            'శనివారం'
          ],
          SHORTWEEKDAYS: const [
            'ఆది',
            'సోమ',
            'మంగళ',
            'బుధ',
            'గురు',
            'శుక్ర',
            'శని'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'ఆది',
            'సోమ',
            'మంగళ',
            'బుధ',
            'గురు',
            'శుక్ర',
            'శని'
          ],
          NARROWWEEKDAYS: const ['ఆ', 'సో', 'మ', 'బు', 'గు', 'శు', 'శ'],
          STANDALONENARROWWEEKDAYS: const [
            'ఆ',
            'సో',
            'మ',
            'బు',
            'గు',
            'శు',
            'శ'
          ],
          SHORTQUARTERS: const ['త్రై1', 'త్రై2', 'త్రై3', 'త్రై4'],
          QUARTERS: const [
            '1వ త్రైమాసికం',
            '2వ త్రైమాసికం',
            '3వ త్రైమాసికం',
            '4వ త్రైమాసికం'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'd, MMMM y, EEEE',
            'd MMMM, y',
            'd MMM, y',
            'dd-MM-yy'
          ],
          TIMEFORMATS: const [
            'h:mm:ss a zzzz',
            'h:mm:ss a z',
            'h:mm:ss a',
            'h:mm a'
          ],
          DATETIMEFORMATS: const [
            '{1} {0}కి',
            '{1} {0}కి',
            '{1} {0}',
            '{1} {0}'
          ],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [6, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale th.
      "th": new DateSymbols(
          NAME: "th",
          ERAS: const ['ปีก่อน ค.ศ.', 'ค.ศ.'],
          ERANAMES: const ['ปีก่อนคริสต์ศักราช', 'คริสต์ศักราช'],
          NARROWMONTHS: const [
            'ม.ค.',
            'ก.พ.',
            'มี.ค.',
            'เม.ย.',
            'พ.ค.',
            'มิ.ย.',
            'ก.ค.',
            'ส.ค.',
            'ก.ย.',
            'ต.ค.',
            'พ.ย.',
            'ธ.ค.'
          ],
          STANDALONENARROWMONTHS: const [
            'ม.ค.',
            'ก.พ.',
            'มี.ค.',
            'เม.ย.',
            'พ.ค.',
            'มิ.ย.',
            'ก.ค.',
            'ส.ค.',
            'ก.ย.',
            'ต.ค.',
            'พ.ย.',
            'ธ.ค.'
          ],
          MONTHS: const [
            'มกราคม',
            'กุมภาพันธ์',
            'มีนาคม',
            'เมษายน',
            'พฤษภาคม',
            'มิถุนายน',
            'กรกฎาคม',
            'สิงหาคม',
            'กันยายน',
            'ตุลาคม',
            'พฤศจิกายน',
            'ธันวาคม'
          ],
          STANDALONEMONTHS: const [
            'มกราคม',
            'กุมภาพันธ์',
            'มีนาคม',
            'เมษายน',
            'พฤษภาคม',
            'มิถุนายน',
            'กรกฎาคม',
            'สิงหาคม',
            'กันยายน',
            'ตุลาคม',
            'พฤศจิกายน',
            'ธันวาคม'
          ],
          SHORTMONTHS: const [
            'ม.ค.',
            'ก.พ.',
            'มี.ค.',
            'เม.ย.',
            'พ.ค.',
            'มิ.ย.',
            'ก.ค.',
            'ส.ค.',
            'ก.ย.',
            'ต.ค.',
            'พ.ย.',
            'ธ.ค.'
          ],
          STANDALONESHORTMONTHS: const [
            'ม.ค.',
            'ก.พ.',
            'มี.ค.',
            'เม.ย.',
            'พ.ค.',
            'มิ.ย.',
            'ก.ค.',
            'ส.ค.',
            'ก.ย.',
            'ต.ค.',
            'พ.ย.',
            'ธ.ค.'
          ],
          WEEKDAYS: const [
            'วันอาทิตย์',
            'วันจันทร์',
            'วันอังคาร',
            'วันพุธ',
            'วันพฤหัสบดี',
            'วันศุกร์',
            'วันเสาร์'
          ],
          STANDALONEWEEKDAYS: const [
            'วันอาทิตย์',
            'วันจันทร์',
            'วันอังคาร',
            'วันพุธ',
            'วันพฤหัสบดี',
            'วันศุกร์',
            'วันเสาร์'
          ],
          SHORTWEEKDAYS: const ['อา.', 'จ.', 'อ.', 'พ.', 'พฤ.', 'ศ.', 'ส.'],
          STANDALONESHORTWEEKDAYS: const [
            'อา.',
            'จ.',
            'อ.',
            'พ.',
            'พฤ.',
            'ศ.',
            'ส.'
          ],
          NARROWWEEKDAYS: const ['อา', 'จ', 'อ', 'พ', 'พฤ', 'ศ', 'ส'],
          STANDALONENARROWWEEKDAYS: const ['อา', 'จ', 'อ', 'พ', 'พฤ', 'ศ', 'ส'],
          SHORTQUARTERS: const ['ไตรมาส 1', 'ไตรมาส 2', 'ไตรมาส 3', 'ไตรมาส 4'],
          QUARTERS: const ['ไตรมาส 1', 'ไตรมาส 2', 'ไตรมาส 3', 'ไตรมาส 4'],
          AMPMS: const ['ก่อนเที่ยง', 'หลังเที่ยง'],
          DATEFORMATS: const [
            'EEEEที่ d MMMM G y',
            'd MMMM G y',
            'd MMM y',
            'd/M/yy'
          ],
          TIMEFORMATS: const [
            'H นาฬิกา mm นาที ss วินาที zzzz',
            'H นาฬิกา mm นาที ss วินาที z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale tl.
      "tl": new DateSymbols(
          NAME: "tl",
          ERAS: const ['BC', 'AD'],
          ERANAMES: const ['Before Christ', 'Anno Domini'],
          NARROWMONTHS: const [
            'Ene',
            'Peb',
            'Mar',
            'Abr',
            'May',
            'Hun',
            'Hul',
            'Ago',
            'Set',
            'Okt',
            'Nob',
            'Dis'
          ],
          STANDALONENARROWMONTHS: const [
            'E',
            'P',
            'M',
            'A',
            'M',
            'Hun',
            'Hul',
            'Ago',
            'Set',
            'Okt',
            'Nob',
            'Dis'
          ],
          MONTHS: const [
            'Enero',
            'Pebrero',
            'Marso',
            'Abril',
            'Mayo',
            'Hunyo',
            'Hulyo',
            'Agosto',
            'Setyembre',
            'Oktubre',
            'Nobyembre',
            'Disyembre'
          ],
          STANDALONEMONTHS: const [
            'Enero',
            'Pebrero',
            'Marso',
            'Abril',
            'Mayo',
            'Hunyo',
            'Hulyo',
            'Agosto',
            'Setyembre',
            'Oktubre',
            'Nobyembre',
            'Disyembre'
          ],
          SHORTMONTHS: const [
            'Ene',
            'Peb',
            'Mar',
            'Abr',
            'May',
            'Hun',
            'Hul',
            'Ago',
            'Set',
            'Okt',
            'Nob',
            'Dis'
          ],
          STANDALONESHORTMONTHS: const [
            'Ene',
            'Peb',
            'Mar',
            'Abr',
            'May',
            'Hun',
            'Hul',
            'Ago',
            'Set',
            'Okt',
            'Nob',
            'Dis'
          ],
          WEEKDAYS: const [
            'Linggo',
            'Lunes',
            'Martes',
            'Miyerkules',
            'Huwebes',
            'Biyernes',
            'Sabado'
          ],
          STANDALONEWEEKDAYS: const [
            'Linggo',
            'Lunes',
            'Martes',
            'Miyerkules',
            'Huwebes',
            'Biyernes',
            'Sabado'
          ],
          SHORTWEEKDAYS: const [
            'Lin',
            'Lun',
            'Mar',
            'Miy',
            'Huw',
            'Biy',
            'Sab'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'Lin',
            'Lun',
            'Mar',
            'Miy',
            'Huw',
            'Biy',
            'Sab'
          ],
          NARROWWEEKDAYS: const [
            'Lin',
            'Lun',
            'Mar',
            'Miy',
            'Huw',
            'Biy',
            'Sab'
          ],
          STANDALONENARROWWEEKDAYS: const [
            'Lin',
            'Lun',
            'Mar',
            'Miy',
            'Huw',
            'Biy',
            'Sab'
          ],
          SHORTQUARTERS: const ['Q1', 'Q2', 'Q3', 'Q4'],
          QUARTERS: const [
            'ika-1 quarter',
            'ika-2 quarter',
            'ika-3 quarter',
            'ika-4 na quarter'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'EEEE, MMMM d, y',
            'MMMM d, y',
            'MMM d, y',
            'M/d/yy'
          ],
          TIMEFORMATS: const [
            'h:mm:ss a zzzz',
            'h:mm:ss a z',
            'h:mm:ss a',
            'h:mm a'
          ],
          DATETIMEFORMATS: const [
            '{1} \'nang\' {0}',
            '{1} \'nang\' {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale tr.
      "tr": new DateSymbols(
          NAME: "tr",
          ERAS: const ['MÖ', 'MS'],
          ERANAMES: const ['Milattan Önce', 'Milattan Sonra'],
          NARROWMONTHS: const [
            'O',
            'Ş',
            'M',
            'N',
            'M',
            'H',
            'T',
            'A',
            'E',
            'E',
            'K',
            'A'
          ],
          STANDALONENARROWMONTHS: const [
            'O',
            'Ş',
            'M',
            'N',
            'M',
            'H',
            'T',
            'A',
            'E',
            'E',
            'K',
            'A'
          ],
          MONTHS: const [
            'Ocak',
            'Şubat',
            'Mart',
            'Nisan',
            'Mayıs',
            'Haziran',
            'Temmuz',
            'Ağustos',
            'Eylül',
            'Ekim',
            'Kasım',
            'Aralık'
          ],
          STANDALONEMONTHS: const [
            'Ocak',
            'Şubat',
            'Mart',
            'Nisan',
            'Mayıs',
            'Haziran',
            'Temmuz',
            'Ağustos',
            'Eylül',
            'Ekim',
            'Kasım',
            'Aralık'
          ],
          SHORTMONTHS: const [
            'Oca',
            'Şub',
            'Mar',
            'Nis',
            'May',
            'Haz',
            'Tem',
            'Ağu',
            'Eyl',
            'Eki',
            'Kas',
            'Ara'
          ],
          STANDALONESHORTMONTHS: const [
            'Oca',
            'Şub',
            'Mar',
            'Nis',
            'May',
            'Haz',
            'Tem',
            'Ağu',
            'Eyl',
            'Eki',
            'Kas',
            'Ara'
          ],
          WEEKDAYS: const [
            'Pazar',
            'Pazartesi',
            'Salı',
            'Çarşamba',
            'Perşembe',
            'Cuma',
            'Cumartesi'
          ],
          STANDALONEWEEKDAYS: const [
            'Pazar',
            'Pazartesi',
            'Salı',
            'Çarşamba',
            'Perşembe',
            'Cuma',
            'Cumartesi'
          ],
          SHORTWEEKDAYS: const [
            'Paz',
            'Pzt',
            'Sal',
            'Çar',
            'Per',
            'Cum',
            'Cmt'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'Paz',
            'Pzt',
            'Sal',
            'Çar',
            'Per',
            'Cum',
            'Cmt'
          ],
          NARROWWEEKDAYS: const ['P', 'P', 'S', 'Ç', 'P', 'C', 'C'],
          STANDALONENARROWWEEKDAYS: const ['P', 'P', 'S', 'Ç', 'P', 'C', 'C'],
          SHORTQUARTERS: const ['Ç1', 'Ç2', 'Ç3', 'Ç4'],
          QUARTERS: const ['1. çeyrek', '2. çeyrek', '3. çeyrek', '4. çeyrek'],
          AMPMS: const ['ÖÖ', 'ÖS'],
          DATEFORMATS: const ['d MMMM y EEEE', 'd MMMM y', 'd MMM y', 'd.MM.y'],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 6),
      // Date/time formatting symbols for locale uk.
      "uk": new DateSymbols(
          NAME: "uk",
          ERAS: const ['до н. е.', 'н. е.'],
          ERANAMES: const ['до нашої ери', 'нашої ери'],
          NARROWMONTHS: const [
            'с',
            'л',
            'б',
            'к',
            'т',
            'ч',
            'л',
            'с',
            'в',
            'ж',
            'л',
            'г'
          ],
          STANDALONENARROWMONTHS: const [
            'С',
            'Л',
            'Б',
            'К',
            'Т',
            'Ч',
            'Л',
            'С',
            'В',
            'Ж',
            'Л',
            'Г'
          ],
          MONTHS: const [
            'січня',
            'лютого',
            'березня',
            'квітня',
            'травня',
            'червня',
            'липня',
            'серпня',
            'вересня',
            'жовтня',
            'листопада',
            'грудня'
          ],
          STANDALONEMONTHS: const [
            'січень',
            'лютий',
            'березень',
            'квітень',
            'травень',
            'червень',
            'липень',
            'серпень',
            'вересень',
            'жовтень',
            'листопад',
            'грудень'
          ],
          SHORTMONTHS: const [
            'січ.',
            'лют.',
            'бер.',
            'квіт.',
            'трав.',
            'черв.',
            'лип.',
            'серп.',
            'вер.',
            'жовт.',
            'лист.',
            'груд.'
          ],
          STANDALONESHORTMONTHS: const [
            'січ',
            'лют',
            'бер',
            'кві',
            'тра',
            'чер',
            'лип',
            'сер',
            'вер',
            'жов',
            'лис',
            'гру'
          ],
          WEEKDAYS: const [
            'неділя',
            'понеділок',
            'вівторок',
            'середа',
            'четвер',
            'пʼятниця',
            'субота'
          ],
          STANDALONEWEEKDAYS: const [
            'неділя',
            'понеділок',
            'вівторок',
            'середа',
            'четвер',
            'пʼятниця',
            'субота'
          ],
          SHORTWEEKDAYS: const ['нд', 'пн', 'вт', 'ср', 'чт', 'пт', 'сб'],
          STANDALONESHORTWEEKDAYS: const [
            'нд',
            'пн',
            'вт',
            'ср',
            'чт',
            'пт',
            'сб'
          ],
          NARROWWEEKDAYS: const ['Н', 'П', 'В', 'С', 'Ч', 'П', 'С'],
          STANDALONENARROWWEEKDAYS: const ['Н', 'П', 'В', 'С', 'Ч', 'П', 'С'],
          SHORTQUARTERS: const ['1-й кв.', '2-й кв.', '3-й кв.', '4-й кв.'],
          QUARTERS: const [
            '1-й квартал',
            '2-й квартал',
            '3-й квартал',
            '4-й квартал'
          ],
          AMPMS: const ['дп', 'пп'],
          DATEFORMATS: const [
            'EEEE, d MMMM y \'р\'.',
            'd MMMM y \'р\'.',
            'd MMM y \'р\'.',
            'dd.MM.yy'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const [
            '{1} \'о\' {0}',
            '{1} \'о\' {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 6),
      // Date/time formatting symbols for locale ur.
      "ur": new DateSymbols(
          NAME: "ur",
          ERAS: const ['قبل مسیح', 'عیسوی'],
          ERANAMES: const ['قبل مسیح', 'عیسوی'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'جنوری',
            'فروری',
            'مارچ',
            'اپریل',
            'مئی',
            'جون',
            'جولائی',
            'اگست',
            'ستمبر',
            'اکتوبر',
            'نومبر',
            'دسمبر'
          ],
          STANDALONEMONTHS: const [
            'جنوری',
            'فروری',
            'مارچ',
            'اپریل',
            'مئی',
            'جون',
            'جولائی',
            'اگست',
            'ستمبر',
            'اکتوبر',
            'نومبر',
            'دسمبر'
          ],
          SHORTMONTHS: const [
            'جنوری',
            'فروری',
            'مارچ',
            'اپریل',
            'مئی',
            'جون',
            'جولائی',
            'اگست',
            'ستمبر',
            'اکتوبر',
            'نومبر',
            'دسمبر'
          ],
          STANDALONESHORTMONTHS: const [
            'جنوری',
            'فروری',
            'مارچ',
            'اپریل',
            'مئی',
            'جون',
            'جولائی',
            'اگست',
            'ستمبر',
            'اکتوبر',
            'نومبر',
            'دسمبر'
          ],
          WEEKDAYS: const [
            'اتوار',
            'پیر',
            'منگل',
            'بدھ',
            'جمعرات',
            'جمعہ',
            'ہفتہ'
          ],
          STANDALONEWEEKDAYS: const [
            'اتوار',
            'پیر',
            'منگل',
            'بدھ',
            'جمعرات',
            'جمعہ',
            'ہفتہ'
          ],
          SHORTWEEKDAYS: const [
            'اتوار',
            'پیر',
            'منگل',
            'بدھ',
            'جمعرات',
            'جمعہ',
            'ہفتہ'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'اتوار',
            'پیر',
            'منگل',
            'بدھ',
            'جمعرات',
            'جمعہ',
            'ہفتہ'
          ],
          NARROWWEEKDAYS: const ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
          STANDALONENARROWWEEKDAYS: const ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
          SHORTQUARTERS: const [
            'پہلی سہ ماہی',
            'دوسری سہ ماہی',
            'تیسری سہ ماہی',
            'چوتهی سہ ماہی'
          ],
          QUARTERS: const [
            'پہلی سہ ماہی',
            'دوسری سہ ماہی',
            'تیسری سہ ماہی',
            'چوتهی سہ ماہی'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'EEEE، d MMMM، y',
            'd MMMM، y',
            'd MMM، y',
            'd/M/yy'
          ],
          TIMEFORMATS: const [
            'h:mm:ss a zzzz',
            'h:mm:ss a z',
            'h:mm:ss a',
            'h:mm a'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale uz.
      "uz": new DateSymbols(
          NAME: "uz",
          ERAS: const ['m.a.', 'milodiy'],
          ERANAMES: const ['miloddan avvalgi', 'milodiy'],
          NARROWMONTHS: const [
            'Y',
            'F',
            'M',
            'A',
            'M',
            'I',
            'I',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'Y',
            'F',
            'M',
            'A',
            'M',
            'I',
            'I',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'yanvar',
            'fevral',
            'mart',
            'aprel',
            'may',
            'iyun',
            'iyul',
            'avgust',
            'sentabr',
            'oktabr',
            'noyabr',
            'dekabr'
          ],
          STANDALONEMONTHS: const [
            'Yanvar',
            'Fevral',
            'Mart',
            'Aprel',
            'May',
            'Iyun',
            'Iyul',
            'Avgust',
            'Sentabr',
            'Oktabr',
            'Noyabr',
            'Dekabr'
          ],
          SHORTMONTHS: const [
            'yan',
            'fev',
            'mar',
            'apr',
            'may',
            'iyn',
            'iyl',
            'avg',
            'sen',
            'okt',
            'noy',
            'dek'
          ],
          STANDALONESHORTMONTHS: const [
            'Yan',
            'Fev',
            'Mar',
            'Apr',
            'May',
            'Iyn',
            'Iyl',
            'Avg',
            'Sen',
            'Okt',
            'Noy',
            'Dek'
          ],
          WEEKDAYS: const [
            'yakshanba',
            'dushanba',
            'seshanba',
            'chorshanba',
            'payshanba',
            'juma',
            'shanba'
          ],
          STANDALONEWEEKDAYS: const [
            'yakshanba',
            'dushanba',
            'seshanba',
            'chorshanba',
            'payshanba',
            'juma',
            'shanba'
          ],
          SHORTWEEKDAYS: const [
            'Yak',
            'Dush',
            'Sesh',
            'Chor',
            'Pay',
            'Jum',
            'Shan'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'Yak',
            'Dush',
            'Sesh',
            'Chor',
            'Pay',
            'Jum',
            'Shan'
          ],
          NARROWWEEKDAYS: const ['Y', 'D', 'S', 'C', 'P', 'J', 'S'],
          STANDALONENARROWWEEKDAYS: const ['Y', 'D', 'S', 'C', 'P', 'J', 'S'],
          SHORTQUARTERS: const ['1-ch', '2-ch', '3-ch', '4-ch'],
          QUARTERS: const ['1-chorak', '2-chorak', '3-chorak', '4-chorak'],
          AMPMS: const ['TO', 'TK'],
          DATEFORMATS: const [
            'EEEE, d-MMMM, y',
            'd-MMMM, y',
            'd-MMM, y',
            'dd/MM/yy'
          ],
          TIMEFORMATS: const [
            'H:mm:ss (zzzz)',
            'H:mm:ss (z)',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const [
            '{1}, {0}',
            '{1}, {0}',
            '{1}, {0}',
            '{1}, {0}'
          ],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 6),
      // Date/time formatting symbols for locale vi.
      "vi": new DateSymbols(
          NAME: "vi",
          ERAS: const ['Trước CN', 'sau CN'],
          ERANAMES: const ['Trước CN', 'sau CN'],
          NARROWMONTHS: const [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12'
          ],
          STANDALONENARROWMONTHS: const [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12'
          ],
          MONTHS: const [
            'tháng 1',
            'tháng 2',
            'tháng 3',
            'tháng 4',
            'tháng 5',
            'tháng 6',
            'tháng 7',
            'tháng 8',
            'tháng 9',
            'tháng 10',
            'tháng 11',
            'tháng 12'
          ],
          STANDALONEMONTHS: const [
            'Tháng 1',
            'Tháng 2',
            'Tháng 3',
            'Tháng 4',
            'Tháng 5',
            'Tháng 6',
            'Tháng 7',
            'Tháng 8',
            'Tháng 9',
            'Tháng 10',
            'Tháng 11',
            'Tháng 12'
          ],
          SHORTMONTHS: const [
            'thg 1',
            'thg 2',
            'thg 3',
            'thg 4',
            'thg 5',
            'thg 6',
            'thg 7',
            'thg 8',
            'thg 9',
            'thg 10',
            'thg 11',
            'thg 12'
          ],
          STANDALONESHORTMONTHS: const [
            'Thg 1',
            'Thg 2',
            'Thg 3',
            'Thg 4',
            'Thg 5',
            'Thg 6',
            'Thg 7',
            'Thg 8',
            'Thg 9',
            'Thg 10',
            'Thg 11',
            'Thg 12'
          ],
          WEEKDAYS: const [
            'Chủ Nhật',
            'Thứ Hai',
            'Thứ Ba',
            'Thứ Tư',
            'Thứ Năm',
            'Thứ Sáu',
            'Thứ Bảy'
          ],
          STANDALONEWEEKDAYS: const [
            'Chủ Nhật',
            'Thứ Hai',
            'Thứ Ba',
            'Thứ Tư',
            'Thứ Năm',
            'Thứ Sáu',
            'Thứ Bảy'
          ],
          SHORTWEEKDAYS: const [
            'CN',
            'Th 2',
            'Th 3',
            'Th 4',
            'Th 5',
            'Th 6',
            'Th 7'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'CN',
            'Th 2',
            'Th 3',
            'Th 4',
            'Th 5',
            'Th 6',
            'Th 7'
          ],
          NARROWWEEKDAYS: const ['CN', 'T2', 'T3', 'T4', 'T5', 'T6', 'T7'],
          STANDALONENARROWWEEKDAYS: const [
            'CN',
            'T2',
            'T3',
            'T4',
            'T5',
            'T6',
            'T7'
          ],
          SHORTQUARTERS: const ['Q1', 'Q2', 'Q3', 'Q4'],
          QUARTERS: const ['Quý 1', 'Quý 2', 'Quý 3', 'Quý 4'],
          AMPMS: const ['SA', 'CH'],
          DATEFORMATS: const [
            'EEEE, d MMMM, y',
            'd MMMM, y',
            'd MMM, y',
            'dd/MM/y'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const ['{0} {1}', '{0} {1}', '{0}, {1}', '{0}, {1}'],
          FIRSTDAYOFWEEK: 0,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 6),
      // Date/time formatting symbols for locale zh.
      "zh": new DateSymbols(
          NAME: "zh",
          ERAS: const ['公元前', '公元'],
          ERANAMES: const ['公元前', '公元'],
          NARROWMONTHS: const [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12'
          ],
          STANDALONENARROWMONTHS: const [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12'
          ],
          MONTHS: const [
            '一月',
            '二月',
            '三月',
            '四月',
            '五月',
            '六月',
            '七月',
            '八月',
            '九月',
            '十月',
            '十一月',
            '十二月'
          ],
          STANDALONEMONTHS: const [
            '一月',
            '二月',
            '三月',
            '四月',
            '五月',
            '六月',
            '七月',
            '八月',
            '九月',
            '十月',
            '十一月',
            '十二月'
          ],
          SHORTMONTHS: const [
            '1月',
            '2月',
            '3月',
            '4月',
            '5月',
            '6月',
            '7月',
            '8月',
            '9月',
            '10月',
            '11月',
            '12月'
          ],
          STANDALONESHORTMONTHS: const [
            '1月',
            '2月',
            '3月',
            '4月',
            '5月',
            '6月',
            '7月',
            '8月',
            '9月',
            '10月',
            '11月',
            '12月'
          ],
          WEEKDAYS: const ['星期日', '星期一', '星期二', '星期三', '星期四', '星期五', '星期六'],
          STANDALONEWEEKDAYS: const [
            '星期日',
            '星期一',
            '星期二',
            '星期三',
            '星期四',
            '星期五',
            '星期六'
          ],
          SHORTWEEKDAYS: const ['周日', '周一', '周二', '周三', '周四', '周五', '周六'],
          STANDALONESHORTWEEKDAYS: const [
            '周日',
            '周一',
            '周二',
            '周三',
            '周四',
            '周五',
            '周六'
          ],
          NARROWWEEKDAYS: const ['日', '一', '二', '三', '四', '五', '六'],
          STANDALONENARROWWEEKDAYS: const ['日', '一', '二', '三', '四', '五', '六'],
          SHORTQUARTERS: const ['1季度', '2季度', '3季度', '4季度'],
          QUARTERS: const ['第一季度', '第二季度', '第三季度', '第四季度'],
          AMPMS: const ['上午', '下午'],
          DATEFORMATS: const ['y年M月d日EEEE', 'y年M月d日', 'y年M月d日', 'y/M/d'],
          TIMEFORMATS: const [
            'zzzz ah:mm:ss',
            'z ah:mm:ss',
            'ah:mm:ss',
            'ah:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale zh_CN.
      // Date/time formatting symbols for locale zh_CN.
      "zh_CN": new DateSymbols(
          NAME: "zh_CN",
          ERAS: const ['公元前', '公元'],
          ERANAMES: const ['公元前', '公元'],
          NARROWMONTHS: const [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12'
          ],
          STANDALONENARROWMONTHS: const [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12'
          ],
          MONTHS: const [
            '一月',
            '二月',
            '三月',
            '四月',
            '五月',
            '六月',
            '七月',
            '八月',
            '九月',
            '十月',
            '十一月',
            '十二月'
          ],
          STANDALONEMONTHS: const [
            '一月',
            '二月',
            '三月',
            '四月',
            '五月',
            '六月',
            '七月',
            '八月',
            '九月',
            '十月',
            '十一月',
            '十二月'
          ],
          SHORTMONTHS: const [
            '1月',
            '2月',
            '3月',
            '4月',
            '5月',
            '6月',
            '7月',
            '8月',
            '9月',
            '10月',
            '11月',
            '12月'
          ],
          STANDALONESHORTMONTHS: const [
            '1月',
            '2月',
            '3月',
            '4月',
            '5月',
            '6月',
            '7月',
            '8月',
            '9月',
            '10月',
            '11月',
            '12月'
          ],
          WEEKDAYS: const ['星期日', '星期一', '星期二', '星期三', '星期四', '星期五', '星期六'],
          STANDALONEWEEKDAYS: const [
            '星期日',
            '星期一',
            '星期二',
            '星期三',
            '星期四',
            '星期五',
            '星期六'
          ],
          SHORTWEEKDAYS: const ['周日', '周一', '周二', '周三', '周四', '周五', '周六'],
          STANDALONESHORTWEEKDAYS: const [
            '周日',
            '周一',
            '周二',
            '周三',
            '周四',
            '周五',
            '周六'
          ],
          NARROWWEEKDAYS: const ['日', '一', '二', '三', '四', '五', '六'],
          STANDALONENARROWWEEKDAYS: const ['日', '一', '二', '三', '四', '五', '六'],
          SHORTQUARTERS: const ['1季度', '2季度', '3季度', '4季度'],
          QUARTERS: const ['第一季度', '第二季度', '第三季度', '第四季度'],
          AMPMS: const ['上午', '下午'],
          DATEFORMATS: const ['y年M月d日EEEE', 'y年M月d日', 'y年M月d日', 'y/M/d'],
          TIMEFORMATS: const [
            'zzzz ah:mm:ss',
            'z ah:mm:ss',
            'ah:mm:ss',
            'ah:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale zh_HK.
      "zh_HK": new DateSymbols(
          NAME: "zh_HK",
          ERAS: const ['公元前', '公元'],
          ERANAMES: const ['公元前', '公元'],
          NARROWMONTHS: const [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12'
          ],
          STANDALONENARROWMONTHS: const [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12'
          ],
          MONTHS: const [
            '1月',
            '2月',
            '3月',
            '4月',
            '5月',
            '6月',
            '7月',
            '8月',
            '9月',
            '10月',
            '11月',
            '12月'
          ],
          STANDALONEMONTHS: const [
            '1月',
            '2月',
            '3月',
            '4月',
            '5月',
            '6月',
            '7月',
            '8月',
            '9月',
            '10月',
            '11月',
            '12月'
          ],
          SHORTMONTHS: const [
            '1月',
            '2月',
            '3月',
            '4月',
            '5月',
            '6月',
            '7月',
            '8月',
            '9月',
            '10月',
            '11月',
            '12月'
          ],
          STANDALONESHORTMONTHS: const [
            '1月',
            '2月',
            '3月',
            '4月',
            '5月',
            '6月',
            '7月',
            '8月',
            '9月',
            '10月',
            '11月',
            '12月'
          ],
          WEEKDAYS: const ['星期日', '星期一', '星期二', '星期三', '星期四', '星期五', '星期六'],
          STANDALONEWEEKDAYS: const [
            '星期日',
            '星期一',
            '星期二',
            '星期三',
            '星期四',
            '星期五',
            '星期六'
          ],
          SHORTWEEKDAYS: const ['週日', '週一', '週二', '週三', '週四', '週五', '週六'],
          STANDALONESHORTWEEKDAYS: const [
            '週日',
            '週一',
            '週二',
            '週三',
            '週四',
            '週五',
            '週六'
          ],
          NARROWWEEKDAYS: const ['日', '一', '二', '三', '四', '五', '六'],
          STANDALONENARROWWEEKDAYS: const ['日', '一', '二', '三', '四', '五', '六'],
          SHORTQUARTERS: const ['Q1', 'Q2', 'Q3', 'Q4'],
          QUARTERS: const ['第1季', '第2季', '第3季', '第4季'],
          AMPMS: const ['上午', '下午'],
          DATEFORMATS: const ['y年M月d日EEEE', 'y年M月d日', 'y年M月d日', 'd/M/y'],
          TIMEFORMATS: const [
            'ah:mm:ss [zzzz]',
            'ah:mm:ss [z]',
            'ah:mm:ss',
            'ah:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale zh_TW.
      "zh_TW": new DateSymbols(
          NAME: "zh_TW",
          ERAS: const ['西元前', '西元'],
          ERANAMES: const ['西元前', '西元'],
          NARROWMONTHS: const [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12'
          ],
          STANDALONENARROWMONTHS: const [
            '1',
            '2',
            '3',
            '4',
            '5',
            '6',
            '7',
            '8',
            '9',
            '10',
            '11',
            '12'
          ],
          MONTHS: const [
            '1月',
            '2月',
            '3月',
            '4月',
            '5月',
            '6月',
            '7月',
            '8月',
            '9月',
            '10月',
            '11月',
            '12月'
          ],
          STANDALONEMONTHS: const [
            '1月',
            '2月',
            '3月',
            '4月',
            '5月',
            '6月',
            '7月',
            '8月',
            '9月',
            '10月',
            '11月',
            '12月'
          ],
          SHORTMONTHS: const [
            '1月',
            '2月',
            '3月',
            '4月',
            '5月',
            '6月',
            '7月',
            '8月',
            '9月',
            '10月',
            '11月',
            '12月'
          ],
          STANDALONESHORTMONTHS: const [
            '1月',
            '2月',
            '3月',
            '4月',
            '5月',
            '6月',
            '7月',
            '8月',
            '9月',
            '10月',
            '11月',
            '12月'
          ],
          WEEKDAYS: const ['星期日', '星期一', '星期二', '星期三', '星期四', '星期五', '星期六'],
          STANDALONEWEEKDAYS: const [
            '星期日',
            '星期一',
            '星期二',
            '星期三',
            '星期四',
            '星期五',
            '星期六'
          ],
          SHORTWEEKDAYS: const ['週日', '週一', '週二', '週三', '週四', '週五', '週六'],
          STANDALONESHORTWEEKDAYS: const [
            '週日',
            '週一',
            '週二',
            '週三',
            '週四',
            '週五',
            '週六'
          ],
          NARROWWEEKDAYS: const ['日', '一', '二', '三', '四', '五', '六'],
          STANDALONENARROWWEEKDAYS: const ['日', '一', '二', '三', '四', '五', '六'],
          SHORTQUARTERS: const ['第1季', '第2季', '第3季', '第4季'],
          QUARTERS: const ['第1季', '第2季', '第3季', '第4季'],
          AMPMS: const ['上午', '下午'],
          DATEFORMATS: const ['y年M月d日 EEEE', 'y年M月d日', 'y年M月d日', 'y/M/d'],
          TIMEFORMATS: const [
            'ah:mm:ss [zzzz]',
            'ah:mm:ss [z]',
            'ah:mm:ss',
            'ah:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
      // Date/time formatting symbols for locale zu.
      "zu": new DateSymbols(
          NAME: "zu",
          ERAS: const ['BC', 'AD'],
          ERANAMES: const ['BC', 'AD'],
          NARROWMONTHS: const [
            'J',
            'F',
            'M',
            'E',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          STANDALONENARROWMONTHS: const [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D'
          ],
          MONTHS: const [
            'Januwari',
            'Februwari',
            'Mashi',
            'Ephreli',
            'Meyi',
            'Juni',
            'Julayi',
            'Agasti',
            'Septhemba',
            'Okthoba',
            'Novemba',
            'Disemba'
          ],
          STANDALONEMONTHS: const [
            'Januwari',
            'Februwari',
            'Mashi',
            'Ephreli',
            'Meyi',
            'Juni',
            'Julayi',
            'Agasti',
            'Septhemba',
            'Okthoba',
            'Novemba',
            'Disemba'
          ],
          SHORTMONTHS: const [
            'Jan',
            'Feb',
            'Mas',
            'Eph',
            'Mey',
            'Jun',
            'Jul',
            'Aga',
            'Sep',
            'Okt',
            'Nov',
            'Dis'
          ],
          STANDALONESHORTMONTHS: const [
            'Jan',
            'Feb',
            'Mas',
            'Eph',
            'Mey',
            'Jun',
            'Jul',
            'Aga',
            'Sep',
            'Okt',
            'Nov',
            'Dis'
          ],
          WEEKDAYS: const [
            'ISonto',
            'UMsombuluko',
            'ULwesibili',
            'ULwesithathu',
            'ULwesine',
            'ULwesihlanu',
            'UMgqibelo'
          ],
          STANDALONEWEEKDAYS: const [
            'ISonto',
            'UMsombuluko',
            'ULwesibili',
            'ULwesithathu',
            'ULwesine',
            'ULwesihlanu',
            'UMgqibelo'
          ],
          SHORTWEEKDAYS: const [
            'Son',
            'Mso',
            'Bil',
            'Tha',
            'Sin',
            'Hla',
            'Mgq'
          ],
          STANDALONESHORTWEEKDAYS: const [
            'Son',
            'Mso',
            'Bil',
            'Tha',
            'Sin',
            'Hla',
            'Mgq'
          ],
          NARROWWEEKDAYS: const ['S', 'M', 'B', 'T', 'S', 'H', 'M'],
          STANDALONENARROWWEEKDAYS: const ['S', 'M', 'B', 'T', 'S', 'H', 'M'],
          SHORTQUARTERS: const ['Q1', 'Q2', 'Q3', 'Q4'],
          QUARTERS: const [
            'ikota yesi-1',
            'ikota yesi-2',
            'ikota yesi-3',
            'ikota yesi-4'
          ],
          AMPMS: const ['AM', 'PM'],
          DATEFORMATS: const [
            'EEEE, MMMM d, y',
            'MMMM d, y',
            'MMM d, y',
            'M/d/yy'
          ],
          TIMEFORMATS: const [
            'HH:mm:ss zzzz',
            'HH:mm:ss z',
            'HH:mm:ss',
            'HH:mm'
          ],
          DATETIMEFORMATS: const ['{1} {0}', '{1} {0}', '{1} {0}', '{1} {0}'],
          FIRSTDAYOFWEEK: 6,
          WEEKENDRANGE: const [5, 6],
          FIRSTWEEKCUTOFFDAY: 5),
    };
