// Copyright (c) 2016, the Dart project authors.
// Please see the AUTHORS file
// for details. All rights reserved. Use of this source
// code is governed by a
// BSD-style license that can be found in the LICENSE file.

/// Test data for compact number formatting.
///
/// DO NOT EDIT. This file is autogenerated by script.  See
/// i18n/tools:dart_compact_number_test_data

/// The test data. A map, keyed by locale name, whose values
/// are a list of [basic, shortform, longform] formatted data
/// for different numbers.
Map<String, List<List<String>>> compactNumberTestData = {
  "af": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 k", "4,32 duisend"],
    ["54321", "54,3 k", "54,3 duisend"],
    ["654321", "654 k", "654 duisend"],
    ["7654321", "7,65 m", "7,65 miljoen"],
    ["87654321", "87,7 m", "87,7 miljoen"],
    ["987654321", "988 m", "988 miljoen"],
    ["1087654321", "1,09 mjd", "1,09 miljard"],
    ["11987654321", "12 mjd", "12 miljard"],
    ["129987654321", "130 mjd", "130 miljard"],
    ["1398987654321", "1,4 bn", "1,4 biljoen"],
    ["14987987654321", "15 bn", "15 biljoen"],
    ["159876987654321", "160 bn", "160 biljoen"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 k", "10 duisend"],
    ["99999", "100 k", "100 duisend"],
    ["99999", "100 k", "100 duisend"],
    ["999999", "1 m", "1 miljoen"],
    ["9999999", "10 m", "10 miljoen"],
    ["99999999", "100 m", "100 miljoen"],
    ["9994", "9,99 k", "9,99 duisend"],
    ["99944", "99,9 k", "99,9 duisend"],
    ["999444", "999 k", "999 duisend"],
    ["9994444", "9,99 m", "9,99 miljoen"],
    ["999444444", "999 m", "999 miljoen"],
    ["9994444444", "9,99 mjd", "9,99 miljard"],
  ],
  "am": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32 ሺ", "4.32 ሺ"],
    ["54321", "54.3 ሺ", "54.3 ሺ"],
    ["654321", "654 ሺ", "654 ሺ"],
    ["7654321", "7.65 ሜትር", "7.65 ሚሊዮን"],
    ["87654321", "87.7 ሜትር", "87.7 ሚሊዮን"],
    ["987654321", "988ሜ", "988 ሚሊዮን"],
    ["1087654321", "1.09 ቢ", "1.09 ቢሊዮን"],
    ["11987654321", "12 ቢ", "12 ቢሊዮን"],
    ["129987654321", "130 ቢ", "130 ቢሊዮን"],
    ["1398987654321", "1.4 ት", "1.4 ትሪሊዮን"],
    ["14987987654321", "15 ት", "15 ትሪሊዮን"],
    ["159876987654321", "160 ት", "160 ትሪሊዮን"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 ሺ", "10 ሺ"],
    ["99999", "100 ሺ", "100 ሺ"],
    ["99999", "100 ሺ", "100 ሺ"],
    ["999999", "1 ሜትር", "1 ሚሊዮን"],
    ["9999999", "10 ሜትር", "10 ሚሊዮን"],
    ["99999999", "100ሜ", "100 ሚሊዮን"],
    ["9994", "9.99 ሺ", "9.99 ሺ"],
    ["99944", "99.9 ሺ", "99.9 ሺ"],
    ["999444", "999 ሺ", "999 ሺ"],
    ["9994444", "9.99 ሜትር", "9.99 ሚሊዮን"],
    ["999444444", "999ሜ", "999 ሚሊዮን"],
    ["9994444444", "9.99 ቢ", "9.99 ቢሊዮን"],
  ],
  "ar": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32 ألف", "4.32 ألف"],
    ["54321", "54.3 ألف", "54.3 ألف"],
    ["654321", "654 ألف", "654 ألف"],
    ["7654321", "7.65 مليون", "7.65 مليون"],
    ["87654321", "87.7 مليون", "87.7 مليون"],
    ["987654321", "988 مليون", "988 مليون"],
    ["1087654321", "1.09 مليار", "1.09 مليار"],
    ["11987654321", "12 مليار", "12 مليار"],
    ["129987654321", "130 مليار", "130 مليار"],
    ["1398987654321", "1.4 ترليون", "1.4 ترليون"],
    ["14987987654321", "15 ترليون", "15 ترليون"],
    ["159876987654321", "160 ترليون", "160 ترليون"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 ألف", "10 ألف"],
    ["99999", "100 ألف", "100 ألف"],
    ["99999", "100 ألف", "100 ألف"],
    ["999999", "1 مليون", "1 مليون"],
    ["9999999", "10 مليون", "10 ملايين"],
    ["99999999", "100 مليون", "100 مليون"],
    ["9994", "9.99 ألف", "9.99 ألف"],
    ["99944", "99.9 ألف", "99.9 ألف"],
    ["999444", "999 ألف", "999 ألف"],
    ["9994444", "9.99 مليون", "9.99 مليون"],
    ["999444444", "999 مليون", "999 مليون"],
    ["9994444444", "9.99 مليار", "9.99 مليار"],
  ],
  "ar_DZ": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 ألف", "4,32 ألف"],
    ["54321", "54,3 ألف", "54,3 ألف"],
    ["654321", "654 ألف", "654 ألف"],
    ["7654321", "7,65 مليون", "7,65 مليون"],
    ["87654321", "87,7 مليون", "87,7 مليون"],
    ["987654321", "988 مليون", "988 مليون"],
    ["1087654321", "1,09 مليار", "1,09 مليار"],
    ["11987654321", "12 مليار", "12 مليار"],
    ["129987654321", "130 مليار", "130 مليار"],
    ["1398987654321", "1,4 ترليون", "1,4 ترليون"],
    ["14987987654321", "15 ترليون", "15 ترليون"],
    ["159876987654321", "160 ترليون", "160 ترليون"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 ألف", "10 ألف"],
    ["99999", "100 ألف", "100 ألف"],
    ["99999", "100 ألف", "100 ألف"],
    ["999999", "1 مليون", "1 مليون"],
    ["9999999", "10 مليون", "10 ملايين"],
    ["99999999", "100 مليون", "100 مليون"],
    ["9994", "9,99 ألف", "9,99 ألف"],
    ["99944", "99,9 ألف", "99,9 ألف"],
    ["999444", "999 ألف", "999 ألف"],
    ["9994444", "9,99 مليون", "9,99 مليون"],
    ["999444444", "999 مليون", "999 مليون"],
    ["9994444444", "9,99 مليار", "9,99 مليار"],
  ],
  "ar_EG": [
    ["1", "١", "١"],
    ["21", "٢١", "٢١"],
    ["321", "٣٢١", "٣٢١"],
    ["4321", "٤٫٣٢ ألف", "٤٫٣٢ ألف"],
    ["54321", "٥٤٫٣ ألف", "٥٤٫٣ ألف"],
    ["654321", "٦٥٤ ألف", "٦٥٤ ألف"],
    ["7654321", "٧٫٦٥ مليون", "٧٫٦٥ مليون"],
    ["87654321", "٨٧٫٧ مليون", "٨٧٫٧ مليون"],
    ["987654321", "٩٨٨ مليون", "٩٨٨ مليون"],
    ["1087654321", "١٫٠٩ مليار", "١٫٠٩ مليار"],
    ["11987654321", "١٢ مليار", "١٢ مليار"],
    ["129987654321", "١٣٠ مليار", "١٣٠ مليار"],
    ["1398987654321", "١٫٤ ترليون", "١٫٤ ترليون"],
    ["14987987654321", "١٥ ترليون", "١٥ ترليون"],
    ["159876987654321", "١٦٠ ترليون", "١٦٠ ترليون"],
    ["9", "٩", "٩"],
    ["99", "٩٩", "٩٩"],
    ["999", "٩٩٩", "٩٩٩"],
    ["9999", "١٠ ألف", "١٠ ألف"],
    ["99999", "١٠٠ ألف", "١٠٠ ألف"],
    ["99999", "١٠٠ ألف", "١٠٠ ألف"],
    ["999999", "١ مليون", "١ مليون"],
    ["9999999", "١٠ مليون", "١٠ ملايين"],
    ["99999999", "١٠٠ مليون", "١٠٠ مليون"],
    ["9994", "٩٫٩٩ ألف", "٩٫٩٩ ألف"],
    ["99944", "٩٩٫٩ ألف", "٩٩٫٩ ألف"],
    ["999444", "٩٩٩ ألف", "٩٩٩ ألف"],
    ["9994444", "٩٫٩٩ مليون", "٩٫٩٩ مليون"],
    ["999444444", "٩٩٩ مليون", "٩٩٩ مليون"],
    ["9994444444", "٩٫٩٩ مليار", "٩٫٩٩ مليار"],
  ],
  "az": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32K", "4,32 min"],
    ["54321", "54,3K", "54,3 min"],
    ["654321", "654K", "654 min"],
    ["7654321", "7,65M", "7,65 milyon"],
    ["87654321", "87,7M", "87,7 milyon"],
    ["987654321", "988M", "988 milyon"],
    ["1087654321", "1,09G", "1,09 milyard"],
    ["11987654321", "12G", "12 milyard"],
    ["129987654321", "130G", "130 milyard"],
    ["1398987654321", "1,4T", "1,4 trilyon"],
    ["14987987654321", "15T", "15 trilyon"],
    ["159876987654321", "160T", "160 trilyon"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 min"],
    ["99999", "100K", "100 min"],
    ["99999", "100K", "100 min"],
    ["999999", "1M", "1 milyon"],
    ["9999999", "10M", "10 milyon"],
    ["99999999", "100M", "100 milyon"],
    ["9994", "9,99K", "9,99 min"],
    ["99944", "99,9K", "99,9 min"],
    ["999444", "999K", "999 min"],
    ["9994444", "9,99M", "9,99 milyon"],
    ["999444444", "999M", "999 milyon"],
    ["9994444444", "9,99G", "9,99 milyard"],
  ],
  "be": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 тыс.", "4,32 тысячы"],
    ["54321", "54,3 тыс.", "54,3 тысячы"],
    ["654321", "654 тыс.", "654 тысячы"],
    ["7654321", "7,65 млн", "7,65 мільёна"],
    ["87654321", "87,7 млн", "87,7 мільёна"],
    ["987654321", "988 млн", "988 мільёнаў"],
    ["1087654321", "1,09 млрд", "1,09 мільярда"],
    ["11987654321", "12 млрд", "12 мільярдаў"],
    ["129987654321", "130 млрд", "130 мільярдаў"],
    ["1398987654321", "1,4 трлн", "1,4 трыльёна"],
    ["14987987654321", "15 трлн", "15 трыльёнаў"],
    ["159876987654321", "160 трлн", "160 трыльёнаў"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 тыс.", "10 тысяч"],
    ["99999", "100 тыс.", "100 тысяч"],
    ["99999", "100 тыс.", "100 тысяч"],
    ["999999", "1 млн", "1 мільён"],
    ["9999999", "10 млн", "10 мільёнаў"],
    ["99999999", "100 млн", "100 мільёнаў"],
    ["9994", "9,99 тыс.", "9,99 тысячы"],
    ["99944", "99,9 тыс.", "99,9 тысячы"],
    ["999444", "999 тыс.", "999 тысяч"],
    ["9994444", "9,99 млн", "9,99 мільёна"],
    ["999444444", "999 млн", "999 мільёнаў"],
    ["9994444444", "9,99 млрд", "9,99 мільярда"],
  ],
  "bg": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 хил.", "4,32 хиляди"],
    ["54321", "54,3 хил.", "54,3 хиляди"],
    ["654321", "654 хил.", "654 хиляди"],
    ["7654321", "7,65 млн.", "7,65 милиона"],
    ["87654321", "87,7 млн.", "87,7 милиона"],
    ["987654321", "988 млн.", "988 милиона"],
    ["1087654321", "1,09 млрд.", "1,09 милиарда"],
    ["11987654321", "12 млрд.", "12 милиарда"],
    ["129987654321", "130 млрд.", "130 милиарда"],
    ["1398987654321", "1,4 трлн.", "1,4 трилиона"],
    ["14987987654321", "15 трлн.", "15 трилиона"],
    ["159876987654321", "160 трлн.", "160 трилиона"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 хил.", "10 хиляди"],
    ["99999", "100 хил.", "100 хиляди"],
    ["99999", "100 хил.", "100 хиляди"],
    ["999999", "1 млн.", "1 милион"],
    ["9999999", "10 млн.", "10 милиона"],
    ["99999999", "100 млн.", "100 милиона"],
    ["9994", "9,99 хил.", "9,99 хиляди"],
    ["99944", "99,9 хил.", "99,9 хиляди"],
    ["999444", "999 хил.", "999 хиляди"],
    ["9994444", "9,99 млн.", "9,99 милиона"],
    ["999444444", "999 млн.", "999 милиона"],
    ["9994444444", "9,99 млрд.", "9,99 милиарда"],
  ],
  "bn": [
    ["1", "১", "১"],
    ["21", "২১", "২১"],
    ["321", "৩২১", "৩২১"],
    ["4321", "৪.৩২ হাজার", "৪.৩২ হাজার"],
    ["54321", "৫৪.৩ হাজার", "৫৪.৩ হাজার"],
    ["654321", "৬.৫৪ লাখ", "৬.৫৪ লাখ"],
    ["7654321", "৭.৬৫M", "৭.৬৫ মিলিয়ন"],
    ["87654321", "৮৭.৭M", "৮৭.৭ মিলিয়ন"],
    ["987654321", "৯৮৮M", "৯৮৮ মিলিয়ন"],
    ["1087654321", "১.০৯B", "১.০৯ বিলিয়ন"],
    ["11987654321", "১২B", "১২ বিলিয়ন"],
    ["129987654321", "১৩০B", "১৩০ বিলিয়ন"],
    ["1398987654321", "১.৪T", "১.৪ ট্রিলিয়ন"],
    ["14987987654321", "১৫T", "১৫ ট্রিলিয়ন"],
    ["159876987654321", "১৬০T", "১৬০ ট্রিলিয়ন"],
    ["9", "৯", "৯"],
    ["99", "৯৯", "৯৯"],
    ["999", "৯৯৯", "৯৯৯"],
    ["9999", "১০ হাজার", "১০ হাজার"],
    ["99999", "১ লাখ", "১ লাখ"],
    ["99999", "১ লাখ", "১ লাখ"],
    ["999999", "১M", "১ মিলিয়ন"],
    ["9999999", "১০M", "১০ মিলিয়ন"],
    ["99999999", "১০০M", "১০০ মিলিয়ন"],
    ["9994", "৯.৯৯ হাজার", "৯.৯৯ হাজার"],
    ["99944", "৯৯.৯ হাজার", "৯৯.৯ হাজার"],
    ["999444", "৯.৯৯ লাখ", "৯.৯৯ লাখ"],
    ["9994444", "৯.৯৯M", "৯.৯৯ মিলিয়ন"],
    ["999444444", "৯৯৯M", "৯৯৯ মিলিয়ন"],
    ["9994444444", "৯.৯৯B", "৯.৯৯ বিলিয়ন"],
  ],
  "br": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32k", "4,32 miliad"],
    ["54321", "54,3k", "54,3 miliad"],
    ["654321", "654k", "654 miliad"],
    ["7654321", "7,65M", "7,65 milion"],
    ["87654321", "87,7M", "87,7 milion"],
    ["987654321", "988M", "988 milion"],
    ["1087654321", "1,09G", "1,09 miliard"],
    ["11987654321", "12G", "12 miliard"],
    ["129987654321", "130G", "130 miliard"],
    ["1398987654321", "1,4T", "1,4 bilion"],
    ["14987987654321", "15T", "15 bilion"],
    ["159876987654321", "160T", "160 bilion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10k", "10 miliad"],
    ["99999", "100k", "100 miliad"],
    ["99999", "100k", "100 miliad"],
    ["999999", "1M", "1 milion"],
    ["9999999", "10M", "10 milion"],
    ["99999999", "100M", "100 milion"],
    ["9994", "9,99k", "9,99 miliad"],
    ["99944", "99,9k", "99,9 miliad"],
    ["999444", "999k", "999 miliad"],
    ["9994444", "9,99M", "9,99 milion"],
    ["999444444", "999M", "999 milion"],
    ["9994444444", "9,99G", "9,99 miliard"],
  ],
  "bs": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 hilj.", "4,32 hiljade"],
    ["54321", "54,3 hilj.", "54,3 hiljade"],
    ["654321", "654 hilj.", "654 hiljade"],
    ["7654321", "7,65 mil.", "7,65 miliona"],
    ["87654321", "87,7 mil.", "87,7 miliona"],
    ["987654321", "988 mil.", "988 miliona"],
    ["1087654321", "1,09 mlr.", "1,09 milijardi"],
    ["11987654321", "12 mlr.", "12 milijardi"],
    ["129987654321", "130 mlr.", "130 milijardi"],
    ["1398987654321", "1,4 bil.", "1,4 biliona"],
    ["14987987654321", "15 bil.", "15 biliona"],
    ["159876987654321", "160 bil.", "160 biliona"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 hilj.", "10 hiljada"],
    ["99999", "100 hilj.", "100 hiljada"],
    ["99999", "100 hilj.", "100 hiljada"],
    ["999999", "1 mil.", "1 milion"],
    ["9999999", "10 mil.", "10 miliona"],
    ["99999999", "100 mil.", "100 miliona"],
    ["9994", "9,99 hilj.", "9,99 hiljada"],
    ["99944", "99,9 hilj.", "99,9 hiljada"],
    ["999444", "999 hilj.", "999 hiljada"],
    ["9994444", "9,99 mil.", "9,99 miliona"],
    ["999444444", "999 mil.", "999 miliona"],
    ["9994444444", "9,99 mlr.", "9,99 milijardi"],
  ],
  "ca": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32m", "4,32 milers"],
    ["54321", "54,3m", "54,3 milers"],
    ["654321", "654m", "654 milers"],
    ["7654321", "7,65M", "7,65 milions"],
    ["87654321", "87,7 M", "87,7 milions"],
    ["987654321", "988 M", "988 milions"],
    ["1087654321", "1090 M", "1,09 milers de milions"],
    ["11987654321", "12mM", "12 milers de milions"],
    ["129987654321", "130mM", "130 milers de milions"],
    ["1398987654321", "1,4B", "1,4 bilions"],
    ["14987987654321", "15 B", "15 bilions"],
    ["159876987654321", "160 B", "160 bilions"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10m", "10 milers"],
    ["99999", "100m", "100 milers"],
    ["99999", "100m", "100 milers"],
    ["999999", "1M", "1 milió"],
    ["9999999", "10 M", "10 milions"],
    ["99999999", "100 M", "100 milions"],
    ["9994", "9,99m", "9,99 milers"],
    ["99944", "99,9m", "99,9 milers"],
    ["999444", "999m", "999 milers"],
    ["9994444", "9,99M", "9,99 milions"],
    ["999444444", "999 M", "999 milions"],
    ["9994444444", "9990 M", "9,99 milers de milions"],
  ],
  "chr": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32K", "4.32 ᎢᏯᎦᏴᎵ"],
    ["54321", "54.3K", "54.3 ᎢᏯᎦᏴᎵ"],
    ["654321", "654K", "654 ᎢᏯᎦᏴᎵ"],
    ["7654321", "7.65M", "7.65 ᎢᏳᏆᏗᏅᏛ"],
    ["87654321", "87.7M", "87.7 ᎢᏳᏆᏗᏅᏛ"],
    ["987654321", "988M", "988 ᎢᏳᏆᏗᏅᏛ"],
    ["1087654321", "1.09B", "1.09 ᎢᏯᏔᎳᏗᏅᏛ"],
    ["11987654321", "12B", "12 ᎢᏯᏔᎳᏗᏅᏛ"],
    ["129987654321", "130B", "130 ᎢᏯᏔᎳᏗᏅᏛ"],
    ["1398987654321", "1.4T", "1.4 ᎢᏯᏦᎠᏗᏅᏛ"],
    ["14987987654321", "15T", "15 ᎢᏯᏦᎠᏗᏅᏛ"],
    ["159876987654321", "160T", "160 ᎢᏯᏦᎠᏗᏅᏛ"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 ᎢᏯᎦᏴᎵ"],
    ["99999", "100K", "100 ᎢᏯᎦᏴᎵ"],
    ["99999", "100K", "100 ᎢᏯᎦᏴᎵ"],
    ["999999", "1M", "1 ᎢᏳᏆᏗᏅᏛ"],
    ["9999999", "10M", "10 ᎢᏳᏆᏗᏅᏛ"],
    ["99999999", "100M", "100 ᎢᏳᏆᏗᏅᏛ"],
    ["9994", "9.99K", "9.99 ᎢᏯᎦᏴᎵ"],
    ["99944", "99.9K", "99.9 ᎢᏯᎦᏴᎵ"],
    ["999444", "999K", "999 ᎢᏯᎦᏴᎵ"],
    ["9994444", "9.99M", "9.99 ᎢᏳᏆᏗᏅᏛ"],
    ["999444444", "999M", "999 ᎢᏳᏆᏗᏅᏛ"],
    ["9994444444", "9.99B", "9.99 ᎢᏯᏔᎳᏗᏅᏛ"],
  ],
  "cs": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 tis.", "4,32 tisíce"],
    ["54321", "54,3 tis.", "54,3 tisíce"],
    ["654321", "654 tis.", "654 tisíc"],
    ["7654321", "7,65 mil.", "7,65 milionu"],
    ["87654321", "87,7 mil.", "87,7 milionu"],
    ["987654321", "988 mil.", "988 milionů"],
    ["1087654321", "1,09 mld.", "1,09 miliardy"],
    ["11987654321", "12 mld.", "12 miliard"],
    ["129987654321", "130 mld.", "130 miliard"],
    ["1398987654321", "1,4 bil.", "1,4 bilionu"],
    ["14987987654321", "15 bil.", "15 bilionů"],
    ["159876987654321", "160 bil.", "160 bilionů"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 tis.", "10 tisíc"],
    ["99999", "100 tis.", "100 tisíc"],
    ["99999", "100 tis.", "100 tisíc"],
    ["999999", "1 mil.", "1 milion"],
    ["9999999", "10 mil.", "10 milionů"],
    ["99999999", "100 mil.", "100 milionů"],
    ["9994", "9,99 tis.", "9,99 tisíce"],
    ["99944", "99,9 tis.", "99,9 tisíce"],
    ["999444", "999 tis.", "999 tisíc"],
    ["9994444", "9,99 mil.", "9,99 milionu"],
    ["999444444", "999 mil.", "999 milionů"],
    ["9994444444", "9,99 mld.", "9,99 miliardy"],
  ],
  "cy": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32K", "4.32 mil"],
    ["54321", "54.3K", "54.3 mil"],
    ["654321", "654K", "654 mil"],
    ["7654321", "7.65M", "7.65 miliwn"],
    ["87654321", "87.7M", "87.7 miliwn"],
    ["987654321", "988M", "988 miliwn"],
    ["1087654321", "1.09B", "1.09 biliwn"],
    ["11987654321", "12B", "12 biliwn"],
    ["129987654321", "130B", "130 biliwn"],
    ["1398987654321", "1.4T", "1.4 triliwn"],
    ["14987987654321", "15T", "15 triliwn"],
    ["159876987654321", "160T", "160 triliwn"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 mil"],
    ["99999", "100K", "100 mil"],
    ["99999", "100K", "100 mil"],
    ["999999", "1M", "1 miliwn"],
    ["9999999", "10M", "10 miliwn"],
    ["99999999", "100M", "100 miliwn"],
    ["9994", "9.99K", "9.99 mil"],
    ["99944", "99.9K", "99.9 mil"],
    ["999444", "999K", "999 mil"],
    ["9994444", "9.99M", "9.99 miliwn"],
    ["999444444", "999M", "999 miliwn"],
    ["9994444444", "9.99B", "9.99 biliwn"],
  ],
  "da": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 t", "4,32 tusind"],
    ["54321", "54,3 t", "54,3 tusind"],
    ["654321", "654 t", "654 tusind"],
    ["7654321", "7,65 mio", "7,65 millioner"],
    ["87654321", "87,7 mio", "87,7 millioner"],
    ["987654321", "988 mio", "988 millioner"],
    ["1087654321", "1,09 mia", "1,09 milliard"],
    ["11987654321", "12 mia", "12 milliarder"],
    ["129987654321", "130 mia", "130 milliarder"],
    ["1398987654321", "1,4 bio", "1,4 billion"],
    ["14987987654321", "15 bio", "15 billioner"],
    ["159876987654321", "160 bio", "160 billioner"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 t", "10 tusind"],
    ["99999", "100 t", "100 tusind"],
    ["99999", "100 t", "100 tusind"],
    ["999999", "1 mio", "1 million"],
    ["9999999", "10 mio", "10 millioner"],
    ["99999999", "100 mio", "100 millioner"],
    ["9994", "9,99 t", "9,99 tusind"],
    ["99944", "99,9 t", "99,9 tusind"],
    ["999444", "999 t", "999 tusind"],
    ["9994444", "9,99 mio", "9,99 millioner"],
    ["999444444", "999 mio", "999 millioner"],
    ["9994444444", "9,99 mia", "9,99 milliarder"],
  ],
  "de": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4320", "4,32 Tausend"],
    ["54321", "54300", "54,3 Tausend"],
    ["654321", "654000", "654 Tausend"],
    ["7654321", "7,65 Mio.", "7,65 Millionen"],
    ["87654321", "87,7 Mio.", "87,7 Millionen"],
    ["987654321", "988 Mio.", "988 Millionen"],
    ["1087654321", "1,09 Mrd.", "1,09 Milliarden"],
    ["11987654321", "12 Mrd.", "12 Milliarden"],
    ["129987654321", "130 Mrd.", "130 Milliarden"],
    ["1398987654321", "1,4 Bio.", "1,4 Billionen"],
    ["14987987654321", "15 Bio.", "15 Billionen"],
    ["159876987654321", "160 Bio.", "160 Billionen"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10000", "10 Tausend"],
    ["99999", "100000", "100 Tausend"],
    ["99999", "100000", "100 Tausend"],
    ["999999", "1 Mio.", "1 Million"],
    ["9999999", "10 Mio.", "10 Millionen"],
    ["99999999", "100 Mio.", "100 Millionen"],
    ["9994", "9990", "9,99 Tausend"],
    ["99944", "99900", "99,9 Tausend"],
    ["999444", "999000", "999 Tausend"],
    ["9994444", "9,99 Mio.", "9,99 Millionen"],
    ["999444444", "999 Mio.", "999 Millionen"],
    ["9994444444", "9,99 Mrd.", "9,99 Milliarden"],
  ],
  "de_AT": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4320", "4,32 Tausend"],
    ["54321", "54300", "54,3 Tausend"],
    ["654321", "654000", "654 Tausend"],
    ["7654321", "7,65 Mio.", "7,65 Millionen"],
    ["87654321", "87,7 Mio.", "87,7 Millionen"],
    ["987654321", "988 Mio.", "988 Millionen"],
    ["1087654321", "1,09 Mrd.", "1,09 Milliarden"],
    ["11987654321", "12 Mrd.", "12 Milliarden"],
    ["129987654321", "130 Mrd.", "130 Milliarden"],
    ["1398987654321", "1,4 Bio.", "1,4 Billionen"],
    ["14987987654321", "15 Bio.", "15 Billionen"],
    ["159876987654321", "160 Bio.", "160 Billionen"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10000", "10 Tausend"],
    ["99999", "100000", "100 Tausend"],
    ["99999", "100000", "100 Tausend"],
    ["999999", "1 Mio.", "1 Million"],
    ["9999999", "10 Mio.", "10 Millionen"],
    ["99999999", "100 Mio.", "100 Millionen"],
    ["9994", "9990", "9,99 Tausend"],
    ["99944", "99900", "99,9 Tausend"],
    ["999444", "999000", "999 Tausend"],
    ["9994444", "9,99 Mio.", "9,99 Millionen"],
    ["999444444", "999 Mio.", "999 Millionen"],
    ["9994444444", "9,99 Mrd.", "9,99 Milliarden"],
  ],
  "de_CH": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4320", "4.32 Tausend"],
    ["54321", "54300", "54.3 Tausend"],
    ["654321", "654000", "654 Tausend"],
    ["7654321", "7.65 Mio.", "7.65 Millionen"],
    ["87654321", "87.7 Mio.", "87.7 Millionen"],
    ["987654321", "988 Mio.", "988 Millionen"],
    ["1087654321", "1.09 Mrd.", "1.09 Milliarden"],
    ["11987654321", "12 Mrd.", "12 Milliarden"],
    ["129987654321", "130 Mrd.", "130 Milliarden"],
    ["1398987654321", "1.4 Bio.", "1.4 Billionen"],
    ["14987987654321", "15 Bio.", "15 Billionen"],
    ["159876987654321", "160 Bio.", "160 Billionen"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10000", "10 Tausend"],
    ["99999", "100000", "100 Tausend"],
    ["99999", "100000", "100 Tausend"],
    ["999999", "1 Mio.", "1 Million"],
    ["9999999", "10 Mio.", "10 Millionen"],
    ["99999999", "100 Mio.", "100 Millionen"],
    ["9994", "9990", "9.99 Tausend"],
    ["99944", "99900", "99.9 Tausend"],
    ["999444", "999000", "999 Tausend"],
    ["9994444", "9.99 Mio.", "9.99 Millionen"],
    ["999444444", "999 Mio.", "999 Millionen"],
    ["9994444444", "9.99 Mrd.", "9.99 Milliarden"],
  ],
  "el": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 χιλ.", "4,32 χιλιάδες"],
    ["54321", "54,3 χιλ.", "54,3 χιλιάδες"],
    ["654321", "654 χιλ.", "654 χιλιάδες"],
    ["7654321", "7,65 εκ.", "7,65 εκατομμύρια"],
    ["87654321", "87,7 εκ.", "87,7 εκατομμύρια"],
    ["987654321", "988 εκ.", "988 εκατομμύρια"],
    ["1087654321", "1,09 δισ.", "1,09 δισεκατομμύρια"],
    ["11987654321", "12 δισ.", "12 δισεκατομμύρια"],
    ["129987654321", "130 δισ.", "130 δισεκατομμύρια"],
    ["1398987654321", "1,4 τρισ.", "1,4 τρισεκατομμύρια"],
    ["14987987654321", "15 τρισ.", "15 τρισεκατομμύρια"],
    ["159876987654321", "160 τρισ.", "160 τρισεκατομμύρια"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 χιλ.", "10 χιλιάδες"],
    ["99999", "100 χιλ.", "100 χιλιάδες"],
    ["99999", "100 χιλ.", "100 χιλιάδες"],
    ["999999", "1 εκ.", "1 εκατομμύριο"],
    ["9999999", "10 εκ.", "10 εκατομμύρια"],
    ["99999999", "100 εκ.", "100 εκατομμύρια"],
    ["9994", "9,99 χιλ.", "9,99 χιλιάδες"],
    ["99944", "99,9 χιλ.", "99,9 χιλιάδες"],
    ["999444", "999 χιλ.", "999 χιλιάδες"],
    ["9994444", "9,99 εκ.", "9,99 εκατομμύρια"],
    ["999444444", "999 εκ.", "999 εκατομμύρια"],
    ["9994444444", "9,99 δισ.", "9,99 δισεκατομμύρια"],
  ],
  "en": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32K", "4.32 thousand"],
    ["54321", "54.3K", "54.3 thousand"],
    ["654321", "654K", "654 thousand"],
    ["7654321", "7.65M", "7.65 million"],
    ["87654321", "87.7M", "87.7 million"],
    ["987654321", "988M", "988 million"],
    ["1087654321", "1.09B", "1.09 billion"],
    ["11987654321", "12B", "12 billion"],
    ["129987654321", "130B", "130 billion"],
    ["1398987654321", "1.4T", "1.4 trillion"],
    ["14987987654321", "15T", "15 trillion"],
    ["159876987654321", "160T", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 thousand"],
    ["99999", "100K", "100 thousand"],
    ["99999", "100K", "100 thousand"],
    ["999999", "1M", "1 million"],
    ["9999999", "10M", "10 million"],
    ["99999999", "100M", "100 million"],
    ["9994", "9.99K", "9.99 thousand"],
    ["99944", "99.9K", "99.9 thousand"],
    ["999444", "999K", "999 thousand"],
    ["9994444", "9.99M", "9.99 million"],
    ["999444444", "999M", "999 million"],
    ["9994444444", "9.99B", "9.99 billion"],
  ],
  "en_AU": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32K", "4.32 thousand"],
    ["54321", "54.3K", "54.3 thousand"],
    ["654321", "654K", "654 thousand"],
    ["7654321", "7.65M", "7.65 million"],
    ["87654321", "87.7M", "87.7 million"],
    ["987654321", "988M", "988 million"],
    ["1087654321", "1.09B", "1.09 billion"],
    ["11987654321", "12B", "12 billion"],
    ["129987654321", "130B", "130 billion"],
    ["1398987654321", "1.4T", "1.4 trillion"],
    ["14987987654321", "15T", "15 trillion"],
    ["159876987654321", "160T", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 thousand"],
    ["99999", "100K", "100 thousand"],
    ["99999", "100K", "100 thousand"],
    ["999999", "1M", "1 million"],
    ["9999999", "10M", "10 million"],
    ["99999999", "100M", "100 million"],
    ["9994", "9.99K", "9.99 thousand"],
    ["99944", "99.9K", "99.9 thousand"],
    ["999444", "999K", "999 thousand"],
    ["9994444", "9.99M", "9.99 million"],
    ["999444444", "999M", "999 million"],
    ["9994444444", "9.99B", "9.99 billion"],
  ],
  "en_CA": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32K", "4.32 thousand"],
    ["54321", "54.3K", "54.3 thousand"],
    ["654321", "654K", "654 thousand"],
    ["7654321", "7.65M", "7.65 million"],
    ["87654321", "87.7M", "87.7 million"],
    ["987654321", "988M", "988 million"],
    ["1087654321", "1.09B", "1.09 billion"],
    ["11987654321", "12B", "12 billion"],
    ["129987654321", "130B", "130 billion"],
    ["1398987654321", "1.4T", "1.4 trillion"],
    ["14987987654321", "15T", "15 trillion"],
    ["159876987654321", "160T", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 thousand"],
    ["99999", "100K", "100 thousand"],
    ["99999", "100K", "100 thousand"],
    ["999999", "1M", "1 million"],
    ["9999999", "10M", "10 million"],
    ["99999999", "100M", "100 million"],
    ["9994", "9.99K", "9.99 thousand"],
    ["99944", "99.9K", "99.9 thousand"],
    ["999444", "999K", "999 thousand"],
    ["9994444", "9.99M", "9.99 million"],
    ["999444444", "999M", "999 million"],
    ["9994444444", "9.99B", "9.99 billion"],
  ],
  "en_GB": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32K", "4.32 thousand"],
    ["54321", "54.3K", "54.3 thousand"],
    ["654321", "654K", "654 thousand"],
    ["7654321", "7.65M", "7.65 million"],
    ["87654321", "87.7M", "87.7 million"],
    ["987654321", "988M", "988 million"],
    ["1087654321", "1.09B", "1.09 billion"],
    ["11987654321", "12B", "12 billion"],
    ["129987654321", "130B", "130 billion"],
    ["1398987654321", "1.4T", "1.4 trillion"],
    ["14987987654321", "15T", "15 trillion"],
    ["159876987654321", "160T", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 thousand"],
    ["99999", "100K", "100 thousand"],
    ["99999", "100K", "100 thousand"],
    ["999999", "1M", "1 million"],
    ["9999999", "10M", "10 million"],
    ["99999999", "100M", "100 million"],
    ["9994", "9.99K", "9.99 thousand"],
    ["99944", "99.9K", "99.9 thousand"],
    ["999444", "999K", "999 thousand"],
    ["9994444", "9.99M", "9.99 million"],
    ["999444444", "999M", "999 million"],
    ["9994444444", "9.99B", "9.99 billion"],
  ],
  "en_IE": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32K", "4.32 thousand"],
    ["54321", "54.3K", "54.3 thousand"],
    ["654321", "654K", "654 thousand"],
    ["7654321", "7.65M", "7.65 million"],
    ["87654321", "87.7M", "87.7 million"],
    ["987654321", "988M", "988 million"],
    ["1087654321", "1.09B", "1.09 billion"],
    ["11987654321", "12B", "12 billion"],
    ["129987654321", "130B", "130 billion"],
    ["1398987654321", "1.4T", "1.4 trillion"],
    ["14987987654321", "15T", "15 trillion"],
    ["159876987654321", "160T", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 thousand"],
    ["99999", "100K", "100 thousand"],
    ["99999", "100K", "100 thousand"],
    ["999999", "1M", "1 million"],
    ["9999999", "10M", "10 million"],
    ["99999999", "100M", "100 million"],
    ["9994", "9.99K", "9.99 thousand"],
    ["99944", "99.9K", "99.9 thousand"],
    ["999444", "999K", "999 thousand"],
    ["9994444", "9.99M", "9.99 million"],
    ["999444444", "999M", "999 million"],
    ["9994444444", "9.99B", "9.99 billion"],
  ],
  "en_IN": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32K", "4.32 thousand"],
    ["54321", "54.3K", "54.3 thousand"],
    ["654321", "654K", "654 thousand"],
    ["7654321", "7.65M", "7.65 million"],
    ["87654321", "87.7M", "87.7 million"],
    ["987654321", "988M", "988 million"],
    ["1087654321", "1.09B", "1.09 billion"],
    ["11987654321", "12B", "12 billion"],
    ["129987654321", "130B", "130 billion"],
    ["1398987654321", "1.4T", "1.4 trillion"],
    ["14987987654321", "15T", "15 trillion"],
    ["159876987654321", "160T", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 thousand"],
    ["99999", "100K", "100 thousand"],
    ["99999", "100K", "100 thousand"],
    ["999999", "1M", "1 million"],
    ["9999999", "10M", "10 million"],
    ["99999999", "100M", "100 million"],
    ["9994", "9.99K", "9.99 thousand"],
    ["99944", "99.9K", "99.9 thousand"],
    ["999444", "999K", "999 thousand"],
    ["9994444", "9.99M", "9.99 million"],
    ["999444444", "999M", "999 million"],
    ["9994444444", "9.99B", "9.99 billion"],
  ],
  "en_SG": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32K", "4.32 thousand"],
    ["54321", "54.3K", "54.3 thousand"],
    ["654321", "654K", "654 thousand"],
    ["7654321", "7.65M", "7.65 million"],
    ["87654321", "87.7M", "87.7 million"],
    ["987654321", "988M", "988 million"],
    ["1087654321", "1.09B", "1.09 billion"],
    ["11987654321", "12B", "12 billion"],
    ["129987654321", "130B", "130 billion"],
    ["1398987654321", "1.4T", "1.4 trillion"],
    ["14987987654321", "15T", "15 trillion"],
    ["159876987654321", "160T", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 thousand"],
    ["99999", "100K", "100 thousand"],
    ["99999", "100K", "100 thousand"],
    ["999999", "1M", "1 million"],
    ["9999999", "10M", "10 million"],
    ["99999999", "100M", "100 million"],
    ["9994", "9.99K", "9.99 thousand"],
    ["99944", "99.9K", "99.9 thousand"],
    ["999444", "999K", "999 thousand"],
    ["9994444", "9.99M", "9.99 million"],
    ["999444444", "999M", "999 million"],
    ["9994444444", "9.99B", "9.99 billion"],
  ],
  "en_US": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32K", "4.32 thousand"],
    ["54321", "54.3K", "54.3 thousand"],
    ["654321", "654K", "654 thousand"],
    ["7654321", "7.65M", "7.65 million"],
    ["87654321", "87.7M", "87.7 million"],
    ["987654321", "988M", "988 million"],
    ["1087654321", "1.09B", "1.09 billion"],
    ["11987654321", "12B", "12 billion"],
    ["129987654321", "130B", "130 billion"],
    ["1398987654321", "1.4T", "1.4 trillion"],
    ["14987987654321", "15T", "15 trillion"],
    ["159876987654321", "160T", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 thousand"],
    ["99999", "100K", "100 thousand"],
    ["99999", "100K", "100 thousand"],
    ["999999", "1M", "1 million"],
    ["9999999", "10M", "10 million"],
    ["99999999", "100M", "100 million"],
    ["9994", "9.99K", "9.99 thousand"],
    ["99944", "99.9K", "99.9 thousand"],
    ["999444", "999K", "999 thousand"],
    ["9994444", "9.99M", "9.99 million"],
    ["999444444", "999M", "999 million"],
    ["9994444444", "9.99B", "9.99 billion"],
  ],
  "en_ZA": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32K", "4,32 thousand"],
    ["54321", "54,3K", "54,3 thousand"],
    ["654321", "654K", "654 thousand"],
    ["7654321", "7,65M", "7,65 million"],
    ["87654321", "87,7M", "87,7 million"],
    ["987654321", "988M", "988 million"],
    ["1087654321", "1,09B", "1,09 billion"],
    ["11987654321", "12B", "12 billion"],
    ["129987654321", "130B", "130 billion"],
    ["1398987654321", "1,4T", "1,4 trillion"],
    ["14987987654321", "15T", "15 trillion"],
    ["159876987654321", "160T", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 thousand"],
    ["99999", "100K", "100 thousand"],
    ["99999", "100K", "100 thousand"],
    ["999999", "1M", "1 million"],
    ["9999999", "10M", "10 million"],
    ["99999999", "100M", "100 million"],
    ["9994", "9,99K", "9,99 thousand"],
    ["99944", "99,9K", "99,9 thousand"],
    ["999444", "999K", "999 thousand"],
    ["9994444", "9,99M", "9,99 million"],
    ["999444444", "999M", "999 million"],
    ["9994444444", "9,99B", "9,99 billion"],
  ],
  "es": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 mil", "4,32 mil"],
    ["54321", "54,3 mil", "54,3 mil"],
    ["654321", "654 mil", "654 mil"],
    ["7654321", "7,65 M", "7,65 millones"],
    ["87654321", "87,7 M", "87,7 millones"],
    ["987654321", "988 M", "988 millones"],
    ["1087654321", "1090 M", "1,09 mil millones"],
    ["11987654321", "12 mil M", "12 mil millones"],
    ["129987654321", "130 mil M", "130 mil millones"],
    ["1398987654321", "1,4 B", "1,4 billones"],
    ["14987987654321", "15 B", "15 billones"],
    ["159876987654321", "160 B", "160 billones"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 mil", "10 mil"],
    ["99999", "100 mil", "100 mil"],
    ["99999", "100 mil", "100 mil"],
    ["999999", "1 M", "1 millón"],
    ["9999999", "10 M", "10 millones"],
    ["99999999", "100 M", "100 millones"],
    ["9994", "9,99 mil", "9,99 mil"],
    ["99944", "99,9 mil", "99,9 mil"],
    ["999444", "999 mil", "999 mil"],
    ["9994444", "9,99 M", "9,99 millones"],
    ["999444444", "999 M", "999 millones"],
    ["9994444444", "9990 M", "9,99 mil millones"],
  ],
  "es_419": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32 K", "4.32 mil"],
    ["54321", "54.3 k", "54.3 mil"],
    ["654321", "654 k", "654 mil"],
    ["7654321", "7.65 M", "7.65 millones"],
    ["87654321", "87.7 M", "87.7 millones"],
    ["987654321", "988 M", "988 millones"],
    ["1087654321", "1.09k M", "1.09 mil millones"],
    ["11987654321", "12k M", "12 mil millones"],
    ["129987654321", "130k M", "130 mil millones"],
    ["1398987654321", "1.4 B", "1.4 billón"],
    ["14987987654321", "15 B", "15 billones"],
    ["159876987654321", "160 B", "160 billones"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 k", "10 mil"],
    ["99999", "100 k", "100 mil"],
    ["99999", "100 k", "100 mil"],
    ["999999", "1 M", "1 millón"],
    ["9999999", "10 M", "10 millones"],
    ["99999999", "100 M", "100 millones"],
    ["9994", "9.99 K", "9.99 mil"],
    ["99944", "99.9 k", "99.9 mil"],
    ["999444", "999 k", "999 mil"],
    ["9994444", "9.99 M", "9.99 millones"],
    ["999444444", "999 M", "999 millones"],
    ["9994444444", "9.99k M", "9.99 mil millones"],
  ],
  "es_ES": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 mil", "4,32 mil"],
    ["54321", "54,3 mil", "54,3 mil"],
    ["654321", "654 mil", "654 mil"],
    ["7654321", "7,65 M", "7,65 millones"],
    ["87654321", "87,7 M", "87,7 millones"],
    ["987654321", "988 M", "988 millones"],
    ["1087654321", "1090 M", "1,09 mil millones"],
    ["11987654321", "12 mil M", "12 mil millones"],
    ["129987654321", "130 mil M", "130 mil millones"],
    ["1398987654321", "1,4 B", "1,4 billones"],
    ["14987987654321", "15 B", "15 billones"],
    ["159876987654321", "160 B", "160 billones"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 mil", "10 mil"],
    ["99999", "100 mil", "100 mil"],
    ["99999", "100 mil", "100 mil"],
    ["999999", "1 M", "1 millón"],
    ["9999999", "10 M", "10 millones"],
    ["99999999", "100 M", "100 millones"],
    ["9994", "9,99 mil", "9,99 mil"],
    ["99944", "99,9 mil", "99,9 mil"],
    ["999444", "999 mil", "999 mil"],
    ["9994444", "9,99 M", "9,99 millones"],
    ["999444444", "999 M", "999 millones"],
    ["9994444444", "9990 M", "9,99 mil millones"],
  ],
  "es_MX": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32 k", "4.32 mil"],
    ["54321", "54.3 k", "54.3 mil"],
    ["654321", "654 k", "654 mil"],
    ["7654321", "7.65 M", "7.65 millones"],
    ["87654321", "87.7 M", "87.7 millones"],
    ["987654321", "988 M", "988 millones"],
    ["1087654321", "1090 M", "1.09 mil millones"],
    ["11987654321", "12 mil M", "12 mil millones"],
    ["129987654321", "130 mil M", "130 mil millones"],
    ["1398987654321", "1.4 B", "1.4 billones"],
    ["14987987654321", "15 B", "15 billones"],
    ["159876987654321", "160 B", "160 billones"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 k", "10 mil"],
    ["99999", "100 k", "100 mil"],
    ["99999", "100 k", "100 mil"],
    ["999999", "1 M", "1 millón"],
    ["9999999", "10 M", "10 millones"],
    ["99999999", "100 M", "100 millones"],
    ["9994", "9.99 k", "9.99 mil"],
    ["99944", "99.9 k", "99.9 mil"],
    ["999444", "999 k", "999 mil"],
    ["9994444", "9.99 M", "9.99 millones"],
    ["999444444", "999 M", "999 millones"],
    ["9994444444", "9990 M", "9.99 mil millones"],
  ],
  "es_US": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4320", "4.32 mil"],
    ["54321", "54.3 K", "54.3 mil"],
    ["654321", "654 K", "654 mil"],
    ["7654321", "7.65 M", "7.65 millones"],
    ["87654321", "87.7 M", "87.7 millones"],
    ["987654321", "988 M", "988 millones"],
    ["1087654321", "1.09k M", "1.09 mil millones"],
    ["11987654321", "12k M", "12 mil millones"],
    ["129987654321", "130k M", "130 mil millones"],
    ["1398987654321", "1.4 T", "1.4 trillones"],
    ["14987987654321", "15 T", "15 trillones"],
    ["159876987654321", "160 T", "160 trillones"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 K", "10 mil"],
    ["99999", "100 K", "100 mil"],
    ["99999", "100 K", "100 mil"],
    ["999999", "1 M", "1 millón"],
    ["9999999", "10 M", "10 millones"],
    ["99999999", "100 M", "100 millones"],
    ["9994", "9990", "9.99 mil"],
    ["99944", "99.9 K", "99.9 mil"],
    ["999444", "999 K", "999 mil"],
    ["9994444", "9.99 M", "9.99 millones"],
    ["999444444", "999 M", "999 millones"],
    ["9994444444", "9.99k M", "9.99 mil millones"],
  ],
  "et": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 tuh", "4,32 tuhat"],
    ["54321", "54,3 tuh", "54,3 tuhat"],
    ["654321", "654 tuh", "654 tuhat"],
    ["7654321", "7,65 mln", "7,65 miljonit"],
    ["87654321", "87,7 mln", "87,7 miljonit"],
    ["987654321", "988 mln", "988 miljonit"],
    ["1087654321", "1,09 mld", "1,09 miljardit"],
    ["11987654321", "12 mld", "12 miljardit"],
    ["129987654321", "130 mld", "130 miljardit"],
    ["1398987654321", "1,4 trl", "1,4 triljonit"],
    ["14987987654321", "15 trl", "15 triljonit"],
    ["159876987654321", "160 trl", "160 triljonit"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 tuh", "10 tuhat"],
    ["99999", "100 tuh", "100 tuhat"],
    ["99999", "100 tuh", "100 tuhat"],
    ["999999", "1 mln", "1 miljon"],
    ["9999999", "10 mln", "10 miljonit"],
    ["99999999", "100 mln", "100 miljonit"],
    ["9994", "9,99 tuh", "9,99 tuhat"],
    ["99944", "99,9 tuh", "99,9 tuhat"],
    ["999444", "999 tuh", "999 tuhat"],
    ["9994444", "9,99 mln", "9,99 miljonit"],
    ["999444444", "999 mln", "999 miljonit"],
    ["9994444444", "9,99 mld", "9,99 miljardit"],
  ],
  "eu": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4320", "4320"],
    ["54321", "54300", "54300"],
    ["654321", "654000", "654000"],
    ["7654321", "7,65 M", "7,65 milioi"],
    ["87654321", "87,7 M", "87,7 milioi"],
    ["987654321", "988 M", "988 milioi"],
    ["1087654321", "1090 M", "1090 milioi"],
    ["11987654321", "12000 M", "12000 milioi"],
    ["129987654321", "130000 M", "130000 milioi"],
    ["1398987654321", "1,4 B", "1,4 bilioi"],
    ["14987987654321", "15 B", "15 bilioi"],
    ["159876987654321", "160 B", "160 bilioi"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10000", "10000"],
    ["99999", "100000", "100000"],
    ["99999", "100000", "100000"],
    ["999999", "1 M", "1 milioi"],
    ["9999999", "10 M", "10 milioi"],
    ["99999999", "100 M", "100 milioi"],
    ["9994", "9990", "9990"],
    ["99944", "99900", "99900"],
    ["999444", "999000", "999000"],
    ["9994444", "9,99 M", "9,99 milioi"],
    ["999444444", "999 M", "999 milioi"],
    ["9994444444", "9990 M", "9990 milioi"],
  ],
  "fa": [
    ["1", "۱", "۱"],
    ["21", "۲۱", "۲۱"],
    ["321", "۳۲۱", "۳۲۱"],
    ["4321", "۴٫۳۲ هزار", "۴٫۳۲ هزار"],
    ["54321", "۵۴٫۳ هزار", "۵۴٫۳ هزار"],
    ["654321", "۶۵۴ هزار", "۶۵۴ هزار"],
    ["7654321", "۷٫۶۵ میلیون", "۷٫۶۵ میلیون"],
    ["87654321", "۸۷٫۷ میلیون", "۸۷٫۷ میلیون"],
    ["987654321", "۹۸۸ م", "۹۸۸ میلیون"],
    ["1087654321", "۱٫۰۹ م", "۱٫۰۹ میلیارد"],
    ["11987654321", "۱۲ م", "۱۲ میلیارد"],
    ["129987654321", "۱۳۰ میلیارد", "۱۳۰ میلیارد"],
    ["1398987654321", "۱٫۴ تریلیون", "۱٫۴ هزارمیلیارد"],
    ["14987987654321", "۱۵ ت", "۱۵ هزارمیلیارد"],
    ["159876987654321", "۱۶۰ ت", "۱۶۰ هزارمیلیارد"],
    ["9", "۹", "۹"],
    ["99", "۹۹", "۹۹"],
    ["999", "۹۹۹", "۹۹۹"],
    ["9999", "۱۰ هزار", "۱۰ هزار"],
    ["99999", "۱۰۰ هزار", "۱۰۰ هزار"],
    ["99999", "۱۰۰ هزار", "۱۰۰ هزار"],
    ["999999", "۱ میلیون", "۱ میلیون"],
    ["9999999", "۱۰ میلیون", "۱۰ میلیون"],
    ["99999999", "۱۰۰ م", "۱۰۰ میلیون"],
    ["9994", "۹٫۹۹ هزار", "۹٫۹۹ هزار"],
    ["99944", "۹۹٫۹ هزار", "۹۹٫۹ هزار"],
    ["999444", "۹۹۹ هزار", "۹۹۹ هزار"],
    ["9994444", "۹٫۹۹ میلیون", "۹٫۹۹ میلیون"],
    ["999444444", "۹۹۹ م", "۹۹۹ میلیون"],
    ["9994444444", "۹٫۹۹ م", "۹٫۹۹ میلیارد"],
  ],
  "fi": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 t.", "4,32 tuhatta"],
    ["54321", "54,3 t.", "54,3 tuhatta"],
    ["654321", "654 t.", "654 tuhatta"],
    ["7654321", "7,65 milj.", "7,65 miljoonaa"],
    ["87654321", "87,7 milj.", "87,7 miljoonaa"],
    ["987654321", "988 milj.", "988 miljoonaa"],
    ["1087654321", "1,09 mrd.", "1,09 miljardia"],
    ["11987654321", "12 mrd.", "12 miljardia"],
    ["129987654321", "130 mrd.", "130 miljardia"],
    ["1398987654321", "1,4 bilj.", "1,4 biljoonaa"],
    ["14987987654321", "15 bilj.", "15 biljoonaa"],
    ["159876987654321", "160 bilj.", "160 biljoonaa"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 t.", "10 tuhatta"],
    ["99999", "100 t.", "100 tuhatta"],
    ["99999", "100 t.", "100 tuhatta"],
    ["999999", "1 milj.", "1 miljoona"],
    ["9999999", "10 milj.", "10 miljoonaa"],
    ["99999999", "100 milj.", "100 miljoonaa"],
    ["9994", "9,99 t.", "9,99 tuhatta"],
    ["99944", "99,9 t.", "99,9 tuhatta"],
    ["999444", "999 t.", "999 tuhatta"],
    ["9994444", "9,99 milj.", "9,99 miljoonaa"],
    ["999444444", "999 milj.", "999 miljoonaa"],
    ["9994444444", "9,99 mrd.", "9,99 miljardia"],
  ],
  "fil": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32K", "4.32 libo"],
    ["54321", "54.3K", "54.3 libo"],
    ["654321", "654K", "654 na libo"],
    ["7654321", "7.65M", "7.65 milyon"],
    ["87654321", "87.7M", "87.7 milyon"],
    ["987654321", "988M", "988 milyon"],
    ["1087654321", "1.09B", "1.09 bilyon"],
    ["11987654321", "12B", "12 bilyon"],
    ["129987654321", "130B", "130 bilyon"],
    ["1398987654321", "1.4T", "1.4 na trilyon"],
    ["14987987654321", "15T", "15 trilyon"],
    ["159876987654321", "160T", "160 trilyon"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 libo"],
    ["99999", "100K", "100 libo"],
    ["99999", "100K", "100 libo"],
    ["999999", "1M", "1 milyon"],
    ["9999999", "10M", "10 milyon"],
    ["99999999", "100M", "100 milyon"],
    ["9994", "9.99K", "9.99 na libo"],
    ["99944", "99.9K", "99.9 na libo"],
    ["999444", "999K", "999 na libo"],
    ["9994444", "9.99M", "9.99 na milyon"],
    ["999444444", "999M", "999 na milyon"],
    ["9994444444", "9.99B", "9.99 na bilyon"],
  ],
  "fr": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 k", "4,32 mille"],
    ["54321", "54,3 k", "54,3 mille"],
    ["654321", "654 k", "654 mille"],
    ["7654321", "7,65 M", "7,65 millions"],
    ["87654321", "87,7 M", "87,7 millions"],
    ["987654321", "988 M", "988 millions"],
    ["1087654321", "1,09 Md", "1,09 milliard"],
    ["11987654321", "12 Md", "12 milliards"],
    ["129987654321", "130 Md", "130 milliards"],
    ["1398987654321", "1,4 Bn", "1,4 billion"],
    ["14987987654321", "15 Bn", "15 billions"],
    ["159876987654321", "160 Bn", "160 billions"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 k", "10 mille"],
    ["99999", "100 k", "100 mille"],
    ["99999", "100 k", "100 mille"],
    ["999999", "1 M", "1 million"],
    ["9999999", "10 M", "10 millions"],
    ["99999999", "100 M", "100 millions"],
    ["9994", "9,99 k", "9,99 mille"],
    ["99944", "99,9 k", "99,9 mille"],
    ["999444", "999 k", "999 mille"],
    ["9994444", "9,99 M", "9,99 millions"],
    ["999444444", "999 M", "999 millions"],
    ["9994444444", "9,99 Md", "9,99 milliards"],
  ],
  "fr_CA": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 k", "4,32 mille"],
    ["54321", "54,3 k", "54,3 mille"],
    ["654321", "654 k", "654 mille"],
    ["7654321", "7,65 M", "7,65 millions"],
    ["87654321", "87,7 M", "87,7 millions"],
    ["987654321", "988 M", "988 millions"],
    ["1087654321", "1,09 G", "1,09 milliard"],
    ["11987654321", "12 G", "12 milliards"],
    ["129987654321", "130 G", "130 milliards"],
    ["1398987654321", "1,4 T", "1,4 billion"],
    ["14987987654321", "15 T", "15 billions"],
    ["159876987654321", "160 T", "160 billions"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 k", "10 mille"],
    ["99999", "100 k", "100 mille"],
    ["99999", "100 k", "100 mille"],
    ["999999", "1 M", "1 million"],
    ["9999999", "10 M", "10 millions"],
    ["99999999", "100 M", "100 millions"],
    ["9994", "9,99 k", "9,99 mille"],
    ["99944", "99,9 k", "99,9 mille"],
    ["999444", "999 k", "999 mille"],
    ["9994444", "9,99 M", "9,99 millions"],
    ["999444444", "999 M", "999 millions"],
    ["9994444444", "9,99 G", "9,99 milliards"],
  ],
  "ga": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32k", "4.32 míle"],
    ["54321", "54.3k", "54.3 míle"],
    ["654321", "654k", "654 míle"],
    ["7654321", "7.65M", "7.65 milliún"],
    ["87654321", "87.7M", "87.7 milliún"],
    ["987654321", "988M", "988 milliún"],
    ["1087654321", "1.09B", "1.09 billiún"],
    ["11987654321", "12B", "12 billiún"],
    ["129987654321", "130B", "130 billiún"],
    ["1398987654321", "1.4T", "1.4 trilliún"],
    ["14987987654321", "15T", "15 trilliún"],
    ["159876987654321", "160T", "160 trilliún"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10k", "10 míle"],
    ["99999", "100k", "100 míle"],
    ["99999", "100k", "100 míle"],
    ["999999", "1M", "1 mhilliún"],
    ["9999999", "10M", "10 milliún"],
    ["99999999", "100M", "100 milliún"],
    ["9994", "9.99k", "9.99 míle"],
    ["99944", "99.9k", "99.9 míle"],
    ["999444", "999k", "999 míle"],
    ["9994444", "9.99M", "9.99 milliún"],
    ["999444444", "999M", "999 milliún"],
    ["9994444444", "9.99B", "9.99 billiún"],
  ],
  "gl": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4320", "4320"],
    ["54321", "54300", "54300"],
    ["654321", "654000", "654000"],
    ["7654321", "7,65 mill.", "7,65 millóns"],
    ["87654321", "87,7 mill.", "87,7 millóns"],
    ["987654321", "988 mill", "988 millóns"],
    ["1087654321", "1090000000", "1090000000"],
    ["11987654321", "12000000000", "12000000000"],
    ["129987654321", "130000000000", "130000000000"],
    ["1398987654321", "1,4 bill.", "1,4 billóns"],
    ["14987987654321", "15 bill.", "15 billóns"],
    ["159876987654321", "160 bill.", "160 billóns"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10000", "10000"],
    ["99999", "100000", "100000"],
    ["99999", "100000", "100000"],
    ["999999", "1 mill.", "1 millón"],
    ["9999999", "10 mill.", "10 millóns"],
    ["99999999", "100 mill", "100 millóns"],
    ["9994", "9990", "9990"],
    ["99944", "99900", "99900"],
    ["999444", "999000", "999000"],
    ["9994444", "9,99 mill.", "9,99 millóns"],
    ["999444444", "999 mill", "999 millóns"],
    ["9994444444", "9990000000", "9990000000"],
  ],
  "gsw": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32 Tsg.", "4.32 Tuusig"],
    ["54321", "54.3 Tsg.", "54.3 Tuusig"],
    ["654321", "654 Tsg.", "654 Tuusig"],
    ["7654321", "7.65 Mio.", "7.65 Millioone"],
    ["87654321", "87.7 Mio.", "87.7 Millioone"],
    ["987654321", "988 Mio.", "988 Millioone"],
    ["1087654321", "1.09 Mrd.", "1.09 Milliarde"],
    ["11987654321", "12 Mrd.", "12 Milliarde"],
    ["129987654321", "130 Mrd.", "130 Milliarde"],
    ["1398987654321", "1.4 Bio.", "1.4 Billioone"],
    ["14987987654321", "15 Bio.", "15 Billioone"],
    ["159876987654321", "160 Bio.", "160 Billioone"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 Tsg.", "10 Tuusig"],
    ["99999", "100 Tsg.", "100 Tuusig"],
    ["99999", "100 Tsg.", "100 Tuusig"],
    ["999999", "1 Mio.", "1 Millioon"],
    ["9999999", "10 Mio.", "10 Millioone"],
    ["99999999", "100 Mio.", "100 Millioone"],
    ["9994", "9.99 Tsg.", "9.99 Tuusig"],
    ["99944", "99.9 Tsg.", "99.9 Tuusig"],
    ["999444", "999 Tsg.", "999 Tuusig"],
    ["9994444", "9.99 Mio.", "9.99 Millioone"],
    ["999444444", "999 Mio.", "999 Millioone"],
    ["9994444444", "9.99 Mrd.", "9.99 Milliarde"],
  ],
  "gu": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32 હજાર", "4.32 હજાર"],
    ["54321", "54.3 હજાર", "54.3 હજાર"],
    ["654321", "6.54 લાખ", "6.54 લાખ"],
    ["7654321", "76.5 લાખ", "76.5 લાખ"],
    ["87654321", "8.77 કરોડ", "8.77 કરોડ"],
    ["987654321", "98.8 કરોડ", "98.8 કરોડ"],
    ["1087654321", "1.09 અબજ", "1.09 અબજ"],
    ["11987654321", "12 અબજ", "12 અબજ"],
    ["129987654321", "1.3 નિખર્વ", "1.3 નિખર્વ"],
    ["1398987654321", "1.4 મહાપદ્મ", "1.4 મહાપદ્મ"],
    ["14987987654321", "1.5 શંકુ", "1.5 શંકુ"],
    ["159876987654321", "1.6 જલધિ", "1.6 જલધિ"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 હજાર", "10 હજાર"],
    ["99999", "1 લાખ", "1 લાખ"],
    ["99999", "1 લાખ", "1 લાખ"],
    ["999999", "10 લાખ", "10 લાખ"],
    ["9999999", "1 કરોડ", "1 કરોડ"],
    ["99999999", "10 કરોડ", "10 કરોડ"],
    ["9994", "9.99 હજાર", "9.99 હજાર"],
    ["99944", "99.9 હજાર", "99.9 હજાર"],
    ["999444", "9.99 લાખ", "9.99 લાખ"],
    ["9994444", "99.9 લાખ", "99.9 લાખ"],
    ["999444444", "99.9 કરોડ", "99.9 કરોડ"],
    ["9994444444", "9.99 અબજ", "9.99 અબજ"],
  ],
  "haw": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32K", "4.32K"],
    ["54321", "54.3K", "54.3K"],
    ["654321", "654K", "654K"],
    ["7654321", "7.65M", "7.65M"],
    ["87654321", "87.7M", "87.7M"],
    ["987654321", "988M", "988M"],
    ["1087654321", "1.09G", "1.09G"],
    ["11987654321", "12G", "12G"],
    ["129987654321", "130G", "130G"],
    ["1398987654321", "1.4T", "1.4T"],
    ["14987987654321", "15T", "15T"],
    ["159876987654321", "160T", "160T"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10K"],
    ["99999", "100K", "100K"],
    ["99999", "100K", "100K"],
    ["999999", "1M", "1M"],
    ["9999999", "10M", "10M"],
    ["99999999", "100M", "100M"],
    ["9994", "9.99K", "9.99K"],
    ["99944", "99.9K", "99.9K"],
    ["999444", "999K", "999K"],
    ["9994444", "9.99M", "9.99M"],
    ["999444444", "999M", "999M"],
    ["9994444444", "9.99G", "9.99G"],
  ],
  "he": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32K", "‏4.32 אלף"],
    ["54321", "54.3K", "‏54.3 אלף"],
    ["654321", "654K", "‏654 אלף"],
    ["7654321", "7.65M", "‏7.65 מיליון"],
    ["87654321", "87.7M", "‏87.7 מיליון"],
    ["987654321", "988M", "‏988 מיליון"],
    ["1087654321", "1.09B", "‏1.09 מיליארד"],
    ["11987654321", "12B", "‏12 מיליארד"],
    ["129987654321", "130B", "‏130 מיליארד"],
    ["1398987654321", "1.4T", "‏1.4 טריליון"],
    ["14987987654321", "15T", "‏15 טריליון"],
    ["159876987654321", "160T", "‏160 טריליון"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "‏10 אלף"],
    ["99999", "100K", "‏100 אלף"],
    ["99999", "100K", "‏100 אלף"],
    ["999999", "1M", "‏1 מיליון"],
    ["9999999", "10M", "‏10 מיליון"],
    ["99999999", "100M", "‏100 מיליון"],
    ["9994", "9.99K", "‏9.99 אלף"],
    ["99944", "99.9K", "‏99.9 אלף"],
    ["999444", "999K", "‏999 אלף"],
    ["9994444", "9.99M", "‏9.99 מיליון"],
    ["999444444", "999M", "‏999 מיליון"],
    ["9994444444", "9.99B", "‏9.99 מיליארד"],
  ],
  "hi": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32 हज़ार", "4.32 हज़ार"],
    ["54321", "54.3 हज़ार", "54.3 हज़ार"],
    ["654321", "6.54 लाख", "6.54 लाख"],
    ["7654321", "76.5 लाख", "76.5 लाख"],
    ["87654321", "8.77 क॰", "8.77 करोड़"],
    ["987654321", "98.8 क॰", "98.8 करोड़"],
    ["1087654321", "1.09 अ॰", "1.09 अरब"],
    ["11987654321", "12 अ॰", "12 अरब"],
    ["129987654321", "1.3 ख॰", "1.3 खरब"],
    ["1398987654321", "14 ख॰", "14 खरब"],
    ["14987987654321", "1.5 नील", "150 खरब"],
    ["159876987654321", "16 नील", "1600 खरब"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 हज़ार", "10 हज़ार"],
    ["99999", "1 लाख", "1 लाख"],
    ["99999", "1 लाख", "1 लाख"],
    ["999999", "10 लाख", "10 लाख"],
    ["9999999", "1 क॰", "1 करोड़"],
    ["99999999", "10 क॰", "10 करोड़"],
    ["9994", "9.99 हज़ार", "9.99 हज़ार"],
    ["99944", "99.9 हज़ार", "99.9 हज़ार"],
    ["999444", "9.99 लाख", "9.99 लाख"],
    ["9994444", "99.9 लाख", "99.9 लाख"],
    ["999444444", "99.9 क॰", "99.9 करोड़"],
    ["9994444444", "9.99 अ॰", "9.99 अरब"],
  ],
  "hr": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 tis.", "4,32 tisuće"],
    ["54321", "54,3 tis.", "54,3 tisuće"],
    ["654321", "654 tis.", "654 tisuće"],
    ["7654321", "7,65 mil.", "7,65 milijuna"],
    ["87654321", "87,7 mil.", "87,7 milijuna"],
    ["987654321", "988 mil.", "988 milijuna"],
    ["1087654321", "1,09 mlr.", "1,09 milijardi"],
    ["11987654321", "12 mlr.", "12 milijardi"],
    ["129987654321", "130 mlr.", "130 milijardi"],
    ["1398987654321", "1,4 bil.", "1,4 bilijuna"],
    ["14987987654321", "15 bil.", "15 bilijuna"],
    ["159876987654321", "160 bil.", "160 bilijuna"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 tis.", "10 tisuća"],
    ["99999", "100 tis.", "100 tisuća"],
    ["99999", "100 tis.", "100 tisuća"],
    ["999999", "1 mil.", "1 milijun"],
    ["9999999", "10 mil.", "10 milijuna"],
    ["99999999", "100 mil.", "100 milijuna"],
    ["9994", "9,99 tis.", "9,99 tisuća"],
    ["99944", "99,9 tis.", "99,9 tisuća"],
    ["999444", "999 tis.", "999 tisuća"],
    ["9994444", "9,99 mil.", "9,99 milijuna"],
    ["999444444", "999 mil.", "999 milijuna"],
    ["9994444444", "9,99 mlr.", "9,99 milijardi"],
  ],
  "hu": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 E", "4,32 ezer"],
    ["54321", "54,3 E", "54,3 ezer"],
    ["654321", "654 E", "654 ezer"],
    ["7654321", "7,65 M", "7,65 millió"],
    ["87654321", "87,7 M", "87,7 millió"],
    ["987654321", "988 M", "988 millió"],
    ["1087654321", "1,09 Mrd", "1,09 milliárd"],
    ["11987654321", "12 Mrd", "12 milliárd"],
    ["129987654321", "130 Mrd", "130 milliárd"],
    ["1398987654321", "1,4 B", "1,4 billió"],
    ["14987987654321", "15 B", "15 billió"],
    ["159876987654321", "160 B", "160 billió"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 E", "10 ezer"],
    ["99999", "100 E", "100 ezer"],
    ["99999", "100 E", "100 ezer"],
    ["999999", "1 M", "1 millió"],
    ["9999999", "10 M", "10 millió"],
    ["99999999", "100 M", "100 millió"],
    ["9994", "9,99 E", "9,99 ezer"],
    ["99944", "99,9 E", "99,9 ezer"],
    ["999444", "999 E", "999 ezer"],
    ["9994444", "9,99 M", "9,99 millió"],
    ["999444444", "999 M", "999 millió"],
    ["9994444444", "9,99 Mrd", "9,99 milliárd"],
  ],
  "hy": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 հզր", "4,32 հազար"],
    ["54321", "54,3 հզր", "54,3 հազար"],
    ["654321", "654 հզր", "654 հազար"],
    ["7654321", "7,65 մլն", "7,65 միլիոն"],
    ["87654321", "87,7 մլն", "87,7 միլիոն"],
    ["987654321", "988 մլն", "988 միլիոն"],
    ["1087654321", "1,09 մլրդ", "1,09 միլիարդ"],
    ["11987654321", "12 մլրդ", "12 միլիարդ"],
    ["129987654321", "130 մլրդ", "130 միլիարդ"],
    ["1398987654321", "1,4 տրլն", "1,4 տրիլիոն"],
    ["14987987654321", "15 տրլն", "15 տրիլիոն"],
    ["159876987654321", "160 տրլն", "160 տրիլիոն"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 հզր", "10 հազար"],
    ["99999", "100 հզր", "100 հազար"],
    ["99999", "100 հզր", "100 հազար"],
    ["999999", "1 մլն", "1 միլիոն"],
    ["9999999", "10 մլն", "10 միլիոն"],
    ["99999999", "100 մլն", "100 միլիոն"],
    ["9994", "9,99 հզր", "9,99 հազար"],
    ["99944", "99,9 հզր", "99,9 հազար"],
    ["999444", "999 հզր", "999 հազար"],
    ["9994444", "9,99 մլն", "9,99 միլիոն"],
    ["999444444", "999 մլն", "999 միլիոն"],
    ["9994444444", "9,99 մլրդ", "9,99 միլիարդ"],
  ],
  "id": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 rb", "4,32 ribu"],
    ["54321", "54,3 rb", "54,3 ribu"],
    ["654321", "654 rb", "654 ribu"],
    ["7654321", "7,65 jt", "7,65 juta"],
    ["87654321", "87,7 jt", "87,7 juta"],
    ["987654321", "988 jt", "988 juta"],
    ["1087654321", "1,09 M", "1,09 miliar"],
    ["11987654321", "12 M", "12 miliar"],
    ["129987654321", "130 M", "130 miliar"],
    ["1398987654321", "1,4 T", "1,4 triliun"],
    ["14987987654321", "15 T", "15 triliun"],
    ["159876987654321", "160 T", "160 triliun"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 rb", "10 ribu"],
    ["99999", "100 rb", "100 ribu"],
    ["99999", "100 rb", "100 ribu"],
    ["999999", "1 jt", "1 juta"],
    ["9999999", "10 jt", "10 juta"],
    ["99999999", "100 jt", "100 juta"],
    ["9994", "9,99 rb", "9,99 ribu"],
    ["99944", "99,9 rb", "99,9 ribu"],
    ["999444", "999 rb", "999 ribu"],
    ["9994444", "9,99 jt", "9,99 juta"],
    ["999444444", "999 jt", "999 juta"],
    ["9994444444", "9,99 M", "9,99 miliar"],
  ],
  "in": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 rb", "4,32 ribu"],
    ["54321", "54,3 rb", "54,3 ribu"],
    ["654321", "654 rb", "654 ribu"],
    ["7654321", "7,65 jt", "7,65 juta"],
    ["87654321", "87,7 jt", "87,7 juta"],
    ["987654321", "988 jt", "988 juta"],
    ["1087654321", "1,09 M", "1,09 miliar"],
    ["11987654321", "12 M", "12 miliar"],
    ["129987654321", "130 M", "130 miliar"],
    ["1398987654321", "1,4 T", "1,4 triliun"],
    ["14987987654321", "15 T", "15 triliun"],
    ["159876987654321", "160 T", "160 triliun"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 rb", "10 ribu"],
    ["99999", "100 rb", "100 ribu"],
    ["99999", "100 rb", "100 ribu"],
    ["999999", "1 jt", "1 juta"],
    ["9999999", "10 jt", "10 juta"],
    ["99999999", "100 jt", "100 juta"],
    ["9994", "9,99 rb", "9,99 ribu"],
    ["99944", "99,9 rb", "99,9 ribu"],
    ["999444", "999 rb", "999 ribu"],
    ["9994444", "9,99 jt", "9,99 juta"],
    ["999444444", "999 jt", "999 juta"],
    ["9994444444", "9,99 M", "9,99 miliar"],
  ],
  "is": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 þ.", "4,32 þúsund"],
    ["54321", "54,3 þ.", "54,3 þúsund"],
    ["654321", "654 þ.", "654 þúsund"],
    ["7654321", "7,65 m.", "7,65 milljón"],
    ["87654321", "87,7 m.", "87,7 milljón"],
    ["987654321", "988 m.", "988 milljónir"],
    ["1087654321", "1,09 ma.", "1,09 milljarður"],
    ["11987654321", "12 ma.", "12 milljarðar"],
    ["129987654321", "130 ma.", "130 milljarðar"],
    ["1398987654321", "1,4 bn", "1,4 billjón"],
    ["14987987654321", "15 bn", "15 billjónir"],
    ["159876987654321", "160 bn", "160 billjónir"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 þ.", "10 þúsund"],
    ["99999", "100 þ.", "100 þúsund"],
    ["99999", "100 þ.", "100 þúsund"],
    ["999999", "1 m.", "1 milljón"],
    ["9999999", "10 m.", "10 milljónir"],
    ["99999999", "100 m.", "100 milljónir"],
    ["9994", "9,99 þ.", "9,99 þúsund"],
    ["99944", "99,9 þ.", "99,9 þúsund"],
    ["999444", "999 þ.", "999 þúsund"],
    ["9994444", "9,99 m.", "9,99 milljón"],
    ["999444444", "999 m.", "999 milljónir"],
    ["9994444444", "9,99 ma.", "9,99 milljarður"],
  ],
  "it": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4320", "4,32 mila"],
    ["54321", "54300", "54,3 mila"],
    ["654321", "654000", "654 mila"],
    ["7654321", "7,65 Mln", "7,65 milioni"],
    ["87654321", "87,7 Mln", "87,7 milioni"],
    ["987654321", "988 Mln", "988 milioni"],
    ["1087654321", "1,09 Mld", "1,09 miliardi"],
    ["11987654321", "12 Mld", "12 miliardi"],
    ["129987654321", "130 Mld", "130 miliardi"],
    ["1398987654321", "1,4 Bln", "1,4 mila miliardi"],
    ["14987987654321", "15 Bln", "15 mila miliardi"],
    ["159876987654321", "160 Bln", "160 mila miliardi"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10000", "10 mila"],
    ["99999", "100000", "100 mila"],
    ["99999", "100000", "100 mila"],
    ["999999", "1 Mln", "1 milione"],
    ["9999999", "10 Mln", "10 milioni"],
    ["99999999", "100 Mln", "100 milioni"],
    ["9994", "9990", "9,99 mila"],
    ["99944", "99900", "99,9 mila"],
    ["999444", "999000", "999 mila"],
    ["9994444", "9,99 Mln", "9,99 milioni"],
    ["999444444", "999 Mln", "999 milioni"],
    ["9994444444", "9,99 Mld", "9,99 miliardi"],
  ],
  "iw": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32K", "‏4.32 אלף"],
    ["54321", "54.3K", "‏54.3 אלף"],
    ["654321", "654K", "‏654 אלף"],
    ["7654321", "7.65M", "‏7.65 מיליון"],
    ["87654321", "87.7M", "‏87.7 מיליון"],
    ["987654321", "988M", "‏988 מיליון"],
    ["1087654321", "1.09B", "‏1.09 מיליארד"],
    ["11987654321", "12B", "‏12 מיליארד"],
    ["129987654321", "130B", "‏130 מיליארד"],
    ["1398987654321", "1.4T", "‏1.4 טריליון"],
    ["14987987654321", "15T", "‏15 טריליון"],
    ["159876987654321", "160T", "‏160 טריליון"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "‏10 אלף"],
    ["99999", "100K", "‏100 אלף"],
    ["99999", "100K", "‏100 אלף"],
    ["999999", "1M", "‏1 מיליון"],
    ["9999999", "10M", "‏10 מיליון"],
    ["99999999", "100M", "‏100 מיליון"],
    ["9994", "9.99K", "‏9.99 אלף"],
    ["99944", "99.9K", "‏99.9 אלף"],
    ["999444", "999K", "‏999 אלף"],
    ["9994444", "9.99M", "‏9.99 מיליון"],
    ["999444444", "999M", "‏999 מיליון"],
    ["9994444444", "9.99B", "‏9.99 מיליארד"],
  ],
  "ja": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4320", "4320"],
    ["54321", "5.43万", "5.43万"],
    ["654321", "65.4万", "65.4万"],
    ["7654321", "765万", "765万"],
    ["87654321", "8770万", "8770万"],
    ["987654321", "9.88億", "9.88億"],
    ["1087654321", "10.9億", "10.9億"],
    ["11987654321", "120億", "120億"],
    ["129987654321", "1300億", "1300億"],
    ["1398987654321", "1.4兆", "1.4兆"],
    ["14987987654321", "15兆", "15兆"],
    ["159876987654321", "160兆", "160兆"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "1万", "1万"],
    ["99999", "10万", "10万"],
    ["99999", "10万", "10万"],
    ["999999", "100万", "100万"],
    ["9999999", "1000万", "1000万"],
    ["99999999", "1億", "1億"],
    ["9994", "9990", "9990"],
    ["99944", "9.99万", "9.99万"],
    ["999444", "99.9万", "99.9万"],
    ["9994444", "999万", "999万"],
    ["999444444", "9.99億", "9.99億"],
    ["9994444444", "99.9億", "99.9億"],
  ],
  "ka": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 ათ.", "4,32 ათასი"],
    ["54321", "54,3 ათ.", "54,3 ათასი"],
    ["654321", "654 ათ.", "654 ათასი"],
    ["7654321", "7,65 მლნ.", "7,65 მილიონი"],
    ["87654321", "87,7 მლნ.", "87,7 მილიონი"],
    ["987654321", "988 მლნ.", "988 მილიონი"],
    ["1087654321", "1,09 მლრდ.", "1,09 მილიარდი"],
    ["11987654321", "12 მლრდ.", "12 მილიარდი"],
    ["129987654321", "130 მლრ.", "130 მილიარდი"],
    ["1398987654321", "1,4 ტრლ.", "1,4 ტრილიონი"],
    ["14987987654321", "15 ტრლ.", "15 ტრილიონი"],
    ["159876987654321", "160 ტრლ.", "160 ტრილიონი"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 ათ.", "10 ათასი"],
    ["99999", "100 ათ.", "100 ათასი"],
    ["99999", "100 ათ.", "100 ათასი"],
    ["999999", "1 მლნ.", "1 მილიონი"],
    ["9999999", "10 მლნ.", "10 მილიონი"],
    ["99999999", "100 მლნ.", "100 მილიონი"],
    ["9994", "9,99 ათ.", "9,99 ათასი"],
    ["99944", "99,9 ათ.", "99,9 ათასი"],
    ["999444", "999 ათ.", "999 ათასი"],
    ["9994444", "9,99 მლნ.", "9,99 მილიონი"],
    ["999444444", "999 მლნ.", "999 მილიონი"],
    ["9994444444", "9,99 მლრდ.", "9,99 მილიარდი"],
  ],
  "kk": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 мың", "4,32 мың"],
    ["54321", "54,3 мың", "54,3 мың"],
    ["654321", "654 м.", "654 мың"],
    ["7654321", "7,65 млн", "7,65 миллион"],
    ["87654321", "87,7 млн", "87,7 миллион"],
    ["987654321", "988 млн", "988 миллион"],
    ["1087654321", "1,09 млрд", "1,09 миллиард"],
    ["11987654321", "12 млрд", "12 миллиард"],
    ["129987654321", "130 млрд", "130 миллиард"],
    ["1398987654321", "1,4 трлн", "1,4 триллион"],
    ["14987987654321", "15 трлн", "15 триллион"],
    ["159876987654321", "160 трлн", "160 триллион"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 мың", "10 мың"],
    ["99999", "100 м.", "100 мың"],
    ["99999", "100 м.", "100 мың"],
    ["999999", "1 млн", "1 миллион"],
    ["9999999", "10 млн", "10 миллион"],
    ["99999999", "100 млн", "100 миллион"],
    ["9994", "9,99 мың", "9,99 мың"],
    ["99944", "99,9 мың", "99,9 мың"],
    ["999444", "999 м.", "999 мың"],
    ["9994444", "9,99 млн", "9,99 миллион"],
    ["999444444", "999 млн", "999 миллион"],
    ["9994444444", "9,99 млрд", "9,99 миллиард"],
  ],
  "km": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32ពាន់", "4,32ពាន់"],
    ["54321", "5,43​មឺុន", "5,43​មឺុន"],
    ["654321", "6,54សែន", "6,54សែន"],
    ["7654321", "7,65លាន", "7,65លាន"],
    ["87654321", "8,77​ដប់​លាន", "8,77​ដប់​លាន"],
    ["987654321", "9,88​រយលាន", "9,88​រយលាន"],
    ["1087654321", "1,09​កោដិ", "1,09​កោដិ"],
    ["11987654321", "1,2​ដប់​កោដិ", "1,2​ដប់​កោដិ"],
    ["129987654321", "1,3​រយ​កោដិ", "1,3​រយ​កោដិ"],
    ["1398987654321", "1,4​ពាន់​កោដិ", "1,4​ពាន់​កោដិ"],
    ["14987987654321", "1,5​មឺុន​កោដិ", "1,5​មឺុន​កោដិ"],
    ["159876987654321", "1,6​សែន​កោដិ", "1,6​សែន​កោដិ"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "1​មឺុន", "1​មឺុន"],
    ["99999", "1សែន", "1សែន"],
    ["99999", "1សែន", "1សែន"],
    ["999999", "1លាន", "1លាន"],
    ["9999999", "1​ដប់​លាន", "1​ដប់​លាន"],
    ["99999999", "1​រយលាន", "1​រយលាន"],
    ["9994", "9,99ពាន់", "9,99ពាន់"],
    ["99944", "9,99​មឺុន", "9,99​មឺុន"],
    ["999444", "9,99សែន", "9,99សែន"],
    ["9994444", "9,99លាន", "9,99លាន"],
    ["999444444", "9,99​រយលាន", "9,99​រយលាន"],
    ["9994444444", "9,99​កោដិ", "9,99​កោដិ"],
  ],
  "kn": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32ಸಾ", "4.32 ಸಾವಿರ"],
    ["54321", "54.3ಸಾ", "54.3 ಸಾವಿರ"],
    ["654321", "654ಸಾ", "654 ಸಾವಿರ"],
    ["7654321", "7.65ಮಿ", "7.65 ಮಿಲಿಯನ್"],
    ["87654321", "87.7ಮಿ", "87.7 ಮಿಲಿಯನ್"],
    ["987654321", "988ಮಿ", "988 ಮಿಲಿಯನ್"],
    ["1087654321", "1.09ಬಿ", "1.09 ಬಿಲಿಯನ್"],
    ["11987654321", "12ಬಿ", "12 ಬಿಲಿಯನ್"],
    ["129987654321", "130ಬಿ", "130 ಬಿಲಿಯನ್"],
    ["1398987654321", "1.4ಟ್ರಿ", "1.4 ಟ್ರಿಲಿಯನ್‌"],
    ["14987987654321", "15ಟ್ರಿ", "15 ಟ್ರಿಲಿಯನ್‌"],
    ["159876987654321", "160ಟ್ರಿ", "160 ಟ್ರಿಲಿಯನ್‌"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10ಸಾ", "10 ಸಾವಿರ"],
    ["99999", "100ಸಾ", "100 ಸಾವಿರ"],
    ["99999", "100ಸಾ", "100 ಸಾವಿರ"],
    ["999999", "1ಮಿ", "1 ಮಿಲಿಯನ್"],
    ["9999999", "10ಮಿ", "10 ಮಿಲಿಯನ್"],
    ["99999999", "100ಮಿ", "100 ಮಿಲಿಯನ್"],
    ["9994", "9.99ಸಾ", "9.99 ಸಾವಿರ"],
    ["99944", "99.9ಸಾ", "99.9 ಸಾವಿರ"],
    ["999444", "999ಸಾ", "999 ಸಾವಿರ"],
    ["9994444", "9.99ಮಿ", "9.99 ಮಿಲಿಯನ್"],
    ["999444444", "999ಮಿ", "999 ಮಿಲಿಯನ್"],
    ["9994444444", "9.99ಬಿ", "9.99 ಬಿಲಿಯನ್"],
  ],
  "ko": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32천", "4.32천"],
    ["54321", "5.43만", "5.43만"],
    ["654321", "65.4만", "65.4만"],
    ["7654321", "765만", "765만"],
    ["87654321", "8770만", "8770만"],
    ["987654321", "9.88억", "9.88억"],
    ["1087654321", "10.9억", "10.9억"],
    ["11987654321", "120억", "120억"],
    ["129987654321", "1300억", "1300억"],
    ["1398987654321", "1.4조", "1.4조"],
    ["14987987654321", "15조", "15조"],
    ["159876987654321", "160조", "160조"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "1만", "1만"],
    ["99999", "10만", "10만"],
    ["99999", "10만", "10만"],
    ["999999", "100만", "100만"],
    ["9999999", "1000만", "1000만"],
    ["99999999", "1억", "1억"],
    ["9994", "9.99천", "9.99천"],
    ["99944", "9.99만", "9.99만"],
    ["999444", "99.9만", "99.9만"],
    ["9994444", "999만", "999만"],
    ["999444444", "9.99억", "9.99억"],
    ["9994444444", "99.9억", "99.9억"],
  ],
  "ky": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 миӊ", "4,32 миӊ"],
    ["54321", "54,3 миӊ", "54,3 миӊ"],
    ["654321", "654 миӊ", "654 миӊ"],
    ["7654321", "7,65 млн", "7,65 миллион"],
    ["87654321", "87,7 млн", "87,7 миллион"],
    ["987654321", "988 млн", "988 миллион"],
    ["1087654321", "1,09 млд", "1,09 миллиард"],
    ["11987654321", "12 млд", "12 миллиард"],
    ["129987654321", "130 млд", "130 миллиард"],
    ["1398987654321", "1,4 трлн", "1,4 триллион"],
    ["14987987654321", "15 трлн", "15 триллион"],
    ["159876987654321", "160 трлн", "160 триллион"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 миӊ", "10 миӊ"],
    ["99999", "100 миӊ", "100 миӊ"],
    ["99999", "100 миӊ", "100 миӊ"],
    ["999999", "1 млн", "1 миллион"],
    ["9999999", "10 млн", "10 миллион"],
    ["99999999", "100 млн", "100 миллион"],
    ["9994", "9,99 миӊ", "9,99 миӊ"],
    ["99944", "99,9 миӊ", "99,9 миӊ"],
    ["999444", "999 миӊ", "999 миӊ"],
    ["9994444", "9,99 млн", "9,99 миллион"],
    ["999444444", "999 млн", "999 миллион"],
    ["9994444444", "9,99 млд", "9,99 миллиард"],
  ],
  "ln": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32K", "4,32K"],
    ["54321", "54,3K", "54,3K"],
    ["654321", "654K", "654K"],
    ["7654321", "7,65M", "7,65M"],
    ["87654321", "87,7M", "87,7M"],
    ["987654321", "988M", "988M"],
    ["1087654321", "1,09G", "1,09G"],
    ["11987654321", "12G", "12G"],
    ["129987654321", "130G", "130G"],
    ["1398987654321", "1,4T", "1,4T"],
    ["14987987654321", "15T", "15T"],
    ["159876987654321", "160T", "160T"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10K"],
    ["99999", "100K", "100K"],
    ["99999", "100K", "100K"],
    ["999999", "1M", "1M"],
    ["9999999", "10M", "10M"],
    ["99999999", "100M", "100M"],
    ["9994", "9,99K", "9,99K"],
    ["99944", "99,9K", "99,9K"],
    ["999444", "999K", "999K"],
    ["9994444", "9,99M", "9,99M"],
    ["999444444", "999M", "999M"],
    ["9994444444", "9,99G", "9,99G"],
  ],
  "lo": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 ພັນ", "4,32 ພັນ"],
    ["54321", "54,3 ພັນ", "54,3 ພັນ"],
    ["654321", "654 ກີບ", "6,54 ແສນ"],
    ["7654321", "7,65 ລ້ານ", "7,65 ລ້ານ"],
    ["87654321", "87,7 ລ້ານ", "87,7 ລ້ານ"],
    ["987654321", "988 ລ້ານ", "988 ລ້ານ"],
    ["1087654321", "1,09 ຕື້", "1,09 ຕື້"],
    ["11987654321", "12 ຕື້", "12 ຕື້"],
    ["129987654321", "130 ຕື້", "130 ຕື້"],
    ["1398987654321", "1,4 ລ້ານລ້ານ", "1,4 ລ້ານລ້ານ"],
    ["14987987654321", "15ລລ", "15 ລ້ານລ້ານ"],
    ["159876987654321", "160ລລ", "160 ລ້ານລ້ານ"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 ພັນ", "10 ພັນ"],
    ["99999", "100 ກີບ", "1 ແສນ"],
    ["99999", "100 ກີບ", "1 ແສນ"],
    ["999999", "1 ລ້ານ", "1 ລ້ານ"],
    ["9999999", "10 ລ້ານ", "10 ລ້ານ"],
    ["99999999", "100 ລ້ານ", "100 ລ້ານ"],
    ["9994", "9,99 ພັນ", "9,99 ພັນ"],
    ["99944", "99,9 ພັນ", "99,9 ພັນ"],
    ["999444", "999 ກີບ", "9,99 ແສນ"],
    ["9994444", "9,99 ລ້ານ", "9,99 ລ້ານ"],
    ["999444444", "999 ລ້ານ", "999 ລ້ານ"],
    ["9994444444", "9,99 ຕື້", "9,99 ຕື້"],
  ],
  "lt": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 tūkst.", "4,32 tūkstančio"],
    ["54321", "54,3 tūkst.", "54,3 tūkstančio"],
    ["654321", "654 tūkst.", "654 tūkstančiai"],
    ["7654321", "7,65 mln.", "7,65 milijono"],
    ["87654321", "87,7 mln.", "87,7 milijono"],
    ["987654321", "988 mln.", "988 milijonai"],
    ["1087654321", "1,09 mlrd.", "1,09 milijardo"],
    ["11987654321", "12 mlrd.", "12 milijardų"],
    ["129987654321", "130 mlrd.", "130 milijardų"],
    ["1398987654321", "1,4 trln.", "1,4 trilijono"],
    ["14987987654321", "15 trln.", "15 trilijonų"],
    ["159876987654321", "160 trln.", "160 trilijonų"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 tūkst.", "10 tūkstančių"],
    ["99999", "100 tūkst.", "100 tūkstančių"],
    ["99999", "100 tūkst.", "100 tūkstančių"],
    ["999999", "1 mln.", "1 milijonas"],
    ["9999999", "10 mln.", "10 milijonų"],
    ["99999999", "100 mln.", "100 milijonų"],
    ["9994", "9,99 tūkst.", "9,99 tūkstančio"],
    ["99944", "99,9 tūkst.", "99,9 tūkstančio"],
    ["999444", "999 tūkst.", "999 tūkstančiai"],
    ["9994444", "9,99 mln.", "9,99 milijono"],
    ["999444444", "999 mln.", "999 milijonai"],
    ["9994444444", "9,99 mlrd.", "9,99 milijardo"],
  ],
  "lv": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 tūkst.", "4,32 tūkstoši"],
    ["54321", "54,3 tūkst.", "54,3 tūkstoši"],
    ["654321", "654 tūkst.", "654 tūkstoši"],
    ["7654321", "7,65 milj.", "7,65 miljoni"],
    ["87654321", "87,7 milj.", "87,7 miljoni"],
    ["987654321", "988 milj.", "988 miljoni"],
    ["1087654321", "1,09 mljrd.", "1,09 miljardi"],
    ["11987654321", "12 mljrd.", "12 miljardi"],
    ["129987654321", "130 mljrd.", "130 miljardi"],
    ["1398987654321", "1,4 trilj.", "1,4 triljoni"],
    ["14987987654321", "15 trilj.", "15 triljoni"],
    ["159876987654321", "160 trilj.", "160 triljoni"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 tūkst.", "10 tūkstoši"],
    ["99999", "100 tūkst.", "100 tūkstoši"],
    ["99999", "100 tūkst.", "100 tūkstoši"],
    ["999999", "1 milj.", "1 miljons"],
    ["9999999", "10 milj.", "10 miljoni"],
    ["99999999", "100 milj.", "100 miljoni"],
    ["9994", "9,99 tūkst.", "9,99 tūkstoši"],
    ["99944", "99,9 tūkst.", "99,9 tūkstoši"],
    ["999444", "999 tūkst.", "999 tūkstoši"],
    ["9994444", "9,99 milj.", "9,99 miljoni"],
    ["999444444", "999 milj.", "999 miljoni"],
    ["9994444444", "9,99 mljrd.", "9,99 miljardi"],
  ],
  "mk": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 илј.", "4,32 илјади"],
    ["54321", "54,3 илј.", "54,3 илјади"],
    ["654321", "654 илј.", "654 илјади"],
    ["7654321", "7,65 мил.", "7,65 милиони"],
    ["87654321", "87,7 мил.", "87,7 милиони"],
    ["987654321", "988 М", "988 милиони"],
    ["1087654321", "1,09 милј.", "1,09 милијарди"],
    ["11987654321", "12 милј.", "12 милијарди"],
    ["129987654321", "130 ми.", "130 милијарди"],
    ["1398987654321", "1,4 бил.", "1,4 билиони"],
    ["14987987654321", "15 бил.", "15 билиони"],
    ["159876987654321", "160 бил.", "160 билиони"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 илј.", "10 илјади"],
    ["99999", "100 илј.", "100 илјади"],
    ["99999", "100 илј.", "100 илјади"],
    ["999999", "1 мил.", "1 милион"],
    ["9999999", "10 мил.", "10 милиони"],
    ["99999999", "100 М", "100 милиони"],
    ["9994", "9,99 илј.", "9,99 илјади"],
    ["99944", "99,9 илј.", "99,9 илјади"],
    ["999444", "999 илј.", "999 илјади"],
    ["9994444", "9,99 мил.", "9,99 милиони"],
    ["999444444", "999 М", "999 милиони"],
    ["9994444444", "9,99 милј.", "9,99 милијарди"],
  ],
  "ml": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32K", "4.32 ആയിരം"],
    ["54321", "54.3K", "54.3 ആയിരം"],
    ["654321", "654K", "654 ആയിരം"],
    ["7654321", "7.65M", "7.65 ദശലക്ഷം"],
    ["87654321", "87.7M", "87.7 ദശലക്ഷം"],
    ["987654321", "988M", "988 ദശലക്ഷം"],
    ["1087654321", "1.09B", "1.09 ലക്ഷം കോടി"],
    ["11987654321", "12B", "12 ലക്ഷം കോടി"],
    ["129987654321", "130B", "130 ലക്ഷം കോടി"],
    ["1398987654321", "1.4T", "1.4 ട്രില്യൺ"],
    ["14987987654321", "15T", "15 ട്രില്യൺ"],
    ["159876987654321", "160T", "160 ട്രില്യൺ"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 ആയിരം"],
    ["99999", "100K", "100 ആയിരം"],
    ["99999", "100K", "100 ആയിരം"],
    ["999999", "1M", "1 ദശലക്ഷം"],
    ["9999999", "10M", "10 ദശലക്ഷം"],
    ["99999999", "100M", "100 ദശലക്ഷം"],
    ["9994", "9.99K", "9.99 ആയിരം"],
    ["99944", "99.9K", "99.9 ആയിരം"],
    ["999444", "999K", "999 ആയിരം"],
    ["9994444", "9.99M", "9.99 ദശലക്ഷം"],
    ["999444444", "999M", "999 ദശലക്ഷം"],
    ["9994444444", "9.99B", "9.99 ലക്ഷം കോടി"],
  ],
  "mn": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32мянга", "4.32 мянга"],
    ["54321", "54.3мянга", "54.3 мянга"],
    ["654321", "654мянга", "654 мянга"],
    ["7654321", "7.65сая", "7.65 сая"],
    ["87654321", "87.7сая", "87.7 сая"],
    ["987654321", "988сая", "988 сая"],
    ["1087654321", "1.09тэрбум", "1.09 тэрбум"],
    ["11987654321", "12тэрбум", "12 тэрбум"],
    ["129987654321", "130Т", "130 тэрбум"],
    ["1398987654321", "1.4ИН", "1.4 их наяд"],
    ["14987987654321", "15ИН", "15 их наяд"],
    ["159876987654321", "160ИН", "160 их наяд"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10мянга", "10 мянга"],
    ["99999", "100мянга", "100 мянга"],
    ["99999", "100мянга", "100 мянга"],
    ["999999", "1сая", "1 сая"],
    ["9999999", "10сая", "10 сая"],
    ["99999999", "100сая", "100 сая"],
    ["9994", "9.99мянга", "9.99 мянга"],
    ["99944", "99.9мянга", "99.9 мянга"],
    ["999444", "999мянга", "999 мянга"],
    ["9994444", "9.99сая", "9.99 сая"],
    ["999444444", "999сая", "999 сая"],
    ["9994444444", "9.99тэрбум", "9.99 тэрбум"],
  ],
  "mr": [
    ["1", "१", "१"],
    ["21", "२१", "२१"],
    ["321", "३२१", "३२१"],
    ["4321", "४.३२ ह", "४.३२ हजार"],
    ["54321", "५४.३ ह", "५४.३ हजार"],
    ["654321", "६.५४ लाख", "६.५४ लाख"],
    ["7654321", "७६.५ लाख", "७६.५ लाख"],
    ["87654321", "८.७७ कोटी", "८.७७ कोटी"],
    ["987654321", "९८.८ कोटी", "९८.८ कोटी"],
    ["1087654321", "१.०९ अब्ज", "१.०९ अब्ज"],
    ["11987654321", "१२ अब्ज", "१२ अब्ज"],
    ["129987654321", "१.३ खर्व", "१.३ खर्व"],
    ["1398987654321", "१४ खर्व", "१४ खर्व"],
    ["14987987654321", "१.५ पद्म", "१.५ पद्म"],
    ["159876987654321", "१६ पद्म", "१६ पद्म"],
    ["9", "९", "९"],
    ["99", "९९", "९९"],
    ["999", "९९९", "९९९"],
    ["9999", "१० ह", "१० हजार"],
    ["99999", "१ लाख", "१ लाख"],
    ["99999", "१ लाख", "१ लाख"],
    ["999999", "१० लाख", "१० लाख"],
    ["9999999", "१ कोटी", "१ कोटी"],
    ["99999999", "१० कोटी", "१० कोटी"],
    ["9994", "९.९९ ह", "९.९९ हजार"],
    ["99944", "९९.९ ह", "९९.९ हजार"],
    ["999444", "९.९९ लाख", "९.९९ लाख"],
    ["9994444", "९९.९ लाख", "९९.९ लाख"],
    ["999444444", "९९.९ कोटी", "९९.९ कोटी"],
    ["9994444444", "९.९९ अब्ज", "९.९९ अब्ज"],
  ],
  "ms": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32K", "4.32 ribu"],
    ["54321", "54.3K", "54.3 ribu"],
    ["654321", "654K", "654 ribu"],
    ["7654321", "7.65J", "7.65 juta"],
    ["87654321", "87.7J", "87.7 juta"],
    ["987654321", "988J", "988 juta"],
    ["1087654321", "1.09B", "1.09 bilion"],
    ["11987654321", "12B", "12 bilion"],
    ["129987654321", "130B", "130 bilion"],
    ["1398987654321", "1.4T", "1.4 trilion"],
    ["14987987654321", "15T", "15 trilion"],
    ["159876987654321", "160T", "160 trilion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 ribu"],
    ["99999", "100K", "100 ribu"],
    ["99999", "100K", "100 ribu"],
    ["999999", "1J", "1 juta"],
    ["9999999", "10J", "10 juta"],
    ["99999999", "100J", "100 juta"],
    ["9994", "9.99K", "9.99 ribu"],
    ["99944", "99.9K", "99.9 ribu"],
    ["999444", "999K", "999 ribu"],
    ["9994444", "9.99J", "9.99 juta"],
    ["999444444", "999J", "999 juta"],
    ["9994444444", "9.99B", "9.99 bilion"],
  ],
  "mt": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32K", "4.32K"],
    ["54321", "54.3K", "54.3K"],
    ["654321", "654K", "654K"],
    ["7654321", "7.65M", "7.65M"],
    ["87654321", "87.7M", "87.7M"],
    ["987654321", "988M", "988M"],
    ["1087654321", "1.09G", "1.09G"],
    ["11987654321", "12G", "12G"],
    ["129987654321", "130G", "130G"],
    ["1398987654321", "1.4T", "1.4T"],
    ["14987987654321", "15T", "15T"],
    ["159876987654321", "160T", "160T"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10K"],
    ["99999", "100K", "100K"],
    ["99999", "100K", "100K"],
    ["999999", "1M", "1M"],
    ["9999999", "10M", "10M"],
    ["99999999", "100M", "100M"],
    ["9994", "9.99K", "9.99K"],
    ["99944", "99.9K", "99.9K"],
    ["999444", "999K", "999K"],
    ["9994444", "9.99M", "9.99M"],
    ["999444444", "999M", "999M"],
    ["9994444444", "9.99G", "9.99G"],
  ],
  "my": [
    ["1", "၁", "၁"],
    ["21", "၂၁", "၂၁"],
    ["321", "၃၂၁", "၃၂၁"],
    ["4321", "၄.၃၂ထောင်", "၄.၃၂ထောင်"],
    ["54321", "၅.၄၃သောင်း", "၅.၄၃သောင်း"],
    ["654321", "၆.၅၄သိန်း", "၆.၅၄သိန်း"],
    ["7654321", "၇.၆၅သန်း", "၇.၆၅သန်း"],
    ["87654321", "၈.၇၇ကုဋေ", "၈.၇၇ကုဋေ"],
    ["987654321", "၉၈.၈ကုဋေ", "၉၈.၈ကုဋေ"],
    ["1087654321", "ကုဋေ၁၀၉", "ကုဋေ၁၀၉"],
    ["11987654321", "ကုဋေ၁.၂ထ", "ကုဋေ၁၂၀၀"],
    ["129987654321", "ကုဋေ၁.၃သ", "ကုဋေ၁.၃သောင်း"],
    ["1398987654321", "ဋေ၁.၄သိန်း", "ကုဋေ၁.၄သိန်း"],
    ["14987987654321", "ဋေ၁.၅သန်း", "ကုဋေ၁.၅သန်း"],
    ["159876987654321", "၁.၆ကောဋိ", "၁.၆ကောဋိ"],
    ["9", "၉", "၉"],
    ["99", "၉၉", "၉၉"],
    ["999", "၉၉၉", "၉၉၉"],
    ["9999", "၁သောင်း", "၁သောင်း"],
    ["99999", "၁သိန်း", "၁သိန်း"],
    ["99999", "၁သိန်း", "၁သိန်း"],
    ["999999", "၁သန်း", "၁သန်း"],
    ["9999999", "၁ကုဋေ", "၁ကုဋေ"],
    ["99999999", "၁၀ကုဋေ", "၁၀ကုဋေ"],
    ["9994", "၉.၉၉ထောင်", "၉.၉၉ထောင်"],
    ["99944", "၉.၉၉သောင်း", "၉.၉၉သောင်း"],
    ["999444", "၉.၉၉သိန်း", "၉.၉၉သိန်း"],
    ["9994444", "၉.၉၉သန်း", "၉.၉၉သန်း"],
    ["999444444", "၉၉.၉ကုဋေ", "၉၉.၉ကုဋေ"],
    ["9994444444", "ကုဋေ၉၉၉", "ကုဋေ၉၉၉"],
  ],
  "nb": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32k", "4,32 tusen"],
    ["54321", "54,3k", "54,3 tusen"],
    ["654321", "654k", "654 tusen"],
    ["7654321", "7,65 mill", "7,65 millioner"],
    ["87654321", "87,7 mill", "87,7 millioner"],
    ["987654321", "988 mill", "988 millioner"],
    ["1087654321", "1,09 mrd", "1,09 milliarder"],
    ["11987654321", "12 mrd", "12 milliarder"],
    ["129987654321", "130 mrd", "130 milliarder"],
    ["1398987654321", "1,4 bill", "1,4 billioner"],
    ["14987987654321", "15 bill", "15 billioner"],
    ["159876987654321", "160 bill", "160 billioner"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10k", "10 tusen"],
    ["99999", "100k", "100 tusen"],
    ["99999", "100k", "100 tusen"],
    ["999999", "1 mill", "1 million"],
    ["9999999", "10 mill", "10 millioner"],
    ["99999999", "100 mill", "100 millioner"],
    ["9994", "9,99k", "9,99 tusen"],
    ["99944", "99,9k", "99,9 tusen"],
    ["999444", "999k", "999 tusen"],
    ["9994444", "9,99 mill", "9,99 millioner"],
    ["999444444", "999 mill", "999 millioner"],
    ["9994444444", "9,99 mrd", "9,99 milliarder"],
  ],
  "ne": [
    ["1", "१", "१"],
    ["21", "२१", "२१"],
    ["321", "३२१", "३२१"],
    ["4321", "४.३२ हजार", "४.३२ हजार"],
    ["54321", "५४.३ हजार", "५४.३ हजार"],
    ["654321", "६.५४ लाख", "६.५४ लाख"],
    ["7654321", "७६.५ लाख", "७.६५ करोड"],
    ["87654321", "८.७७ करोड", "८७.७ करोड"],
    ["987654321", "९८.८ करोड", "९८८ करोड"],
    ["1087654321", "१.०९ अरब", "१.०९ अरब"],
    ["11987654321", "१२ अरब", "१२ अरब"],
    ["129987654321", "१.३ खरब", "१३० अरब"],
    ["1398987654321", "१४ खरब", "१४ खरब"],
    ["14987987654321", "१.५ शंख", "१.५ शंख"],
    ["159876987654321", "१६ शंख", "१६ शंख"],
    ["9", "९", "९"],
    ["99", "९९", "९९"],
    ["999", "९९९", "९९९"],
    ["9999", "१० हजार", "१० हजार"],
    ["99999", "१ लाख", "१ लाख"],
    ["99999", "१ लाख", "१ लाख"],
    ["999999", "१० लाख", "१ करोड"],
    ["9999999", "१ करोड", "१० करोड"],
    ["99999999", "१० करोड", "१०० करोड"],
    ["9994", "९.९९ हजार", "९.९९ हजार"],
    ["99944", "९९.९ हजार", "९९.९ हजार"],
    ["999444", "९.९९ लाख", "९.९९ लाख"],
    ["9994444", "९९.९ लाख", "९.९९ करोड"],
    ["999444444", "९९.९ करोड", "९९९ करोड"],
    ["9994444444", "९.९९ अरब", "९.९९ अरब"],
  ],
  "nl": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32K", "4,32 duizend"],
    ["54321", "54,3K", "54,3 duizend"],
    ["654321", "654K", "654 duizend"],
    ["7654321", "7,65 mln.", "7,65 miljoen"],
    ["87654321", "87,7 mln.", "87,7 miljoen"],
    ["987654321", "988 mln.", "988 miljoen"],
    ["1087654321", "1,09 mld.", "1,09 miljard"],
    ["11987654321", "12 mld.", "12 miljard"],
    ["129987654321", "130 mld.", "130 miljard"],
    ["1398987654321", "1,4 bln.", "1,4 biljoen"],
    ["14987987654321", "15 bln.", "15 biljoen"],
    ["159876987654321", "160 bln.", "160 biljoen"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 duizend"],
    ["99999", "100K", "100 duizend"],
    ["99999", "100K", "100 duizend"],
    ["999999", "1 mln.", "1 miljoen"],
    ["9999999", "10 mln.", "10 miljoen"],
    ["99999999", "100 mln.", "100 miljoen"],
    ["9994", "9,99K", "9,99 duizend"],
    ["99944", "99,9K", "99,9 duizend"],
    ["999444", "999K", "999 duizend"],
    ["9994444", "9,99 mln.", "9,99 miljoen"],
    ["999444444", "999 mln.", "999 miljoen"],
    ["9994444444", "9,99 mld.", "9,99 miljard"],
  ],
  "no": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32k", "4,32 tusen"],
    ["54321", "54,3k", "54,3 tusen"],
    ["654321", "654k", "654 tusen"],
    ["7654321", "7,65 mill", "7,65 millioner"],
    ["87654321", "87,7 mill", "87,7 millioner"],
    ["987654321", "988 mill", "988 millioner"],
    ["1087654321", "1,09 mrd", "1,09 milliarder"],
    ["11987654321", "12 mrd", "12 milliarder"],
    ["129987654321", "130 mrd", "130 milliarder"],
    ["1398987654321", "1,4 bill", "1,4 billioner"],
    ["14987987654321", "15 bill", "15 billioner"],
    ["159876987654321", "160 bill", "160 billioner"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10k", "10 tusen"],
    ["99999", "100k", "100 tusen"],
    ["99999", "100k", "100 tusen"],
    ["999999", "1 mill", "1 million"],
    ["9999999", "10 mill", "10 millioner"],
    ["99999999", "100 mill", "100 millioner"],
    ["9994", "9,99k", "9,99 tusen"],
    ["99944", "99,9k", "99,9 tusen"],
    ["999444", "999k", "999 tusen"],
    ["9994444", "9,99 mill", "9,99 millioner"],
    ["999444444", "999 mill", "999 millioner"],
    ["9994444444", "9,99 mrd", "9,99 milliarder"],
  ],
  "no_NO": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32k", "4,32 tusen"],
    ["54321", "54,3k", "54,3 tusen"],
    ["654321", "654k", "654 tusen"],
    ["7654321", "7,65 mill", "7,65 millioner"],
    ["87654321", "87,7 mill", "87,7 millioner"],
    ["987654321", "988 mill", "988 millioner"],
    ["1087654321", "1,09 mrd", "1,09 milliarder"],
    ["11987654321", "12 mrd", "12 milliarder"],
    ["129987654321", "130 mrd", "130 milliarder"],
    ["1398987654321", "1,4 bill", "1,4 billioner"],
    ["14987987654321", "15 bill", "15 billioner"],
    ["159876987654321", "160 bill", "160 billioner"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10k", "10 tusen"],
    ["99999", "100k", "100 tusen"],
    ["99999", "100k", "100 tusen"],
    ["999999", "1 mill", "1 million"],
    ["9999999", "10 mill", "10 millioner"],
    ["99999999", "100 mill", "100 millioner"],
    ["9994", "9,99k", "9,99 tusen"],
    ["99944", "99,9k", "99,9 tusen"],
    ["999444", "999k", "999 tusen"],
    ["9994444", "9,99 mill", "9,99 millioner"],
    ["999444444", "999 mill", "999 millioner"],
    ["9994444444", "9,99 mrd", "9,99 milliarder"],
  ],
  "or": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32ହ", "4.32 ହଜାର"],
    ["54321", "54.3ହ", "54.3 ହଜାର"],
    ["654321", "654ହ", "654 ହଜାର"],
    ["7654321", "7.65ନି", "7.65 ନିୟୁତ"],
    ["87654321", "87.7ନି", "87.7 ନିୟୁତ"],
    ["987654321", "988ନି", "988 ନିୟୁତ"],
    ["1087654321", "1.09ବି", "1.09 ଶହକୋଟି"],
    ["11987654321", "12ବି", "12 ଶହକୋଟି"],
    ["129987654321", "130ବି", "130 ଶହକୋଟି"],
    ["1398987654321", "1.4ଟ୍ରି", "1.4 ଲକ୍ଷକୋଟି"],
    ["14987987654321", "15ଟ୍ରି", "15 ଲକ୍ଷକୋଟି"],
    ["159876987654321", "160ଟ୍ରି", "160 ଲକ୍ଷକୋଟି"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10ହ", "10 ହଜାର"],
    ["99999", "100ହ", "100 ହଜାର"],
    ["99999", "100ହ", "100 ହଜାର"],
    ["999999", "1ନି", "1 ନିୟୁତ"],
    ["9999999", "10ନି", "10 ନିୟୁତ"],
    ["99999999", "100ନି", "100 ନିୟୁତ"],
    ["9994", "9.99ହ", "9.99 ହଜାର"],
    ["99944", "99.9ହ", "99.9 ହଜାର"],
    ["999444", "999ହ", "999 ହଜାର"],
    ["9994444", "9.99ନି", "9.99 ନିୟୁତ"],
    ["999444444", "999ନି", "999 ନିୟୁତ"],
    ["9994444444", "9.99ବି", "9.99 ଶହକୋଟି"],
  ],
  "pa": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32 ਹਜ਼ਾਰ", "4.32 ਹਜ਼ਾਰ"],
    ["54321", "54.3 ਹਜ਼ਾਰ", "54.3 ਹਜ਼ਾਰ"],
    ["654321", "6.54 ਲੱਖ", "6.54 ਲੱਖ"],
    ["7654321", "76.5 ਲੱਖ", "76.5 ਲੱਖ"],
    ["87654321", "8.77 ਕਰੋੜ", "8.77 ਕਰੋੜ"],
    ["987654321", "98.8 ਕਰੋੜ", "98.8 ਕਰੋੜ"],
    ["1087654321", "1.09 ਅਰਬ", "1.09 ਅਰਬ"],
    ["11987654321", "12 ਅਰਬ", "12 ਅਰਬ"],
    ["129987654321", "1.3 ਖਰਬ", "1.3 ਖਰਬ"],
    ["1398987654321", "14 ਖਰਬ", "14 ਖਰਬ"],
    ["14987987654321", "1.5 ਨੀਲ", "1.5 ਨੀਲ"],
    ["159876987654321", "16 ਨੀਲ", "16 ਨੀਲ"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 ਹਜ਼ਾਰ", "10 ਹਜ਼ਾਰ"],
    ["99999", "1 ਲੱਖ", "1 ਲੱਖ"],
    ["99999", "1 ਲੱਖ", "1 ਲੱਖ"],
    ["999999", "10 ਲੱਖ", "10 ਲੱਖ"],
    ["9999999", "1 ਕਰੋੜ", "1 ਕਰੋੜ"],
    ["99999999", "10 ਕਰੋੜ", "10 ਕਰੋੜ"],
    ["9994", "9.99 ਹਜ਼ਾਰ", "9.99 ਹਜ਼ਾਰ"],
    ["99944", "99.9 ਹਜ਼ਾਰ", "99.9 ਹਜ਼ਾਰ"],
    ["999444", "9.99 ਲੱਖ", "9.99 ਲੱਖ"],
    ["9994444", "99.9 ਲੱਖ", "99.9 ਲੱਖ"],
    ["999444444", "99.9 ਕਰੋੜ", "99.9 ਕਰੋੜ"],
    ["9994444444", "9.99 ਅਰਬ", "9.99 ਅਰਬ"],
  ],
  "pl": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 tys.", "4,32 tysiąca"],
    ["54321", "54,3 tys.", "54,3 tysiąca"],
    ["654321", "654 tys.", "654 tysiące"],
    ["7654321", "7,65 mln", "7,65 miliona"],
    ["87654321", "87,7 mln", "87,7 miliona"],
    ["987654321", "988 mln", "988 milionów"],
    ["1087654321", "1,09 mld", "1,09 miliarda"],
    ["11987654321", "12 mld", "12 miliardów"],
    ["129987654321", "130 mld", "130 miliardów"],
    ["1398987654321", "1,4 bln", "1,4 biliona"],
    ["14987987654321", "15 bln", "15 bilionów"],
    ["159876987654321", "160 bln", "160 bilionów"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 tys.", "10 tysięcy"],
    ["99999", "100 tys.", "100 tysięcy"],
    ["99999", "100 tys.", "100 tysięcy"],
    ["999999", "1 mln", "1 milion"],
    ["9999999", "10 mln", "10 milionów"],
    ["99999999", "100 mln", "100 milionów"],
    ["9994", "9,99 tys.", "9,99 tysiąca"],
    ["99944", "99,9 tys.", "99,9 tysiąca"],
    ["999444", "999 tys.", "999 tysięcy"],
    ["9994444", "9,99 mln", "9,99 miliona"],
    ["999444444", "999 mln", "999 milionów"],
    ["9994444444", "9,99 mld", "9,99 miliarda"],
  ],
  "pt": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 mil", "4,32 mil"],
    ["54321", "54,3 mil", "54,3 mil"],
    ["654321", "654 mil", "654 mil"],
    ["7654321", "7,65 mi", "7,65 milhões"],
    ["87654321", "87,7 mi", "87,7 milhões"],
    ["987654321", "988 mi", "988 milhões"],
    ["1087654321", "1,09 bi", "1,09 bilhão"],
    ["11987654321", "12 bi", "12 bilhões"],
    ["129987654321", "130 bi", "130 bilhões"],
    ["1398987654321", "1,4 tri", "1,4 trilhão"],
    ["14987987654321", "15 tri", "15 trilhões"],
    ["159876987654321", "160 tri", "160 trilhões"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 mil", "10 mil"],
    ["99999", "100 mil", "100 mil"],
    ["99999", "100 mil", "100 mil"],
    ["999999", "1 mi", "1 milhão"],
    ["9999999", "10 mi", "10 milhões"],
    ["99999999", "100 mi", "100 milhões"],
    ["9994", "9,99 mil", "9,99 mil"],
    ["99944", "99,9 mil", "99,9 mil"],
    ["999444", "999 mil", "999 mil"],
    ["9994444", "9,99 mi", "9,99 milhões"],
    ["999444444", "999 mi", "999 milhões"],
    ["9994444444", "9,99 bi", "9,99 bilhões"],
  ],
  "pt_BR": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 mil", "4,32 mil"],
    ["54321", "54,3 mil", "54,3 mil"],
    ["654321", "654 mil", "654 mil"],
    ["7654321", "7,65 mi", "7,65 milhões"],
    ["87654321", "87,7 mi", "87,7 milhões"],
    ["987654321", "988 mi", "988 milhões"],
    ["1087654321", "1,09 bi", "1,09 bilhão"],
    ["11987654321", "12 bi", "12 bilhões"],
    ["129987654321", "130 bi", "130 bilhões"],
    ["1398987654321", "1,4 tri", "1,4 trilhão"],
    ["14987987654321", "15 tri", "15 trilhões"],
    ["159876987654321", "160 tri", "160 trilhões"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 mil", "10 mil"],
    ["99999", "100 mil", "100 mil"],
    ["99999", "100 mil", "100 mil"],
    ["999999", "1 mi", "1 milhão"],
    ["9999999", "10 mi", "10 milhões"],
    ["99999999", "100 mi", "100 milhões"],
    ["9994", "9,99 mil", "9,99 mil"],
    ["99944", "99,9 mil", "99,9 mil"],
    ["999444", "999 mil", "999 mil"],
    ["9994444", "9,99 mi", "9,99 milhões"],
    ["999444444", "999 mi", "999 milhões"],
    ["9994444444", "9,99 bi", "9,99 bilhões"],
  ],
  "pt_PT": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 mil", "4,32 mil"],
    ["54321", "54,3 mil", "54,3 mil"],
    ["654321", "654 mil", "654 mil"],
    ["7654321", "7,65 M", "7,65 milhões"],
    ["87654321", "87,7 M", "87,7 milhões"],
    ["987654321", "988 M", "988 milhões"],
    ["1087654321", "1,09 mM", "1,09 mil milhões"],
    ["11987654321", "12 mM", "12 mil milhões"],
    ["129987654321", "130 mM", "130 mil milhões"],
    ["1398987654321", "1,4 Bi", "1,4 biliões"],
    ["14987987654321", "15 Bi", "15 biliões"],
    ["159876987654321", "160 Bi", "160 biliões"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 mil", "10 mil"],
    ["99999", "100 mil", "100 mil"],
    ["99999", "100 mil", "100 mil"],
    ["999999", "1 M", "1 milhão"],
    ["9999999", "10 M", "10 milhões"],
    ["99999999", "100 M", "100 milhões"],
    ["9994", "9,99 mil", "9,99 mil"],
    ["99944", "99,9 mil", "99,9 mil"],
    ["999444", "999 mil", "999 mil"],
    ["9994444", "9,99 M", "9,99 milhões"],
    ["999444444", "999 M", "999 milhões"],
    ["9994444444", "9,99 mM", "9,99 mil milhões"],
  ],
  "ro": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 K", "4,32 mii"],
    ["54321", "54,3 K", "54,3 mii"],
    ["654321", "654 K", "654 de mii"],
    ["7654321", "7,65 mil.", "7,65 milioane"],
    ["87654321", "87,7 mil.", "87,7 milioane"],
    ["987654321", "988 mil.", "988 de milioane"],
    ["1087654321", "1,09 mld.", "1,09 miliarde"],
    ["11987654321", "12 mld.", "12 miliarde"],
    ["129987654321", "130 mld.", "130 de miliarde"],
    ["1398987654321", "1,4 tril.", "1,4 trilioane"],
    ["14987987654321", "15 tril.", "15 trilioane"],
    ["159876987654321", "160 tril.", "160 de trilioane"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 K", "10 mii"],
    ["99999", "100 K", "100 de mii"],
    ["99999", "100 K", "100 de mii"],
    ["999999", "1 mil.", "1 milion"],
    ["9999999", "10 mil.", "10 milioane"],
    ["99999999", "100 mil.", "100 de milioane"],
    ["9994", "9,99 K", "9,99 mii"],
    ["99944", "99,9 K", "99,9 mii"],
    ["999444", "999 K", "999 de mii"],
    ["9994444", "9,99 mil.", "9,99 milioane"],
    ["999444444", "999 mil.", "999 de milioane"],
    ["9994444444", "9,99 mld.", "9,99 miliarde"],
  ],
  "ru": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 тыс.", "4,32 тысячи"],
    ["54321", "54,3 тыс.", "54,3 тысячи"],
    ["654321", "654 тыс.", "654 тысячи"],
    ["7654321", "7,65 млн", "7,65 миллиона"],
    ["87654321", "87,7 млн", "87,7 миллиона"],
    ["987654321", "988 млн", "988 миллионов"],
    ["1087654321", "1,09 млрд", "1,09 миллиарда"],
    ["11987654321", "12 млрд", "12 миллиардов"],
    ["129987654321", "130 млрд", "130 миллиардов"],
    ["1398987654321", "1,4 трлн", "1,4 триллиона"],
    ["14987987654321", "15 трлн", "15 триллионов"],
    ["159876987654321", "160 трлн", "160 триллионов"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 тыс.", "10 тысяч"],
    ["99999", "100 тыс.", "100 тысяч"],
    ["99999", "100 тыс.", "100 тысяч"],
    ["999999", "1 млн", "1 миллион"],
    ["9999999", "10 млн", "10 миллионов"],
    ["99999999", "100 млн", "100 миллионов"],
    ["9994", "9,99 тыс.", "9,99 тысячи"],
    ["99944", "99,9 тыс.", "99,9 тысячи"],
    ["999444", "999 тыс.", "999 тысяч"],
    ["9994444", "9,99 млн", "9,99 миллиона"],
    ["999444444", "999 млн", "999 миллионов"],
    ["9994444444", "9,99 млрд", "9,99 миллиарда"],
  ],
  "si": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "ද4.32", "දහස 4.32"],
    ["54321", "ද54.3", "දහස 54.3"],
    ["654321", "ද654", "දහස 654"],
    ["7654321", "මි7.65", "මිලියන 7.65"],
    ["87654321", "මි87.7", "මිලියන 87.7"],
    ["987654321", "මි988", "මිලියන 988"],
    ["1087654321", "බි1.09", "බිලියන 1.09"],
    ["11987654321", "බි12", "බිලියන 12"],
    ["129987654321", "බි130", "බිලියන 130"],
    ["1398987654321", "ට්‍රි1.4", "ට්‍රිලියන 1.4"],
    ["14987987654321", "ට්‍රි15", "ට්‍රිලියන 15"],
    ["159876987654321", "ට්‍රි160", "ට්‍රිලියන 160"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "ද10", "දහස 10"],
    ["99999", "ද100", "දහස 100"],
    ["99999", "ද100", "දහස 100"],
    ["999999", "මි1", "මිලියන 1"],
    ["9999999", "මි10", "මිලියන 10"],
    ["99999999", "මි100", "මිලියන 100"],
    ["9994", "ද9.99", "දහස 9.99"],
    ["99944", "ද99.9", "දහස 99.9"],
    ["999444", "ද999", "දහස 999"],
    ["9994444", "මි9.99", "මිලියන 9.99"],
    ["999444444", "මි999", "මිලියන 999"],
    ["9994444444", "බි9.99", "බිලියන 9.99"],
  ],
  "sk": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 tis.", "4,32 tisíca"],
    ["54321", "54,3 tis.", "54,3 tisíca"],
    ["654321", "654 tis.", "654 tisíc"],
    ["7654321", "7,65 mil.", "7,65 milióna"],
    ["87654321", "87,7 mil.", "87,7 milióna"],
    ["987654321", "988 mil.", "988 miliónov"],
    ["1087654321", "1,09 mld.", "1,09 miliardy"],
    ["11987654321", "12 mld.", "12 miliárd"],
    ["129987654321", "130 mld.", "130 miliárd"],
    ["1398987654321", "1,4 bil.", "1,4 bilióna"],
    ["14987987654321", "15 bil.", "15 biliónov"],
    ["159876987654321", "160 bil.", "160 biliónov"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 tis.", "10 tisíc"],
    ["99999", "100 tis.", "100 tisíc"],
    ["99999", "100 tis.", "100 tisíc"],
    ["999999", "1 mil.", "1 milión"],
    ["9999999", "10 mil.", "10 miliónov"],
    ["99999999", "100 mil.", "100 miliónov"],
    ["9994", "9,99 tis.", "9,99 tisíca"],
    ["99944", "99,9 tis.", "99,9 tisíca"],
    ["999444", "999 tis.", "999 tisíc"],
    ["9994444", "9,99 mil.", "9,99 milióna"],
    ["999444444", "999 mil.", "999 miliónov"],
    ["9994444444", "9,99 mld.", "9,99 miliardy"],
  ],
  "sl": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 tis.", "4,32 tisoč"],
    ["54321", "54,3 tis.", "54,3 tisoč"],
    ["654321", "654 tis.", "654 tisoč"],
    ["7654321", "7,65 mio.", "7,65 milijone"],
    ["87654321", "87,7 mio.", "87,7 milijoni"],
    ["987654321", "988 mio.", "988 milijonov"],
    ["1087654321", "1,09 mrd.", "1,09 milijarde"],
    ["11987654321", "12 mrd.", "12 milijard"],
    ["129987654321", "130 mrd.", "130 milijard"],
    ["1398987654321", "1,4 bil.", "1,4 bilijoni"],
    ["14987987654321", "15 bil.", "15 bilijonov"],
    ["159876987654321", "160 bil.", "160 bilijonov"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 tis.", "10 tisoč"],
    ["99999", "100 tis.", "100 tisoč"],
    ["99999", "100 tis.", "100 tisoč"],
    ["999999", "1 mio.", "1 milijon"],
    ["9999999", "10 mio.", "10 milijonov"],
    ["99999999", "100 mio.", "100 milijonov"],
    ["9994", "9,99 tis.", "9,99 tisoč"],
    ["99944", "99,9 tis.", "99,9 tisoč"],
    ["999444", "999 tis.", "999 tisoč"],
    ["9994444", "9,99 mio.", "9,99 milijone"],
    ["999444444", "999 mio.", "999 milijonov"],
    ["9994444444", "9,99 mrd.", "9,99 milijarde"],
  ],
  "sq": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 mijë", "4,32 mijë"],
    ["54321", "54,3 mijë", "54,3 mijë"],
    ["654321", "654 mijë", "654 mijë"],
    ["7654321", "7,65 mln", "7,65 milion"],
    ["87654321", "87,7 mln", "87,7 milion"],
    ["987654321", "988 mln", "988 milion"],
    ["1087654321", "1,09 mld", "1,09 miliard"],
    ["11987654321", "12 mld", "12 miliard"],
    ["129987654321", "130 mld", "130 miliard"],
    ["1398987654321", "1,4 bln", "1,4 bilion"],
    ["14987987654321", "15 bln", "15 bilion"],
    ["159876987654321", "160 bln", "160 bilion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 mijë", "10 mijë"],
    ["99999", "100 mijë", "100 mijë"],
    ["99999", "100 mijë", "100 mijë"],
    ["999999", "1 mln", "1 milion"],
    ["9999999", "10 mln", "10 milion"],
    ["99999999", "100 mln", "100 milion"],
    ["9994", "9,99 mijë", "9,99 mijë"],
    ["99944", "99,9 mijë", "99,9 mijë"],
    ["999444", "999 mijë", "999 mijë"],
    ["9994444", "9,99 mln", "9,99 milion"],
    ["999444444", "999 mln", "999 milion"],
    ["9994444444", "9,99 mld", "9,99 miliard"],
  ],
  "sr": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 хиљ.", "4,32 хиљаде"],
    ["54321", "54,3 хиљ.", "54,3 хиљаде"],
    ["654321", "654 хиљ.", "654 хиљаде"],
    ["7654321", "7,65 мил.", "7,65 милиона"],
    ["87654321", "87,7 мил.", "87,7 милиона"],
    ["987654321", "988 мил.", "988 милиона"],
    ["1087654321", "1,09 млрд.", "1,09 милијарди"],
    ["11987654321", "12 млрд.", "12 милијарди"],
    ["129987654321", "130 млрд.", "130 милијарди"],
    ["1398987654321", "1,4 бил.", "1,4 билиона"],
    ["14987987654321", "15 бил.", "15 билиона"],
    ["159876987654321", "160 бил.", "160 билиона"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 хиљ.", "10 хиљада"],
    ["99999", "100 хиљ.", "100 хиљада"],
    ["99999", "100 хиљ.", "100 хиљада"],
    ["999999", "1 мил.", "1 милион"],
    ["9999999", "10 мил.", "10 милиона"],
    ["99999999", "100 мил.", "100 милиона"],
    ["9994", "9,99 хиљ.", "9,99 хиљада"],
    ["99944", "99,9 хиљ.", "99,9 хиљада"],
    ["999444", "999 хиљ.", "999 хиљада"],
    ["9994444", "9,99 мил.", "9,99 милиона"],
    ["999444444", "999 мил.", "999 милиона"],
    ["9994444444", "9,99 млрд.", "9,99 милијарди"],
  ],
  "sr_Latn": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 hilj.", "4,32 hiljade"],
    ["54321", "54,3 hilj.", "54,3 hiljade"],
    ["654321", "654 hilj.", "654 hiljade"],
    ["7654321", "7,65 mil.", "7,65 miliona"],
    ["87654321", "87,7 mil.", "87,7 miliona"],
    ["987654321", "988 mil.", "988 miliona"],
    ["1087654321", "1,09 mlrd.", "1,09 milijardi"],
    ["11987654321", "12 mlrd.", "12 milijardi"],
    ["129987654321", "130 mlrd.", "130 milijardi"],
    ["1398987654321", "1,4 bil.", "1,4 biliona"],
    ["14987987654321", "15 bil.", "15 biliona"],
    ["159876987654321", "160 bil.", "160 biliona"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 hilj.", "10 hiljada"],
    ["99999", "100 hilj.", "100 hiljada"],
    ["99999", "100 hilj.", "100 hiljada"],
    ["999999", "1 mil.", "1 milion"],
    ["9999999", "10 mil.", "10 miliona"],
    ["99999999", "100 mil.", "100 miliona"],
    ["9994", "9,99 hilj.", "9,99 hiljada"],
    ["99944", "99,9 hilj.", "99,9 hiljada"],
    ["999444", "999 hilj.", "999 hiljada"],
    ["9994444", "9,99 mil.", "9,99 miliona"],
    ["999444444", "999 mil.", "999 miliona"],
    ["9994444444", "9,99 mlrd.", "9,99 milijardi"],
  ],
  "sv": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 tn", "4,32 tusen"],
    ["54321", "54,3 tn", "54,3 tusen"],
    ["654321", "654 tn", "654 tusen"],
    ["7654321", "7,65 mn", "7,65 miljoner"],
    ["87654321", "87,7 mn", "87,7 miljoner"],
    ["987654321", "988 mn", "988 miljoner"],
    ["1087654321", "1,09 md", "1,09 miljarder"],
    ["11987654321", "12 md", "12 miljarder"],
    ["129987654321", "130 md", "130 miljarder"],
    ["1398987654321", "1,4 bn", "1,4 biljoner"],
    ["14987987654321", "15 bn", "15 biljoner"],
    ["159876987654321", "160 bn", "160 biljoner"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 tn", "10 tusen"],
    ["99999", "100 tn", "100 tusen"],
    ["99999", "100 tn", "100 tusen"],
    ["999999", "1 mn", "1 miljon"],
    ["9999999", "10 mn", "10 miljoner"],
    ["99999999", "100 mn", "100 miljoner"],
    ["9994", "9,99 tn", "9,99 tusen"],
    ["99944", "99,9 tn", "99,9 tusen"],
    ["999444", "999 tn", "999 tusen"],
    ["9994444", "9,99 mn", "9,99 miljoner"],
    ["999444444", "999 mn", "999 miljoner"],
    ["9994444444", "9,99 md", "9,99 miljarder"],
  ],
  "sw": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "elfu 4.32", "elfu 4.32"],
    ["54321", "elfu 54.3", "elfu 54.3"],
    ["654321", "elfu 654", "elfu 654"],
    ["7654321", "M7.65", "milioni 7.65"],
    ["87654321", "M87.7", "milioni 87.7"],
    ["987654321", "M988", "milioni 988"],
    ["1087654321", "B1.09", "bilioni 1.09"],
    ["11987654321", "B12", "bilioni 12"],
    ["129987654321", "B130", "bilioni 130"],
    ["1398987654321", "T1.4", "trilioni 1.4"],
    ["14987987654321", "T15", "trilioni 15"],
    ["159876987654321", "T160", "trilioni 160"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "elfu 10", "elfu 10"],
    ["99999", "elfu 100", "elfu 100"],
    ["99999", "elfu 100", "elfu 100"],
    ["999999", "M1", "milioni 1"],
    ["9999999", "M10", "milioni 10"],
    ["99999999", "M100", "milioni 100"],
    ["9994", "elfu 9.99", "elfu 9.99"],
    ["99944", "elfu 99.9", "elfu 99.9"],
    ["999444", "elfu 999", "elfu 999"],
    ["9994444", "M9.99", "milioni 9.99"],
    ["999444444", "M999", "milioni 999"],
    ["9994444444", "B9.99", "bilioni 9.99"],
  ],
  "ta": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32ஆ", "4.32 ஆயிரம்"],
    ["54321", "54.3ஆ", "54.3 ஆயிரம்"],
    ["654321", "654ஆ", "654 ஆயிரம்"],
    ["7654321", "7.65மி", "7.65 மில்லியன்"],
    ["87654321", "87.7மி", "87.7 மில்லியன்"],
    ["987654321", "988மி", "988 மில்லியன்"],
    ["1087654321", "1.09பி", "1.09 பில்லியன்"],
    ["11987654321", "12பி", "12 பில்லியன்"],
    ["129987654321", "130பி", "130 பில்லியன்"],
    ["1398987654321", "1.4டி", "1.4 டிரில்லியன்"],
    ["14987987654321", "15டி", "15 டிரில்லியன்"],
    ["159876987654321", "160டி", "160 டிரில்லியன்"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10ஆ", "10 ஆயிரம்"],
    ["99999", "100ஆ", "100 ஆயிரம்"],
    ["99999", "100ஆ", "100 ஆயிரம்"],
    ["999999", "1மி", "1 மில்லியன்"],
    ["9999999", "10மி", "10 மில்லியன்"],
    ["99999999", "100மி", "100 மில்லியன்"],
    ["9994", "9.99ஆ", "9.99 ஆயிரம்"],
    ["99944", "99.9ஆ", "99.9 ஆயிரம்"],
    ["999444", "999ஆ", "999 ஆயிரம்"],
    ["9994444", "9.99மி", "9.99 மில்லியன்"],
    ["999444444", "999மி", "999 மில்லியன்"],
    ["9994444444", "9.99பி", "9.99 பில்லியன்"],
  ],
  "te": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32వే", "4.32 వేలు"],
    ["54321", "54.3వే", "54.3 వేలు"],
    ["654321", "654వే", "654 వేలు"],
    ["7654321", "7.65మి", "7.65 మిలియన్లు"],
    ["87654321", "87.7మి", "87.7 మిలియన్లు"],
    ["987654321", "988మి", "988 మిలియన్లు"],
    ["1087654321", "1.09బి", "1.09 బిలియన్లు"],
    ["11987654321", "12బి", "12 బిలియన్లు"],
    ["129987654321", "130బి", "130 బిలియన్లు"],
    ["1398987654321", "1.4ట్రి", "1.4 ట్రిలియన్లు"],
    ["14987987654321", "15ట్రి", "15 ట్రిలియన్లు"],
    ["159876987654321", "160ట్రి", "160 ట్రిలియన్లు"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10వే", "10 వేలు"],
    ["99999", "100వే", "100 వేలు"],
    ["99999", "100వే", "100 వేలు"],
    ["999999", "1మి", "1 మిలియన్"],
    ["9999999", "10మి", "10 మిలియన్లు"],
    ["99999999", "100మి", "100 మిలియన్లు"],
    ["9994", "9.99వే", "9.99 వేలు"],
    ["99944", "99.9వే", "99.9 వేలు"],
    ["999444", "999వే", "999 వేలు"],
    ["9994444", "9.99మి", "9.99 మిలియన్లు"],
    ["999444444", "999మి", "999 మిలియన్లు"],
    ["9994444444", "9.99బి", "9.99 బిలియన్లు"],
  ],
  "th": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32K", "4.32 พัน"],
    ["54321", "54.3K", "5.43 หมื่น"],
    ["654321", "654K", "6.54 แสน"],
    ["7654321", "7.65M", "7.65 ล้าน"],
    ["87654321", "87.7M", "87.7 ล้าน"],
    ["987654321", "988M", "988 ล้าน"],
    ["1087654321", "1.09B", "1.09 พันล้าน"],
    ["11987654321", "12B", "1.2 หมื่นล้าน"],
    ["129987654321", "130B", "1.3 แสนล้าน"],
    ["1398987654321", "1.4T", "1.4 ล้านล้าน"],
    ["14987987654321", "15T", "15 ล้านล้าน"],
    ["159876987654321", "160T", "160 ล้านล้าน"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "1 หมื่น"],
    ["99999", "100K", "1 แสน"],
    ["99999", "100K", "1 แสน"],
    ["999999", "1M", "1 ล้าน"],
    ["9999999", "10M", "10 ล้าน"],
    ["99999999", "100M", "100 ล้าน"],
    ["9994", "9.99K", "9.99 พัน"],
    ["99944", "99.9K", "9.99 หมื่น"],
    ["999444", "999K", "9.99 แสน"],
    ["9994444", "9.99M", "9.99 ล้าน"],
    ["999444444", "999M", "999 ล้าน"],
    ["9994444444", "9.99B", "9.99 พันล้าน"],
  ],
  "tl": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32K", "4.32 libo"],
    ["54321", "54.3K", "54.3 libo"],
    ["654321", "654K", "654 na libo"],
    ["7654321", "7.65M", "7.65 milyon"],
    ["87654321", "87.7M", "87.7 milyon"],
    ["987654321", "988M", "988 milyon"],
    ["1087654321", "1.09B", "1.09 bilyon"],
    ["11987654321", "12B", "12 bilyon"],
    ["129987654321", "130B", "130 bilyon"],
    ["1398987654321", "1.4T", "1.4 na trilyon"],
    ["14987987654321", "15T", "15 trilyon"],
    ["159876987654321", "160T", "160 trilyon"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 libo"],
    ["99999", "100K", "100 libo"],
    ["99999", "100K", "100 libo"],
    ["999999", "1M", "1 milyon"],
    ["9999999", "10M", "10 milyon"],
    ["99999999", "100M", "100 milyon"],
    ["9994", "9.99K", "9.99 na libo"],
    ["99944", "99.9K", "99.9 na libo"],
    ["999444", "999K", "999 na libo"],
    ["9994444", "9.99M", "9.99 na milyon"],
    ["999444444", "999M", "999 na milyon"],
    ["9994444444", "9.99B", "9.99 na bilyon"],
  ],
  "tr": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 B", "4,32 bin"],
    ["54321", "54,3 B", "54,3 bin"],
    ["654321", "654 B", "654 bin"],
    ["7654321", "7,65 Mn", "7,65 milyon"],
    ["87654321", "87,7 Mn", "87,7 milyon"],
    ["987654321", "988 Mn", "988 milyon"],
    ["1087654321", "1,09 Mr", "1,09 milyar"],
    ["11987654321", "12 Mr", "12 milyar"],
    ["129987654321", "130 Mr", "130 milyar"],
    ["1398987654321", "1,4 Tn", "1,4 trilyon"],
    ["14987987654321", "15 Tn", "15 trilyon"],
    ["159876987654321", "160 Tn", "160 trilyon"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 B", "10 bin"],
    ["99999", "100 B", "100 bin"],
    ["99999", "100 B", "100 bin"],
    ["999999", "1 Mn", "1 milyon"],
    ["9999999", "10 Mn", "10 milyon"],
    ["99999999", "100 Mn", "100 milyon"],
    ["9994", "9,99 B", "9,99 bin"],
    ["99944", "99,9 B", "99,9 bin"],
    ["999444", "999 B", "999 bin"],
    ["9994444", "9,99 Mn", "9,99 milyon"],
    ["999444444", "999 Mn", "999 milyon"],
    ["9994444444", "9,99 Mr", "9,99 milyar"],
  ],
  "uk": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 тис.", "4,32 тисячі"],
    ["54321", "54,3 тис.", "54,3 тисячі"],
    ["654321", "654 тис.", "654 тисячі"],
    ["7654321", "7,65 млн", "7,65 мільйона"],
    ["87654321", "87,7 млн", "87,7 мільйона"],
    ["987654321", "988 млн", "988 мільйонів"],
    ["1087654321", "1,09 млрд", "1,09 мільярда"],
    ["11987654321", "12 млрд", "12 мільярдів"],
    ["129987654321", "130 млрд", "130 мільярдів"],
    ["1398987654321", "1,4 трлн", "1,4 трильйона"],
    ["14987987654321", "15 трлн", "15 трильйонів"],
    ["159876987654321", "160 трлн", "160 трильйонів"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 тис.", "10 тисяч"],
    ["99999", "100 тис.", "100 тисяч"],
    ["99999", "100 тис.", "100 тисяч"],
    ["999999", "1 млн", "1 мільйон"],
    ["9999999", "10 млн", "10 мільйонів"],
    ["99999999", "100 млн", "100 мільйонів"],
    ["9994", "9,99 тис.", "9,99 тисячі"],
    ["99944", "99,9 тис.", "99,9 тисячі"],
    ["999444", "999 тис.", "999 тисяч"],
    ["9994444", "9,99 млн", "9,99 мільйона"],
    ["999444444", "999 млн", "999 мільйонів"],
    ["9994444444", "9,99 млрд", "9,99 мільярда"],
  ],
  "ur": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32 ہزار", "4.32 ہزار"],
    ["54321", "54.3 ہزار", "54.3 ہزار"],
    ["654321", "6.54 لاکھ", "6.54 لاکھ"],
    ["7654321", "76.5 لاکھ", "76.5 لاکھ"],
    ["87654321", "8.77 کروڑ", "8.77 کروڑ"],
    ["987654321", "98.8 کروڑ", "98.8 کروڑ"],
    ["1087654321", "1.09 ارب", "1.09 ارب"],
    ["11987654321", "12 ارب", "12 ارب"],
    ["129987654321", "1.3 کھرب", "1.3 کھرب"],
    ["1398987654321", "14 کھرب", "14 کھرب"],
    ["14987987654321", "15 ٹریلین", "15 ٹریلین"],
    ["159876987654321", "160 ٹریلین", "160 ٹریلین"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 ہزار", "10 ہزار"],
    ["99999", "1 لاکھ", "1 لاکھ"],
    ["99999", "1 لاکھ", "1 لاکھ"],
    ["999999", "10 لاکھ", "10 لاکھ"],
    ["9999999", "1 کروڑ", "1 کروڑ"],
    ["99999999", "10 کروڑ", "10 کروڑ"],
    ["9994", "9.99 ہزار", "9.99 ہزار"],
    ["99944", "99.9 ہزار", "99.9 ہزار"],
    ["999444", "9.99 لاکھ", "9.99 لاکھ"],
    ["9994444", "99.9 لاکھ", "99.9 لاکھ"],
    ["999444444", "99.9 کروڑ", "99.9 کروڑ"],
    ["9994444444", "9.99 ارب", "9.99 ارب"],
  ],
  "uz": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 ming", "4,32 ming"],
    ["54321", "54,3 ming", "54,3 ming"],
    ["654321", "654 ming", "654 ming"],
    ["7654321", "7,65 mln", "7,65 million"],
    ["87654321", "87,7 mln", "87,7 million"],
    ["987654321", "988 mln", "988 million"],
    ["1087654321", "1,09 mlrd", "1,09 milliard"],
    ["11987654321", "12 mlrd", "12 milliard"],
    ["129987654321", "130 mlrd", "130 milliard"],
    ["1398987654321", "1,4 trln", "1,4 trillion"],
    ["14987987654321", "15 trln", "15 trillion"],
    ["159876987654321", "160 trln", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 ming", "10 ming"],
    ["99999", "100 ming", "100 ming"],
    ["99999", "100 ming", "100 ming"],
    ["999999", "1 mln", "1 million"],
    ["9999999", "10 mln", "10 million"],
    ["99999999", "100 mln", "100 million"],
    ["9994", "9,99 ming", "9,99 ming"],
    ["99944", "99,9 ming", "99,9 ming"],
    ["999444", "999 ming", "999 ming"],
    ["9994444", "9,99 mln", "9,99 million"],
    ["999444444", "999 mln", "999 million"],
    ["9994444444", "9,99 mlrd", "9,99 milliard"],
  ],
  "vi": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 N", "4,32 nghìn"],
    ["54321", "54,3 N", "54,3 nghìn"],
    ["654321", "654 N", "654 nghìn"],
    ["7654321", "7,65 Tr", "7,65 triệu"],
    ["87654321", "87,7 Tr", "87,7 triệu"],
    ["987654321", "988 Tr", "988 triệu"],
    ["1087654321", "1,09 T", "1,09 tỷ"],
    ["11987654321", "12 T", "12 tỷ"],
    ["129987654321", "130 T", "130 tỷ"],
    ["1398987654321", "1,4 NT", "1,4 nghìn tỷ"],
    ["14987987654321", "15 NT", "15 nghìn tỷ"],
    ["159876987654321", "160 NT", "160 nghìn tỷ"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 N", "10 nghìn"],
    ["99999", "100 N", "100 nghìn"],
    ["99999", "100 N", "100 nghìn"],
    ["999999", "1 Tr", "1 triệu"],
    ["9999999", "10 Tr", "10 triệu"],
    ["99999999", "100 Tr", "100 triệu"],
    ["9994", "9,99 N", "9,99 nghìn"],
    ["99944", "99,9 N", "99,9 nghìn"],
    ["999444", "999 N", "999 nghìn"],
    ["9994444", "9,99 Tr", "9,99 triệu"],
    ["999444444", "999 Tr", "999 triệu"],
    ["9994444444", "9,99 T", "9,99 tỷ"],
  ],
  "zh": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4320", "4320"],
    ["54321", "5.43万", "5.43万"],
    ["654321", "65.4万", "65.4万"],
    ["7654321", "765万", "765万"],
    ["87654321", "8770万", "8770万"],
    ["987654321", "9.88亿", "9.88亿"],
    ["1087654321", "10.9亿", "10.9亿"],
    ["11987654321", "120亿", "120亿"],
    ["129987654321", "1300亿", "1300亿"],
    ["1398987654321", "1.4兆", "1.4兆"],
    ["14987987654321", "15兆", "15兆"],
    ["159876987654321", "160兆", "160兆"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "1万", "1万"],
    ["99999", "10万", "10万"],
    ["99999", "10万", "10万"],
    ["999999", "100万", "100万"],
    ["9999999", "1000万", "1000万"],
    ["99999999", "1亿", "1亿"],
    ["9994", "9990", "9990"],
    ["99944", "9.99万", "9.99万"],
    ["999444", "99.9万", "99.9万"],
    ["9994444", "999万", "999万"],
    ["999444444", "9.99亿", "9.99亿"],
    ["9994444444", "99.9亿", "99.9亿"],
  ],
  "zh_CN": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4320", "4320"],
    ["54321", "5.43万", "5.43万"],
    ["654321", "65.4万", "65.4万"],
    ["7654321", "765万", "765万"],
    ["87654321", "8770万", "8770万"],
    ["987654321", "9.88亿", "9.88亿"],
    ["1087654321", "10.9亿", "10.9亿"],
    ["11987654321", "120亿", "120亿"],
    ["129987654321", "1300亿", "1300亿"],
    ["1398987654321", "1.4兆", "1.4兆"],
    ["14987987654321", "15兆", "15兆"],
    ["159876987654321", "160兆", "160兆"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "1万", "1万"],
    ["99999", "10万", "10万"],
    ["99999", "10万", "10万"],
    ["999999", "100万", "100万"],
    ["9999999", "1000万", "1000万"],
    ["99999999", "1亿", "1亿"],
    ["9994", "9990", "9990"],
    ["99944", "9.99万", "9.99万"],
    ["999444", "99.9万", "99.9万"],
    ["9994444", "999万", "999万"],
    ["999444444", "9.99亿", "9.99亿"],
    ["9994444444", "99.9亿", "99.9亿"],
  ],
  "zh_HK": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32K", "4320"],
    ["54321", "54.3K", "5.43萬"],
    ["654321", "654K", "65.4萬"],
    ["7654321", "7.65M", "765萬"],
    ["87654321", "87.7M", "8770萬"],
    ["987654321", "988M", "9.88億"],
    ["1087654321", "1.09B", "10.9億"],
    ["11987654321", "12B", "120億"],
    ["129987654321", "130B", "1300億"],
    ["1398987654321", "1.4T", "1.4兆"],
    ["14987987654321", "15T", "15兆"],
    ["159876987654321", "160T", "160兆"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "1萬"],
    ["99999", "100K", "10萬"],
    ["99999", "100K", "10萬"],
    ["999999", "1M", "100萬"],
    ["9999999", "10M", "1000萬"],
    ["99999999", "100M", "1億"],
    ["9994", "9.99K", "9990"],
    ["99944", "99.9K", "9.99萬"],
    ["999444", "999K", "99.9萬"],
    ["9994444", "9.99M", "999萬"],
    ["999444444", "999M", "9.99億"],
    ["9994444444", "9.99B", "99.9億"],
  ],
  "zh_TW": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4320", "4320"],
    ["54321", "5.43萬", "5.43萬"],
    ["654321", "65.4萬", "65.4萬"],
    ["7654321", "765萬", "765萬"],
    ["87654321", "8770萬", "8770萬"],
    ["987654321", "9.88億", "9.88億"],
    ["1087654321", "10.9億", "10.9億"],
    ["11987654321", "120億", "120億"],
    ["129987654321", "1300億", "1300億"],
    ["1398987654321", "1.4兆", "1.4兆"],
    ["14987987654321", "15兆", "15兆"],
    ["159876987654321", "160兆", "160兆"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "1萬", "1萬"],
    ["99999", "10萬", "10萬"],
    ["99999", "10萬", "10萬"],
    ["999999", "100萬", "100萬"],
    ["9999999", "1000萬", "1000萬"],
    ["99999999", "1億", "1億"],
    ["9994", "9990", "9990"],
    ["99944", "9.99萬", "9.99萬"],
    ["999444", "99.9萬", "99.9萬"],
    ["9994444", "999萬", "999萬"],
    ["999444444", "9.99億", "9.99億"],
    ["9994444444", "99.9億", "99.9億"],
  ],
  "zu": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32K", "4.32 inkulungwane"],
    ["54321", "54.3K", "54.3 inkulungwane"],
    ["654321", "654K", "654 inkulungwane"],
    ["7654321", "7.65M", "7.65 isigidi"],
    ["87654321", "87.7M", "87.7 isigidi"],
    ["987654321", "988M", "988 isigidi"],
    ["1087654321", "1.09B", "1.09 isigidi sezigidi"],
    ["11987654321", "12B", "12 isigidi sezigidi"],
    ["129987654321", "130B", "130 isigidi sezigidi"],
    ["1398987654321", "1.4T", "1.4 isigidintathu"],
    ["14987987654321", "15T", "15 isigidintathu"],
    ["159876987654321", "160T", "160 isigidintathu"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 inkulungwane"],
    ["99999", "100K", "100 inkulungwane"],
    ["99999", "100K", "100 inkulungwane"],
    ["999999", "1M", "1 isigidi"],
    ["9999999", "10M", "10 isigidi"],
    ["99999999", "100M", "100 isigidi"],
    ["9994", "9.99K", "9.99 inkulungwane"],
    ["99944", "99.9K", "99.9 inkulungwane"],
    ["999444", "999K", "999 inkulungwane"],
    ["9994444", "9.99M", "9.99 isigidi"],
    ["999444444", "999M", "999 isigidi"],
    ["9994444444", "9.99B", "9.99 isigidi sezigidi"],
  ],
  "en_MY": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.32K", "4.32 thousand"],
    ["54321", "54.3K", "54.3 thousand"],
    ["654321", "654K", "654 thousand"],
    ["7654321", "7.65M", "7.65 million"],
    ["87654321", "87.7M", "87.7 million"],
    ["987654321", "988M", "988 million"],
    ["1087654321", "1.09B", "1.09 billion"],
    ["11987654321", "12B", "12 billion"],
    ["129987654321", "130B", "130 billion"],
    ["1398987654321", "1.4T", "1.4 trillion"],
    ["14987987654321", "15T", "15 trillion"],
    ["159876987654321", "160T", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 thousand"],
    ["99999", "100K", "100 thousand"],
    ["99999", "100K", "100 thousand"],
    ["999999", "1M", "1 million"],
    ["9999999", "10M", "10 million"],
    ["99999999", "100M", "100 million"],
    ["9994", "9.99K", "9.99 thousand"],
    ["99944", "99.9K", "99.9 thousand"],
    ["999444", "999K", "999 thousand"],
    ["9994444", "9.99M", "9.99 million"],
    ["999444444", "999M", "999 million"],
    ["9994444444", "9.99B", "9.99 billion"],
  ],
  "fr_CH": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,32 k", "4,32 mille"],
    ["54321", "54,3 k", "54,3 mille"],
    ["654321", "654 k", "654 mille"],
    ["7654321", "7,65 M", "7,65 millions"],
    ["87654321", "87,7 M", "87,7 millions"],
    ["987654321", "988 M", "988 millions"],
    ["1087654321", "1,09 Md", "1,09 milliard"],
    ["11987654321", "12 Md", "12 milliards"],
    ["129987654321", "130 Md", "130 milliards"],
    ["1398987654321", "1,4 Bn", "1,4 billion"],
    ["14987987654321", "15 Bn", "15 billions"],
    ["159876987654321", "160 Bn", "160 billions"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 k", "10 mille"],
    ["99999", "100 k", "100 mille"],
    ["99999", "100 k", "100 mille"],
    ["999999", "1 M", "1 million"],
    ["9999999", "10 M", "10 millions"],
    ["99999999", "100 M", "100 millions"],
    ["9994", "9,99 k", "9,99 mille"],
    ["99944", "99,9 k", "99,9 mille"],
    ["999444", "999 k", "999 mille"],
    ["9994444", "9,99 M", "9,99 millions"],
    ["999444444", "999 M", "999 millions"],
    ["9994444444", "9,99 Md", "9,99 milliards"],
  ],
  "it_CH": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4320", "4.32 mila"],
    ["54321", "54300", "54.3 mila"],
    ["654321", "654000", "654 mila"],
    ["7654321", "7.65 Mln", "7.65 milioni"],
    ["87654321", "87.7 Mln", "87.7 milioni"],
    ["987654321", "988 Mln", "988 milioni"],
    ["1087654321", "1.09 Mld", "1.09 miliardi"],
    ["11987654321", "12 Mld", "12 miliardi"],
    ["129987654321", "130 Mld", "130 miliardi"],
    ["1398987654321", "1.4 Bln", "1.4 mila miliardi"],
    ["14987987654321", "15 Bln", "15 mila miliardi"],
    ["159876987654321", "160 Bln", "160 mila miliardi"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10000", "10 mila"],
    ["99999", "100000", "100 mila"],
    ["99999", "100000", "100 mila"],
    ["999999", "1 Mln", "1 milione"],
    ["9999999", "10 Mln", "10 milioni"],
    ["99999999", "100 Mln", "100 milioni"],
    ["9994", "9990", "9.99 mila"],
    ["99944", "99900", "99.9 mila"],
    ["999444", "999000", "999 mila"],
    ["9994444", "9.99 Mln", "9.99 milioni"],
    ["999444444", "999 Mln", "999 milioni"],
    ["9994444444", "9.99 Mld", "9.99 miliardi"],
  ],
  "ps": [
    ["1", "۱", "۱"],
    ["21", "۲۱", "۲۱"],
    ["321", "۳۲۱", "۳۲۱"],
    ["4321", "۴٫۳۲K", "۴٫۳۲K"],
    ["54321", "۵۴٫۳K", "۵۴٫۳K"],
    ["654321", "۶۵۴K", "۶۵۴K"],
    ["7654321", "۷٫۶۵M", "۷٫۶۵M"],
    ["87654321", "۸۷٫۷M", "۸۷٫۷M"],
    ["987654321", "۹۸۸M", "۹۸۸M"],
    ["1087654321", "۱٫۰۹B", "۱٫۰۹G"],
    ["11987654321", "۱۲B", "۱۲G"],
    ["129987654321", "۱۳۰B", "۱۳۰G"],
    ["1398987654321", "۱٫۴T", "۱٫۴T"],
    ["14987987654321", "۱۵T", "۱۵T"],
    ["159876987654321", "۱۶۰T", "۱۶۰T"],
    ["9", "۹", "۹"],
    ["99", "۹۹", "۹۹"],
    ["999", "۹۹۹", "۹۹۹"],
    ["9999", "۱۰K", "۱۰K"],
    ["99999", "۱۰۰K", "۱۰۰K"],
    ["99999", "۱۰۰K", "۱۰۰K"],
    ["999999", "۱M", "۱M"],
    ["9999999", "۱۰M", "۱۰M"],
    ["99999999", "۱۰۰M", "۱۰۰M"],
    ["9994", "۹٫۹۹K", "۹٫۹۹K"],
    ["99944", "۹۹٫۹K", "۹۹٫۹K"],
    ["999444", "۹۹۹K", "۹۹۹K"],
    ["9994444", "۹٫۹۹M", "۹٫۹۹M"],
    ["999444444", "۹۹۹M", "۹۹۹M"],
    ["9994444444", "۹٫۹۹B", "۹٫۹۹G"],
  ],
};
