/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.systemchannels;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.flutter.Log;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.plugin.common.JSONMethodCodec;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import java.util.Arrays;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TextInputChannel {
    private static final String TAG = "TextInputChannel";
    @NonNull
    public final MethodChannel channel;
    @Nullable
    private TextInputMethodHandler textInputMethodHandler;
    private final MethodChannel.MethodCallHandler parsingMethodHandler = new MethodChannel.MethodCallHandler(){

        @Override
        public void onMethodCall(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            if (TextInputChannel.this.textInputMethodHandler == null) {
                return;
            }
            String method = call.method;
            Object args = call.arguments;
            Log.v(TextInputChannel.TAG, "Received '" + method + "' message.");
            switch (method) {
                case "TextInput.show": {
                    TextInputChannel.this.textInputMethodHandler.show();
                    result.success(null);
                    break;
                }
                case "TextInput.hide": {
                    TextInputChannel.this.textInputMethodHandler.hide();
                    result.success(null);
                    break;
                }
                case "TextInput.setClient": {
                    try {
                        JSONArray argumentList = (JSONArray)args;
                        int textInputClientId = argumentList.getInt(0);
                        JSONObject jsonConfiguration = argumentList.getJSONObject(1);
                        TextInputChannel.this.textInputMethodHandler.setClient(textInputClientId, Configuration.fromJson(jsonConfiguration));
                        result.success(null);
                    }
                    catch (NoSuchFieldException | JSONException exception) {
                        result.error("error", exception.getMessage(), null);
                    }
                    break;
                }
                case "TextInput.setPlatformViewClient": {
                    int id = (Integer)args;
                    TextInputChannel.this.textInputMethodHandler.setPlatformViewClient(id);
                    break;
                }
                case "TextInput.setEditingState": {
                    try {
                        JSONObject editingState = (JSONObject)args;
                        TextInputChannel.this.textInputMethodHandler.setEditingState(TextEditState.fromJson(editingState));
                        result.success(null);
                    }
                    catch (JSONException exception) {
                        result.error("error", exception.getMessage(), null);
                    }
                    break;
                }
                case "TextInput.clearClient": {
                    TextInputChannel.this.textInputMethodHandler.clearClient();
                    result.success(null);
                    break;
                }
                default: {
                    result.notImplemented();
                }
            }
        }
    };

    public TextInputChannel(@NonNull DartExecutor dartExecutor) {
        this.channel = new MethodChannel(dartExecutor, "flutter/textinput", JSONMethodCodec.INSTANCE);
        this.channel.setMethodCallHandler(this.parsingMethodHandler);
    }

    public void updateEditingState(int inputClientId, String text, int selectionStart, int selectionEnd, int composingStart, int composingEnd) {
        Log.v(TAG, "Sending message to update editing state: \nText: " + text + "\nSelection start: " + selectionStart + "\nSelection end: " + selectionEnd + "\nComposing start: " + composingStart + "\nComposing end: " + composingEnd);
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("text", text);
        state.put("selectionBase", selectionStart);
        state.put("selectionExtent", selectionEnd);
        state.put("composingBase", composingStart);
        state.put("composingExtent", composingEnd);
        this.channel.invokeMethod("TextInputClient.updateEditingState", Arrays.asList(inputClientId, state));
    }

    public void newline(int inputClientId) {
        Log.v(TAG, "Sending 'newline' message.");
        this.channel.invokeMethod("TextInputClient.performAction", Arrays.asList(inputClientId, "TextInputAction.newline"));
    }

    public void go(int inputClientId) {
        Log.v(TAG, "Sending 'go' message.");
        this.channel.invokeMethod("TextInputClient.performAction", Arrays.asList(inputClientId, "TextInputAction.go"));
    }

    public void search(int inputClientId) {
        Log.v(TAG, "Sending 'search' message.");
        this.channel.invokeMethod("TextInputClient.performAction", Arrays.asList(inputClientId, "TextInputAction.search"));
    }

    public void send(int inputClientId) {
        Log.v(TAG, "Sending 'send' message.");
        this.channel.invokeMethod("TextInputClient.performAction", Arrays.asList(inputClientId, "TextInputAction.send"));
    }

    public void done(int inputClientId) {
        Log.v(TAG, "Sending 'done' message.");
        this.channel.invokeMethod("TextInputClient.performAction", Arrays.asList(inputClientId, "TextInputAction.done"));
    }

    public void next(int inputClientId) {
        Log.v(TAG, "Sending 'next' message.");
        this.channel.invokeMethod("TextInputClient.performAction", Arrays.asList(inputClientId, "TextInputAction.next"));
    }

    public void previous(int inputClientId) {
        Log.v(TAG, "Sending 'previous' message.");
        this.channel.invokeMethod("TextInputClient.performAction", Arrays.asList(inputClientId, "TextInputAction.previous"));
    }

    public void unspecifiedAction(int inputClientId) {
        Log.v(TAG, "Sending 'unspecified' message.");
        this.channel.invokeMethod("TextInputClient.performAction", Arrays.asList(inputClientId, "TextInputAction.unspecified"));
    }

    public void setTextInputMethodHandler(@Nullable TextInputMethodHandler textInputMethodHandler) {
        this.textInputMethodHandler = textInputMethodHandler;
    }

    public static class TextEditState {
        @NonNull
        public final String text;
        public final int selectionStart;
        public final int selectionEnd;

        public static TextEditState fromJson(@NonNull JSONObject textEditState) throws JSONException {
            return new TextEditState(textEditState.getString("text"), textEditState.getInt("selectionBase"), textEditState.getInt("selectionExtent"));
        }

        public TextEditState(@NonNull String text, int selectionStart, int selectionEnd) {
            this.text = text;
            this.selectionStart = selectionStart;
            this.selectionEnd = selectionEnd;
        }
    }

    public static enum TextCapitalization {
        CHARACTERS("TextCapitalization.characters"),
        WORDS("TextCapitalization.words"),
        SENTENCES("TextCapitalization.sentences"),
        NONE("TextCapitalization.none");

        @NonNull
        private final String encodedName;

        static TextCapitalization fromValue(@NonNull String encodedName) throws NoSuchFieldException {
            for (TextCapitalization textCapitalization : TextCapitalization.values()) {
                if (!textCapitalization.encodedName.equals(encodedName)) continue;
                return textCapitalization;
            }
            throw new NoSuchFieldException("No such TextCapitalization: " + encodedName);
        }

        private TextCapitalization(String encodedName) {
            this.encodedName = encodedName;
        }
    }

    public static enum TextInputType {
        TEXT("TextInputType.text"),
        DATETIME("TextInputType.datetime"),
        NUMBER("TextInputType.number"),
        PHONE("TextInputType.phone"),
        MULTILINE("TextInputType.multiline"),
        EMAIL_ADDRESS("TextInputType.emailAddress"),
        URL("TextInputType.url"),
        VISIBLE_PASSWORD("TextInputType.visiblePassword");

        @NonNull
        private final String encodedName;

        static TextInputType fromValue(@NonNull String encodedName) throws NoSuchFieldException {
            for (TextInputType textInputType : TextInputType.values()) {
                if (!textInputType.encodedName.equals(encodedName)) continue;
                return textInputType;
            }
            throw new NoSuchFieldException("No such TextInputType: " + encodedName);
        }

        private TextInputType(String encodedName) {
            this.encodedName = encodedName;
        }
    }

    public static class InputType {
        @NonNull
        public final TextInputType type;
        public final boolean isSigned;
        public final boolean isDecimal;

        @NonNull
        public static InputType fromJson(@NonNull JSONObject json) throws JSONException, NoSuchFieldException {
            return new InputType(TextInputType.fromValue(json.getString("name")), json.optBoolean("signed", false), json.optBoolean("decimal", false));
        }

        public InputType(@NonNull TextInputType type, boolean isSigned, boolean isDecimal) {
            this.type = type;
            this.isSigned = isSigned;
            this.isDecimal = isDecimal;
        }
    }

    public static class Configuration {
        public final boolean obscureText;
        public final boolean autocorrect;
        @NonNull
        public final TextCapitalization textCapitalization;
        @NonNull
        public final InputType inputType;
        @Nullable
        public final Integer inputAction;
        @Nullable
        public final String actionLabel;

        public static Configuration fromJson(@NonNull JSONObject json) throws JSONException, NoSuchFieldException {
            String inputActionName = json.getString("inputAction");
            if (inputActionName == null) {
                throw new JSONException("Configuration JSON missing 'inputAction' property.");
            }
            Integer inputAction = Configuration.inputActionFromTextInputAction(inputActionName);
            return new Configuration(json.optBoolean("obscureText"), json.optBoolean("autocorrect", true), TextCapitalization.fromValue(json.getString("textCapitalization")), InputType.fromJson(json.getJSONObject("inputType")), inputAction, json.isNull("actionLabel") ? null : json.getString("actionLabel"));
        }

        @NonNull
        private static Integer inputActionFromTextInputAction(@NonNull String inputAction) {
            switch (inputAction) {
                case "TextInputAction.newline": {
                    return 1;
                }
                case "TextInputAction.none": {
                    return 1;
                }
                case "TextInputAction.unspecified": {
                    return 0;
                }
                case "TextInputAction.done": {
                    return 6;
                }
                case "TextInputAction.go": {
                    return 2;
                }
                case "TextInputAction.search": {
                    return 3;
                }
                case "TextInputAction.send": {
                    return 4;
                }
                case "TextInputAction.next": {
                    return 5;
                }
                case "TextInputAction.previous": {
                    return 7;
                }
            }
            return 0;
        }

        public Configuration(boolean obscureText, boolean autocorrect, @NonNull TextCapitalization textCapitalization, @NonNull InputType inputType, @Nullable Integer inputAction, @Nullable String actionLabel) {
            this.obscureText = obscureText;
            this.autocorrect = autocorrect;
            this.textCapitalization = textCapitalization;
            this.inputType = inputType;
            this.inputAction = inputAction;
            this.actionLabel = actionLabel;
        }
    }

    public static interface TextInputMethodHandler {
        public void show();

        public void hide();

        public void setClient(int var1, @NonNull Configuration var2);

        public void setPlatformViewClient(int var1);

        public void setEditingState(@NonNull TextEditState var1);

        public void clearClient();
    }
}

