// This is a generated file (see the discoveryapis_generator project).

// ignore_for_file: unnecessary_cast

library googleapis.compute.v1;

import 'dart:core' as core;
import 'dart:async' as async;
import 'dart:convert' as convert;

import 'package:_discoveryapis_commons/_discoveryapis_commons.dart' as commons;
import 'package:http/http.dart' as http;

export 'package:_discoveryapis_commons/_discoveryapis_commons.dart'
    show ApiRequestError, DetailedApiRequestError;

const core.String USER_AGENT = 'dart-api-client compute/v1';

/// Creates and runs virtual machines on Google Cloud Platform.
class ComputeApi {
  /// View and manage your data across Google Cloud Platform services
  static const CloudPlatformScope =
      "https://www.googleapis.com/auth/cloud-platform";

  /// View and manage your Google Compute Engine resources
  static const ComputeScope = "https://www.googleapis.com/auth/compute";

  /// View your Google Compute Engine resources
  static const ComputeReadonlyScope =
      "https://www.googleapis.com/auth/compute.readonly";

  /// Manage your data and permissions in Google Cloud Storage
  static const DevstorageFullControlScope =
      "https://www.googleapis.com/auth/devstorage.full_control";

  /// View your data in Google Cloud Storage
  static const DevstorageReadOnlyScope =
      "https://www.googleapis.com/auth/devstorage.read_only";

  /// Manage your data in Google Cloud Storage
  static const DevstorageReadWriteScope =
      "https://www.googleapis.com/auth/devstorage.read_write";

  final commons.ApiRequester _requester;

  AcceleratorTypesResourceApi get acceleratorTypes =>
      new AcceleratorTypesResourceApi(_requester);
  AddressesResourceApi get addresses => new AddressesResourceApi(_requester);
  AutoscalersResourceApi get autoscalers =>
      new AutoscalersResourceApi(_requester);
  BackendBucketsResourceApi get backendBuckets =>
      new BackendBucketsResourceApi(_requester);
  BackendServicesResourceApi get backendServices =>
      new BackendServicesResourceApi(_requester);
  DiskTypesResourceApi get diskTypes => new DiskTypesResourceApi(_requester);
  DisksResourceApi get disks => new DisksResourceApi(_requester);
  FirewallsResourceApi get firewalls => new FirewallsResourceApi(_requester);
  ForwardingRulesResourceApi get forwardingRules =>
      new ForwardingRulesResourceApi(_requester);
  GlobalAddressesResourceApi get globalAddresses =>
      new GlobalAddressesResourceApi(_requester);
  GlobalForwardingRulesResourceApi get globalForwardingRules =>
      new GlobalForwardingRulesResourceApi(_requester);
  GlobalOperationsResourceApi get globalOperations =>
      new GlobalOperationsResourceApi(_requester);
  HealthChecksResourceApi get healthChecks =>
      new HealthChecksResourceApi(_requester);
  HttpHealthChecksResourceApi get httpHealthChecks =>
      new HttpHealthChecksResourceApi(_requester);
  HttpsHealthChecksResourceApi get httpsHealthChecks =>
      new HttpsHealthChecksResourceApi(_requester);
  ImagesResourceApi get images => new ImagesResourceApi(_requester);
  InstanceGroupManagersResourceApi get instanceGroupManagers =>
      new InstanceGroupManagersResourceApi(_requester);
  InstanceGroupsResourceApi get instanceGroups =>
      new InstanceGroupsResourceApi(_requester);
  InstanceTemplatesResourceApi get instanceTemplates =>
      new InstanceTemplatesResourceApi(_requester);
  InstancesResourceApi get instances => new InstancesResourceApi(_requester);
  InterconnectAttachmentsResourceApi get interconnectAttachments =>
      new InterconnectAttachmentsResourceApi(_requester);
  InterconnectLocationsResourceApi get interconnectLocations =>
      new InterconnectLocationsResourceApi(_requester);
  InterconnectsResourceApi get interconnects =>
      new InterconnectsResourceApi(_requester);
  LicenseCodesResourceApi get licenseCodes =>
      new LicenseCodesResourceApi(_requester);
  LicensesResourceApi get licenses => new LicensesResourceApi(_requester);
  MachineTypesResourceApi get machineTypes =>
      new MachineTypesResourceApi(_requester);
  NetworkEndpointGroupsResourceApi get networkEndpointGroups =>
      new NetworkEndpointGroupsResourceApi(_requester);
  NetworksResourceApi get networks => new NetworksResourceApi(_requester);
  NodeGroupsResourceApi get nodeGroups => new NodeGroupsResourceApi(_requester);
  NodeTemplatesResourceApi get nodeTemplates =>
      new NodeTemplatesResourceApi(_requester);
  NodeTypesResourceApi get nodeTypes => new NodeTypesResourceApi(_requester);
  ProjectsResourceApi get projects => new ProjectsResourceApi(_requester);
  RegionAutoscalersResourceApi get regionAutoscalers =>
      new RegionAutoscalersResourceApi(_requester);
  RegionBackendServicesResourceApi get regionBackendServices =>
      new RegionBackendServicesResourceApi(_requester);
  RegionCommitmentsResourceApi get regionCommitments =>
      new RegionCommitmentsResourceApi(_requester);
  RegionDiskTypesResourceApi get regionDiskTypes =>
      new RegionDiskTypesResourceApi(_requester);
  RegionDisksResourceApi get regionDisks =>
      new RegionDisksResourceApi(_requester);
  RegionInstanceGroupManagersResourceApi get regionInstanceGroupManagers =>
      new RegionInstanceGroupManagersResourceApi(_requester);
  RegionInstanceGroupsResourceApi get regionInstanceGroups =>
      new RegionInstanceGroupsResourceApi(_requester);
  RegionOperationsResourceApi get regionOperations =>
      new RegionOperationsResourceApi(_requester);
  RegionsResourceApi get regions => new RegionsResourceApi(_requester);
  ReservationsResourceApi get reservations =>
      new ReservationsResourceApi(_requester);
  ResourcePoliciesResourceApi get resourcePolicies =>
      new ResourcePoliciesResourceApi(_requester);
  RoutersResourceApi get routers => new RoutersResourceApi(_requester);
  RoutesResourceApi get routes => new RoutesResourceApi(_requester);
  SecurityPoliciesResourceApi get securityPolicies =>
      new SecurityPoliciesResourceApi(_requester);
  SnapshotsResourceApi get snapshots => new SnapshotsResourceApi(_requester);
  SslCertificatesResourceApi get sslCertificates =>
      new SslCertificatesResourceApi(_requester);
  SslPoliciesResourceApi get sslPolicies =>
      new SslPoliciesResourceApi(_requester);
  SubnetworksResourceApi get subnetworks =>
      new SubnetworksResourceApi(_requester);
  TargetHttpProxiesResourceApi get targetHttpProxies =>
      new TargetHttpProxiesResourceApi(_requester);
  TargetHttpsProxiesResourceApi get targetHttpsProxies =>
      new TargetHttpsProxiesResourceApi(_requester);
  TargetInstancesResourceApi get targetInstances =>
      new TargetInstancesResourceApi(_requester);
  TargetPoolsResourceApi get targetPools =>
      new TargetPoolsResourceApi(_requester);
  TargetSslProxiesResourceApi get targetSslProxies =>
      new TargetSslProxiesResourceApi(_requester);
  TargetTcpProxiesResourceApi get targetTcpProxies =>
      new TargetTcpProxiesResourceApi(_requester);
  TargetVpnGatewaysResourceApi get targetVpnGateways =>
      new TargetVpnGatewaysResourceApi(_requester);
  UrlMapsResourceApi get urlMaps => new UrlMapsResourceApi(_requester);
  VpnTunnelsResourceApi get vpnTunnels => new VpnTunnelsResourceApi(_requester);
  ZoneOperationsResourceApi get zoneOperations =>
      new ZoneOperationsResourceApi(_requester);
  ZonesResourceApi get zones => new ZonesResourceApi(_requester);

  ComputeApi(http.Client client,
      {core.String rootUrl = "https://www.googleapis.com/",
      core.String servicePath = "compute/v1/projects/"})
      : _requester =
            new commons.ApiRequester(client, rootUrl, servicePath, USER_AGENT);
}

class AcceleratorTypesResourceApi {
  final commons.ApiRequester _requester;

  AcceleratorTypesResourceApi(commons.ApiRequester client)
      : _requester = client;

  /// Retrieves an aggregated list of accelerator types.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AcceleratorTypeAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AcceleratorTypeAggregatedList> aggregatedList(
      core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/aggregated/acceleratorTypes';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response
        .then((data) => new AcceleratorTypeAggregatedList.fromJson(data));
  }

  /// Returns the specified accelerator type.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [acceleratorType] - Name of the accelerator type to return.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AcceleratorType].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AcceleratorType> get(
      core.String project, core.String zone, core.String acceleratorType,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (acceleratorType == null) {
      throw new core.ArgumentError("Parameter acceleratorType is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/acceleratorTypes/' +
        commons.Escaper.ecapeVariable('$acceleratorType');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new AcceleratorType.fromJson(data));
  }

  /// Retrieves a list of accelerator types available to the specified project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AcceleratorTypeList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AcceleratorTypeList> list(core.String project, core.String zone,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/acceleratorTypes';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new AcceleratorTypeList.fromJson(data));
  }
}

class AddressesResourceApi {
  final commons.ApiRequester _requester;

  AddressesResourceApi(commons.ApiRequester client) : _requester = client;

  /// Retrieves an aggregated list of addresses.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AddressAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AddressAggregatedList> aggregatedList(core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/aggregated/addresses';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new AddressAggregatedList.fromJson(data));
  }

  /// Deletes the specified address resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [address] - Name of the address resource to delete.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
      core.String project, core.String region, core.String address,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (address == null) {
      throw new core.ArgumentError("Parameter address is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/addresses/' +
        commons.Escaper.ecapeVariable('$address');

    var _response = _requester.request(_url, "DELETE",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns the specified address resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [address] - Name of the address resource to return.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Address].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Address> get(
      core.String project, core.String region, core.String address,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (address == null) {
      throw new core.ArgumentError("Parameter address is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/addresses/' +
        commons.Escaper.ecapeVariable('$address');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Address.fromJson(data));
  }

  /// Creates an address resource in the specified project by using the data
  /// included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
      Address request, core.String project, core.String region,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/addresses';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves a list of addresses contained within the specified region.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AddressList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AddressList> list(core.String project, core.String region,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/addresses';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new AddressList.fromJson(data));
  }
}

class AutoscalersResourceApi {
  final commons.ApiRequester _requester;

  AutoscalersResourceApi(commons.ApiRequester client) : _requester = client;

  /// Retrieves an aggregated list of autoscalers.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AutoscalerAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AutoscalerAggregatedList> aggregatedList(core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url =
        commons.Escaper.ecapeVariable('$project') + '/aggregated/autoscalers';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response
        .then((data) => new AutoscalerAggregatedList.fromJson(data));
  }

  /// Deletes the specified autoscaler.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - Name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [autoscaler] - Name of the autoscaler to delete.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
      core.String project, core.String zone, core.String autoscaler,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (autoscaler == null) {
      throw new core.ArgumentError("Parameter autoscaler is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/autoscalers/' +
        commons.Escaper.ecapeVariable('$autoscaler');

    var _response = _requester.request(_url, "DELETE",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns the specified autoscaler resource. Gets a list of available
  /// autoscalers by making a list() request.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - Name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [autoscaler] - Name of the autoscaler to return.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Autoscaler].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Autoscaler> get(
      core.String project, core.String zone, core.String autoscaler,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (autoscaler == null) {
      throw new core.ArgumentError("Parameter autoscaler is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/autoscalers/' +
        commons.Escaper.ecapeVariable('$autoscaler');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Autoscaler.fromJson(data));
  }

  /// Creates an autoscaler in the specified project using the data included in
  /// the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - Name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
      Autoscaler request, core.String project, core.String zone,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/autoscalers';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves a list of autoscalers contained within the specified zone.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - Name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AutoscalerList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AutoscalerList> list(core.String project, core.String zone,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/autoscalers';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new AutoscalerList.fromJson(data));
  }

  /// Updates an autoscaler in the specified project using the data included in
  /// the request. This method supports PATCH semantics and uses the JSON merge
  /// patch format and processing rules.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - Name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [autoscaler] - Name of the autoscaler to patch.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patch(
      Autoscaler request, core.String project, core.String zone,
      {core.String autoscaler, core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (autoscaler != null) {
      _queryParams["autoscaler"] = [autoscaler];
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/autoscalers';

    var _response = _requester.request(_url, "PATCH",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Updates an autoscaler in the specified project using the data included in
  /// the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - Name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [autoscaler] - Name of the autoscaler to update.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> update(
      Autoscaler request, core.String project, core.String zone,
      {core.String autoscaler, core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (autoscaler != null) {
      _queryParams["autoscaler"] = [autoscaler];
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/autoscalers';

    var _response = _requester.request(_url, "PUT",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }
}

class BackendBucketsResourceApi {
  final commons.ApiRequester _requester;

  BackendBucketsResourceApi(commons.ApiRequester client) : _requester = client;

  /// Adds a key for validating requests with signed URLs for this backend
  /// bucket.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [backendBucket] - Name of the BackendBucket resource to which the Signed
  /// URL Key should be added. The name should conform to RFC1035.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> addSignedUrlKey(
      SignedUrlKey request, core.String project, core.String backendBucket,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (backendBucket == null) {
      throw new core.ArgumentError("Parameter backendBucket is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/backendBuckets/' +
        commons.Escaper.ecapeVariable('$backendBucket') +
        '/addSignedUrlKey';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Deletes the specified BackendBucket resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [backendBucket] - Name of the BackendBucket resource to delete.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(core.String project, core.String backendBucket,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (backendBucket == null) {
      throw new core.ArgumentError("Parameter backendBucket is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/backendBuckets/' +
        commons.Escaper.ecapeVariable('$backendBucket');

    var _response = _requester.request(_url, "DELETE",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Deletes a key for validating requests with signed URLs for this backend
  /// bucket.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [backendBucket] - Name of the BackendBucket resource to which the Signed
  /// URL Key should be added. The name should conform to RFC1035.
  ///
  /// [keyName] - The name of the Signed URL Key to delete.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> deleteSignedUrlKey(
      core.String project, core.String backendBucket, core.String keyName,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (backendBucket == null) {
      throw new core.ArgumentError("Parameter backendBucket is required.");
    }
    if (keyName == null) {
      throw new core.ArgumentError("Parameter keyName is required.");
    }
    _queryParams["keyName"] = [keyName];
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/backendBuckets/' +
        commons.Escaper.ecapeVariable('$backendBucket') +
        '/deleteSignedUrlKey';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns the specified BackendBucket resource. Gets a list of available
  /// backend buckets by making a list() request.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [backendBucket] - Name of the BackendBucket resource to return.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [BackendBucket].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<BackendBucket> get(
      core.String project, core.String backendBucket,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (backendBucket == null) {
      throw new core.ArgumentError("Parameter backendBucket is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/backendBuckets/' +
        commons.Escaper.ecapeVariable('$backendBucket');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new BackendBucket.fromJson(data));
  }

  /// Creates a BackendBucket resource in the specified project using the data
  /// included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(BackendBucket request, core.String project,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/global/backendBuckets';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves the list of BackendBucket resources available to the specified
  /// project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [BackendBucketList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<BackendBucketList> list(core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/global/backendBuckets';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new BackendBucketList.fromJson(data));
  }

  /// Updates the specified BackendBucket resource with the data included in the
  /// request. This method supports PATCH semantics and uses the JSON merge
  /// patch format and processing rules.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [backendBucket] - Name of the BackendBucket resource to patch.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patch(
      BackendBucket request, core.String project, core.String backendBucket,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (backendBucket == null) {
      throw new core.ArgumentError("Parameter backendBucket is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/backendBuckets/' +
        commons.Escaper.ecapeVariable('$backendBucket');

    var _response = _requester.request(_url, "PATCH",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Updates the specified BackendBucket resource with the data included in the
  /// request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [backendBucket] - Name of the BackendBucket resource to update.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> update(
      BackendBucket request, core.String project, core.String backendBucket,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (backendBucket == null) {
      throw new core.ArgumentError("Parameter backendBucket is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/backendBuckets/' +
        commons.Escaper.ecapeVariable('$backendBucket');

    var _response = _requester.request(_url, "PUT",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }
}

class BackendServicesResourceApi {
  final commons.ApiRequester _requester;

  BackendServicesResourceApi(commons.ApiRequester client) : _requester = client;

  /// Adds a key for validating requests with signed URLs for this backend
  /// service.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [backendService] - Name of the BackendService resource to which the Signed
  /// URL Key should be added. The name should conform to RFC1035.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> addSignedUrlKey(
      SignedUrlKey request, core.String project, core.String backendService,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (backendService == null) {
      throw new core.ArgumentError("Parameter backendService is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/backendServices/' +
        commons.Escaper.ecapeVariable('$backendService') +
        '/addSignedUrlKey';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves the list of all BackendService resources, regional and global,
  /// available to the specified project.
  ///
  /// Request parameters:
  ///
  /// [project] - Name of the project scoping this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [BackendServiceAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<BackendServiceAggregatedList> aggregatedList(core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/aggregated/backendServices';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response
        .then((data) => new BackendServiceAggregatedList.fromJson(data));
  }

  /// Deletes the specified BackendService resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [backendService] - Name of the BackendService resource to delete.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
      core.String project, core.String backendService,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (backendService == null) {
      throw new core.ArgumentError("Parameter backendService is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/backendServices/' +
        commons.Escaper.ecapeVariable('$backendService');

    var _response = _requester.request(_url, "DELETE",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Deletes a key for validating requests with signed URLs for this backend
  /// service.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [backendService] - Name of the BackendService resource to which the Signed
  /// URL Key should be added. The name should conform to RFC1035.
  ///
  /// [keyName] - The name of the Signed URL Key to delete.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> deleteSignedUrlKey(
      core.String project, core.String backendService, core.String keyName,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (backendService == null) {
      throw new core.ArgumentError("Parameter backendService is required.");
    }
    if (keyName == null) {
      throw new core.ArgumentError("Parameter keyName is required.");
    }
    _queryParams["keyName"] = [keyName];
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/backendServices/' +
        commons.Escaper.ecapeVariable('$backendService') +
        '/deleteSignedUrlKey';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns the specified BackendService resource. Gets a list of available
  /// backend services.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [backendService] - Name of the BackendService resource to return.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [BackendService].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<BackendService> get(
      core.String project, core.String backendService,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (backendService == null) {
      throw new core.ArgumentError("Parameter backendService is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/backendServices/' +
        commons.Escaper.ecapeVariable('$backendService');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new BackendService.fromJson(data));
  }

  /// Gets the most recent health check results for this BackendService.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - null
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [backendService] - Name of the BackendService resource to which the
  /// queried instance belongs.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [BackendServiceGroupHealth].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<BackendServiceGroupHealth> getHealth(
      ResourceGroupReference request,
      core.String project,
      core.String backendService,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (backendService == null) {
      throw new core.ArgumentError("Parameter backendService is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/backendServices/' +
        commons.Escaper.ecapeVariable('$backendService') +
        '/getHealth';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response
        .then((data) => new BackendServiceGroupHealth.fromJson(data));
  }

  /// Creates a BackendService resource in the specified project using the data
  /// included in the request. There are several restrictions and guidelines to
  /// keep in mind when creating a backend service. Read  Restrictions and
  /// Guidelines for more information.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(BackendService request, core.String project,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url =
        commons.Escaper.ecapeVariable('$project') + '/global/backendServices';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves the list of BackendService resources available to the specified
  /// project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [BackendServiceList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<BackendServiceList> list(core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url =
        commons.Escaper.ecapeVariable('$project') + '/global/backendServices';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new BackendServiceList.fromJson(data));
  }

  /// Patches the specified BackendService resource with the data included in
  /// the request. There are several restrictions and guidelines to keep in mind
  /// when updating a backend service. Read  Restrictions and Guidelines for
  /// more information. This method supports PATCH semantics and uses the JSON
  /// merge patch format and processing rules.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [backendService] - Name of the BackendService resource to patch.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patch(
      BackendService request, core.String project, core.String backendService,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (backendService == null) {
      throw new core.ArgumentError("Parameter backendService is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/backendServices/' +
        commons.Escaper.ecapeVariable('$backendService');

    var _response = _requester.request(_url, "PATCH",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Sets the security policy for the specified backend service.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [backendService] - Name of the BackendService resource to which the
  /// security policy should be set. The name should conform to RFC1035.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setSecurityPolicy(SecurityPolicyReference request,
      core.String project, core.String backendService,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (backendService == null) {
      throw new core.ArgumentError("Parameter backendService is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/backendServices/' +
        commons.Escaper.ecapeVariable('$backendService') +
        '/setSecurityPolicy';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Updates the specified BackendService resource with the data included in
  /// the request. There are several restrictions and guidelines to keep in mind
  /// when updating a backend service. Read  Restrictions and Guidelines for
  /// more information.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [backendService] - Name of the BackendService resource to update.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> update(
      BackendService request, core.String project, core.String backendService,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (backendService == null) {
      throw new core.ArgumentError("Parameter backendService is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/backendServices/' +
        commons.Escaper.ecapeVariable('$backendService');

    var _response = _requester.request(_url, "PUT",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }
}

class DiskTypesResourceApi {
  final commons.ApiRequester _requester;

  DiskTypesResourceApi(commons.ApiRequester client) : _requester = client;

  /// Retrieves an aggregated list of disk types.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [DiskTypeAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<DiskTypeAggregatedList> aggregatedList(core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/aggregated/diskTypes';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new DiskTypeAggregatedList.fromJson(data));
  }

  /// Returns the specified disk type. Gets a list of available disk types by
  /// making a list() request.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [diskType] - Name of the disk type to return.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [DiskType].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<DiskType> get(
      core.String project, core.String zone, core.String diskType,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (diskType == null) {
      throw new core.ArgumentError("Parameter diskType is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/diskTypes/' +
        commons.Escaper.ecapeVariable('$diskType');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new DiskType.fromJson(data));
  }

  /// Retrieves a list of disk types available to the specified project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [DiskTypeList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<DiskTypeList> list(core.String project, core.String zone,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/diskTypes';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new DiskTypeList.fromJson(data));
  }
}

class DisksResourceApi {
  final commons.ApiRequester _requester;

  DisksResourceApi(commons.ApiRequester client) : _requester = client;

  /// Adds existing resource policies to a disk. You can only add one policy
  /// which will be applied to this disk for scheduling snapshot creation.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [disk] - The disk name for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> addResourcePolicies(
      DisksAddResourcePoliciesRequest request,
      core.String project,
      core.String zone,
      core.String disk,
      {core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (disk == null) {
      throw new core.ArgumentError("Parameter disk is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/disks/' +
        commons.Escaper.ecapeVariable('$disk') +
        '/addResourcePolicies';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves an aggregated list of persistent disks.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [DiskAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<DiskAggregatedList> aggregatedList(core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/aggregated/disks';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new DiskAggregatedList.fromJson(data));
  }

  /// Creates a snapshot of a specified persistent disk.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [disk] - Name of the persistent disk to snapshot.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [guestFlush] - [Input Only] Specifies to create an application consistent
  /// snapshot by informing the OS to prepare for the snapshot process.
  /// Currently only supported on Windows instances using the Volume Shadow Copy
  /// Service (VSS).
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> createSnapshot(
      Snapshot request, core.String project, core.String zone, core.String disk,
      {core.bool guestFlush, core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (disk == null) {
      throw new core.ArgumentError("Parameter disk is required.");
    }
    if (guestFlush != null) {
      _queryParams["guestFlush"] = ["${guestFlush}"];
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/disks/' +
        commons.Escaper.ecapeVariable('$disk') +
        '/createSnapshot';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Deletes the specified persistent disk. Deleting a disk removes its data
  /// permanently and is irreversible. However, deleting a disk does not delete
  /// any snapshots previously made from the disk. You must separately delete
  /// snapshots.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [disk] - Name of the persistent disk to delete.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
      core.String project, core.String zone, core.String disk,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (disk == null) {
      throw new core.ArgumentError("Parameter disk is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/disks/' +
        commons.Escaper.ecapeVariable('$disk');

    var _response = _requester.request(_url, "DELETE",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns a specified persistent disk. Gets a list of available persistent
  /// disks by making a list() request.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [disk] - Name of the persistent disk to return.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Disk].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Disk> get(
      core.String project, core.String zone, core.String disk,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (disk == null) {
      throw new core.ArgumentError("Parameter disk is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/disks/' +
        commons.Escaper.ecapeVariable('$disk');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Disk.fromJson(data));
  }

  /// Gets the access control policy for a resource. May be empty if no such
  /// policy or resource exists.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> getIamPolicy(
      core.String project, core.String zone, core.String resource,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (resource == null) {
      throw new core.ArgumentError("Parameter resource is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/disks/' +
        commons.Escaper.ecapeVariable('$resource') +
        '/getIamPolicy';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Policy.fromJson(data));
  }

  /// Creates a persistent disk in the specified project using the data in the
  /// request. You can create a disk with a sourceImage, a sourceSnapshot, or
  /// create an empty 500 GB data disk by omitting all properties. You can also
  /// create a disk that is larger than the default size by specifying the
  /// sizeGb property.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [sourceImage] - Optional. Source image to restore onto a disk.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
      Disk request, core.String project, core.String zone,
      {core.String requestId, core.String sourceImage, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if (sourceImage != null) {
      _queryParams["sourceImage"] = [sourceImage];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/disks';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves a list of persistent disks contained within the specified zone.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [DiskList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<DiskList> list(core.String project, core.String zone,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/disks';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new DiskList.fromJson(data));
  }

  /// Removes resource policies from a disk.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [disk] - The disk name for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> removeResourcePolicies(
      DisksRemoveResourcePoliciesRequest request,
      core.String project,
      core.String zone,
      core.String disk,
      {core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (disk == null) {
      throw new core.ArgumentError("Parameter disk is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/disks/' +
        commons.Escaper.ecapeVariable('$disk') +
        '/removeResourcePolicies';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Resizes the specified persistent disk. You can only increase the size of
  /// the disk.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [disk] - The name of the persistent disk.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> resize(DisksResizeRequest request,
      core.String project, core.String zone, core.String disk,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (disk == null) {
      throw new core.ArgumentError("Parameter disk is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/disks/' +
        commons.Escaper.ecapeVariable('$disk') +
        '/resize';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Sets the access control policy on the specified resource. Replaces any
  /// existing policy.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> setIamPolicy(ZoneSetPolicyRequest request,
      core.String project, core.String zone, core.String resource,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (resource == null) {
      throw new core.ArgumentError("Parameter resource is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/disks/' +
        commons.Escaper.ecapeVariable('$resource') +
        '/setIamPolicy';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Policy.fromJson(data));
  }

  /// Sets the labels on a disk. To learn more about labels, read the Labeling
  /// Resources documentation.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setLabels(ZoneSetLabelsRequest request,
      core.String project, core.String zone, core.String resource,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (resource == null) {
      throw new core.ArgumentError("Parameter resource is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/disks/' +
        commons.Escaper.ecapeVariable('$resource') +
        '/setLabels';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [TestPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<TestPermissionsResponse> testIamPermissions(
      TestPermissionsRequest request,
      core.String project,
      core.String zone,
      core.String resource,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (resource == null) {
      throw new core.ArgumentError("Parameter resource is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/disks/' +
        commons.Escaper.ecapeVariable('$resource') +
        '/testIamPermissions';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new TestPermissionsResponse.fromJson(data));
  }
}

class FirewallsResourceApi {
  final commons.ApiRequester _requester;

  FirewallsResourceApi(commons.ApiRequester client) : _requester = client;

  /// Deletes the specified firewall.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [firewall] - Name of the firewall rule to delete.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(core.String project, core.String firewall,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (firewall == null) {
      throw new core.ArgumentError("Parameter firewall is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/firewalls/' +
        commons.Escaper.ecapeVariable('$firewall');

    var _response = _requester.request(_url, "DELETE",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns the specified firewall.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [firewall] - Name of the firewall rule to return.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Firewall].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Firewall> get(core.String project, core.String firewall,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (firewall == null) {
      throw new core.ArgumentError("Parameter firewall is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/firewalls/' +
        commons.Escaper.ecapeVariable('$firewall');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Firewall.fromJson(data));
  }

  /// Creates a firewall rule in the specified project using the data included
  /// in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(Firewall request, core.String project,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/global/firewalls';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves the list of firewall rules available to the specified project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [FirewallList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<FirewallList> list(core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/global/firewalls';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new FirewallList.fromJson(data));
  }

  /// Updates the specified firewall rule with the data included in the request.
  /// This method supports PATCH semantics and uses the JSON merge patch format
  /// and processing rules.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [firewall] - Name of the firewall rule to patch.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patch(
      Firewall request, core.String project, core.String firewall,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (firewall == null) {
      throw new core.ArgumentError("Parameter firewall is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/firewalls/' +
        commons.Escaper.ecapeVariable('$firewall');

    var _response = _requester.request(_url, "PATCH",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Updates the specified firewall rule with the data included in the request.
  /// The PUT method can only update the following fields of firewall rule:
  /// allowed, description, sourceRanges, sourceTags, targetTags.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [firewall] - Name of the firewall rule to update.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> update(
      Firewall request, core.String project, core.String firewall,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (firewall == null) {
      throw new core.ArgumentError("Parameter firewall is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/firewalls/' +
        commons.Escaper.ecapeVariable('$firewall');

    var _response = _requester.request(_url, "PUT",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }
}

class ForwardingRulesResourceApi {
  final commons.ApiRequester _requester;

  ForwardingRulesResourceApi(commons.ApiRequester client) : _requester = client;

  /// Retrieves an aggregated list of forwarding rules.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ForwardingRuleAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ForwardingRuleAggregatedList> aggregatedList(core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/aggregated/forwardingRules';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response
        .then((data) => new ForwardingRuleAggregatedList.fromJson(data));
  }

  /// Deletes the specified ForwardingRule resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [forwardingRule] - Name of the ForwardingRule resource to delete.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
      core.String project, core.String region, core.String forwardingRule,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (forwardingRule == null) {
      throw new core.ArgumentError("Parameter forwardingRule is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/forwardingRules/' +
        commons.Escaper.ecapeVariable('$forwardingRule');

    var _response = _requester.request(_url, "DELETE",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns the specified ForwardingRule resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [forwardingRule] - Name of the ForwardingRule resource to return.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ForwardingRule].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ForwardingRule> get(
      core.String project, core.String region, core.String forwardingRule,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (forwardingRule == null) {
      throw new core.ArgumentError("Parameter forwardingRule is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/forwardingRules/' +
        commons.Escaper.ecapeVariable('$forwardingRule');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new ForwardingRule.fromJson(data));
  }

  /// Creates a ForwardingRule resource in the specified project and region
  /// using the data included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
      ForwardingRule request, core.String project, core.String region,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/forwardingRules';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves a list of ForwardingRule resources available to the specified
  /// project and region.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ForwardingRuleList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ForwardingRuleList> list(core.String project, core.String region,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/forwardingRules';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new ForwardingRuleList.fromJson(data));
  }

  /// Changes target URL for forwarding rule. The new target should be of the
  /// same type as the old target.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [forwardingRule] - Name of the ForwardingRule resource in which target is
  /// to be set.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setTarget(TargetReference request,
      core.String project, core.String region, core.String forwardingRule,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (forwardingRule == null) {
      throw new core.ArgumentError("Parameter forwardingRule is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/forwardingRules/' +
        commons.Escaper.ecapeVariable('$forwardingRule') +
        '/setTarget';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }
}

class GlobalAddressesResourceApi {
  final commons.ApiRequester _requester;

  GlobalAddressesResourceApi(commons.ApiRequester client) : _requester = client;

  /// Deletes the specified address resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [address] - Name of the address resource to delete.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(core.String project, core.String address,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (address == null) {
      throw new core.ArgumentError("Parameter address is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/addresses/' +
        commons.Escaper.ecapeVariable('$address');

    var _response = _requester.request(_url, "DELETE",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns the specified address resource. Gets a list of available addresses
  /// by making a list() request.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [address] - Name of the address resource to return.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Address].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Address> get(core.String project, core.String address,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (address == null) {
      throw new core.ArgumentError("Parameter address is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/addresses/' +
        commons.Escaper.ecapeVariable('$address');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Address.fromJson(data));
  }

  /// Creates an address resource in the specified project by using the data
  /// included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(Address request, core.String project,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/global/addresses';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves a list of global addresses.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AddressList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AddressList> list(core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/global/addresses';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new AddressList.fromJson(data));
  }
}

class GlobalForwardingRulesResourceApi {
  final commons.ApiRequester _requester;

  GlobalForwardingRulesResourceApi(commons.ApiRequester client)
      : _requester = client;

  /// Deletes the specified GlobalForwardingRule resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [forwardingRule] - Name of the ForwardingRule resource to delete.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
      core.String project, core.String forwardingRule,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (forwardingRule == null) {
      throw new core.ArgumentError("Parameter forwardingRule is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/forwardingRules/' +
        commons.Escaper.ecapeVariable('$forwardingRule');

    var _response = _requester.request(_url, "DELETE",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns the specified GlobalForwardingRule resource. Gets a list of
  /// available forwarding rules by making a list() request.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [forwardingRule] - Name of the ForwardingRule resource to return.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ForwardingRule].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ForwardingRule> get(
      core.String project, core.String forwardingRule,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (forwardingRule == null) {
      throw new core.ArgumentError("Parameter forwardingRule is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/forwardingRules/' +
        commons.Escaper.ecapeVariable('$forwardingRule');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new ForwardingRule.fromJson(data));
  }

  /// Creates a GlobalForwardingRule resource in the specified project using the
  /// data included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(ForwardingRule request, core.String project,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url =
        commons.Escaper.ecapeVariable('$project') + '/global/forwardingRules';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves a list of GlobalForwardingRule resources available to the
  /// specified project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ForwardingRuleList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ForwardingRuleList> list(core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url =
        commons.Escaper.ecapeVariable('$project') + '/global/forwardingRules';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new ForwardingRuleList.fromJson(data));
  }

  /// Changes target URL for the GlobalForwardingRule resource. The new target
  /// should be of the same type as the old target.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [forwardingRule] - Name of the ForwardingRule resource in which target is
  /// to be set.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setTarget(
      TargetReference request, core.String project, core.String forwardingRule,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (forwardingRule == null) {
      throw new core.ArgumentError("Parameter forwardingRule is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/forwardingRules/' +
        commons.Escaper.ecapeVariable('$forwardingRule') +
        '/setTarget';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }
}

class GlobalOperationsResourceApi {
  final commons.ApiRequester _requester;

  GlobalOperationsResourceApi(commons.ApiRequester client)
      : _requester = client;

  /// Retrieves an aggregated list of all operations.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OperationAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OperationAggregatedList> aggregatedList(core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/aggregated/operations';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new OperationAggregatedList.fromJson(data));
  }

  /// Deletes the specified Operations resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [operation] - Name of the Operations resource to delete.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future delete(core.String project, core.String operation,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (operation == null) {
      throw new core.ArgumentError("Parameter operation is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _downloadOptions = null;

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/operations/' +
        commons.Escaper.ecapeVariable('$operation');

    var _response = _requester.request(_url, "DELETE",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => null);
  }

  /// Retrieves the specified Operations resource. Gets a list of operations by
  /// making a list() request.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [operation] - Name of the Operations resource to return.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> get(core.String project, core.String operation,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (operation == null) {
      throw new core.ArgumentError("Parameter operation is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/operations/' +
        commons.Escaper.ecapeVariable('$operation');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves a list of Operation resources contained within the specified
  /// project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OperationList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OperationList> list(core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/global/operations';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new OperationList.fromJson(data));
  }
}

class HealthChecksResourceApi {
  final commons.ApiRequester _requester;

  HealthChecksResourceApi(commons.ApiRequester client) : _requester = client;

  /// Deletes the specified HealthCheck resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [healthCheck] - Name of the HealthCheck resource to delete.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(core.String project, core.String healthCheck,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (healthCheck == null) {
      throw new core.ArgumentError("Parameter healthCheck is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/healthChecks/' +
        commons.Escaper.ecapeVariable('$healthCheck');

    var _response = _requester.request(_url, "DELETE",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns the specified HealthCheck resource. Gets a list of available
  /// health checks by making a list() request.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [healthCheck] - Name of the HealthCheck resource to return.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [HealthCheck].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<HealthCheck> get(core.String project, core.String healthCheck,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (healthCheck == null) {
      throw new core.ArgumentError("Parameter healthCheck is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/healthChecks/' +
        commons.Escaper.ecapeVariable('$healthCheck');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new HealthCheck.fromJson(data));
  }

  /// Creates a HealthCheck resource in the specified project using the data
  /// included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(HealthCheck request, core.String project,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/global/healthChecks';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves the list of HealthCheck resources available to the specified
  /// project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [HealthCheckList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<HealthCheckList> list(core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/global/healthChecks';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new HealthCheckList.fromJson(data));
  }

  /// Updates a HealthCheck resource in the specified project using the data
  /// included in the request. This method supports PATCH semantics and uses the
  /// JSON merge patch format and processing rules.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [healthCheck] - Name of the HealthCheck resource to patch.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patch(
      HealthCheck request, core.String project, core.String healthCheck,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (healthCheck == null) {
      throw new core.ArgumentError("Parameter healthCheck is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/healthChecks/' +
        commons.Escaper.ecapeVariable('$healthCheck');

    var _response = _requester.request(_url, "PATCH",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Updates a HealthCheck resource in the specified project using the data
  /// included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [healthCheck] - Name of the HealthCheck resource to update.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> update(
      HealthCheck request, core.String project, core.String healthCheck,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (healthCheck == null) {
      throw new core.ArgumentError("Parameter healthCheck is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/healthChecks/' +
        commons.Escaper.ecapeVariable('$healthCheck');

    var _response = _requester.request(_url, "PUT",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }
}

class HttpHealthChecksResourceApi {
  final commons.ApiRequester _requester;

  HttpHealthChecksResourceApi(commons.ApiRequester client)
      : _requester = client;

  /// Deletes the specified HttpHealthCheck resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [httpHealthCheck] - Name of the HttpHealthCheck resource to delete.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
      core.String project, core.String httpHealthCheck,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (httpHealthCheck == null) {
      throw new core.ArgumentError("Parameter httpHealthCheck is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/httpHealthChecks/' +
        commons.Escaper.ecapeVariable('$httpHealthCheck');

    var _response = _requester.request(_url, "DELETE",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns the specified HttpHealthCheck resource. Gets a list of available
  /// HTTP health checks by making a list() request.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [httpHealthCheck] - Name of the HttpHealthCheck resource to return.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [HttpHealthCheck].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<HttpHealthCheck> get(
      core.String project, core.String httpHealthCheck,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (httpHealthCheck == null) {
      throw new core.ArgumentError("Parameter httpHealthCheck is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/httpHealthChecks/' +
        commons.Escaper.ecapeVariable('$httpHealthCheck');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new HttpHealthCheck.fromJson(data));
  }

  /// Creates a HttpHealthCheck resource in the specified project using the data
  /// included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(HttpHealthCheck request, core.String project,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url =
        commons.Escaper.ecapeVariable('$project') + '/global/httpHealthChecks';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves the list of HttpHealthCheck resources available to the specified
  /// project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [HttpHealthCheckList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<HttpHealthCheckList> list(core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url =
        commons.Escaper.ecapeVariable('$project') + '/global/httpHealthChecks';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new HttpHealthCheckList.fromJson(data));
  }

  /// Updates a HttpHealthCheck resource in the specified project using the data
  /// included in the request. This method supports PATCH semantics and uses the
  /// JSON merge patch format and processing rules.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [httpHealthCheck] - Name of the HttpHealthCheck resource to patch.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patch(
      HttpHealthCheck request, core.String project, core.String httpHealthCheck,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (httpHealthCheck == null) {
      throw new core.ArgumentError("Parameter httpHealthCheck is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/httpHealthChecks/' +
        commons.Escaper.ecapeVariable('$httpHealthCheck');

    var _response = _requester.request(_url, "PATCH",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Updates a HttpHealthCheck resource in the specified project using the data
  /// included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [httpHealthCheck] - Name of the HttpHealthCheck resource to update.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> update(
      HttpHealthCheck request, core.String project, core.String httpHealthCheck,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (httpHealthCheck == null) {
      throw new core.ArgumentError("Parameter httpHealthCheck is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/httpHealthChecks/' +
        commons.Escaper.ecapeVariable('$httpHealthCheck');

    var _response = _requester.request(_url, "PUT",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }
}

class HttpsHealthChecksResourceApi {
  final commons.ApiRequester _requester;

  HttpsHealthChecksResourceApi(commons.ApiRequester client)
      : _requester = client;

  /// Deletes the specified HttpsHealthCheck resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [httpsHealthCheck] - Name of the HttpsHealthCheck resource to delete.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
      core.String project, core.String httpsHealthCheck,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (httpsHealthCheck == null) {
      throw new core.ArgumentError("Parameter httpsHealthCheck is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/httpsHealthChecks/' +
        commons.Escaper.ecapeVariable('$httpsHealthCheck');

    var _response = _requester.request(_url, "DELETE",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns the specified HttpsHealthCheck resource. Gets a list of available
  /// HTTPS health checks by making a list() request.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [httpsHealthCheck] - Name of the HttpsHealthCheck resource to return.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [HttpsHealthCheck].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<HttpsHealthCheck> get(
      core.String project, core.String httpsHealthCheck,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (httpsHealthCheck == null) {
      throw new core.ArgumentError("Parameter httpsHealthCheck is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/httpsHealthChecks/' +
        commons.Escaper.ecapeVariable('$httpsHealthCheck');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new HttpsHealthCheck.fromJson(data));
  }

  /// Creates a HttpsHealthCheck resource in the specified project using the
  /// data included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(HttpsHealthCheck request, core.String project,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url =
        commons.Escaper.ecapeVariable('$project') + '/global/httpsHealthChecks';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves the list of HttpsHealthCheck resources available to the
  /// specified project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [HttpsHealthCheckList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<HttpsHealthCheckList> list(core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url =
        commons.Escaper.ecapeVariable('$project') + '/global/httpsHealthChecks';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new HttpsHealthCheckList.fromJson(data));
  }

  /// Updates a HttpsHealthCheck resource in the specified project using the
  /// data included in the request. This method supports PATCH semantics and
  /// uses the JSON merge patch format and processing rules.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [httpsHealthCheck] - Name of the HttpsHealthCheck resource to patch.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patch(HttpsHealthCheck request, core.String project,
      core.String httpsHealthCheck,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (httpsHealthCheck == null) {
      throw new core.ArgumentError("Parameter httpsHealthCheck is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/httpsHealthChecks/' +
        commons.Escaper.ecapeVariable('$httpsHealthCheck');

    var _response = _requester.request(_url, "PATCH",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Updates a HttpsHealthCheck resource in the specified project using the
  /// data included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [httpsHealthCheck] - Name of the HttpsHealthCheck resource to update.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> update(HttpsHealthCheck request, core.String project,
      core.String httpsHealthCheck,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (httpsHealthCheck == null) {
      throw new core.ArgumentError("Parameter httpsHealthCheck is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/httpsHealthChecks/' +
        commons.Escaper.ecapeVariable('$httpsHealthCheck');

    var _response = _requester.request(_url, "PUT",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }
}

class ImagesResourceApi {
  final commons.ApiRequester _requester;

  ImagesResourceApi(commons.ApiRequester client) : _requester = client;

  /// Deletes the specified image.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [image] - Name of the image resource to delete.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(core.String project, core.String image,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (image == null) {
      throw new core.ArgumentError("Parameter image is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/images/' +
        commons.Escaper.ecapeVariable('$image');

    var _response = _requester.request(_url, "DELETE",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Sets the deprecation status of an image.
  ///
  /// If an empty request body is given, clears the deprecation status instead.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [image] - Image name.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> deprecate(
      DeprecationStatus request, core.String project, core.String image,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (image == null) {
      throw new core.ArgumentError("Parameter image is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/images/' +
        commons.Escaper.ecapeVariable('$image') +
        '/deprecate';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns the specified image. Gets a list of available images by making a
  /// list() request.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [image] - Name of the image resource to return.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Image].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Image> get(core.String project, core.String image,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (image == null) {
      throw new core.ArgumentError("Parameter image is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/images/' +
        commons.Escaper.ecapeVariable('$image');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Image.fromJson(data));
  }

  /// Returns the latest image that is part of an image family and is not
  /// deprecated.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [family] - Name of the image family to search for.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Image].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Image> getFromFamily(core.String project, core.String family,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (family == null) {
      throw new core.ArgumentError("Parameter family is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/images/family/' +
        commons.Escaper.ecapeVariable('$family');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Image.fromJson(data));
  }

  /// Gets the access control policy for a resource. May be empty if no such
  /// policy or resource exists.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> getIamPolicy(core.String project, core.String resource,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (resource == null) {
      throw new core.ArgumentError("Parameter resource is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/images/' +
        commons.Escaper.ecapeVariable('$resource') +
        '/getIamPolicy';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Policy.fromJson(data));
  }

  /// Creates an image in the specified project using the data included in the
  /// request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [forceCreate] - Force image creation if true.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(Image request, core.String project,
      {core.bool forceCreate, core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (forceCreate != null) {
      _queryParams["forceCreate"] = ["${forceCreate}"];
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/global/images';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves the list of custom images available to the specified project.
  /// Custom images are images you create that belong to your project. This
  /// method does not get any images that belong to other projects, including
  /// publicly-available images, like Debian 8. If you want to get a list of
  /// publicly-available images, use this method to make a request to the
  /// respective image project, such as debian-cloud or windows-cloud.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ImageList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ImageList> list(core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/global/images';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new ImageList.fromJson(data));
  }

  /// Sets the access control policy on the specified resource. Replaces any
  /// existing policy.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> setIamPolicy(
      GlobalSetPolicyRequest request, core.String project, core.String resource,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (resource == null) {
      throw new core.ArgumentError("Parameter resource is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/images/' +
        commons.Escaper.ecapeVariable('$resource') +
        '/setIamPolicy';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Policy.fromJson(data));
  }

  /// Sets the labels on an image. To learn more about labels, read the Labeling
  /// Resources documentation.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setLabels(
      GlobalSetLabelsRequest request, core.String project, core.String resource,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (resource == null) {
      throw new core.ArgumentError("Parameter resource is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/images/' +
        commons.Escaper.ecapeVariable('$resource') +
        '/setLabels';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [TestPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<TestPermissionsResponse> testIamPermissions(
      TestPermissionsRequest request, core.String project, core.String resource,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (resource == null) {
      throw new core.ArgumentError("Parameter resource is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/images/' +
        commons.Escaper.ecapeVariable('$resource') +
        '/testIamPermissions';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new TestPermissionsResponse.fromJson(data));
  }
}

class InstanceGroupManagersResourceApi {
  final commons.ApiRequester _requester;

  InstanceGroupManagersResourceApi(commons.ApiRequester client)
      : _requester = client;

  /// Flags the specified instances to be removed from the managed instance
  /// group. Abandoning an instance does not delete the instance, but it does
  /// remove the instance from any target pools that are applied by the managed
  /// instance group. This method reduces the targetSize of the managed instance
  /// group by the number of instances that you abandon. This operation is
  /// marked as DONE when the action is scheduled even if the instances have not
  /// yet been removed from the group. You must separately verify the status of
  /// the abandoning action with the listmanagedinstances method.
  ///
  /// If the group is part of a backend service that has enabled connection
  /// draining, it can take up to 60 seconds after the connection draining
  /// duration has elapsed before the VM instance is removed or deleted.
  ///
  /// You can specify a maximum of 1000 instances with this method per request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  ///
  /// [instanceGroupManager] - The name of the managed instance group.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> abandonInstances(
      InstanceGroupManagersAbandonInstancesRequest request,
      core.String project,
      core.String zone,
      core.String instanceGroupManager,
      {core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instanceGroupManager == null) {
      throw new core.ArgumentError(
          "Parameter instanceGroupManager is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.Escaper.ecapeVariable('$instanceGroupManager') +
        '/abandonInstances';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves the list of managed instance groups and groups them by zone.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceGroupManagerAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceGroupManagerAggregatedList> aggregatedList(
      core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/aggregated/instanceGroupManagers';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response
        .then((data) => new InstanceGroupManagerAggregatedList.fromJson(data));
  }

  /// Deletes the specified managed instance group and all of the instances in
  /// that group. Note that the instance group must not belong to a backend
  /// service. Read  Deleting an instance group for more information.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  ///
  /// [instanceGroupManager] - The name of the managed instance group to delete.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
      core.String project, core.String zone, core.String instanceGroupManager,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instanceGroupManager == null) {
      throw new core.ArgumentError(
          "Parameter instanceGroupManager is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.Escaper.ecapeVariable('$instanceGroupManager');

    var _response = _requester.request(_url, "DELETE",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Flags the specified instances in the managed instance group for immediate
  /// deletion. The instances are also removed from any target pools of which
  /// they were a member. This method reduces the targetSize of the managed
  /// instance group by the number of instances that you delete. This operation
  /// is marked as DONE when the action is scheduled even if the instances are
  /// still being deleted. You must separately verify the status of the deleting
  /// action with the listmanagedinstances method.
  ///
  /// If the group is part of a backend service that has enabled connection
  /// draining, it can take up to 60 seconds after the connection draining
  /// duration has elapsed before the VM instance is removed or deleted.
  ///
  /// You can specify a maximum of 1000 instances with this method per request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  ///
  /// [instanceGroupManager] - The name of the managed instance group.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> deleteInstances(
      InstanceGroupManagersDeleteInstancesRequest request,
      core.String project,
      core.String zone,
      core.String instanceGroupManager,
      {core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instanceGroupManager == null) {
      throw new core.ArgumentError(
          "Parameter instanceGroupManager is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.Escaper.ecapeVariable('$instanceGroupManager') +
        '/deleteInstances';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns all of the details about the specified managed instance group.
  /// Gets a list of available managed instance groups by making a list()
  /// request.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  ///
  /// [instanceGroupManager] - The name of the managed instance group.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceGroupManager].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceGroupManager> get(
      core.String project, core.String zone, core.String instanceGroupManager,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instanceGroupManager == null) {
      throw new core.ArgumentError(
          "Parameter instanceGroupManager is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.Escaper.ecapeVariable('$instanceGroupManager');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new InstanceGroupManager.fromJson(data));
  }

  /// Creates a managed instance group using the information that you specify in
  /// the request. After the group is created, instances in the group are
  /// created using the specified instance template. This operation is marked as
  /// DONE when the group is created even if the instances in the group have not
  /// yet been created. You must separately verify the status of the individual
  /// instances with the listmanagedinstances method.
  ///
  /// A managed instance group can have up to 1000 VM instances per group.
  /// Please contact Cloud Support if you need an increase in this limit.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone where you want to create the managed
  /// instance group.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
      InstanceGroupManager request, core.String project, core.String zone,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instanceGroupManagers';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves a list of managed instance groups that are contained within the
  /// specified project and zone.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceGroupManagerList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceGroupManagerList> list(
      core.String project, core.String zone,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instanceGroupManagers';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response
        .then((data) => new InstanceGroupManagerList.fromJson(data));
  }

  /// Lists all of the instances in the managed instance group. Each instance in
  /// the list has a currentAction, which indicates the action that the managed
  /// instance group is performing on the instance. For example, if the group is
  /// still creating an instance, the currentAction is CREATING. If a previous
  /// action failed, the list displays the errors for that failed action.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  ///
  /// [instanceGroupManager] - The name of the managed instance group.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceGroupManagersListManagedInstancesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceGroupManagersListManagedInstancesResponse>
      listManagedInstances(core.String project, core.String zone,
          core.String instanceGroupManager,
          {core.String filter,
          core.int maxResults,
          core.String orderBy,
          core.String pageToken,
          core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instanceGroupManager == null) {
      throw new core.ArgumentError(
          "Parameter instanceGroupManager is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["order_by"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.Escaper.ecapeVariable('$instanceGroupManager') +
        '/listManagedInstances';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) =>
        new InstanceGroupManagersListManagedInstancesResponse.fromJson(data));
  }

  /// Updates a managed instance group using the information that you specify in
  /// the request. This operation is marked as DONE when the group is patched
  /// even if the instances in the group are still in the process of being
  /// patched. You must separately verify the status of the individual instances
  /// with the listManagedInstances method. This method supports PATCH semantics
  /// and uses the JSON merge patch format and processing rules.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone where you want to create the managed
  /// instance group.
  ///
  /// [instanceGroupManager] - The name of the instance group manager.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patch(InstanceGroupManager request,
      core.String project, core.String zone, core.String instanceGroupManager,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instanceGroupManager == null) {
      throw new core.ArgumentError(
          "Parameter instanceGroupManager is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.Escaper.ecapeVariable('$instanceGroupManager');

    var _response = _requester.request(_url, "PATCH",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Flags the specified instances in the managed instance group to be
  /// immediately recreated. The instances are deleted and recreated using the
  /// current instance template for the managed instance group. This operation
  /// is marked as DONE when the flag is set even if the instances have not yet
  /// been recreated. You must separately verify the status of the recreating
  /// action with the listmanagedinstances method.
  ///
  /// If the group is part of a backend service that has enabled connection
  /// draining, it can take up to 60 seconds after the connection draining
  /// duration has elapsed before the VM instance is removed or deleted.
  ///
  /// You can specify a maximum of 1000 instances with this method per request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  ///
  /// [instanceGroupManager] - The name of the managed instance group.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> recreateInstances(
      InstanceGroupManagersRecreateInstancesRequest request,
      core.String project,
      core.String zone,
      core.String instanceGroupManager,
      {core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instanceGroupManager == null) {
      throw new core.ArgumentError(
          "Parameter instanceGroupManager is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.Escaper.ecapeVariable('$instanceGroupManager') +
        '/recreateInstances';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Resizes the managed instance group. If you increase the size, the group
  /// creates new instances using the current instance template. If you decrease
  /// the size, the group deletes instances. The resize operation is marked DONE
  /// when the resize actions are scheduled even if the group has not yet added
  /// or deleted any instances. You must separately verify the status of the
  /// creating or deleting actions with the listmanagedinstances method.
  ///
  /// When resizing down, the instance group arbitrarily chooses the order in
  /// which VMs are deleted. The group takes into account some VM attributes
  /// when making the selection including:
  ///
  /// + The status of the VM instance. + The health of the VM instance. + The
  /// instance template version the VM is based on. + For regional managed
  /// instance groups, the location of the VM instance.
  ///
  /// This list is subject to change.
  ///
  /// If the group is part of a backend service that has enabled connection
  /// draining, it can take up to 60 seconds after the connection draining
  /// duration has elapsed before the VM instance is removed or deleted.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  ///
  /// [instanceGroupManager] - The name of the managed instance group.
  ///
  /// [size] - The number of running instances that the managed instance group
  /// should maintain at any given time. The group automatically adds or removes
  /// instances to maintain the number of instances specified by this parameter.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> resize(core.String project, core.String zone,
      core.String instanceGroupManager, core.int size,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instanceGroupManager == null) {
      throw new core.ArgumentError(
          "Parameter instanceGroupManager is required.");
    }
    if (size == null) {
      throw new core.ArgumentError("Parameter size is required.");
    }
    _queryParams["size"] = ["${size}"];
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.Escaper.ecapeVariable('$instanceGroupManager') +
        '/resize';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Specifies the instance template to use when creating new instances in this
  /// group. The templates for existing instances in the group do not change
  /// unless you recreate them.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  ///
  /// [instanceGroupManager] - The name of the managed instance group.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setInstanceTemplate(
      InstanceGroupManagersSetInstanceTemplateRequest request,
      core.String project,
      core.String zone,
      core.String instanceGroupManager,
      {core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instanceGroupManager == null) {
      throw new core.ArgumentError(
          "Parameter instanceGroupManager is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.Escaper.ecapeVariable('$instanceGroupManager') +
        '/setInstanceTemplate';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Modifies the target pools to which all instances in this managed instance
  /// group are assigned. The target pools automatically apply to all of the
  /// instances in the managed instance group. This operation is marked DONE
  /// when you make the request even if the instances have not yet been added to
  /// their target pools. The change might take some time to apply to all of the
  /// instances in the group depending on the size of the group.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  ///
  /// [instanceGroupManager] - The name of the managed instance group.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setTargetPools(
      InstanceGroupManagersSetTargetPoolsRequest request,
      core.String project,
      core.String zone,
      core.String instanceGroupManager,
      {core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instanceGroupManager == null) {
      throw new core.ArgumentError(
          "Parameter instanceGroupManager is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.Escaper.ecapeVariable('$instanceGroupManager') +
        '/setTargetPools';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }
}

class InstanceGroupsResourceApi {
  final commons.ApiRequester _requester;

  InstanceGroupsResourceApi(commons.ApiRequester client) : _requester = client;

  /// Adds a list of instances to the specified instance group. All of the
  /// instances in the instance group must be in the same network/subnetwork.
  /// Read  Adding instances for more information.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone where the instance group is located.
  ///
  /// [instanceGroup] - The name of the instance group where you are adding
  /// instances.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> addInstances(
      InstanceGroupsAddInstancesRequest request,
      core.String project,
      core.String zone,
      core.String instanceGroup,
      {core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instanceGroup == null) {
      throw new core.ArgumentError("Parameter instanceGroup is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instanceGroups/' +
        commons.Escaper.ecapeVariable('$instanceGroup') +
        '/addInstances';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves the list of instance groups and sorts them by zone.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceGroupAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceGroupAggregatedList> aggregatedList(core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/aggregated/instanceGroups';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response
        .then((data) => new InstanceGroupAggregatedList.fromJson(data));
  }

  /// Deletes the specified instance group. The instances in the group are not
  /// deleted. Note that instance group must not belong to a backend service.
  /// Read  Deleting an instance group for more information.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone where the instance group is located.
  ///
  /// [instanceGroup] - The name of the instance group to delete.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
      core.String project, core.String zone, core.String instanceGroup,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instanceGroup == null) {
      throw new core.ArgumentError("Parameter instanceGroup is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instanceGroups/' +
        commons.Escaper.ecapeVariable('$instanceGroup');

    var _response = _requester.request(_url, "DELETE",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns the specified instance group. Gets a list of available instance
  /// groups by making a list() request.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone where the instance group is located.
  ///
  /// [instanceGroup] - The name of the instance group.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceGroup].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceGroup> get(
      core.String project, core.String zone, core.String instanceGroup,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instanceGroup == null) {
      throw new core.ArgumentError("Parameter instanceGroup is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instanceGroups/' +
        commons.Escaper.ecapeVariable('$instanceGroup');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new InstanceGroup.fromJson(data));
  }

  /// Creates an instance group in the specified project using the parameters
  /// that are included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone where you want to create the instance group.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
      InstanceGroup request, core.String project, core.String zone,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instanceGroups';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves the list of instance groups that are located in the specified
  /// project and zone.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone where the instance group is located.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceGroupList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceGroupList> list(core.String project, core.String zone,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instanceGroups';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new InstanceGroupList.fromJson(data));
  }

  /// Lists the instances in the specified instance group.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone where the instance group is located.
  ///
  /// [instanceGroup] - The name of the instance group from which you want to
  /// generate a list of included instances.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceGroupsListInstances].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceGroupsListInstances> listInstances(
      InstanceGroupsListInstancesRequest request,
      core.String project,
      core.String zone,
      core.String instanceGroup,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instanceGroup == null) {
      throw new core.ArgumentError("Parameter instanceGroup is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instanceGroups/' +
        commons.Escaper.ecapeVariable('$instanceGroup') +
        '/listInstances';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response
        .then((data) => new InstanceGroupsListInstances.fromJson(data));
  }

  /// Removes one or more instances from the specified instance group, but does
  /// not delete those instances.
  ///
  /// If the group is part of a backend service that has enabled connection
  /// draining, it can take up to 60 seconds after the connection draining
  /// duration before the VM instance is removed or deleted.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone where the instance group is located.
  ///
  /// [instanceGroup] - The name of the instance group where the specified
  /// instances will be removed.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> removeInstances(
      InstanceGroupsRemoveInstancesRequest request,
      core.String project,
      core.String zone,
      core.String instanceGroup,
      {core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instanceGroup == null) {
      throw new core.ArgumentError("Parameter instanceGroup is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instanceGroups/' +
        commons.Escaper.ecapeVariable('$instanceGroup') +
        '/removeInstances';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Sets the named ports for the specified instance group.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone where the instance group is located.
  ///
  /// [instanceGroup] - The name of the instance group where the named ports are
  /// updated.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setNamedPorts(
      InstanceGroupsSetNamedPortsRequest request,
      core.String project,
      core.String zone,
      core.String instanceGroup,
      {core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instanceGroup == null) {
      throw new core.ArgumentError("Parameter instanceGroup is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instanceGroups/' +
        commons.Escaper.ecapeVariable('$instanceGroup') +
        '/setNamedPorts';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }
}

class InstanceTemplatesResourceApi {
  final commons.ApiRequester _requester;

  InstanceTemplatesResourceApi(commons.ApiRequester client)
      : _requester = client;

  /// Deletes the specified instance template. Deleting an instance template is
  /// permanent and cannot be undone. It is not possible to delete templates
  /// that are already in use by a managed instance group.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [instanceTemplate] - The name of the instance template to delete.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
      core.String project, core.String instanceTemplate,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (instanceTemplate == null) {
      throw new core.ArgumentError("Parameter instanceTemplate is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/instanceTemplates/' +
        commons.Escaper.ecapeVariable('$instanceTemplate');

    var _response = _requester.request(_url, "DELETE",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns the specified instance template. Gets a list of available instance
  /// templates by making a list() request.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [instanceTemplate] - The name of the instance template.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceTemplate].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceTemplate> get(
      core.String project, core.String instanceTemplate,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (instanceTemplate == null) {
      throw new core.ArgumentError("Parameter instanceTemplate is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/instanceTemplates/' +
        commons.Escaper.ecapeVariable('$instanceTemplate');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new InstanceTemplate.fromJson(data));
  }

  /// Gets the access control policy for a resource. May be empty if no such
  /// policy or resource exists.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> getIamPolicy(core.String project, core.String resource,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (resource == null) {
      throw new core.ArgumentError("Parameter resource is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/instanceTemplates/' +
        commons.Escaper.ecapeVariable('$resource') +
        '/getIamPolicy';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Policy.fromJson(data));
  }

  /// Creates an instance template in the specified project using the data that
  /// is included in the request. If you are creating a new template to update
  /// an existing instance group, your new instance template must use the same
  /// network or, if applicable, the same subnetwork as the original template.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(InstanceTemplate request, core.String project,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url =
        commons.Escaper.ecapeVariable('$project') + '/global/instanceTemplates';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves a list of instance templates that are contained within the
  /// specified project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceTemplateList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceTemplateList> list(core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url =
        commons.Escaper.ecapeVariable('$project') + '/global/instanceTemplates';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new InstanceTemplateList.fromJson(data));
  }

  /// Sets the access control policy on the specified resource. Replaces any
  /// existing policy.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> setIamPolicy(
      GlobalSetPolicyRequest request, core.String project, core.String resource,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (resource == null) {
      throw new core.ArgumentError("Parameter resource is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/instanceTemplates/' +
        commons.Escaper.ecapeVariable('$resource') +
        '/setIamPolicy';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Policy.fromJson(data));
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [TestPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<TestPermissionsResponse> testIamPermissions(
      TestPermissionsRequest request, core.String project, core.String resource,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (resource == null) {
      throw new core.ArgumentError("Parameter resource is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/instanceTemplates/' +
        commons.Escaper.ecapeVariable('$resource') +
        '/testIamPermissions';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new TestPermissionsResponse.fromJson(data));
  }
}

class InstancesResourceApi {
  final commons.ApiRequester _requester;

  InstancesResourceApi(commons.ApiRequester client) : _requester = client;

  /// Adds an access config to an instance's network interface.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [instance] - The instance name for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [networkInterface] - The name of the network interface to add to this
  /// instance.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> addAccessConfig(
      AccessConfig request,
      core.String project,
      core.String zone,
      core.String instance,
      core.String networkInterface,
      {core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instance == null) {
      throw new core.ArgumentError("Parameter instance is required.");
    }
    if (networkInterface == null) {
      throw new core.ArgumentError("Parameter networkInterface is required.");
    }
    _queryParams["networkInterface"] = [networkInterface];
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances/' +
        commons.Escaper.ecapeVariable('$instance') +
        '/addAccessConfig';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves aggregated list of all of the instances in your project across
  /// all regions and zones.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceAggregatedList> aggregatedList(core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/aggregated/instances';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new InstanceAggregatedList.fromJson(data));
  }

  /// Attaches an existing Disk resource to an instance. You must first create
  /// the disk before you can attach it. It is not possible to create and attach
  /// a disk at the same time. For more information, read Adding a persistent
  /// disk to your instance.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [instance] - The instance name for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [forceAttach] - Whether to force attach the disk even if it's currently
  /// attached to another instance.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> attachDisk(AttachedDisk request, core.String project,
      core.String zone, core.String instance,
      {core.bool forceAttach, core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instance == null) {
      throw new core.ArgumentError("Parameter instance is required.");
    }
    if (forceAttach != null) {
      _queryParams["forceAttach"] = ["${forceAttach}"];
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances/' +
        commons.Escaper.ecapeVariable('$instance') +
        '/attachDisk';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Deletes the specified Instance resource. For more information, see
  /// Stopping or Deleting an Instance.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [instance] - Name of the instance resource to delete.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
      core.String project, core.String zone, core.String instance,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instance == null) {
      throw new core.ArgumentError("Parameter instance is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances/' +
        commons.Escaper.ecapeVariable('$instance');

    var _response = _requester.request(_url, "DELETE",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Deletes an access config from an instance's network interface.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [instance] - The instance name for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [accessConfig] - The name of the access config to delete.
  ///
  /// [networkInterface] - The name of the network interface.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> deleteAccessConfig(
      core.String project,
      core.String zone,
      core.String instance,
      core.String accessConfig,
      core.String networkInterface,
      {core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instance == null) {
      throw new core.ArgumentError("Parameter instance is required.");
    }
    if (accessConfig == null) {
      throw new core.ArgumentError("Parameter accessConfig is required.");
    }
    _queryParams["accessConfig"] = [accessConfig];
    if (networkInterface == null) {
      throw new core.ArgumentError("Parameter networkInterface is required.");
    }
    _queryParams["networkInterface"] = [networkInterface];
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances/' +
        commons.Escaper.ecapeVariable('$instance') +
        '/deleteAccessConfig';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Detaches a disk from an instance.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [instance] - Instance name for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [deviceName] - The device name of the disk to detach. Make a get() request
  /// on the instance to view currently attached disks and device names.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> detachDisk(core.String project, core.String zone,
      core.String instance, core.String deviceName,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instance == null) {
      throw new core.ArgumentError("Parameter instance is required.");
    }
    if (deviceName == null) {
      throw new core.ArgumentError("Parameter deviceName is required.");
    }
    _queryParams["deviceName"] = [deviceName];
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances/' +
        commons.Escaper.ecapeVariable('$instance') +
        '/detachDisk';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns the specified Instance resource. Gets a list of available
  /// instances by making a list() request.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [instance] - Name of the instance resource to return.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Instance].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Instance> get(
      core.String project, core.String zone, core.String instance,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instance == null) {
      throw new core.ArgumentError("Parameter instance is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances/' +
        commons.Escaper.ecapeVariable('$instance');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Instance.fromJson(data));
  }

  /// Returns the specified guest attributes entry.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [instance] - Name of the instance scoping this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [queryPath] - Specifies the guest attributes path to be queried.
  ///
  /// [variableKey] - Specifies the key for the guest attributes entry.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GuestAttributes].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GuestAttributes> getGuestAttributes(
      core.String project, core.String zone, core.String instance,
      {core.String queryPath, core.String variableKey, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instance == null) {
      throw new core.ArgumentError("Parameter instance is required.");
    }
    if (queryPath != null) {
      _queryParams["queryPath"] = [queryPath];
    }
    if (variableKey != null) {
      _queryParams["variableKey"] = [variableKey];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances/' +
        commons.Escaper.ecapeVariable('$instance') +
        '/getGuestAttributes';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new GuestAttributes.fromJson(data));
  }

  /// Gets the access control policy for a resource. May be empty if no such
  /// policy or resource exists.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> getIamPolicy(
      core.String project, core.String zone, core.String resource,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (resource == null) {
      throw new core.ArgumentError("Parameter resource is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances/' +
        commons.Escaper.ecapeVariable('$resource') +
        '/getIamPolicy';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Policy.fromJson(data));
  }

  /// Returns the last 1 MB of serial port output from the specified instance.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [instance] - Name of the instance scoping this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [port] - Specifies which COM or serial port to retrieve data from.
  /// Value must be between "1" and "4".
  ///
  /// [start_1] - Returns output starting from a specific byte position. Use
  /// this to page through output when the output is too large to return in a
  /// single request. For the initial request, leave this field unspecified. For
  /// subsequent calls, this field should be set to the next value returned in
  /// the previous call.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [SerialPortOutput].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<SerialPortOutput> getSerialPortOutput(
      core.String project, core.String zone, core.String instance,
      {core.int port, core.String start_1, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instance == null) {
      throw new core.ArgumentError("Parameter instance is required.");
    }
    if (port != null) {
      _queryParams["port"] = ["${port}"];
    }
    if (start_1 != null) {
      _queryParams["start"] = [start_1];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances/' +
        commons.Escaper.ecapeVariable('$instance') +
        '/serialPort';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new SerialPortOutput.fromJson(data));
  }

  /// Returns the Shielded Instance Identity of an instance
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [instance] - Name or id of the instance scoping this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ShieldedInstanceIdentity].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ShieldedInstanceIdentity> getShieldedInstanceIdentity(
      core.String project, core.String zone, core.String instance,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instance == null) {
      throw new core.ArgumentError("Parameter instance is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances/' +
        commons.Escaper.ecapeVariable('$instance') +
        '/getShieldedInstanceIdentity';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response
        .then((data) => new ShieldedInstanceIdentity.fromJson(data));
  }

  /// Creates an instance resource in the specified project using the data
  /// included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [sourceInstanceTemplate] - Specifies instance template to create the
  /// instance.
  ///
  /// This field is optional. It can be a full or partial URL. For example, the
  /// following are all valid URLs to an instance template:
  /// -
  /// https://www.googleapis.com/compute/v1/projects/project/global/instanceTemplates/instanceTemplate
  /// - projects/project/global/instanceTemplates/instanceTemplate
  /// - global/instanceTemplates/instanceTemplate
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
      Instance request, core.String project, core.String zone,
      {core.String requestId,
      core.String sourceInstanceTemplate,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if (sourceInstanceTemplate != null) {
      _queryParams["sourceInstanceTemplate"] = [sourceInstanceTemplate];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves the list of instances contained within the specified zone.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceList> list(core.String project, core.String zone,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new InstanceList.fromJson(data));
  }

  /// Retrieves the list of referrers to instances contained within the
  /// specified zone. For more information, read Viewing Referrers to VM
  /// Instances.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [instance] - Name of the target instance scoping this request, or '-' if
  /// the request should span over all instances in the container.
  /// Value must have pattern
  /// "-|[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceListReferrers].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceListReferrers> listReferrers(
      core.String project, core.String zone, core.String instance,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instance == null) {
      throw new core.ArgumentError("Parameter instance is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances/' +
        commons.Escaper.ecapeVariable('$instance') +
        '/referrers';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new InstanceListReferrers.fromJson(data));
  }

  /// Performs a reset on the instance. This is a hard reset the VM does not do
  /// a graceful shutdown. For more information, see Resetting an instance.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [instance] - Name of the instance scoping this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> reset(
      core.String project, core.String zone, core.String instance,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instance == null) {
      throw new core.ArgumentError("Parameter instance is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances/' +
        commons.Escaper.ecapeVariable('$instance') +
        '/reset';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Sets deletion protection on the instance.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [deletionProtection] - Whether the resource should be protected against
  /// deletion.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setDeletionProtection(
      core.String project, core.String zone, core.String resource,
      {core.bool deletionProtection,
      core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (resource == null) {
      throw new core.ArgumentError("Parameter resource is required.");
    }
    if (deletionProtection != null) {
      _queryParams["deletionProtection"] = ["${deletionProtection}"];
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances/' +
        commons.Escaper.ecapeVariable('$resource') +
        '/setDeletionProtection';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Sets the auto-delete flag for a disk attached to an instance.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [instance] - The instance name for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [autoDelete] - Whether to auto-delete the disk when the instance is
  /// deleted.
  ///
  /// [deviceName] - The device name of the disk to modify. Make a get() request
  /// on the instance to view currently attached disks and device names.
  /// Value must have pattern "\w[\w.-]{0,254}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setDiskAutoDelete(
      core.String project,
      core.String zone,
      core.String instance,
      core.bool autoDelete,
      core.String deviceName,
      {core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instance == null) {
      throw new core.ArgumentError("Parameter instance is required.");
    }
    if (autoDelete == null) {
      throw new core.ArgumentError("Parameter autoDelete is required.");
    }
    _queryParams["autoDelete"] = ["${autoDelete}"];
    if (deviceName == null) {
      throw new core.ArgumentError("Parameter deviceName is required.");
    }
    _queryParams["deviceName"] = [deviceName];
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances/' +
        commons.Escaper.ecapeVariable('$instance') +
        '/setDiskAutoDelete';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Sets the access control policy on the specified resource. Replaces any
  /// existing policy.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> setIamPolicy(ZoneSetPolicyRequest request,
      core.String project, core.String zone, core.String resource,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (resource == null) {
      throw new core.ArgumentError("Parameter resource is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances/' +
        commons.Escaper.ecapeVariable('$resource') +
        '/setIamPolicy';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Policy.fromJson(data));
  }

  /// Sets labels on an instance. To learn more about labels, read the Labeling
  /// Resources documentation.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [instance] - Name of the instance scoping this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setLabels(InstancesSetLabelsRequest request,
      core.String project, core.String zone, core.String instance,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instance == null) {
      throw new core.ArgumentError("Parameter instance is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances/' +
        commons.Escaper.ecapeVariable('$instance') +
        '/setLabels';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Changes the number and/or type of accelerator for a stopped instance to
  /// the values specified in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [instance] - Name of the instance scoping this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setMachineResources(
      InstancesSetMachineResourcesRequest request,
      core.String project,
      core.String zone,
      core.String instance,
      {core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instance == null) {
      throw new core.ArgumentError("Parameter instance is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances/' +
        commons.Escaper.ecapeVariable('$instance') +
        '/setMachineResources';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Changes the machine type for a stopped instance to the machine type
  /// specified in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [instance] - Name of the instance scoping this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setMachineType(InstancesSetMachineTypeRequest request,
      core.String project, core.String zone, core.String instance,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instance == null) {
      throw new core.ArgumentError("Parameter instance is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances/' +
        commons.Escaper.ecapeVariable('$instance') +
        '/setMachineType';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Sets metadata for the specified instance to the data included in the
  /// request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [instance] - Name of the instance scoping this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setMetadata(Metadata request, core.String project,
      core.String zone, core.String instance,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instance == null) {
      throw new core.ArgumentError("Parameter instance is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances/' +
        commons.Escaper.ecapeVariable('$instance') +
        '/setMetadata';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Changes the minimum CPU platform that this instance should use. This
  /// method can only be called on a stopped instance. For more information,
  /// read Specifying a Minimum CPU Platform.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [instance] - Name of the instance scoping this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setMinCpuPlatform(
      InstancesSetMinCpuPlatformRequest request,
      core.String project,
      core.String zone,
      core.String instance,
      {core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instance == null) {
      throw new core.ArgumentError("Parameter instance is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances/' +
        commons.Escaper.ecapeVariable('$instance') +
        '/setMinCpuPlatform';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Sets an instance's scheduling options.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [instance] - Instance name for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setScheduling(Scheduling request, core.String project,
      core.String zone, core.String instance,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instance == null) {
      throw new core.ArgumentError("Parameter instance is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances/' +
        commons.Escaper.ecapeVariable('$instance') +
        '/setScheduling';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Sets the service account on the instance. For more information, read
  /// Changing the service account and access scopes for an instance.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [instance] - Name of the instance resource to start.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setServiceAccount(
      InstancesSetServiceAccountRequest request,
      core.String project,
      core.String zone,
      core.String instance,
      {core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instance == null) {
      throw new core.ArgumentError("Parameter instance is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances/' +
        commons.Escaper.ecapeVariable('$instance') +
        '/setServiceAccount';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Sets the Shielded Instance integrity policy for an instance. You can only
  /// use this method on a running instance. This method supports PATCH
  /// semantics and uses the JSON merge patch format and processing rules.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [instance] - Name or id of the instance scoping this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setShieldedInstanceIntegrityPolicy(
      ShieldedInstanceIntegrityPolicy request,
      core.String project,
      core.String zone,
      core.String instance,
      {core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instance == null) {
      throw new core.ArgumentError("Parameter instance is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances/' +
        commons.Escaper.ecapeVariable('$instance') +
        '/setShieldedInstanceIntegrityPolicy';

    var _response = _requester.request(_url, "PATCH",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Sets network tags for the specified instance to the data included in the
  /// request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [instance] - Name of the instance scoping this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setTags(
      Tags request, core.String project, core.String zone, core.String instance,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instance == null) {
      throw new core.ArgumentError("Parameter instance is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances/' +
        commons.Escaper.ecapeVariable('$instance') +
        '/setTags';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Simulates a maintenance event on the instance.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [instance] - Name of the instance scoping this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> simulateMaintenanceEvent(
      core.String project, core.String zone, core.String instance,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instance == null) {
      throw new core.ArgumentError("Parameter instance is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances/' +
        commons.Escaper.ecapeVariable('$instance') +
        '/simulateMaintenanceEvent';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Starts an instance that was stopped using the instances().stop method. For
  /// more information, see Restart an instance.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [instance] - Name of the instance resource to start.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> start(
      core.String project, core.String zone, core.String instance,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instance == null) {
      throw new core.ArgumentError("Parameter instance is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances/' +
        commons.Escaper.ecapeVariable('$instance') +
        '/start';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Starts an instance that was stopped using the instances().stop method. For
  /// more information, see Restart an instance.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [instance] - Name of the instance resource to start.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> startWithEncryptionKey(
      InstancesStartWithEncryptionKeyRequest request,
      core.String project,
      core.String zone,
      core.String instance,
      {core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instance == null) {
      throw new core.ArgumentError("Parameter instance is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances/' +
        commons.Escaper.ecapeVariable('$instance') +
        '/startWithEncryptionKey';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Stops a running instance, shutting it down cleanly, and allows you to
  /// restart the instance at a later time. Stopped instances do not incur VM
  /// usage charges while they are stopped. However, resources that the VM is
  /// using, such as persistent disks and static IP addresses, will continue to
  /// be charged until they are deleted. For more information, see Stopping an
  /// instance.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [instance] - Name of the instance resource to stop.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> stop(
      core.String project, core.String zone, core.String instance,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instance == null) {
      throw new core.ArgumentError("Parameter instance is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances/' +
        commons.Escaper.ecapeVariable('$instance') +
        '/stop';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [TestPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<TestPermissionsResponse> testIamPermissions(
      TestPermissionsRequest request,
      core.String project,
      core.String zone,
      core.String resource,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (resource == null) {
      throw new core.ArgumentError("Parameter resource is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances/' +
        commons.Escaper.ecapeVariable('$resource') +
        '/testIamPermissions';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new TestPermissionsResponse.fromJson(data));
  }

  /// Updates the specified access config from an instance's network interface
  /// with the data included in the request. This method supports PATCH
  /// semantics and uses the JSON merge patch format and processing rules.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [instance] - The instance name for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [networkInterface] - The name of the network interface where the access
  /// config is attached.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> updateAccessConfig(
      AccessConfig request,
      core.String project,
      core.String zone,
      core.String instance,
      core.String networkInterface,
      {core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instance == null) {
      throw new core.ArgumentError("Parameter instance is required.");
    }
    if (networkInterface == null) {
      throw new core.ArgumentError("Parameter networkInterface is required.");
    }
    _queryParams["networkInterface"] = [networkInterface];
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances/' +
        commons.Escaper.ecapeVariable('$instance') +
        '/updateAccessConfig';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Updates an instance's network interface. This method follows PATCH
  /// semantics.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [instance] - The instance name for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [networkInterface] - The name of the network interface to update.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> updateNetworkInterface(
      NetworkInterface request,
      core.String project,
      core.String zone,
      core.String instance,
      core.String networkInterface,
      {core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instance == null) {
      throw new core.ArgumentError("Parameter instance is required.");
    }
    if (networkInterface == null) {
      throw new core.ArgumentError("Parameter networkInterface is required.");
    }
    _queryParams["networkInterface"] = [networkInterface];
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances/' +
        commons.Escaper.ecapeVariable('$instance') +
        '/updateNetworkInterface';

    var _response = _requester.request(_url, "PATCH",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Updates the Shielded Instance config for an instance. You can only use
  /// this method on a stopped instance. This method supports PATCH semantics
  /// and uses the JSON merge patch format and processing rules.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [instance] - Name or id of the instance scoping this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> updateShieldedInstanceConfig(
      ShieldedInstanceConfig request,
      core.String project,
      core.String zone,
      core.String instance,
      {core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (instance == null) {
      throw new core.ArgumentError("Parameter instance is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/instances/' +
        commons.Escaper.ecapeVariable('$instance') +
        '/updateShieldedInstanceConfig';

    var _response = _requester.request(_url, "PATCH",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }
}

class InterconnectAttachmentsResourceApi {
  final commons.ApiRequester _requester;

  InterconnectAttachmentsResourceApi(commons.ApiRequester client)
      : _requester = client;

  /// Retrieves an aggregated list of interconnect attachments.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InterconnectAttachmentAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InterconnectAttachmentAggregatedList> aggregatedList(
      core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/aggregated/interconnectAttachments';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then(
        (data) => new InterconnectAttachmentAggregatedList.fromJson(data));
  }

  /// Deletes the specified interconnect attachment.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [interconnectAttachment] - Name of the interconnect attachment to delete.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(core.String project, core.String region,
      core.String interconnectAttachment,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (interconnectAttachment == null) {
      throw new core.ArgumentError(
          "Parameter interconnectAttachment is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/interconnectAttachments/' +
        commons.Escaper.ecapeVariable('$interconnectAttachment');

    var _response = _requester.request(_url, "DELETE",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns the specified interconnect attachment.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [interconnectAttachment] - Name of the interconnect attachment to return.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InterconnectAttachment].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InterconnectAttachment> get(core.String project,
      core.String region, core.String interconnectAttachment,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (interconnectAttachment == null) {
      throw new core.ArgumentError(
          "Parameter interconnectAttachment is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/interconnectAttachments/' +
        commons.Escaper.ecapeVariable('$interconnectAttachment');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new InterconnectAttachment.fromJson(data));
  }

  /// Creates an InterconnectAttachment in the specified project using the data
  /// included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
      InterconnectAttachment request, core.String project, core.String region,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/interconnectAttachments';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves the list of interconnect attachments contained within the
  /// specified region.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InterconnectAttachmentList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InterconnectAttachmentList> list(
      core.String project, core.String region,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/interconnectAttachments';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response
        .then((data) => new InterconnectAttachmentList.fromJson(data));
  }

  /// Updates the specified interconnect attachment with the data included in
  /// the request. This method supports PATCH semantics and uses the JSON merge
  /// patch format and processing rules.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [interconnectAttachment] - Name of the interconnect attachment to patch.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patch(
      InterconnectAttachment request,
      core.String project,
      core.String region,
      core.String interconnectAttachment,
      {core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (interconnectAttachment == null) {
      throw new core.ArgumentError(
          "Parameter interconnectAttachment is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/interconnectAttachments/' +
        commons.Escaper.ecapeVariable('$interconnectAttachment');

    var _response = _requester.request(_url, "PATCH",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }
}

class InterconnectLocationsResourceApi {
  final commons.ApiRequester _requester;

  InterconnectLocationsResourceApi(commons.ApiRequester client)
      : _requester = client;

  /// Returns the details for the specified interconnect location. Gets a list
  /// of available interconnect locations by making a list() request.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [interconnectLocation] - Name of the interconnect location to return.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InterconnectLocation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InterconnectLocation> get(
      core.String project, core.String interconnectLocation,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (interconnectLocation == null) {
      throw new core.ArgumentError(
          "Parameter interconnectLocation is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/interconnectLocations/' +
        commons.Escaper.ecapeVariable('$interconnectLocation');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new InterconnectLocation.fromJson(data));
  }

  /// Retrieves the list of interconnect locations available to the specified
  /// project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InterconnectLocationList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InterconnectLocationList> list(core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/interconnectLocations';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response
        .then((data) => new InterconnectLocationList.fromJson(data));
  }
}

class InterconnectsResourceApi {
  final commons.ApiRequester _requester;

  InterconnectsResourceApi(commons.ApiRequester client) : _requester = client;

  /// Deletes the specified interconnect.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [interconnect] - Name of the interconnect to delete.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(core.String project, core.String interconnect,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (interconnect == null) {
      throw new core.ArgumentError("Parameter interconnect is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/interconnects/' +
        commons.Escaper.ecapeVariable('$interconnect');

    var _response = _requester.request(_url, "DELETE",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns the specified interconnect. Get a list of available interconnects
  /// by making a list() request.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [interconnect] - Name of the interconnect to return.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Interconnect].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Interconnect> get(core.String project, core.String interconnect,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (interconnect == null) {
      throw new core.ArgumentError("Parameter interconnect is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/interconnects/' +
        commons.Escaper.ecapeVariable('$interconnect');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Interconnect.fromJson(data));
  }

  /// Returns the interconnectDiagnostics for the specified interconnect.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [interconnect] - Name of the interconnect resource to query.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InterconnectsGetDiagnosticsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InterconnectsGetDiagnosticsResponse> getDiagnostics(
      core.String project, core.String interconnect,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (interconnect == null) {
      throw new core.ArgumentError("Parameter interconnect is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/interconnects/' +
        commons.Escaper.ecapeVariable('$interconnect') +
        '/getDiagnostics';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response
        .then((data) => new InterconnectsGetDiagnosticsResponse.fromJson(data));
  }

  /// Creates a Interconnect in the specified project using the data included in
  /// the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(Interconnect request, core.String project,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/global/interconnects';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves the list of interconnect available to the specified project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InterconnectList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InterconnectList> list(core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/global/interconnects';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new InterconnectList.fromJson(data));
  }

  /// Updates the specified interconnect with the data included in the request.
  /// This method supports PATCH semantics and uses the JSON merge patch format
  /// and processing rules.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [interconnect] - Name of the interconnect to update.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patch(
      Interconnect request, core.String project, core.String interconnect,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (interconnect == null) {
      throw new core.ArgumentError("Parameter interconnect is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/interconnects/' +
        commons.Escaper.ecapeVariable('$interconnect');

    var _response = _requester.request(_url, "PATCH",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }
}

class LicenseCodesResourceApi {
  final commons.ApiRequester _requester;

  LicenseCodesResourceApi(commons.ApiRequester client) : _requester = client;

  /// Return a specified license code. License codes are mirrored across all
  /// projects that have permissions to read the License Code.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [licenseCode] - Number corresponding to the License code resource to
  /// return.
  /// Value must have pattern "[0-9]{0,61}?".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [LicenseCode].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<LicenseCode> get(core.String project, core.String licenseCode,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (licenseCode == null) {
      throw new core.ArgumentError("Parameter licenseCode is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/licenseCodes/' +
        commons.Escaper.ecapeVariable('$licenseCode');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new LicenseCode.fromJson(data));
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [TestPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<TestPermissionsResponse> testIamPermissions(
      TestPermissionsRequest request, core.String project, core.String resource,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (resource == null) {
      throw new core.ArgumentError("Parameter resource is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/licenseCodes/' +
        commons.Escaper.ecapeVariable('$resource') +
        '/testIamPermissions';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new TestPermissionsResponse.fromJson(data));
  }
}

class LicensesResourceApi {
  final commons.ApiRequester _requester;

  LicensesResourceApi(commons.ApiRequester client) : _requester = client;

  /// Deletes the specified license.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [license] - Name of the license resource to delete.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(core.String project, core.String license,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (license == null) {
      throw new core.ArgumentError("Parameter license is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/licenses/' +
        commons.Escaper.ecapeVariable('$license');

    var _response = _requester.request(_url, "DELETE",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns the specified License resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [license] - Name of the License resource to return.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [License].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<License> get(core.String project, core.String license,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (license == null) {
      throw new core.ArgumentError("Parameter license is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/licenses/' +
        commons.Escaper.ecapeVariable('$license');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new License.fromJson(data));
  }

  /// Gets the access control policy for a resource. May be empty if no such
  /// policy or resource exists.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> getIamPolicy(core.String project, core.String resource,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (resource == null) {
      throw new core.ArgumentError("Parameter resource is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/licenses/' +
        commons.Escaper.ecapeVariable('$resource') +
        '/getIamPolicy';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Policy.fromJson(data));
  }

  /// Create a License resource in the specified project.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(License request, core.String project,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/global/licenses';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves the list of licenses available in the specified project. This
  /// method does not get any licenses that belong to other projects, including
  /// licenses attached to publicly-available images, like Debian 9. If you want
  /// to get a list of publicly-available licenses, use this method to make a
  /// request to the respective image project, such as debian-cloud or
  /// windows-cloud.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [LicensesListResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<LicensesListResponse> list(core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/global/licenses';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new LicensesListResponse.fromJson(data));
  }

  /// Sets the access control policy on the specified resource. Replaces any
  /// existing policy.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> setIamPolicy(
      GlobalSetPolicyRequest request, core.String project, core.String resource,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (resource == null) {
      throw new core.ArgumentError("Parameter resource is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/licenses/' +
        commons.Escaper.ecapeVariable('$resource') +
        '/setIamPolicy';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Policy.fromJson(data));
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [TestPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<TestPermissionsResponse> testIamPermissions(
      TestPermissionsRequest request, core.String project, core.String resource,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (resource == null) {
      throw new core.ArgumentError("Parameter resource is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/licenses/' +
        commons.Escaper.ecapeVariable('$resource') +
        '/testIamPermissions';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new TestPermissionsResponse.fromJson(data));
  }
}

class MachineTypesResourceApi {
  final commons.ApiRequester _requester;

  MachineTypesResourceApi(commons.ApiRequester client) : _requester = client;

  /// Retrieves an aggregated list of machine types.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [MachineTypeAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<MachineTypeAggregatedList> aggregatedList(core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url =
        commons.Escaper.ecapeVariable('$project') + '/aggregated/machineTypes';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response
        .then((data) => new MachineTypeAggregatedList.fromJson(data));
  }

  /// Returns the specified machine type. Gets a list of available machine types
  /// by making a list() request.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [machineType] - Name of the machine type to return.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [MachineType].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<MachineType> get(
      core.String project, core.String zone, core.String machineType,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (machineType == null) {
      throw new core.ArgumentError("Parameter machineType is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/machineTypes/' +
        commons.Escaper.ecapeVariable('$machineType');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new MachineType.fromJson(data));
  }

  /// Retrieves a list of machine types available to the specified project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [MachineTypeList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<MachineTypeList> list(core.String project, core.String zone,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/machineTypes';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new MachineTypeList.fromJson(data));
  }
}

class NetworkEndpointGroupsResourceApi {
  final commons.ApiRequester _requester;

  NetworkEndpointGroupsResourceApi(commons.ApiRequester client)
      : _requester = client;

  /// Retrieves the list of network endpoint groups and sorts them by zone.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [NetworkEndpointGroupAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<NetworkEndpointGroupAggregatedList> aggregatedList(
      core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/aggregated/networkEndpointGroups';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response
        .then((data) => new NetworkEndpointGroupAggregatedList.fromJson(data));
  }

  /// Attach a list of network endpoints to the specified network endpoint
  /// group.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone where the network endpoint group is located.
  /// It should comply with RFC1035.
  ///
  /// [networkEndpointGroup] - The name of the network endpoint group where you
  /// are attaching network endpoints to. It should comply with RFC1035.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> attachNetworkEndpoints(
      NetworkEndpointGroupsAttachEndpointsRequest request,
      core.String project,
      core.String zone,
      core.String networkEndpointGroup,
      {core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (networkEndpointGroup == null) {
      throw new core.ArgumentError(
          "Parameter networkEndpointGroup is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/networkEndpointGroups/' +
        commons.Escaper.ecapeVariable('$networkEndpointGroup') +
        '/attachNetworkEndpoints';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Deletes the specified network endpoint group. The network endpoints in the
  /// NEG and the VM instances they belong to are not terminated when the NEG is
  /// deleted. Note that the NEG cannot be deleted if there are backend services
  /// referencing it.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone where the network endpoint group is located.
  /// It should comply with RFC1035.
  ///
  /// [networkEndpointGroup] - The name of the network endpoint group to delete.
  /// It should comply with RFC1035.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
      core.String project, core.String zone, core.String networkEndpointGroup,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (networkEndpointGroup == null) {
      throw new core.ArgumentError(
          "Parameter networkEndpointGroup is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/networkEndpointGroups/' +
        commons.Escaper.ecapeVariable('$networkEndpointGroup');

    var _response = _requester.request(_url, "DELETE",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Detach a list of network endpoints from the specified network endpoint
  /// group.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone where the network endpoint group is located.
  /// It should comply with RFC1035.
  ///
  /// [networkEndpointGroup] - The name of the network endpoint group where you
  /// are removing network endpoints. It should comply with RFC1035.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> detachNetworkEndpoints(
      NetworkEndpointGroupsDetachEndpointsRequest request,
      core.String project,
      core.String zone,
      core.String networkEndpointGroup,
      {core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (networkEndpointGroup == null) {
      throw new core.ArgumentError(
          "Parameter networkEndpointGroup is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/networkEndpointGroups/' +
        commons.Escaper.ecapeVariable('$networkEndpointGroup') +
        '/detachNetworkEndpoints';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns the specified network endpoint group. Gets a list of available
  /// network endpoint groups by making a list() request.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone where the network endpoint group is located.
  /// It should comply with RFC1035.
  ///
  /// [networkEndpointGroup] - The name of the network endpoint group. It should
  /// comply with RFC1035.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [NetworkEndpointGroup].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<NetworkEndpointGroup> get(
      core.String project, core.String zone, core.String networkEndpointGroup,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (networkEndpointGroup == null) {
      throw new core.ArgumentError(
          "Parameter networkEndpointGroup is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/networkEndpointGroups/' +
        commons.Escaper.ecapeVariable('$networkEndpointGroup');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new NetworkEndpointGroup.fromJson(data));
  }

  /// Creates a network endpoint group in the specified project using the
  /// parameters that are included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone where you want to create the network
  /// endpoint group. It should comply with RFC1035.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
      NetworkEndpointGroup request, core.String project, core.String zone,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/networkEndpointGroups';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves the list of network endpoint groups that are located in the
  /// specified project and zone.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone where the network endpoint group is located.
  /// It should comply with RFC1035.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [NetworkEndpointGroupList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<NetworkEndpointGroupList> list(
      core.String project, core.String zone,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/networkEndpointGroups';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response
        .then((data) => new NetworkEndpointGroupList.fromJson(data));
  }

  /// Lists the network endpoints in the specified network endpoint group.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone where the network endpoint group is located.
  /// It should comply with RFC1035.
  ///
  /// [networkEndpointGroup] - The name of the network endpoint group from which
  /// you want to generate a list of included network endpoints. It should
  /// comply with RFC1035.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [NetworkEndpointGroupsListNetworkEndpoints].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<NetworkEndpointGroupsListNetworkEndpoints> listNetworkEndpoints(
      NetworkEndpointGroupsListEndpointsRequest request,
      core.String project,
      core.String zone,
      core.String networkEndpointGroup,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (networkEndpointGroup == null) {
      throw new core.ArgumentError(
          "Parameter networkEndpointGroup is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/networkEndpointGroups/' +
        commons.Escaper.ecapeVariable('$networkEndpointGroup') +
        '/listNetworkEndpoints';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then(
        (data) => new NetworkEndpointGroupsListNetworkEndpoints.fromJson(data));
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [TestPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<TestPermissionsResponse> testIamPermissions(
      TestPermissionsRequest request,
      core.String project,
      core.String zone,
      core.String resource,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (resource == null) {
      throw new core.ArgumentError("Parameter resource is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/networkEndpointGroups/' +
        commons.Escaper.ecapeVariable('$resource') +
        '/testIamPermissions';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new TestPermissionsResponse.fromJson(data));
  }
}

class NetworksResourceApi {
  final commons.ApiRequester _requester;

  NetworksResourceApi(commons.ApiRequester client) : _requester = client;

  /// Adds a peering to the specified network.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [network] - Name of the network resource to add peering to.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> addPeering(NetworksAddPeeringRequest request,
      core.String project, core.String network,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (network == null) {
      throw new core.ArgumentError("Parameter network is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/networks/' +
        commons.Escaper.ecapeVariable('$network') +
        '/addPeering';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Deletes the specified network.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [network] - Name of the network to delete.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(core.String project, core.String network,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (network == null) {
      throw new core.ArgumentError("Parameter network is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/networks/' +
        commons.Escaper.ecapeVariable('$network');

    var _response = _requester.request(_url, "DELETE",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns the specified network. Gets a list of available networks by making
  /// a list() request.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [network] - Name of the network to return.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Network].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Network> get(core.String project, core.String network,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (network == null) {
      throw new core.ArgumentError("Parameter network is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/networks/' +
        commons.Escaper.ecapeVariable('$network');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Network.fromJson(data));
  }

  /// Creates a network in the specified project using the data included in the
  /// request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(Network request, core.String project,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/global/networks';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves the list of networks available to the specified project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [NetworkList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<NetworkList> list(core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/global/networks';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new NetworkList.fromJson(data));
  }

  /// Patches the specified network with the data included in the request. Only
  /// the following fields can be modified: routingConfig.routingMode.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [network] - Name of the network to update.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patch(
      Network request, core.String project, core.String network,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (network == null) {
      throw new core.ArgumentError("Parameter network is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/networks/' +
        commons.Escaper.ecapeVariable('$network');

    var _response = _requester.request(_url, "PATCH",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Removes a peering from the specified network.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [network] - Name of the network resource to remove peering from.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> removePeering(NetworksRemovePeeringRequest request,
      core.String project, core.String network,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (network == null) {
      throw new core.ArgumentError("Parameter network is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/networks/' +
        commons.Escaper.ecapeVariable('$network') +
        '/removePeering';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Switches the network mode from auto subnet mode to custom subnet mode.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [network] - Name of the network to be updated.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> switchToCustomMode(
      core.String project, core.String network,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (network == null) {
      throw new core.ArgumentError("Parameter network is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/global/networks/' +
        commons.Escaper.ecapeVariable('$network') +
        '/switchToCustomMode';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }
}

class NodeGroupsResourceApi {
  final commons.ApiRequester _requester;

  NodeGroupsResourceApi(commons.ApiRequester client) : _requester = client;

  /// Adds specified number of nodes to the node group.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [nodeGroup] - Name of the NodeGroup resource.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> addNodes(NodeGroupsAddNodesRequest request,
      core.String project, core.String zone, core.String nodeGroup,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (nodeGroup == null) {
      throw new core.ArgumentError("Parameter nodeGroup is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/nodeGroups/' +
        commons.Escaper.ecapeVariable('$nodeGroup') +
        '/addNodes';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves an aggregated list of node groups. Note: use
  /// nodeGroups.listNodes for more details about each group.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [NodeGroupAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<NodeGroupAggregatedList> aggregatedList(core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/aggregated/nodeGroups';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new NodeGroupAggregatedList.fromJson(data));
  }

  /// Deletes the specified NodeGroup resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [nodeGroup] - Name of the NodeGroup resource to delete.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
      core.String project, core.String zone, core.String nodeGroup,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (nodeGroup == null) {
      throw new core.ArgumentError("Parameter nodeGroup is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/nodeGroups/' +
        commons.Escaper.ecapeVariable('$nodeGroup');

    var _response = _requester.request(_url, "DELETE",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Deletes specified nodes from the node group.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [nodeGroup] - Name of the NodeGroup resource to delete.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> deleteNodes(NodeGroupsDeleteNodesRequest request,
      core.String project, core.String zone, core.String nodeGroup,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (nodeGroup == null) {
      throw new core.ArgumentError("Parameter nodeGroup is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/nodeGroups/' +
        commons.Escaper.ecapeVariable('$nodeGroup') +
        '/deleteNodes';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns the specified NodeGroup. Get a list of available NodeGroups by
  /// making a list() request. Note: the "nodes" field should not be used. Use
  /// nodeGroups.listNodes instead.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [nodeGroup] - Name of the node group to return.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [NodeGroup].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<NodeGroup> get(
      core.String project, core.String zone, core.String nodeGroup,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (nodeGroup == null) {
      throw new core.ArgumentError("Parameter nodeGroup is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/nodeGroups/' +
        commons.Escaper.ecapeVariable('$nodeGroup');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new NodeGroup.fromJson(data));
  }

  /// Gets the access control policy for a resource. May be empty if no such
  /// policy or resource exists.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> getIamPolicy(
      core.String project, core.String zone, core.String resource,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (resource == null) {
      throw new core.ArgumentError("Parameter resource is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/nodeGroups/' +
        commons.Escaper.ecapeVariable('$resource') +
        '/getIamPolicy';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Policy.fromJson(data));
  }

  /// Creates a NodeGroup resource in the specified project using the data
  /// included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [initialNodeCount] - Initial count of nodes in the node group.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(NodeGroup request, core.String project,
      core.String zone, core.int initialNodeCount,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (initialNodeCount == null) {
      throw new core.ArgumentError("Parameter initialNodeCount is required.");
    }
    _queryParams["initialNodeCount"] = ["${initialNodeCount}"];
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/nodeGroups';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves a list of node groups available to the specified project. Note:
  /// use nodeGroups.listNodes for more details about each group.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [NodeGroupList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<NodeGroupList> list(core.String project, core.String zone,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/nodeGroups';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new NodeGroupList.fromJson(data));
  }

  /// Lists nodes in the node group.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [nodeGroup] - Name of the NodeGroup resource whose nodes you want to list.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [NodeGroupsListNodes].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<NodeGroupsListNodes> listNodes(
      core.String project, core.String zone, core.String nodeGroup,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (nodeGroup == null) {
      throw new core.ArgumentError("Parameter nodeGroup is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/nodeGroups/' +
        commons.Escaper.ecapeVariable('$nodeGroup') +
        '/listNodes';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new NodeGroupsListNodes.fromJson(data));
  }

  /// Sets the access control policy on the specified resource. Replaces any
  /// existing policy.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> setIamPolicy(ZoneSetPolicyRequest request,
      core.String project, core.String zone, core.String resource,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (resource == null) {
      throw new core.ArgumentError("Parameter resource is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/nodeGroups/' +
        commons.Escaper.ecapeVariable('$resource') +
        '/setIamPolicy';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Policy.fromJson(data));
  }

  /// Updates the node template of the node group.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [nodeGroup] - Name of the NodeGroup resource to update.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setNodeTemplate(
      NodeGroupsSetNodeTemplateRequest request,
      core.String project,
      core.String zone,
      core.String nodeGroup,
      {core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (nodeGroup == null) {
      throw new core.ArgumentError("Parameter nodeGroup is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/nodeGroups/' +
        commons.Escaper.ecapeVariable('$nodeGroup') +
        '/setNodeTemplate';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [TestPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<TestPermissionsResponse> testIamPermissions(
      TestPermissionsRequest request,
      core.String project,
      core.String zone,
      core.String resource,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (resource == null) {
      throw new core.ArgumentError("Parameter resource is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/nodeGroups/' +
        commons.Escaper.ecapeVariable('$resource') +
        '/testIamPermissions';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new TestPermissionsResponse.fromJson(data));
  }
}

class NodeTemplatesResourceApi {
  final commons.ApiRequester _requester;

  NodeTemplatesResourceApi(commons.ApiRequester client) : _requester = client;

  /// Retrieves an aggregated list of node templates.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [NodeTemplateAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<NodeTemplateAggregatedList> aggregatedList(core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url =
        commons.Escaper.ecapeVariable('$project') + '/aggregated/nodeTemplates';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response
        .then((data) => new NodeTemplateAggregatedList.fromJson(data));
  }

  /// Deletes the specified NodeTemplate resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - The name of the region for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [nodeTemplate] - Name of the NodeTemplate resource to delete.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
      core.String project, core.String region, core.String nodeTemplate,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (nodeTemplate == null) {
      throw new core.ArgumentError("Parameter nodeTemplate is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/nodeTemplates/' +
        commons.Escaper.ecapeVariable('$nodeTemplate');

    var _response = _requester.request(_url, "DELETE",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns the specified node template. Gets a list of available node
  /// templates by making a list() request.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - The name of the region for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [nodeTemplate] - Name of the node template to return.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [NodeTemplate].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<NodeTemplate> get(
      core.String project, core.String region, core.String nodeTemplate,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (nodeTemplate == null) {
      throw new core.ArgumentError("Parameter nodeTemplate is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/nodeTemplates/' +
        commons.Escaper.ecapeVariable('$nodeTemplate');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new NodeTemplate.fromJson(data));
  }

  /// Gets the access control policy for a resource. May be empty if no such
  /// policy or resource exists.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - The name of the region for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> getIamPolicy(
      core.String project, core.String region, core.String resource,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (resource == null) {
      throw new core.ArgumentError("Parameter resource is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/nodeTemplates/' +
        commons.Escaper.ecapeVariable('$resource') +
        '/getIamPolicy';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Policy.fromJson(data));
  }

  /// Creates a NodeTemplate resource in the specified project using the data
  /// included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - The name of the region for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
      NodeTemplate request, core.String project, core.String region,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/nodeTemplates';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves a list of node templates available to the specified project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - The name of the region for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [NodeTemplateList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<NodeTemplateList> list(core.String project, core.String region,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/nodeTemplates';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new NodeTemplateList.fromJson(data));
  }

  /// Sets the access control policy on the specified resource. Replaces any
  /// existing policy.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - The name of the region for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> setIamPolicy(RegionSetPolicyRequest request,
      core.String project, core.String region, core.String resource,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (resource == null) {
      throw new core.ArgumentError("Parameter resource is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/nodeTemplates/' +
        commons.Escaper.ecapeVariable('$resource') +
        '/setIamPolicy';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Policy.fromJson(data));
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - The name of the region for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [TestPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<TestPermissionsResponse> testIamPermissions(
      TestPermissionsRequest request,
      core.String project,
      core.String region,
      core.String resource,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (resource == null) {
      throw new core.ArgumentError("Parameter resource is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/nodeTemplates/' +
        commons.Escaper.ecapeVariable('$resource') +
        '/testIamPermissions';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new TestPermissionsResponse.fromJson(data));
  }
}

class NodeTypesResourceApi {
  final commons.ApiRequester _requester;

  NodeTypesResourceApi(commons.ApiRequester client) : _requester = client;

  /// Retrieves an aggregated list of node types.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [NodeTypeAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<NodeTypeAggregatedList> aggregatedList(core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/aggregated/nodeTypes';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new NodeTypeAggregatedList.fromJson(data));
  }

  /// Returns the specified node type. Gets a list of available node types by
  /// making a list() request.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [nodeType] - Name of the node type to return.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [NodeType].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<NodeType> get(
      core.String project, core.String zone, core.String nodeType,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (nodeType == null) {
      throw new core.ArgumentError("Parameter nodeType is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/nodeTypes/' +
        commons.Escaper.ecapeVariable('$nodeType');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new NodeType.fromJson(data));
  }

  /// Retrieves a list of node types available to the specified project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [NodeTypeList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<NodeTypeList> list(core.String project, core.String zone,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/nodeTypes';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new NodeTypeList.fromJson(data));
  }
}

class ProjectsResourceApi {
  final commons.ApiRequester _requester;

  ProjectsResourceApi(commons.ApiRequester client) : _requester = client;

  /// Disable this project as a shared VPC host project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> disableXpnHost(core.String project,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/disableXpnHost';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Disable a service resource (also known as service project) associated with
  /// this host project.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> disableXpnResource(
      ProjectsDisableXpnResourceRequest request, core.String project,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/disableXpnResource';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Enable this project as a shared VPC host project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> enableXpnHost(core.String project,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/enableXpnHost';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Enable service resource (a.k.a service project) for a host project, so
  /// that subnets in the host project can be used by instances in the service
  /// project.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> enableXpnResource(
      ProjectsEnableXpnResourceRequest request, core.String project,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/enableXpnResource';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns the specified Project resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Project].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Project> get(core.String project, {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Project.fromJson(data));
  }

  /// Gets the shared VPC host project that this project links to. May be empty
  /// if no link exists.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Project].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Project> getXpnHost(core.String project, {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/getXpnHost';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Project.fromJson(data));
  }

  /// Gets service resources (a.k.a service project) associated with this host
  /// project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ProjectsGetXpnResources].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ProjectsGetXpnResources> getXpnResources(core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["order_by"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/getXpnResources';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new ProjectsGetXpnResources.fromJson(data));
  }

  /// Lists all shared VPC host projects visible to the user in an organization.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [XpnHostList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<XpnHostList> listXpnHosts(
      ProjectsListXpnHostsRequest request, core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["order_by"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/listXpnHosts';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new XpnHostList.fromJson(data));
  }

  /// Moves a persistent disk from one zone to another.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> moveDisk(DiskMoveRequest request, core.String project,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/moveDisk';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Moves an instance and its attached persistent disks from one zone to
  /// another.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> moveInstance(
      InstanceMoveRequest request, core.String project,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/moveInstance';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Sets metadata common to all instances within the specified project using
  /// the data included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setCommonInstanceMetadata(
      Metadata request, core.String project,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/setCommonInstanceMetadata';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Sets the default network tier of the project. The default network tier is
  /// used when an address/forwardingRule/instance is created without specifying
  /// the network tier field.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setDefaultNetworkTier(
      ProjectsSetDefaultNetworkTierRequest request, core.String project,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/setDefaultNetworkTier';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Enables the usage export feature and sets the usage export bucket where
  /// reports are stored. If you provide an empty request body using this
  /// method, the usage export feature will be disabled.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setUsageExportBucket(
      UsageExportLocation request, core.String project,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/setUsageExportBucket';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }
}

class RegionAutoscalersResourceApi {
  final commons.ApiRequester _requester;

  RegionAutoscalersResourceApi(commons.ApiRequester client)
      : _requester = client;

  /// Deletes the specified autoscaler.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [autoscaler] - Name of the autoscaler to delete.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
      core.String project, core.String region, core.String autoscaler,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (autoscaler == null) {
      throw new core.ArgumentError("Parameter autoscaler is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/autoscalers/' +
        commons.Escaper.ecapeVariable('$autoscaler');

    var _response = _requester.request(_url, "DELETE",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns the specified autoscaler.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [autoscaler] - Name of the autoscaler to return.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Autoscaler].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Autoscaler> get(
      core.String project, core.String region, core.String autoscaler,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (autoscaler == null) {
      throw new core.ArgumentError("Parameter autoscaler is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/autoscalers/' +
        commons.Escaper.ecapeVariable('$autoscaler');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Autoscaler.fromJson(data));
  }

  /// Creates an autoscaler in the specified project using the data included in
  /// the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
      Autoscaler request, core.String project, core.String region,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/autoscalers';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves a list of autoscalers contained within the specified region.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [RegionAutoscalerList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<RegionAutoscalerList> list(
      core.String project, core.String region,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/autoscalers';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new RegionAutoscalerList.fromJson(data));
  }

  /// Updates an autoscaler in the specified project using the data included in
  /// the request. This method supports PATCH semantics and uses the JSON merge
  /// patch format and processing rules.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [autoscaler] - Name of the autoscaler to patch.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patch(
      Autoscaler request, core.String project, core.String region,
      {core.String autoscaler, core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (autoscaler != null) {
      _queryParams["autoscaler"] = [autoscaler];
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/autoscalers';

    var _response = _requester.request(_url, "PATCH",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Updates an autoscaler in the specified project using the data included in
  /// the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [autoscaler] - Name of the autoscaler to update.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> update(
      Autoscaler request, core.String project, core.String region,
      {core.String autoscaler, core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (autoscaler != null) {
      _queryParams["autoscaler"] = [autoscaler];
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/autoscalers';

    var _response = _requester.request(_url, "PUT",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }
}

class RegionBackendServicesResourceApi {
  final commons.ApiRequester _requester;

  RegionBackendServicesResourceApi(commons.ApiRequester client)
      : _requester = client;

  /// Deletes the specified regional BackendService resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [backendService] - Name of the BackendService resource to delete.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
      core.String project, core.String region, core.String backendService,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (backendService == null) {
      throw new core.ArgumentError("Parameter backendService is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/backendServices/' +
        commons.Escaper.ecapeVariable('$backendService');

    var _response = _requester.request(_url, "DELETE",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns the specified regional BackendService resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [backendService] - Name of the BackendService resource to return.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [BackendService].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<BackendService> get(
      core.String project, core.String region, core.String backendService,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (backendService == null) {
      throw new core.ArgumentError("Parameter backendService is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/backendServices/' +
        commons.Escaper.ecapeVariable('$backendService');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new BackendService.fromJson(data));
  }

  /// Gets the most recent health check results for this regional
  /// BackendService.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - null
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [backendService] - Name of the BackendService resource for which to get
  /// health.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [BackendServiceGroupHealth].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<BackendServiceGroupHealth> getHealth(
      ResourceGroupReference request,
      core.String project,
      core.String region,
      core.String backendService,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (backendService == null) {
      throw new core.ArgumentError("Parameter backendService is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/backendServices/' +
        commons.Escaper.ecapeVariable('$backendService') +
        '/getHealth';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response
        .then((data) => new BackendServiceGroupHealth.fromJson(data));
  }

  /// Creates a regional BackendService resource in the specified project using
  /// the data included in the request. There are several restrictions and
  /// guidelines to keep in mind when creating a regional backend service. Read
  /// Restrictions and Guidelines for more information.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
      BackendService request, core.String project, core.String region,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/backendServices';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves the list of regional BackendService resources available to the
  /// specified project in the given region.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [BackendServiceList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<BackendServiceList> list(core.String project, core.String region,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/backendServices';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new BackendServiceList.fromJson(data));
  }

  /// Updates the specified regional BackendService resource with the data
  /// included in the request. There are several restrictions and guidelines to
  /// keep in mind when updating a backend service. Read  Restrictions and
  /// Guidelines for more information. This method supports PATCH semantics and
  /// uses the JSON merge patch format and processing rules.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [backendService] - Name of the BackendService resource to patch.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patch(BackendService request, core.String project,
      core.String region, core.String backendService,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (backendService == null) {
      throw new core.ArgumentError("Parameter backendService is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/backendServices/' +
        commons.Escaper.ecapeVariable('$backendService');

    var _response = _requester.request(_url, "PATCH",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Updates the specified regional BackendService resource with the data
  /// included in the request. There are several restrictions and guidelines to
  /// keep in mind when updating a backend service. Read  Restrictions and
  /// Guidelines for more information.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [backendService] - Name of the BackendService resource to update.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> update(BackendService request, core.String project,
      core.String region, core.String backendService,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (backendService == null) {
      throw new core.ArgumentError("Parameter backendService is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/backendServices/' +
        commons.Escaper.ecapeVariable('$backendService');

    var _response = _requester.request(_url, "PUT",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }
}

class RegionCommitmentsResourceApi {
  final commons.ApiRequester _requester;

  RegionCommitmentsResourceApi(commons.ApiRequester client)
      : _requester = client;

  /// Retrieves an aggregated list of commitments.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [CommitmentAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<CommitmentAggregatedList> aggregatedList(core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url =
        commons.Escaper.ecapeVariable('$project') + '/aggregated/commitments';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response
        .then((data) => new CommitmentAggregatedList.fromJson(data));
  }

  /// Returns the specified commitment resource. Gets a list of available
  /// commitments by making a list() request.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [commitment] - Name of the commitment to return.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Commitment].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Commitment> get(
      core.String project, core.String region, core.String commitment,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (commitment == null) {
      throw new core.ArgumentError("Parameter commitment is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/commitments/' +
        commons.Escaper.ecapeVariable('$commitment');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Commitment.fromJson(data));
  }

  /// Creates a commitment in the specified project using the data included in
  /// the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
      Commitment request, core.String project, core.String region,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/commitments';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves a list of commitments contained within the specified region.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [CommitmentList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<CommitmentList> list(core.String project, core.String region,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/commitments';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new CommitmentList.fromJson(data));
  }
}

class RegionDiskTypesResourceApi {
  final commons.ApiRequester _requester;

  RegionDiskTypesResourceApi(commons.ApiRequester client) : _requester = client;

  /// Returns the specified regional disk type. Gets a list of available disk
  /// types by making a list() request.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - The name of the region for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [diskType] - Name of the disk type to return.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [DiskType].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<DiskType> get(
      core.String project, core.String region, core.String diskType,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (diskType == null) {
      throw new core.ArgumentError("Parameter diskType is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/diskTypes/' +
        commons.Escaper.ecapeVariable('$diskType');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new DiskType.fromJson(data));
  }

  /// Retrieves a list of regional disk types available to the specified
  /// project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - The name of the region for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [RegionDiskTypeList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<RegionDiskTypeList> list(core.String project, core.String region,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/diskTypes';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new RegionDiskTypeList.fromJson(data));
  }
}

class RegionDisksResourceApi {
  final commons.ApiRequester _requester;

  RegionDisksResourceApi(commons.ApiRequester client) : _requester = client;

  /// Adds existing resource policies to a regional disk. You can only add one
  /// policy which will be applied to this disk for scheduling snapshot
  /// creation.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - The name of the region for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [disk] - The disk name for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> addResourcePolicies(
      RegionDisksAddResourcePoliciesRequest request,
      core.String project,
      core.String region,
      core.String disk,
      {core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (disk == null) {
      throw new core.ArgumentError("Parameter disk is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/disks/' +
        commons.Escaper.ecapeVariable('$disk') +
        '/addResourcePolicies';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Creates a snapshot of this regional disk.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [disk] - Name of the regional persistent disk to snapshot.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> createSnapshot(Snapshot request, core.String project,
      core.String region, core.String disk,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (disk == null) {
      throw new core.ArgumentError("Parameter disk is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/disks/' +
        commons.Escaper.ecapeVariable('$disk') +
        '/createSnapshot';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Deletes the specified regional persistent disk. Deleting a regional disk
  /// removes all the replicas of its data permanently and is irreversible.
  /// However, deleting a disk does not delete any snapshots previously made
  /// from the disk. You must separately delete snapshots.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [disk] - Name of the regional persistent disk to delete.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
      core.String project, core.String region, core.String disk,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (disk == null) {
      throw new core.ArgumentError("Parameter disk is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/disks/' +
        commons.Escaper.ecapeVariable('$disk');

    var _response = _requester.request(_url, "DELETE",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns a specified regional persistent disk.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [disk] - Name of the regional persistent disk to return.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Disk].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Disk> get(
      core.String project, core.String region, core.String disk,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (disk == null) {
      throw new core.ArgumentError("Parameter disk is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/disks/' +
        commons.Escaper.ecapeVariable('$disk');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Disk.fromJson(data));
  }

  /// Creates a persistent regional disk in the specified project using the data
  /// included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [sourceImage] - Optional. Source image to restore onto a disk.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
      Disk request, core.String project, core.String region,
      {core.String requestId, core.String sourceImage, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if (sourceImage != null) {
      _queryParams["sourceImage"] = [sourceImage];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/disks';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves the list of persistent disks contained within the specified
  /// region.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [DiskList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<DiskList> list(core.String project, core.String region,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/disks';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new DiskList.fromJson(data));
  }

  /// Removes resource policies from a regional disk.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - The name of the region for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [disk] - The disk name for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> removeResourcePolicies(
      RegionDisksRemoveResourcePoliciesRequest request,
      core.String project,
      core.String region,
      core.String disk,
      {core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (disk == null) {
      throw new core.ArgumentError("Parameter disk is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/disks/' +
        commons.Escaper.ecapeVariable('$disk') +
        '/removeResourcePolicies';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Resizes the specified regional persistent disk.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - The project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [disk] - Name of the regional persistent disk.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> resize(RegionDisksResizeRequest request,
      core.String project, core.String region, core.String disk,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (disk == null) {
      throw new core.ArgumentError("Parameter disk is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/disks/' +
        commons.Escaper.ecapeVariable('$disk') +
        '/resize';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Sets the labels on the target regional disk.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - The region for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setLabels(RegionSetLabelsRequest request,
      core.String project, core.String region, core.String resource,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (resource == null) {
      throw new core.ArgumentError("Parameter resource is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/disks/' +
        commons.Escaper.ecapeVariable('$resource') +
        '/setLabels';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - The name of the region for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [TestPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<TestPermissionsResponse> testIamPermissions(
      TestPermissionsRequest request,
      core.String project,
      core.String region,
      core.String resource,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (resource == null) {
      throw new core.ArgumentError("Parameter resource is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/disks/' +
        commons.Escaper.ecapeVariable('$resource') +
        '/testIamPermissions';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new TestPermissionsResponse.fromJson(data));
  }
}

class RegionInstanceGroupManagersResourceApi {
  final commons.ApiRequester _requester;

  RegionInstanceGroupManagersResourceApi(commons.ApiRequester client)
      : _requester = client;

  /// Flags the specified instances to be immediately removed from the managed
  /// instance group. Abandoning an instance does not delete the instance, but
  /// it does remove the instance from any target pools that are applied by the
  /// managed instance group. This method reduces the targetSize of the managed
  /// instance group by the number of instances that you abandon. This operation
  /// is marked as DONE when the action is scheduled even if the instances have
  /// not yet been removed from the group. You must separately verify the status
  /// of the abandoning action with the listmanagedinstances method.
  ///
  /// If the group is part of a backend service that has enabled connection
  /// draining, it can take up to 60 seconds after the connection draining
  /// duration has elapsed before the VM instance is removed or deleted.
  ///
  /// You can specify a maximum of 1000 instances with this method per request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  ///
  /// [instanceGroupManager] - Name of the managed instance group.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> abandonInstances(
      RegionInstanceGroupManagersAbandonInstancesRequest request,
      core.String project,
      core.String region,
      core.String instanceGroupManager,
      {core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (instanceGroupManager == null) {
      throw new core.ArgumentError(
          "Parameter instanceGroupManager is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/instanceGroupManagers/' +
        commons.Escaper.ecapeVariable('$instanceGroupManager') +
        '/abandonInstances';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Deletes the specified managed instance group and all of the instances in
  /// that group.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  ///
  /// [instanceGroupManager] - Name of the managed instance group to delete.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
      core.String project, core.String region, core.String instanceGroupManager,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (instanceGroupManager == null) {
      throw new core.ArgumentError(
          "Parameter instanceGroupManager is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/instanceGroupManagers/' +
        commons.Escaper.ecapeVariable('$instanceGroupManager');

    var _response = _requester.request(_url, "DELETE",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Flags the specified instances in the managed instance group to be
  /// immediately deleted. The instances are also removed from any target pools
  /// of which they were a member. This method reduces the targetSize of the
  /// managed instance group by the number of instances that you delete. The
  /// deleteInstances operation is marked DONE if the deleteInstances request is
  /// successful. The underlying actions take additional time. You must
  /// separately verify the status of the deleting action with the
  /// listmanagedinstances method.
  ///
  /// If the group is part of a backend service that has enabled connection
  /// draining, it can take up to 60 seconds after the connection draining
  /// duration has elapsed before the VM instance is removed or deleted.
  ///
  /// You can specify a maximum of 1000 instances with this method per request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  ///
  /// [instanceGroupManager] - Name of the managed instance group.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> deleteInstances(
      RegionInstanceGroupManagersDeleteInstancesRequest request,
      core.String project,
      core.String region,
      core.String instanceGroupManager,
      {core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (instanceGroupManager == null) {
      throw new core.ArgumentError(
          "Parameter instanceGroupManager is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/instanceGroupManagers/' +
        commons.Escaper.ecapeVariable('$instanceGroupManager') +
        '/deleteInstances';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Returns all of the details about the specified managed instance group.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  ///
  /// [instanceGroupManager] - Name of the managed instance group to return.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceGroupManager].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceGroupManager> get(
      core.String project, core.String region, core.String instanceGroupManager,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (instanceGroupManager == null) {
      throw new core.ArgumentError(
          "Parameter instanceGroupManager is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/instanceGroupManagers/' +
        commons.Escaper.ecapeVariable('$instanceGroupManager');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new InstanceGroupManager.fromJson(data));
  }

  /// Creates a managed instance group using the information that you specify in
  /// the request. After the group is created, instances in the group are
  /// created using the specified instance template. This operation is marked as
  /// DONE when the group is created even if the instances in the group have not
  /// yet been created. You must separately verify the status of the individual
  /// instances with the listmanagedinstances method.
  ///
  /// A regional managed instance group can contain up to 2000 instances.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
      InstanceGroupManager request, core.String project, core.String region,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/instanceGroupManagers';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves the list of managed instance groups that are contained within
  /// the specified region.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [RegionInstanceGroupManagerList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<RegionInstanceGroupManagerList> list(
      core.String project, core.String region,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/instanceGroupManagers';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response
        .then((data) => new RegionInstanceGroupManagerList.fromJson(data));
  }

  /// Lists the instances in the managed instance group and instances that are
  /// scheduled to be created. The list includes any current actions that the
  /// group has scheduled for its instances.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  ///
  /// [instanceGroupManager] - The name of the managed instance group.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [RegionInstanceGroupManagersListInstancesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<RegionInstanceGroupManagersListInstancesResponse>
      listManagedInstances(core.String project, core.String region,
          core.String instanceGroupManager,
          {core.String filter,
          core.int maxResults,
          core.String orderBy,
          core.String pageToken,
          core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (instanceGroupManager == null) {
      throw new core.ArgumentError(
          "Parameter instanceGroupManager is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["order_by"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/instanceGroupManagers/' +
        commons.Escaper.ecapeVariable('$instanceGroupManager') +
        '/listManagedInstances';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) =>
        new RegionInstanceGroupManagersListInstancesResponse.fromJson(data));
  }

  /// Updates a managed instance group using the information that you specify in
  /// the request. This operation is marked as DONE when the group is patched
  /// even if the instances in the group are still in the process of being
  /// patched. You must separately verify the status of the individual instances
  /// with the listmanagedinstances method. This method supports PATCH semantics
  /// and uses the JSON merge patch format and processing rules.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  ///
  /// [instanceGroupManager] - The name of the instance group manager.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patch(InstanceGroupManager request,
      core.String project, core.String region, core.String instanceGroupManager,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (instanceGroupManager == null) {
      throw new core.ArgumentError(
          "Parameter instanceGroupManager is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/instanceGroupManagers/' +
        commons.Escaper.ecapeVariable('$instanceGroupManager');

    var _response = _requester.request(_url, "PATCH",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Flags the specified instances in the managed instance group to be
  /// immediately recreated. The instances are deleted and recreated using the
  /// current instance template for the managed instance group. This operation
  /// is marked as DONE when the flag is set even if the instances have not yet
  /// been recreated. You must separately verify the status of the recreating
  /// action with the listmanagedinstances method.
  ///
  /// If the group is part of a backend service that has enabled connection
  /// draining, it can take up to 60 seconds after the connection draining
  /// duration has elapsed before the VM instance is removed or deleted.
  ///
  /// You can specify a maximum of 1000 instances with this method per request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  ///
  /// [instanceGroupManager] - Name of the managed instance group.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> recreateInstances(
      RegionInstanceGroupManagersRecreateRequest request,
      core.String project,
      core.String region,
      core.String instanceGroupManager,
      {core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (instanceGroupManager == null) {
      throw new core.ArgumentError(
          "Parameter instanceGroupManager is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/instanceGroupManagers/' +
        commons.Escaper.ecapeVariable('$instanceGroupManager') +
        '/recreateInstances';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Changes the intended size of the managed instance group. If you increase
  /// the size, the group creates new instances using the current instance
  /// template. If you decrease the size, the group deletes one or more
  /// instances.
  ///
  /// The resize operation is marked DONE if the resize request is successful.
  /// The underlying actions take additional time. You must separately verify
  /// the status of the creating or deleting actions with the
  /// listmanagedinstances method.
  ///
  /// If the group is part of a backend service that has enabled connection
  /// draining, it can take up to 60 seconds after the connection draining
  /// duration has elapsed before the VM instance is removed or deleted.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  ///
  /// [instanceGroupManager] - Name of the managed instance group.
  ///
  /// [size] - Number of instances that should exist in this instance group
  /// manager.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> resize(core.String project, core.String region,
      core.String instanceGroupManager, core.int size,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (instanceGroupManager == null) {
      throw new core.ArgumentError(
          "Parameter instanceGroupManager is required.");
    }
    if (size == null) {
      throw new core.ArgumentError("Parameter size is required.");
    }
    _queryParams["size"] = ["${size}"];
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/instanceGroupManagers/' +
        commons.Escaper.ecapeVariable('$instanceGroupManager') +
        '/resize';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Sets the instance template to use when creating new instances or
  /// recreating instances in this group. Existing instances are not affected.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  ///
  /// [instanceGroupManager] - The name of the managed instance group.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setInstanceTemplate(
      RegionInstanceGroupManagersSetTemplateRequest request,
      core.String project,
      core.String region,
      core.String instanceGroupManager,
      {core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (instanceGroupManager == null) {
      throw new core.ArgumentError(
          "Parameter instanceGroupManager is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/instanceGroupManagers/' +
        commons.Escaper.ecapeVariable('$instanceGroupManager') +
        '/setInstanceTemplate';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Modifies the target pools to which all new instances in this group are
  /// assigned. Existing instances in the group are not affected.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  ///
  /// [instanceGroupManager] - Name of the managed instance group.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setTargetPools(
      RegionInstanceGroupManagersSetTargetPoolsRequest request,
      core.String project,
      core.String region,
      core.String instanceGroupManager,
      {core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (instanceGroupManager == null) {
      throw new core.ArgumentError(
          "Parameter instanceGroupManager is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/instanceGroupManagers/' +
        commons.Escaper.ecapeVariable('$instanceGroupManager') +
        '/setTargetPools';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }
}

class RegionInstanceGroupsResourceApi {
  final commons.ApiRequester _requester;

  RegionInstanceGroupsResourceApi(commons.ApiRequester client)
      : _requester = client;

  /// Returns the specified instance group resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  ///
  /// [instanceGroup] - Name of the instance group resource to return.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceGroup].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceGroup> get(
      core.String project, core.String region, core.String instanceGroup,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (instanceGroup == null) {
      throw new core.ArgumentError("Parameter instanceGroup is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/instanceGroups/' +
        commons.Escaper.ecapeVariable('$instanceGroup');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new InstanceGroup.fromJson(data));
  }

  /// Retrieves the list of instance group resources contained within the
  /// specified region.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [RegionInstanceGroupList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<RegionInstanceGroupList> list(
      core.String project, core.String region,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/instanceGroups';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new RegionInstanceGroupList.fromJson(data));
  }

  /// Lists the instances in the specified instance group and displays
  /// information about the named ports. Depending on the specified options,
  /// this method can list all instances or only the instances that are running.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  ///
  /// [instanceGroup] - Name of the regional instance group for which we want to
  /// list the instances.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [RegionInstanceGroupsListInstances].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<RegionInstanceGroupsListInstances> listInstances(
      RegionInstanceGroupsListInstancesRequest request,
      core.String project,
      core.String region,
      core.String instanceGroup,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (instanceGroup == null) {
      throw new core.ArgumentError("Parameter instanceGroup is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/instanceGroups/' +
        commons.Escaper.ecapeVariable('$instanceGroup') +
        '/listInstances';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response
        .then((data) => new RegionInstanceGroupsListInstances.fromJson(data));
  }

  /// Sets the named ports for the specified regional instance group.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region scoping this request.
  ///
  /// [instanceGroup] - The name of the regional instance group where the named
  /// ports are updated.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setNamedPorts(
      RegionInstanceGroupsSetNamedPortsRequest request,
      core.String project,
      core.String region,
      core.String instanceGroup,
      {core.String requestId,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (instanceGroup == null) {
      throw new core.ArgumentError("Parameter instanceGroup is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/instanceGroups/' +
        commons.Escaper.ecapeVariable('$instanceGroup') +
        '/setNamedPorts';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }
}

class RegionOperationsResourceApi {
  final commons.ApiRequester _requester;

  RegionOperationsResourceApi(commons.ApiRequester client)
      : _requester = client;

  /// Deletes the specified region-specific Operations resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [operation] - Name of the Operations resource to delete.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future delete(
      core.String project, core.String region, core.String operation,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (operation == null) {
      throw new core.ArgumentError("Parameter operation is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _downloadOptions = null;

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/operations/' +
        commons.Escaper.ecapeVariable('$operation');

    var _response = _requester.request(_url, "DELETE",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => null);
  }

  /// Retrieves the specified region-specific Operations resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [operation] - Name of the Operations resource to return.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> get(
      core.String project, core.String region, core.String operation,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (operation == null) {
      throw new core.ArgumentError("Parameter operation is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/operations/' +
        commons.Escaper.ecapeVariable('$operation');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves a list of Operation resources contained within the specified
  /// region.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OperationList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OperationList> list(core.String project, core.String region,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region') +
        '/operations';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new OperationList.fromJson(data));
  }
}

class RegionsResourceApi {
  final commons.ApiRequester _requester;

  RegionsResourceApi(commons.ApiRequester client) : _requester = client;

  /// Returns the specified Region resource. Gets a list of available regions by
  /// making a list() request.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [region] - Name of the region resource to return.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Region].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Region> get(core.String project, core.String region,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (region == null) {
      throw new core.ArgumentError("Parameter region is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/regions/' +
        commons.Escaper.ecapeVariable('$region');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Region.fromJson(data));
  }

  /// Retrieves the list of region resources available to the specified project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [RegionList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<RegionList> list(core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') + '/regions';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new RegionList.fromJson(data));
  }
}

class ReservationsResourceApi {
  final commons.ApiRequester _requester;

  ReservationsResourceApi(commons.ApiRequester client) : _requester = client;

  /// Retrieves an aggregated list of reservations.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ReservationAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ReservationAggregatedList> aggregatedList(core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url =
        commons.Escaper.ecapeVariable('$project') + '/aggregated/reservations';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response
        .then((data) => new ReservationAggregatedList.fromJson(data));
  }

  /// Deletes the specified reservation.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - Name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [reservation] - Name of the reservation to delete.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
      core.String project, core.String zone, core.String reservation,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (reservation == null) {
      throw new core.ArgumentError("Parameter reservation is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/reservations/' +
        commons.Escaper.ecapeVariable('$reservation');

    var _response = _requester.request(_url, "DELETE",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Retrieves all information of the specified reservation.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - Name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [reservation] - Name of the reservation to retrieve.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Reservation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Reservation> get(
      core.String project, core.String zone, core.String reservation,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (reservation == null) {
      throw new core.ArgumentError("Parameter reservation is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/reservations/' +
        commons.Escaper.ecapeVariable('$reservation');

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Reservation.fromJson(data));
  }

  /// Gets the access control policy for a resource. May be empty if no such
  /// policy or resource exists.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> getIamPolicy(
      core.String project, core.String zone, core.String resource,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (resource == null) {
      throw new core.ArgumentError("Parameter resource is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/reservations/' +
        commons.Escaper.ecapeVariable('$resource') +
        '/getIamPolicy';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Policy.fromJson(data));
  }

  /// Creates a new reservation. For more information, read Reserving zonal
  /// resources.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - Name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
      Reservation request, core.String project, core.String zone,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/reservations';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// A list all the reservations that have been configured for the specified
  /// project in specified zone.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - Name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ReservationList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ReservationList> list(core.String project, core.String zone,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (filter != null) {
      _queryParams["filter"] = [filter];
    }
    if (maxResults != null) {
      _queryParams["maxResults"] = ["${maxResults}"];
    }
    if (orderBy != null) {
      _queryParams["orderBy"] = [orderBy];
    }
    if (pageToken != null) {
      _queryParams["pageToken"] = [pageToken];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/reservations';

    var _response = _requester.request(_url, "GET",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new ReservationList.fromJson(data));
  }

  /// Resizes the reservation (applicable to standalone reservations only)
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - Name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [reservation] - Name of the reservation to update.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed.
  ///
  /// For example, consider a situation where you make an initial request and
  /// the request times out. If you make the request again with the same request
  /// ID, the server can check if original operation with the same request ID
  /// was received, and if so, will ignore the second request. This prevents
  /// clients from accidentally creating duplicate commitments.
  ///
  /// The request ID must be a valid UUID with the exception that zero UUID is
  /// not supported (00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> resize(ReservationsResizeRequest request,
      core.String project, core.String zone, core.String reservation,
      {core.String requestId, core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (reservation == null) {
      throw new core.ArgumentError("Parameter reservation is required.");
    }
    if (requestId != null) {
      _queryParams["requestId"] = [requestId];
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/reservations/' +
        commons.Escaper.ecapeVariable('$reservation') +
        '/resize';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Operation.fromJson(data));
  }

  /// Sets the access control policy on the specified resource. Replaces any
  /// existing policy.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> setIamPolicy(ZoneSetPolicyRequest request,
      core.String project, core.String zone, core.String resource,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (resource == null) {
      throw new core.ArgumentError("Parameter resource is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/reservations/' +
        commons.Escaper.ecapeVariable('$resource') +
        '/setIamPolicy';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new Policy.fromJson(data));
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?".
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [TestPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<TestPermissionsResponse> testIamPermissions(
      TestPermissionsRequest request,
      core.String project,
      core.String zone,
      core.String resource,
      {core.String $fields}) {
    var _url;
    var _queryParams = new core.Map<core.String, core.List<core.String>>();
    var _uploadMedia;
    var _uploadOptions;
    var _downloadOptions = commons.DownloadOptions.Metadata;
    var _body;

    if (request != null) {
      _body = convert.json.encode((request).toJson());
    }
    if (project == null) {
      throw new core.ArgumentError("Parameter project is required.");
    }
    if (zone == null) {
      throw new core.ArgumentError("Parameter zone is required.");
    }
    if (resource == null) {
      throw new core.ArgumentError("Parameter resource is required.");
    }
    if ($fields != null) {
      _queryParams["fields"] = [$fields];
    }

    _url = commons.Escaper.ecapeVariable('$project') +
        '/zones/' +
        commons.Escaper.ecapeVariable('$zone') +
        '/reservations/' +
        commons.Escaper.ecapeVariable('$resource') +
        '/testIamPermissions';

    var _response = _requester.request(_url, "POST",
        body: _body,
        queryParams: _queryParams,
        uploadOptions: _uploadOptions,
        uploadMedia: _uploadMedia,
        downloadOptions: _downloadOptions);
    return _response.then((data) => new TestPermissionsResponse.fromJson(data));
  }
}

class ResourcePoliciesResourceApi {
  final commons.ApiRequester _requester;

  ResourcePoliciesResourceApi(commons.ApiRequester client)
      : _requester = client;

  /// Retrieves an aggregated list of resource policies.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// "(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))".
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. The expression must specify the field name, a comparison
  /// operator, and the value that you want to use for filtering. The value must
  /// be a string, a number, or a boolean. The comparison operator must be
  /// either =, !=, >, or <.
  ///
  /// For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named example-instance by specifying name !=
  /// example-instance.
  ///
  /// You can also filter nested fields. For example, you could specify
  /// scheduling.automaticRestart = false to include instances only if they are
  /// not scheduled for automatic restarts. You can use filtering on nested
  /// fields to filter based on resource labels.
  ///
  /// To filter on multiple expressions, provide each separate expression within
  /// parentheses. For example, (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake"). By default, each expression is an AND
  /// expression. However, you can include AND and OR expressions explicitly.
  /// For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
  /// Broadwell") AND (scheduling.automaticRestart = true).
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than maxResults,
  /// Compute Engine returns a nextPageToken that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are 0 to
  /// 500, inclusive. (Default: 500)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name.
  ///
  /// You can also sort results in descending order based on the creation
  /// timestamp using orderBy="creationTimestamp desc". This sorts results based
  /// on the creationTimestamp field in reverse chronological order (newest
  /// result first). Use this to sort resources like operations so that the
  /// newest operation is returned first.
  ///
  /// Currently, only sorting by name or creationTimestamp desc is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set pageToken to the
  /// nextPageToken returned by a previous list request to get the next page of
  /// results.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ResourcePolicyAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ResourcePolicyAggregatedList> aggregatedList(core.String project,
      {core.String filter,
      core.int maxResults,
      core.String orderBy,
      core.String pageToken,
      core.String $fields}) {
    var _url;
    var _queryParams = new core